<?php
public function getPairsByRole($role)
{
    return $this->loadExtension('cmmi')->getPairsByRole($role);
}

/**
 * Get all members for project/execution.
 *
 * @param int $objectID
 * @access public
 * @return array
 */
public function getAllMembers($objectID)
{
    if(defined('TUTORIAL')) return $this->loadModel('tutorial')->getTeamMembersPairs();

    $users = $this->dao->select("t2.id, t2.account, t2.realname")->from(TABLE_TEAM)->alias('t1')
        ->leftJoin(TABLE_USER)->alias('t2')->on('t1.account = t2.account')
        ->leftJoin(TABLE_STAKEHOLDER)->alias('t3')->on("t3.user = t2.account")
        ->leftJoin(TABLE_ACL)->alias('t4')->on("t4.account = t2.account and t4.type = 'whitelist'")
        ->where('t2.deleted')->eq(0)
        ->andwhere('t1.type', true)->in('project,execution')
        ->andWhere('t1.root')->eq((int)$objectID)
        ->markRight(1)
        ->orwhere('( t3.objectID')->eq((int)$objectID)
        ->orwhere('t4.objectID')->eq((int)$objectID)
        ->markRight(1)
        ->fetchAll('account');

    if(!$users) return array('' => '');

    foreach($users as $account => $user)
    {
        $firstLetter = ucfirst(substr($user->account, 0, 1)) . ':';
        if(!empty($this->config->isINT)) $firstLetter = '';
        $users[$account] =  $firstLetter . ($user->realname ? $user->realname : $user->account);
    }
    return array('' => '') + $users;
}
