<?php
/**
 * The browse view file of account module of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2015 青岛易软天创网络科技有限公司(QingDao Nature Easy Soft Network Technology Co,LTD, www.cnezsoft.com)
 * @license     ZPL (http://zpl.pub/page/zplv12.html)
 * @author      pengjiangxiu <pengjiangxiu@cnezsoft.com>
 * @package     account
 * @version     $Id$
 * @link        http://www.zentao.net
 */
?>
<?php include '../../common/view/header.html.php';?>
<?php js::set('browseType', $browseType)?>
<div id='mainMenu' class='clearfix'>
  <div class='pull-left btn-toolbar'>
    <?php echo html::a(inlink('browse'), "<span class='text'>{$lang->account->all}</span>", '', "class='btn btn-link btn-active-text' id='allTab'")?>
    <a href='#' class='btn btn-link querybox-toggle' id='bysearchTab'><i class='icon-search icon'></i> <?php echo $lang->account->search;?></a>
  </div>
  <?php if(common::hasPriv('account', 'create')):?>
  <div class="btn-toolbar pull-right" id='createActionMenu'>
    <?php
    $misc = "class='btn btn-primary'";
    echo html::a(inLink('create'), "<i class='icon icon-plus'></i>" . $lang->account->create, '', "class='btn btn-primary' data-toggle='modal'");
    ?>
  </div>
  <?php endif;?>
</div>
<div id='queryBox' class='cell <?php if($browseType =='bysearch') echo 'show';?>' data-module='account'></div>

<div id='mainContent' class='main-row'>
  <div class='main-col main-table' id='accountList'>
    <table class='table has-sort-head table-fixed'>
      <thead>
        <tr>
          <?php $vars = "browseType=$browseType&param=$param&orderBy=%s&recTotal={$pager->recTotal}&recPerPage={$pager->recPerPage}";?>
          <th class='w-60px'>   <?php common::printOrderLink('id',         $orderBy, $vars, $lang->idAB);?></th>
          <th class='text-left'><?php common::printOrderLink('name',       $orderBy, $vars, $lang->account->name);?></th>
          <th class='w-100px'>  <?php common::printOrderLink('provider',   $orderBy, $vars, $lang->account->provider);?></th>
          <th class='text-left'><?php common::printOrderLink('account',    $orderBy, $vars, $lang->account->account);?></th>
          <th class='w-110px'>  <?php common::printOrderLink('email',  $orderBy, $vars, $lang->account->email);?></th>
          <th class='w-110px'>  <?php common::printOrderLink('mobile',   $orderBy, $vars, $lang->account->mobile);?></th>
          <th class='w-100px'>  <?php common::printOrderLink('createdBy',  $orderBy, $vars, $lang->account->createdBy);?></th>
          <th class='w-120px'>  <?php echo $lang->actions?></th>
        </tr>
      </thead>
      <?php if(!empty($accountList)):?>
      <tbody>
        <?php foreach($accountList as $account):?>
        <tr class='text-left'>
          <td><?php printf('%03d', $account->id);?></td>
          <td title='<?php echo $account->name?>'><?php echo html::a($this->inlink('view', "id=$account->id", 'html', true), $account->name, '', "class='iframe'");?></td>
          <td><?php echo zget($lang->serverroom->providerList, $account->provider);?></td>
          <td><?php echo $account->account;?></td>
          <td><?php echo $account->email;?></td>
          <td><?php echo $account->mobile;?></td>
          <td><?php echo $account->createdBy;?></td>
          <td class='c-actions'>
            <?php
            common::printIcon('account','edit',"id=$account->id", $account, '', 'edit');
            if(common::hasPriv('account', 'delete', $account))
            {
                $deleteURL = $this->createLink('account', 'delete', "id=$account->id&confirm=yes");
                echo html::a("javascript:ajaxDelete(\"$deleteURL\",\"accountList\",confirmDelete)", '<i class="icon-trash"></i>', '', "class='btn' title='{$lang->delete}'");
            }
            ?>
          </td>
        </tr>
        <?php endforeach;?>
      </tbody>
      <?php endif;?>
    </table>
    <?php if(!empty($accountList)):?>
    <div class='table-footer'><?php $pager->show('right', 'pagerjs');?></div>
    <?php endif;?>
  </div>
</div>
<script>
$(function()
{
    <?php if($browseType == 'bymodule'):?>
    $('#module<?php echo $param?>').closest('li').addClass('active');
    <?php endif;?>
    if(browseType == 'bysearch') $.toggleQueryBox(true);
})
</script>
<?php include '../../common/view/footer.html.php';?>
