-- DROP TABLE IF EXISTS `zt_searchindex`;
CREATE TABLE IF NOT EXISTS `zt_searchindex` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `objectType` char(20) NOT NULL,
  `objectID` mediumint(9) NOT NULL,
  `title` text NOT NULL,
  `content` text NOT NULL,
  `addedDate` datetime NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`objectType`,`objectID`),
  KEY `addedDate` (`addedDate`),
  FULLTEXT KEY `content` (`content`),
  FULLTEXT KEY `title` (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_searchdict`;
CREATE TABLE IF NOT EXISTS `zt_searchdict` (
  `key` smallint(5) unsigned NOT NULL,
  `value` char(3) NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_acl`;
CREATE TABLE IF NOT EXISTS `zt_acl` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `objectType` char(30) NOT NULL,
  `objectID` mediumint(9) NOT NULL DEFAULT '0',
  `type` char(40) NOT NULL DEFAULT 'whitelist',
  `source` char(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_action`;
CREATE TABLE IF NOT EXISTS `zt_action` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `objectType` varchar(30) NOT NULL default '',
  `objectID` mediumint(8) unsigned NOT NULL default '0',
  `product` varchar(255) NOT NULL,
  `project` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `actor` varchar(100) NOT NULL default '',
  `action` varchar(30) NOT NULL default '',
  `date` datetime NOT NULL,
  `comment` text NOT NULL,
  `extra` text NOT NULL,
  `read` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `date` (`date`),
  KEY `actor` (`actor`),
  KEY `project` (`project`),
  KEY `action` (`action`),
  KEY `objectID` (`objectID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_block`;
CREATE TABLE IF NOT EXISTS `zt_block` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `module` varchar(20) NOT NULL,
  `type` char(30) NOT NULL,
  `title` varchar(100) NOT NULL,
  `source` varchar(20) NOT NULL,
  `block` varchar(20) NOT NULL,
  `params` text NOT NULL,
  `order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `grid` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `height` smallint(5) unsigned NOT NULL DEFAULT '0',
  `hidden` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `account_module_type_order` (`account`,`module`,`type`,`order`),
  KEY `account` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_branch`;
CREATE TABLE IF NOT EXISTS `zt_branch` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `order` smallint unsigned NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY  (`id`),
  KEY `product` (`product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_bug`;
CREATE TABLE IF NOT EXISTS `zt_bug` (
  `id` mediumint(8) NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `execution` mediumint(8) unsigned NOT NULL default '0',
  `plan` mediumint(8) unsigned NOT NULL default '0',
  `story` mediumint(8) unsigned NOT NULL default '0',
  `storyVersion` smallint(6) NOT NULL default '1',
  `task` mediumint(8) unsigned NOT NULL default '0',
  `toTask` mediumint(8) unsigned NOT NULL default '0',
  `toStory` mediumint(8) NOT NULL default '0',
  `title` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `severity` tinyint(4) NOT NULL default '0',
  `pri` tinyint(3) unsigned NOT NULL,
  `type` varchar(30) NOT NULL default '',
  `os` varchar(30) NOT NULL default '',
  `browser` varchar(30) NOT NULL default '',
  `hardware` varchar(30) NOT NULL,
  `found` varchar(30) NOT NULL default '',
  `steps` text NOT NULL,
  `status` enum('active','resolved','closed') NOT NULL default 'active',
  `subStatus` varchar(30) NOT NULL default '',
  `color` char(7) NOT NULL,
  `confirmed` tinyint(1) NOT NULL default '0',
  `activatedCount` smallint(6) NOT NULL,
  `activatedDate` datetime NOT NULL,
  `mailto` text,
  `openedBy` varchar(30) NOT NULL default '',
  `openedDate` datetime NOT NULL,
  `openedBuild` varchar(255) NOT NULL,
  `assignedTo` varchar(30) NOT NULL default '',
  `assignedDate` datetime NOT NULL,
  `deadline` date NOT NULL,
  `resolvedBy` varchar(30) NOT NULL default '',
  `resolution` varchar(30) NOT NULL default '',
  `resolvedBuild` varchar(30) NOT NULL default '',
  `resolvedDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL default '',
  `closedDate` datetime NOT NULL,
  `duplicateBug` mediumint(8) unsigned NOT NULL,
  `linkBug` varchar(255) NOT NULL,
  `case` mediumint(8) unsigned NOT NULL,
  `caseVersion` smallint(6) NOT NULL DEFAULT '1',
  `result` mediumint(8) unsigned NOT NULL,
  `repo` mediumint(8) unsigned NOT NULL,
  `entry` varchar(255) NOT NULL,
  `lines` varchar(10) NOT NULL,
  `v1` varchar(40) NOT NULL,
  `v2` varchar(40) NOT NULL,
  `repoType` varchar(30) NOT NULL DEFAULT '',
  `testtask` mediumint(8) unsigned NOT NULL,
  `lastEditedBy` varchar(30) NOT NULL default '',
  `lastEditedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`),
  KEY `status` (`status`),
  KEY `plan` (`plan`),
  KEY `story` (`story`),
  KEY `case` (`case`),
  KEY `toStory` (`toStory`),
  KEY `result` (`result`),
  KEY `assignedTo` (`assignedTo`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_build`;
CREATE TABLE IF NOT EXISTS `zt_build` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `execution` mediumint(8) unsigned NOT NULL default '0',
  `name` char(150) NOT NULL,
  `scmPath` char(255) NOT NULL,
  `filePath` char(255) NOT NULL,
  `date` date NOT NULL,
  `stories` text NOT NULL,
  `bugs` text NOT NULL,
  `builder` char(30) NOT NULL default '',
  `desc` text NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_burn`;
CREATE TABLE IF NOT EXISTS `zt_burn` (
  `execution` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `task` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `date` date NOT NULL,
  `estimate` float NOT NULL,
  `left` float NOT NULL,
  `consumed` float NOT NULL,
  `storyPoint` float NOT NULL,
  PRIMARY KEY  (`execution`,`date`,`task`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_case`;
CREATE TABLE IF NOT EXISTS `zt_case` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `execution` mediumint(8) unsigned NOT NULL,
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `lib` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `path` mediumint(8) unsigned NOT NULL default '0',
  `story` mediumint(30) unsigned NOT NULL default '0',
  `storyVersion` smallint(6) NOT NULL default '1',
  `title` varchar(255) NOT NULL,
  `precondition` text NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `pri` tinyint(3) unsigned NOT NULL default '3',
  `type` char(30) NOT NULL default '1',
  `auto` varchar(10) NOT NULL default 'no',
  `frame` varchar(10) NOT NULL,
  `stage` varchar(255) NOT NULL,
  `howRun` varchar(30) NOT NULL,
  `scriptedBy` varchar(30) NOT NULL,
  `scriptedDate` date NOT NULL,
  `scriptStatus` varchar(30) NOT NULL,
  `scriptLocation` varchar(255) NOT NULL,
  `status` char(30) NOT NULL default '1',
  `subStatus` varchar(30) NOT NULL default '',
  `color` char(7) NOT NULL,
  `frequency` enum('1','2','3') NOT NULL default '1',
  `order` tinyint(30) unsigned NOT NULL default '0',
  `openedBy` char(30) NOT NULL default '',
  `openedDate` datetime NOT NULL,
  `reviewedBy` varchar(255) NOT NULL,
  `reviewedDate` date NOT NULL,
  `lastEditedBy` char(30) NOT NULL default '',
  `lastEditedDate` datetime NOT NULL,
  `version` tinyint(3) unsigned NOT NULL default '0',
  `linkCase` varchar(255) NOT NULL,
  `fromBug` mediumint(8) unsigned NOT NULL,
  `fromCaseID` mediumint(8) unsigned NOT NULL,
  `fromCaseVersion` mediumint(8) unsigned NOT NULL default '1',
  `deleted` enum('0','1') NOT NULL default '0',
  `lastRunner` varchar(30) NOT NULL,
  `lastRunDate` datetime NOT NULL,
  `lastRunResult` char(30) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `story` (`story`),
  KEY `fromBug` (`fromBug`),
  KEY `module` (`module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_casestep`;
CREATE TABLE IF NOT EXISTS `zt_casestep` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `case` mediumint(8) unsigned NOT NULL default '0',
  `version` smallint(3) unsigned NOT NULL default '0',
  `type` varchar(10) NOT NULL DEFAULT 'step',
  `desc` text NOT NULL,
  `expect` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `case` (`case`),
  KEY `version` (`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_company`;
CREATE TABLE IF NOT EXISTS `zt_company` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` char(120) default NULL,
  `phone` char(20) default NULL,
  `fax` char(20) default NULL,
  `address` char(120) default NULL,
  `zipcode` char(10) default NULL,
  `website` char(120) default NULL,
  `backyard` char(120) default NULL,
  `guest` enum('1','0') NOT NULL default '0',
  `admins` char(255) default NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_compile`;
CREATE TABLE IF NOT EXISTS `zt_compile` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `job` mediumint(8) unsigned NOT NULL,
  `queue` mediumint(8) NOT NULL,
  `status` varchar(255) NOT NULL,
  `logs` text,
  `atTime` varchar(10) NOT NULL,
  `testtask` mediumint(8) unsigned NOT NULL,
  `tag` varchar(255) NOT NULL,
  `times` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `updateDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_config`;
CREATE TABLE IF NOT EXISTS `zt_config` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `owner` char(30) NOT NULL default '',
  `module` varchar(30) NOT NULL,
  `section` char(30) NOT NULL default '',
  `key` char(30) NOT NULL default '',
  `value` longtext NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `unique` (`owner`,`module`,`section`,`key`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_cron`;
CREATE TABLE IF NOT EXISTS `zt_cron` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `m` varchar(20) NOT NULL,
  `h` varchar(20) NOT NULL,
  `dom` varchar(20) NOT NULL,
  `mon` varchar(20) NOT NULL,
  `dow` varchar(20) NOT NULL,
  `command` text NOT NULL,
  `remark` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `buildin` tinyint(1) NOT NULL DEFAULT '0',
  `status` varchar(20) NOT NULL,
  `lastTime` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `lastTime` (`lastTime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_lang`;
CREATE TABLE IF NOT EXISTS `zt_lang` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `lang` varchar(30) NOT NULL,
  `module` varchar(30) NOT NULL,
  `section` varchar(30) NOT NULL,
  `key` varchar(60) NOT NULL,
  `value` text NOT NULL,
  `system` enum('0','1') NOT NULL default '1',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `lang` (`lang`,`module`,`section`,`key`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_dept`;
CREATE TABLE IF NOT EXISTS `zt_dept` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` char(60) NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `path` char(255) NOT NULL default '',
  `grade` tinyint(3) unsigned NOT NULL default '0',
  `order` smallint(4) unsigned NOT NULL default '0',
  `position` char(30) NOT NULL default '',
  `function` char(255) NOT NULL default '',
  `manager` char(30) NOT NULL default '',
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `path` (`path`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_doc`;
CREATE TABLE IF NOT EXISTS `zt_doc` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `lib` varchar(30) NOT NULL,
  `module` varchar(30) NOT NULL,
  `title` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `type` varchar(30) NOT NULL,
  `views` smallint(5) unsigned NOT NULL,
  `collector` text NOT NULL,
  `addedBy` varchar(30) NOT NULL,
  `addedDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `mailto` text,
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `groups` varchar(255) NOT NULL,
  `users` text NOT NULL,
  `version` smallint(5) unsigned NOT NULL DEFAULT '1',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`),
  KEY `lib` (`lib`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_doccontent`;
CREATE TABLE IF NOT EXISTS `zt_doccontent` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `doc` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `digest` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `files` text NOT NULL,
  `type` varchar(10) NOT NULL,
  `version` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `doc_version` (`doc`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_doclib`;
CREATE TABLE IF NOT EXISTS `zt_doclib` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `type` varchar(30) NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `project` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `name` varchar(60) NOT NULL,
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `groups` varchar(255) NOT NULL,
  `users` text NOT NULL,
  `main` enum('0','1') NOT NULL default '0',
  `collector` text NOT NULL,
  `order` tinyint(5) unsigned NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_effort`;
CREATE TABLE IF NOT EXISTS `zt_effort` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `user` char(30) NOT NULL default '',
  `todo` enum('1','0') NOT NULL default '1',
  `date` date NOT NULL,
  `begin` datetime NOT NULL default '0000-00-00 00:00:00',
  `end` datetime NOT NULL default '0000-00-00 00:00:00',
  `type` enum('1','2','3') NOT NULL default '1',
  `idvalue` mediumint(8) unsigned NOT NULL default '0',
  `name` char(30) NOT NULL default '',
  `desc` char(255) NOT NULL default '',
  `status` enum('1','2','3') NOT NULL default '1',
  PRIMARY KEY  (`id`),
  KEY `user` (`user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_extension`;
CREATE TABLE IF NOT EXISTS `zt_extension` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` varchar(150) NOT NULL,
  `code` varchar(30) NOT NULL,
  `version` varchar(50) NOT NULL,
  `author` varchar(100) NOT NULL,
  `desc` text NOT NULL,
  `license` text NOT NULL,
  `type` varchar(20) NOT NULL default 'extension',
  `site` varchar(150) NOT NULL,
  `zentaoCompatible` varchar(100) NOT NULL,
  `installedTime` datetime NOT NULL,
  `depends` varchar(100) NOT NULL,
  `dirs` mediumtext NOT NULL,
  `files` mediumtext NOT NULL,
  `status` varchar(20) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `name` (`name`),
  KEY `installedTime` (`installedTime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_file`;
CREATE TABLE IF NOT EXISTS `zt_file` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `pathname` char(50) NOT NULL,
  `title` char(255) NOT NULL,
  `extension` char(30) NOT NULL,
  `size` int(10) unsigned NOT NULL default '0',
  `objectType` char(30) NOT NULL,
  `objectID` mediumint(9) NOT NULL,
  `addedBy` char(30) NOT NULL default '',
  `addedDate` datetime NOT NULL,
  `downloads` mediumint(8) unsigned NOT NULL default '0',
  `extra` varchar(255) NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `objectType` (`objectType`),
  KEY `objectID` (`objectID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_group`;
CREATE TABLE IF NOT EXISTS `zt_group` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` char(30) NOT NULL,
  `role` char(30) NOT NULL default '',
  `desc` char(255) NOT NULL default '',
  `acl` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_grouppriv`;
CREATE TABLE IF NOT EXISTS `zt_grouppriv` (
  `group` mediumint(8) unsigned NOT NULL default '0',
  `module` char(30) NOT NULL default '',
  `method` char(30) NOT NULL default '',
  UNIQUE KEY `group` (`group`,`module`,`method`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_history`;
CREATE TABLE IF NOT EXISTS `zt_history` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `action` mediumint(8) unsigned NOT NULL default '0',
  `field` varchar(30) NOT NULL default '',
  `old` text NOT NULL,
  `new` text NOT NULL,
  `diff` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `action` (`action`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_jenkins`;
CREATE TABLE IF NOT EXISTS `zt_jenkins` (
  `id` smallint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `url` varchar(255) DEFAULT NULL,
  `account` varchar(30) DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `token` varchar(255) DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_job`;
CREATE TABLE IF NOT EXISTS `zt_job` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `repo` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `frame` varchar(20) NOT NULL,
  `jkHost` mediumint(8) unsigned NOT NULL,
  `jkJob` varchar(500) NOT NULL,
  `triggerType` varchar(255) NOT NULL,
  `svnDir` varchar(255) NOT NULL,
  `atDay` varchar(255) DEFAULT NULL,
  `atTime` varchar(10) DEFAULT NULL,
  `customParam` text NOT NULL,
  `comment` varchar(255) DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `lastExec` datetime DEFAULT NULL,
  `lastStatus` varchar(255) DEFAULT NULL,
  `lastTag` varchar(255) DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_module`;
CREATE TABLE IF NOT EXISTS `zt_module` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `root` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `name` char(60) NOT NULL default '',
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `path` char(255) NOT NULL default '',
  `grade` tinyint(3) unsigned NOT NULL default '0',
  `order` smallint(5) unsigned NOT NULL default '0',
  `type` char(30) NOT NULL,
  `owner` varchar(30) NOT NULL,
  `collector` text NOT NULL,
  `short` varchar(30) NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `root` (`root`),
  KEY `type` (`type`),
  KEY `path` (`path`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_notify`;
CREATE TABLE IF NOT EXISTS `zt_notify` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(50) NOT NULL,
  `objectID` mediumint unsigned NOT NULL,
  `action` mediumint NOT NULL,
  `toList` varchar(255) NOT NULL,
  `ccList` text NOT NULL,
  `subject` varchar(255) NOT NULL,
  `data` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `sendTime` datetime NOT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `failReason` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `objectType_toList_status` (`objectType`,`toList`,`status`)
) ENGINE='MyISAM' COLLATE 'utf8_general_ci';
-- DROP TABLE IF EXISTS `zt_oauth`;
CREATE TABLE IF NOT EXISTS `zt_oauth` (
  `account` varchar(30) NOT NULL,
  `openID` varchar(255) NOT NULL,
  `providerType` varchar(30) NOT NULL,
  `providerID` mediumint(8) unsigned NOT NULL,
  KEY `account` (`account`),
  KEY `providerType` (`providerType`),
  KEY `providerID` (`providerID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_planstory`;
CREATE TABLE IF NOT EXISTS `zt_planstory` (
  `plan` mediumint(8) unsigned NOT NULL,
  `story` mediumint(8) unsigned NOT NULL,
  `order` mediumint(9) NOT NULL,
  UNIQUE KEY `plan_story` (`plan`,`story`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_product`;
CREATE TABLE IF NOT EXISTS `zt_product` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `program` mediumint(8) unsigned NOT NULL,
  `name` varchar(90) NOT NULL,
  `code` varchar(45) NOT NULL,
  `bind` enum('0','1') NOT NULL DEFAULT '0',
  `line` mediumint(8) NOT NULL,
  `type` varchar(30) NOT NULL default 'normal',
  `status` varchar(30) NOT NULL default '',
  `subStatus` varchar(30) NOT NULL default '',
  `desc` text NOT NULL,
  `PO` varchar(30) NOT NULL,
  `QD` varchar(30) NOT NULL,
  `RD` varchar(30) NOT NULL,
  `storyConcept` smallint(5) NOT NULL,
  `acl` enum('open','private','custom') NOT NULL default 'open',
  `whitelist` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `createdVersion` varchar(20) NOT NULL,
  `order` mediumint(8) unsigned NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `acl` (`acl`),
  KEY `order` (`order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_productplan`;
CREATE TABLE IF NOT EXISTS `zt_productplan` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `product` mediumint(8) unsigned NOT NULL,
  `branch` mediumint(8) unsigned NOT NULL,
  `parent` mediumint(9) NOT NULL DEFAULT '0',
  `title` varchar(90) NOT NULL,
  `desc` text NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `order` text NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `end` (`end`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_project`;
CREATE TABLE IF NOT EXISTS `zt_project` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) NOT NULL DEFAULT 0,
  `model` char(30) NOT NULL,
  `type` char(30) NOT NULL DEFAULT 'sprint',
  `product` char(30) NOT NULL DEFAULT 'single',
  `lifetime` char(30) NOT NULL,
  `budget` varchar(30) NOT NULL DEFAULT '0',
  `budgetUnit` char(30) NOT NULL DEFAULT 'CNY',
  `attribute` varchar(30) NOT NULL DEFAULT '',
  `percent` float unsigned NOT NULL DEFAULT '0',
  `milestone` enum('0','1') NOT NULL DEFAULT '0',
  `output` text NOT NULL,
  `auth` char(30) NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL,
  `grade` tinyint(3) unsigned NOT NULL,
  `name` varchar(90) NOT NULL,
  `code` varchar(45) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `realBegan` date NOT NULL,
  `realEnd` date NOT NULL,
  `days` smallint(5) unsigned NOT NULL,
  `storyConcept` smallint(5) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `statge` enum('1','2','3','4','5') NOT NULL DEFAULT '1',
  `pri` enum('1','2','3','4') NOT NULL DEFAULT '1',
  `desc` text NOT NULL,
  `version` smallint(6) NOT NULL,
  `parentVersion` smallint(6) NOT NULL,
  `planDuration` int(11) NOT NULL,
  `realDuration` int(11) NOT NULL,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime NOT NULL,
  `openedVersion` varchar(20) NOT NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime NOT NULL,
  `canceledBy` varchar(30) NOT NULL DEFAULT '',
  `canceledDate` datetime NOT NULL,
  `PO` varchar(30) NOT NULL DEFAULT '',
  `PM` varchar(30) NOT NULL DEFAULT '',
  `QD` varchar(30) NOT NULL DEFAULT '',
  `RD` varchar(30) NOT NULL DEFAULT '',
  `team` varchar(90) NOT NULL,
  `acl` char(30) NOT NULL DEFAULT 'open',
  `whitelist` text NOT NULL,
  `order` mediumint(8) unsigned NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `begin` (`begin`),
  KEY `end` (`end`),
  KEY `status` (`status`),
  KEY `acl` (`acl`),
  KEY `order` (`order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_projectspec`;
CREATE TABLE IF NOT EXISTS `zt_projectspec` (
  `project` mediumint(8) NOT NULL,
  `version` smallint(6) NOT NULL,
  `name` varchar(255) NOT NULL,
  `milestone` enum('0','1') NOT NULL DEFAULT '0',
  `begin` date NOT NULL,
  `end` date NOT NULL,
  UNIQUE KEY `project` (`project`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_projectproduct`;
CREATE TABLE IF NOT EXISTS `zt_projectproduct` (
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `branch` mediumint(8) unsigned NOT NULL,
  `plan` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY  (`project`,`product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_projectstory`;
CREATE TABLE IF NOT EXISTS `zt_projectstory` (
  `project` mediumint(8) unsigned NOT NULL default '0',
  `product` mediumint(8) unsigned NOT NULL,
  `story` mediumint(8) unsigned NOT NULL default '0',
  `version` smallint(6) NOT NULL default '1',
  `order` smallint(6) unsigned NOT NULL,
  UNIQUE KEY `project` (`project`,`story`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_projectcase`;
CREATE TABLE `zt_projectcase` (
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `product` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `case` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `version` smallint(6) NOT NULL DEFAULT '1',
  `order` smallint(6) unsigned NOT NULL,
  UNIQUE KEY `project` (`project`,`case`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_release`;
CREATE TABLE IF NOT EXISTS `zt_release` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `build` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL default '',
  `marker` enum('0','1') NOT NULL default '0',
  `date` date NOT NULL,
  `stories` text NOT NULL,
  `bugs` text NOT NULL,
  `leftBugs` text NOT NULL,
  `desc` text NOT NULL,
  `status` varchar(20) NOT NULL default 'normal',
  `subStatus` varchar(30) NOT NULL default '',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `build` (`build`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_repo`;
CREATE TABLE IF NOT EXISTS `zt_repo` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `product` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `path` varchar(255) NOT NULL,
  `prefix` varchar(100) NOT NULL,
  `encoding` varchar(20) NOT NULL,
  `SCM` varchar(10) NOT NULL,
  `client` varchar(100) NOT NULL,
  `commits` mediumint(8) unsigned NOT NULL,
  `account` varchar(30) NOT NULL,
  `password` varchar(30) NOT NULL,
  `encrypt` varchar(30) NOT NULL DEFAULT 'plain',
  `acl` text NOT NULL,
  `synced` tinyint(1) NOT NULL DEFAULT '0',
  `lastSync` datetime NOT NULL,
  `desc` text NOT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_repobranch`;
CREATE TABLE IF NOT EXISTS `zt_repobranch` (
  `repo` mediumint(8) unsigned NOT NULL,
  `revision` mediumint(8) unsigned NOT NULL,
  `branch` varchar(255) NOT NULL,
  UNIQUE KEY `repo_revision_branch` (`repo`,`revision`,`branch`),
  KEY `branch` (`branch`),
  KEY `revision` (`revision`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_repofiles`;
CREATE TABLE IF NOT EXISTS `zt_repofiles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `repo` mediumint(8) unsigned NOT NULL,
  `revision` mediumint(8) unsigned NOT NULL,
  `path` varchar(255) NOT NULL,
  `parent` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `action` char(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `path` (`path`),
  KEY `parent` (`parent`),
  KEY `repo` (`repo`),
  KEY `revision` (`revision`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_repohistory`;
CREATE TABLE IF NOT EXISTS `zt_repohistory` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `repo` mediumint(9) NOT NULL,
  `revision` varchar(40) NOT NULL,
  `commit` mediumint(8) unsigned NOT NULL,
  `comment` text NOT NULL,
  `committer` varchar(100) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `repo` (`repo`),
  KEY `revision` (`revision`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_stakeholder`;
CREATE TABLE IF NOT EXISTS `zt_stakeholder` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `objectID` mediumint(8) NOT NULL,
  `objectType` char(30) NOT NULL,
  `user` char(30) NOT NULL,
  `type` char(30) NOT NULL,
  `key` enum('0','1') NOT NULL,
  `from` char(30) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_story`;
CREATE TABLE IF NOT EXISTS `zt_story` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `parent` mediumint(9) NOT NULL default '0',
  `product` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `plan` text,
  `source` varchar(20) NOT NULL,
  `sourceNote` varchar(255) NOT NULL,
  `fromBug` mediumint(8) unsigned NOT NULL default '0',
  `title` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `type` varchar(30) NOT NULL default 'story',
  `pri` tinyint(3) unsigned NOT NULL default '3',
  `estimate` float unsigned NOT NULL,
  `status` enum('','changed','active','draft','closed') NOT NULL default '',
  `subStatus` varchar(30) NOT NULL default '',
  `color` char(7) NOT NULL,
  `stage` enum('','wait','planned','projected','developing','developed','testing','tested','verified','released', 'closed') NOT NULL DEFAULT 'wait',
  `stagedBy` char(30) NOT NULL,
  `mailto` text,
  `openedBy` varchar(30) NOT NULL default '',
  `openedDate` datetime NOT NULL,
  `assignedTo` varchar(30) NOT NULL default '',
  `assignedDate` datetime NOT NULL,
  `lastEditedBy` varchar(30) NOT NULL default '',
  `lastEditedDate` datetime NOT NULL,
  `reviewedBy` varchar(255) NOT NULL,
  `reviewedDate` date NOT NULL,
  `closedBy` varchar(30) NOT NULL default '',
  `closedDate` datetime NOT NULL,
  `closedReason` varchar(30) NOT NULL,
  `toBug` mediumint(8) unsigned NOT NULL,
  `childStories` varchar(255) NOT NULL,
  `linkStories` varchar(255) NOT NULL,
  `duplicateStory` mediumint(8) unsigned NOT NULL,
  `version` smallint(6) NOT NULL default '1',
  `URChanged` enum('0','1') NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `product` (`product`),
  KEY `status` (`status`),
  KEY `assignedTo` (`assignedTo`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_storyspec`;
CREATE TABLE IF NOT EXISTS `zt_storyspec` (
  `story` mediumint(9) NOT NULL,
  `version` smallint(6) NOT NULL,
  `title` varchar(255) NOT NULL,
  `spec` text NOT NULL,
  `verify` text NOT NULL,
  UNIQUE KEY `story` (`story`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_storystage`;
CREATE TABLE IF NOT EXISTS `zt_storystage` (
  `story` mediumint(8) unsigned NOT NULL,
  `branch` mediumint(8) unsigned NOT NULL,
  `stage` varchar(50) NOT NULL,
  `stagedBy` char(30) NOT NULL,
  UNIQUE KEY `story_branch` (`story`,`branch`),
  KEY `story` (`story`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_suitecase`;
CREATE TABLE IF NOT EXISTS `zt_suitecase` (
  `suite` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `case` mediumint(8) unsigned NOT NULL,
  `version` smallint(5) unsigned NOT NULL,
  UNIQUE KEY `suitecase` (`suite`,`case`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_task`;
CREATE TABLE IF NOT EXISTS `zt_task` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL,
  `parent` mediumint(8) NOT NULL DEFAULT '0',
  `execution` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `design` mediumint(8) unsigned NOT NULL,
  `story` mediumint(8) unsigned NOT NULL default '0',
  `storyVersion` smallint(6) NOT NULL default '1',
  `designVersion` smallint(6) unsigned NOT NULL,
  `fromBug` mediumint(8) unsigned NOT NULL default '0',
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `pri` tinyint(3) unsigned NOT NULL default '0',
  `estimate` float unsigned NOT NULL,
  `consumed` float unsigned NOT NULL,
  `left` float unsigned NOT NULL,
  `deadline` date NOT NULL,
  `status` enum('wait','doing','done','pause','cancel','closed') NOT NULL default 'wait',
  `subStatus` varchar(30) NOT NULL default '',
  `color` char(7) NOT NULL,
  `mailto` text,
  `desc` text NOT NULL,
  `version` smallint(6) NOT NULL,
  `openedBy` varchar(30) NOT NULL,
  `openedDate` datetime NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `estStarted` date NOT NULL,
  `realStarted` datetime NOT NULL,
  `finishedBy` varchar(30) NOT NULL,
  `finishedDate` datetime NOT NULL,
  `finishedList` text NOT NULL,
  `canceledBy` varchar(30) NOT NULL,
  `canceledDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL,
  `closedDate` datetime NOT NULL,
  `planDuration` int(11) NOT NULL,
  `realDuration` int(11) NOT NULL,
  `closedReason` varchar(30) NOT NULL,
  `lastEditedBy` varchar(30) NOT NULL,
  `lastEditedDate` datetime NOT NULL,
  `activatedDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
   PRIMARY KEY (`id`),
  KEY `execution` (`execution`),
  KEY `story` (`story`),
  KEY `parent` (`parent`),
  KEY `assignedTo` (`assignedTo`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_taskspec`;
CREATE TABLE IF NOT EXISTS `zt_taskspec` (
  `task` mediumint(8) NOT NULL,
  `version` smallint(6) NOT NULL,
  `name` varchar(255) NOT NULL,
  `estStarted` date NOT NULL,
  `deadline` date NOT NULL,
  UNIQUE KEY `task` (`task`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_taskestimate`;
CREATE TABLE IF NOT EXISTS `zt_taskestimate` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `task` mediumint(8) unsigned NOT NULL default '0',
  `date` date NOT NULL,
  `left` float unsigned NOT NULL default '0',
  `consumed` float unsigned NOT NULL,
  `account` char(30) NOT NULL default '',
  `work` text,
  PRIMARY KEY (`id`),
  KEY `task` (`task`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_team`;
CREATE TABLE IF NOT EXISTS `zt_team` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `root` mediumint(8) unsigned NOT NULL default '0',
  `type` enum('project','task','execution') NOT NULL DEFAULT 'project',
  `account` char(30) NOT NULL default '',
  `role` char(30) NOT NULL default '',
  `limited` char(8) NOT NULL default 'no',
  `join` date NOT NULL default '0000-00-00',
  `days` smallint(5) unsigned NOT NULL,
  `hours` float(2,1) unsigned NOT NULL default '0',
  `estimate` DECIMAL(12,2) UNSIGNED NOT NULL DEFAULT '0',
  `consumed` DECIMAL(12,2) UNSIGNED NOT NULL DEFAULT '0',
  `left` DECIMAL(12,2) UNSIGNED NOT NULL DEFAULT '0',
  `order` TINYINT(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `team` (`root`,`type`,`account`)
  ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testreport`;
CREATE TABLE IF NOT EXISTS `zt_testreport` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `tasks` varchar(255) NOT NULL,
  `builds` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `owner` char(30) NOT NULL,
  `members` text NOT NULL,
  `stories` text NOT NULL,
  `bugs` text NOT NULL,
  `cases` text NOT NULL,
  `report` text NOT NULL,
  `objectType` varchar(20) NOT NULL,
  `objectID` mediumint(8) unsigned NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testresult`;
CREATE TABLE IF NOT EXISTS `zt_testresult` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `run` mediumint(8) unsigned NOT NULL,
  `case` mediumint(8) unsigned NOT NULL,
  `version` smallint(5) unsigned NOT NULL,
  `job` mediumint(8) unsigned NOT NULL,
  `compile` mediumint(8) unsigned NOT NULL,
  `caseResult` char(30) NOT NULL,
  `stepResults` text NOT NULL,
  `lastRunner` varchar(30) NOT NULL,
  `date` datetime NOT NULL,
  `duration` float NOT NULL,
  `xml` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `case` (`case`),
  KEY `version` (`version`),
  KEY `run` (`run`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testrun`;
CREATE TABLE IF NOT EXISTS `zt_testrun` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `task` mediumint(8) unsigned NOT NULL default '0',
  `case` mediumint(8) unsigned NOT NULL default '0',
  `version` tinyint(3) unsigned NOT NULL default '0',
  `assignedTo` char(30) NOT NULL default '',
  `lastRunner` varchar(30) NOT NULL,
  `lastRunDate` datetime NOT NULL,
  `lastRunResult` char(30) NOT NULL,
  `status` char(30) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `task` (`task`,`case`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testsuite`;
CREATE TABLE IF NOT EXISTS `zt_testsuite` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  `type` varchar(20) NOT NULL,
  `addedBy` char(30) NOT NULL,
  `addedDate` datetime NOT NULL,
  `lastEditedBy` char(30) NOT NULL,
  `lastEditedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product` (`product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testtask`;
CREATE TABLE IF NOT EXISTS `zt_testtask` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `name` char(90) NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL default '0',
  `build` char(30) NOT NULL,
  `owner` varchar(30) NOT NULL,
  `pri` tinyint(3) unsigned NOT NULL default '0',
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `mailto` text,
  `desc` text NOT NULL,
  `report` text NOT NULL,
  `status` enum('blocked','doing','wait','done') NOT NULL DEFAULT 'wait',
  `auto` varchar(10) NOT NULL DEFAULT 'no',
  `subStatus` varchar(30) NOT NULL default '',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `build` (`build`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_todo`;
CREATE TABLE IF NOT EXISTS `zt_todo` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `date` date NOT NULL,
  `begin` smallint(4) unsigned zerofill NOT NULL,
  `end` smallint(4) unsigned zerofill NOT NULL,
  `type` char(10) NOT NULL,
  `cycle` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `idvalue` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `pri` tinyint(3) unsigned NOT NULL,
  `name` char(150) NOT NULL,
  `desc` text NOT NULL,
  `status` enum('wait','doing','done','closed') NOT NULL DEFAULT 'wait',
  `private` tinyint(1) NOT NULL,
  `config` varchar(255) NOT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime NOT NULL,
  `finishedBy` varchar(30) NOT NULL DEFAULT '',
  `finishedDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `assignedTo` (`assignedTo`),
  KEY `finishedBy` (`finishedBy`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_user`;
CREATE TABLE IF NOT EXISTS `zt_user` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint unsigned NOT NULL,
  `type` char(30) NOT NULL default 'inside',
  `dept` mediumint(8) unsigned NOT NULL default '0',
  `account` char(30) NOT NULL default '',
  `password` char(32) NOT NULL default '',
  `role` char(10) NOT NULL default '',
  `realname` varchar(100) NOT NULL default '',
  `nickname` char(60) NOT NULL default '',
  `commiter` varchar(100) NOT NULL,
  `avatar` text NOT NULL,
  `birthday` date NOT NULL default '0000-00-00',
  `gender` enum('f','m') NOT NULL default 'f',
  `email` char(90) NOT NULL default '',
  `skype` char(90) NOT NULL default '',
  `qq` char(20) NOT NULL default '',
  `mobile` char(11) NOT NULL default '',
  `phone` char(20) NOT NULL default '',
  `weixin` varchar(90) NOT NULL default '',
  `dingding` varchar(90) NOT NULL default '',
  `slack` varchar(90) NOT NULL default '',
  `whatsapp` varchar(90) NOT NULL default '',
  `address` char(120) NOT NULL default '',
  `zipcode` char(10) NOT NULL default '',
  `nature` text NOT NULL,
  `analysis` text NOT NULL,
  `strategy` text NOT NULL,
  `join` date NOT NULL default '0000-00-00',
  `visits` mediumint(8) unsigned NOT NULL default '0',
  `ip` char(15) NOT NULL default '',
  `last` int(10) unsigned NOT NULL default '0',
  `fails` tinyint(5) NOT NULL default '0',
  `locked` datetime NOT NULL default '0000-00-00 00:00:00',
  `ranzhi` char(30) NOT NULL default '',
  `score` INT(11) NOT NULL DEFAULT '0',
  `scoreLevel` INT(11) NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `account` (`account`),
  KEY `dept` (`dept`),
  KEY `email` (`email`),
  KEY `commiter` (`commiter`),
  KEY `deleted` (`deleted`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_usercontact`;
CREATE TABLE IF NOT EXISTS `zt_usercontact` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `account` char(30) NOT NULL,
  `listName` varchar(60) NOT NULL,
  `userList` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_usergroup`;
CREATE TABLE IF NOT EXISTS `zt_usergroup` (
  `account` char(30) NOT NULL default '',
  `group` mediumint(8) unsigned NOT NULL default '0',
  `project` text NOT NULL,
  UNIQUE KEY `account` (`account`,`group`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_userquery`;
CREATE TABLE IF NOT EXISTS `zt_userquery` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `account` char(30) NOT NULL,
  `module` varchar(30) NOT NULL,
  `title` varchar(90) NOT NULL,
  `form` text NOT NULL,
  `sql` text NOT NULL,
  `shortcut` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY  (`id`),
  KEY `account` (`account`),
  KEY `module` (`module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_usertpl`;
CREATE TABLE IF NOT EXISTS `zt_usertpl` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `account` char(30) NOT NULL,
  `type` char(30) NOT NULL,
  `title` varchar(150) NOT NULL,
  `content` text NOT NULL,
  `public` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY  (`id`),
  KEY `account` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_userview`;
CREATE TABLE IF NOT EXISTS `zt_userview` (
  `account` char(30) NOT NULL,
  `programs` mediumtext NOT NULL,
  `products` mediumtext NOT NULL,
  `projects` mediumtext NOT NULL,
  `sprints` mediumtext NOT NULL,
  UNIQUE KEY `account` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_entry`;
CREATE TABLE IF NOT EXISTS `zt_entry` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `account` varchar(30) NOT NULL DEFAULT '',
  `code` varchar(20) NOT NULL,
  `key` varchar(32) NOT NULL,
  `freePasswd` enum('0','1') NOT NULL DEFAULT '0',
  `ip` varchar(100) NOT NULL,
  `desc` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `calledTime` int(10) unsigned NOT NULL DEFAULT '0',
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_expect`;
CREATE TABLE IF NOT EXISTS `zt_expect` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `userID` mediumint(8) NOT NULL,
  `project` mediumint(8) NOT NULL DEFAULT 0,
  `expect` text NOT NULL,
  `progress` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_webhook`;
CREATE TABLE IF NOT EXISTS `zt_webhook` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(15) NOT NULL DEFAULT 'default',
  `name` varchar(50) NOT NULL,
  `url` varchar(255) NOT NULL,
  `domain` varchar(255) NOT NULL,
  `secret` varchar(255) NOT NULL,
  `contentType` varchar(30) NOT NULL DEFAULT 'application/json',
  `sendType` enum('sync','async') NOT NULL DEFAULT 'sync',
  `products` text NOT NULL,
  `projects` text NOT NULL,
  `params` varchar(100) NOT NULL,
  `actions` text NOT NULL,
  `desc` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_log`;
CREATE TABLE IF NOT EXISTS `zt_log` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(30) NOT NULL,
  `objectID` mediumint(8) unsigned NOT NULL,
  `action` mediumint(8) unsigned NOT NULL,
  `date` datetime NOT NULL,
  `url` varchar(255) NOT NULL,
  `contentType` varchar(30) NOT NULL,
  `data` text NOT NULL,
  `result` text  NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `objectType` (`objectType`),
  KEY `obejctID` (`objectID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_score`;
CREATE TABLE IF NOT EXISTS `zt_score` (
  `id` bigint(12) unsigned NOT NULL AUTO_INCREMENT,
  `account` varchar(30) NOT NULL,
  `module` varchar(30) NOT NULL DEFAULT '',
  `method` varchar(30) NOT NULL,
  `desc` varchar(250) NOT NULL DEFAULT '',
  `before` int(11) NOT NULL DEFAULT '0',
  `score` int(11) NOT NULL DEFAULT '0',
  `after` int(11) NOT NULL DEFAULT '0',
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `model` (`module`),
  KEY `method` (`method`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_relation`;
CREATE TABLE IF NOT EXISTS `zt_relation` (
  `id` int(8) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `project` mediumint(8) NOT NULL,
  `product` mediumint(8) NOT NULL,
  `execution` mediumint(8) NOT NULL,
  `AType` char(30) NOT NULL,
  `AID` mediumint(8) NOT NULL,
  `AVersion` char(30) NOT NULL,
  `relation` char(30) NOT NULL,
  `BType` char(30) NOT NULL,
  `BID` mediumint(8) NOT NULL,
  `BVersion` char(30) NOT NULL,
  `extra` char(30) NOT NULL,
  UNIQUE KEY `relation` (`relation`,`AType`,`BType`, `AID`, `BID`)
) ENGINE='MyISAM' DEFAULT CHARSET=utf8;

INSERT INTO `zt_cron` (`m`, `h`, `dom`, `mon`, `dow`, `command`, `remark`, `type`, `buildin`, `status`, `lastTime`) VALUES
('*',    '*',    '*',    '*',    '*',    '', '监控定时任务', 'zentao', 1, 'normal',   '0000-00-00 00:00:00'),
('30',   '23',   '*',    '*',    '*',    'moduleName=execution&methodName=computeburn', '更新燃尽图',      'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('0',    '8',    '*',    '*',    '*',    'moduleName=report&methodName=remind',       '每日任务提醒',    'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=svn&methodName=run',             '同步SVN',         'zentao', 1, 'stop',   '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=git&methodName=run',             '同步GIT',         'zentao', 1, 'stop',   '0000-00-00 00:00:00'),
('30',   '0',    '*',    '*',    '*',    'moduleName=backup&methodName=backup',       '备份数据和附件',  'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=mail&methodName=asyncSend',      '异步发信',        'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=webhook&methodName=asyncSend',   '异步发送Webhook', 'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=admin&methodName=deleteLog',     '删除过期日志',    'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('1',    '1',    '*',    '*',    '*',    'moduleName=todo&methodName=createCycle',    '生成周期性待办',  'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('1',    '0',    '*',    '*',    '*',    'moduleName=ci&methodName=initQueue', '创建周期性任务', 'zentao', 1, 'normal',   '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=ci&methodName=checkCompileStatus', '同步Jenkins任务状态', 'zentao', 1, 'normal',   '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=ci&methodName=exec', '执行Jenkins任务', 'zentao', 1, 'normal',   '0000-00-00 00:00:00');

INSERT INTO `zt_group` (`id`, `name`, `role`, `desc`) VALUES
(1, 'ADMIN', 'admin', 'for administrator'),
(2, 'DEV', 'dev', 'for developers.'),
(3, 'QA', 'qa', 'for testers.'),
(4, 'PM', 'pm', 'for project managers.'),
(5, 'PO', 'po', 'for product owners.'),
(6, 'TD', 'td', 'for technical director.'),
(7, 'PD', 'pd', 'for product director.'),
(8, 'QD', 'qd', 'for quality director.'),
(9, 'TOP', 'top', 'for top manager.'),
(10, 'OTHERS', 'others', 'for others.'),
(11, 'guest', 'guest', 'For guest'),
(12, 'LIMITED', 'limited', 'For limited user'),
(13, '项目管理员', 'projectAdmin', '项目管理员可以维护项目的权限');

INSERT INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1,'action','editComment'),
(1,'action','hideAll'),
(1,'action','hideOne'),
(1,'action','trash'),
(1,'action','undelete'),
(1,'admin','checkDB'),
(1,'admin','checkWeak'),
(1,'admin','index'),
(1,'admin','safe'),
(1,'api','debug'),
(1,'backup','backup'),
(1,'backup','change'),
(1,'backup','delete'),
(1,'backup','index'),
(1,'backup','restore'),
(1,'branch','delete'),
(1,'branch','manage'),
(1,'branch','sort'),
(1,'bug','activate'),
(1,'bug','assignTo'),
(1,'bug','batchActivate'),
(1,'bug','batchAssignTo'),
(1,'bug','batchChangeModule'),
(1,'bug','batchClose'),
(1,'bug','batchConfirm'),
(1,'bug','batchCreate'),
(1,'bug','batchEdit'),
(1,'bug','batchResolve'),
(1,'bug','browse'),
(1,'bug','close'),
(1,'bug','confirmBug'),
(1,'bug','confirmStoryChange'),
(1,'bug','create'),
(1,'bug','delete'),
(1,'bug','edit'),
(1,'bug','export'),
(1,'bug','index'),
(1,'bug','linkBugs'),
(1,'bug','report'),
(1,'bug','resolve'),
(1,'bug','view'),
(1,'build','batchUnlinkBug'),
(1,'build','batchUnlinkStory'),
(1,'build','create'),
(1,'build','delete'),
(1,'build','edit'),
(1,'build','linkBug'),
(1,'build','linkStory'),
(1,'build','unlinkBug'),
(1,'build','unlinkStory'),
(1,'build','view'),
(1,'company','browse'),
(1,'company','dynamic'),
(1,'company','edit'),
(1,'company','index'),
(1,'company','view'),
(1,'compile','browse'),
(1,'compile','logs'),
(1,'convert','checkBugFree'),
(1,'convert','checkConfig'),
(1,'convert','checkRedmine'),
(1,'convert','convertBugFree'),
(1,'convert','convertRedmine'),
(1,'convert','execute'),
(1,'convert','index'),
(1,'convert','selectSource'),
(1,'convert','setBugfree'),
(1,'convert','setConfig'),
(1,'convert','setRedmine'),
(1,'cron','create'),
(1,'cron','delete'),
(1,'cron','edit'),
(1,'cron','index'),
(1,'cron','toggle'),
(1,'cron','turnon'),
(1,'custom','flow'),
(1,'custom','index'),
(1,'custom','product'),
(1,'custom','project'),
(1,'custom','restore'),
(1,'custom','set'),
(1,'custom','working'),
(1,'dept','browse'),
(1,'dept','delete'),
(1,'dept','edit'),
(1,'dept','manageChild'),
(1,'dept','updateOrder'),
(1,'dev','api'),
(1,'dev','db'),
(1,'dev','editor'),
(1,'dev','translate'),
(1,'doc','allLibs'),
(1,'doc','browse'),
(1,'doc','create'),
(1,'doc','createLib'),
(1,'doc','delete'),
(1,'doc','deleteFile'),
(1,'doc','deleteLib'),
(1,'doc','edit'),
(1,'doc','editLib'),
(1,'doc','index'),
(1,'doc','objectLibs'),
(1,'doc','showFiles'),
(1,'doc','sort'),
(1,'doc','view'),
(1,'extension','activate'),
(1,'extension','browse'),
(1,'extension','deactivate'),
(1,'extension','erase'),
(1,'extension','install'),
(1,'extension','obtain'),
(1,'extension','structure'),
(1,'extension','uninstall'),
(1,'extension','upgrade'),
(1,'extension','upload'),
(1,'file','delete'),
(1,'file','download'),
(1,'file','edit'),
(1,'file','uploadImages'),
(1,'git','apiSync'),
(1,'git','cat'),
(1,'git','diff'),
(1,'group','browse'),
(1,'group','copy'),
(1,'group','create'),
(1,'group','delete'),
(1,'group','edit'),
(1,'group','manageMember'),
(1,'group','managePriv'),
(1,'group','manageView'),
(1,'index','index'),
(1,'jenkins','browse'),
(1,'jenkins','create'),
(1,'jenkins','delete'),
(1,'jenkins','edit'),
(1,'job','browse'),
(1,'job','create'),
(1,'job','delete'),
(1,'job','edit'),
(1,'job','exec'),
(1,'mail','batchDelete'),
(1,'mail','browse'),
(1,'mail','delete'),
(1,'mail','detect'),
(1,'mail','edit'),
(1,'mail','index'),
(1,'mail','resend'),
(1,'mail','reset'),
(1,'mail','save'),
(1,'mail','test'),
(1,'message','browser'),
(1,'message','index'),
(1,'message','setting'),
(1,'misc','ping'),
(1,'my','calendar'),
(1,'my','team'),
(1,'my','work'),
(1,'my','contribute'),
(1,'my','changePassword'),
(1,'my','deleteContacts'),
(1,'my','dynamic'),
(1,'my','editProfile'),
(1,'my','index'),
(1,'my','manageContacts'),
(1,'my','preference'),
(1,'my','profile'),
(1,'my','project'),
(1,'my','todo'),
(1,'my','unbind'),
(1,'my','uploadAvatar'),
(1,'product','all'),
(1,'product','batchEdit'),
(1,'product','browse'),
(1,'product','build'),
(1,'product','close'),
(1,'product','create'),
(1,'product','dashboard'),
(1,'product','delete'),
(1,'product','doc'),
(1,'product','dynamic'),
(1,'product','edit'),
(1,'product','index'),
(1,'product','project'),
(1,'product','roadmap'),
(1,'product','updateOrder'),
(1,'product','view'),
(1,'productplan','batchUnlinkBug'),
(1,'productplan','batchUnlinkStory'),
(1,'productplan','browse'),
(1,'productplan','create'),
(1,'productplan','delete'),
(1,'productplan','edit'),
(1,'productplan','linkBug'),
(1,'productplan','linkStory'),
(1,'productplan','unlinkBug'),
(1,'productplan','unlinkStory'),
(1,'productplan','view'),
(1,'program','index'),
(1,'program','activate'),
(1,'program','browse'),
(1,'program','close'),
(1,'program','create'),
(1,'program','delete'),
(1,'program','edit'),
(1,'program','product'),
(1,'program','project'),
(1,'program','stakeholder'),
(1,'program','start'),
(1,'program','suspend'),
(1,'project','createGuide'),
(1,'project','createStakeholder'),
(1,'project','index'),
(1,'project','activate'),
(1,'project','addWhitelist'),
(1,'project','browse'),
(1,'project','close'),
(1,'project','copyGroup'),
(1,'project','create'),
(1,'project','createGroup'),
(1,'project','delete'),
(1,'project','edit'),
(1,'project','editGroup'),
(1,'project','group'),
(1,'project','manageGroupMember'),
(1,'project','manageMembers'),
(1,'project','managePriv'),
(1,'project','manageProducts'),
(1,'project','manageView'),
(1,'project','programTitle'),
(1,'project','start'),
(1,'project','suspend'),
(1,'project','view'),
(1,'project','updateOrder'),
(1,'project','whitelist'),
(1,'project','unbindWhielist'),
(1,'project','unlinkStakeholder'),
(1,'execution','activate'),
(1,'execution','all'),
(1,'execution','batchedit'),
(1,'execution','batchUnlinkStory'),
(1,'execution','browse'),
(1,'execution','bug'),
(1,'execution','build'),
(1,'execution','burn'),
(1,'execution','close'),
(1,'execution','computeBurn'),
(1,'execution','create'),
(1,'execution','delete'),
(1,'execution','doc'),
(1,'execution','dynamic'),
(1,'execution','edit'),
(1,'execution','grouptask'),
(1,'execution','importBug'),
(1,'execution','importtask'),
(1,'execution','index'),
(1,'execution','kanban'),
(1,'execution','linkStory'),
(1,'execution','manageMembers'),
(1,'execution','manageProducts'),
(1,'execution','putoff'),
(1,'execution','start'),
(1,'execution','story'),
(1,'execution','suspend'),
(1,'execution','task'),
(1,'execution','team'),
(1,'execution','testtask'),
(1,'execution','tree'),
(1,'execution','unlinkMember'),
(1,'execution','unlinkStory'),
(1,'execution','updateOrder'),
(1,'execution','view'),
(1,'projectbuild','browse'),
(1,'projectrelease','batchUnlinkBug'),
(1,'projectrelease','batchUnlinkStory'),
(1,'projectrelease','browse'),
(1,'projectrelease','changeStatus'),
(1,'projectrelease','create'),
(1,'projectrelease','delete'),
(1,'projectrelease','edit'),
(1,'projectrelease','export'),
(1,'projectrelease','linkBug'),
(1,'projectrelease','linkStory'),
(1,'projectrelease','unlinkBug'),
(1,'projectrelease','unlinkStory'),
(1,'projectrelease','view'),
(1,'projectstory','linkStory'),
(1,'projectstory','story'),
(1,'projectstory','track'),
(1,'projectstory','view'),
(1,'qa','index'),
(1,'release','batchUnlinkBug'),
(1,'release','batchUnlinkStory'),
(1,'release','browse'),
(1,'release','changeStatus'),
(1,'release','create'),
(1,'release','delete'),
(1,'release','edit'),
(1,'release','export'),
(1,'release','linkBug'),
(1,'release','linkStory'),
(1,'release','unlinkBug'),
(1,'release','unlinkStory'),
(1,'release','view'),
(1,'repo','blame'),
(1,'repo','browse'),
(1,'repo','create'),
(1,'repo','delete'),
(1,'repo','diff'),
(1,'repo','download'),
(1,'repo','edit'),
(1,'repo','log'),
(1,'repo','maintain'),
(1,'repo','revision'),
(1,'repo','setRules'),
(1,'repo','showSyncCommit'),
(1,'repo','view'),
(1,'report','bugAssign'),
(1,'report','bugCreate'),
(1,'report','index'),
(1,'report','productSummary'),
(1,'report','projectDeviation'),
(1,'report','workload'),
(1,'search','buildForm'),
(1,'search','buildIndex'),
(1,'search','buildQuery'),
(1,'search','deleteQuery'),
(1,'search','index'),
(1,'search','saveQuery'),
(1,'search','select'),
(1,'story','activate'),
(1,'story','assignTo'),
(1,'story','batchAssignTo'),
(1,'story','batchChangeBranch'),
(1,'story','batchChangeModule'),
(1,'story','batchChangePlan'),
(1,'story','batchChangeStage'),
(1,'story','batchClose'),
(1,'story','batchCreate'),
(1,'story','batchEdit'),
(1,'story','batchReview'),
(1,'story','batchToTask'),
(1,'story','bugs'),
(1,'story','cases'),
(1,'story','change'),
(1,'story','close'),
(1,'story','create'),
(1,'story','delete'),
(1,'story','edit'),
(1,'story','export'),
(1,'story','linkStory'),
(1,'story','report'),
(1,'story','review'),
(1,'story','tasks'),
(1,'story','view'),
(1,'story','zeroCase'),
(1,'svn','apiSync'),
(1,'svn','cat'),
(1,'svn','diff'),
(1,'task','activate'),
(1,'task','assignTo'),
(1,'task','batchAssignTo'),
(1,'task','batchChangeModule'),
(1,'task','batchClose'),
(1,'task','batchCreate'),
(1,'task','batchEdit'),
(1,'task','cancel'),
(1,'task','close'),
(1,'task','confirmStoryChange'),
(1,'task','create'),
(1,'task','delete'),
(1,'task','deleteEstimate'),
(1,'task','edit'),
(1,'task','editEstimate'),
(1,'task','export'),
(1,'task','finish'),
(1,'task','pause'),
(1,'task','recordEstimate'),
(1,'task','report'),
(1,'task','restart'),
(1,'task','start'),
(1,'task','view'),
(1,'testcase','batchCaseTypeChange'),
(1,'testcase','batchChangeModule'),
(1,'testcase','batchConfirmStoryChange'),
(1,'testcase','batchCreate'),
(1,'testcase','batchDelete'),
(1,'testcase','batchEdit'),
(1,'testcase','batchReview'),
(1,'testcase','browse'),
(1,'testcase','bugs'),
(1,'testcase','confirmChange'),
(1,'testcase','confirmStoryChange'),
(1,'testcase','create'),
(1,'testcase','createBug'),
(1,'testcase','delete'),
(1,'testcase','edit'),
(1,'testcase','export'),
(1,'testcase','exportTemplet'),
(1,'testcase','groupCase'),
(1,'testcase','import'),
(1,'testcase','importFromLib'),
(1,'testcase','index'),
(1,'testcase','linkCases'),
(1,'testcase','review'),
(1,'testcase','showImport'),
(1,'testcase','view'),
(1,'testreport','browse'),
(1,'testreport','create'),
(1,'testreport','delete'),
(1,'testreport','edit'),
(1,'testreport','view'),
(1,'testsuite','batchUnlinkCases'),
(1,'testsuite','browse'),
(1,'testsuite','create'),
(1,'testsuite','delete'),
(1,'testsuite','edit'),
(1,'testsuite','index'),
(1,'testsuite','linkCase'),
(1,'testsuite','unlinkCase'),
(1,'testsuite','view'),
(1,'testtask','activate'),
(1,'testtask','batchAssign'),
(1,'testtask','batchRun'),
(1,'testtask','block'),
(1,'testtask','browse'),
(1,'testtask','cases'),
(1,'testtask','close'),
(1,'testtask','create'),
(1,'testtask','delete'),
(1,'testtask','edit'),
(1,'testtask','groupCase'),
(1,'testtask','index'),
(1,'testtask','linkcase'),
(1,'testtask','report'),
(1,'testtask','results'),
(1,'testtask','runcase'),
(1,'testtask','start'),
(1,'testtask','unlinkcase'),
(1,'testtask','view'),
(1,'todo','activate'),
(1,'todo','assignTo'),
(1,'todo','batchClose'),
(1,'todo','batchCreate'),
(1,'todo','batchEdit'),
(1,'todo','batchFinish'),
(1,'todo','close'),
(1,'todo','create'),
(1,'todo','delete'),
(1,'todo','edit'),
(1,'todo','export'),
(1,'todo','finish'),
(1,'todo','import2Today'),
(1,'todo','view'),
(1,'tree','browse'),
(1,'tree','browseTask'),
(1,'tree','delete'),
(1,'tree','edit'),
(1,'tree','fix'),
(1,'tree','manageChild'),
(1,'tree','updateOrder'),
(1,'user','batchCreate'),
(1,'user','batchEdit'),
(1,'user','bug'),
(1,'user','create'),
(1,'user','cropAvatar'),
(1,'user','delete'),
(1,'user','dynamic'),
(1,'user','edit'),
(1,'user','execution'),
(1,'user','issue'),
(1,'user','profile'),
(1,'user','risk'),
(1,'user','story'),
(1,'user','task'),
(1,'user','testCase'),
(1,'user','testTask'),
(1,'user','todo'),
(1,'user','unbind'),
(1,'user','unlock'),
(1,'user','view'),
(2,'action','editComment'),
(2,'bug','activate'),
(2,'bug','assignTo'),
(2,'bug','batchActivate'),
(2,'bug','batchAssignTo'),
(2,'bug','batchChangeModule'),
(2,'bug','batchClose'),
(2,'bug','batchConfirm'),
(2,'bug','batchCreate'),
(2,'bug','batchEdit'),
(2,'bug','batchResolve'),
(2,'bug','browse'),
(2,'bug','close'),
(2,'bug','confirmBug'),
(2,'bug','confirmStoryChange'),
(2,'bug','create'),
(2,'bug','edit'),
(2,'bug','export'),
(2,'bug','index'),
(2,'bug','linkBugs'),
(2,'bug','report'),
(2,'bug','resolve'),
(2,'bug','view'),
(2,'build','create'),
(2,'build','delete'),
(2,'build','edit'),
(2,'build','view'),
(2,'company','browse'),
(2,'company','dynamic'),
(2,'company','index'),
(2,'company','view'),
(2,'doc','allLibs'),
(2,'doc','browse'),
(2,'doc','create'),
(2,'doc','edit'),
(2,'doc','index'),
(2,'doc','objectLibs'),
(2,'doc','showFiles'),
(2,'doc','view'),
(2,'file','download'),
(2,'file','edit'),
(2,'git','apiSync'),
(2,'git','cat'),
(2,'git','diff'),
(2,'group','browse'),
(2,'index','index'),
(2,'misc','ping'),
(2,'my','calendar'),
(2,'my','team'),
(2,'my','work'),
(2,'my','contribute'),
(2,'my','changePassword'),
(2,'my','deleteContacts'),
(2,'my','dynamic'),
(2,'my','editProfile'),
(2,'my','index'),
(2,'my','manageContacts'),
(2,'my','preference'),
(2,'my','profile'),
(2,'my','project'),
(2,'my','todo'),
(2,'my','unbind'),
(2,'my','uploadAvatar'),
(2,'product','all'),
(2,'product','browse'),
(2,'product','build'),
(2,'product','dashboard'),
(2,'product','doc'),
(2,'product','dynamic'),
(2,'product','index'),
(2,'product','project'),
(2,'product','roadmap'),
(2,'product','view'),
(2,'productplan','browse'),
(2,'productplan','view'),
(2,'execution','all'),
(2,'execution','browse'),
(2,'execution','bug'),
(2,'execution','build'),
(2,'execution','burn'),
(2,'execution','computeBurn'),
(2,'execution','doc'),
(2,'execution','dynamic'),
(2,'execution','grouptask'),
(2,'execution','importBug'),
(2,'execution','importtask'),
(2,'execution','index'),
(2,'execution','kanban'),
(2,'execution','story'),
(2,'execution','task'),
(2,'execution','team'),
(2,'execution','testtask'),
(2,'execution','tree'),
(2,'execution','view'),
(2,'projectstory','story'),
(2,'projectstory','track'),
(2,'projectstory','view'),
(2,'qa','index'),
(2,'release','browse'),
(2,'release','export'),
(2,'release','view'),
(2,'repo','blame'),
(2,'repo','browse'),
(2,'repo','diff'),
(2,'repo','download'),
(2,'repo','log'),
(2,'repo','revision'),
(2,'repo','showSyncCommit'),
(2,'repo','view'),
(2,'report','bugAssign'),
(2,'report','bugCreate'),
(2,'report','index'),
(2,'report','productSummary'),
(2,'report','projectDeviation'),
(2,'report','workload'),
(2,'search','buildForm'),
(2,'search','buildQuery'),
(2,'search','deleteQuery'),
(2,'search','index'),
(2,'search','saveQuery'),
(2,'search','select'),
(2,'story','batchToTask'),
(2,'story','bugs'),
(2,'story','cases'),
(2,'story','export'),
(2,'story','report'),
(2,'story','tasks'),
(2,'story','view'),
(2,'svn','apiSync'),
(2,'svn','cat'),
(2,'svn','diff'),
(2,'task','activate'),
(2,'task','assignTo'),
(2,'task','batchAssignTo'),
(2,'task','batchChangeModule'),
(2,'task','batchClose'),
(2,'task','batchCreate'),
(2,'task','batchEdit'),
(2,'task','cancel'),
(2,'task','close'),
(2,'task','confirmStoryChange'),
(2,'task','create'),
(2,'task','deleteEstimate'),
(2,'task','edit'),
(2,'task','editEstimate'),
(2,'task','export'),
(2,'task','finish'),
(2,'task','pause'),
(2,'task','recordEstimate'),
(2,'task','report'),
(2,'task','restart'),
(2,'task','start'),
(2,'task','view'),
(2,'testcase','browse'),
(2,'testcase','bugs'),
(2,'testcase','export'),
(2,'testcase','groupCase'),
(2,'testcase','index'),
(2,'testcase','view'),
(2,'testsuite','browse'),
(2,'testsuite','index'),
(2,'testsuite','view'),
(2,'testtask','browse'),
(2,'testtask','cases'),
(2,'testtask','create'),
(2,'testtask','edit'),
(2,'testtask','groupCase'),
(2,'testtask','index'),
(2,'testtask','results'),
(2,'testtask','view'),
(2,'todo','activate'),
(2,'todo','assignTo'),
(2,'todo','batchClose'),
(2,'todo','batchCreate'),
(2,'todo','batchEdit'),
(2,'todo','batchFinish'),
(2,'todo','close'),
(2,'todo','create'),
(2,'todo','delete'),
(2,'todo','edit'),
(2,'todo','export'),
(2,'todo','finish'),
(2,'todo','import2Today'),
(2,'todo','view'),
(2,'user','bug'),
(2,'user','cropAvatar'),
(2,'user','dynamic'),
(2,'user','execution'),
(2,'user','issue'),
(2,'user','profile'),
(2,'user','risk'),
(2,'user','story'),
(2,'user','task'),
(2,'user','testCase'),
(2,'user','testTask'),
(2,'user','todo'),
(2,'user','view'),
(3,'action','editComment'),
(3,'bug','activate'),
(3,'bug','assignTo'),
(3,'bug','batchActivate'),
(3,'bug','batchChangeModule'),
(3,'bug','batchClose'),
(3,'bug','batchConfirm'),
(3,'bug','batchCreate'),
(3,'bug','batchEdit'),
(3,'bug','batchResolve'),
(3,'bug','browse'),
(3,'bug','close'),
(3,'bug','confirmBug'),
(3,'bug','confirmStoryChange'),
(3,'bug','create'),
(3,'bug','edit'),
(3,'bug','export'),
(3,'bug','index'),
(3,'bug','linkBugs'),
(3,'bug','report'),
(3,'bug','resolve'),
(3,'bug','view'),
(3,'build','create'),
(3,'build','edit'),
(3,'build','view'),
(3,'company','browse'),
(3,'company','dynamic'),
(3,'company','index'),
(3,'company','view'),
(3,'doc','allLibs'),
(3,'doc','browse'),
(3,'doc','create'),
(3,'doc','edit'),
(3,'doc','index'),
(3,'doc','objectLibs'),
(3,'doc','showFiles'),
(3,'doc','view'),
(3,'file','download'),
(3,'file','edit'),
(3,'git','apiSync'),
(3,'git','cat'),
(3,'git','diff'),
(3,'group','browse'),
(3,'index','index'),
(3,'misc','ping'),
(3,'my','calendar'),
(3,'my','team'),
(3,'my','work'),
(3,'my','contribute'),
(3,'my','changePassword'),
(3,'my','deleteContacts'),
(3,'my','dynamic'),
(3,'my','editProfile'),
(3,'my','index'),
(3,'my','manageContacts'),
(3,'my','preference'),
(3,'my','profile'),
(3,'my','project'),
(3,'my','todo'),
(3,'my','unbind'),
(3,'my','uploadAvatar'),
(3,'product','all'),
(3,'product','browse'),
(3,'product','build'),
(3,'product','dashboard'),
(3,'product','doc'),
(3,'product','dynamic'),
(3,'product','index'),
(3,'product','project'),
(3,'product','roadmap'),
(3,'product','view'),
(3,'productplan','browse'),
(3,'productplan','view'),
(3,'execution','all'),
(3,'execution','browse'),
(3,'execution','bug'),
(3,'execution','build'),
(3,'execution','burn'),
(3,'execution','computeBurn'),
(3,'execution','doc'),
(3,'execution','dynamic'),
(3,'execution','grouptask'),
(3,'execution','importBug'),
(3,'execution','importtask'),
(3,'execution','index'),
(3,'execution','kanban'),
(3,'execution','story'),
(3,'execution','task'),
(3,'execution','team'),
(3,'execution','testtask'),
(3,'execution','tree'),
(3,'execution','view'),
(3,'projectstory','story'),
(3,'projectstory','track'),
(3,'projectstory','view'),
(3,'qa','index'),
(3,'release','browse'),
(3,'release','export'),
(3,'release','view'),
(3,'repo','blame'),
(3,'repo','browse'),
(3,'repo','diff'),
(3,'repo','download'),
(3,'repo','log'),
(3,'repo','revision'),
(3,'repo','showSyncCommit'),
(3,'repo','view'),
(3,'report','bugAssign'),
(3,'report','bugCreate'),
(3,'report','index'),
(3,'report','productSummary'),
(3,'report','projectDeviation'),
(3,'report','workload'),
(3,'search','buildForm'),
(3,'search','buildQuery'),
(3,'search','deleteQuery'),
(3,'search','index'),
(3,'search','saveQuery'),
(3,'search','select'),
(3,'story','batchToTask'),
(3,'story','bugs'),
(3,'story','cases'),
(3,'story','export'),
(3,'story','report'),
(3,'story','tasks'),
(3,'story','view'),
(3,'story','zeroCase'),
(3,'svn','apiSync'),
(3,'svn','cat'),
(3,'svn','diff'),
(3,'task','activate'),
(3,'task','assignTo'),
(3,'task','batchAssignTo'),
(3,'task','batchChangeModule'),
(3,'task','batchClose'),
(3,'task','batchCreate'),
(3,'task','batchEdit'),
(3,'task','cancel'),
(3,'task','close'),
(3,'task','confirmStoryChange'),
(3,'task','create'),
(3,'task','deleteEstimate'),
(3,'task','edit'),
(3,'task','editEstimate'),
(3,'task','export'),
(3,'task','finish'),
(3,'task','pause'),
(3,'task','recordEstimate'),
(3,'task','report'),
(3,'task','restart'),
(3,'task','start'),
(3,'task','view'),
(3,'testcase','batchCaseTypeChange'),
(3,'testcase','batchChangeModule'),
(3,'testcase','batchConfirmStoryChange'),
(3,'testcase','batchCreate'),
(3,'testcase','batchEdit'),
(3,'testcase','batchReview'),
(3,'testcase','browse'),
(3,'testcase','bugs'),
(3,'testcase','confirmChange'),
(3,'testcase','confirmStoryChange'),
(3,'testcase','create'),
(3,'testcase','createBug'),
(3,'testcase','edit'),
(3,'testcase','export'),
(3,'testcase','exportTemplet'),
(3,'testcase','groupCase'),
(3,'testcase','import'),
(3,'testcase','index'),
(3,'testcase','linkCases'),
(3,'testcase','review'),
(3,'testcase','showImport'),
(3,'testcase','view'),
(3,'testreport','browse'),
(3,'testreport','view'),
(3,'testsuite','browse'),
(3,'testsuite','create'),
(3,'testsuite','delete'),
(3,'testsuite','edit'),
(3,'testsuite','index'),
(3,'testsuite','linkCase'),
(3,'testsuite','unlinkCase'),
(3,'testsuite','view'),
(3,'testtask','activate'),
(3,'testtask','batchAssign'),
(3,'testtask','batchRun'),
(3,'testtask','block'),
(3,'testtask','browse'),
(3,'testtask','cases'),
(3,'testtask','close'),
(3,'testtask','create'),
(3,'testtask','edit'),
(3,'testtask','groupCase'),
(3,'testtask','index'),
(3,'testtask','linkcase'),
(3,'testtask','report'),
(3,'testtask','results'),
(3,'testtask','runcase'),
(3,'testtask','start'),
(3,'testtask','unlinkcase'),
(3,'testtask','view'),
(3,'todo','activate'),
(3,'todo','assignTo'),
(3,'todo','batchClose'),
(3,'todo','batchCreate'),
(3,'todo','batchEdit'),
(3,'todo','batchFinish'),
(3,'todo','close'),
(3,'todo','create'),
(3,'todo','delete'),
(3,'todo','edit'),
(3,'todo','export'),
(3,'todo','finish'),
(3,'todo','import2Today'),
(3,'todo','view'),
(3,'user','bug'),
(3,'user','cropAvatar'),
(3,'user','dynamic'),
(3,'user','execution'),
(3,'user','issue'),
(3,'user','profile'),
(3,'user','risk'),
(3,'user','story'),
(3,'user','task'),
(3,'user','testCase'),
(3,'user','testTask'),
(3,'user','todo'),
(3,'user','view'),
(4,'action','editComment'),
(4,'action','hideAll'),
(4,'action','hideOne'),
(4,'action','trash'),
(4,'action','undelete'),
(4,'admin','index'),
(4,'bug','activate'),
(4,'bug','assignTo'),
(4,'bug','batchActivate'),
(4,'bug','batchAssignTo'),
(4,'bug','batchChangeModule'),
(4,'bug','batchClose'),
(4,'bug','batchConfirm'),
(4,'bug','batchCreate'),
(4,'bug','batchEdit'),
(4,'bug','batchResolve'),
(4,'bug','browse'),
(4,'bug','close'),
(4,'bug','confirmBug'),
(4,'bug','confirmStoryChange'),
(4,'bug','create'),
(4,'bug','delete'),
(4,'bug','edit'),
(4,'bug','export'),
(4,'bug','index'),
(4,'bug','linkBugs'),
(4,'bug','report'),
(4,'bug','resolve'),
(4,'bug','view'),
(4,'build','batchUnlinkBug'),
(4,'build','batchUnlinkStory'),
(4,'build','create'),
(4,'build','delete'),
(4,'build','edit'),
(4,'build','linkBug'),
(4,'build','linkStory'),
(4,'build','unlinkBug'),
(4,'build','unlinkStory'),
(4,'build','view'),
(4,'company','browse'),
(4,'company','dynamic'),
(4,'company','index'),
(4,'company','view'),
(4,'compile','browse'),
(4,'compile','logs'),
(4,'doc','allLibs'),
(4,'doc','browse'),
(4,'doc','create'),
(4,'doc','createLib'),
(4,'doc','delete'),
(4,'doc','deleteFile'),
(4,'doc','deleteLib'),
(4,'doc','edit'),
(4,'doc','editLib'),
(4,'doc','index'),
(4,'doc','objectLibs'),
(4,'doc','showFiles'),
(4,'doc','view'),
(4,'extension','browse'),
(4,'extension','obtain'),
(4,'extension','structure'),
(4,'file','delete'),
(4,'file','download'),
(4,'file','edit'),
(4,'file','uploadImages'),
(4,'git','apiSync'),
(4,'git','cat'),
(4,'git','diff'),
(4,'group','browse'),
(4,'index','index'),
(4,'jenkins','browse'),
(4,'jenkins','create'),
(4,'jenkins','delete'),
(4,'jenkins','edit'),
(4,'job','browse'),
(4,'job','create'),
(4,'job','delete'),
(4,'job','edit'),
(4,'job','exec'),
(4,'misc','ping'),
(4,'my','calendar'),
(4,'my','team'),
(4,'my','work'),
(4,'my','contribute'),
(4,'my','changePassword'),
(4,'my','deleteContacts'),
(4,'my','dynamic'),
(4,'my','editProfile'),
(4,'my','index'),
(4,'my','manageContacts'),
(4,'my','preference'),
(4,'my','profile'),
(4,'my','project'),
(4,'my','todo'),
(4,'my','unbind'),
(4,'my','uploadAvatar'),
(4,'product','all'),
(4,'product','browse'),
(4,'product','build'),
(4,'product','dashboard'),
(4,'product','doc'),
(4,'product','dynamic'),
(4,'product','index'),
(4,'product','project'),
(4,'product','roadmap'),
(4,'product','view'),
(4,'productplan','browse'),
(4,'productplan','view'),
(4,'program','index'),
(4,'program','activate'),
(4,'program','browse'),
(4,'program','close'),
(4,'program','create'),
(4,'program','delete'),
(4,'program','edit'),
(4,'program','product'),
(4,'program','project'),
(4,'program','stakeholder'),
(4,'program','start'),
(4,'program','suspend'),
(4,'project','createGuide'),
(4,'project','createStakeholder'),
(4,'project','index'),
(4,'project','activate'),
(4,'project','addWhitelist'),
(4,'project','browse'),
(4,'project','close'),
(4,'project','copyGroup'),
(4,'project','create'),
(4,'project','createGroup'),
(4,'project','delete'),
(4,'project','edit'),
(4,'project','editGroup'),
(4,'project','group'),
(4,'project','manageGroupMember'),
(4,'project','manageMembers'),
(4,'project','managePriv'),
(4,'project','manageProducts'),
(4,'project','manageView'),
(4,'project','programTitle'),
(4,'project','start'),
(4,'project','suspend'),
(4,'project','updateOrder'),
(4,'project','view'),
(4,'project','whitelist'),
(4,'project','unbindWhielist'),
(4,'project','unlinkStakeholder'),
(4,'execution','activate'),
(4,'execution','all'),
(4,'execution','batchedit'),
(4,'execution','batchUnlinkStory'),
(4,'execution','browse'),
(4,'execution','bug'),
(4,'execution','build'),
(4,'execution','burn'),
(4,'execution','close'),
(4,'execution','computeBurn'),
(4,'execution','create'),
(4,'execution','delete'),
(4,'execution','doc'),
(4,'execution','dynamic'),
(4,'execution','edit'),
(4,'execution','grouptask'),
(4,'execution','importBug'),
(4,'execution','importtask'),
(4,'execution','index'),
(4,'execution','kanban'),
(4,'execution','linkStory'),
(4,'execution','manageMembers'),
(4,'execution','manageProducts'),
(4,'execution','putoff'),
(4,'execution','start'),
(4,'execution','story'),
(4,'execution','suspend'),
(4,'execution','task'),
(4,'execution','team'),
(4,'execution','testtask'),
(4,'execution','tree'),
(4,'execution','unlinkMember'),
(4,'execution','unlinkStory'),
(4,'execution','updateOrder'),
(4,'execution','view'),
(4,'projectstory','story'),
(4,'projectstory','track'),
(4,'projectstory','view'),
(4,'qa','index'),
(4,'release','browse'),
(4,'release','export'),
(4,'release','view'),
(4,'repo','blame'),
(4,'repo','browse'),
(4,'repo','create'),
(4,'repo','delete'),
(4,'repo','diff'),
(4,'repo','download'),
(4,'repo','edit'),
(4,'repo','log'),
(4,'repo','maintain'),
(4,'repo','revision'),
(4,'repo','setRules'),
(4,'repo','showSyncCommit'),
(4,'repo','view'),
(4,'report','bugAssign'),
(4,'report','bugCreate'),
(4,'report','index'),
(4,'report','productSummary'),
(4,'report','projectDeviation'),
(4,'report','workload'),
(4,'search','buildForm'),
(4,'search','buildQuery'),
(4,'search','deleteQuery'),
(4,'search','index'),
(4,'search','saveQuery'),
(4,'search','select'),
(4,'story','batchToTask'),
(4,'story','bugs'),
(4,'story','cases'),
(4,'story','export'),
(4,'story','report'),
(4,'story','tasks'),
(4,'story','view'),
(4,'story','zeroCase'),
(4,'svn','apiSync'),
(4,'svn','cat'),
(4,'svn','diff'),
(4,'task','activate'),
(4,'task','assignTo'),
(4,'task','batchAssignTo'),
(4,'task','batchChangeModule'),
(4,'task','batchClose'),
(4,'task','batchCreate'),
(4,'task','batchEdit'),
(4,'task','cancel'),
(4,'task','close'),
(4,'task','confirmStoryChange'),
(4,'task','create'),
(4,'task','delete'),
(4,'task','deleteEstimate'),
(4,'task','edit'),
(4,'task','editEstimate'),
(4,'task','export'),
(4,'task','finish'),
(4,'task','pause'),
(4,'task','recordEstimate'),
(4,'task','report'),
(4,'task','restart'),
(4,'task','start'),
(4,'task','view'),
(4,'testcase','browse'),
(4,'testcase','bugs'),
(4,'testcase','createBug'),
(4,'testcase','export'),
(4,'testcase','groupCase'),
(4,'testcase','index'),
(4,'testcase','view'),
(4,'testsuite','browse'),
(4,'testsuite','index'),
(4,'testsuite','view'),
(4,'testtask','batchAssign'),
(4,'testtask','browse'),
(4,'testtask','cases'),
(4,'testtask','create'),
(4,'testtask','edit'),
(4,'testtask','groupCase'),
(4,'testtask','index'),
(4,'testtask','results'),
(4,'testtask','view'),
(4,'todo','activate'),
(4,'todo','assignTo'),
(4,'todo','batchClose'),
(4,'todo','batchCreate'),
(4,'todo','batchEdit'),
(4,'todo','batchFinish'),
(4,'todo','close'),
(4,'todo','create'),
(4,'todo','delete'),
(4,'todo','edit'),
(4,'todo','export'),
(4,'todo','finish'),
(4,'todo','import2Today'),
(4,'todo','view'),
(4,'tree','browse'),
(4,'tree','browseTask'),
(4,'tree','delete'),
(4,'tree','edit'),
(4,'tree','fix'),
(4,'tree','manageChild'),
(4,'tree','updateOrder'),
(4,'user','bug'),
(4,'user','cropAvatar'),
(4,'user','dynamic'),
(4,'user','execution'),
(4,'user','issue'),
(4,'user','profile'),
(4,'user','risk'),
(4,'user','story'),
(4,'user','task'),
(4,'user','testCase'),
(4,'user','testTask'),
(4,'user','todo'),
(4,'user','view'),
(5,'action','editComment'),
(5,'action','hideAll'),
(5,'action','hideOne'),
(5,'action','trash'),
(5,'action','undelete'),
(5,'admin','index'),
(5,'branch','delete'),
(5,'branch','manage'),
(5,'branch','sort'),
(5,'bug','activate'),
(5,'bug','assignTo'),
(5,'bug','batchActivate'),
(5,'bug','batchAssignTo'),
(5,'bug','batchChangeModule'),
(5,'bug','batchClose'),
(5,'bug','batchConfirm'),
(5,'bug','batchCreate'),
(5,'bug','batchEdit'),
(5,'bug','batchResolve'),
(5,'bug','browse'),
(5,'bug','close'),
(5,'bug','confirmBug'),
(5,'bug','confirmStoryChange'),
(5,'bug','create'),
(5,'bug','edit'),
(5,'bug','export'),
(5,'bug','index'),
(5,'bug','linkBugs'),
(5,'bug','report'),
(5,'bug','resolve'),
(5,'bug','view'),
(5,'build','view'),
(5,'company','browse'),
(5,'company','dynamic'),
(5,'company','index'),
(5,'company','view'),
(5,'compile','browse'),
(5,'compile','logs'),
(5,'doc','allLibs'),
(5,'doc','browse'),
(5,'doc','create'),
(5,'doc','createLib'),
(5,'doc','delete'),
(5,'doc','deleteFile'),
(5,'doc','deleteLib'),
(5,'doc','edit'),
(5,'doc','editLib'),
(5,'doc','index'),
(5,'doc','objectLibs'),
(5,'doc','showFiles'),
(5,'doc','view'),
(5,'extension','browse'),
(5,'extension','obtain'),
(5,'extension','structure'),
(5,'file','delete'),
(5,'file','download'),
(5,'file','edit'),
(5,'file','uploadImages'),
(5,'git','apiSync'),
(5,'git','cat'),
(5,'git','diff'),
(5,'group','browse'),
(5,'index','index'),
(5,'jenkins','browse'),
(5,'jenkins','create'),
(5,'jenkins','delete'),
(5,'jenkins','edit'),
(5,'job','browse'),
(5,'job','create'),
(5,'job','delete'),
(5,'job','edit'),
(5,'job','exec'),
(5,'misc','ping'),
(5,'my','calendar'),
(5,'my','team'),
(5,'my','work'),
(5,'my','contribute'),
(5,'my','changePassword'),
(5,'my','deleteContacts'),
(5,'my','dynamic'),
(5,'my','editProfile'),
(5,'my','index'),
(5,'my','manageContacts'),
(5,'my','preference'),
(5,'my','profile'),
(5,'my','project'),
(5,'my','todo'),
(5,'my','unbind'),
(5,'my','uploadAvatar'),
(5,'product','all'),
(5,'product','batchEdit'),
(5,'product','browse'),
(5,'product','build'),
(5,'product','close'),
(5,'product','create'),
(5,'product','dashboard'),
(5,'product','delete'),
(5,'product','doc'),
(5,'product','dynamic'),
(5,'product','edit'),
(5,'product','index'),
(5,'product','project'),
(5,'product','roadmap'),
(5,'product','updateOrder'),
(5,'product','view'),
(5,'productplan','batchUnlinkBug'),
(5,'productplan','batchUnlinkStory'),
(5,'productplan','browse'),
(5,'productplan','create'),
(5,'productplan','delete'),
(5,'productplan','edit'),
(5,'productplan','linkBug'),
(5,'productplan','linkStory'),
(5,'productplan','unlinkBug'),
(5,'productplan','unlinkStory'),
(5,'productplan','view'),
(5,'program','index'),
(5,'program','activate'),
(5,'program','browse'),
(5,'program','close'),
(5,'program','create'),
(5,'program','delete'),
(5,'program','edit'),
(5,'program','product'),
(5,'program','project'),
(5,'program','stakeholder'),
(5,'program','start'),
(5,'program','suspend'),
(5,'project','createGuide'),
(5,'project','createStakeholder'),
(5,'project','index'),
(5,'project','activate'),
(5,'project','addWhitelist'),
(5,'project','browse'),
(5,'project','close'),
(5,'project','copyGroup'),
(5,'project','create'),
(5,'project','createGroup'),
(5,'project','delete'),
(5,'project','edit'),
(5,'project','editGroup'),
(5,'project','group'),
(5,'project','manageGroupMember'),
(5,'project','manageMembers'),
(5,'project','managePriv'),
(5,'project','manageProducts'),
(5,'project','manageView'),
(5,'project','programTitle'),
(5,'project','start'),
(5,'project','suspend'),
(5,'project','view'),
(5,'project','updateOrder'),
(5,'project','whitelist'),
(5,'project','unbindWhielist'),
(5,'project','unlinkStakeholder'),
(5,'execution','activate'),
(5,'execution','all'),
(5,'execution','batchedit'),
(5,'execution','batchUnlinkStory'),
(5,'execution','browse'),
(5,'execution','bug'),
(5,'execution','build'),
(5,'execution','burn'),
(5,'execution','close'),
(5,'execution','computeBurn'),
(5,'execution','create'),
(5,'execution','delete'),
(5,'execution','doc'),
(5,'execution','dynamic'),
(5,'execution','edit'),
(5,'execution','grouptask'),
(5,'execution','importBug'),
(5,'execution','importtask'),
(5,'execution','index'),
(5,'execution','kanban'),
(5,'execution','linkStory'),
(5,'execution','manageMembers'),
(5,'execution','manageProducts'),
(5,'execution','putoff'),
(5,'execution','start'),
(5,'execution','story'),
(5,'execution','suspend'),
(5,'execution','task'),
(5,'execution','team'),
(5,'execution','testtask'),
(5,'execution','tree'),
(5,'execution','unlinkMember'),
(5,'execution','unlinkStory'),
(5,'execution','updateOrder'),
(5,'execution','view'),
(5,'projectstory','linkStory'),
(5,'projectstory','story'),
(5,'projectstory','track'),
(5,'projectstory','view'),
(5,'qa','index'),
(5,'release','batchUnlinkBug'),
(5,'release','batchUnlinkStory'),
(5,'release','browse'),
(5,'release','changeStatus'),
(5,'release','create'),
(5,'release','delete'),
(5,'release','edit'),
(5,'release','export'),
(5,'release','linkBug'),
(5,'release','linkStory'),
(5,'release','unlinkBug'),
(5,'release','unlinkStory'),
(5,'release','view'),
(5,'repo','blame'),
(5,'repo','browse'),
(5,'repo','create'),
(5,'repo','delete'),
(5,'repo','diff'),
(5,'repo','download'),
(5,'repo','edit'),
(5,'repo','log'),
(5,'repo','maintain'),
(5,'repo','revision'),
(5,'repo','setRules'),
(5,'repo','showSyncCommit'),
(5,'repo','view'),
(5,'report','bugAssign'),
(5,'report','bugCreate'),
(5,'report','index'),
(5,'report','productSummary'),
(5,'report','projectDeviation'),
(5,'report','workload'),
(5,'search','buildForm'),
(5,'search','buildQuery'),
(5,'search','deleteQuery'),
(5,'search','index'),
(5,'search','saveQuery'),
(5,'search','select'),
(5,'story','activate'),
(5,'story','batchChangeBranch'),
(5,'story','batchChangeModule'),
(5,'story','batchChangePlan'),
(5,'story','batchChangeStage'),
(5,'story','batchClose'),
(5,'story','batchCreate'),
(5,'story','batchEdit'),
(5,'story','batchReview'),
(5,'story','bugs'),
(5,'story','cases'),
(5,'story','change'),
(5,'story','close'),
(5,'story','create'),
(5,'story','delete'),
(5,'story','edit'),
(5,'story','export'),
(5,'story','linkStory'),
(5,'story','report'),
(5,'story','review'),
(5,'story','tasks'),
(5,'story','view'),
(5,'story','zeroCase'),
(5,'svn','apiSync'),
(5,'svn','cat'),
(5,'svn','diff'),
(5,'task','confirmStoryChange'),
(5,'task','deleteEstimate'),
(5,'task','editEstimate'),
(5,'task','export'),
(5,'task','recordEstimate'),
(5,'task','report'),
(5,'task','view'),
(5,'testcase','browse'),
(5,'testcase','bugs'),
(5,'testcase','createBug'),
(5,'testcase','export'),
(5,'testcase','groupCase'),
(5,'testcase','importFromLib'),
(5,'testcase','index'),
(5,'testcase','view'),
(5,'testsuite','browse'),
(5,'testsuite','index'),
(5,'testsuite','view'),
(5,'testtask','browse'),
(5,'testtask','cases'),
(5,'testtask','groupCase'),
(5,'testtask','index'),
(5,'testtask','results'),
(5,'testtask','view'),
(5,'todo','activate'),
(5,'todo','assignTo'),
(5,'todo','batchClose'),
(5,'todo','batchCreate'),
(5,'todo','batchEdit'),
(5,'todo','batchFinish'),
(5,'todo','close'),
(5,'todo','create'),
(5,'todo','delete'),
(5,'todo','edit'),
(5,'todo','export'),
(5,'todo','finish'),
(5,'todo','import2Today'),
(5,'todo','view'),
(5,'tree','browse'),
(5,'tree','browseTask'),
(5,'tree','delete'),
(5,'tree','edit'),
(5,'tree','fix'),
(5,'tree','manageChild'),
(5,'tree','updateOrder'),
(5,'user','bug'),
(5,'user','cropAvatar'),
(5,'user','dynamic'),
(5,'user','execution'),
(5,'user','issue'),
(5,'user','profile'),
(5,'user','risk'),
(5,'user','story'),
(5,'user','task'),
(5,'user','testCase'),
(5,'user','testTask'),
(5,'user','todo'),
(5,'user','view'),
(6,'action','editComment'),
(6,'action','hideAll'),
(6,'action','hideOne'),
(6,'action','trash'),
(6,'action','undelete'),
(6,'admin','index'),
(6,'bug','activate'),
(6,'bug','assignTo'),
(6,'bug','batchActivate'),
(6,'bug','batchAssignTo'),
(6,'bug','batchChangeModule'),
(6,'bug','batchClose'),
(6,'bug','batchConfirm'),
(6,'bug','batchCreate'),
(6,'bug','batchEdit'),
(6,'bug','batchResolve'),
(6,'bug','browse'),
(6,'bug','close'),
(6,'bug','confirmBug'),
(6,'bug','confirmStoryChange'),
(6,'bug','create'),
(6,'bug','delete'),
(6,'bug','edit'),
(6,'bug','export'),
(6,'bug','index'),
(6,'bug','linkBugs'),
(6,'bug','report'),
(6,'bug','resolve'),
(6,'bug','view'),
(6,'build','batchUnlinkBug'),
(6,'build','batchUnlinkStory'),
(6,'build','create'),
(6,'build','delete'),
(6,'build','edit'),
(6,'build','linkBug'),
(6,'build','linkStory'),
(6,'build','unlinkBug'),
(6,'build','unlinkStory'),
(6,'build','view'),
(6,'company','browse'),
(6,'company','dynamic'),
(6,'company','index'),
(6,'company','view'),
(6,'doc','allLibs'),
(6,'doc','browse'),
(6,'doc','create'),
(6,'doc','createLib'),
(6,'doc','delete'),
(6,'doc','deleteFile'),
(6,'doc','deleteLib'),
(6,'doc','edit'),
(6,'doc','editLib'),
(6,'doc','index'),
(6,'doc','objectLibs'),
(6,'doc','showFiles'),
(6,'doc','view'),
(6,'extension','browse'),
(6,'extension','obtain'),
(6,'extension','structure'),
(6,'file','delete'),
(6,'file','download'),
(6,'file','edit'),
(6,'file','uploadImages'),
(6,'git','apiSync'),
(6,'git','cat'),
(6,'git','diff'),
(6,'group','browse'),
(6,'index','index'),
(6,'misc','ping'),
(6,'my','calendar'),
(6,'my','team'),
(6,'my','work'),
(6,'my','contribute'),
(6,'my','changePassword'),
(6,'my','deleteContacts'),
(6,'my','dynamic'),
(6,'my','editProfile'),
(6,'my','index'),
(6,'my','manageContacts'),
(6,'my','preference'),
(6,'my','profile'),
(6,'my','project'),
(6,'my','todo'),
(6,'my','unbind'),
(6,'my','uploadAvatar'),
(6,'product','all'),
(6,'product','browse'),
(6,'product','build'),
(6,'product','dashboard'),
(6,'product','doc'),
(6,'product','dynamic'),
(6,'product','index'),
(6,'product','project'),
(6,'product','roadmap'),
(6,'product','view'),
(6,'productplan','browse'),
(6,'productplan','view'),
(6,'program','index'),
(6,'program','activate'),
(6,'program','browse'),
(6,'program','close'),
(6,'program','create'),
(6,'program','delete'),
(6,'program','edit'),
(6,'program','product'),
(6,'program','project'),
(6,'program','stakeholder'),
(6,'program','start'),
(6,'program','suspend'),
(6,'project','createGuide'),
(6,'project','createStakeholder'),
(6,'project','index'),
(6,'project','activate'),
(6,'project','addWhitelist'),
(6,'project','browse'),
(6,'project','close'),
(6,'project','copyGroup'),
(6,'project','create'),
(6,'project','createGroup'),
(6,'project','delete'),
(6,'project','edit'),
(6,'project','editGroup'),
(6,'project','group'),
(6,'project','manageGroupMember'),
(6,'project','manageMembers'),
(6,'project','managePriv'),
(6,'project','manageProducts'),
(6,'project','manageView'),
(6,'project','programTitle'),
(6,'project','start'),
(6,'project','suspend'),
(6,'project','view'),
(6,'project','updateOrder'),
(6,'project','whitelist'),
(6,'project','unbindWhielist'),
(6,'project','unlinkStakeholder'),
(6,'execution','activate'),
(6,'execution','all'),
(6,'execution','batchedit'),
(6,'execution','batchUnlinkStory'),
(6,'execution','browse'),
(6,'execution','bug'),
(6,'execution','build'),
(6,'execution','burn'),
(6,'execution','close'),
(6,'execution','computeBurn'),
(6,'execution','create'),
(6,'execution','delete'),
(6,'execution','doc'),
(6,'execution','dynamic'),
(6,'execution','edit'),
(6,'execution','grouptask'),
(6,'execution','importBug'),
(6,'execution','importtask'),
(6,'execution','index'),
(6,'execution','kanban'),
(6,'execution','linkStory'),
(6,'execution','manageMembers'),
(6,'execution','manageProducts'),
(6,'execution','putoff'),
(6,'execution','start'),
(6,'execution','story'),
(6,'execution','suspend'),
(6,'execution','task'),
(6,'execution','team'),
(6,'execution','testtask'),
(6,'execution','tree'),
(6,'execution','unlinkMember'),
(6,'execution','unlinkStory'),
(6,'execution','updateOrder'),
(6,'execution','view'),
(6,'projectstory','story'),
(6,'projectstory','track'),
(6,'projectstory','view'),
(6,'qa','index'),
(6,'release','browse'),
(6,'release','export'),
(6,'release','view'),
(6,'repo','blame'),
(6,'repo','browse'),
(6,'repo','diff'),
(6,'repo','download'),
(6,'repo','log'),
(6,'repo','revision'),
(6,'repo','showSyncCommit'),
(6,'repo','view'),
(6,'report','bugAssign'),
(6,'report','bugCreate'),
(6,'report','index'),
(6,'report','productSummary'),
(6,'report','projectDeviation'),
(6,'report','workload'),
(6,'search','buildForm'),
(6,'search','buildQuery'),
(6,'search','deleteQuery'),
(6,'search','index'),
(6,'search','saveQuery'),
(6,'search','select'),
(6,'story','batchToTask'),
(6,'story','bugs'),
(6,'story','cases'),
(6,'story','export'),
(6,'story','report'),
(6,'story','tasks'),
(6,'story','view'),
(6,'story','zeroCase'),
(6,'svn','apiSync'),
(6,'svn','cat'),
(6,'svn','diff'),
(6,'task','activate'),
(6,'task','assignTo'),
(6,'task','batchAssignTo'),
(6,'task','batchChangeModule'),
(6,'task','batchClose'),
(6,'task','batchCreate'),
(6,'task','batchEdit'),
(6,'task','cancel'),
(6,'task','close'),
(6,'task','confirmStoryChange'),
(6,'task','create'),
(6,'task','delete'),
(6,'task','deleteEstimate'),
(6,'task','edit'),
(6,'task','editEstimate'),
(6,'task','export'),
(6,'task','finish'),
(6,'task','pause'),
(6,'task','recordEstimate'),
(6,'task','report'),
(6,'task','restart'),
(6,'task','start'),
(6,'task','view'),
(6,'testcase','browse'),
(6,'testcase','bugs'),
(6,'testcase','export'),
(6,'testcase','groupCase'),
(6,'testcase','index'),
(6,'testcase','view'),
(6,'testsuite','browse'),
(6,'testsuite','index'),
(6,'testsuite','view'),
(6,'testtask','browse'),
(6,'testtask','cases'),
(6,'testtask','create'),
(6,'testtask','edit'),
(6,'testtask','groupCase'),
(6,'testtask','index'),
(6,'testtask','results'),
(6,'testtask','view'),
(6,'todo','activate'),
(6,'todo','assignTo'),
(6,'todo','batchClose'),
(6,'todo','batchCreate'),
(6,'todo','batchEdit'),
(6,'todo','batchFinish'),
(6,'todo','close'),
(6,'todo','create'),
(6,'todo','delete'),
(6,'todo','edit'),
(6,'todo','export'),
(6,'todo','finish'),
(6,'todo','import2Today'),
(6,'todo','view'),
(6,'tree','browse'),
(6,'tree','browseTask'),
(6,'tree','delete'),
(6,'tree','edit'),
(6,'tree','fix'),
(6,'tree','manageChild'),
(6,'tree','updateOrder'),
(6,'user','bug'),
(6,'user','cropAvatar'),
(6,'user','dynamic'),
(6,'user','execution'),
(6,'user','issue'),
(6,'user','profile'),
(6,'user','risk'),
(6,'user','story'),
(6,'user','task'),
(6,'user','testCase'),
(6,'user','testTask'),
(6,'user','todo'),
(6,'user','view'),
(7,'action','editComment'),
(7,'action','hideAll'),
(7,'action','hideOne'),
(7,'action','trash'),
(7,'action','undelete'),
(7,'admin','index'),
(7,'branch','delete'),
(7,'branch','manage'),
(7,'branch','sort'),
(7,'bug','activate'),
(7,'bug','assignTo'),
(7,'bug','batchActivate'),
(7,'bug','batchChangeModule'),
(7,'bug','batchClose'),
(7,'bug','batchConfirm'),
(7,'bug','batchCreate'),
(7,'bug','batchEdit'),
(7,'bug','batchResolve'),
(7,'bug','browse'),
(7,'bug','close'),
(7,'bug','confirmBug'),
(7,'bug','confirmStoryChange'),
(7,'bug','create'),
(7,'bug','delete'),
(7,'bug','edit'),
(7,'bug','export'),
(7,'bug','index'),
(7,'bug','linkBugs'),
(7,'bug','report'),
(7,'bug','resolve'),
(7,'bug','view'),
(7,'build','view'),
(7,'company','browse'),
(7,'company','dynamic'),
(7,'company','index'),
(7,'company','view'),
(7,'doc','allLibs'),
(7,'doc','browse'),
(7,'doc','create'),
(7,'doc','createLib'),
(7,'doc','delete'),
(7,'doc','deleteFile'),
(7,'doc','deleteLib'),
(7,'doc','edit'),
(7,'doc','editLib'),
(7,'doc','index'),
(7,'doc','objectLibs'),
(7,'doc','showFiles'),
(7,'doc','view'),
(7,'extension','browse'),
(7,'extension','obtain'),
(7,'extension','structure'),
(7,'file','delete'),
(7,'file','download'),
(7,'file','edit'),
(7,'file','uploadImages'),
(7,'git','apiSync'),
(7,'git','cat'),
(7,'git','diff'),
(7,'group','browse'),
(7,'index','index'),
(7,'misc','ping'),
(7,'my','calendar'),
(7,'my','team'),
(7,'my','work'),
(7,'my','contribute'),
(7,'my','changePassword'),
(7,'my','deleteContacts'),
(7,'my','dynamic'),
(7,'my','editProfile'),
(7,'my','index'),
(7,'my','manageContacts'),
(7,'my','preference'),
(7,'my','profile'),
(7,'my','project'),
(7,'my','todo'),
(7,'my','unbind'),
(7,'my','uploadAvatar'),
(7,'product','all'),
(7,'product','batchEdit'),
(7,'product','browse'),
(7,'product','build'),
(7,'product','close'),
(7,'product','create'),
(7,'product','dashboard'),
(7,'product','delete'),
(7,'product','doc'),
(7,'product','dynamic'),
(7,'product','edit'),
(7,'product','index'),
(7,'product','project'),
(7,'product','roadmap'),
(7,'product','updateOrder'),
(7,'product','view'),
(7,'productplan','batchUnlinkBug'),
(7,'productplan','batchUnlinkStory'),
(7,'productplan','browse'),
(7,'productplan','create'),
(7,'productplan','delete'),
(7,'productplan','edit'),
(7,'productplan','linkBug'),
(7,'productplan','linkStory'),
(7,'productplan','unlinkBug'),
(7,'productplan','unlinkStory'),
(7,'productplan','view'),
(7,'program','index'),
(7,'program','activate'),
(7,'program','browse'),
(7,'program','close'),
(7,'program','create'),
(7,'program','delete'),
(7,'program','edit'),
(7,'program','product'),
(7,'program','project'),
(7,'program','stakeholder'),
(7,'program','start'),
(7,'program','suspend'),
(7,'project','createGuide'),
(7,'project','createStakeholder'),
(7,'project','index'),
(7,'project','activate'),
(7,'project','addWhitelist'),
(7,'project','browse'),
(7,'project','close'),
(7,'project','copyGroup'),
(7,'project','create'),
(7,'project','createGroup'),
(7,'project','delete'),
(7,'project','edit'),
(7,'project','editGroup'),
(7,'project','group'),
(7,'project','manageGroupMember'),
(7,'project','manageMembers'),
(7,'project','managePriv'),
(7,'project','manageProducts'),
(7,'project','manageView'),
(7,'project','programTitle'),
(7,'project','start'),
(7,'project','suspend'),
(7,'project','view'),
(7,'project','updateOrder'),
(7,'project','whitelist'),
(7,'project','unbindWhielist'),
(7,'project','unlinkStakeholder'),
(7,'execution','all'),
(7,'execution','browse'),
(7,'execution','bug'),
(7,'execution','build'),
(7,'execution','burn'),
(7,'execution','doc'),
(7,'execution','dynamic'),
(7,'execution','grouptask'),
(7,'execution','index'),
(7,'execution','kanban'),
(7,'execution','linkStory'),
(7,'execution','manageProducts'),
(7,'execution','story'),
(7,'execution','task'),
(7,'execution','team'),
(7,'execution','testtask'),
(7,'execution','tree'),
(7,'execution','unlinkStory'),
(7,'execution','view'),
(7,'projectstory','linkStory'),
(7,'projectstory','story'),
(7,'projectstory','track'),
(7,'projectstory','view'),
(7,'qa','index'),
(7,'release','batchUnlinkBug'),
(7,'release','batchUnlinkStory'),
(7,'release','browse'),
(7,'release','changeStatus'),
(7,'release','create'),
(7,'release','delete'),
(7,'release','edit'),
(7,'release','export'),
(7,'release','linkBug'),
(7,'release','linkStory'),
(7,'release','unlinkBug'),
(7,'release','unlinkStory'),
(7,'release','view'),
(7,'repo','blame'),
(7,'repo','browse'),
(7,'repo','diff'),
(7,'repo','download'),
(7,'repo','log'),
(7,'repo','revision'),
(7,'repo','showSyncCommit'),
(7,'repo','view'),
(7,'report','bugAssign'),
(7,'report','bugCreate'),
(7,'report','index'),
(7,'report','productSummary'),
(7,'report','projectDeviation'),
(7,'report','workload'),
(7,'search','buildForm'),
(7,'search','buildQuery'),
(7,'search','deleteQuery'),
(7,'search','index'),
(7,'search','saveQuery'),
(7,'search','select'),
(7,'story','activate'),
(7,'story','assignTo'),
(7,'story','batchAssignTo'),
(7,'story','batchChangeBranch'),
(7,'story','batchChangeModule'),
(7,'story','batchChangePlan'),
(7,'story','batchChangeStage'),
(7,'story','batchClose'),
(7,'story','batchCreate'),
(7,'story','batchEdit'),
(7,'story','batchReview'),
(7,'story','bugs'),
(7,'story','cases'),
(7,'story','change'),
(7,'story','close'),
(7,'story','create'),
(7,'story','delete'),
(7,'story','edit'),
(7,'story','export'),
(7,'story','linkStory'),
(7,'story','report'),
(7,'story','review'),
(7,'story','tasks'),
(7,'story','view'),
(7,'story','zeroCase'),
(7,'svn','apiSync'),
(7,'svn','cat'),
(7,'svn','diff'),
(7,'task','confirmStoryChange'),
(7,'task','deleteEstimate'),
(7,'task','editEstimate'),
(7,'task','export'),
(7,'task','recordEstimate'),
(7,'task','report'),
(7,'task','view'),
(7,'testcase','browse'),
(7,'testcase','bugs'),
(7,'testcase','createBug'),
(7,'testcase','export'),
(7,'testcase','groupCase'),
(7,'testcase','importFromLib'),
(7,'testcase','index'),
(7,'testcase','view'),
(7,'testsuite','browse'),
(7,'testsuite','index'),
(7,'testsuite','view'),
(7,'testtask','browse'),
(7,'testtask','cases'),
(7,'testtask','groupCase'),
(7,'testtask','index'),
(7,'testtask','results'),
(7,'testtask','view'),
(7,'todo','activate'),
(7,'todo','assignTo'),
(7,'todo','batchClose'),
(7,'todo','batchCreate'),
(7,'todo','batchEdit'),
(7,'todo','batchFinish'),
(7,'todo','close'),
(7,'todo','create'),
(7,'todo','delete'),
(7,'todo','edit'),
(7,'todo','export'),
(7,'todo','finish'),
(7,'todo','import2Today'),
(7,'todo','view'),
(7,'tree','browse'),
(7,'tree','browseTask'),
(7,'tree','delete'),
(7,'tree','edit'),
(7,'tree','fix'),
(7,'tree','manageChild'),
(7,'tree','updateOrder'),
(7,'user','bug'),
(7,'user','cropAvatar'),
(7,'user','dynamic'),
(7,'user','execution'),
(7,'user','issue'),
(7,'user','profile'),
(7,'user','risk'),
(7,'user','story'),
(7,'user','task'),
(7,'user','testCase'),
(7,'user','testTask'),
(7,'user','todo'),
(7,'user','view'),
(8,'action','editComment'),
(8,'action','hideAll'),
(8,'action','hideOne'),
(8,'action','trash'),
(8,'action','undelete'),
(8,'admin','index'),
(8,'bug','activate'),
(8,'bug','assignTo'),
(8,'bug','batchActivate'),
(8,'bug','batchAssignTo'),
(8,'bug','batchChangeModule'),
(8,'bug','batchClose'),
(8,'bug','batchConfirm'),
(8,'bug','batchCreate'),
(8,'bug','batchEdit'),
(8,'bug','batchResolve'),
(8,'bug','browse'),
(8,'bug','close'),
(8,'bug','confirmBug'),
(8,'bug','confirmStoryChange'),
(8,'bug','create'),
(8,'bug','delete'),
(8,'bug','edit'),
(8,'bug','export'),
(8,'bug','index'),
(8,'bug','linkBugs'),
(8,'bug','report'),
(8,'bug','resolve'),
(8,'bug','view'),
(8,'build','create'),
(8,'build','delete'),
(8,'build','edit'),
(8,'build','view'),
(8,'company','browse'),
(8,'company','dynamic'),
(8,'company','index'),
(8,'company','view'),
(8,'doc','allLibs'),
(8,'doc','browse'),
(8,'doc','create'),
(8,'doc','createLib'),
(8,'doc','delete'),
(8,'doc','deleteFile'),
(8,'doc','deleteLib'),
(8,'doc','edit'),
(8,'doc','editLib'),
(8,'doc','index'),
(8,'doc','objectLibs'),
(8,'doc','showFiles'),
(8,'doc','view'),
(8,'extension','browse'),
(8,'extension','obtain'),
(8,'extension','structure'),
(8,'file','delete'),
(8,'file','download'),
(8,'file','edit'),
(8,'file','uploadImages'),
(8,'git','apiSync'),
(8,'git','cat'),
(8,'git','diff'),
(8,'group','browse'),
(8,'index','index'),
(8,'misc','ping'),
(8,'my','calendar'),
(8,'my','team'),
(8,'my','work'),
(8,'my','contribute'),
(8,'my','changePassword'),
(8,'my','deleteContacts'),
(8,'my','dynamic'),
(8,'my','editProfile'),
(8,'my','index'),
(8,'my','manageContacts'),
(8,'my','preference'),
(8,'my','profile'),
(8,'my','project'),
(8,'my','todo'),
(8,'my','unbind'),
(8,'my','uploadAvatar'),
(8,'product','all'),
(8,'product','browse'),
(8,'product','build'),
(8,'product','dashboard'),
(8,'product','doc'),
(8,'product','dynamic'),
(8,'product','index'),
(8,'product','project'),
(8,'product','roadmap'),
(8,'product','view'),
(8,'productplan','browse'),
(8,'productplan','view'),
(8,'program','index'),
(8,'program','activate'),
(8,'program','browse'),
(8,'program','close'),
(8,'program','create'),
(8,'program','delete'),
(8,'program','edit'),
(8,'program','product'),
(8,'program','project'),
(8,'program','stakeholder'),
(8,'program','start'),
(8,'program','suspend'),
(8,'project','createGuide'),
(8,'project','createStakeholder'),
(8,'project','index'),
(8,'project','activate'),
(8,'project','addWhitelist'),
(8,'project','browse'),
(8,'project','close'),
(8,'project','copyGroup'),
(8,'project','create'),
(8,'project','createGroup'),
(8,'project','delete'),
(8,'project','edit'),
(8,'project','editGroup'),
(8,'project','group'),
(8,'project','manageGroupMember'),
(8,'project','manageMembers'),
(8,'project','managePriv'),
(8,'project','manageProducts'),
(8,'project','manageView'),
(8,'project','programTitle'),
(8,'project','start'),
(8,'project','suspend'),
(8,'project','view'),
(8,'project','updateOrder'),
(8,'project','whitelist'),
(8,'project','unbindWhielist'),
(8,'project','unlinkStakeholder'),
(8,'execution','all'),
(8,'execution','bug'),
(8,'execution','build'),
(8,'execution','burn'),
(8,'execution','doc'),
(8,'execution','dynamic'),
(8,'execution','grouptask'),
(8,'execution','importBug'),
(8,'execution','importtask'),
(8,'execution','index'),
(8,'execution','kanban'),
(8,'execution','story'),
(8,'execution','task'),
(8,'execution','team'),
(8,'execution','testtask'),
(8,'execution','tree'),
(8,'execution','view'),
(8,'projectstory','story'),
(8,'projectstory','track'),
(8,'projectstory','view'),
(8,'qa','index'),
(8,'release','browse'),
(8,'release','export'),
(8,'release','view'),
(8,'repo','blame'),
(8,'repo','browse'),
(8,'repo','diff'),
(8,'repo','download'),
(8,'repo','log'),
(8,'repo','revision'),
(8,'repo','showSyncCommit'),
(8,'repo','view'),
(8,'report','bugAssign'),
(8,'report','bugCreate'),
(8,'report','index'),
(8,'report','productSummary'),
(8,'report','projectDeviation'),
(8,'report','workload'),
(8,'search','buildForm'),
(8,'search','buildQuery'),
(8,'search','deleteQuery'),
(8,'search','index'),
(8,'search','saveQuery'),
(8,'search','select'),
(8,'story','batchToTask'),
(8,'story','bugs'),
(8,'story','cases'),
(8,'story','export'),
(8,'story','report'),
(8,'story','tasks'),
(8,'story','view'),
(8,'story','zeroCase'),
(8,'svn','apiSync'),
(8,'svn','cat'),
(8,'svn','diff'),
(8,'task','activate'),
(8,'task','assignTo'),
(8,'task','batchAssignTo'),
(8,'task','batchChangeModule'),
(8,'task','batchClose'),
(8,'task','batchCreate'),
(8,'task','batchEdit'),
(8,'task','cancel'),
(8,'task','close'),
(8,'task','confirmStoryChange'),
(8,'task','create'),
(8,'task','delete'),
(8,'task','deleteEstimate'),
(8,'task','edit'),
(8,'task','editEstimate'),
(8,'task','export'),
(8,'task','finish'),
(8,'task','pause'),
(8,'task','recordEstimate'),
(8,'task','report'),
(8,'task','restart'),
(8,'task','start'),
(8,'task','view'),
(8,'testcase','batchCaseTypeChange'),
(8,'testcase','batchChangeModule'),
(8,'testcase','batchConfirmStoryChange'),
(8,'testcase','batchCreate'),
(8,'testcase','batchDelete'),
(8,'testcase','batchEdit'),
(8,'testcase','batchReview'),
(8,'testcase','browse'),
(8,'testcase','bugs'),
(8,'testcase','confirmChange'),
(8,'testcase','confirmStoryChange'),
(8,'testcase','create'),
(8,'testcase','createBug'),
(8,'testcase','delete'),
(8,'testcase','edit'),
(8,'testcase','export'),
(8,'testcase','exportTemplet'),
(8,'testcase','groupCase'),
(8,'testcase','import'),
(8,'testcase','importFromLib'),
(8,'testcase','index'),
(8,'testcase','linkCases'),
(8,'testcase','review'),
(8,'testcase','showImport'),
(8,'testcase','view'),
(8,'testreport','browse'),
(8,'testreport','create'),
(8,'testreport','delete'),
(8,'testreport','edit'),
(8,'testreport','view'),
(8,'testsuite','browse'),
(8,'testsuite','create'),
(8,'testsuite','delete'),
(8,'testsuite','edit'),
(8,'testsuite','index'),
(8,'testsuite','linkCase'),
(8,'testsuite','unlinkCase'),
(8,'testsuite','view'),
(8,'testtask','activate'),
(8,'testtask','batchAssign'),
(8,'testtask','batchRun'),
(8,'testtask','block'),
(8,'testtask','browse'),
(8,'testtask','cases'),
(8,'testtask','close'),
(8,'testtask','create'),
(8,'testtask','delete'),
(8,'testtask','edit'),
(8,'testtask','groupCase'),
(8,'testtask','index'),
(8,'testtask','linkcase'),
(8,'testtask','report'),
(8,'testtask','results'),
(8,'testtask','runcase'),
(8,'testtask','start'),
(8,'testtask','unlinkcase'),
(8,'testtask','view'),
(8,'todo','activate'),
(8,'todo','assignTo'),
(8,'todo','batchClose'),
(8,'todo','batchCreate'),
(8,'todo','batchEdit'),
(8,'todo','batchFinish'),
(8,'todo','close'),
(8,'todo','create'),
(8,'todo','delete'),
(8,'todo','edit'),
(8,'todo','export'),
(8,'todo','finish'),
(8,'todo','import2Today'),
(8,'todo','view'),
(8,'tree','browse'),
(8,'tree','browseTask'),
(8,'tree','delete'),
(8,'tree','edit'),
(8,'tree','fix'),
(8,'tree','manageChild'),
(8,'tree','updateOrder'),
(8,'user','bug'),
(8,'user','cropAvatar'),
(8,'user','dynamic'),
(8,'user','execution'),
(8,'user','issue'),
(8,'user','profile'),
(8,'user','risk'),
(8,'user','story'),
(8,'user','task'),
(8,'user','testCase'),
(8,'user','testTask'),
(8,'user','todo'),
(8,'user','view'),
(9,'action','editComment'),
(9,'action','hideAll'),
(9,'action','hideOne'),
(9,'action','trash'),
(9,'action','undelete'),
(9,'admin','index'),
(9,'bug','browse'),
(9,'bug','export'),
(9,'bug','index'),
(9,'bug','report'),
(9,'bug','view'),
(9,'build','view'),
(9,'company','browse'),
(9,'company','dynamic'),
(9,'company','edit'),
(9,'company','index'),
(9,'company','view'),
(9,'dept','browse'),
(9,'dept','delete'),
(9,'dept','manageChild'),
(9,'dept','updateOrder'),
(9,'doc','allLibs'),
(9,'doc','browse'),
(9,'doc','create'),
(9,'doc','createLib'),
(9,'doc','delete'),
(9,'doc','deleteFile'),
(9,'doc','deleteLib'),
(9,'doc','edit'),
(9,'doc','editLib'),
(9,'doc','index'),
(9,'doc','objectLibs'),
(9,'doc','showFiles'),
(9,'doc','view'),
(9,'extension','browse'),
(9,'extension','obtain'),
(9,'extension','structure'),
(9,'file','delete'),
(9,'file','download'),
(9,'file','edit'),
(9,'file','uploadImages'),
(9,'git','apiSync'),
(9,'git','cat'),
(9,'git','diff'),
(9,'group','browse'),
(9,'index','index'),
(9,'misc','ping'),
(9,'my','calendar'),
(9,'my','team'),
(9,'my','work'),
(9,'my','contribute'),
(9,'my','changePassword'),
(9,'my','deleteContacts'),
(9,'my','dynamic'),
(9,'my','editProfile'),
(9,'my','index'),
(9,'my','manageContacts'),
(9,'my','preference'),
(9,'my','profile'),
(9,'my','project'),
(9,'my','todo'),
(9,'my','unbind'),
(9,'my','uploadAvatar'),
(9,'product','all'),
(9,'product','browse'),
(9,'product','build'),
(9,'product','dashboard'),
(9,'product','doc'),
(9,'product','dynamic'),
(9,'product','index'),
(9,'product','project'),
(9,'product','roadmap'),
(9,'product','view'),
(9,'productplan','browse'),
(9,'productplan','view'),
(9,'program','index'),
(9,'program','activate'),
(9,'program','browse'),
(9,'program','close'),
(9,'program','create'),
(9,'program','delete'),
(9,'program','edit'),
(9,'program','product'),
(9,'program','project'),
(9,'program','stakeholder'),
(9,'program','start'),
(9,'program','suspend'),
(9,'project','createGuide'),
(9,'project','createStakeholder'),
(9,'project','index'),
(9,'project','activate'),
(9,'project','addWhitelist'),
(9,'project','browse'),
(9,'project','close'),
(9,'project','copyGroup'),
(9,'project','create'),
(9,'project','createGroup'),
(9,'project','delete'),
(9,'project','edit'),
(9,'project','editGroup'),
(9,'project','group'),
(9,'project','manageGroupMember'),
(9,'project','manageMembers'),
(9,'project','managePriv'),
(9,'project','manageProducts'),
(9,'project','manageView'),
(9,'project','programTitle'),
(9,'project','start'),
(9,'project','suspend'),
(9,'project','view'),
(9,'project','updateOrder'),
(9,'project','whitelist'),
(9,'project','unbindWhielist'),
(9,'project','unlinkStakeholder'),
(9,'execution','all'),
(9,'execution','browse'),
(9,'execution','bug'),
(9,'execution','build'),
(9,'execution','burn'),
(9,'execution','computeBurn'),
(9,'execution','doc'),
(9,'execution','dynamic'),
(9,'execution','grouptask'),
(9,'execution','index'),
(9,'execution','kanban'),
(9,'execution','story'),
(9,'execution','task'),
(9,'execution','team'),
(9,'execution','tree'),
(9,'execution','view'),
(9,'projectstory','linkStory'),
(9,'projectstory','story'),
(9,'projectstory','track'),
(9,'projectstory','view'),
(9,'qa','index'),
(9,'release','browse'),
(9,'release','export'),
(9,'release','view'),
(9,'repo','blame'),
(9,'repo','browse'),
(9,'repo','diff'),
(9,'repo','download'),
(9,'repo','log'),
(9,'repo','revision'),
(9,'repo','showSyncCommit'),
(9,'repo','view'),
(9,'report','bugAssign'),
(9,'report','bugCreate'),
(9,'report','index'),
(9,'report','productSummary'),
(9,'report','projectDeviation'),
(9,'report','workload'),
(9,'search','buildForm'),
(9,'search','buildQuery'),
(9,'search','deleteQuery'),
(9,'search','index'),
(9,'search','saveQuery'),
(9,'search','select'),
(9,'story','bugs'),
(9,'story','cases'),
(9,'story','export'),
(9,'story','report'),
(9,'story','review'),
(9,'story','tasks'),
(9,'story','view'),
(9,'story','zeroCase'),
(9,'svn','apiSync'),
(9,'svn','cat'),
(9,'svn','diff'),
(9,'task','deleteEstimate'),
(9,'task','editEstimate'),
(9,'task','export'),
(9,'task','recordEstimate'),
(9,'task','report'),
(9,'task','view'),
(9,'testcase','browse'),
(9,'testcase','bugs'),
(9,'testcase','export'),
(9,'testcase','groupCase'),
(9,'testcase','index'),
(9,'testcase','view'),
(9,'testsuite','browse'),
(9,'testsuite','index'),
(9,'testsuite','view'),
(9,'testtask','browse'),
(9,'testtask','cases'),
(9,'testtask','groupCase'),
(9,'testtask','index'),
(9,'testtask','results'),
(9,'testtask','view'),
(9,'todo','activate'),
(9,'todo','assignTo'),
(9,'todo','batchClose'),
(9,'todo','batchCreate'),
(9,'todo','batchEdit'),
(9,'todo','batchFinish'),
(9,'todo','close'),
(9,'todo','create'),
(9,'todo','delete'),
(9,'todo','edit'),
(9,'todo','export'),
(9,'todo','finish'),
(9,'todo','import2Today'),
(9,'todo','view'),
(9,'user','batchCreate'),
(9,'user','batchEdit'),
(9,'user','bug'),
(9,'user','create'),
(9,'user','cropAvatar'),
(9,'user','delete'),
(9,'user','dynamic'),
(9,'user','edit'),
(9,'user','execution'),
(9,'user','issue'),
(9,'user','profile'),
(9,'user','risk'),
(9,'user','story'),
(9,'user','task'),
(9,'user','testCase'),
(9,'user','testTask'),
(9,'user','todo'),
(9,'user','unbind'),
(9,'user','unlock'),
(9,'user','view'),
(10,'action','editComment'),
(10,'bug','activate'),
(10,'bug','batchChangeModule'),
(10,'bug','browse'),
(10,'bug','close'),
(10,'bug','create'),
(10,'bug','edit'),
(10,'bug','index'),
(10,'bug','linkBugs'),
(10,'bug','report'),
(10,'bug','view'),
(10,'build','view'),
(10,'company','browse'),
(10,'company','dynamic'),
(10,'company','index'),
(10,'company','view'),
(10,'doc','allLibs'),
(10,'doc','browse'),
(10,'doc','index'),
(10,'doc','objectLibs'),
(10,'doc','showFiles'),
(10,'doc','view'),
(10,'file','download'),
(10,'index','index'),
(10,'misc','ping'),
(10,'my','calendar'),
(10,'my','team'),
(10,'my','work'),
(10,'my','contribute'),
(10,'my','changePassword'),
(10,'my','dynamic'),
(10,'my','editProfile'),
(10,'my','index'),
(10,'my','preference'),
(10,'my','profile'),
(10,'my','todo'),
(10,'my','unbind'),
(10,'my','uploadAvatar'),
(10,'product','all'),
(10,'product','browse'),
(10,'product','build'),
(10,'product','dashboard'),
(10,'product','doc'),
(10,'product','dynamic'),
(10,'product','index'),
(10,'product','roadmap'),
(10,'product','view'),
(10,'productplan','browse'),
(10,'productplan','view'),
(10,'execution','all'),
(10,'execution','browse'),
(10,'execution','bug'),
(10,'execution','build'),
(10,'execution','burn'),
(10,'execution','doc'),
(10,'execution','dynamic'),
(10,'execution','grouptask'),
(10,'execution','index'),
(10,'execution','kanban'),
(10,'execution','story'),
(10,'execution','task'),
(10,'execution','team'),
(10,'execution','testtask'),
(10,'execution','tree'),
(10,'execution','view'),
(10,'projectstory','story'),
(10,'projectstory','track'),
(10,'projectstory','view'),
(10,'qa','index'),
(10,'release','browse'),
(10,'release','view'),
(10,'repo','blame'),
(10,'repo','browse'),
(10,'repo','diff'),
(10,'repo','download'),
(10,'repo','log'),
(10,'repo','revision'),
(10,'repo','showSyncCommit'),
(10,'repo','view'),
(10,'report','bugAssign'),
(10,'report','bugCreate'),
(10,'report','index'),
(10,'report','productSummary'),
(10,'report','projectDeviation'),
(10,'report','workload'),
(10,'search','buildForm'),
(10,'search','buildQuery'),
(10,'search','deleteQuery'),
(10,'search','index'),
(10,'search','saveQuery'),
(10,'story','bugs'),
(10,'story','cases'),
(10,'story','tasks'),
(10,'story','view'),
(10,'task','deleteEstimate'),
(10,'task','editEstimate'),
(10,'task','recordEstimate'),
(10,'task','view'),
(10,'testsuite','browse'),
(10,'testsuite','index'),
(10,'testsuite','view'),
(10,'todo','activate'),
(10,'todo','assignTo'),
(10,'todo','batchClose'),
(10,'todo','batchCreate'),
(10,'todo','batchEdit'),
(10,'todo','batchFinish'),
(10,'todo','close'),
(10,'todo','create'),
(10,'todo','delete'),
(10,'todo','edit'),
(10,'todo','export'),
(10,'todo','finish'),
(10,'todo','import2Today'),
(10,'todo','view'),
(10,'user','bug'),
(10,'user','cropAvatar'),
(10,'user','dynamic'),
(10,'user','execution'),
(10,'user','issue'),
(10,'user','profile'),
(10,'user','risk'),
(10,'user','story'),
(10,'user','task'),
(10,'user','testCase'),
(10,'user','testTask'),
(10,'user','todo'),
(10,'user','view'),
(11,'bug','browse'),
(11,'bug','index'),
(11,'bug','report'),
(11,'bug','view'),
(11,'build','view'),
(11,'company','browse'),
(11,'company','dynamic'),
(11,'company','index'),
(11,'company','view'),
(11,'doc','allLibs'),
(11,'doc','browse'),
(11,'doc','index'),
(11,'doc','objectLibs'),
(11,'doc','showFiles'),
(11,'doc','view'),
(11,'file','download'),
(11,'git','cat'),
(11,'git','diff'),
(11,'group','browse'),
(11,'index','index'),
(11,'misc','ping'),
(11,'my','index'),
(11,'my','preference'),
(11,'my','profile'),
(11,'my','uploadAvatar'),
(11,'product','all'),
(11,'product','browse'),
(11,'product','build'),
(11,'product','dashboard'),
(11,'product','doc'),
(11,'product','dynamic'),
(11,'product','index'),
(11,'product','roadmap'),
(11,'product','view'),
(11,'productplan','browse'),
(11,'productplan','view'),
(11,'execution','all'),
(11,'execution','browse'),
(11,'execution','bug'),
(11,'execution','build'),
(11,'execution','burn'),
(11,'execution','doc'),
(11,'execution','dynamic'),
(11,'execution','grouptask'),
(11,'execution','index'),
(11,'execution','kanban'),
(11,'execution','story'),
(11,'execution','task'),
(11,'execution','team'),
(11,'execution','testtask'),
(11,'execution','tree'),
(11,'execution','treestory'),
(11,'execution','treetask'),
(11,'execution','view'),
(11,'projectstory','story'),
(11,'projectstory','track'),
(11,'projectstory','view'),
(11,'qa','index'),
(11,'release','browse'),
(11,'release','view'),
(11,'report','bugAssign'),
(11,'report','bugCreate'),
(11,'report','index'),
(11,'report','productSummary'),
(11,'report','projectDeviation'),
(11,'report','workload'),
(11,'search','buildForm'),
(11,'search','buildQuery'),
(11,'story','bugs'),
(11,'story','cases'),
(11,'story','tasks'),
(11,'story','view'),
(11,'svn','cat'),
(11,'svn','diff'),
(11,'task','recordEstimate'),
(11,'task','view'),
(11,'testcase','browse'),
(11,'testcase','bugs'),
(11,'testcase','groupCase'),
(11,'testcase','index'),
(11,'testcase','view'),
(11,'testsuite','browse'),
(11,'testsuite','index'),
(11,'testsuite','view'),
(11,'testtask','browse'),
(11,'testtask','cases'),
(11,'testtask','groupCase'),
(11,'testtask','index'),
(11,'testtask','results'),
(11,'testtask','view'),
(11,'user','bug'),
(11,'user','cropAvatar'),
(11,'user','dynamic'),
(11,'user','execution'),
(11,'user','issue'),
(11,'user','profile'),
(11,'user','project'),
(11,'user','risk'),
(11,'user','story'),
(11,'user','task'),
(11,'user','testCase'),
(11,'user','testTask'),
(11,'user','todo'),
(11,'user','view'),
(12,'my','limited');

REPLACE INTO `zt_lang` (`lang`, `module`, `section`, `key`, `value`, `system`) VALUES
('zh-cn', 'custom', 'URSRList', '1', '{\"SRName\":\"\\u8f6f\\u4ef6\\u9700\\u6c42\",\"URName\":\"\\u7528\\u6237\\u9700\\u6c42\"}', '1'),
('zh-cn', 'custom', 'URSRList', '2', '{\"SRName\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"URName\":\"\\u7528\\u6237\\u9700\\u6c42\"}', '1'),
('zh-cn', 'custom', 'URSRList', '3', '{\"SRName\":\"\\u8f6f\\u9700\",\"URName\":\"\\u7528\\u9700\"}', '1'),
('zh-cn', 'custom', 'URSRList', '4', '{\"SRName\":\"\\u6545\\u4e8b\",\"URName\":\"\\u53f2\\u8bd7\"}', '1'),
('zh-cn', 'custom', 'URSRList', '5', '{\"SRName\":\"\\u9700\\u6c42\",\"URName\":\"\\u7528\\u6237\\u9700\\u6c42\"}', '1'),
('en', 'custom', 'URSRList', '1', '{\"SRName\":\"Story\",\"URName\":\"Epic\"}', '0'),
('en', 'custom', 'URSRList', '2', '{\"SRName\":\"Story\",\"URName\":\"Requirement\"}', '0');

INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'custom', '', 'hourPoint',   '0');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'common', '', 'CRProduct',   '1');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'common', '', 'CRExecution', '1');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'custom', '', 'URSR', '2');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'common', 'global', 'mode', 'new');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'project', '', 'unitList', 'CNY,USD');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'project', '', 'defaultCurrency', 'CNY');
-- DROP TABLE IF EXISTS `zt_im_chat`;
CREATE TABLE IF NOT EXISTS `zt_im_chat` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `gid` char(40) NOT NULL DEFAULT '',
  `name` varchar(60) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT 'group',
  `admins` varchar(255) NOT NULL DEFAULT '',
  `committers` varchar(255) NOT NULL DEFAULT '',
  `subject` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `public` enum('0', '1') NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastActiveTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `dismissDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `gid` (`gid`),
  KEY `name` (`name`),
  KEY `type` (`type`),
  KEY `public` (`public`),
  KEY `createdBy` (`createdBy`),
  KEY `editedBy` (`editedBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_chatuser`;
CREATE TABLE IF NOT EXISTS `zt_im_chatuser` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `cgid` char(40) NOT NULL DEFAULT '',
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `order` smallint(5) NOT NULL DEFAULT 0,
  `star` enum('0', '1') NOT NULL DEFAULT '0',
  `hide` enum('0', '1') NOT NULL DEFAULT '0',
  `mute` enum('0', '1') NOT NULL DEFAULT '0',
  `freeze` enum('0', '1') NOT NULL DEFAULT '0',
  `join` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `quit` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `category` varchar(40) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `cgid` (`cgid`),
  KEY `user` (`user`),
  KEY `order` (`order`),
  KEY `star` (`star`),
  KEY `hide` (`hide`),
  UNIQUE KEY `chatuser` (`cgid`, `user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_client`;
CREATE TABLE IF NOT EXISTS `zt_im_client` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` char(30) NOT NULL DEFAULT '',
  `desc` varchar(100) NOT NULL DEFAULT '',
  `changeLog` text NOT NULL,
  `strategy` varchar(10) NOT NULL DEFAULT '',
  `downloads` text NOT NULL,
  `createdDate` datetime NOT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `status` enum('released','wait') NOT NULL DEFAULT 'wait',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_message`;
CREATE TABLE IF NOT EXISTS `zt_im_message` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `gid` char(40) NOT NULL DEFAULT '',
  `cgid` char(40) NOT NULL DEFAULT '',
  `user` varchar(30) NOT NULL DEFAULT '',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `order` bigint(8) unsigned NOT NULL,
  `type` enum('normal', 'broadcast', 'notify') NOT NULL DEFAULT 'normal',
  `content` text NOT NULL DEFAULT '',
  `contentType` enum('text', 'plain', 'emotion', 'image', 'file', 'object', 'code') NOT NULL DEFAULT 'text',
  `data` text NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mgid` (`gid`),
  KEY `mcgid` (`cgid`),
  KEY `muser` (`user`),
  KEY `mtype` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_messagestatus`;
CREATE TABLE IF NOT EXISTS `zt_im_messagestatus` (
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `message` int(11) unsigned NOT NULL,
  `status` enum('waiting','sent','readed','deleted') NOT NULL DEFAULT 'waiting',
  UNIQUE KEY `user` (`user`,`message`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_queue`;
CREATE TABLE IF NOT EXISTS `zt_im_queue` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `type` char(30) NOT NULL,
  `content` text NOT NULL,
  `addDate` datetime NOT NULL,
  `processDate` datetime NOT NULL,
  `result` text NOT NULL,
  `status` char(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_conference`;
CREATE TABLE IF NOT EXISTS `zt_im_conference` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `rid` char(24) NOT NULL DEFAULT '',
  `cgid` char(40) NOT NULL DEFAULT '',
  `status` enum('closed','open') NOT NULL DEFAULT 'closed',
  `participants` text NOT NULL,
  `openedBy` mediumint(8) NOT NULL DEFAULT 0,
  `openedDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_conferenceaction`;
CREATE TABLE IF NOT EXISTS `zt_im_conferenceaction` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `rid` char(24) NOT NULL DEFAULT '',
  `type` enum('create','join','leave','close') NOT NULL DEFAULT 'create',
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

ALTER TABLE `zt_file` CHANGE `pathname` `pathname` char(100) NOT NULL;
ALTER TABLE `zt_user` ADD `clientStatus` enum('online', 'away', 'busy', 'offline') NOT NULL DEFAULT 'offline';
ALTER TABLE `zt_user` ADD `clientLang` varchar(10) NOT NULL DEFAULT 'zh-cn';
ALTER TABLE `zt_effort` DROP INDEX `user`;
ALTER TABLE `zt_effort` DROP `user`;
ALTER TABLE `zt_effort` DROP `todo`;
ALTER TABLE `zt_effort` DROP `type`;
ALTER TABLE `zt_effort` DROP `idvalue`;
ALTER TABLE `zt_effort` DROP `name`;
ALTER TABLE `zt_effort` DROP `desc`;
ALTER TABLE `zt_effort` DROP `status`;

ALTER TABLE `zt_effort` ADD `objectType` varchar(30) NOT NULL AFTER `id`;
ALTER TABLE `zt_effort` ADD `objectID` mediumint(8) unsigned NOT NULL AFTER `objectType`;
ALTER TABLE `zt_effort` ADD `product` varchar(255) NOT NULL AFTER `objectID`;
ALTER TABLE `zt_effort` ADD `project` mediumint(8) unsigned NOT NULL AFTER `product`;
ALTER TABLE `zt_effort` ADD `execution` mediumint(8) unsigned NOT NULL AFTER `project`;
ALTER TABLE `zt_effort` ADD `account` varchar(30) NOT NULL AFTER `execution`;
ALTER TABLE `zt_effort` ADD `work` text COLLATE 'utf8_general_ci' NULL AFTER `account`;
ALTER TABLE `zt_effort` ADD `left` float NOT NULL AFTER `date`;
ALTER TABLE `zt_effort` ADD `consumed` float NOT NULL AFTER `left`;
ALTER TABLE `zt_effort` CHANGE `begin` `begin` smallint(4) unsigned zerofill NOT NULL AFTER `consumed`;
ALTER TABLE `zt_effort` CHANGE `end` `end` smallint(4) unsigned zerofill NOT NULL AFTER `begin`;
ALTER TABLE `zt_effort` ADD `deleted` enum('0','1') NOT NULL DEFAULT '0' AFTER `end`;
ALTER TABLE `zt_effort` ADD INDEX `execution` (`execution`);
ALTER TABLE `zt_effort` ADD INDEX `objectID` (`objectID`);
ALTER TABLE `zt_effort` ADD INDEX `date` (`date`);
ALTER TABLE `zt_effort` ADD INDEX `account` (`account`);

ALTER TABLE `zt_action` ADD  `efforted` BOOL NOT NULL DEFAULT  '0';
INSERT INTO `zt_cron` (`m`, `h`, `dom`, `mon`, `dow`, `command`, `remark`, `type`, `buildin`, `status`, `lastTime`) VALUES ('30', '23', '*', '*', '*', 'moduleName=execution&methodName=computeTaskEffort', '计算任务剩余工时', 'zentao', '1', 'normal', '0000-00-00 00:00:00');
INSERT INTO `zt_cron` (`m`, `h`, `dom`, `mon`, `dow`, `command`, `remark`, `type`, `buildin`, `status`, `lastTime`) VALUES ('30', '7', '*', '*', '*', 'moduleName=effort&methodName=remindNotRecord', '提醒录入日志', 'zentao', '1', 'stop', '0000-00-00 00:00:00');
REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'company', 'effort'),
(2, 'company', 'effort'),
(3, 'company', 'effort'),
(4, 'company', 'effort'),
(5, 'company', 'effort'),
(6, 'company', 'effort'),
(7, 'company', 'effort'),
(8, 'company', 'effort'),
(9, 'company', 'effort'),
(10, 'company', 'effort'),
(1, 'effort', 'export'),
(2, 'effort', 'export'),
(3, 'effort', 'export'),
(4, 'effort', 'export'),
(5, 'effort', 'export'),
(6, 'effort', 'export'),
(7, 'effort', 'export'),
(8, 'effort', 'export'),
(9, 'effort', 'export'),
(10, 'effort', 'export'),
(1, 'effort', 'view'),
(2, 'effort', 'view'),
(3, 'effort', 'view'),
(4, 'effort', 'view'),
(5, 'effort', 'view'),
(6, 'effort', 'view'),
(7, 'effort', 'view'),
(8, 'effort', 'view'),
(9, 'effort', 'view'),
(10, 'effort', 'view'),
(1, 'effort', 'edit'),
(2, 'effort', 'edit'),
(3, 'effort', 'edit'),
(4, 'effort', 'edit'),
(5, 'effort', 'edit'),
(6, 'effort', 'edit'),
(7, 'effort', 'edit'),
(8, 'effort', 'edit'),
(9, 'effort', 'edit'),
(10, 'effort', 'edit'),
(1, 'effort', 'batchCreate'),
(2, 'effort', 'batchCreate'),
(3, 'effort', 'batchCreate'),
(4, 'effort', 'batchCreate'),
(5, 'effort', 'batchCreate'),
(6, 'effort', 'batchCreate'),
(7, 'effort', 'batchCreate'),
(8, 'effort', 'batchCreate'),
(9, 'effort', 'batchCreate'),
(10, 'effort', 'batchCreate'),
(1, 'effort', 'delete'),
(2, 'effort', 'delete'),
(3, 'effort', 'delete'),
(4, 'effort', 'delete'),
(5, 'effort', 'delete'),
(6, 'effort', 'delete'),
(7, 'effort', 'delete'),
(8, 'effort', 'delete'),
(9, 'effort', 'delete'),
(10, 'effort', 'delete'),
(1, 'effort', 'createForObject'),
(2, 'effort', 'createForObject'),
(3, 'effort', 'createForObject'),
(4, 'effort', 'createForObject'),
(5, 'effort', 'createForObject'),
(6, 'effort', 'createForObject'),
(7, 'effort', 'createForObject'),
(8, 'effort', 'createForObject'),
(9, 'effort', 'createForObject'),
(10, 'effort', 'createForObject'),
(1, 'my', 'effort'),
(2, 'my', 'effort'),
(3, 'my', 'effort'),
(4, 'my', 'effort'),
(5, 'my', 'effort'),
(6, 'my', 'effort'),
(7, 'my', 'effort'),
(8, 'my', 'effort'),
(9, 'my', 'effort'),
(10, 'my', 'effort'),
(1, 'execution', 'effort'),
(2, 'execution', 'effort'),
(3, 'execution', 'effort'),
(4, 'execution', 'effort'),
(5, 'execution', 'effort'),
(6, 'execution', 'effort'),
(7, 'execution', 'effort'),
(8, 'execution', 'effort'),
(9, 'execution', 'effort'),
(10, 'execution', 'effort'),
(1, 'user', 'effort');
REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'todo', 'calendar'),
(2, 'todo', 'calendar'),
(3, 'todo', 'calendar'),
(4, 'todo', 'calendar'),
(5, 'todo', 'calendar'),
(6, 'todo', 'calendar'),
(7, 'todo', 'calendar'),
(8, 'todo', 'calendar'),
(9, 'todo', 'calendar'),
(10, 'todo', 'calendar'),
(1, 'effort', 'calendar'),
(2, 'effort', 'calendar'),
(3, 'effort', 'calendar'),
(4, 'effort', 'calendar'),
(5, 'effort', 'calendar'),
(6, 'effort', 'calendar'),
(7, 'effort', 'calendar'),
(8, 'effort', 'calendar'),
(9, 'effort', 'calendar'),
(10, 'effort', 'calendar'),
(1, 'execution', 'calendar'),
(2, 'execution', 'calendar'),
(3, 'execution', 'calendar'),
(4, 'execution', 'calendar'),
(5, 'execution', 'calendar'),
(6, 'execution', 'calendar'),
(7, 'execution', 'calendar'),
(8, 'execution', 'calendar'),
(9, 'execution', 'calendar'),
(10, 'execution', 'calendar'),
(1, 'user', 'effortcalendar'),
(2, 'user', 'effortcalendar'),
(3, 'user', 'effortcalendar'),
(4, 'user', 'effortcalendar'),
(5, 'user', 'effortcalendar'),
(6, 'user', 'effortcalendar'),
(7, 'user', 'effortcalendar'),
(8, 'user', 'effortcalendar'),
(9, 'user', 'effortcalendar'),
(10, 'user', 'effortcalendar'),
(1, 'user', 'todocalendar'),
(2, 'user', 'todocalendar'),
(3, 'user', 'todocalendar'),
(4, 'user', 'todocalendar'),
(5, 'user', 'todocalendar'),
(6, 'user', 'todocalendar'),
(7, 'user', 'todocalendar'),
(8, 'user', 'todocalendar'),
(9, 'user', 'todocalendar'),
(10, 'user', 'todocalendar');
REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'bug', 'exportTemplet'),
(4, 'bug', 'exportTemplet'),
(1, 'bug', 'import'),
(4, 'bug', 'import'),
(1, 'bug', 'showImport'),
(4, 'bug', 'showImport'),
(1, 'story', 'exportTemplet'),
(4, 'story', 'exportTemplet'),
(1, 'story', 'import'),
(4, 'story', 'import'),
(1, 'story', 'showImport'),
(4, 'story', 'showImport'),
(1, 'task', 'exportTemplet'),
(4, 'task', 'exportTemplet'),
(1, 'task', 'import'),
(4, 'task', 'import'),
(1, 'task', 'showImport'),
(4, 'task', 'showImport');
 -- DROP TABLE IF EXISTS `zt_relationoftasks`;
CREATE TABLE IF NOT EXISTS `zt_relationoftasks` (
  `id` MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `execution` MEDIUMINT(8) UNSIGNED NOT NULL ,
  `pretask` MEDIUMINT(8) UNSIGNED NOT NULL ,
  `condition` ENUM( 'begin', 'end' ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
  `task` MEDIUMINT( 8 ) UNSIGNED NOT NULL ,
  `action` ENUM( 'begin', 'end' ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
  PRIMARY KEY (`id`),
  KEY `relationoftasks` (`execution`,`task`)
) ENGINE = MYISAM CHARACTER SET utf8 COLLATE utf8_general_ci;
REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'project', 'deleterelation'),
(1, 'project', 'gantt'),
(2, 'project', 'gantt'),
(3, 'project', 'gantt'),
(4, 'project', 'gantt'),
(5, 'project', 'gantt'),
(6, 'project', 'gantt'),
(7, 'project', 'gantt'),
(8, 'project', 'gantt'),
(9, 'project', 'gantt'),
(10, 'project', 'gantt'),
(1, 'project', 'relation'),
(2, 'project', 'relation'),
(3, 'project', 'relation'),
(4, 'project', 'relation'),
(5, 'project', 'relation'),
(6, 'project', 'relation'),
(7, 'project', 'relation'),
(8, 'project', 'relation'),
(9, 'project', 'relation'),
(10, 'project', 'relation');
REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'report', 'build'),
(2, 'report', 'build'),
(3, 'report', 'build'),
(4, 'report', 'build'),
(5, 'report', 'build'),
(6, 'report', 'build'),
(7, 'report', 'build'),
(8, 'report', 'build'),
(9, 'report', 'build'),
(10, 'report', 'build'),
(1, 'report', 'testcase'),
(2, 'report', 'testcase'),
(3, 'report', 'testcase'),
(4, 'report', 'testcase'),
(5, 'report', 'testcase'),
(6, 'report', 'testcase'),
(7, 'report', 'testcase'),
(8, 'report', 'testcase'),
(9, 'report', 'testcase'),
(10, 'report', 'testcase'),
(1, 'report', 'workSummary'),
(2, 'report', 'workSummary'),
(3, 'report', 'workSummary'),
(4, 'report', 'workSummary'),
(5, 'report', 'workSummary'),
(6, 'report', 'workSummary'),
(7, 'report', 'workSummary'),
(8, 'report', 'workSummary'),
(9, 'report', 'workSummary'),
(10, 'report', 'workSummary');
ALTER TABLE `zt_user` ADD `ldap` CHAR(30) NOT NULL AFTER `ranzhi`;

-- DROP TABLE IF EXISTS `zt_report`;
CREATE TABLE IF NOT EXISTS `zt_report` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `code` varchar(100) NOT NULL,
  `name` text NOT NULL,
  `module` varchar(100) NOT NULL,
  `sql` text NOT NULL,
  `vars` text NOT NULL,
  `langs` text NOT NULL,
  `params` text NOT NULL,
  `step` tinyint(1) NOT NULL DEFAULT '2',
  `desc` text NOT NULL,
  `addedBy` char(30) NOT NULL,
  `addedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE OR REPLACE VIEW `ztv_executionsummary` AS select `zt_task`.`execution` AS `execution`,sum(if((`zt_task`.`parent` >= '0'),`zt_task`.`estimate`,0)) AS `estimate`,sum(if((`zt_task`.`parent` >= '0'),`zt_task`.`consumed`,0)) AS `consumed`,sum(if(((`zt_task`.`status` <> 'cancel') and (`zt_task`.`status` <> 'closed') and (`zt_task`.`parent` >= '0')),`zt_task`.`left`,0)) AS `left`,count(0) AS `number`,sum(if(((`zt_task`.`status` <> 'done') and (`zt_task`.`status` <> 'closed')),1,0)) AS `undone`,sum((if((`zt_task`.`parent` >= '0'),`zt_task`.`consumed`,0) + if(((`zt_task`.`status` <> 'cancel') and (`zt_task`.`status` <> 'closed') and (`zt_task`.`parent` >= '0')),`zt_task`.`left`,0))) AS `totalReal` from `zt_task` where (`zt_task`.`deleted` = '0') group by `zt_task`.`execution`;
CREATE OR REPLACE VIEW `ztv_projectsummary` AS select `zt_task`.`project` AS `project`,sum(if((`zt_task`.`parent` >= '0'),`zt_task`.`estimate`,0)) AS `estimate`,sum(if((`zt_task`.`parent` >= '0'),`zt_task`.`consumed`,0)) AS `consumed`,sum(if(((`zt_task`.`status` <> 'cancel') and (`zt_task`.`status` <> 'closed') and (`zt_task`.`parent` >= '0')),`zt_task`.`left`,0)) AS `left`,count(0) AS `number`,sum(if(((`zt_task`.`status` <> 'done') and (`zt_task`.`status` <> 'closed')),1,0)) AS `undone`,sum((if((`zt_task`.`parent` >= '0'),`zt_task`.`consumed`,0) + if(((`zt_task`.`status` <> 'cancel') and (`zt_task`.`status` <> 'closed') and (`zt_task`.`parent` >= '0')),`zt_task`.`left`,0))) AS `totalReal` from `zt_task` where (`zt_task`.`deleted` = '0') group by `zt_task`.`project`;
CREATE OR REPLACE VIEW `ztv_projectstories` AS select `t1`.`project` AS `execution`,count('*') AS `stories`,sum(if((`t2`.`status` = 'closed'),0,1)) AS `undone` from ((`zt_projectstory` `t1` left join `zt_story` `t2` on((`t1`.`story` = `t2`.`id`))) left join `zt_project` `t3` on((`t1`.`project` = `t3`.`id`))) where ((`t2`.`deleted` = '0') and (`t3`.`type` in ('sprint','stage'))) group by `t1`.`project`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `ztv_projectteams` AS select `zt_team`.`root` AS `execution`,count('*') AS `teams` from `zt_team` where (`zt_team`.`type` = 'execution') group by `zt_team`.`root`;
CREATE OR REPLACE VIEW `ztv_projectbugs` AS select `zt_bug`.`execution` AS `execution`,count(0) AS `bugs`,sum(if((`zt_bug`.`resolution` = ''),0,1)) AS `resolutions`,sum(if((`zt_bug`.`severity` <= 2),1,0)) AS `seriousBugs` from `zt_bug` where (`zt_bug`.`deleted` = '0') group by `zt_bug`.`execution`;
CREATE OR REPLACE VIEW `ztv_productbugs` AS select `zt_bug`.`product` AS `product`,count(0) AS `bugs`,sum(if((`zt_bug`.`resolution` = ''),0,1)) AS `resolutions`,sum(if((`zt_bug`.`severity` <= 2),1,0)) AS `seriousBugs` from `zt_bug` where (`zt_bug`.`deleted` = '0') group by `zt_bug`.`product`;
CREATE OR REPLACE VIEW `ztv_productstories` AS select `zt_story`.`product` AS `product`,count('*') AS `stories`,sum(if((`zt_story`.`status` = 'closed'),0,1)) AS `undone` from `zt_story` where (`zt_story`.`deleted` = '0') group by `zt_story`.`product`;
CREATE OR REPLACE VIEW `ztv_dayuserlogin` AS select count(*) AS `userlogin`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'user') and (`zt_action`.`action` = 'login')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_dayeffort` AS select round(sum(`zt_effort`.`consumed`),1) AS `consumed`,`zt_effort`.`date` AS `date` from `zt_effort` group by `zt_effort`.`date`;
CREATE OR REPLACE VIEW `ztv_daystoryopen` AS select count(*) AS `storyopen`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'story') and (`zt_action`.`action` = 'opened')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_daystoryclose` AS select count(*) AS `storyclose`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'story') and (`zt_action`.`action` = 'closed')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_daytaskopen` AS select count(*) AS `taskopen`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'task') and (`zt_action`.`action` = 'opened')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_daytaskfinish` AS select count(*) AS `taskfinish`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'task') and (`zt_action`.`action` = 'finished')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_daybugopen` AS select count(*) AS `bugopen`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'bug') and (`zt_action`.`action` = 'opened')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_daybugresolve` AS select count(*) AS `bugresolve`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'bug') and (`zt_action`.`action` = 'resolved')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_dayactions` AS select count(*) AS `actions`,left(`zt_action`.`date`,10) AS `day` from `zt_action` group by left(`zt_action`.`date`,10);
REPLACE INTO `zt_report` (`code`, `name`, `module`, `sql`, `vars`, `langs`, `params`, `step`, `desc`, `addedBy`, `addedDate`) VALUES
('product-invest',       '{\"zh-cn\":\"\\u4ea7\\u54c1\\u6295\\u5165\\u8868\",\"zh-tw\":\"\\u7522\\u54c1\\u6295\\u5165\\u8868\",\"en\":\"Product Investment\"}',  ',product',     'select t1.id,t1.name,1 as projects, round(t3.consumed,2) as consumed from TABLE_PRODUCT as t1\r\n left join TABLE_PROJECTPRODUCT as t2 on t1.id=t2.product\r\n left join ztv_projectsummary as t3 on t2.project=t3.project\r\n left join TABLE_PROJECT as t4 on t2.project=t4.id\r\n left join TABLE_PROGRAM as t5 on t1.program=t5.id\r\n where t1.deleted=\'0\' and t4.deleted=\'0\' and t4.type=\'project\'\r\norder by t5.`order` asc, t1.line desc, t1.`order` asc',      '',     '{\"projects\":{\"zh-cn\":\"\\u9879\\u76ee\\u6570\",\"zh-tw\":\"\\u9879\\u76ee\\u6570\",\"en\":\"Projects\"},\"consumed\":{\"zh-cn\":\"\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\",\"zh-tw\":\"\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\",\"en\":\"Cost(h)\"}}',   '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"projects\",\"consumed\"],\"reportType\":[\"sum\",\"sum\"],\"sumAppend\":[\"projects\",\"consumed\"]}', 2,      '{\"zh-cn\":\"\\u5217\\u51fa\\u6bcf\\u4e2a\\u4ea7\\u54c1\\u7684\\u9879\\u76ee\\u603b\\u6570\\uff0c\\u5df2\\u7ecf\\u6d88\\u8017\\u7684\\u5de5\\u65f6\\u3002\",\"zh-tw\":\"\\u5217\\u51fa\\u6bcf\\u500b\\u7522\\u54c1\\u7684\\u9805\\u76ee\\u7e3d\\u6578\\uff0c\\u5df2\\u7d93\\u6d88\\u8017\\u7684\\u5de5\\u6642\\u3002 \",\"en\":\"Number of projects and consumed hours.\"}',   'admin',        '2015-07-20 14:21:30'),
('product-progress',     '{\"zh-cn\":\"\\u4ea7\\u54c1\\u5b8c\\u6210\\u5ea6\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u7522\\u54c1\\u5b8c\\u6210\\u5ea6\\u7d71\\u8a08\\u8868\",\"en\":\"Product Progress\"}',  ',product',     'select t1.*,t2.name, (case when t1.status = \'closed\' or t1.stage = \'released\' then 1 else 0 end) as done, 1 as count from TABLE_STORY as t1 \r\nleft join TABLE_PRODUCT as t2 on t1.product=t2.id \r\nleft join TABLE_PROGRAM as t3 on t2.program=t3.id \r\nwhere t1.deleted=\'0\' and t2.deleted=\'0\'\r\norder by t3.`order` asc, t2.line desc, t2.`order` asc', '',     '{\"count\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"done\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u6570\",\"en\":\"Done\"}}',  '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"count\",\"done\"],\"reportType\":[\"sum\",\"sum\"],\"sumAppend\":[\"count\",\"done\"],\"percent\":{\"1\":\"1\"},\"contrast\":{\"1\":\"count\"},\"showAlone\":{\"1\":\"1\"}}',  2,      '{\"zh-cn\":\"\\u6309\\u7167\\u4ea7\\u54c1\\u5217\\u51fa\\u9700\\u6c42\\u603b\\u6570\\uff0c\\u5b8c\\u6210\\u7684\\u603b\\u6570(\\u72b6\\u6001\\u662f\\u5173\\u95ed\\uff0c\\u6216\\u8005\\u7814\\u53d1\\u9636\\u6bb5\\u662f\\u53d1\\u5e03)\\uff0c\\u5b8c\\u6210\\u7684\\u767e\\u5206\\u6bd4\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u7522\\u54c1\\u5217\\u51fa\\u9700\\u6c42\\u7e3d\\u6578\\uff0c\\u5b8c\\u6210\\u7684\\u7e3d\\u6578\\uff08\\u72c0\\u614b\\u662f\\u95dc\\u9589\\uff0c\\u6216\\u8005\\u7814\\u767c\\u968e\\u6bb5\\u662f\\u767c\\u4f48\\uff09\\uff0c\\u5b8c\\u6210\\u7684\\u767e\\u5206\\u6bd4\\u3002\",\"en\":\"Number of total stories,done stories(state is closed, or stage is released), percent of completion.\"}',     'admin',        '2015-07-21 15:07:48'),
('story-status', '{\"zh-cn\":\"\\u4ea7\\u54c1\\u9700\\u6c42\\u72b6\\u6001\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u7522\\u54c1\\u9700\\u6c42\\u72c0\\u614b\\u5206\\u4f48\\u8868\",\"en\":\"Story Status\"}',        ',product',     'select t1.*,t2.name from TABLE_STORY as t1\r\n left join TABLE_PRODUCT as t2 on t1.product=t2.id \r\nleft join TABLE_PROGRAM as t3 on t2.program=t3.id \r\nwhere t1.deleted=\'0\' and t2.deleted=\'0\'\r\norder by t3.`order` asc, t2.line desc, t2.`order` asc',      '',     '',     '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"status\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',   2,      '{\"zh-cn\":\"\\u6309\\u7167\\u4ea7\\u54c1\\u5217\\u51fa\\u9700\\u6c42\\u603b\\u6570\\uff0c\\u72b6\\u6001\\u7684\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u7522\\u54c1\\u5217\\u51fa\\u9700\\u6c42\\u7e3d\\u6578\\uff0c\\u72c0\\u614b\\u7684\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"en\":\"Total number and status distribution of stories.\"}',        'admin',        '2015-07-21 15:35:38'),
('story-stage',  '{\"zh-cn\":\"\\u4ea7\\u54c1\\u9700\\u6c42\\u9636\\u6bb5\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u7522\\u54c1\\u9700\\u6c42\\u968e\\u6bb5\\u5206\\u4f48\\u8868\",\"en\":\"Story Stage\"}', ',product',     'select t1.*,t2.name from TABLE_STORY as t1\r\n left join TABLE_PRODUCT as t2 on t1.product=t2.id \r\nleft join TABLE_PROGRAM as t3 on t2.program=t3.id \r\nwhere t1.deleted=\'0\' and t2.deleted=\'0\'\r\norder by t3.`order` asc, t2.line desc, t2.`order` asc',      '',     '',     '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"stage\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',    2,      '{\"zh-cn\":\"\\u6309\\u7167\\u4ea7\\u54c1\\u5217\\u51fa\\u9700\\u6c42\\u603b\\u6570\\uff0c\\u7814\\u53d1\\u9636\\u6bb5\\u7684\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u7522\\u54c1\\u5217\\u51fa\\u9700\\u6c42\\u7e3d\\u6578\\uff0c\\u7814\\u767c\\u968e\\u6bb5\\u7684\\u5206\\u5e03\\u60c5\\u51b5\\u3002 \",\"en\":\"Total number and stage distribution of stories \"}',    'admin',        '2015-07-21 15:38:34'),
('product-release',      '{\"zh-cn\":\"\\u4ea7\\u54c1\\u53d1\\u5e03\\u6570\\u91cf\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u7522\\u54c1\\u767c\\u4f48\\u6578\\u91cf\\u7d71\\u8a08\\u8868\",\"en\":\"Product Release\"}',     ',product',     'select t2.name, 1 as releases from TABLE_RELEASE as t1 \r\nleft join TABLE_PRODUCT as t2 on t1.product=t2.id \r\nleft join TABLE_PROGRAM as t3 on t2.program=t3.id \r\nwhere t1.deleted=\'0\' and t2.deleted=\'0\'\r\norder by t3.`order` asc, t2.line desc, t2.`order` asc',  '',     '{\"count\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"done\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u6570\",\"en\":\"Done\"}}',  '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"releases\"],\"reportType\":[\"sum\"],\"sumAppend\":[\"releases\"]}',   2,      '{\"zh-cn\":\"\\u6309\\u7167\\u4ea7\\u54c1\\u5217\\u51fa\\u53d1\\u5e03\\u7684\\u6570\\u91cf\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u7522\\u54c1\\u5217\\u51fa\\u767c\\u4f48\\u7684\\u6578\\u91cf\\u3002\",\"en\":\"Product Release.\"}',  'admin',        '2015-07-21 16:00:52'),
('task-status',  '{\"zh-cn\":\"\\u4efb\\u52a1\\u72b6\\u6001\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\",\"en\":\"Task Status Report\",\"de\":\"Task Status Report\",\"fr\":\"Task Status Report\",\"vi\":\"Task Status Report\",\"ja\":\"Task Status Report\"}', ',project',     'select t1.id,t3.name as project,t1.name,t2.status,t1.name as execution,t2.id as taskID,  t1.status as projectstatus, (case when t2.deadline < CURDATE() and t2.deadline != \'0000-00-00\' and t2.status != \'closed\' and t2.status != \'done\' and t2.status != \'cancel\' then 1 else 0 end) as timeout from TABLE_EXECUTION as t1\r\n left join TABLE_TASK as t2 on t1.id=t2.execution\r\n left join TABLE_PROJECT as t3 on t3.id=t1.project\r\n where t1.deleted=\'0\' and t1.type in (\'sprint\',\'stage\') and t2.deleted=\'0\' and if($project=\'\',1,t3.id=$project) and if($status=\'\',1,t1.status=$status) and if($beginDate=\'\',1,t1.begin>=$beginDate) and if($endDate=\'\',1,t1.end<=$endDate)',        '{\"varName\":[\"project\",\"status\",\"beginDate\",\"endDate\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u72b6\\u6001\",\"\\u6267\\u884c\\u8d77\\u59cb\\u65e5\\u671f\",\"\\u6267\\u884c\\u7ed3\\u675f\\u65e5\\u671f\"],\"requestType\":[\"select\",\"select\",\"date\",\"date\"],\"selectList\":[\"project\",\"project.status\",\"user\",\"user\"],\"default\":[\"\",\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}',    '{\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}',        '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"status\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',       2,      '{\"zh-cn\":\"\\u6309\\u7167\\u6267\\u884c\\u7edf\\u8ba1\\u4efb\\u52a1\\u7684\\u72b6\\u6001\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\",\"vi\":\"\",\"ja\":\"\"}',  'admin',        '2015-07-22 11:28:33'),
('task-type',    '{\"zh-cn\":\"\\u4efb\\u52a1\\u7c7b\\u578b\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\",\"en\":\"Task Type Report\",\"de\":\"Task Type Report\",\"fr\":\"Task Type Report\",\"vi\":\"Task Type Report\",\"ja\":\"Task Type Report\"}', ',project',     'select t1.id,t3.name as project,t1.name as execution,t2.type,t2.id as taskID, t1.status as projectstatus from TABLE_EXECUTION as t1 \r\nleft join TABLE_TASK as t2 on t1.id=t2.execution\r\nleft join TABLE_PROJECT as t3 on t3.id=t1.project\r\nwhere t1.deleted=\'0\' and t1.type in (\'sprint\',\'stage\') and t2.deleted=\'0\' and if($project=\'\',1,t3.id=$project) and if($status=\'\',1,t1.status=$status) and if($beginDate=\'\',1,t1.begin>=$beginDate) and if($endDate=\'\',1,t1.end<=$endDate)',   '{\"varName\":[\"project\",\"status\",\"beginDate\",\"endDate\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u72b6\\u6001\",\"\\u6267\\u884c\\u8d77\\u59cb\\u65e5\\u671f\",\"\\u6267\\u884c\\u7ed3\\u675f\\u65e5\\u671f\"],\"requestType\":[\"select\",\"select\",\"date\",\"date\"],\"selectList\":[\"project\",\"project.status\",\"user\",\"user\"],\"default\":[\"\",\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}',    '{\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}',        '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"type\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}', 2,      '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1\\u4efb\\u52a1\\u7684\\u7c7b\\u578b\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\",\"vi\":\"\",\"ja\":\"\"}',  'admin',        '2015-07-22 13:06:46'),
('task-assign',  '{\"zh-cn\":\"\\u9879\\u76ee\\u4efb\\u52a1\\u6307\\u6d3e\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\",\"en\":\"Task Assign Report\",\"de\":\"Task Assign Report\",\"fr\":\"Task Assign Report\",\"vi\":\"Task Assign Report\",\"ja\":\"Task Assign Report\"}',   ',project',     'select t1.id,t4.name as project,t1.name as execution,if(t3.account is not null, t3.account,t2.assignedTo) as assignedTo,t2.id as taskID, t1.status as projectstatus from TABLE_EXECUTION as t1\r\n left join TABLE_TASK as t2 on t1.id=t2.execution\r\n left join TABLE_TEAM as t3 on t3.type=\'task\' && t3.root=t2.id \r\nleft join TABLE_PROJECT as t4 on t1.project=t4.id\r\nwhere t1.deleted=\'0\' and t1.type in (\'sprint\',\'stage\') and t2.deleted=\'0\' and if($project=\'\',1,t4.id=$project) and if($status=\'\',1,t1.status=$status) and if($beginDate=\'\',1,t1.begin>=$beginDate) and if($endDate=\'\',1,t1.end<=$endDate)',   '{\"varName\":[\"project\",\"status\",\"beginDate\",\"endDate\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u72b6\\u6001\",\"\\u6267\\u884c\\u8d77\\u59cb\\u65e5\\u671f\",\"\\u6267\\u884c\\u7ed3\\u675f\\u65e5\\u671f\"],\"requestType\":[\"select\",\"select\",\"date\",\"date\"],\"selectList\":[\"project\",\"project.status\",\"user\",\"user\"],\"default\":[\"\",\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}',    '{\"assignedTo\":{\"zh-cn\":\"\\u6307\\u6d3e\\u7ed9\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}',    '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"assignedTo\"],\"isUser\":{\"reportField\":[[\"1\"]]},\"reportType\":[\"count\"],\"sumAppend\":[\"\"]}',    2,      '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1\\u4efb\\u52a1\\u7684\\u6307\\u6d3e\\u7ed9\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\",\"vi\":\"\",\"ja\":\"\"}',   'admin',        '2015-07-22 13:13:28'),
('task-finish',  '{\"zh-cn\":\"\\u9879\\u76ee\\u4efb\\u52a1\\u5b8c\\u6210\\u8005\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\",\"en\":\"Task Finish Report\",\"de\":\"Task Finish Report\",\"fr\":\"Task Finish Report\",\"vi\":\"Task Finish Report\",\"ja\":\"Task Finish Report\"}',    ',project',     'select t1.id,t3.name as project,t1.name as execution,t2.finishedBy,t2.id as taskID, t1.status as projectstatus from TABLE_EXECUTION as t1 \r\nleft join TABLE_TASK as t2 on t1.id=t2.execution\r\nleft join TABLE_PROJECT as t3 on t1.project=t3.id \r\nwhere t1.deleted=\'0\' and t1.type in (\'sprint\',\'stage\') and t2.deleted=\'0\' and t2.finishedBy!=\'\' and if($project=\'\',1,t3.id=$project) and if($status=\'\',1,t1.status=$status) and if($beginDate=\'\',1,t1.begin>=$beginDate) and if($endDate=\'\',1,t1.end<=$endDate)',    '{\"varName\":[\"project\",\"status\",\"beginDate\",\"endDate\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u72b6\\u6001\",\"\\u6267\\u884c\\u8d77\\u59cb\\u65e5\\u671f\",\"\\u6267\\u884c\\u7ed3\\u675f\\u65e5\\u671f\"],\"requestType\":[\"select\",\"select\",\"date\",\"date\"],\"selectList\":[\"project\",\"project.status\",\"user\",\"user\"],\"default\":[\"\",\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}',    '{\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}',        '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"finishedBy\"],\"isUser\":{\"reportField\":[[\"1\"]]},\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',    2,      '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1\\u4efb\\u52a1\\u7684\\u5b8c\\u6210\\u8005\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\",\"vi\":\"\",\"ja\":\"\"}',   'admin',        '2015-07-22 13:16:21'),
('project-invest',       '{\"zh-cn\":\"\\u9879\\u76ee\\u6295\\u5165\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\",\"en\":\"Project Invest Report\",\"de\":\"Project Invest Report\",\"fr\":\"Project Invest Report\",\"vi\":\"Project Invest Report\",\"ja\":\"Project Invest Report\"}', ',project',     'select t1.id,t5.name as project,t1.name as execution,CONCAT(t1.begin,\' ~ \',t1.end) as timeLimit,t2.teams,t3.stories,round(t4.consumed,1) as consumed,t4.number, t1.status as projectstatus \r\nfrom TABLE_EXECUTION as t1\r\n left join ztv_projectteams as t2 on t1.id=t2.execution\r\nleft join ztv_projectstories as t3 on t1.id=t3.execution\r\n left join ztv_executionsummary as t4 on t1.id=t4.execution \r\nleft join TABLE_PROJECT as t5 on t1.project=t5.id \r\nwhere t1.deleted=\'0\' and t1.type in (\'sprint\',\'stage\') and if($project=\'\',1,t5.id=$project) and if($status=\'\',1,t1.status=$status) and if($beginDate=\'\',1,t1.begin>=$beginDate) and if($endDate=\'\',1,t1.end<=$endDate)',     '{\"varName\":[\"project\",\"status\",\"beginDate\",\"endDate\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u72b6\\u6001\",\"\\u6267\\u884c\\u8d77\\u59cb\\u65e5\\u671f\",\"\\u6267\\u884c\\u7ed3\\u675f\\u65e5\\u671f\"],\"requestType\":[\"select\",\"select\",\"date\",\"date\"],\"selectList\":[\"project\",\"project.status\",\"user\",\"user\"],\"default\":[\"\",\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}',    '{\"timeLimit\":{\"zh-cn\":\"\\u5de5\\u671f\"},\"teams\":{\"zh-cn\":\"\\u4eba\\u6570\"},\"stories\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\"},\"consumed\":{\"zh-cn\":\"\\u603b\\u6d88\\u8017\"},\"number\":{\"zh-cn\":\"\\u4efb\\u52a1\\u6570\"},\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}',    '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"number\",\"stories\",\"teams\",\"consumed\"],\"reportType\":[\"sum\",\"sum\",\"sum\",\"sum\"],\"sumAppend\":[\"number\",\"stories\",\"teams\",\"consumed\"]}',     2,      '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u5217\\u51fa\\uff1a\\u4efb\\u52a1\\u6570\\uff0c\\u9700\\u6c42\\u6570\\uff0c\\u4eba\\u6570\\uff0c\\u603b\\u6d88\\u8017\\u5de5\\u65f6\\u3002\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\",\"vi\":\"\",\"ja\":\"\"}',  'admin',        '2015-07-22 16:37:38'),
('projectstory-status',  '{\"zh-cn\":\"\\u9879\\u76ee\\u9700\\u6c42\\u72b6\\u6001\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\",\"en\":\"Project Story Status\",\"de\":\"Project Story Status\",\"fr\":\"Project Story Status\",\"vi\":\"Project Story Status\",\"ja\":\"Project Story Status\"}',   ',project',     'select t2.id, t4.name as project,t2.name as execution,t3.status from TABLE_PROJECTSTORY as t1 \r\nleft join TABLE_EXECUTION as t2 on t1.project=t2.id \r\nleft join TABLE_STORY as t3 on t1.story=t3.id \r\nleft join TABLE_PROJECT as t4 on t4.id=t2.project\r\nwhere t2.deleted=\'0\' and t2.type in(\'sprint\', \'stage\') and if($project=\'\',1,t4.id=$project) and if($execution=\'\',1,t2.id=$execution) and if($status=\'\',1,t2.status=$status)',     '{\"varName\":[\"project\",\"execution\",\"status\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u5217\\u8868\",\"\\u6267\\u884c\\u72b6\\u6001\"],\"requestType\":[\"select\",\"select\",\"select\"],\"selectList\":[\"project\",\"execution\",\"project.status\"],\"default\":[\"\",\"\",\"\"]}', '{\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}',        '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"status\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',       2,      '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1\\u9700\\u6c42\\u7684\\u72b6\\u6001\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\",\"vi\":\"\",\"ja\":\"\"}',  'admin',        '2015-07-23 15:35:08'),
('project-stage',        '{\"zh-cn\":\"\\u9879\\u76ee\\u9700\\u6c42\\u9636\\u6bb5\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\",\"en\":\"Project Stage Report\",\"de\":\"Project Stage Report\",\"fr\":\"Project Stage Report\",\"vi\":\"Project Stage Report\",\"ja\":\"Project Stage Report\"}',   ',project',     'select t2.id, t4.name as project,t2.name as execution,t3.stage from TABLE_PROJECTSTORY as t1 \r\nleft join TABLE_EXECUTION as t2 on t1.project=t2.id \r\nleft join TABLE_STORY as t3 on t1.story=t3.id \r\nleft join TABLE_PROJECT as t4 on t4.id=t2.project\r\nwhere t2.deleted=\'0\' and t2.type in(\'sprint\', \'stage\') and if($project=\'\',1,t4.id=$project) and if($execution=\'\',1,t2.id=$execution) and if($status=\'\',1,t2.status=$status)',      '{\"varName\":[\"project\",\"execution\",\"status\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u5217\\u8868\",\"\\u6267\\u884c\\u72b6\\u6001\"],\"requestType\":[\"select\",\"select\",\"select\"],\"selectList\":[\"project\",\"execution\",\"project.status\"],\"default\":[\"\",\"\",\"\"]}', '{\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}',        '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"stage\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',        2,      '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1\\u9700\\u6c42\\u9636\\u6bb5\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\",\"vi\":\"\",\"ja\":\"\"}', 'admin',        '2015-07-23 15:38:18'),
('projectbug-resolution',        '{\"zh-cn\":\"\\u9879\\u76eeBug\\u89e3\\u51b3\\u65b9\\u6848\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\",\"en\":\"Project Bug Resolution\",\"de\":\"Project Bug Resolution\",\"fr\":\"Project Bug Resolution\",\"vi\":\"Project Bug Resolution\",\"ja\":\"Project Bug Resolution\"}',        ',project,test',        'select t1.id,t3.name as project,t3.id,t1.name as execution,t1.id as bugID,t2.resolution from TABLE_EXECUTION as t1 \r\nleft join TABLE_BUG as t2 on t1.id=t2.execution\r\nleft join TABLE_PROJECT as t3 on t3.id=t1.project\r\n where t1.deleted=\'0\' and t2.deleted=\'0\' and t2.resolution!=\'\' having bugID!=\'\' and if($project=\'\',1,t3.id=$project) and if($execution=\'\',1,t1.id=$execution)',     '{\"varName\":[\"project\",\"execution\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u5217\\u8868\"],\"requestType\":[\"select\",\"select\"],\"selectList\":[\"project\",\"execution\"],\"default\":[\"\",\"\"]}',        '{\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}',        '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"resolution\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',   2,      '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1Bug\\u7684\\u89e3\\u51b3\\u65b9\\u6848\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\",\"vi\":\"\",\"ja\":\"\"}',       'admin',        '2015-07-23 16:04:46'),
('projectbug-status',    '{\"zh-cn\":\"\\u9879\\u76eeBug\\u72b6\\u6001\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\",\"en\":\"Project Bug Status\",\"de\":\"Project Bug Status\",\"fr\":\"Project Bug Status\",\"vi\":\"Project Bug Status\",\"ja\":\"Project Bug Status\"}',      ',project,test',        'select t1.id,t3.name as project,t3.id,t1.name as execution,t1.id as bugID,t2.status from TABLE_EXECUTION as t1 \r\nleft join TABLE_BUG as t2 on t1.id=t2.execution\r\nleft join TABLE_PROJECT as t3 on t3.id=t1.project\r\nwhere t1.deleted=\'0\' and t2.deleted=\'0\' having bugID!=\' \' and if($project=\'\',1,t3.id=$project) and if($execution=\'\',1,t1.id=$execution)', '{\"varName\":[\"project\",\"execution\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u5217\\u8868\"],\"requestType\":[\"select\",\"select\"],\"selectList\":[\"project\",\"execution\"],\"default\":[\"\",\"\"]}',        '{\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}',        '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"status\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"]}',       2,      '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1Bug\\u7684\\u72b6\\u6001\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\",\"vi\":\"\",\"ja\":\"\"}',     'admin',        '2015-07-23 15:48:03'),
('projectbug-opened',    '{\"zh-cn\":\"\\u9879\\u76eeBug\\u521b\\u5efa\\u8005\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\",\"en\":\"Project Bug Opened\",\"de\":\"Project Bug Opened\",\"fr\":\"Project Bug Opened\",\"vi\":\"Project Bug Opened\",\"ja\":\"Project Bug Opened\"}',       ',project,test',        'select t1.id,t3.name as project,t3.id,t1.name as execution,t1.id as bugID,t2.openedBy from TABLE_EXECUTION as t1 \r\nleft join TABLE_BUG as t2 on t1.id=t2.execution\r\nleft join TABLE_PROJECT as t3 on t3.id=t1.project\r\nwhere t1.deleted=\'0\' and t2.deleted=\'0\' having bugID!=\'\' and if($project=\'\',1,t3.id=$project) and if($execution=\'\',1,t1.id=$execution)',        '{\"varName\":[\"project\",\"execution\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u5217\\u8868\"],\"requestType\":[\"select\",\"select\"],\"selectList\":[\"project\",\"execution\"],\"default\":[\"\",\"\"]}',        '{\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}',        '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"openedBy\"],\"isUser\":{\"reportField\":[[\"1\"]]},\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',      2,      '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1Bug\\u7684\\u521b\\u5efa\\u8005\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\",\"vi\":\"\",\"ja\":\"\"}',      'admin',        '2015-07-23 16:08:10'),
('projectbug-resolve',   '{\"zh-cn\":\"\\u9879\\u76eeBug\\u89e3\\u51b3\\u8005\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\",\"en\":\"Project Bug Resolve\",\"de\":\"Project Bug Resolve\",\"fr\":\"Project Bug Resolve\",\"vi\":\"Project Bug Resolve\",\"ja\":\"Project Bug Resolve\"}',       ',project,test',        'select t1.id,t3.name as project,t3.id,t1.name as execution,t1.id as bugID,t2.resolvedBy from TABLE_EXECUTION as t1 \r\nleft join TABLE_BUG as t2 on t1.id=t2.execution\r\nleft join TABLE_PROJECT as t3 on t3.id=t1.project\r\nwhere t1.deleted=\'0\' and t2.deleted=\'0\' and t2.status!=\'active\' and t2.resolvedBy!=\'\' having bugID!=\'\' and if($project=\'\',1,t3.id=$project) and if($execution=\'\',1,t1.id=$execution)',    '{\"varName\":[\"project\",\"execution\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u5217\\u8868\"],\"requestType\":[\"select\",\"select\"],\"selectList\":[\"project\",\"execution\"],\"default\":[\"\",\"\"]}',        '{\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}',        '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"resolvedBy\"],\"isUser\":{\"reportField\":[[\"1\"]]},\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',    2,      '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1Bug\\u7684\\u89e3\\u51b3\\u8005\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\",\"vi\":\"\",\"ja\":\"\"}',      'admin',        '2015-07-23 16:13:16'),
('projectbug-assign',    '{\"zh-cn\":\"\\u9879\\u76eeBug\\u6307\\u6d3e\\u7ed9\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\",\"en\":\"Project Bug Assign\",\"de\":\"Project Bug Assign\",\"fr\":\"Project Bug Assign\",\"vi\":\"Project Bug Assign\",\"ja\":\"Project Bug Assign\"}',       ',project,test',        'select t1.id,t3.name as project,t3.id,t1.name as execution,t1.id as bugID,t2.assignedTo from TABLE_EXECUTION as t1 \r\nleft join TABLE_BUG as t2 on t1.id=t2.execution \r\nleft join TABLE_PROJECT as t3 on t3.id=t1.project\r\nwhere t1.deleted=\'0\' and t2.deleted=\'0\' having bugID!=\'\' and if($project=\'\',1,t3.id=$project) and if($execution=\'\',1,t1.id=$execution)',     '{\"varName\":[\"project\",\"execution\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u5217\\u8868\"],\"requestType\":[\"select\",\"select\"],\"selectList\":[\"project\",\"execution\"],\"default\":[\"\",\"\"]}',        '{\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}',        '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"assignedTo\"],\"isUser\":{\"reportField\":[[\"1\"]]},\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',    2,      '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1Bug\\u7684\\u6307\\u6d3e\\u7ed9\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\",\"vi\":\"\",\"ja\":\"\"}',      'admin',        '2015-07-23 16:29:10'),
('project-quality',      '{\"zh-cn\":\"\\u9879\\u76ee\\u8d28\\u91cf\\u8868\",\"zh-tw\":\"\",\"en\":\"Project Quality Report\",\"de\":\"Project Quality Report\",\"fr\":\"Project Quality Report\",\"vi\":\"Project Quality Report\",\"ja\":\"Project Quality Report\"}',       ',project',     'select t1.id, t5.name as project,t5.id,t1.name as execution,t2.stories,(t2.stories-t2.undone) as doneStory,t3.number,(t3.number-t3.undone) as doneTask,t4.bugs,t4.resolutions, round(t4.bugs/(t2.stories-t2.undone),2) as bugthanstory,round(t4.bugs/(t3.number-t3.undone),2) as bugthantask,t4.seriousBugs from TABLE_EXECUTION as t1 \r\nleft join ztv_projectstories as t2 on t1.id=t2.execution\r\nleft join ztv_executionsummary as t3 on t1.id=t3.execution\r\nleft join ztv_projectbugs as t4 on t1.id=t4.execution\r\nleft join TABLE_PROJECT as t5 on t5.id=t1.project\r\nwhere t1.deleted=\'0\' and t1.type in (\'sprint\',\'stage\') and t1.grade=\'1\' and if($project=\'\',1,t5.id=$project) and if($execution=\'\',1,t1.id=$execution)', '{\"varName\":[\"project\",\"execution\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u5217\\u8868\"],\"requestType\":[\"select\",\"select\"],\"selectList\":[\"project\",\"execution\"],\"default\":[\"\",\"\"]}',        '{\"stories\":{\"zh-cn\":\"\\u9700\\u6c42\\u603b\\u6570\"},\"doneStory\":{\"zh-cn\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\"},\"number\":{\"zh-cn\":\"\\u4efb\\u52a1\\u603b\\u6570\"},\"doneTask\":{\"zh-cn\":\"\\u5b8c\\u6210\\u4efb\\u52a1\\u6570\"},\"bugs\":{\"zh-cn\":\"Bug\\u6570\"},\"resolutions\":{\"zh-cn\":\"\\u89e3\\u51b3Bug\\u6570\"},\"bugthanstory\":{\"zh-cn\":\"Bug\\/\\u5b8c\\u6210\\u9700\\u6c42\"},\"bugthantask\":{\"zh-cn\":\"Bug\\/\\u5b8c\\u6210\\u4efb\\u52a1\"},\"seriousBugs\":{\"zh-cn\":\"\\u91cd\\u8981Bug\\u6570\"},\"seriousBugsPercent\":{\"zh-cn\":\"\\u4e25\\u91cdBug\\u6bd4\\u7387\"},\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}',        '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"stories\",\"doneStory\",\"number\",\"doneTask\",\"bugs\",\"resolutions\",\"bugthanstory\",\"bugthantask\",\"seriousBugs\"],\"reportType\":[\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\"],\"sumAppend\":[\"stories\",\"doneStory\",\"number\",\"doneTask\",\"bugs\",\"resolutions\",\"bugthanstory\",\"bugthantask\",\"seriousBugs\"]}', 2,      '{\"zh-cn\":\"\\u5217\\u51fa\\u9879\\u76ee\\u7684\\u9700\\u6c42\\u603b\\u6570\\uff0c\\u5b8c\\u6210\\u9700\\u6c42\\u6570\\uff0c\\u4efb\\u52a1\\u603b\\u6570\\uff0c\\u5b8c\\u6210\\u7684\\u4efb\\u52a1\\u6570\\uff0cBug\\u6570\\uff0c\\u89e3\\u51b3\\u7684Bug\\u6570\\uff0cBug\\/\\u9700\\u6c42\\uff0cBug\\/\\u4efb\\u52a1\\uff0c\\u91cd\\u8981Bug\\u6570\\u91cf(\\u4e25\\u91cd\\u7a0b\\u5ea6\\u4e0d\\u5927\\u4e8e3\\uff09\\u3002\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\",\"vi\":\"\",\"ja\":\"\"}', 'admin',        '2015-07-23 17:03:10'),
('productbug-type',      '{\"zh-cn\":\"\\u4ea7\\u54c1Bug\\u7c7b\\u578b\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u7522\\u54c1Bug\\u985e\\u578b\\u7d71\\u8a08\\u8868\",\"en\":\"Bug Type of Product\"}',       ',product,test',        'select t1.id,t1.name,t2.id as bugID,t2.type from TABLE_PRODUCT as t1 \r\nleft join TABLE_BUG as t2 on t1.id=t2.product \r\nleft join TABLE_PROGRAM as t3 on t1.program=t3.id \r\nwhere t1.deleted=\'0\' and t2.deleted=\'0\'\r\norder by t3.`order` asc, t1.line desc, t1.`order` asc',        '',     '{\"count\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"done\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u6570\",\"en\":\"Done\"}}',  '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"type\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',     2,      '{\"zh-cn\":\"\\u6309\\u7167\\u4ea7\\u54c1\\u7edf\\u8ba1Bug\\u7684\\u7c7b\\u578b\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u7522\\u54c1\\u7d71\\u8a08Bug\\u7684\\u985e\\u578b\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"en\":\"Type distribution of Bugs.\"}',      'admin',        '2015-07-24 13:48:22'),
('product-quality',      '{\"zh-cn\":\"\\u4ea7\\u54c1\\u8d28\\u91cf\\u8868\",\"zh-tw\":\"\\u7522\\u54c1\\u8cea\\u91cf\\u8868\",\"en\":\"Product Quality\"}',     ',product',     'select t1.id,t1.name,t2.stories,(t2.stories-t2.undone) as doneStory,t3.bugs,t3.resolutions,round(t3.bugs/(t2.stories-t2.undone),2) as bugthanstory,t3.seriousBugs from TABLE_PRODUCT as t1 \r\nleft join ztv_productstories as t2 on t1.id=t2.product \r\nleft join ztv_productbugs as t3 on t1.id=t3.product \r\nleft join TABLE_PROGRAM as t4 on t1.program=t4.id \r\nwhere t1.deleted=\'0\'\r\norder by t4.`order` asc, t1.line desc, t1.`order` asc',      '',     '{\"stories\":{\"zh-cn\":\"\\u9700\\u6c42\\u603b\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u603b\\u6570\",\"en\":\"Stories\"},\"doneStory\":{\"zh-cn\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"en\":\"Finished Stories\"},\"bugs\":{\"zh-cn\":\"Bug\\u6570\",\"zh-tw\":\"Bug\\u6570\",\"en\":\"Bugs\"},\"resolutions\":{\"zh-cn\":\"\\u89e3\\u51b3Bug\\u6570\",\"zh-tw\":\"\\u89e3\\u51b3Bug\\u6570\",\"en\":\"Solved Bugs\"},\"bugthanstory\":{\"zh-cn\":\"Bug\\/\\u5b8c\\u6210\\u9700\\u6c42\",\"zh-tw\":\"Bug\\/\\u5b8c\\u6210\\u9700\\u6c42\",\"en\":\"Bug\\/Finished Story\"},\"seriousBugs\":{\"zh-cn\":\"\\u91cd\\u8981Bug\\u6570\",\"zh-tw\":\"\\u91cd\\u8981Bug\\u6570\",\"en\":\"Serious Bugs\"},\"seriousBugsPercent\":{\"zh-cn\":\"\\u4e25\\u91cdbug\\u6bd4\\u7387\",\"zh-tw\":\"\\u4e25\\u91cdbug\\u6bd4\\u7387\",\"en\":\"Serious Bugs %\"}}',     '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"stories\",\"doneStory\",\"bugs\",\"resolutions\",\"bugthanstory\",\"seriousBugs\"],\"reportType\":[\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\"],\"sumAppend\":[\"stories\",\"doneStory\",\"bugs\",\"resolutions\",\"bugthanstory\",\"seriousBugs\"],\"percent\":{\"5\":\"1\"},\"contrast\":{\"5\":\"bugs\"},\"showAlone\":{\"5\":\"1\"}}', 2,      '{\"zh-cn\":\"\\u5217\\u51fa\\u4ea7\\u54c1\\u7684\\u9700\\u6c42\\u6570\\uff0c\\u5b8c\\u6210\\u7684\\u9700\\u6c42\\u603b\\u6570\\uff0cBug\\u6570\\uff0c\\u89e3\\u51b3\\u7684Bug\\u603b\\u6570\\uff0cBug\\/\\u9700\\u6c42\\uff0c\\u91cd\\u8981Bug\\u6570\\u91cf(\\u4e25\\u91cd\\u7a0b\\u5ea6\\u4e0d\\u5927\\u4e8e3)\\u3002\",\"zh-tw\":\"\\u5217\\u51fa\\u7522\\u54c1\\u7684\\u9700\\u6c42\\u6578\\uff0c\\u5b8c\\u6210\\u7684\\u9700\\u6c42\\u7e3d\\u6578\\uff0cBug\\u6578\\uff0c\\u89e3\\u51b3\\u7684Bug\\u7e3d\\u6578\\uff0cBug\\/\\u9700\\u6c42\\uff0c\\u91cd\\u8981Bug\\u6578\\u91cf\\uff08\\u56b4\\u91cd\\u7a0b\\u5ea6\\u4e0d\\u5927\\u65bc3\\uff09\\u3002\",\"en\":\"Serious Bug (severity is less than 3).\"}',    'admin',        '2015-07-23 17:17:40'),
('user-login',   '{\"zh-cn\":\"\\u5458\\u5de5\\u767b\\u5f55\\u6b21\\u6570\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u54e1\\u5de5\\u767b\\u9304\\u6b21\\u6578\\u7d71\\u8a08\\u8868\",\"en\":\"Login Times\"}', ',staff',       'select actor,LEFT(`date`,10) as `day` from TABLE_ACTION where `action`=\'login\' and if($startDate=\'\',1,`date`>=$startDate) and if($endDate=\'\',1,`date`<=$endDate) order by `date` asc, actor asc',        '{\"varName\":[\"startDate\",\"endDate\"],\"showName\":[\"\\u8d77\\u59cb\\u65f6\\u95f4\",\"\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"date\",\"date\"],\"selectList\":[\"user\",\"user\"],\"default\":[\"$MONTHBEGIN\",\"$MONTHEND\"]}',        '{\"count\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"done\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u6570\",\"en\":\"Done\"}}',  '{\"group1\":\"actor\",\"isUser\":{\"group1\":[\"1\"]},\"group2\":\"\",\"reportField\":[\"day\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',     2,      '{\"zh-cn\":\"\\u5b9e\\u73b0\\u5458\\u5de5\\u767b\\u5f55\\u6b21\\u6570\\u7edf\\u8ba1\\u62a5\\u8868\\uff0c\\u6309\\u7167\\u5929\\u7edf\\u8ba1\\u6bcf\\u5929\\u6bcf\\u4e2a\\u4eba\\u7684\\u767b\\u5f55\\u6b21\\u6570\\uff0c\\u4ee5\\u53ca\\u603b\\u6570\\u3002\",\"zh-tw\":\"\\u5be6\\u73fe\\u54e1\\u5de5\\u767b\\u9304\\u6b21\\u6578\\u7d71\\u8a08\\u5831\\u8868\\uff0c\\u6309\\u5929\\u7d71\\u8a08\\u6bcf\\u5929\\u6bcf\\u500b\\u4eba\\u7684\\u767b\\u9304\\u6b21\\u6578\\uff0c\\u4ee5\\u53ca\\u7e3d\\u6578\\u3002 \",\"en\":\"The summary of user login times.\"}',    'admin',        '2015-07-24 14:28:11'),
('effort',       '{\"zh-cn\":\"\\u65e5\\u5fd7\\u6c47\\u603b\\u8868\",\"zh-tw\":\"\\u65e5\\u8a8c\\u5f59\\u7e3d\\u8868\",\"en\":\"Effort Summary\"}',      ',staff',       'select t1.account,t1.consumed,t1.`date`,if($dept=\'0\',0,t2.dept) as dept from TABLE_EFFORT as t1 left join TABLE_USER as t2 on t1.account=t2.account where t1.`deleted`=\'0\' and if($startDate=\'\',1,t1.`date`>=$startDate) and if($endDate=\'\',1,t1.`date`<=$endDate) having dept=$dept order by `date` asc',     '{\"varName\":[\"dept\",\"startDate\",\"endDate\"],\"showName\":[\"\\u90e8\\u95e8\",\"\\u8d77\\u59cb\\u65f6\\u95f4\",\"\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"select\",\"date\",\"date\"],\"selectList\":[\"dept\",\"user\",\"user\"],\"default\":[\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}',   '{\"date\":{\"zh-cn\":\"\\u65e5\\u671f\",\"zh-tw\":\"\\u65e5\\u671f\",\"en\":\"Date\"},\"consumed\":{\"zh-cn\":\"\\u6d88\\u8017\\u5de5\\u65f6\",\"zh-tw\":\"\\u6d88\\u8017\\u5de5\\u65f6\",\"en\":\"Cost\"}}',  '{\"group1\":\"account\",\"isUser\":{\"group1\":[\"1\"]},\"group2\":\"\",\"reportField\":[\"date\"],\"reportType\":[\"sum\"],\"sumAppend\":[\"consumed\"]}',    2,      '{\"zh-cn\":\"\\u67e5\\u770b\\u67d0\\u4e2a\\u65f6\\u95f4\\u6bb5\\u5185\\u7684\\u65e5\\u5fd7\\u60c5\\u51b5\\uff0c\\u53ef\\u4ee5\\u6309\\u7167\\u90e8\\u95e8\\u9009\\u62e9\\u3002\",\"zh-tw\":\" \\u67e5\\u770b\\u67d0\\u500b\\u6642\\u9593\\u6bb5\\u5167\\u7684\\u65e5\\u8a8c\\u60c5\\u51b5\\uff0c\\u53ef\\u4ee5\\u6309\\u7167\\u90e8\\u9580\\u9078\\u64c7\\u3002 \",\"en\":\"Effort summary of users.\"}',      'admin',        '2015-07-27 13:53:32'),
('company-dynamic',      '{\"zh-cn\":\"\\u516c\\u53f8\\u52a8\\u6001\\u6c47\\u603b\\u8868\",\"zh-tw\":\"\\u516c\\u53f8\\u52d5\\u614b\\u5f59\\u7e3d\\u8868\",\"en\":\"Company Dynamics\"}',        ',staff',       'select t1.day,t2.userlogin,t3.consumed,t4.storyopen,t5.storyclose,t6.taskopen,t7.taskfinish,t8.bugopen,t9.bugresolve,t1.actions from ztv_dayactions as t1 left join ztv_dayuserlogin as t2 on t1.day=t2.day left join ztv_dayeffort as t3 on t1.day=t3.date left join ztv_daystoryopen as t4 on t1.day=t4.day left join ztv_daystoryclose as t5 on t1.day=t5.day left join ztv_daytaskopen as t6 on t1.day=t6.day left join ztv_daytaskfinish as t7 on t1.day=t7.day left join ztv_daybugopen as t8 on t1.day=t8.day left join ztv_daybugresolve as t9 on t1.day=t9.day where if($startDate=\'\',1,t1.day>=$startDate) and if($endDate=\'\',1,t1.day<=$endDate)',      '{\"varName\":[\"startDate\",\"endDate\"],\"showName\":[\"\\u8d77\\u59cb\\u65f6\\u95f4\",\"\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"date\",\"date\"],\"selectList\":[\"user\",\"user\"],\"default\":[\"$MONTHBEGIN\",\"$MONTHEND\"]}',        '{\"day\":{\"zh-cn\":\"\\u65e5\\u671f\",\"zh-tw\":\"\\u65e5\\u671f\",\"en\":\"Date\"},\"userlogin\":{\"zh-cn\":\"\\u767b\\u5f55\\u6b21\\u6570\",\"zh-tw\":\"\\u767b\\u9304\\u6b21\\u6578\",\"en\":\"Login\"},\"consumed\":{\"zh-cn\":\"\\u65e5\\u5fd7\\u5de5\\u65f6\",\"zh-tw\":\"\\u65e5\\u8a8c\\u5de5\\u6642\",\"en\":\"Cost(h)\"},\"storyopen\":{\"zh-cn\":\"\\u65b0\\u589e\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u65b0\\u589e\\u9700\\u6c42\\u6578\",\"en\":\"Open Story\"},\"storyclose\":{\"zh-cn\":\"\\u5173\\u95ed\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u95dc\\u9589\\u9700\\u6c42\\u6578\",\"en\":\"Closed Story\"},\"taskopen\":{\"zh-cn\":\"\\u65b0\\u589e\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u65b0\\u589e\\u4efb\\u52d9\\u6578\",\"en\":\"Open Task\"},\"taskfinish\":{\"zh-cn\":\"\\u5b8c\\u6210\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u4efb\\u52d9\\u6578\",\"en\":\"Finished Task\"},\"bugopen\":{\"zh-cn\":\"\\u65b0\\u589eBug\\u6570\",\"zh-tw\":\"\\u65b0\\u589eBug\\u6578\",\"en\":\"Open Bug\"},\"bugresolve\":{\"zh-cn\":\"\\u89e3\\u51b3Bug\\u6570\",\"zh-tw\":\"\\u89e3\\u51b3Bug\\u6578\",\"en\":\"Resolved bug\"},\"actions\":{\"zh-cn\":\"\\u52a8\\u6001\\u6570\",\"zh-tw\":\"\\u52d5\\u614b\\u6578\",\"en\":\"Dynamics\"}}',   '{\"group1\":\"day\",\"isUser\":{\"group1\":[\"1\"]},\"group2\":\"\",\"reportField\":[\"userlogin\",\"consumed\",\"storyopen\",\"storyclose\",\"taskopen\",\"taskfinish\",\"bugopen\",\"bugresolve\",\"actions\"],\"reportType\":[\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\"],\"sumAppend\":[\"userlogin\",\"consumed\",\"storyopen\",\"storyclose\",\"taskopen\",\"taskfinish\",\"bugopen\",\"bugresolve\",\"actions\"]}',        2,      '{\"zh-cn\":\"\\u53ef\\u4ee5\\u6307\\u5b9a\\u4e00\\u4e2a\\u65f6\\u671f\\uff0c\\u5217\\u51fa\\u76f8\\u5e94\\u7684\\u6570\\u636e\\uff1a1. \\u6bcf\\u5929\\u7684\\u767b\\u5f55\\u6b21\\u6570\\u30022. \\u6bcf\\u5929\\u7684\\u65e5\\u5fd7\\u5de5\\u65f6\\u91cf\\u30023. \\u6bcf\\u5929\\u65b0\\u589e\\u7684\\u9700\\u6c42\\u6570\\u30024. \\u6bcf\\u5929\\u5173\\u95ed\\u7684\\u9700\\u6c42\\u6570\\u30025. \\u6bcf\\u5929\\u65b0\\u589e\\u7684\\u4efb\\u52a1\\u6570\\u30026. \\u6bcf\\u5929\\u5b8c\\u6210\\u7684\\u4efb\\u52a1\\u6570\\u30027. \\u6bcf\\u5929\\u65b0\\u589e\\u7684Bug\\u6570\\u30028. \\u6bcf\\u5929\\u89e3\\u51b3\\u7684Bug\\u6570\\u30029. \\u6bcf\\u5929\\u7684\\u52a8\\u6001\\u6570\\u3002\",\"zh-tw\":\"\\u53ef\\u4ee5\\u6307\\u5b9a\\u4e00\\u500b\\u6642\\u671f\\uff0c\\u5217\\u51fa\\u76f8\\u61c9\\u7684\\u6578\\u64da\\uff1a1.\\u6bcf\\u5929\\u7684\\u767b\\u9304\\u6b21\\u6578\\u30022.\\u6bcf\\u5929\\u7684\\u65e5\\u8a8c\\u5de5\\u6642\\u91cf\\u30023.\\u6bcf\\u5929\\u65b0\\u589e\\u7684\\u9700\\u6c42\\u6578\\u30024.\\u6bcf\\u5929\\u95dc\\u9589\\u7684\\u9700\\u6c42\\u6578\\u30025.\\u6bcf\\u5929\\u65b0\\u589e\\u7684\\u4efb\\u52d9\\u6578\\u30026.\\u6bcf\\u5929\\u5b8c\\u6210\\u7684\\u4efb\\u52d9\\u6578\\u30027.\\u6bcf\\u5929\\u65b0\\u589e\\u7684Bug\\u6578\\u30028.\\u6bcf\\u5929\\u89e3\\u51b3\\u7684Bug\\u6578\\u30029.\\u6bcf\\u5929\\u7684\\u52d5\\u614b\\u6578\\u3002\",\"en\":\"The summary of company dynamics\"}',        'admin',        '2015-07-27 15:09:42'),
('bug-resolve',  '{\"zh-cn\":\"Bug\\u89e3\\u51b3\\u8868\",\"zh-tw\":\"Bug\\u89e3\\u6c7a\\u8868\",\"en\":\"Solved Bugs\"}',       ',test',        'select *,if($product=\'\',0,product) as customproduct from TABLE_BUG where deleted=\'0\' and resolution!=\'\' and if($startDate=\'\',1,resolvedDate>=$startDate) and if($endDate=\'\',1,resolvedDate<=$endDate) having customproduct=$product',        '{\"varName\":[\"product\",\"startDate\",\"endDate\"],\"showName\":[\"\\u4ea7\\u54c1\",\"\\u89e3\\u51b3\\u65e5\\u671f\\u5f00\\u59cb\",\"\\u89e3\\u51b3\\u65e5\\u671f\\u7ed3\\u675f\"],\"requestType\":[\"select\",\"date\",\"date\"],\"selectList\":[\"product\",\"user\",\"user\"],\"default\":[\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}', '{\"count\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"done\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u6570\",\"en\":\"Done\"}}',  '{\"group1\":\"resolvedBy\",\"isUser\":{\"group1\":[\"1\"]},\"group2\":\"\",\"reportField\":[\"resolution\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"],\"percent\":[\"1\"],\"contrast\":[\"crystalTotal\"],\"showAlone\":[\"1\"]}',       2,      '{\"zh-cn\":\"\\u5217\\u51fa\\u89e3\\u51b3\\u7684Bug\\u603b\\u6570\\uff0c\\u89e3\\u51b3\\u65b9\\u6848\\u7684\\u5206\\u5e03\\uff0c\\u5360\\u7684\\u6bd4\\u4f8b\\uff08\\u8be5\\u7528\\u6237\\u89e3\\u51b3\\u7684Bug\\u7684\\u6570\\u91cf\\u5360\\u6240\\u6709\\u7684\\u89e3\\u51b3\\u7684Bug\\u7684\\u6570\\u91cf)\\u3002\",\"zh-tw\":\"\\u5217\\u51fa\\u89e3\\u51b3\\u7684Bug\\u7e3d\\u6578\\uff0c\\u89e3\\u6c7a\\u65b9\\u6848\\u7684\\u5206\\u4f48\\uff0c\\u5360\\u7684\\u6bd4\\u4f8b\\uff08\\u8a72\\u7528\\u6236\\u89e3\\u51b3\\u7684Bug\\u7684\\u6578\\u91cf\\u5360\\u6240\\u6709\\u7684\\u89e3\\u51b3\\u7684Bug\\u7684\\u6578\\u91cf\\uff09\\u3002\",\"en\":\"percentage:self resolved / all resolved\"}',   'admin',        '2015-07-24 13:44:25'),
('project-progress',     '{\"zh-cn\":\"\\u9879\\u76ee\\u8fdb\\u5c55\\u8868\",\"zh-tw\":\"\",\"en\":\"Project Progress Report\",\"de\":\"Project Progress Report\",\"fr\":\"Project Progress Report\",\"vi\":\"Project Progress Report\",\"ja\":\"Project Progress Report\"}',       ',project',     'select t1.id,t4.name as project,t4.id,t1.name as execution,t1.status,t2.number as tasks,round(t2.consumed,2) as consumed,round(t2.`left`,2) as `left`,t3.stories,t2.undone as undoneTask,t3.undone as undoneStory,t2.totalReal from TABLE_EXECUTION as t1 \r\nleft join ztv_executionsummary as t2 on t1.id=t2.execution\r\nleft join ztv_projectstories as t3 on t1.id=t3.execution\r\nleft join TABLE_PROJECT as t4 on t4.id=t1.project\r\nwhere t1.deleted=\'0\' and t1.type in (\'sprint\',\'stage\') and if($project=\'\',1,t4.id=$project) and if($execution=\'\',1,t1.id=$execution) and if($status=\'\',1,t1.status=$status)', '{\"varName\":[\"project\",\"execution\",\"status\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u5217\\u8868\",\"\\u6267\\u884c\\u72b6\\u6001\"],\"requestType\":[\"select\",\"select\",\"select\"],\"selectList\":[\"project\",\"execution\",\"project.status\"],\"default\":[\"\",\"\",\"\"]}', '{\"stories\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"tasks\":{\"zh-cn\":\"\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u4efb\\u52a1\\u6570\",\"en\":\"Tasks\"},\"undoneStory\":{\"zh-cn\":\"\\u5269\\u4f59\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u5269\\u4f59\\u9700\\u6c42\\u6570\",\"en\":\"Undone Story\"},\"undoneTask\":{\"zh-cn\":\"\\u5269\\u4f59\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u5269\\u4f59\\u4efb\\u52a1\\u6570\",\"en\":\"Undone Task\"},\"consumed\":{\"zh-cn\":\"\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\",\"zh-tw\":\"\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\",\"en\":\"Cost(h)\"},\"left\":{\"zh-cn\":\"\\u5269\\u4f59\\u5de5\\u65f6\",\"zh-tw\":\"\\u5269\\u4f59\\u5de5\\u65f6\",\"en\":\"Left(h)\"},\"consumedPercent\":{\"zh-cn\":\"\\u8fdb\\u5ea6\",\"zh-tw\":\"\\u8fdb\\u5ea6\",\"en\":\"Process\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}',    '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"stories\",\"undoneStory\",\"tasks\",\"undoneTask\",\"left\",\"consumed\"],\"reportType\":[\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\"],\"sumAppend\":[\"stories\",\"undoneStory\",\"tasks\",\"undoneTask\",\"left\",\"consumed\"],\"percent\":{\"5\":\"1\"},\"contrast\":{\"5\":\"totalReal\"},\"showAlone\":{\"5\":\"1\"}}',  2,      '{\"zh-cn\":\"\\u9879\\u76ee\\u7684\\u9700\\u6c42\\u6570\\uff0c\\u4efb\\u52a1\\u6570\\uff0c\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\\uff0c\\u5269\\u4f59\\u5de5\\u65f6\\uff0c\\u5269\\u4f59\\u9700\\u6c42\\u6570\\uff0c\\u5269\\u4f59\\u4efb\\u52a1\\u6570\\uff0c\\u8fdb\\u5ea6\\u3002\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\",\"vi\":\"\",\"ja\":\"\"}',       'admin',        '2015-07-23 14:03:06'),
('projectbug-type',      '{\"zh-cn\":\"\\u9879\\u76eeBug\\u7c7b\\u578b\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\",\"en\":\"Project Bug Type\",\"de\":\"Project Bug Type\",\"fr\":\"Project Bug Type\",\"vi\":\"Project Bug Type\",\"ja\":\"Project Bug Type\"}',      ',project,test',        'select t1.id,t3.name as project,t3.id,t1.name as execution,t2.id as bugID,t2.type from TABLE_EXECUTION as t1 \r\nleft join TABLE_BUG as t2 on t1.id=t2.execution\r\nleft join TABLE_PROJECT as t3 on t3.id=t1.project\r\nwhere t1.deleted=\'0\' and t2.deleted=\'0\' and if($project=\'\',1,t3.id=$project) and if($execution=\'\',1,t1.id=$execution)',       '{\"varName\":[\"project\",\"execution\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u5217\\u8868\"],\"requestType\":[\"select\",\"select\"],\"selectList\":[\"project\",\"execution\"],\"default\":[\"\",\"\"]}',        '{\"stories\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"tasks\":{\"zh-cn\":\"\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u4efb\\u52a1\\u6570\",\"en\":\"Tasks\"},\"undoneStory\":{\"zh-cn\":\"\\u5269\\u4f59\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u5269\\u4f59\\u9700\\u6c42\\u6570\",\"en\":\"Undone Story\"},\"undoneTask\":{\"zh-cn\":\"\\u5269\\u4f59\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u5269\\u4f59\\u4efb\\u52a1\\u6570\",\"en\":\"Undone Task\"},\"consumed\":{\"zh-cn\":\"\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\",\"zh-tw\":\"\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\",\"en\":\"Cost(h)\"},\"left\":{\"zh-cn\":\"\\u5269\\u4f59\\u5de5\\u65f6\",\"zh-tw\":\"\\u5269\\u4f59\\u5de5\\u65f6\",\"en\":\"Left(h)\"},\"consumedPercent\":{\"zh-cn\":\"\\u8fdb\\u5ea6\",\"zh-tw\":\"\\u8fdb\\u5ea6\",\"en\":\"Process\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}',    '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"type\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"]}', 2,      '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1Bug\\u7684\\u7c7b\\u578b\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\",\"vi\":\"\",\"ja\":\"\"}',     'admin',        '2015-08-04 13:54:22');
REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'report', 'export'),
(4, 'report', 'export'),
(5, 'report', 'export'),
(6, 'report', 'export'),
(7, 'report', 'export'),
(8, 'report', 'export'),
(9, 'report', 'export');
-- DROP TABLE IF EXISTS `zt_feedback`;
CREATE TABLE IF NOT EXISTS `zt_feedback` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL,
  `module` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  `status` varchar(30) NOT NULL,
  `subStatus` varchar(30) NOT NULL default '',
  `public` enum('0','1') NOT NULL DEFAULT '0',
  `notify` enum('0','1') NOT NULL DEFAULT '0',
  `likes` text NOT NULL,
  `result` mediumint(8) unsigned NOT NULL,
  `faq` mediumint(8) unsigned NOT NULL,
  `openedBy` char(30) NOT NULL,
  `openedDate` datetime NOT NULL,
  `reviewedBy` varchar(255) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  `processedBy` char(30) NOT NULL,
  `processedDate` datetime NOT NULL,
  `closedBy` char(30) NOT NULL,
  `closedDate` datetime NOT NULL,
  `closedReason` varchar(30) NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedTo` varchar(255) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `mailto` varchar(255) NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `zt_bug`   ADD `feedback` mediumint(8) unsigned NOT NULL DEFAULT '0' AFTER `caseVersion`;
ALTER TABLE `zt_story` ADD `feedback` mediumint(8) unsigned NOT NULL DEFAULT '0' AFTER `fromBug`;
ALTER TABLE `zt_user`  ADD `feedback` enum('0', '1') NOT NULL DEFAULT '0' AFTER `locked`;
ALTER TABLE `zt_group` ADD `developer` enum('0', '1') NOT NULL DEFAULT '1' AFTER `acl`;

INSERT INTO `zt_group` (`name`, `role`, `desc`, `acl`, `developer`) VALUES ('FEEDBACK', 'feedback', 'Feedback', '', '0');

REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'feedback', 'admin'),
(4, 'feedback', 'admin'),
(5, 'feedback', 'admin'),
(8, 'feedback', 'admin'),
(1, 'feedback', 'adminview'),
(4, 'feedback', 'adminview'),
(5, 'feedback', 'adminview'),
(8, 'feedback', 'adminview'),
(1, 'feedback', 'close'),
(4, 'feedback', 'close'),
(5, 'feedback', 'close'),
(8, 'feedback', 'close'),
(1, 'faq', 'browse'),
(4, 'faq', 'browse'),
(5, 'faq', 'browse'),
(8, 'faq', 'browse'),
(1, 'host', 'browse'),
(1, 'host', 'create'),
(1, 'host', 'edit'),
(1, 'host', 'view'),
(1, 'host', 'delete'),
(1, 'host', 'treemap'),
(4, 'host', 'browse'),
(4, 'host', 'create'),
(4, 'host', 'edit'),
(4, 'host', 'view'),
(4, 'host', 'delete'),
(4, 'host', 'treemap'),
(6, 'host', 'browse'),
(6, 'host', 'create'),
(6, 'host', 'edit'),
(6, 'host', 'view'),
(6, 'host', 'delete'),
(6, 'host', 'treemap'),
(8, 'host', 'browse'),
(8, 'host', 'create'),
(8, 'host', 'edit'),
(8, 'host', 'view'),
(8, 'host', 'delete'),
(8, 'host', 'treemap'),
(1, 'tree', 'browsehost'),
(4, 'tree', 'browsehost'),
(6, 'tree', 'browsehost'),
(8, 'tree', 'browsehost'),
(13,'attend','edit'),
(13,'attend','personal'),
(13,'doc','alllibs'),
(13,'doc','browse'),
(13,'doc','create'),
(13,'doc','createLib'),
(13,'doc','delete'),
(13,'doc','diff'),
(13,'doc','edit'),
(13,'doc','editLib'),
(13,'doc','showFiles'),
(13,'doc','view'),
(13,'effort','batchCreate'),
(13,'effort','batchEdit'),
(13,'effort','calendar'),
(13,'effort','createForObject'),
(13,'effort','delete'),
(13,'effort','edit'),
(13,'effort','export'),
(13,'effort','view'),
(13,'feedback','browse'),
(13,'feedback','close'),
(13,'feedback','comment'),
(13,'feedback','create'),
(13,'feedback','delete'),
(13,'feedback','edit'),
(13,'feedback','index'),
(13,'feedback','view'),
(13,'faq','browse'),
(13,'faq','create'),
(13,'faq','edit'),
(13,'faq','delete'),
(13,'file','delete'),
(13,'file','download'),
(13,'file','edit'),
(13,'holiday','browse'),
(13,'index','index'),
(13,'leave','back'),
(13,'leave','create'),
(13,'leave','delete'),
(13,'leave','edit'),
(13,'leave','personal'),
(13,'leave','switchstatus'),
(13,'leave','view'),
(13,'lieu','create'),
(13,'lieu','delete'),
(13,'lieu','edit'),
(13,'lieu','personal'),
(13,'lieu','switchstatus'),
(13,'lieu','view'),
(13,'makeup','create'),
(13,'makeup','delete'),
(13,'makeup','edit'),
(13,'makeup','personal'),
(13,'makeup','switchstatus'),
(13,'makeup','view'),
(13,'my','changePassword'),
(13,'my','editProfile'),
(13,'my','effort'),
(13,'my','profile'),
(13,'my','todo'),
(13,'overtime','create'),
(13,'overtime','delete'),
(13,'overtime','edit'),
(13,'overtime','personal'),
(13,'overtime','switchstatus'),
(13,'overtime','view'),
(13,'search','buildForm'),
(13,'search','buildQuery'),
(13,'search','deleteQuery'),
(13,'search','saveQuery'),
(13,'search','select'),
(13,'todo','batchCreate'),
(13,'todo','batchEdit'),
(13,'todo','batchFinish'),
(13,'todo','calendar'),
(13,'todo','create'),
(13,'todo','delete'),
(13,'todo','edit'),
(13,'todo','export'),
(13,'todo','finish'),
(13,'todo','import2Today'),
(13,'todo','view'),
(13,'tree','browse'),
(13,'tree','delete'),
(13,'tree','manageChild'),
(13,'tree','updateOrder');

-- DROP TABLE IF EXISTS `zt_feedbackproduct`;
CREATE TABLE IF NOT EXISTS `zt_feedbackview` (
  `account` char(30) NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  UNIQUE KEY `account_product` (`account`,`product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_serverroom`;
CREATE TABLE IF NOT EXISTS `zt_serverroom` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `city` varchar(128) NOT NULL,
  `line` varchar(20) NOT NULL,
  `bandwidth` varchar(128) NOT NULL,
  `provider` varchar(128) NOT NULL,
  `owner` varchar(30) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_account`;
CREATE TABLE `zt_account` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `provider` varchar(255) NOT NULL,
  `adminURI` varchar(255) NOT NULL,
  `account` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `mobile` varchar(255) NOT NULL,
  `extra` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `status` varchar(30) NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  key `name` (`name`),
  key `provider` (`provider`),
  key `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_asset`;
CREATE TABLE IF NOT EXISTS `zt_asset` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `status` varchar(30) NOT NULL,
  `type` varchar(30) NOT NULL,
  `group` varchar(128) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_host`;
CREATE TABLE IF NOT EXISTS `zt_host` (
  `id` mediumint(8) unsigned  NOT NULL AUTO_INCREMENT,
  `assetID`      mediumint(8) unsigned NOT NULL,
  `serverRoom`   mediumint(8) unsigned NOT NULL,
  `cabinet`      varchar(128) NOT NULL,
  `serverModel`  varchar(256) NOT NULL,
  `hardwareType` varchar(64)  NOT NULL,
  `hostType`     enum('physical','virtual') NOT NULL,
  `cpuBrand`     varchar(128) NOT NULL,
  `cpuModel`     varchar(128) NOT NULL,
  `cpuNumber`    varchar(16)  NOT NULL,
  `cpuCores`     varchar(30)  NOT NULL,
  `cpuRate`      varchar(30)  NOT NULL,
  `memory`       varchar(30)  NOT NULL,
  `diskType`     varchar(30)  NOT NULL,
  `diskSize`     varchar(30)  NOT NULL,
  `unit`         enum('GB','TB') NOT NULL DEFAULT 'GB',
  `privateIP`    varchar(128) NOT NULL,
  `publicIP`     varchar(128) NOT NULL,
  `nic`          varchar(128) NOT NULL,
  `mac`          varchar(128) NOT NULL,
  `osName`       varchar(64)  NOT NULL,
  `osVersion`    varchar(64)  NOT NULL,
  `webserver`    varchar(128) NOT NULL,
  `database`     varchar(128) NOT NULL,
  `language`     varchar(16)  NOT NULL,
  `status`       enum('online','offline') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_service`;
CREATE TABLE IF NOT EXISTS `zt_service` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `version` varchar(64) NOT NULL,
  `color` char(7) NOT NULL,
  `desc` text,
  `dept` varchar(128) NOT NULL,
  `devel` varchar(30) NOT NULL,
  `qa` varchar(30) NOT NULL,
  `ops` varchar(30) NOT NULL,
  `hosts` text,
  `softName` varchar(128) NOT NULL,
  `softVersion` varchar(128) NOT NULL,
  `type` varchar(20) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL default '0', 
  `path` char(255) NOT NULL default '',
  `grade` tinyint(3) unsigned NOT NULL default '0', 
  `order` smallint(5) unsigned NOT NULL default '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES (1, 'tree', 'editHost');

-- DROP TABLE IF EXISTS `zt_attend`;
CREATE TABLE IF NOT EXISTS `zt_attend` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `date` date NOT NULL,
  `signIn` time NOT NULL,
  `signOut` time NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `ip` varchar(15) NOT NULL,
  `device` varchar(30) NOT NULL,
  `client` varchar(20) NOT NULL,
  `manualIn` time NOT NULL,
  `manualOut` time NOT NULL,
  `reason` varchar(30) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  `reviewStatus` varchar(30) NOT NULL DEFAULT '',
  `reviewedBy` char(30) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `date` (`date`),
  KEY `status` (`status`),
  KEY `reason` (`reason`),
  KEY `reviewStatus` (`reviewStatus`),
  KEY `reviewedBy` (`reviewedBy`),
  UNIQUE KEY `attend` (`date`,`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_attendstat`;
CREATE TABLE IF NOT EXISTS `zt_attendstat` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `month` char(10) NOT NULL DEFAULT '',
  `normal` decimal(12,2) NOT NULL DEFAULT 0.00,
  `late` decimal(12,2) NOT NULL DEFAULT 0.00,
  `early` decimal(12,2) NOT NULL DEFAULT 0.00,
  `absent` decimal(12,2) NOT NULL DEFAULT 0.00,
  `trip` decimal(12,2) NOT NULL DEFAULT 0.00,
  `egress` decimal(12,2) NOT NULL DEFAULT 0.00,
  `lieu` decimal(12,2) NOT NULL DEFAULT 0.00,
  `paidLeave` decimal(12,2) NOT NULL DEFAULT 0.00,
  `unpaidLeave` decimal(12,2) NOT NULL DEFAULT 0.00,
  `timeOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `restOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `holidayOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `deserve` decimal(12,2) NOT NULL DEFAULT 0.00,
  `actual` decimal(12,2) NOT NULL DEFAULT 0.00,
  `status` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `month` (`month`),
  KEY `status` (`status`),
  UNIQUE KEY `attend` (`month`,`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_overtime`;
CREATE TABLE IF NOT EXISTS `zt_overtime` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT '0.0',
  `leave` varchar(255) NOT NULL,
  `type` varchar(30) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `rejectReason` varchar(100) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `reviewedBy` char(30) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `type` (`type`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_holiday`;
CREATE TABLE IF NOT EXISTS `zt_holiday` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `type` enum('holiday', 'working') NOT NULL DEFAULT 'holiday',
  `desc` text NOT NULL,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_leave`;
CREATE TABLE IF NOT EXISTS `zt_leave` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT '0.0',
  `backDate` datetime NOT NULL,
  `type` varchar(30) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `reviewedBy` char(30) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `type` (`type`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_lieu`;
CREATE TABLE IF NOT EXISTS `zt_lieu` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT '0.0',
  `overtime` char(255) NOT NULL,
  `trip` char(255) NOT NULL,
  `desc` text NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `reviewedBy` char(30) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_trip`;
CREATE TABLE IF NOT EXISTS `zt_trip` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('trip', 'egress') NOT NULL DEFAULT 'trip',
  `customers` varchar(20) NOT NULL,
  `name` char(30) NOT NULL,
  `desc` text NOT NULL,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `from` char(50) NOT NULL,
  `to` char(50) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `createdBy` (`createdBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_deploy`;
CREATE TABLE IF NOT EXISTS `zt_deploy` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `begin` datetime NOT NULL,
  `end` datetime NOT NULL,
  `name` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  `status` varchar(20) NOT NULL,
  `owner` char(30) NOT NULL,
  `members` text NOT NULL,
  `notify` text NOT NULL,
  `cases` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `result` varchar(20) NOT NULL,
  `deleted` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_deployproduct`;
CREATE TABLE IF NOT EXISTS `zt_deployproduct` (
  `deploy` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `release` mediumint(8) unsigned NOT NULL,
  `package` varchar(255) NOT NULL,
  UNIQUE KEY `deploy_product_release` (`deploy`,`product`,`release`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_deploystep`;
CREATE TABLE IF NOT EXISTS `zt_deploystep` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `deploy` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `begin` datetime NOT NULL,
  `end` datetime NOT NULL,
  `stage` varchar(30) NOT NULL,
  `content` text NOT NULL,
  `status` varchar(30) NOT NULL,
  `assignedTo` char(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `finishedBy` char(30) NOT NULL,
  `finishedDate` datetime NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
ALTER TABLE `zt_testresult` ADD `deploy` mediumint(8) unsigned NOT NULL;
-- DROP TABLE IF EXISTS `zt_deployscope`;
CREATE TABLE IF NOT EXISTS `zt_deployscope` (
  `deploy` mediumint(8) unsigned NOT NULL,
  `service` mediumint(8) unsigned NOT NULL,
  `hosts` text NOT NULL,
  `remove` text NOT NULL,
  `add` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `zt_doc`
ADD `parent` smallint(5) unsigned NOT NULL DEFAULT '0' AFTER `type`,
ADD `path` char(255) COLLATE 'utf8_general_ci' NOT NULL DEFAULT '' AFTER `parent`,
ADD `grade` tinyint(3) unsigned NOT NULL DEFAULT '0' AFTER `path`,
ADD `order` smallint(5) unsigned NOT NULL DEFAULT '0' AFTER `grade`;

ALTER TABLE `zt_product` ADD `feedback` varchar(30) COLLATE 'utf8_general_ci' NOT NULL AFTER `RD`;

ALTER TABLE `zt_leave`       ADD `level` tinyint(3) NOT NULL;
ALTER TABLE `zt_leave`       ADD `assignedTo` varchar(30) NOT NULL;
ALTER TABLE `zt_leave`       ADD `reviewers` text NOT NULL;  
ALTER TABLE `zt_leave`       ADD `backReviewers` text NOT NULL;
ALTER TABLE `zt_lieu`        ADD `level` tinyint(3) NOT NULL;
ALTER TABLE `zt_lieu`        ADD `assignedTo` varchar(30) NOT NULL;
ALTER TABLE `zt_lieu`        ADD `reviewers` text NOT NULL;  
ALTER TABLE `zt_overtime`    ADD `level` tinyint(3) NOT NULL;
ALTER TABLE `zt_overtime`    ADD `assignedTo` varchar(30) NOT NULL;
ALTER TABLE `zt_overtime`    ADD `reviewers` text NOT NULL;  

-- DROP TABLE IF EXISTS `zt_faq`;
CREATE TABLE IF NOT EXISTS `zt_faq` (
`id` mediumint(9) NOT NULL AUTO_INCREMENT,
`module` mediumint(9) NOT NULL,
`product` mediumint(9) NOT NULL,
`question` varchar(255) NOT NULL,
`answer` text NOT NULL,
`addedtime` datetime NOT NULL,
PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

ALTER TABLE `zt_task` ADD `feedback` mediumint(8) unsigned NOT NULL AFTER `fromBug`;
ALTER TABLE `zt_todo` ADD `feedback` mediumint(8) unsigned NOT NULL AFTER `end`;
-- DROP TABLE IF EXISTS `zt_workflow`;
CREATE TABLE IF NOT EXISTS `zt_workflow` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `parent` varchar(30) NOT NULL, 
  `child` varchar(30) NOT NULL, 
  `type` varchar(10) NOT NULL DEFAULT 'flow',
  `app` varchar(20) NOT NULL,
  `position` varchar(30) NOT NULL,
  `module` varchar(30) NOT NULL,
  `table` varchar(50) NOT NULL,
  `name` varchar(30) NOT NULL,
  `flowchart` text NOT NULL,
  `js` text NOT NULL,
  `css` text NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  `buildin` tinyint(1) unsigned NOT NULL,
  `administrator` text NOT NULL,
  `desc` text NOT NULL,
  `version` varchar(10) NOT NULL DEFAULT '1.0',
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `type` (`type`),
  KEY `app` (`app`),
  KEY `module` (`module`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`app`, `module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowaction`;
CREATE TABLE IF NOT EXISTS `zt_workflowaction` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `action` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` enum('single', 'batch') NOT NULL DEFAULT 'single',
  `batchMode` enum('same', 'different') NOT NULL DEFAULT 'different',
  `extensionType` varchar(10) NOT NULL DEFAULT 'override' COMMENT 'none | extend | override',
  `open` varchar(20) NOT NULL,
  `position` enum('menu', 'browseandview', 'browse', 'view') NOT NULL DEFAULT 'browseandview',
  `layout` char(20) NOT NULL,
  `show` enum('dropdownlist', 'direct') NOT NULL DEFAULT 'dropdownlist',
  `order` smallint(5) unsigned NOT NULL,
  `buildin` tinyint(1) unsigned NOT NULL,
  `virtual` tinyint(1) unsigned NOT NULL,
  `conditions` text NOT NULL,
  `verifications` text NOT NULL,
  `hooks` text NOT NULL,
  `linkages` text NOT NULL,
  `js` text NOT NULL,
  `css` text NOT NULL,
  `toList` char(255) NOT NULL,
  `blocks` text NOT NULL,
  `desc` text NOT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'enable',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `module` (`module`),
  KEY `action` (`action`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`module`, `action`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowdatasource`;
CREATE TABLE IF NOT EXISTS `zt_workflowdatasource` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('system', 'sql', 'func', 'option', 'lang', 'category') NOT NULL DEFAULT 'option',
  `name` varchar(30) NOT NULL,
  `datasource` text NOT NULL, 
  `view` varchar(20) NOT NULL,
  `keyField` varchar(50) NOT NULL,
  `valueField` varchar(50) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowfield`;
CREATE TABLE IF NOT EXISTS `zt_workflowfield` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `field`  varchar(50) NOT NULL,
  `type` varchar(20) NOT NULL DEFAULT 'varchar',
  `length` varchar(10) NOT NULL,
  `name` varchar(50) NOT NULL,
  `control` varchar(20) NOT NULL,
  `expression` text NOT NULL,
  `options` text NOT NULL,
  `default` varchar(100) NOT NULL,
  `rules` varchar(255) NOT NULL,
  `placeholder` varchar(100) NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  `searchOrder` smallint(5) unsigned NOT NULL DEFAULT '0', 
  `exportOrder` smallint(5) unsigned NOT NULL DEFAULT '0',
  `canExport` enum('0', '1') NOT NULL DEFAULT '0',
  `canSearch` enum('0', '1') NOT NULL DEFAULT '0',
  `isValue` enum('0', '1') NOT NULL DEFAULT '0',
  `readonly` enum('0', '1') NOT NULL DEFAULT '0',
  `buildin` tinyint(1) unsigned NOT NULL,
  `desc` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `module` (`module`),
  KEY `field` (`field`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`module`, `field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowlayout`;
CREATE TABLE IF NOT EXISTS `zt_workflowlayout` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `action` varchar(50) NOT NULL,
  `field`  varchar(50) NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  `width` smallint(5) NOT NULL,
  `position` text NOT NULL,
  `readonly` enum('0', '1') NOT NULL DEFAULT '0',
  `mobileShow` enum('0', '1') NOT NULL DEFAULT '1',
  `summary` varchar(20) NOT NULL,
  `defaultValue` text NOT NULL,
  `layoutRules` varchar(255) NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `module` (`module`),
  KEY `action` (`action`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`module`, `action`, `field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowlabel`;
CREATE TABLE IF NOT EXISTS `zt_workflowlabel` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `code` varchar(30) NOT NULL,
  `label` varchar(255) NOT NULL,
  `params` text NOT NULL,
  `orderBy` text NOT NULL,
  `order` tinyint(3) NOT NULL,
  `buildin` tinyint(1) unsigned NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowlinkdata`;
CREATE TABLE IF NOT EXISTS `zt_workflowlinkdata` (
  `objectType` varchar(30) NOT NULL,
  `objectID` mediumint(8) unsigned NOT NULL,
  `linkedType` varchar(30) NOT NULL,
  `linkedID` mediumint(8) unsigned NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  UNIQUE KEY `unique` (`objectType`, `objectID`, `linkedType`, `linkedID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowrelation`;
CREATE TABLE IF NOT EXISTS `zt_workflowrelation` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `prev` varchar(30) NOT NULL, 
  `next` varchar(30) NOT NULL,
  `field` varchar(50) NOT NULL,
  `actions` varchar(20) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowrelationlayout`;
CREATE TABLE IF NOT EXISTS `zt_workflowrelationlayout` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `prev` varchar(30) NOT NULL,
  `next` varchar(30) NOT NULL,
  `action` varchar(50) NOT NULL,
  `field` varchar(50) NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `prev` (`prev`),
  KEY `next` (`next`),
  KEY `action` (`action`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`prev`, `next`, `action`, `field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowrule`;
CREATE TABLE IF NOT EXISTS `zt_workflowrule` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('system', 'regex', 'func') NOT NULL DEFAULT 'regex',
  `name` varchar(30) NOT NULL,
  `rule` text NOT NULL, 
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowsql`;
CREATE TABLE IF NOT EXISTS `zt_workflowsql` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `field` varchar(50) NOT NULL,
  `action` varchar(50) NOT NULL,
  `sql` text NOT NULL,
  `vars` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `module` (`module`),
  KEY `field` (`field`),
  KEY `action` (`action`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowversion`;
CREATE TABLE IF NOT EXISTS `zt_workflowversion` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `version` varchar(10) NOT NULL,
  `fields` text NOT NULL,
  `actions` text NOT NULL,
  `layouts` text NOT NULL,
  `sqls` text NOT NULL,
  `labels` text NOT NULL,
  `table` text NOT NULL,
  `datas` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `moduleversion` (`module`, `version`),
  KEY `module` (`module`),
  KEY `version` (`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowreport`;
CREATE TABLE IF NOT EXISTS `zt_workflowreport` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL COMMENT 'module name',
  `name` varchar(100) NOT NULL COMMENT 'report name',
  `type` enum('pie', 'line', 'bar') NOT NULL DEFAULT 'pie' COMMENT 'report type',
  `countType` enum('sum', 'count') NOT NULL DEFAULT 'sum' COMMENT 'report count method',
  `displayType` enum('value', 'percent') NOT NULL DEFAULT 'value' COMMENT 'report display method',
  `dimension` varchar(130) NOT NULL COMMENT 'dimension field code of zt_workflowfield',
  `fields` text NOT NULL COMMENT 'count fileds code of zt_workflowfield,use comma split',
  `order` smallint(5) unsigned NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `zt_action` CHANGE `action` `action` varchar(80) NOT NULL DEFAULT '';
ALTER TABLE `zt_action` CHANGE `extra` `extra` text;
ALTER TABLE `zt_file` CHANGE `objectType` `objectType` char(30) NOT NULL;

INSERT INTO `zt_workflowrule` VALUES (1,'system','必填','notempty','admin','2020-10-14 14:06:14','','0000-00-00 00:00:00'),(2,'system','唯一','unique','admin','2020-10-14 14:06:14','','0000-00-00 00:00:00'),(3,'system','日期','date','admin','2020-10-14 14:06:14','','0000-00-00 00:00:00'),(4,'system','email','email','admin','2020-10-14 14:06:14','','0000-00-00 00:00:00'),(5,'system','数字','float','admin','2020-10-14 14:06:14','','0000-00-00 00:00:00'),(6,'system','电话','phone','admin','2020-10-14 14:06:14','','0000-00-00 00:00:00'),(7,'system','IP','ip','admin','2020-10-14 14:06:14','','0000-00-00 00:00:00');

REPLACE INTO `zt_grouppriv` VALUES
(1,'apppriv','flow'),
(1,'workflow','activate'),
(1,'workflow','backup'),
(1,'workflow','browseDB'),
(1,'workflow','browseFlow'),
(1,'workflow','copy'),
(1,'workflow','create'),
(1,'workflow','deactivate'),
(1,'workflow','delete'),
(1,'workflow','edit'),
(1,'workflow','flowchart'),
(1,'workflow','setCSS'),
(1,'workflow','setJS'),
(1,'workflow','release'),
(1,'workflow','ui'),
(1,'workflow','upgrade'),
(1,'workflow','view'),
(1,'workflowaction','browse'),
(1,'workflowaction','create'),
(1,'workflowaction','delete'),
(1,'workflowaction','edit'),
(1,'workflowaction','setCSS'),
(1,'workflowaction','setJS'),
(1,'workflowaction','setNotice'),
(1,'workflowaction','setVerification'),
(1,'workflowaction','sort'),
(1,'workflowaction','view'),
(1,'workflowcondition','browse'),
(1,'workflowcondition','create'),
(1,'workflowcondition','delete'),
(1,'workflowcondition','edit'),
(1,'workflowdatasource','browse'),
(1,'workflowdatasource','create'),
(1,'workflowdatasource','delete'),
(1,'workflowdatasource','edit'),
(1,'workflowfield','browse'),
(1,'workflowfield','create'),
(1,'workflowfield','delete'),
(1,'workflowfield','edit'),
(1,'workflowfield','export'),
(1,'workflowfield','exportTemplate'),
(1,'workflowfield','setValue'),
(1,'workflowfield','setExport'),
(1,'workflowfield','setSearch'),
(1,'workflowfield','showImport'),
(1,'workflowfield','sort'),
(1,'workflowfield','import'),
(1,'workflowhook','browse'),
(1,'workflowhook','create'),
(1,'workflowhook','delete'),
(1,'workflowhook','edit'),
(1,'workflowlabel','browse'),
(1,'workflowlabel','create'),
(1,'workflowlabel','delete'),
(1,'workflowlabel','edit'),
(1,'workflowlabel','sort'),
(1,'workflowlayout','admin'),
(1,'workflowlayout','block'),
(1,'workflowlinkage','browse'),
(1,'workflowlinkage','create'),
(1,'workflowlinkage','delete'),
(1,'workflowlinkage','edit'),
(1,'workflowrelation','admin'),
(1,'workflowreport','browse'),
(1,'workflowreport','create'),
(1,'workflowreport','edit'),
(1,'workflowreport','delete'),
(1,'workflowreport','sort'),
(1,'workflowrule','browse'),
(1,'workflowrule','create'),
(1,'workflowrule','delete'),
(1,'workflowrule','edit'),
(1,'workflowrule','view');

ALTER TABLE `zt_workflow` ADD `navigator` varchar(10) NOT NULL AFTER `type`;

INSERT INTO `zt_workflowdatasource` (`type`, `name`, `datasource`, `view`, `keyField`, `valueField`) VALUES
('system',      '产品',           '{\"app\":\"system\",\"module\":\"product\",\"method\":\"getPairs\",\"methodDesc\":\"Get product pairs.\",\"params\":[{\"name\":\"mode\",\"type\":\"string\",\"desc\":\"\",\"value\":\"all\"}]}',       '',     '',     ''),
('system',      '项目',           '{\"app\":\"system\",\"module\":\"execution\",\"method\":\"getPairs\",\"methodDesc\":\"Get execution pairs.\",\"params\":[{\"name\":\"mode\",\"type\":\"string\",\"desc\":\"all|noclosed or empty\",\"value\":\"all\"}]}',  '',     '',     ''),
('system',      '产品线',         '{\"app\":\"system\",\"module\":\"product\",\"method\":\"getLinePairs\",\"methodDesc\":\"Get line pairs.\",\"params\":[{\"name\":\"useShort\",\"type\":\"bool\",\"desc\":\"\",\"value\":\"\"}]}',  '',     '',     ''),
('sql',         '需求',           'select id,title from zt_story where deleted=\"0\"',    'view_datasource_4',    'id',   'title'),
('sql',         '任务',           'select id,name from zt_task where deleted=\"0\"',      'view_datasource_5',    'id',   'name'),
('sql',         'Bug',            'select id,title from zt_bug where deleted=\"0\"',      'view_datasource_6',    'id',   'title'),
('system',      '权限分组',       '{\"app\":\"system\",\"module\":\"group\",\"method\":\"getPairs\",\"methodDesc\":\"\",\"params\":[]}',  '',     '',     ''),
('system',      '用户',           '{\"app\":\"system\",\"module\":\"user\",\"method\":\"getPairs\",\"methodDesc\":\"\",\"params\":[{\"name\":\"params\",\"type\":\"\",\"desc\":\"\",\"value\":\"noclosed|noletter\"},{\"name\":\"usersToAppended\",\"type\":\"\",\"desc\":\"\",\"value\":\"\"}]}',        '',     '',     ''),
('system',      '产品分支',       '{\"app\":\"system\",\"module\":\"branch\",\"method\":\"getAllPairs\",\"methodDesc\":\"Get pairs.\",\"params\":[{\"name\":\"params\",\"type\":\"string\",\"desc\":\"\",\"value\":\"\"}]}',      '',     '',     ''),
('sql',         '版本',           'select id,name from zt_build where deleted=\"0\"',     'view_datasource_10',   'id',   'name'),
('sql',         '模块',           'select id,name from zt_module where deleted=\"0\"',    'view_datasource_11',   'id',   'name'),
('sql',         '计划',           'select id,title from zt_productplan where deleted=\"0\"',      'view_datasource_12',   'id',   'title'),
('lang',        '产品类型',       'productType',    '',     '',     ''),
('lang',        '产品状态',       'productStatus',  '',     '',     ''),
('lang',        '产品访问控制',   'productAcl',     '',     '',     ''),
('lang',        '项目类型',       'projectType',    '',     '',     ''),
('lang',        '项目状态',       'projectStatus',  '',     '',     ''),
('lang',        '项目访问控制',   'projectAcl',     '',     '',     ''),
('lang',        '发布状态',       'releaseStatus',  '',     '',     ''),
('lang',        '需求来源',       'storySource',    '',     '',     ''),
('lang',        '需求优先级',     'storyPri',       '',     '',     ''),
('lang',        '需求状态',       'storyStatus',    '',     '',     ''),
('lang',        '需求阶段',       'storyStage',     '',     '',     ''),
('lang',        'Bug严重程度',    'bugSeverity',    '',     '',     ''),
('lang',        'Bug优先级',      'bugPri',         '',     '',     ''),
('lang',        'Bug类型',        'bugType',        '',     '',     ''),
('lang',        'Bug操作系统',    'bugOs',          '',     '',     ''),
('lang',        'Bug浏览器',      'bugBrowser',     '',     '',     ''),
('lang',        'Bug状态',        'bugStatus',      '',     '',     ''),
('lang',        '任务类型',       'taskType',       '',     '',     ''),
('lang',        '任务优先级',     'taskPri',        '',     '',     ''),
('lang',        '任务状态',       'taskStatus',     '',     '',     ''),
('lang',        '测试用例优先级', 'testcasePri',    '',     '',     ''),
('lang',        '测试用例类型',   'testcaseType',   '',     '',     ''),
('lang',        '测试用例阶段',   'testcaseStage',  '',     '',     ''),
('lang',        '测试用例状态',   'testcaseStatus', '',     '',     ''),
('lang',        '测试单优先级',   'testtaskPri',    '',     '',     ''),
('lang',        '测试单状态',     'testtaskStatus', '',     '',     ''),
('lang',        '反馈状态',       'feedbackStatus', '',     '',     ''),
('lang',        'Bug解决方案',    'bugResolution',  '',     '',     ''),
('sql',         '用例',           'select id,title from zt_case where deleted=\"0\"',     'view_datasource_41',   'id',   'title'),
('system',      '反馈分支',       '{\"app\":\"system\",\"module\":\"tree\",\"method\":\"getOptionMenu\",\"methodDesc\":\"Create an option menu in html.\",\"params\":[{\"name\":\"rootID\",\"type\":\"int\",\"desc\":\"\",\"value\":\"0\"},{\"name\":\"type\",\"type\":\"string\",\"desc\":\"\",\"value\":\"feedback\"},{\"name\":\"startModule\",\"type\":\"int\",\"desc\":\"\",\"value\":\"0\"},{\"name\":\"branch\",\"type\":\"\",\"desc\":\"\",\"value\":\"0\"}]}',   '',     '',     ''),
('lang',        '需求类型',       'storyType',    '',     '',     '');

DROP VIEW IF EXISTS `view_datasource_4`;
DROP VIEW IF EXISTS `view_datasource_5`;
DROP VIEW IF EXISTS `view_datasource_6`;
DROP VIEW IF EXISTS `view_datasource_10`;
DROP VIEW IF EXISTS `view_datasource_11`;
DROP VIEW IF EXISTS `view_datasource_12`;
DROP VIEW IF EXISTS `view_datasource_41`;

CREATE VIEW `view_datasource_4`  AS select `id`,`title` from `zt_story` where `deleted` = '0';
CREATE VIEW `view_datasource_5`  AS select `id`,`name` from `zt_task` where `deleted` = '0';
CREATE VIEW `view_datasource_6`  AS select `id`,`title` from `zt_bug` where `deleted` = '0';
CREATE VIEW `view_datasource_10` AS select `id`,`name` from `zt_build` where `deleted` = '0';
CREATE VIEW `view_datasource_11` AS select `id`,`name` from `zt_module` where `deleted` = '0';
CREATE VIEW `view_datasource_12` AS select `id`,`title` from `zt_productplan` where `deleted` = '0';
CREATE VIEW `view_datasource_41` AS select `id`,`title` from `zt_case` where `deleted` = '0';
-- DROP TABLE IF EXISTS `zt_sqlview`;
CREATE TABLE IF NOT EXISTS `zt_sqlview` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` varchar(90) NOT NULL,
  `code` varchar(45) NOT NULL,
  `sql` text NOT NULL,
  `desc` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
ALTER TABLE `zt_doc`
ADD `template` varchar(30) COLLATE 'utf8_general_ci' NOT NULL AFTER `lib`,
ADD `templateType` varchar(30) COLLATE 'utf8_general_ci' NOT NULL AFTER `template`,
ADD `chapterType` varchar(30) COLLATE 'utf8_general_ci' NOT NULL AFTER `templateType`;

ALTER TABLE `zt_story`
ADD `storyChanged` enum('0','1') NOT NULL DEFAULT '0' AFTER `version`;

-- DROP TABLE IF EXISTS `zt_durationestimation`;
CREATE TABLE IF NOT EXISTS `zt_durationestimation` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `stage` mediumint(9) NOT NULL,
  `workload` varchar(255) NOT NULL,
  `worktimeRate` varchar(255) NOT NULL,
  `people` varchar(255) NOT NULL,
  `startDate` date NOT NULL,
  `endDate` date NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_design`;
CREATE TABLE `zt_design` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` varchar(255) NOT NULL,
  `product` varchar(255) NOT NULL,
  `commit` text NOT NULL,
  `commitedBy` varchar(30) NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL,
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `story` char(30) NOT NULL,
  `desc` text NOT NULL,
  `version` smallint(6) NOT NULL,
  `type` char(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `zt_designspec` (
  `design` mediumint(8) NOT NULL,
  `version` smallint(6) NOT NULL,
  `name` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  `files` varchar(255) NOT NULL,
  UNIQUE KEY `design` (`design`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workestimation`;
CREATE TABLE `zt_workestimation` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `scale` decimal(10,2) unsigned NOT NULL,
  `productivity` decimal(10,2) unsigned NOT NULL,
  `duration` decimal(10,2) unsigned NOT NULL,
  `unitLaborCost` decimal(10,2) unsigned NOT NULL,
  `totalLaborCost` decimal(10,2) unsigned NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `dayHour` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_intervention`;
CREATE TABLE `zt_intervention` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `activity` mediumint(8) NOT NULL,
  `status` char(30) NOT NULL,
  `partake` text NOT NULL,
  `begin` date NOT NULL,
  `realBegin` date NOT NULL,
  `situation` varchar(255) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project` (`project`,`activity`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_activity`;
CREATE TABLE `zt_activity` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `process` mediumint(9) NOT NULL,
  `name` varchar(255) NOT NULL,
  `optional` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `order` mediumint(8) DEFAULT '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_auditcl`;
CREATE TABLE `zt_auditcl` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `practiceArea` char(30) NOT NULL,
  `type` char(30) NOT NULL,
  `title` varchar(255) NOT NULL,
  `objectType` char(30) NOT NULL,
  `objectID` int(10) DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_auditplan`;
CREATE TABLE `zt_auditplan` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `dateType` char(30) DEFAULT NULL,
  `config` text,
  `objectID` mediumint(9) NOT NULL,
  `objectType` char(30) NOT NULL,
  `process` mediumint(9) NOT NULL,
  `processType` char(30) NOT NULL,
  `checkDate` date NOT NULL,
  `checkedBy` varchar(30) NOT NULL,
  `realCheckDate` date NOT NULL,
  `result` char(30) NOT NULL,
  `project` mediumint(8) unsigned NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `checkBy` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_auditresult`;
CREATE TABLE `zt_auditresult` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `auditplan` mediumint(8) NOT NULL,
  `listID` mediumint(8) NOT NULL,
  `result` char(30) NOT NULL,
  `checkedBy` varchar(30) NOT NULL,
  `checkedDate` date NOT NULL,
  `comment` text NOT NULL ,
  `assignedTo` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_nc`;
CREATE TABLE `zt_nc` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `auditplan` mediumint(8) NOT NULL,
  `listID` mediumint(8) NOT NULL,
  `title` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  `type` char(30) NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  `severity` char(30) NOT NULL,
  `deadline` date NOT NULL,
  `resolvedBy` varchar(30) NOT NULL,
  `resolution` char(30) NOT NULL,
  `resolvedDate` date NOT NULL,
  `closedBy` varchar(30) NOT NULL,
  `closedDate` date NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_zoutput`;
CREATE TABLE `zt_zoutput` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `activity` mediumint(8) NOT NULL,
  `name` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `optional` char(20) NOT NULL,
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `order` mediumint(8) DEFAULT '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_process`;
CREATE TABLE `zt_process` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` char(30) NOT NULL,
  `abbr` char(30) NOT NULL,
  `desc` text NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `order` mediumint(9) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_holiday`;
CREATE TABLE IF NOT EXISTS `zt_holiday` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `type` enum('holiday', 'working') NOT NULL DEFAULT 'holiday',
  `desc` text NOT NULL,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_programactivity`;
CREATE TABLE `zt_programactivity` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `process` mediumint(8) NOT NULL,
  `activity` mediumint(8) NOT NULL,
  `name` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `reason` varchar(255) NOT NULL,
  `result` char(30) NOT NULL,
  `linkedBy` char(30) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_programoutput`;
CREATE TABLE `zt_programoutput` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `process` mediumint(8) NOT NULL,
  `activity` mediumint(8) NOT NULL,
  `output` mediumint(8) NOT NULL,
  `content` text NOT NULL,
  `name` varchar(255) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `result` char(30) NOT NULL,
  `linkedBy` char(30) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_programprocess`;
CREATE TABLE `zt_programprocess` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `process` mediumint(8) NOT NULL,
  `name` varchar(255) NOT NULL,
  `type` char(30) NOT NULL,
  `abbr` char(30) NOT NULL,
  `desc` text NOT NULL,
  `reason` varchar(255) NOT NULL,
  `linkedBy` char(30) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_basicmeas`;
CREATE TABLE `zt_basicmeas` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `purpose` varchar(50) NOT NULL,
  `scope` char(30) NOT NULL,
  `object` char(30) NOT NULL,
  `name` varchar(90) NOT NULL,
  `code` char(30) NOT NULL,
  `unit` varchar(10) NOT NULL,
  `configure` text,
  `params` text,
  `definition` text,
  `source` varchar(255) DEFAULT NULL,
  `collectType` varchar(30) NOT NULL,
  `collectConf` text NOT NULL,
  `execTime` varchar(30) NOT NULL,
  `collectedBy` varchar(10) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `order` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_budget`;
CREATE TABLE IF NOT EXISTS `zt_budget` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `stage` char(30) NOT NULL,
  `subject` mediumint(8) NOT NULL,
  `amount` char(30) NOT NULL,
  `name` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `lastEditedBy` char(30) NOT NULL,
  `lastEditedDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_meastemplate`;
CREATE TABLE `zt_meastemplate` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_programreport`;
CREATE TABLE `zt_programreport` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `template` mediumint(8) NOT NULL,
  `project` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `params` text NOT NULL,
  `content` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_measrecords`;
CREATE TABLE `zt_measrecords` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL,
  `mid` mediumint(8) NOT NULL,
  `measCode` char(50) NOT NULL DEFAULT '',
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `params` text NOT NULL,
  `year` char(4) NOT NULL,
  `month` char(6) NOT NULL,
  `week` char(8) NOT NULL,
  `day` char(8) NOT NULL,
  `value` varchar(255) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`),

  KEY `product` (`product`),

  KEY `project` (`project`),

  KEY `time` (`year`, `month`, `day`, `week`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_object`;
CREATE TABLE `zt_object` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) NOT NULL,
  `from` mediumint(8) NOT NULL,
  `title` varchar(255) NOT NULL,
  `category` char(30) NOT NULL,
  `version` varchar(255) NOT NULL,
  `type` enum('reviewed','taged') NOT NULL,
  `range` text NOT NULL,
  `data` text NOT NULL,
  `storyEst` char(30) NOT NULL,
  `taskEst` char(30) NOT NULL,
  `requestEst` char(30) NOT NULL,
  `testEst` char(30) NOT NULL,
  `devEst` char(30) NOT NULL,
  `designEst` char(30) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_review`;
CREATE TABLE `zt_review` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `object` mediumint(8) NOT NULL,
  `status` char(30) NOT NULL,
  `reviewedBy` varchar(255) NOT NULL,
  `auditedBy` varchar(255) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deadline` date NOT NULL,
  `lastReviewedBy` varchar(255) DEFAULT NULL,
  `lastReviewedDate` date NOT NULL,
  `lastAuditedBy` varchar(255) NOT NULL,
  `lastAuditedDate` date NOT NULL,
  `lastEditedBy` varchar(255) NOT NULL,
  `lastEditedDate` date NOT NULL,
  `result` char(30) NOT NULL,
  `auditResult` char(30) NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=39 DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_reviewcl`;
CREATE TABLE `zt_reviewcl` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `object` char(30) NOT NULL,
  `category` char(30) NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `order` mediumint(8) DEFAULT '0',
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_reviewresult`;
CREATE TABLE `zt_reviewresult` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `review` mediumint(8) NOT NULL,
  `type` char(30) NOT NULL DEFAULT 'review',
  `result` char(30) NOT NULL,
  `opinion` varchar(255) NOT NULL,
  `reviewer` char(30) NOT NULL,
  `remainIssue` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `consumed` float NOT NULL,
  UNIQUE KEY `reviewer` (`review`,`reviewer`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_reviewissue`;
CREATE TABLE `zt_reviewissue` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `review` mediumint(8) NOT NULL,
  `injection` mediumint(8) NOT NULL,
  `identify` mediumint(8) NOT NULL,
  `type` char(30) NOT NULL DEFAULT 'review',
  `listID` mediumint(8) NOT NULL,
  `title` varchar(255) NOT NULL,
  `opinion` varchar(255) NOT NULL,
  `opinionDate` DATE NOT NULL,
  `status` char(30) NOT NULL,
  `resolution` char(30) NOT NULL,
  `resolutionBy` CHAR(30) NOT NULL,
  `resolutionDate` DATE NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_reviewlist`;
CREATE TABLE `zt_reviewlist` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `title` varchar(255) NOT NULL,
  `object` char(30) NOT NULL,
  `category` char(30) NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_cmcl`;
CREATE TABLE `zt_cmcl` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` char(30) NOT NULL,
  `title` int(11) NOT NULL,
  `contents` text NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `order` int(11) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_solutions`;
CREATE TABLE `zt_solutions` (
 `id` mediumint(8) NOT NULL AUTO_INCREMENT,
 `project` mediumint(8) unsigned NOT NULL,
 `execution` mediumint(8) unsigned NOT NULL,
 `contents` text NOT NULL COMMENT '问题描述',
 `support` text NOT NULL COMMENT '是否需要高层支持',
 `measures` text NOT NULL COMMENT '解决建议',
 `type` char(30) NOT NULL,
 `addedBy` varchar(30) NOT NULL,
 `addedDate` date NOT NULL,
 `editedBy` varchar(30) NOT NULL,
 `editedDate` date NOT NULL,
 `deleted` enum('0','1') NOT NULL DEFAULT '0',
 PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_stage`;
CREATE TABLE IF NOT EXISTS `zt_stage` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `percent` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_measqueue`;
CREATE TABLE `zt_measqueue` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL,
  `mid` mediumint(8) unsigned NOT NULL,
  `status` varchar(255) NOT NULL,
  `logs` text,
  `execTime` varchar(10) NOT NULL,
  `params` text,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `updateDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_issue`;
CREATE TABLE IF NOT EXISTS `zt_issue` (
  `id` mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  `resolvedBy` varchar(30) NOT NULL,
  `project` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  `pri` char(30) NOT NULL,
  `severity` char(30) NOT NULL,
  `type` char(30) NOT NULL,
  `activity` varchar(255) NOT NULL,
  `deadline` date NOT NULL,
  `resolution` char(30) NOT NULL,
  `resolutionComment` text NOT NULL,
  `objectID` varchar(255) NOT NULL,
  `resolvedDate` date NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `activateBy` varchar(30) NOT NULL,
  `activateDate` date NOT NULL,
  `closedBy` varchar(30) NOT NULL,
  `closedDate` date NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_risk`;
CREATE TABLE IF NOT EXISTS `zt_risk` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `source` char(30) NOT NULL,
  `category` char(30) NOT NULL,
  `strategy` char(30) NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  `impact` char(30) NOT NULL,
  `probability` char(30) NOT NULL,
  `rate` char(30) NOT NULL,
  `pri` char(30) NOT NULL,
  `identifiedDate` date NOT NULL,
  `prevention` text NOT NULL,
  `remedy` text NOT NULL,
  `plannedClosedDate` date NOT NULL,
  `actualClosedDate` date NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `resolution` text NOT NULL,
  `resolvedBy` varchar(30) NOT NULL,
  `activateBy` varchar(30) NOT NULL,
  `activateDate` date NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `closedBy` varchar(30) NOT NULL,
  `closedDate` date NOT NULL,
  `cancelBy` varchar(30) NOT NULL,
  `cancelDate` date NOT NULL,
  `cancelReason` char(30) NOT NULL,
  `hangupBy` varchar(30) NOT NULL,
  `hangupDate` date NOT NULL,
  `trackedBy` varchar(30) NOT NULL,
  `trackedDate` date NOT NULL,
  `assignedDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_weeklyreport`;
CREATE TABLE IF NOT EXISTS `zt_weeklyreport`(
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `weekStart` date NOT NULL,
  `pv` float(9,2) NOT NULL,
  `ev` float(9,2) NOT NULL,
  `ac` float(9,2) NOT NULL,
  `sv` float(9,2) NOT NULL,
  `cv` float(9,2) NOT NULL,
  `staff` smallint(5) unsigned NOT NULL,
  `progress` varchar(255) NOT NULL,
  `workload` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `week` (`project`,`weekStart`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `zt_bug`
ADD `injection` mediumint(8) unsigned NOT NULL AFTER `product`,
ADD `identify` mediumint(8) unsigned NOT NULL AFTER `injection`;

ALTER TABLE `zt_team` ADD `position` varchar(30) not null AFTER role;

REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'action', 'comment'),
(1, 'action', 'editComment'),
(1, 'action', 'hideAll'),
(1, 'action', 'hideOne'),
(1, 'action', 'trash'),
(1, 'action', 'undelete'),
(1, 'activity', '12'),
(1, 'activity', 'assign'),
(1, 'activity', 'batchassign'),
(1, 'activity', 'batchcreate'),
(1, 'activity', 'batchedit'),
(1, 'activity', 'browse'),
(1, 'activity', 'create'),
(1, 'activity', 'delete'),
(1, 'activity', 'edit'),
(1, 'activity', 'export'),
(1, 'activity', 'exporttemplate'),
(1, 'activity', 'import'),
(1, 'activity', 'link'),
(1, 'activity', 'outputlist'),
(1, 'activity', 'search'),
(1, 'activity', 'showimport'),
(1, 'activity', 'unlink'),
(1, 'activity', 'view'),
(1, 'admin', 'checkDB'),
(1, 'admin', 'checkWeak'),
(1, 'admin', 'index'),
(1, 'admin', 'safe'),
(1, 'admin', 'sso'),
(1, 'admin', 'xuanxuan'),
(1, 'api', 'debug'),
(1, 'api', 'getModel'),
(1, 'api', 'sql'),
(1, 'apppriv', 'flow'),
(1, 'audit', '8'),
(1, 'audit', 'assign'),
(1, 'audit', 'batchassign'),
(1, 'audit', 'batchcreate'),
(1, 'audit', 'batchedit'),
(1, 'audit', 'browse'),
(1, 'audit', 'create'),
(1, 'audit', 'delete'),
(1, 'audit', 'edit'),
(1, 'audit', 'export'),
(1, 'audit', 'exporttemplate'),
(1, 'audit', 'import'),
(1, 'audit', 'link'),
(1, 'audit', 'search'),
(1, 'audit', 'showimport'),
(1, 'audit', 'unlink'),
(1, 'audit', 'view'),
(1, 'auditcl', 'assign'),
(1, 'auditcl', 'batchassign'),
(1, 'auditcl', 'batchcreate'),
(1, 'auditcl', 'batchedit'),
(1, 'auditcl', 'browse'),
(1, 'auditcl', 'create'),
(1, 'auditcl', 'delete'),
(1, 'auditcl', 'edit'),
(1, 'auditcl', 'export'),
(1, 'auditcl', 'exporttemplate'),
(1, 'auditcl', 'import'),
(1, 'auditcl', 'link'),
(1, 'auditcl', 'search'),
(1, 'auditcl', 'showimport'),
(1, 'auditcl', 'unlink'),
(1, 'auditcl', 'view'),
(1, 'auditplan', '9'),
(1, 'auditplan', 'assign'),
(1, 'auditplan', 'batchassign'),
(1, 'auditplan', 'batchcreate'),
(1, 'auditplan', 'batchedit'),
(1, 'auditplan', 'browse'),
(1, 'auditplan', 'create'),
(1, 'auditplan', 'delete'),
(1, 'auditplan', 'edit'),
(1, 'auditplan', 'export'),
(1, 'auditplan', 'exporttemplate'),
(1, 'auditplan', 'import'),
(1, 'auditplan', 'link'),
(1, 'auditplan', 'nc'),
(1, 'auditplan', 'result'),
(1, 'auditplan', 'search'),
(1, 'auditplan', 'showimport'),
(1, 'auditplan', 'unlink'),
(1, 'auditplan', 'view'),
(1, 'auditresult', '10'),
(1, 'auditresult', 'assign'),
(1, 'auditresult', 'batchassign'),
(1, 'auditresult', 'batchcreate'),
(1, 'auditresult', 'batchedit'),
(1, 'auditresult', 'browse'),
(1, 'auditresult', 'create'),
(1, 'auditresult', 'delete'),
(1, 'auditresult', 'edit'),
(1, 'auditresult', 'export'),
(1, 'auditresult', 'exporttemplate'),
(1, 'auditresult', 'import'),
(1, 'auditresult', 'link'),
(1, 'auditresult', 'search'),
(1, 'auditresult', 'showimport'),
(1, 'auditresult', 'unlink'),
(1, 'auditresult', 'view'),
(1, 'backup', 'backup'),
(1, 'backup', 'change'),
(1, 'backup', 'delete'),
(1, 'backup', 'index'),
(1, 'backup', 'restore'),
(1, 'backup', 'rmPHPHeader'),
(1, 'backup', 'setting'),
(1, 'baseline', 'articleview'),
(1, 'baseline', 'catalog'),
(1, 'baseline', 'createTemplate'),
(1, 'baseline', 'delete'),
(1, 'baseline', 'editBook'),
(1, 'baseline', 'editTemplate'),
(1, 'baseline', 'manageBook'),
(1, 'baseline', 'template'),
(1, 'baseline', 'version'),
(1, 'baseline', 'view'),
(1, 'branch', 'delete'),
(1, 'branch', 'manage'),
(1, 'branch', 'sort'),
(1, 'budget', 'batchCreate'),
(1, 'budget', 'browse'),
(1, 'budget', 'create'),
(1, 'budget', 'delete'),
(1, 'budget', 'edit'),
(1, 'budget', 'summary'),
(1, 'budget', 'view'),
(1, 'bug', 'activate'),
(1, 'bug', 'assignTo'),
(1, 'bug', 'batchActivate'),
(1, 'bug', 'batchAssignTo'),
(1, 'bug', 'batchChangeBranch'),
(1, 'bug', 'batchChangeModule'),
(1, 'bug', 'batchClose'),
(1, 'bug', 'batchConfirm'),
(1, 'bug', 'batchCreate'),
(1, 'bug', 'batchEdit'),
(1, 'bug', 'batchResolve'),
(1, 'bug', 'browse'),
(1, 'bug', 'close'),
(1, 'bug', 'confirmBug'),
(1, 'bug', 'confirmStoryChange'),
(1, 'bug', 'create'),
(1, 'bug', 'delete'),
(1, 'bug', 'edit'),
(1, 'bug', 'export'),
(1, 'bug', 'exportTemplet'),
(1, 'bug', 'import'),
(1, 'bug', 'index'),
(1, 'bug', 'linkBugs'),
(1, 'bug', 'report'),
(1, 'bug', 'resolve'),
(1, 'bug', 'showImport'),
(1, 'bug', 'view'),
(1, 'build', 'batchUnlinkBug'),
(1, 'build', 'batchUnlinkStory'),
(1, 'build', 'create'),
(1, 'build', 'delete'),
(1, 'build', 'edit'),
(1, 'build', 'linkBug'),
(1, 'build', 'linkStory'),
(1, 'build', 'unlinkBug'),
(1, 'build', 'unlinkStory'),
(1, 'build', 'view'),
(1, 'caselib', 'batchCreateCase'),
(1, 'caselib', 'browse'),
(1, 'caselib', 'create'),
(1, 'caselib', 'createCase'),
(1, 'caselib', 'delete'),
(1, 'caselib', 'edit'),
(1, 'caselib', 'exportTemplet'),
(1, 'caselib', 'import'),
(1, 'caselib', 'index'),
(1, 'caselib', 'showImport'),
(1, 'caselib', 'view'),
(1, 'classify', 'browse'),
(1, 'client', 'browse'),
(1, 'client', 'checkUpgrade'),
(1, 'client', 'create'),
(1, 'client', 'delete'),
(1, 'client', 'edit'),
(1, 'cm', 'browse'),
(1, 'cm', 'create'),
(1, 'cm', 'delete'),
(1, 'cm', 'edit'),
(1, 'cm', 'report'),
(1, 'cm', 'view'),
(1, 'cmcl', 'assign'),
(1, 'cmcl', 'batchassign'),
(1, 'cmcl', 'batchcreate'),
(1, 'cmcl', 'batchedit'),
(1, 'cmcl', 'browse'),
(1, 'cmcl', 'create'),
(1, 'cmcl', 'delete'),
(1, 'cmcl', 'edit'),
(1, 'cmcl', 'export'),
(1, 'cmcl', 'exporttemplate'),
(1, 'cmcl', 'import'),
(1, 'cmcl', 'link'),
(1, 'cmcl', 'search'),
(1, 'cmcl', 'showimport'),
(1, 'cmcl', 'unlink'),
(1, 'cmcl', 'view'),
(1, 'company', 'alleffort'),
(1, 'company', 'allTodo'),
(1, 'company', 'browse'),
(1, 'company', 'calendar'),
(1, 'company', 'dynamic'),
(1, 'company', 'edit'),
(1, 'company', 'effort'),
(1, 'company', 'index'),
(1, 'company', 'todo'),
(1, 'company', 'view'),
(1, 'compile', 'browse'),
(1, 'compile', 'logs'),
(1, 'convert', 'checkBugFree'),
(1, 'convert', 'checkConfig'),
(1, 'convert', 'checkRedmine'),
(1, 'convert', 'convertBugFree'),
(1, 'convert', 'convertRedmine'),
(1, 'convert', 'execute'),
(1, 'convert', 'index'),
(1, 'convert', 'selectSource'),
(1, 'convert', 'setBugfree'),
(1, 'convert', 'setConfig'),
(1, 'convert', 'setRedmine'),
(1, 'cron', 'create'),
(1, 'cron', 'delete'),
(1, 'cron', 'edit'),
(1, 'cron', 'index'),
(1, 'cron', 'openProcess'),
(1, 'cron', 'toggle'),
(1, 'cron', 'turnon'),
(1, 'custom', 'estimate'),
(1, 'custom', 'feedback'),
(1, 'custom', 'flow'),
(1, 'custom', 'index'),
(1, 'custom', 'libreoffice'),
(1, 'custom', 'restore'),
(1, 'custom', 'set'),
(1, 'custom', 'setPublic'),
(1, 'custom', 'timezone'),
(1, 'custom', 'working'),
(1, 'datatable', 'setGlobal'),
(1, 'dept', 'browse'),
(1, 'dept', 'delete'),
(1, 'dept', 'edit'),
(1, 'dept', 'manageChild'),
(1, 'dept', 'updateOrder'),
(1, 'design', '23'),
(1, 'design', 'assign'),
(1, 'design', 'batchassign'),
(1, 'design', 'batchcreate'),
(1, 'design', 'batchedit'),
(1, 'design', 'browse'),
(1, 'design', 'commit'),
(1, 'design', 'create'),
(1, 'design', 'delete'),
(1, 'design', 'edit'),
(1, 'design', 'export'),
(1, 'design', 'search'),
(1, 'design', 'view'),
(1, 'dev', 'api'),
(1, 'dev', 'db'),
(1, 'dev', 'editor'),
(1, 'dev', 'translate'),
(1, 'doc', 'allLibs'),
(1, 'doc', 'browse'),
(1, 'doc', 'catalog'),
(1, 'doc', 'collect'),
(1, 'doc', 'create'),
(1, 'doc', 'createLib'),
(1, 'doc', 'delete'),
(1, 'doc', 'deleteFile'),
(1, 'doc', 'deleteLib'),
(1, 'doc', 'diff'),
(1, 'doc', 'edit'),
(1, 'doc', 'editLib'),
(1, 'doc', 'index'),
(1, 'doc', 'managebook'),
(1, 'doc', 'objectLibs'),
(1, 'doc', 'showFiles'),
(1, 'doc', 'sort'),
(1, 'doc', 'view'),
(1, 'durationestimation', 'create'),
(1, 'durationestimation', 'index'),
(1, 'effort', 'batchCreate'),
(1, 'effort', 'batchEdit'),
(1, 'effort', 'calendar'),
(1, 'effort', 'createForObject'),
(1, 'effort', 'delete'),
(1, 'effort', 'edit'),
(1, 'effort', 'export'),
(1, 'effort', 'view'),
(1, 'extension', 'activate'),
(1, 'extension', 'browse'),
(1, 'extension', 'deactivate'),
(1, 'extension', 'erase'),
(1, 'extension', 'install'),
(1, 'extension', 'obtain'),
(1, 'extension', 'structure'),
(1, 'extension', 'uninstall'),
(1, 'extension', 'upgrade'),
(1, 'extension', 'upload'),
(1, 'faq', 'browse'),
(1, 'feedback', 'admin'),
(1, 'feedback', 'adminview'),
(1, 'feedback', 'close'),
(1, 'file', 'delete'),
(1, 'file', 'download'),
(1, 'file', 'edit'),
(1, 'file', 'setPublic'),
(1, 'file', 'uploadImages'),
(1, 'git', 'apiSync'),
(1, 'git', 'cat'),
(1, 'git', 'diff'),
(1, 'group', 'browse'),
(1, 'group', 'copy'),
(1, 'group', 'create'),
(1, 'group', 'delete'),
(1, 'group', 'edit'),
(1, 'group', 'manageMember'),
(1, 'group', 'managePriv'),
(1, 'group', 'manageView'),
(1, 'holiday', 'browse'),
(1, 'holiday', 'create'),
(1, 'holiday', 'delete'),
(1, 'holiday', 'edit'),
(1, 'host', 'browse'),
(1, 'host', 'create'),
(1, 'host', 'delete'),
(1, 'host', 'edit'),
(1, 'host', 'treemap'),
(1, 'host', 'view'),
(1, 'im', 'getChatGroups'),
(1, 'im', 'getChatUsers'),
(1, 'im', 'notifyMSG'),
(1, 'index', 'index'),
(1, 'issue', '17'),
(1, 'issue', '18'),
(1, 'issue', '19'),
(1, 'issue', '20'),
(1, 'issue', '21'),
(1, 'issue', '22'),
(1, 'issue', 'activate'),
(1, 'issue', 'assign'),
(1, 'issue', 'batchassign'),
(1, 'issue', 'batchcreate'),
(1, 'issue', 'batchedit'),
(1, 'issue', 'browse'),
(1, 'issue', 'cancel'),
(1, 'issue', 'close'),
(1, 'issue', 'create'),
(1, 'issue', 'delete'),
(1, 'issue', 'edit'),
(1, 'issue', 'export'),
(1, 'issue', 'resolve'),
(1, 'issue', 'search'),
(1, 'issue', 'view'),
(1, 'jenkins', 'browse'),
(1, 'jenkins', 'create'),
(1, 'jenkins', 'delete'),
(1, 'jenkins', 'edit'),
(1, 'job', 'browse'),
(1, 'job', 'create'),
(1, 'job', 'delete'),
(1, 'job', 'edit'),
(1, 'job', 'exec'),
(1, 'ldap', 'index'),
(1, 'ldap', 'set'),
(1, 'mail', 'batchDelete'),
(1, 'mail', 'browse'),
(1, 'mail', 'delete'),
(1, 'mail', 'detect'),
(1, 'mail', 'edit'),
(1, 'mail', 'index'),
(1, 'mail', 'resend'),
(1, 'mail', 'reset'),
(1, 'mail', 'save'),
(1, 'mail', 'sendCloud'),
(1, 'mail', 'sendcloudUser'),
(1, 'mail', 'test'),
(1, 'measrecord', 'browse'),
(1, 'measurement', 'batchEdit'),
(1, 'measurement', 'browse'),
(1, 'measurement', 'createBasic'),
(1, 'measurement', 'createTemplate'),
(1, 'measurement', 'delete'),
(1, 'measurement', 'design'),
(1, 'measurement', 'designPHP'),
(1, 'measurement', 'designSQL'),
(1, 'measurement', 'editBasic'),
(1, 'measurement', 'editDerivation'),
(1, 'measurement', 'editTemplate'),
(1, 'measurement', 'execCrontabQueue'),
(1, 'measurement', 'initCrontabQueue'),
(1, 'measurement', 'searchMeas'),
(1, 'measurement', 'setTips'),
(1, 'measurement', 'template'),
(1, 'measurement', 'viewTemplate'),
(1, 'message', 'browser'),
(1, 'message', 'index'),
(1, 'message', 'setting'),
(1, 'milestone', 'index'),
(1, 'milestone', 'saveOtherProblem'),
(1, 'misc', 'ping'),
(1, 'my', 'bug'),
(1, 'my', 'calendar'),
(1, 'my', 'changePassword'),
(1, 'my', 'deleteContacts'),
(1, 'my', 'dynamic'),
(1, 'my', 'editProfile'),
(1, 'my', 'effort'),
(1, 'my', 'index'),
(1, 'my', 'manageContacts'),
(1, 'my', 'nc'),
(1, 'my', 'profile'),
(1, 'my', 'program'),
(1, 'my', 'project'),
(1, 'my', 'requirement'),
(1, 'my', 'review'),
(1, 'my', 'score'),
(1, 'my', 'story'),
(1, 'my', 'task'),
(1, 'my', 'testCase'),
(1, 'my', 'testTask'),
(1, 'my', 'todo'),
(1, 'my', 'unbind'),
(1, 'nc', '16'),
(1, 'nc', 'activate'),
(1, 'nc', 'assign'),
(1, 'nc', 'batchassign'),
(1, 'nc', 'batchcreate'),
(1, 'nc', 'batchedit'),
(1, 'nc', 'browse'),
(1, 'nc', 'close'),
(1, 'nc', 'create'),
(1, 'nc', 'delete'),
(1, 'nc', 'edit'),
(1, 'nc', 'export'),
(1, 'nc', 'exporttemplate'),
(1, 'nc', 'import'),
(1, 'nc', 'link'),
(1, 'nc', 'resolve'),
(1, 'nc', 'search'),
(1, 'nc', 'showimport'),
(1, 'nc', 'unlink'),
(1, 'nc', 'view'),
(1, 'output', '13'),
(1, 'output', 'assign'),
(1, 'output', 'batchassign'),
(1, 'output', 'batchcreate'),
(1, 'output', 'batchedit'),
(1, 'output', 'browse'),
(1, 'output', 'create'),
(1, 'output', 'delete'),
(1, 'output', 'edit'),
(1, 'output', 'export'),
(1, 'output', 'exporttemplate'),
(1, 'output', 'import'),
(1, 'output', 'link'),
(1, 'output', 'search'),
(1, 'output', 'showimport'),
(1, 'output', 'unlink'),
(1, 'output', 'view'),
(1, 'process', '11'),
(1, 'process', 'activitylist'),
(1, 'process', 'assign'),
(1, 'process', 'batchassign'),
(1, 'process', 'batchcreate'),
(1, 'process', 'batchedit'),
(1, 'process', 'browse'),
(1, 'process', 'create'),
(1, 'process', 'delete'),
(1, 'process', 'edit'),
(1, 'process', 'export'),
(1, 'process', 'exporttemplate'),
(1, 'process', 'import'),
(1, 'process', 'link'),
(1, 'process', 'search'),
(1, 'process', 'showimport'),
(1, 'process', 'unlink'),
(1, 'process', 'view'),
(1, 'product', 'all'),
(1, 'product', 'browse'),
(1, 'product', 'close'),
(1, 'product', 'create'),
(1, 'product', 'delete'),
(1, 'product', 'edit'),
(1, 'product', 'index'),
(1, 'product', 'view'),
(1, 'productplan', 'batchEdit'),
(1, 'productplan', 'batchUnlinkBug'),
(1, 'productplan', 'batchUnlinkStory'),
(1, 'productplan', 'browse'),
(1, 'productplan', 'create'),
(1, 'productplan', 'delete'),
(1, 'productplan', 'edit'),
(1, 'productplan', 'linkBug'),
(1, 'productplan', 'linkStory'),
(1, 'productplan', 'unlinkBug'),
(1, 'productplan', 'unlinkStory'),
(1, 'productplan', 'view'),
(1, 'project', 'activate'),
(1, 'project', 'all'),
(1, 'project', 'batchUnlinkStory'),
(1, 'project', 'browse'),
(1, 'project', 'bug'),
(1, 'project', 'build'),
(1, 'project', 'burn'),
(1, 'project', 'burnData'),
(1, 'project', 'calendar'),
(1, 'project', 'close'),
(1, 'project', 'computeBurn'),
(1, 'project', 'computeTaskEffort'),
(1, 'project', 'create'),
(1, 'project', 'delete'),
(1, 'project', 'deleterelation'),
(1, 'project', 'edit'),
(1, 'project', 'effort'),
(1, 'project', 'effortCalendar'),
(1, 'project', 'export'),
(1, 'project', 'fixFirst'),
(1, 'project', 'gantt'),
(1, 'project', 'grouptask'),
(1, 'project', 'importBug'),
(1, 'project', 'importplanstories'),
(1, 'project', 'importtask'),
(1, 'project', 'index'),
(1, 'project', 'kanban'),
(1, 'project', 'kanbanColsColor'),
(1, 'project', 'kanbanHideCols'),
(1, 'project', 'linkStory'),
(1, 'project', 'maintainrelation'),
(1, 'project', 'manageMembers'),
(1, 'project', 'printKanban'),
(1, 'project', 'relation'),
(1, 'project', 'story'),
(1, 'project', 'storyKanban'),
(1, 'project', 'storySort'),
(1, 'project', 'task'),
(1, 'project', 'taskEffort'),
(1, 'project', 'team'),
(1, 'project', 'testtask'),
(1, 'project', 'tree'),
(1, 'project', 'treeStory'),
(1, 'project', 'treeTask'),
(1, 'project', 'unlinkMember'),
(1, 'project', 'unlinkStory'),
(1, 'project', 'updateOrder'),
(1, 'project', 'view'),
(1, 'pssp', 'browse'),
(1, 'pssp', 'update'),
(1, 'qa', 'index'),
(1, 'release', 'batchUnlinkBug'),
(1, 'release', 'batchUnlinkStory'),
(1, 'release', 'browse'),
(1, 'release', 'changeStatus'),
(1, 'release', 'create'),
(1, 'release', 'delete'),
(1, 'release', 'edit'),
(1, 'release', 'export'),
(1, 'release', 'linkBug'),
(1, 'release', 'linkStory'),
(1, 'release', 'unlinkBug'),
(1, 'release', 'unlinkStory'),
(1, 'release', 'view'),
(1, 'repo', 'addBug'),
(1, 'repo', 'addComment'),
(1, 'repo', 'blame'),
(1, 'repo', 'browse'),
(1, 'repo', 'create'),
(1, 'repo', 'delete'),
(1, 'repo', 'deleteBug'),
(1, 'repo', 'deleteComment'),
(1, 'repo', 'diff'),
(1, 'repo', 'download'),
(1, 'repo', 'edit'),
(1, 'repo', 'editBug'),
(1, 'repo', 'editComment'),
(1, 'repo', 'log'),
(1, 'repo', 'maintain'),
(1, 'repo', 'review'),
(1, 'repo', 'revision'),
(1, 'repo', 'setRules'),
(1, 'repo', 'showSyncCommit'),
(1, 'repo', 'view'),
(1, 'report', 'browseReport'),
(1, 'report', 'bugAssign'),
(1, 'report', 'bugAssignSummary'),
(1, 'report', 'bugCreate'),
(1, 'report', 'bugSummary'),
(1, 'report', 'build'),
(1, 'report', 'casesrun'),
(1, 'report', 'crystalExport'),
(1, 'report', 'custom'),
(1, 'report', 'deleteReport'),
(1, 'report', 'editReport'),
(1, 'report', 'export'),
(1, 'report', 'index'),
(1, 'report', 'productSummary'),
(1, 'report', 'programSummary'),
(1, 'report', 'programWorkload'),
(1, 'report', 'projectDeviation'),
(1, 'report', 'reportExport'),
(1, 'report', 'roadmap'),
(1, 'report', 'saveReport'),
(1, 'report', 'show'),
(1, 'report', 'storyLinkedBug'),
(1, 'report', 'testcase'),
(1, 'report', 'useReport'),
(1, 'report', 'workAssignSummary'),
(1, 'report', 'workload'),
(1, 'report', 'workSummary'),
(1, 'review', 'assess'),
(1, 'review', 'audit'),
(1, 'review', 'browse'),
(1, 'review', 'create'),
(1, 'review', 'edit'),
(1, 'review', 'recall'),
(1, 'review', 'report'),
(1, 'review', 'result'),
(1, 'review', 'submit'),
(1, 'review', 'toAudit'),
(1, 'review', 'view'),
(1, 'reviewcl', 'assign'),
(1, 'reviewcl', 'batchassign'),
(1, 'reviewcl', 'batchcreate'),
(1, 'reviewcl', 'batchedit'),
(1, 'reviewcl', 'browse'),
(1, 'reviewcl', 'create'),
(1, 'reviewcl', 'delete'),
(1, 'reviewcl', 'edit'),
(1, 'reviewcl', 'export'),
(1, 'reviewcl', 'exporttemplate'),
(1, 'reviewcl', 'import'),
(1, 'reviewcl', 'search'),
(1, 'reviewcl', 'view'),
(1, 'reviewissue', 'create'),
(1, 'reviewissue', 'edit'),
(1, 'reviewissue', 'issue'),
(1, 'reviewissue', 'resolved'),
(1, 'reviewissue', 'updateStatus'),
(1, 'reviewissue', 'view'),
(1, 'reviewsetting', 'reviewer'),
(1, 'reviewsetting', 'version'),
(1, 'risk', '1'),
(1, 'risk', '2'),
(1, 'risk', '3'),
(1, 'risk', '4'),
(1, 'risk', '5'),
(1, 'risk', '6'),
(1, 'risk', 'activate'),
(1, 'risk', 'assign'),
(1, 'risk', 'batchassign'),
(1, 'risk', 'batchcreate'),
(1, 'risk', 'batchedit'),
(1, 'risk', 'browse'),
(1, 'risk', 'cancel'),
(1, 'risk', 'check'),
(1, 'risk', 'close'),
(1, 'risk', 'create'),
(1, 'risk', 'delete'),
(1, 'risk', 'edit'),
(1, 'risk', 'export'),
(1, 'risk', 'hangup'),
(1, 'risk', 'search'),
(1, 'risk', 'view'),
(1, 'search', 'buildForm'),
(1, 'search', 'buildIndex'),
(1, 'search', 'buildQuery'),
(1, 'search', 'deleteQuery'),
(1, 'search', 'index'),
(1, 'search', 'saveQuery'),
(1, 'search', 'select'),
(1, 'setting', 'downloadxxd'),
(1, 'setting', 'xuanxuan'),
(1, 'sms', 'index'),
(1, 'sms', 'test'),
(1, 'sqlbuilder', 'browseSQLView'),
(1, 'sqlbuilder', 'create'),
(1, 'sqlbuilder', 'createSQLView'),
(1, 'sqlbuilder', 'deleteSQLView'),
(1, 'sqlbuilder', 'editSQLView'),
(1, 'stage', '24'),
(1, 'stage', 'assign'),
(1, 'stage', 'batchassign'),
(1, 'stage', 'batchcreate'),
(1, 'stage', 'batchedit'),
(1, 'stage', 'browse'),
(1, 'stage', 'create'),
(1, 'stage', 'delete'),
(1, 'stage', 'edit'),
(1, 'stage', 'export'),
(1, 'stage', 'exporttemplate'),
(1, 'stage', 'import'),
(1, 'stage', 'search'),
(1, 'stage', 'view'),
(1, 'story', 'activate'),
(1, 'story', 'assignTo'),
(1, 'story', 'batchAssignTo'),
(1, 'story', 'batchChangeBranch'),
(1, 'story', 'batchChangeModule'),
(1, 'story', 'batchChangePlan'),
(1, 'story', 'batchChangeStage'),
(1, 'story', 'batchClose'),
(1, 'story', 'batchCreate'),
(1, 'story', 'batchEdit'),
(1, 'story', 'batchReview'),
(1, 'story', 'browse'),
(1, 'story', 'bugs'),
(1, 'story', 'cases'),
(1, 'story', 'change'),
(1, 'story', 'close'),
(1, 'story', 'create'),
(1, 'story', 'delete'),
(1, 'story', 'edit'),
(1, 'story', 'export'),
(1, 'story', 'exportTemplet'),
(1, 'story', 'import'),
(1, 'story', 'linkStory'),
(1, 'story', 'processStoryChange'),
(1, 'story', 'relation'),
(1, 'story', 'report'),
(1, 'story', 'review'),
(1, 'story', 'showImport'),
(1, 'story', 'submit'),
(1, 'story', 'tasks'),
(1, 'story', 'track'),
(1, 'story', 'view'),
(1, 'story', 'zeroCase'),
(1, 'subject', 'browse'),
(1, 'svn', 'apiSync'),
(1, 'svn', 'cat'),
(1, 'svn', 'diff'),
(1, 'task', 'activate'),
(1, 'task', 'assignTo'),
(1, 'task', 'batchAssignTo'),
(1, 'task', 'batchCancel'),
(1, 'task', 'batchChangeModule'),
(1, 'task', 'batchClose'),
(1, 'task', 'batchCreate'),
(1, 'task', 'batchEdit'),
(1, 'task', 'cancel'),
(1, 'task', 'close'),
(1, 'task', 'confirmdesignchange'),
(1, 'task', 'confirmStoryChange'),
(1, 'task', 'create'),
(1, 'task', 'delete'),
(1, 'task', 'deleteEstimate'),
(1, 'task', 'edit'),
(1, 'task', 'editEstimate'),
(1, 'task', 'export'),
(1, 'task', 'exportTemplet'),
(1, 'task', 'finish'),
(1, 'task', 'import'),
(1, 'task', 'pause'),
(1, 'task', 'recordEstimate'),
(1, 'task', 'report'),
(1, 'task', 'restart'),
(1, 'task', 'showImport'),
(1, 'task', 'start'),
(1, 'task', 'view'),
(1, 'testcase', 'batchCaseTypeChange'),
(1, 'testcase', 'batchChangeBranch'),
(1, 'testcase', 'batchChangeModule'),
(1, 'testcase', 'batchConfirmStoryChange'),
(1, 'testcase', 'batchCreate'),
(1, 'testcase', 'batchDelete'),
(1, 'testcase', 'batchEdit'),
(1, 'testcase', 'batchReview'),
(1, 'testcase', 'browse'),
(1, 'testcase', 'bugs'),
(1, 'testcase', 'confirmChange'),
(1, 'testcase', 'confirmLibcaseChange'),
(1, 'testcase', 'confirmStoryChange'),
(1, 'testcase', 'create'),
(1, 'testcase', 'createBug'),
(1, 'testcase', 'delete'),
(1, 'testcase', 'edit'),
(1, 'testcase', 'export'),
(1, 'testcase', 'exportTemplet'),
(1, 'testcase', 'groupCase'),
(1, 'testcase', 'ignoreLibcaseChange'),
(1, 'testcase', 'import'),
(1, 'testcase', 'importFromLib'),
(1, 'testcase', 'index'),
(1, 'testcase', 'linkCases'),
(1, 'testcase', 'review'),
(1, 'testcase', 'showImport'),
(1, 'testcase', 'submit'),
(1, 'testcase', 'view'),
(1, 'testreport', 'browse'),
(1, 'testreport', 'create'),
(1, 'testreport', 'delete'),
(1, 'testreport', 'edit'),
(1, 'testreport', 'export'),
(1, 'testreport', 'view'),
(1, 'testsuite', 'batchUnlinkCases'),
(1, 'testsuite', 'browse'),
(1, 'testsuite', 'create'),
(1, 'testsuite', 'delete'),
(1, 'testsuite', 'edit'),
(1, 'testsuite', 'index'),
(1, 'testsuite', 'linkCase'),
(1, 'testsuite', 'unlinkCase'),
(1, 'testsuite', 'view'),
(1, 'testtask', 'activate'),
(1, 'testtask', 'batchAssign'),
(1, 'testtask', 'batchRun'),
(1, 'testtask', 'batchUnlinkCases'),
(1, 'testtask', 'block'),
(1, 'testtask', 'browse'),
(1, 'testtask', 'cases'),
(1, 'testtask', 'close'),
(1, 'testtask', 'create'),
(1, 'testtask', 'delete'),
(1, 'testtask', 'deployCaseResults'),
(1, 'testtask', 'edit'),
(1, 'testtask', 'groupCase'),
(1, 'testtask', 'index'),
(1, 'testtask', 'linkcase'),
(1, 'testtask', 'report'),
(1, 'testtask', 'results'),
(1, 'testtask', 'runcase'),
(1, 'testtask', 'runDeployCase'),
(1, 'testtask', 'start'),
(1, 'testtask', 'unlinkcase'),
(1, 'testtask', 'view'),
(1, 'todo', 'activate'),
(1, 'todo', 'assignTo'),
(1, 'todo', 'batchClose'),
(1, 'todo', 'batchCreate'),
(1, 'todo', 'batchEdit'),
(1, 'todo', 'batchFinish'),
(1, 'todo', 'calendar'),
(1, 'todo', 'close'),
(1, 'todo', 'create'),
(1, 'todo', 'createcycle'),
(1, 'todo', 'delete'),
(1, 'todo', 'edit'),
(1, 'todo', 'export'),
(1, 'todo', 'finish'),
(1, 'todo', 'import2Today'),
(1, 'todo', 'view'),
(1, 'tree', 'browse'),
(1, 'tree', 'browsehost'),
(1, 'tree', 'browseTask'),
(1, 'tree', 'delete'),
(1, 'tree', 'edit'),
(1, 'tree', 'editHost'),
(1, 'tree', 'fix'),
(1, 'tree', 'manageChild'),
(1, 'tree', 'updateOrder'),
(1, 'user', 'batchCreate'),
(1, 'user', 'batchEdit'),
(1, 'user', 'bug'),
(1, 'user', 'create'),
(1, 'user', 'delete'),
(1, 'user', 'dynamic'),
(1, 'user', 'edit'),
(1, 'user', 'effort'),
(1, 'user', 'effortcalendar'),
(1, 'user', 'importldap'),
(1, 'user', 'profile'),
(1, 'user', 'project'),
(1, 'user', 'setPublicTemplate'),
(1, 'user', 'story'),
(1, 'user', 'task'),
(1, 'user', 'testCase'),
(1, 'user', 'testTask'),
(1, 'user', 'todo'),
(1, 'user', 'todocalendar'),
(1, 'user', 'unbind'),
(1, 'user', 'unlock'),
(1, 'user', 'view'),
(1, 'webhook', 'bind'),
(1, 'webhook', 'browse'),
(1, 'webhook', 'create'),
(1, 'webhook', 'delete'),
(1, 'webhook', 'edit'),
(1, 'webhook', 'log'),
(1, 'weekly', 'index'),
(1, 'workestimation', 'index'),
(1, 'workloadbudget', '27'),
(1, 'workloadbudget', 'assign'),
(1, 'workloadbudget', 'batchassign'),
(1, 'workloadbudget', 'batchcreate'),
(1, 'workloadbudget', 'batchedit'),
(1, 'workloadbudget', 'browse'),
(1, 'workloadbudget', 'create'),
(1, 'workloadbudget', 'delete'),
(1, 'workloadbudget', 'edit'),
(1, 'workloadbudget', 'export'),
(1, 'workloadbudget', 'exporttemplate'),
(1, 'workloadbudget', 'import'),
(1, 'workloadbudget', 'link'),
(1, 'workloadbudget', 'search'),
(1, 'workloadbudget', 'showimport'),
(1, 'workloadbudget', 'unlink'),
(1, 'workloadbudget', 'view'),
('1', 'stakeholder', 'browse'),
('1', 'stakeholder', 'communicate'),
('1', 'stakeholder', 'create'),
('1', 'stakeholder', 'delete'),
('1', 'stakeholder', 'createExpect'),
('1', 'stakeholder', 'deleteExpect'),
('1', 'stakeholder', 'edit'),
('1', 'stakeholder', 'editExpect'),
('1', 'stakeholder', 'expect'),
('1', 'stakeholder', 'expectation'),
('1', 'stakeholder', 'issue'),
('1', 'stakeholder', 'plan'),
('1', 'stakeholder', 'userIssue'),
('1', 'stakeholder', 'view'),
('1', 'stakeholder', 'viewExpect'),
('1', 'stakeholder', 'viewIssue'),
(2, 'action', 'editComment'),
(2, 'activity', '12'),
(2, 'activity', 'assign'),
(2, 'activity', 'batchassign'),
(2, 'activity', 'batchcreate'),
(2, 'activity', 'batchedit'),
(2, 'activity', 'browse'),
(2, 'activity', 'create'),
(2, 'activity', 'delete'),
(2, 'activity', 'edit'),
(2, 'activity', 'export'),
(2, 'activity', 'exporttemplate'),
(2, 'activity', 'import'),
(2, 'activity', 'link'),
(2, 'activity', 'outputlist'),
(2, 'activity', 'search'),
(2, 'activity', 'showimport'),
(2, 'activity', 'unlink'),
(2, 'activity', 'view'),
(2, 'audit', '8'),
(2, 'audit', 'assign'),
(2, 'audit', 'batchassign'),
(2, 'audit', 'batchcreate'),
(2, 'audit', 'batchedit'),
(2, 'audit', 'browse'),
(2, 'audit', 'create'),
(2, 'audit', 'delete'),
(2, 'audit', 'edit'),
(2, 'audit', 'export'),
(2, 'audit', 'exporttemplate'),
(2, 'audit', 'import'),
(2, 'audit', 'link'),
(2, 'audit', 'search'),
(2, 'audit', 'showimport'),
(2, 'audit', 'unlink'),
(2, 'audit', 'view'),
(2, 'auditcl', 'browse'),
(2, 'auditcl', 'view'),
(2, 'auditplan', '9'),
(2, 'auditplan', 'assign'),
(2, 'auditplan', 'batchassign'),
(2, 'auditplan', 'batchcreate'),
(2, 'auditplan', 'batchedit'),
(2, 'auditplan', 'browse'),
(2, 'auditplan', 'create'),
(2, 'auditplan', 'delete'),
(2, 'auditplan', 'edit'),
(2, 'auditplan', 'export'),
(2, 'auditplan', 'exporttemplate'),
(2, 'auditplan', 'import'),
(2, 'auditplan', 'link'),
(2, 'auditplan', 'nc'),
(2, 'auditplan', 'result'),
(2, 'auditplan', 'search'),
(2, 'auditplan', 'showimport'),
(2, 'auditplan', 'unlink'),
(2, 'auditplan', 'view'),
(2, 'auditresult', '10'),
(2, 'auditresult', 'assign'),
(2, 'auditresult', 'batchassign'),
(2, 'auditresult', 'batchcreate'),
(2, 'auditresult', 'batchedit'),
(2, 'auditresult', 'browse'),
(2, 'auditresult', 'create'),
(2, 'auditresult', 'delete'),
(2, 'auditresult', 'edit'),
(2, 'auditresult', 'export'),
(2, 'auditresult', 'exporttemplate'),
(2, 'auditresult', 'import'),
(2, 'auditresult', 'link'),
(2, 'auditresult', 'search'),
(2, 'auditresult', 'showimport'),
(2, 'auditresult', 'unlink'),
(2, 'auditresult', 'view'),
(2, 'baseline', 'articleview'),
(2, 'baseline', 'catalog'),
(2, 'baseline', 'createTemplate'),
(2, 'baseline', 'editBook'),
(2, 'baseline', 'editTemplate'),
(2, 'baseline', 'manageBook'),
(2, 'baseline', 'template'),
(2, 'baseline', 'version'),
(2, 'baseline', 'view'),
(2, 'budget', 'browse'),
(2, 'bug', 'activate'),
(2, 'bug', 'assignTo'),
(2, 'bug', 'batchActivate'),
(2, 'bug', 'batchAssignTo'),
(2, 'bug', 'batchChangeModule'),
(2, 'bug', 'batchClose'),
(2, 'bug', 'batchConfirm'),
(2, 'bug', 'batchCreate'),
(2, 'bug', 'batchEdit'),
(2, 'bug', 'batchResolve'),
(2, 'bug', 'browse'),
(2, 'bug', 'close'),
(2, 'bug', 'confirmBug'),
(2, 'bug', 'confirmStoryChange'),
(2, 'bug', 'create'),
(2, 'bug', 'edit'),
(2, 'bug', 'export'),
(2, 'bug', 'index'),
(2, 'bug', 'linkBugs'),
(2, 'bug', 'report'),
(2, 'bug', 'resolve'),
(2, 'bug', 'view'),
(2, 'build', 'create'),
(2, 'build', 'delete'),
(2, 'build', 'edit'),
(2, 'build', 'view'),
(2, 'classify', 'browse'),
(2, 'cm', 'browse'),
(2, 'cm', 'create'),
(2, 'cm', 'edit'),
(2, 'cm', 'report'),
(2, 'cm', 'view'),
(2, 'cmcl', 'browse'),
(2, 'company', 'browse'),
(2, 'company', 'dynamic'),
(2, 'company', 'effort'),
(2, 'company', 'index'),
(2, 'company', 'view'),
(2, 'custom', 'estimate'),
(2, 'datatable', 'setGlobal'),
(2, 'design', '23'),
(2, 'design', 'assign'),
(2, 'design', 'batchassign'),
(2, 'design', 'batchcreate'),
(2, 'design', 'batchedit'),
(2, 'design', 'browse'),
(2, 'design', 'commit'),
(2, 'design', 'create'),
(2, 'design', 'delete'),
(2, 'design', 'edit'),
(2, 'design', 'export'),
(2, 'design', 'search'),
(2, 'design', 'view'),
(2, 'doc', 'allLibs'),
(2, 'doc', 'browse'),
(2, 'doc', 'create'),
(2, 'doc', 'edit'),
(2, 'doc', 'index'),
(2, 'doc', 'objectLibs'),
(2, 'doc', 'showFiles'),
(2, 'doc', 'view'),
(2, 'durationestimation', 'create'),
(2, 'durationestimation', 'index'),
(2, 'effort', 'batchCreate'),
(2, 'effort', 'calendar'),
(2, 'effort', 'createForObject'),
(2, 'effort', 'delete'),
(2, 'effort', 'edit'),
(2, 'effort', 'export'),
(2, 'effort', 'view'),
(2, 'file', 'download'),
(2, 'file', 'edit'),
(2, 'git', 'apiSync'),
(2, 'git', 'cat'),
(2, 'git', 'diff'),
(2, 'group', 'browse'),
(2, 'im', 'notifyMSG'),
(2, 'index', 'index'),
(2, 'issue', '17'),
(2, 'issue', '18'),
(2, 'issue', '19'),
(2, 'issue', '20'),
(2, 'issue', '21'),
(2, 'issue', '22'),
(2, 'issue', 'activate'),
(2, 'issue', 'assign'),
(2, 'issue', 'batchassign'),
(2, 'issue', 'batchcreate'),
(2, 'issue', 'batchedit'),
(2, 'issue', 'browse'),
(2, 'issue', 'cancel'),
(2, 'issue', 'close'),
(2, 'issue', 'create'),
(2, 'issue', 'delete'),
(2, 'issue', 'edit'),
(2, 'issue', 'export'),
(2, 'issue', 'resolve'),
(2, 'issue', 'search'),
(2, 'issue', 'view'),
(2, 'milestone', 'index'),
(2, 'milestone', 'saveOtherProblem'),
(2, 'misc', 'ping'),
(2, 'my', 'bug'),
(2, 'my', 'calendar'),
(2, 'my', 'changePassword'),
(2, 'my', 'deleteContacts'),
(2, 'my', 'dynamic'),
(2, 'my', 'editProfile'),
(2, 'my', 'effort'),
(2, 'my', 'index'),
(2, 'my', 'manageContacts'),
(2, 'my', 'nc'),
(2, 'my', 'profile'),
(2, 'my', 'program'),
(2, 'my', 'project'),
(2, 'my', 'requirement'),
(2, 'my', 'story'),
(2, 'my', 'task'),
(2, 'my', 'testCase'),
(2, 'my', 'testTask'),
(2, 'my', 'todo'),
(2, 'my', 'unbind'),
(2, 'nc', '16'),
(2, 'nc', 'activate'),
(2, 'nc', 'assign'),
(2, 'nc', 'batchassign'),
(2, 'nc', 'batchcreate'),
(2, 'nc', 'batchedit'),
(2, 'nc', 'browse'),
(2, 'nc', 'close'),
(2, 'nc', 'create'),
(2, 'nc', 'delete'),
(2, 'nc', 'edit'),
(2, 'nc', 'export'),
(2, 'nc', 'exporttemplate'),
(2, 'nc', 'import'),
(2, 'nc', 'link'),
(2, 'nc', 'resolve'),
(2, 'nc', 'search'),
(2, 'nc', 'showimport'),
(2, 'nc', 'unlink'),
(2, 'nc', 'view'),
(2, 'output', '13'),
(2, 'output', 'assign'),
(2, 'output', 'batchassign'),
(2, 'output', 'batchcreate'),
(2, 'output', 'batchedit'),
(2, 'output', 'browse'),
(2, 'output', 'create'),
(2, 'output', 'delete'),
(2, 'output', 'edit'),
(2, 'output', 'export'),
(2, 'output', 'exporttemplate'),
(2, 'output', 'import'),
(2, 'output', 'link'),
(2, 'output', 'search'),
(2, 'output', 'showimport'),
(2, 'output', 'unlink'),
(2, 'output', 'view'),
(2, 'process', '11'),
(2, 'process', 'activitylist'),
(2, 'process', 'assign'),
(2, 'process', 'batchassign'),
(2, 'process', 'batchcreate'),
(2, 'process', 'batchedit'),
(2, 'process', 'browse'),
(2, 'process', 'create'),
(2, 'process', 'delete'),
(2, 'process', 'edit'),
(2, 'process', 'export'),
(2, 'process', 'exporttemplate'),
(2, 'process', 'import'),
(2, 'process', 'link'),
(2, 'process', 'search'),
(2, 'process', 'showimport'),
(2, 'process', 'unlink'),
(2, 'process', 'view'),
(2, 'product', 'all'),
(2, 'product', 'browse'),
(2, 'product', 'index'),
(2, 'product', 'view'),
(2, 'productplan', 'browse'),
(2, 'productplan', 'view'),
(2, 'project', 'all'),
(2, 'project', 'browse'),
(2, 'project', 'bug'),
(2, 'project', 'build'),
(2, 'project', 'burn'),
(2, 'project', 'calendar'),
(2, 'project', 'computeBurn'),
(2, 'project', 'effort'),
(2, 'project', 'gantt'),
(2, 'project', 'grouptask'),
(2, 'project', 'importBug'),
(2, 'project', 'importtask'),
(2, 'project', 'index'),
(2, 'project', 'kanban'),
(2, 'project', 'relation'),
(2, 'project', 'story'),
(2, 'project', 'task'),
(2, 'project', 'team'),
(2, 'project', 'testtask'),
(2, 'project', 'tree'),
(2, 'project', 'view'),
(2, 'pssp', 'browse'),
(2, 'pssp', 'update'),
(2, 'qa', 'index'),
(2, 'release', 'browse'),
(2, 'release', 'export'),
(2, 'release', 'view'),
(2, 'report', 'bugAssign'),
(2, 'report', 'bugCreate'),
(2, 'report', 'build'),
(2, 'report', 'index'),
(2, 'report', 'productSummary'),
(2, 'report', 'projectDeviation'),
(2, 'report', 'testcase'),
(2, 'report', 'workload'),
(2, 'report', 'workSummary'),
(2, 'review', 'assess'),
(2, 'review', 'audit'),
(2, 'review', 'browse'),
(2, 'review', 'create'),
(2, 'review', 'edit'),
(2, 'review', 'recall'),
(2, 'review', 'report'),
(2, 'review', 'result'),
(2, 'review', 'submit'),
(2, 'review', 'toAudit'),
(2, 'review', 'view'),
(2, 'reviewcl', 'browse'),
(2, 'reviewissue', 'create'),
(2, 'reviewissue', 'edit'),
(2, 'reviewissue', 'issue'),
(2, 'reviewissue', 'resolved'),
(2, 'reviewissue', 'updateStatus'),
(2, 'reviewissue', 'view'),
(2, 'reviewsetting', 'reviewer'),
(2, 'reviewsetting', 'version'),
(2, 'risk', 'activate'),
(2, 'risk', 'assign'),
(2, 'risk', 'batchassign'),
(2, 'risk', 'batchcreate'),
(2, 'risk', 'batchedit'),
(2, 'risk', 'browse'),
(2, 'risk', 'cancel'),
(2, 'risk', 'check'),
(2, 'risk', 'close'),
(2, 'risk', 'create'),
(2, 'risk', 'delete'),
(2, 'risk', 'edit'),
(2, 'risk', 'export'),
(2, 'risk', 'hangup'),
(2, 'risk', 'search'),
(2, 'risk', 'view'),
(2, 'search', 'buildForm'),
(2, 'search', 'buildQuery'),
(2, 'search', 'deleteQuery'),
(2, 'search', 'index'),
(2, 'search', 'saveQuery'),
(2, 'search', 'select'),
(2, 'stage', '24'),
(2, 'stage', 'assign'),
(2, 'stage', 'batchassign'),
(2, 'stage', 'batchcreate'),
(2, 'stage', 'batchedit'),
(2, 'stage', 'browse'),
(2, 'stage', 'create'),
(2, 'stage', 'delete'),
(2, 'stage', 'edit'),
(2, 'stage', 'export'),
(2, 'stage', 'exporttemplate'),
(2, 'stage', 'import'),
(2, 'stage', 'search'),
(2, 'stage', 'view'),
(2, 'story', 'bugs'),
(2, 'story', 'cases'),
(2, 'story', 'export'),
(2, 'story', 'processStoryChange'),
(2, 'story', 'report'),
(2, 'story', 'tasks'),
(2, 'story', 'track'),
(2, 'story', 'view'),
(2, 'subject', 'browse'),
(2, 'svn', 'apiSync'),
(2, 'svn', 'cat'),
(2, 'svn', 'diff'),
(2, 'task', 'activate'),
(2, 'task', 'assignTo'),
(2, 'task', 'batchAssignTo'),
(2, 'task', 'batchChangeModule'),
(2, 'task', 'batchClose'),
(2, 'task', 'batchCreate'),
(2, 'task', 'batchEdit'),
(2, 'task', 'close'),
(2, 'task', 'confirmStoryChange'),
(2, 'task', 'create'),
(2, 'task', 'deleteEstimate'),
(2, 'task', 'edit'),
(2, 'task', 'editEstimate'),
(2, 'task', 'export'),
(2, 'task', 'finish'),
(2, 'task', 'pause'),
(2, 'task', 'recordEstimate'),
(2, 'task', 'report'),
(2, 'task', 'restart'),
(2, 'task', 'start'),
(2, 'task', 'view'),
(2, 'testcase', 'browse'),
(2, 'testcase', 'bugs'),
(2, 'testcase', 'export'),
(2, 'testcase', 'groupCase'),
(2, 'testcase', 'index'),
(2, 'testcase', 'view'),
(2, 'testsuite', 'browse'),
(2, 'testsuite', 'index'),
(2, 'testsuite', 'view'),
(2, 'testtask', 'browse'),
(2, 'testtask', 'cases'),
(2, 'testtask', 'create'),
(2, 'testtask', 'edit'),
(2, 'testtask', 'groupCase'),
(2, 'testtask', 'index'),
(2, 'testtask', 'results'),
(2, 'testtask', 'view'),
(2, 'todo', 'activate'),
(2, 'todo', 'assignTo'),
(2, 'todo', 'batchClose'),
(2, 'todo', 'batchCreate'),
(2, 'todo', 'batchEdit'),
(2, 'todo', 'batchFinish'),
(2, 'todo', 'calendar'),
(2, 'todo', 'close'),
(2, 'todo', 'create'),
(2, 'todo', 'delete'),
(2, 'todo', 'edit'),
(2, 'todo', 'export'),
(2, 'todo', 'finish'),
(2, 'todo', 'import2Today'),
(2, 'todo', 'view'),
(2, 'user', 'bug'),
(2, 'user', 'dynamic'),
(2, 'user', 'effortcalendar'),
(2, 'user', 'profile'),
(2, 'user', 'project'),
(2, 'user', 'story'),
(2, 'user', 'task'),
(2, 'user', 'testCase'),
(2, 'user', 'testTask'),
(2, 'user', 'todo'),
(2, 'user', 'todocalendar'),
(2, 'user', 'view'),
(2, 'weekly', 'index'),
(2, 'workestimation', 'index'),
(2, 'workloadbudget', '27'),
(2, 'workloadbudget', 'assign'),
(2, 'workloadbudget', 'batchassign'),
(2, 'workloadbudget', 'batchcreate'),
(2, 'workloadbudget', 'batchedit'),
(2, 'workloadbudget', 'browse'),
(2, 'workloadbudget', 'create'),
(2, 'workloadbudget', 'delete'),
(2, 'workloadbudget', 'edit'),
(2, 'workloadbudget', 'export'),
(2, 'workloadbudget', 'exporttemplate'),
(2, 'workloadbudget', 'import'),
(2, 'workloadbudget', 'link'),
(2, 'workloadbudget', 'search'),
(2, 'workloadbudget', 'showimport'),
(2, 'workloadbudget', 'unlink'),
(2, 'workloadbudget', 'view'),
(3, 'action', 'editComment'),
(3, 'activity', '12'),
(3, 'activity', 'assign'),
(3, 'activity', 'batchassign'),
(3, 'activity', 'batchcreate'),
(3, 'activity', 'batchedit'),
(3, 'activity', 'browse'),
(3, 'activity', 'create'),
(3, 'activity', 'delete'),
(3, 'activity', 'edit'),
(3, 'activity', 'export'),
(3, 'activity', 'exporttemplate'),
(3, 'activity', 'import'),
(3, 'activity', 'link'),
(3, 'activity', 'outputlist'),
(3, 'activity', 'search'),
(3, 'activity', 'showimport'),
(3, 'activity', 'unlink'),
(3, 'activity', 'view'),
(3, 'audit', '8'),
(3, 'audit', 'assign'),
(3, 'audit', 'batchassign'),
(3, 'audit', 'batchcreate'),
(3, 'audit', 'batchedit'),
(3, 'audit', 'browse'),
(3, 'audit', 'create'),
(3, 'audit', 'delete'),
(3, 'audit', 'edit'),
(3, 'audit', 'export'),
(3, 'audit', 'exporttemplate'),
(3, 'audit', 'import'),
(3, 'audit', 'link'),
(3, 'audit', 'search'),
(3, 'audit', 'showimport'),
(3, 'audit', 'unlink'),
(3, 'audit', 'view'),
(3, 'auditcl', 'browse'),
(3, 'auditplan', '9'),
(3, 'auditplan', 'assign'),
(3, 'auditplan', 'batchassign'),
(3, 'auditplan', 'batchcreate'),
(3, 'auditplan', 'batchedit'),
(3, 'auditplan', 'browse'),
(3, 'auditplan', 'create'),
(3, 'auditplan', 'delete'),
(3, 'auditplan', 'edit'),
(3, 'auditplan', 'export'),
(3, 'auditplan', 'exporttemplate'),
(3, 'auditplan', 'import'),
(3, 'auditplan', 'link'),
(3, 'auditplan', 'nc'),
(3, 'auditplan', 'result'),
(3, 'auditplan', 'search'),
(3, 'auditplan', 'showimport'),
(3, 'auditplan', 'unlink'),
(3, 'auditplan', 'view'),
(3, 'auditresult', '10'),
(3, 'auditresult', 'assign'),
(3, 'auditresult', 'batchassign'),
(3, 'auditresult', 'batchcreate'),
(3, 'auditresult', 'batchedit'),
(3, 'auditresult', 'browse'),
(3, 'auditresult', 'create'),
(3, 'auditresult', 'delete'),
(3, 'auditresult', 'edit'),
(3, 'auditresult', 'export'),
(3, 'auditresult', 'exporttemplate'),
(3, 'auditresult', 'import'),
(3, 'auditresult', 'link'),
(3, 'auditresult', 'search'),
(3, 'auditresult', 'showimport'),
(3, 'auditresult', 'unlink'),
(3, 'auditresult', 'view'),
(3, 'baseline', 'articleview'),
(3, 'baseline', 'catalog'),
(3, 'baseline', 'createTemplate'),
(3, 'baseline', 'editBook'),
(3, 'baseline', 'editTemplate'),
(3, 'baseline', 'manageBook'),
(3, 'baseline', 'template'),
(3, 'baseline', 'version'),
(3, 'baseline', 'view'),
(3, 'budget', 'batchCreate'),
(3, 'budget', 'browse'),
(3, 'budget', 'create'),
(3, 'budget', 'edit'),
(3, 'budget', 'summary'),
(3, 'budget', 'view'),
(3, 'bug', 'activate'),
(3, 'bug', 'assignTo'),
(3, 'bug', 'batchActivate'),
(3, 'bug', 'batchAssignTo'),
(3, 'bug', 'batchChangeModule'),
(3, 'bug', 'batchClose'),
(3, 'bug', 'batchConfirm'),
(3, 'bug', 'batchCreate'),
(3, 'bug', 'batchEdit'),
(3, 'bug', 'batchResolve'),
(3, 'bug', 'browse'),
(3, 'bug', 'close'),
(3, 'bug', 'confirmBug'),
(3, 'bug', 'confirmStoryChange'),
(3, 'bug', 'create'),
(3, 'bug', 'edit'),
(3, 'bug', 'export'),
(3, 'bug', 'index'),
(3, 'bug', 'linkBugs'),
(3, 'bug', 'report'),
(3, 'bug', 'resolve'),
(3, 'bug', 'view'),
(3, 'build', 'create'),
(3, 'build', 'edit'),
(3, 'build', 'view'),
(3, 'classify', 'browse'),
(3, 'cm', 'browse'),
(3, 'cm', 'create'),
(3, 'cm', 'edit'),
(3, 'cm', 'report'),
(3, 'cm', 'view'),
(3, 'cmcl', 'browse'),
(3, 'company', 'browse'),
(3, 'company', 'dynamic'),
(3, 'company', 'effort'),
(3, 'company', 'index'),
(3, 'company', 'view'),
(3, 'custom', 'estimate'),
(3, 'datatable', 'setGlobal'),
(3, 'design', '23'),
(3, 'design', 'assign'),
(3, 'design', 'batchassign'),
(3, 'design', 'batchcreate'),
(3, 'design', 'batchedit'),
(3, 'design', 'browse'),
(3, 'design', 'commit'),
(3, 'design', 'create'),
(3, 'design', 'edit'),
(3, 'design', 'export'),
(3, 'design', 'search'),
(3, 'design', 'view'),
(3, 'doc', 'allLibs'),
(3, 'doc', 'browse'),
(3, 'doc', 'create'),
(3, 'doc', 'edit'),
(3, 'doc', 'index'),
(3, 'doc', 'objectLibs'),
(3, 'doc', 'showFiles'),
(3, 'doc', 'view'),
(3, 'durationestimation', 'create'),
(3, 'durationestimation', 'index'),
(3, 'effort', 'batchCreate'),
(3, 'effort', 'calendar'),
(3, 'effort', 'createForObject'),
(3, 'effort', 'edit'),
(3, 'effort', 'export'),
(3, 'effort', 'view'),
(3, 'file', 'download'),
(3, 'file', 'edit'),
(3, 'git', 'apiSync'),
(3, 'git', 'cat'),
(3, 'git', 'diff'),
(3, 'group', 'browse'),
(3, 'im', 'notifyMSG'),
(3, 'index', 'index'),
(3, 'issue', '17'),
(3, 'issue', '18'),
(3, 'issue', '19'),
(3, 'issue', '20'),
(3, 'issue', '21'),
(3, 'issue', '22'),
(3, 'issue', 'activate'),
(3, 'issue', 'assign'),
(3, 'issue', 'batchassign'),
(3, 'issue', 'batchcreate'),
(3, 'issue', 'batchedit'),
(3, 'issue', 'browse'),
(3, 'issue', 'cancel'),
(3, 'issue', 'close'),
(3, 'issue', 'create'),
(3, 'issue', 'delete'),
(3, 'issue', 'edit'),
(3, 'issue', 'export'),
(3, 'issue', 'resolve'),
(3, 'issue', 'search'),
(3, 'issue', 'view'),
(3, 'milestone', 'index'),
(3, 'milestone', 'saveOtherProblem'),
(3, 'misc', 'ping'),
(3, 'my', 'bug'),
(3, 'my', 'calendar'),
(3, 'my', 'changePassword'),
(3, 'my', 'deleteContacts'),
(3, 'my', 'dynamic'),
(3, 'my', 'editProfile'),
(3, 'my', 'effort'),
(3, 'my', 'index'),
(3, 'my', 'manageContacts'),
(3, 'my', 'nc'),
(3, 'my', 'profile'),
(3, 'my', 'program'),
(3, 'my', 'project'),
(3, 'my', 'requirement'),
(3, 'my', 'story'),
(3, 'my', 'task'),
(3, 'my', 'testCase'),
(3, 'my', 'testTask'),
(3, 'my', 'todo'),
(3, 'my', 'unbind'),
(3, 'nc', '16'),
(3, 'nc', 'activate'),
(3, 'nc', 'assign'),
(3, 'nc', 'batchassign'),
(3, 'nc', 'batchcreate'),
(3, 'nc', 'batchedit'),
(3, 'nc', 'browse'),
(3, 'nc', 'close'),
(3, 'nc', 'create'),
(3, 'nc', 'delete'),
(3, 'nc', 'edit'),
(3, 'nc', 'export'),
(3, 'nc', 'exporttemplate'),
(3, 'nc', 'import'),
(3, 'nc', 'link'),
(3, 'nc', 'resolve'),
(3, 'nc', 'search'),
(3, 'nc', 'showimport'),
(3, 'nc', 'unlink'),
(3, 'nc', 'view'),
(3, 'output', '13'),
(3, 'output', 'assign'),
(3, 'output', 'batchassign'),
(3, 'output', 'batchcreate'),
(3, 'output', 'batchedit'),
(3, 'output', 'browse'),
(3, 'output', 'create'),
(3, 'output', 'delete'),
(3, 'output', 'edit'),
(3, 'output', 'export'),
(3, 'output', 'exporttemplate'),
(3, 'output', 'import'),
(3, 'output', 'link'),
(3, 'output', 'search'),
(3, 'output', 'showimport'),
(3, 'output', 'unlink'),
(3, 'output', 'view'),
(3, 'process', '11'),
(3, 'process', 'activitylist'),
(3, 'process', 'assign'),
(3, 'process', 'batchassign'),
(3, 'process', 'batchcreate'),
(3, 'process', 'batchedit'),
(3, 'process', 'browse'),
(3, 'process', 'create'),
(3, 'process', 'delete'),
(3, 'process', 'edit'),
(3, 'process', 'export'),
(3, 'process', 'exporttemplate'),
(3, 'process', 'import'),
(3, 'process', 'link'),
(3, 'process', 'search'),
(3, 'process', 'showimport'),
(3, 'process', 'unlink'),
(3, 'process', 'view'),
(3, 'product', 'all'),
(3, 'product', 'browse'),
(3, 'product', 'index'),
(3, 'product', 'view'),
(3, 'productplan', 'browse'),
(3, 'productplan', 'view'),
(3, 'project', 'all'),
(3, 'project', 'browse'),
(3, 'project', 'bug'),
(3, 'project', 'build'),
(3, 'project', 'burn'),
(3, 'project', 'calendar'),
(3, 'project', 'computeBurn'),
(3, 'project', 'effort'),
(3, 'project', 'gantt'),
(3, 'project', 'grouptask'),
(3, 'project', 'importBug'),
(3, 'project', 'importtask'),
(3, 'project', 'index'),
(3, 'project', 'kanban'),
(3, 'project', 'relation'),
(3, 'project', 'story'),
(3, 'project', 'task'),
(3, 'project', 'team'),
(3, 'project', 'testtask'),
(3, 'project', 'tree'),
(3, 'project', 'view'),
(3, 'pssp', 'browse'),
(3, 'pssp', 'update'),
(3, 'qa', 'index'),
(3, 'release', 'browse'),
(3, 'release', 'export'),
(3, 'release', 'view'),
(3, 'report', 'bugAssign'),
(3, 'report', 'bugCreate'),
(3, 'report', 'build'),
(3, 'report', 'index'),
(3, 'report', 'productSummary'),
(3, 'report', 'projectDeviation'),
(3, 'report', 'testcase'),
(3, 'report', 'workload'),
(3, 'report', 'workSummary'),
(3, 'review', 'assess'),
(3, 'review', 'audit'),
(3, 'review', 'browse'),
(3, 'review', 'create'),
(3, 'review', 'edit'),
(3, 'review', 'recall'),
(3, 'review', 'report'),
(3, 'review', 'result'),
(3, 'review', 'submit'),
(3, 'review', 'toAudit'),
(3, 'review', 'view'),
(3, 'reviewcl', 'browse'),
(3, 'reviewissue', 'create'),
(3, 'reviewissue', 'edit'),
(3, 'reviewissue', 'issue'),
(3, 'reviewissue', 'resolved'),
(3, 'reviewissue', 'updateStatus'),
(3, 'reviewissue', 'view'),
(3, 'reviewsetting', 'reviewer'),
(3, 'reviewsetting', 'version'),
(3, 'risk', 'activate'),
(3, 'risk', 'assign'),
(3, 'risk', 'batchassign'),
(3, 'risk', 'batchcreate'),
(3, 'risk', 'batchedit'),
(3, 'risk', 'browse'),
(3, 'risk', 'cancel'),
(3, 'risk', 'check'),
(3, 'risk', 'close'),
(3, 'risk', 'create'),
(3, 'risk', 'edit'),
(3, 'risk', 'export'),
(3, 'risk', 'hangup'),
(3, 'risk', 'search'),
(3, 'risk', 'view'),
(3, 'search', 'buildForm'),
(3, 'search', 'buildQuery'),
(3, 'search', 'deleteQuery'),
(3, 'search', 'index'),
(3, 'search', 'saveQuery'),
(3, 'search', 'select'),
(3, 'stage', '24'),
(3, 'stage', 'assign'),
(3, 'stage', 'batchassign'),
(3, 'stage', 'batchcreate'),
(3, 'stage', 'batchedit'),
(3, 'stage', 'browse'),
(3, 'stage', 'create'),
(3, 'stage', 'delete'),
(3, 'stage', 'edit'),
(3, 'stage', 'export'),
(3, 'stage', 'exporttemplate'),
(3, 'stage', 'import'),
(3, 'stage', 'search'),
(3, 'stage', 'view'),
(3, 'story', 'bugs'),
(3, 'story', 'cases'),
(3, 'story', 'export'),
(3, 'story', 'processStoryChange'),
(3, 'story', 'report'),
(3, 'story', 'tasks'),
(3, 'story', 'track'),
(3, 'story', 'view'),
(3, 'story', 'zeroCase'),
(3, 'subject', 'browse'),
(3, 'svn', 'apiSync'),
(3, 'svn', 'cat'),
(3, 'svn', 'diff'),
(3, 'task', 'activate'),
(3, 'task', 'assignTo'),
(3, 'task', 'batchAssignTo'),
(3, 'task', 'batchChangeModule'),
(3, 'task', 'batchClose'),
(3, 'task', 'batchCreate'),
(3, 'task', 'batchEdit'),
(3, 'task', 'cancel'),
(3, 'task', 'close'),
(3, 'task', 'confirmStoryChange'),
(3, 'task', 'create'),
(3, 'task', 'deleteEstimate'),
(3, 'task', 'edit'),
(3, 'task', 'editEstimate'),
(3, 'task', 'export'),
(3, 'task', 'finish'),
(3, 'task', 'pause'),
(3, 'task', 'recordEstimate'),
(3, 'task', 'report'),
(3, 'task', 'restart'),
(3, 'task', 'start'),
(3, 'task', 'view'),
(3, 'testcase', 'batchCaseTypeChange'),
(3, 'testcase', 'batchChangeModule'),
(3, 'testcase', 'batchConfirmStoryChange'),
(3, 'testcase', 'batchCreate'),
(3, 'testcase', 'batchEdit'),
(3, 'testcase', 'batchReview'),
(3, 'testcase', 'browse'),
(3, 'testcase', 'bugs'),
(3, 'testcase', 'confirmChange'),
(3, 'testcase', 'confirmStoryChange'),
(3, 'testcase', 'create'),
(3, 'testcase', 'createBug'),
(3, 'testcase', 'edit'),
(3, 'testcase', 'export'),
(3, 'testcase', 'exportTemplet'),
(3, 'testcase', 'groupCase'),
(3, 'testcase', 'import'),
(3, 'testcase', 'index'),
(3, 'testcase', 'linkCases'),
(3, 'testcase', 'review'),
(3, 'testcase', 'showImport'),
(3, 'testcase', 'view'),
(3, 'testreport', 'browse'),
(3, 'testreport', 'view'),
(3, 'testsuite', 'browse'),
(3, 'testsuite', 'create'),
(3, 'testsuite', 'delete'),
(3, 'testsuite', 'edit'),
(3, 'testsuite', 'index'),
(3, 'testsuite', 'linkCase'),
(3, 'testsuite', 'unlinkCase'),
(3, 'testsuite', 'view'),
(3, 'testtask', 'activate'),
(3, 'testtask', 'batchAssign'),
(3, 'testtask', 'batchRun'),
(3, 'testtask', 'block'),
(3, 'testtask', 'browse'),
(3, 'testtask', 'cases'),
(3, 'testtask', 'close'),
(3, 'testtask', 'create'),
(3, 'testtask', 'edit'),
(3, 'testtask', 'groupCase'),
(3, 'testtask', 'index'),
(3, 'testtask', 'linkcase'),
(3, 'testtask', 'report'),
(3, 'testtask', 'results'),
(3, 'testtask', 'runcase'),
(3, 'testtask', 'start'),
(3, 'testtask', 'unlinkcase'),
(3, 'testtask', 'view'),
(3, 'todo', 'activate'),
(3, 'todo', 'assignTo'),
(3, 'todo', 'batchClose'),
(3, 'todo', 'batchCreate'),
(3, 'todo', 'batchEdit'),
(3, 'todo', 'batchFinish'),
(3, 'todo', 'calendar'),
(3, 'todo', 'close'),
(3, 'todo', 'create'),
(3, 'todo', 'delete'),
(3, 'todo', 'edit'),
(3, 'todo', 'export'),
(3, 'todo', 'finish'),
(3, 'todo', 'import2Today'),
(3, 'todo', 'view'),
(3, 'user', 'bug'),
(3, 'user', 'dynamic'),
(3, 'user', 'effortcalendar'),
(3, 'user', 'profile'),
(3, 'user', 'project'),
(3, 'user', 'story'),
(3, 'user', 'task'),
(3, 'user', 'testCase'),
(3, 'user', 'testTask'),
(3, 'user', 'todo'),
(3, 'user', 'todocalendar'),
(3, 'user', 'view'),
(3, 'weekly', 'index'),
(3, 'workestimation', 'index'),
(3, 'workloadbudget', '27'),
(3, 'workloadbudget', 'assign'),
(3, 'workloadbudget', 'batchassign'),
(3, 'workloadbudget', 'batchcreate'),
(3, 'workloadbudget', 'batchedit'),
(3, 'workloadbudget', 'browse'),
(3, 'workloadbudget', 'create'),
(3, 'workloadbudget', 'delete'),
(3, 'workloadbudget', 'edit'),
(3, 'workloadbudget', 'export'),
(3, 'workloadbudget', 'exporttemplate'),
(3, 'workloadbudget', 'import'),
(3, 'workloadbudget', 'link'),
(3, 'workloadbudget', 'search'),
(3, 'workloadbudget', 'showimport'),
(3, 'workloadbudget', 'unlink'),
(3, 'workloadbudget', 'view'),
('4', 'stakeholder', 'browse'),
('4', 'stakeholder', 'communicate'),
('4', 'stakeholder', 'create'),
('4', 'stakeholder', 'delete'),
('4', 'stakeholder', 'createExpect'),
('4', 'stakeholder', 'deleteExpect'),
('4', 'stakeholder', 'edit'),
('4', 'stakeholder', 'editExpect'),
('4', 'stakeholder', 'expect'),
('4', 'stakeholder', 'expectation'),
('4', 'stakeholder', 'issue'),
('4', 'stakeholder', 'plan'),
('4', 'stakeholder', 'userIssue'),
('4', 'stakeholder', 'view'),
('4', 'stakeholder', 'viewExpect'),
('4', 'stakeholder', 'viewIssue'),
(4, 'action', 'editComment'),
(4, 'action', 'hideAll'),
(4, 'action', 'hideOne'),
(4, 'action', 'trash'),
(4, 'action', 'undelete'),
(4, 'activity', '12'),
(4, 'activity', 'assign'),
(4, 'activity', 'batchassign'),
(4, 'activity', 'batchcreate'),
(4, 'activity', 'batchedit'),
(4, 'activity', 'browse'),
(4, 'activity', 'create'),
(4, 'activity', 'delete'),
(4, 'activity', 'edit'),
(4, 'activity', 'export'),
(4, 'activity', 'exporttemplate'),
(4, 'activity', 'import'),
(4, 'activity', 'link'),
(4, 'activity', 'outputlist'),
(4, 'activity', 'search'),
(4, 'activity', 'showimport'),
(4, 'activity', 'unlink'),
(4, 'activity', 'view'),
(4, 'admin', 'index'),
(4, 'audit', '8'),
(4, 'audit', 'assign'),
(4, 'audit', 'batchassign'),
(4, 'audit', 'batchcreate'),
(4, 'audit', 'batchedit'),
(4, 'audit', 'browse'),
(4, 'audit', 'create'),
(4, 'audit', 'delete'),
(4, 'audit', 'edit'),
(4, 'audit', 'export'),
(4, 'audit', 'exporttemplate'),
(4, 'audit', 'import'),
(4, 'audit', 'link'),
(4, 'audit', 'search'),
(4, 'audit', 'showimport'),
(4, 'audit', 'unlink'),
(4, 'audit', 'view'),
(4, 'auditcl', 'assign'),
(4, 'auditcl', 'batchassign'),
(4, 'auditcl', 'batchcreate'),
(4, 'auditcl', 'batchedit'),
(4, 'auditcl', 'browse'),
(4, 'auditcl', 'create'),
(4, 'auditcl', 'delete'),
(4, 'auditcl', 'edit'),
(4, 'auditcl', 'export'),
(4, 'auditcl', 'exporttemplate'),
(4, 'auditcl', 'import'),
(4, 'auditcl', 'link'),
(4, 'auditcl', 'search'),
(4, 'auditcl', 'showimport'),
(4, 'auditcl', 'unlink'),
(4, 'auditcl', 'view'),
(4, 'auditplan', '9'),
(4, 'auditplan', 'assign'),
(4, 'auditplan', 'batchassign'),
(4, 'auditplan', 'batchcreate'),
(4, 'auditplan', 'batchedit'),
(4, 'auditplan', 'browse'),
(4, 'auditplan', 'create'),
(4, 'auditplan', 'delete'),
(4, 'auditplan', 'edit'),
(4, 'auditplan', 'export'),
(4, 'auditplan', 'exporttemplate'),
(4, 'auditplan', 'import'),
(4, 'auditplan', 'link'),
(4, 'auditplan', 'nc'),
(4, 'auditplan', 'result'),
(4, 'auditplan', 'search'),
(4, 'auditplan', 'showimport'),
(4, 'auditplan', 'unlink'),
(4, 'auditplan', 'view'),
(4, 'auditresult', '10'),
(4, 'auditresult', 'assign'),
(4, 'auditresult', 'batchassign'),
(4, 'auditresult', 'batchcreate'),
(4, 'auditresult', 'batchedit'),
(4, 'auditresult', 'browse'),
(4, 'auditresult', 'create'),
(4, 'auditresult', 'delete'),
(4, 'auditresult', 'edit'),
(4, 'auditresult', 'export'),
(4, 'auditresult', 'exporttemplate'),
(4, 'auditresult', 'import'),
(4, 'auditresult', 'link'),
(4, 'auditresult', 'search'),
(4, 'auditresult', 'showimport'),
(4, 'auditresult', 'unlink'),
(4, 'auditresult', 'view'),
(4, 'baseline', 'articleview'),
(4, 'baseline', 'catalog'),
(4, 'baseline', 'createTemplate'),
(4, 'baseline', 'editBook'),
(4, 'baseline', 'editTemplate'),
(4, 'baseline', 'manageBook'),
(4, 'baseline', 'template'),
(4, 'baseline', 'version'),
(4, 'baseline', 'view'),
(4, 'budget', 'batchCreate'),
(4, 'budget', 'browse'),
(4, 'budget', 'create'),
(4, 'budget', 'edit'),
(4, 'budget', 'summary'),
(4, 'budget', 'view'),
(4, 'bug', 'activate'),
(4, 'bug', 'assignTo'),
(4, 'bug', 'batchActivate'),
(4, 'bug', 'batchAssignTo'),
(4, 'bug', 'batchChangeModule'),
(4, 'bug', 'batchClose'),
(4, 'bug', 'batchConfirm'),
(4, 'bug', 'batchCreate'),
(4, 'bug', 'batchEdit'),
(4, 'bug', 'batchResolve'),
(4, 'bug', 'browse'),
(4, 'bug', 'close'),
(4, 'bug', 'confirmBug'),
(4, 'bug', 'confirmStoryChange'),
(4, 'bug', 'create'),
(4, 'bug', 'delete'),
(4, 'bug', 'edit'),
(4, 'bug', 'export'),
(4, 'bug', 'exportTemplet'),
(4, 'bug', 'import'),
(4, 'bug', 'index'),
(4, 'bug', 'linkBugs'),
(4, 'bug', 'report'),
(4, 'bug', 'resolve'),
(4, 'bug', 'showImport'),
(4, 'bug', 'view'),
(4, 'build', 'batchUnlinkBug'),
(4, 'build', 'batchUnlinkStory'),
(4, 'build', 'create'),
(4, 'build', 'delete'),
(4, 'build', 'edit'),
(4, 'build', 'linkBug'),
(4, 'build', 'linkStory'),
(4, 'build', 'unlinkBug'),
(4, 'build', 'unlinkStory'),
(4, 'build', 'view'),
(4, 'classify', 'browse'),
(4, 'cm', 'browse'),
(4, 'cm', 'create'),
(4, 'cm', 'edit'),
(4, 'cm', 'report'),
(4, 'cm', 'view'),
(4, 'cmcl', 'assign'),
(4, 'cmcl', 'batchassign'),
(4, 'cmcl', 'batchcreate'),
(4, 'cmcl', 'batchedit'),
(4, 'cmcl', 'browse'),
(4, 'cmcl', 'create'),
(4, 'cmcl', 'delete'),
(4, 'cmcl', 'edit'),
(4, 'cmcl', 'export'),
(4, 'cmcl', 'exporttemplate'),
(4, 'cmcl', 'import'),
(4, 'cmcl', 'link'),
(4, 'cmcl', 'search'),
(4, 'cmcl', 'showimport'),
(4, 'cmcl', 'unlink'),
(4, 'cmcl', 'view'),
(4, 'company', 'browse'),
(4, 'company', 'dynamic'),
(4, 'company', 'effort'),
(4, 'company', 'index'),
(4, 'company', 'view'),
(4, 'custom', 'estimate'),
(4, 'datatable', 'setGlobal'),
(4, 'design', '23'),
(4, 'design', 'assign'),
(4, 'design', 'batchassign'),
(4, 'design', 'batchcreate'),
(4, 'design', 'batchedit'),
(4, 'design', 'browse'),
(4, 'design', 'commit'),
(4, 'design', 'create'),
(4, 'design', 'delete'),
(4, 'design', 'edit'),
(4, 'design', 'export'),
(4, 'design', 'search'),
(4, 'design', 'view'),
(4, 'doc', 'allLibs'),
(4, 'doc', 'browse'),
(4, 'doc', 'create'),
(4, 'doc', 'createLib'),
(4, 'doc', 'delete'),
(4, 'doc', 'deleteFile'),
(4, 'doc', 'deleteLib'),
(4, 'doc', 'edit'),
(4, 'doc', 'editLib'),
(4, 'doc', 'index'),
(4, 'doc', 'objectLibs'),
(4, 'doc', 'showFiles'),
(4, 'doc', 'view'),
(4, 'durationestimation', 'create'),
(4, 'durationestimation', 'index'),
(4, 'effort', 'batchCreate'),
(4, 'effort', 'calendar'),
(4, 'effort', 'createForObject'),
(4, 'effort', 'edit'),
(4, 'effort', 'export'),
(4, 'effort', 'view'),
(4, 'extension', 'browse'),
(4, 'extension', 'obtain'),
(4, 'extension', 'structure'),
(4, 'faq', 'browse'),
(4, 'feedback', 'admin'),
(4, 'feedback', 'adminview'),
(4, 'feedback', 'close'),
(4, 'file', 'delete'),
(4, 'file', 'download'),
(4, 'file', 'edit'),
(4, 'file', 'uploadImages'),
(4, 'git', 'apiSync'),
(4, 'git', 'cat'),
(4, 'git', 'diff'),
(4, 'group', 'browse'),
(4, 'host', 'browse'),
(4, 'host', 'create'),
(4, 'host', 'delete'),
(4, 'host', 'edit'),
(4, 'host', 'treemap'),
(4, 'host', 'view'),
(4, 'im', 'notifyMSG'),
(4, 'index', 'index'),
(4, 'issue', '17'),
(4, 'issue', '18'),
(4, 'issue', '19'),
(4, 'issue', '20'),
(4, 'issue', '21'),
(4, 'issue', '22'),
(4, 'issue', 'activate'),
(4, 'issue', 'assign'),
(4, 'issue', 'batchassign'),
(4, 'issue', 'batchcreate'),
(4, 'issue', 'batchedit'),
(4, 'issue', 'browse'),
(4, 'issue', 'cancel'),
(4, 'issue', 'close'),
(4, 'issue', 'create'),
(4, 'issue', 'delete'),
(4, 'issue', 'edit'),
(4, 'issue', 'export'),
(4, 'issue', 'resolve'),
(4, 'issue', 'search'),
(4, 'issue', 'view'),
(4, 'milestone', 'index'),
(4, 'milestone', 'saveOtherProblem'),
(4, 'misc', 'ping'),
(4, 'my', 'bug'),
(4, 'my', 'calendar'),
(4, 'my', 'changePassword'),
(4, 'my', 'deleteContacts'),
(4, 'my', 'dynamic'),
(4, 'my', 'editProfile'),
(4, 'my', 'effort'),
(4, 'my', 'index'),
(4, 'my', 'manageContacts'),
(4, 'my', 'nc'),
(4, 'my', 'profile'),
(4, 'my', 'program'),
(4, 'my', 'project'),
(4, 'my', 'requirement'),
(4, 'my', 'story'),
(4, 'my', 'task'),
(4, 'my', 'testCase'),
(4, 'my', 'testTask'),
(4, 'my', 'todo'),
(4, 'my', 'unbind'),
(4, 'nc', '16'),
(4, 'nc', 'activate'),
(4, 'nc', 'assign'),
(4, 'nc', 'batchassign'),
(4, 'nc', 'batchcreate'),
(4, 'nc', 'batchedit'),
(4, 'nc', 'browse'),
(4, 'nc', 'close'),
(4, 'nc', 'create'),
(4, 'nc', 'delete'),
(4, 'nc', 'edit'),
(4, 'nc', 'export'),
(4, 'nc', 'exporttemplate'),
(4, 'nc', 'import'),
(4, 'nc', 'link'),
(4, 'nc', 'resolve'),
(4, 'nc', 'search'),
(4, 'nc', 'showimport'),
(4, 'nc', 'unlink'),
(4, 'nc', 'view'),
(4, 'output', '13'),
(4, 'output', 'assign'),
(4, 'output', 'batchassign'),
(4, 'output', 'batchcreate'),
(4, 'output', 'batchedit'),
(4, 'output', 'browse'),
(4, 'output', 'create'),
(4, 'output', 'delete'),
(4, 'output', 'edit'),
(4, 'output', 'export'),
(4, 'output', 'exporttemplate'),
(4, 'output', 'import'),
(4, 'output', 'link'),
(4, 'output', 'search'),
(4, 'output', 'showimport'),
(4, 'output', 'unlink'),
(4, 'output', 'view'),
(4, 'process', '11'),
(4, 'process', 'activitylist'),
(4, 'process', 'assign'),
(4, 'process', 'batchassign'),
(4, 'process', 'batchcreate'),
(4, 'process', 'batchedit'),
(4, 'process', 'browse'),
(4, 'process', 'create'),
(4, 'process', 'delete'),
(4, 'process', 'edit'),
(4, 'process', 'export'),
(4, 'process', 'exporttemplate'),
(4, 'process', 'import'),
(4, 'process', 'link'),
(4, 'process', 'search'),
(4, 'process', 'showimport'),
(4, 'process', 'unlink'),
(4, 'process', 'view'),
(4, 'product', 'browse'),
(4, 'product', 'index'),
(4, 'productplan', 'browse'),
(4, 'productplan', 'view'),
(4, 'project', 'activate'),
(4, 'project', 'all'),
(4, 'project', 'batchUnlinkStory'),
(4, 'project', 'browse'),
(4, 'project', 'bug'),
(4, 'project', 'build'),
(4, 'project', 'burn'),
(4, 'project', 'burnData'),
(4, 'project', 'calendar'),
(4, 'project', 'close'),
(4, 'project', 'computeBurn'),
(4, 'project', 'create'),
(4, 'project', 'delete'),
(4, 'project', 'edit'),
(4, 'project', 'effort'),
(4, 'project', 'gantt'),
(4, 'project', 'grouptask'),
(4, 'project', 'importBug'),
(4, 'project', 'importtask'),
(4, 'project', 'index'),
(4, 'project', 'kanban'),
(4, 'project', 'linkStory'),
(4, 'project', 'manageMembers'),
(4, 'project', 'relation'),
(4, 'project', 'story'),
(4, 'project', 'task'),
(4, 'project', 'team'),
(4, 'project', 'testtask'),
(4, 'project', 'tree'),
(4, 'project', 'unlinkMember'),
(4, 'project', 'unlinkStory'),
(4, 'project', 'updateOrder'),
(4, 'project', 'view'),
(4, 'pssp', 'browse'),
(4, 'pssp', 'update'),
(4, 'qa', 'index'),
(4, 'release', 'browse'),
(4, 'release', 'export'),
(4, 'release', 'view'),
(4, 'report', 'bugAssign'),
(4, 'report', 'bugCreate'),
(4, 'report', 'build'),
(4, 'report', 'export'),
(4, 'report', 'index'),
(4, 'report', 'productSummary'),
(4, 'report', 'projectDeviation'),
(4, 'report', 'testcase'),
(4, 'report', 'workload'),
(4, 'report', 'workSummary'),
(4, 'review', 'assess'),
(4, 'review', 'audit'),
(4, 'review', 'browse'),
(4, 'review', 'create'),
(4, 'review', 'edit'),
(4, 'review', 'recall'),
(4, 'review', 'report'),
(4, 'review', 'result'),
(4, 'review', 'submit'),
(4, 'review', 'toAudit'),
(4, 'review', 'view'),
(4, 'reviewcl', 'assign'),
(4, 'reviewcl', 'batchassign'),
(4, 'reviewcl', 'batchcreate'),
(4, 'reviewcl', 'batchedit'),
(4, 'reviewcl', 'browse'),
(4, 'reviewcl', 'create'),
(4, 'reviewcl', 'delete'),
(4, 'reviewcl', 'edit'),
(4, 'reviewcl', 'export'),
(4, 'reviewcl', 'exporttemplate'),
(4, 'reviewcl', 'import'),
(4, 'reviewcl', 'search'),
(4, 'reviewcl', 'view'),
(4, 'reviewissue', 'create'),
(4, 'reviewissue', 'edit'),
(4, 'reviewissue', 'issue'),
(4, 'reviewissue', 'resolved'),
(4, 'reviewissue', 'updateStatus'),
(4, 'reviewissue', 'view'),
(4, 'reviewsetting', 'reviewer'),
(4, 'reviewsetting', 'version'),
(4, 'risk', 'activate'),
(4, 'risk', 'assign'),
(4, 'risk', 'batchassign'),
(4, 'risk', 'batchcreate'),
(4, 'risk', 'batchedit'),
(4, 'risk', 'browse'),
(4, 'risk', 'cancel'),
(4, 'risk', 'check'),
(4, 'risk', 'close'),
(4, 'risk', 'create'),
(4, 'risk', 'delete'),
(4, 'risk', 'edit'),
(4, 'risk', 'export'),
(4, 'risk', 'hangup'),
(4, 'risk', 'search'),
(4, 'risk', 'view'),
(4, 'search', 'buildForm'),
(4, 'search', 'buildQuery'),
(4, 'search', 'deleteQuery'),
(4, 'search', 'index'),
(4, 'search', 'saveQuery'),
(4, 'search', 'select'),
(4, 'stage', '24'),
(4, 'stage', 'assign'),
(4, 'stage', 'batchassign'),
(4, 'stage', 'batchcreate'),
(4, 'stage', 'batchedit'),
(4, 'stage', 'browse'),
(4, 'stage', 'create'),
(4, 'stage', 'delete'),
(4, 'stage', 'edit'),
(4, 'stage', 'export'),
(4, 'stage', 'exporttemplate'),
(4, 'stage', 'import'),
(4, 'stage', 'search'),
(4, 'stage', 'view'),
(4, 'story', 'bugs'),
(4, 'story', 'cases'),
(4, 'story', 'export'),
(4, 'story', 'exportTemplet'),
(4, 'story', 'import'),
(4, 'story', 'processStoryChange'),
(4, 'story', 'report'),
(4, 'story', 'showImport'),
(4, 'story', 'tasks'),
(4, 'story', 'track'),
(4, 'story', 'view'),
(4, 'story', 'zeroCase'),
(4, 'subject', 'browse'),
(4, 'svn', 'apiSync'),
(4, 'svn', 'cat'),
(4, 'svn', 'diff'),
(4, 'task', 'activate'),
(4, 'task', 'assignTo'),
(4, 'task', 'batchAssignTo'),
(4, 'task', 'batchChangeModule'),
(4, 'task', 'batchClose'),
(4, 'task', 'batchCreate'),
(4, 'task', 'batchEdit'),
(4, 'task', 'cancel'),
(4, 'task', 'close'),
(4, 'task', 'confirmdesignchange'),
(4, 'task', 'confirmStoryChange'),
(4, 'task', 'create'),
(4, 'task', 'delete'),
(4, 'task', 'deleteEstimate'),
(4, 'task', 'edit'),
(4, 'task', 'editEstimate'),
(4, 'task', 'export'),
(4, 'task', 'exportTemplet'),
(4, 'task', 'finish'),
(4, 'task', 'import'),
(4, 'task', 'pause'),
(4, 'task', 'recordEstimate'),
(4, 'task', 'report'),
(4, 'task', 'restart'),
(4, 'task', 'showImport'),
(4, 'task', 'start'),
(4, 'task', 'view'),
(4, 'testcase', 'browse'),
(4, 'testcase', 'bugs'),
(4, 'testcase', 'createBug'),
(4, 'testcase', 'export'),
(4, 'testcase', 'groupCase'),
(4, 'testcase', 'index'),
(4, 'testcase', 'review'),
(4, 'testcase', 'submit'),
(4, 'testcase', 'view'),
(4, 'testsuite', 'browse'),
(4, 'testsuite', 'index'),
(4, 'testsuite', 'view'),
(4, 'testtask', 'batchAssign'),
(4, 'testtask', 'browse'),
(4, 'testtask', 'cases'),
(4, 'testtask', 'create'),
(4, 'testtask', 'edit'),
(4, 'testtask', 'groupCase'),
(4, 'testtask', 'index'),
(4, 'testtask', 'results'),
(4, 'testtask', 'view'),
(4, 'todo', 'activate'),
(4, 'todo', 'assignTo'),
(4, 'todo', 'batchClose'),
(4, 'todo', 'batchCreate'),
(4, 'todo', 'batchEdit'),
(4, 'todo', 'batchFinish'),
(4, 'todo', 'calendar'),
(4, 'todo', 'close'),
(4, 'todo', 'create'),
(4, 'todo', 'delete'),
(4, 'todo', 'edit'),
(4, 'todo', 'export'),
(4, 'todo', 'finish'),
(4, 'todo', 'import2Today'),
(4, 'todo', 'view'),
(4, 'tree', 'browse'),
(4, 'tree', 'browsehost'),
(4, 'tree', 'browseTask'),
(4, 'tree', 'delete'),
(4, 'tree', 'edit'),
(4, 'tree', 'fix'),
(4, 'tree', 'manageChild'),
(4, 'tree', 'updateOrder'),
(4, 'user', 'bug'),
(4, 'user', 'dynamic'),
(4, 'user', 'effortcalendar'),
(4, 'user', 'profile'),
(4, 'user', 'project'),
(4, 'user', 'story'),
(4, 'user', 'task'),
(4, 'user', 'testCase'),
(4, 'user', 'testTask'),
(4, 'user', 'todo'),
(4, 'user', 'todocalendar'),
(4, 'user', 'view'),
(4, 'weekly', 'index'),
(4, 'workestimation', 'index'),
(4, 'workloadbudget', '27'),
(4, 'workloadbudget', 'assign'),
(4, 'workloadbudget', 'batchassign'),
(4, 'workloadbudget', 'batchcreate'),
(4, 'workloadbudget', 'batchedit'),
(4, 'workloadbudget', 'browse'),
(4, 'workloadbudget', 'create'),
(4, 'workloadbudget', 'delete'),
(4, 'workloadbudget', 'edit'),
(4, 'workloadbudget', 'export'),
(4, 'workloadbudget', 'exporttemplate'),
(4, 'workloadbudget', 'import'),
(4, 'workloadbudget', 'link'),
(4, 'workloadbudget', 'search'),
(4, 'workloadbudget', 'showimport'),
(4, 'workloadbudget', 'unlink'),
(4, 'workloadbudget', 'view'),
('5', 'stakeholder', 'browse'),
('5', 'stakeholder', 'communicate'),
('5', 'stakeholder', 'create'),
('5', 'stakeholder', 'delete'),
('5', 'stakeholder', 'createExpect'),
('5', 'stakeholder', 'deleteExpect'),
('5', 'stakeholder', 'edit'),
('5', 'stakeholder', 'editExpect'),
('5', 'stakeholder', 'expect'),
('5', 'stakeholder', 'expectation'),
('5', 'stakeholder', 'issue'),
('5', 'stakeholder', 'plan'),
('5', 'stakeholder', 'userIssue'),
('5', 'stakeholder', 'view'),
('5', 'stakeholder', 'viewExpect'),
('5', 'stakeholder', 'viewIssue'),
(5, 'action', 'editComment'),
(5, 'action', 'hideAll'),
(5, 'action', 'hideOne'),
(5, 'action', 'trash'),
(5, 'action', 'undelete'),
(5, 'activity', '12'),
(5, 'activity', 'assign'),
(5, 'activity', 'batchassign'),
(5, 'activity', 'batchcreate'),
(5, 'activity', 'batchedit'),
(5, 'activity', 'browse'),
(5, 'activity', 'create'),
(5, 'activity', 'delete'),
(5, 'activity', 'edit'),
(5, 'activity', 'export'),
(5, 'activity', 'exporttemplate'),
(5, 'activity', 'import'),
(5, 'activity', 'link'),
(5, 'activity', 'outputlist'),
(5, 'activity', 'search'),
(5, 'activity', 'showimport'),
(5, 'activity', 'unlink'),
(5, 'activity', 'view'),
(5, 'admin', 'index'),
(5, 'audit', '8'),
(5, 'audit', 'assign'),
(5, 'audit', 'batchassign'),
(5, 'audit', 'batchcreate'),
(5, 'audit', 'batchedit'),
(5, 'audit', 'browse'),
(5, 'audit', 'create'),
(5, 'audit', 'delete'),
(5, 'audit', 'edit'),
(5, 'audit', 'export'),
(5, 'audit', 'exporttemplate'),
(5, 'audit', 'import'),
(5, 'audit', 'link'),
(5, 'audit', 'search'),
(5, 'audit', 'showimport'),
(5, 'audit', 'unlink'),
(5, 'audit', 'view'),
(5, 'auditcl', 'assign'),
(5, 'auditcl', 'batchassign'),
(5, 'auditcl', 'batchcreate'),
(5, 'auditcl', 'batchedit'),
(5, 'auditcl', 'browse'),
(5, 'auditcl', 'create'),
(5, 'auditcl', 'delete'),
(5, 'auditcl', 'edit'),
(5, 'auditcl', 'export'),
(5, 'auditcl', 'exporttemplate'),
(5, 'auditcl', 'import'),
(5, 'auditcl', 'link'),
(5, 'auditcl', 'search'),
(5, 'auditcl', 'showimport'),
(5, 'auditcl', 'unlink'),
(5, 'auditcl', 'view'),
(5, 'auditplan', '9'),
(5, 'auditplan', 'assign'),
(5, 'auditplan', 'batchassign'),
(5, 'auditplan', 'batchcreate'),
(5, 'auditplan', 'batchedit'),
(5, 'auditplan', 'browse'),
(5, 'auditplan', 'create'),
(5, 'auditplan', 'delete'),
(5, 'auditplan', 'edit'),
(5, 'auditplan', 'export'),
(5, 'auditplan', 'exporttemplate'),
(5, 'auditplan', 'import'),
(5, 'auditplan', 'link'),
(5, 'auditplan', 'nc'),
(5, 'auditplan', 'result'),
(5, 'auditplan', 'search'),
(5, 'auditplan', 'showimport'),
(5, 'auditplan', 'unlink'),
(5, 'auditplan', 'view'),
(5, 'auditresult', '10'),
(5, 'auditresult', 'assign'),
(5, 'auditresult', 'batchassign'),
(5, 'auditresult', 'batchcreate'),
(5, 'auditresult', 'batchedit'),
(5, 'auditresult', 'browse'),
(5, 'auditresult', 'create'),
(5, 'auditresult', 'delete'),
(5, 'auditresult', 'edit'),
(5, 'auditresult', 'export'),
(5, 'auditresult', 'exporttemplate'),
(5, 'auditresult', 'import'),
(5, 'auditresult', 'link'),
(5, 'auditresult', 'search'),
(5, 'auditresult', 'showimport'),
(5, 'auditresult', 'unlink'),
(5, 'auditresult', 'view'),
(5, 'baseline', 'articleview'),
(5, 'baseline', 'catalog'),
(5, 'baseline', 'createTemplate'),
(5, 'baseline', 'editBook'),
(5, 'baseline', 'editTemplate'),
(5, 'baseline', 'manageBook'),
(5, 'baseline', 'template'),
(5, 'baseline', 'version'),
(5, 'baseline', 'view'),
(5, 'branch', 'delete'),
(5, 'branch', 'manage'),
(5, 'branch', 'sort'),
(5, 'budget', 'batchCreate'),
(5, 'budget', 'browse'),
(5, 'budget', 'create'),
(5, 'budget', 'edit'),
(5, 'budget', 'summary'),
(5, 'budget', 'view'),
(5, 'bug', 'activate'),
(5, 'bug', 'assignTo'),
(5, 'bug', 'batchActivate'),
(5, 'bug', 'batchAssignTo'),
(5, 'bug', 'batchChangeModule'),
(5, 'bug', 'batchClose'),
(5, 'bug', 'batchConfirm'),
(5, 'bug', 'batchCreate'),
(5, 'bug', 'batchEdit'),
(5, 'bug', 'batchResolve'),
(5, 'bug', 'browse'),
(5, 'bug', 'close'),
(5, 'bug', 'confirmBug'),
(5, 'bug', 'confirmStoryChange'),
(5, 'bug', 'create'),
(5, 'bug', 'edit'),
(5, 'bug', 'export'),
(5, 'bug', 'index'),
(5, 'bug', 'linkBugs'),
(5, 'bug', 'report'),
(5, 'bug', 'resolve'),
(5, 'bug', 'view'),
(5, 'build', 'create'),
(5, 'build', 'delete'),
(5, 'build', 'edit'),
(5, 'build', 'view'),
(5, 'classify', 'browse'),
(5, 'cm', 'browse'),
(5, 'cm', 'create'),
(5, 'cm', 'edit'),
(5, 'cm', 'report'),
(5, 'cm', 'view'),
(5, 'cmcl', 'assign'),
(5, 'cmcl', 'batchassign'),
(5, 'cmcl', 'batchcreate'),
(5, 'cmcl', 'batchedit'),
(5, 'cmcl', 'browse'),
(5, 'cmcl', 'create'),
(5, 'cmcl', 'delete'),
(5, 'cmcl', 'edit'),
(5, 'cmcl', 'export'),
(5, 'cmcl', 'exporttemplate'),
(5, 'cmcl', 'import'),
(5, 'cmcl', 'link'),
(5, 'cmcl', 'search'),
(5, 'cmcl', 'showimport'),
(5, 'cmcl', 'unlink'),
(5, 'cmcl', 'view'),
(5, 'company', 'browse'),
(5, 'company', 'dynamic'),
(5, 'company', 'effort'),
(5, 'company', 'index'),
(5, 'company', 'view'),
(5, 'datatable', 'setGlobal'),
(5, 'design', '23'),
(5, 'design', 'assign'),
(5, 'design', 'batchassign'),
(5, 'design', 'batchcreate'),
(5, 'design', 'batchedit'),
(5, 'design', 'browse'),
(5, 'design', 'commit'),
(5, 'design', 'create'),
(5, 'design', 'delete'),
(5, 'design', 'edit'),
(5, 'design', 'export'),
(5, 'design', 'search'),
(5, 'design', 'view'),
(5, 'doc', 'allLibs'),
(5, 'doc', 'browse'),
(5, 'doc', 'create'),
(5, 'doc', 'createLib'),
(5, 'doc', 'delete'),
(5, 'doc', 'deleteFile'),
(5, 'doc', 'deleteLib'),
(5, 'doc', 'edit'),
(5, 'doc', 'editLib'),
(5, 'doc', 'index'),
(5, 'doc', 'objectLibs'),
(5, 'doc', 'showFiles'),
(5, 'doc', 'view'),
(5, 'durationestimation', 'create'),
(5, 'durationestimation', 'index'),
(5, 'effort', 'batchCreate'),
(5, 'effort', 'calendar'),
(5, 'effort', 'createForObject'),
(5, 'effort', 'delete'),
(5, 'effort', 'edit'),
(5, 'effort', 'export'),
(5, 'effort', 'view'),
(5, 'extension', 'browse'),
(5, 'extension', 'obtain'),
(5, 'extension', 'structure'),
(5, 'faq', 'browse'),
(5, 'feedback', 'admin'),
(5, 'feedback', 'adminview'),
(5, 'feedback', 'close'),
(5, 'file', 'delete'),
(5, 'file', 'download'),
(5, 'file', 'edit'),
(5, 'file', 'uploadImages'),
(5, 'git', 'apiSync'),
(5, 'git', 'cat'),
(5, 'git', 'diff'),
(5, 'group', 'browse'),
(5, 'im', 'notifyMSG'),
(5, 'index', 'index'),
(5, 'issue', '17'),
(5, 'issue', '18'),
(5, 'issue', '19'),
(5, 'issue', '20'),
(5, 'issue', '21'),
(5, 'issue', '22'),
(5, 'issue', 'activate'),
(5, 'issue', 'assign'),
(5, 'issue', 'batchassign'),
(5, 'issue', 'batchcreate'),
(5, 'issue', 'batchedit'),
(5, 'issue', 'browse'),
(5, 'issue', 'cancel'),
(5, 'issue', 'close'),
(5, 'issue', 'create'),
(5, 'issue', 'delete'),
(5, 'issue', 'edit'),
(5, 'issue', 'export'),
(5, 'issue', 'resolve'),
(5, 'issue', 'search'),
(5, 'issue', 'view'),
(5, 'measrecord', 'browse'),
(5, 'measurement', 'batchEdit'),
(5, 'measurement', 'browse'),
(5, 'measurement', 'createBasic'),
(5, 'measurement', 'createTemplate'),
(5, 'measurement', 'delete'),
(5, 'measurement', 'design'),
(5, 'measurement', 'designPHP'),
(5, 'measurement', 'designSQL'),
(5, 'measurement', 'editBasic'),
(5, 'measurement', 'editDerivation'),
(5, 'measurement', 'editTemplate'),
(5, 'measurement', 'execCrontabQueue'),
(5, 'measurement', 'initCrontabQueue'),
(5, 'measurement', 'searchMeas'),
(5, 'measurement', 'setTips'),
(5, 'measurement', 'template'),
(5, 'measurement', 'viewTemplate'),
(5, 'milestone', 'index'),
(5, 'milestone', 'saveOtherProblem'),
(5, 'misc', 'ping'),
(5, 'my', 'bug'),
(5, 'my', 'calendar'),
(5, 'my', 'changePassword'),
(5, 'my', 'deleteContacts'),
(5, 'my', 'dynamic'),
(5, 'my', 'editProfile'),
(5, 'my', 'effort'),
(5, 'my', 'index'),
(5, 'my', 'manageContacts'),
(5, 'my', 'profile'),
(5, 'my', 'program'),
(5, 'my', 'project'),
(5, 'my', 'requirement'),
(5, 'my', 'story'),
(5, 'my', 'task'),
(5, 'my', 'testCase'),
(5, 'my', 'testTask'),
(5, 'my', 'todo'),
(5, 'my', 'unbind'),
(5, 'nc', '16'),
(5, 'nc', 'activate'),
(5, 'nc', 'assign'),
(5, 'nc', 'batchassign'),
(5, 'nc', 'batchcreate'),
(5, 'nc', 'batchedit'),
(5, 'nc', 'browse'),
(5, 'nc', 'close'),
(5, 'nc', 'create'),
(5, 'nc', 'delete'),
(5, 'nc', 'edit'),
(5, 'nc', 'export'),
(5, 'nc', 'exporttemplate'),
(5, 'nc', 'import'),
(5, 'nc', 'link'),
(5, 'nc', 'resolve'),
(5, 'nc', 'search'),
(5, 'nc', 'showimport'),
(5, 'nc', 'unlink'),
(5, 'nc', 'view'),
(5, 'output', '13'),
(5, 'output', 'assign'),
(5, 'output', 'batchassign'),
(5, 'output', 'batchcreate'),
(5, 'output', 'batchedit'),
(5, 'output', 'browse'),
(5, 'output', 'create'),
(5, 'output', 'delete'),
(5, 'output', 'edit'),
(5, 'output', 'export'),
(5, 'output', 'exporttemplate'),
(5, 'output', 'import'),
(5, 'output', 'link'),
(5, 'output', 'search'),
(5, 'output', 'showimport'),
(5, 'output', 'unlink'),
(5, 'output', 'view'),
(5, 'process', '11'),
(5, 'process', 'activitylist'),
(5, 'process', 'assign'),
(5, 'process', 'batchassign'),
(5, 'process', 'batchcreate'),
(5, 'process', 'batchedit'),
(5, 'process', 'browse'),
(5, 'process', 'create'),
(5, 'process', 'delete'),
(5, 'process', 'edit'),
(5, 'process', 'export'),
(5, 'process', 'exporttemplate'),
(5, 'process', 'import'),
(5, 'process', 'link'),
(5, 'process', 'search'),
(5, 'process', 'showimport'),
(5, 'process', 'unlink'),
(5, 'process', 'view'),
(5, 'product', 'all'),
(5, 'product', 'browse'),
(5, 'product', 'close'),
(5, 'product', 'create'),
(5, 'product', 'delete'),
(5, 'product', 'edit'),
(5, 'product', 'index'),
(5, 'product', 'view'),
(5, 'productplan', 'batchUnlinkBug'),
(5, 'productplan', 'batchUnlinkStory'),
(5, 'productplan', 'browse'),
(5, 'productplan', 'create'),
(5, 'productplan', 'delete'),
(5, 'productplan', 'edit'),
(5, 'productplan', 'linkBug'),
(5, 'productplan', 'linkStory'),
(5, 'productplan', 'unlinkBug'),
(5, 'productplan', 'unlinkStory'),
(5, 'productplan', 'view'),
(5, 'project', 'activate'),
(5, 'project', 'all'),
(5, 'project', 'batchUnlinkStory'),
(5, 'project', 'browse'),
(5, 'project', 'bug'),
(5, 'project', 'build'),
(5, 'project', 'burn'),
(5, 'project', 'burnData'),
(5, 'project', 'calendar'),
(5, 'project', 'close'),
(5, 'project', 'computeBurn'),
(5, 'project', 'create'),
(5, 'project', 'delete'),
(5, 'project', 'edit'),
(5, 'project', 'effort'),
(5, 'project', 'gantt'),
(5, 'project', 'grouptask'),
(5, 'project', 'importBug'),
(5, 'project', 'importtask'),
(5, 'project', 'index'),
(5, 'project', 'kanban'),
(5, 'project', 'linkStory'),
(5, 'project', 'manageMembers'),
(5, 'project', 'relation'),
(5, 'project', 'story'),
(5, 'project', 'task'),
(5, 'project', 'team'),
(5, 'project', 'testtask'),
(5, 'project', 'tree'),
(5, 'project', 'unlinkMember'),
(5, 'project', 'unlinkStory'),
(5, 'project', 'updateOrder'),
(5, 'project', 'view'),
(5, 'pssp', 'browse'),
(5, 'pssp', 'update'),
(5, 'qa', 'index'),
(5, 'release', 'batchUnlinkBug'),
(5, 'release', 'batchUnlinkStory'),
(5, 'release', 'browse'),
(5, 'release', 'changeStatus'),
(5, 'release', 'create'),
(5, 'release', 'delete'),
(5, 'release', 'edit'),
(5, 'release', 'export'),
(5, 'release', 'linkBug'),
(5, 'release', 'linkStory'),
(5, 'release', 'unlinkBug'),
(5, 'release', 'unlinkStory'),
(5, 'release', 'view'),
(5, 'repo', 'browse'),
(5, 'repo', 'create'),
(5, 'repo', 'delete'),
(5, 'repo', 'diff'),
(5, 'repo', 'download'),
(5, 'repo', 'log'),
(5, 'repo', 'revision'),
(5, 'repo', 'view'),
(5, 'report', 'bugAssign'),
(5, 'report', 'bugCreate'),
(5, 'report', 'build'),
(5, 'report', 'export'),
(5, 'report', 'index'),
(5, 'report', 'productSummary'),
(5, 'report', 'projectDeviation'),
(5, 'report', 'testcase'),
(5, 'report', 'workload'),
(5, 'report', 'workSummary'),
(5, 'review', 'assess'),
(5, 'review', 'audit'),
(5, 'review', 'browse'),
(5, 'review', 'create'),
(5, 'review', 'edit'),
(5, 'review', 'recall'),
(5, 'review', 'report'),
(5, 'review', 'result'),
(5, 'review', 'submit'),
(5, 'review', 'toAudit'),
(5, 'review', 'view'),
(5, 'reviewcl', 'assign'),
(5, 'reviewcl', 'batchassign'),
(5, 'reviewcl', 'batchcreate'),
(5, 'reviewcl', 'batchedit'),
(5, 'reviewcl', 'browse'),
(5, 'reviewcl', 'create'),
(5, 'reviewcl', 'delete'),
(5, 'reviewcl', 'edit'),
(5, 'reviewcl', 'export'),
(5, 'reviewcl', 'exporttemplate'),
(5, 'reviewcl', 'import'),
(5, 'reviewcl', 'search'),
(5, 'reviewcl', 'view'),
(5, 'reviewissue', 'create'),
(5, 'reviewissue', 'edit'),
(5, 'reviewissue', 'issue'),
(5, 'reviewissue', 'resolved'),
(5, 'reviewissue', 'updateStatus'),
(5, 'reviewissue', 'view'),
(5, 'reviewsetting', 'reviewer'),
(5, 'reviewsetting', 'version'),
(5, 'risk', 'activate'),
(5, 'risk', 'assign'),
(5, 'risk', 'batchassign'),
(5, 'risk', 'batchcreate'),
(5, 'risk', 'batchedit'),
(5, 'risk', 'browse'),
(5, 'risk', 'cancel'),
(5, 'risk', 'check'),
(5, 'risk', 'close'),
(5, 'risk', 'create'),
(5, 'risk', 'delete'),
(5, 'risk', 'edit'),
(5, 'risk', 'export'),
(5, 'risk', 'hangup'),
(5, 'risk', 'search'),
(5, 'risk', 'view'),
(5, 'search', 'buildForm'),
(5, 'search', 'buildQuery'),
(5, 'search', 'deleteQuery'),
(5, 'search', 'index'),
(5, 'search', 'saveQuery'),
(5, 'search', 'select'),
(5, 'stage', '24'),
(5, 'stage', 'assign'),
(5, 'stage', 'batchassign'),
(5, 'stage', 'batchcreate'),
(5, 'stage', 'batchedit'),
(5, 'stage', 'browse'),
(5, 'stage', 'create'),
(5, 'stage', 'delete'),
(5, 'stage', 'edit'),
(5, 'stage', 'export'),
(5, 'stage', 'exporttemplate'),
(5, 'stage', 'import'),
(5, 'stage', 'search'),
(5, 'stage', 'view'),
(5, 'story', 'activate'),
(5, 'story', 'batchChangeBranch'),
(5, 'story', 'batchChangeModule'),
(5, 'story', 'batchChangePlan'),
(5, 'story', 'batchChangeStage'),
(5, 'story', 'batchClose'),
(5, 'story', 'batchCreate'),
(5, 'story', 'batchEdit'),
(5, 'story', 'batchReview'),
(5, 'story', 'bugs'),
(5, 'story', 'cases'),
(5, 'story', 'change'),
(5, 'story', 'close'),
(5, 'story', 'create'),
(5, 'story', 'delete'),
(5, 'story', 'edit'),
(5, 'story', 'export'),
(5, 'story', 'linkStory'),
(5, 'story', 'processStoryChange'),
(5, 'story', 'report'),
(5, 'story', 'review'),
(5, 'story', 'tasks'),
(5, 'story', 'track'),
(5, 'story', 'view'),
(5, 'story', 'zeroCase'),
(5, 'subject', 'browse'),
(5, 'svn', 'apiSync'),
(5, 'svn', 'cat'),
(5, 'svn', 'diff'),
(5, 'task', 'activate'),
(5, 'task', 'assignTo'),
(5, 'task', 'batchAssignTo'),
(5, 'task', 'batchChangeModule'),
(5, 'task', 'batchClose'),
(5, 'task', 'batchCreate'),
(5, 'task', 'batchEdit'),
(5, 'task', 'cancel'),
(5, 'task', 'close'),
(5, 'task', 'confirmStoryChange'),
(5, 'task', 'create'),
(5, 'task', 'deleteEstimate'),
(5, 'task', 'edit'),
(5, 'task', 'editEstimate'),
(5, 'task', 'export'),
(5, 'task', 'finish'),
(5, 'task', 'pause'),
(5, 'task', 'recordEstimate'),
(5, 'task', 'report'),
(5, 'task', 'restart'),
(5, 'task', 'start'),
(5, 'task', 'view'),
(5, 'testcase', 'browse'),
(5, 'testcase', 'bugs'),
(5, 'testcase', 'createBug'),
(5, 'testcase', 'export'),
(5, 'testcase', 'groupCase'),
(5, 'testcase', 'importFromLib'),
(5, 'testcase', 'index'),
(5, 'testcase', 'view'),
(5, 'testsuite', 'browse'),
(5, 'testsuite', 'index'),
(5, 'testsuite', 'view'),
(5, 'testtask', 'browse'),
(5, 'testtask', 'cases'),
(5, 'testtask', 'create'),
(5, 'testtask', 'edit'),
(5, 'testtask', 'groupCase'),
(5, 'testtask', 'index'),
(5, 'testtask', 'results'),
(5, 'testtask', 'view'),
(5, 'todo', 'activate'),
(5, 'todo', 'assignTo'),
(5, 'todo', 'batchClose'),
(5, 'todo', 'batchCreate'),
(5, 'todo', 'batchEdit'),
(5, 'todo', 'batchFinish'),
(5, 'todo', 'calendar'),
(5, 'todo', 'close'),
(5, 'todo', 'create'),
(5, 'todo', 'delete'),
(5, 'todo', 'edit'),
(5, 'todo', 'export'),
(5, 'todo', 'finish'),
(5, 'todo', 'import2Today'),
(5, 'todo', 'view'),
(5, 'tree', 'browse'),
(5, 'tree', 'browseTask'),
(5, 'tree', 'delete'),
(5, 'tree', 'edit'),
(5, 'tree', 'fix'),
(5, 'tree', 'manageChild'),
(5, 'tree', 'updateOrder'),
(5, 'user', 'bug'),
(5, 'user', 'dynamic'),
(5, 'user', 'effortcalendar'),
(5, 'user', 'profile'),
(5, 'user', 'project'),
(5, 'user', 'story'),
(5, 'user', 'task'),
(5, 'user', 'testCase'),
(5, 'user', 'testTask'),
(5, 'user', 'todo'),
(5, 'user', 'todocalendar'),
(5, 'user', 'view'),
(5, 'weekly', 'index'),
(5, 'workestimation', 'index'),
(5, 'workloadbudget', '27'),
(5, 'workloadbudget', 'assign'),
(5, 'workloadbudget', 'batchassign'),
(5, 'workloadbudget', 'batchcreate'),
(5, 'workloadbudget', 'batchedit'),
(5, 'workloadbudget', 'browse'),
(5, 'workloadbudget', 'create'),
(5, 'workloadbudget', 'delete'),
(5, 'workloadbudget', 'edit'),
(5, 'workloadbudget', 'export'),
(5, 'workloadbudget', 'exporttemplate'),
(5, 'workloadbudget', 'import'),
(5, 'workloadbudget', 'link'),
(5, 'workloadbudget', 'search'),
(5, 'workloadbudget', 'showimport'),
(5, 'workloadbudget', 'unlink'),
(5, 'workloadbudget', 'view'),
(6, 'action', 'editComment'),
(6, 'action', 'hideAll'),
(6, 'action', 'hideOne'),
(6, 'action', 'trash'),
(6, 'action', 'undelete'),
(6, 'activity', '12'),
(6, 'activity', 'assign'),
(6, 'activity', 'batchassign'),
(6, 'activity', 'batchcreate'),
(6, 'activity', 'batchedit'),
(6, 'activity', 'browse'),
(6, 'activity', 'create'),
(6, 'activity', 'delete'),
(6, 'activity', 'edit'),
(6, 'activity', 'export'),
(6, 'activity', 'exporttemplate'),
(6, 'activity', 'import'),
(6, 'activity', 'link'),
(6, 'activity', 'outputlist'),
(6, 'activity', 'search'),
(6, 'activity', 'showimport'),
(6, 'activity', 'unlink'),
(6, 'activity', 'view'),
(6, 'admin', 'index'),
(6, 'audit', '8'),
(6, 'audit', 'assign'),
(6, 'audit', 'batchassign'),
(6, 'audit', 'batchcreate'),
(6, 'audit', 'batchedit'),
(6, 'audit', 'browse'),
(6, 'audit', 'create'),
(6, 'audit', 'delete'),
(6, 'audit', 'edit'),
(6, 'audit', 'export'),
(6, 'audit', 'exporttemplate'),
(6, 'audit', 'import'),
(6, 'audit', 'link'),
(6, 'audit', 'search'),
(6, 'audit', 'showimport'),
(6, 'audit', 'unlink'),
(6, 'audit', 'view'),
(6, 'auditcl', 'assign'),
(6, 'auditcl', 'batchassign'),
(6, 'auditcl', 'batchcreate'),
(6, 'auditcl', 'batchedit'),
(6, 'auditcl', 'browse'),
(6, 'auditcl', 'create'),
(6, 'auditcl', 'delete'),
(6, 'auditcl', 'edit'),
(6, 'auditcl', 'export'),
(6, 'auditcl', 'exporttemplate'),
(6, 'auditcl', 'import'),
(6, 'auditcl', 'link'),
(6, 'auditcl', 'search'),
(6, 'auditcl', 'showimport'),
(6, 'auditcl', 'unlink'),
(6, 'auditcl', 'view'),
(6, 'auditplan', '9'),
(6, 'auditplan', 'assign'),
(6, 'auditplan', 'batchassign'),
(6, 'auditplan', 'batchcreate'),
(6, 'auditplan', 'batchedit'),
(6, 'auditplan', 'browse'),
(6, 'auditplan', 'create'),
(6, 'auditplan', 'delete'),
(6, 'auditplan', 'edit'),
(6, 'auditplan', 'export'),
(6, 'auditplan', 'exporttemplate'),
(6, 'auditplan', 'import'),
(6, 'auditplan', 'link'),
(6, 'auditplan', 'nc'),
(6, 'auditplan', 'result'),
(6, 'auditplan', 'search'),
(6, 'auditplan', 'showimport'),
(6, 'auditplan', 'unlink'),
(6, 'auditplan', 'view'),
(6, 'auditresult', '10'),
(6, 'auditresult', 'assign'),
(6, 'auditresult', 'batchassign'),
(6, 'auditresult', 'batchcreate'),
(6, 'auditresult', 'batchedit'),
(6, 'auditresult', 'browse'),
(6, 'auditresult', 'create'),
(6, 'auditresult', 'delete'),
(6, 'auditresult', 'edit'),
(6, 'auditresult', 'export'),
(6, 'auditresult', 'exporttemplate'),
(6, 'auditresult', 'import'),
(6, 'auditresult', 'link'),
(6, 'auditresult', 'search'),
(6, 'auditresult', 'showimport'),
(6, 'auditresult', 'unlink'),
(6, 'auditresult', 'view'),
(6, 'baseline', 'articleview'),
(6, 'baseline', 'catalog'),
(6, 'baseline', 'createTemplate'),
(6, 'baseline', 'editBook'),
(6, 'baseline', 'editTemplate'),
(6, 'baseline', 'manageBook'),
(6, 'baseline', 'template'),
(6, 'baseline', 'version'),
(6, 'baseline', 'view'),
(6, 'budget', 'batchCreate'),
(6, 'budget', 'browse'),
(6, 'budget', 'create'),
(6, 'budget', 'edit'),
(6, 'budget', 'summary'),
(6, 'budget', 'view'),
(6, 'bug', 'activate'),
(6, 'bug', 'assignTo'),
(6, 'bug', 'batchActivate'),
(6, 'bug', 'batchAssignTo'),
(6, 'bug', 'batchChangeModule'),
(6, 'bug', 'batchClose'),
(6, 'bug', 'batchConfirm'),
(6, 'bug', 'batchCreate'),
(6, 'bug', 'batchEdit'),
(6, 'bug', 'batchResolve'),
(6, 'bug', 'browse'),
(6, 'bug', 'close'),
(6, 'bug', 'confirmBug'),
(6, 'bug', 'confirmStoryChange'),
(6, 'bug', 'create'),
(6, 'bug', 'delete'),
(6, 'bug', 'edit'),
(6, 'bug', 'export'),
(6, 'bug', 'index'),
(6, 'bug', 'linkBugs'),
(6, 'bug', 'report'),
(6, 'bug', 'resolve'),
(6, 'bug', 'view'),
(6, 'build', 'batchUnlinkBug'),
(6, 'build', 'batchUnlinkStory'),
(6, 'build', 'create'),
(6, 'build', 'delete'),
(6, 'build', 'edit'),
(6, 'build', 'linkBug'),
(6, 'build', 'linkStory'),
(6, 'build', 'unlinkBug'),
(6, 'build', 'unlinkStory'),
(6, 'build', 'view'),
(6, 'classify', 'browse'),
(6, 'client', 'browse'),
(6, 'client', 'checkUpgrade'),
(6, 'client', 'create'),
(6, 'client', 'delete'),
(6, 'client', 'edit'),
(6, 'cm', 'browse'),
(6, 'cm', 'create'),
(6, 'cm', 'edit'),
(6, 'cm', 'report'),
(6, 'cm', 'view'),
(6, 'cmcl', 'assign'),
(6, 'cmcl', 'batchassign'),
(6, 'cmcl', 'batchcreate'),
(6, 'cmcl', 'batchedit'),
(6, 'cmcl', 'browse'),
(6, 'cmcl', 'create'),
(6, 'cmcl', 'delete'),
(6, 'cmcl', 'edit'),
(6, 'cmcl', 'export'),
(6, 'cmcl', 'exporttemplate'),
(6, 'cmcl', 'import'),
(6, 'cmcl', 'link'),
(6, 'cmcl', 'search'),
(6, 'cmcl', 'showimport'),
(6, 'cmcl', 'unlink'),
(6, 'cmcl', 'view'),
(6, 'company', 'browse'),
(6, 'company', 'dynamic'),
(6, 'company', 'effort'),
(6, 'company', 'index'),
(6, 'company', 'view'),
(6, 'custom', 'estimate'),
(6, 'datatable', 'setGlobal'),
(6, 'design', '23'),
(6, 'design', 'assign'),
(6, 'design', 'batchassign'),
(6, 'design', 'batchcreate'),
(6, 'design', 'batchedit'),
(6, 'design', 'browse'),
(6, 'design', 'commit'),
(6, 'design', 'create'),
(6, 'design', 'delete'),
(6, 'design', 'edit'),
(6, 'design', 'export'),
(6, 'design', 'search'),
(6, 'design', 'view'),
(6, 'doc', 'allLibs'),
(6, 'doc', 'browse'),
(6, 'doc', 'create'),
(6, 'doc', 'createLib'),
(6, 'doc', 'delete'),
(6, 'doc', 'deleteFile'),
(6, 'doc', 'deleteLib'),
(6, 'doc', 'edit'),
(6, 'doc', 'editLib'),
(6, 'doc', 'index'),
(6, 'doc', 'objectLibs'),
(6, 'doc', 'showFiles'),
(6, 'doc', 'view'),
(6, 'durationestimation', 'create'),
(6, 'durationestimation', 'index'),
(6, 'effort', 'batchCreate'),
(6, 'effort', 'calendar'),
(6, 'effort', 'createForObject'),
(6, 'effort', 'edit'),
(6, 'effort', 'export'),
(6, 'effort', 'view'),
(6, 'extension', 'browse'),
(6, 'extension', 'obtain'),
(6, 'extension', 'structure'),
(6, 'file', 'delete'),
(6, 'file', 'download'),
(6, 'file', 'edit'),
(6, 'file', 'uploadImages'),
(6, 'git', 'apiSync'),
(6, 'git', 'cat'),
(6, 'git', 'diff'),
(6, 'group', 'browse'),
(6, 'host', 'browse'),
(6, 'host', 'create'),
(6, 'host', 'delete'),
(6, 'host', 'edit'),
(6, 'host', 'treemap'),
(6, 'host', 'view'),
(6, 'im', 'notifyMSG'),
(6, 'index', 'index'),
(6, 'issue', '17'),
(6, 'issue', '18'),
(6, 'issue', '19'),
(6, 'issue', '20'),
(6, 'issue', '21'),
(6, 'issue', '22'),
(6, 'issue', 'activate'),
(6, 'issue', 'assign'),
(6, 'issue', 'batchassign'),
(6, 'issue', 'batchcreate'),
(6, 'issue', 'batchedit'),
(6, 'issue', 'browse'),
(6, 'issue', 'cancel'),
(6, 'issue', 'close'),
(6, 'issue', 'create'),
(6, 'issue', 'delete'),
(6, 'issue', 'edit'),
(6, 'issue', 'export'),
(6, 'issue', 'resolve'),
(6, 'issue', 'search'),
(6, 'issue', 'view'),
(6, 'milestone', 'index'),
(6, 'milestone', 'saveOtherProblem'),
(6, 'misc', 'ping'),
(6, 'my', 'bug'),
(6, 'my', 'calendar'),
(6, 'my', 'changePassword'),
(6, 'my', 'deleteContacts'),
(6, 'my', 'dynamic'),
(6, 'my', 'editProfile'),
(6, 'my', 'effort'),
(6, 'my', 'index'),
(6, 'my', 'manageContacts'),
(6, 'my', 'nc'),
(6, 'my', 'profile'),
(6, 'my', 'program'),
(6, 'my', 'project'),
(6, 'my', 'requirement'),
(6, 'my', 'story'),
(6, 'my', 'task'),
(6, 'my', 'testCase'),
(6, 'my', 'testTask'),
(6, 'my', 'todo'),
(6, 'my', 'unbind'),
(6, 'nc', '16'),
(6, 'nc', 'activate'),
(6, 'nc', 'assign'),
(6, 'nc', 'batchassign'),
(6, 'nc', 'batchcreate'),
(6, 'nc', 'batchedit'),
(6, 'nc', 'browse'),
(6, 'nc', 'close'),
(6, 'nc', 'create'),
(6, 'nc', 'delete'),
(6, 'nc', 'edit'),
(6, 'nc', 'export'),
(6, 'nc', 'exporttemplate'),
(6, 'nc', 'import'),
(6, 'nc', 'link'),
(6, 'nc', 'resolve'),
(6, 'nc', 'search'),
(6, 'nc', 'showimport'),
(6, 'nc', 'unlink'),
(6, 'nc', 'view'),
(6, 'output', '13'),
(6, 'output', 'assign'),
(6, 'output', 'batchassign'),
(6, 'output', 'batchcreate'),
(6, 'output', 'batchedit'),
(6, 'output', 'browse'),
(6, 'output', 'create'),
(6, 'output', 'delete'),
(6, 'output', 'edit'),
(6, 'output', 'export'),
(6, 'output', 'exporttemplate'),
(6, 'output', 'import'),
(6, 'output', 'link'),
(6, 'output', 'search'),
(6, 'output', 'showimport'),
(6, 'output', 'unlink'),
(6, 'output', 'view'),
(6, 'process', '11'),
(6, 'process', 'activitylist'),
(6, 'process', 'assign'),
(6, 'process', 'batchassign'),
(6, 'process', 'batchcreate'),
(6, 'process', 'batchedit'),
(6, 'process', 'browse'),
(6, 'process', 'create'),
(6, 'process', 'delete'),
(6, 'process', 'edit'),
(6, 'process', 'export'),
(6, 'process', 'exporttemplate'),
(6, 'process', 'import'),
(6, 'process', 'link'),
(6, 'process', 'search'),
(6, 'process', 'showimport'),
(6, 'process', 'unlink'),
(6, 'process', 'view'),
(6, 'product', 'all'),
(6, 'product', 'browse'),
(6, 'product', 'index'),
(6, 'product', 'view'),
(6, 'productplan', 'browse'),
(6, 'productplan', 'view'),
(6, 'project', 'activate'),
(6, 'project', 'all'),
(6, 'project', 'batchUnlinkStory'),
(6, 'project', 'browse'),
(6, 'project', 'bug'),
(6, 'project', 'build'),
(6, 'project', 'burn'),
(6, 'project', 'burnData'),
(6, 'project', 'calendar'),
(6, 'project', 'close'),
(6, 'project', 'computeBurn'),
(6, 'project', 'create'),
(6, 'project', 'delete'),
(6, 'project', 'edit'),
(6, 'project', 'effort'),
(6, 'project', 'gantt'),
(6, 'project', 'grouptask'),
(6, 'project', 'importBug'),
(6, 'project', 'importtask'),
(6, 'project', 'index'),
(6, 'project', 'kanban'),
(6, 'project', 'linkStory'),
(6, 'project', 'manageMembers'),
(6, 'project', 'relation'),
(6, 'project', 'story'),
(6, 'project', 'storySort'),
(6, 'project', 'task'),
(6, 'project', 'team'),
(6, 'project', 'testtask'),
(6, 'project', 'tree'),
(6, 'project', 'unlinkMember'),
(6, 'project', 'unlinkStory'),
(6, 'project', 'updateOrder'),
(6, 'project', 'view'),
(6, 'pssp', 'browse'),
(6, 'pssp', 'update'),
(6, 'qa', 'index'),
(6, 'release', 'browse'),
(6, 'release', 'export'),
(6, 'release', 'view'),
(6, 'repo', 'browse'),
(6, 'repo', 'diff'),
(6, 'repo', 'download'),
(6, 'repo', 'log'),
(6, 'repo', 'revision'),
(6, 'repo', 'view'),
(6, 'report', 'bugAssign'),
(6, 'report', 'bugCreate'),
(6, 'report', 'build'),
(6, 'report', 'export'),
(6, 'report', 'index'),
(6, 'report', 'productSummary'),
(6, 'report', 'projectDeviation'),
(6, 'report', 'testcase'),
(6, 'report', 'workload'),
(6, 'report', 'workSummary'),
(6, 'review', 'assess'),
(6, 'review', 'audit'),
(6, 'review', 'browse'),
(6, 'review', 'create'),
(6, 'review', 'edit'),
(6, 'review', 'recall'),
(6, 'review', 'report'),
(6, 'review', 'result'),
(6, 'review', 'submit'),
(6, 'review', 'toAudit'),
(6, 'review', 'view'),
(6, 'reviewcl', 'assign'),
(6, 'reviewcl', 'batchassign'),
(6, 'reviewcl', 'batchcreate'),
(6, 'reviewcl', 'batchedit'),
(6, 'reviewcl', 'browse'),
(6, 'reviewcl', 'create'),
(6, 'reviewcl', 'delete'),
(6, 'reviewcl', 'edit'),
(6, 'reviewcl', 'export'),
(6, 'reviewcl', 'exporttemplate'),
(6, 'reviewcl', 'import'),
(6, 'reviewcl', 'search'),
(6, 'reviewcl', 'view'),
(6, 'reviewissue', 'create'),
(6, 'reviewissue', 'edit'),
(6, 'reviewissue', 'issue'),
(6, 'reviewissue', 'resolved'),
(6, 'reviewissue', 'updateStatus'),
(6, 'reviewissue', 'view'),
(6, 'reviewsetting', 'reviewer'),
(6, 'reviewsetting', 'version'),
(6, 'risk', 'activate'),
(6, 'risk', 'assign'),
(6, 'risk', 'batchassign'),
(6, 'risk', 'batchcreate'),
(6, 'risk', 'batchedit'),
(6, 'risk', 'browse'),
(6, 'risk', 'cancel'),
(6, 'risk', 'check'),
(6, 'risk', 'close'),
(6, 'risk', 'create'),
(6, 'risk', 'delete'),
(6, 'risk', 'edit'),
(6, 'risk', 'export'),
(6, 'risk', 'hangup'),
(6, 'risk', 'search'),
(6, 'risk', 'view'),
(6, 'search', 'buildForm'),
(6, 'search', 'buildQuery'),
(6, 'search', 'deleteQuery'),
(6, 'search', 'index'),
(6, 'search', 'saveQuery'),
(6, 'search', 'select'),
(6, 'stage', '24'),
(6, 'stage', 'assign'),
(6, 'stage', 'batchassign'),
(6, 'stage', 'batchcreate'),
(6, 'stage', 'batchedit'),
(6, 'stage', 'browse'),
(6, 'stage', 'create'),
(6, 'stage', 'delete'),
(6, 'stage', 'edit'),
(6, 'stage', 'export'),
(6, 'stage', 'exporttemplate'),
(6, 'stage', 'import'),
(6, 'stage', 'search'),
(6, 'stage', 'view'),
(6, 'story', 'bugs'),
(6, 'story', 'cases'),
(6, 'story', 'export'),
(6, 'story', 'processStoryChange'),
(6, 'story', 'report'),
(6, 'story', 'tasks'),
(6, 'story', 'track'),
(6, 'story', 'view'),
(6, 'story', 'zeroCase'),
(6, 'subject', 'browse'),
(6, 'svn', 'apiSync'),
(6, 'svn', 'cat'),
(6, 'svn', 'diff'),
(6, 'task', 'activate'),
(6, 'task', 'assignTo'),
(6, 'task', 'batchAssignTo'),
(6, 'task', 'batchChangeModule'),
(6, 'task', 'batchClose'),
(6, 'task', 'batchCreate'),
(6, 'task', 'batchEdit'),
(6, 'task', 'cancel'),
(6, 'task', 'close'),
(6, 'task', 'confirmStoryChange'),
(6, 'task', 'create'),
(6, 'task', 'delete'),
(6, 'task', 'deleteEstimate'),
(6, 'task', 'edit'),
(6, 'task', 'editEstimate'),
(6, 'task', 'export'),
(6, 'task', 'finish'),
(6, 'task', 'pause'),
(6, 'task', 'recordEstimate'),
(6, 'task', 'report'),
(6, 'task', 'restart'),
(6, 'task', 'start'),
(6, 'task', 'view'),
(6, 'testcase', 'browse'),
(6, 'testcase', 'bugs'),
(6, 'testcase', 'export'),
(6, 'testcase', 'groupCase'),
(6, 'testcase', 'index'),
(6, 'testcase', 'view'),
(6, 'testsuite', 'browse'),
(6, 'testsuite', 'index'),
(6, 'testsuite', 'view'),
(6, 'testtask', 'browse'),
(6, 'testtask', 'cases'),
(6, 'testtask', 'create'),
(6, 'testtask', 'edit'),
(6, 'testtask', 'groupCase'),
(6, 'testtask', 'index'),
(6, 'testtask', 'results'),
(6, 'testtask', 'view'),
(6, 'todo', 'activate'),
(6, 'todo', 'assignTo'),
(6, 'todo', 'batchClose'),
(6, 'todo', 'batchCreate'),
(6, 'todo', 'batchEdit'),
(6, 'todo', 'batchFinish'),
(6, 'todo', 'calendar'),
(6, 'todo', 'close'),
(6, 'todo', 'create'),
(6, 'todo', 'delete'),
(6, 'todo', 'edit'),
(6, 'todo', 'export'),
(6, 'todo', 'finish'),
(6, 'todo', 'import2Today'),
(6, 'todo', 'view'),
(6, 'tree', 'browse'),
(6, 'tree', 'browsehost'),
(6, 'tree', 'browseTask'),
(6, 'tree', 'delete'),
(6, 'tree', 'edit'),
(6, 'tree', 'fix'),
(6, 'tree', 'manageChild'),
(6, 'tree', 'updateOrder'),
(6, 'user', 'bug'),
(6, 'user', 'dynamic'),
(6, 'user', 'effortcalendar'),
(6, 'user', 'profile'),
(6, 'user', 'project'),
(6, 'user', 'story'),
(6, 'user', 'task'),
(6, 'user', 'testCase'),
(6, 'user', 'testTask'),
(6, 'user', 'todo'),
(6, 'user', 'todocalendar'),
(6, 'user', 'view'),
(6, 'weekly', 'index'),
(6, 'workestimation', 'index'),
(6, 'workloadbudget', '27'),
(6, 'workloadbudget', 'assign'),
(6, 'workloadbudget', 'batchassign'),
(6, 'workloadbudget', 'batchcreate'),
(6, 'workloadbudget', 'batchedit'),
(6, 'workloadbudget', 'browse'),
(6, 'workloadbudget', 'create'),
(6, 'workloadbudget', 'delete'),
(6, 'workloadbudget', 'edit'),
(6, 'workloadbudget', 'export'),
(6, 'workloadbudget', 'exporttemplate'),
(6, 'workloadbudget', 'import'),
(6, 'workloadbudget', 'link'),
(6, 'workloadbudget', 'search'),
(6, 'workloadbudget', 'showimport'),
(6, 'workloadbudget', 'unlink'),
(6, 'workloadbudget', 'view'),
(7, 'action', 'editComment'),
(7, 'action', 'hideAll'),
(7, 'action', 'hideOne'),
(7, 'action', 'trash'),
(7, 'action', 'undelete'),
(7, 'activity', '12'),
(7, 'activity', 'assign'),
(7, 'activity', 'batchassign'),
(7, 'activity', 'batchcreate'),
(7, 'activity', 'batchedit'),
(7, 'activity', 'browse'),
(7, 'activity', 'create'),
(7, 'activity', 'delete'),
(7, 'activity', 'edit'),
(7, 'activity', 'export'),
(7, 'activity', 'exporttemplate'),
(7, 'activity', 'import'),
(7, 'activity', 'link'),
(7, 'activity', 'outputlist'),
(7, 'activity', 'search'),
(7, 'activity', 'showimport'),
(7, 'activity', 'unlink'),
(7, 'activity', 'view'),
(7, 'admin', 'index'),
(7, 'audit', '8'),
(7, 'audit', 'assign'),
(7, 'audit', 'batchassign'),
(7, 'audit', 'batchcreate'),
(7, 'audit', 'batchedit'),
(7, 'audit', 'browse'),
(7, 'audit', 'create'),
(7, 'audit', 'delete'),
(7, 'audit', 'edit'),
(7, 'audit', 'export'),
(7, 'audit', 'exporttemplate'),
(7, 'audit', 'import'),
(7, 'audit', 'link'),
(7, 'audit', 'search'),
(7, 'audit', 'showimport'),
(7, 'audit', 'unlink'),
(7, 'audit', 'view'),
(7, 'auditcl', 'assign'),
(7, 'auditcl', 'batchassign'),
(7, 'auditcl', 'batchcreate'),
(7, 'auditcl', 'batchedit'),
(7, 'auditcl', 'browse'),
(7, 'auditcl', 'create'),
(7, 'auditcl', 'delete'),
(7, 'auditcl', 'edit'),
(7, 'auditcl', 'export'),
(7, 'auditcl', 'exporttemplate'),
(7, 'auditcl', 'import'),
(7, 'auditcl', 'link'),
(7, 'auditcl', 'search'),
(7, 'auditcl', 'showimport'),
(7, 'auditcl', 'unlink'),
(7, 'auditcl', 'view'),
(7, 'auditplan', '9'),
(7, 'auditplan', 'assign'),
(7, 'auditplan', 'batchassign'),
(7, 'auditplan', 'batchcreate'),
(7, 'auditplan', 'batchedit'),
(7, 'auditplan', 'browse'),
(7, 'auditplan', 'create'),
(7, 'auditplan', 'delete'),
(7, 'auditplan', 'edit'),
(7, 'auditplan', 'export'),
(7, 'auditplan', 'exporttemplate'),
(7, 'auditplan', 'import'),
(7, 'auditplan', 'link'),
(7, 'auditplan', 'nc'),
(7, 'auditplan', 'result'),
(7, 'auditplan', 'search'),
(7, 'auditplan', 'showimport'),
(7, 'auditplan', 'unlink'),
(7, 'auditplan', 'view'),
(7, 'auditresult', '10'),
(7, 'auditresult', 'assign'),
(7, 'auditresult', 'batchassign'),
(7, 'auditresult', 'batchcreate'),
(7, 'auditresult', 'batchedit'),
(7, 'auditresult', 'browse'),
(7, 'auditresult', 'create'),
(7, 'auditresult', 'delete'),
(7, 'auditresult', 'edit'),
(7, 'auditresult', 'export'),
(7, 'auditresult', 'exporttemplate'),
(7, 'auditresult', 'import'),
(7, 'auditresult', 'link'),
(7, 'auditresult', 'search'),
(7, 'auditresult', 'showimport'),
(7, 'auditresult', 'unlink'),
(7, 'auditresult', 'view'),
(7, 'baseline', 'articleview'),
(7, 'baseline', 'catalog'),
(7, 'baseline', 'createTemplate'),
(7, 'baseline', 'editBook'),
(7, 'baseline', 'editTemplate'),
(7, 'baseline', 'manageBook'),
(7, 'baseline', 'template'),
(7, 'baseline', 'version'),
(7, 'baseline', 'view'),
(7, 'branch', 'delete'),
(7, 'branch', 'manage'),
(7, 'branch', 'sort'),
(7, 'budget', 'batchCreate'),
(7, 'budget', 'browse'),
(7, 'budget', 'create'),
(7, 'budget', 'delete'),
(7, 'budget', 'edit'),
(7, 'budget', 'summary'),
(7, 'budget', 'view'),
(7, 'bug', 'activate'),
(7, 'bug', 'assignTo'),
(7, 'bug', 'batchActivate'),
(7, 'bug', 'batchAssignTo'),
(7, 'bug', 'batchChangeModule'),
(7, 'bug', 'batchClose'),
(7, 'bug', 'batchConfirm'),
(7, 'bug', 'batchCreate'),
(7, 'bug', 'batchEdit'),
(7, 'bug', 'batchResolve'),
(7, 'bug', 'browse'),
(7, 'bug', 'close'),
(7, 'bug', 'confirmBug'),
(7, 'bug', 'confirmStoryChange'),
(7, 'bug', 'create'),
(7, 'bug', 'delete'),
(7, 'bug', 'edit'),
(7, 'bug', 'export'),
(7, 'bug', 'index'),
(7, 'bug', 'linkBugs'),
(7, 'bug', 'report'),
(7, 'bug', 'resolve'),
(7, 'bug', 'view'),
(7, 'build', 'create'),
(7, 'build', 'delete'),
(7, 'build', 'edit'),
(7, 'build', 'view'),
(7, 'classify', 'browse'),
(7, 'cm', 'browse'),
(7, 'cm', 'create'),
(7, 'cm', 'edit'),
(7, 'cm', 'report'),
(7, 'cm', 'view'),
(7, 'cmcl', 'assign'),
(7, 'cmcl', 'batchassign'),
(7, 'cmcl', 'batchcreate'),
(7, 'cmcl', 'batchedit'),
(7, 'cmcl', 'browse'),
(7, 'cmcl', 'create'),
(7, 'cmcl', 'delete'),
(7, 'cmcl', 'edit'),
(7, 'cmcl', 'export'),
(7, 'cmcl', 'exporttemplate'),
(7, 'cmcl', 'import'),
(7, 'cmcl', 'link'),
(7, 'cmcl', 'search'),
(7, 'cmcl', 'showimport'),
(7, 'cmcl', 'unlink'),
(7, 'cmcl', 'view'),
(7, 'company', 'browse'),
(7, 'company', 'dynamic'),
(7, 'company', 'effort'),
(7, 'company', 'index'),
(7, 'company', 'view'),
(7, 'custom', 'estimate'),
(7, 'design', '23'),
(7, 'design', 'assign'),
(7, 'design', 'batchassign'),
(7, 'design', 'batchcreate'),
(7, 'design', 'batchedit'),
(7, 'design', 'browse'),
(7, 'design', 'commit'),
(7, 'design', 'create'),
(7, 'design', 'delete'),
(7, 'design', 'edit'),
(7, 'design', 'export'),
(7, 'design', 'search'),
(7, 'design', 'view'),
(7, 'doc', 'allLibs'),
(7, 'doc', 'browse'),
(7, 'doc', 'create'),
(7, 'doc', 'createLib'),
(7, 'doc', 'delete'),
(7, 'doc', 'deleteFile'),
(7, 'doc', 'deleteLib'),
(7, 'doc', 'edit'),
(7, 'doc', 'editLib'),
(7, 'doc', 'index'),
(7, 'doc', 'objectLibs'),
(7, 'doc', 'showFiles'),
(7, 'doc', 'view'),
(7, 'durationestimation', 'create'),
(7, 'durationestimation', 'index'),
(7, 'effort', 'batchCreate'),
(7, 'effort', 'calendar'),
(7, 'effort', 'createForObject'),
(7, 'effort', 'delete'),
(7, 'effort', 'edit'),
(7, 'effort', 'export'),
(7, 'effort', 'view'),
(7, 'extension', 'browse'),
(7, 'extension', 'obtain'),
(7, 'extension', 'structure'),
(7, 'file', 'delete'),
(7, 'file', 'download'),
(7, 'file', 'edit'),
(7, 'file', 'uploadImages'),
(7, 'git', 'apiSync'),
(7, 'git', 'cat'),
(7, 'git', 'diff'),
(7, 'group', 'browse'),
(7, 'im', 'notifyMSG'),
(7, 'index', 'index'),
(7, 'issue', '17'),
(7, 'issue', '18'),
(7, 'issue', '19'),
(7, 'issue', '20'),
(7, 'issue', '21'),
(7, 'issue', '22'),
(7, 'issue', 'activate'),
(7, 'issue', 'assign'),
(7, 'issue', 'batchassign'),
(7, 'issue', 'batchcreate'),
(7, 'issue', 'batchedit'),
(7, 'issue', 'browse'),
(7, 'issue', 'cancel'),
(7, 'issue', 'close'),
(7, 'issue', 'create'),
(7, 'issue', 'delete'),
(7, 'issue', 'edit'),
(7, 'issue', 'export'),
(7, 'issue', 'resolve'),
(7, 'issue', 'search'),
(7, 'issue', 'view'),
(7, 'measrecord', 'browse'),
(7, 'measurement', 'batchEdit'),
(7, 'measurement', 'browse'),
(7, 'measurement', 'createBasic'),
(7, 'measurement', 'createTemplate'),
(7, 'measurement', 'delete'),
(7, 'measurement', 'design'),
(7, 'measurement', 'designPHP'),
(7, 'measurement', 'designSQL'),
(7, 'measurement', 'editBasic'),
(7, 'measurement', 'editDerivation'),
(7, 'measurement', 'editTemplate'),
(7, 'measurement', 'execCrontabQueue'),
(7, 'measurement', 'initCrontabQueue'),
(7, 'measurement', 'searchMeas'),
(7, 'measurement', 'setTips'),
(7, 'measurement', 'template'),
(7, 'measurement', 'viewTemplate'),
(7, 'milestone', 'index'),
(7, 'misc', 'ping'),
(7, 'my', 'bug'),
(7, 'my', 'calendar'),
(7, 'my', 'changePassword'),
(7, 'my', 'deleteContacts'),
(7, 'my', 'dynamic'),
(7, 'my', 'editProfile'),
(7, 'my', 'effort'),
(7, 'my', 'index'),
(7, 'my', 'manageContacts'),
(7, 'my', 'nc'),
(7, 'my', 'profile'),
(7, 'my', 'program'),
(7, 'my', 'project'),
(7, 'my', 'requirement'),
(7, 'my', 'story'),
(7, 'my', 'task'),
(7, 'my', 'testCase'),
(7, 'my', 'testTask'),
(7, 'my', 'todo'),
(7, 'my', 'unbind'),
(7, 'nc', '16'),
(7, 'nc', 'activate'),
(7, 'nc', 'assign'),
(7, 'nc', 'batchassign'),
(7, 'nc', 'batchcreate'),
(7, 'nc', 'batchedit'),
(7, 'nc', 'browse'),
(7, 'nc', 'close'),
(7, 'nc', 'create'),
(7, 'nc', 'delete'),
(7, 'nc', 'edit'),
(7, 'nc', 'export'),
(7, 'nc', 'exporttemplate'),
(7, 'nc', 'import'),
(7, 'nc', 'link'),
(7, 'nc', 'resolve'),
(7, 'nc', 'search'),
(7, 'nc', 'showimport'),
(7, 'nc', 'unlink'),
(7, 'nc', 'view'),
(7, 'output', '13'),
(7, 'output', 'assign'),
(7, 'output', 'batchassign'),
(7, 'output', 'batchcreate'),
(7, 'output', 'batchedit'),
(7, 'output', 'browse'),
(7, 'output', 'create'),
(7, 'output', 'delete'),
(7, 'output', 'edit'),
(7, 'output', 'export'),
(7, 'output', 'exporttemplate'),
(7, 'output', 'import'),
(7, 'output', 'link'),
(7, 'output', 'search'),
(7, 'output', 'showimport'),
(7, 'output', 'unlink'),
(7, 'output', 'view'),
(7, 'process', '11'),
(7, 'process', 'activitylist'),
(7, 'process', 'assign'),
(7, 'process', 'batchassign'),
(7, 'process', 'batchcreate'),
(7, 'process', 'batchedit'),
(7, 'process', 'browse'),
(7, 'process', 'create'),
(7, 'process', 'delete'),
(7, 'process', 'edit'),
(7, 'process', 'export'),
(7, 'process', 'exporttemplate'),
(7, 'process', 'import'),
(7, 'process', 'link'),
(7, 'process', 'search'),
(7, 'process', 'showimport'),
(7, 'process', 'unlink'),
(7, 'process', 'view'),
(7, 'product', 'all'),
(7, 'product', 'browse'),
(7, 'product', 'close'),
(7, 'product', 'create'),
(7, 'product', 'delete'),
(7, 'product', 'edit'),
(7, 'product', 'index'),
(7, 'product', 'view'),
(7, 'productplan', 'batchUnlinkBug'),
(7, 'productplan', 'batchUnlinkStory'),
(7, 'productplan', 'browse'),
(7, 'productplan', 'create'),
(7, 'productplan', 'delete'),
(7, 'productplan', 'edit'),
(7, 'productplan', 'linkBug'),
(7, 'productplan', 'linkStory'),
(7, 'productplan', 'unlinkBug'),
(7, 'productplan', 'unlinkStory'),
(7, 'productplan', 'view'),
(7, 'project', 'all'),
(7, 'project', 'browse'),
(7, 'project', 'bug'),
(7, 'project', 'build'),
(7, 'project', 'burn'),
(7, 'project', 'burnData'),
(7, 'project', 'calendar'),
(7, 'project', 'computeBurn'),
(7, 'project', 'effort'),
(7, 'project', 'gantt'),
(7, 'project', 'grouptask'),
(7, 'project', 'importBug'),
(7, 'project', 'importtask'),
(7, 'project', 'index'),
(7, 'project', 'kanban'),
(7, 'project', 'linkStory'),
(7, 'project', 'relation'),
(7, 'project', 'story'),
(7, 'project', 'task'),
(7, 'project', 'team'),
(7, 'project', 'testtask'),
(7, 'project', 'tree'),
(7, 'project', 'unlinkStory'),
(7, 'project', 'view'),
(7, 'pssp', 'browse'),
(7, 'pssp', 'update'),
(7, 'qa', 'index'),
(7, 'release', 'batchUnlinkBug'),
(7, 'release', 'batchUnlinkStory'),
(7, 'release', 'browse'),
(7, 'release', 'changeStatus'),
(7, 'release', 'create'),
(7, 'release', 'delete'),
(7, 'release', 'edit'),
(7, 'release', 'export'),
(7, 'release', 'linkBug'),
(7, 'release', 'linkStory'),
(7, 'release', 'unlinkBug'),
(7, 'release', 'unlinkStory'),
(7, 'release', 'view'),
(7, 'report', 'bugAssign'),
(7, 'report', 'bugCreate'),
(7, 'report', 'build'),
(7, 'report', 'export'),
(7, 'report', 'index'),
(7, 'report', 'productSummary'),
(7, 'report', 'projectDeviation'),
(7, 'report', 'testcase'),
(7, 'report', 'workload'),
(7, 'report', 'workSummary'),
(7, 'review', 'assess'),
(7, 'review', 'audit'),
(7, 'review', 'browse'),
(7, 'review', 'create'),
(7, 'review', 'edit'),
(7, 'review', 'recall'),
(7, 'review', 'report'),
(7, 'review', 'result'),
(7, 'review', 'submit'),
(7, 'review', 'toAudit'),
(7, 'review', 'view'),
(7, 'reviewcl', 'assign'),
(7, 'reviewcl', 'batchassign'),
(7, 'reviewcl', 'batchcreate'),
(7, 'reviewcl', 'batchedit'),
(7, 'reviewcl', 'browse'),
(7, 'reviewcl', 'create'),
(7, 'reviewcl', 'delete'),
(7, 'reviewcl', 'edit'),
(7, 'reviewcl', 'export'),
(7, 'reviewcl', 'exporttemplate'),
(7, 'reviewcl', 'import'),
(7, 'reviewcl', 'search'),
(7, 'reviewcl', 'view'),
(7, 'reviewissue', 'create'),
(7, 'reviewissue', 'edit'),
(7, 'reviewissue', 'issue'),
(7, 'reviewissue', 'resolved'),
(7, 'reviewissue', 'updateStatus'),
(7, 'reviewissue', 'view'),
(7, 'reviewsetting', 'reviewer'),
(7, 'reviewsetting', 'version'),
(7, 'risk', 'activate'),
(7, 'risk', 'assign'),
(7, 'risk', 'batchassign'),
(7, 'risk', 'batchcreate'),
(7, 'risk', 'batchedit'),
(7, 'risk', 'browse'),
(7, 'risk', 'cancel'),
(7, 'risk', 'check'),
(7, 'risk', 'close'),
(7, 'risk', 'create'),
(7, 'risk', 'delete'),
(7, 'risk', 'edit'),
(7, 'risk', 'export'),
(7, 'risk', 'hangup'),
(7, 'risk', 'search'),
(7, 'risk', 'view'),
(7, 'search', 'buildForm'),
(7, 'search', 'buildQuery'),
(7, 'search', 'deleteQuery'),
(7, 'search', 'index'),
(7, 'search', 'saveQuery'),
(7, 'search', 'select'),
(7, 'stage', '24'),
(7, 'stage', 'assign'),
(7, 'stage', 'batchassign'),
(7, 'stage', 'batchcreate'),
(7, 'stage', 'batchedit'),
(7, 'stage', 'browse'),
(7, 'stage', 'create'),
(7, 'stage', 'delete'),
(7, 'stage', 'edit'),
(7, 'stage', 'export'),
(7, 'stage', 'exporttemplate'),
(7, 'stage', 'import'),
(7, 'stage', 'search'),
(7, 'stage', 'view'),
(7, 'story', 'activate'),
(7, 'story', 'assignTo'),
(7, 'story', 'batchAssignTo'),
(7, 'story', 'batchChangeBranch'),
(7, 'story', 'batchChangeModule'),
(7, 'story', 'batchChangePlan'),
(7, 'story', 'batchChangeStage'),
(7, 'story', 'batchClose'),
(7, 'story', 'batchCreate'),
(7, 'story', 'batchEdit'),
(7, 'story', 'batchReview'),
(7, 'story', 'bugs'),
(7, 'story', 'cases'),
(7, 'story', 'change'),
(7, 'story', 'close'),
(7, 'story', 'create'),
(7, 'story', 'delete'),
(7, 'story', 'edit'),
(7, 'story', 'export'),
(7, 'story', 'linkStory'),
(7, 'story', 'processStoryChange'),
(7, 'story', 'report'),
(7, 'story', 'review'),
(7, 'story', 'tasks'),
(7, 'story', 'track'),
(7, 'story', 'view'),
(7, 'story', 'zeroCase'),
(7, 'subject', 'browse'),
(7, 'svn', 'apiSync'),
(7, 'svn', 'cat'),
(7, 'svn', 'diff'),
(7, 'task', 'activate'),
(7, 'task', 'assignTo'),
(7, 'task', 'batchAssignTo'),
(7, 'task', 'batchChangeModule'),
(7, 'task', 'batchClose'),
(7, 'task', 'batchCreate'),
(7, 'task', 'batchEdit'),
(7, 'task', 'cancel'),
(7, 'task', 'close'),
(7, 'task', 'confirmStoryChange'),
(7, 'task', 'create'),
(7, 'task', 'deleteEstimate'),
(7, 'task', 'edit'),
(7, 'task', 'editEstimate'),
(7, 'task', 'export'),
(7, 'task', 'finish'),
(7, 'task', 'pause'),
(7, 'task', 'recordEstimate'),
(7, 'task', 'report'),
(7, 'task', 'restart'),
(7, 'task', 'start'),
(7, 'task', 'view'),
(7, 'testcase', 'browse'),
(7, 'testcase', 'bugs'),
(7, 'testcase', 'createBug'),
(7, 'testcase', 'export'),
(7, 'testcase', 'groupCase'),
(7, 'testcase', 'importFromLib'),
(7, 'testcase', 'index'),
(7, 'testcase', 'view'),
(7, 'testsuite', 'browse'),
(7, 'testsuite', 'index'),
(7, 'testsuite', 'view'),
(7, 'testtask', 'browse'),
(7, 'testtask', 'cases'),
(7, 'testtask', 'create'),
(7, 'testtask', 'edit'),
(7, 'testtask', 'groupCase'),
(7, 'testtask', 'index'),
(7, 'testtask', 'results'),
(7, 'testtask', 'view'),
(7, 'todo', 'activate'),
(7, 'todo', 'assignTo'),
(7, 'todo', 'batchClose'),
(7, 'todo', 'batchCreate'),
(7, 'todo', 'batchEdit'),
(7, 'todo', 'batchFinish'),
(7, 'todo', 'calendar'),
(7, 'todo', 'close'),
(7, 'todo', 'create'),
(7, 'todo', 'delete'),
(7, 'todo', 'edit'),
(7, 'todo', 'export'),
(7, 'todo', 'finish'),
(7, 'todo', 'import2Today'),
(7, 'todo', 'view'),
(7, 'tree', 'browse'),
(7, 'tree', 'browseTask'),
(7, 'tree', 'delete'),
(7, 'tree', 'edit'),
(7, 'tree', 'fix'),
(7, 'tree', 'manageChild'),
(7, 'tree', 'updateOrder'),
(7, 'user', 'bug'),
(7, 'user', 'dynamic'),
(7, 'user', 'effortcalendar'),
(7, 'user', 'profile'),
(7, 'user', 'project'),
(7, 'user', 'story'),
(7, 'user', 'task'),
(7, 'user', 'testCase'),
(7, 'user', 'testTask'),
(7, 'user', 'todo'),
(7, 'user', 'todocalendar'),
(7, 'user', 'view'),
(7, 'weekly', 'index'),
(7, 'workestimation', 'index'),
(7, 'workloadbudget', '27'),
(7, 'workloadbudget', 'assign'),
(7, 'workloadbudget', 'batchassign'),
(7, 'workloadbudget', 'batchcreate'),
(7, 'workloadbudget', 'batchedit'),
(7, 'workloadbudget', 'browse'),
(7, 'workloadbudget', 'create'),
(7, 'workloadbudget', 'delete'),
(7, 'workloadbudget', 'edit'),
(7, 'workloadbudget', 'export'),
(7, 'workloadbudget', 'exporttemplate'),
(7, 'workloadbudget', 'import'),
(7, 'workloadbudget', 'link'),
(7, 'workloadbudget', 'search'),
(7, 'workloadbudget', 'showimport'),
(7, 'workloadbudget', 'unlink'),
(7, 'workloadbudget', 'view'),
(8, 'action', 'editComment'),
(8, 'action', 'hideAll'),
(8, 'action', 'hideOne'),
(8, 'action', 'trash'),
(8, 'action', 'undelete'),
(8, 'activity', '12'),
(8, 'activity', 'assign'),
(8, 'activity', 'batchassign'),
(8, 'activity', 'batchcreate'),
(8, 'activity', 'batchedit'),
(8, 'activity', 'browse'),
(8, 'activity', 'create'),
(8, 'activity', 'delete'),
(8, 'activity', 'edit'),
(8, 'activity', 'export'),
(8, 'activity', 'exporttemplate'),
(8, 'activity', 'import'),
(8, 'activity', 'link'),
(8, 'activity', 'outputlist'),
(8, 'activity', 'search'),
(8, 'activity', 'showimport'),
(8, 'activity', 'unlink'),
(8, 'activity', 'view'),
(8, 'admin', 'index'),
(8, 'audit', '8'),
(8, 'audit', 'assign'),
(8, 'audit', 'batchassign'),
(8, 'audit', 'batchcreate'),
(8, 'audit', 'batchedit'),
(8, 'audit', 'browse'),
(8, 'audit', 'create'),
(8, 'audit', 'delete'),
(8, 'audit', 'edit'),
(8, 'audit', 'export'),
(8, 'audit', 'exporttemplate'),
(8, 'audit', 'import'),
(8, 'audit', 'link'),
(8, 'audit', 'search'),
(8, 'audit', 'showimport'),
(8, 'audit', 'unlink'),
(8, 'audit', 'view'),
(8, 'auditcl', 'assign'),
(8, 'auditcl', 'batchassign'),
(8, 'auditcl', 'batchcreate'),
(8, 'auditcl', 'batchedit'),
(8, 'auditcl', 'browse'),
(8, 'auditcl', 'create'),
(8, 'auditcl', 'delete'),
(8, 'auditcl', 'edit'),
(8, 'auditcl', 'export'),
(8, 'auditcl', 'exporttemplate'),
(8, 'auditcl', 'import'),
(8, 'auditcl', 'link'),
(8, 'auditcl', 'search'),
(8, 'auditcl', 'showimport'),
(8, 'auditcl', 'unlink'),
(8, 'auditcl', 'view'),
(8, 'auditplan', '9'),
(8, 'auditplan', 'assign'),
(8, 'auditplan', 'batchassign'),
(8, 'auditplan', 'batchcreate'),
(8, 'auditplan', 'batchedit'),
(8, 'auditplan', 'browse'),
(8, 'auditplan', 'create'),
(8, 'auditplan', 'delete'),
(8, 'auditplan', 'edit'),
(8, 'auditplan', 'export'),
(8, 'auditplan', 'exporttemplate'),
(8, 'auditplan', 'import'),
(8, 'auditplan', 'link'),
(8, 'auditplan', 'nc'),
(8, 'auditplan', 'result'),
(8, 'auditplan', 'search'),
(8, 'auditplan', 'showimport'),
(8, 'auditplan', 'unlink'),
(8, 'auditplan', 'view'),
(8, 'auditresult', '10'),
(8, 'auditresult', 'assign'),
(8, 'auditresult', 'batchassign'),
(8, 'auditresult', 'batchcreate'),
(8, 'auditresult', 'batchedit'),
(8, 'auditresult', 'browse'),
(8, 'auditresult', 'create'),
(8, 'auditresult', 'delete'),
(8, 'auditresult', 'edit'),
(8, 'auditresult', 'export'),
(8, 'auditresult', 'exporttemplate'),
(8, 'auditresult', 'import'),
(8, 'auditresult', 'link'),
(8, 'auditresult', 'search'),
(8, 'auditresult', 'showimport'),
(8, 'auditresult', 'unlink'),
(8, 'auditresult', 'view'),
(8, 'baseline', 'articleview'),
(8, 'baseline', 'catalog'),
(8, 'baseline', 'createTemplate'),
(8, 'baseline', 'editBook'),
(8, 'baseline', 'editTemplate'),
(8, 'baseline', 'manageBook'),
(8, 'baseline', 'template'),
(8, 'baseline', 'version'),
(8, 'baseline', 'view'),
(8, 'budget', 'batchCreate'),
(8, 'budget', 'browse'),
(8, 'budget', 'create'),
(8, 'budget', 'edit'),
(8, 'budget', 'summary'),
(8, 'budget', 'view'),
(8, 'bug', 'activate'),
(8, 'bug', 'assignTo'),
(8, 'bug', 'batchActivate'),
(8, 'bug', 'batchAssignTo'),
(8, 'bug', 'batchChangeModule'),
(8, 'bug', 'batchClose'),
(8, 'bug', 'batchConfirm'),
(8, 'bug', 'batchCreate'),
(8, 'bug', 'batchEdit'),
(8, 'bug', 'batchResolve'),
(8, 'bug', 'browse'),
(8, 'bug', 'close'),
(8, 'bug', 'confirmBug'),
(8, 'bug', 'confirmStoryChange'),
(8, 'bug', 'create'),
(8, 'bug', 'delete'),
(8, 'bug', 'edit'),
(8, 'bug', 'export'),
(8, 'bug', 'index'),
(8, 'bug', 'linkBugs'),
(8, 'bug', 'report'),
(8, 'bug', 'resolve'),
(8, 'bug', 'view'),
(8, 'build', 'create'),
(8, 'build', 'delete'),
(8, 'build', 'edit'),
(8, 'build', 'view'),
(8, 'classify', 'browse'),
(8, 'cm', 'browse'),
(8, 'cm', 'create'),
(8, 'cm', 'edit'),
(8, 'cm', 'report'),
(8, 'cm', 'view'),
(8, 'cmcl', 'assign'),
(8, 'cmcl', 'batchassign'),
(8, 'cmcl', 'batchcreate'),
(8, 'cmcl', 'batchedit'),
(8, 'cmcl', 'browse'),
(8, 'cmcl', 'create'),
(8, 'cmcl', 'delete'),
(8, 'cmcl', 'edit'),
(8, 'cmcl', 'export'),
(8, 'cmcl', 'exporttemplate'),
(8, 'cmcl', 'import'),
(8, 'cmcl', 'link'),
(8, 'cmcl', 'search'),
(8, 'cmcl', 'showimport'),
(8, 'cmcl', 'unlink'),
(8, 'cmcl', 'view'),
(8, 'company', 'browse'),
(8, 'company', 'dynamic'),
(8, 'company', 'effort'),
(8, 'company', 'index'),
(8, 'company', 'view'),
(8, 'custom', 'estimate'),
(8, 'datatable', 'setGlobal'),
(8, 'design', '23'),
(8, 'design', 'assign'),
(8, 'design', 'batchassign'),
(8, 'design', 'batchcreate'),
(8, 'design', 'batchedit'),
(8, 'design', 'browse'),
(8, 'design', 'commit'),
(8, 'design', 'create'),
(8, 'design', 'delete'),
(8, 'design', 'edit'),
(8, 'design', 'export'),
(8, 'design', 'search'),
(8, 'design', 'view'),
(8, 'doc', 'allLibs'),
(8, 'doc', 'browse'),
(8, 'doc', 'create'),
(8, 'doc', 'createLib'),
(8, 'doc', 'delete'),
(8, 'doc', 'deleteFile'),
(8, 'doc', 'deleteLib'),
(8, 'doc', 'edit'),
(8, 'doc', 'editLib'),
(8, 'doc', 'index'),
(8, 'doc', 'objectLibs'),
(8, 'doc', 'showFiles'),
(8, 'doc', 'view'),
(8, 'durationestimation', 'create'),
(8, 'durationestimation', 'index'),
(8, 'effort', 'batchCreate'),
(8, 'effort', 'calendar'),
(8, 'effort', 'createForObject'),
(8, 'effort', 'delete'),
(8, 'effort', 'edit'),
(8, 'effort', 'export'),
(8, 'effort', 'view'),
(8, 'extension', 'browse'),
(8, 'extension', 'obtain'),
(8, 'extension', 'structure'),
(8, 'faq', 'browse'),
(8, 'feedback', 'admin'),
(8, 'feedback', 'adminview'),
(8, 'feedback', 'close'),
(8, 'file', 'delete'),
(8, 'file', 'download'),
(8, 'file', 'edit'),
(8, 'file', 'uploadImages'),
(8, 'git', 'apiSync'),
(8, 'git', 'cat'),
(8, 'git', 'diff'),
(8, 'group', 'browse'),
(8, 'host', 'browse'),
(8, 'host', 'create'),
(8, 'host', 'delete'),
(8, 'host', 'edit'),
(8, 'host', 'treemap'),
(8, 'host', 'view'),
(8, 'im', 'notifyMSG'),
(8, 'index', 'index'),
(8, 'issue', '17'),
(8, 'issue', '18'),
(8, 'issue', '19'),
(8, 'issue', '20'),
(8, 'issue', '21'),
(8, 'issue', '22'),
(8, 'issue', 'activate'),
(8, 'issue', 'assign'),
(8, 'issue', 'batchassign'),
(8, 'issue', 'batchcreate'),
(8, 'issue', 'batchedit'),
(8, 'issue', 'browse'),
(8, 'issue', 'cancel'),
(8, 'issue', 'close'),
(8, 'issue', 'create'),
(8, 'issue', 'delete'),
(8, 'issue', 'edit'),
(8, 'issue', 'export'),
(8, 'issue', 'resolve'),
(8, 'issue', 'search'),
(8, 'issue', 'view'),
(8, 'milestone', 'index'),
(8, 'milestone', 'saveOtherProblem'),
(8, 'misc', 'ping'),
(8, 'my', 'bug'),
(8, 'my', 'calendar'),
(8, 'my', 'changePassword'),
(8, 'my', 'deleteContacts'),
(8, 'my', 'dynamic'),
(8, 'my', 'editProfile'),
(8, 'my', 'effort'),
(8, 'my', 'index'),
(8, 'my', 'manageContacts'),
(8, 'my', 'nc'),
(8, 'my', 'profile'),
(8, 'my', 'program'),
(8, 'my', 'project'),
(8, 'my', 'requirement'),
(8, 'my', 'story'),
(8, 'my', 'task'),
(8, 'my', 'testCase'),
(8, 'my', 'testTask'),
(8, 'my', 'todo'),
(8, 'my', 'unbind'),
(8, 'nc', '16'),
(8, 'nc', 'activate'),
(8, 'nc', 'assign'),
(8, 'nc', 'batchassign'),
(8, 'nc', 'batchcreate'),
(8, 'nc', 'batchedit'),
(8, 'nc', 'browse'),
(8, 'nc', 'close'),
(8, 'nc', 'create'),
(8, 'nc', 'delete'),
(8, 'nc', 'edit'),
(8, 'nc', 'export'),
(8, 'nc', 'exporttemplate'),
(8, 'nc', 'import'),
(8, 'nc', 'link'),
(8, 'nc', 'resolve'),
(8, 'nc', 'search'),
(8, 'nc', 'showimport'),
(8, 'nc', 'unlink'),
(8, 'nc', 'view'),
(8, 'output', '13'),
(8, 'output', 'assign'),
(8, 'output', 'batchassign'),
(8, 'output', 'batchcreate'),
(8, 'output', 'batchedit'),
(8, 'output', 'browse'),
(8, 'output', 'create'),
(8, 'output', 'delete'),
(8, 'output', 'edit'),
(8, 'output', 'export'),
(8, 'output', 'exporttemplate'),
(8, 'output', 'import'),
(8, 'output', 'link'),
(8, 'output', 'search'),
(8, 'output', 'showimport'),
(8, 'output', 'unlink'),
(8, 'output', 'view'),
(8, 'process', '11'),
(8, 'process', 'activitylist'),
(8, 'process', 'assign'),
(8, 'process', 'batchassign'),
(8, 'process', 'batchcreate'),
(8, 'process', 'batchedit'),
(8, 'process', 'browse'),
(8, 'process', 'create'),
(8, 'process', 'delete'),
(8, 'process', 'edit'),
(8, 'process', 'export'),
(8, 'process', 'exporttemplate'),
(8, 'process', 'import'),
(8, 'process', 'link'),
(8, 'process', 'search'),
(8, 'process', 'showimport'),
(8, 'process', 'unlink'),
(8, 'process', 'view'),
(8, 'product', 'all'),
(8, 'product', 'browse'),
(8, 'product', 'index'),
(8, 'product', 'view'),
(8, 'productplan', 'browse'),
(8, 'productplan', 'view'),
(8, 'project', 'all'),
(8, 'project', 'browse'),
(8, 'project', 'bug'),
(8, 'project', 'build'),
(8, 'project', 'burn'),
(8, 'project', 'burnData'),
(8, 'project', 'calendar'),
(8, 'project', 'computeBurn'),
(8, 'project', 'effort'),
(8, 'project', 'gantt'),
(8, 'project', 'grouptask'),
(8, 'project', 'importBug'),
(8, 'project', 'importtask'),
(8, 'project', 'index'),
(8, 'project', 'kanban'),
(8, 'project', 'relation'),
(8, 'project', 'story'),
(8, 'project', 'task'),
(8, 'project', 'team'),
(8, 'project', 'testtask'),
(8, 'project', 'tree'),
(8, 'project', 'view'),
(8, 'pssp', 'browse'),
(8, 'pssp', 'update'),
(8, 'qa', 'index'),
(8, 'release', 'browse'),
(8, 'release', 'export'),
(8, 'release', 'view'),
(8, 'report', 'bugAssign'),
(8, 'report', 'bugCreate'),
(8, 'report', 'build'),
(8, 'report', 'export'),
(8, 'report', 'index'),
(8, 'report', 'productSummary'),
(8, 'report', 'projectDeviation'),
(8, 'report', 'testcase'),
(8, 'report', 'workload'),
(8, 'report', 'workSummary'),
(8, 'review', 'assess'),
(8, 'review', 'audit'),
(8, 'review', 'browse'),
(8, 'review', 'create'),
(8, 'review', 'edit'),
(8, 'review', 'recall'),
(8, 'review', 'report'),
(8, 'review', 'result'),
(8, 'review', 'submit'),
(8, 'review', 'toAudit'),
(8, 'review', 'view'),
(8, 'reviewcl', 'assign'),
(8, 'reviewcl', 'batchassign'),
(8, 'reviewcl', 'batchcreate'),
(8, 'reviewcl', 'batchedit'),
(8, 'reviewcl', 'browse'),
(8, 'reviewcl', 'create'),
(8, 'reviewcl', 'delete'),
(8, 'reviewcl', 'edit'),
(8, 'reviewcl', 'export'),
(8, 'reviewcl', 'exporttemplate'),
(8, 'reviewcl', 'import'),
(8, 'reviewcl', 'search'),
(8, 'reviewcl', 'view'),
(8, 'reviewissue', 'create'),
(8, 'reviewissue', 'edit'),
(8, 'reviewissue', 'issue'),
(8, 'reviewissue', 'resolved'),
(8, 'reviewissue', 'updateStatus'),
(8, 'reviewissue', 'view'),
(8, 'reviewsetting', 'reviewer'),
(8, 'reviewsetting', 'version'),
(8, 'risk', 'activate'),
(8, 'risk', 'assign'),
(8, 'risk', 'batchassign'),
(8, 'risk', 'batchcreate'),
(8, 'risk', 'batchedit'),
(8, 'risk', 'browse'),
(8, 'risk', 'cancel'),
(8, 'risk', 'check'),
(8, 'risk', 'close'),
(8, 'risk', 'create'),
(8, 'risk', 'delete'),
(8, 'risk', 'edit'),
(8, 'risk', 'export'),
(8, 'risk', 'hangup'),
(8, 'risk', 'search'),
(8, 'risk', 'view'),
(8, 'search', 'buildForm'),
(8, 'search', 'buildQuery'),
(8, 'search', 'deleteQuery'),
(8, 'search', 'index'),
(8, 'search', 'saveQuery'),
(8, 'search', 'select'),
(8, 'stage', '24'),
(8, 'stage', 'assign'),
(8, 'stage', 'batchassign'),
(8, 'stage', 'batchcreate'),
(8, 'stage', 'batchedit'),
(8, 'stage', 'browse'),
(8, 'stage', 'create'),
(8, 'stage', 'delete'),
(8, 'stage', 'edit'),
(8, 'stage', 'export'),
(8, 'stage', 'exporttemplate'),
(8, 'stage', 'import'),
(8, 'stage', 'search'),
(8, 'stage', 'view'),
(8, 'story', 'bugs'),
(8, 'story', 'cases'),
(8, 'story', 'export'),
(8, 'story', 'import'),
(8, 'story', 'processStoryChange'),
(8, 'story', 'report'),
(8, 'story', 'tasks'),
(8, 'story', 'track'),
(8, 'story', 'view'),
(8, 'story', 'zeroCase'),
(8, 'subject', 'browse'),
(8, 'svn', 'apiSync'),
(8, 'svn', 'cat'),
(8, 'svn', 'diff'),
(8, 'task', 'activate'),
(8, 'task', 'assignTo'),
(8, 'task', 'batchAssignTo'),
(8, 'task', 'batchChangeModule'),
(8, 'task', 'batchClose'),
(8, 'task', 'batchCreate'),
(8, 'task', 'batchEdit'),
(8, 'task', 'cancel'),
(8, 'task', 'close'),
(8, 'task', 'confirmStoryChange'),
(8, 'task', 'create'),
(8, 'task', 'delete'),
(8, 'task', 'deleteEstimate'),
(8, 'task', 'edit'),
(8, 'task', 'editEstimate'),
(8, 'task', 'export'),
(8, 'task', 'finish'),
(8, 'task', 'pause'),
(8, 'task', 'recordEstimate'),
(8, 'task', 'report'),
(8, 'task', 'restart'),
(8, 'task', 'start'),
(8, 'task', 'view'),
(8, 'testcase', 'batchCaseTypeChange'),
(8, 'testcase', 'batchChangeModule'),
(8, 'testcase', 'batchConfirmStoryChange'),
(8, 'testcase', 'batchCreate'),
(8, 'testcase', 'batchDelete'),
(8, 'testcase', 'batchEdit'),
(8, 'testcase', 'batchReview'),
(8, 'testcase', 'browse'),
(8, 'testcase', 'bugs'),
(8, 'testcase', 'confirmChange'),
(8, 'testcase', 'confirmStoryChange'),
(8, 'testcase', 'create'),
(8, 'testcase', 'createBug'),
(8, 'testcase', 'delete'),
(8, 'testcase', 'edit'),
(8, 'testcase', 'export'),
(8, 'testcase', 'exportTemplet'),
(8, 'testcase', 'groupCase'),
(8, 'testcase', 'import'),
(8, 'testcase', 'importFromLib'),
(8, 'testcase', 'index'),
(8, 'testcase', 'linkCases'),
(8, 'testcase', 'review'),
(8, 'testcase', 'showImport'),
(8, 'testcase', 'view'),
(8, 'testreport', 'browse'),
(8, 'testreport', 'create'),
(8, 'testreport', 'delete'),
(8, 'testreport', 'edit'),
(8, 'testreport', 'view'),
(8, 'testsuite', 'browse'),
(8, 'testsuite', 'create'),
(8, 'testsuite', 'delete'),
(8, 'testsuite', 'edit'),
(8, 'testsuite', 'index'),
(8, 'testsuite', 'linkCase'),
(8, 'testsuite', 'unlinkCase'),
(8, 'testsuite', 'view'),
(8, 'testtask', 'activate'),
(8, 'testtask', 'batchAssign'),
(8, 'testtask', 'batchRun'),
(8, 'testtask', 'block'),
(8, 'testtask', 'browse'),
(8, 'testtask', 'cases'),
(8, 'testtask', 'close'),
(8, 'testtask', 'create'),
(8, 'testtask', 'delete'),
(8, 'testtask', 'edit'),
(8, 'testtask', 'groupCase'),
(8, 'testtask', 'index'),
(8, 'testtask', 'linkcase'),
(8, 'testtask', 'report'),
(8, 'testtask', 'results'),
(8, 'testtask', 'runcase'),
(8, 'testtask', 'start'),
(8, 'testtask', 'unlinkcase'),
(8, 'testtask', 'view'),
(8, 'todo', 'activate'),
(8, 'todo', 'assignTo'),
(8, 'todo', 'batchClose'),
(8, 'todo', 'batchCreate'),
(8, 'todo', 'batchEdit'),
(8, 'todo', 'batchFinish'),
(8, 'todo', 'calendar'),
(8, 'todo', 'close'),
(8, 'todo', 'create'),
(8, 'todo', 'delete'),
(8, 'todo', 'edit'),
(8, 'todo', 'export'),
(8, 'todo', 'finish'),
(8, 'todo', 'import2Today'),
(8, 'todo', 'view'),
(8, 'tree', 'browse'),
(8, 'tree', 'browsehost'),
(8, 'tree', 'browseTask'),
(8, 'tree', 'delete'),
(8, 'tree', 'edit'),
(8, 'tree', 'fix'),
(8, 'tree', 'manageChild'),
(8, 'tree', 'updateOrder'),
(8, 'user', 'bug'),
(8, 'user', 'dynamic'),
(8, 'user', 'effortcalendar'),
(8, 'user', 'profile'),
(8, 'user', 'project'),
(8, 'user', 'story'),
(8, 'user', 'task'),
(8, 'user', 'testCase'),
(8, 'user', 'testTask'),
(8, 'user', 'todo'),
(8, 'user', 'todocalendar'),
(8, 'user', 'view'),
(8, 'weekly', 'index'),
(8, 'workestimation', 'index'),
(8, 'workloadbudget', '27'),
(8, 'workloadbudget', 'assign'),
(8, 'workloadbudget', 'batchassign'),
(8, 'workloadbudget', 'batchcreate'),
(8, 'workloadbudget', 'batchedit'),
(8, 'workloadbudget', 'browse'),
(8, 'workloadbudget', 'create'),
(8, 'workloadbudget', 'delete'),
(8, 'workloadbudget', 'edit'),
(8, 'workloadbudget', 'export'),
(8, 'workloadbudget', 'exporttemplate'),
(8, 'workloadbudget', 'import'),
(8, 'workloadbudget', 'link'),
(8, 'workloadbudget', 'search'),
(8, 'workloadbudget', 'showimport'),
(8, 'workloadbudget', 'unlink'),
(8, 'workloadbudget', 'view'),
('9', 'stakeholder', 'browse'),
('9', 'stakeholder', 'communicate'),
('9', 'stakeholder', 'create'),
('9', 'stakeholder', 'delete'),
('9', 'stakeholder', 'createExpect'),
('9', 'stakeholder', 'deleteExpect'),
('9', 'stakeholder', 'edit'),
('9', 'stakeholder', 'editExpect'),
('9', 'stakeholder', 'expect'),
('9', 'stakeholder', 'expectation'),
('9', 'stakeholder', 'issue'),
('9', 'stakeholder', 'plan'),
('9', 'stakeholder', 'userIssue'),
('9', 'stakeholder', 'view'),
('9', 'stakeholder', 'viewExpect'),
('9', 'stakeholder', 'viewIssue'),
(9, 'action', 'editComment'),
(9, 'action', 'hideAll'),
(9, 'action', 'hideOne'),
(9, 'action', 'trash'),
(9, 'action', 'undelete'),
(9, 'activity', '12'),
(9, 'activity', 'assign'),
(9, 'activity', 'batchassign'),
(9, 'activity', 'batchcreate'),
(9, 'activity', 'batchedit'),
(9, 'activity', 'browse'),
(9, 'activity', 'create'),
(9, 'activity', 'delete'),
(9, 'activity', 'edit'),
(9, 'activity', 'export'),
(9, 'activity', 'exporttemplate'),
(9, 'activity', 'import'),
(9, 'activity', 'link'),
(9, 'activity', 'outputlist'),
(9, 'activity', 'search'),
(9, 'activity', 'showimport'),
(9, 'activity', 'unlink'),
(9, 'activity', 'view'),
(9, 'admin', 'index'),
(9, 'audit', '8'),
(9, 'audit', 'assign'),
(9, 'audit', 'batchassign'),
(9, 'audit', 'batchcreate'),
(9, 'audit', 'batchedit'),
(9, 'audit', 'browse'),
(9, 'audit', 'create'),
(9, 'audit', 'delete'),
(9, 'audit', 'edit'),
(9, 'audit', 'export'),
(9, 'audit', 'exporttemplate'),
(9, 'audit', 'import'),
(9, 'audit', 'link'),
(9, 'audit', 'search'),
(9, 'audit', 'showimport'),
(9, 'audit', 'unlink'),
(9, 'audit', 'view'),
(9, 'auditcl', 'assign'),
(9, 'auditcl', 'batchassign'),
(9, 'auditcl', 'batchcreate'),
(9, 'auditcl', 'batchedit'),
(9, 'auditcl', 'browse'),
(9, 'auditcl', 'create'),
(9, 'auditcl', 'delete'),
(9, 'auditcl', 'edit'),
(9, 'auditcl', 'export'),
(9, 'auditcl', 'exporttemplate'),
(9, 'auditcl', 'import'),
(9, 'auditcl', 'link'),
(9, 'auditcl', 'search'),
(9, 'auditcl', 'showimport'),
(9, 'auditcl', 'unlink'),
(9, 'auditcl', 'view'),
(9, 'auditplan', '9'),
(9, 'auditplan', 'assign'),
(9, 'auditplan', 'batchassign'),
(9, 'auditplan', 'batchcreate'),
(9, 'auditplan', 'batchedit'),
(9, 'auditplan', 'browse'),
(9, 'auditplan', 'create'),
(9, 'auditplan', 'delete'),
(9, 'auditplan', 'edit'),
(9, 'auditplan', 'export'),
(9, 'auditplan', 'exporttemplate'),
(9, 'auditplan', 'import'),
(9, 'auditplan', 'link'),
(9, 'auditplan', 'nc'),
(9, 'auditplan', 'result'),
(9, 'auditplan', 'search'),
(9, 'auditplan', 'showimport'),
(9, 'auditplan', 'unlink'),
(9, 'auditplan', 'view'),
(9, 'auditresult', '10'),
(9, 'auditresult', 'assign'),
(9, 'auditresult', 'batchassign'),
(9, 'auditresult', 'batchcreate'),
(9, 'auditresult', 'batchedit'),
(9, 'auditresult', 'browse'),
(9, 'auditresult', 'create'),
(9, 'auditresult', 'delete'),
(9, 'auditresult', 'edit'),
(9, 'auditresult', 'export'),
(9, 'auditresult', 'exporttemplate'),
(9, 'auditresult', 'import'),
(9, 'auditresult', 'link'),
(9, 'auditresult', 'search'),
(9, 'auditresult', 'showimport'),
(9, 'auditresult', 'unlink'),
(9, 'auditresult', 'view'),
(9, 'baseline', 'articleview'),
(9, 'baseline', 'catalog'),
(9, 'baseline', 'createTemplate'),
(9, 'baseline', 'delete'),
(9, 'baseline', 'editBook'),
(9, 'baseline', 'editTemplate'),
(9, 'baseline', 'manageBook'),
(9, 'baseline', 'template'),
(9, 'baseline', 'version'),
(9, 'baseline', 'view'),
(9, 'budget', 'batchCreate'),
(9, 'budget', 'browse'),
(9, 'budget', 'create'),
(9, 'budget', 'delete'),
(9, 'budget', 'edit'),
(9, 'budget', 'summary'),
(9, 'budget', 'view'),
(9, 'bug', 'activate'),
(9, 'bug', 'assignTo'),
(9, 'bug', 'batchActivate'),
(9, 'bug', 'batchAssignTo'),
(9, 'bug', 'batchChangeModule'),
(9, 'bug', 'batchClose'),
(9, 'bug', 'batchConfirm'),
(9, 'bug', 'batchCreate'),
(9, 'bug', 'batchEdit'),
(9, 'bug', 'batchResolve'),
(9, 'bug', 'browse'),
(9, 'bug', 'close'),
(9, 'bug', 'confirmBug'),
(9, 'bug', 'confirmStoryChange'),
(9, 'bug', 'create'),
(9, 'bug', 'edit'),
(9, 'bug', 'export'),
(9, 'bug', 'index'),
(9, 'bug', 'linkBugs'),
(9, 'bug', 'report'),
(9, 'bug', 'resolve'),
(9, 'bug', 'view'),
(9, 'build', 'create'),
(9, 'build', 'delete'),
(9, 'build', 'edit'),
(9, 'build', 'view'),
(9, 'classify', 'browse'),
(9, 'cm', 'browse'),
(9, 'cm', 'create'),
(9, 'cm', 'delete'),
(9, 'cm', 'edit'),
(9, 'cm', 'report'),
(9, 'cm', 'view'),
(9, 'cmcl', 'assign'),
(9, 'cmcl', 'batchassign'),
(9, 'cmcl', 'batchcreate'),
(9, 'cmcl', 'batchedit'),
(9, 'cmcl', 'browse'),
(9, 'cmcl', 'create'),
(9, 'cmcl', 'delete'),
(9, 'cmcl', 'edit'),
(9, 'cmcl', 'export'),
(9, 'cmcl', 'exporttemplate'),
(9, 'cmcl', 'import'),
(9, 'cmcl', 'link'),
(9, 'cmcl', 'search'),
(9, 'cmcl', 'showimport'),
(9, 'cmcl', 'unlink'),
(9, 'cmcl', 'view'),
(9, 'company', 'browse'),
(9, 'company', 'dynamic'),
(9, 'company', 'edit'),
(9, 'company', 'effort'),
(9, 'company', 'index'),
(9, 'company', 'view'),
(9, 'custom', 'estimate'),
(9, 'dept', 'browse'),
(9, 'dept', 'delete'),
(9, 'dept', 'manageChild'),
(9, 'dept', 'updateOrder'),
(9, 'design', '23'),
(9, 'design', 'assign'),
(9, 'design', 'batchassign'),
(9, 'design', 'batchcreate'),
(9, 'design', 'batchedit'),
(9, 'design', 'browse'),
(9, 'design', 'commit'),
(9, 'design', 'create'),
(9, 'design', 'delete'),
(9, 'design', 'edit'),
(9, 'design', 'export'),
(9, 'design', 'search'),
(9, 'design', 'view'),
(9, 'doc', 'allLibs'),
(9, 'doc', 'browse'),
(9, 'doc', 'create'),
(9, 'doc', 'createLib'),
(9, 'doc', 'delete'),
(9, 'doc', 'deleteFile'),
(9, 'doc', 'deleteLib'),
(9, 'doc', 'edit'),
(9, 'doc', 'editLib'),
(9, 'doc', 'index'),
(9, 'doc', 'objectLibs'),
(9, 'doc', 'showFiles'),
(9, 'doc', 'view'),
(9, 'durationestimation', 'create'),
(9, 'durationestimation', 'index'),
(9, 'effort', 'batchCreate'),
(9, 'effort', 'calendar'),
(9, 'effort', 'createForObject'),
(9, 'effort', 'delete'),
(9, 'effort', 'edit'),
(9, 'effort', 'export'),
(9, 'effort', 'view'),
(9, 'extension', 'browse'),
(9, 'extension', 'obtain'),
(9, 'extension', 'structure'),
(9, 'file', 'delete'),
(9, 'file', 'download'),
(9, 'file', 'edit'),
(9, 'file', 'uploadImages'),
(9, 'git', 'apiSync'),
(9, 'git', 'cat'),
(9, 'git', 'diff'),
(9, 'group', 'browse'),
(9, 'holiday', 'browse'),
(9, 'holiday', 'create'),
(9, 'holiday', 'delete'),
(9, 'holiday', 'edit'),
(9, 'im', 'notifyMSG'),
(9, 'index', 'index'),
(9, 'issue', '17'),
(9, 'issue', '18'),
(9, 'issue', '19'),
(9, 'issue', '20'),
(9, 'issue', '21'),
(9, 'issue', '22'),
(9, 'issue', 'activate'),
(9, 'issue', 'assign'),
(9, 'issue', 'batchassign'),
(9, 'issue', 'batchcreate'),
(9, 'issue', 'batchedit'),
(9, 'issue', 'browse'),
(9, 'issue', 'cancel'),
(9, 'issue', 'close'),
(9, 'issue', 'create'),
(9, 'issue', 'delete'),
(9, 'issue', 'edit'),
(9, 'issue', 'export'),
(9, 'issue', 'resolve'),
(9, 'issue', 'search'),
(9, 'issue', 'view'),
(9, 'milestone', 'index'),
(9, 'milestone', 'saveOtherProblem'),
(9, 'misc', 'ping'),
(9, 'my', 'bug'),
(9, 'my', 'calendar'),
(9, 'my', 'changePassword'),
(9, 'my', 'deleteContacts'),
(9, 'my', 'dynamic'),
(9, 'my', 'editProfile'),
(9, 'my', 'effort'),
(9, 'my', 'index'),
(9, 'my', 'manageContacts'),
(9, 'my', 'nc'),
(9, 'my', 'profile'),
(9, 'my', 'program'),
(9, 'my', 'project'),
(9, 'my', 'requirement'),
(9, 'my', 'story'),
(9, 'my', 'task'),
(9, 'my', 'testCase'),
(9, 'my', 'testTask'),
(9, 'my', 'todo'),
(9, 'my', 'unbind'),
(9, 'nc', '16'),
(9, 'nc', 'activate'),
(9, 'nc', 'assign'),
(9, 'nc', 'batchassign'),
(9, 'nc', 'batchcreate'),
(9, 'nc', 'batchedit'),
(9, 'nc', 'browse'),
(9, 'nc', 'close'),
(9, 'nc', 'create'),
(9, 'nc', 'delete'),
(9, 'nc', 'edit'),
(9, 'nc', 'export'),
(9, 'nc', 'exporttemplate'),
(9, 'nc', 'import'),
(9, 'nc', 'link'),
(9, 'nc', 'resolve'),
(9, 'nc', 'search'),
(9, 'nc', 'showimport'),
(9, 'nc', 'unlink'),
(9, 'nc', 'view'),
(9, 'output', '13'),
(9, 'output', 'assign'),
(9, 'output', 'batchassign'),
(9, 'output', 'batchcreate'),
(9, 'output', 'batchedit'),
(9, 'output', 'browse'),
(9, 'output', 'create'),
(9, 'output', 'delete'),
(9, 'output', 'edit'),
(9, 'output', 'export'),
(9, 'output', 'exporttemplate'),
(9, 'output', 'import'),
(9, 'output', 'link'),
(9, 'output', 'search'),
(9, 'output', 'showimport'),
(9, 'output', 'unlink'),
(9, 'output', 'view'),
(9, 'process', '11'),
(9, 'process', 'activitylist'),
(9, 'process', 'assign'),
(9, 'process', 'batchassign'),
(9, 'process', 'batchcreate'),
(9, 'process', 'batchedit'),
(9, 'process', 'browse'),
(9, 'process', 'create'),
(9, 'process', 'delete'),
(9, 'process', 'edit'),
(9, 'process', 'export'),
(9, 'process', 'exporttemplate'),
(9, 'process', 'import'),
(9, 'process', 'link'),
(9, 'process', 'search'),
(9, 'process', 'showimport'),
(9, 'process', 'unlink'),
(9, 'process', 'view'),
(9, 'product', 'all'),
(9, 'product', 'browse'),
(9, 'product', 'index'),
(9, 'product', 'view'),
(9, 'productplan', 'browse'),
(9, 'productplan', 'view'),
(9, 'project', 'all'),
(9, 'project', 'browse'),
(9, 'project', 'bug'),
(9, 'project', 'build'),
(9, 'project', 'burn'),
(9, 'project', 'burnData'),
(9, 'project', 'calendar'),
(9, 'project', 'computeBurn'),
(9, 'project', 'effort'),
(9, 'project', 'gantt'),
(9, 'project', 'grouptask'),
(9, 'project', 'importBug'),
(9, 'project', 'importtask'),
(9, 'project', 'index'),
(9, 'project', 'kanban'),
(9, 'project', 'manageMembers'),
(9, 'project', 'relation'),
(9, 'project', 'story'),
(9, 'project', 'task'),
(9, 'project', 'team'),
(9, 'project', 'testtask'),
(9, 'project', 'tree'),
(9, 'project', 'view'),
(9, 'pssp', 'browse'),
(9, 'pssp', 'update'),
(9, 'qa', 'index'),
(9, 'release', 'browse'),
(9, 'release', 'export'),
(9, 'release', 'view'),
(9, 'repo', 'browse'),
(9, 'repo', 'diff'),
(9, 'repo', 'download'),
(9, 'repo', 'log'),
(9, 'repo', 'revision'),
(9, 'repo', 'view'),
(9, 'report', 'bugAssign'),
(9, 'report', 'bugCreate'),
(9, 'report', 'build'),
(9, 'report', 'export'),
(9, 'report', 'index'),
(9, 'report', 'productSummary'),
(9, 'report', 'projectDeviation'),
(9, 'report', 'testcase'),
(9, 'report', 'workload'),
(9, 'report', 'workSummary'),
(9, 'review', 'assess'),
(9, 'review', 'audit'),
(9, 'review', 'browse'),
(9, 'review', 'create'),
(9, 'review', 'edit'),
(9, 'review', 'recall'),
(9, 'review', 'report'),
(9, 'review', 'result'),
(9, 'review', 'submit'),
(9, 'review', 'toAudit'),
(9, 'review', 'view'),
(9, 'reviewcl', 'assign'),
(9, 'reviewcl', 'batchassign'),
(9, 'reviewcl', 'batchcreate'),
(9, 'reviewcl', 'batchedit'),
(9, 'reviewcl', 'browse'),
(9, 'reviewcl', 'create'),
(9, 'reviewcl', 'delete'),
(9, 'reviewcl', 'edit'),
(9, 'reviewcl', 'export'),
(9, 'reviewcl', 'exporttemplate'),
(9, 'reviewcl', 'import'),
(9, 'reviewcl', 'search'),
(9, 'reviewcl', 'view'),
(9, 'reviewissue', 'create'),
(9, 'reviewissue', 'edit'),
(9, 'reviewissue', 'issue'),
(9, 'reviewissue', 'resolved'),
(9, 'reviewissue', 'updateStatus'),
(9, 'reviewissue', 'view'),
(9, 'reviewsetting', 'reviewer'),
(9, 'reviewsetting', 'version'),
(9, 'risk', 'activate'),
(9, 'risk', 'assign'),
(9, 'risk', 'batchassign'),
(9, 'risk', 'batchcreate'),
(9, 'risk', 'batchedit'),
(9, 'risk', 'browse'),
(9, 'risk', 'cancel'),
(9, 'risk', 'check'),
(9, 'risk', 'close'),
(9, 'risk', 'create'),
(9, 'risk', 'delete'),
(9, 'risk', 'edit'),
(9, 'risk', 'export'),
(9, 'risk', 'hangup'),
(9, 'risk', 'search'),
(9, 'risk', 'view'),
(9, 'search', 'buildForm'),
(9, 'search', 'buildQuery'),
(9, 'search', 'deleteQuery'),
(9, 'search', 'index'),
(9, 'search', 'saveQuery'),
(9, 'search', 'select'),
(9, 'stage', '24'),
(9, 'stage', 'assign'),
(9, 'stage', 'batchassign'),
(9, 'stage', 'batchcreate'),
(9, 'stage', 'batchedit'),
(9, 'stage', 'browse'),
(9, 'stage', 'create'),
(9, 'stage', 'delete'),
(9, 'stage', 'edit'),
(9, 'stage', 'export'),
(9, 'stage', 'exporttemplate'),
(9, 'stage', 'import'),
(9, 'stage', 'search'),
(9, 'stage', 'view'),
(9, 'story', 'bugs'),
(9, 'story', 'cases'),
(9, 'story', 'export'),
(9, 'story', 'processStoryChange'),
(9, 'story', 'report'),
(9, 'story', 'review'),
(9, 'story', 'tasks'),
(9, 'story', 'track'),
(9, 'story', 'view'),
(9, 'story', 'zeroCase'),
(9, 'subject', 'browse'),
(9, 'svn', 'apiSync'),
(9, 'svn', 'cat'),
(9, 'svn', 'diff'),
(9, 'task', 'activate'),
(9, 'task', 'assignTo'),
(9, 'task', 'batchAssignTo'),
(9, 'task', 'batchChangeModule'),
(9, 'task', 'batchClose'),
(9, 'task', 'batchCreate'),
(9, 'task', 'batchEdit'),
(9, 'task', 'cancel'),
(9, 'task', 'close'),
(9, 'task', 'confirmStoryChange'),
(9, 'task', 'create'),
(9, 'task', 'deleteEstimate'),
(9, 'task', 'edit'),
(9, 'task', 'editEstimate'),
(9, 'task', 'export'),
(9, 'task', 'finish'),
(9, 'task', 'pause'),
(9, 'task', 'recordEstimate'),
(9, 'task', 'report'),
(9, 'task', 'restart'),
(9, 'task', 'start'),
(9, 'task', 'view'),
(9, 'testcase', 'browse'),
(9, 'testcase', 'bugs'),
(9, 'testcase', 'export'),
(9, 'testcase', 'groupCase'),
(9, 'testcase', 'index'),
(9, 'testcase', 'view'),
(9, 'testsuite', 'browse'),
(9, 'testsuite', 'index'),
(9, 'testsuite', 'view'),
(9, 'testtask', 'browse'),
(9, 'testtask', 'cases'),
(9, 'testtask', 'create'),
(9, 'testtask', 'edit'),
(9, 'testtask', 'groupCase'),
(9, 'testtask', 'index'),
(9, 'testtask', 'results'),
(9, 'testtask', 'view'),
(9, 'todo', 'activate'),
(9, 'todo', 'assignTo'),
(9, 'todo', 'batchClose'),
(9, 'todo', 'batchCreate'),
(9, 'todo', 'batchEdit'),
(9, 'todo', 'batchFinish'),
(9, 'todo', 'calendar'),
(9, 'todo', 'close'),
(9, 'todo', 'create'),
(9, 'todo', 'delete'),
(9, 'todo', 'edit'),
(9, 'todo', 'export'),
(9, 'todo', 'finish'),
(9, 'todo', 'import2Today'),
(9, 'todo', 'view'),
(9, 'user', 'batchCreate'),
(9, 'user', 'batchEdit'),
(9, 'user', 'bug'),
(9, 'user', 'create'),
(9, 'user', 'delete'),
(9, 'user', 'dynamic'),
(9, 'user', 'edit'),
(9, 'user', 'effortcalendar'),
(9, 'user', 'profile'),
(9, 'user', 'project'),
(9, 'user', 'story'),
(9, 'user', 'task'),
(9, 'user', 'testCase'),
(9, 'user', 'testTask'),
(9, 'user', 'todo'),
(9, 'user', 'todocalendar'),
(9, 'user', 'unbind'),
(9, 'user', 'unlock'),
(9, 'user', 'view'),
(9, 'weekly', 'index'),
(9, 'workestimation', 'index'),
(9, 'workloadbudget', '27'),
(9, 'workloadbudget', 'assign'),
(9, 'workloadbudget', 'batchassign'),
(9, 'workloadbudget', 'batchcreate'),
(9, 'workloadbudget', 'batchedit'),
(9, 'workloadbudget', 'browse'),
(9, 'workloadbudget', 'create'),
(9, 'workloadbudget', 'delete'),
(9, 'workloadbudget', 'edit'),
(9, 'workloadbudget', 'export'),
(9, 'workloadbudget', 'exporttemplate'),
(9, 'workloadbudget', 'import'),
(9, 'workloadbudget', 'link'),
(9, 'workloadbudget', 'search'),
(9, 'workloadbudget', 'showimport'),
(9, 'workloadbudget', 'unlink'),
(9, 'workloadbudget', 'view'),
(10, 'action', 'editComment'),
(10, 'activity', '12'),
(10, 'activity', 'assign'),
(10, 'activity', 'batchassign'),
(10, 'activity', 'batchcreate'),
(10, 'activity', 'batchedit'),
(10, 'activity', 'browse'),
(10, 'activity', 'create'),
(10, 'activity', 'delete'),
(10, 'activity', 'edit'),
(10, 'activity', 'export'),
(10, 'activity', 'exporttemplate'),
(10, 'activity', 'import'),
(10, 'activity', 'link'),
(10, 'activity', 'outputlist'),
(10, 'activity', 'search'),
(10, 'activity', 'showimport'),
(10, 'activity', 'unlink'),
(10, 'activity', 'view'),
(10, 'audit', '8'),
(10, 'audit', 'assign'),
(10, 'audit', 'batchassign'),
(10, 'audit', 'batchcreate'),
(10, 'audit', 'batchedit'),
(10, 'audit', 'browse'),
(10, 'audit', 'create'),
(10, 'audit', 'delete'),
(10, 'audit', 'edit'),
(10, 'audit', 'export'),
(10, 'audit', 'exporttemplate'),
(10, 'audit', 'import'),
(10, 'audit', 'link'),
(10, 'audit', 'search'),
(10, 'audit', 'showimport'),
(10, 'audit', 'unlink'),
(10, 'audit', 'view'),
(10, 'auditplan', '9'),
(10, 'auditplan', 'assign'),
(10, 'auditplan', 'batchassign'),
(10, 'auditplan', 'batchcreate'),
(10, 'auditplan', 'batchedit'),
(10, 'auditplan', 'browse'),
(10, 'auditplan', 'create'),
(10, 'auditplan', 'delete'),
(10, 'auditplan', 'edit'),
(10, 'auditplan', 'export'),
(10, 'auditplan', 'exporttemplate'),
(10, 'auditplan', 'import'),
(10, 'auditplan', 'link'),
(10, 'auditplan', 'nc'),
(10, 'auditplan', 'result'),
(10, 'auditplan', 'search'),
(10, 'auditplan', 'showimport'),
(10, 'auditplan', 'unlink'),
(10, 'auditplan', 'view'),
(10, 'auditresult', '10'),
(10, 'auditresult', 'assign'),
(10, 'auditresult', 'batchassign'),
(10, 'auditresult', 'batchcreate'),
(10, 'auditresult', 'batchedit'),
(10, 'auditresult', 'browse'),
(10, 'auditresult', 'create'),
(10, 'auditresult', 'delete'),
(10, 'auditresult', 'edit'),
(10, 'auditresult', 'export'),
(10, 'auditresult', 'exporttemplate'),
(10, 'auditresult', 'import'),
(10, 'auditresult', 'link'),
(10, 'auditresult', 'search'),
(10, 'auditresult', 'showimport'),
(10, 'auditresult', 'unlink'),
(10, 'auditresult', 'view'),
(10, 'budget', 'batchCreate'),
(10, 'budget', 'browse'),
(10, 'budget', 'create'),
(10, 'budget', 'delete'),
(10, 'budget', 'edit'),
(10, 'budget', 'summary'),
(10, 'budget', 'view'),
(10, 'bug', 'activate'),
(10, 'bug', 'assignTo'),
(10, 'bug', 'batchActivate'),
(10, 'bug', 'batchAssignTo'),
(10, 'bug', 'batchChangeModule'),
(10, 'bug', 'batchClose'),
(10, 'bug', 'batchConfirm'),
(10, 'bug', 'batchCreate'),
(10, 'bug', 'batchEdit'),
(10, 'bug', 'batchResolve'),
(10, 'bug', 'browse'),
(10, 'bug', 'close'),
(10, 'bug', 'confirmBug'),
(10, 'bug', 'confirmStoryChange'),
(10, 'bug', 'create'),
(10, 'bug', 'edit'),
(10, 'bug', 'export'),
(10, 'bug', 'index'),
(10, 'bug', 'linkBugs'),
(10, 'bug', 'report'),
(10, 'bug', 'resolve'),
(10, 'bug', 'unlinkBug'),
(10, 'bug', 'view'),
(10, 'build', 'create'),
(10, 'build', 'delete'),
(10, 'build', 'edit'),
(10, 'build', 'view'),
(10, 'company', 'browse'),
(10, 'company', 'dynamic'),
(10, 'company', 'effort'),
(10, 'company', 'index'),
(10, 'company', 'view'),
(10, 'custom', 'estimate'),
(10, 'custom', 'settips'),
(10, 'design', '23'),
(10, 'design', 'assign'),
(10, 'design', 'batchassign'),
(10, 'design', 'batchcreate'),
(10, 'design', 'batchedit'),
(10, 'design', 'browse'),
(10, 'design', 'commit'),
(10, 'design', 'create'),
(10, 'design', 'delete'),
(10, 'design', 'edit'),
(10, 'design', 'export'),
(10, 'design', 'search'),
(10, 'design', 'view'),
(10, 'doc', 'allLibs'),
(10, 'doc', 'browse'),
(10, 'doc', 'create'),
(10, 'doc', 'edit'),
(10, 'doc', 'index'),
(10, 'doc', 'objectLibs'),
(10, 'doc', 'showFiles'),
(10, 'doc', 'view'),
(10, 'durationestimation', 'create'),
(10, 'durationestimation', 'index'),
(10, 'effort', 'batchCreate'),
(10, 'effort', 'calendar'),
(10, 'effort', 'createForObject'),
(10, 'effort', 'delete'),
(10, 'effort', 'edit'),
(10, 'effort', 'export'),
(10, 'effort', 'view'),
(10, 'file', 'download'),
(10, 'file', 'edit'),
(10, 'git', 'apiSync'),
(10, 'git', 'cat'),
(10, 'git', 'diff'),
(10, 'group', 'browse'),
(10, 'holiday', 'browse'),
(10, 'holiday', 'create'),
(10, 'holiday', 'delete'),
(10, 'holiday', 'edit'),
(10, 'index', 'index'),
(10, 'issue', '17'),
(10, 'issue', '18'),
(10, 'issue', '19'),
(10, 'issue', '20'),
(10, 'issue', '21'),
(10, 'issue', '22'),
(10, 'issue', 'activate'),
(10, 'issue', 'assign'),
(10, 'issue', 'batchassign'),
(10, 'issue', 'batchcreate'),
(10, 'issue', 'batchedit'),
(10, 'issue', 'browse'),
(10, 'issue', 'cancel'),
(10, 'issue', 'close'),
(10, 'issue', 'create'),
(10, 'issue', 'delete'),
(10, 'issue', 'edit'),
(10, 'issue', 'export'),
(10, 'issue', 'resolve'),
(10, 'issue', 'search'),
(10, 'issue', 'view'),
(10, 'misc', 'ping'),
(10, 'my', 'bug'),
(10, 'my', 'calendar'),
(10, 'my', 'changePassword'),
(10, 'my', 'deleteContacts'),
(10, 'my', 'dynamic'),
(10, 'my', 'editProfile'),
(10, 'my', 'effort'),
(10, 'my', 'index'),
(10, 'my', 'manageContacts'),
(10, 'my', 'profile'),
(10, 'my', 'project'),
(10, 'my', 'story'),
(10, 'my', 'task'),
(10, 'my', 'todo'),
(10, 'my', 'unbind'),
(10, 'nc', '16'),
(10, 'nc', 'activate'),
(10, 'nc', 'assign'),
(10, 'nc', 'batchassign'),
(10, 'nc', 'batchcreate'),
(10, 'nc', 'batchedit'),
(10, 'nc', 'browse'),
(10, 'nc', 'close'),
(10, 'nc', 'create'),
(10, 'nc', 'delete'),
(10, 'nc', 'edit'),
(10, 'nc', 'export'),
(10, 'nc', 'exporttemplate'),
(10, 'nc', 'import'),
(10, 'nc', 'link'),
(10, 'nc', 'resolve'),
(10, 'nc', 'search'),
(10, 'nc', 'showimport'),
(10, 'nc', 'unlink'),
(10, 'nc', 'view'),
(10, 'output', '13'),
(10, 'output', 'assign'),
(10, 'output', 'batchassign'),
(10, 'output', 'batchcreate'),
(10, 'output', 'batchedit'),
(10, 'output', 'browse'),
(10, 'output', 'create'),
(10, 'output', 'delete'),
(10, 'output', 'edit'),
(10, 'output', 'export'),
(10, 'output', 'exporttemplate'),
(10, 'output', 'import'),
(10, 'output', 'link'),
(10, 'output', 'search'),
(10, 'output', 'showimport'),
(10, 'output', 'unlink'),
(10, 'output', 'view'),
(10, 'process', '11'),
(10, 'process', 'activitylist'),
(10, 'process', 'assign'),
(10, 'process', 'batchassign'),
(10, 'process', 'batchcreate'),
(10, 'process', 'batchedit'),
(10, 'process', 'browse'),
(10, 'process', 'create'),
(10, 'process', 'delete'),
(10, 'process', 'edit'),
(10, 'process', 'export'),
(10, 'process', 'exporttemplate'),
(10, 'process', 'import'),
(10, 'process', 'link'),
(10, 'process', 'search'),
(10, 'process', 'showimport'),
(10, 'process', 'unlink'),
(10, 'process', 'view'),
(10, 'product', 'all'),
(10, 'product', 'browse'),
(10, 'product', 'build'),
(10, 'product', 'doc'),
(10, 'product', 'dynamic'),
(10, 'product', 'index'),
(10, 'product', 'roadmap'),
(10, 'product', 'view'),
(10, 'productplan', 'browse'),
(10, 'productplan', 'view'),
(10, 'project', 'all'),
(10, 'project', 'browse'),
(10, 'project', 'bug'),
(10, 'project', 'build'),
(10, 'project', 'burn'),
(10, 'project', 'calendar'),
(10, 'project', 'computeBurn'),
(10, 'project', 'doc'),
(10, 'project', 'dynamic'),
(10, 'project', 'effort'),
(10, 'project', 'gantt'),
(10, 'project', 'grouptask'),
(10, 'project', 'importBug'),
(10, 'project', 'importtask'),
(10, 'project', 'index'),
(10, 'project', 'kanban'),
(10, 'project', 'relation'),
(10, 'project', 'story'),
(10, 'project', 'task'),
(10, 'project', 'team'),
(10, 'project', 'testtask'),
(10, 'project', 'tree'),
(10, 'project', 'treestory'),
(10, 'project', 'treetask'),
(10, 'project', 'view'),
(10, 'pssp', 'browse'),
(10, 'pssp', 'update'),
(10, 'qa', 'index'),
(10, 'release', 'browse'),
(10, 'release', 'export'),
(10, 'release', 'view'),
(10, 'repo', 'browse'),
(10, 'repo', 'diff'),
(10, 'repo', 'download'),
(10, 'repo', 'log'),
(10, 'repo', 'revision'),
(10, 'repo', 'showSyncComment'),
(10, 'repo', 'view'),
(10, 'report', 'bugAssign'),
(10, 'report', 'bugCreate'),
(10, 'report', 'build'),
(10, 'report', 'index'),
(10, 'report', 'productSummary'),
(10, 'report', 'projectDeviation'),
(10, 'report', 'testcase'),
(10, 'report', 'workload'),
(10, 'report', 'workSummary'),
(10, 'risk', 'activate'),
(10, 'risk', 'assign'),
(10, 'risk', 'batchassign'),
(10, 'risk', 'batchcreate'),
(10, 'risk', 'batchedit'),
(10, 'risk', 'browse'),
(10, 'risk', 'cancel'),
(10, 'risk', 'check'),
(10, 'risk', 'close'),
(10, 'risk', 'create'),
(10, 'risk', 'delete'),
(10, 'risk', 'edit'),
(10, 'risk', 'export'),
(10, 'risk', 'hangup'),
(10, 'risk', 'search'),
(10, 'risk', 'view'),
(10, 'search', 'buildForm'),
(10, 'search', 'buildQuery'),
(10, 'search', 'deleteQuery'),
(10, 'search', 'index'),
(10, 'search', 'saveQuery'),
(10, 'search', 'select'),
(10, 'stage', '24'),
(10, 'stage', 'assign'),
(10, 'stage', 'batchassign'),
(10, 'stage', 'batchcreate'),
(10, 'stage', 'batchedit'),
(10, 'stage', 'browse'),
(10, 'stage', 'create'),
(10, 'stage', 'delete'),
(10, 'stage', 'edit'),
(10, 'stage', 'export'),
(10, 'stage', 'exporttemplate'),
(10, 'stage', 'import'),
(10, 'stage', 'search'),
(10, 'stage', 'view'),
(10, 'story', 'bugs'),
(10, 'story', 'cases'),
(10, 'story', 'export'),
(10, 'story', 'processStoryChange'),
(10, 'story', 'report'),
(10, 'story', 'tasks'),
(10, 'story', 'track'),
(10, 'story', 'view'),
(10, 'subject', 'browse'),
(10, 'svn', 'apiSync'),
(10, 'svn', 'cat'),
(10, 'svn', 'diff'),
(10, 'task', 'activate'),
(10, 'task', 'assignTo'),
(10, 'task', 'batchAssignTo'),
(10, 'task', 'batchChangeModule'),
(10, 'task', 'batchClose'),
(10, 'task', 'batchCreate'),
(10, 'task', 'batchEdit'),
(10, 'task', 'cancel'),
(10, 'task', 'close'),
(10, 'task', 'confirmStoryChange'),
(10, 'task', 'create'),
(10, 'task', 'deleteEstimate'),
(10, 'task', 'edit'),
(10, 'task', 'editEstimate'),
(10, 'task', 'export'),
(10, 'task', 'finish'),
(10, 'task', 'pause'),
(10, 'task', 'recordEstimate'),
(10, 'task', 'report'),
(10, 'task', 'restart'),
(10, 'task', 'start'),
(10, 'task', 'view'),
(10, 'testcase', 'browse'),
(10, 'testcase', 'bugs'),
(10, 'testcase', 'export'),
(10, 'testcase', 'groupCase'),
(10, 'testcase', 'index'),
(10, 'testcase', 'view'),
(10, 'testsuite', 'browse'),
(10, 'testsuite', 'index'),
(10, 'testsuite', 'view'),
(10, 'testtask', 'browse'),
(10, 'testtask', 'cases'),
(10, 'testtask', 'create'),
(10, 'testtask', 'edit'),
(10, 'testtask', 'groupCase'),
(10, 'testtask', 'index'),
(10, 'testtask', 'results'),
(10, 'testtask', 'view'),
(10, 'todo', 'activate'),
(10, 'todo', 'assignTo'),
(10, 'todo', 'batchClose'),
(10, 'todo', 'batchCreate'),
(10, 'todo', 'batchEdit'),
(10, 'todo', 'batchFinish'),
(10, 'todo', 'calendar'),
(10, 'todo', 'close'),
(10, 'todo', 'create'),
(10, 'todo', 'createCycle'),
(10, 'todo', 'delete'),
(10, 'todo', 'edit'),
(10, 'todo', 'export'),
(10, 'todo', 'finish'),
(10, 'todo', 'import2Today'),
(10, 'todo', 'view'),
(10, 'user', 'bug'),
(10, 'user', 'dynamic'),
(10, 'user', 'effortcalendar'),
(10, 'user', 'profile'),
(10, 'user', 'project'),
(10, 'user', 'story'),
(10, 'user', 'task'),
(10, 'user', 'testCase'),
(10, 'user', 'testTask'),
(10, 'user', 'todo'),
(10, 'user', 'todocalendar'),
(10, 'user', 'view'),
(10, 'weekly', 'index'),
(10, 'workestimation', 'index'),
(10, 'workloadbudget', '27'),
(10, 'workloadbudget', 'assign'),
(10, 'workloadbudget', 'batchassign'),
(10, 'workloadbudget', 'batchcreate'),
(10, 'workloadbudget', 'batchedit'),
(10, 'workloadbudget', 'browse'),
(10, 'workloadbudget', 'create'),
(10, 'workloadbudget', 'delete'),
(10, 'workloadbudget', 'edit'),
(10, 'workloadbudget', 'export'),
(10, 'workloadbudget', 'exporttemplate'),
(10, 'workloadbudget', 'import'),
(10, 'workloadbudget', 'link'),
(10, 'workloadbudget', 'search'),
(10, 'workloadbudget', 'showimport'),
(10, 'workloadbudget', 'unlink'),
(10, 'workloadbudget', 'view'),
(11, 'action', 'editComment'),
(11, 'activity', '12'),
(11, 'activity', 'assign'),
(11, 'activity', 'batchassign'),
(11, 'activity', 'batchcreate'),
(11, 'activity', 'batchedit'),
(11, 'activity', 'browse'),
(11, 'activity', 'create'),
(11, 'activity', 'delete'),
(11, 'activity', 'edit'),
(11, 'activity', 'export'),
(11, 'activity', 'exporttemplate'),
(11, 'activity', 'import'),
(11, 'activity', 'link'),
(11, 'activity', 'outputlist'),
(11, 'activity', 'search'),
(11, 'activity', 'showimport'),
(11, 'activity', 'unlink'),
(11, 'activity', 'view'),
(11, 'audit', '8'),
(11, 'audit', 'assign'),
(11, 'audit', 'batchassign'),
(11, 'audit', 'batchcreate'),
(11, 'audit', 'batchedit'),
(11, 'audit', 'browse'),
(11, 'audit', 'create'),
(11, 'audit', 'delete'),
(11, 'audit', 'edit'),
(11, 'audit', 'export'),
(11, 'audit', 'exporttemplate'),
(11, 'audit', 'import'),
(11, 'audit', 'link'),
(11, 'audit', 'search'),
(11, 'audit', 'showimport'),
(11, 'audit', 'unlink'),
(11, 'audit', 'view'),
(11, 'auditplan', '9'),
(11, 'auditplan', 'assign'),
(11, 'auditplan', 'batchassign'),
(11, 'auditplan', 'batchcreate'),
(11, 'auditplan', 'batchedit'),
(11, 'auditplan', 'browse'),
(11, 'auditplan', 'create'),
(11, 'auditplan', 'delete'),
(11, 'auditplan', 'edit'),
(11, 'auditplan', 'export'),
(11, 'auditplan', 'exporttemplate'),
(11, 'auditplan', 'import'),
(11, 'auditplan', 'link'),
(11, 'auditplan', 'nc'),
(11, 'auditplan', 'result'),
(11, 'auditplan', 'search'),
(11, 'auditplan', 'showimport'),
(11, 'auditplan', 'unlink'),
(11, 'auditplan', 'view'),
(11, 'auditresult', '10'),
(11, 'auditresult', 'assign'),
(11, 'auditresult', 'batchassign'),
(11, 'auditresult', 'batchcreate'),
(11, 'auditresult', 'batchedit'),
(11, 'auditresult', 'browse'),
(11, 'auditresult', 'create'),
(11, 'auditresult', 'delete'),
(11, 'auditresult', 'edit'),
(11, 'auditresult', 'export'),
(11, 'auditresult', 'exporttemplate'),
(11, 'auditresult', 'import'),
(11, 'auditresult', 'link'),
(11, 'auditresult', 'search'),
(11, 'auditresult', 'showimport'),
(11, 'auditresult', 'unlink'),
(11, 'auditresult', 'view'),
(11, 'budget', 'batchCreate'),
(11, 'budget', 'browse'),
(11, 'budget', 'create'),
(11, 'budget', 'delete'),
(11, 'budget', 'edit'),
(11, 'budget', 'summary'),
(11, 'budget', 'view'),
(11, 'bug', 'activate'),
(11, 'bug', 'assignTo'),
(11, 'bug', 'batchActivate'),
(11, 'bug', 'batchAssignTo'),
(11, 'bug', 'batchChangeModule'),
(11, 'bug', 'batchClose'),
(11, 'bug', 'batchConfirm'),
(11, 'bug', 'batchCreate'),
(11, 'bug', 'batchEdit'),
(11, 'bug', 'batchResolve'),
(11, 'bug', 'browse'),
(11, 'bug', 'close'),
(11, 'bug', 'confirmBug'),
(11, 'bug', 'confirmStoryChange'),
(11, 'bug', 'create'),
(11, 'bug', 'edit'),
(11, 'bug', 'export'),
(11, 'bug', 'index'),
(11, 'bug', 'linkBugs'),
(11, 'bug', 'report'),
(11, 'bug', 'resolve'),
(11, 'bug', 'view'),
(11, 'build', 'create'),
(11, 'build', 'delete'),
(11, 'build', 'edit'),
(11, 'build', 'view'),
(11, 'company', 'browse'),
(11, 'company', 'dynamic'),
(11, 'company', 'effort'),
(11, 'company', 'index'),
(11, 'company', 'view'),
(11, 'custom', 'estimate'),
(11, 'custom', 'settips'),
(11, 'design', '23'),
(11, 'design', 'assign'),
(11, 'design', 'batchassign'),
(11, 'design', 'batchcreate'),
(11, 'design', 'batchedit'),
(11, 'design', 'browse'),
(11, 'design', 'commit'),
(11, 'design', 'create'),
(11, 'design', 'delete'),
(11, 'design', 'edit'),
(11, 'design', 'export'),
(11, 'design', 'search'),
(11, 'design', 'view'),
(11, 'doc', 'allLibs'),
(11, 'doc', 'browse'),
(11, 'doc', 'create'),
(11, 'doc', 'edit'),
(11, 'doc', 'index'),
(11, 'doc', 'objectLibs'),
(11, 'doc', 'showFiles'),
(11, 'doc', 'view'),
(11, 'durationestimation', 'create'),
(11, 'durationestimation', 'index'),
(11, 'effort', 'batchCreate'),
(11, 'effort', 'calendar'),
(11, 'effort', 'createForObject'),
(11, 'effort', 'delete'),
(11, 'effort', 'edit'),
(11, 'effort', 'export'),
(11, 'effort', 'view'),
(11, 'file', 'download'),
(11, 'file', 'edit'),
(11, 'git', 'apiSync'),
(11, 'git', 'cat'),
(11, 'git', 'diff'),
(11, 'group', 'browse'),
(11, 'holiday', 'browse'),
(11, 'holiday', 'create'),
(11, 'holiday', 'delete'),
(11, 'holiday', 'edit'),
(11, 'index', 'index'),
(11, 'issue', '17'),
(11, 'issue', '18'),
(11, 'issue', '19'),
(11, 'issue', '20'),
(11, 'issue', '21'),
(11, 'issue', '22'),
(11, 'issue', 'activate'),
(11, 'issue', 'assign'),
(11, 'issue', 'batchassign'),
(11, 'issue', 'batchcreate'),
(11, 'issue', 'batchedit'),
(11, 'issue', 'browse'),
(11, 'issue', 'cancel'),
(11, 'issue', 'close'),
(11, 'issue', 'create'),
(11, 'issue', 'delete'),
(11, 'issue', 'edit'),
(11, 'issue', 'export'),
(11, 'issue', 'resolve'),
(11, 'issue', 'search'),
(11, 'issue', 'view'),
(11, 'misc', 'ping'),
(11, 'my', 'bug'),
(11, 'my', 'calendar'),
(11, 'my', 'changePassword'),
(11, 'my', 'deleteContacts'),
(11, 'my', 'dynamic'),
(11, 'my', 'editProfile'),
(11, 'my', 'effort'),
(11, 'my', 'index'),
(11, 'my', 'manageContacts'),
(11, 'my', 'profile'),
(11, 'my', 'project'),
(11, 'my', 'story'),
(11, 'my', 'task'),
(11, 'my', 'todo'),
(11, 'my', 'unbind'),
(11, 'nc', '16'),
(11, 'nc', 'activate'),
(11, 'nc', 'assign'),
(11, 'nc', 'batchassign'),
(11, 'nc', 'batchcreate'),
(11, 'nc', 'batchedit'),
(11, 'nc', 'browse'),
(11, 'nc', 'close'),
(11, 'nc', 'create'),
(11, 'nc', 'delete'),
(11, 'nc', 'edit'),
(11, 'nc', 'export'),
(11, 'nc', 'exporttemplate'),
(11, 'nc', 'import'),
(11, 'nc', 'link'),
(11, 'nc', 'resolve'),
(11, 'nc', 'search'),
(11, 'nc', 'showimport'),
(11, 'nc', 'unlink'),
(11, 'nc', 'view'),
(11, 'output', '13'),
(11, 'output', 'assign'),
(11, 'output', 'batchassign'),
(11, 'output', 'batchcreate'),
(11, 'output', 'batchedit'),
(11, 'output', 'browse'),
(11, 'output', 'create'),
(11, 'output', 'delete'),
(11, 'output', 'edit'),
(11, 'output', 'export'),
(11, 'output', 'exporttemplate'),
(11, 'output', 'import'),
(11, 'output', 'link'),
(11, 'output', 'search'),
(11, 'output', 'showimport'),
(11, 'output', 'unlink'),
(11, 'output', 'view'),
(11, 'process', '11'),
(11, 'process', 'activitylist'),
(11, 'process', 'assign'),
(11, 'process', 'batchassign'),
(11, 'process', 'batchcreate'),
(11, 'process', 'batchedit'),
(11, 'process', 'browse'),
(11, 'process', 'create'),
(11, 'process', 'delete'),
(11, 'process', 'edit'),
(11, 'process', 'export'),
(11, 'process', 'exporttemplate'),
(11, 'process', 'import'),
(11, 'process', 'link'),
(11, 'process', 'search'),
(11, 'process', 'showimport'),
(11, 'process', 'unlink'),
(11, 'process', 'view'),
(11, 'product', 'all'),
(11, 'product', 'browse'),
(11, 'product', 'build'),
(11, 'product', 'doc'),
(11, 'product', 'dynamic'),
(11, 'product', 'index'),
(11, 'product', 'roadmap'),
(11, 'product', 'view'),
(11, 'productplan', 'browse'),
(11, 'productplan', 'view'),
(11, 'project', 'all'),
(11, 'project', 'browse'),
(11, 'project', 'bug'),
(11, 'project', 'build'),
(11, 'project', 'burn'),
(11, 'project', 'calendar'),
(11, 'project', 'computeBurn'),
(11, 'project', 'doc'),
(11, 'project', 'dynamic'),
(11, 'project', 'effort'),
(11, 'project', 'gantt'),
(11, 'project', 'grouptask'),
(11, 'project', 'importBug'),
(11, 'project', 'importtask'),
(11, 'project', 'index'),
(11, 'project', 'kanban'),
(11, 'project', 'relation'),
(11, 'project', 'story'),
(11, 'project', 'task'),
(11, 'project', 'team'),
(11, 'project', 'testtask'),
(11, 'project', 'tree'),
(11, 'project', 'treestory'),
(11, 'project', 'treetask'),
(11, 'project', 'view'),
(11, 'pssp', 'browse'),
(11, 'pssp', 'update'),
(11, 'qa', 'index'),
(11, 'release', 'browse'),
(11, 'release', 'export'),
(11, 'release', 'view'),
(11, 'repo', 'browse'),
(11, 'repo', 'diff'),
(11, 'repo', 'download'),
(11, 'repo', 'log'),
(11, 'repo', 'revision'),
(11, 'repo', 'showSyncComment'),
(11, 'repo', 'view'),
(11, 'report', 'bugAssign'),
(11, 'report', 'bugCreate'),
(11, 'report', 'build'),
(11, 'report', 'index'),
(11, 'report', 'productSummary'),
(11, 'report', 'projectDeviation'),
(11, 'report', 'testcase'),
(11, 'report', 'workload'),
(11, 'report', 'workSummary'),
(11, 'risk', 'activate'),
(11, 'risk', 'assign'),
(11, 'risk', 'batchassign'),
(11, 'risk', 'batchcreate'),
(11, 'risk', 'batchedit'),
(11, 'risk', 'browse'),
(11, 'risk', 'cancel'),
(11, 'risk', 'check'),
(11, 'risk', 'close'),
(11, 'risk', 'create'),
(11, 'risk', 'delete'),
(11, 'risk', 'edit'),
(11, 'risk', 'export'),
(11, 'risk', 'hangup'),
(11, 'risk', 'search'),
(11, 'risk', 'view'),
(11, 'search', 'buildForm'),
(11, 'search', 'buildQuery'),
(11, 'search', 'deleteQuery'),
(11, 'search', 'index'),
(11, 'search', 'saveQuery'),
(11, 'search', 'select'),
(11, 'stage', '24'),
(11, 'stage', 'assign'),
(11, 'stage', 'batchassign'),
(11, 'stage', 'batchcreate'),
(11, 'stage', 'batchedit'),
(11, 'stage', 'browse'),
(11, 'stage', 'create'),
(11, 'stage', 'delete'),
(11, 'stage', 'edit'),
(11, 'stage', 'export'),
(11, 'stage', 'exporttemplate'),
(11, 'stage', 'import'),
(11, 'stage', 'search'),
(11, 'stage', 'view'),
(11, 'story', 'bugs'),
(11, 'story', 'cases'),
(11, 'story', 'export'),
(11, 'story', 'processStoryChange'),
(11, 'story', 'report'),
(11, 'story', 'tasks'),
(11, 'story', 'track'),
(11, 'story', 'view'),
(11, 'subject', 'browse'),
(11, 'svn', 'apiSync'),
(11, 'svn', 'cat'),
(11, 'svn', 'diff'),
(11, 'task', 'activate'),
(11, 'task', 'assignTo'),
(11, 'task', 'batchAssignTo'),
(11, 'task', 'batchChangeModule'),
(11, 'task', 'batchClose'),
(11, 'task', 'batchCreate'),
(11, 'task', 'batchEdit'),
(11, 'task', 'cancel'),
(11, 'task', 'close'),
(11, 'task', 'confirmStoryChange'),
(11, 'task', 'create'),
(11, 'task', 'deleteEstimate'),
(11, 'task', 'edit'),
(11, 'task', 'editEstimate'),
(11, 'task', 'export'),
(11, 'task', 'finish'),
(11, 'task', 'pause'),
(11, 'task', 'recordEstimate'),
(11, 'task', 'report'),
(11, 'task', 'restart'),
(11, 'task', 'start'),
(11, 'task', 'view'),
(11, 'testcase', 'browse'),
(11, 'testcase', 'bugs'),
(11, 'testcase', 'export'),
(11, 'testcase', 'groupCase'),
(11, 'testcase', 'index'),
(11, 'testcase', 'view'),
(11, 'testsuite', 'browse'),
(11, 'testsuite', 'index'),
(11, 'testsuite', 'view'),
(11, 'testtask', 'browse'),
(11, 'testtask', 'cases'),
(11, 'testtask', 'create'),
(11, 'testtask', 'edit'),
(11, 'testtask', 'groupCase'),
(11, 'testtask', 'index'),
(11, 'testtask', 'results'),
(11, 'testtask', 'view'),
(11, 'todo', 'activate'),
(11, 'todo', 'assignTo'),
(11, 'todo', 'batchClose'),
(11, 'todo', 'batchCreate'),
(11, 'todo', 'batchEdit'),
(11, 'todo', 'batchFinish'),
(11, 'todo', 'calendar'),
(11, 'todo', 'close'),
(11, 'todo', 'create'),
(11, 'todo', 'delete'),
(11, 'todo', 'edit'),
(11, 'todo', 'export'),
(11, 'todo', 'finish'),
(11, 'todo', 'import2Today'),
(11, 'todo', 'view'),
(11, 'user', 'bug'),
(11, 'user', 'dynamic'),
(11, 'user', 'effortcalendar'),
(11, 'user', 'profile'),
(11, 'user', 'project'),
(11, 'user', 'story'),
(11, 'user', 'task'),
(11, 'user', 'testCase'),
(11, 'user', 'testTask'),
(11, 'user', 'todo'),
(11, 'user', 'todocalendar'),
(11, 'user', 'view'),
(11, 'weekly', 'index'),
(11, 'workestimation', 'index'),
(11, 'workloadbudget', '27'),
(11, 'workloadbudget', 'assign'),
(11, 'workloadbudget', 'batchassign'),
(11, 'workloadbudget', 'batchcreate'),
(11, 'workloadbudget', 'batchedit'),
(11, 'workloadbudget', 'browse'),
(11, 'workloadbudget', 'create'),
(11, 'workloadbudget', 'delete'),
(11, 'workloadbudget', 'edit'),
(11, 'workloadbudget', 'export'),
(11, 'workloadbudget', 'exporttemplate'),
(11, 'workloadbudget', 'import'),
(11, 'workloadbudget', 'link'),
(11, 'workloadbudget', 'search'),
(11, 'workloadbudget', 'showimport'),
(11, 'workloadbudget', 'unlink'),
(11, 'workloadbudget', 'view'),
(12, 'action', 'editComment'),
(12, 'activity', '12'),
(12, 'activity', 'assign'),
(12, 'activity', 'batchassign'),
(12, 'activity', 'batchcreate'),
(12, 'activity', 'batchedit'),
(12, 'activity', 'browse'),
(12, 'activity', 'create'),
(12, 'activity', 'delete'),
(12, 'activity', 'edit'),
(12, 'activity', 'export'),
(12, 'activity', 'exporttemplate'),
(12, 'activity', 'import'),
(12, 'activity', 'link'),
(12, 'activity', 'outputlist'),
(12, 'activity', 'search'),
(12, 'activity', 'showimport'),
(12, 'activity', 'unlink'),
(12, 'activity', 'view'),
(12, 'audit', '8'),
(12, 'audit', 'assign'),
(12, 'audit', 'batchassign'),
(12, 'audit', 'batchcreate'),
(12, 'audit', 'batchedit'),
(12, 'audit', 'browse'),
(12, 'audit', 'create'),
(12, 'audit', 'delete'),
(12, 'audit', 'edit'),
(12, 'audit', 'export'),
(12, 'audit', 'exporttemplate'),
(12, 'audit', 'import'),
(12, 'audit', 'link'),
(12, 'audit', 'search'),
(12, 'audit', 'showimport'),
(12, 'audit', 'unlink'),
(12, 'audit', 'view'),
(12, 'auditplan', '9'),
(12, 'auditplan', 'assign'),
(12, 'auditplan', 'batchassign'),
(12, 'auditplan', 'batchcreate'),
(12, 'auditplan', 'batchedit'),
(12, 'auditplan', 'browse'),
(12, 'auditplan', 'create'),
(12, 'auditplan', 'delete'),
(12, 'auditplan', 'edit'),
(12, 'auditplan', 'export'),
(12, 'auditplan', 'exporttemplate'),
(12, 'auditplan', 'import'),
(12, 'auditplan', 'link'),
(12, 'auditplan', 'nc'),
(12, 'auditplan', 'result'),
(12, 'auditplan', 'search'),
(12, 'auditplan', 'showimport'),
(12, 'auditplan', 'unlink'),
(12, 'auditplan', 'view'),
(12, 'auditresult', '10'),
(12, 'auditresult', 'assign'),
(12, 'auditresult', 'batchassign'),
(12, 'auditresult', 'batchcreate'),
(12, 'auditresult', 'batchedit'),
(12, 'auditresult', 'browse'),
(12, 'auditresult', 'create'),
(12, 'auditresult', 'delete'),
(12, 'auditresult', 'edit'),
(12, 'auditresult', 'export'),
(12, 'auditresult', 'exporttemplate'),
(12, 'auditresult', 'import'),
(12, 'auditresult', 'link'),
(12, 'auditresult', 'search'),
(12, 'auditresult', 'showimport'),
(12, 'auditresult', 'unlink'),
(12, 'auditresult', 'view'),
(12, 'budget', 'batchCreate'),
(12, 'budget', 'browse'),
(12, 'budget', 'create'),
(12, 'budget', 'delete'),
(12, 'budget', 'edit'),
(12, 'budget', 'summary'),
(12, 'budget', 'view'),
(12, 'bug', 'activate'),
(12, 'bug', 'assignTo'),
(12, 'bug', 'batchActivate'),
(12, 'bug', 'batchAssignTo'),
(12, 'bug', 'batchChangeModule'),
(12, 'bug', 'batchClose'),
(12, 'bug', 'batchConfirm'),
(12, 'bug', 'batchCreate'),
(12, 'bug', 'batchEdit'),
(12, 'bug', 'batchResolve'),
(12, 'bug', 'browse'),
(12, 'bug', 'close'),
(12, 'bug', 'confirmBug'),
(12, 'bug', 'confirmStoryChange'),
(12, 'bug', 'create'),
(12, 'bug', 'edit'),
(12, 'bug', 'export'),
(12, 'bug', 'index'),
(12, 'bug', 'linkBugs'),
(12, 'bug', 'report'),
(12, 'bug', 'resolve'),
(12, 'bug', 'view'),
(12, 'build', 'create'),
(12, 'build', 'delete'),
(12, 'build', 'edit'),
(12, 'build', 'view'),
(12, 'company', 'browse'),
(12, 'company', 'dynamic'),
(12, 'company', 'effort'),
(12, 'company', 'index'),
(12, 'company', 'view'),
(12, 'custom', 'estimate'),
(12, 'custom', 'settips'),
(12, 'design', '23'),
(12, 'design', 'assign'),
(12, 'design', 'batchassign'),
(12, 'design', 'batchcreate'),
(12, 'design', 'batchedit'),
(12, 'design', 'browse'),
(12, 'design', 'commit'),
(12, 'design', 'create'),
(12, 'design', 'delete'),
(12, 'design', 'edit'),
(12, 'design', 'export'),
(12, 'design', 'search'),
(12, 'design', 'view'),
(12, 'doc', 'allLibs'),
(12, 'doc', 'browse'),
(12, 'doc', 'create'),
(12, 'doc', 'edit'),
(12, 'doc', 'index'),
(12, 'doc', 'objectLibs'),
(12, 'doc', 'showFiles'),
(12, 'doc', 'view'),
(12, 'durationestimation', 'create'),
(12, 'durationestimation', 'index'),
(12, 'effort', 'batchCreate'),
(12, 'effort', 'calendar'),
(12, 'effort', 'createForObject'),
(12, 'effort', 'delete'),
(12, 'effort', 'edit'),
(12, 'effort', 'export'),
(12, 'effort', 'view'),
(12, 'file', 'download'),
(12, 'file', 'edit'),
(12, 'git', 'apiSync'),
(12, 'git', 'cat'),
(12, 'git', 'diff'),
(12, 'group', 'browse'),
(12, 'holiday', 'browse'),
(12, 'holiday', 'create'),
(12, 'holiday', 'delete'),
(12, 'holiday', 'edit'),
(12, 'index', 'index'),
(12, 'issue', '17'),
(12, 'issue', '18'),
(12, 'issue', '19'),
(12, 'issue', '20'),
(12, 'issue', '21'),
(12, 'issue', '22'),
(12, 'issue', 'activate'),
(12, 'issue', 'assign'),
(12, 'issue', 'batchassign'),
(12, 'issue', 'batchcreate'),
(12, 'issue', 'batchedit'),
(12, 'issue', 'browse'),
(12, 'issue', 'cancel'),
(12, 'issue', 'close'),
(12, 'issue', 'create'),
(12, 'issue', 'delete'),
(12, 'issue', 'edit'),
(12, 'issue', 'export'),
(12, 'issue', 'resolve'),
(12, 'issue', 'search'),
(12, 'issue', 'view'),
(12, 'misc', 'ping'),
(12, 'my', 'bug'),
(12, 'my', 'calendar'),
(12, 'my', 'changePassword'),
(12, 'my', 'deleteContacts'),
(12, 'my', 'dynamic'),
(12, 'my', 'editProfile'),
(12, 'my', 'effort'),
(12, 'my', 'index'),
(12, 'my', 'limited'),
(12, 'my', 'manageContacts'),
(12, 'my', 'profile'),
(12, 'my', 'project'),
(12, 'my', 'story'),
(12, 'my', 'task'),
(12, 'my', 'todo'),
(12, 'my', 'unbind'),
(12, 'nc', '16'),
(12, 'nc', 'activate'),
(12, 'nc', 'assign'),
(12, 'nc', 'batchassign'),
(12, 'nc', 'batchcreate'),
(12, 'nc', 'batchedit'),
(12, 'nc', 'browse'),
(12, 'nc', 'close'),
(12, 'nc', 'create'),
(12, 'nc', 'delete'),
(12, 'nc', 'edit'),
(12, 'nc', 'export'),
(12, 'nc', 'exporttemplate'),
(12, 'nc', 'import'),
(12, 'nc', 'link'),
(12, 'nc', 'resolve'),
(12, 'nc', 'search'),
(12, 'nc', 'showimport'),
(12, 'nc', 'unlink'),
(12, 'nc', 'view'),
(12, 'output', '13'),
(12, 'output', 'assign'),
(12, 'output', 'batchassign'),
(12, 'output', 'batchcreate'),
(12, 'output', 'batchedit'),
(12, 'output', 'browse'),
(12, 'output', 'create'),
(12, 'output', 'delete'),
(12, 'output', 'edit'),
(12, 'output', 'export'),
(12, 'output', 'exporttemplate'),
(12, 'output', 'import'),
(12, 'output', 'link'),
(12, 'output', 'search'),
(12, 'output', 'showimport'),
(12, 'output', 'unlink'),
(12, 'output', 'view'),
(12, 'process', '11'),
(12, 'process', 'activitylist'),
(12, 'process', 'assign'),
(12, 'process', 'batchassign'),
(12, 'process', 'batchcreate'),
(12, 'process', 'batchedit'),
(12, 'process', 'browse'),
(12, 'process', 'create'),
(12, 'process', 'delete'),
(12, 'process', 'edit'),
(12, 'process', 'export'),
(12, 'process', 'exporttemplate'),
(12, 'process', 'import'),
(12, 'process', 'link'),
(12, 'process', 'search'),
(12, 'process', 'showimport'),
(12, 'process', 'unlink'),
(12, 'process', 'view'),
(12, 'product', 'all'),
(12, 'product', 'browse'),
(12, 'product', 'index'),
(12, 'product', 'view'),
(12, 'productplan', 'browse'),
(12, 'productplan', 'view'),
(12, 'project', 'all'),
(12, 'project', 'browse'),
(12, 'project', 'bug'),
(12, 'project', 'build'),
(12, 'project', 'burn'),
(12, 'project', 'calendar'),
(12, 'project', 'computeBurn'),
(12, 'project', 'effort'),
(12, 'project', 'gantt'),
(12, 'project', 'grouptask'),
(12, 'project', 'importBug'),
(12, 'project', 'importtask'),
(12, 'project', 'index'),
(12, 'project', 'kanban'),
(12, 'project', 'relation'),
(12, 'project', 'story'),
(12, 'project', 'task'),
(12, 'project', 'team'),
(12, 'project', 'testtask'),
(12, 'project', 'tree'),
(12, 'project', 'view'),
(12, 'pssp', 'browse'),
(12, 'pssp', 'update'),
(12, 'qa', 'index'),
(12, 'release', 'browse'),
(12, 'release', 'export'),
(12, 'release', 'view'),
(12, 'repo', 'browse'),
(12, 'repo', 'diff'),
(12, 'repo', 'download'),
(12, 'repo', 'log'),
(12, 'repo', 'revision'),
(12, 'repo', 'showSyncComment'),
(12, 'repo', 'view'),
(12, 'report', 'bugAssign'),
(12, 'report', 'bugCreate'),
(12, 'report', 'build'),
(12, 'report', 'index'),
(12, 'report', 'productSummary'),
(12, 'report', 'projectDeviation'),
(12, 'report', 'testcase'),
(12, 'report', 'workload'),
(12, 'report', 'workSummary'),
(12, 'risk', 'activate'),
(12, 'risk', 'assign'),
(12, 'risk', 'batchassign'),
(12, 'risk', 'batchcreate'),
(12, 'risk', 'batchedit'),
(12, 'risk', 'browse'),
(12, 'risk', 'cancel'),
(12, 'risk', 'check'),
(12, 'risk', 'close'),
(12, 'risk', 'create'),
(12, 'risk', 'delete'),
(12, 'risk', 'edit'),
(12, 'risk', 'export'),
(12, 'risk', 'hangup'),
(12, 'risk', 'search'),
(12, 'risk', 'view'),
(12, 'search', 'buildForm'),
(12, 'search', 'buildQuery'),
(12, 'search', 'deleteQuery'),
(12, 'search', 'index'),
(12, 'search', 'saveQuery'),
(12, 'search', 'select'),
(12, 'stage', '24'),
(12, 'stage', 'assign'),
(12, 'stage', 'batchassign'),
(12, 'stage', 'batchcreate'),
(12, 'stage', 'batchedit'),
(12, 'stage', 'browse'),
(12, 'stage', 'create'),
(12, 'stage', 'delete'),
(12, 'stage', 'edit'),
(12, 'stage', 'export'),
(12, 'stage', 'exporttemplate'),
(12, 'stage', 'import'),
(12, 'stage', 'search'),
(12, 'stage', 'view'),
(12, 'story', 'bugs'),
(12, 'story', 'cases'),
(12, 'story', 'export'),
(12, 'story', 'processStoryChange'),
(12, 'story', 'report'),
(12, 'story', 'tasks'),
(12, 'story', 'track'),
(12, 'story', 'view'),
(12, 'subject', 'browse'),
(12, 'svn', 'apiSync'),
(12, 'svn', 'cat'),
(12, 'svn', 'diff'),
(12, 'task', 'activate'),
(12, 'task', 'assignTo'),
(12, 'task', 'batchAssignTo'),
(12, 'task', 'batchChangeModule'),
(12, 'task', 'batchClose'),
(12, 'task', 'batchCreate'),
(12, 'task', 'batchEdit'),
(12, 'task', 'cancel'),
(12, 'task', 'close'),
(12, 'task', 'confirmStoryChange'),
(12, 'task', 'create'),
(12, 'task', 'deleteEstimate'),
(12, 'task', 'edit'),
(12, 'task', 'editEstimate'),
(12, 'task', 'export'),
(12, 'task', 'finish'),
(12, 'task', 'pause'),
(12, 'task', 'recordEstimate'),
(12, 'task', 'report'),
(12, 'task', 'restart'),
(12, 'task', 'start'),
(12, 'task', 'view'),
(12, 'testcase', 'browse'),
(12, 'testcase', 'bugs'),
(12, 'testcase', 'export'),
(12, 'testcase', 'groupCase'),
(12, 'testcase', 'index'),
(12, 'testcase', 'view'),
(12, 'testsuite', 'browse'),
(12, 'testsuite', 'index'),
(12, 'testsuite', 'view'),
(12, 'testtask', 'browse'),
(12, 'testtask', 'cases'),
(12, 'testtask', 'create'),
(12, 'testtask', 'edit'),
(12, 'testtask', 'groupCase'),
(12, 'testtask', 'index'),
(12, 'testtask', 'results'),
(12, 'testtask', 'view'),
(12, 'todo', 'activate'),
(12, 'todo', 'assignTo'),
(12, 'todo', 'batchClose'),
(12, 'todo', 'batchCreate'),
(12, 'todo', 'batchEdit'),
(12, 'todo', 'batchFinish'),
(12, 'todo', 'calendar'),
(12, 'todo', 'close'),
(12, 'todo', 'create'),
(12, 'todo', 'delete'),
(12, 'todo', 'edit'),
(12, 'todo', 'export'),
(12, 'todo', 'finish'),
(12, 'todo', 'import2Today'),
(12, 'todo', 'view'),
(12, 'user', 'bug'),
(12, 'user', 'dynamic'),
(12, 'user', 'effortcalendar'),
(12, 'user', 'profile'),
(12, 'user', 'project'),
(12, 'user', 'story'),
(12, 'user', 'task'),
(12, 'user', 'testCase'),
(12, 'user', 'testTask'),
(12, 'user', 'todo'),
(12, 'user', 'todocalendar'),
(12, 'user', 'view'),
(12, 'weekly', 'index'),
(12, 'workestimation', 'index'),
(12, 'workloadbudget', '27'),
(12, 'workloadbudget', 'assign'),
(12, 'workloadbudget', 'batchassign'),
(12, 'workloadbudget', 'batchcreate'),
(12, 'workloadbudget', 'batchedit'),
(12, 'workloadbudget', 'browse'),
(12, 'workloadbudget', 'create'),
(12, 'workloadbudget', 'delete'),
(12, 'workloadbudget', 'edit'),
(12, 'workloadbudget', 'export'),
(12, 'workloadbudget', 'exporttemplate'),
(12, 'workloadbudget', 'import'),
(12, 'workloadbudget', 'link'),
(12, 'workloadbudget', 'search'),
(12, 'workloadbudget', 'showimport'),
(12, 'workloadbudget', 'unlink'),
(12, 'workloadbudget', 'view'),
(13, 'attend', 'edit'),
(13, 'attend', 'personal'),
(13, 'doc', 'alllibs'),
(13, 'doc', 'browse'),
(13, 'doc', 'create'),
(13, 'doc', 'createLib'),
(13, 'doc', 'delete'),
(13, 'doc', 'deleteFile'),
(13, 'doc', 'diff'),
(13, 'doc', 'edit'),
(13, 'doc', 'editLib'),
(13, 'doc', 'showFiles'),
(13, 'doc', 'view'),
(13, 'effort', 'batchCreate'),
(13, 'effort', 'batchEdit'),
(13, 'effort', 'calendar'),
(13, 'effort', 'createForObject'),
(13, 'effort', 'delete'),
(13, 'effort', 'edit'),
(13, 'effort', 'export'),
(13, 'effort', 'view'),
(13, 'faq', 'browse'),
(13, 'faq', 'create'),
(13, 'faq', 'delete'),
(13, 'faq', 'edit'),
(13, 'feedback', 'browse'),
(13, 'feedback', 'close'),
(13, 'feedback', 'comment'),
(13, 'feedback', 'create'),
(13, 'feedback', 'delete'),
(13, 'feedback', 'edit'),
(13, 'feedback', 'index'),
(13, 'feedback', 'view'),
(13, 'file', 'delete'),
(13, 'file', 'download'),
(13, 'file', 'edit'),
(13, 'holiday', 'browse'),
(13, 'index', 'index'),
(13, 'leave', 'back'),
(13, 'leave', 'create'),
(13, 'leave', 'delete'),
(13, 'leave', 'edit'),
(13, 'leave', 'personal'),
(13, 'leave', 'switchstatus'),
(13, 'leave', 'view'),
(13, 'lieu', 'create'),
(13, 'lieu', 'delete'),
(13, 'lieu', 'edit'),
(13, 'lieu', 'personal'),
(13, 'lieu', 'switchstatus'),
(13, 'lieu', 'view'),
(13, 'makeup', 'create'),
(13, 'makeup', 'delete'),
(13, 'makeup', 'edit'),
(13, 'makeup', 'personal'),
(13, 'makeup', 'switchstatus'),
(13, 'makeup', 'view'),
(13, 'my', 'changePassword'),
(13, 'my', 'editProfile'),
(13, 'my', 'effort'),
(13, 'my', 'profile'),
(13, 'my', 'todo'),
(13, 'overtime', 'create'),
(13, 'overtime', 'delete'),
(13, 'overtime', 'edit'),
(13, 'overtime', 'personal'),
(13, 'overtime', 'switchstatus'),
(13, 'overtime', 'view'),
(13, 'search', 'buildForm'),
(13, 'search', 'buildQuery'),
(13, 'search', 'deleteQuery'),
(13, 'search', 'saveQuery'),
(13, 'search', 'select'),
(13, 'todo', 'batchCreate'),
(13, 'todo', 'batchEdit'),
(13, 'todo', 'batchFinish'),
(13, 'todo', 'calendar'),
(13, 'todo', 'create'),
(13, 'todo', 'delete'),
(13, 'todo', 'edit'),
(13, 'todo', 'export'),
(13, 'todo', 'finish'),
(13, 'todo', 'import2Today'),
(13, 'todo', 'view'),
(13, 'tree', 'browse'),
(13, 'tree', 'delete'),
(13, 'tree', 'manageChild'),
(13, 'tree', 'updateOrder');

REPLACE INTO `zt_stage` (`name`,`percent`,`type`,`createdBy`,`createdDate`,`editedBy`,`editedDate`,`deleted`) VALUES
('需求','10','request','admin','2020-02-08 21:08:30','admin','2020-02-12 13:50:27','0'),
('设计','10','design','admin','2020-02-08 21:08:30','admin','2020-02-12 13:50:27','0'),
('开发','50','dev','admin','2020-02-08 21:08:30','admin','2020-02-12 13:50:27','0'),
('测试','15','qa','admin','2020-02-08 21:08:30','admin','2020-02-12 13:50:27','0'),
('发布','10','release','admin','2020-02-08 21:08:30','admin','2020-02-12 13:50:27','0'),
('总结评审','5','review','admin','2020-02-08 21:08:45','admin','2020-02-12 13:50:27','0');

INSERT INTO `zt_lang` (`lang`, `module`, `section`, `key`, `value`, `system`) VALUES
('all', 'process', 'classify', 'support', '支持过程', '1'),
('all', 'process', 'classify', 'engineering', '工程支持', '1'),
('all', 'process', 'classify', 'project', '项目管理', '1'),
('all','stage','typeList','request','需求', '1'),
('all','stage','typeList','design','设计', '1'),
('all','stage','typeList','dev','开发', '1'),
('all','stage','typeList','qa','测试', '1'),
('all','stage','typeList','release','发布', '1'),
('all','stage','typeList','review','总结评审','1'),
('all','stage','typeList','other','其他','1');

INSERT INTO `zt_process` VALUES
(11,'立项管理','project','PIM','','','',55,'admin','2020-01-09 10:29:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(12,'项目规划','project','PP','','','',60,'admin','2020-01-09 10:31:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(13,'项目监控','project','PMC','','','',65,'admin','2020-01-09 10:31:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(14,'风险管理','project','RSKM','','','',70,'admin','2020-01-09 10:31:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(15,'结项管理','project','PCM','','','',75,'admin','2020-01-09 10:31:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(16,'量化项目管理','project','QPM','','','',80,'admin','2020-01-09 10:31:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(17,'需求开发','engineering','RDM','','','',85,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(18,'设计开发','engineering','','','','',90,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(19,'实现与测试','engineering','EMBEDDED','','','',95,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(20,'系统测试','engineering','ST','','','',100,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(21,'客户验收','engineering','CA','','','',105,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(22,'质量保证','support','QA','','','',110,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(23,'配置管理','support','CM','','','',115,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(24,'度量分析','support','MA','','','',120,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(25,'原因分析与解决','support','CAR','','','',125,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','1'),
(26,'决策分析','support','DAR','','','',130,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0');

INSERT INTO `zt_activity` VALUES
(4,11,'立项调查，可行性分析，技术预研','yes','','','','admin','2020-01-09 10:49:34','','0000-00-00 00:00:00','','0000-00-00 00:00:00',20,'0'),
(5,11,'项目预算','yes','','','','admin','2020-01-09 10:49:34','','0000-00-00 00:00:00','','0000-00-00 00:00:00',25,'0'),
(6,11,'立项决策','yes','','','','admin','2020-01-09 10:49:34','','0000-00-00 00:00:00','','0000-00-00 00:00:00',30,'0'),
(7,11,'投标/商务洽谈','no','','','','admin','2020-01-09 10:49:34','','0000-00-00 00:00:00','','0000-00-00 00:00:00',35,'0'),
(8,12,'估算','yes','','','','admin','2020-01-09 11:12:17','','0000-00-00 00:00:00','','0000-00-00 00:00:00',40,'0'),
(9,12,'裁剪','yes','','','','admin','2020-01-09 11:12:17','','0000-00-00 00:00:00','','0000-00-00 00:00:00',45,'0'),
(10,12,'制定项目计划及下属计划','yes','','','','admin','2020-01-09 11:12:17','','0000-00-00 00:00:00','','0000-00-00 00:00:00',50,'0'),
(11,12,'评审项目计划及下属计划','yes','','','','admin','2020-01-09 11:12:17','','0000-00-00 00:00:00','','0000-00-00 00:00:00',55,'0'),
(12,13,'日常跟踪','yes','','','','admin','2020-01-09 11:13:37','','0000-00-00 00:00:00','','0000-00-00 00:00:00',60,'0'),
(13,13,'举行周例会','yes','','','','admin','2020-01-09 11:13:37','','0000-00-00 00:00:00','','0000-00-00 00:00:00',65,'0'),
(14,13,'里程碑评审','yes','','','','admin','2020-01-09 11:13:37','','0000-00-00 00:00:00','','0000-00-00 00:00:00',70,'0'),
(15,13,'采取纠正措施','no','','','','admin','2020-01-09 11:13:37','','0000-00-00 00:00:00','','0000-00-00 00:00:00',75,'0'),
(16,14,'制定风险管理计划','yes','','','','admin','2020-01-09 11:15:04','','0000-00-00 00:00:00','','0000-00-00 00:00:00',80,'0'),
(17,14,'风险识别','yes','','','','admin','2020-01-09 11:15:04','','0000-00-00 00:00:00','','0000-00-00 00:00:00',85,'0'),
(18,14,'风险分析','yes','','','','admin','2020-01-09 11:15:04','','0000-00-00 00:00:00','','0000-00-00 00:00:00',90,'0'),
(19,14,'风险规避和缓解','yes','','','','admin','2020-01-09 11:15:04','','0000-00-00 00:00:00','','0000-00-00 00:00:00',95,'0'),
(20,14,'风险跟踪','yes','','','','admin','2020-01-09 11:15:04','','0000-00-00 00:00:00','','0000-00-00 00:00:00',100,'0'),
(21,14,'更新组织级“风险列表库”','no','','','','admin','2020-01-09 11:15:04','','0000-00-00 00:00:00','','0000-00-00 00:00:00',105,'0'),
(22,15,'结项准备','no','','','','admin','2020-01-09 11:16:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00',110,'0'),
(23,15,'结项申请','yes','','','','admin','2020-01-09 11:16:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00',115,'0'),
(24,15,'结项评审','yes','','','','admin','2020-01-09 11:16:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00',120,'0'),
(25,15,'资料纳入组织级过程资产库','yes','','','','admin','2020-01-09 11:16:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00',125,'0'),
(26,16,'量化项目管理','yes','','','','admin','2020-01-09 11:16:34','','0000-00-00 00:00:00','','0000-00-00 00:00:00',130,'0'),
(27,17,'用户需求获取','yes','','','','admin','2020-01-09 13:25:22','','0000-00-00 00:00:00','','0000-00-00 00:00:00',135,'0'),
(28,17,'用户需求评审','yes','','','','admin','2020-01-09 13:25:22','','0000-00-00 00:00:00','','0000-00-00 00:00:00',140,'0'),
(29,17,'产品需求定义','yes','','','','admin','2020-01-09 13:25:22','','0000-00-00 00:00:00','','0000-00-00 00:00:00',145,'0'),
(30,17,'产品需求评审','yes','','','','admin','2020-01-09 13:25:22','','0000-00-00 00:00:00','','0000-00-00 00:00:00',150,'0'),
(31,17,'需求变更控制','no','未涉及变更时可不进行','','','admin','2020-01-09 13:25:22','','0000-00-00 00:00:00','','0000-00-00 00:00:00',155,'0'),
(32,18,'概要设计','','','','','admin','2020-01-09 13:26:07','','0000-00-00 00:00:00','','0000-00-00 00:00:00',160,'0'),
(33,18,'评审《概要设计说明书》','','','','','admin','2020-01-09 13:26:07','','0000-00-00 00:00:00','','0000-00-00 00:00:00',165,'0'),
(34,18,'详细设计','','','','','admin','2020-01-09 13:26:07','','0000-00-00 00:00:00','','0000-00-00 00:00:00',170,'0'),
(35,18,'评审详细设计工作产品','','','','','admin','2020-01-09 13:26:07','','0000-00-00 00:00:00','','0000-00-00 00:00:00',175,'0'),
(42,19,'制定编码阶段计划','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',210,'0'),
(43,19,'构建数据库','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',215,'0'),
(44,19,'编码实现','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',220,'0'),
(45,19,'代码检查','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',225,'0'),
(46,19,'单元测试','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',230,'0'),
(47,19,'交叉单元测试','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',235,'0'),
(48,19,'系统集成','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',240,'0'),
(49,19,'编写集成测试用例','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',245,'0'),
(50,19,'评审集成测试用例','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',250,'0'),
(51,19,'集成测试','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',255,'0'),
(52,19,'缺陷管理','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',260,'0'),
(53,19,'编写支持文档','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',265,'0'),
(54,20,'制定《系统测试计划》','','','','','admin','2020-01-09 13:28:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',270,'0'),
(55,20,'评审《系统测试计划》','','','','','admin','2020-01-09 13:28:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',275,'0'),
(56,20,'编写《系统测试用例》','','','','','admin','2020-01-09 13:28:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',280,'0'),
(57,20,'评审《系统测试用例》','','','','','admin','2020-01-09 13:28:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',285,'0'),
(58,20,'执行系统测试','','','','','admin','2020-01-09 13:28:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',290,'0'),
(59,21,'验收准备','','','','','admin','2020-01-09 13:29:28','','0000-00-00 00:00:00','','0000-00-00 00:00:00',295,'0'),
(60,21,'产品打包','','','','','admin','2020-01-09 13:29:28','','0000-00-00 00:00:00','','0000-00-00 00:00:00',300,'0'),
(61,21,'内部培训','','','','','admin','2020-01-09 13:29:28','','0000-00-00 00:00:00','','0000-00-00 00:00:00',305,'0'),
(62,21,'现场安装调试','','','','','admin','2020-01-09 13:29:28','','0000-00-00 00:00:00','','0000-00-00 00:00:00',310,'0'),
(63,21,'用户使用培训','','','','','admin','2020-01-09 13:29:28','','0000-00-00 00:00:00','','0000-00-00 00:00:00',315,'0'),
(64,21,'试运行','','','','','admin','2020-01-09 13:29:28','','0000-00-00 00:00:00','','0000-00-00 00:00:00',320,'0'),
(65,21,'客户验收','','','','','admin','2020-01-09 13:29:28','','0000-00-00 00:00:00','','0000-00-00 00:00:00',325,'0'),
(66,22,'制定质量保证计划','','','','','admin','2020-01-09 13:38:58','','0000-00-00 00:00:00','','0000-00-00 00:00:00',330,'0'),
(67,22,'评审质量保证计划','','','','','admin','2020-01-09 13:38:58','','0000-00-00 00:00:00','','0000-00-00 00:00:00',335,'0'),
(68,22,'过程和产品质量检查','','','','','admin','2020-01-09 13:38:58','','0000-00-00 00:00:00','','0000-00-00 00:00:00',340,'0'),
(69,22,'问题跟踪处理','','','','','admin','2020-01-09 13:38:58','','0000-00-00 00:00:00','','0000-00-00 00:00:00',345,'0'),
(70,22,'质量保证总结报告','','','','','admin','2020-01-09 13:38:58','','0000-00-00 00:00:00','','0000-00-00 00:00:00',350,'0'),
(71,23,'组织及配置管理员移交工作','','','','','admin','2020-01-09 13:39:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',355,'0'),
(72,23,'制定《配置管理计划》','','','','','admin','2020-01-09 13:39:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',360,'0'),
(73,23,'建立和维护配置库','','','','','admin','2020-01-09 13:39:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',365,'0'),
(74,23,'配置项管理','','','','','admin','2020-01-09 13:39:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',370,'0'),
(75,23,'基线管理','','','','','admin','2020-01-09 13:39:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',375,'0'),
(76,23,'变更管理','','','','','admin','2020-01-09 13:39:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',380,'0'),
(77,23,'配置审计','','','','','admin','2020-01-09 13:39:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',385,'0'),
(78,24,'建立项目度量目标','','','','','admin','2020-01-09 13:40:05','','0000-00-00 00:00:00','','0000-00-00 00:00:00',390,'0'),
(79,24,'确定项目度量点','','','','','admin','2020-01-09 13:40:05','','0000-00-00 00:00:00','','0000-00-00 00:00:00',395,'0'),
(80,24,'制定度量分析计划','','','','','admin','2020-01-09 13:40:05','','0000-00-00 00:00:00','','0000-00-00 00:00:00',400,'0'),
(81,24,'收集和分析度量数据','','','','','admin','2020-01-09 13:40:05','','0000-00-00 00:00:00','','0000-00-00 00:00:00',405,'0'),
(82,24,'存储和通报度量分析结果','','','','','admin','2020-01-09 13:40:05','','0000-00-00 00:00:00','','0000-00-00 00:00:00',410,'0'),
(83,25,'原因分析与解决','','','','','admin','2020-01-09 13:40:15','','0000-00-00 00:00:00','','0000-00-00 00:00:00',415,'0'),
(84,26,'建立评估标准','','','','','admin','2020-01-09 13:40:35','','0000-00-00 00:00:00','','0000-00-00 00:00:00',420,'0'),
(85,26,'确定候选方案','','','','','admin','2020-01-09 13:40:35','','0000-00-00 00:00:00','','0000-00-00 00:00:00',425,'0'),
(86,26,'原因分析与解决','','','','','admin','2020-01-09 13:40:35','','0000-00-00 00:00:00','','0000-00-00 00:00:00',430,'0'),
(87,26,'确定评估方法','','','','','admin','2020-01-09 13:40:35','','0000-00-00 00:00:00','','0000-00-00 00:00:00',435,'0'),
(88,26,'评估候选方案','','','','','admin','2020-01-09 13:40:35','','0000-00-00 00:00:00','','0000-00-00 00:00:00',440,'0'),
(89,26,'做出决策','','','','','admin','2020-01-09 13:40:35','','0000-00-00 00:00:00','','0000-00-00 00:00:00',445,'0');

INSERT INTO `zt_zoutput` VALUES
(5,4,'《技术可行性分析报告》','','','','admin','2020-01-09 11:01:52','','0000-00-00 00:00:00',25,'0'),
(6,5,'《项目预算表》','','','','admin','2020-01-09 11:17:27','','0000-00-00 00:00:00',30,'0'),
(7,6,'《立项申请报告》','','','','admin','2020-01-09 11:17:50','','0000-00-00 00:00:00',35,'0'),
(8,7,'《项目投标书》','不涉及投标','','','admin','2020-01-09 11:18:12','','0000-00-00 00:00:00',40,'0'),
(9,8,'《项目估算报告》','','','','admin','2020-01-09 11:18:41','','0000-00-00 00:00:00',45,'0'),
(10,8,'《功能点估算》','','','','admin','2020-01-09 11:18:41','','0000-00-00 00:00:00',50,'0'),
(11,9,'《PDP说明》','','','','admin','2020-01-09 11:18:54','','0000-00-00 00:00:00',55,'0'),
(12,10,'《项目进度表》','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',60,'0'),
(13,10,'《项目计划》及其下属计划','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',65,'0'),
(14,10,'《风险管理计划及跟踪表》','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',70,'0'),
(15,10,'《项目资源计划》','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',75,'0'),
(16,10,'《干系人计划》','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',80,'0'),
(17,10,'《同行评审计划》','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',85,'0'),
(18,10,'《质量保证计划》','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',90,'0'),
(19,10,'《配置管理计划》','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',95,'0'),
(20,11,'《同行评审通知》','','','','admin','2020-01-09 11:20:16','','0000-00-00 00:00:00',100,'0'),
(21,11,'《评审准备表》','','','','admin','2020-01-09 11:20:16','','0000-00-00 00:00:00',105,'0'),
(22,11,'《同行评审报告》','','','','admin','2020-01-09 11:20:17','','0000-00-00 00:00:00',110,'0'),
(23,12,'《里程碑报告》','','yes','','admin','2020-01-09 13:44:11','','0000-00-00 00:00:00',115,'0'),
(24,12,'《项目周报》','','yes','','admin','2020-01-09 13:44:11','','0000-00-00 00:00:00',120,'0'),
(25,13,'《项目周报》','','yes','','admin','2020-01-09 13:44:11','','0000-00-00 00:00:00',125,'0'),
(26,13,'《会议纪要》','','yes','','admin','2020-01-09 13:44:11','','0000-00-00 00:00:00',130,'0'),
(27,14,'《里程碑报告》','','yes','','admin','2020-01-09 13:44:11','','0000-00-00 00:00:00',135,'0'),
(28,14,'《里程碑会议纪要》','','yes','','admin','2020-01-09 13:44:11','','0000-00-00 00:00:00',140,'0'),
(29,15,'《计划变更申请》','','no','','admin','2020-01-09 13:44:11','','0000-00-00 00:00:00',145,'0'),
(30,16,'《风险管理计划及跟踪表》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',150,'0'),
(31,17,'《风险管理计划及跟踪表》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',155,'0'),
(32,17,'《风险管理报告》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',160,'0'),
(33,18,'《风险管理计划及跟踪表》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',165,'0'),
(34,19,'《异常处理申请表》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',170,'0'),
(35,19,'《风险管理计划及跟踪表》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',175,'0'),
(36,20,'《风险管理报告》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',180,'0'),
(37,20,'《风险管理计划及跟踪表》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',185,'0'),
(38,21,'《风险列表库》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',190,'0'),
(39,22,'《代码复用总结》','','','','admin','2020-01-09 13:46:26','','0000-00-00 00:00:00',195,'0'),
(40,24,'《结项报告》','','','','admin','2020-01-09 13:46:26','','0000-00-00 00:00:00',200,'0'),
(41,26,'《量化项目管理及跟踪计划》','','yes','','admin','2020-01-09 13:46:46','','0000-00-00 00:00:00',205,'0'),
(42,27,'《用户需求调查单》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',210,'0'),
(43,27,'《用户需求说明书》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',215,'0'),
(44,28,'《评审通知》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',220,'0'),
(45,28,'《同行评审准备表》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',225,'0'),
(46,28,'《同行评审报告》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',230,'0'),
(47,29,'《产品需求规格说明书》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',235,'0'),
(48,30,'《评审通知》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',240,'0'),
(49,30,' 《同行评审准备表》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',245,'0'),
(50,30,' 《同行评审报告》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',250,'0'),
(51,31,'《需求变更记录》','','','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',255,'0'),
(52,31,'《用户需求说明书》','','','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',260,'0'),
(53,31,'《软件需求规格说明书》','','','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',265,'0'),
(54,32,'《概要设计说明书》','','yes','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',270,'0'),
(55,33,'《评审通知》','','yes','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',275,'0'),
(56,33,'《同行评审准备表》','','yes','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',280,'0'),
(57,33,'《同行评审报告》','','yes','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',285,'0'),
(58,34,'《模块设计说明书》','','no','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',290,'0'),
(59,34,'《数据库设计说明书》','','yes','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',295,'0'),
(60,34,'《用户界面设计说明书》','','no','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',300,'0'),
(61,35,'《评审通知》','','no','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',305,'0'),
(62,35,'《同行评审准备表》','','no','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',310,'0'),
(63,35,'《同行评审报告》','','no','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',315,'0'),
(64,42,'《实现与测试计划》','','yes','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',320,'0'),
(65,42,'《单板硬件调试和单元测试计划》','','yes','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',325,'0'),
(66,42,'《项目进度表》中“实现与测试”部分','','yes','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',330,'0'),
(67,43,'产品数据库','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',335,'0'),
(68,44,'模块代码','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',340,'0'),
(69,45,'《代码质量检查记录单》','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',345,'0'),
(70,46,'《单元测试缺陷统计分析报告》','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',350,'0'),
(71,47,'bugzilla缺陷记录','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',355,'0'),
(72,48,'《系统集成说明书》','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',360,'0'),
(73,49,'《集成测试用例》','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',365,'0'),
(74,50,'《评审通知》 ','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',370,'0'),
(75,50,'《同行评审准备表》 ','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',375,'0'),
(76,50,'《同行评审报告》','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',380,'0'),
(77,51,'《集成测试报告》','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',385,'0'),
(78,52,'bugzilla缺陷记录','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',390,'0'),
(79,52,'《用户操作手册》 ','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',395,'0'),
(80,52,'《安装手册》','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',400,'0'),
(81,54,'《系统测试计划》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',405,'0'),
(82,55,'《评审通知》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',410,'0'),
(83,55,'《同行评审准备表》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',415,'0'),
(84,55,'《同行评审报告》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',420,'0'),
(85,56,'《系统测试用例》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',425,'0'),
(86,57,'《评审通知》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',430,'0'),
(87,57,'《同行评审准备表》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',435,'0'),
(88,57,'《同行评审报告》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',440,'0'),
(89,58,'bugzilla缺陷跟踪系统记录项','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',445,'0'),
(90,58,'《系统测试分析报告》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',450,'0'),
(91,58,'《缺陷统计分析报告》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',455,'0'),
(92,59,'《产品打包清单》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',460,'0'),
(93,60,'发布光盘、纸质支持文档','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',465,'0'),
(94,61,'《交接签收单》','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',470,'0'),
(95,62,'《工作联系单》','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',475,'0'),
(96,62,'《工作记录单》','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',480,'0'),
(97,62,'《交接签收单》','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',485,'0'),
(98,62,'《安装调试信息》','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',490,'0'),
(99,64,'bugzilla缺陷记录项','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',495,'0'),
(100,64,'会议纪要等文档','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',500,'0'),
(101,65,'《交接验收单》','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',505,'0'),
(102,65,'《客户验收报告》','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',510,'0'),
(103,66,'初步《质量保证计划及跟踪表》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',515,'0'),
(104,67,'详细《质量保证计划及跟踪表》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',520,'0'),
(105,68,'《过程审计检查表》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',525,'0'),
(106,68,'《产品审计检查表》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',530,'0'),
(107,68,'《QA审计报告》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',535,'0'),
(108,68,'《QA问题报告》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',540,'0'),
(109,68,'《QA里程碑报告》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',545,'0'),
(110,68,'《QA周报》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',550,'0'),
(111,69,'《QA审计报告》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',555,'0'),
(112,69,'《QA问题报告》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',560,'0'),
(113,70,'《QA总结报告》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',565,'0'),
(114,72,'《配置管理计划》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',570,'0'),
(115,72,'《配置项计划及跟踪表》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',575,'0'),
(116,72,'《基线计划及跟踪表》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',580,'0'),
(117,73,'《配置库管理报告》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',585,'0'),
(118,74,'《配置项计划及跟踪表》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',590,'0'),
(119,75,'《基线计划及跟踪表》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',595,'0'),
(120,76,'《变更申请书》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',600,'0'),
(121,77,'《配置审计报告》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',605,'0'),
(122,80,'《度量分析计划》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',610,'0'),
(123,82,'项目度量数据库','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',615,'0'),
(124,86,'《量化项目管理及跟踪计划》','','no','','admin','2020-01-09 14:59:04','','0000-00-00 00:00:00',620,'0'),
(125,84,'《决策分析报告》的决策分析评估表','','no','','admin','2020-01-09 14:59:04','','0000-00-00 00:00:00',625,'0'),
(126,83,'《量化项目计划及跟踪表》','','no','','admin','2020-01-09 14:59:04','','0000-00-00 00:00:00',630,'0'),
(127,87,'《决策分析报告》的评分表','','no','','admin','2020-01-09 14:59:04','','0000-00-00 00:00:00',635,'0'),
(128,88,'《决策分析报告》的评分表','','no','','admin','2020-01-09 14:59:04','','0000-00-00 00:00:00',640,'0'),
(129,89,'《决策分析报告》','','no','','admin','2020-01-09 14:59:04','','0000-00-00 00:00:00',645,'0');

INSERT INTO `zt_basicmeas` VALUES
(2,'scale','project','userRequest','项目用户需求初始规模','pgmURInitScale','故事点或功能点','CREATE FUNCTION qc_pgmurinitscale($project int) returns float (10,2)\r\nbegin\r\n    declare scale float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'URS\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_initscale($project, \'URS\',\'requestEst\') into scale__DELIMITER__\r\n    return scale__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nend','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目每个产品的第一个用户需求规格说明书基线版本的规模之和','从基线表中查询该项目下面每个产品的第一个用户需求规模说明书版本，然后查询对应的需求，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 14:19:41',10,'0'),
(3,'scale','project','softRequest','项目软件需求初始规模','pgmSRInitScale','故事点或功能点','CREATE FUNCTION qc_pgmsrinitscale($project int) returns float (10,2)\r\nbegin\r\n    declare scale float (10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'SRS\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_initscale($project, \'SRS\',\'storyEst\') into scale __DELIMITER__\r\n    return scale __DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nend','{\"$project\":{\"showName\":\"\\u6240\\u9700\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目每个产品的第一个软件需求规格说明书基线版本的规模之和','从基线表中查询该项目下面每个产品的第一个软件需求规模说明书版本，然后查询对应的需求，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 14:21:53',15,'0'),
(4,'scale','project','userRequest','项目用户需求实时规模','pgmURRealScale','故事点或功能点','CREATE FUNCTION `qc_pgmurrealscale`($project int) RETURNS float (10,2)\r\nBEGIN\r\n  declare totalEstimate float(10,2) default 0__DELIMITER__\r\n  select CAST(sum(estimate) as DECIMAL(10,2)) as estimate from zt_story where project=$project and type=\'requirement\' and deleted=\'0\' and closedReason not in (\'subdivided\', \'duplicate\', \'willnotdo\', \'cancel\', \'bydesign\') into totalEstimate__DELIMITER__\r\n  return totalEstimate__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目用户需求实际的规模','从需求表中查询该项目下的所有用户需求，对规模进行求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 14:22:17',20,'0'),
(5,'scale','project','softRequest','项目软件需求实时规模','pgmSRRealScale','故事点或功能点','CREATE FUNCTION `qc_pgmsrrealscale`($project int) RETURNS float (10,2)\r\nBEGIN\r\n  declare totalEstimate float (10,2) default 0__DELIMITER__\r\n  select CAST(sum(estimate) as DECIMAL(10,2)) as estimate from zt_story where project=$project and type=\'story\' and deleted=\'0\' and closedReason not in (\'subdivided\', \'duplicate\', \'willnotdo\', \'cancel\', \'bydesign\') into totalEstimate__DELIMITER__\r\n  return totalEstimate__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目软件需求实际的规模','从需求表中查询该项目下的所有软件需求，对规模进行求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 14:28:01',25,'0'),
(6,'scale','project','program','项目估算规模','pgmPlanScale','故事点或功能点','CREATE FUNCTION `qc_pgmplanscale`($project int) RETURNS float (10,2)\r\nBEGIN\r\n   declare programScale float (10,2) default 0__DELIMITER__\r\n   select `scale` from zt_workestimation where project = $project into programScale__DELIMITER__\r\n   return programScale__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目最初估算时估计的规模','从项目估算表里面查询项目的估算规模。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 14:26:01',30,'0'),
(8,'duration','project','stage','项目需求阶段计划天数','pgmRequestPlanDays','天','CREATE FUNCTION `qc_pgmrequestplandays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeplanneddays($project,\'request\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有需求阶段计划天数的和','从阶段表里面统计该项目下面所有类型为需求的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',40,'0'),
(9,'duration','project','stage','项目设计阶段计划天数','pgmDesigntPlanDays','天','CREATE FUNCTION `qc_pgmdesigntplandays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeplanneddays($project,\'design\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有设计阶段计划天数的和','从阶段表里面统计该项目下面所有类型为设计的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',45,'0'),
(10,'duration','project','stage','项目开发阶段计划天数','pgmDevelPlanDays','天','CREATE FUNCTION `qc_pgmdevelplandays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeplanneddays($project,\'dev\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有研发阶段计划天数的和','从阶段表里面统计该项目下面所有类型为开发的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',50,'0'),
(11,'duration','project','stage','项目测试阶段计划天数','pgmTestPlanDays','天','CREATE FUNCTION `qc_pgmtestplandays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeplanneddays($project,\'qa\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有测试阶段计划天数的和','从阶段表里面统计该项目下面所有类型为测试的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',55,'0'),
(12,'duration','project','stage','项目需求阶段实际天数','pgmRequestRealDays','天','CREATE FUNCTION `qc_pgmrequestrealdays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeactualdays($project,\'request\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有需求阶段实际天数的和','从阶段表里面统计该项目下面所有类型为需求的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',60,'0'),
(13,'duration','project','stage','项目设计阶段实际天数','pgmDesigntRealDays','天','CREATE FUNCTION `qc_pgmdesigntrealdays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeactualdays($project,\'design\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有设计阶段实际天数的和','从阶段表里面统计该项目下面所有类型为设计的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',65,'0'),
(14,'duration','project','stage','项目开发阶段实际天数','pgmDevelRealDays','天','CREATE FUNCTION `qc_pgmdevelrealdays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeactualdays($project,\'dev\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有研发阶段实际天数的和','从阶段表里面统计该项目下面所有类型为开发的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',70,'0'),
(15,'duration','project','stage','项目测试阶段实际天数','pgmTestRealDays','天','CREATE FUNCTION `qc_pgmtestrealdays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeactualdays($project,\'qa\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"3\"}}','项目下面所有测试阶段实际天数的和','从阶段表里面统计该项目下面所有类型为测试的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',75,'0'),
(26,'duration','product','stage','分产品需求阶段计划天数','prdRequestPlanDays','天','CREATE FUNCTION `qc_prdrequestplandays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageplannedduration($product, \'request\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"\"}}','产品下面所有需求阶段计划天数的和','从阶段表里面统计该产品在该项目下所有类型为需求的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',130,'0'),
(27,'duration','product','stage','分产品设计阶段计划天数','prdDesigntPlanDays','天','CREATE FUNCTION `qc_prddesigntplandays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageplannedduration($product, \'design\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"\"}}','产品下面所有设计阶段计划天数的和','从阶段表里面统计该产品在该项目下所有类型为设计的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',135,'0'),
(28,'duration','product','stage','分产品开发阶段计划天数','prdDevelPlanDays','天','CREATE FUNCTION `qc_prddevelplandays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageplannedduration($product, \'dev\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"1\"}}','产品下面所有研发阶段计划天数的和','从阶段表里面统计该产品在该项目下所有类型为开发的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',140,'0'),
(29,'duration','product','stage','分产品测试阶段计划天数','prdTestPlanDays','天','CREATE FUNCTION `qc_prdtestplandays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageplannedduration($product, \'qa\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"\"}}','产品下面所有测试阶段计划天数的和','从阶段表里面统计该产品在该项目下所有类型为测试的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',145,'0'),
(30,'duration','product','stage','分产品需求阶段实际天数','prdRequestRealDays','天','CREATE FUNCTION `qc_prdrequestrealdays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageactualduration($product,\'request\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"\"}}','产品下面所有需求阶段实际天数的和','从阶段表里面统计该产品在该项目下所有类型为需求的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',150,'0'),
(31,'duration','product','stage','分产品设计阶段实际天数','prdDesigntRealDays','天','CREATE FUNCTION `qc_prddesigntrealdays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageactualduration($product, \'design\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"\"}}','产品下面所有设计阶段实际天数的和','从阶段表里面统计该产品在该项目下所有类型为设计的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',155,'0'),
(32,'duration','product','stage','分产品开发阶段实际天数','prdDevelRealDays','天','CREATE FUNCTION `qc_prddevelrealdays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageactualduration($product, \'dev\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"\"}}','产品下面所有研发阶段实际天数的和','从阶段表里面统计该产品在该项目下所有类型为开发的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',160,'0'),
(33,'duration','product','stage','分产品测试阶段实际天数','prdTestRealDays','天','CREATE FUNCTION `qc_prdtestrealdays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageactualduration($product, \'qa\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"1\"}}','产品下面所有测试阶段实际天数的和','从阶段表里面统计该产品在该项目下所有类型为测试的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',165,'0'),
(34,'workload','project','finance','项目任务实时预计工时数','pgmRealEstHours','小时','CREATE FUNCTION `qc_pgmrealesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    select sum(estimate) from zt_task where project=$project and parent >= 0 and status != \'cancel\' and deleted = \'0\' into @estimate__DELIMITER__\r\nreturn @estimate__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有任务的最初预计工时和','从任务表中查询该项目的所有任务，统计最初预计工>时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 19:51:39',170,'0'),
(35,'workload','project','finance','项目需求工作实时总预计工时数','pgmRequestRealEstHours','小时','CREATE FUNCTION `qc_pgmrequestrealesthours`($project int) RETURNS float (10,2)\r\nBEGIN\r\nreturn qc_pgmesthoursbytype($project, \'request\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有需求相关任务的最初预计工时和','从任务表中查询该项目所有任务类型为需求的任务，统计最初预计工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-23 13:49:17',175,'0'),
(36,'workload','project','finance','项目设计工作实时总预计工时数','pgmDesgignRealEstHours','小时','CREATE FUNCTION `qc_pgmdesgignrealesthours`($project int) RETURNS float (10,2)\r\nBEGIN\r\nreturn qc_pgmesthoursbytype($project, \'design\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有设计相关任务的最初预计工时和','从任务表中查询该项目所有任务类型为设计的任务，统计最初预计工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-23 13:45:32',180,'0'),
(37,'workload','project','finance','项目开发工作实时总预计工时数','pgmDevelRealEstHours','小时','CREATE FUNCTION `qc_pgmdevelrealesthours`($project int) RETURNS float (10,2)\r\nBEGIN\r\nreturn qc_pgmesthoursbytype($project, \'devel\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有开发相关任务的最初预计工时和','从任务表中查询该项目所有任务类型为开发的任务，统计最初预计工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-23 13:46:53',185,'0'),
(38,'workload','project','finance','项目测试工作实时总预计工时数','pgmTestRealEstHours','小时','CREATE FUNCTION `qc_pgmtestrealesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\nreturn qc_pgmesthoursbytype($project, \'test\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有测试相关任务的最初预计工时和','从任务表中查询该项目所有任务类型为测试的任务，统计最初预计工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-23 13:44:13',190,'0'),
(39,'workload','project','finance','项目任务实际消耗工时数','pgmRealHours','小时','CREATE FUNCTION `qc_pgmrealhours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n  select CAST(sum(consumed) as DECIMAL(10,2)) as consumed from zt_task where project=$project and parent >= 0 and status != \'cancel\' and deleted = \'0\'  into @consumed__DELIMITER__\r\n  return @consumed__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有任务的实际消耗工时和','从任务表中查询该项目的所有任务，统计实际消耗工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 19:49:32',195,'0'),
(40,'workload','project','finance','项目需求工作实际消耗工时数','pgmRequestRealHours','小时','CREATE FUNCTION `qc_pgmrequestrealhours`($project int) RETURNS float(10,2)\r\nBEGIN\r\nreturn qc_pgmrealhoursbytype($project, \'request\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有需求相关任务的实际消耗工时和','从任务表中查询该项目所有任务类型为需求的任务，统计实际消耗工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 19:49:03',200,'0'),
(41,'workload','project','finance','项目设计工作实际消耗工时数','pgmDesignRealHours','小时','CREATE FUNCTION `qc_pgmdesignrealhours`($project int) RETURNS float(10,2)\r\nBEGIN\r\nreturn qc_pgmrealhoursbytype($project, \'design\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有设计相关任务的实际消耗工时和','从任务表中查询该项目所有任务类型为设计的任务，统计实际消耗工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 19:48:35',205,'0'),
(42,'workload','project','finance','项目开发工作实际消耗工时数','pgmDevelRealHours','小时','CREATE FUNCTION `qc_pgmdevelrealhours`($project int) RETURNS float(10,2)\r\nBEGIN\r\nreturn qc_pgmrealhoursbytype($project, \'devel\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有开发相关任务的实际消耗工时和','从任务表中查询该项目所有任务类型为开发的任务，统计实际消耗工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 18:34:51',210,'0'),
(43,'workload','project','finance','项目测试工作实际消耗工时数','pgmTestRealHours','小时','CREATE FUNCTION `qc_pgmtestrealhours`($project int) RETURNS float(10, 2)\r\nBEGIN\r\nreturn qc_pgmrealhoursbytype($project, \'test\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有测试相关任务的实际消耗工时和','从任务表中查询该项目所有任务类型为测试的任务，统计实际消耗工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 18:09:01',215,'0'),
(44,'workload','project','finance','项目开发工作最初总预计工时数','pgmDevelFirstEstHours','小时','CREATE FUNCTION `qc_pgmdevelfirstesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getdevelfirstesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划第一个基线版本中所有开发相关工作最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-22 13:13:51','','0000-00-00 00:00:00',220,'0'),
(45,'workload','project','finance','项目设计工作最初总预计工时数','pgmDesignFirstEstHours','小时','CREATE FUNCTION `qc_pgmdesignfirstesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getdesignfirstesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划第一个基线版本中所有设计相关工作最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-22 16:33:20','admin','2020-07-23 10:31:23',225,'0'),
(46,'workload','project','finance','项目测试工作最初总预计工时数','pgmTestFirstEstHours','小时','CREATE FUNCTION `qc_pgmtestfirstesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_gettestfirstesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划第一个基线版本中所有测试相关工作最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 10:31:17','','0000-00-00 00:00:00',230,'0'),
(47,'workload','project','finance','项目需求工作最初总预计工时数','pgmRequestFirstEstHours','小时','CREATE FUNCTION `qc_pgmrequestfirstesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getstoryfirstesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划第一个基线版本中所有需求相关工作最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 10:53:09','','0000-00-00 00:00:00',235,'0'),
(48,'workload','project','finance','项目任务最初总预计工时数','pgmFirstEstHours','小时','CREATE FUNCTION `qc_pgmfirstesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getfirstesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划第一个基线版本中所有任务最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 13:06:59','','0000-00-00 00:00:00',240,'0'),
(49,'workload','project','finance','项目开发工作最终总预计工时数','pgmDevelLastEstHours','小时','CREATE FUNCTION `qc_pgmdevellastesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getdevlastesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划最后一个基线版本中所有开发相关任务最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 13:41:38','','0000-00-00 00:00:00',245,'0'),
(50,'workload','project','finance','项目需求工作最终总预计工时数','pgmRequestLastEstHours','小时','CREATE FUNCTION `qc_pgmrequestlastesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project,\'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getrequestlastesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划最后一个基线版本中所有需求相关任务最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 14:00:58','','0000-00-00 00:00:00',250,'0'),
(51,'workload','project','finance','项目测试工作最终总预计工时数','pgmTestLastEstHours','小时','CREATE FUNCTION `qc_pgmtestlastesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project,\'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_gettestlastesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划最后一个基线版本中所有测试相关任务最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 14:10:12','','0000-00-00 00:00:00',255,'0'),
(52,'workload','project','finance','项目设计工作最终总预计工时数','pgmDesignLastEstHours','小时','CREATE FUNCTION `qc_pgmdesignlastesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project,\'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getdesignlastesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划最后一个基线版本中所有设计相关任务最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 14:33:00','','0000-00-00 00:00:00',260,'0'),
(53,'workload','project','finance','项目任务最终总预计工时数','pgmLastEstHours','小时','CREATE FUNCTION `qc_pgmlastesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project,\'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getlastesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划最后一个基线版本中所有任务最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 14:54:42','','0000-00-00 00:00:00',265,'0');

INSERT INTO `zt_cron` (`m`, `h`, `dom`, `mon`, `dow`, `command`, `remark`, `type`, `buildin`, `status`, `lastTime`) VALUES
('1','0','*','*','*','moduleName=weekly&methodName=computeWeekly','更新项目周报','system',0,'normal','2020-08-27 10:07:53'),
('1','0','*','*','*','moduleName=measurement&methodName=initCrontabQueue','初始化度量队列','zentao',0,'normal','2020-07-07 14:51:48'),
('*/5','*','*','*','*','moduleName=measurement&methodName=execCrontabQueue','执行度量队列','zentao',0,'running','2020-07-10 13:10:58');
-- DROP TABLE IF EXISTS `zt_sqlview`;
CREATE TABLE IF NOT EXISTS `zt_sqlview` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` varchar(90) NOT NULL,
  `code` varchar(45) NOT NULL,
  `sql` text NOT NULL,
  `desc` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SET global log_bin_trust_function_creators = 1;
SET global sql_mode = '';
USE __TABLE__;

CREATE FUNCTION `get_monday`(day date) RETURNS date
  begin if date_format(day, '%w') = 0 then return subdate(day, date_format(day, '%w') - 6)__DELIMITER__
  else  return subdate(day, date_format(day, '%w') -1)__DELIMITER__
  end if__DELIMITER__
END;

CREATE FUNCTION `get_sunday`(day date) RETURNS date
begin
  if date_format(day, '%w') = 0 then return day__DELIMITER__
  else return subdate(day, date_format(day, '%w') - 7)__DELIMITER__
  end if__DELIMITER__
END;

CREATE FUNCTION qc_cminited($project int, $category varchar(30)) returns int
begin
    declare products int default 0__DELIMITER__
    declare objects  int default 0__DELIMITER__
    select count(*) from zt_projectproduct where project = $project into products__DELIMITER__
    select count(distinct product) from zt_object where project = $project and category = $category and type = 'taged' and product in (select product from zt_projectproduct where project = $project) into objects__DELIMITER__
    IF products = objects THEN
    return 1__DELIMITER__
    ELSEIF products != objects THEN
    return 0__DELIMITER__
    END IF__DELIMITER__
END;

CREATE FUNCTION qc_initscale($project int, $category varchar(30), $estimateType varchar(30)) RETURNS float(10,2)
BEGIN
    declare $estimate int default 0__DELIMITER__
    declare $storyEst varchar(30) default 'storyEst'__DELIMITER__
    declare $requestEst varchar(30) default 'requestEst'__DELIMITER__
    if($estimateType = $storyEst) THEN SELECT sum(storyEst) as estimate FROM zt_object WHERE id in(SELECT MIN(id) FROM zt_object WHERE project = $project and category = $category and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__
    end if__DELIMITER__
    if($estimateType = $requestEst) THEN SELECT sum(requestEst) as estimate FROM zt_object WHERE id in(SELECT MIN(id) FROM zt_object WHERE project = $project and category = $category and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__
    end if__DELIMITER__
    RETURN @estimate__DELIMITER__
END;

CREATE FUNCTION `qc_pgmplanscale`($project int) RETURNS float(10,2)
BEGIN
   declare programScale float (10,2) default 0__DELIMITER__
   select `scale` from zt_workestimation where project = $project into @programScale__DELIMITER__
   return @programScale__DELIMITER__
END;

CREATE FUNCTION `qc_pgmsrinitscale`($project int) RETURNS float(10,2)
begin
    declare scale int default 0__DELIMITER__
    declare inited int default 0__DELIMITER__
    select qc_cminited($project, 'SRS') into inited__DELIMITER__
    IF inited = 1 THEN
    select qc_initscale($project, 'SRS', 'storyEst') into scale __DELIMITER__
    return scale __DELIMITER__
    ELSE
    return 0__DELIMITER__
    END IF__DELIMITER__
END;

CREATE FUNCTION `qc_pgmsrrealscale`($project int) RETURNS float(10,2)
BEGIN
  declare totalEstimate float(10,2) default 0__DELIMITER__
  select CAST(sum(estimate) as DECIMAL(10,2)) as estimate from zt_story where project=$project and type='story' and deleted='0' and closedReason not in ('subdivided', 'duplicate', 'willnotdo', 'cancel', 'bydesign') into totalEstimate__DELIMITER__
  return totalEstimate__DELIMITER__
END;

CREATE FUNCTION `qc_pgmurinitscale`($project int) RETURNS float(10,2)
begin
    declare scale int default 0__DELIMITER__
    declare inited int default 0__DELIMITER__
    select qc_cminited($project, 'URS') into inited__DELIMITER__
    IF inited = 1 THEN
    select qc_initscale($project, 'URS', 'requestEst') into scale__DELIMITER__
    return scale__DELIMITER__
    ELSE
    return 0__DELIMITER__
    END IF__DELIMITER__
END;

CREATE FUNCTION `qc_pgmurrealscale`($project int) RETURNS float(10,2)
BEGIN
  declare totalEstimate float(10,2) default 0__DELIMITER__
  select CAST(sum(estimate) as DECIMAL(10,2)) as estimate from zt_story where project=$project and type='requirement' and deleted='0' and closedReason not in ('subdivided', 'duplicate', 'willnotdo', 'cancel', 'bydesign') into totalEstimate__DELIMITER__
  return totalEstimate__DELIMITER__
END;

CREATE FUNCTION `qc_pgmallrequirementstage`($project int) RETURNS int(1)
BEGIN
    -- 获取项目产品总数
    select count(*) as products from zt_projectproduct where project = $project into @totalproduct__DELIMITER__
    -- 获取已经设置需求阶段的产品总数
    select count(*) as product from (select product from zt_projectproduct where project in (select id from zt_project where project = $project and type = 'stage' and attribute = 'request' and deleted = '0') GROUP BY product) as product into @product__DELIMITER__
    -- 让项目产品总数和已设置需求阶段产品总数比较,都设置返回1,否则返回0
    if @totalproduct = @product then return 1__DELIMITER__
    end if__DELIMITER__
    RETURN 0__DELIMITER__
END;

CREATE FUNCTION `qc_pgmdesigntplandays`($project int) RETURNS int(10)
BEGIN
    select qc_pgmspecifiedtypeplanneddays($project,'design') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

CREATE FUNCTION `qc_pgmdesigntrealdays`($project int) RETURNS int(10)
BEGIN
    select qc_pgmspecifiedtypeactualdays($project,'design') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

CREATE FUNCTION `qc_pgmdevelplandays`($project int) RETURNS int(10)
BEGIN
    select qc_pgmspecifiedtypeplanneddays($project,'dev') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

CREATE FUNCTION `qc_pgmdevelrealdays`($project int) RETURNS int(10)
BEGIN
    select qc_pgmspecifiedtypeactualdays($project,'dev') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

CREATE FUNCTION `qc_pgmrequestplandays`($project int) RETURNS int(10)
BEGIN
    select qc_pgmspecifiedtypeplanneddays($project,'request') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

CREATE FUNCTION `qc_pgmrequestrealdays`($project int) RETURNS int(10)
BEGIN
    select qc_pgmspecifiedtypeactualdays($project,'request') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

CREATE FUNCTION `qc_pgmspecifiedtypeactualdays`($project int,$attribute varchar(50)) RETURNS int(10)
BEGIN
    -- 查询某类型的阶段总数
    select count(*) from zt_project where project = $project and attribute = $attribute and deleted = '0' and id not in (select parent from zt_project where project = $project and attribute = $attribute and grade = 2 group by parent) into @totalstory__DELIMITER__
    -- 查询某类型已设置实际工期的阶段总数
    select count(*) from zt_project where project = $project and attribute = $attribute and deleted = '0' and realDuration > 0 and id not in (select parent from zt_project where project = $project and attribute = $attribute and grade = 2 group by parent) into @setstory__DELIMITER__
    -- 查询项目下某类型阶段实际工期总数
    select sum(realDuration) as realDuration from zt_project where project = $project and attribute = $attribute and deleted = '0' and realDuration > 0 and id not in (select parent from zt_project where project = $project and attribute = $attribute and grade = 2 group by parent) into @days__DELIMITER__
    -- 判断项目下某类型的阶段是否都已设置实际工期
    if @totalstory != @setstory then
        set @days = 0__DELIMITER__
    end if__DELIMITER__
    return @days__DELIMITER__
END;

CREATE FUNCTION `qc_pgmspecifiedtypeplanneddays`($project int,$attribute varchar(50)) RETURNS int(10)
BEGIN
    select sum(planDuration) as planDuration from zt_project where project = $project and attribute = $attribute and deleted = '0' and id not in (select parent from zt_project where project = $project and attribute = $attribute and grade = 2 group by parent) into @days__DELIMITER__
    return @days__DELIMITER__
END;

CREATE FUNCTION `qc_pgmstageactualduration`($product int, $attribute varchar(50)) RETURNS int(10)
BEGIN
    -- 查找某类型的阶段总数
    select count(*) as totalduration from zt_project where id in (select project from zt_projectproduct where product = $product) and type = 'stage' and attribute = $attribute and deleted = '0' and id not in (select parent from zt_project where id in (select project from zt_projectproduct where product = $product) and attribute = $attribute and grade = 2 group by parent) into @totalduration__DELIMITER__
    -- 查某类型阶段已设置实际工期的总数
    select count(*) as setduration from zt_project where id in (select project from zt_projectproduct where product = $product) and type = 'stage' and attribute = $attribute and deleted = '0' and id not in (select parent from zt_project where id in (select project from zt_projectproduct where product = $product) and attribute = $attribute and grade = 2 group by parent) and realDuration > 0 into @setduration__DELIMITER__
    -- 指定产品下某类型的阶段实际工期总和
    select sum(realDuration) as duration from zt_project where id in (select project from zt_projectproduct where product = $product) and type = 'stage' and attribute = $attribute and deleted = '0' and id not in (select parent from zt_project where id in (select project from zt_projectproduct where product = $product) and attribute = $attribute and grade = 2 group by parent) and realDuration > 0 into @duration__DELIMITER__
    -- 需要判断该类型阶段都已设置实际工期,否则不统计
    if @totalduration != @setduration then
        set @duration = 0__DELIMITER__
    end if__DELIMITER__
    return @duration__DELIMITER__
END;

CREATE FUNCTION `qc_pgmstageplannedduration`($product int, $attribute varchar(50)) RETURNS int(10)
BEGIN
    -- 查找某产品对应阶段
    select sum(planDuration) as duration from zt_project where id in (select project from zt_projectproduct where product = $product) and attribute = $attribute and deleted = '0' and id not in (select parent from zt_project where id in (select project from zt_projectproduct where product = $product) and attribute = $attribute and grade = 2 group by parent) and planDuration > 0 into @duration__DELIMITER__
    RETURN @duration__DELIMITER__
END;

CREATE FUNCTION `qc_pgmtestplandays`($project int) RETURNS int(10)
BEGIN
    select qc_pgmspecifiedtypeplanneddays($project,'qa') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

CREATE FUNCTION `qc_pgmtestrealdays`($project int) RETURNS int(10)
BEGIN
    select qc_pgmspecifiedtypeactualdays($project,'qa') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

CREATE FUNCTION `qc_prddesigntplandays`($project int, $product int) RETURNS int(10)
BEGIN
    select qc_pgmstageplannedduration($project, $product, 'design') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

CREATE FUNCTION `qc_prddesigntrealdays`($project int, $product int) RETURNS int(10)
BEGIN
    select qc_pgmstageactualduration($project, $product, 'design') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

CREATE FUNCTION `qc_prddevelplandays`($project int, $product int) RETURNS int(10)
BEGIN
    select qc_pgmstageplannedduration($project, $product, 'dev') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

CREATE FUNCTION `qc_prddevelrealdays`($project int, $product int) RETURNS int(10)
BEGIN
    select qc_pgmstageactualduration($project, $product, 'dev') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

CREATE FUNCTION `qc_prdrequestplandays`($project int, $product int) RETURNS int(10)
BEGIN
    select qc_pgmstageplannedduration($project, $product, 'request') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

CREATE FUNCTION `qc_prdrequestrealdays`($project int, $product int) RETURNS int(10)
BEGIN
    select qc_pgmstageactualduration($project, $product, 'request') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

CREATE FUNCTION `qc_prdtestplandays`($project int, $product int) RETURNS int(10)
BEGIN
    select qc_pgmstageplannedduration($project, $product, 'qa') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

CREATE FUNCTION `qc_prdtestrealdays`($project int, $product int) RETURNS int(10)
BEGIN
    select qc_pgmstageactualduration($project, $product, 'qa') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

CREATE FUNCTION `qc_pgmdesgignrealesthours`($project int) RETURNS float(10,2)
BEGIN
return qc_pgmesthoursbytype($project, 'design')__DELIMITER__
END;

CREATE FUNCTION `qc_pgmdesignrealhours`($project int) RETURNS float(10,2)
BEGIN
return qc_pgmrealhoursbytype($project, 'design')__DELIMITER__
END;

CREATE FUNCTION `qc_pgmdevelrealesthours`($project int) RETURNS float(10,2)
BEGIN
return qc_pgmesthoursbytype($project, 'devel')__DELIMITER__
END;

CREATE FUNCTION `qc_pgmdevelrealhours`($project int) RETURNS float(10,2)
BEGIN
return qc_pgmrealhoursbytype($project, 'devel')__DELIMITER__
END;

CREATE FUNCTION `qc_pgmrealesthours`($project int) RETURNS float(10,2)
BEGIN
  select CAST(sum(estimate) as DECIMAL(10,2)) as estimate from zt_task where project=$project and parent >= 0 and status != 'cancel' and deleted = '0' into @estimate__DELIMITER__
  return @estimate__DELIMITER__
END;

CREATE FUNCTION `qc_pgmesthoursbytype`($project int, $type char(30)) RETURNS float(10,2)
BEGIN
  select CAST(sum(estimate) as DECIMAL(10,2)) as estimate from zt_task where project=$project and type = $type and parent >= 0 and status != 'cancel' and deleted = '0' into @estimate__DELIMITER__
  return @estimate__DELIMITER__
END;

CREATE FUNCTION `qc_pgmrealhours`($project int) RETURNS float(10,2)
BEGIN
  select CAST(sum(consumed) as DECIMAL(10,2)) as consumed from zt_task where project=$project and parent >= 0 and status != 'cancel' and deleted = '0' into @consumed__DELIMITER__
  return @consumed__DELIMITER__
END;

CREATE FUNCTION `qc_pgmrealhoursbytype`($project int, $type char(30)) RETURNS float(10,2)
BEGIN
  select CAST(sum(consumed) as DECIMAL(10,2)) as consumed from zt_task where project=$project and type = $type and parent >= 0 and status != 'cancel' and deleted = '0' into @consumed__DELIMITER__
  return @consumed__DELIMITER__
END;

CREATE FUNCTION `qc_pgmrequestrealesthours`($project int) RETURNS float(10,2)
BEGIN
return qc_pgmesthoursbytype($project, 'request')__DELIMITER__
END;

CREATE FUNCTION `qc_pgmrequestrealhours`($project int) RETURNS float(10,2)
BEGIN
return qc_pgmrealhoursbytype($project, 'request')__DELIMITER__
END;

CREATE FUNCTION `qc_pgmtestrealesthours`($project int) RETURNS float(10,2)
BEGIN
return qc_pgmesthoursbytype($project, 'test')__DELIMITER__
END;

CREATE FUNCTION `qc_pgmtestrealhours`($project int) RETURNS float(10,2)
BEGIN
return qc_pgmrealhoursbytype($project, 'test')__DELIMITER__
END;

CREATE FUNCTION `qc_getdevelfirstesthours`($project int) RETURNS float(10,2)
BEGIN
    SELECT sum(devEst) as estimate FROM zt_object WHERE id in(SELECT MIN(id) FROM zt_object WHERE project = $project and category = 'PP' and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__

    return @estimate__DELIMITER__
END;

CREATE FUNCTION `qc_getdesignfirstesthours`($project int) RETURNS float(10,2)
BEGIN
    SELECT sum(designEst) as estimate FROM zt_object WHERE id in(SELECT MIN(id) FROM zt_object WHERE project = $project and category = 'PP' and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__

    return @estimate__DELIMITER__
END;

CREATE FUNCTION `qc_getstoryfirstesthours`($project int) RETURNS float(10,2)
BEGIN
    SELECT sum(requestEst) as estimate FROM zt_object WHERE id in(SELECT MIN(id) FROM zt_object WHERE project = $project and category = 'PP' and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__

    return @estimate__DELIMITER__
END;

CREATE FUNCTION `qc_gettestfirstesthours`($project int) RETURNS float(10,2)
BEGIN
    SELECT sum(testEst) as estimate FROM zt_object WHERE id in(SELECT MIN(id) FROM zt_object WHERE project = $project and category = 'PP' and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__

    return @estimate__DELIMITER__
END;

CREATE FUNCTION `qc_getfirstesthours`($project int) RETURNS float(10,2)
BEGIN
    SELECT sum(taskEst) as estimate FROM zt_object WHERE id in(SELECT MIN(id) FROM zt_object WHERE project = $project and category = 'PP' and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__

    return @estimate__DELIMITER__
END;

CREATE FUNCTION `qc_getdevlastesthours`($project int) RETURNS float(10,2)
BEGIN
    SELECT sum(devEst) as estimate FROM zt_object WHERE id in(SELECT MAX(id) FROM zt_object WHERE project = $project and category = 'PP' and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__

    return @estimate__DELIMITER__
END;

CREATE FUNCTION `qc_getrequestlastesthours`($project int) RETURNS float(10,2)
BEGIN
    SELECT sum(requestEst) as estimate FROM zt_object WHERE id in(SELECT MAX(id) FROM zt_object WHERE project = $project and category = 'PP' and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__

    return @estimate__DELIMITER__
END;

CREATE FUNCTION `qc_gettestlastesthours`($project int) RETURNS float(10,2)
BEGIN
    SELECT sum(testEst) as estimate FROM zt_object WHERE id in(SELECT MAX(id) FROM zt_object WHERE project = $project and category = 'PP' and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__

    return @estimate__DELIMITER__
END;

CREATE FUNCTION `qc_getdesignlastesthours`($project int) RETURNS float(10,2)
BEGIN
    SELECT sum(designEst) as estimate FROM zt_object WHERE id in(SELECT MAX(id) FROM zt_object WHERE project = $project and category = 'PP' and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__

    return @estimate__DELIMITER__
END;

CREATE FUNCTION `qc_getlastesthours`($project int) RETURNS float(10,2)
BEGIN
    SELECT sum(taskEst) as estimate FROM zt_object WHERE id in(SELECT MAX(id) FROM zt_object WHERE project = $project and category = 'PP' and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__

    return @estimate__DELIMITER__
END;

CREATE FUNCTION `qc_pgmlastesthours`($project int) RETURNS float(10,2)
BEGIN
    declare estimate float(10,2) default 0__DELIMITER__
    declare inited int default 0__DELIMITER__
    select qc_cminited($project,'PP') into inited__DELIMITER__
    IF inited = 1 THEN
    select qc_getlastesthours($project) into estimate__DELIMITER__
    return estimate__DELIMITER__
    ELSE
    return 0__DELIMITER__
    END IF__DELIMITER__
END;
