window.productChange = function()
{
    const productID = $('input[name=product]').val();
    const type      = $('input[name=object]').val();
    const getNodesLink = $.createLink('review', 'ajaxGetNodes', `project=${projectID}&object=${type}&product=${productID}`);
    loadCurrentPage({url: getNodesLink, selector: '#reviewerBox', partial: true});
}

window.objectChange = function()
{
    const type  = $('input[name=object]').val();
    if(type == undefined) return;

    let title = type ? reviewText + objectList[type] : '';
    $('[data-name=title] input[name=title]').val(title);

    const content = $('input[name=content]:checked').val();

    if(type == 'PP')
    {
        $('input[name=content').closest('div.form-group').addClass('hidden');
        $('div.form-group[data-name=template]').addClass('hidden');
        $('div.form-group[data-name=doc]').addClass('hidden');
        $('div.form-group[data-name=doclib]').addClass('hidden');
    }
    else
    {
        $('input[name=content').closest('div.form-group').removeClass('hidden');
        $('div.form-group[data-name=doc]').removeClass('hidden');
        if(content == 'template')
        {
            $('div.form-group[data-name=template]').removeClass('hidden');
            $('div.form-group[data-name=doclib]').addClass('hidden');
        }
        else
        {
            $('div.form-group[data-name=template]').addClass('hidden');
            $('div.form-group[data-name=doclib]').removeClass('hidden');
        }
    }

    const productID    = $('input[name=product]').val();
    const getNodesLink = $.createLink('review', 'ajaxGetNodes', `project=${projectID}&object=${type}&product=${productID}`);
    loadCurrentPage({url: getNodesLink, selector: '#reviewerBox', partial: true});

    const getTemplatesLink = $.createLink('baseline', 'ajaxGetTemplates', 'type=' + type + '&from=review&contentType=&viewType=json');
    $.getJSON(getTemplatesLink, function(templateItems)
    {
        const templateID     = $('input[name=template]').val();
        const templatePicker = $('input[name=template]').zui('picker');

        templatePicker.render({items: templateItems});
        templatePicker.$.setValue(templateID);
    })
}

window.contentChange = function()
{
    const content = $('input[name=content]:checked').val();
    if(content == 'template')
    {
        templateChange();
        $('div.form-group[data-name=template]').removeClass('hidden');
        $('div.form-group[data-name=doclib]').addClass('hidden');
    }
    else
    {
        doclibChange();
        $('div.form-group[data-name=template]').addClass('hidden');
        $('div.form-group[data-name=doclib]').removeClass('hidden');
    }
}

window.templateChange = function()
{
    const templateID  = $('input[name=template]').val();
    const getDocsLink = $.createLink('baseline', 'ajaxGetDocs', `template=${templateID}&from=review&project=${projectID}&contentType=&viewType=json`);
    $.getJSON(getDocsLink, function(docItems)
    {
        const docID     = $('input[name=doc]').val();
        const docPicker = $('input[name=doc]').zui('picker');

        docPicker.render({items: docItems});
        docPicker.$.setValue(docID);
    })
}

window.doclibChange = function()
{
    const libID       = $('input[name=doclib]').val();
    const getDocsLink = $.createLink('doc', 'ajaxGetDocs', `lib=${libID}&viewType=json`);
    $.getJSON(getDocsLink, function(docItems)
    {
        const docID     = $('input[name=doc]').val();
        const docPicker = $('input[name=doc]').zui('picker');

        docPicker.render({items: docItems});
        docPicker.$.setValue(docID);
    })
}

waitDom('[name=object]', function()
{
    setTimeout(function(){ objectChange();}, 100);
})
