<?php
namespace zin;

class docList extends wg
{
    /**
     * @var mixed[]
     */
    protected static $defineProps = array(
        'data' => '?object',           // 对象数据。
        'mode' => '?string="edit"'     // view还是edit模式。
    );

    /**
     * @return string|null
     */
    public static function getPageJS()
    {
        return file_get_contents(__DIR__ . DS . 'js' . DS . 'v1.js');
    }

    protected function build()
    {
        global $app, $lang;

        $app->loadLang('task');
        $data    = $this->prop('data');
        $mode    = $this->prop('mode');
        $oldDocs = $app->control->dao->select('id,title,version')->from(TABLE_DOC)->where('id')->in($data->docs)->fetchAll('id');
        $docList = $app->control->loadModel('doc')->getMySpaceDocs('all', 'bykeyword', '', 'id_desc', null, '', $data->docs);

        $docs = array();
        foreach($docList as $doc) $docs[] = array('text' => $doc->title, 'value' => $doc->id);

        if($mode == 'edit')
        {
            $oldDocVersions = $app->control->dao->select('doc,version')->from(TABLE_DOCCONTENT)->where('doc')->in($data->docs)->fetchGroup('doc', 'version');
            $oldDocVersions = \json_decode(json_encode($oldDocVersions), true);
            foreach($oldDocVersions as $docID => $versions)
            {
                foreach($versions as $versionID => $version) $oldDocVersions[$docID][$versionID] = "#{$version['version']}";
            }
        }

        if(is_string($data->docVersions)) $data->docVersions = \json_decode($data->docVersions, true);

        $docBox = array();
        if($data->docs)
        {
            foreach(explode(',', $data->docs) as $docID)
            {
                $link = $mode == 'view' && common::hasPriv('doc', 'view') ? a(set::href(helper::createLink('doc', 'view', "docID={$docID}&version={$data->docVersions[$docID]}")), $oldDocs[$docID]->title) : $oldDocs[$docID]->title;
                $docBox[] = div
                (
                    setData(array('docID' => $docID)),
                    setClass('docItem flex items-center py-1'),
                    span(setClass('mr-4 p-1 docTitle'), icon(setClass('mr-2'), 'file-text'), $link),
                    div(setClass('w-24'), $mode == 'edit' ? picker(set::required(true), set::name("docVersions[$docID]"), set::items($oldDocVersions[$docID]), set::value($data->docVersions[$docID])) : "#{$data->docVersions[$docID]}"),
                    $mode == 'edit' && $oldDocs[$docID]->version != $data->docVersions[$docID] ? label(setClass('ml-2 warning'), $lang->task->docSyncTips) : null,
                    $mode == 'edit' ? input(setClass('hidden'), set::name("oldDocs[$docID]"), set::value($docID)) : null,
                    $mode == 'edit' ? btn(setClass('ghost ml-2'), icon('trash'), setData(array('on' => 'click', 'call' => 'window.removeDocs', 'params' => 'event'))) : null
                );
            }
        }


        return div
        (
            setClass('form-group-wrapper picker-box'),
            $mode == 'edit' ? picker
            (
                setID('docs'),
                set::name('docs'),
                set::items($docs),
                set::multiple(true),
                set::maxItemsCount(50),
                set::menu(array('checkbox' => true)),
                !empty($items) ? set::toolbar(true) : null
            ) : null,
            div(setClass('mt-2'), $docBox)
        );
    }
}
