<?php
/**
 * 判断IPD项目阶段是否允许并行。
 * Determine whether parallelism is allowed in the IPD project phase.
 *
 * @param  int    $projectID
 * @access public
 * @return int
 */
public function checkParallel($projectID)
{
    return (int)$this->dao->select('parallel')->from(TABLE_PROJECT)
        ->where('project')->eq($projectID)
        ->andWhere('status')->ne('wait')
        ->fetch('parallel');
}

/**
 * 检查单个编辑IPD阶段的开始时间和结束时间是否符合规则。
 * Check whether the start and end time of a single edit IPD phase is in accordance with the rules.
 *
 * @param  object $currentStage
 * @access public
 * @return bool
 */
public function checkIpdStageDate($currentStage)
{
    $stages = $this->loadModel('execution')->getList($currentStage->project);
    if($stages) $stages = array_reverse($stages, true);

    $preDate   = $nextDate = '';
    $isCurrent = false;
    foreach($stages as $stage)
    {
        if(!$stage->enabled) continue;//阶段是否启用
        if($isCurrent)
        {
            $nextDate = $stage->begin;
            break;
        }

        if($stage->attribute == $currentStage->attribute)
        {
            $isCurrent = true;
            continue;
        }

        $preDate = $stage->end;
    }

    if($preDate and $preDate > $_POST['begin']) dao::$errors['begin'] = $this->lang->programplan->error->outOfDate . ': ' . $preDate;
    if($nextDate and $nextDate < $_POST['end']) dao::$errors['end']   = $this->lang->programplan->error->lessOfDate . ': ' . $nextDate;

    return !dao::isError();
}
