<?php
/**
 * The ajaxgetdropmenu view file of caselib module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Mengyi Liu <liumengyi@easycorp.ltd>
 * @package     caselib
 * @link        https://www.zentao.net
 */
namespace zin;
if(in_array("{$module}-{$method}", $config->index->oldPages))
{
    include '../view/ajaxgetdropmenu.html.php';
    return;
}

$data = array();

$allProductlink = $module == 'ticket' ? helper::createLink('ticket', 'browse', 'browseType=byProduct&param=all') : helper::createLink('feedback', 'admin', 'browseType=byProduct&param=all');
if($this->config->vision == 'lite' and $module != 'ticket') $allProductlink = helper::createLink('feedback', 'browse', 'browseType=byProduct&param=all');

$item = array();
$item['id']     = 'all';
$item['name']   = $lang->product->allProduct;
$item['text']   = $lang->product->allProduct;
$item['title']  = $lang->product->allProduct;
$item['active'] = 'all' == $productID;
$item['url']    = $allProductlink;
$item['type']   = 'item';
$data[] = $item;

foreach($products as $programID => $programProducts)
{
    foreach($programProducts as $index => $product)
    {
        $productName = ($config->systemMode == 'ALM' and $product->line) ? zget($lines, $product->line, '') . ' / ' . $product->name : $product->name;
        $linkHtml    = $this->product->setParamsForLink($module, $link, $projectID, $product->id);

        $item = array();
        $item['id']     = $product->id;
        $item['name']   = $productName;
        $item['text']   = $productName;
        $item['title']  = $productName;
        $item['active'] = $product->id == $productID;
        $item['url']    = $linkHtml;
        $item['type']   = 'item';
        $data[] = $item;
    }
}

$json = array();
$json['data']       = $data;
$json['searchHint'] = $lang->searchAB;

renderJson($json);

