/**
 * 计算表格风险信息的统计。
 * Set risk summary for table footer.
 *
 * @param  element element
 * @param  array   checkedIDList
 * @access public
 * @return object
 */
window.setStatistics = function(element, checks)
{
    let activeCount = 0;
    let hangupCount = 0;
    checks.forEach((checkID) => {
        const risk = element.getRowInfo(checkID).data;
        if(risk.status == 'active') activeCount ++;
        if(risk.status == 'hangup') hangupCount ++;
    })
    if(checks.length) return {html: element.options.checkedSummary.replaceAll('%total%', `${checks.length}`).replaceAll('%active%', activeCount).replaceAll('%hangup%', hangupCount)};
    return zui.formatString(element.options.defaultSummary);
}

window.clickImportToLib = function()
{
    const dtable = zui.DTable.query();
    const checkedList = dtable.$.getChecks();
    if(!checkedList.length) return;

    let riskIDList = '';
    checkedList.forEach((id) => riskIDList += id + ',');
    $('#riskIDList').val(riskIDList);
}
