<?php
public function saveUpload($objectType = '', $objectID = 0, $extra = '', $filesName = 'files', $labelsName = 'labels')
{
    $fileTitles = array();
    $now        = helper::today();
    $files      = $this->getUpload($filesName, $labelsName);

    foreach($files as $id => $file)
    {
        if(!isset($file['size']) || $file['size'] == 0) continue;
        if(!move_uploaded_file($file['tmpname'], $this->savePath . $this->getSaveName($file['pathname']))) return false;

        $file = $this->compressImage($file);

        $file['objectType'] = $objectType;
        $file['objectID']   = $objectID;
        $file['addedBy']    = $this->app->user->account;
        $file['addedDate']  = $now;
        $file['extra']      = $extra;
        unset($file['tmpname']);
        $this->dao->insert(TABLE_FILE)->data($file)->exec();
        $fileTitles[$this->dao->lastInsertId()] = $file['title'];
    }
    return $fileTitles;
}
