<?php
/**
 * __construct
 *
 * @access public
 * @return void
 */
public function __construct($appName = '')
{
    parent::__construct($appName);
if(defined('IN_USE') or (defined('RUN_MODE') and RUN_MODE == 'api')) $this->loadExtension('flow')->loadCustomLang();
}

/**
 * Get deleted objects.
 *
 * @param  string    $type all|hidden
 * @param  string    $orderBy
 * @param  object    $pager
 * @access public
 * @return array
 */
public function transformActions($actions)
{
    $this->app->loadLang('todo');
    $this->app->loadLang('stakeholder');
    $this->app->loadLang('branch');
    $this->app->loadLang('execution');

    /* Get commiters and the same department users. */
    $commiters = $this->loadModel('user')->getCommiters();
    $deptUsers = isset($this->app->user->dept) ? $this->loadModel('dept')->getDeptUserPairs($this->app->user->dept, 'id') : '';

    /* Get object names, object projects and requirements by actions. */
    $relatedData     = $this->getRelatedDataByActions($actions);
    $objectNames     = $relatedData['objectNames'];
    $relatedProjects = $relatedData['relatedProjects'];
    $requirements    = $relatedData['requirements'];

    $projectIdList = array();
    foreach($relatedProjects as $objectType => $idList) $projectIdList += $idList;

    /* If idList include ',*,' Format ',*,' to '*'. */
    foreach($projectIdList as $key => $idList)
    {
        $idList = explode(',', $idList);

        foreach($idList as $id) $projectIdList[] = $id;
        unset($projectIdList[$key]);
    }

    if($projectIdList) $projectIdList = array_unique($projectIdList);

    $shadowProducts   = $this->dao->select('id')->from(TABLE_PRODUCT)->where('shadow')->eq(1)->fetchPairs();
    $projectMultiples = $this->dao->select('id,type,multiple')->from(TABLE_PROJECT)->where('id')->in($projectIdList)->fetchAll('id');
    $docList          = $this->loadModel('doc')->getPrivDocs('', 0, 'all');
    $apiList          = $this->loadModel('api')->getPrivApis();
    $docLibList       = $this->doc->getLibs('hasApi');

    foreach($actions as $i => $action)
    {
        if($action->objectType == 'doc' and !isset($docList[$action->objectID])) unset($actions[$i]);
        if($action->objectType == 'api' and !isset($apiList[$action->objectID])) unset($actions[$i]);
        if($action->objectType == 'doclib' and !isset($docLibList[$action->objectID])) unset($actions[$i]);
        if($action->objectType == 'product' AND isset($shadowProducts[$action->objectID]))
        {
            unset($actions[$i]);
            continue;
        }

        /* Add name field to the actions. */
        $action->objectName = isset($objectNames[$action->objectType][$action->objectID]) ? $objectNames[$action->objectType][$action->objectID] : '';

        if($action->objectType == 'program' and strpos('syncexecution,syncproject,syncprogram', $action->action) !== false)
        {
            $action->objectName .= $this->lang->action->label->startProgram;
        }
        elseif($action->objectType == 'branch' and $action->action == 'mergedbranch')
        {
            if($action->objectID == 0) $action->objectName = $this->lang->branch->main;
            $action->objectName = '"' . $action->extra . ' "' . $this->lang->action->to . ' "' . $action->objectName . '"';
        }
        elseif($action->objectType == 'user')
        {
            $user = $this->dao->select('id,realname')->from(TABLE_USER)->where('id')->eq($action->objectID)->fetch();
            if($user) $action->objectName = $user->realname;
        }
        elseif($action->objectType == 'kanbancard' and strpos($action->action, 'imported') !== false and $action->action != 'importedcard')
        {
            $objectType  = str_replace('imported', '', $action->action);
            $objectTable = zget($this->config->objectTables, $objectType);
            $objectName  = ($objectType == 'productplan' or $objectType == 'ticket') ? 'title' : 'name';
            $action->objectName = $this->dao->select($objectName)->from($objectTable)->where('id')->eq($action->extra)->fetch($objectName);
        }
        elseif(strpos(',module,chartgroup,', ",$action->objectType,") !== false and !empty($action->extra) and $action->action != 'deleted')
        {
            $modules = $this->dao->select('id,name')->from(TABLE_MODULE)->where('id')->in(explode(',', $action->extra))->fetchPairs('id');
            $action->objectName = implode(',', $modules);
        }
        elseif($action->objectType == 'mr' and $action->action == 'deleted')
        {
            $action->objectName = $action->extra;
        }
        elseif($action->objectType == 'pivot')
        {
            $pivotNames = json_decode($action->objectName, true);
            $action->objectName = zget($pivotNames, $this->app->getClientLang(), '');
            if(empty($action->objectName))
            {
                $pivotNames = array_filter($pivotNames);
                $action->objectName = reset($pivotNames);
            }
        }

        $projectID = isset($relatedProjects[$action->objectType][$action->objectID]) ? $relatedProjects[$action->objectType][$action->objectID] : 0;

        $actionType = strtolower($action->action);
        $objectType = strtolower($action->objectType);

        $action->originalDate = $action->date;
        $action->date         = date(DT_MONTHTIME2, strtotime($action->date));
        $action->actionLabel  = isset($this->lang->$objectType->$actionType) ? $this->lang->$objectType->$actionType : $action->action;
        $action->actionLabel  = isset($this->lang->action->label->$actionType) ? $this->lang->action->label->$actionType : $action->actionLabel;
        $action->objectLabel  = $this->getObjectLabel($objectType, $action->objectID, $actionType, $requirements);

        /* If action type is login or logout, needn't link. */
        if($actionType == 'svncommited' or $actionType == 'gitcommited') $action->actor = zget($commiters, $action->actor);

        /* Get gitlab, gitea or gogs objectname. */
        if(empty($action->objectName) and (substr($objectType, 0, 6) == 'gitlab' or substr($objectType, 0, 5) == 'gitea' or substr($objectType, 0, 4) == 'gogs')) $action->objectName = $action->extra;

        /* Other actions, create a link. */
        $this->setObjectLink($action, $deptUsers, $shadowProducts, zget($projectMultiples, $projectID, ''));

        /* Set merge request link. */
        if((empty($action->objectName) or $action->action == 'deleted') and $action->objectType == 'mr') $action->objectLink = '';

        $action->major = (isset($this->config->action->majorList[$action->objectType]) && in_array($action->action, $this->config->action->majorList[$action->objectType])) ? 1 : 0;
    }

    foreach($actions as $action)
    {
        if(isset($this->config->action->customFlows[$action->objectType]))
        {
            $flow = $this->config->action->customFlows[$action->objectType];
            $action->objectName = $flow->name . $action->objectName;

            $actionType = $action->objectType . strtolower($action->action);
            if(isset($this->lang->action->label->{$actionType})) $action->actionLabel = $this->lang->action->label->{$actionType};
        }

        $actionType = strtolower($action->action);
        $objectType = strtolower($action->objectType);
        if($objectType != 'workflowfield' && $objectType != 'workflowaction') continue;

        if(isset($this->lang->action->label->$objectType))
        {
            $objectLabel = $this->lang->action->label->$objectType;
            if(is_array($objectLabel))
            {
                if(isset($objectLabel['common']))    $action->objectLabel = $objectLabel['common'];
                if(isset($objectLabel[$actionType])) $action->objectLabel = $objectLabel[$actionType];
            }
            else
            {
                $action->objectLabel = $objectLabel;
            }
        }

        $data = $this->loadModel($action->objectType, 'flow')->getByID($action->objectID);

        if(!$data) continue;

        /* Other actions, create a link. */
        if(strpos($action->objectLabel, '|') !== false)
        {
            list($objectLabel, $moduleName, $methodName, $vars) = explode('|', $action->objectLabel);
            if($action->objectType == 'workflowrule') $vars = empty($vars) ? '' : sprintf($vars, $action->objectID);
            $vars = empty($vars) ? '' : sprintf($vars, $data->module);
            $action->objectLink  = helper::createLink($moduleName, $methodName, $vars);
            $action->objectLabel = $objectLabel;
        }
        else
        {
            $action->objectLink = '';
        }
    }

    return $actions;
}
