<?php
/**
 * The tao file of team module of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      sunguangming <sunguangming@easycorp.ltd>
 * @link        https://www.zentao.net
 */
class teamTao extends teamModel
{
    /**
     * 根据团队ID更新团队的父团队。
     * Update team's parent by id.
     *
     * @param  int    $teamID
     * @param  int    $parent
     * @access public
     * @return void
     */
    public function updateParent($teamID, $parent)
    {
        $this->dao->update(TABLE_TEAMGROUP)->set('parent')->eq($parent)->where('id')->eq($teamID)->exec();
    }

    /**
     * 根据获取的团队列表，构造列表的树状结构。
     * Build team option menu by teamList.
     *
     * @param  array  $teams
     * @param  int    $parentID
     * @param  string $path
     * @access public
     * @return array
     */
    function buildOptionMenu($teams, $parentID = 0, $path = '/'): array
    {
        $options = array(0 => $path);

        foreach($teams as $id => $team)
        {
            if($team->parent == $parentID)
            {
                $newPath      = $path . $team->name . '/';
                $options[$id] = rtrim($newPath, '/');
                $options     += $this->buildOptionMenu($teams, $id, $newPath);
            }
        }

        return $options;
    }
}
