<?php
public function manageMembers($projectID)
{
    $project = $this->getByID($projectID);
    $data    = (array)fixer::input('post')->get();

    extract($data);
    $projectID   = (int)$projectID;
    $projectType = 'project';
    $accounts    = array_unique($accounts);
    $oldJoin     = $this->dao->select('`account`, `join`')->from(TABLE_TEAM)->where('root')->eq($projectID)->andWhere('type')->eq($projectType)->fetchPairs();

    foreach($accounts as $key => $account)
    {
        if(empty($account)) continue;

        if(!empty($project->days) and (int)$days[$key] > $project->days)
        {
            dao::$errors['message'][]  = sprintf($this->lang->project->daysGreaterProject, $project->days);
            return false;
        }
        if((float)$hours[$key] > 24)
        {
            dao::$errors['message'][]  = $this->lang->project->errorHours;
            return false;
        }
    }

    $this->dao->delete()->from(TABLE_TEAM)->where('root')->eq($projectID)->andWhere('type')->eq($projectType)->exec();

    $projectMember = array();
    foreach($accounts as $key => $account)
    {
        if(empty($account)) continue;

        $member            = new stdclass();
        $member->role      = $roles[$key];
        $member->days      = $days[$key];
        $member->hours     = $hours[$key];
        $member->teamgroup = $teamgroup[$key];
        $member->limited   = isset($limited[$key]) ? $limited[$key] : 'no';

        $member->root      = $projectID;
        $member->account   = $account;
        $member->join      = isset($oldJoin[$account]) ? $oldJoin[$account] : helper::today();
        $member->type      = $projectType;

        $projectMember[$account] = $member;
        $this->dao->insert(TABLE_TEAM)->data($member)->exec();
    }

    /* Only changed account update userview. */
    $oldAccounts     = array_keys($oldJoin);
    $removedAccounts = array_diff($oldAccounts, $accounts);
    $changedAccounts = array_merge($removedAccounts, array_diff($accounts, $oldAccounts));
    $changedAccounts = array_unique($changedAccounts);

    $childSprints   = $this->dao->select('id')->from(TABLE_PROJECT)->where('project')->eq($projectID)->andWhere('type')->in('stage,sprint')->andWhere('deleted')->eq('0')->fetchPairs();
    $linkedProducts = $this->dao->select("t2.id")->from(TABLE_PROJECTPRODUCT)->alias('t1')
        ->leftJoin(TABLE_PRODUCT)->alias('t2')->on('t1.product = t2.id')
        ->where('t2.deleted')->eq(0)
        ->andWhere('t1.project')->eq($projectID)
        ->andWhere('t2.vision')->eq($this->config->vision)
        ->fetchPairs();

    $this->loadModel('user')->updateUserView(array($projectID), 'project', $changedAccounts);
    if(!empty($childSprints))   $this->user->updateUserView($childSprints, 'sprint', $changedAccounts);
    if(!empty($linkedProducts)) $this->user->updateUserView(array_keys($linkedProducts), 'product', $changedAccounts);

    /* Remove execution members. */
    if($this->post->removeExecution == 'yes' and !empty($childSprints) and !empty($removedAccounts))
    {
        $this->dao->delete()->from(TABLE_TEAM)
             ->where('root')->in($childSprints)
             ->andWhere('type')->eq('execution')
             ->andWhere('account')->in($removedAccounts)
             ->exec();
    }

    if(empty($project->multiple) and $project->model != 'waterfall') $this->loadModel('execution')->syncNoMultipleSprint($projectID);
}
