<?php
class piZen extends pi
{
    /**
     * 验证表单数据完整性。
     * Check form data on create and edit.
     *
     * @param  object    $formData
     * @access protected
     * @return bool
     */
    protected function checkCreateFormData($formData): bool
    {
        $executionIDList = $formData->plan;
        $executions      = $formData->execution;
        $beginList       = $formData->begin;
        $endList         = $formData->end;

        $duplicates = array_count_values($executions);
        foreach($executions as $key => $execution)
        {
            if(!$execution)             dao::$errors["execution[$key]"][] = sprintf($this->lang->error->notempty, $this->lang->pi->execution);
            if(empty($beginList[$key])) dao::$errors["begin[$key]"][]     = sprintf($this->lang->error->notempty, $this->lang->pi->begin);
            if(empty($endList[$key]))   dao::$errors["end[$key]"][]       = sprintf($this->lang->error->notempty, $this->lang->pi->end);

            if(!empty($beginList[$key]) && !empty($endList[$key]) && $beginList[$key] > $endList[$key]) dao::$errors["end[$key]"][] = sprintf($this->lang->error->gt, $this->lang->pi->end, $this->lang->pi->begin);

            foreach($duplicates as $value => $count)
            {
                if($count > 1 && $execution == $value) dao::$errors["execution[$key]"][] = $this->lang->pi->error->duplicate;
            }
        }

        if(dao::isError()) return false;

        $order         = 1;
        $executionData = array();
        foreach($executions as $key => $execution)
        {
            $data = new stdclass();
            $data->id    = zget($executionIDList, $key, '');
            $data->name  = $execution;
            $data->begin = $beginList[$key];
            $data->end   = $endList[$key];
            $data->order = $order;
            $executionData[] = $data;

            $order ++;
        }
        $formData->executions = $executionData;

        return true;
    }

    protected function commonAction($id)
    {
        $this->lang->safe->menu        = $this->lang->pi->menu;
        $this->lang->safe->dividerMenu = $this->lang->pi->dividerMenu;
        $this->lang->safe->menuOrder   = $this->lang->pi->menuOrder;
        $this->session->safe = $id;
        unset($this->lang->pi->menu);
    }
}
