-- DROP TABLE IF EXISTS `zt_metric`;
CREATE TABLE IF NOT EXISTS `zt_metric` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `purpose` varchar(50) NOT NULL DEFAULT '',
  `scope` char(30) NOT NULL DEFAULT '',
  `object` char(30) NOT NULL DEFAULT '',
  `stage` enum('wait','released') NULL DEFAULT 'wait',
  `type` enum('php', 'sql') NULL DEFAULT 'php',
  `name` varchar(90) NOT NULL DEFAULT '',
  `code` varchar(90) NOT NULL DEFAULT '',
  `unit` varchar(10) NOT NULL DEFAULT '',
  `collector` text,
  `desc` text,
  `definition` text,
  `when` varchar(30) NOT NULL DEFAULT '',
  `event` varchar(30) NOT NULL DEFAULT '',
  `cronCFG` varchar(30) NOT NULL DEFAULT '',
  `time` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `implementedBy` varchar(30) NOT NULL DEFAULT '',
  `implementedDate` datetime DEFAULT NULL,
  `delistedBy` varchar(30) NOT NULL DEFAULT '',
  `delistedDate` datetime DEFAULT NULL,
  `builtin` enum('0', '1') NOT NULL DEFAULT '0',
  `fromID` mediumint unsigned NOT NULL DEFAULT 0,
  `order` mediumint unsigned NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_metriclib`;
CREATE TABLE IF NOT EXISTS `zt_metriclib` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `metricID`   mediumint    NOT NULL DEFAULT 0,
  `metricCode` varchar(100) NOT NULL DEFAULT '',
  `system`     char(30)     NOT NULL DEFAULT '0',
  `program`    char(30)     NOT NULL DEFAULT '',
  `project`    char(30)     NOT NULL DEFAULT '',
  `product`    char(30)     NOT NULL DEFAULT '',
  `execution`  char(30)     NOT NULL DEFAULT '',
  `code`       char(30)     NOT NULL DEFAULT '',
  `pipeline`   char(30)     NOT NULL DEFAULT '',
  `user`       text,
  `dept`       char(30)     NOT NULL DEFAULT '',
  `year`       char(4)      NOT NULL DEFAULT '0',
  `month`      char(2)      NOT NULL DEFAULT '0',
  `week`       char(2)      NOT NULL DEFAULT '0',
  `day`        char(2)      NOT NULL DEFAULT '0',
  `value`      varchar(100) NOT NULL DEFAULT '0',
  `date`       datetime              DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'program', 'released', 'php', '按系统统计的所有层级的项目集总数', 'count_of_program', 'count', NULL, '按系统统计的所有层级的项目集总数表示在整个组织范围内的项目集数量。此度量项反映了整个组织所管理的项目集数量。可以作为评估组织规模和复杂度的指标。', '所有项目集的个数求和\r\n过滤已删除的项目集', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'program', 'released', 'php', '按系统统计的所有层级进行中项目集数', 'count_of_doing_program', 'count', NULL, '按系统统计的所有层级进行中项目集数表示当前正在进行中的项目集数量。此度量项反映了组织当前正在进行中的项目集数量，可以用于评估组织的项目集管理进展和资源分配情况。', '所有项目集的个数求和\r\n状态为进行中\r\n过滤已删除的项目集', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'program', 'released', 'php', '按系统统计的所有层级已关闭项目集数', 'count_of_closed_program', 'count', NULL, '按系统统计的所有层级已关闭项目集数反映了系统关闭的项目集数量，用于评估组织项目集层面的管理成果。', '所有项目集的个数求和\r\n状态为已关闭\r\n过滤已删除的项目集', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'program', 'released', 'php', '按系统统计的所有层级已挂起项目集数', 'count_of_suspended_program', 'count', NULL, '按系统统计的所有层级已挂起项目集数反映了系统内因为某种原因暂时中止或搁置的项目集数量，用于评估组织项目集层面的风险和不确定性。', '所有项目集的个数求和\r\n状态为已挂起\r\n过滤已删除的项目集', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'program', 'released', 'php', '按系统统计的所有层级未开始项目集数', 'count_of_wait_program', 'count', NULL, '按系统统计的所有层级未开始项目集数反映了系统尚未启动的项目集数量，用于评估组织项目集层面的计划或储备工作。', '所有项目集的个数求和\r\n状态为未开始\r\n过滤已删除的项目集', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'program', 'released', 'php', '按系统统计的一级项目集总数', 'count_of_top_program', 'count', NULL, '按系统统计的一级项目集总数反映了组织中不同战略目标的项目集数量及情况，用于评估组织的战略取向、优先事项、资源分配以及管理能力等关键方面，是组织实现长期成功的重要手段和路径。', '所有一级项目集的个数求和\r\n过滤已删除的项目集', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'program', 'released', 'php', '按系统统计的已关闭一级项目集数', 'count_of_closed_top_program', 'count', NULL, '按系统统计的已关闭一级项目集数反映了系统中不同战略目标的项目集数量及情况，用于评估组织的项目集战略目标管理绩效和成果。', '所有一级项目集的个数求和\r\n状态为已关闭\r\n过滤已删除的项目集', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'program', 'released', 'php', '按系统统计的未关闭一级项目集数', 'count_of_unclosed_top_program', 'count', NULL, '按系统统计的未关闭一级项目集数反映了系统中不同战略目标的项目集数量及情况，用于评估组织进行中的项目集战略目标的进展和挑战。', '复用：\r\n按系统统计的一级项目集总数\r\n按系统统计的已关闭一级项目集数\r\n公式：按系统统计的未关闭一级项目集数=按系统统计的一级项目集总数-按系统统计的已关闭一级项目集数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'program', 'released', 'php', '按系统统计的年度新增一级项目集数', 'count_of_annual_created_top_program', 'count', NULL, '按系统统计的年度新增一级项目集数反映了系统中每年新增的不同战略目标的项目集数量及情况，用于评估组织的最新的战略取向、优先事项、资源分配以及管理能力等关键方面。', '所有的一级项目集的个数求和\r\n创建时间为某年\r\n过滤已删除的项目集', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'program', 'released', 'php', '按系统统计的年度关闭一级项目集数', 'count_of_annual_closed_top_program', 'count', NULL, '按系统统计的年度关闭一级项目集数反映了系统中每年结束的不同战略目标的项目集数量及情况，用于评估组织的战略目标管理的绩效和成果。', '所有的一级项目集的个数求和\r\n关闭时间为某年\r\n状态为已关闭\r\n过滤已删除的项目集', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'line', 'released', 'php', '按系统统计的产品线总数', 'count_of_line', 'count', NULL, '按系统统计的产品线总数反映了组织中产品线的数量和广度，用于评估组织的产品组合策略和业务发展方向。', '所有产品线的个数求和\r\n过滤已删除的产品线', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'product', 'released', 'php', '按系统统计的产品总数', 'count_of_product', 'count', NULL, '按系统统计的产品总数反映了系统中的产品数量，用于评估组织的产品的数量和多样性。', '所有产品的个数求和\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'product', 'released', 'php', '按系统统计的正常的产品数', 'count_of_normal_product', 'count', NULL, '按系统统计的正常的产品数量反映了组织中处于正常研发和运营状态的产品数量，用于评估组织的产品研发能力和持续的运营能力。', '所有产品的个数求和\r\n状态为正常\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'product', 'released', 'php', '按系统统计的结束的产品数', 'count_of_closed_product', 'count', NULL, '按系统统计的结束的产品数反映了组织中已经停止研发和运营的产品数量，用于评估组织的产品生命周期管理和战略调整。', '所有产品的个数求和\r\n状态为结束\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'product', 'released', 'php', '按系统统计的年度新增产品数', 'count_of_annual_created_product', 'count', NULL, '按系统统计的年度新增产品数反映了组织每年新增加的产品数量，用于评估组织的产品创新能力和市场拓展情况。', '所有的产品个数求和\r\n创建时间为某年\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'product', 'released', 'php', '按系统统计的年度结束产品数', 'count_of_annual_closed_product', 'count', NULL, '按系统统计的年度结束产品数反映了组织每年停止研发和运营的产品数量，用于评估组织的产品组合调整和战略转型情况。', '所有的产品个数求和\r\n关闭时间为某年\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'project', 'released', 'php', '按系统统计的项目总数', 'count_of_project', 'count', NULL, '按系统统计的项目总数是指目前系统内的总项目数量。这个度量项可以帮助团队了解当前的项目规模和工作量，并作为项目管理的基础数据之一。', '所有的项目个数求和\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'project', 'released', 'php', '按系统统计的未开始项目数', 'count_of_wait_project', 'count', NULL, '按系统统计的未开始项目数是指系统中目前未开始的项目数量。这个度量项可以帮助团队了解当前需要启动的项目数量和未来的项目规划。', '所有的项目个数求和\r\n状态为未开始\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'project', 'released', 'php', '按系统统计的进行中项目数', 'count_of_doing_project', 'count', NULL, '按系统统计的进行中项目数是指系统中目前正在进行中的项目数量。这个度量项可以帮助团队了解当前正在进行的工作量和资源分配情况，以及项目的执行进度和效率。', '所有的项目个数求和\r\n状态为进行中\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'project', 'released', 'php', '按系统统计的已挂起项目数', 'count_of_suspended_project', 'count', NULL, '按系统统计的已挂起项目数是指因某种原因而暂停或停滞的项目数量。这个度量项可以帮助团队了解存在的挂起项目的数量和原因，并进行适当的调整和解决。', '所有的项目个数求和\r\n状态为已挂起\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'project', 'released', 'php', '按系统统计的已关闭项目数', 'count_of_closed_project', 'count', NULL, '按系统统计的已关闭项目数是指已经完成并关闭的项目数量。这个度量项可以帮助团队了解已经完成的项目数量和整体的项目执行情况。', '所有的项目个数求和\r\n状态为已关闭\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'project', 'released', 'php', '按系统统计的未关闭项目数', 'count_of_unclosed_project', 'count', NULL, '按系统统计的未关闭项目数是指在系统目前未开始或仍然在进行中的项目数量。这个度量项可以衡量项目管理和执行的效率。', '复用：\r\n按系统统计的已关闭项目数\r\n按系统统计的项目总数\r\n公式：\r\n按系统统计的未关闭项目数=按系统统计的项目总数-按系统统计的已关闭项目数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'project', 'released', 'php', '按系统统计的已完成项目中按期完成项目数', 'count_of_undelayed_finished_project_which_finished', 'count', NULL, '按系统统计的已完成项目中按期完成项目数是指按预定计划时间完成的项目数量。这个度量项可以帮助团队评估项目的时间管理和执行能力。较高的按期完成项目数表示团队能够按时交付项目，有助于保持项目进展和客户满意度。', '所有的项目个数求和\r\n状态为已关闭\r\n完成日期<=项目启动时的计划截止日期\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'project', 'released', 'php', '按系统统计的已完成项目中延期完成项目数', 'count_of_delayed_finished_project_which_finished', 'count', NULL, '按系统统计的已完成项目中延期完成项目数是指超过预定计划时间而完成的项目数量。这个度量项可以帮助团队评估项目的时间管理和执行能力，并识别延期原因并采取适当措施。较高的延期完成项目数可能需要团队关注项目计划和资源安排的问题。', '所有的项目个数求和\r\n状态为已关闭\r\n完成日期>项目启动时的计划截止日期\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'project', 'released', 'php', '按系统统计的年度新增项目数', 'count_of_annual_created_project', 'count', NULL, '按系统统计的年度新增项目数是指某年度新创建的项目数量。这个度量项可以帮助团队了解某年度的项目规模和工作负荷，以及项目管理和资源分配的需求。较高的年度新增项目数可能需要团队根据资源和能力进行优先级和规划管理。', '所有的项目个数求和\r\n创建时间为某年\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'project', 'released', 'php', '按系统统计的年度关闭项目数', 'count_of_annual_closed_project', 'count', NULL, '按系统统计的年度关闭项目数是指在某年度关闭的项目数量。这个度量项可以帮助团队了解某年度项目的执行情况和成果，并进行项目交付能力的评估。较高的年度关闭项目数表明团队在项目交付方面具有较高的效率。', '所有的项目个数求和\r\n关闭时间为某年\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'project', 'released', 'php', '按系统统计的年度启动项目中按期完成项目数', 'count_of_undelayed_finished_project_which_annual_started', 'count', NULL, '按系统统计的年度启动项目中按期完成项目数是指在某年度启动的项目中按预定计划时间关闭的项目数量。这个度量项可以帮助团队评估某年度项目的时间管理和执行能力，并衡量项目的进展和交付效果。较高的按时关闭项目数表明团队能够按时交付项目，有助于保持项目的正常进行和客户满意度。', '所有的项目个数求和\r\n启动时间为某年\r\n完成日期<=项目启动时的计划截止日期（根据历史记录推算）\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'project', 'released', 'php', '按系统统计的年度完成项目中延期完成项目数', 'count_of_delayed_finished_project_which_annual_finished', 'count', NULL, '按系统统计的年度完成项目中延期完成项目数是指在某年度完成的项目中超过预定计划时间关闭的项目数量。这个度量项可以帮助团队评估某年度项目的时间管理和执行能力，并识别延期原因并采取适当措施。较高的延期关闭项目数可能需要团队关注项目计划和资源安排的问题。', '复用：\r\n按系统统计的年度关闭项目数\r\n按系统统计的每年完成项目中按期完成项目数\r\n公式：\r\n按系统统计的年度延期完成项目数=按系统统计的年度关闭项目数-按系统统计的每年完成项目中按期完成项目数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'project', 'released', 'php', '按系统统计的年度完成项目中按期完成项目数', 'count_of_undelayed_finished_project_which_annual_finished', 'count', NULL, '按系统统计的年度完成项目中按期完成项目数是指在某年度完成的项目中按预定计划时间关闭的项目数量。这个度量项可以帮助团队评估某年度项目的时间管理和执行能力，并衡量项目的进展和交付效果。较高的按时关闭项目数表明团队能够按时交付项目，有助于保持项目的正常进行和客户满意度。', '所有的项目个数求和\r\n关闭时间为某年\r\n完成日期<=项目启动时的计划截止日期\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'project', 'released', 'php', '按系统统计的月度新增项目数', 'count_of_monthly_created_project', 'count', NULL, '按系统统计的月度新增项目数是指在某月度新创建的项目数量。这个度量项可以帮助团队了解某年度项目规模和工作负荷，以及项目管理和资源分配的需求。较高的年度新增项目数可能需要团队根据资源和能力进行优先级和规划管理。', '所有的项目个数求和\r\n创建时间为某年某月\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'project', 'released', 'php', '按系统统计的月度关闭项目数', 'count_of_monthly_closed_project', 'count', NULL, '按系统统计的年度关闭项目数是指在某月度关闭的项目数量。这个度量项可以帮助团队了解某年度项目的执行情况和成果，并进行项目交付能力的评估。较高的年度关闭项目数表明团队在项目交付方面具有较高的效率。', '所有的项目个数求和\r\n关闭时间为某年某月\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'project', 'released', 'php', '按系统统计的年度完成项目数', 'count_of_annual_finished_project', 'count', NULL, '按系统统计的年度完成项目数是指在某年度完成并关闭的项目数量。反映了团队在某年度项目的执行情况和成果，并进行项目交付能力的评估。较高的年度完成项目数表明团队在项目交付方面具有较高的效率。', '所有的项目个数求和\r\n实际完成时间为某年\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('hour', 'system', 'project', 'released', 'php', '按系统统计的年度关闭项目的任务预计工时数', 'estimate_of_annual_closed_project', 'count', NULL, '按系统统计的年度关闭项目的任务预计工时数是指在某年度关闭项目预计需要花费的总工时数。该度量项可以用来评估团队或组织在任务完成方面的工时规划和估算准确性。较准确的年度完成任务预计工时数可以帮助团队更好地安排资源和时间，提高任务的完成效率和进度控制。', '所有项目任务的预计工时数求和\r\n项目状态为已关闭\r\n关闭时间为某年\r\n过滤父任务\r\n过滤已删除的任务\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('hour', 'system', 'project', 'released', 'php', '按系统统计的年度关闭项目的任务消耗工时数', 'consume_of_annual_closed_project', 'hour', NULL, '按系统统计的年度关闭项目的任务消耗工时数是指在某年度关闭的项目中任务消耗的总工时数。该度量项可以用来评估团队或组织在任务执行过程中的工时投入情况和对资源的利用效率。较高的年度关闭项目的任务消耗工时数可能需要审查工作流程和资源分配，以提高工作效率和进度控制。', '所有项目任务的消耗工时数求和\r\n项目状态为已关闭\r\n关闭时间为某年\r\n过滤父任务\r\n过滤已删除的任务\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('hour', 'system', 'project', 'released', 'php', '按系统统计的月度关闭项目的任务消耗工时数', 'consume_of_monthly_closed_project', 'hour', NULL, '按系统统计的月度关闭项目的任务消耗工时数是指在某月任务预计需要花费的总工时数。该度量项可以用来评估团队或组织在任务执行过程中的工时投入情况和对资源的利用效率。较高的月度关闭项目的任务消耗工时数可能需要审查工作流程和资源分配，以提高工作效率和进度控制。', '所有项目任务消耗工时数求和\r\n项目状态为已关闭\r\n关闭时间为某年某月\r\n过滤父任务\r\n过滤已删除的任务\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('hour', 'system', 'project', 'released', 'php', '按系统统计的年度已关闭项目投入总人天', 'day_of_annual_closed_project', 'manday', NULL, '按系统统计的年度已关闭项目投入总人天是指在某年度关闭项目投入的人天总数。该度量项可以用来评估项目的人力资源投入情况。投入总人天的增加可能意味着项目投入的工作时间和资源的增加。', '复用：\r\n按系统统计的年度关闭项目消耗工时数\r\n公式：\r\n按系统统计的年度关闭项目投入总人天=按系统统计的年度已关闭项目任务的消耗工时数/后台配置的每天可用工时', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('rate', 'system', 'project', 'released', 'php', '按系统统计的年度完成项目中项目的按期完成率', 'rate_of_undelayed_finished_project_which_annual_finished', 'count', NULL, '按系统统计的年度完成项目中项目的按期完成率是指按系统统计的年度完成项目中按期完成项目数与关闭项目数之比。这个度量项可以帮助团队评估某年度项目按期关闭的能力和效果，并作为项目管理的绩效指标之一。较高的按期完成率表示团队能够按时完成项目，说明对项目管理和交付能力较高。', '复用：\r\n按系统统计的年度关闭项目数\r\n按系统统计的年度完成项目中项目的按期完成率\r\n公式：\r\n按系统统计的年度项目按期关闭率=按系统统计的年度按时关闭项目数/按系统统计的年度关闭项目数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('rate', 'system', 'project', 'released', 'php', '按系统统计的年度完成项目中项目的延期完成率', 'rate_of_delayed_finished_project_which_annual_finished', 'count', NULL, '按系统统计的年度完成项目中项目的延期完成率是指按系统统计的年度完成项目中延期完成项目数与关闭项目数之比。这个度量项可以帮助团队评估某年度项目按期关闭的能力和效果，并作为项目管理的绩效指标之一。较高的延期完成率可能需要团队关注项目计划和资源安排的问题。', '复用：\r\n按系统统计的年度关闭项目数\r\n按系统统计的年度延期关闭项目数\r\n公式：\r\n按系统统计的年度项目延期关闭率=按系统统计的年度延期关闭项目数/按系统统计的年度关闭项目数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'productplan', 'released', 'php', '按系统统计的计划总数', 'count_of_productplan', 'count', NULL, '按系统统计的计划总数反映了组织中进行中和已完成的计划数量，用于评估组织的规划效率、预测资源需求、优化项目组织与协调，并用于绩效评估和目标设定。', '所有的计划的个数求和\r\n过滤已删除的计划', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'productplan', 'released', 'php', '按系统统计的年度新增计划数', 'count_of_annual_created_productplan', 'count', NULL, '按系统统计的年度新增计划数反映了组织在某年度内新增计划数量，用于评估组织创新能力、市场竞争力和投资决策，并用于绩效评估和目标设定。', '所有的计划个数求和\r\n创建时间为某年\r\n过滤已删除的计划', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'productplan', 'released', 'php', '按系统统计的年度完成计划数', 'count_of_annual_finished_productplan', 'count', NULL, '按系统统计的年度完成计划数反映了组织在某年度内实际完成的计划数量，用于评估绩效、生产效率和客户满意度，并用于规划和资源优化。', '所有的计划个数求和\r\n完成时间为某年\r\n过滤已删除的计划', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'productplan', 'released', 'php', '按系统统计的年度关闭计划数', 'count_of_annual_closed_productplan', 'count', NULL, '按系统统计的年度关闭计划数反映了组织在某年度内关闭的计划数量，用于评估组织的计划管理效能、资源优化和成本控制，并提供学习机会和产品组合优化的参考。', '所有的计划个数求和\r\n关闭时间为某年\r\n过滤已删除的计划', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'productplan', 'released', 'php', '按系统统计的已完成计划数', 'count_of_finished_productplan', 'count', NULL, '按系统统计的已完成计划数反映了组织在某年度内已经完成的计划数量，用于评估组织的绩效、生产效率和客户满意度，并用于规划和资源优化。', '所有计划的个数求和\r\n状态为已完成\r\n过滤已删除的计划', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'productplan', 'released', 'php', '按系统统计的未完成计划数', 'count_of_unfinished_productplan', 'count', NULL, '按系统统计的未完成的产品计划数量反映了组织在特定年度内未能完成的产品计划数量，用于评估组织的评估绩效、资源管理和风险控制，并用于规划和改进。', '复用：\r\n按系统统计的已完成计划数\r\n按系统统计的计划总数\r\n公式：\r\n按系统统计的未完成计划数=按系统统计的计划总数-按系统统计的已完成计划数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'execution', 'released', 'php', '按系统统计的执行总数', 'count_of_execution', 'count', NULL, '按系统统计的执行总数表示在整个系统中所有执行项的数量，可以用来评估项目的规模和任务的总量。', '所有的执行个数求和\r\n过滤已删除的执行', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'execution', 'released', 'php', '按系统统计的未开始执行数', 'count_of_wait_execution', 'count', NULL, '按系统统计的未开始执行数表示在整个系统中尚未开始执行的任务数，可以用来了解待办任务的数量。', '所有的执行个数求和\r\n状态为未开始\r\n过滤已删除的执行', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'execution', 'released', 'php', '按系统统计的进行中执行数', 'count_of_doing_execution', 'count', NULL, '按系统统计的进行中执行数表示在整个系统中正在进行中的执行项的数量，可以用来了解当前正在进行的任务数量，反映团队的工作进展。', '所有的执行个数求和\r\n状态为进行中\r\n过滤已删除的执行', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'execution', 'released', 'php', '按系统统计的已挂起执行数', 'count_of_suspended_execution', 'count', NULL, '按系统统计的已挂起执行数表示在整个系统中已被挂起的执行项的数量，可以用来了解暂停的任务数量，可能是由于需求不明确或其他原因导致。', '所有的执行个数求和\r\n状态为已挂起\r\n过滤已删除的执行', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'execution', 'released', 'php', '按系统统计的已关闭执行数', 'count_of_closed_execution', 'count', NULL, '按系统统计的已关闭执行数表示在整个系统中已关闭的执行项的数量，可以用来了解执行的进度情况。', '所有的执行个数求和\r\n状态为已关闭\r\n过滤已删除的执行', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'execution', 'released', 'php', '按系统统计的未关闭执行数', 'count_of_unclosed_execution', 'count', NULL, '按系统统计的未关闭执行数表示在整个系统中未关闭的执行项的数量，可以用来了解执行的进度情况。', '复用：\r\n按系统统计的执行总数\r\n按系统统计的已关闭执行数\r\n公式：\r\n按系统统计的未关闭执行数=按系统统计的执行总数-按系统统计的已关闭执行数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'execution', 'released', 'php', '按系统统计的年度新增执行数', 'count_of_annual_created_execution', 'count', NULL, '按系统统计的年度新增执行数是指在某年度新添加的执行数。该度量项反映了一个团队或组织在某年的工作量大小。较高的年度新增执行数可能表明团队面临更多的任务和挑战，需要更多的资源和努力来完成执行。同时，对于项目管理方面，该度量项也可以提供管理决策的依据。', '所有的执行个数求和\r\n创建时间为某年\r\n过滤已删除的执行', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'execution', 'released', 'php', '按系统统计的年度关闭执行数', 'count_of_annual_closed_execution', 'count', NULL, '按系统统计的年度完成执行数是指在某年度已经关闭的执行数。该度量项反映了团队或组织在某年的工作效率和完成能力。较高的年度完成执行数表示团队或组织在完成任务方面表现出较高的效率，反之则可能需要审查工作流程和资源分配情况，以提高执行效率。', '所有的执行个数求和\r\n关闭时间为某年\r\n过滤已删除的执行', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'execution', 'released', 'php', '按系统统计的月度新增执行数', 'count_of_monthly_created_execution', 'count', NULL, '按系统统计的月度新增执行数是指在某月度内新添加的执行数。该度量项反映了团队或组织在某月内所面临的新任务或工作量。较高的月度新增执行数可能表明团队需要快速适应新任务和及时调整资源来满足需求。', '所有的执行个数求和\r\n创建时间为某年某月\r\n过滤已删除的执行', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'execution', 'released', 'php', '按系统统计的月度关闭执行数', 'count_of_monthly_closed_execution', 'count', NULL, '按系统统计的月度完成执行数是指在某月度已经关闭的执行数。该度量项反映了团队或组织在某月内的工作效率和完成能力。较高的月度完成执行数表示团队或组织在快速完成任务方面表现出较高的效率，反之则可能需要审查工作流程和资源分配情况，以提高执行效率。', '所有的执行个数求和\r\n关闭时间为某年某月\r\n过滤已删除的执行', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'execution', 'released', 'php', '按系统统计的已完成执行中按期完成执行数', 'count_of_undelayed_finished_execution_which_finished', 'count', NULL, '按系统统计的已完成执行中按时完成执行数表示在整个系统中按期完成执行的数量，可以用来评估团队的执行能力和效率。', '所有的执行个数求和\r\n状态为已关闭\r\n关闭日期<=执行开始时计划截止日期\r\n过滤已删除的执行', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'execution', 'released', 'php', '按系统统计的已完成执行中延期完成执行数', 'count_of_delayed_finished_execution_which_finished', 'count', NULL, '按系统统计的已完成执行中延期完成执行数表示在整个系统中延期完成的执行项的数量，可以用来评估任务的延期情况和团队的执行能力。', '所有的执行个数求和\r\n状态为已关闭\r\n关闭日期>执行开始时计划截止日期\r\n过滤已删除的执行', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'execution', 'released', 'php', '按系统统计的年度完成执行中按期完成执行数', 'count_of_undelayed_finished_execution_which_annual_finished', 'count', NULL, '按系统统计的年度完成执行中按期完成执行数是指在某年度关闭的执行中，按预定计划时间关闭的执行数量。这个度量项可以用来衡量团队在某年度的按时完成能力，较高的按期完成执行数表明团队能够按期交付执行，有助于保持执行和项目的正常进行。', '所有的执行个数求和\r\n关闭时间为某年\r\n关闭日期<=执行开始时计划截止日期\r\n过滤已删除的执行', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'execution', 'released', 'php', '按系统统计的年度完成执行中延期完成执行数', 'count_of_delayed_finished_execution_which_annual_finished', 'count', NULL, '按系统统计的年度完成执行中延期完成执行数是指在某年度关闭的执行中，超过预定计划时间关闭的执行数量。这个度量项可以用来衡量团队在某年度的按时完成能力，并识别延期原因并采取适当措施。较高的延期关闭执行数可能需要团队关注执行计划和资源安排的问题。', '所有的关闭时间为某年的执行个数求和\r\n关闭日期>执行开始时计划截止日期\r\n过滤已删除的执行', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('rate', 'system', 'execution', 'released', 'php', '按系统统计的年度完成执行中执行的按期关闭率', 'rate_of_undelayed_closed_execution_which_annual_finished', 'percentage', NULL, '按系统统计的年度完成执行中执行的按期关闭率是指某年度按预定计划时间关闭的执行数量与某年度关闭执行执行数量之比。这个度量项可以帮助团队评估某年度执行按期关闭的能力和效果，并作为执行管理的绩效指标之一。较高的执行按期关闭率表示团队能够按时完成执行和项目。', '复用：\r\n按系统统计的年度关闭执行数\r\n按系统统计的年度完成执行中按期完成执行数\r\n公式：\r\n按系统统计的年度完成执行中执行的按期关闭率=按系统统计的年度完成执行中按期完成执行数/按系统统计的年度关闭执行数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('rate', 'system', 'execution', 'released', 'php', '按系统统计的年度完成执行中执行的延期关闭率', 'rate_of_delayed_closed_execution_which_annual_finished', 'percentage', NULL, '按系统统计的年度完成执行中执行的延期关闭率是指某年度超过预定计划时间关闭的执行数量与某年度关闭执行数量之比。这个度量项可以帮助团队评估某年度执行按期关闭的能力和效果，并作为执行管理的绩效指标之一。较高的执行延期关闭率可能需要团队关注执行计划和资源安排的问题。', '复用：\r\n按系统统计的年度关闭执行数\r\n按系统统计的年度完成执行中延期完成执行数\r\n公式：\r\n按系统统计的年度完成执行中执行的延期关闭率=按系统统计的年度完成执行中延期完成执行数/按系统统计的年度关闭执行数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'release', 'released', 'php', '按系统统计的发布总数', 'count_of_release', 'count', NULL, '按系统统计的产品发布数量反映了组织在特定时间段内发布的产品版本数量，用于评估组织的产品开发效率、市场适应能力和产品组合优化，并提供绩效评估和学习机会。', '所有的发布个数求和\r\n过滤已删除的发布', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'release', 'released', 'php', '按系统统计的里程碑发布总数', 'count_of_marker_release', 'count', NULL, '按系统统计的产品里程碑发布数量反映了组织在特定时间段内达到的产品开发里程碑数量，用于评估组织的产品开发进展情况和重要的产品节点。', '所有的里程碑发布个数求和\r\n过滤已删除的发布', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'release', 'released', 'php', '按系统统计的年度新增发布数', 'count_of_annual_created_release', 'count', NULL, '按系统统计的年度新增产品发布数量反映了组织在特定年度内新增发布的产品数量，用于评估组织的出汗品的创新能力、市场竞争力，以及业务增长和收益潜力。', '所有的发布个数求和\r\n发布时间为某年\r\n过滤已删除的发布', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'release', 'released', 'php', '按系统统计的月度新增发布数', 'count_of_monthly_created_release', 'count', NULL, '按系统统计的月度新增产品发布数量反映了组织在特定月份内新增发布的产品数量，用于评估组织的产品开发效率、市场适应能力和产品组合优化。', '所有的发布个数求和\r\n发布时间为某年某月\r\n过滤已删除的发布', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'release', 'released', 'php', '按系统统计的每周新增发布数', 'count_of_weekly_created_release', 'count', NULL, '按系统统计的每周新增发布数表示每周新增加的发布数量。反映了组织每周增加的发布数量，用于评估组织产品发布的速度和规模。', '所有的发布个数求和\r\n发布时间为某周\r\n过滤已删除的发布\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的研发需求总数', 'count_of_story', 'count', NULL, '按系统统计的研发需求的数量反映了组织在特定时间段内的研发需求数量，用于评估组织的研发投入、技术创新能力和市场竞争力，并提供绩效评估。', '所有的研发需求个数求和\r\n过滤已删除的研发需求', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的已关闭研发需求数', 'count_of_closed_story', 'count', NULL, '按系统统计的已关闭的产品研发需求数量反映了组织在特定时间段内已经关闭的产品研发需求数量，用于评估组织的研发决策效果、优化资源管理和提供绩效评估和成果。', '所有的研发需求个数求和\r\n状态为已关闭\r\n过滤已删除的研发需求', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的已完成研发需求数', 'count_of_finished_story', 'count', NULL, '按系统统计的已完成研发需求数反映了组织在特定时间段内已经完成的产品研发需求数量，用于评估评组织的估研发成果、产品创新和竞争力，并提供绩效评估。', '所有的研发需求个数求和\r\n关闭原因为已完成\r\n过滤已删除的研发需求', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的未关闭研发需求数', 'count_of_unclosed_story', 'count', NULL, '按系统统计的未关闭的产品研发需求数量反映了组织在特定时间段内尚未关闭的产品研发需求数量，用于评估组织评估研发进度、需求管理和资源规划，并提供对需求可行性和商业价值的评估。', '复用：\r\n按系统统计的研发需求总数\r\n按系统统计的已关闭研发需求数\r\n公式：按系统统计的未关闭研发需求数=按系统统计的研发需求总数-按系统统计的已关闭研发需求数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的无效研发需求数', 'count_of_invalid_story', 'count', NULL, '按系统统计的无效的产品研发需求数量反映了组织在特定时间段内无效或被废弃的产品研发需求数量，用于评估组织的帮助组织评估需求管理效果、资源利用效率和需求准确性，提供学习和改进的机会。', '所有的研发需求个数求和\r\n关闭原因为重复、不做、设计如此和已取消\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的有效研发需求数', 'count_of_valid_story', 'count', NULL, '按系统统计的有效的产品研发需求数量反映了组织在特定时间段内有效的产品研发需求数量，用于评估组织的评估需求质量、市场适应性、研发投资回报和竞争力。', '复用：\r\n按系统统计的无效研发需求数\r\n按系统统计的研发需求总数\r\n公式：\r\n按系统统计的有效研发需求数=按系统统计的研发需求总数-按系统统计的无效研发需求数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的已交付研发需求数', 'count_of_delivered_story', 'count', NULL, '按系统统计的已交付的产品研发需求数量反映了组织在特定时间段内已交付的产品研发需求数量，用于评估组织的交付能力、项目执行效率、产品质量和客户满意度。', '所有的研发需求个数求和\r\n阶段为已发布或关闭原因为已完成\r\n过滤已删除的研发需求', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的年度新增研发需求数', 'count_of_annual_created_story', 'count', NULL, '按系统统计的年度新增的产品研发需求数量反映了组织在每年新增的产品研发需求数量，用于评估组织的创新能力、需求发现和优先级制定、投资决策以及绩效评估与持续改进。', '所有的研发需求个数求和\r\n创建时间为某年\r\n过滤已删除的研发需求', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的年度完成研发需求数', 'count_of_annual_finished_story', 'count', NULL, '按系统统计的年度完成的研发需求数量反映了组织在每年完成的研发需求数量，用于评估组织的研发活动的产出、项目管理能力、产品质量和市场竞争力具有重要意义。有助于优化资源规划、提高研发效率，并推动持续改进和创新。', '所有的研发需求个数求和\r\n关闭时间为某年\r\n关闭原因为已完成\r\n过滤已删除的研发需求', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的月度新增研发需求数', 'count_of_monthly_created_story', 'count', NULL, '按系统统计的月度新增的研发需求数量反映了组织每个月内新增的研发需求数量，用于评估组织的研发活动的监测、需求管理、项目规划、绩效评估和决策支持具有重要意义。它提供了一个动态的指标，为组织提供了实时的数据支持，以便更好地管理和优化研发活动。', '所有的研发需求个数求和\r\n创建时间为某年某月\r\n过滤已删除的研发需求', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的月度完成研发需求数', 'count_of_monthly_finished_story', 'count', NULL, '按系统统计的月度完成研发需求数量反映了组织每个月内完成的研发需求数量，用于评估组织的绩效评估、进度跟踪、资源规划、经验积累和持续改进具有重要意义。', '所有的研发需求个数求和\r\n关闭时间为某年某月\r\n关闭原因为已完成\r\n过滤已删除的研发需求', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的年度交付研发需求数', 'count_of_annual_delivered_story', 'count', NULL, '按系统统计的年度交付的研发需求数量反映了组织在一年内交付的研发需求数量，可以用于评估组织的交付能力评估、项目管理、客户满意度、绩效评估和持续改进具有重要意义。', '所有的研发需求个数求和\r\n阶段为已发布且发布时间为某年或关闭原因为已完成且关闭时间为某年的\r\n过滤已删除的研发需求', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的研发需求规模总数', 'scale_of_story', 'count', NULL, '按系统统计的研发需求规模总数反映了组织在所有研发需求上的规模总数，用于评估组织对于研发资源规划、技术能力评估、需求管理、风险评估和绩效评估具有重要意义。', '所有的研发需求规模数求和\r\n过滤父研发需求\r\n过滤已删除的研发需求', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的已完成研发需求规模数', 'scale_of_finished_story', 'count', NULL, '按系统统计的已完成研发需求规模数反映了组织在已完成的研发需求上的规模总数，用于评估组织对于研发进展评估、质量控制、绩效评估和持续改进具有重要意义。', '所有的研发需求规模数求和\r\n关闭原因为已完成\r\n过滤父研发需求\r\n过滤已删除的研发需求', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的无效研发需求规模数', 'scale_of_invalid_story', 'count', NULL, '按系统统计的无效的研发需求规模数反映了组织中无效的研发需求的规模总数，用于评估组织对于资源管理、需求管理、质量控制、风险评估和持续改进具有重要意义。', '所有的研发需求规模数求和\r\n关闭原因为重复、不做、设计如此和已取消\r\n过滤父研发需求\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的有效研发需求规模数', 'scale_of_valid_story', 'count', NULL, '按系统统计的有效的研发需求规模数反映了组织中有效的研发需求的规模总数，用于评估组织对于项目成果评估、资源规划、目标达成度评估、绩效评估和持续改进具有重要意义。', '复用：\r\n按系统统计的无效研发需求规模数\r\n按系统统计的研发需求规模数\r\n公式：\r\n按系统统计的有效研发需求数=按系统统计的研发需求规模数-按系统统计的无效研发需求规模数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的年度完成研发需求规模数', 'scale_of_annual_finished_story', 'count', NULL, '按系统统计的年度完成的研发需求规模数反映了组织在年度期间完成的研发需求的规模总数，用于评估组织对于绩效评估、规划和资源管理、风险评估、学习和持续改进以及组织透明度和沟通具有重要意义。', '所有的研发需求规模数求和\r\n关闭时间为某年\r\n关闭原因为已完成\r\n过滤父研发需求\r\n过滤已删除的研发需求', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的年度交付研发需求规模数', 'scale_of_annual_delivered_story', 'count', NULL, '按系统统计的年度交付的研发需求规模数反映了组织在年度期间交付的研发需求的规模总数，用于评估组织对于项目交付评估、绩效评估、资源规划、风险评估、学习和持续改进具有重要意义。', '所有研发需求规模数求和\r\n阶段为已发布且发布时间为某年或关闭原因为已完成且关闭时间为某年\r\n过滤父研发需求\r\n过滤已删除的研发需求', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的年度关闭研发需求规模数', 'scale_of_annual_closed_story', 'count', NULL, '按系统统计的年度关闭的研发需求规模数反映了组织在年度期间关闭的研发需求的规模总数，用于评估组织对于项目管理和控制、绩效评估、资源规划、风险评估、学习和持续改进具有重要意义。', '所有的研发需求规模数求和\r\n关闭时间为某年\r\n过滤父研发需求\r\n过滤已删除的研发需求', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的月度完成研发需求规模数', 'scale_of_monthly_finished_story', 'count', NULL, '按系统统计的月度完成的研发需求规模数反映了组织在每个月完成的研发需求的规模总数，用于评估组织对于进度监控、绩效评估、资源规划、风险评估、持续改进和敏捷性具有重要意义。', '所有的研发需求规模数求和\r\n关闭时间为某年某月\r\n关闭原因为已完成\r\n过滤父研发需求\r\n过滤已删除的研发需求', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的月度交付研发需求规模数', 'scale_of_monthly_delivered_story', 'count', NULL, '按系统统计的月度交付的研发需求规模数反映了组织在每个月交付的研发需求的规模总数，用于评估组织对于交付能力评估、绩效评估、项目管理和控制、客户满意度和信任建立、持续改进和效率提升具有重要意义。', '所有的研发需求规模数求和\r\n阶段为已发布且发布时间为某年某月或关闭原因为已完成且关闭时间为某年某月\r\n过滤父研发需求\r\n过滤已删除的研发需求', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的月度关闭研发需求规模数', 'scale_of_monthly_closed_story', 'count', NULL, '按系统统计的月度关闭的研发需求规模数反映了组织在每个月关闭的研发需求的规模总数，用于评估组织对于项目管理和控制、绩效评估、资源规划和利用、风险评估、持续改进和效率提升具有重要意义。', '所有的研发需求规模数求和\r\n关闭时间为某年某月\r\n过滤父研发需求\r\n过滤已删除的研发需求', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的每周完成研发需求规模数', 'scale_of_weekly_finished_story', 'measure', NULL, '按系统统计的每周完成研发需求规模数表示每周完成的研发需求的数量。反映了组织每周完成的研发需求数量，用于评估项目进度、资源规划、需求管理、团队绩效和质量控制的有用信息。它对于项目管理和团队协作具有重要意义，并可以帮助团队监控进度、优化资源利用和提高研发效率。', '所有的研发需求个数求和\r\n关闭时间为某周\r\n关闭原因为已完成\r\n过滤父需求\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的每周完成需求数', 'count_of_weekly_finished_story', 'count', NULL, '按系统统计的每周完成需求数是指每周已关闭且关闭原因为已完成的研发需求数量。反映了团队在每周的开发效率和成果，用于评估需求管理、项目进度、资源规划、绩效评估和质量控制的有用信息。它对于项目管理和团队协作具有重要意义，并可以帮助团队监控进度、优化资源利用和提高工作效率。', '所有研发需求的个数求和。\r\n关闭时间在某周。\r\n关闭原因为已完成。\r\n过滤已删除的研发需求。\r\n过滤已删除的产品。', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'story', 'released', 'php', '按系统统计的每日新增研发需求数', 'count_of_daily_created_story', 'count', NULL, '按系统统计的每日新增研发需求数表示每日新增加的研发需求的数量，可以用于评估组织的研发需求增长和规模扩展情况。', '所有的研发需求个数求和\r\n创建时间为某日\r\n过滤已删除的研发需求', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('rate', 'system', 'story', 'released', 'php', '按系统统计的研发需求完成率', 'rate_of_finished_story', 'percentage', NULL, '按系统统计的研发需求完成率反映了组织按系统统计的已完成研发需求数和按系统统计的有效研发需求数之间的比率，用于评估组织对于进度控制、绩效评估、风险评估、资源规划和利用，以及持续改进和效率提升具有重要意义。', '复用：\r\n按系统统计的完成研发需求数\r\n按系统统计的有效研发需求数\r\n公式：\r\n按系统统计的研发需求完成率=按系统统计的已完成研发需求数/按系统统计的有效研发需求数*100%', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('rate', 'system', 'story', 'released', 'php', '按系统统计的研发需求交付率', 'rate_of_delivered_story', 'percentage', NULL, '按系统统计的研发需求交付率反映了组织在研发过程中按时交付需求的能力和表现。用于评估组织对于评估交付能力、客户满意度和信任建立、项目管理和资源优化、竞争力和市场表现，以及持续改进和效率提升具有重要意义。', '复用：\r\n按系统统计的已交付研发需求数\r\n按系统统计的有效研发需求数\r\n公式：\r\n按系统统计的研发需求完成率=按系统统计的已交付研发需求数/按系统统计的有效研发需求数*100%', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('rate', 'system', 'story', 'released', 'php', '按系统统计的年度研发需求完成率', 'rate_of_annual_finished_story', 'percentage', NULL, '按系统统计的年度研发需求完成率反映了组织在年度研发过程中完成需求的能力和表现，反映了组织对于评估项目目标达成、资源规划和优化、业务决策和战略执行、绩效评估和激励机制，以及持续改进和效率提升具有重要意义。', '复用：\r\n按系统统计的年度完成研发需求数\r\n按系统统计的年度有效研发需求数\r\n公式：\r\n按系统统计的年度研发需求完成率=按系统统计的年度完成研发需求数/按系统统计的年度有效研发需求数*100%', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('rate', 'system', 'story', 'released', 'php', '按系统统计的年度研发需求交付率', 'rate_of_annual_delivered_story', 'percentage', NULL, '按系统统计的年度研发需求交付率反映了组织在年度研发过程中按时交付需求的能力和表现，用于评估组织对于评估项目交付能力、客户满意度和信任建立、项目进度管理和风险控制、绩效评估和激励机制，以及持续改进和效率提升具有重要意义。', '复用：\r\n按系统统计的年度交付研发需求数\r\n按系统统计的年度有效研发需求数\r\n公式：\r\n按系统统计的年度研发需求完成率=按系统统计的年度交付研发需求数/按系统统计的年度有效研发需求数*100%', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'task', 'released', 'php', '按系统统计的任务总数', 'count_of_task', 'count', NULL, '按系统统计的任务总数是指整个团队或组织当前存在的任务总量。该度量项可以用来跟踪任务的规模和复杂性，为资源分配和工作计划提供基础。较大的任务总数可能需要更多的资源和时间来完成，而较小的任务总数可能意味着团队负荷较轻或项目进展较好。', '所有的任务个数求和\r\n过滤已删除的任务', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'task', 'released', 'php', '按系统统计的已完成任务数', 'count_of_finished_task', 'count', NULL, '按系统统计的已完成任务数是指团队或组织已经完成的任务总量。该度量项可以衡量任务完成的进度和效率，以及团队成员或组织的工作质量和产出。较高的已完成任务总数可能表明团队在交付工作方面表现出较好的能力。', '所有的任务个数求和\r\n状态为已完成\r\n过滤已删除的任务', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'task', 'released', 'php', '按系统统计的未完成任务数', 'count_of_unfinished_task', 'count', NULL, '按系统统计的未完成任务数是指团队或组织未完成的任务总量。该度量项可以用来评估项目进展和未来工作量，同时也可以帮助进行资源分配和优先级确定。较大的未完成任务总数可能需要更多的努力和调整来确保任务按时完成。', '复用：\r\n按系统统计的任务总数\r\n按系统统计的已完成任务数\r\n公式：\r\n按系统统计的未完成任务数=按系统统计的任务总数-按系统统计的已完成任务数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'task', 'released', 'php', '按系统统计的已关闭任务数', 'count_of_closed_task', 'count', NULL, '按系统统计的已关闭任务数是指团队或组织已经关闭的任务总量。该度量项可以用来评估项目或团队的运营情况和任务管理效果。较高的已关闭任务总数可能表明团队在任务管理方面表现出较好的能力，同时也可以释放资源和优先处理其他任务。', '所有的任务个数求和\r\n状态为已关闭\r\n过滤已删除的任务', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'task', 'released', 'php', '按系统统计的年度新增任务数', 'count_of_annual_created_task', 'count', NULL, '按系统统计的年度新增任务数是指一年内新添加的任务总量。该度量项可以用来衡量团队或组织在某年内所承担的新增工作量。较高的年度新增任务数可能需要额外的资源和计划调整来满足需求。', '所有的任务个数求和\r\n创建时间为某年\r\n过滤已删除的任务', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'task', 'released', 'php', '按系统统计的年度完成任务数', 'count_of_annual_finished_task', 'count', NULL, '按系统统计的年度完成任务数是指某年内已经完成的任务总量。该度量项可以用来评估团队或组织在某年内的工作效率和完成能力。较高的年度完成任务数表示团队或组织在项目执行方面表现出较好的效率。', '所有的任务个数求和\r\n完成时间为某年\r\n过滤已删除的任务', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'task', 'released', 'php', '按系统统计的月度新增任务数', 'count_of_monthly_created_task', 'count', NULL, '按系统统计的月度新增任务数是指在某月新添加的任务总量。该度量项可以用来衡量团队或组织在某月内所承担的新增工作量，以及对项目规划和资源分配的影响。较高的月度新增任务数可能需要额外的资源和计划调整来满足需求。', '所有的任务个数求和\r\n创建时间为某年某月\r\n过滤已删除的任务', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'task', 'released', 'php', '按系统统计的月度完成任务数', 'count_of_monthly_finished_task', 'count', NULL, '按系统统计的月度完成任务数是指在某月已经完成的任务总量。该度量项可以用来评估团队或组织在某月内的工作效率和完成能力。较高的月度完成任务数表示团队或组织在项目执行方面表现出较好的效率。', '所有的任务个数求和\r\n完成时间为某年某月\r\n过滤已删除的任务', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'task', 'released', 'php', '按系统统计的任务预计工时数', 'estimate_of_task', 'hour', NULL, '按系统统计的任务预计工时数是指所有任务预计完成所需的工时总和。该度量项可以用来规划资源和预估工期，为项目管理和团队协作提供依据。较准确的任务预计工时总数可以帮助团队更好地安排时间和资源，提高任务的完成效率。', '所有的任务的预计工时数求和\r\n过滤父任务\r\n过滤已删除的任务', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'task', 'released', 'php', '按系统统计的任务消耗工时数', 'consume_of_task', 'hour', NULL, '按系统统计的任务消耗工时数是指已经花费的工时总和，用于完成所有任务。该度量项可以用来评估团队或组织在任务执行过程中的工时投入情况，以及在完成任务方面的效率和资源利用情况。较高的任务消耗工时总数可能表明需要审查工作流程和资源分配，以提高工作效率。', '所有的任务的消耗工时数求和\r\n过滤父任务\r\n过滤已删除的任务', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'task', 'released', 'php', '按系统统计的任务剩余工时数', 'left_of_task', 'hour', NULL, '按系统统计的任务剩余工时数是指任务当前剩余工时的总和，用于完成所有任务。该度量项可以用来评估团队或组织在任务执行过程中剩余的工作量和时间，以及为完成任务所需的资源和计划。较小的任务剩余工时总数可能表示团队即将完成任务。', '所有的任务的剩余工时数求和\r\n过滤父任务\r\n过滤已删除的任务', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'task', 'released', 'php', '按系统统计的每日完成任务数', 'count_of_daily_finished_task', 'count', NULL, '按系统统计的每日完成任务数是指每日完成的任务总量。该度量项可以用来评估团队或组织每日的工作效率和任务完成能力。', '所有的任务个数求和\r\n完成时间为某日\r\n过滤已删除的任务', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'bug', 'released', 'php', '按系统统计的Bug总数', 'count_of_bug', 'count', NULL, '按系统统计的Bug总数是指在整个系统中发现的所有Bug的数量。这个度量项反映了系统或项目的整体Bug质量情况。Bug总数越多可能代表系统或项目的代码质量存在问题，需要进行进一步的解决和改进。', '所有Bug个数求和\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'bug', 'released', 'php', '按系统统计的激活Bug数', 'count_of_activated_bug', 'count', NULL, '按系统统计的激活Bug数是指当前尚未解决的Bug数量。这个度量项反映了系统或项目当前存在的待解决问题数量。激活Bug总数越多可能代表系统或项目的稳定性较低，需要加强Bug解决的速度和质量。', '所有Bug个数求和\r\n状态为激活\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'bug', 'released', 'php', '按系统统计的已解决Bug数', 'count_of_resolved_bug', 'count', NULL, '按系统统计的已解决Bug数是指已经被开发团队解决的Bug数量。反映了组织在特定时间段内已解决的Bug数量，用于评估系统质量、用户满意度、资源管理、过程改进和绩效评估等方面。通过跟踪和分析已解决的Bug数，可以及时发现问题、改进开发过程、提高用户满意度，并为团队绩效评估和优化提供依据。', '所有Bug个数求和\r\n状态为已解决\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'bug', 'released', 'php', '按系统统计的已关闭Bug总数', 'count_of_closed_bug', 'count', NULL, '按系统统计的已关闭Bug总数是指已经被关闭的Bug数量。反映了组织特定时间段内已关闭的Bug数量，用于评估系统质量、进度管理、资源管理、过程改进和绩效评估等方面。通过跟踪和分析已关闭的Bug总数，可以及时发现问题、改进开发过程、提高项目进度，并为团队绩效评估和优化提供依据。', '所有Bug个数求和\r\n状态为已关闭\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'bug', 'released', 'php', '按系统统计的未关闭Bug数', 'count_of_unclosed_bug', 'count', NULL, '按系统统计的未关闭Bug数是指当前仍然存在但未关闭的Bug数量。反映了组织在特定时间段内尚未解决的Bug数量，用于评估系统质量、问题管理、优先级和计划调整、资源管理以及过程改进等方面。通过跟踪和分析未关闭的Bug数，可以及时发现问题、优化问题处理流程、合理安排资源，并为团队的质量管理和持续改进提供依据。', '复用：\r\n按系统统计的Bug总数\r\n按系统统计的已关闭Bug数\r\n公式：\r\n按系统统计的未关闭Bug数=按系统统计的Bug总数-按系统统计的已关闭Bug数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'bug', 'released', 'php', '按系统统计的已修复Bug数', 'count_of_fixed_bug', 'count', NULL, '按系统统计的已修复Bug数是指解决并关闭的Bug数量。反映了组织在特定时间段内已经修复的Bug数量，用于评估系统质量、问题管理、进度管理、资源管理以及过程改进等方面。通过跟踪和分析已修复的Bug数，可以及时发现问题、优化问题处理流程、提高项目进度，并为团队的质量管理和持续改进提供依据。', '所有Bug个数求和\r\n状态为已关闭\r\n解决方案为已解决\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'bug', 'released', 'php', '按系统统计的有效Bug数', 'count_of_valid_bug', 'count', NULL, '按系统统计的有效Bug数是指系统或项目中真正具有影响和价值的Bug数量。反映了一个系统或软件中有效的Bug数量。有效Bug是指经过验证和确认的真实问题，需要进行修复和解决的Bug。用于评估系统质量、问题管理、资源管理、过程改进以及用户满意度等方面。通过跟踪和分析有效Bug数，可以及时发现问题、优化问题处理流程、合理安排资源，并为团队的质量管理和持续改进提供依据，同时提升用户满意度和系统质量。', '所有Bug个数求和\r\n解决方案为已解决和延期处理\r\n或状态为激活的Bug数\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'bug', 'released', 'php', '按系统统计的年度新增Bug数', 'count_of_annual_created_bug', 'count', NULL, '按系统统计的年度新增Bug数是指在一年内新发现的Bug数量。反映了一个系统或软件每年新增的Bug数量，用于评估评估系统质量、变更管理、资源规划、过程改进和趋势分析等方面。', '所有Bug个数求和\r\n创建时间为某年\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'bug', 'released', 'php', '按系统统计的年度修复Bug数', 'count_of_annual_fixed_bug', 'count', NULL, '按系统统计的年度修复Bug数是指在一年内解决并关闭的Bug数量。反映了一个系统或软件在一年内修复的Bug数量，用于评估系统质量改进、用户满意度、故障管理、变更管理和资源规划等方面。通过跟踪和分析年度修复Bug数，可以及时发现和解决问题，改善系统的质量和可靠性。同时，通过Bug修复数的评估，可以提高用户满意度、优化故障管理流程、控制变更质量，合理安排资源，从而提升整体的研发效果和项目交付质量。', '所有Bug个数求和\r\n状态为已关闭\r\n解决方案为已解决\r\n关闭时间为某年\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'bug', 'released', 'php', '按系统统计的月度新增Bug数', 'count_of_monthly_created_bug', 'count', NULL, '按系统统计的月度新增Bug数是指在一个月内新发现的Bug数量。反映了一个系统或软件每个月新增的Bug数量，用于评估及时发现问题、变更管理与影响评估、趋势分析与问题预测以及资源规划与优化等方面。通过跟踪和分析月度新增Bug数，可以及时发现质量问题、优化变更管理、预测系统质量趋势，并合理安排资源，从而提升系统的质量和可靠性。', '所有Bug个数求和\r\n创建时间为某年某月\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'bug', 'released', 'php', '按系统统计的月度修复Bug数', 'count_of_monthly_fixed_bug', 'count', NULL, '按系统统计的月度修复Bug数是指在一个月内解决并关闭的Bug数量。反映了一个系统或软件每个月修复的Bug数量，用于评估质量改进、故障管理、变更管理、资源规划以及趋势分析与问题预测等方面。通过跟踪和分析月度修复Bug数，可以及时发现和解决问题，改善系统的质量和可靠性。', '所有Bug个数求和\r\n状态为已关闭\r\n解决方案为已解决\r\n关闭时间为某年某月\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'bug', 'released', 'php', '按系统统计的每日关闭Bug数', 'count_of_daily_closed_bug', 'count', NULL, '按系统统计的每日关闭Bug数是指组织每日被确认并关闭的Bug的数量。该度量项可以帮助我们了解组织对已解决的Bug进行确认与关闭的速度和效率。', '所有每日关闭的Bug数求和\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('rate', 'system', 'bug', 'released', 'php', '按系统统计的Bug修复率', 'rate_of_fixed_bug', 'percentage', NULL, '按系统统计的Bug修复率是指已修复的Bug占相对于有效Bug数量的比例。反映了一个系统或软件中Bug修复的效率和速度，用于评估质量改进、故障管理、用户满意度、变更管理以及团队绩效评估与改进等方面。通过跟踪和分析Bug修复率，可以评估团队在修复Bug方面的效率和能力，及时发现和解决问题，提高系统的质量和可靠性。', '复用：\r\n按系统统计的已修复Bug数\r\n按系统统计的有效Bug数\r\n公式：\r\n按系统统计的Bug修复率=按系统统计的已修复Bug数/按系统统计的有效Bug数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'case', 'released', 'php', '按系统统计的用例总数', 'count_of_case', 'count', NULL, '按系统统计的用例总数是指系统或项目中的测试用例总数量。反映了一个系统或软件的功能广度和复杂性，用于评估功能完整性、需求管理、项目规模评估、测试覆盖度评估以及变更管理等方面。通过统计和跟踪用例总数，可以评估系统的功能广度和复杂性，帮助团队进行需求管理、项目规模评估、测试覆盖和变更管理，从而提高系统的开发效率和质量。', '所有用例个数求和\r\n过滤已删除的用例\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'case', 'released', 'php', '按系统统计的年度新增用例数', 'count_of_annual_created_case', 'count', NULL, '按系统统计的年度新增用例数是指在一年内新增的测试用例数量。统计年度新增用例数可以帮助评估系统或项目在不同阶段的测试覆盖和测试深度。年度新增用例数的增加可能意味着对新功能和需求进行了更充分的测试。', '所有用例个数求和\r\n创建时间在某年\r\n过滤已删除的用例\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'case', 'released', 'php', '按系统统计的每日执行用例次数', 'count_of_daily_run_case', 'count', NULL, '按系统统计的每日执行用例次数表示组织每日执行的用例次数，这个度量项可以反映测试团队每日的工作效率和进展情况。', '所有用例的执行次数求和\r\n过滤已删除的用例\r\n过滤已删除的产品\r\n执行时间为某日', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'user', 'released', 'php', '按系统统计的用户总数', 'count_of_user', 'count', NULL, '按系统统计的人员总数是指在项目或系统中参与开发和管理的人员总数。反映了系统的用户基础和用户规模，用于评估组织内部资源、增长趋势等方面的有用信息。这对于组织发展、内部管理和战略决策具有重要意义。', '系统所有用户个数求和\r\n过滤已删除的用户', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'user', 'released', 'php', '按系统统计的年度添加用户数', 'count_of_annual_created_user', 'count', NULL, '按系统统计的年度新增人员数是指在一年内新增加到项目或系统中的人员数量。反映了系统或平台在一年内新增用户数量的指标，用于评估团队扩充和人员流动情况。年度新增人员数的增加可能意味着团队的增加或项目的扩大。', '系统所有用户个数求和\r\n添加时间为某年', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('hour', 'system', 'effort', 'released', 'php', '按系统统计的年度日志记录的工时总数', 'hour_of_annual_effort', 'hour', NULL, '按系统统计的年度日志记录的工时总数是指组织在某年度实际花费的总工时数。该度量项可以用来评估组织的工时投入情况和对资源的利用效率。较高的消耗工时数可能需要审查工作流程和资源分配，以提高工作效率和进度控制。', '所有日志记录的工时之和\r\n记录时间在某年', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('hour', 'system', 'effort', 'released', 'php', '按系统统计的年度投入总人天', 'day_of_annual_effort', 'manday', NULL, '按系统统计的年度投入总人天是指团队总共投入的工作天数。该度量项可以用来评估人力资源投入情况。投入总人天的增加可能意味着项目投入的工作时间和资源的增加。', '复用：\r\n按系统统计的年度日志记录的工时总数\r\n公式：\r\n按系统统计的年度投入总人天=按系统统计的年度日志记录的工时总数/后台配置的每日可用工时', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('hour', 'system', 'effort', 'released', 'php', '按系统统计的每日投入总人天', 'day_of_daily_effort', 'manday', NULL, '按系统统计的每日投入总人天是指团队每日投入的工作量。该度量项可以用来评估每日人力资源投入情况。', '复用：\r\n按系统统计的每日日志记录的工时总数\r\n公式：\r\n按系统统计的每日投入总人天=按系统统计的每日日志记录的工时总数/后台配置的每日可用工时', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('hour', 'system', 'effort', 'released', 'php', '按系统统计的每日日志记录的工时总数', 'hour_of_daily_effort', 'hour', NULL, '按系统统计的每日日志记录的工时总数是指组织每日实际花费的总工时数。该度量项可以用来评估组织的工时投入情况和对资源的利用效率。较高的消耗工时数可能需要审查工作流程和资源分配，以提高工作效率和进度控制。', '所有日志记录的工时之和\r\n记录时间在某日', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'doc', 'released', 'php', '按系统统计的文档总数', 'count_of_doc', 'count', NULL, '按系统统计的文档总数是指系统或组织中存在的所有文档数量的统计值。反映了整体文档管理的规模和复杂度。文档总数越大，代表着组织的信息量越丰富，也可能意味着需要更多的资源来维护和管理这些文档。', '所有文档个数求和\r\n过滤已删除的文档', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'doc', 'released', 'php', '按系统统计的年度新增文档个数', 'count_of_annual_created_doc', 'count', NULL, '按系统统计的年度新增文档个数是指在某年度系统或组织中新建的文档数量。反映了组织中信息产生的速度和增长的趋势。年度新增文档个数越大，说明组织的信息需求和创造力较强，也可能需要投入更多的资源来管理和维护这些新增文档。该度量项还可以用于评估组织的创新能力和知识管理水平。', '所有文档个数求和\r\n创建时间为某年\r\n过滤已删除的文档', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'feedback', 'released', 'php', '按系统统计的反馈总数', 'count_of_feedback', 'count', NULL, '按系统统计的反馈总数是指收集到的所有用户反馈的数量。这个度量项可以帮助团队了解用户对产品的关注点和问题，并作为改进产品质量和用户满意度的依据。较高的反馈总数可能暗示着用户的活跃度和关注度较高，需要团队及时响应和处理，同时暗示产品问题可能有很多。', '所有的反馈个数求和\r\n过滤已删除的反馈\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'feedback', 'released', 'php', '按系统统计的已关闭反馈数', 'count_of_closed_feedback', 'count', NULL, '按系统统计的已关闭反馈数是指已经处理完毕并关闭的用户反馈的数量。这个度量项可以反映团队对用户反馈的关注度和处理效率。较高的已关闭反馈总数可能意味着团队能够及时响应用户反馈，并持续改进产品以解决用户问题。', '所有的反馈个数求和\r\n状态为已关闭\r\n过滤已删除的反馈', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'feedback', 'released', 'php', '按系统统计的年度新增反馈数', 'count_of_annual_created_feedback', 'count', NULL, '按系统统计的年度新增反馈数是指在某年度收集到的用户反馈的数量。这个度量项可以帮助团队了解用户对产品的发展趋势和需求变化，并进行产品策略的调整和优化。较高的年度新增反馈数可能暗示着产品的用户基础扩大或者功能迭代带来了更多用户参与。', '所有的反馈个数求和\r\n创建时间为某年\r\n过滤已删除的反馈', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'feedback', 'released', 'php', '按系统统计的年度关闭反馈数', 'count_of_annual_closed_feedback', 'count', NULL, '按系统统计的年度关闭反馈数是指在某年度处理并关闭的用户反馈的数量。这个度量项可以帮助团队评估在某年度对用户反馈的响应能力和问题解决能力。较高的年度关闭反馈数可能暗示着团队能够高效地解决用户反馈并持续改进产品，提升用户满意度和产品质量。', '所有的反馈个数求和\r\n关闭时间为某年\r\n过滤已删除的反馈', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'code', 'released', 'php', '按系统统计的代码库总数', 'count_of_codebase', 'count', NULL, '按系统统计的代码库总数是指整个研发团队中维护的所有代码库的总数量。通过统计代码库总数可以了解团队的代码库规模和复杂性。', '所有代码库的个数求和，不统计已删除xxxxx', 'realtime', '', '', '', '', NULL, '', NULL, '', NULL, '', NULL, '0', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'pipeline', 'released', 'php', '按系统统计流水线总数', 'count_of_pipeline', '', NULL, '按系统统计的流水线总数是指系统中所有流水线的数量统计，它反映了项目或组织在软件开发和交付过程中采用自动化流程的程度。', '所有流水线的个数求和\r\n不统计已删除', 'realtime', '', '', '', '', NULL, '', NULL, '', NULL, '', NULL, '0', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'artifact', 'released', 'php', '按系统统计制品库总数', 'count_of_artifactrepo', '', NULL, '按系统统计的制品库总数是指统计所有产品的制品库总数，它反映了研发团队所管理的制品数量。该度量项可以帮助团队可以评估制品管理的复杂性和效率，并根据需要进行合理的优化和调整。', '所有制品库的个数求和\r\n不统计已删除', 'realtime', '', '', '', '', NULL, '', NULL, '', NULL, '', NULL, '0', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'node', 'released', 'php', '按系统统计节点总数', 'count_of_node', '', NULL, '按系统统计的节点总数是指在禅道DevOps平台中使用的全部节点总数。', '所有节点的个数求和', 'realtime', '', '', '', '', NULL, '', NULL, '', NULL, '', NULL, '0', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'system', 'application', 'released', 'php', '按系统统计应用总数', 'count_of_application', '', NULL, '按系统统计的应用总数是指在禅道DevOps平台中使用的全部应用总数。', '所有安装的应用个数求和', 'realtime', '', '', '', '', NULL, '', NULL, '', NULL, '', NULL, '0', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('qc', 'system', 'codebase', 'released', 'php', '按系统统计代码库待处理问题总数', 'count_of_pending_issue', '', NULL, '系统统计的代码库待处理问题总数是指所有代码库中尚未解决的问题数量的统计，它反映了代码库的健康状况和存在的潜在问题数量，通过对问题总数的监控和分析，可以及时发现并解决和解决问题，提高软件开发过程的效率和质量。', '所有代码库的未关闭代码问题个数求和\r\n不统计删除的问题\r\n不统计删除的代码库里的问题', 'realtime', '', '', '', '', NULL, '', NULL, '', NULL, '', NULL, '0', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('qc', 'system', 'codebase', 'released', 'php', '按系统统计代码库中待处理的合并请求总数', 'count_of_pending_mergeRequest', '', NULL, '系统统计的待处理的合并请求总数是指代码库中等待合并的合并请求总数量，它反映了团队在合并代码方面的效率和进展情况，高数量可能意味着合并困难、合并冲突多、代码质量低等问题存在，需及时关注和处理以提升研发效能。', '所有代码库的未关闭的合并请求个数求和 \r\n不统计已删除的合并请求\r\n不统计已删除代码库里的合并请求', 'realtime', '', '', '', '', NULL, '', NULL, '', NULL, '', NULL, '0', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('rate', 'system', 'deployment', 'released', 'php', '按系统统计待处理的上线计划总数', 'count_of_pending_deployment', '', NULL, '按系统统计的待处理的上线计划总数是指所有尚未完成的计划数量。该度量反映了团队在软件交付和发布管理方面的任务积压和工作进展情况。', '所有的未完成的上线计划个数求和 \r\n不统计已删除', 'realtime', '', '', '', '', NULL, '', NULL, '', NULL, '', NULL, '0', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'productplan', 'released', 'php', '按产品统计的计划总数', 'count_of_productplan_in_product', 'count', NULL, '按产品统计的计划总数是指产品团队创建的所有计划数量。这个度量项可以反映产品团队的规划能力。适当的计划数量可以促进团队高效完成需求。', '产品中计划的个数求和\r\n过滤已删除的计划\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'productplan', 'released', 'php', '按产品统计的年度新增计划数', 'count_of_annual_created_productplan_in_product', 'count', NULL, '按产品统计的年度新增计划数是指某年度产品团队新创建的计划数量。这个度量项可以反映产品团队对于新需求的接收能力和规模的扩展。新增计划数越多，说明产品团队在该年度内面临着更多的新挑战和需求。', '产品中创建时间为某年的计划个数求和\r\n过滤已删除的计划\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'productplan', 'released', 'php', '按产品统计的年度完成计划数', 'count_of_annual_finished_productplan_in_product', 'count', NULL, '按产品统计的年度完成计划数是指某年度产品团队实际完成的计划数量。这个度量项可以反映产品团队在规划和执行过程中的效率和执行能力。完成计划数越多，说明产品团队在该年度内可能取得了更多的成果和交付物。', '产品中计划个数求和\r\n完成时间为某年\r\n过滤已删除的计划\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'release', 'released', 'php', '按产品统计的发布总数', 'count_of_release_in_product', 'count', NULL, '按产品统计的发布总数是指产品中所有发布的数量。这个度量项可以反映产品团队对产品发布的频率和稳定性的掌控程度。发布总数越多，说明产品团队有更多的迭代和产品版本更新。', '产品中发布的个数求和\r\n过滤已删除的发布\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'release', 'released', 'php', '按产品统计的年度新增发布数', 'count_of_annual_created_release_in_product', 'count', NULL, '按产品统计的年度新增发布数是指某年度产品中新增加的发布数量，该度量项可以反映产品团队在该年度内对产品新功能和改进的发布能力和速度。新增发布数越多，说明产品团队在该年度内推出了更多的新功能和改进。', '产品中发布个数求和\r\n发布时间为某年\r\n过滤已删除的发布\r\n过滤已删除的产品\r\n过滤无效时间', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'release', 'released', 'php', '按产品统计的月度新增发布数', 'count_of_monthly_created_release_in_product', 'count', NULL, '按产品统计的月度新增发布数是指在某月产品中新增加的发布数量。这个度量项可以反映产品团队在该月内对新功能和改进的发布能力和速度。新增发布数越多，说明产品团队在该月内推出了更多的新功能和改进。', '产品中发布时间为某年某月的发布个数求和\r\n过滤已删除的发布\r\n过滤已删除的产品\r\n过滤无效时间', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的研发需求总数', 'count_of_story_in_product', 'count', NULL, '按产品统计的研发需求总数是指产品中创建的所有研发需求的数量。这个度量项可以反映团队需进行研发工作的规模。研发需求总数越多，可能意味着产品规模越大，面临的开发工作越多。', '产品中研发需求的个数求和\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的已完成研发需求数', 'count_of_finished_story_in_product', 'count', NULL, '按产品统计的已完成研发需求数是指状态为已关闭且关闭原因为已完成的研发需求的数量。这个度量项可以反映产品团队在开发过程中的进展和交付能力。已完成研发需求数越多，说明产品团队可能取得了更多的研发成果。', '产品中的研发需求个数求和\r\n阶段为已关闭\r\n关闭原因为已完成\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的已关闭研发需求数', 'count_of_closed_story_in_product', 'count', NULL, '按产品统计的已关闭研发需求数是指产品中已经关闭的研发需求的数量。该度量项反映了产品研发的进展，可以用于评估产品的研发需求管理绩效和成果。较高的已关闭研发需求数可能代表团队取得了越多的研发成果。', '产品中研发需求的个数求和\r\n阶段为已关闭\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的未关闭研发需求数', 'count_of_unclosed_story_in_product', 'count', NULL, '按产品统计的未关闭研发需求数是指产品中未关闭的研发需求的数量。这个度量项可以反映产品团队研发需求的开发进度。未关闭研发需求数越多，说明产品团队的开发工作还有一定的进行中，并需要进一步跟进和完成。', '复用：\r\n按产品统计的研发需求总数\r\n按产品统计的已关闭研发需求数\r\n按产品统计的关闭研发需求总数=按产品统计的研发需求总数-按产品统计的已关闭研发需求数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的已交付研发需求数', 'count_of_delivered_story_in_product', 'count', NULL, '按产品统计的已交付研发需求数表示已交付给用户的研发需求的数量。该度量项反映了产品中已发布或关闭原因为已完成的研发需求的数量，可以用于评估产品的研发需求交付能力。', '产品中研发需求个数求和\r\n所处阶段为已发布或关闭原因为已完成\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的无效研发需求数', 'count_of_invalid_story_in_product', 'count', NULL, '按产品统计的无效研发需求数是指产品中被判定为无效的研发需求的数量。这个度量项可以反映产品团队进行需求管理的有效性和能力。无效研发需求数越多，可能说明产品团队在需求管理中的团队协作能力较弱或对产品理解有偏差等。', '产品中研发需求个数求和\r\n关闭原因为重复、不做、设计如此和已取消\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的有效研发需求数', 'count_of_valid_story_in_product', 'count', NULL, '按产品统计的有效研发需求数是指在在产品中被确认为有效的研发需求数量。有效需求指的是符合产品策略和目标，可以实施并且对用户有价值的需求。较高的有效研发需求数通常表示产品的功能和特性满足了用户和市场的期望，有利于实现产品的成功交付和用户满意度。', '复用：\r\n按产品统计的研发需求总数\r\n按产品统计的无效研发需求数\r\n公式：\r\n按产品统计的有效研发需求数=按产品统计的研发需求总数-按产品统计的无效研发需求数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的研发完毕的研发需求数', 'count_of_developed_story_in_product', 'count', NULL, '按产品统计的研发完毕的研发需求数是指产品中阶段为研发完毕及以后的研发需求的数量。这个度量项可以反映产品在研发过程中的进展和成就。研发完毕的研发需求数越多，说明产品取得了更多的研发成果。', '产品中研发需求个数求和\r\n阶段为（研发完毕、测试中、测试完毕、已验收、已发布）或关闭原因为已完成的\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的已立项研发需求的用例覆盖率', 'case_coverage_of_projected_story_in_product', 'percentage', NULL, '按产品统计的已立项研发需求的用例覆盖率是指产品中已立项研发需求的用例覆盖程度。用例覆盖率可以衡量产品团队对于已立项需求的测试计划和测试用例编写的完整度。较高的用例覆盖率可能表示产品团队有较完整的测试计划。', '复用：\r\n按产品统计的已立项研发需求数\r\n按产品统计的有用例的已立项研发需求数\r\n公式：\r\n按产品统计的已立项研发需求用例覆盖率=按产品统计的有用例的已立项研发需求数/按产品统计的已立项研发需求数\r\n过滤已删除的研发需求\r\n过滤已删除的产品\r\n过滤已删除的用例', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的年度新增研发需求数', 'count_of_annual_created_story_in_product', 'count', NULL, '按产品统计的年度新增研发需求数是指产品在某年度新增的研发需求数量。这个度量项可以反映产品团队在该年度内需求的增长或变化情况。', '产品中研发需求的个数求和\r\n创建时间为某年\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的年度完成研发需求数', 'count_of_annual_finished_story_in_product', 'count', NULL, '按产品统计的年度完成研发需求数是指产品在某年度已关闭且关闭原因为已完成的研发需求数量。这个度量项可以反映产品团队在一年时间内的开发效率和成果。完成研发需求数量的增加说明产品团队在该年度内取得了更多的开发成果和交付物。', '产品中关闭时间在某年且关闭原因为已完成的研发需求的个数求和\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的年度交付研发需求数', 'count_of_annual_delivered_story_in_product', 'count', NULL, '按产品统计的年度交付研发需求数是指产品在某年度内已经成功交付给用户的研发需求数量。这个度量项可以反映产品团队在开发过程中的交付能力和协作能力，可以用于评估产品的研发需求交付效能和效果。已交付的研发需求数量越多可能说明产品团队在该年度内的交付成果越多。', '产品中研发需求个数求和\r\n所处阶段为已发布且发布时间为某年或关闭原因为已完成且关闭时间为某年\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的年度关闭研发需求数', 'count_of_annual_closed_story_in_product', 'count', NULL, '按产品统计的年度关闭研发需求规模数表示产品在某年度关闭的研发需求数。该度量项反映了产品团队每年因完成、不做或取消等原因关闭的研发需求数，可以用于评估产品团队的研发需求规模管理和调整情况。', '产品中关闭时间在某年的研发需求的个数求和\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的月度完成研发需求数', 'count_of_monthly_finished_story_in_product', 'count', NULL, '按产品统计的月度完成研发需求数表示每月完成的研发需求的数量。该度量项反映了产品的月度研发成果，可以用于评估产品团队的研发需求完成情况和效率。', '产品中关闭时间为某年某月且关闭原因为已完成的研发需求的个数求和\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的已立项研发需求数', 'count_of_projected_story_in_product', 'count', NULL, '按产品统计的已立项研发需求数是指产品中已关联进项目的研发需求数。该度量项表示产品中获得批准需要投入资源进行开发的需求数量。产品中较高的已立项研发需求数可能表示产品相关项目的规模越大。', '产品中研发需求个数求和\r\n过滤已删除的产品\r\n过滤已删除的研发需求\r\n研发需求被关联进项目', 'realtime', '', '', '', '', NULL, '', NULL, '', NULL, '', NULL, '0', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的月度交付研发需求数', 'count_of_monthly_delivered_story_in_product', 'count', NULL, '按产品统计的月度交付研发需求数表示每月完成或关联到发布的研发需求的数量。该度量项反映了产品团队每月交付给用户的研发需求数量，可以用于评估产品团队的研发需求交付效能。', '产品中研发需求个数求和\r\n所处阶段为已发布且发布时间为某年某月或关闭原因为已完成且关闭时间为某年某月\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的有用例的已立项研发需求数', 'count_of_projected_story_with_case_in_product', 'count', NULL, '按产品统计的有用例的已立项研发需求数是指产品中关联进项目且有用例的研发需求数量。该度量项反映了产品中对于已立项需求的测试用例编写情况。产品中较高的有用例的已立项研发需求数量可能表示需求测试用例覆盖度越高。', '产品中研发需求个数求和\r\n研发需求关联进项目\r\n过滤已删除的产品\r\n过滤已删除的研发需求\r\n过滤没有用例的研发需求', 'realtime', '', '', '', '', NULL, '', NULL, '', NULL, '', NULL, '0', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的月度关闭研发需求数', 'count_of_monthly_closed_story_in_product', 'count', NULL, '按产品统计的月度关闭研发需求规模数表示产品在某月度关闭的研发需求数。该度量项反映了产品团队每月因完成、不做或取消等原因关闭的研发需求数，可以用于评估产品团队的研发需求规模管理和调整情况。', '产品中关闭时间为某年某月的研发需求的个数求和\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的月度新增研发需求数', 'count_of_monthly_created_story_in_product', 'count', NULL, '按产品统计的月度新增研发需求数是指在某月度新增的研发需求数量。这个度量项可以反映产品团队在该月度内需求的增长情况。月度新增研发需求数越多可能表示团队正在不断地推出新功能。', '产品中研发需求的个数求和\r\n创建时间在某年某月\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的研发需求规模总数', 'scale_of_story_in_product', 'measure', NULL, '按产品统计的研发需求规模总数表示产品种所有研发需求的总规模。这个度量项可以反映团队需进行研发工作的规模，可以用于评估产品团队的研发需求规模管理和成果。', '产品中研发需求的规模数求和\r\n过滤父研发需求\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的年度完成研发需求规模数', 'scale_of_annual_finished_story_in_product', 'measure', NULL, '按产品统计的年度完成研发需求规模数是指产品在某年度已关闭且关闭原因为已完成研发需求的总规模数。这个度量项可以反映产品团队在一年时间内的开发效率和成果。完成研发需求规模数的增加说明产品团队在该年度内取得了更多的开发成果和交付物。', '产品中研发需求的规模数求和\r\n关闭时间在某年\r\n关闭原因为已完成\r\n过滤父研发需求\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的年度交付研发需求规模数', 'scale_of_annual_delivered_story_in_product', 'measure', NULL, '按产品统计的年度交付研发需求数是指产品在某年度内已经成功交付给用户的研发需求规模数。这个度量项可以反映产品团队在开发过程中的交付能力和协作能力，可以用于评估产品的研发需求交付效能和效果。已交付的研发需求规模数越多可能说明产品团队在该年度内的交付成果越多。', '产品中研发需求规模数求和\r\n所处阶段为已发布且发布时间为某年某月或关闭原因为已完成且关闭时间为某年某月\r\n过滤父研发需求\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的年度关闭研发需求规模数', 'scale_of_annual_closed_story_in_product', 'measure', NULL, '按产品统计的年度关闭研发需求规模数表示产品在某年度关闭的研发需求的规模总数。该度量项反映了产品团队每年因完成、不做或取消等原因关闭研发需求数的规模总数，可以用于评估产品的团队研发需求规模管理和调整情况。', '产品中研发需求的规模数求和\r\n关闭时间在某年\r\n过滤父研发需求\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'story', 'released', 'php', '按产品统计的月度完成研发需求规模数', 'scale_of_monthly_finished_story_in_product', 'count', NULL, '按产品统计的月度完成研发需求规模数表示每月完成的研发需求的规模。该度量项反映了产品团队每月完成的研发需求规模，可以用于评估产品团队的研发需求完成情况和效率。', '产品中关闭时间为某年某月且关闭原因为已完成的研发需求的规模数求和\r\n过滤父需求\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('qc', 'product', 'story', 'released', 'php', '按产品统计的研发需求评审通过率', 'rate_of_approved_story_in_product', 'percentage', NULL, '按产品统计的研发需求评审通过率表示产品中通过评审的研发需求（不需要评审研发需求的与需要评审并通过的研发需求）相对于评审过的研发需求（不需要评审的研发需求与有评审结果的研发需求数）的比例。该度量项反映了需求评审过程中的成功率。', '按产品统计的所有研发需求评审通过率=（按产品统计的不需要评审的研发需求数+评审结果确认通过的研发需求数）/（按产品统计的不需要评审的研发需求数+有评审结果的研发需求数）\r\n过滤已删除的研发需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('rate', 'product', 'story', 'released', 'php', '按产品统计的研发需求完成率', 'rate_of_finish_story_in_product', 'percentage', NULL, '按产品统计的研发需求交付率表示按产品统计的已完成的研发需求规数相对于按产品统计的有效研发需求数。这个度量项衡量了研发团队完成需求的能力。完成率越高，代表研发团队有更多研发成果，保证产品的正常发布。', '复用：\r\n按产品统计的已完成研发需求数\r\n按产品统计的无效研发需求数\r\n按产品统计的研发需求总数\r\n公式：\r\n按产品统计的研发需求完成率=按产品统计的已完成研发需求数/（按产品统计的研发需求总数-按产品统计的无效研发需求数）*100%', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('rate', 'product', 'story', 'released', 'php', '按产品统计的研发需求交付率', 'rate_of_delivery_story_in_product', 'percentage', NULL, '按产品统计的研发需求交付率表示按产品统计的已交付的研发需求数相对于按产品统计的有效研发需求数。这个度量项衡量了产品团队按时交付需求的能力。交付率越高，代表产品团队能够将更多的需求交付给用户。', '复用：\r\n按产品统计的已交付研发需求数\r\n按产品统计的无效研发需求数\r\n按产品统计的研发需求总数\r\n公式：\r\n按产品统计的研发需求完成率=按产品统计的已交付研发需求数/（按产品统计的研发需求总数-按产品统计的无效研发需求数）*100%', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'requirement', 'released', 'php', '按产品统计的用户需求总数', 'count_of_requirement_in_product', 'count', NULL, '按产品统计的用户需求总数是指产品所有用户需求的总数。该度量项反映了对用户需求量的整体把握和了解程度。越高的用户需求数可能表示市场潜力较大，产品的受欢迎程度较高，有更多的用户对该产品提出了需求。', '产品中用户需求的个数求和\r\n过滤已删除的用户需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'requirement', 'released', 'php', '按产品统计的年度新增用户需求数', 'count_of_annual_created_requirement_in_product', 'count', NULL, '按产品统计的年度新增用户需求数反映了产品在某年度内新产生的用户对产品的需求数量。越高的用户需求数可能表示产品在该年度获得了更多的用户关注和认可，有更多的用户愿意尝试和使用该产品。', '产品中用户需求的个数求和\r\n创建时间为某年\r\n过滤已删除的用户需求\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'bug', 'released', 'php', '按产品统计的研发完毕研需规模的Bug密度', 'bug_concentration_of_developed_story_in_product', 'count', NULL, '按产品统计的研发完毕研需规模的Bug密度表示按产品统计的有效Bug数相对于按产品统计的研发完成的研发需求规模数。该度量项反映了研发完毕的研需的质量表现，密度越低代表研发完毕的研需质量越高。', '复用：\r\n按产品统计的有效Bug数\r\n按产品统计的研发完成的研发需求规模数\r\n公式：\r\n按产品统计的研发完成需求的Bug密度=按产品统计的有效Bug数/按产品统计的研发完成的研发需求规模数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'bug', 'released', 'php', '按产品统计的Bug总数', 'count_of_bug_in_product', 'count', NULL, '按产品统计的Bug总数是指在产品中发现的所有Bug的数量。这个度量项反映了产品整体Bug质量情况。Bug总数越多可能代表产品的代码质量存在问题，需要进行进一步的解决和改进。', '产品中Bug的个数求和\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'bug', 'released', 'php', '按产品统计的激活Bug数', 'count_of_activated_bug_in_product', 'count', NULL, '按产品统计的激活Bug数是指产品中当前状态为激活的Bug数量。这个度量项反映了产品当前存在的待处理问题数量。激活Bug总数越多可能代表产品的稳定性较低，需要加强Bug解决的速度和质量。', '产品中激活Bug的个数求和\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'bug', 'released', 'php', '按产品统计的有效Bug数', 'count_of_effective_bug_in_product', 'count', NULL, '按产品统计的有效Bug数是指产品中真正具有影响和价值的Bug数量。有效Bug通常是指导致产品不正常运行或影响用户体验的Bug。统计有效Bug数可以帮助评估产品的稳定性和质量，也可以评估测试人员之间的协作或对产品的了解程度。', '产品中所有Bug个数求和\r\n解决方案为已解决、延期处理或状态为激活\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'bug', 'released', 'php', '按产品统计的已修复Bug数', 'count_of_fixed_bug_in_product', 'count', NULL, '按产品统计的已修复Bug数是指解决方案为已解决并且状态为已关闭的Bug数量。这个度量项反映了产品解决的问题数量。已修复Bug数的可以评估开发团队在Bug解决方面的工作效率。', '产品中Bug的个数求和\r\n解决方案为已解决\r\n状态为已关闭\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'bug', 'released', 'php', '按产品统计的严重程度为1级的Bug数', 'count_of_severity_1_bug_in_product', 'count', NULL, '按产品统计的严重程度为1级的Bug数是指在产品开发过程中发现的、对产品功能或性能产生重大影响的Bug数量。这些Bug可能会导致系统崩溃、功能无法正常运行、数据丢失等严重问题。统计这些Bug的数量可以帮助评估产品的稳定性和可靠性。', '产品中Bug的个数求和\r\n严重程度为1级\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'bug', 'released', 'php', '按产品统计的严重程度为2级的Bug数', 'count_of_severity_2_bug_in_product', 'count', NULL, '按产品统计的严重程度为2级的Bug数是指在产品开发过程中发现的、对产品功能或性能产生较大影响的Bug数量。这些Bug可能会给用户带来不便或影响产品的某些功能。统计这些Bug的数量可以帮助评估产品的稳定性和可靠性。', '产品的Bug个数求和\r\n严重程度为2级\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'bug', 'released', 'php', '按产品统计的严重程度为1、2级的Bug数', 'count_of_severe_bug_in_product', 'count', NULL, '按产品统计的严重程度为1、2级的Bug数是指在产品开发过程中发现的严重程度为1级和2级的Bug数量的总和。统计这些Bug的数量可以评估产品的质量和稳定性，同时也关注影响用户体验和功能完整性的问题。', '复用：\r\n按产品统计的严重程度为1级的Bug数\r\n按产品统计的严重程度为2级的Bug数\r\n公式：\r\n按产品统计的严重程度为1、2级的Bug数=按产品统计的严重程度为1级的Bug数+按产品统计的严重程度为2级的Bug数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'bug', 'released', 'php', '按产品统计的年度新增Bug数', 'count_of_annual_created_bug_in_product', 'count', NULL, '按产品统计的年度新增Bug数是指产品在某年度新发现的Bug数量。这个度量项反映了产品在某年度出现的新问题数量。年度新增Bug数越多可能意味着质量控制存在问题，需要及时进行处理和改进。', '产品中Bug的个数求和\r\n创建时间为某年\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'bug', 'released', 'php', '按产品统计的年度新增有效Bug数', 'count_of_annual_created_effective_bug_in_product', 'count', NULL, '按产品统计的年度新增有效Bug数是指产品在某年度新发现的真正具有影响和价值的Bug数量。有效Bug通常是指导致产品不正常运行或影响用户体验的Bug。统计有效Bug数可以帮助评估产品的稳定性和质量也可以评估测试人员之前的协作或对产品的了解程度。', '产品中Bug个数求和\r\n创建时间为某年\r\n解决方案为已解决和延期处理或者状态为激活\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'bug', 'released', 'php', '按产品统计的年度修复Bug数', 'count_of_annual_fixed_bug_in_product', 'count', NULL, '按产品统计的年度修复Bug数是指在某年度解决并关闭的Bug数量。这个度量项反映了产品在某年度解决的问题数量。年度修复Bug数越多可能说明开发团队在Bug解决方面的工作效率较高。', '产品中Bug的个数求和\r\n关闭时间为某年\r\n解决方案为已解决\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'bug', 'released', 'php', '按产品统计的每日新增Bug数', 'count_of_daily_created_bug_in_product', 'count', NULL, '按产品统计的每日新增Bug数是指在每天的产品开发过程中新发现并记录的Bug数量。该度量项可以体现产品开发过程中Bug的发现速度和趋势，较高的新增Bug数可能意味着存在较多的问题需要解决，同时也可以帮助识别产品开发过程中的瓶颈和潜在的质量风险。', '产品中Bug数求和\r\n创建时间为某日\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'bug', 'released', 'php', '按产品统计的每日解决Bug数', 'count_of_daily_resolved_bug_in_product', 'count', NULL, '按产品统计的每日解决Bug数是指产品每日解决的Bug的数量。该度量项可以帮助我们了解开发团队解决Bug的速度和效率。', '产品中Bug数求和\r\n解决日期为某日\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'bug', 'released', 'php', '按产品统计的每日关闭Bug数', 'count_of_daily_closed_bug_in_product', 'count', NULL, '按产品统计的每日关闭Bug数是指每天在产品中每日关闭的Bug的数量。该度量项可以帮助我们了解开发团队对已解决的Bug进行确认与关闭的速度和效率，通过对比不同时间段的关闭Bug数，可以评估开发团队的协作和问题处理能力。', '产品中Bug数求和\r\n关闭时间为某日\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'bug', 'released', 'php', '按产品统计的月度解决Bug数', 'count_of_monthly_fixed_bug_in_product', 'count', NULL, '按产品统计的月度解决Bug数是指每天在产品开发过程中被解决并关闭的Bug的数量。该度量项可以帮助我们了解开发团队解决Bug的速度和效率。', '产品中创建时间在某年某月的Bug个数求和\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'bug', 'released', 'php', '按产品统计的月度关闭Bug数', 'count_of_monthly_closed_bug_in_product', 'count', NULL, '按产品统计的月度关闭Bug数是指在某月度关闭的Bug数量。这个度量项反映了产品开发过程中每月被确认并关闭的Bug的数量。该度量项可以帮助我们了解开发团队对Bug进行确认与关闭的速度和效率。', '产品中创建时间在某年某月的Bug个数求和\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'bug', 'released', 'php', '按产品统计的月度新增Bug数', 'count_of_monthly_created_bug_in_product', 'count', NULL, '按产品统计的月度新增Bug数是指在某年度新发现的Bug数量。这个度量项反映了系统或项目在某月度出现的新问题数量。月度新增Bug数的增加可能意味着质量控制存在问题，需要及时进行处理和改进。', '产品中创建时间在某年某月的Bug个数求和\r\n过滤已删除的Bug\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('rate', 'product', 'bug', 'released', 'php', '按产品统计的Bug修复率', 'rate_of_fixed_bug_in_product', 'percentage', NULL, '按产品统计的Bug修复率是指按产品统计的修复Bug数相对于按产品统计的有效Bug数的比例。该度量项可以帮助我们了解开发团队对Bug修复的效率和质量，高的修复率可能说明Bug得到及时解决，产品质量得到有效保障。', '复用：\r\n按产品统计的修复Bug数\r\n按产品统计的有效Bug数\r\n公式：\r\n按产品统计的Bug修复率=按产品统计的修复Bug数/按产品统计的有效Bug数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'case', 'released', 'php', '按产品统计的用例总数', 'count_of_case_in_product', 'count', NULL, '按产品统计的用例总数是指系统或项目中的测试用例总数量。用例是用来验证系统功能和性能的测试场景。统计用例总数可以帮助评估测试覆盖的广度和深度。用例总数越高可能意味着项目进行了全面和充分的测试。', '产品中用例的个数求和\r\n过滤已删除的用例\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'case', 'released', 'php', '按产品统计的年度新增用例数', 'count_of_annual_created_case_in_product', 'count', NULL, '按产品统计的年度新增用例数是指产品在某年度新增的测试用例数量。统计年度新增用例数可以帮助评估系统或项目在不同阶段的测试覆盖和测试深度。年度新增用例数的增加可能意味着对新功能和需求进行了充分的测试。', '产品中用例的个数求和\r\n创建时间为某年\r\n过滤已删除的用例\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'feedback', 'released', 'php', '按产品统计的反馈总数', 'count_of_feedback_in_product', 'count', NULL, '产品的反馈总数', '产品中反馈的个数求和\r\n过滤已删除的反馈\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'feedback', 'released', 'php', '按产品统计的年度新增反馈数', 'count_of_annual_created_feedback_in_product', 'count', NULL, '按产品统计的年度新增反馈数是指在某年度收集到的用户反馈的数量。这个度量项可以帮助团队了解用户对产品的发展趋势和需求变化，并进行产品策略的调整和优化。较高的年度新增反馈数可能暗示着产品的用户基础扩大或者功能迭代带来了更多用户参与，同时暗示产品问题可能有很多。', '产品中创建时间为某年的反馈的个数求和\r\n过滤已删除的反馈\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'product', 'feedback', 'released', 'php', '按产品统计的年度关闭反馈数', 'count_of_annual_closed_feedback_in_product', 'count', NULL, '按产品统计的年度关闭反馈数是指在某年度处理并关闭的用户反馈的数量。这个度量项可以帮助产品团队评估在某年度对用户反馈的响应能力和问题解决能力。较高的年度关闭反馈数可能暗示着团队能够高效地解决用户反馈并持续改进产品，提升用户满意度和产品质量。', '产品中关闭时间为某年的反馈的个数求和\r\n过滤已删除的反馈\r\n过滤已删除的产品', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('time', 'project', 'project', 'released', 'php', '按项目统计的计划工期', 'planned_period_of_project', 'day', NULL, '按项目统计的计划工期是基于项目计划和排期制定的预估工期。该度量项通过确定项目开始和结束日期之间的时间间隔来计算。计划工期用于制定项目的时间目标和进度安排，为项目管理提供了基准。与实际工期进行比较，可以评估项目的进展和时间规划的准确性，帮助团队及时调整工作计划。', '计划完成日期-计划开始日期\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('time', 'project', 'project', 'released', 'php', '按项目统计的剩余工期', 'left_period_of_project', 'day', NULL, '按项目统计的剩余工期表示项目在当前时间点上还剩下的工作时间。这个度量项可以帮助团队评估项目的剩余工作量和进度。通过比较剩余工期和剩余工时，可以预测项目是否能够按时完成，并采取适当的措施来调整进度，以确保项目的成功交付。', '已关闭的项目\r\n未关闭的项目\r\n计划截止日期-当前日期\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('time', 'project', 'project', 'released', 'php', '按项目统计的的实际工期', 'count_of_actual_time_in_project', 'day', NULL, '按项目统计的实际工期反映了项目在执行过程中实际花费的时间。该度量项通过统计项目实际的开始和完成日期来计算。实际工期的准确记录能够帮助团队评估项目的执行效率和时间管理能力。较短的实际工期可能意味着项目按计划进行，团队高效执行，而较长的实际工期可能表明项目存在一些延迟和挑战。', '已关闭的项目：\r\n实际完成日期-实际开始日期\r\n未关闭的项目：\r\n当前日期-实际开始日期\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('time', 'project', 'project', 'released', 'php', '按项目统计的的工期偏差', 'variance_of_time_in_project', 'day', NULL, '按项目统计的工期偏差表示实际工期与计划工期之间的差异。工期偏差的正值表示项目进度延迟，负值表示项目进度提前。工期偏差可以帮助团队及时识别项目进度的偏差，并采取相应的调整措施来重新规划资源和工作计划，以确保项目能够按时完成。', '复用：\r\n按项目统计的实际工期\r\n按项目统计的计划工期\r\n公式：\r\n按项目统计的工期偏差=按项目统计的实际工期-按项目统计的计划工期', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'execution', 'released', 'php', '按项目统计的已关闭执行数', 'count_of_closed_execution_in_project', 'count', NULL, '按项目统计的已关闭执行数表示在项目中已关闭的执行项的数量，可以用来了解已关闭的执行数量。', '项目的执行个数求和\r\n过滤已删除的执行\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'execution', 'released', 'php', '按项目统计的已挂起执行数', 'count_of_suspended_execution_in_project', 'count', NULL, '按项目统计的已挂起执行数表示在项目中已挂起的执行项的数量，可以用来了解暂停的任务数量，可能是由于需求不明确或其他原因导致。', '项目的执行个数求和\r\n状态为已挂起\r\n过滤已删除的执行\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'execution', 'released', 'php', '按项目统计的进行中执行数', 'count_of_doing_execution_in_project', 'count', NULL, '按项目统计的进行中执行数表示在项目中正在进行中的执行项的数量，可以用来了解当前正在进行的任务数量，反映项目团队的工作进展。', '所有的执行个数求和\r\n状态为进行中\r\n过滤已删除的执行', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'execution', 'released', 'php', '按项目统计的未开始执行数', 'count_wait_execution_in_project', 'count', NULL, '按项目统计的未开始执行数表示在项目中未开始的执行数，可以用来了解未开始的执行数量。', '项目的执行个数求和\r\n状态为未开始\r\n过滤已删除的执行\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'execution', 'released', 'php', '按项目统计的年度关闭执行数', 'count_annual_closed_execution_in_project', 'count', NULL, '按项目统计的年度关闭执行数是指在项目中某年度已经关闭的执行数。该度量项反映了项目团队在某年度的工作效率和完成能力。较高的年度关闭执行数表示项目在完成任务方面表现出较高的效率，反之则可能需要审查工作流程和资源分配情况，以提高执行效率。', '项目的执行个数求和\r\n关闭时间为某年\r\n过滤已删除的执行\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'execution', 'released', 'php', '按项目统计的执行总数', 'count_of_execution_in_project', 'count', NULL, '按项目统计的执行总数表示在项目中所有执行的数量，可以用来评估项目的规模、项目执行进度、工作负荷、绩效评估、风险控制和项目管理的有用信息。', '项目的执行个数求和\r\n过滤已删除的执行\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'story', 'released', 'php', '按项目统计的研发需求总数', 'count_of_story_in_project', 'count', NULL, '按项目统计的研发需求总数是指项目中创建或关联的所有研发需求的数量，反映了项目的规模和复杂度，提供了关于需求管理、进度控制、资源规划、风险评估和质量控制的有用信息。', '项目中研发需求个数求和\r\n过滤已删除的研发需求\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'story', 'released', 'php', '按项目统计的已关闭研发需求数', 'count_of_closed_story_in_project', 'count', NULL, '按项目统计的已关闭研发需求数是指项目中已经关闭的研发需求的数量反映了项目中已经关闭的研发需求的数量，提供了关于需求管理、项目进度、质量控制、用户满意度和绩效评估的有用信息。', '项目中研发需求个数求和\r\n过滤已删除的研发需求\r\n状态为已关闭\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'story', 'released', 'php', '按项目统计的未关闭研发需求数', 'count_of_unclosed_story_in_project', 'count', NULL, '按项目统计的未关闭研发需求数是指项目中未关闭的研发需求的数量反映了项目团队在开发过程中的进行中的任务和计划，未关闭研发需求数越多，说明项目团队未完成的开发工作越多，需要进一步跟进从而完成。', '复用：\r\n按项目统计的研发需求总数\r\n按项目统计的已关闭研发需求数\r\n公式：\r\n按项目统计的关闭研发需求数=按项目统计的研发需求总数-按项目统计的已关闭研发需求数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'story', 'released', 'php', '按项目统计的已完成研发需求数', 'count_of_finished_story_in_project', 'count', NULL, '按项目统计的已完成研发需求数是指状态为已关闭且关闭原因为已完成的研发需求的数量。反映了项目团队在开发过程中的进展和交付能力，已完成研发需求数越多，说明项目团队在该时间段内取得了更多的开发成果。', '项目中研发需求的个数求和\r\n状态为已关闭\r\n关闭原因为已完成\r\n过滤已删除的研发需求\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'story', 'released', 'php', '按项目统计的无效研发需求数', 'count_of_invalid_story_in_project', 'count', NULL, '按项目统计的无效研发需求数是指被判定为无效的研发需求数量。无效需求可能包括重复需求、不可实现的需求、或者与项目策略和目标不符的需求。通过对无效需求的统计，可以帮助项目团队优化需求管理和筛选机制，以提高需求有效性和资源利用率。较高的无效需求数量可能需要对需求收集和评估流程进行改进。', '项目中研发需求的个数求和\r\n关闭原因为重复、不做、设计如此\r\n过滤已删除的研发需求\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'story', 'released', 'php', '按项目统计的有效研发需求数', 'count_of_valid_story_in_project', 'count', NULL, '按项目统计的有效研发需求数是指被确认为有效的研发需求数量。有效需求指的是符合项目策略和目标，可以实施并且对用户有价值的需求。通过对有效需求的统计，可以帮助项目团队评估项目需求的质量和重要性，并进行优先级排序和资源分配。较高的有效需求数量通常表示项目的功能和特性满足了用户和市场的期望，有利于实现项目的成功交付和用户满意度。', '复用：\r\n按项目统计的无效研发需求数\r\n按项目统计的研发需求总数\r\n公式：\r\n按执行统计的有效研发需求数=按执行统计的研发需求总数-按执行统计的无效研发需求数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'story', 'released', 'php', '按项目统计的所有研发需求规模数', 'scale_of_story_in_project', 'measure', NULL, '按项目统计的所有研发需求规模数表示研发需求的规模总数反映了项目研发需求的规模总数，可以用于评估项目团队的研发需求规模管理和成果。', '项目中研发需求的规模数求和\r\n过滤已删除的研发需求\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'story', 'released', 'php', '按项目统计的年度完成研发需求数', 'count_of_annual_finished_story_in_project', 'count', NULL, '按项目统计的年度完成研发需求数是指在某年度已关闭且关闭原因为已完成的研发需求数量。这个度量项可以反映项目团队在某年度的开发效率和成果。完成研发需求数量的增加说明项目团队在该年度内取得了更多的开发成果和交付物。', '项目中研发需求的个数求和\r\n关闭时间在某年\r\n关闭原因为已完成\r\n过滤已删除的研发需求\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'story', 'released', 'php', '按项目统计的年度完成研发需求规模数', 'scale_of_annual_finished_story_in_project', 'measure', NULL, '按项目统计的年度完成研发需求数是指在某年度已关闭且关闭原因为已完成的研发需求规模数。这个度量项可以反映项目团队在某年度的开发效率和成果。完成研发需求规模数的增加说明项目团队在该年度内取得了更多的开发成果和交付物。', '项目中研发需求的规模数求和\r\n关闭时间在某年\r\n关闭原因为已完成\r\n过滤已删除的研发需求\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('rate', 'project', 'story', 'released', 'php', '按项目统计的研发需求完成率', 'rate_of_finished_story_in_project', 'percentage', NULL, '按项目统计的研发需求完成率表示按项目统计的已完成的研发需求数相对于按项目统计的有效研发需求数。衡量了项目研发团队完成需求的能力，完成率越高代表项目研发团队能够将需求交付给用户，实现正常发布的几率越大。', '复用：\r\n按项目统计的已完成研发需求数\r\n按项目统计的有效研发需求数\r\n公式：\r\n按项目统计的研发需求完成率=按项目统计的已完成研发需求数/按项目统计的有效研发需求数*100%', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'task', 'released', 'php', '按项目统计的任务总数', 'count_of_task_in_project', 'count', NULL, '按项目统计的任务总数是指整个项目当前存在的任务总量。该度量项可以用来跟踪任务的规模和复杂性，为资源分配和工作计划提供基础。较大的任务总数可能需要更多的资源和时间来完成，而较小的任务总数可能意味着项目负荷较轻或项目进展较好。', '项目中所有的任务个数求和\r\n过滤已删除的任务\r\n过滤已删除执行的任务\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'task', 'released', 'php', '按项目统计的未开始任务数', 'count_of_wait_task_in_project', 'count', NULL, '按项目统计的未开始任务数指的是在项目执行过程中未开始进行的任务数量。这个度量项帮助团队了解项目进展的一部分，即有多少任务未启动。通过统计未开始任务数，团队可以评估项目的准备状况、资源分配以及可能存在的延迟因素。', '项目中任务个数求和\r\n状态为未开始\r\n过滤已删除的任务\r\n过滤已删除执行的任务\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'task', 'released', 'php', '按项目统计的进行中任务数', 'count_of_doing_task_in_project', 'count', NULL, '按项目统计的进行中任务数表示项目执行过程中正在进行的任务数量。这个度量项帮助团队了解项目当前的工作负载和进展情况。统计进行中任务数可以帮助团队判断项目的工作量是否合理分配，并进行进一步的资源规划和调整。', '项目中任务个数求和\r\n状态为进行中\r\n过滤已删除的任务\r\n过滤已删除执行的任务\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'task', 'released', 'php', '按项目统计的已完成任务数', 'count_of_finished_task_in_project', 'count', NULL, '按项目统计的已完成任务数是指项目已经完成的任务总量。该度量项可以衡量任务完成的进度和效率，以及项目的工作质量和产出。较高的已完成任务总数可能表明项目在交付工作方面表现出较好的能力。', '项目中任务个数求和\r\n状态为已完成\r\n过滤已删除的任务\r\n过滤已删除执行的任务\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('hour', 'project', 'task', 'released', 'php', '按项目统计的任务预计工时数', 'estimate_of_task_in_project', 'hour', NULL, '按项目统计的任务预计工时数是指在项目管理中，对所有任务的预计工时进行统计和汇总的度量。这个度量项用于评估项目的工作量和资源需求，并帮助规划和安排项目团队。任务预计工时数是通过对每个任务的工作量估算进行累加而得，可以作为项目计划和进度控制的依据。', '项目中任务的预计工时数求和\r\n过滤已删除的任务\r\n过滤父任务\r\n过滤已删除执行的任务\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('hour', 'project', 'task', 'released', 'php', '按项目统计的任务消耗工时数', 'consume_of_task_in_project', 'hour', NULL, '按项目统计的任务消耗工时数是指已经花费的工时总和，用于完成所有任务。该度量项可以用来评估项目在任务执行过程中的工时投入情况，以及在完成任务方面的效率和资源利用情况。较高的任务消耗工时总数可能表明需要审查工作流程和资源分配，以提高工作效率。', '项目中任务的消耗工时数求和\r\n过滤已删除的任务\r\n过滤父任务\r\n过滤已删除执行的任务\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('hour', 'project', 'task', 'released', 'php', '按项目统计的任务剩余工时数', 'left_of_task_in_project', 'hour', NULL, '按项目统计的任务剩余工时数是指当前未消耗的工时总和，用于完成所有任务。该度量项可以用来评估项目在任务执行过程中剩余的工作量和时间，以及为完成任务所需的资源和计划。较小的任务剩余工时总数可能表示项目将及时完成任务，而较大的任务剩余工时总数可能需要重新评估进度和资源分配。', '项目中任务的剩余工时数求和\r\n过滤已删除的任务\r\n过滤父任务\r\n过滤已删除执行的任务\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('hour', 'project', 'task', 'released', 'php', '按瀑布项目统计的已完成任务工作的预计工时(EV)', 'ev_of_finished_task_in_waterfall', 'hour', NULL, '按瀑布项目统计的已完成任务工作的预计工时指的是在瀑布项目管理方法中，已经完成的任务的预计工时。这个度量项用来评估项目进展与实际完成情况的一致性。EV的值越高，代表项目团队在按计划完成任务的工作量方面表现得越好。', '复用：\r\n按项目统计的任务进度\r\n按项目统计的任务预计工时数\r\n公式：\r\n按项目统计的已完成任务工作的预计工时(EV)=按项目统计的任务预计工时数*按项目统计的任务进度\r\n要求项目为瀑布项目\r\n过滤已删除的任务\r\n过滤已取消的任务\r\n过滤已删除执行下的任务\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('hour', 'project', 'task', 'released', 'php', '按瀑布项目统计的任务的计划完成工时(PV)', 'pv_of_task_in_waterfall', 'hour', NULL, '按瀑布项目统计的任务的计划完成工时指的是在瀑布项目管理方法中，按计划需要完成的任务的总预计工时。这个度量项用于评估任务的预期工作量，可用作与实际花费工时和已完成任务的预计工时进行比较。', '瀑布项目中所有任务的预计工时之和\r\n过滤已删除的任务\r\n过滤已取消的任务\r\n过滤已删除的执行的任务\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('rate', 'project', 'task', 'released', 'php', '按项目统计的任务进度', 'progress_of_task_in_project', 'percentage', NULL, '按项目统计的任务进度是指项目团队按已消耗的工时数与已消耗和剩余的工时数的比率。这个度量项能够反映项目进度的准确性和任务执行的效率。', '复用：\r\n按项目统计的任务消耗工时数\r\n按项目统计的任务剩余工时数\r\n公式：\r\n按项目统计的任务进度=按项目统计的任务消耗工时数/（按项目统计的任务消耗工时数+按项目统计的任务剩余工时数）', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('rate', 'project', 'task', 'released', 'php', '按瀑布项目统计的进度偏差率', 'sv_in_waterfall', 'percentage', NULL, '按瀑布项目统计的进度偏差率是用来衡量项目当前的进度与计划进度之间的差异。它通过计算已完成的工作量与计划工作量之间的差异来评估项目的进展情况。', '复用：\r\n按瀑布项目统计的已完成任务工作的预计工时(EV)\r\n按瀑布项目统计的任务的计划完成工时(PV)\r\n公式：\r\n按瀑布项目统计的进度偏差率=(EV-PV)/PV*100%', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('rate', 'project', 'task', 'released', 'php', '按瀑布项目统计的成本偏差率', 'cv_in_waterfall', 'percentage', NULL, '按瀑布项目统计的成本偏差率用于衡量项目的实际成本与计划成本之间的差异。它通过计算已花费的成本与预计花费的成本之间的差异来评估项目的成本绩效。', '复用：\r\n按瀑布项目统计的已完成任务工作的预计\r\n按瀑布项目统计的实际花费工时(AC)\r\n公式：\r\n按瀑布项目统计的成本偏差率=(EV-AC)/AC*100%', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'bug', 'released', 'php', '按项目统计的Bug总数', 'count_of_bug_in_project', 'count', NULL, '按项目统计的Bug总数是指在项目中发现的所有Bug的数量。这个度量项反映了项目的整体Bug质量情况。Bug总数越多可能代表项目的代码质量存在问题，需要进行进一步的解决和改进。', '项目中Bug个数求和\r\n过滤已删除的Bug\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'bug', 'released', 'php', '按项目统计的激活Bug数', 'count_of_activated_bug_in_project', 'count', NULL, '按项目统计的激活Bug数是指当前未解决的Bug数量。这个度量项反映了项目当前存在的待解决问题数量。激活Bug总数越多可能代表项目的稳定性较低，需要加强Bug解决的速度和质量。', '项目中Bug个数求和\r\n状态为激活\r\n过滤已删除的Bug\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'bug', 'released', 'php', '按项目统计的已关闭Bug数', 'count_of_closed_bug_in_project', 'count', NULL, '按项目统计的已关闭Bug总数是指已经被关闭的Bug数量。这个度量项反映了项目中已经关闭的缺陷数量。已关闭Bug总数的增加说明项目进行了持续的改进和修复工作。', '项目中Bug个数求和\r\n状态为已关闭\r\n过滤已删除的Bug\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'user', 'released', 'php', '按项目统计的人员总数', 'count_of_user_in_project', 'count', NULL, '按项目统计的人员总数是指参与项目的全部人员的数量。这个度量项用于了解项目团队的规模和组成，对项目资源的分配和管理起到重要作用。', '项目中团队成员个数求和\r\n过滤已移除的人员\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('hour', 'project', 'effort', 'released', 'php', '按项目统计的项目内所有消耗工时数', 'consume_of_all_in_project', 'hour', NULL, '按项目统计的项目内所有消耗工时数是指项目实际花费的总工时数。该度量项可以用来评估项目的工时投入情况和对资源的利用效率。较高的消耗工时数可能需要审查工作流程和资源分配，以提高工作效率和进度控制。', '项目中所有日志记录的工时之和\r\n记录时间在某年\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('hour', 'project', 'effort', 'released', 'php', '按项目统计的已投入人天', 'day_of_invested_in_project', 'manday', NULL, '按项目统计的已投入人天是指项目总共投入的工作天数。该度量项可以用来评估项目的人力资源投入情况。投入总人天的增加可能意味着项目投入的工作时间和资源的增加。', '复用：\r\n按项目统计的日志记录的工时总数\r\n公式：\r\n按项目统计的已投入人天=按项目统计的项目内所有消耗工时数/后台配置的每日可用工时', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('hour', 'project', 'effort', 'released', 'php', '按瀑布项目统计的实际花费工时(AC)', 'ac_of_all_in_waterfall', 'hour', NULL, '按瀑布项目统计的实际花费工时指的是在瀑布项目管理方法中，实际花费的工时总数。这个度量项用于评估实际工作量和预计工作量之间的差异，有助于估计项目的真实进展情况。AC的值越接近EV，代表项目团队在任务执行方面表现得越好。', '瀑布项目中所有日志记录的工时之和\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'risk', 'released', 'php', '按项目统计的开放的风险数', 'count_of_opened_risk_in_project', 'count', NULL, '按项目统计的开放的风险数是指在项目管理中，正在被跟踪和管理的项目风险的数量。风险是项目中潜在的不确定事件或情况，可能对项目目标的达成产生负面影响。通过跟踪和管理项目风险，项目团队可以及时采取措施降低风险的概率和影响程度。', '项目中风险的个数求和\r\n状态为开放\r\n过滤已删除的风险\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'project', 'issue', 'released', 'php', '按项目统计的开放的问题数', 'count_of_opened_issue_in_project', 'count', NULL, '按项目统计的开放的问题数指的是在项目管理中，正在被跟踪和解决的项目问题的数量。问题是指在项目执行过程中遇到的障碍、困难或需要解决的事项。通过跟踪和解决项目问题，可以避免问题的积累和对项目目标的影响。', '项目中问题的个数求和\r\n状态为开放\r\n过滤已删除的问题\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'execution', 'story', 'released', 'php', '按执行统计的研发需求总数', 'count_of_story_in_execution', 'count', NULL, '按执行统计的研发需求总数是指执行中创建和关联的所有研发需求的数量。该度量项反映了执行的规模和复杂度，为执行计划和资源分配提供了参考。', '执行中研发需求个数求和\r\n过滤已删除的研发需求\r\n过滤已删除的执行\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'execution', 'story', 'released', 'php', '按执行统计的已完成研发需求数', 'count_of_finished_story_in_execution', 'count', NULL, '按执行统计的已完成研发需求数是指状态为已关闭且关闭原因为已完成的研发需求的数量。这个度量项可以反映执行团队在开发过程中的进展和交付能力。已完成研发需求数越多，说明执行团队在该时间段内取得了更多的开发成果。', '执行中研发需求的个数求和\r\n状态为已关闭\r\n关闭原因为已完成\r\n过滤已删除的研发需求\r\n过滤已删除的执行\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'execution', 'story', 'released', 'php', '按执行统计的无效研发需求数', 'count_of_invalid_story_in_execution', 'count', NULL, '按执行统计的无效研发需求数是指被判定为无效的研发需求数量。无效需求可能包括重复需求、不可实现的需求、或者与项目策略和目标不符的需求。通过对无效需求的统计，可以帮助执行团队优化需求管理和筛选机制，以提高需求有效性和资源利用率。较高的无效需求数量可能需要对需求收集和评估流程进行改进。', '执行中研发需求的个数求和\r\n关闭原因为重复、不做、设计如此和已取消\r\n过滤已删除的研发需求\r\n过滤已删除的执行\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'execution', 'story', 'released', 'php', '按执行统计的有效研发需求数', 'count_of_valid_story_in_execution', 'count', NULL, '按执行统计的有效研发需求数是指被确认为有效的研发需求数量。有效需求指的是符合项目策略和目标，可以实施并且对用户有价值的需求。通过对有效需求的统计，可以帮助执行团队评估项目需求的质量和重要性，并进行优先级排序和资源分配。较高的有效需求数量通常表示执行的功能和特性满足了用户和市场的期望，有利于实现项目的成功交付和用户满意度。', '复用：\r\n按执行统计的无效研发需求数\r\n按执行统计的研发需求总数\r\n公式：\r\n按执行统计的有效研发需求数=按执行统计的研发需求总数-按执行统计的无效研发需求数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'execution', 'story', 'released', 'php', '按执行统计的研发完成的研发需求数', 'count_of_developed_story_in_execution', 'count', NULL, '按执行统计的研发完成的研发需求数是指执行中研发完成的研发需求的数量。这个度量项可以反映执行的进展。研发完成的研发需求数越多，说明执行团队在该时间段内取得了更多的研发成果。', '执行中所处阶段为研发完毕、测试中、测试完毕、已验收、已发布和关闭原因为已完成的研发需求个数求和\r\n过滤已删除的研发需求\r\n过滤已删除产品的研发需求\r\n过滤已删除的执行', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('rate', 'execution', 'story', 'released', 'php', '按执行统计的研发需求完成率', 'rate_of_finished_story_in_execution', 'percentage', NULL, '按执行统计的研发需求完成率表示按执行统计的已完成的研发需求数相对于按执行统计的有效研发需求数。这个度量项衡量了执行研发团队完成需求的能力。', '复用：\r\n按执行统计的已完成研发需求数\r\n按执行统计的有效研发需求数\r\n公式：\r\n按执行统计的研发需求完成率=按执行统计的已完成研发需求数/按执行统计的有效研发需求数*100%', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('rate', 'execution', 'story', 'released', 'php', '按执行统计的研发完成需求占比', 'rate_of_developed_story_in_execution', 'percentage', NULL, '按执行统计的研发完成需求占比表示按执行统计的研发完成的研发需求规数相对于按产品统计的研发需求总数的比例。这个度量项衡量了执行中研发团队完成需求的数量，可以衡量团队的研发进展，帮助团队更好的安排研发资源。', '复用：\r\n按执行统计的研发完成的研发需求数\r\n按执行统计的研发需求总数\r\n公式：\r\n按执行统计的研发完成需求占比=按执行统计的研发完成的研发需求数/按执行统计的研发需求总数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'execution', 'task', 'released', 'php', '按执行统计的任务总数', 'count_of_task_in_execution', 'count', NULL, '按执行统计的任务总数是指整个执行当前存在的任务总量。该度量项可以用来跟踪任务的规模和复杂性，为资源分配和工作计划提供基础，可以帮助团队评估工作负荷和任务分配的合理性。', '执行中所有的任务个数求和\r\n过滤已删除的任务\r\n过滤已删除的执行\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'execution', 'task', 'released', 'php', '按执行统计的已完成任务数', 'count_of_finished_task_in_execution', 'count', NULL, '按执行统计的已完成任务数是指执行已经完成的任务总量。该度量项可以衡量任务完成的进度和效率，以及项目的工作质量和产出。较高的已完成任务总数可能表明项目在交付工作方面表现出较好的能力。', '执行中任务个数求和\r\n状态为已完成\r\n过滤已删除的任务\r\n过滤已删除的执行\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'execution', 'task', 'released', 'php', '按执行统计的未完成任务数', 'count_of_unfinished_task_in_execution', 'count', NULL, '按执行统计的未完成任务数是指执行未完成的任务总量。该度量项反映了团队的待办工作量和未来的工作压力。较低的未完成任务总数可能表明项目在交付工作方面表现出较好的能力。', '复用：\r\n按执行统计的未完成任务数\r\n按执行统计的任务总数\r\n公式：\r\n按执行统计的未完成任务数=按执行统计的任务总数-按执行统计的已完成任务数', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'execution', 'task', 'released', 'php', '按执行统计的日完成任务数', 'count_of_daily_finished_task_in_execution', 'count', NULL, '按执行统计的日完成任务数是指每天完成的任务数量。该度量项反映了团队的日常工作效率和任务完成速度。', '执行中任务个数求和\r\n状态为已完成\r\n实际完成日期为某日\r\n过滤已删除的任务\r\n过滤已删除的执行\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('hour', 'execution', 'task', 'released', 'php', '按执行统计的任务预计工时数', 'estimate_of_task_in_execution', 'hour', NULL, '按执行统计的任务预计工时数是指在执行管理中，对所有任务的预计工时进行统计和汇总的度量。该度量项反映了任务的预计复杂性和所需的资源投入，可以帮助团队管理者评估任务的难度并安排资源。', '执行中任务的预计工时数求和\r\n过滤已删除的任务\r\n过滤父任务\r\n过滤已删除的执行\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('hour', 'execution', 'task', 'released', 'php', '按执行统计的任务消耗工时数', 'consume_of_task_in_execution', 'hour', NULL, '按执行统计的任务消耗工时数是指已经花费的工时总和，用于完成所有任务。该度量项反映了任务的实际完成情况和资源使用情况，可以帮助团队掌握任务的进展情况和资源利用效率。', '执行中任务的消耗工时数求和\r\n过滤已删除的任务\r\n过滤父任务\r\n过滤已删除的执行\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('hour', 'execution', 'task', 'released', 'php', '按执行统计的任务剩余工时数', 'left_of_task_in_execution', 'hour', NULL, '按执行统计的任务剩余工时数是指当前未消耗的工时总和，用于完成所有任务。该度量项反映了任务完成的剩余工作量，可以帮助团队预测任务的完成时间和资源需求。', '执行中任务的剩余工时数求和\r\n过滤已删除的任务\r\n过滤父任务\r\n过滤已删除的执行\r\n过滤已删除的项目', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('rate', 'execution', 'task', 'released', 'php', '按执行统计的任务进度', 'progress_of_task_in_execution', 'percentage', NULL, '按执行统计的任务进度是指执行团队按已消耗的工时数与已消耗和剩余的工时数的比率。该度量项反映了任务的执行进展情况，可以帮助团队评估任务是否按计划进行并做出相应调整。', '复用：\r\n按执行统计的任务消耗工时数\r\n按执行统计的任务剩余工时数\r\n公式：\r\n按执行统计的任务进度=按执行统计的任务消耗工时数/（按执行统计的任务消耗工时数+按执行统计的任务剩余工时数）', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'user', 'story', 'released', 'php', '按人员统计的待评审研发需求数', 'count_of_reviewing_story_in_user', 'count', NULL, '按人员统计的待评审研发需求数表示每个人需要评审的研发需求数量之和。反映了每个人需要评审的研发需求的规模。该数值越大，说明需要投入越多的时间评审需求。', '所有研发需求个数求和\r\n状态为评审中\r\n指派给为某人\r\n过滤已删除的研发需求\r\n过滤已删除产品的研发需求', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'user', 'story', 'released', 'php', '按人员统计的每日评审研发需求数', 'count_of_daily_review_story_in_user', 'count', NULL, '按人员统计的日评审研发需求数表示每个人每日评审的研发需求数量之和。反映了每个人每日评审研发需求的规模。该数值越大，说明工作量越大。', '所有研发需求个数求和\r\n评审者为某人\r\n评审时间为某日\r\n过滤已删除的研发需求\r\n过滤已删除产品的研发需求', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'user', 'story', 'released', 'php', '按人员统计的待处理研发需求数', 'count_of_pending_story_in_user', 'count', NULL, '按人员统计的待处理研发需求数表示每个人待处理的研发需求数量之和。反映了每个人员需要处理的研发需求数量的规模。该数值越大，说明需要投入越多的时间处理研发需求。', '所有研发需求个数求和\r\n指派给为某人\r\n过滤已删除的研发需求\r\n过滤已删除产品的研发需求', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'user', 'task', 'released', 'php', '按人员统计的每日完成任务数', 'count_of_daily_finished_task_in_user', 'count', NULL, '按人员统计的日完成任务数表示每个人每日完成的任务数量之和。反映了每个人每日完成的任务规模。该数值越大，可能说明工作效率越高，任务完成速度越快。', '某人某日完成的任务个数求和', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'user', 'task', 'released', 'php', '按人员统计的待处理任务数', 'count_of_assigned_task_in_user', 'count', NULL, '按人员统计的待处理任务数表示每个人待处理的任务数量之和。反映了每个人在需要处理的任务数量上的规模。该数值越大，说明需要投入越多的时间处理任务。', '所有任务个数求和\r\n指派给为某人\r\n过滤已删除的任务\r\n过滤已删除项目的任务\r\n过滤已删除执行的任务', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'user', 'bug', 'released', 'php', '按人员统计的日解决Bug数', 'count_of_daily_fixed_bug_in_user', 'count', NULL, '按人员统计的日解决Bug数表示每个人每日解决的Bug数量之和。反映了每个人每日解决Bug的规模。该数值越大，可能说明Bug的解决能力越强，工作效率越高。', '所有Bug个数求和\r\n解决者为某人', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'user', 'bug', 'released', 'php', '按人员统计的待处理Bug数', 'count_of_assigned_bug_in_user', 'count', NULL, '按人员统计的待处理Bug数表示每个人待处理的Bug数量之和。反映了每个人需要处理的Bug数量上的规模。该数值越大，说明需要投入越多的时间解决Bug。', '所有Bug个数求和\r\n指派给为某人\r\n过滤已删除的Bug\r\n过滤已删除产品的Bug', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'user', 'case', 'released', 'php', '按人员统计的待处理用例数', 'count_of_assigned_case_in_user', 'count', NULL, '按人员统计的待处理用例数表示每个人待处理的用例数量之和。反映了每个人需要处理的用例数量上的规模。该数值越大，说明需要投入越多的时间处理用例。', '所有用例个数求和\r\n指派给为某人\r\n过滤已删除的用例\r\n过滤已删除产品的用例', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'user', 'feedback', 'released', 'php', '按人员统计的待处理反馈数', 'count_of_assigned_feedback_in_user', 'count', NULL, '按人员统计的待处理反馈数表示每个人待处理的反馈数量之和。反映了每个人需要处理的反馈数量上的规模。该数值越大，说明需要投入越多的时间处理反馈。', '所有反馈个数求和\r\n指派给为某人\r\n过滤已删除的反馈\r\n过滤已删除产品的反馈', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'user', 'feedback', 'released', 'php', '按人员统计的待评审反馈数', 'count_of_reviewing_feedback_in_user', 'count', NULL, '按人员统计的待评审反馈数表示每个人待评审的反馈数量之和。反映了每个人需要评审的反馈的规模。该数值越大，说明需要投入越多的时间评审反馈。', '所有反馈个数求和\r\n状态为待评审\r\n指派给为某人\r\n过滤已删除的反馈\r\n过滤已删除产品的反馈', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('scale', 'user', 'feedback', 'released', 'php', '按人员统计的每日评审反馈数', 'count_of_daily_review_feedback_in_user', 'count', NULL, '按人员统计的日评审反馈数表示每个人每日评审的反馈数量之和。反映了每个人每日评审的反馈的规模。该数值越大，说明工作量越大。', '所有反馈个数求和\r\n由谁评审为某人\r\n评审时间为某日\r\n过滤已删除的反馈\r\n过滤已删除产品的反馈', 'realtime', '', '', '', 'system', '2023-08-22 08:00:00', '', NULL, '', NULL, '', NULL, '1', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('qc', 'code', 'issue', 'released', 'php', '按代码库统计代码问题提交次数', 'count_of_submitted_code_issues_in_codebase', 'count', NULL, '按代码库统计代码问题提交次数，可作为度量项衡量研发过程中出现的代码问题频率。代码问题提交次数反映了代码质量和稳定性方面的情况。', '代码库中问题提交次数相加。\r\n不包含已删除。', 'realtime', '', '', '', '', NULL, '', NULL, '', NULL, '', NULL, '0', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('qc', 'code', 'issue', 'released', 'php', '按代码库统计代码问题解决总数', 'count_of_resolved_code_issues_in_codebase', 'count', NULL, '按代码库统计的代码问题解决总数是指在特定代码库中解决的所有代码问题的总数。它可以反映团队在代码质量方面的工作效能和改进情况。', '代码库中问题解决次数相加。\r\n不包含已删除。', 'realtime', '', '', '', '', NULL, '', NULL, '', NULL, '', NULL, '0', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('qc', 'code', 'issue', 'released', 'php', '按代码库统计代码中待处理的问题总数', 'count_of_pending_issues_in_codebase', 'count', NULL, '按代码库统计的代码问题库存总数是指在代码库中记录的所有未解决的代码问题的总数，它反映了代码质量和稳定性。', '代码库中所有未关闭的问题数量相加。\r\n不包含已删除。', 'realtime', '', '', '', '', NULL, '', NULL, '', NULL, '', NULL, '0', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('rate', 'code', 'mergeRequest', 'released', 'php', '按代码库统计合并请求合并次数', 'count_of_merged_pull_requests_in_codebase', 'count', NULL, '按代码库统计的合并请求合并次数是指在代码库中完成的全部合并请求的数量。该度量项反映了代码库的合并流程和代码合并质量，有助于评估团队的协作效率和代码更新情况。', '代码库中合并请求合并次数相加。\r\n不包含已删除。', 'realtime', '', '', '', '', NULL, '', NULL, '', NULL, '', NULL, '0', 0, 0, '0');
INSERT INTO `zt_metric`(`purpose`, `scope`, `object`, `stage`, `type`, `name`, `code`, `unit`, `collector`, `desc`, `definition`, `when`, `event`, `cronCFG`, `time`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `implementedBy`, `implementedDate`, `delistedBy`, `delistedDate`, `builtin`, `fromID`, `order`, `deleted`) VALUES ('rate', 'code', 'commit', 'released', 'php', '按代码库统计代码提交次数', 'count_of_code_commits_in_codebase', 'count', NULL, '按代码库统计的代码提交次数是指代码库中的全部代码提交（Commit）操作的数量。代码提交次数反映了代码库的开发活动频率和代码更新情况，可以评估开发团队的工作量和迭代速度。', '代码库中代码提交次数相加。\r\n不包含已删除。', 'realtime', '', '', '', '', NULL, '', NULL, '', NULL, '', NULL, '0', 0, 0, '0');

ALTER TABLE `zt_repo` ADD `lastCommit` DATETIME NULL DEFAULT NULL AFTER `lastSync`;
ALTER TABLE `zt_story` ADD `releasedDate` datetime DEFAULT NULL AFTER `reviewedDate`;
ALTER TABLE `zt_project` ADD `firstEnd` date DEFAULT NULL AFTER `end`;
ALTER TABLE `zt_product` ADD `closedDate` date DEFAULT NULL AFTER `createdVersion`;
ALTER TABLE `zt_productplan` ADD `finishedDate` datetime DEFAULT NULL AFTER `end`;
ALTER TABLE `zt_productplan` ADD `closedDate` datetime DEFAULT NULL AFTER `finishedDate`;

UPDATE `zt_case` SET `sort` = `id` WHERE `sort` = 0;
UPDATE `zt_scene` SET `sort` = `id` WHERE `sort` = 0;
UPDATE `zt_project` SET `firstEnd` = `end`;
UPDATE `zt_product` AS t1 JOIN `zt_action` AS t2 ON t2.`objectID` = t1.`id` AND t2.`action` = 'closed' AND t2.`objectType` = 'product' SET t1.`closedDate` = t2.`date`;
UPDATE `zt_productplan` AS t1 JOIN `zt_action` AS t2 ON t2.`objectID` = t1.`id` AND t2.`action` LIKE 'close%' AND t2.`objectType` = 'productplan' SET t1.`closedDate` = t2.`date`;
UPDATE `zt_productplan` AS t1 JOIN `zt_action` AS t2 ON t2.`objectID` = t1.`id` AND t2.`action` LIKE 'finish%' AND t2.`objectType` = 'productplan' SET t1.`finishedDate` = t2.`date`;

INSERT INTO `zt_cron`(`m`, `h`, `dom`, `mon`, `dow`, `command`, `remark`, `type`, `buildin`, `status`, `lastTime`) VALUES ('59', '23', '*', '*', '*', 'moduleName=metric&methodName=updateMetricLib', '计算度量数据', 'zentao', 1, 'normal', NUll);

INSERT INTO `zt_chart`(`id`, `name`, `dimension`, `type`, `group`, `desc`, `settings`, `filters`, `step`, `fields`, `langs`, `sql`, `stage`, `builtin`, `objects`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES (20002, '活跃账号情况-活跃账号数项目间对比', 1, 'table', '62', ' ', '{\"group\":[],\"column\":[{\"field\":\"name\",\"valOrAgg\":\"value\",\"name\":\"项目\"},{\"field\":\"activeAccount\",\"valOrAgg\":\"value\",\"name\":\"活跃账号数\"},{\"field\":\"totalAccount\",\"valOrAgg\":\"value\",\"name\":\"团队账号数\"},{\"field\":\"ratio\",\"valOrAgg\":\"value\",\"name\":\"活跃账号比\"}],\"filter\":[]}', '[]', 0, ' ', NULL, 'SELECT t1.id, t1.name, t1.year, t1.month, t1.totalAccount, ifnull(t2.activeAccount,0) as activeAccount, ifnull(concat(truncate(t2.activeAccount/t1.totalAccount*100,2),\'%\'), 0) as ratio\r\nFROM (\r\nselect t1.id, t1.name, t3.year, t3.month, count(distinct t2.`account`) as totalAccount\r\nfrom zt_project as t1\r\nleft join zt_team as t2 on t1.id = t2.root\r\nleft join (\r\n    SELECT DISTINCT YEAR(`date`) AS `year`, MONTH(`date`) AS `month`, cast(`date` as DATE) as date\r\n    FROM zt_action\r\n) as t3 on t2.`join` <= t3.date\r\nleft join zt_user as t4 on t2.account = t4.account\r\nwhere t1.type = \'project\'\r\nand t4.deleted = \'0\'\r\ngroup by t1.id, t3.year, t3.month\r\n) AS t1 LEFT JOIN (\r\nSELECT t1.id, t1.name, t4.year,t4.month, COUNT(DISTINCT t3.id) AS activeAccount\r\nFROM\r\n  zt_project AS t1\r\n  LEFT JOIN zt_team AS t2 ON t1.id = t2.root\r\n  LEFT JOIN zt_user AS t3 ON t2.account = t3.account\r\n  LEFT JOIN (\r\n    SELECT objectID, YEAR(date) AS year, MONTH(date) AS month, cast(`date` as DATE) as date\r\n    FROM zt_action\r\n    WHERE objectType = \'user\' AND action = \'login\'\r\n  ) AS t4 ON t3.id = t4.objectID and t2.`join` <= t4.date\r\nWHERE\r\n  t3.deleted = \'0\' AND t1.type = \'project\'\r\nGROUP BY t1.id, t4.year, t4.month\r\n) AS t2 ON t1.year = t2.year AND t1.month = t2.month AND t1.id = t2.id\r\nORDER BY t2.activeAccount DESC', 'published', 1, ' ', 'admin', '2023-08-16 13:37:24', 'admin', '2023-08-16 13:37:24', 0);
INSERT INTO `zt_chart`(`id`, `name`, `dimension`, `type`, `group`, `desc`, `settings`, `filters`, `step`, `fields`, `langs`, `sql`, `stage`, `builtin`, `objects`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES (20003, '活跃账号情况-公司账号日活跃度趋势', 1, 'line', '56', ' ', '{\r\n  \"xaxis\":[{\"field\":\"day\",\"name\":\"日期\",\"group\":\"value\"}],\r\n  \"yaxis\":[{\"type\":\"value\",\"field\":\"count\",\"agg\":\"value\",\"name\":\"数量\",\"valOrAgg\":\"value\"}]\r\n}\r\n', '[]', 0, ' ', NULL, 'SELECT YEAR(t2.date) AS year, MONTH(t2.date) AS month, DAY(t2.date) AS day, COUNT(DISTINCT t1.account) AS count FROM zt_user AS t1\r\nLEFT JOIN zt_action AS t2 ON t1.account = t2.actor\r\nWHERE t2.objectType = \'user\' AND t2.action = \'login\'\r\nGROUP BY YEAR(t2.date), MONTH(t2.date), DAY(t2.date)', 'published', 1, ' ', 'admin', '2023-08-16 13:37:24', 'admin', '2023-08-16 13:37:24', 0);
INSERT INTO `zt_chart`(`id`, `name`, `dimension`, `type`, `group`, `desc`, `settings`, `filters`, `step`, `fields`, `langs`, `sql`, `stage`, `builtin`, `objects`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES (20004, '应用数据-活跃产品数', 1, 'card', '47', ' ', '{\"value\": {\"type\": \"value\", \"field\": \"count\", \"agg\": \"value\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}', '[]', 0, ' ', NULL, 'select count(distinct REPLACE(product, \',\', \'\')) as count, year(date) as year, month(date) as month \r\nfrom zt_action\r\nwhere objectType not in (\'project\',\'execution\',\'task\')\r\nand product != \',0,\'\r\nand product != \',\'\r\nand product != \'\'\r\ngroup by year(date), month(date)', 'published', 1, '  ', 'admin', '2023-08-16 13:37:24', 'admin', '2023-08-16 13:37:24', 0);
INSERT INTO `zt_chart`(`id`, `name`, `dimension`, `type`, `group`, `desc`, `settings`, `filters`, `step`, `fields`, `langs`, `sql`, `stage`, `builtin`, `objects`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES (20005, '应用数据-本月新增产品数', 1, 'card', '47', ' ', '{\"value\": {\"type\": \"value\", \"field\": \"count\", \"agg\": \"value\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}', '[]', 0, ' ', NULL, 'SELECT DISTINCT YEAR(createdDate) AS year, MONTH(createdDate) AS month, count(id) as count FROM zt_product\r\nWHERE deleted = \'0\' AND shadow = \'0\'\r\nGROUP BY YEAR(createdDate), MONTH(createdDate)', 'published', 1, ' ', 'admin', '2023-08-16 13:37:24', 'admin', '2023-08-16 13:37:24', 0);
INSERT INTO `zt_chart`(`id`, `name`, `dimension`, `type`, `group`, `desc`, `settings`, `filters`, `step`, `fields`, `langs`, `sql`, `stage`, `builtin`, `objects`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES (20006, '应用数据-本月新增产品名', 1, 'card', '47', ' ', '{\"value\": {\"type\": \"text\", \"field\": \"name\", \"agg\": \"value\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}', '[]', 0, ' ', NULL, 'SELECT DISTINCT GROUP_CONCAT(name) AS name, YEAR(createdDate) AS year, MONTH(createdDate) AS month FROM zt_product\r\nWHERE deleted = \'0\' AND shadow = \'0\'\r\nGROUP BY YEAR(createdDate), MONTH(createdDate)\r\n', 'published', 1, ' ', 'admin', '2023-08-16 13:37:24', 'admin', '2023-08-16 13:37:24', 0);
INSERT INTO `zt_chart`(`id`, `name`, `dimension`, `type`, `group`, `desc`, `settings`, `filters`, `step`, `fields`, `langs`, `sql`, `stage`, `builtin`, `objects`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES (20007, '应用数据-活跃项目数', 1, 'card', '46', ' ', '{\"value\": {\"type\": \"value\", \"field\": \"count\", \"agg\": \"value\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}', '[]', 0, ' ', NULL, 'select year(date) as year, month(date) as month, count(distinct project) as count\r\nfrom zt_action\r\nwhere project != 0\r\ngroup by year(date), month(date)', 'published', 1, ' ', 'admin', '2023-08-16 13:37:24', 'admin', '2023-08-16 13:37:24', 0);
INSERT INTO `zt_chart`(`id`, `name`, `dimension`, `type`, `group`, `desc`, `settings`, `filters`, `step`, `fields`, `langs`, `sql`, `stage`, `builtin`, `objects`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES (20008, '应用数据-本月新增项目数', 1, 'card', '46', ' ', '{\"value\": {\"type\": \"value\", \"field\": \"count\", \"agg\": \"value\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}', '[]', 0, ' ', NULL, 'SELECT COUNT(id) as count, YEAR(openedDate) AS year, MONTH(openedDate) AS month FROM zt_project\r\nWHERE deleted = \'0\' AND type = \'project\'\r\nGROUP BY YEAR(openedDate), MONTH(openedDate)', 'published', 1, ' ', 'admin', '2023-08-16 13:37:24', 'admin', '2023-08-16 13:37:24', 0);
INSERT INTO `zt_chart`(`id`, `name`, `dimension`, `type`, `group`, `desc`, `settings`, `filters`, `step`, `fields`, `langs`, `sql`, `stage`, `builtin`, `objects`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES (20009, '应用数据-本月新增项目名 ', 1, 'card', '46', ' ', '{\"value\": {\"type\": \"text\", \"field\": \"name\", \"agg\": \"value\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}', '[]', 0, ' ', NULL, 'SELECT DISTINCT GROUP_CONCAT(name) AS name, YEAR(openedDate) AS year, MONTH(openedDate) AS month FROM zt_project\r\nWHERE deleted = \'0\' AND type = \'project\'\r\nGROUP BY YEAR(openedDate), MONTH(openedDate)\r\n', 'published', 1, ' ', 'admin', '2023-08-16 13:37:24', 'admin', '2023-08-16 13:37:24', 0);
INSERT INTO `zt_chart`(`id`, `name`, `dimension`, `type`, `group`, `desc`, `settings`, `filters`, `step`, `fields`, `langs`, `sql`, `stage`, `builtin`, `objects`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES (20010, '应用数据-项目任务概况表', 1, 'table', '60', ' ', '{\"group\":[],\"column\":[{\"field\":\"name\",\"valOrAgg\":\"value\",\"name\":\"项目\"},{\"field\":\"createdTasks\",\"valOrAgg\":\"value\",\"name\":\"新增任务数\"},{\"field\":\"contributors\",\"valOrAgg\":\"value\",\"name\":\"新增任务人数\"},{\"field\":\"finishedTasks\",\"valOrAgg\":\"value\",\"name\":\"完成任务数\"}],\"filter\":[]}', '[]', 0, ' ', NULL, 'SELECT\n	t1.name,\n	t4.year,\n	t4.month,\n	t1.createdTasks,\n	t2.finishedTasks,\n	t3.contributors \nFROM\r\n  (\r\nselect distinct year(date) as year, month(date) as month\r\nfrom zt_action \r\n  ) as t4 \r\nleft join\n	(\nSELECT\n	t1.id,\n	t1.NAME,\n	YEAR ( t2.openedDate ) AS YEAR,\n	MONTH ( t2.openedDate ) AS MONTH,\n	COUNT( t2.id ) AS createdTasks \nFROM\n	zt_project AS t1\n	LEFT JOIN zt_task AS t2 ON t1.id = t2.project \nWHERE\n	t1.type = \'project\' \nGROUP BY\n	t1.id,\n	YEAR ( t2.openedDate ),\n	MONTH ( t2.openedDate ) \n	) AS t1 on t4.year = t1.year and t4.month = t1.month\n	LEFT JOIN (\nSELECT\n	t1.id,\n	t1.NAME,\n	YEAR ( t2.finishedDate ) AS YEAR,\n	MONTH ( t2.finishedDate ) AS MONTH,\n	COUNT( t2.id ) AS finishedTasks \nFROM\n	zt_project AS t1\n	LEFT JOIN zt_task AS t2 ON t1.id = t2.project \nWHERE\n	t1.type = \'project\' \n	AND t2.finishedDate IS NOT NULL \nGROUP BY\n	t1.id,\n	YEAR ( t2.finishedDate ),\n	MONTH ( t2.finishedDate ) \n	) AS t2 ON t1.id = t2.id \n	AND t4.YEAR = t2.YEAR \n	AND t4.MONTH = t2.\n	MONTH LEFT JOIN (\nSELECT\n	t1.id,\n	t1.NAME,\n	YEAR ( t3.date ) AS YEAR,\n	MONTH ( t3.date ) AS MONTH,\n	COUNT( DISTINCT t3.actor ) AS CONTRIBUTORS \nFROM\n	zt_project AS t1\n	LEFT JOIN zt_task AS t2 ON t1.id = t2.project\n	LEFT JOIN zt_action AS t3 ON t2.id = t3.objectID \nWHERE\n	t1.type = \'project\' \n	AND t3.objectType = \'task\' \n	AND t3.action IN ( \'opened\', \'closed\', \'finished\', \'canceled\', \'assigned\' ) \nGROUP BY\n	t1.id,\n	YEAR ( t3.date ),\n	MONTH ( t3.date ) \n	) AS t3 ON t1.id = t3.id \n	AND t4.YEAR = t3.YEAR \n	AND t4.MONTH = t3.MONTH\r\n	order by t1.id,t4.year', 'published', 1, ' ', 'admin', '2023-08-16 13:37:24', 'admin', '2023-08-16 13:37:24', 0);
INSERT INTO `zt_chart`(`id`, `name`, `dimension`, `type`, `group`, `desc`, `settings`, `filters`, `step`, `fields`, `langs`, `sql`, `stage`, `builtin`, `objects`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES (20011, '应用数据-产品测试表', 1, 'table', '63', ' ', '{\"group\":[],\"column\":[{\"field\":\"name\",\"valOrAgg\":\"value\",\"name\":\"产品\"},{\"field\":\"createdCases\",\"valOrAgg\":\"value\",\"name\":\"新增用例数\"},{\"field\":\"avgBugsOfCase\",\"valOrAgg\":\"value\",\"name\":\"用例平均Bug数\"},\r\n{\"field\":\"createdBugs\",\"valOrAgg\":\"value\",\"name\":\"新增Bug数\"},{\"field\":\"fixedBugs\",\"valOrAgg\":\"value\",\"name\":\"修复Bug数\"},{\"field\":\"avgFixedCycle\",\"valOrAgg\":\"value\",\"name\":\"Bug平均修复周期\"}],\"filter\":[]}\r\n', '[]', 0, ' ', NULL, 'SELECT * FROM\r\n(\r\nSELECT\r\n	t1.name,\r\n	t6.year,\r\n	t6.month,\r\n	IFNULL(t5.createdCases, 0) AS createdCases,\r\n	IFNULL(t4.relativedBugs / t5.createdCases, 0) AS avgBugsOfCase,\r\n	IFNULL(t1.createdBugs, 0) AS createdBugs,\r\n	IFNULL(t2.fixedBugs, 0) AS fixedBugs,\r\n	IFNULL(t3.fixedCycle / t2.fixedBugs, 0) AS avgFixedCycle \r\nFROM\r\n	(\r\n	select distinct year(date) as year, month(date) as month\r\n	from zt_action\r\n	) AS t6 left join\r\n	(\r\n	SELECT\r\n	t1.id,\r\n	t1.NAME,\r\n	YEAR ( t2.openedDate ) AS YEAR,\r\n	MONTH ( t2.openedDate ) AS MONTH,\r\n	COUNT( t2.id ) AS createdBugs \r\nFROM\r\n	zt_product AS t1\r\n	LEFT JOIN zt_bug AS t2 ON t1.id = t2.product \r\nWHERE\r\n	t1.deleted = \'0\' \r\n	AND t2.deleted = \'0\' \r\nGROUP BY\r\n	t1.id,\r\n	YEAR ( t2.openedDate ),\r\n	MONTH ( t2.openedDate )\r\n	) AS t1 on t1.year = t6.year AND t1.month = t6.month\r\n	LEFT JOIN (\r\nSELECT\r\n	t1.id,\r\n	t1.NAME,\r\n	YEAR ( t2.resolvedDate ) AS YEAR,\r\n	MONTH ( t2.resolvedDate ) AS MONTH,\r\n	COUNT( t2.id ) AS fixedBugs \r\nFROM\r\n	zt_product AS t1\r\n	LEFT JOIN zt_bug AS t2 ON t1.id = t2.product \r\nWHERE\r\n	t1.deleted = \'0\' \r\n	AND t2.deleted = \'0\' \r\n	AND t2.`status` = \'closed\' \r\n	AND t2.resolution = \'fixed\' \r\nGROUP BY\r\n	t1.id,\r\n	YEAR ( t2.resolvedDate ),\r\n	MONTH ( t2.resolvedDate ) \r\n	) AS t2 ON t1.id = t2.id \r\n	AND t6.YEAR = t2.YEAR \r\n	AND t6.MONTH = t2.MONTH \r\n	LEFT JOIN (\r\nSELECT\r\n	t1.id,\r\n	t1.NAME,\r\n	YEAR ( t2.resolvedDate ) AS YEAR,\r\n	MONTH ( t2.resolvedDate ) AS MONTH,\r\n	SUM( DATEDIFF( t2.resolvedDate, t2.openedDate ) ) AS fixedCycle \r\nFROM\r\n	zt_product AS t1\r\n	LEFT JOIN zt_bug AS t2 ON t1.id = t2.product \r\nWHERE\r\n	t1.deleted = \'0\' \r\n	AND t2.deleted = \'0\'\r\n	AND t2.`status` = \'closed\'\r\n	AND t2.resolution = \'fixed\' \r\nGROUP BY\r\n	t1.id,\r\n	YEAR ( t2.resolvedDate ),\r\n	MONTH ( t2.resolvedDate ) \r\n	) AS t3 ON t1.id = t3.id \r\n	AND t6.YEAR = t3.YEAR \r\n	AND t6.MONTH = t3.\r\n	MONTH LEFT JOIN (\r\nSELECT\r\n	t1.id,\r\n	t1.NAME,\r\n	YEAR ( t2.openedDate ) AS YEAR,\r\n	MONTH ( t2.openedDate ) AS MONTH,\r\n	COUNT( t3.id ) AS relativedBugs \r\nFROM\r\n	zt_product AS t1\r\n	LEFT JOIN zt_case AS t2 ON t1.id = t2.product\r\n	LEFT JOIN zt_bug AS t3 ON t2.id = t3.`case` \r\nWHERE\r\n	t2.id IS NOT NULL \r\n	AND t3.id IS NOT NULL\r\n  AND t1.deleted = \'0\'\r\n	AND t2.deleted = \'0\'\r\n	AND t3.deleted = \'0\'\r\nGROUP BY\r\n	t1.id,\r\n	YEAR ( t2.openedDate ),\r\n	MONTH ( t2.openedDate ) \r\n	) AS t4 ON t1.id = t4.id \r\n	AND t6.YEAR = t4.YEAR \r\n	AND t6.MONTH = t4.\r\n	MONTH LEFT JOIN (\r\n SELECT\r\n	t1.id,\r\n	t1.NAME,\r\n	YEAR ( t2.openedDate ) AS YEAR,\r\n	MONTH ( t2.openedDate ) AS MONTH,\r\n	COUNT( t2.id ) AS createdCases \r\nFROM\r\n	zt_product AS t1\r\n	LEFT JOIN zt_case AS t2 ON t1.id = t2.product \r\nWHERE\r\n	t1.deleted = \'0\' \r\n	AND t2.deleted = \'0\' \r\nGROUP BY\r\n	t1.id,\r\n	YEAR ( t2.openedDate ),\r\n	MONTH ( t2.openedDate )\r\n	) AS t5 ON t1.id = t5.id \r\n	AND t6.YEAR = t5.YEAR \r\n	AND t6.MONTH = t5.MONTH\r\n) AS t WHERE t.name IS NOT NULL', 'published', 1, ' ', 'admin', '2023-08-16 13:37:24', 'admin', '2023-08-16 13:37:24', 0);
INSERT INTO `zt_chart`(`id`, `name`, `dimension`, `type`, `group`, `desc`, `settings`, `filters`, `step`, `fields`, `langs`, `sql`, `stage`, `builtin`, `objects`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES (20012, '应用数据-产品需求概况表', 1, 'table', '63', ' ', '{\"group\":[],\"column\":[{\"field\":\"name\",\"valOrAgg\":\"value\",\"name\":\"产品\"},{\"field\":\"createdStories\",\"valOrAgg\":\"value\",\"name\":\"新增研发需求数\"},{\"field\":\"deliveredStories\",\"valOrAgg\":\"value\",\"name\":\"交付需求数\"}],\"filter\":[]}', '[]', 0, ' ', NULL, 'SELECT * FROM\r\n(\r\nSELECT\r\n	t1.id,\r\n	t1.name,\r\n	t3.year,\r\n	t3.month,\r\n	IFNULL(t1.count, 0) AS createdStories,\r\n	IFNULL(t2.count, 0) AS deliveredStories \r\nFROM\r\n	(\r\n	select distinct year(date) as year, month(date) as month\r\n	from zt_action\r\n	)\r\n	as t3 left join\r\n	(\r\nSELECT\r\n	t2.id,\r\n	t2.NAME,\r\n	YEAR ( t1.openedDate ) AS YEAR,\r\n	MONTH ( t1.openedDate ) AS MONTH,\r\n	COUNT( t1.id ) AS count \r\nFROM\r\n	zt_story AS t1\r\n	LEFT JOIN zt_product AS t2 ON t1.product = t2.id \r\nWHERE\r\n	t2.deleted = \'0\'\r\n	AND t1.deleted = \'0\'\r\n	AND t1.type = \'story\'\r\nGROUP BY\r\n	t2.id,\r\n	YEAR,\r\nMONTH \r\n	) AS t1 on t3.year = t1.year and t3.month = t1.month\r\n	LEFT JOIN (\r\nSELECT\r\n	t1.id,\r\n	t1.NAME,\r\n	t1.YEAR,\r\n	t1.MONTH,\r\n	COUNT( distinct t1.story ) AS count \r\nFROM\r\n	(\r\nSELECT\r\n	t2.id,\r\n	t2.NAME, \r\n	YEAR ( t3.date ) AS YEAR,\r\n	MONTH ( t3.date ) AS MONTH,\r\n	t1.id AS story \r\nFROM\r\n	zt_story AS t1\r\n	LEFT JOIN zt_product AS t2 ON t1.product = t2.id\r\n	LEFT JOIN ( SELECT objectID, MAX( date ) AS date FROM zt_action WHERE objectType = \'story\' AND action = \'linked2release\' GROUP BY objectID ) AS t3 ON t1.id = t3.objectID \r\nWHERE\r\n	t1.deleted = \'0\' \r\n	AND t2.deleted = \'0\' \r\n	AND EXISTS ( SELECT 1 FROM zt_action WHERE objectID = t1.id AND objectType = \'story\' AND action = \'linked2release\' ) \r\nUNION\r\nSELECT\r\n	t2.id,\r\n	t2.NAME,\r\n	YEAR ( t1.closedDate ) AS YEAR,\r\n	MONTH ( t1.closedDate ) AS MONTH,\r\n	t1.id AS story \r\nFROM\r\n	zt_story AS t1\r\n	LEFT JOIN zt_product AS t2 ON t1.product = t2.id \r\nWHERE\r\n	t1.deleted = \'0\' \r\n	AND t2.deleted = \'0\' \r\n	AND t1.status = \'closed\' \r\n	AND t1.closedReason = \'done\' \r\n	) AS t1 \r\nGROUP BY\r\n	t1.id,\r\n	t1.name,\r\n	t1.YEAR,\r\n	t1.MONTH order by id asc \r\n	) AS t2 ON t1.id = t2.id \r\n	AND t3.YEAR = t2.YEAR \r\n	AND t3.MONTH = t2.MONTH\r\n) AS t\r\nWHERE t.name IS NOT NULL', 'published', 1, ' ', 'admin', '2023-08-16 13:37:24', 'admin', '2023-08-16 13:37:24', 0);
INSERT INTO `zt_chart`(`id`, `name`, `dimension`, `type`, `group`, `desc`, `settings`, `filters`, `step`, `fields`, `langs`, `sql`, `stage`, `builtin`, `objects`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES (20013, '应用数据-项目需求概况表', 1, 'table', '60', ' ', '{\"group\":[],\"column\":[{\"field\":\"name\",\"valOrAgg\":\"value\",\"name\":\"项目\"},{\"field\":\"createdStories\",\"valOrAgg\":\"value\",\"name\":\"新增研发需求数\"},{\"field\":\"deliveredStories\",\"valOrAgg\":\"value\",\"name\":\"交付需求数\"}],\"filter\":[]}', '[]', 0, ' ', NULL, 'SELECT * FROM (\r\nSELECT\r\n	t1.id,\r\n	t1.name,\r\n	t3.year,\r\n	t3.month,\r\n	IFNULL(t1.count, 0) AS createdStories,\r\n	IFNULL(t2.count, 0) AS deliveredStories \r\nFROM\r\n	(\r\n	select distinct year(date) as year, month(date) as month\r\n	from zt_action\r\n	)\r\n	as t3 left join\r\n	(\r\nSELECT\r\n	t3.id,\r\n	t3.NAME,\r\n	YEAR ( t1.openedDate ) AS YEAR,\r\n	MONTH ( t1.openedDate ) AS MONTH,\r\n	COUNT( t1.id ) AS count \r\nFROM\r\n	zt_story AS t1\r\n	LEFT JOIN zt_projectstory AS t2 ON t1.id = t2.story\r\n	LEFT JOIN zt_project AS t3 ON t2.project = t3.id \r\nWHERE\r\n	t3.type = \'project\' \r\n	AND t1.deleted = \'0\' \r\n	AND t3.deleted = \'0\' \r\nGROUP BY\r\n	t3.id,\r\n	YEAR,\r\nMONTH \r\n	) AS t1 on t1.year = t3.year and t1.month = t3.month\r\n	LEFT JOIN (\r\nSELECT\r\n	t1.id,\r\n	t1.NAME,\r\n	t1.YEAR,\r\n	t1.MONTH,\r\n	COUNT( t1.story ) AS count \r\nFROM\r\n	(\r\nSELECT\r\n	t3.id,\r\n	t3.NAME,\r\n	YEAR ( t4.date ) AS YEAR,\r\n	MONTH ( t4.date ) AS MONTH,\r\n	t1.id AS story \r\nFROM\r\n	zt_story AS t1\r\n	LEFT JOIN zt_projectstory AS t2 ON t1.id = t2.story\r\n	LEFT JOIN zt_project AS t3 ON t2.project = t3.id\r\n	LEFT JOIN ( SELECT objectID, MAX( date ) AS date FROM zt_action WHERE objectType = \'story\' AND action = \'linked2release\' GROUP BY objectID ) AS t4 ON t1.id = t4.objectID \r\nWHERE\r\n	t3.type = \'project\' \r\n	AND t1.deleted = \'0\' \r\n	AND t3.deleted = \'0\' \r\n	AND EXISTS ( SELECT 1 FROM zt_action WHERE objectID = t1.id AND objectType = \'story\' AND action = \'linked2release\' ) UNION\r\nSELECT\r\n	t3.id,\r\n	t3.NAME,\r\n	YEAR ( t1.closedDate ) AS YEAR,\r\n	MONTH ( t1.closedDate ) AS MONTH,\r\n	t1.id AS story \r\nFROM\r\n	zt_story AS t1\r\n	LEFT JOIN zt_projectstory AS t2 ON t1.id = t2.story\r\n	LEFT JOIN zt_project AS t3 ON t2.project = t3.id \r\nWHERE\r\n	t3.type = \'project\' \r\n	AND t1.STATUS = \'closed\' \r\n	AND t1.closedReason = \'done\' \r\n	AND t1.deleted = \'0\' \r\n	AND t3.deleted = \'0\' \r\n	) AS t1 \r\nGROUP BY\r\n	t1.id,\r\n	t1.name,\r\n	t1.YEAR,\r\n	t1.MONTH \r\n	) AS t2 ON t1.id = t2.id \r\n	AND t3.YEAR = t2.YEAR \r\n	AND t3.MONTH = t2.MONTH\r\n) AS t WHERE t.id IS NOT NULL', 'published', 1, ' ', 'admin', '2023-08-16 13:37:24', 'admin', '2023-08-16 13:37:24', 0);
INSERT INTO `zt_chart`(`id`, `name`, `dimension`, `type`, `group`, `desc`, `settings`, `filters`, `step`, `fields`, `langs`, `sql`, `stage`, `builtin`, `objects`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES (20014, '使用数据分析-当前版本', 1, 'card', '58', ' ', '{\"value\": {\"type\": \"value\", \"field\": \"version\", \"agg\": \"value\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}', ' ', 0, ' ', NULL, 'SELECT REPLACE(REPLACE(REPLACE(value, \'max\', \'旗舰版\'), \'biz\', \'企业版\'), \'pro\', \'专业版\') as version FROM zt_config WHERE owner = \'system\' AND module = \'common\' AND section = \'global\' AND `key` = \'version\'', 'published', 1, ' ', 'admin', '2023-08-16 15:28:35', 'admin', '2023-08-16 15:28:41', 0);
INSERT INTO `zt_chart`(`id`, `name`, `dimension`, `type`, `group`, `desc`, `settings`, `filters`, `step`, `fields`, `langs`, `sql`, `stage`, `builtin`, `objects`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES (20015, '使用数据分析-上线时间', 1, 'card', '58', ' ', '{\"value\": {\"type\": \"value\", \"field\": \"date\", \"agg\": \"value\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}', '[]', 0, ' ', NULL, 'select concat(year(date), \'-\', month(date), \'-\', day(date)) as date from zt_action order by id asc limit 1', 'published', 1, ' ', 'admin', '2023-08-16 15:32:10', 'admin', '2023-08-16 15:32:17', 0);

INSERT INTO `zt_screen`(`id`, `dimension`, `name`, `desc`, `cover`, `scheme`, `status`, `builtin`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES (1001, 1, '禅道月度应用健康度体检大屏', '公司级禅道应用健康度体检大屏，促进项目管理持续改进。', '', '[{\"id\":\"5scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":0,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":1300,\"h\":120,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static\\/images\\/screen_header.png\",\"borderRadius\":10}},{\"id\":\"2nws38440fq000\",\"isGroup\":false,\"attr\":{\"x\":400,\"y\":36,\"w\":500,\"h\":66,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"title\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u7985\\u9053\\u6708\\u5ea6\\u5e94\\u7528\\u5065\\u5eb7\\u5ea6\\u4f53\\u68c0\\u5927\\u5c4f\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"5scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":300,\"h\":120,\"x\":0,\"y\":95,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"type\":\"year\",\"filterCharts\":[{\"chart\":20001,\"field\":\"t1.`year`\"},{\"chart\":20002,\"field\":\"t1.`year`\"},{\"chart\":20003,\"field\":\"t1.`year`\"},{\"chart\":20004,\"field\":\"t1.`year`\"},{\"chart\":20005,\"field\":\"t1.`year`\"},{\"chart\":20006,\"field\":\"t1.`year`\"},{\"chart\":20007,\"field\":\"t1.`year`\"},{\"chart\":20008,\"field\":\"t1.`year`\"},{\"chart\":20009,\"field\":\"t1.`year`\"},{\"chart\":20010,\"field\":\"t1.`year`\"},{\"chart\":20011,\"field\":\"t1.`year`\"},{\"chart\":20012,\"field\":\"t1.`year`\"},{\"chart\":20013,\"field\":\"t1.`year`\"}],\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":120,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Select\",\"chartConfig\":{\"key\":\"Select\",\"chartKey\":\"VSelect\",\"conKey\":\"VCSelect\",\"title\":\"\\u9009\\u62e9\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/select-c616737a.png\"},\"option\":{\"dataset\":[{\"label\":\"\\u8bf7\\u9009\\u62e9\",\"value\":\"\"},{\"label\":\"\\u6cb3\\u5317\",\"value\":\"18700\"},{\"label\":\"\\u5f90\\u5dde\",\"value\":\"17800\"}],\"value\":\"\",\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"background\":\"none\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"backgroundColor\":\"transparent\",\"fontSize\":20,\"onChange\":\"console.log(value)\"}},{\"id\":\"2xjom2cw2b2000\",\"type\":\"month\",\"filterCharts\":[{\"chart\":20001,\"field\":\"t1.`month`\"},{\"chart\":20002,\"field\":\"t1.`month`\"},{\"chart\":20003,\"field\":\"t1.`month`\"},{\"chart\":20004,\"field\":\"t1.`month`\"},{\"chart\":20005,\"field\":\"t1.`month`\"},{\"chart\":20006,\"field\":\"t1.`month`\"},{\"chart\":20007,\"field\":\"t1.`month`\"},{\"chart\":20008,\"field\":\"t1.`month`\"},{\"chart\":20009,\"field\":\"t1.`month`\"},{\"chart\":20010,\"field\":\"t1.`month`\"},{\"chart\":20011,\"field\":\"t1.`month`\"},{\"chart\":20012,\"field\":\"t1.`month`\"},{\"chart\":20013,\"field\":\"t1.`month`\"}],\"isGroup\":false,\"attr\":{\"x\":100,\"y\":0,\"w\":100,\"h\":120,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Select\",\"chartConfig\":{\"key\":\"Select\",\"chartKey\":\"VSelect\",\"conKey\":\"VCSelect\",\"title\":\"\\u9009\\u62e9\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/select-c616737a.png\"},\"option\":{\"dataset\":[{\"label\":\"\\u8bf7\\u9009\\u62e9\",\"value\":\"\"},{\"label\":\"\\u6cb3\\u5317\",\"value\":\"18700\"},{\"label\":\"\\u5f90\\u5dde\",\"value\":\"17800\"}],\"value\":\"\",\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"background\":\"none\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"backgroundColor\":\"transparent\",\"fontSize\":20,\"onChange\":\"console.log(value)\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":150,\"w\":1300,\"h\":220,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":80,\"x\":0,\"y\":150,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":230,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u4f7f\\u7528\\u6570\\u636e\\u5206\\u6790\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":180,\"h\":159,\"x\":25,\"y\":220,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":390,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":20014,\"isGroup\":false,\"attr\":{\"x\":110,\"y\":20,\"w\":169,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":15,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":110,\"y\":50,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u5f53\\u524d\\u7248\\u672c\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":180,\"h\":159,\"x\":448,\"y\":220,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":390,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":20015,\"isGroup\":false,\"attr\":{\"x\":110,\"y\":20,\"w\":169,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":15,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":110,\"y\":50,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u4e0a\\u7ebf\\u65f6\\u95f4\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":180,\"h\":159,\"x\":870,\"y\":220,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":390,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1028,\"isGroup\":false,\"attr\":{\"x\":110,\"y\":20,\"w\":169,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":15,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":110,\"y\":50,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u540e\\u53f0\\u8d26\\u53f7\\u6570\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":375,\"w\":1300,\"h\":525,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":375,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":277,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u6d3b\\u8dc3\\u8d26\\u53f7\\u6570\\u9879\\u76ee\\u95f4\\u5bf9\\u6bd4\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"1zhfrmecpnxc00\",\"sourceID\":20002,\"isGroup\":false,\"attr\":{\"x\":25,\"y\":57,\"w\":1250,\"h\":446,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TableScrollBoard\",\"chartConfig\":{\"key\":\"TableScrollBoard\",\"chartKey\":\"VTableScrollBoard\",\"conKey\":\"VCTableScrollBoard\",\"title\":\"\\u8f6e\\u64ad\\u5217\\u8868\",\"category\":\"Tables\",\"categoryName\":\"\\u8868\\u683c\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/table_scrollboard-fb642e78.png\"},\"option\":{\"header\":[\"\\u52171\",\"\\u52172\",\"\\u52173\"],\"dataset\":[[\"\\u884c1\\u52171\",\"\\u884c1\\u52172\",\"\\u884c1\\u52173\"],[\"\\u884c2\\u52171\",\"\\u884c2\\u52172\",\"\\u884c2\\u52173\"],[\"\\u884c3\\u52171\",\"\\u884c3\\u52172\",\"\\u884c3\\u52173\"],[\"\\u884c4\\u52171\",\"\\u884c4\\u52172\",\"\\u884c4\\u52173\"],[\"\\u884c5\\u52171\",\"\\u884c5\\u52172\",\"\\u884c5\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"]],\"index\":false,\"columnWidth\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"rowNum\":8,\"waitTime\":3,\"headerHeight\":45,\"carousel\":\"single\",\"headerBGC\":\"#165896FF\",\"oddRowBGC\":\"#042b4dFF\",\"evenRowBGC\":\"#0a1c37FF\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":500,\"x\":0,\"y\":905,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u516c\\u53f8\\u8d26\\u53f7\\u65e5\\u6d3b\\u8dc3\\u5ea6\\u8d8b\\u52bf\\u7edf\\u8ba1\",\"image\":\"\"},\"groupList\":[{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":1300,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u516c\\u53f8\\u8d26\\u53f7\\u65e5\\u6d3b\\u8dc3\\u5ea6\\u8d8b\\u52bf\\u7edf\\u8ba1\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"obhxxjnin3400\",\"sourceID\":20003,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":60,\"w\":1250,\"h\":416,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"LineCommon\",\"chartConfig\":{\"key\":\"LineCommon\",\"chartKey\":\"VLineCommon\",\"conKey\":\"VCLineCommon\",\"title\":\"\\u6298\\u7ebf\\u56fe\",\"category\":\"Lines\",\"categoryName\":\"\\u6298\\u7ebf\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static\\/png\\/line.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"(\\u65e5\\u671f)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"(\\u4e2a\\u6570)\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"30\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"type\":\"line\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}},{\"type\":\"line\",\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"symbolSize\":5,\"itemStyle\":{\"color\":null,\"borderRadius\":0},\"lineStyle\":{\"type\":\"solid\",\"width\":3,\"color\":null}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}},{\"id\":\"2u3zlsz5kk4000\",\"isGroup\":false,\"attr\":{\"x\":17,\"y\":0,\"w\":250,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u516c\\u53f8\\u8d26\\u53f7\\u65e5\\u6d3b\\u8dc3\\u5ea6\\u8d8b\\u52bf\\u7edf\\u8ba1\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u516c\\u53f8\\u8d26\\u53f7\\u65e5\\u6d3b\\u8dc3\\u5ea6\\u8d8b\\u52bf\\u7edf\\u8ba1\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":1405,\"w\":1300,\"h\":400,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":80,\"x\":0,\"y\":1400,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":230,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u4ea7\\u54c1\\u6570\\u636e\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":180,\"h\":159,\"x\":25,\"y\":1470,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":390,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1020,\"isGroup\":false,\"attr\":{\"x\":100,\"y\":20,\"w\":169,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":15,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":100,\"y\":50,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u5f53\\u524d\\u4ea7\\u54c1\\u6570\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":180,\"h\":159,\"x\":448,\"y\":1470,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":390,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":20004,\"isGroup\":false,\"attr\":{\"x\":100,\"y\":20,\"w\":169,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":15,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":100,\"y\":50,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u6d3b\\u8dc3\\u4ea7\\u54c1\\u6570\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":180,\"h\":159,\"x\":870,\"y\":1470,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":390,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":20005,\"isGroup\":false,\"attr\":{\"x\":100,\"y\":20,\"w\":169,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":15,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":100,\"y\":50,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u672c\\u6708\\u65b0\\u589e\\u4ea7\\u54c1\\u6570\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":159,\"x\":25,\"y\":1630,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":1240,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":20006,\"isGroup\":false,\"attr\":{\"x\":110,\"y\":20,\"w\":1000,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":15,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":525,\"y\":50,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u672c\\u6708\\u65b0\\u589e\\u4ea7\\u54c1\\u540d\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":2855,\"w\":1300,\"h\":400,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":80,\"x\":0,\"y\":2855,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":230,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u9879\\u76ee\\u6570\\u636e\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":180,\"h\":159,\"x\":25,\"y\":2925,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":370,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1019,\"isGroup\":false,\"attr\":{\"x\":100,\"y\":20,\"w\":169,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":15,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":100,\"y\":50,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u5f53\\u524d\\u9879\\u76ee\\u6570\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":180,\"h\":159,\"x\":448,\"y\":2925,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":370,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":20007,\"isGroup\":false,\"attr\":{\"x\":100,\"y\":20,\"w\":169,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":15,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":100,\"y\":50,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u6d3b\\u8dc3\\u9879\\u76ee\\u6570\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":180,\"h\":159,\"x\":870,\"y\":2925,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":370,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":20008,\"isGroup\":false,\"attr\":{\"x\":100,\"y\":20,\"w\":169,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":15,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":100,\"y\":50,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u672c\\u6708\\u65b0\\u589e\\u9879\\u76ee\\u6570\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":159,\"x\":25,\"y\":3080,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":1215,\"h\":127,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":20009,\"isGroup\":false,\"attr\":{\"x\":100,\"y\":20,\"w\":1000,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":15,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":515,\"y\":50,\"w\":169,\"h\":78,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u672c\\u6708\\u65b0\\u589e\\u9879\\u76ee\\u540d\",\"fontSize\":15,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":1,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":3780,\"w\":1300,\"h\":525,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":3780,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":277,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9879\\u76ee\\u4efb\\u52a1\\u6982\\u51b5\\u8868\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"1zhfrmecpnxc00\",\"sourceID\":20010,\"isGroup\":false,\"attr\":{\"x\":25,\"y\":57,\"w\":1250,\"h\":446,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TableScrollBoard\",\"chartConfig\":{\"key\":\"TableScrollBoard\",\"chartKey\":\"VTableScrollBoard\",\"conKey\":\"VCTableScrollBoard\",\"title\":\"\\u8f6e\\u64ad\\u5217\\u8868\",\"category\":\"Tables\",\"categoryName\":\"\\u8868\\u683c\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/table_scrollboard-fb642e78.png\"},\"option\":{\"header\":[\"\\u52171\",\"\\u52172\",\"\\u52173\"],\"dataset\":[[\"\\u884c1\\u52171\",\"\\u884c1\\u52172\",\"\\u884c1\\u52173\"],[\"\\u884c2\\u52171\",\"\\u884c2\\u52172\",\"\\u884c2\\u52173\"],[\"\\u884c3\\u52171\",\"\\u884c3\\u52172\",\"\\u884c3\\u52173\"],[\"\\u884c4\\u52171\",\"\\u884c4\\u52172\",\"\\u884c4\\u52173\"],[\"\\u884c5\\u52171\",\"\\u884c5\\u52172\",\"\\u884c5\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"]],\"index\":false,\"columnWidth\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"rowNum\":8,\"waitTime\":3,\"headerHeight\":45,\"carousel\":\"single\",\"headerBGC\":\"#165896FF\",\"oddRowBGC\":\"#042b4dFF\",\"evenRowBGC\":\"#0a1c37FF\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":3255,\"w\":1300,\"h\":525,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":3255,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":277,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u9879\\u76ee\\u9700\\u6c42\\u6982\\u51b5\\u8868\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"1zhfrmecpnxc00\",\"sourceID\":20013,\"isGroup\":false,\"attr\":{\"x\":25,\"y\":57,\"w\":1250,\"h\":446,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TableScrollBoard\",\"chartConfig\":{\"key\":\"TableScrollBoard\",\"chartKey\":\"VTableScrollBoard\",\"conKey\":\"VCTableScrollBoard\",\"title\":\"\\u8f6e\\u64ad\\u5217\\u8868\",\"category\":\"Tables\",\"categoryName\":\"\\u8868\\u683c\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/table_scrollboard-fb642e78.png\"},\"option\":{\"header\":[\"\\u52171\",\"\\u52172\",\"\\u52173\"],\"dataset\":[[\"\\u884c1\\u52171\",\"\\u884c1\\u52172\",\"\\u884c1\\u52173\"],[\"\\u884c2\\u52171\",\"\\u884c2\\u52172\",\"\\u884c2\\u52173\"],[\"\\u884c3\\u52171\",\"\\u884c3\\u52172\",\"\\u884c3\\u52173\"],[\"\\u884c4\\u52171\",\"\\u884c4\\u52172\",\"\\u884c4\\u52173\"],[\"\\u884c5\\u52171\",\"\\u884c5\\u52172\",\"\\u884c5\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"]],\"index\":false,\"columnWidth\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"rowNum\":8,\"waitTime\":3,\"headerHeight\":45,\"carousel\":\"single\",\"headerBGC\":\"#165896FF\",\"oddRowBGC\":\"#042b4dFF\",\"evenRowBGC\":\"#0a1c37FF\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":2330,\"w\":1300,\"h\":525,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":2330,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":277,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4ea7\\u54c1\\u6d4b\\u8bd5\\u8868\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"1zhfrmecpnxc00\",\"sourceID\":20011,\"isGroup\":false,\"attr\":{\"x\":25,\"y\":57,\"w\":1250,\"h\":446,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TableScrollBoard\",\"chartConfig\":{\"key\":\"TableScrollBoard\",\"chartKey\":\"VTableScrollBoard\",\"conKey\":\"VCTableScrollBoard\",\"title\":\"\\u8f6e\\u64ad\\u5217\\u8868\",\"category\":\"Tables\",\"categoryName\":\"\\u8868\\u683c\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/table_scrollboard-fb642e78.png\"},\"option\":{\"header\":[\"\\u52171\",\"\\u52172\",\"\\u52173\"],\"dataset\":[[\"\\u884c1\\u52171\",\"\\u884c1\\u52172\",\"\\u884c1\\u52173\"],[\"\\u884c2\\u52171\",\"\\u884c2\\u52172\",\"\\u884c2\\u52173\"],[\"\\u884c3\\u52171\",\"\\u884c3\\u52172\",\"\\u884c3\\u52173\"],[\"\\u884c4\\u52171\",\"\\u884c4\\u52172\",\"\\u884c4\\u52173\"],[\"\\u884c5\\u52171\",\"\\u884c5\\u52172\",\"\\u884c5\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"]],\"index\":false,\"columnWidth\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"rowNum\":8,\"waitTime\":3,\"headerHeight\":45,\"carousel\":\"single\",\"headerBGC\":\"#165896FF\",\"oddRowBGC\":\"#042b4dFF\",\"evenRowBGC\":\"#0a1c37FF\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":1805,\"w\":1300,\"h\":525,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":1805,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":277,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static\\/png\\/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http:\\/\\/\",\"dataset\":\"\\u4ea7\\u54c1\\u9700\\u6c42\\u6982\\u51b5\\u8868\",\"fontSize\":14,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"1zhfrmecpnxc00\",\"sourceID\":20012,\"isGroup\":false,\"attr\":{\"x\":25,\"y\":57,\"w\":1250,\"h\":446,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TableScrollBoard\",\"chartConfig\":{\"key\":\"TableScrollBoard\",\"chartKey\":\"VTableScrollBoard\",\"conKey\":\"VCTableScrollBoard\",\"title\":\"\\u8f6e\\u64ad\\u5217\\u8868\",\"category\":\"Tables\",\"categoryName\":\"\\u8868\\u683c\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/table_scrollboard-fb642e78.png\"},\"option\":{\"header\":[\"\\u52171\",\"\\u52172\",\"\\u52173\"],\"dataset\":[[\"\\u884c1\\u52171\",\"\\u884c1\\u52172\",\"\\u884c1\\u52173\"],[\"\\u884c2\\u52171\",\"\\u884c2\\u52172\",\"\\u884c2\\u52173\"],[\"\\u884c3\\u52171\",\"\\u884c3\\u52172\",\"\\u884c3\\u52173\"],[\"\\u884c4\\u52171\",\"\\u884c4\\u52172\",\"\\u884c4\\u52173\"],[\"\\u884c5\\u52171\",\"\\u884c5\\u52172\",\"\\u884c5\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"]],\"index\":false,\"columnWidth\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"rowNum\":8,\"waitTime\":3,\"headerHeight\":45,\"carousel\":\"single\",\"headerBGC\":\"#165896FF\",\"oddRowBGC\":\"#042b4dFF\",\"evenRowBGC\":\"#0a1c37FF\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":1250,\"y\":173,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"\\u63d0\\u793a\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"\\u4e0a\\u7ebf\\u65f6\\u95f4\\uff1a\\u7ba1\\u7406\\u5458\\u9996\\u6b21\\u767b\\u5f55\\u7985\\u9053\\u7684\\u65f6\\u95f4\\u3002\\u000A\\u540e\\u53f0\\u8d26\\u53f7\\u6570\\uff1a\\u7cfb\\u7edf\\u6240\\u6709\\u8d26\\u53f7\\u4e2a\\u6570\\u6c42\\u548c\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u8d26\\u53f7\\u3002\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":1250,\"y\":395,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"\\u63d0\\u793a\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"\\u67d0\\u6708\\u56e2\\u961f\\u8d26\\u53f7\\u6570\\uff1a\\u56e2\\u961f\\u6240\\u6709\\u8d26\\u53f7\\u6570\\u6c42\\u548c\\uff0c\\u52a0\\u5165\\u65f6\\u95f4\\u003c\\u003d\\u67d0\\u6708\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u8d26\\u53f7\\u6570\\u3002\\u000A\\u67d0\\u6708\\u6d3b\\u8dc3\\u8d26\\u53f7\\u6570\\uff1a\\u56e2\\u961f\\u8d26\\u53f7\\u4e2d\\uff0c\\u5728\\u67d0\\u6708\\u6709\\u8fc7\\u767b\\u5f55\\u884c\\u4e3a\\u7684\\u8d26\\u53f7\\u6570\\u6c42\\u548c\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u8d26\\u53f7\\u3002\\u000A\\u67d0\\u6708\\u6d3b\\u8dc3\\u8d26\\u53f7\\u6bd4\\uff1a\\u67d0\\u6708\\u6d3b\\u8dc3\\u8d26\\u53f7\\u6bd4\\u003d\\u67d0\\u6708\\u6d3b\\u8dc3\\u8d26\\u53f7\\u6570\\u002f\\u67d0\\u6708\\u56e2\\u961f\\u8d26\\u53f7\\u6570\\u3002\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":1250,\"y\":925,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"\\u63d0\\u793a\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"\\u5728\\u67d0\\u6708\\uff0c\\u516c\\u53f8\\u6bcf\\u65e5\\u6709\\u767b\\u5f55\\u884c\\u4e3a\\u7684\\u8d26\\u53f7\\u6570\\u6c42\\u548c\\u3002\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":1250,\"y\":1419,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"\\u63d0\\u793a\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"\\u5f53\\u524d\\u4ea7\\u54c1\\u6570\\uff1a\\u7cfb\\u7edf\\u4e2d\\u6240\\u6709\\u4ea7\\u54c1\\u4e2a\\u6570\\u6c42\\u548c\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u4ea7\\u54c1\\u3002\\u000A\\u67d0\\u6708\\u6d3b\\u8dc3\\u4ea7\\u54c1\\u6570\\uff1a\\u7cfb\\u7edf\\u4e2d\\u67d0\\u6708\\u6709\\u8fc7\\u52a8\\u6001\\u7684\\u4ea7\\u54c1\\u4e2a\\u6570\\u6c42\\u548c\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u4ea7\\u54c1\\u3002\\u000A\\u67d0\\u6708\\u65b0\\u589e\\u4ea7\\u54c1\\u6570\\uff1a\\u7cfb\\u7edf\\u4e2d\\u67d0\\u6708\\u65b0\\u589e\\u7684\\u4ea7\\u54c1\\u4e2a\\u6570\\u6c42\\u548c\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u4ea7\\u54c1\\u3002\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":1250,\"y\":1820,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"\\u63d0\\u793a\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"\\u6309\\u4ea7\\u54c1\\u7edf\\u8ba1\\u7684\\u6708\\u5ea6\\u65b0\\u589e\\u7814\\u53d1\\u9700\\u6c42\\u6570\\uff1a\\u4ea7\\u54c1\\u4e2d\\u7814\\u53d1\\u9700\\u6c42\\u7684\\u4e2a\\u6570\\u6c42\\u548c\\uff0c\\u521b\\u5efa\\u65f6\\u95f4\\u4e3a\\u67d0\\u5e74\\u67d0\\u6708\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u7814\\u53d1\\u9700\\u6c42\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u4ea7\\u54c1\\u3002\\u000A\\u6309\\u4ea7\\u54c1\\u7edf\\u8ba1\\u7684\\u6708\\u5ea6\\u4ea4\\u4ed8\\u7814\\u53d1\\u9700\\u6c42\\u6570\\uff1a\\u4ea7\\u54c1\\u4e2d\\u7814\\u53d1\\u9700\\u6c42\\u4e2a\\u6570\\u6c42\\u548c\\uff0c\\u6240\\u5904\\u9636\\u6bb5\\u4e3a\\u5df2\\u53d1\\u5e03\\u4e14\\u53d1\\u5e03\\u65f6\\u95f4\\u4e3a\\u67d0\\u5e74\\u67d0\\u6708\\u6216\\u5173\\u95ed\\u539f\\u56e0\\u4e3a\\u5df2\\u5b8c\\u6210\\u4e14\\u5173\\u95ed\\u65f6\\u95f4\\u4e3a\\u67d0\\u5e74\\u67d0\\u6708\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u7814\\u53d1\\u9700\\u6c42\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u4ea7\\u54c1\\u3002\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":1250,\"y\":2356,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"\\u63d0\\u793a\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"\\u6309\\u4ea7\\u54c1\\u7edf\\u8ba1\\u7684\\u6708\\u5ea6\\u65b0\\u589e\\u7528\\u4f8b\\u6570\\uff1a\\u4ea7\\u54c1\\u4e2d\\u7528\\u4f8b\\u7684\\u4e2a\\u6570\\u6c42\\u548c\\uff0c\\u521b\\u5efa\\u65f6\\u95f4\\u4e3a\\u67d0\\u5e74\\u67d0\\u6708\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u7528\\u4f8b\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u4ea7\\u54c1\\u3002\\u000A\\u6309\\u4ea7\\u54c1\\u7edf\\u8ba1\\u7684\\u6708\\u5ea6\\u7528\\u4f8b\\u5e73\\u5747\\u0042\\u0075\\u0067\\u6570\\uff1a\\u6309\\u4ea7\\u54c1\\u7edf\\u8ba1\\u7684\\u6708\\u5ea6\\u65b0\\u589e\\u7528\\u4f8b\\u6570\\u5173\\u8054\\u7684\\u0042\\u0075\\u0067\\u6570\\u002f\\u6309\\u4ea7\\u54c1\\u7edf\\u8ba1\\u7684\\u6708\\u5ea6\\u65b0\\u589e\\u7528\\u4f8b\\u6570\\u3002\\u000A\\u6309\\u4ea7\\u54c1\\u7edf\\u8ba1\\u7684\\u6708\\u5ea6\\u65b0\\u589e\\u0042\\u0075\\u0067\\u6570\\uff1a\\u4ea7\\u54c1\\u4e2d\\u0042\\u0075\\u0067\\u4e2a\\u6570\\u6c42\\u548c\\uff0c\\u521b\\u5efa\\u65f6\\u95f4\\u4e3a\\u67d0\\u5e74\\u67d0\\u6708\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u0042\\u0075\\u0067\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u4ea7\\u54c1\\u3002\\u000A\\u6309\\u4ea7\\u54c1\\u7edf\\u8ba1\\u7684\\u6708\\u5ea6\\u4fee\\u590d\\u0042\\u0075\\u0067\\u6570\\uff1a\\u4ea7\\u54c1\\u4e2d\\u0042\\u0075\\u0067\\u4e2a\\u6570\\u6c42\\u548c\\uff0c\\u5173\\u95ed\\u65f6\\u95f4\\u4e3a\\u67d0\\u5e74\\u67d0\\u6708\\uff0c\\u89e3\\u51b3\\u65b9\\u6848\\u4e3a\\u5df2\\u89e3\\u51b3\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u0042\\u0075\\u0067\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u4ea7\\u54c1\\u3002\\u000A\\u6309\\u4ea7\\u54c1\\u7edf\\u8ba1\\u7684\\u0062\\u0075\\u0067\\u5e73\\u5747\\u4fee\\u590d\\u65f6\\u95f4\\uff1a\\u6309\\u4ea7\\u54c1\\u7edf\\u8ba1\\u7684\\u6708\\u5ea6\\u4fee\\u590d\\u0042\\u0075\\u0067\\u7684\\u4fee\\u590d\\u5468\\u671f\\u002f\\u6309\\u4ea7\\u54c1\\u7edf\\u8ba1\\u7684\\u6708\\u5ea6\\u4fee\\u590d\\u0042\\u0075\\u0067\\u6570\\u3002\\u000A\\u4fee\\u590d\\u5468\\u671f\\uff1a\\u4fee\\u590d\\u65e5\\u671f\\u002d\\u521b\\u5efa\\u65e5\\u671f\\u3002\\u000A\\u4fee\\u590d\\uff1a\\u5df2\\u5173\\u95ed\\uff0c\\u5173\\u95ed\\u539f\\u56e0\\u4e3a\\u5df2\\u89e3\\u51b3\\u3002\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":1250,\"y\":2872,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"\\u63d0\\u793a\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"\\u5f53\\u524d\\u9879\\u76ee\\u6570\\uff1a\\u7cfb\\u7edf\\u4e2d\\u6240\\u6709\\u9879\\u76ee\\u4e2a\\u6570\\u6c42\\u548c\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u9879\\u76ee\\u3002\\u000A\\u67d0\\u6708\\u6d3b\\u8dc3\\u9879\\u76ee\\u6570\\uff1a\\u9879\\u76ee\\u4e2d\\u67d0\\u6708\\u6709\\u8fc7\\u52a8\\u6001\\u7684\\u9879\\u76ee\\u4e2a\\u6570\\u6c42\\u548c\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u9879\\u76ee\\u3002\\u000A\\u67d0\\u6708\\u65b0\\u589e\\u9879\\u76ee\\u6570\\uff1a\\u9879\\u76ee\\u4e2d\\u67d0\\u6708\\u65b0\\u589e\\u7684\\u9879\\u76ee\\u4e2a\\u6570\\u6c42\\u548c\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u9879\\u76ee\\u3002\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":1250,\"y\":3278,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"\\u63d0\\u793a\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"\\u6309\\u9879\\u76ee\\u7edf\\u8ba1\\u7684\\u6708\\u5ea6\\u65b0\\u589e\\u7814\\u53d1\\u9700\\u6c42\\u6570\\uff1a\\u9879\\u76ee\\u4e2d\\u7814\\u53d1\\u9700\\u6c42\\u7684\\u4e2a\\u6570\\u6c42\\u548c\\uff0c\\u521b\\u5efa\\u65f6\\u95f4\\u4e3a\\u67d0\\u5e74\\u67d0\\u6708\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u7814\\u53d1\\u9700\\u6c42\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u4ea7\\u54c1\\u3002\\u000A\\u6309\\u9879\\u76ee\\u7edf\\u8ba1\\u7684\\u6708\\u5ea6\\u4ea4\\u4ed8\\u7814\\u53d1\\u9700\\u6c42\\u6570\\uff1a\\u9879\\u76ee\\u4e2d\\u7814\\u53d1\\u9700\\u6c42\\u4e2a\\u6570\\u6c42\\u548c\\uff0c\\u6240\\u5904\\u9636\\u6bb5\\u4e3a\\u5df2\\u53d1\\u5e03\\u4e14\\u53d1\\u5e03\\u65f6\\u95f4\\u4e3a\\u67d0\\u5e74\\u67d0\\u6708\\u6216\\u5173\\u95ed\\u539f\\u56e0\\u4e3a\\u5df2\\u5b8c\\u6210\\u4e14\\u5173\\u95ed\\u65f6\\u95f4\\u4e3a\\u67d0\\u5e74\\u67d0\\u6708\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u7814\\u53d1\\u9700\\u6c42\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u9879\\u76ee\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u4ea7\\u54c1\\u3002\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":1250,\"y\":3800,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"\\u63d0\\u793a\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static\\/png\\/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"\\u6309\\u9879\\u76ee\\u7edf\\u8ba1\\u7684\\u6708\\u5ea6\\u65b0\\u589e\\u4efb\\u52a1\\u6570\\uff1a\\u9879\\u76ee\\u4e2d\\u4efb\\u52a1\\u7684\\u4e2a\\u6570\\u6c42\\u548c\\uff0c\\u521b\\u5efa\\u65f6\\u95f4\\u4e3a\\u67d0\\u5e74\\u67d0\\u6708\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u4efb\\u52a1\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u9879\\u76ee\\u3002\\u000A\\u6309\\u9879\\u76ee\\u7edf\\u8ba1\\u7684\\u6708\\u5ea6\\u8d21\\u732e\\u4efb\\u52a1\\u4eba\\u6570\\uff1a\\u9879\\u76ee\\u4e2d\\u4efb\\u52a1\\u7684\\u521b\\u5efa\\u4eba\\u7684\\u4e2a\\u6570\\u6c42\\u548c\\uff0c\\u521b\\u5efa\\u65f6\\u95f4\\u4e3a\\u67d0\\u5e74\\u67d0\\u6708\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u4efb\\u52a1\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u9879\\u76ee\\uff0c\\u4eba\\u5458\\u53bb\\u91cd\\u3002\\u000A\\u6309\\u9879\\u76ee\\u7edf\\u8ba1\\u7684\\u6708\\u5ea6\\u5b8c\\u6210\\u4efb\\u52a1\\u6570\\uff1a\\u9879\\u76ee\\u4e2d\\u4efb\\u52a1\\u4e2a\\u6570\\u6c42\\u548c\\uff0c\\u5b8c\\u6210\\u65f6\\u95f4\\u4e3a\\u67d0\\u5e74\\u67d0\\u6708\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u4efb\\u52a1\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u6267\\u884c\\u7684\\u4efb\\u52a1\\uff0c\\u8fc7\\u6ee4\\u5df2\\u5220\\u9664\\u7684\\u9879\\u76ee\\u3002\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}}]', 'published', '1', 'admin', '2022-12-07 14:59:41', 'admin', '2022-12-07 14:59:41', '0');

-- DROP TABLE IF EXISTS `zt_market`;
CREATE TABLE IF NOT EXISTS `zt_market` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `industry` char(255) NOT NULL DEFAULT '',
  `scale` decimal(10, 2) NOT NULL DEFAULT '0',
  `maturity` char(255) NOT NULL DEFAULT '',
  `speed` varchar(255) NOT NULL DEFAULT '',
  `competition` char(255) NOT NULL DEFAULT '',
  `strategy` varchar(255) NOT NULL DEFAULT '',
  `ppm` varchar(20) NOT NULL DEFAULT '',
  `desc` mediumtext NULL,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_marketreport`;
CREATE TABLE IF NOT EXISTS `zt_marketreport` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `market` mediumint(8) NOT NULL DEFAULT 0,
  `research` mediumint(8) NOT NULL DEFAULT 0,
  `maturity` varchar(30) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `participants` char(255) NOT NULL DEFAULT '',
  `source` varchar(30) NOT NULL DEFAULT '',
  `desc` mediumtext NULL,
  `status` varchar(20)  NOT NULL DEFAULT '',
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime NULL,
  `publishedBy` varchar(30) NOT NULL DEFAULT '',
  `publishedDate` datetime NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

ALTER TABLE `zt_project` ADD COLUMN `market` mediumint(8) NOT NULL DEFAULT 0;
ALTER TABLE `zt_project` ADD COLUMN `closedReason` varchar(20) NOT NULL DEFAULT '';
