<?php

/**
 * `UNION` keyword builder.
 */

namespace PhpMyAdmin\SqlParser\Components;

use PhpMyAdmin\SqlParser\Component;

/**
 * `UNION` keyword builder.
 *
 * @category   Keywords
 *
 * @license    https://www.gnu.org/licenses/gpl-2.0.txt GPL-2.0+
 */
class UnionKeyword extends Component
{
    /**
     * @param array<UnionKeyword[]> $component the component to be built
     * @param array                 $options   parameters for building
     *
     * @return string
     */
    public static function build($component, $options = array())
    {
        $tmp = array();
        foreach ($component as $componentPart) {
            $tmp[] = $componentPart[0] . ' ' . $componentPart[1];
        }

        return implode(' ', $tmp);
    }
}
