ALTER TABLE `zt_review` MODIFY `doc` varchar(255) DEFAULT '';
ALTER TABLE `zt_review` MODIFY `docVersion` varchar(255) DEFAULT '';

CREATE INDEX `metricCode` ON zt_metriclib (metricCode) USING BTREE;
CREATE INDEX `metricID` ON zt_metriclib (metricID) USING BTREE;

ALTER TABLE `zt_feedback` ADD COLUMN `keywords` varchar(255) NOT NULL DEFAULT '';

-- Update createdBy to system in chart and pivot
UPDATE `zt_chart` SET `createdBy` = 'system' WHERE `builtin` = '1';
UPDATE `zt_pivot` SET `createdBy` = 'system' WHERE `id` >= 1000 and `id` <= 1027;

UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"topProgram\",\"name\":\"topProgram\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"storyDoneRate\",\"name\":\"storyDoneRate\",\"valOrAgg\":\"sum\"},{\"field\":\"bugSolvedRate\",\"name\":\"bugSolvedRate\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"topProgram\":{\"name\":\"topProgram\",\"object\":\"bug\",\"field\":\"topProgram\",\"type\":\"string\"},\"doneStory\":{\"name\":\"doneStory\",\"object\":\"bug\",\"field\":\"doneStory\",\"type\":\"number\"},\"allStory\":{\"name\":\"allStory\",\"object\":\"bug\",\"field\":\"allStory\",\"type\":\"number\"},\"storyDoneRate\":{\"name\":\"storyDoneRate\",\"object\":\"bug\",\"field\":\"storyDoneRate\",\"type\":\"number\"},\"solvedBug\":{\"name\":\"solvedBug\",\"object\":\"bug\",\"field\":\"solvedBug\",\"type\":\"number\"},\"allBug\":{\"name\":\"allBug\",\"object\":\"bug\",\"field\":\"allBug\",\"type\":\"number\"},\"bugSolvedRate\":{\"name\":\"bugSolvedRate\",\"object\":\"bug\",\"field\":\"bugSolvedRate\",\"type\":\"number\"}}', `filters` = '[]', `langs` = '{\"topProgram\":{\"zh-cn\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\",\"zh-tw\":\"\",\"en\":\"topProgram\",\"de\":\"\",\"fr\":\"\"},\"doneStory\":{\"zh-cn\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\",\"en\":\"doneStory\",\"de\":\"\",\"fr\":\"\"},\"allStory\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\",\"en\":\"allStory\",\"de\":\"\",\"fr\":\"\"},\"storyDoneRate\":{\"zh-cn\":\"\\u9700\\u6c42\\u5b8c\\u6210\\u7387\",\"zh-tw\":\"\",\"en\":\"storyDoneRate\",\"de\":\"\",\"fr\":\"\"},\"solvedBug\":{\"zh-cn\":\"\\u89e3\\u51b3bug\\u6570\",\"zh-tw\":\"\",\"en\":\"solvedBug\",\"de\":\"\",\"fr\":\"\"},\"allBug\":{\"zh-cn\":\"bug\\u6570\",\"zh-tw\":\"\",\"en\":\"allBug\",\"de\":\"\",\"fr\":\"\"},\"bugSolvedRate\":{\"zh-cn\":\"bug\\u4fee\\u590d\\u7387\",\"zh-tw\":\"\",\"en\":\"bugSolvedRate\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT\n    t1.name AS topProgram,\n    SUM(IFNULL(t3.doneStory,0)) as doneStory,\n    SUM(IFNULL(t4.allStory,0)) as allStory,\n    CONVERT(IF(SUM(IFNULL(t4.allStory,0)) <= 0, 0, SUM(IFNULL(t3.doneStory,0)) / SUM(IFNULL(t4.allStory,0))*100), decimal(10,2)) as storyDoneRate,                                                                                                                                         \n    SUM(IFNULL(t5.solvedBug,0)) as solvedBug,\n    SUM(IFNULL(t6.allBug,0)) as allBug,\n    CONVERT(IF(SUM(IFNULL(t6.allBug,0)) <= 0, 0, SUM(IFNULL(t5.solvedBug,0)) / SUM(IFNULL(t6.allBug,0))*100), decimal(10,2)) as bugSolvedRate\nFROM zt_project AS t1\nLEFT JOIN zt_product AS t2 ON t1.id = t2.program\nLEFT JOIN (SELECT COUNT(1) as doneStory, product FROM zt_story WHERE deleted = \'0\' AND closedReason = \'done\' AND status = \'closed\' GROUP BY product) AS t3 ON t2.id = t3.product\nLEFT JOIN (SELECT COUNT(1) as allStory, product FROM zt_story WHERE deleted = \'0\' AND ((closedReason = \'done\' AND status = \'closed\') OR status != \'closed\') GROUP BY product) AS t4 ON t2.id = t4.product\nLEFT JOIN (SELECT COUNT(1) as solvedBug, product FROM zt_bug WHERE deleted = \'0\' AND resolution = \'fixed\' AND status = \'closed\' GROUP BY product) AS t5 ON t2.id = t5.product\nLEFT JOIN (SELECT COUNT(1) as allBug, product FROM zt_bug WHERE deleted = \'0\' AND (resolution in (\'fixed\', \'postponed\') OR status = \'active\') GROUP BY product) AS t6 ON t2.id = t6.product\nWHERE t1.type = \'program\' AND t1.grade = 1 AND t1.deleted = \'0\'\nAND t2.deleted = \'0\'\nGROUP BY t1.name\nORDER BY t1.`order` DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1042;
UPDATE `zt_chart` SET `type` = 'pie', `settings` = '[{\"type\":\"pie\",\"group\":[{\"field\":\"status\",\"name\":\"\\u72b6\\u6001\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"\\u9879\\u76eeID\",\"valOrAgg\":\"count\"}]}]', `fields` = '{\"id\":{\"name\":\"\\u9879\\u76eeID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"status\":{\"name\":\"\\u72b6\\u6001\",\"object\":\"project\",\"field\":\"status\",\"type\":\"option\"}}', `filters` = '[]', `langs` = '{\"id\":{\"zh-cn\":\"\\u9879\\u76eeID\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"status\":{\"zh-cn\":\"\\u72b6\\u6001\",\"zh-tw\":\"\",\"en\":\"status\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT id, CASE `status` WHEN \'wait\' then \'未开始\' WHEN \'doing\' THEN \'进行中\' WHEN \'suspended\' THEN \'已挂起\' ELSE \'已关闭\' END status FROM zt_project  WHERE type = \'program\' AND grade = 1 AND deleted = \'0\'', `stage` = 'published', `builtin` = 0 WHERE `id` = 1043;
UPDATE `zt_chart` SET `type` = 'pie', `settings` = '[{\"type\":\"pie\",\"group\":[{\"field\":\"status\",\"name\":\"\\u72b6\\u6001\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"\\u9879\\u76eeID\",\"valOrAgg\":\"count\"}]}]', `fields` = '{\"id\":{\"name\":\"\\u9879\\u76eeID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"status\":{\"name\":\"\\u72b6\\u6001\",\"object\":\"project\",\"field\":\"status\",\"type\":\"option\"}}', `filters` = '[]', `langs` = '{\"id\":{\"zh-cn\":\"\\u9879\\u76eeID\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"status\":{\"zh-cn\":\"\\u72b6\\u6001\",\"zh-tw\":\"\",\"en\":\"status\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT id, CASE `status` WHEN \'wait\' then \'未开始\' WHEN \'doing\' THEN \'进行中\' WHEN \'suspended\' THEN \'已挂起\' ELSE \'已关闭\' END status FROM zt_project  WHERE type = \'project\' AND deleted = \'0\'', `stage` = 'published', `builtin` = 0 WHERE `id` = 1044;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"product\",\"name\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"closedRate\",\"name\":\"closedRate\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"product\":{\"name\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"object\":\"story\",\"field\":\"product\",\"type\":\"string\"},\"program\":{\"name\":\"program\",\"object\":\"story\",\"field\":\"program\",\"type\":\"string\"},\"productLine\":{\"name\":\"productLine\",\"object\":\"story\",\"field\":\"productLine\",\"type\":\"string\"},\"closedStory\":{\"name\":\"\\u9700\\u6c42\\uff1a%s \\u5df2\\u5173\\u95ed\\uff0c\\u5c06\\u4e0d\\u4f1a\\u88ab\\u5173\\u95ed\\u3002\",\"object\":\"story\",\"field\":\"closedStory\",\"type\":\"string\"},\"totalStory\":{\"name\":\"totalStory\",\"object\":\"story\",\"field\":\"totalStory\",\"type\":\"string\"},\"closedRate\":{\"name\":\"closedRate\",\"object\":\"story\",\"field\":\"closedRate\",\"type\":\"number\"}}', `filters` = '[]', `langs` = '{\"product\":{\"zh-cn\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"zh-tw\":\"\",\"en\":\"product\",\"de\":\"\",\"fr\":\"\"},\"program\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\",\"zh-tw\":\"\",\"en\":\"program\",\"de\":\"\",\"fr\":\"\"},\"productLine\":{\"zh-cn\":\"\\u4ea7\\u54c1\\u7ebf\",\"zh-tw\":\"\",\"en\":\"productLine\",\"de\":\"\",\"fr\":\"\"},\"closedStory\":{\"zh-cn\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\",\"en\":\"closedStory\",\"de\":\"\",\"fr\":\"\"},\"totalStory\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\",\"en\":\"totalStory\",\"de\":\"\",\"fr\":\"\"},\"closedRate\":{\"zh-cn\":\"\\u9700\\u6c42\\u5b8c\\u6210\\u7387\",\"zh-tw\":\"\",\"en\":\"closedRate\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT\n  t1.name AS product,\n  IFNULL(t2.name, \'/\') AS program, \n  IFNULL(t3.name, \'/\') AS productLine,   \n  IFNULL(t4.story, 0) AS closedStory, \n  t5.story AS totalStory, \n  ROUND(IFNULL(t4.story, 0) / t5.story * 100, 2) AS closedRate \nFROM zt_product AS t1 \nLEFT JOIN zt_project AS t2 ON t1.program = t2.id AND t2.type = \'program\' AND t2.grade = 1 \nLEFT JOIN zt_module AS t3 ON t1.line = t3.id AND t3.type = \'line\' \nLEFT JOIN (SELECT product, COUNT(1) AS story FROM zt_story WHERE deleted = \'0\' AND closedReason = \'done\' GROUP BY product) AS t4 ON t1.id = t4.product \nLEFT JOIN (SELECT product, COUNT(1) AS story FROM zt_story WHERE deleted = \'0\' AND ( closedReason = \'done\' OR status != \'closed\') GROUP BY product) AS t5 ON t1.id = t5.product \nWHERE t1.deleted = \'0\' AND t1.status != \'closed\' AND t1.shadow = \'0\' AND t1.vision = \'rnd\' AND t5.story IS NOT NULL \nORDER BY t1.order DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1046;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"product\",\"name\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"fixedRate\",\"name\":\"\\u4fee\\u590d\\u7387\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"product\":{\"name\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"object\":\"bug\",\"field\":\"product\",\"type\":\"string\"},\"program\":{\"name\":\"program\",\"object\":\"bug\",\"field\":\"program\",\"type\":\"string\"},\"productLine\":{\"name\":\"productLine\",\"object\":\"bug\",\"field\":\"productLine\",\"type\":\"string\"},\"fixedBug\":{\"name\":\"fixedBug\",\"object\":\"bug\",\"field\":\"fixedBug\",\"type\":\"string\"},\"totalBug\":{\"name\":\"totalBug\",\"object\":\"bug\",\"field\":\"totalBug\",\"type\":\"string\"},\"fixedRate\":{\"name\":\"\\u4fee\\u590d\\u7387\",\"object\":\"bug\",\"field\":\"fixedRate\",\"type\":\"number\"}}', `filters` = '[]', `langs` = '{\"product\":{\"zh-cn\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"zh-tw\":\"\",\"en\":\"product\",\"de\":\"\",\"fr\":\"\"},\"program\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\",\"zh-tw\":\"\",\"en\":\"program\",\"de\":\"\",\"fr\":\"\"},\"productLine\":{\"zh-cn\":\"\\u4ea7\\u54c1\\u7ebf\",\"zh-tw\":\"\",\"en\":\"productLine\",\"de\":\"\",\"fr\":\"\"},\"fixedBug\":{\"zh-cn\":\"\\u4fee\\u590dbug\\u6570\",\"zh-tw\":\"\",\"en\":\"fixedBug\",\"de\":\"\",\"fr\":\"\"},\"totalBug\":{\"zh-cn\":\"bug\\u6570\",\"zh-tw\":\"\",\"en\":\"totalBug\",\"de\":\"\",\"fr\":\"\"},\"fixedRate\":{\"zh-cn\":\"bug\\u4fee\\u590d\\u7387\",\"zh-tw\":\"\",\"en\":\"fixedRate\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  t1.name AS product,\n  IFNULL(t2.name, \'/\') AS program,\n  IFNULL(t3.name, \'/\') AS productLine,\n  IFNULL(t4.bug, 0) AS fixedBug,\n  t5.bug AS totalBug,\n  ROUND(IFNULL(t4.bug, 0) / t5.bug * 100, 2) AS fixedRate\nFROM zt_product AS t1\nLEFT JOIN zt_project AS t2 ON t1.program = t2.id AND t2.type = \'program\' AND t2.grade = 1\nLEFT JOIN zt_module AS t3 ON t1.line = t3.id AND t3.type = \'line\'\nLEFT JOIN (SELECT product, COUNT(1) AS bug FROM zt_bug WHERE deleted = \'0\' AND resolution = \'fixed\' AND status = \'closed\' GROUP BY product) AS t4 ON t1.id = t4.product\nLEFT JOIN (SELECT product, COUNT(1) AS bug FROM zt_bug WHERE deleted = \'0\' AND (resolution = \'fixed\' OR resolution = \'postponed\' OR status = \'active\') GROUP BY product) AS t5 ON t1.id = t5.product\nWHERE t1.deleted = \'0\' AND t1.status != \'closed\' AND t1.shadow = \'0\' AND t1.vision = \'rnd\'  AND t5.bug IS NOT NULL\nORDER BY t1.order DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1047;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"deptName\",\"name\":\"deptName\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"count\",\"name\":\"count\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"deptName\":{\"name\":\"deptName\",\"object\":\"false\",\"field\":\"deptName\",\"type\":\"object\"},\"count\":{\"name\":\"count\",\"object\":\"false\",\"field\":\"count\",\"type\":\"object\"},\"deptOrder\":{\"name\":\"deptOrder\",\"object\":\"false\",\"field\":\"deptOrder\",\"type\":\"object\"}}', `filters` = '[]', `langs` = '{\"deptName\":{\"zh-cn\":\"\\u90e8\\u95e8\",\"zh-tw\":\"\",\"en\":\"deptName\",\"de\":\"\",\"fr\":\"\"},\"count\":{\"zh-cn\":\"\\u4eba\\u6570\",\"zh-tw\":\"\",\"en\":\"count\",\"de\":\"\",\"fr\":\"\"},\"deptOrder\":{\"zh-cn\":\"\\u987a\\u5e8f\",\"zh-tw\":\"\",\"en\":\"deptOrder\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT IF(t3.id IS NOT NULL, t3.`name`, \"空\") AS deptName,count(1) as count, \nIF(t3.id IS NOT NULL, t3.`order`, 9999) AS deptOrder \nFROM zt_user AS t1 \nLEFT JOIN zt_dept AS t2 ON t1.dept = t2.id\nLEFT JOIN zt_dept AS t3 ON FIND_IN_SET(TRIM(\',\' FROM t3.path), TRIM(\',\' FROM t2.path)) AND t3.grade = \'1\'\nWHERE t1.deleted = \'0\'\nGROUP BY deptName, deptOrder \nORDER BY deptOrder  ASC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1049;
UPDATE `zt_chart` SET `type` = 'pie', `settings` = '[{\"type\":\"pie\",\"group\":[{\"field\":\"role\",\"name\":\"\\u804c\\u4f4d\",\"group\":\"\"}],\"metric\":[{\"field\":\"account\",\"name\":\"\\u7528\\u6237\\u540d\",\"valOrAgg\":\"count\"}]}]', `fields` = '{\"account\":{\"name\":\"\\u7528\\u6237\\u540d\",\"object\":\"user\",\"field\":\"account\",\"type\":\"string\"},\"role\":{\"name\":\"\\u804c\\u4f4d\",\"object\":\"user\",\"field\":\"role\",\"type\":\"string\"}}', `filters` = '[]', `langs` = '{\"account\":{\"zh-cn\":\"\\u7528\\u6237\\u540d\",\"zh-tw\":\"\",\"en\":\"account\",\"de\":\"\",\"fr\":\"\"},\"role\":{\"zh-cn\":\"\\u804c\\u4f4d\",\"zh-tw\":\"\",\"en\":\"role\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT\n	account,\nCASE\n		ROLE \n		WHEN \'dev\' THEN\n		\"研发\" \n		WHEN \'qa\' THEN\n		\"测试\" \n		WHEN \'pm\' THEN\n		\"项目经理\" \n		WHEN \'others\' THEN\n		\"其他\" \n		WHEN \'td\' THEN\n		\"研发主管\" \n		WHEN \'pd\' THEN\n		\"产品主管\" \n		WHEN \'po\' THEN\n		\"产品经理\" \n		WHEN \'qd\' THEN\n		\"测试主管\" \n		WHEN \'top\' THEN\n		\"高层管理\" ELSE \"未知\" \n	END role \nFROM\n	zt_user \nWHERE\n	deleted = \'0\'', `stage` = 'published', `builtin` = 0 WHERE `id` = 1050;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"joinDate\",\"name\":\"joinDate\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"count\",\"name\":\"count\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"count\":{\"name\":\"count\",\"object\":\"user\",\"field\":\"count\",\"type\":\"string\"},\"joinDate\":{\"name\":\"joinDate\",\"object\":\"user\",\"field\":\"joinDate\",\"type\":\"string\"}}', `filters` = '[]', `langs` = '{\"count\":{\"zh-cn\":\"\\u4eba\\u6570\",\"zh-tw\":\"\",\"en\":\"count\",\"de\":\"\",\"fr\":\"\"},\"joinDate\":{\"zh-cn\":\"\\u5de5\\u9f84\",\"zh-tw\":\"\",\"en\":\"joinDate\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT count(1) as count, \"0-1年\" as joinDate FROM zt_user WHERE deleted = \'0\' AND `join` > DATE_SUB(NOW(), INTERVAL 1 YEAR)\nunion\nSELECT count(1) as count, \"1-3年\" as joinDate FROM zt_user WHERE deleted = \'0\' AND `join` > DATE_SUB(NOW(), INTERVAL 3 YEAR) AND `join` <= DATE_SUB(NOW(), INTERVAL 1 YEAR)\nunion\nSELECT count(1) as count, \"3-5年\" as joinDate FROM zt_user WHERE deleted = \'0\' AND `join` > DATE_SUB(NOW(), INTERVAL 5 YEAR) AND `join` <= DATE_SUB(NOW(), INTERVAL 3 YEAR)\nunion\nSELECT count(1) as count, \"5-10年\" as joinDate FROM zt_user WHERE deleted = \'0\' AND `join` > DATE_SUB(NOW(), INTERVAL 10 YEAR) AND `join` <= DATE_SUB(NOW(), INTERVAL 5 YEAR)\nunion\nSELECT count(1) as count, \"10年以上\" as joinDate FROM zt_user WHERE deleted = \'0\' AND `join` < DATE_SUB(NOW(), INTERVAL 10 YEAR) AND LEFT(`join`, 4) != \'0000\'\nunion                                                                                                                                                                                                                                                          \nSELECT count(1) as count, \"未知\" as joinDate FROM zt_user WHERE deleted = \'0\' AND LEFT(`join`, 4) = \'0000\'', `stage` = 'published', `builtin` = 0 WHERE `id` = 1051;

-- 年度进行中项目过程大屏
UPDATE `zt_chart` SET `type` = 'pie', `settings` = '[{\"type\":\"pie\",\"group\":[{\"field\":\"status\",\"name\":\"\\u72b6\\u6001\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"id\",\"valOrAgg\":\"count\"}]}]', `fields` = '{\"id\":{\"name\":\"id\",\"object\":\"zt_project\",\"field\":\"id\",\"type\":\"number\"},\"name\":{\"name\":\"name\",\"object\":\"zt_project\",\"field\":\"name\",\"type\":\"string\"},\"status\":{\"name\":\"\\u72b6\\u6001\",\"object\":\"project\",\"field\":\"status\",\"type\":\"option\"},\"prograss\":{\"name\":\"prograss\",\"object\":\"task\",\"field\":\"prograss\",\"type\":\"number\"},\"planPrograss\":{\"name\":\"planPrograss\",\"object\":\"task\",\"field\":\"planPrograss\",\"type\":\"number\"},\"endYear\":{\"name\":\"endYear\",\"object\":\"task\",\"field\":\"endYear\",\"type\":\"string\"}}', `langs` = '{\"id\":{\"zh-cn\":\"\\u9879\\u76eeID\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"name\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"name\",\"de\":\"\",\"fr\":\"\"},\"status\":{\"zh-cn\":\"\\u72b6\\u6001\",\"zh-tw\":\"\",\"en\":\"status\",\"de\":\"\",\"fr\":\"\"},\"prograss\":{\"zh-cn\":\"\\u9879\\u76ee\\u8fdb\\u5ea6\",\"zh-tw\":\"\",\"en\":\"prograss\",\"de\":\"\",\"fr\":\"\"},\"planPrograss\":{\"zh-cn\":\"\\u8ba1\\u5212\\u8fdb\\u5ea6\",\"zh-tw\":\"\",\"en\":\"planPrograss\",\"de\":\"\",\"fr\":\"\"},\"endYear\":{\"zh-cn\":\"\\u7ed3\\u675f\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"endYear\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT t1.id, t1.name, \nIF(\n    DATEDIFF(t1.`end`, NOW()) < 0, \n    \"延期\", \n    (IF(\n        (IFNULL(prograss, 0) >= (DATEDIFF(NOW(), t1.`begin`) / DATEDIFF(t1.`end`, t1.`begin`) * 100) AND LEFT(t1.`end`, 4) != \'2059\') \n        OR LEFT(t1.`end`, 4) = \'2059\' ,\n        \"顺利\",\n        \"滞后\"\n    ))) AS \'status\',\nIFNULL(prograss, 0) AS prograss, ROUND(DATEDIFF(NOW(), t1.`begin`) / DATEDIFF(t1.`end`, t1.`begin`) * 100, 2)  AS planPrograss,LEFT(t1.`end`, 4) AS endYear\nFROM zt_project AS t1\nLEFT JOIN (\n    SELECT t22.project,\n    ROUND(IF(SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0)) > 0, SUM(t22.consumed) / (SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0))), 0) * 100, 2) AS prograss\n    FROM zt_project AS t21\n    LEFT JOIN zt_task AS t22 ON t21.id = t22.execution\n    WHERE t21.deleted = \'0\' AND t21.type IN (\'sprint\', \'kanban\')\n    AND t22.deleted = \'0\' AND t22.parent < 1\n    GROUP BY t22.project\n    UNION\n    SELECT  t.project, ROUND(SUM(t.prograss * (t.percent / 100)), 2) as prograss\n    FROM (\n        SELECT t21.id,t21.percent, t22.project,\n        IF(SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0)) > 0, ROUND(SUM(t22.consumed) / (SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0))) * 1000 / 1000 * 100, 2), 0)  AS prograss\n        FROM zt_project AS t21\n        LEFT JOIN zt_task AS t22 ON t21.id = t22.execution\n        WHERE t21.deleted = \'0\' AND t21.type = \'stage\'\n        AND t22.deleted = \'0\' AND t22.parent < 1\n        AND t22.id IS NOT NULL\n        GROUP BY t21.id, t21.percent, t22.project\n    ) t\n    GROUP BY t.project\n) AS t2 ON t1.id = t2.project \nWHERE t1.deleted = \'0\'\nAND t1.status = \'doing\' \nAND t1.type = \'project\'', `stage` = 'published', `builtin` = 0 WHERE `id` = 10114;
UPDATE `zt_chart` SET `type` = 'pie', `settings` = '[{\"type\":\"pie\",\"group\":[{\"field\":\"status\",\"name\":\"\\u72b6\\u6001\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"\\u9879\\u76eeID\",\"valOrAgg\":\"count\"}]}]', `fields` = '{\"id\":{\"name\":\"\\u9879\\u76eeID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"name\":{\"name\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"object\":\"project\",\"field\":\"name\",\"type\":\"string\"},\"status\":{\"name\":\"\\u72b6\\u6001\",\"object\":\"project\",\"field\":\"status\",\"type\":\"option\"},\"prograss\":{\"name\":\"prograss\",\"object\":\"task\",\"field\":\"prograss\",\"type\":\"number\"},\"planPrograss\":{\"name\":\"planPrograss\",\"object\":\"task\",\"field\":\"planPrograss\",\"type\":\"number\"},\"end\":{\"name\":\"\\u8ba1\\u5212\\u5b8c\\u6210\",\"object\":\"project\",\"field\":\"end\",\"type\":\"date\"}}', `langs` = '{\"id\":{\"zh-cn\":\"\\u9879\\u76eeID\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"name\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"name\",\"de\":\"\",\"fr\":\"\"},\"status\":{\"zh-cn\":\"\\u72b6\\u6001\",\"zh-tw\":\"\",\"en\":\"status\",\"de\":\"\",\"fr\":\"\"},\"prograss\":{\"zh-cn\":\"\\u9879\\u76ee\\u8fdb\\u5ea6\",\"zh-tw\":\"\",\"en\":\"prograss\",\"de\":\"\",\"fr\":\"\"},\"planPrograss\":{\"zh-cn\":\"\\u8ba1\\u5212\\u8fdb\\u5ea6\",\"zh-tw\":\"\",\"en\":\"planPrograss\",\"de\":\"\",\"fr\":\"\"},\"end\":{\"zh-cn\":\"\\u8ba1\\u5212\\u5b8c\\u6210\",\"zh-tw\":\"\",\"en\":\"end\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT id, name,IF(\n    DATEDIFF(`end`, NOW()) < 0,\n    \"延期\",\n    (IF(\n        prograss >= planPrograss,\n        \"顺利\",\n        \"滞后\"\n    ))\n) AS status,\nprograss, planPrograss, `end`\nFROM (\nSELECT t1.id,t1.name,ROUND(DATEDIFF(NOW(), t1.`begin`) / DATEDIFF(t1.`end`, t1.`begin`) * 100, 2) AS planPrograss,t1.`end`,\nROUND(IF(SUM(t2.consumed) + SUM(IF(t2.status != \'closed\' && t2.status != \'cancel\', t2.`left`, 0)) > 0, SUM(t2.consumed) / (SUM(t2.consumed) + SUM(IF(t2.status != \'closed\' && t2.status != \'cancel\', t2.`left`, 0))), 0) * 100, 2) AS prograss\nFROM zt_project AS t1\nLEFT JOIN zt_task AS t2 ON t1.id = t2.execution\nWHERE t1.deleted = \'0\' AND t1.type IN (\'sprint\', \'stage\', \'kanban\') AND t1.status = \'doing\' AND t1.multiple = \'1\'\nAND ((t2.deleted = \'0\' AND t2.parent < 1) OR t2.id IS NULL)\nGROUP BY t1.id\n) AS t', `stage` = 'published', `builtin` = 0 WHERE `id` = 10115;

-- 年度汇总数据大屏
UPDATE `zt_chart` SET `type` = 'line', `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"month\",\"name\":\"month\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"newStory\",\"name\":\"\\u7ee7\\u7eed\\u6dfb\\u52a0\\u7814\\u53d1\\u9700\\u6c42\",\"valOrAgg\":\"sum\"},{\"field\":\"closedStory\",\"name\":\"\\u9700\\u6c42\\uff1a%s \\u5df2\\u5173\\u95ed\\uff0c\\u5c06\\u4e0d\\u4f1a\\u88ab\\u5173\\u95ed\\u3002\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"story\",\"field\":\"month\",\"type\":\"string\"},\"newStory\":{\"name\":\"\\u7ee7\\u7eed\\u6dfb\\u52a0\\u7814\\u53d1\\u9700\\u6c42\",\"object\":\"story\",\"field\":\"newStory\",\"type\":\"string\"},\"closedStory\":{\"name\":\"\\u9700\\u6c42\\uff1a%s \\u5df2\\u5173\\u95ed\\uff0c\\u5c06\\u4e0d\\u4f1a\\u88ab\\u5173\\u95ed\\u3002\",\"object\":\"story\",\"field\":\"closedStory\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u5ea6\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u5ea6\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u5ea6\",\"zh-tw\":\"\",\"en\":\"month\",\"de\":\"\",\"fr\":\"\"},\"newStory\":{\"zh-cn\":\"\\u65b0\\u589e\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\",\"en\":\"newStory\",\"de\":\"\",\"fr\":\"\"},\"closedStory\":{\"zh-cn\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\",\"en\":\"closedStory\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT t1.year, CONCAT(t1.month, \"月\") AS `month`, IFNULL(t2.story, 0) AS newStory, IFNULL(t3.story, 0) AS closedStory\nFROM (SELECT DISTINCT Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS story FROM zt_story WHERE deleted = \'0\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS story FROM zt_story WHERE deleted = \'0\' AND closedReason = \'done\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\nORDER BY `year`, t1.month', `stage` = 'published', `builtin` = 0 WHERE `id` = 1077;
UPDATE `zt_chart` SET `type` = 'line', `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"month\",\"name\":\"month\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"newBug\",\"name\":\"newBug\",\"valOrAgg\":\"sum\"},{\"field\":\"fixedBug\",\"name\":\"fixedBug\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"bug\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"bug\",\"field\":\"month\",\"type\":\"string\"},\"newBug\":{\"name\":\"newBug\",\"object\":\"bug\",\"field\":\"newBug\",\"type\":\"string\"},\"fixedBug\":{\"name\":\"fixedBug\",\"object\":\"bug\",\"field\":\"fixedBug\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u5ea6\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u5ea6\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u4efd\",\"zh-tw\":\"\",\"en\":\"month\",\"de\":\"\",\"fr\":\"\"},\"newBug\":{\"zh-cn\":\"\\u65b0\\u589eBug\\u6570\",\"zh-tw\":\"\",\"en\":\"newBug\",\"de\":\"\",\"fr\":\"\"},\"fixedBug\":{\"zh-cn\":\"\\u89e3\\u51b3Bug\\u6570\",\"zh-tw\":\"\",\"en\":\"fixedBug\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT t1.year, CONCAT(t1.month, \"月\") AS `month`, IFNULL(t2.bug, 0) AS newBug, IFNULL(t3.bug, 0) AS fixedBug\nFROM (SELECT DISTINCT Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS bug FROM zt_bug WHERE deleted = \'0\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS bug FROM zt_bug WHERE deleted = \'0\' AND resolution = \'fixed\' AND status = \'closed\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\nORDER BY `year`, t1.month', `stage` = 'published', `builtin` = 0 WHERE `id` = 1078;
UPDATE `zt_chart` SET `type` = 'line', `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"month\",\"name\":\"month\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"newTask\",\"name\":\"newTask\",\"valOrAgg\":\"sum\"},{\"field\":\"closedTask\",\"name\":\"closedTask\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"task\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"task\",\"field\":\"month\",\"type\":\"string\"},\"newTask\":{\"name\":\"newTask\",\"object\":\"task\",\"field\":\"newTask\",\"type\":\"string\"},\"closedTask\":{\"name\":\"closedTask\",\"object\":\"task\",\"field\":\"closedTask\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u4efd\",\"zh-tw\":\"\",\"en\":\"month\",\"de\":\"\",\"fr\":\"\"},\"newTask\":{\"zh-cn\":\"\\u65b0\\u589e\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\",\"en\":\"newTask\",\"de\":\"\",\"fr\":\"\"},\"closedTask\":{\"zh-cn\":\"\\u5b8c\\u6210\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\",\"en\":\"closedTask\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT t1.year, CONCAT(t1.month, \"月\") AS `month`, IFNULL(t2.task, 0) AS newTask, IFNULL(t3.task, 0) AS closedTask\nFROM (SELECT DISTINCT Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS task FROM zt_task WHERE deleted = \'0\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS task FROM zt_task WHERE deleted = \'0\' AND status = \'closed\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\nORDER BY `year`, t1.month', `stage` = 'published', `builtin` = 0 WHERE `id` = 1079;
UPDATE `zt_chart` SET `type` = 'line', `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"month\",\"name\":\"month\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"newProject\",\"name\":\"newProject\",\"valOrAgg\":\"sum\"},{\"field\":\"closedProject\",\"name\":\"\\u5df2\\u5173\\u95ed\\u7684\\u9879\\u76ee\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"project\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"project\",\"field\":\"month\",\"type\":\"string\"},\"newProject\":{\"name\":\"newProject\",\"object\":\"project\",\"field\":\"newProject\",\"type\":\"string\"},\"closedProject\":{\"name\":\"\\u5df2\\u5173\\u95ed\\u7684\\u9879\\u76ee\",\"object\":\"project\",\"field\":\"closedProject\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u4efd\",\"zh-tw\":\"\",\"en\":\"month\",\"de\":\"\",\"fr\":\"\"},\"newProject\":{\"zh-cn\":\"\\u65b0\\u589e\\u9879\\u76ee\\u6570\",\"zh-tw\":\"\",\"en\":\"newProject\",\"de\":\"\",\"fr\":\"\"},\"closedProject\":{\"zh-cn\":\"\\u5b8c\\u6210\\u9879\\u76ee\\u6570\",\"zh-tw\":\"\",\"en\":\"closedProject\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT t1.year, CONCAT(t1.month, \"月\") AS `month`, IFNULL(t2.project, 0) AS newProject, IFNULL(t3.project, 0) AS closedProject\nFROM (SELECT DISTINCT Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS project FROM zt_project WHERE deleted = \'0\' AND type = \'project\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS project FROM zt_project WHERE deleted = \'0\' AND type = \'project\' AND status = \'closed\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\nORDER BY `year`, t1.month', `stage` = 'published', `builtin` = 0 WHERE `id` = 1080;
UPDATE `zt_chart` SET `type` = 'line', `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"month\",\"name\":\"month\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"newExecution\",\"name\":\"newExecution\",\"valOrAgg\":\"sum\"},{\"field\":\"closedExecution\",\"name\":\"closedExecution\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"project\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"project\",\"field\":\"month\",\"type\":\"string\"},\"newExecution\":{\"name\":\"newExecution\",\"object\":\"project\",\"field\":\"newExecution\",\"type\":\"string\"},\"closedExecution\":{\"name\":\"closedExecution\",\"object\":\"project\",\"field\":\"closedExecution\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u4efd\",\"zh-tw\":\"\",\"en\":\"month\",\"de\":\"\",\"fr\":\"\"},\"newExecution\":{\"zh-cn\":\"\\u65b0\\u589e\\u6267\\u884c\\u6570\",\"zh-tw\":\"\",\"en\":\"newExecution\",\"de\":\"\",\"fr\":\"\"},\"closedExecution\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6267\\u884c\\u6570\",\"zh-tw\":\"\",\"en\":\"closedExecution\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT t1.year, CONCAT(t1.month, \"月\") AS `month`, IFNULL(t2.execution, 0) AS newExecution, IFNULL(t3.execution, 0) AS closedExecution\nFROM (SELECT DISTINCT YEAR(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS execution FROM zt_project WHERE deleted = \'0\' AND type IN (\'sprint\', \'stage\', \'kanban\') AND multiple = \'1\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS execution FROM zt_project WHERE deleted = \'0\' AND type IN (\'sprint\', \'stage\', \'kanban\') AND status = \'closed\' AND multiple = \'1\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\nORDER BY `year`, t1.month', `stage` = 'published', `builtin` = 0 WHERE `id` = 1081;
UPDATE `zt_chart` SET `type` = 'line', `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"month\",\"name\":\"month\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"release\",\"name\":\"release\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"release\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"release\",\"field\":\"month\",\"type\":\"string\"},\"release\":{\"name\":\"release\",\"object\":\"release\",\"field\":\"release\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u4efd\",\"zh-tw\":\"\",\"en\":\"month\",\"de\":\"\",\"fr\":\"\"},\"release\":{\"zh-cn\":\"\\u53d1\\u5e03\\u6b21\\u6570\",\"zh-tw\":\"\",\"en\":\"release\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT t1.year, CONCAT(t1.month, \"月\") AS `month`, IFNULL(t2.release, 0) AS `release`\nFROM (SELECT DISTINCT Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(createdDate) AS `year`, MONTH(createdDate) AS `month`, COUNT(1) AS `release` FROM zt_release WHERE deleted = \'0\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nORDER BY `year`, t1.month', `stage` = 'published', `builtin` = 0 WHERE `id` = 1082;

-- 年度完成项目过程数据大屏
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"name\",\"name\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"daterate\",\"name\":\"daterate\",\"valOrAgg\":\"max\"}]}]', `fields` = '{\"name\":{\"name\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"object\":\"project\",\"field\":\"name\",\"type\":\"string\"},\"closedDate\":{\"name\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"closedDate\",\"type\":\"date\"},\"daterate\":{\"name\":\"daterate\",\"object\":\"project\",\"field\":\"daterate\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"closedDate\",\"type\":\"date\",\"name\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]', `langs` = '{\"name\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"name\",\"de\":\"\",\"fr\":\"\"},\"closedDate\":{\"zh-cn\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"closedDate\",\"de\":\"\",\"fr\":\"\"},\"daterate\":{\"zh-cn\":\"\\u5de5\\u671f\\u504f\\u5dee\\u7387\",\"zh-tw\":\"\",\"en\":\"daterate\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select\nt1.name,\nt1.closedDate,\nround(t1.realduration-t1.planduration)/t1.planduration as daterate\nfrom(\nselect\nname,\nid,\nclosedDate,\nbegin,\nend,\ndatediff(`end`,`begin`) planduration,\nrealBegan,\nrealEnd,\nifnull(if(left(realEnd,4) != \'0000\',datediff(`realEnd`,`realBegan`),datediff(`closedDate`,`realBegan`)),0) realduration\nfrom\nzt_project\nwhere deleted=\'0\'\nand status=\'closed\'\nand type=\'project\'\n) t1', `stage` = 'published', `builtin` = 0 WHERE `id` = 10018;
UPDATE `zt_chart` SET `type` = 'pie', `settings` = '[{\"type\":\"pie\",\"group\":[{\"field\":\"completeStatus\",\"name\":\"completeStatus\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"\\u9879\\u76eeID\",\"valOrAgg\":\"count\"}]}]', `fields` = '{\"id\":{\"name\":\"\\u9879\\u76eeID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"completeStatus\":{\"name\":\"completeStatus\",\"object\":\"project\",\"field\":\"completeStatus\",\"type\":\"string\"},\"closedDate\":{\"name\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"closedDate\",\"type\":\"date\"}}', `filters` = '[{\"field\":\"closedDate\",\"type\":\"date\",\"name\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]', `langs` = '{\"id\":{\"zh-cn\":\"\\u9879\\u76eeID\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"completeStatus\":{\"zh-cn\":\"\\u9879\\u76ee\\u5b8c\\u6210\\u60c5\\u51b5\",\"zh-tw\":\"\",\"en\":\"completeStatus\",\"de\":\"\",\"fr\":\"\"},\"closedDate\":{\"zh-cn\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"closedDate\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select\nt1.id,\n(case when t1.realEnd<t1.end then \"提前完成项目\" when t1.realEnd=t1.end then \"正常完成项目\" else \"延期完成项目\" end) \"completeStatus\",\nt1.closedDate\nfrom(\nselect\nid,\nclosedDate,\nend,\nif(left(realEnd, 4) = \'0000\', closedDate, realEnd) as realEnd\nfrom\nzt_project\nwhere deleted=\'0\'\nand status=\'closed\'\nand type=\'project\') t1', `stage` = 'published', `builtin` = 0 WHERE `id` = 10020;
UPDATE `zt_chart` SET `type` = 'pie', `settings` = '[{\"type\":\"pie\",\"group\":[{\"field\":\"completeStatus\",\"name\":\"completeStatus\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"\\u9879\\u76eeID\",\"valOrAgg\":\"count\"}]}]', `fields` = '{\"id\":{\"name\":\"\\u9879\\u76eeID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"completeStatus\":{\"name\":\"completeStatus\",\"object\":\"project\",\"field\":\"completeStatus\",\"type\":\"string\"},\"closedDate\":{\"name\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"closedDate\",\"type\":\"date\"}}', `filters` = '[{\"field\":\"closedDate\",\"type\":\"date\",\"name\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]', `langs` = '{\"id\":{\"zh-cn\":\"\\u6267\\u884cID\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"completeStatus\":{\"zh-cn\":\"\\u5b8c\\u6210\\u60c5\\u51b5\",\"zh-tw\":\"\",\"en\":\"completeStatus\",\"de\":\"\",\"fr\":\"\"},\"closedDate\":{\"zh-cn\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select\nt1.id,\n(case when t1.realEnd<t1.end then \"提前完成执行\" when t1.realEnd=t1.end then \"正常完成执行\" else \"延期完成执行\" end) \"completeStatus\",\nt1.closedDate\nfrom(\nselect\nid,\nclosedDate,\nend,\nif(left(realEnd, 4) = \'0000\', closedDate, realEnd) as realEnd\nfrom\nzt_project\nwhere deleted=\'0\'\nand status=\'closed\'\nand type=\'sprint\') t1', `stage` = 'published', `builtin` = 0 WHERE `id` = 10021;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"name\",\"name\":\"\\u4efb\\u52a1\\u540d\\u79f0\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"rate\",\"name\":\"rate\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"name\":{\"name\":\"\\u4efb\\u52a1\\u540d\\u79f0\",\"object\":\"project\",\"field\":\"name\",\"type\":\"string\"},\"id\":{\"name\":\"\\u7f16\\u53f7\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"closedDate\":{\"name\":\"\\u5173\\u95ed\\u65f6\\u95f4\",\"object\":\"task\",\"field\":\"closedDate\",\"type\":\"date\"},\"estimate\":{\"name\":\"\\u6700\\u521d\\u9884\\u8ba1\",\"object\":\"task\",\"field\":\"estimate\",\"type\":\"string\"},\"consumed\":{\"name\":\"\\u603b\\u8ba1\\u6d88\\u8017\",\"object\":\"task\",\"field\":\"consumed\",\"type\":\"string\"},\"left\":{\"name\":\"\\u9884\\u8ba1\\u5269\\u4f59\",\"object\":\"task\",\"field\":\"left\",\"type\":\"string\"},\"deviation\":{\"name\":\"deviation\",\"object\":\"task\",\"field\":\"deviation\",\"type\":\"number\"},\"rate\":{\"name\":\"rate\",\"object\":\"task\",\"field\":\"rate\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"closedDate\",\"type\":\"date\",\"name\":\"\\u5173\\u95ed\\u65f6\\u95f4\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]', `langs` = '{\"name\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"name\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"closedDate\":{\"zh-cn\":\"\\u5173\\u95ed\\u65f6\\u95f4\",\"zh-tw\":\"\",\"en\":\"closedDate\",\"de\":\"\",\"fr\":\"\"},\"estimate\":{\"zh-cn\":\"\\u6700\\u521d\\u9884\\u8ba1\",\"zh-tw\":\"\",\"en\":\"estimate\",\"de\":\"\",\"fr\":\"\"},\"consumed\":{\"zh-cn\":\"\\u603b\\u8ba1\\u6d88\\u8017\",\"zh-tw\":\"\",\"en\":\"consumed\",\"de\":\"\",\"fr\":\"\"},\"left\":{\"zh-cn\":\"\\u9884\\u8ba1\\u5269\\u4f59\",\"zh-tw\":\"\",\"en\":\"left\",\"de\":\"\",\"fr\":\"\"},\"deviation\":{\"zh-cn\":\"\\u504f\\u5dee\",\"zh-tw\":\"\",\"en\":\"deviation\",\"de\":\"\",\"fr\":\"\"},\"rate\":{\"zh-cn\":\"\\u504f\\u5dee\\u6bd4\\u7387\",\"zh-tw\":\"\",\"en\":\"rate\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select\n*,\nround(tt.deviation/tt.estimate,3) rate\nfrom(\nselect\nt1.name,\nt1.id,\nt1.closedDate,\nt2.estimate estimate,\nt2.consumed consumed,\nt2.`left`,\nt2.consumed-t2.estimate deviation\nfrom\nzt_project t1\nleft join\n(select\nproject,\nsum(estimate) estimate,\nsum(consumed) consumed,\nsum(`left`) `left`\nfrom\nzt_task\ngroup by project) t2\non t1.id=t2.project\nwhere t1.deleted=\'0\'\nand t1.status=\'closed\'\nand t1.type=\'project\') tt', `stage` = 'published', `builtin` = 0 WHERE `id` = 10022;

-- 公司质量数据盘点大屏
UPDATE `zt_chart` SET `type` = 'line', `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"year\",\"name\":\"year\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"effectiveBugRate\",\"name\":\"effectiveBugRate\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"bug\",\"field\":\"year\",\"type\":\"string\"},\"totalBugCount\":{\"name\":\"totalBugCount\",\"object\":\"bug\",\"field\":\"totalBugCount\",\"type\":\"string\"},\"effectiveBugCount\":{\"name\":\"effectiveBugCount\",\"object\":\"bug\",\"field\":\"effectiveBugCount\",\"type\":\"number\"},\"effectiveBugRate\":{\"name\":\"effectiveBugRate\",\"object\":\"bug\",\"field\":\"effectiveBugRate\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"Year\",\"de\":\"\",\"fr\":\"\"},\"totalBugCount\":{\"zh-cn\":\"Bug\\u603b\\u6570\",\"zh-tw\":\"\",\"en\":\"Total Bug Count\",\"de\":\"\",\"fr\":\"\"},\"effectiveBugCount\":{\"zh-cn\":\"\\u6709\\u6548Bug\\u6570\",\"zh-tw\":\"\",\"en\":\"Effective Bug Count\",\"de\":\"\",\"fr\":\"\"},\"effectiveBugRate\":{\"zh-cn\":\"\\u6709\\u6548Bug\\u7387\",\"zh-tw\":\"\",\"en\":\"Effective Bug Rate\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select\nyear,\ncount(a.id) as totalBugCount,\nsum(a.effectivebug) as effectiveBugCount,\nsum(a.effectivebug)/count(a.id) effectiveBugRate\nfrom(\nselect \nleft(openedDate,4) year,\nid,\n(case when  resolution in (\'fixed\',\'postponed\') or status=\'active\' then 1 else 0 end) effectivebug,\n(case when  resolution=\'fixed\' then 1 else 0 end) fixedBug\nfrom zt_bug\nwhere zt_bug.deleted=\'0\'\n) a\ngroup by a.year\norder by  a.year', `stage` = 'published', `builtin` = 0 WHERE `id` = 10212;
UPDATE `zt_chart` SET `type` = 'line', `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"year\",\"name\":\"year\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"bugCount\",\"name\":\"Bug\\u6570\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"string\"},\"createdBugs\":{\"name\":\"createdBugs\",\"object\":\"story\",\"field\":\"createdBugs\",\"type\":\"string\"},\"exfixedstoryestimate\":{\"name\":\"exfixedstoryestimate\",\"object\":\"story\",\"field\":\"exfixedstoryestimate\",\"type\":\"number\"},\"bugCount\":{\"name\":\"Bug\\u6570\",\"object\":\"story\",\"field\":\"bugCount\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"Year\",\"de\":\"\",\"fr\":\"\"},\"createdBugs\":{\"zh-cn\":\"\\u4ea7\\u751fBug\",\"zh-tw\":\"\",\"en\":\"Created Bug\",\"de\":\"\",\"fr\":\"\"},\"exfixedstoryestimate\":{\"zh-cn\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\",\"en\":\"Finished Story\",\"de\":\"\",\"fr\":\"\"},\"bugCount\":{\"zh-cn\":\"\\u5355\\u4f4d\\u5b8c\\u6210\\u9700\\u6c42\\u89c4\\u6a21\\u4ea7\\u751f\\u7684Bug\\u6570\",\"zh-tw\":\"\",\"en\":\"Bug Density\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select\nbug.year as year,\ncreatedBugs, \nexfixedstoryestimate,\nround(createdBugs/exfixedstoryestimate,2) as bugCount                                                                                                                                                             \nfrom\n(select \nleft(openedDate,4) year,\ncount(id) createdBugs\nfrom zt_bug\nwhere zt_bug.deleted=\'0\'\ngroup by year\n) bug \nleft join\n(select\nsum(estimate) exfixedstoryestimate,\nleft(closedDate,4) year\nfrom\nzt_story\nwhere zt_story.deleted=\'0\' and zt_story.status=\'closed\' and zt_story.closedReason=\'done\'\ngroup by year\n) story\non story.year=bug.year\norder by bug.year', `stage` = 'published', `builtin` = 0 WHERE `id` = 10213;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"name\",\"name\":\"name\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"count\",\"name\":\"count\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"name\":{\"name\":\"name\",\"object\":\"product\",\"field\":\"name\",\"type\":\"string\"},\"count\":{\"name\":\"count\",\"object\":\"testcase\",\"field\":\"id\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"name\",\"type\":\"select\",\"name\":\"\\u4ea7\\u54c1\"}]', `langs` = '{\"name\":{\"zh-cn\":\"\\u4ea7\\u54c1\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"Product\",\"de\":\"\",\"fr\":\"\"},\"count\":{\"zh-cn\":\"\\u7528\\u4f8b\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"Case Count\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select \nt1.name,\nifnull(t2.cases,0) as count\nfrom\nzt_product t1\nleft join\n(\nselect\nproduct,\ncount(id) cases \nfrom\nzt_case\nwhere deleted=\'0\'\ngroup by product )\nt2 on t1.id=t2.product', `stage` = 'published', `builtin` = 0 WHERE `id` = 10215;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"name\",\"name\":\"name\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"bug\",\"name\":\"bug\",\"valOrAgg\":\"sum\"}],\"rotateX\":\"notuse\"}]', `fields` = '{\"name\":{\"name\":\"name\",\"object\":\"product\",\"field\":\"name\",\"type\":\"string\"},\"bug\":{\"name\":\"bug\",\"object\":\"bug\",\"field\":\"id\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"name\",\"type\":\"select\",\"name\":\"\\u4ea7\\u54c1\"}]', `langs` = '{\"name\":{\"zh-cn\":\"\\u4ea7\\u54c1\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"Product\",\"de\":\"\",\"fr\":\"\"},\"bug\":{\"zh-cn\":\"Bug\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"Bug Count\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select \nt1.name,\nifnull(t2.bugs,0) bug\nfrom\nzt_product t1\nleft join\n(\nselect\nproduct,\ncount(id) bugs \nfrom\nzt_bug\nwhere zt_bug.deleted=\'0\'\ngroup by product )\nt2 on t1.id=t2.product', `stage` = 'published', `builtin` = 0 WHERE `id` = 10216;
UPDATE `zt_chart` SET `type` = 'pie', `settings` = '[{\"type\":\"pie\",\"group\":[{\"field\":\"status\",\"name\":\"Bug\\u72b6\\u6001\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"Bug\\u7f16\\u53f7\",\"valOrAgg\":\"count\"}]}]', `fields` = '{\"id\":{\"name\":\"Bug\\u7f16\\u53f7\",\"object\":\"bug\",\"field\":\"id\",\"type\":\"number\"},\"status\":{\"name\":\"Bug\\u72b6\\u6001\",\"object\":\"bug\",\"field\":\"status\",\"type\":\"option\"},\"openedDate\":{\"name\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"object\":\"bug\",\"field\":\"openedDate\",\"type\":\"date\"}}', `filters` = '[{\"field\":\"openedDate\",\"type\":\"date\",\"name\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]', `langs` = '{\"id\":{\"zh-cn\":\"Bug\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"Bug ID\",\"de\":\"\",\"fr\":\"\"},\"status\":{\"zh-cn\":\"Bug\\u72b6\\u6001\",\"zh-tw\":\"\",\"en\":\"Status\",\"de\":\"\",\"fr\":\"\"},\"openedDate\":{\"zh-cn\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"Opened Date\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select \nid,status,openedDate \nfrom zt_bug\nwhere deleted=\'0\'', `stage` = 'published', `builtin` = 0 WHERE `id` = 10217;
UPDATE `zt_chart` SET `type` = 'pie', `settings` = '[{\"type\":\"pie\",\"group\":[{\"field\":\"type\",\"name\":\"Bug\\u7c7b\\u578b\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"Bug\\u7f16\\u53f7\",\"valOrAgg\":\"count\"}]}]', `fields` = '{\"id\":{\"name\":\"Bug\\u7f16\\u53f7\",\"object\":\"bug\",\"field\":\"id\",\"type\":\"number\"},\"type\":{\"name\":\"Bug\\u7c7b\\u578b\",\"object\":\"bug\",\"field\":\"type\",\"type\":\"option\"},\"openedDate\":{\"name\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"object\":\"bug\",\"field\":\"openedDate\",\"type\":\"date\"}}', `filters` = '[{\"field\":\"openedDate\",\"type\":\"date\",\"name\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]', `langs` = '{\"id\":{\"zh-cn\":\"Bug\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"Bug ID\",\"de\":\"\",\"fr\":\"\"},\"type\":{\"zh-cn\":\"Bug\\u7c7b\\u578b\",\"zh-tw\":\"\",\"en\":\"Type\",\"de\":\"\",\"fr\":\"\"},\"openedDate\":{\"zh-cn\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"Opened Date\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select\nid,type,openedDate\nfrom\nzt_bug\nwhere deleted=\'0\'', `stage` = 'published', `builtin` = 0 WHERE `id` = 10218;
UPDATE `zt_chart` SET `type` = 'pie', `settings` = '[{\"type\":\"pie\",\"group\":[{\"field\":\"severity\",\"name\":\"\\u4e25\\u91cd\\u7a0b\\u5ea6\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"Bug\\u7f16\\u53f7\",\"valOrAgg\":\"count\"}]}]', `fields` = '{\"id\":{\"name\":\"Bug\\u7f16\\u53f7\",\"object\":\"bug\",\"field\":\"id\",\"type\":\"number\"},\"severity\":{\"name\":\"\\u4e25\\u91cd\\u7a0b\\u5ea6\",\"object\":\"bug\",\"field\":\"severity\",\"type\":\"option\"},\"openedDate\":{\"name\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"object\":\"bug\",\"field\":\"openedDate\",\"type\":\"date\"}}', `filters` = '[{\"field\":\"openedDate\",\"type\":\"date\",\"name\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]', `langs` = '{\"id\":{\"zh-cn\":\"Bug\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"Bug ID\",\"de\":\"\",\"fr\":\"\"},\"severity\":{\"zh-cn\":\"\\u4e25\\u91cd\\u7a0b\\u5ea6\",\"zh-tw\":\"\",\"en\":\"Severity\",\"de\":\"\",\"fr\":\"\"},\"openedDate\":{\"zh-cn\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"Opened Date\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select\nid,severity,openedDate\nfrom\nzt_bug\nwhere deleted=\'0\'', `stage` = 'published', `builtin` = 0 WHERE `id` = 10219;
UPDATE `zt_chart` SET `type` = 'pie', `settings` = '[{\"type\":\"pie\",\"group\":[{\"field\":\"resolution\",\"name\":\"\\u89e3\\u51b3\\u65b9\\u6848\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"Bug\\u7f16\\u53f7\",\"valOrAgg\":\"count\"}]}]', `fields` = '{\"id\":{\"name\":\"Bug\\u7f16\\u53f7\",\"object\":\"bug\",\"field\":\"id\",\"type\":\"number\"},\"resolution\":{\"name\":\"\\u89e3\\u51b3\\u65b9\\u6848\",\"object\":\"bug\",\"field\":\"resolution\",\"type\":\"option\"},\"resolvedDate\":{\"name\":\"\\u89e3\\u51b3\\u65e5\\u671f\",\"object\":\"bug\",\"field\":\"resolvedDate\",\"type\":\"date\"}}', `filters` = '[{\"field\":\"resolvedDate\",\"type\":\"date\",\"name\":\"\\u89e3\\u51b3\\u65e5\\u671f\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]', `langs` = '{\"id\":{\"zh-cn\":\"Bug\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"Bug ID\",\"de\":\"\",\"fr\":\"\"},\"resolution\":{\"zh-cn\":\"\\u89e3\\u51b3\\u65b9\\u6848\",\"zh-tw\":\"\",\"en\":\"Resolution\",\"de\":\"\",\"fr\":\"\"},\"resolvedDate\":{\"zh-cn\":\"\\u89e3\\u51b3\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"Resolved Date\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select id,resolution,resolvedDate from zt_bug\nwhere deleted=\'0\' and resolution!=\' \'', `stage` = 'published', `builtin` = 0 WHERE `id` = 10220;

UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"program\",\"name\":\"program\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"budget\",\"name\":\"\\u9884\\u7b97\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"project\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_project\",\"field\":\"id\",\"type\":\"number\"},\"program\":{\"name\":\"program\",\"object\":\"zt_project\",\"field\":\"program\",\"type\":\"string\"},\"budget\":{\"name\":\"\\u9884\\u7b97\",\"object\":\"project\",\"field\":\"budget\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"program\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"program\",\"de\":\"\",\"fr\":\"\"},\"budget\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u9884\\u7b97\",\"zh-tw\":\"\",\"en\":\"budget\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  YEAR(t2.openedDate) AS `year`, \n  t1.id,\n  t1.name AS program, \n  ROUND(\n    SUM(\n      IFNULL(t2.budget, 0)\n    ) / 10000, \n    2\n  ) AS budget \nFROM \n  zt_project AS t1 \n  LEFT JOIN zt_project AS t2 ON FIND_IN_SET(t1.id, t2.path) \n  AND t2.deleted = \'0\' \n  AND t2.type = \'project\' \nWHERE \n  t1.deleted = \'0\' \n  AND t1.type = \'program\' \n  AND t1.grade = 1 \nGROUP BY \n  `year`, \n  id,\n  program \nORDER BY \n  `year`, \n  budget DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1085;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"setName\",\"name\":\"setName\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"number\",\"name\":\"number\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"user\",\"field\":\"year\",\"type\":\"number\"},\"number\":{\"name\":\"number\",\"object\":\"user\",\"field\":\"number\",\"type\":\"string\"},\"setName\":{\"name\":\"setName\",\"object\":\"user\",\"field\":\"setName\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"number\":{\"zh-cn\":\"\\u4eba\\u5458\\u6570\\u91cf\",\"zh-tw\":\"\",\"en\":\"number\",\"de\":\"\",\"fr\":\"\"},\"setName\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"setName\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT tt.join as `year`, count(1) as number, tt.setName from (\nselect \nYEAR(t1.join) as `join`, t4.name as setName \nfrom zt_team t1 \nRIGHT JOIN zt_project t2 on t2.id = t1.root\nLEFT JOIN zt_project t4 on FIND_IN_SET(t4.id,t2.path) and t4.grade = 1\nRIGHT JOIN zt_user t3 on t3.account = t1.account\nWHERE t1.type = \'project\'\nAND t2.deleted = \'0\'\nAND t3.deleted = \'0\'\n) tt\nGROUP BY tt.setName, tt.join\nORDER BY tt.join, number desc, tt.setName', `stage` = 'published', `builtin` = 0 WHERE `id` = 1086;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"program\",\"name\":\"program\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"consumed\",\"name\":\"\\u603b\\u8ba1\\u6d88\\u8017\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"effort\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_project\",\"field\":\"id\",\"type\":\"number\"},\"program\":{\"name\":\"program\",\"object\":\"zt_project\",\"field\":\"program\",\"type\":\"string\"},\"consumed\":{\"name\":\"\\u603b\\u8ba1\\u6d88\\u8017\",\"object\":\"task\",\"field\":\"consumed\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"program\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"program\",\"de\":\"\",\"fr\":\"\"},\"consumed\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u603b\\u8ba1\\u6d88\\u8017\",\"zh-tw\":\"\",\"en\":\"program\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  YEAR(t5.date) AS `year`, \n  t1.id,\n  t1.name AS program, \n  ROUND(\n    SUM(t5.consumed), \n    2\n  ) AS consumed \nFROM \n  zt_project AS t1 \n  LEFT JOIN zt_project AS t2 ON FIND_IN_SET(t1.id, t2.path) \n  AND t2.deleted = \'0\' \n  AND t2.type = \'project\' \n  LEFT JOIN zt_project AS t3 ON t2.id = t3.parent \n  AND t3.deleted = \'0\' \n  AND t3.type IN (\'sprint\', \'stage\', \'kanban\') \n  LEFT JOIN zt_task AS t4 ON t3.id = t4.execution \n  AND t4.deleted = \'0\' \n  AND t4.status != \'cancel\' \n  LEFT JOIN zt_effort AS t5 ON t4.id = t5.objectID \n  AND t5.deleted = \'0\' \n  AND t5.objectType = \'task\' \nWHERE \n  t1.deleted = \'0\' \n  AND t1.type = \'program\' \n  AND t1.grade = 1 \n  AND t5.id IS NOT NULL \nGROUP BY \n  `year`, \n  id,\n  program \nORDER BY \n  `year`, \n  consumed DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1087;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"program\",\"name\":\"program\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"story\",\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_project\",\"field\":\"id\",\"type\":\"number\"},\"program\":{\"name\":\"program\",\"object\":\"zt_project\",\"field\":\"program\",\"type\":\"string\"},\"story\":{\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"object\":\"story\",\"field\":\"story\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"program\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"program\",\"de\":\"\",\"fr\":\"\"},\"story\":{\"zh-cn\":\"\\u65b0\\u589e\\u7814\\u53d1\\u9700\\u6c42\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"story\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  YEAR(t3.openedDate) AS `year`,\n  t1.id, \n  t1.name AS program, \n  COUNT(1) AS story \nFROM \n  zt_project AS t1 \n  LEFT JOIN zt_product AS t2 ON t1.id = t2.program \n  AND t2.deleted = \'0\' \n  LEFT JOIN zt_story AS t3 ON t2.id = t3.product \n  AND t3.deleted = \'0\' \nWHERE \n  t1.deleted = \'0\' \n  AND t1.type = \'program\' \n  AND t1.grade = 1 \n  AND t3.id IS NOT NULL \nGROUP BY \n  `year`, \n  id,\n  program \nORDER BY \n  `year`, \n  story DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1088;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"program\",\"name\":\"program\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"story\",\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_project\",\"field\":\"id\",\"type\":\"number\"},\"program\":{\"name\":\"program\",\"object\":\"zt_project\",\"field\":\"program\",\"type\":\"string\"},\"story\":{\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"object\":\"story\",\"field\":\"story\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"program\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"program\",\"de\":\"\",\"fr\":\"\"},\"story\":{\"zh-cn\":\"\\u65b0\\u589e\\u7814\\u53d1\\u9700\\u6c42\\u89c4\\u6a21\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  YEAR(t3.openedDate) AS `year`, \n  t1.id,\n  t1.name AS program, \n  ROUND(\n    SUM(t3.estimate), \n    2\n  ) AS story \nFROM \n  zt_project AS t1 \n  LEFT JOIN zt_product AS t2 ON t1.id = t2.program \n  AND t2.deleted = \'0\' \n  LEFT JOIN zt_story AS t3 ON t2.id = t3.product \n  AND t3.deleted = \'0\' \nWHERE \n  t1.deleted = \'0\' \n  AND t1.type = \'program\' \n  AND t1.grade = 1 \n  AND t3.id IS NOT NULL \nGROUP BY \n  `year`,\n  id, \n  program \nORDER BY \n  `year`, \n  story DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1089;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"program\",\"name\":\"program\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"bug\",\"name\":\"Bug\\u5217\\u8868\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"bug\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_project\",\"field\":\"id\",\"type\":\"number\"},\"program\":{\"name\":\"program\",\"object\":\"zt_project\",\"field\":\"program\",\"type\":\"string\"},\"bug\":{\"name\":\"Bug\\u5217\\u8868\",\"object\":\"project\",\"field\":\"bug\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"program\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"program\",\"de\":\"\",\"fr\":\"\"},\"bug\":{\"zh-cn\":\"\\u65b0\\u589eBug\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"bug\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  YEAR(t3.openedDate) AS `year`,\n  t1.id, \n  t1.name AS program, \n  COUNT(1) AS bug \nFROM \n  zt_project AS t1 \n  LEFT JOIN zt_product AS t2 ON t1.id = t2.program \n  AND t2.deleted = \'0\' \n  LEFT JOIN zt_bug AS t3 ON t2.id = t3.product \n  AND t3.deleted = \'0\' \nWHERE \n  t1.deleted = \'0\' \n  AND t1.type = \'program\' \n  AND t1.grade = 1 \n  AND t3.id IS NOT NULL \nGROUP BY \n  `year`, \n  id,\n  program \nORDER BY \n  `year`, \n  bug DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1090;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"program\",\"name\":\"program\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"story\",\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_project\",\"field\":\"id\",\"type\":\"number\"},\"program\":{\"name\":\"program\",\"object\":\"zt_project\",\"field\":\"program\",\"type\":\"string\"},\"story\":{\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"object\":\"story\",\"field\":\"story\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"program\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"program\",\"de\":\"\",\"fr\":\"\"},\"story\":{\"zh-cn\":\"\\u5b8c\\u6210\\u7814\\u53d1\\u9700\\u6c42\\u6c42\\u548c\",\"zh-tw\":\"\",\"en\":\"story\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  YEAR(t3.closedDate) AS `year`, \n  t1.id,\n  t1.name AS program, \n  COUNT(1) AS story \nFROM \n  zt_project AS t1 \n  LEFT JOIN zt_product AS t2 ON t1.id = t2.program \n  AND t2.deleted = \'0\' \n  LEFT JOIN zt_story AS t3 ON t2.id = t3.product \n  AND t3.deleted = \'0\' \n  AND t3.closedReason = \'done\' \nWHERE \n  t1.deleted = \'0\' \n  AND t1.type = \'program\' \n  AND t1.grade = 1 \n  AND t3.id IS NOT NULL \nGROUP BY \n  `year`,\n  id,  \n  program \nORDER BY \n  `year`, \n  story DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1091;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"program\",\"name\":\"program\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"story\",\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_project\",\"field\":\"id\",\"type\":\"number\"},\"program\":{\"name\":\"program\",\"object\":\"zt_project\",\"field\":\"program\",\"type\":\"string\"},\"story\":{\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"object\":\"story\",\"field\":\"story\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"program\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"program\",\"de\":\"\",\"fr\":\"\"},\"story\":{\"zh-cn\":\"\\u7814\\u53d1\\u9700\\u6c42\\u9884\\u8ba1\\u5de5\\u65f6\\u6c42\\u548c\",\"zh-tw\":\"\",\"en\":\"story\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  YEAR(t3.closedDate) AS `year`, \n  t1.id,\n  t1.name AS program, \n  ROUND(\n    SUM(t3.estimate), \n    2\n  ) AS story \nFROM \n  zt_project AS t1 \n  LEFT JOIN zt_product AS t2 ON t1.id = t2.program \n  AND t2.deleted = \'0\' \n  LEFT JOIN zt_story AS t3 ON t2.id = t3.product \n  AND t3.deleted = \'0\' \n  AND t3.closedReason = \'done\' \nWHERE \n  t1.deleted = \'0\' \n  AND t1.type = \'program\' \n  AND t1.grade = 1 \n  AND t3.id IS NOT NULL \nGROUP BY \n  `year`, \n  id,\n  program \nORDER BY \n  `year`, \n  story DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1092;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"program\",\"name\":\"program\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"bug\",\"name\":\"Bug\\u5217\\u8868\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"bug\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_project\",\"field\":\"id\",\"type\":\"number\"},\"program\":{\"name\":\"program\",\"object\":\"zt_project\",\"field\":\"program\",\"type\":\"string\"},\"bug\":{\"name\":\"Bug\\u5217\\u8868\",\"object\":\"project\",\"field\":\"bug\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"program\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"program\",\"de\":\"\",\"fr\":\"\"},\"bug\":{\"zh-cn\":\"Bug\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"bug\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  YEAR(t3.closedDate) AS `year`,\n  t1.id,  \n  t1.name AS program, \n  COUNT(1) AS bug \nFROM \n  zt_project AS t1 \n  LEFT JOIN zt_product AS t2 ON t1.id = t2.program \n  AND t2.deleted = \'0\' \n  LEFT JOIN zt_bug AS t3 ON t2.id = t3.product \n  AND t3.deleted = \'0\' \n  AND t3.resolution = \'fixed\' \n  AND t3.status = \'closed\' \nWHERE \n  t1.deleted = \'0\' \n  AND t1.type = \'program\' \n  AND t1.grade = 1 \n  AND t3.id IS NOT NULL \nGROUP BY \n  `year`, \n  id,\n  program \nORDER BY \n  `year`, \n  bug DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1093;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"name\",\"name\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"duration\",\"name\":\"duration\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"project\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"\\u7f16\\u53f7\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"name\":{\"name\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"object\":\"project\",\"field\":\"name\",\"type\":\"string\"},\"status\":{\"name\":\"\\u72b6\\u6001\",\"object\":\"project\",\"field\":\"status\",\"type\":\"option\"},\"realBegan\":{\"name\":\"\\u5b9e\\u9645\\u5f00\\u59cb\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"realBegan\",\"type\":\"date\"},\"realEnd\":{\"name\":\"\\u5b9e\\u9645\\u5b8c\\u6210\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"realEnd\",\"type\":\"date\"},\"duration\":{\"name\":\"duration\",\"object\":\"project\",\"field\":\"duration\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"name\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"name\",\"de\":\"\",\"fr\":\"\"},\"status\":{\"zh-cn\":\"\\u72b6\\u6001\",\"zh-tw\":\"\",\"en\":\"status\",\"de\":\"\",\"fr\":\"\"},\"realBegan\":{\"zh-cn\":\"\\u5b9e\\u9645\\u5f00\\u59cb\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"realBegan\",\"de\":\"\",\"fr\":\"\"},\"realEnd\":{\"zh-cn\":\"\\u5b9e\\u9645\\u5b8c\\u6210\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"realEnd\",\"de\":\"\",\"fr\":\"\"},\"duration\":{\"zh-cn\":\"\\u5de5\\u671f\",\"zh-tw\":\"\",\"en\":\"duration\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT `year`, id,name,status,realBegan,realEnd,IF(status = \'closed\', DATEDIFF(realEnd, realBegan), DATEDIFF(NOW(),realBegan)) as duration\nFROM (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) AS t1\nLEFT JOIN zt_project AS t2 ON 1 = 1 WHERE deleted = \'0\' AND type = \'project\' AND YEAR(realBegan) <= `year` AND LEFT(realBegan, 4) != \'0000\' AND (status =\'doing\' OR (status = \'suspended\' AND YEAR(suspendedDate) >= `year`) OR (status = \'closed\' AND YEAR(realEnd) >= `year`)) HAVING 1=1 ORDER BY `year`, duration desc', `stage` = 'published', `builtin` = 0 WHERE `id` = 1094;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"name\",\"name\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"duration\",\"name\":\"duration\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"project\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"\\u7f16\\u53f7\",\"object\":\"action\",\"field\":\"id\",\"type\":\"number\"},\"name\":{\"name\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"object\":\"project\",\"field\":\"name\",\"type\":\"string\"},\"status\":{\"name\":\"\\u72b6\\u6001\",\"object\":\"project\",\"field\":\"status\",\"type\":\"option\"},\"begin\":{\"name\":\"\\u8ba1\\u5212\\u5f00\\u59cb\",\"object\":\"project\",\"field\":\"begin\",\"type\":\"date\"},\"end\":{\"name\":\"\\u8ba1\\u5212\\u5b8c\\u6210\",\"object\":\"project\",\"field\":\"end\",\"type\":\"date\"},\"realBegan\":{\"name\":\"\\u5b9e\\u9645\\u5f00\\u59cb\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"realBegan\",\"type\":\"date\"},\"realEnd\":{\"name\":\"\\u5b9e\\u9645\\u5b8c\\u6210\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"realEnd\",\"type\":\"date\"},\"duration\":{\"name\":\"duration\",\"object\":\"project\",\"field\":\"duration\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"name\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"name\",\"de\":\"\",\"fr\":\"\"},\"status\":{\"zh-cn\":\"\\u72b6\\u6001\",\"zh-tw\":\"\",\"en\":\"status\",\"de\":\"\",\"fr\":\"\"},\"begin\":{\"zh-cn\":\"\\u8ba1\\u5212\\u5f00\\u59cb\",\"zh-tw\":\"\",\"en\":\"begin\",\"de\":\"\",\"fr\":\"\"},\"end\":{\"zh-cn\":\"\\u8ba1\\u5212\\u5b8c\\u6210\",\"zh-tw\":\"\",\"en\":\"end\",\"de\":\"\",\"fr\":\"\"},\"realBegan\":{\"zh-cn\":\"\\u5b9e\\u9645\\u5f00\\u59cb\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"realBegan\",\"de\":\"\",\"fr\":\"\"},\"realEnd\":{\"zh-cn\":\"\\u5b9e\\u9645\\u5b8c\\u6210\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"realEnd\",\"de\":\"\",\"fr\":\"\"},\"duration\":{\"zh-cn\":\"\\u5de5\\u671f\\u504f\\u5dee\",\"zh-tw\":\"\",\"en\":\"duration\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT `year`, id,name,status,`begin`,`end`,realBegan,realEnd,\nROUND((IF(LEFT(realEnd,4) != \'0000\', DATEDIFF(realEnd, realBegan), DATEDIFF(NOW(),realBegan)) - DATEDIFF(`end`, `begin`)) / DATEDIFF(`end`,`begin`) * 100) as duration\nFROM (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) AS t1\nLEFT JOIN zt_project AS t2 ON 1 = 1 \nWHERE deleted = \'0\' AND type = \'project\'\nAND YEAR(realBegan) <= `year` AND LEFT(realBegan, 4) != \'0000\'\nAND (YEAR(realEnd) >= `year` OR LEFT(realEnd, 4) = \'0000\') AND YEAR(`end`) != \'2059\'\nHAVING 1=1\nORDER BY duration ASC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1096;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"name\",\"name\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"number\",\"name\":\"number\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"user\",\"field\":\"year\",\"type\":\"number\"},\"number\":{\"name\":\"number\",\"object\":\"user\",\"field\":\"number\",\"type\":\"string\"},\"name\":{\"name\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"object\":\"project\",\"field\":\"name\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"number\":{\"zh-cn\":\"\\u4eba\\u5458\\u4e2a\\u6570\",\"zh-tw\":\"\",\"en\":\"number\",\"de\":\"\",\"fr\":\"\"},\"name\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"name\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT tt.join as `year`, count(1) as number, tt.name from (\nselect \nt2.name, YEAR(t1.join) as `join`\nfrom zt_team t1 \nRIGHT JOIN zt_project t2 on t2.id = t1.root\nRIGHT JOIN zt_user t3 on t3.account = t1.account\nWHERE t1.type = \'project\'\nAND t2.deleted = \'0\'\n) tt\nGROUP BY tt.`name`, tt.join\nORDER BY tt.join, number desc, tt.name', `stage` = 'published', `builtin` = 0 WHERE `id` = 1097;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"project\",\"name\":\"project\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"consumed\",\"name\":\"\\u603b\\u8ba1\\u6d88\\u8017\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"effort\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_project\",\"field\":\"id\",\"type\":\"number\"},\"project\":{\"name\":\"project\",\"object\":\"zt_project\",\"field\":\"project\",\"type\":\"string\"},\"consumed\":{\"name\":\"\\u603b\\u8ba1\\u6d88\\u8017\",\"object\":\"task\",\"field\":\"consumed\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"project\":{\"zh-cn\":\"\\u9879\\u76ee\",\"zh-tw\":\"\",\"en\":\"project\",\"de\":\"\",\"fr\":\"\"},\"consumed\":{\"zh-cn\":\"\\u4efb\\u52a1\\u603b\\u8ba1\\u6d88\\u8017\",\"zh-tw\":\"\",\"en\":\"consumed\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  YEAR(t4.date) AS `year`,\n  t1.id,  \n  t1.name AS project, \n  ROUND(\n    SUM(t4.consumed), \n    2\n  ) AS consumed \nFROM \n  zt_project AS t1 \n  LEFT JOIN zt_project AS t2 ON t1.id = t2.parent \n  AND t2.deleted = \'0\' \n  AND t2.type IN (\'sprint\', \'stage\', \'kanban\') \n  LEFT JOIN zt_task AS t3 ON t2.id = t3.execution \n  AND t3.deleted = \'0\' \n  AND t3.status != \'cancel\' \n  LEFT JOIN zt_effort AS t4 ON t3.id = t4.objectID \n  AND t4.deleted = \'0\' \n  AND t4.objectType = \'task\' \nWHERE \n  t1.deleted = \'0\' \n  AND t1.type = \'project\' \n  AND t4.id IS NOT NULL \nGROUP BY \n  `year`, \n  id,\n  project \nORDER BY \n  `year`, \n  consumed DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1098;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"project\",\"name\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"story\",\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\\u5217\\u8868\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"\\u9879\\u76eeID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"project\":{\"name\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"object\":\"project\",\"field\":\"project\",\"type\":\"string\"},\"story\":{\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\\u5217\\u8868\",\"object\":\"projectstory\",\"field\":\"story\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"project\":{\"zh-cn\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"zh-tw\":\"\",\"en\":\"project\",\"de\":\"\",\"fr\":\"\"},\"story\":{\"zh-cn\":\"\\u7814\\u53d1\\u9700\\u6c42\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"story\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  YEAR(t1.closedDate) AS `year`, \n  t1.id, \n  t1.project, \n  COUNT(1) AS story \nFROM \n  (\n    SELECT \n      DISTINCT t1.id, \n      t1.name AS project, \n      t4.id AS story, \n      t4.closedDate \n    FROM \n      zt_project AS t1 \n      LEFT JOIN zt_project AS t2 ON t1.id = t2.parent \n      AND t2.deleted = \'0\' \n      AND t2.type IN (\'sprint\', \'stage\', \'kanban\') \n      LEFT JOIN zt_projectstory AS t3 ON t2.id = t3.project \n      LEFT JOIN zt_story AS t4 ON t3.story = t4.id \n      AND t4.deleted = \'0\' \n      AND t4.closedReason = \'done\' \n    WHERE \n      t1.deleted = \'0\' \n      AND t1.type = \'project\' \n      AND t4.id IS NOT NULL\n  ) AS t1 \nGROUP BY \n  `year`, \n  id, \n  project \nORDER BY \n  `year`, \n  story DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1099;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"project\",\"name\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"story\",\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\\u5217\\u8868\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"\\u9879\\u76eeID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"project\":{\"name\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"object\":\"project\",\"field\":\"project\",\"type\":\"string\"},\"story\":{\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\\u5217\\u8868\",\"object\":\"projectstory\",\"field\":\"story\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"project\":{\"zh-cn\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"zh-tw\":\"\",\"en\":\"project\",\"de\":\"\",\"fr\":\"\"},\"story\":{\"zh-cn\":\"\\u9700\\u6c42\\u9884\\u8ba1\\u5de5\\u65f6\",\"zh-tw\":\"\",\"en\":\"story\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  YEAR(t1.closedDate) AS `year`, \n  t1.id, \n  t1.project, \n  ROUND(\n    SUM(t1.estimate), \n    2\n  ) AS story \nFROM \n  (\n    SELECT \n      DISTINCT t1.id, \n      t1.name AS project, \n      t4.id AS story, \n      t4.estimate, \n      t4.closedDate \n    FROM \n      zt_project AS t1 \n      LEFT JOIN zt_project AS t2 ON t1.id = t2.parent \n      AND t2.deleted = \'0\' \n      AND t2.type IN (\'sprint\', \'stage\', \'kanban\') \n      LEFT JOIN zt_projectstory AS t3 ON t2.id = t3.project \n      LEFT JOIN zt_story AS t4 ON t3.story = t4.id \n      AND t4.deleted = \'0\' \n      AND t4.closedReason = \'done\' \n    WHERE \n      t1.deleted = \'0\' \n      AND t1.type = \'project\' \n      AND t4.id IS NOT NULL\n  ) AS t1 \nGROUP BY \n  `year`, \n  id, \n  project \nORDER BY \n  `year`, \n  story DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1100;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"product\",\"name\":\"product\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"story\",\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_product\",\"field\":\"id\",\"type\":\"number\"},\"product\":{\"name\":\"product\",\"object\":\"zt_product\",\"field\":\"product\",\"type\":\"string\"},\"story\":{\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"object\":\"story\",\"field\":\"story\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u4ea7\\u54c1\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"product\":{\"zh-cn\":\"\\u4ea7\\u54c1\",\"zh-tw\":\"\",\"en\":\"product\",\"de\":\"\",\"fr\":\"\"},\"story\":{\"zh-cn\":\"\\u7814\\u53d1\\u9700\\u6c42\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"story\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT YEAR(t2.openedDate) AS `year`, t1.id,  t1.name AS product, COUNT(1) AS story\nFROM zt_product AS t1\nLEFT JOIN zt_story AS t2 ON t1.id = t2.product AND t2.deleted = \'0\'\nWHERE t1.deleted = \'0\' AND t1.shadow = \'0\' AND t1.vision = \'rnd\' AND t2.id IS NOT NULL\nGROUP BY `year`, id, product\nORDER BY `year`, story DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1101;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"product\",\"name\":\"product\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"story\",\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_product\",\"field\":\"id\",\"type\":\"number\"},\"product\":{\"name\":\"product\",\"object\":\"zt_product\",\"field\":\"product\",\"type\":\"string\"},\"story\":{\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"object\":\"story\",\"field\":\"story\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u4ea7\\u54c1\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"product\":{\"zh-cn\":\"\\u4ea7\\u54c1\",\"zh-tw\":\"\",\"en\":\"product\",\"de\":\"\",\"fr\":\"\"},\"story\":{\"zh-cn\":\"\\u7814\\u53d1\\u9700\\u6c42\\u9884\\u8ba1\\u5de5\\u65f6\\u6c42\\u548c\",\"zh-tw\":\"\",\"en\":\"story\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT YEAR(t2.closedDate) AS `year`, t1.id, t1.name AS product, ROUND(SUM(t2.estimate), 1) AS story\nFROM zt_product AS t1\nLEFT JOIN zt_story AS t2 ON t1.id = t2.product AND t2.deleted = \'0\' AND t2.closedReason = \'done\'\nWHERE t1.deleted = \'0\' AND t1.shadow = \'0\' AND t1.vision = \'rnd\' AND t2.id IS NOT NULL\nGROUP BY `year`, id, product\nORDER BY `year`, story DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1102;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"product\",\"name\":\"product\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"bug\",\"name\":\"bug\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"bug\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_product\",\"field\":\"id\",\"type\":\"number\"},\"product\":{\"name\":\"product\",\"object\":\"zt_product\",\"field\":\"product\",\"type\":\"string\"},\"bug\":{\"name\":\"bug\",\"object\":\"bug\",\"field\":\"bug\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u4ea7\\u54c1\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"product\":{\"zh-cn\":\"\\u4ea7\\u54c1\",\"zh-tw\":\"\",\"en\":\"product\",\"de\":\"\",\"fr\":\"\"},\"bug\":{\"zh-cn\":\"Bug\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"bug\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT YEAR(t2.openedDate) AS `year`, t1.id,  t1.name AS product, COUNT(1) AS bug\nFROM zt_product AS t1\nLEFT JOIN zt_bug AS t2 ON t1.id = t2.product AND t2.deleted = \'0\'\nWHERE t1.deleted = \'0\' AND t1.shadow = \'0\' AND t1.vision = \'rnd\' AND t2.id IS NOT NULL\nGROUP BY `year`, id, product\nORDER BY `year`, bug DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1103;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"product\",\"name\":\"product\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"bug\",\"name\":\"bug\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"bug\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_product\",\"field\":\"id\",\"type\":\"number\"},\"product\":{\"name\":\"product\",\"object\":\"zt_product\",\"field\":\"product\",\"type\":\"string\"},\"bug\":{\"name\":\"bug\",\"object\":\"bug\",\"field\":\"bug\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u4ea7\\u54c1\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"product\":{\"zh-cn\":\"\\u4ea7\\u54c1\",\"zh-tw\":\"\",\"en\":\"product\",\"de\":\"\",\"fr\":\"\"},\"bug\":{\"zh-cn\":\"Bug\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"bug\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT YEAR(t2.closedDate) AS `year`, t1.id, t1.name AS product, COUNT(1) AS bug\nFROM zt_product AS t1\nLEFT JOIN zt_bug AS t2 ON t1.id = t2.product AND t2.deleted = \'0\' AND t2.resolution = \'fixed\' AND t2.status = \'closed\'\nWHERE t1.deleted = \'0\' AND t1.shadow = \'0\' AND t1.vision = \'rnd\' AND t2.id IS NOT NULL\nGROUP BY `year`, id, product\nORDER BY `year`, bug DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1104;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"realname\",\"name\":\"realname\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"count\",\"name\":\"count\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"number\"},\"realname\":{\"name\":\"realname\",\"object\":\"zt_user\",\"field\":\"realname\",\"type\":\"string\"},\"count\":{\"name\":\"count\",\"object\":\"story\",\"field\":\"count\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"realname\":{\"zh-cn\":\"\\u59d3\\u540d\",\"zh-tw\":\"\",\"en\":\"realname\",\"de\":\"\",\"fr\":\"\"},\"count\":{\"zh-cn\":\"\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"count\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \nYEAR(t3.openedDate) AS `year`,t2.realname,count(1) AS count\nFROM zt_action AS t1 RIGHT JOIN zt_user AS t2 ON t1.actor=t2.account LEFT JOIN zt_story AS t3 ON t1.objectID=t3.id\nWHERE t1.objectType=\'story\' AND t1.action=\'opened\' AND t3.deleted=\'0\'\nGROUP BY `year`,t2.account ORDER BY `year`,count DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1105;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"realname\",\"name\":\"realname\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"count\",\"name\":\"count\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"testcase\",\"field\":\"year\",\"type\":\"number\"},\"realname\":{\"name\":\"realname\",\"object\":\"zt_user\",\"field\":\"realname\",\"type\":\"string\"},\"count\":{\"name\":\"count\",\"object\":\"testcase\",\"field\":\"count\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"realname\":{\"zh-cn\":\"\\u59d3\\u540d\",\"zh-tw\":\"\",\"en\":\"realname\",\"de\":\"\",\"fr\":\"\"},\"count\":{\"zh-cn\":\"\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"count\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \nYEAR(t3.openedDate) AS `year`,t2.realname,count(1) AS count\nFROM zt_action AS t1 RIGHT JOIN zt_user AS t2 ON t1.actor=t2.account LEFT JOIN zt_case AS t3 ON t1.objectID=t3.id\nWHERE t1.objectType=\'case\' AND t1.action=\'opened\' AND t3.deleted=\'0\'\nGROUP BY `year`,t2.account ORDER BY `year`,count DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1106;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"realname\",\"name\":\"realname\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"count\",\"name\":\"count\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"bug\",\"field\":\"year\",\"type\":\"number\"},\"realname\":{\"name\":\"realname\",\"object\":\"zt_user\",\"field\":\"realname\",\"type\":\"string\"},\"count\":{\"name\":\"count\",\"object\":\"bug\",\"field\":\"count\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"realname\":{\"zh-cn\":\"\\u59d3\\u540d\",\"zh-tw\":\"\",\"en\":\"realname\",\"de\":\"\",\"fr\":\"\"},\"count\":{\"zh-cn\":\"\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"count\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \nYEAR(t3.openedDate) AS `year`,t2.realname,count(1) AS count\nFROM zt_action AS t1 RIGHT JOIN zt_user AS t2 ON t1.actor=t2.account LEFT JOIN zt_bug AS t3 ON t1.objectID=t3.id\nWHERE t1.objectType=\'bug\' AND t1.action=\'opened\' AND t3.deleted=\'0\'\nGROUP BY `year`,t2.account ORDER BY `year`,count DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1107;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"realname\",\"name\":\"realname\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"count\",\"name\":\"count\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"bug\",\"field\":\"year\",\"type\":\"number\"},\"realname\":{\"name\":\"realname\",\"object\":\"zt_user\",\"field\":\"realname\",\"type\":\"string\"},\"count\":{\"name\":\"count\",\"object\":\"bug\",\"field\":\"count\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"realname\":{\"zh-cn\":\"\\u59d3\\u540d\",\"zh-tw\":\"\",\"en\":\"realname\",\"de\":\"\",\"fr\":\"\"},\"count\":{\"zh-cn\":\"\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"count\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \nYEAR(t3.openedDate) AS `year`,t2.realname,count(DISTINCT t3.id) AS count\nFROM zt_action AS t1 RIGHT JOIN zt_user AS t2 ON t1.actor=t2.account LEFT JOIN zt_bug AS t3 ON t1.objectID=t3.id\nWHERE t1.objectType=\'bug\' AND t1.action=\'resolved\' AND t3.deleted=\'0\'\nGROUP BY `year`,t2.account ORDER BY `year`,count DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1108;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"realname\",\"name\":\"realname\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"consumed\",\"name\":\"\\u8017\\u65f6\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"user\",\"field\":\"year\",\"type\":\"number\"},\"realname\":{\"name\":\"realname\",\"object\":\"zt_user\",\"field\":\"realname\",\"type\":\"string\"},\"consumed\":{\"name\":\"\\u8017\\u65f6\",\"object\":\"effort\",\"field\":\"consumed\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"realname\":{\"zh-cn\":\"\\u59d3\\u540d\",\"zh-tw\":\"\",\"en\":\"realname\",\"de\":\"\",\"fr\":\"\"},\"consumed\":{\"zh-cn\":\"\\u8017\\u65f6\",\"zh-tw\":\"\",\"en\":\"consumed\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT YEAR(t1.date) AS `year`, t2.realname, ROUND(SUM(t1.consumed),1) AS consumed\nFROM zt_effort AS t1 LEFT JOIN zt_user AS t2 ON t1.account = t2.account\nWHERE t1.deleted = \'0\' AND t2.deleted = \'0\'\nGROUP BY `year`, realname\nORDER BY `year`, consumed DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1109;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"realname\",\"name\":\"realname\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"count\",\"name\":\"count\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"user\",\"field\":\"year\",\"type\":\"number\"},\"realname\":{\"name\":\"realname\",\"object\":\"zt_action\",\"field\":\"realname\",\"type\":\"string\"},\"count\":{\"name\":\"count\",\"object\":\"user\",\"field\":\"count\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"realname\":{\"zh-cn\":\"\\u59d3\\u540d\",\"zh-tw\":\"\",\"en\":\"realname\",\"de\":\"\",\"fr\":\"\"},\"count\":{\"zh-cn\":\"\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"count\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT YEAR(t1.date) AS `year`,IFNULL(t2.realname,t1.actor) AS realname,count(1) AS count\nFROM zt_action t1 LEFT JOIN zt_user AS t2 ON t1.actor=t2.account\nGROUP BY `year`,t1.actor\nORDER BY `year`, `count` DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1110;

-- 升级水球图
-- 宏观数据盘点大屏
UPDATE `zt_chart` SET `type` = 'waterpolo', `settings` = '[{\"type\":\"waterpolo\",\"calc\":\"count\",\"goal\":\"id\",\"conditions\":[{\"field\":\"bugstatus\",\"condition\":\"eq\",\"value\":\"done\"}]}]', `fields` = '{\"id\":{\"name\":\"\\u7f16\\u53f7\",\"object\":\"story\",\"field\":\"id\",\"type\":\"number\"},\"bugstatus\":{\"name\":\"bugstatus\",\"object\":\"story\",\"field\":\"bugstatus\",\"type\":\"string\"}}', `filters` = '[]', `langs` = '{\"id\":{\"zh-cn\":\"\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"bugstatus\":{\"zh-cn\":\"Bug\\u72b6\\u6001\",\"zh-tw\":\"\",\"en\":\"bugstatus\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT id, IF(closedReason=\'done\', \'done\', \'undone\') AS bugstatus FROM zt_story WHERE deleted=\'0\' AND (status != \'closed\' OR closedReason=\'done\')', `stage` = 'published', `builtin` = 0 WHERE `id` = 1031;
UPDATE `zt_chart` SET `type` = 'waterpolo', `settings` = '[{\"type\":\"waterpolo\",\"calc\":\"count\",\"goal\":\"id\",\"conditions\":[{\"field\":\"bugstatus\",\"condition\":\"eq\",\"value\":\"done\"}]}]', `fields` = '{\"id\":{\"name\":\"Bug\\u7f16\\u53f7\",\"object\":\"bug\",\"field\":\"id\",\"type\":\"number\"},\"bugstatus\":{\"name\":\"bugstatus\",\"object\":\"bug\",\"field\":\"bugstatus\",\"type\":\"string\"}}', `filters` = '[]', `langs` = '{\"id\":{\"zh-cn\":\"Bug\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"bugstatus\":{\"zh-cn\":\"Bug\\u72b6\\u6001\",\"zh-tw\":\"\",\"en\":\"bugstatus\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT id, IF(`status`=\'closed\' AND resolution=\'fixed\', \'done\', \'undone\') AS bugstatus FROM zt_bug WHERE deleted=\'0\' AND (status = \'active\' OR resolution in (\'fixed\', \'postponed\'))', `stage` = 'published', `builtin` = 0 WHERE `id` = 1032;

-- 年度完成项目过程数据大屏
UPDATE `zt_chart` SET `type` = 'waterpolo', `settings` = '[{\"type\":\"waterpolo\",\"calc\":\"count\",\"goal\":\"id\",\"conditions\":[{\"field\":\"projectstatus\",\"condition\":\"eq\",\"value\":\"done\"}]}]', `fields` = '{\"id\":{\"name\":\"\\u9879\\u76eeID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"projectstatus\":{\"name\":\"projectstatus\",\"object\":\"project\",\"field\":\"projectstatus\",\"type\":\"string\"},\"year\":{\"name\":\"year\",\"object\":\"project\",\"field\":\"year\",\"type\":\"string\"}}', `filters` = '[]', `langs` = '{\"id\":{\"zh-cn\":\"\\u9879\\u76eeID\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"projectstatus\":{\"zh-cn\":\"\\u9879\\u76ee\\u72b6\\u6001\",\"zh-tw\":\"\",\"en\":\"projectstatus\",\"de\":\"\",\"fr\":\"\"},\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT t1.id,IF(t1.realEnd<=t1.end,\'done\',\'undone\') AS \'projectstatus\', YEAR(`closedDate`) AS \'year\' FROM(SELECT id, begin, end, IF(LEFT(realEnd, 4) = \'0000\', LEFT(closedDate,10), realEnd) AS realEnd, closedDate FROM zt_project WHERE deleted=\'0\' AND type=\'project\' AND status=\'closed\') t1', `stage` = 'published', `builtin` = 0 WHERE `id` = 10014;
UPDATE `zt_chart` SET `type` = 'waterpolo', `settings` = '[{\"type\":\"waterpolo\",\"calc\":\"count\",\"goal\":\"id\",\"conditions\":[{\"field\":\"projectstatus\",\"condition\":\"eq\",\"value\":\"done\"}]}]', `fields` = '{\"id\":{\"name\":\"\\u9879\\u76eeID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"projectstatus\":{\"name\":\"projectstatus\",\"object\":\"project\",\"field\":\"projectstatus\",\"type\":\"string\"},\"year\":{\"name\":\"year\",\"object\":\"project\",\"field\":\"year\",\"type\":\"string\"}}', `filters` = '[]', `langs` = '{\"id\":{\"zh-cn\":\"\\u6267\\u884cID\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"projectstatus\":{\"zh-cn\":\"\\u6267\\u884c\\u72b6\\u6001\",\"zh-tw\":\"\",\"en\":\"projectstatus\",\"de\":\"\",\"fr\":\"\"},\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT t1.id,IF(t1.realEnd<=t1.end,\'done\',\'undone\') AS \'projectstatus\', YEAR(`closedDate`) AS \'year\' FROM (SELECT id, begin, end, IF(LEFT(realEnd,4)=\'0000\',LEFT(closedDate,10), realEnd) AS realEnd, closedDate FROM zt_project WHERE deleted=\'0\' and type=\'sprint\' and status=\'closed\') t1', `stage` = 'published', `builtin` = 0 WHERE `id` = 10015;
UPDATE `zt_chart` SET `type` = 'waterpolo', `settings` = '[{\"type\":\"waterpolo\",\"calc\":\"count\",\"goal\":\"id\",\"conditions\":[{\"field\":\"projectstatus\",\"condition\":\"eq\",\"value\":\"done\"}]}]', `fields` = '{\"id\":{\"name\":\"\\u9879\\u76eeID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"projectstatus\":{\"name\":\"projectstatus\",\"object\":\"project\",\"field\":\"projectstatus\",\"type\":\"string\"},\"year\":{\"name\":\"year\",\"object\":\"project\",\"field\":\"year\",\"type\":\"string\"}}', `filters` = '[]', `langs` = '{\"id\":{\"zh-cn\":\"\\u9879\\u76eeID\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"projectstatus\":{\"zh-cn\":\"\\u9879\\u76ee\\u72b6\\u6001\",\"zh-tw\":\"\",\"en\":\"projectstatus\",\"de\":\"\",\"fr\":\"\"},\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT t1.id,IF(t1.realEnd>t1.end ,\'done\',\'undone\') AS \'projectstatus\', YEAR(`closedDate`) AS \'year\' FROM (SELECT id, begin, end, IF(LEFT(realEnd, 4) = \'0000\', LEFT(closedDate,10), realEnd) AS realEnd, closedDate FROM zt_project WHERE deleted=\'0\' AND type=\'project\' AND status=\'closed\') t1', `stage` = 'published', `builtin` = 0 WHERE `id` = 10016;
UPDATE `zt_chart` SET `type` = 'waterpolo', `settings` = '[{\"type\":\"waterpolo\",\"calc\":\"count\",\"goal\":\"id\",\"conditions\":[{\"field\":\"projectstatus\",\"condition\":\"eq\",\"value\":\"done\"}]}]', `fields` = '{\"id\":{\"name\":\"\\u9879\\u76eeID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"projectstatus\":{\"name\":\"projectstatus\",\"object\":\"project\",\"field\":\"projectstatus\",\"type\":\"string\"},\"year\":{\"name\":\"year\",\"object\":\"project\",\"field\":\"year\",\"type\":\"string\"}}', `filters` = '[]', `langs` = '{\"id\":{\"zh-cn\":\"\\u6267\\u884cID\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"projectstatus\":{\"zh-cn\":\"\\u6267\\u884c\\u72b6\\u6001\",\"zh-tw\":\"\",\"en\":\"projectstatus\",\"de\":\"\",\"fr\":\"\"},\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT t1.id,IF(t1.realEnd>t1.end,\'done\',\'undone\') AS \'projectstatus\', YEAR(`closedDate`) AS \'year\' FROM(SELECT id, begin, end, IF(LEFT(realEnd, 4) = \'0000\', LEFT(closedDate,10), realEnd) AS realEnd, closedDate FROM zt_project WHERE deleted=\'0\' and type=\'sprint\' and status=\'closed\') t1', `stage` = 'published', `builtin` = 0 WHERE `id` = 10017;

-- 公司质量数据盘点大屏
UPDATE `zt_chart` SET `type` = 'waterpolo', `settings` = '[{\"type\":\"waterpolo\",\"calc\":\"sum\",\"goal\":\"fixpercent\",\"conditions\":[{\"field\":\"havecase\",\"condition\":\"eq\",\"value\":\"havecase\"}]}]', `fields` = '{\"fixpercent\":{\"name\":\"fixpercent\",\"object\":\"testcase\",\"field\":\"fixpercent\",\"type\":\"number\"},\"havecase\":{\"name\":\"havecase\",\"object\":\"testcase\",\"field\":\"havecase\",\"type\":\"string\"}}', `filters` = '[]', `langs` = '{\"fixpercent\":{\"zh-cn\":\"\\u7528\\u4f8b\\u8986\\u76d6\\u7387\",\"zh-tw\":\"\",\"en\":\"fixpercent\",\"de\":\"\",\"fr\":\"\"},\"havecase\":{\"zh-cn\":\"\\u662f\\u5426\\u6709\\u7528\\u4f8b\",\"zh-tw\":\"\",\"en\":\"havecase\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT ROUND(SUM(t3.havecasefixstory)/COUNT(t3.fixstory),4) AS fixpercent, \'havecase\' as havecase FROM (SELECT t2.storyid \'fixstory\', (CASE WHEN t2.cases=0 THEN 0 ELSE 1 END) havecasefixstory FROM (SELECT t1.storyid, SUM(t1.iscase) cases FROM (SELECT zt_story.id storyid, (CASE WHEN zt_case.id is null THEN 0 ELSE 1 END) iscase FROM zt_story LEFT JOIN zt_case ON zt_story.id=zt_case.story WHERE zt_story.deleted=\'0\' AND (zt_story.stage IN (\'developed\',\'testing\',\'verfied\',\'released\') OR (zt_story.status=\'closed\' AND zt_story.closedReason=\'done\'))) t1 GROUP BY t1.storyid ORDER BY cases DESC) t2) t3\nunion\nSELECT ROUND(1-SUM(t3.havecasefixstory)/COUNT(t3.fixstory),4) AS fixpercent, \'nocase\' as havecase FROM (SELECT t2.storyid \'fixstory\', (CASE WHEN t2.cases=0 THEN 0 ELSE 1 END) havecasefixstory FROM (SELECT t1.storyid, SUM(t1.iscase) cases FROM (SELECT zt_story.id storyid, (CASE WHEN zt_case.id is null THEN 0 ELSE 1 END) iscase FROM zt_story LEFT JOIN zt_case ON zt_story.id=zt_case.story WHERE zt_story.deleted=\'0\' AND (zt_story.stage IN (\'developed\',\'testing\',\'verfied\',\'released\') OR (zt_story.status=\'closed\' AND zt_story.closedReason=\'done\'))) t1 GROUP BY t1.storyid ORDER BY cases DESC) t2) t3', `stage` = 'published', `builtin` = 0 WHERE `id` = 10207;
UPDATE `zt_chart` SET `type` = 'waterpolo', `settings` = '[{\"type\":\"waterpolo\",\"calc\":\"sum\",\"goal\":\"casedensity\",\"conditions\":[{\"field\":\"havecase\",\"condition\":\"eq\",\"value\":\"havecase\"}]}]', `fields` = '{\"casedensity\":{\"name\":\"casedensity\",\"object\":\"testcase\",\"field\":\"casedensity\",\"type\":\"number\"},\"havecase\":{\"name\":\"havecase\",\"object\":\"testcase\",\"field\":\"havecase\",\"type\":\"string\"}}', `filters` = '[]', `langs` = '{\"casedensity\":{\"zh-cn\":\"\\u7528\\u4f8b\\u5bc6\\u5ea6\",\"zh-tw\":\"\",\"en\":\"casedensity\",\"de\":\"\",\"fr\":\"\"},\"havecase\":{\"zh-cn\":\"\\u662f\\u5426\\u6709\\u7528\\u4f8b\",\"zh-tw\":\"\",\"en\":\"havecase\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT ROUND(SUM(t2.cases)/SUM(t2.estimate),4) AS casedensity, \'havecase\' as havecase FROM (SELECT t1.storyid, t1.estimate, SUM(t1.iscase) cases FROM (SELECT zt_story.id storyid, zt_story.estimate, (CASE WHEN zt_case.id is null THEN 0 ELSE 1 END) iscase FROM zt_story LEFT JOIN zt_case ON zt_story.id=zt_case.story WHERE zt_story.deleted=\'0\' AND (zt_story.stage IN (\'developed\',\'testing\',\'verfied\',\'released\') OR (zt_story.status=\'closed\' AND zt_story.closedReason=\'done\'))) t1 GROUP BY t1.storyid, t1.estimate ORDER BY cases DESC) t2\nunion\nSELECT ROUND(1-SUM(t2.cases)/SUM(t2.estimate),4) AS casedensity, \'nocase\' as havecase FROM (SELECT t1.storyid, t1.estimate, SUM(t1.iscase) cases FROM (SELECT zt_story.id storyid, zt_story.estimate, (CASE WHEN zt_case.id is null THEN 0 ELSE 1 END) iscase FROM zt_story LEFT JOIN zt_case ON zt_story.id=zt_case.story WHERE zt_story.deleted=\'0\' AND (zt_story.stage IN (\'developed\',\'testing\',\'verfied\',\'released\') OR (zt_story.status=\'closed\' AND zt_story.closedReason=\'done\'))) t1 GROUP BY t1.storyid, t1.estimate ORDER BY cases DESC) t2', `stage` = 'published', `builtin` = 0 WHERE `id` = 10208;
UPDATE `zt_chart` SET `type` = 'waterpolo', `settings` = '[{\"type\":\"waterpolo\",\"calc\":\"sum\",\"goal\":\"bugdensity\",\"conditions\":[{\"field\":\"havebug\",\"condition\":\"eq\",\"value\":\"havebug\"}]}]', `fields` = '{\"bugdensity\":{\"name\":\"bugdensity\",\"object\":\"bug\",\"field\":\"bugdensity\",\"type\":\"number\"},\"havebug\":{\"name\":\"havebug\",\"object\":\"bug\",\"field\":\"havebug\",\"type\":\"string\"}}', `filters` = '[]', `langs` = '{\"bugdensity\":{\"zh-cn\":\"Bug\\u5bc6\\u5ea6\",\"zh-tw\":\"\",\"en\":\"bugdensity\",\"de\":\"\",\"fr\":\"\"},\"havebug\":{\"zh-cn\":\"\\u662f\\u5426\\u6709Bug\",\"zh-tw\":\"\",\"en\":\"havebug\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT ROUND(SUM(t3.bug)/SUM(t3.estimate), 4) AS bugdensity, \'havebug\' as havebug FROM (SELECT t1.product product, IFNULL(t1.estimate,0) estimate, IFNULL(t2.bug,0) bug FROM (SELECT product, ROUND(SUM(estimate),2) estimate FROM zt_story WHERE deleted=\'0\' AND (stage IN (\'developed\',\'testing\',\'verfied\',\'released\') OR (status=\'closed\' AND closedReason=\'done\')) GROUP BY product) t1 LEFT JOIN (SELECT product, COUNT(id) bug FROM zt_bug WHERE deleted=\'0\' GROUP BY product) t2 ON t1.product=t2.product) t3\nunion\nSELECT ROUND(1-SUM(t3.bug)/SUM(t3.estimate), 4) AS bugdensity, \'nobug\' as havebug FROM (SELECT t1.product product, IFNULL(t1.estimate,0) estimate, IFNULL(t2.bug,0) bug FROM (SELECT product, ROUND(SUM(estimate),2) estimate FROM zt_story WHERE deleted=\'0\' AND (stage IN (\'developed\',\'testing\',\'verfied\',\'released\') OR (status=\'closed\' AND closedReason=\'done\')) GROUP BY product) t1 LEFT JOIN (SELECT product, COUNT(id) bug FROM zt_bug WHERE deleted=\'0\' GROUP BY product) t2 ON t1.product=t2.product) t3', `stage` = 'published', `builtin` = 0 WHERE `id` = 10209;
UPDATE `zt_chart` SET `type` = 'waterpolo', `settings` = '[{\"type\":\"waterpolo\",\"calc\":\"sum\",\"goal\":\"fixpercent\",\"conditions\":[{\"field\":\"havebug\",\"condition\":\"eq\",\"value\":\"havebug\"}]}]', `fields` = '{\"fixpercent\":{\"name\":\"fixpercent\",\"object\":\"bug\",\"field\":\"fixpercent\",\"type\":\"number\"},\"havebug\":{\"name\":\"havebug\",\"object\":\"bug\",\"field\":\"havebug\",\"type\":\"string\"}}', `filters` = '[]', `langs` = '{\"fixpercent\":{\"zh-cn\":\"Bug\\u4fee\\u590d\\u7387\",\"zh-tw\":\"\",\"en\":\"fixpercent\",\"de\":\"\",\"fr\":\"\"},\"havebug\":{\"zh-cn\":\"\\u662f\\u5426\\u6709Bug\",\"zh-tw\":\"\",\"en\":\"havebug\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT ROUND(SUM(CASE WHEN resolution=\'fixed\' THEN 1 ELSE 0 END)/COUNT(id),4) AS fixpercent, \'havebug\' as havebug FROM zt_bug WHERE deleted = \'0\' \nunion\nSELECT ROUND(1-SUM(CASE WHEN resolution=\'fixed\' THEN 1 ELSE 0 END)/COUNT(id),4) AS fixpercent, \'nobug\' as havebug FROM zt_bug WHERE deleted = \'0\'', `stage` = 'published', `builtin` = 0 WHERE `id` = 10210;

-- 升级大屏
-- 宏观数据盘点大屏
UPDATE `zt_screen` SET `scheme` = '[{\"id\":\"5scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":0,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":1300,\"h\":120,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/screen_header.png\",\"borderRadius\":10}},{\"id\":\"2nws38440fq000\",\"isGroup\":false,\"attr\":{\"x\":400,\"y\":36,\"w\":500,\"h\":66,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"title\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u5b8f\\u89c2\\u6570\\u636e\\u76d8\\u70b9\\u5927\\u5c4f\",\"fontSize\":26,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":124,\"w\":1000,\"h\":480,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":800,\"h\":120,\"x\":0,\"y\":128,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":287,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u516c\\u53f8\\u7ea7\\u6570\\u636e\\u6982\\u89c8\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":175,\"y\":31,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":175,\"y\":33,\"w\":800,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_right.png\",\"fit\":\"contain\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":25,\"y\":199,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1018,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":155,\"y\":199,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1019,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9879\\u76ee\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9879\\u76ee\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u9879\\u76ee\\u4e2a\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":285,\"y\":199,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4ea7\\u54c1\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1020,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4ea7\\u54c1\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4ea7\\u54c1\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u4ea7\\u54c1\\u4e2a\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":25,\"y\":299,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u8ba1\\u5212\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1021,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u8ba1\\u5212\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u8ba1\\u5212\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u8ba1\\u5212\\u4e2a\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":155,\"y\":299,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6267\\u884c\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1022,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6267\\u884c\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6267\\u884c\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u6267\\u884c\\u4e2a\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":285,\"y\":299,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u53d1\\u5e03\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1023,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u53d1\\u5e03\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u53d1\\u5e03\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u53d1\\u5e03\\u4e2a\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":25,\"y\":399,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9700\\u6c42\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1024,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9700\\u6c42\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9700\\u6c42\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u9700\\u6c42\\u4e2a\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":155,\"y\":399,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4efb\\u52a1\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1025,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4efb\\u52a1\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4efb\\u52a1\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u4efb\\u52a1\\u4e2a\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":285,\"y\":399,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"Bug\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1026,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"Bug\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"Bug\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"Bug\\u4e2a\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":25,\"y\":499,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1027,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u6587\\u6863\\u4e2a\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":155,\"y\":499,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u73b0\\u6709\\u4eba\\u5458\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1028,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u73b0\\u6709\\u4eba\\u5458\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u73b0\\u6709\\u4eba\\u5458\\u4e2a\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u73b0\\u6709\\u4eba\\u5458\\u4e2a\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":285,\"y\":499,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u7d2f\\u8ba1\\u6d88\\u8017\\u5de5\\u65f6\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1029,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u7d2f\\u8ba1\\u6d88\\u8017\\u5de5\\u65f6\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u7d2f\\u8ba1\\u6d88\\u8017\\u5de5\\u65f6\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u7d2f\\u8ba1\\u6d88\\u8017\\u5de5\\u65f6\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"3v5jz5hzz0c000\",\"isGroup\":true,\"attr\":{\"w\":211,\"h\":150,\"x\":500,\"y\":133,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4f7f\\u7528\\u65f6\\u957f\",\"image\":\"\"},\"groupList\":[{\"id\":\"1hxm2jtfh3y800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":380,\"h\":150,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u4f7f\\u7528\\u65f6\\u957f\\u8fb9\\u6846\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#6586ec00\",\"#2cf7fe00\"],\"backgroundColor\":\"#00000000\"}},{\"id\":\"3aekp6a7tag000\",\"isGroup\":false,\"attr\":{\"x\":60,\"y\":25,\"w\":200,\"h\":150,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4f7f\\u7528\\u65f6\\u957f\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u7985\\u9053\\u4f7f\\u7528\\u65f6\\u957f\\uff1a\",\"fontSize\":19,\"fontColor\":\"#9abdcd\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"right\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"4u5rgs0pf34000\",\"sourceID\":1030,\"isGroup\":false,\"attr\":{\"x\":265,\"y\":25,\"w\":252,\"h\":150,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u65f6\\u957f\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\",\"fontSize\":19,\"fontColor\":\"#9abdcd\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":963,\"y\":139,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"\\u63d0\\u793a\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"\\u9700\\u6c42\\u5b8c\\u6210\\u7387=\\u5173\\u95ed\\u539f\\u56e0\\u4e3a\\u5df2\\u5b8c\\u6210\\u7684\\u9700\\u6c42\\u4e2a\\u6570/(\\u5173\\u95ed\\u539f\\u56e0\\u4e3a\\u5df2\\u5b8c\\u6210\\u7684\\u9700\\u6c42\\u4e2a\\u6570+\\u672a\\u5173\\u95ed\\u7684\\u9700\\u6c42\\u4e2a\\u6570)\\uff1b\\nBug\\u4fee\\u590d\\u7387=\\u65b9\\u6848\\u4e3a\\u5df2\\u89e3\\u51b3\\u4e14\\u72b6\\u6001\\u4e3a\\u5df2\\u5173\\u95ed\\u7684Bug\\u6570/(\\u65b9\\u6848\\u4e3a\\u5df2\\u89e3\\u51b3\\u7684Bug\\u6570+\\u65b9\\u6848\\u4e3a\\u5ef6\\u671f\\u5904\\u7406\\u7684Bug\\u6570+\\u6fc0\\u6d3b\\u7684Bug\\u6570)\\u3002\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}},{\"id\":\"17sqdjuu74ik00\",\"sourceID\":1031,\"isGroup\":false,\"attr\":{\"x\":460,\"y\":253,\"w\":280,\"h\":250,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"WaterPolo\",\"chartConfig\":{\"key\":\"WaterPolo\",\"chartKey\":\"VWaterPolo\",\"conKey\":\"VWaterPolo\",\"title\":\"\\u9700\\u6c42\\u5b8c\\u6210\\u7387\",\"category\":\"WaterPolo\",\"categoryName\":\"\\u997c\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"water_WaterPolo.png\"},\"option\":{\"dataset\":0.6667,\"series\":[{\"type\":\"liquidFill\",\"shape\":\"circle\",\"radius\":\"70%\",\"data\":[0.67],\"center\":[\"50%\",\"50%\"],\"color\":[{\"type\":\"linear\",\"x\":0,\"y\":0,\"x2\":0,\"y2\":1,\"colorStops\":[{\"offset\":0,\"color\":\"#4992ff\"},{\"offset\":1,\"color\":\"#7cffb2\"}],\"globalCoord\":false}],\"backgroundStyle\":{\"borderWidth\":1,\"color\":\"rgba(68, 181, 226, 0.3)\"},\"label\":{\"normal\":{\"textStyle\":{\"fontSize\":32,\"color\":\"#fff\"}}},\"outline\":{\"show\":false,\"borderDistance\":10,\"itemStyle\":{\"borderWidth\":2,\"borderColor\":\"#112165\"}}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}},{\"id\":\"4u5rgs0pf34000\",\"isGroup\":false,\"attr\":{\"x\":475,\"y\":488,\"w\":250,\"h\":50,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u65f6\\u957f\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u9700\\u6c42\\u5b8c\\u6210\\u7387\",\"fontSize\":16,\"fontColor\":\"#c6d3d9\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"4xgico362ww000\",\"sourceID\":1032,\"isGroup\":false,\"attr\":{\"x\":720,\"y\":253,\"w\":280,\"h\":250,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"WaterPolo\",\"chartConfig\":{\"key\":\"WaterPolo\",\"chartKey\":\"VWaterPolo\",\"conKey\":\"VWaterPolo\",\"title\":\"Bug\\u4fee\\u590d\\u7387\",\"category\":\"WaterPolo\",\"categoryName\":\"\\u997c\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"water_WaterPolo.png\"},\"option\":{\"dataset\":0.6667,\"series\":[{\"type\":\"liquidFill\",\"shape\":\"circle\",\"radius\":\"70%\",\"data\":[0.67],\"center\":[\"50%\",\"50%\"],\"color\":[{\"type\":\"linear\",\"x\":0,\"y\":0,\"x2\":0,\"y2\":1,\"colorStops\":[{\"offset\":0,\"color\":\"#4992ff\"},{\"offset\":1,\"color\":\"#7cffb2\"}],\"globalCoord\":false}],\"backgroundStyle\":{\"borderWidth\":1,\"color\":\"rgba(68, 181, 226, 0.3)\"},\"label\":{\"normal\":{\"textStyle\":{\"fontSize\":32,\"color\":\"#fff\"}}},\"outline\":{\"show\":false,\"borderDistance\":10,\"itemStyle\":{\"borderWidth\":2,\"borderColor\":\"#112165\"}}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}},{\"id\":\"4u5rgs0pf34000\",\"isGroup\":false,\"attr\":{\"x\":735,\"y\":488,\"w\":250,\"h\":50,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u65f6\\u957f\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"Bug\\u4fee\\u590d\\u7387\",\"fontSize\":16,\"fontColor\":\"#c6d3d9\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":1010,\"y\":124,\"w\":290,\"h\":480,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":400,\"h\":120,\"x\":1010,\"y\":128,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":400,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u516c\\u53f8\\u7ea7\\u672a\\u5b8c\\u6210\\u6570\\u636e\\u6982\\u89c8\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":235,\"y\":31,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":235,\"y\":34,\"w\":41,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":1035,\"y\":199,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1033,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":1165,\"y\":199,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1034,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9700\\u6c42\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9700\\u6c42\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u9700\\u6c42\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":1035,\"y\":299,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4ea7\\u54c1\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1035,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4ea7\\u54c1\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4ea7\\u54c1\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u4ea7\\u54c1\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":1165,\"y\":299,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u9879\\u76ee\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1036,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9879\\u76ee\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u9879\\u76ee\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u9879\\u76ee\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":1035,\"y\":399,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u8ba1\\u5212\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1037,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u8ba1\\u5212\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u8ba1\\u5212\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u8ba1\\u5212\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":1165,\"y\":399,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6267\\u884c\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1038,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6267\\u884c\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u6267\\u884c\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u6267\\u884c\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":1035,\"y\":499,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"Bug\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1039,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"Bug\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"Bug\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"Bug\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"z3gs9qz8hq800\",\"isGroup\":true,\"attr\":{\"w\":110,\"h\":100,\"x\":1165,\"y\":499,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4efb\\u52a1\\u4e2a\\u6570\",\"image\":\"\"},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":110,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/card.png\",\"borderRadius\":0}},{\"id\":\"3ef3nnqh7gu00\",\"sourceID\":1040,\"isGroup\":false,\"attr\":{\"x\":0,\"y\":14,\"w\":110,\"h\":30,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4efb\\u52a1\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"100\",\"fontSize\":24,\"fontColor\":\"#ffffff\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"52mwo993eaw000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":38,\"w\":110,\"h\":49,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4efb\\u52a1\\u6570\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u4efb\\u52a1\\u6570\",\"fontSize\":13,\"fontColor\":\"#9abdcd\",\"paddingX\":0,\"paddingY\":0,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"fc4u6zmi58w00\",\"isGroup\":false,\"attr\":{\"x\":1260,\"y\":139,\"w\":20,\"h\":20,\"offsetX\":0,\"offsetY\":0,\"zIndex\":1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null}},\"key\":\"Hint\",\"chartConfig\":{\"key\":\"Hint\",\"chartKey\":\"VHint\",\"conKey\":\"VCHint\",\"title\":\"\\u63d0\\u793a\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/hint-2cbf6381.png\"},\"option\":{\"text\":\"\",\"icon\":\"\",\"textSize\":15,\"textColor\":\"#ffffff\",\"textWeight\":\"bold\",\"placement\":\"left-top\",\"distance\":8,\"hint\":\"\\u672a\\u5b8c\\u6210\\u7684\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570=\\u672a\\u5173\\u95ed\\u7684\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u4e2a\\u6570\\uff1b\\n\\u672a\\u5b8c\\u6210\\u7684\\u9700\\u6c42\\u4e2a\\u6570=\\u672a\\u5173\\u95ed\\u7684\\u9700\\u6c42\\u4e2a\\u6570\\uff1b\\n\\u672a\\u5b8c\\u6210\\u7684\\u4ea7\\u54c1\\u4e2a\\u6570=\\u672a\\u5173\\u95ed\\u7684\\u4ea7\\u54c1\\u4e2a\\u6570\\uff1b\\n\\u672a\\u5b8c\\u6210\\u7684\\u9879\\u76ee\\u4e2a\\u6570=\\u672a\\u5173\\u95ed\\u7684\\u9879\\u76ee\\u4e2a\\u6570\\uff1b\\n\\u672a\\u5b8c\\u6210\\u7684\\u8ba1\\u5212\\u4e2a\\u6570=\\u672a\\u5b8c\\u6210\\u7684\\u8ba1\\u5212\\u4e2a\\u6570\\uff1b\\n\\u672a\\u5b8c\\u6210\\u7684\\u6267\\u884c\\u4e2a\\u6570=\\u672a\\u5173\\u95ed\\u7684\\u6267\\u884c\\u4e2a\\u6570\\uff1b\\n\\u672a\\u5b8c\\u6210\\u7684\\u4efb\\u52a1\\u4e2a\\u6570=\\u672a\\u5b8c\\u6210\\u7684\\u4efb\\u52a1\\u4e2a\\u6570\\uff1b\\n\\u672a\\u5b8c\\u6210\\u7684Bug\\u4e2a\\u6570=\\u672a\\u5173\\u95ed\\u7684Bug\\u4e2a\\u6570\\u3002\",\"width\":0,\"height\":0,\"paddingX\":16,\"paddingY\":8,\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"left\",\"fontWeight\":\"normal\",\"backgroundColor\":\"rgba(8, 40, 80, 0.9)\",\"fontSize\":16}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":618,\"w\":1300,\"h\":525,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"6scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":618,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"57r67ykkwxk000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":230,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u6570\\u636e\\u6982\\u89c8\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":212,\"y\":31,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_left.png\",\"borderRadius\":0}},{\"id\":\"3xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":212,\"y\":33,\"w\":1065,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_right.png\",\"fit\":\"contain\",\"borderRadius\":0}},{\"id\":\"1zhfrmecpnxc00\",\"sourceID\":1041,\"isGroup\":false,\"attr\":{\"x\":25,\"y\":57,\"w\":1250,\"h\":446,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TableScrollBoard\",\"chartConfig\":{\"key\":\"TableScrollBoard\",\"chartKey\":\"VTableScrollBoard\",\"conKey\":\"VCTableScrollBoard\",\"title\":\"\\u8f6e\\u64ad\\u5217\\u8868\",\"category\":\"Tables\",\"categoryName\":\"\\u8868\\u683c\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"static/png/table_scrollboard-fb642e78.png\"},\"option\":{\"header\":[\"\\u52171\",\"\\u52172\",\"\\u52173\"],\"dataset\":[[\"\\u884c1\\u52171\",\"\\u884c1\\u52172\",\"\\u884c1\\u52173\"],[\"\\u884c2\\u52171\",\"\\u884c2\\u52172\",\"\\u884c2\\u52173\"],[\"\\u884c3\\u52171\",\"\\u884c3\\u52172\",\"\\u884c3\\u52173\"],[\"\\u884c4\\u52171\",\"\\u884c4\\u52172\",\"\\u884c4\\u52173\"],[\"\\u884c5\\u52171\",\"\\u884c5\\u52172\",\"\\u884c5\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"]],\"index\":false,\"columnWidth\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"rowNum\":8,\"waitTime\":3,\"headerHeight\":45,\"carousel\":\"single\",\"headerBGC\":\"#165896FF\",\"oddRowBGC\":\"#042b4dFF\",\"evenRowBGC\":\"#0a1c37FF\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"3hqq7oh18ra000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":0,\"y\":1153,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"1dlpgwe8wwe800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"obhxxjnin3400\",\"sourceID\":1042,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":60,\"w\":380,\"h\":416,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static/png/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"2%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}%\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"18%\",\"top\":\"10\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"confine\":\"true\",\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}%\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}},{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[2]}%\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":5,\"maxValueSpan\":5,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":5,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"handleIcon\":\"path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5M36.9,35.8h-1.3z M27.8,35.8 h-1.3H27L27.8,35.8L27.8,35.8z\",\"handleSize\":0,\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"borderCap\":\"round\",\"backgroundColor\":\"#cfcfcf00\",\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}},{\"id\":\"2u3zlsz5kk4000\",\"isGroup\":false,\"attr\":{\"x\":-10,\"y\":0,\"w\":378,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\\u4fee\\u590d\\u7387\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3ajkrqyykr8000\",\"isGroup\":false,\"attr\":{\"x\":349,\"y\":33,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_left.png\",\"borderRadius\":0}},{\"id\":\"2z65lmxl328000\",\"isGroup\":false,\"attr\":{\"x\":350,\"y\":35,\"w\":55,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1xih6tzmmssg00\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":437,\"y\":1153,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u516c\\u53f8\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u72b6\\u6001\\u5206\\u5e03\",\"image\":\"\"},\"groupList\":[{\"id\":\"2bnelf1diy8000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u516c\\u53f8\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u72b6\\u6001\\u5206\\u5e03\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"1351cy224nb400\",\"isGroup\":false,\"attr\":{\"x\":10,\"y\":0,\"w\":240,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u516c\\u53f8\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u72b6\\u6001\\u5206\\u5e03\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u516c\\u53f8\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u72b6\\u6001\\u5206\\u5e03\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3ajkrqyykr8000\",\"isGroup\":false,\"attr\":{\"x\":247,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_left.png\",\"borderRadius\":0}},{\"id\":\"2z65lmxl328000\",\"isGroup\":false,\"attr\":{\"x\":248,\"y\":32,\"w\":160,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}},{\"id\":\"4ocyn7hip9k000\",\"sourceID\":1043,\"isGroup\":false,\"attr\":{\"x\":10,\"y\":67,\"w\":400,\"h\":410,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"PieCommon\",\"chartConfig\":{\"key\":\"PieCommon\",\"chartKey\":\"VPieCommon\",\"conKey\":\"VCPieCommon\",\"title\":\"\\u997c\\u56fe\",\"category\":\"Pies\",\"categoryName\":\"\\u997c\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static/png/pie-9620f191.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"type\":\"nomal\",\"tooltip\":{\"show\":true,\"trigger\":\"item\"},\"dataset\":{\"dimensions\":[\"product\",\"data1\"],\"source\":[{\"product\":\"Mon\",\"data1\":120},{\"product\":\"Tue\",\"data1\":200},{\"product\":\"Wed\",\"data1\":150},{\"product\":\"Thu\",\"data1\":80},{\"product\":\"Fri\",\"data1\":70},{\"product\":\"Sat\",\"data1\":110},{\"product\":\"Sun\",\"data1\":130}]},\"series\":[{\"type\":\"pie\",\"radius\":[\"30%\",\"30%\"],\"label\":{\"show\":true,\"width\":120,\"formatter\":\"{b}\\n{d}%\",\"lineHeight\":20,\"color\":\"#ffffff\",\"position\":\"outside\",\"alignTo\":\"edge\",\"margin\":5},\"center\":[\"50%\",\"50%\"],\"roseType\":false,\"emphasis\":{\"itemStyle\":{\"shadowBlur\":20,\"shadowOffsetX\":2,\"shadowColor\":\"rgba(0, 0, 0, 0)\"}}}]}}],\"key\":\"group\",\"option\":{}},{\"id\":\"2js0ncv6kpc000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":865,\"x\":874,\"y\":1153,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u516c\\u53f8\\u9879\\u76ee\\u72b6\\u6001\\u5206\\u5e03\",\"image\":\"\"},\"groupList\":[{\"id\":\"4d4pumofn5g000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u516c\\u53f8\\u9879\\u76ee\\u72b6\\u6001\\u5206\\u5e03\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"50qj95gt8fs000\",\"sourceID\":1044,\"isGroup\":false,\"attr\":{\"x\":10,\"y\":76,\"w\":400,\"h\":400,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"PieCommon\",\"chartConfig\":{\"key\":\"PieCommon\",\"chartKey\":\"VPieCommon\",\"conKey\":\"VCPieCommon\",\"title\":\"\\u997c\\u56fe\",\"category\":\"Pies\",\"categoryName\":\"\\u997c\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static/png/pie-9620f191.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"type\":\"nomal\",\"tooltip\":{\"show\":true,\"trigger\":\"item\"},\"dataset\":{\"dimensions\":[\"product\",\"data1\"],\"source\":[{\"product\":\"Mon\",\"data1\":120},{\"product\":\"Tue\",\"data1\":200},{\"product\":\"Wed\",\"data1\":150},{\"product\":\"Thu\",\"data1\":80},{\"product\":\"Fri\",\"data1\":70},{\"product\":\"Sat\",\"data1\":110},{\"product\":\"Sun\",\"data1\":130}]},\"series\":[{\"type\":\"pie\",\"radius\":[\"30%\",\"30%\"],\"label\":{\"show\":true,\"width\":120,\"formatter\":\"{b}\\n{d}%\",\"lineHeight\":20,\"color\":\"#ffffff\",\"position\":\"outside\",\"alignTo\":\"edge\",\"margin\":5},\"center\":[\"50%\",\"50%\"],\"roseType\":false,\"emphasis\":{\"itemStyle\":{\"shadowBlur\":20,\"shadowOffsetX\":2,\"shadowColor\":\"rgba(0, 0, 0, 0)\"}}}]}},{\"id\":\"36zg35ree9q000\",\"isGroup\":false,\"attr\":{\"x\":8,\"y\":0,\"w\":180,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u516c\\u53f8\\u9879\\u76ee\\u72b6\\u6001\\u5206\\u5e03\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u516c\\u53f8\\u9879\\u76ee\\u72b6\\u6001\\u5206\\u5e03\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3ajkrqyykr8000\",\"isGroup\":false,\"attr\":{\"x\":186,\"y\":30,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_left.png\",\"borderRadius\":0}},{\"id\":\"2z65lmxl328000\",\"isGroup\":false,\"attr\":{\"x\":188,\"y\":32,\"w\":210,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1cfwp95aiif400\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":1663,\"w\":1300,\"h\":525,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"summary\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#00102800\",\"#00102800\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"vwvqtuc6lyo00\",\"isGroup\":true,\"attr\":{\"w\":1300,\"h\":120,\"x\":0,\"y\":1663,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u6807\\u9898\",\"image\":\"\"},\"groupList\":[{\"id\":\"5l0cps9x0z0000\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":187,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"summary_top\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u4ea7\\u54c1\\u6570\\u636e\\u6982\\u89c8\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"left\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3ajkrqyykr8000\",\"isGroup\":false,\"attr\":{\"x\":161,\"y\":33,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_left.png\",\"borderRadius\":0}},{\"id\":\"2z65lmxl328000\",\"isGroup\":false,\"attr\":{\"x\":163,\"y\":35,\"w\":1105,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_right.png\",\"fit\":\"contain\",\"borderRadius\":0}},{\"id\":\"1zhfrmecpnxc00\",\"sourceID\":1045,\"isGroup\":false,\"attr\":{\"x\":25,\"y\":57,\"w\":1250,\"h\":446,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TableScrollBoard\",\"chartConfig\":{\"key\":\"TableScrollBoard\",\"chartKey\":\"VTableScrollBoard\",\"conKey\":\"VCTableScrollBoard\",\"title\":\"\\u8f6e\\u64ad\\u5217\\u8868\",\"category\":\"Tables\",\"categoryName\":\"\\u8868\\u683c\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"static/png/table_scrollboard-fb642e78.png\"},\"option\":{\"header\":[\"\\u52171\",\"\\u52172\",\"\\u52173\"],\"dataset\":[[\"\\u884c1\\u52171\",\"\\u884c1\\u52172\",\"\\u884c1\\u52173\"],[\"\\u884c2\\u52171\",\"\\u884c2\\u52172\",\"\\u884c2\\u52173\"],[\"\\u884c3\\u52171\",\"\\u884c3\\u52172\",\"\\u884c3\\u52173\"],[\"\\u884c4\\u52171\",\"\\u884c4\\u52172\",\"\\u884c4\\u52173\"],[\"\\u884c5\\u52171\",\"\\u884c5\\u52172\",\"\\u884c5\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"],[\"\\u884c6\\u52171\",\"\\u884c6\\u52172\",\"\\u884c6\\u52173\"]],\"index\":false,\"columnWidth\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"rowNum\":8,\"waitTime\":3,\"headerHeight\":45,\"carousel\":\"single\",\"headerBGC\":\"#165896FF\",\"oddRowBGC\":\"#042b4dFF\",\"evenRowBGC\":\"#0a1c37FF\"}}],\"key\":\"group\",\"option\":{}},{\"id\":\"sl2d95i1hz400\",\"isGroup\":true,\"attr\":{\"w\":640,\"h\":500,\"x\":0,\"y\":2203,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4ea7\\u54c1\\u9700\\u6c42\\u5b8c\\u6210\\u7387\",\"image\":\"\"},\"groupList\":[{\"id\":\"57zre1am96c000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":640,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u4ea7\\u54c1\\u9700\\u6c42\\u5b8c\\u6210\\u7387\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"42ae8w3dgeg000\",\"sourceID\":1046,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":60,\"w\":530,\"h\":416,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static/png/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}%\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"15%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"confine\":\"true\",\"trigger\":\"item\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}%\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":6,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":6,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"handleIcon\":\"path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5M36.9,35.8h-1.3z M27.8,35.8 h-1.3H27L27.8,35.8L27.8,35.8z\",\"handleSize\":0,\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"borderCap\":\"round\",\"backgroundColor\":\"#cfcfcf00\",\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}},{\"id\":\"579jc04cfps000\",\"isGroup\":false,\"attr\":{\"x\":10,\"y\":0,\"w\":170,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4ea7\\u54c1\\u9700\\u6c42\\u5b8c\\u6210\\u7387\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u4ea7\\u54c1\\u9700\\u6c42\\u5b8c\\u6210\\u7387\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3ajkrqyykr8000\",\"isGroup\":false,\"attr\":{\"x\":175,\"y\":33,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_left.png\",\"borderRadius\":0}},{\"id\":\"2z65lmxl328000\",\"isGroup\":false,\"attr\":{\"x\":176,\"y\":35,\"w\":445,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"nr1mfqoyuwg00\",\"isGroup\":true,\"attr\":{\"w\":645,\"h\":500,\"x\":655,\"y\":2203,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\\u9700\\u6c42\\u5b8c\\u6210\\u7387\\u4e0eBug\",\"image\":\"\"},\"groupList\":[{\"id\":\"2ta7xcd152i000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":645,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u4ea7\\u54c1Bug\\u4fee\\u590d\\u7387\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"4o7ep6z91ii000\",\"sourceID\":1047,\"isGroup\":false,\"attr\":{\"x\":30,\"y\":60,\"w\":540,\"h\":416,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static/png/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}%\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"15%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}%\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":6,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":6,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"handleIcon\":\"path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5M36.9,35.8h-1.3z M27.8,35.8 h-1.3H27L27.8,35.8L27.8,35.8z\",\"handleSize\":0,\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"borderCap\":\"round\",\"backgroundColor\":\"#cfcfcf00\",\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}},{\"id\":\"4vcyxy305n6000\",\"isGroup\":false,\"attr\":{\"x\":12,\"y\":0,\"w\":160,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4ea7\\u54c1Bug\\u4fee\\u590d\\u7387\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u4ea7\\u54c1Bug\\u4fee\\u590d\\u7387\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3ajkrqyykr8000\",\"isGroup\":false,\"attr\":{\"x\":171,\"y\":34,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_left.png\",\"borderRadius\":0}},{\"id\":\"2z65lmxl328000\",\"isGroup\":false,\"attr\":{\"x\":172,\"y\":36,\"w\":445,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"45ao1xz9kzu000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":0,\"y\":2717,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u90e8\\u95e8\\u4eba\\u5458\\u5206\\u5e03\\u56fe\",\"image\":\"\"},\"groupList\":[{\"id\":\"1ncdmrlvzjy800\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u90e8\\u95e8\\u4eba\\u5458\\u5206\\u5e03\\u56fe\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"v3d9spa59dc00\",\"sourceID\":1049,\"isGroup\":false,\"attr\":{\"x\":20,\"y\":50,\"w\":380,\"h\":426,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static/png/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0,\"formatter\":\"{value}\"},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"15%\",\"top\":\"20\",\"right\":\"12%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"confine\":\"true\",\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"formatter\":\"{@[1]}\",\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\",\"dataZoom\":[{\"type\":\"inside\",\"startValue\":0,\"endValue\":5,\"minValueSpan\":10,\"maxValueSpan\":10,\"yAxisIndex\":[0],\"zoomOnMouseWheel\":false,\"moveOnMouseWheel\":true,\"moveOnMouseMove\":true},{\"type\":\"slider\",\"realtime\":true,\"startValue\":0,\"endValue\":6,\"zoomLock\":true,\"brushSelect\":false,\"width\":5,\"height\":\"80%\",\"handleIcon\":\"path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5M36.9,35.8h-1.3z M27.8,35.8 h-1.3H27L27.8,35.8L27.8,35.8z\",\"handleSize\":0,\"yAxisIndex\":[0],\"fillerColor\":\"#33aaff\",\"borderColor\":\"#33aaff00\",\"borderCap\":\"round\",\"backgroundColor\":\"#cfcfcf00\",\"showDataShadow\":false,\"showDetail\":false,\"top\":\"10%\",\"right\":0}]}},{\"id\":\"wam6ydb8zqo00\",\"isGroup\":false,\"attr\":{\"x\":15,\"y\":0,\"w\":160,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u90e8\\u95e8\\u4eba\\u5458\\u5206\\u5e03\\u56fe\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u90e8\\u95e8\\u4eba\\u5458\\u5206\\u5e03\\u56fe\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3ajkrqyykr8000\",\"isGroup\":false,\"attr\":{\"x\":176,\"y\":32,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_left.png\",\"borderRadius\":0}},{\"id\":\"2z65lmxl328000\",\"isGroup\":false,\"attr\":{\"x\":176,\"y\":34,\"w\":235,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"2dg0t90atgg000\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":437,\"y\":2717,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u516c\\u53f8\\u89d2\\u8272\\u5206\\u5e03\\u56fe\",\"image\":\"\"},\"groupList\":[{\"id\":\"53ynqk2kzh8000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u516c\\u53f8\\u89d2\\u8272\\u5206\\u5e03\\u56fe\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"1knkjcb65rwg00\",\"isGroup\":false,\"attr\":{\"x\":7,\"y\":0,\"w\":170,\"h\":72,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u516c\\u53f8\\u89d2\\u8272\\u5206\\u5e03\\u56fe\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u516c\\u53f8\\u89d2\\u8272\\u5206\\u5e03\\u56fe\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"mblj8ow100000\",\"sourceID\":1050,\"isGroup\":false,\"attr\":{\"x\":20,\"y\":60,\"w\":400,\"h\":420,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"PieCommon\",\"chartConfig\":{\"key\":\"PieCommon\",\"chartKey\":\"VPieCommon\",\"conKey\":\"VCPieCommon\",\"title\":\"\\u9700\\u6c42\\u5b8c\\u6210\\u7387\",\"category\":\"Pies\",\"categoryName\":\"\\u997c\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static/png/pie-9620f191.png\"},\"option\":{\"legend\":{\"show\":true,\"bottom\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"type\":\"nomal\",\"tooltip\":{\"show\":true,\"trigger\":\"item\"},\"dataset\":{\"dimensions\":[\"product\",\"data1\"],\"source\":[{\"product\":\"Mon\",\"data1\":120},{\"product\":\"Tue\",\"data1\":200},{\"product\":\"Wed\",\"data1\":150},{\"product\":\"Thu\",\"data1\":80},{\"product\":\"Fri\",\"data1\":70},{\"product\":\"Sat\",\"data1\":110},{\"product\":\"Sun\",\"data1\":130}]},\"series\":[{\"type\":\"pie\",\"radius\":[\"40%\",\"40%\"],\"label\":{\"show\":true,\"width\":120,\"formatter\":\"{b}\\n{d}%\",\"lineHeight\":20,\"color\":\"#ffffff\",\"position\":\"outside\",\"alignTo\":\"edge\",\"margin\":5},\"center\":[\"50%\",\"45%\"],\"roseType\":false,\"emphasis\":{\"itemStyle\":{\"shadowBlur\":20,\"shadowOffsetX\":2,\"shadowColor\":\"rgba(0, 0, 0, 0)\"}}}]}},{\"id\":\"3ajkrqyykr8000\",\"isGroup\":false,\"attr\":{\"x\":168,\"y\":32,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_left.png\",\"borderRadius\":0}},{\"id\":\"2z65lmxl328000\",\"isGroup\":false,\"attr\":{\"x\":169,\"y\":34,\"w\":235,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImwage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}},{\"id\":\"1j55da3c41vk00\",\"isGroup\":true,\"attr\":{\"w\":426,\"h\":500,\"x\":874,\"y\":2717,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"\\u4eba\\u5458\\u5de5\\u9f84\\u5206\\u5e03\\u56fe\",\"image\":\"\"},\"groupList\":[{\"id\":\"1xqnm37nva8w00\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":426,\"h\":500,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"\\u4eba\\u5458\\u5de5\\u9f84\\u5206\\u5e03\\u56fe\",\"category\":\"Borders\",\"categoryName\":\"\\u8fb9\\u6846\",\"package\":\"Decorates\",\"image\":\"\"},\"option\":{\"colors\":[\"#0a1c3700\",\"#042b4d00\"],\"backgroundColor\":\"#0a1c38\"}},{\"id\":\"5ll028fasrw000\",\"sourceID\":1051,\"isGroup\":false,\"attr\":{\"x\":20,\"y\":50,\"w\":380,\"h\":426,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"\\u6a2a\\u5411\\u67f1\\u72b6\\u56fe\",\"category\":\"Bars\",\"categoryName\":\"\\u67f1\\u72b6\\u56fe\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"static/png/bar_y-05067169.png\"},\"option\":{\"legend\":{\"show\":false,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":true,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":false,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"20%\",\"top\":\"20\",\"right\":\"10%\",\"bottom\":\"60\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{\"dimensions\":[\"product\",\"data1\",\"data2\"],\"source\":[{\"product\":\"Mon\",\"data1\":120,\"data2\":130},{\"product\":\"Tue\",\"data1\":200,\"data2\":130},{\"product\":\"Wed\",\"data1\":150,\"data2\":312},{\"product\":\"Thu\",\"data1\":80,\"data2\":268},{\"product\":\"Fri\",\"data1\":70,\"data2\":155},{\"product\":\"Sat\",\"data1\":110,\"data2\":117},{\"product\":\"Sun\",\"data1\":130,\"data2\":160}]},\"series\":[{\"type\":\"bar\",\"barMaxWidth\":28,\"barWidth\":null,\"label\":{\"show\":true,\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\"}},{\"id\":\"4887ix47ule000\",\"isGroup\":false,\"attr\":{\"x\":7,\"y\":0,\"w\":170,\"h\":68,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"\\u4eba\\u5458\\u5de5\\u9f84\\u5206\\u5e03\\u56fe\",\"category\":\"Texts\",\"categoryName\":\"\\u6587\\u672c\",\"package\":\"Informations\",\"image\":\"static/png/text_static-b2721032.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"\\u4eba\\u5458\\u5de5\\u9f84\\u5206\\u5e03\\u56fe\",\"fontSize\":20,\"fontColor\":\"#b2d5e5\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"bold\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":0,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3ajkrqyykr8000\",\"isGroup\":false,\"attr\":{\"x\":170,\"y\":31,\"w\":14,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_left.png\",\"borderRadius\":0}},{\"id\":\"2z65lmxl328000\",\"isGroup\":false,\"attr\":{\"x\":171,\"y\":33,\"w\":235,\"h\":11,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1},\"key\":\"Image\",\"chartConfig\":{\"key\":\"Image\",\"chartKey\":\"VImage\",\"conKey\":\"VCImage\",\"title\":\"header\",\"category\":\"Mores\",\"categoryName\":\"\\u66f4\\u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/photo-637bc05d.png\"},\"option\":{\"dataset\":\"static/images/line_right.png\",\"fit\":\"none\",\"borderRadius\":0}}],\"key\":\"group\",\"option\":{}}]' WHERE `id` = 1;
-- 年度完成项目过程数据大屏
UPDATE `zt_screen` SET `scheme` = '{\"editCanvasConfig\":{\"projectName\":\"2\",\"width\":1366,\"height\":\"3600\",\"size\":0,\"lockScale\":false,\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"background\":null,\"backgroundImage\":null,\"selectColor\":true,\"chartThemeColor\":\"3wvajowr6l8000\",\"chartThemeSetting\":{\"title\":{\"text\":\"\",\"show\":true,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14}},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}}},\"legend\":{\"show\":true,\"top\":\"5%\",\"textStyle\":{\"color\":\"#B9B8CE\"}},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":\"60\",\"right\":\"10%\",\"bottom\":\"60\"},\"dataset\":null,\"renderer\":\"svg\"},\"previewScaleType\":\"scrollY\",\"globalFilter\":[],\"chartCustomThemeColorInfo\":[{\"id\":\"3wvajowr6l8000\",\"name\":\"未命名\",\"color\":[\"#6ae5bb\",\"#69e3de\",\"#5ac5ee\",\"#6FB6F1FF\",\"#4498ec\",\"#3c7ddf\",\"#1E6AEBFF\"]}]},\"componentList\":[{\"id\":\"owvo5wyad9c00\",\"isGroup\":false,\"attr\":{\"x\":1142,\"y\":320,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"3as8najk6hg00\",\"isGroup\":false,\"attr\":{\"x\":1142,\"y\":208,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"5d6bo6dfzf4000\",\"isGroup\":false,\"attr\":{\"x\":962,\"y\":320,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"26hlsg2c15vk00\",\"isGroup\":false,\"attr\":{\"x\":962,\"y\":208,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"5niqhm817gw000\",\"isGroup\":false,\"attr\":{\"x\":782,\"y\":320,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"5rjfkvfw4i8000\",\"isGroup\":false,\"attr\":{\"x\":782,\"y\":208,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"ffvurro4h4w00\",\"isGroup\":false,\"attr\":{\"x\":603,\"y\":320,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"51idc736a5s000\",\"isGroup\":false,\"attr\":{\"x\":602,\"y\":208,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"rdnf6i797pc00\",\"isGroup\":false,\"attr\":{\"x\":421,\"y\":320,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089ff12\"}},{\"id\":\"2klk0oo8kj8000\",\"isGroup\":false,\"attr\":{\"x\":421,\"y\":208,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"48zdrnjvl0c000\",\"isGroup\":false,\"attr\":{\"x\":242,\"y\":320,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"4q65e0gqmlg000\",\"isGroup\":false,\"attr\":{\"x\":61,\"y\":320,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"17bvssn39zuk00\",\"isGroup\":false,\"attr\":{\"x\":242,\"y\":208,\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"5irrkthvdhc000\",\"isGroup\":false,\"attr\":{\"x\":61,\"y\":\"208\",\"w\":156,\"h\":88,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border03\",\"chartConfig\":{\"key\":\"Border03\",\"chartKey\":\"VBorder03\",\"conKey\":\"VCBorder03\",\"title\":\"边框-03\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border03.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00AAFF82\",\"#2CF7FE00\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"vgfp0juvuf400\",\"isGroup\":false,\"attr\":{\"x\":416,\"y\":339,\"w\":161,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"延期完成执行数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":20,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#E1E5EA00\"}},{\"id\":\"2uqxi3e1y3u000\",\"isGroup\":false,\"attr\":{\"x\":424,\"y\":303,\"w\":144,\"h\":81,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-延期完成执行数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"1326\",\"sourceID\":\"10009\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"1326\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":57,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10009\",\"title\":\"延期完成执行数\",\"type\":\"card\"},{\"id\":\"5nyrxc5w010000\",\"isGroup\":false,\"attr\":{\"x\":18,\"y\":726,\"w\":653,\"h\":490,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":true,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"2uws0ytah1s000\",\"isGroup\":false,\"attr\":{\"x\":693,\"y\":726,\"w\":653,\"h\":490,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":true,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"3mnttqgyc4o000\",\"isGroup\":false,\"attr\":{\"x\":253,\"y\":46,\"w\":860,\"h\":32,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#1089FF42\",\"#1089FF00\"],\"backgroundColor\":\"#00000000\"}},{\"id\":\"4nir9d6n138000\",\"isGroup\":false,\"attr\":{\"x\":20,\"y\":106,\"w\":1326,\"h\":600,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":true,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"3sdxo2ffqi0000\",\"isGroup\":false,\"attr\":{\"x\":50,\"y\":228,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\" 完成项目数 \",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":37,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":4,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"4nyo2dxv5yi000\",\"isGroup\":false,\"attr\":{\"x\":50,\"y\":194,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-完成项目数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"91\",\"sourceID\":\"10000\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"91\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":56,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10000\",\"title\":\"完成项目数\",\"type\":\"card\"},{\"id\":\"2ev27p00xbpc00\",\"isGroup\":false,\"attr\":{\"x\":230,\"y\":228,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"按时完成项目数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":20,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"lzaj0yorolc00\",\"isGroup\":false,\"attr\":{\"x\":410,\"y\":228,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"延期完成项目数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":20,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"4jogna07yk8000\",\"isGroup\":false,\"attr\":{\"x\":771,\"y\":229,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成需求规模数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":20,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"15j805dkq4ik00\",\"isGroup\":false,\"attr\":{\"x\":951,\"y\":228,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成发布数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":36,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"4q15hg06540000\",\"isGroup\":false,\"attr\":{\"x\":1131,\"y\":228,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"解决bug数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":36,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"4l83s1sqlek000\",\"isGroup\":false,\"attr\":{\"x\":591,\"y\":228,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成需求条目数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":20,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"5f6dr2y034w000\",\"isGroup\":false,\"attr\":{\"x\":231,\"y\":194,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-按时完成项目数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"3\",\"sourceID\":\"10001\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"3\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":56,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10001\",\"title\":\"按时完成项目数\",\"type\":\"card\"},{\"id\":\"1gw11ho3ev4w00\",\"isGroup\":false,\"attr\":{\"x\":410,\"y\":194,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-延期完成项目数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"88\",\"sourceID\":\"10002\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"88\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":56,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10002\",\"title\":\"延期完成项目数\",\"type\":\"card\"},{\"id\":\"4ljohxdlzfs000\",\"isGroup\":false,\"attr\":{\"x\":591,\"y\":194,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-完成需求条目数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"17954\",\"sourceID\":\"10003\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"17954\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":56,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10003\",\"title\":\"完成需求条目数\",\"type\":\"card\"},{\"id\":\"2dsxvobrqdes00\",\"isGroup\":false,\"attr\":{\"x\":771,\"y\":194,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-完成需求规模数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"57370\",\"sourceID\":\"10004\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"57370\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":56,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10004\",\"title\":\"完成需求规模数\",\"type\":\"card\"},{\"id\":\"25j01jdzmrts00\",\"isGroup\":false,\"attr\":{\"x\":951,\"y\":194,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-完成发布数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"602\",\"sourceID\":\"10005\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"602\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":56,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10005\",\"title\":\"完成发布数\",\"type\":\"card\"},{\"id\":\"poh8lbo2qc000\",\"isGroup\":false,\"attr\":{\"x\":1131,\"y\":194,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-解决bug数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"13886\",\"sourceID\":\"10006\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"13886\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":56,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10006\",\"title\":\"解决bug数\",\"type\":\"card\"},{\"id\":\"4nkffa1hzc0000\",\"isGroup\":false,\"attr\":{\"x\":50,\"y\":338,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成执行数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":34,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"43q8d7h9nlk000\",\"isGroup\":false,\"attr\":{\"x\":50,\"y\":304,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-完成执行数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"1567\",\"sourceID\":\"10007\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"1567\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":56,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10007\",\"title\":\"完成执行数\",\"type\":\"card\"},{\"id\":\"5jexl1ycymg000\",\"isGroup\":false,\"attr\":{\"x\":230,\"y\":338,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"按时完成执行数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":20,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"3362s9jdoko000\",\"isGroup\":false,\"attr\":{\"x\":605,\"y\":338,\"w\":166,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成任务条目数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":20,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"5l9fr10ck94000\",\"isGroup\":false,\"attr\":{\"x\":772,\"y\":338,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成任务预计工时数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":8,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":4,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"1zxjse36amv400\",\"isGroup\":false,\"attr\":{\"x\":952,\"y\":338,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成任务消耗工时数\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":8,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":4,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"29iw7qg73bbw00\",\"isGroup\":false,\"attr\":{\"x\":1131,\"y\":338,\"w\":180,\"h\":100,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"投入的总人天\",\"fontSize\":12,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":28,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"}},{\"id\":\"1r8qfow1e45c00\",\"isGroup\":false,\"attr\":{\"x\":230,\"y\":304,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-按时完成执行数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"241\",\"sourceID\":\"10008\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"241\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":57,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10008\",\"title\":\"按时完成执行数\",\"type\":\"card\"},{\"id\":\"2bnzdjpcesg000\",\"isGroup\":false,\"attr\":{\"x\":591,\"y\":304,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-完成任务条目数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"38661\",\"sourceID\":\"10010\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"38661\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":57,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10010\",\"title\":\"完成任务条目数\",\"type\":\"card\"},{\"id\":\"5rwyxojtmnw000\",\"isGroup\":false,\"attr\":{\"x\":772,\"y\":304,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-完成任务预计工时数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"109341\",\"sourceID\":\"10011\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"109341\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":57,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10011\",\"title\":\"完成任务预计工时数\",\"type\":\"card\"},{\"id\":\"1ook02lf4ns000\",\"isGroup\":false,\"attr\":{\"x\":951,\"y\":304,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-完成任务消耗工时数\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"101601\",\"sourceID\":\"10012\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"101601\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":57,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10012\",\"title\":\"完成任务消耗工时数\",\"type\":\"card\"},{\"id\":\"3c1qy9alml2000\",\"isGroup\":false,\"attr\":{\"x\":1131,\"y\":304,\"w\":180,\"h\":80,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"项目过程-投入的总人天\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\",\"dataset\":\"12339\",\"sourceID\":\"10013\",\"fields\":null,\"filters\":[]},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"12339\",\"fontSize\":18,\"fontColor\":\"#ffffff\",\"paddingX\":57,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":0,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#1089FF00\"},\"sourceID\":\"10013\",\"title\":\"投入的总人天\",\"type\":\"card\"},{\"id\":\"4v411wy0jam000\",\"isGroup\":false,\"attr\":{\"x\":68,\"y\":439,\"w\":332,\"h\":200,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"WaterPolo\",\"chartConfig\":{\"key\":\"WaterPolo\",\"chartKey\":\"VWaterPolo\",\"conKey\":\"VCVWaterPolo\",\"title\":\"项目过程-项目按期完成率\",\"category\":\"WaterPolo\",\"categoryName\":\"水球图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"water_WaterPolo.png\",\"sourceID\":\"10014\",\"fields\":null,\"filters\":[],\"dataset\":0},\"option\":{\"dataset\":0.6667,\"series\":[{\"type\":\"liquidFill\",\"shape\":\"circle\",\"radius\":\"80%\",\"data\":[0.67],\"center\":[\"50%\",\"50%\"],\"color\":[{\"type\":\"linear\",\"x\":0,\"y\":0,\"x2\":0,\"y2\":1,\"colorStops\":[{\"offset\":0,\"color\":\"#4992ff\"},{\"offset\":1,\"color\":\"#7cffb2\"}],\"globalCoord\":false}],\"backgroundStyle\":{\"borderWidth\":1,\"color\":\"rgba(68, 181, 226, 0.3)\"},\"label\":{\"normal\":{\"textStyle\":{\"fontSize\":32,\"color\":\"#fff\"}}},\"outline\":{\"show\":false,\"borderDistance\":10,\"itemStyle\":{\"borderWidth\":2,\"borderColor\":\"#112165\"}}}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10014\",\"title\":\"项目过程-项目按期完成率\",\"type\":\"WaterPolo\"},{\"id\":\"455e6v96m36000\",\"isGroup\":false,\"attr\":{\"x\":347,\"y\":440,\"w\":332,\"h\":200,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"WaterPolo\",\"chartConfig\":{\"key\":\"WaterPolo\",\"chartKey\":\"VWaterPolo\",\"conKey\":\"VCWaterPolo\",\"title\":\"项目过程-执行按期完成率\",\"category\":\"WaterPolo\",\"categoryName\":\"水球图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"water_WaterPolo.png\",\"sourceID\":\"10015\",\"fields\":null,\"filters\":[],\"dataset\":0},\"option\":{\"dataset\":0.6667,\"series\":[{\"type\":\"liquidFill\",\"shape\":\"circle\",\"radius\":\"80%\",\"data\":[0.67],\"center\":[\"50%\",\"50%\"],\"color\":[{\"type\":\"linear\",\"x\":0,\"y\":0,\"x2\":0,\"y2\":1,\"colorStops\":[{\"offset\":0,\"color\":\"#4992ff\"},{\"offset\":1,\"color\":\"#7cffb2\"}],\"globalCoord\":false}],\"backgroundStyle\":{\"borderWidth\":1,\"color\":\"rgba(68, 181, 226, 0.3)\"},\"label\":{\"normal\":{\"textStyle\":{\"fontSize\":32,\"color\":\"#fff\"}}},\"outline\":{\"show\":false,\"borderDistance\":10,\"itemStyle\":{\"borderWidth\":2,\"borderColor\":\"#112165\"}}}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10015\",\"title\":\"项目过程-执行按期完成率\",\"type\":\"water_WaterPolo.png\"},{\"id\":\"1357hi74tghs00\",\"isGroup\":false,\"attr\":{\"x\":680,\"y\":439,\"w\":332,\"h\":200,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"WaterPolo\",\"chartConfig\":{\"key\":\"WaterPolo\",\"chartKey\":\"VWaterPolo\",\"conKey\":\"VCWaterPolo\",\"title\":\"项目过程-项目延期率\",\"category\":\"WaterPolo\",\"categoryName\":\"水球图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"water_WaterPolo.png\",\"sourceID\":\"10016\",\"fields\":null,\"filters\":[],\"dataset\":0},\"option\":{\"dataset\":0.6667,\"series\":[{\"type\":\"liquidFill\",\"shape\":\"circle\",\"radius\":\"80%\",\"data\":[0.67],\"center\":[\"50%\",\"50%\"],\"color\":[{\"type\":\"linear\",\"x\":0,\"y\":0,\"x2\":0,\"y2\":1,\"colorStops\":[{\"offset\":0,\"color\":\"#4992ff\"},{\"offset\":1,\"color\":\"#7cffb2\"}],\"globalCoord\":false}],\"backgroundStyle\":{\"borderWidth\":1,\"color\":\"rgba(68, 181, 226, 0.3)\"},\"label\":{\"normal\":{\"textStyle\":{\"fontSize\":32,\"color\":\"#fff\"}}},\"outline\":{\"show\":false,\"borderDistance\":10,\"itemStyle\":{\"borderWidth\":2,\"borderColor\":\"#112165\"}}}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10016\",\"title\":\"项目过程-项目延期率\",\"type\":\"WaterPolo\"},{\"id\":\"5czvzl4a3qs000\",\"isGroup\":false,\"attr\":{\"x\":959,\"y\":439,\"w\":332,\"h\":200,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"WaterPolo\",\"chartConfig\":{\"key\":\"WaterPolo\",\"chartKey\":\"VWaterPolo\",\"conKey\":\"VCWaterPolo\",\"title\":\"项目过程-执行延期率\",\"category\":\"WaterPolo\",\"categoryName\":\"水球图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"water_WaterPolo.png\",\"sourceID\":\"10017\",\"fields\":null,\"filters\":[],\"dataset\":0},\"option\":{\"dataset\":0.6667,\"series\":[{\"type\":\"liquidFill\",\"shape\":\"circle\",\"radius\":\"80%\",\"data\":[0.67],\"center\":[\"50%\",\"50%\"],\"color\":[{\"type\":\"linear\",\"x\":0,\"y\":0,\"x2\":0,\"y2\":1,\"colorStops\":[{\"offset\":0,\"color\":\"#4992ff\"},{\"offset\":1,\"color\":\"#7cffb2\"}],\"globalCoord\":false}],\"backgroundStyle\":{\"borderWidth\":1,\"color\":\"rgba(68, 181, 226, 0.3)\"},\"label\":{\"normal\":{\"textStyle\":{\"fontSize\":32,\"color\":\"#fff\"}}},\"outline\":{\"show\":false,\"borderDistance\":10,\"itemStyle\":{\"borderWidth\":2,\"borderColor\":\"#112165\"}}}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10017\",\"title\":\"项目过程-执行延期率\",\"type\":\"WaterPolo\"},{\"id\":\"3rrf13x8aig000\",\"isGroup\":false,\"attr\":{\"x\":68,\"y\":626,\"w\":332,\"h\":50,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"项目按期完成率\",\"fontSize\":16,\"fontColor\":\"#ffffff\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2fj8shp4iww000\",\"isGroup\":false,\"attr\":{\"x\":349,\"y\":626,\"w\":332,\"h\":50,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"执行按期完成率\",\"fontSize\":16,\"fontColor\":\"#ffffff\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"7c0kw504pfo00\",\"isGroup\":false,\"attr\":{\"x\":680,\"y\":626,\"w\":332,\"h\":50,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"项目延期率\",\"fontSize\":16,\"fontColor\":\"#ffffff\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3tdqudx15lm000\",\"isGroup\":false,\"attr\":{\"x\":959,\"y\":626,\"w\":332,\"h\":50,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"执行延期率\",\"fontSize\":16,\"fontColor\":\"#ffffff\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"15v07f9mllz400\",\"isGroup\":false,\"attr\":{\"x\":\"27\",\"y\":120,\"w\":242,\"h\":\"58\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"年度完成项目数据盘点\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"5rscm33a7a0000\",\"isGroup\":false,\"attr\":{\"x\":916,\"y\":8,\"w\":450,\"h\":75,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates04\",\"chartConfig\":{\"key\":\"Decorates04\",\"chartKey\":\"VDecorates04\",\"conKey\":\"VCDecorates04\",\"title\":\"装饰-04\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates04.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#1dc1f5\",\"#1dc1f5\"],\"reverse\":false}},{\"id\":\"48vgwd3xywc000\",\"isGroup\":false,\"attr\":{\"x\":2,\"y\":8,\"w\":450,\"h\":75,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates04\",\"chartConfig\":{\"key\":\"Decorates04\",\"chartKey\":\"VDecorates04\",\"conKey\":\"VCDecorates04\",\"title\":\"装饰-04\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates04.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#1dc1f5\",\"#1dc1f5\"],\"reverse\":true}},{\"id\":\"34gsoca72ak000\",\"isGroup\":false,\"attr\":{\"x\":450,\"y\":55,\"w\":466,\"h\":50,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates05\",\"chartConfig\":{\"key\":\"Decorates05\",\"chartKey\":\"VDecorates05\",\"conKey\":\"VCDecorates05\",\"title\":\"装饰-05\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates05.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#00c2ff\",\"#00c2ff4d\"],\"dur\":3}},{\"id\":\"5emz0hdi03k000\",\"isGroup\":false,\"attr\":{\"x\":1,\"y\":-2,\"w\":1365,\"h\":48,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#1089FF42\",\"#1089FF00\"],\"backgroundColor\":\"#00000000\"}},{\"id\":\"afw1xcxn3ug00\",\"isGroup\":false,\"attr\":{\"x\":433,\"y\":7,\"w\":500,\"h\":64,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"年度完成项目过程数据大屏\",\"fontSize\":28,\"fontColor\":\"#b2d5e5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"2v5j91if94k000\",\"isGroup\":false,\"attr\":{\"x\":18,\"y\":1236,\"w\":1326,\"h\":528,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"3h6cqs958r6000\",\"isGroup\":false,\"attr\":{\"x\":\"272\",\"y\":\"1240\",\"w\":\"1040\",\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"4p2d6bkzx2m000\",\"isGroup\":false,\"attr\":{\"x\":\"40\",\"y\":\"1240\",\"w\":\"240\",\"h\":\"60\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成项目工期透视表\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"53verjpnwh8000\",\"isGroup\":false,\"attr\":{\"x\":22,\"y\":2347,\"w\":653,\"h\":619,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"5rg2qtyfzno000\",\"isGroup\":false,\"attr\":{\"x\":691,\"y\":2347,\"w\":653,\"h\":617,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"4gf68m6chq4000\",\"isGroup\":false,\"attr\":{\"x\":20,\"y\":2991,\"w\":1326,\"h\":580,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"1t16zb563uzk00\",\"isGroup\":false,\"attr\":{\"x\":53,\"y\":1312,\"w\":1263,\"h\":420,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"TableMergeCell\",\"chartConfig\":{\"key\":\"TableMergeCell\",\"chartKey\":\"VTableMergeCell\",\"conKey\":\"VCTableMergeCell\",\"title\":\"完成项目工期透视表\",\"category\":\"Tables\",\"categoryName\":\"列表\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"table_scrollboard.png\",\"sourceID\":\"1000\",\"fields\":{},\"filters\":[{\"field\":\"closedDate\",\"type\":\"date\",\"name\":\"关闭日期\",\"default\":null}],\"dataset\":[],\"tableInfo\":{}},\"option\":{\"dataset\":[],\"header\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"columnWidth\":[],\"rowspan\":{},\"colspan\":[],\"evenRowBGC\":\"#FFFFFF00\",\"oddRowBGC\":\"#1089FF1A\",\"headerBGC\":\"#4498EC85\"},\"sourceID\":\"1000\",\"title\":\"完成项目工期透视表\",\"type\":\"table\"},{\"id\":\"12km9ka7t40g00\",\"isGroup\":false,\"attr\":{\"x\":18,\"y\":1788,\"w\":1326,\"h\":528,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Border06\",\"chartConfig\":{\"key\":\"Border06\",\"chartKey\":\"VBorder06\",\"conKey\":\"VCBorder06\",\"title\":\"边框-06\",\"category\":\"Borders\",\"categoryName\":\"边框\",\"package\":\"Decorates\",\"image\":\"border06.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#3140AD00\",\"#1089FF12\"],\"backgroundColor\":\"#1089FF12\"}},{\"id\":\"4wxuogwx6he000\",\"isGroup\":false,\"attr\":{\"x\":236,\"y\":726,\"w\":242,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"项目完成分布图\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"5n8bpai3kcw000\",\"isGroup\":false,\"attr\":{\"x\":\"60\",\"y\":\"2440\",\"w\":\"580\",\"h\":\"500\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"项目过程-完成项目工期偏差条形图\",\"category\":\"Bars\",\"categoryName\":\"柱状图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"bar_y.png\",\"sourceID\":\"10018\",\"fields\":{},\"filters\":[{\"field\":\"name\",\"type\":\"input\",\"name\":\"项目名称\",\"default\":\"\"}],\"dataset\":{}},\"option\":{\"legend\":{\"show\":true,\"top\":40,\"textStyle\":{\"color\":\"#B9B8CE\"},\"left\":\"center\"},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":70,\"right\":\"10%\",\"bottom\":\"60\"},\"title\":{\"text\":\"项目过程-完成项目工期偏差条形图\",\"show\":false,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14},\"top\":10,\"x\":\"center\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{},\"series\":[{\"type\":\"bar\",\"barWidth\":null,\"label\":{\"show\":true,\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10018\",\"title\":\"完成项目工期偏差条形图\",\"type\":\"cluBarY\"},{\"id\":\"5q7zvaotgyo000\",\"isGroup\":false,\"attr\":{\"x\":724,\"y\":\"2440\",\"w\":\"580\",\"h\":\"500\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"BarCrossrange\",\"chartConfig\":{\"key\":\"BarCrossrange\",\"chartKey\":\"VBarCrossrange\",\"conKey\":\"VCBarCrossrange\",\"title\":\"项目过程-完成项目工期偏差条形图\",\"category\":\"Bars\",\"categoryName\":\"柱状图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"bar_y.png\",\"sourceID\":\"10022\",\"fields\":{},\"filters\":[{\"field\":\"name\",\"type\":\"input\",\"name\":\"项目名称\",\"default\":\"\"}],\"dataset\":{}},\"option\":{\"legend\":{\"show\":true,\"top\":40,\"textStyle\":{\"color\":\"#B9B8CE\"},\"left\":\"center\"},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":70,\"right\":\"10%\",\"bottom\":\"60\"},\"title\":{\"text\":\"项目过程-完成项目工期偏差条形图\",\"show\":false,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14},\"top\":10,\"x\":\"center\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{},\"series\":[{\"type\":\"bar\",\"barWidth\":null,\"label\":{\"show\":true,\"position\":\"right\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":0}}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10022\",\"title\":\"完成项目工期偏差条形图\",\"type\":\"cluBarY\"},{\"id\":\"37kkzy05o6u000\",\"isGroup\":false,\"attr\":{\"x\":\"48\",\"y\":\"3100\",\"w\":1265,\"h\":\"420\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"BarCommon\",\"chartConfig\":{\"key\":\"BarCommon\",\"chartKey\":\"VBarCommon\",\"conKey\":\"VCBarCommon\",\"title\":\"项目过程-单位工时交付需求规模数对比图\",\"category\":\"Bars\",\"categoryName\":\"柱状图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"bar_x.png\",\"sourceID\":\"10019\",\"fields\":{},\"filters\":[{\"field\":\"project\",\"type\":\"input\",\"name\":\"所属项目\",\"default\":\"\"}],\"dataset\":{}},\"option\":{\"legend\":{\"show\":true,\"top\":40,\"textStyle\":{\"color\":\"#B9B8CE\"},\"left\":\"center\"},\"xAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"bottom\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":false,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"category\"},\"yAxis\":{\"show\":true,\"name\":\"\",\"nameGap\":15,\"nameTextStyle\":{\"color\":\"#B9B8CE\",\"fontSize\":12},\"inverse\":false,\"axisLabel\":{\"show\":true,\"fontSize\":12,\"color\":\"#B9B8CE\",\"rotate\":0},\"position\":\"left\",\"axisLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#B9B8CE\",\"width\":1},\"onZero\":true},\"axisTick\":{\"show\":true,\"length\":5},\"splitLine\":{\"show\":true,\"lineStyle\":{\"color\":\"#484753\",\"width\":1,\"type\":\"solid\"}},\"type\":\"value\"},\"grid\":{\"show\":false,\"left\":\"10%\",\"top\":90,\"right\":\"10%\",\"bottom\":\"60\"},\"title\":{\"text\":\"项目过程-单位工时交付需求规模数对比图\",\"show\":false,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14},\"top\":10,\"x\":\"center\"},\"tooltip\":{\"show\":true,\"trigger\":\"axis\",\"axisPointer\":{\"show\":true,\"type\":\"shadow\"}},\"dataset\":{},\"series\":[{\"type\":\"bar\",\"barWidth\":15,\"label\":{\"show\":true,\"position\":\"top\",\"color\":\"#fff\",\"fontSize\":12},\"itemStyle\":{\"color\":null,\"borderRadius\":2}}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10019\",\"title\":\"单位工时交付需求规模数对比图\",\"type\":\"cluBarX\"},{\"id\":\"58diyfly21g000\",\"isGroup\":false,\"attr\":{\"x\":900,\"y\":726,\"w\":242,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"执行完成分布图\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"4y4a1x55hh4000\",\"isGroup\":false,\"attr\":{\"x\":\"60\",\"y\":\"734\",\"w\":\"182\",\"h\":\"40\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"5txcqlq213g000\",\"isGroup\":false,\"attr\":{\"x\":\"460\",\"y\":\"734\",\"w\":\"182\",\"h\":\"40\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"5oxxiekui1c000\",\"isGroup\":false,\"attr\":{\"x\":\"724\",\"y\":\"734\",\"w\":\"182\",\"h\":\"33\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"3u3w3sejwiu000\",\"isGroup\":false,\"attr\":{\"x\":1134,\"y\":\"734\",\"w\":182,\"h\":\"40\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"579d65hwr6c00\",\"isGroup\":false,\"attr\":{\"x\":\"64\",\"y\":\"790\",\"w\":\"560\",\"h\":400,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"PieCommon\",\"chartConfig\":{\"key\":\"PieCommon\",\"chartKey\":\"VPieCommon\",\"conKey\":\"VCPieCommon\",\"title\":\"项目过程-项目完成分布图\",\"category\":\"Pies\",\"categoryName\":\"饼图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"pie.png\",\"sourceID\":\"10020\",\"fields\":{},\"filters\":[{\"field\":\"closedDate\",\"type\":\"date\",\"name\":\"关闭日期\",\"default\":null}],\"dataset\":{}},\"option\":{\"legend\":{\"show\":true,\"top\":30,\"textStyle\":{\"color\":\"#B9B8CE\"},\"left\":\"center\"},\"title\":{\"text\":\"项目过程-项目完成分布图\",\"show\":false,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14},\"top\":10,\"x\":\"center\"},\"type\":\"nomal\",\"tooltip\":{\"show\":true,\"trigger\":\"item\"},\"grid\":{\"top\":70},\"dataset\":{},\"series\":[{\"type\":\"pie\",\"radius\":\"70%\",\"center\":[\"50%\",\"60%\"],\"label\":{\"show\":true,\"formatter\":\"{b} {d}%\",\"fontSize\":12,\"color\":\"#fff\",\"shadowColor\":\"transparent\"},\"roseType\":false}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10020\",\"title\":\"项目完成分布图\",\"type\":\"pie\"},{\"id\":\"1ei55qri4gu800\",\"isGroup\":false,\"attr\":{\"x\":\"736\",\"y\":\"790\",\"w\":\"560\",\"h\":\"400\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"PieCommon\",\"chartConfig\":{\"key\":\"PieCommon\",\"chartKey\":\"VPieCommon\",\"conKey\":\"VCPieCommon\",\"title\":\"项目过程-执行完成分布图\",\"category\":\"Pies\",\"categoryName\":\"饼图\",\"package\":\"Charts\",\"chartFrame\":\"echarts\",\"image\":\"pie.png\",\"sourceID\":\"10021\",\"fields\":{},\"filters\":[{\"field\":\"closedDate\",\"type\":\"date\",\"name\":\"关闭日期\",\"default\":null}],\"dataset\":{}},\"option\":{\"legend\":{\"show\":true,\"top\":30,\"textStyle\":{\"color\":\"#B9B8CE\"},\"left\":\"center\"},\"title\":{\"text\":\"项目过程-执行完成分布图\",\"show\":false,\"textStyle\":{\"color\":\"#BFBFBF\",\"fontSize\":18},\"subtextStyle\":{\"color\":\"#A2A2A2\",\"fontSize\":14},\"top\":10,\"x\":\"center\"},\"type\":\"nomal\",\"tooltip\":{\"show\":true,\"trigger\":\"item\"},\"grid\":{\"top\":70},\"dataset\":{},\"series\":[{\"type\":\"pie\",\"radius\":\"70%\",\"center\":[\"50%\",\"60%\"],\"label\":{\"show\":true,\"formatter\":\"{b} {d}%\",\"fontSize\":12,\"color\":\"#fff\",\"shadowColor\":\"transparent\"},\"roseType\":false}],\"backgroundColor\":\"rgba(0,0,0,0)\"},\"sourceID\":\"10021\",\"title\":\"执行完成分布图\",\"type\":\"pie\"},{\"id\":\"2flxymehju8000\",\"isGroup\":false,\"attr\":{\"x\":\"272\",\"y\":\"1794\",\"w\":\"1036\",\"h\":\"60\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"5scfjzqsbzo000\",\"isGroup\":true,\"attr\":{\"w\":300,\"h\":120,\"x\":277,\"y\":133,\"offsetX\":0,\"offsetY\":0,\"zIndex\":-1,\"lockScale\":false},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"chartConfig\":{\"key\":\"group\",\"chartKey\":\"group\",\"conKey\":\"group\",\"category\":\"group\",\"categoryName\":\"group\",\"package\":\"group\",\"chartFrame\":\"common\",\"title\":\"u6807u9898\",\"image\":\"\",\"dataset\":[]},\"groupList\":[{\"id\":\"2xjom2cw2b2000\",\"isGroup\":false,\"attr\":{\"x\":0,\"y\":0,\"w\":100,\"h\":120,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"Select\",\"chartConfig\":{\"key\":\"Select\",\"chartKey\":\"VSelect\",\"conKey\":\"VCSelect\",\"title\":\"u9009u62e9\",\"category\":\"Mores\",\"categoryName\":\"u66f4u591a\",\"package\":\"Informations\",\"chartFrame\":\"common\",\"image\":\"static/png/select-c616737a.png\"},\"option\":{\"dataset\":[{\"label\":\"2023\",\"value\":\"2023\"},{\"label\":2022,\"value\":2022},{\"label\":2021,\"value\":2021},{\"label\":2020,\"value\":2020},{\"label\":2019,\"value\":2019},{\"label\":2018,\"value\":2018},{\"label\":2017,\"value\":2017},{\"label\":2016,\"value\":2016},{\"label\":2015,\"value\":2015},{\"label\":2014,\"value\":2014},{\"label\":2013,\"value\":2013},{\"label\":2012,\"value\":2012},{\"label\":2011,\"value\":2011},{\"label\":2010,\"value\":2010},{\"label\":2009,\"value\":2009}],\"value\":\"\",\"borderWidth\":1,\"borderStyle\":\"solid\",\"borderColor\":\"#1a77a5\",\"background\":\"none\",\"borderRadius\":6,\"color\":\"#ffffff\",\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"backgroundColor\":\"transparent\",\"fontSize\":20,\"onChange\":\"window.location.href = createLink(\'screen\', \'view\', \'screenID=6&year=\' + value + \'&dept=&account=\')\"},\"type\":\"year\",\"filterCharts\":[{\"chart\":10000,\"field\":\"t1.`year`\"},{\"chart\":10001,\"field\":\"t1.`year`\"},{\"chart\":10002,\"field\":\"t1.`year`\"},{\"chart\":10003,\"field\":\"t1.`year`\"},{\"chart\":10004,\"field\":\"t1.`year`\"},{\"chart\":10005,\"field\":\"t1.`year`\"},{\"chart\":10006,\"field\":\"t1.`year`\"},{\"chart\":10007,\"field\":\"t1.`year`\"},{\"chart\":10008,\"field\":\"t1.`year`\"},{\"chart\":10009,\"field\":\"t1.`year`\"},{\"chart\":10010,\"field\":\"t1.`year`\"},{\"chart\":10011,\"field\":\"t1.`year`\"},{\"chart\":10012,\"field\":\"t1.`year`\"},{\"chart\":10013,\"field\":\"t1.`year`\"},{\"chart\":10014,\"field\":\"t1.`year`\"},{\"chart\":10015,\"field\":\"t1.`year`\"},{\"chart\":10016,\"field\":\"t1.`year`\"},{\"chart\":10017,\"field\":\"t1.`year`\"}]}],\"key\":\"group\",\"option\":{}},{\"id\":\"12pr64gobork00\",\"isGroup\":false,\"attr\":{\"x\":424,\"y\":120,\"w\":882,\"h\":60,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\",\"chartFrame\":\"static\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"436oj64jvca000\",\"isGroup\":false,\"attr\":{\"x\":\"32\",\"y\":2362,\"w\":\"240\",\"h\":\"60\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成项目工期偏差\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"1ahevk1yw0tc00\",\"isGroup\":false,\"attr\":{\"x\":\"268\",\"y\":\"2362\",\"w\":\"376\",\"h\":\"60\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"4kcpsj6i5q8000\",\"isGroup\":false,\"attr\":{\"x\":698,\"y\":\"2362\",\"w\":\"240\",\"h\":\"60\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成项目工时偏差\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"5dijh3989bg000\",\"isGroup\":false,\"attr\":{\"x\":\"940\",\"y\":\"2362\",\"w\":\"376\",\"h\":\"60\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\"},\"option\":{\"colors\":[\"#A9CDF3FF\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"17o4abp7p68w00\",\"isGroup\":false,\"attr\":{\"x\":\"32\",\"y\":3014,\"w\":\"460\",\"h\":\"60\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成项目单位工时交付需求规模数对比\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":5,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"4f1dpys6drq000\",\"isGroup\":false,\"attr\":{\"x\":\"500\",\"y\":\"3014\",\"w\":\"820\",\"h\":\"60\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"Decorates02\",\"chartConfig\":{\"key\":\"Decorates02\",\"chartKey\":\"VDecorates02\",\"conKey\":\"VCDecorates02\",\"title\":\"装饰-02\",\"category\":\"Decorates\",\"categoryName\":\"装饰\",\"package\":\"Decorates\",\"image\":\"decorates02.png\"},\"option\":{\"colors\":[\"#ffffff4d\",\"#1DC1F5FF\"],\"dur\":3,\"lineHeight\":3}},{\"id\":\"4dhr11orgts000\",\"isGroup\":false,\"attr\":{\"x\":\"40\",\"y\":\"1794\",\"w\":\"240\",\"h\":\"60\",\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestInterval\":null,\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"filter\":null,\"events\":{\"baseEvent\":{\"click\":null,\"dblclick\":null,\"mouseenter\":null,\"mouseleave\":null},\"advancedEvents\":{\"vnodeMounted\":null,\"vnodeBeforeMount\":null},\"interactEvents\":[]},\"key\":\"TextCommon\",\"chartConfig\":{\"key\":\"TextCommon\",\"chartKey\":\"VTextCommon\",\"conKey\":\"VCTextCommon\",\"title\":\"文字\",\"category\":\"Texts\",\"categoryName\":\"文本\",\"package\":\"Informations\",\"image\":\"text_static.png\",\"chartFrame\":\"common\"},\"option\":{\"link\":\"\",\"linkHead\":\"http://\",\"dataset\":\"完成项目工时透视表\",\"fontSize\":20,\"fontColor\":\"#B2D5E5FF\",\"paddingX\":10,\"paddingY\":10,\"textAlign\":\"center\",\"fontWeight\":\"normal\",\"borderWidth\":0,\"borderColor\":\"#ffffff\",\"borderRadius\":5,\"letterSpacing\":2,\"writingMode\":\"horizontal-tb\",\"backgroundColor\":\"#00000000\"}},{\"id\":\"3j6atjdm7co000\",\"isGroup\":false,\"attr\":{\"x\":50,\"y\":1861,\"w\":1257,\"h\":428,\"offsetX\":0,\"offsetY\":0,\"lockScale\":false,\"zIndex\":-1},\"styles\":{\"filterShow\":false,\"hueRotate\":0,\"saturate\":1,\"contrast\":1,\"brightness\":1,\"opacity\":1,\"rotateZ\":0,\"rotateX\":0,\"rotateY\":0,\"skewX\":0,\"skewY\":0,\"blendMode\":\"normal\",\"animations\":[]},\"preview\":{\"overFlowHidden\":false},\"status\":{\"lock\":false,\"hide\":false},\"request\":{\"requestDataType\":0,\"requestHttpType\":\"get\",\"requestUrl\":\"\",\"requestIntervalUnit\":\"second\",\"requestContentType\":0,\"requestParamsBodyType\":\"none\",\"requestSQLContent\":{\"sql\":\"select * from  where\"},\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}},\"events\":{\"baseEvent\":{},\"advancedEvents\":{}},\"key\":\"TableMergeCell\",\"chartConfig\":{\"key\":\"TableMergeCell\",\"chartKey\":\"VTableMergeCell\",\"conKey\":\"VCTableMergeCell\",\"title\":\"完成项目工时透视表\",\"category\":\"Tables\",\"categoryName\":\"列表\",\"package\":\"Tables\",\"chartFrame\":\"common\",\"image\":\"table_scrollboard.png\",\"sourceID\":\"1001\",\"fields\":{},\"filters\":[{\"field\":\"closedDate\",\"type\":\"date\",\"name\":\"关闭日期\",\"default\":null}],\"dataset\":[],\"tableInfo\":{}},\"option\":{\"dataset\":[],\"header\":[],\"align\":[\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"],\"columnWidth\":[],\"rowspan\":{},\"colspan\":[],\"oddRowBGC\":\"#1089FF1A\",\"headerBGC\":\"#4498EC85\",\"evenRowBGC\":\"#00000000\"},\"sourceID\":\"1001\",\"title\":\"完成项目工时透视表\",\"type\":\"table\"}],\"requestGlobalConfig\":{\"requestDataPond\":[],\"requestOriginUrl\":\"\",\"requestInterval\":30,\"requestIntervalUnit\":\"second\",\"requestParams\":{\"Body\":{\"form-data\":{},\"x-www-form-urlencoded\":{},\"json\":\"\",\"xml\":\"\"},\"Header\":{},\"Params\":{}}}}' WHERE `id` = 6;

ALTER TABLE `zt_review` MODIFY `doc` varchar(255) DEFAULT '';
ALTER TABLE `zt_review` MODIFY `docVersion` varchar(255) DEFAULT '';

DELETE FROM `zt_cron` WHERE command='moduleName=measurement&methodName=initCrontabQueue';
DELETE FROM `zt_cron` WHERE command='moduleName=measurement&methodName=execCrontabQueue';

ALTER TABLE `zt_artifactrepo` MODIFY `name` varchar(45) NOT NULL DEFAULT '';
ALTER TABLE `zt_artifactrepo` MODIFY `products` varchar(255) NOT NULL DEFAULT '';
ALTER TABLE `zt_artifactrepo` MODIFY `serverID` smallint(8) NOT NULL DEFAULT 0;
ALTER TABLE `zt_artifactrepo` MODIFY `repoName` varchar(45) NOT NULL DEFAULT '';
ALTER TABLE `zt_artifactrepo` MODIFY `format` varchar(10) NOT NULL DEFAULT '';
ALTER TABLE `zt_artifactrepo` MODIFY `type` char(7) NOT NULL DEFAULT '';
ALTER TABLE `zt_artifactrepo` MODIFY `status` varchar(10) NOT NULL DEFAULT '';
ALTER TABLE `zt_artifactrepo` MODIFY `createdBy` varchar(30) NOT NULL DEFAULT '';
ALTER TABLE `zt_artifactrepo` MODIFY `editedBy` varchar(30) NOT NULL DEFAULT '';
ALTER TABLE `zt_artifactrepo` MODIFY `deleted` tinyint(4) UNSIGNED NOT NULL DEFAULT 0;

ALTER TABLE `zt_space` MODIFY `createdAt` datetime NULL;
ALTER TABLE `zt_space` MODIFY `name` varchar(200) NOT NULL DEFAULT '';
ALTER TABLE `zt_space` MODIFY `k8space` char(64) NOT NULL DEFAULT '';
ALTER TABLE `zt_space` MODIFY `owner` char(30) NOT NULL DEFAULT '';

ALTER TABLE `zt_instance` MODIFY `name` char(50) NOT NULL DEFAULT '';
ALTER TABLE `zt_instance` MODIFY `logo` varchar(255) NOT NULL DEFAULT '';
ALTER TABLE `zt_instance` MODIFY `desc` text NULL;
ALTER TABLE `zt_instance` MODIFY `introduction` text NULL;
ALTER TABLE `zt_instance` MODIFY `channel` char(20) NOT NULL DEFAULT '';
ALTER TABLE `zt_instance` MODIFY `smtpSnippetName` char(30) NOT NULL DEFAULT '';
ALTER TABLE `zt_instance` MODIFY `ldapSnippetName` char(30) NOT NULL DEFAULT '';
ALTER TABLE `zt_instance` MODIFY `ldapSettings` text NULL;
ALTER TABLE `zt_instance` MODIFY `dbSettings` text NULL;
ALTER TABLE `zt_instance` MODIFY `env` text NULL;
ALTER TABLE `zt_instance` MODIFY `createdAt` datetime NULL;

ALTER TABLE `zt_solution` MODIFY `name` char(50) NOT NULL DEFAULT '';
ALTER TABLE `zt_solution` MODIFY `appID` mediumint(8) unsigned NOT NULL DEFAULT 0;
ALTER TABLE `zt_solution` MODIFY `appName` char(50) NOT NULL DEFAULT '';
ALTER TABLE `zt_solution` MODIFY `appVersion` char(20) NOT NULL DEFAULT '';
ALTER TABLE `zt_solution` MODIFY `version` char(50) NOT NULL DEFAULT '';
ALTER TABLE `zt_solution` MODIFY `chart` char(50) NOT NULL DEFAULT '';
ALTER TABLE `zt_solution` MODIFY `cover` varchar(255) NOT NULL DEFAULT '';
ALTER TABLE `zt_solution` MODIFY `desc` text NULL;
ALTER TABLE `zt_solution` MODIFY `introduction` varchar(255) NOT NULL DEFAULT '';
ALTER TABLE `zt_solution` MODIFY `source` char(20) NOT NULL DEFAULT '';
ALTER TABLE `zt_solution` MODIFY `channel` char(20) NOT NULL DEFAULT '';
ALTER TABLE `zt_solution` MODIFY `components` text NULL;
ALTER TABLE `zt_solution` MODIFY `status` char(20) NOT NULL DEFAULT '';
ALTER TABLE `zt_solution` MODIFY `createdBy` char(30) NOT NULL DEFAULT '';
ALTER TABLE `zt_solution` MODIFY `createdAt` datetime NULL;

UPDATE `zt_chart` SET `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"YEARMONTH\",\"name\":\"YEARMONTH\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"newStory\",\"name\":\"\\u7ee7\\u7eed\\u6dfb\\u52a0\\u7814\\u53d1\\u9700\\u6c42\",\"valOrAgg\":\"sum\"},{\"field\":\"closedStory\",\"name\":\"\\u9700\\u6c42\\uff1a%s \\u5df2\\u5173\\u95ed\\uff0c\\u5c06\\u4e0d\\u4f1a\\u88ab\\u5173\\u95ed\\u3002\",\"valOrAgg\":\"sum\"}],\"rotateX\":\"notuse\"}]', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u5ea6\"}]', `fields` = '{\"YEARMONTH\":{\"name\":\"YEARMONTH\",\"object\":\"story\",\"field\":\"YEARMONTH\",\"type\":\"string\"},\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"story\",\"field\":\"month\",\"type\":\"number\"},\"newStory\":{\"name\":\"\\u7ee7\\u7eed\\u6dfb\\u52a0\\u7814\\u53d1\\u9700\\u6c42\",\"object\":\"story\",\"field\":\"newStory\",\"type\":\"string\"},\"closedStory\":{\"name\":\"\\u9700\\u6c42\\uff1a%s \\u5df2\\u5173\\u95ed\\uff0c\\u5c06\\u4e0d\\u4f1a\\u88ab\\u5173\\u95ed\\u3002\",\"object\":\"story\",\"field\":\"closedStory\",\"type\":\"string\"}}', `langs` = '{\"YEARMONTH\":{\"zh-cn\":\"YEARMONTH\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"year\":{\"zh-cn\":\"\\u5e74\\u5ea6\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u4efd\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"newStory\":{\"zh-cn\":\"\\u65b0\\u589e\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"closedStory\":{\"zh-cn\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT t1.YEARMONTH, t1.year, t1.month AS `month`, IFNULL(t2.story, 0) AS newStory, IFNULL(t3.story, 0) AS closedStory\nFROM (SELECT DISTINCT DATE_FORMAT(date, \'%Y-%m\') YEARMONTH, Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS story FROM zt_story WHERE deleted = \'0\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS story FROM zt_story WHERE deleted = \'0\' AND closedReason = \'done\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\nORDER BY `year`, t1.month' WHERE `name` = '年度新增-需求年度新增和完成趋势图';
UPDATE `zt_chart` SET `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"YEARMONTH\",\"name\":\"YEARMONTH\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"newBug\",\"name\":\"newBug\",\"valOrAgg\":\"sum\"},{\"field\":\"fixedBug\",\"name\":\"fixedBug\",\"valOrAgg\":\"sum\"}]}]', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u5ea6\"}]', `fields` = '{\"YEARMONTH\":{\"name\":\"YEARMONTH\",\"object\":\"bug\",\"field\":\"YEARMONTH\",\"type\":\"string\"},\"year\":{\"name\":\"year\",\"object\":\"bug\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"bug\",\"field\":\"month\",\"type\":\"number\"},\"newBug\":{\"name\":\"newBug\",\"object\":\"bug\",\"field\":\"newBug\",\"type\":\"string\"},\"fixedBug\":{\"name\":\"fixedBug\",\"object\":\"bug\",\"field\":\"fixedBug\",\"type\":\"string\"}}', `langs` = '{\"YEARMONTH\":{\"zh-cn\":\"\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"year\":{\"zh-cn\":\"\\u5e74\\u5ea6\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u4efd\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"newBug\":{\"zh-cn\":\"\\u65b0\\u589eBug\\u6570\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"fixedBug\":{\"zh-cn\":\"\\u89e3\\u51b3Bug\\u6570\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT YEARMONTH, t1.year, t1.month AS `month`, IFNULL(t2.bug, 0) AS newBug, IFNULL(t3.bug, 0) AS fixedBug\nFROM (SELECT DISTINCT DATE_FORMAT(date, \'%Y-%m\') YEARMONTH, Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS bug FROM zt_bug WHERE deleted = \'0\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS bug FROM zt_bug WHERE deleted = \'0\' AND resolution = \'fixed\' AND status = \'closed\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\nORDER BY `year`, t1.month' WHERE `name` = '年度新增-Bug年度新增和解决趋势图';
UPDATE `zt_chart` SET `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"YEARMONTH\",\"name\":\"YEARMONTH\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"newTask\",\"name\":\"newTask\",\"valOrAgg\":\"sum\"},{\"field\":\"closedTask\",\"name\":\"closedTask\",\"valOrAgg\":\"sum\"}]}]', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u5ea6\"}]', `fields` = '{\"YEARMONTH\":{\"name\":\"YEARMONTH\",\"object\":\"task\",\"field\":\"YEARMONTH\",\"type\":\"string\"},\"year\":{\"name\":\"year\",\"object\":\"task\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"task\",\"field\":\"month\",\"type\":\"string\"},\"newTask\":{\"name\":\"newTask\",\"object\":\"task\",\"field\":\"newTask\",\"type\":\"string\"},\"closedTask\":{\"name\":\"closedTask\",\"object\":\"task\",\"field\":\"closedTask\",\"type\":\"string\"}}', `langs` = '{\"YEARMONTH\":{\"zh-cn\":\"YEARMONTH\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"year\":{\"zh-cn\":\"\\u5e74\\u5ea6\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u4efd\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"newTask\":{\"zh-cn\":\"\\u65b0\\u589e\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"closedTask\":{\"zh-cn\":\"\\u5b8c\\u6210\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT YEARMONTH, t1.year, CONCAT(t1.month, \"月\") AS `month`, IFNULL(t2.task, 0) AS newTask, IFNULL(t3.task, 0) AS closedTask\nFROM (SELECT DISTINCT DATE_FORMAT(date, \'%Y-%m\') YEARMONTH, Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS task FROM zt_task WHERE deleted = \'0\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS task FROM zt_task WHERE deleted = \'0\' AND status = \'closed\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\nORDER BY `year`, t1.month' WHERE `name` = '年度新增-任务年度新增和完成趋势图';
UPDATE `zt_chart` SET `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"YEARMONTH\",\"name\":\"YEARMONTH\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"newProject\",\"name\":\"newProject\",\"valOrAgg\":\"sum\"},{\"field\":\"closedProject\",\"name\":\"\\u5df2\\u5173\\u95ed\\u7684\\u9879\\u76ee\",\"valOrAgg\":\"sum\"}]}]', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u5ea6\"}]', `fields` = '{\"YEARMONTH\":{\"name\":\"YEARMONTH\",\"object\":\"project\",\"field\":\"YEARMONTH\",\"type\":\"string\"},\"year\":{\"name\":\"year\",\"object\":\"project\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"project\",\"field\":\"month\",\"type\":\"string\"},\"newProject\":{\"name\":\"newProject\",\"object\":\"project\",\"field\":\"newProject\",\"type\":\"string\"},\"closedProject\":{\"name\":\"\\u5df2\\u5173\\u95ed\\u7684\\u9879\\u76ee\",\"object\":\"project\",\"field\":\"closedProject\",\"type\":\"string\"}}', `langs` = '{\"YEARMONTH\":{\"zh-cn\":\"YEARMONTH\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"year\":{\"zh-cn\":\"\\u5e74\\u5ea6\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u4efd\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"newProject\":{\"zh-cn\":\"\\u65b0\\u589e\\u9879\\u76ee\\u6570\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"closedProject\":{\"zh-cn\":\"\\u5b8c\\u6210\\u9879\\u76ee\\u6570\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT YEARMONTH, t1.year, CONCAT(t1.month, \"月\") AS `month`, IFNULL(t2.project, 0) AS newProject, IFNULL(t3.project, 0) AS closedProject\nFROM (SELECT DISTINCT DATE_FORMAT(date, \'%Y-%m\') YEARMONTH, Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS project FROM zt_project WHERE deleted = \'0\' AND type = \'project\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS project FROM zt_project WHERE deleted = \'0\' AND type = \'project\' AND status = \'closed\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\nORDER BY `year`, t1.month' WHERE `name` = '年度新增-项目年度新增和完成趋势图';
UPDATE `zt_chart` SET `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"YEARMONTH\",\"name\":\"YEARMONTH\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"newExecution\",\"name\":\"newExecution\",\"valOrAgg\":\"sum\"},{\"field\":\"closedExecution\",\"name\":\"closedExecution\",\"valOrAgg\":\"sum\"}]}]', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u5ea6\"}]', `fields` = '{\"YEARMONTH\":{\"name\":\"YEARMONTH\",\"object\":\"project\",\"field\":\"YEARMONTH\",\"type\":\"string\"},\"year\":{\"name\":\"year\",\"object\":\"project\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"project\",\"field\":\"month\",\"type\":\"string\"},\"newExecution\":{\"name\":\"newExecution\",\"object\":\"project\",\"field\":\"newExecution\",\"type\":\"string\"},\"closedExecution\":{\"name\":\"closedExecution\",\"object\":\"project\",\"field\":\"closedExecution\",\"type\":\"string\"}}', `langs` = '{\"YEARMONTH\":{\"zh-cn\":\"YEARMONTH\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"year\":{\"zh-cn\":\"\\u5e74\\u5ea6\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u4efd\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"newExecution\":{\"zh-cn\":\"\\u65b0\\u589e\\u6267\\u884c\\u6570\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"closedExecution\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6267\\u884c\\u6570\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT YEARMONTH, t1.year, CONCAT(t1.month, \"月\") AS `month`, IFNULL(t2.execution, 0) AS newExecution, IFNULL(t3.execution, 0) AS closedExecution\nFROM (SELECT DISTINCT DATE_FORMAT(date, \'%Y-%m\') YEARMONTH,YEAR(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS execution FROM zt_project WHERE deleted = \'0\' AND type IN (\'sprint\', \'stage\', \'kanban\') AND multiple = \'1\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS execution FROM zt_project WHERE deleted = \'0\' AND type IN (\'sprint\', \'stage\', \'kanban\') AND status = \'closed\' AND multiple = \'1\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\nORDER BY `year`, t1.month' WHERE `name` = '年度新增-执行年度新增和完成趋势图';
UPDATE `zt_chart` SET `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"YEARMONTH\",\"name\":\"YEARMONTH\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"release\",\"name\":\"release\",\"valOrAgg\":\"sum\"}]}]', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u5ea6\"}]', `fields` = '{\"YEARMONTH\":{\"name\":\"YEARMONTH\",\"object\":\"release\",\"field\":\"YEARMONTH\",\"type\":\"string\"},\"year\":{\"name\":\"year\",\"object\":\"release\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"release\",\"field\":\"month\",\"type\":\"string\"},\"release\":{\"name\":\"release\",\"object\":\"release\",\"field\":\"release\",\"type\":\"string\"}}', `langs` = '{\"YEARMONTH\":{\"zh-cn\":\"YEARMONTH\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"year\":{\"zh-cn\":\"\\u5e74\\u5ea6\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u4efd\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"release\":{\"zh-cn\":\"\\u53d1\\u5e03\\u6b21\\u6570\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT YEARMONTH, t1.year, CONCAT(t1.month, \"月\") AS `month`, IFNULL(t2.release, 0) AS `release`\nFROM (SELECT DISTINCT DATE_FORMAT(date, \'%Y-%m\') YEARMONTH,Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(createdDate) AS `year`, MONTH(createdDate) AS `month`, COUNT(1) AS `release` FROM zt_release WHERE deleted = \'0\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nORDER BY `year`, t1.month' WHERE `name` = '年度新增-产品发布次数年度趋势图';
UPDATE `zt_chart` SET `sql` = "SELECT id FROM (SELECT id,deleted FROM zt_task WHERE `status` NOT IN ('closed','cancel','done')) AS task WHERE task.deleted='0'" WHERE `id` = 1040;

UPDATE `zt_chart` SET `sql` = "SELECT t1.name,t1.id,t2.`year`,IF(YEAR(t1.createdDate) = t2.`year`, 1, 0) as newProduct, SUM(IFNULL(t3.story, 0)) AS story, SUM(IFNULL(t4.bug, 0)) AS bug, SUM(IFNULL(t5.`plan`, 0)) AS 'plan', SUM(IFNULL(t6.`release`, 0)) AS 'release' FROM zt_product AS t1 LEFT JOIN (SELECT DISTINCT YEAR(`date`) as 'year' FROM zt_action) as t2 ON 1 = 1 LEFT JOIN (SELECT COUNT(1) as 'story', product, YEAR(openedDate) as `year` FROM zt_story WHERE deleted = '0' GROUP BY product, `year`) AS t3 on t1.id = t3.product AND t3.`year` = t2.`year` LEFT JOIN (SELECT COUNT(1) as 'bug', product, YEAR(openedDate) as `year` FROM zt_bug WHERE deleted = '0' GROUP BY product, `year`) AS t4 on t1.id = t4.product AND t4.`year` = t2.`year` LEFT JOIN (SELECT COUNT(1) as 'plan', product, YEAR(createdDate) AS 'year' FROM zt_productplan WHERE deleted = '0' GROUP BY product,`year`) AS t5 on t1.id = t5.product AND t5.`year` = t2.`year` LEFT JOIN (SELECT COUNT(1) as 'release', product, YEAR(`date`) as `year` FROM zt_release WHERE deleted = '0' GROUP BY product, `year`) AS t6 ON t1.id = t6.product AND t6.`year` = t2.`year` WHERE t1.deleted = '0' AND t1.status != 'closed' AND t1.shadow = '0' GROUP BY t1.name,t1.id,t2.`year`,newProduct" WHERE `id` = 1075;

UPDATE `zt_cron` SET `h` = '1', `m` = '0' WHERE `command` = 'moduleName=metric&methodName=updateMetricLib';

UPDATE `zt_pivot` SET `fields` = '{\"account\":{\"object\":\"effort\",\"field\":\"account\",\"type\":\"user\",\"name\":\"account\"},\"consumed\":{\"object\":\"effort\",\"field\":\"consumed\",\"type\":\"object\",\"name\":\"consumed\"},\"date\":{\"object\":\"effort\",\"field\":\"date\",\"type\":\"object\",\"name\":\"date\"},\"dept\":{\"object\":\"user\",\"field\":\"dept\",\"type\":\"string\",\"name\":\"dept\"}}' WHERE `name` = '{\"zh-cn\":\"\\u65e5\\u5fd7\\u6c47\\u603b\\u8868\",\"zh-tw\":\"\\u65e5\\u8a8c\\u532f\\u7e3d\\u8868\",\"en\":\"Effort Summary\",\"de\":\"Effort Summary\",\"fr\":\"Effort Summary\"}';
UPDATE `zt_pivot` SET `sql` = 'SELECT\n    COALESCE(p.id, 0) AS projectID,\n    p.name AS projectName,\n    COALESCE(e.id, 0) AS executionID,\n    e.name AS executionName,\n    b.id,\n    b.resolution\nFROM zt_bug AS b\nLEFT JOIN zt_project AS p ON b.project = p.id\nLEFT JOIN zt_project AS e ON b.execution = e.id AND e.parent != 0\nWHERE p.id != 0 AND p.deleted = \'0\' AND b.deleted = \'0\' AND b.resolution != \'\' AND if($project=\'\',1,p.id=$project) AND if($execution=\'\',1,e.id=$execution)', `fields` = '{\"projectID\":{\"name\":\"projectID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"string\"},\"projectName\":{\"name\":\"projectName\",\"object\":\"project\",\"field\":\"name\",\"type\":\"object\"},\"executionID\":{\"name\":\"executionID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"string\"},\"executionName\":{\"name\":\"executionName\",\"object\":\"project\",\"field\":\"name\",\"type\":\"object\"},\"id\":{\"name\":\"Bug\\u7f16\\u53f7\",\"object\":\"bug\",\"field\":\"id\",\"type\":\"number\"},\"resolution\":{\"name\":\"resolution\",\"object\":\"bug\",\"field\":\"resolution\",\"type\":\"option\"}}', `langs` = '{\"projectID\":{\"zh-cn\":\"\\u9879\\u76eeID\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"projectName\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"executionID\":{\"zh-cn\":\"\\u6267\\u884cID\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"executionName\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"Bug\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"},\"resolution\":{\"zh-cn\":\"\\u89e3\\u51b3\\u65b9\\u6848\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}}', `settings` = '{\"columns\":[{\"field\":\"resolution\",\"stat\":\"count\",\"slice\":\"resolution\",\"showMode\":\"default\",\"monopolize\":\"0\",\"showTotal\":\"sum\",\"showOrigin\":\"0\"}],\"filterType\":\"query\",\"columnTotal\":\"noShow\",\"group1\":\"projectName\",\"group2\":\"executionName\",\"lastStep\":\"4\"}', `filters` = '[{\"from\":\"query\",\"field\":\"project\",\"type\":\"select\",\"typeOption\":\"project\",\"name\":\"\\u9879\\u76ee\\u5217\\u8868\",\"default\":\"\"},{\"from\":\"query\",\"field\":\"execution\",\"type\":\"select\",\"typeOption\":\"execution\",\"name\":\"\\u6267\\u884c\\u5217\\u8868\",\"default\":\"\"}]' WHERE `name` = '{\"zh-cn\":\"\\u9879\\u76eeBug\\u89e3\\u51b3\\u65b9\\u6848\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76eeBug\\u89e3\\u6c7a\\u65b9\\u6848\\u5206\\u5e03\\u8868\",\"en\":\"Project Bug Resolution\",\"de\":\"Project Bug Resolution\",\"fr\":\"Project Bug Resolution\",\"vi\":\"Project Bug Resolution\",\"ja\":\"Project Bug Resolution\"}';

UPDATE `zt_chart` SET `sql` = 'select tt.topProgram,tt.programID as id,tt.`year`,sum(tt.product) as product,sum(tt.plan) as plan,sum(tt.`release`) as `release`,sum(tt.story) as story,sum(tt.bug) as bug,sum(tt.doc) as doc\r\nfrom (\r\nselect t2.name as topProgram,t2.id as programID,t0.`year`,count(1) as product,0 as plan,0 as story,0 as bug,0 as `release`, 0 as doc\r\nfrom zt_product t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.createdDate) = t0.`year`\r\nleft join zt_project t2 on t1.program = t2.id\r\nwhere t1.deleted = \'0\' and t1.shadow = \'0\'\r\nand t2.type = \'program\' and t2.grade = 1 and t2.deleted = \'0\'\r\ngroup by t2.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as product,count(1) as plan,0 as story,0 as bug,0 as `release`, 0 as doc\r\nfrom zt_productplan t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.createdDate) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as product,0 as plan,0 as story,0 as bug,0 as `release`, count(1) as doc\r\nfrom zt_doc t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.addedDate) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as product,0 as plan,0 as story,0 as bug,count(1) as `release`, 0 as doc\r\nfrom zt_release t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.date) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as product,0 as plan,count(1) as story,0 as bug,0 as `release`, 0 as doc\r\nfrom zt_story t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.openedDate) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as product,0 as plan,0 as story,count(1) as bug,0 as `release`, 0 as doc\r\nfrom zt_bug t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.openedDate) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\n) tt\r\ngroup by tt.programID, tt.`year`' WHERE `name` = '年度新增-项目集年度新增数据汇总表';
UPDATE `zt_chart` SET `sql` = 'select tt.topProgram,tt.programID as id,tt.`year`,sum(tt.projectA) as projectA,sum(tt.executionA) as executionA,sum(tt.releaseA) as `release`,sum(tt.storyA) as story,sum(tt.bugA) as bug \r\nfrom (\r\nselect t2.name as topProgram,t2.id as programID,t0.`year`,count(1) as projectA,0 as executionA,0 as releaseA,0 as storyA,0 as bugA\r\nfrom zt_project t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.closedDate) = t0.`year`\r\nleft join zt_project t2 on FIND_IN_SET(t2.id, t1.path)\r\nwhere t1.type = \'project\' and t1.deleted = \'0\'\r\nand t2.type = \'program\' and t2.grade = 1 and t2.deleted = \'0\'\r\nand t1.`status` = \'closed\'\r\ngroup by t2.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram, t3.id as programID,t0.`year`,0 as projectA,count(1) as executionA,0 as releaseA,0 as storyA,0 as bugA\r\nfrom zt_project t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.closedDate) = t0.`year`\r\nleft join zt_project t2 on t1.parent = t2.id\r\nleft join zt_project t3 on FIND_IN_SET(t3.id, t2.path)\r\nwhere t1.type in (\'sprint\', \'stage\', \'kanban\') and t1.deleted = \'0\'\r\nand t2.type = \'project\' and t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\nand t1.`status` = \'closed\'\r\ngroup by t3.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as projectA,0 as executionA,count(1) as releaseA,0 as storyA,0 as bugA\r\nfrom zt_release t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.date) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as projectA,0 as executionA,0 as releaseA,count(1) as storyA,0 as bugA\r\nfrom zt_story t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.closedDate) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\' and t1.closedReason = \'done\' and t1.status = \'closed\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\nunion all\r\nselect t3.name as topProgram,t3.id as programID,t0.`year`,0 as projectA,0 as executionA,0 as releaseA,0 as storyA,count(1) as bugA\r\nfrom zt_bug t1\r\nleft join (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) t0 on YEAR(t1.resolvedDate) = t0.`year`\r\nleft join zt_product t2 on t2.id = t1.product\r\nleft join zt_project t3 on t2.program = t3.id\r\nwhere t1.deleted = \'0\' and t1.resolution = \'fixed\' and t1.status = \'closed\'\r\nand t2.deleted = \'0\'\r\nand t3.type = \'program\' and t3.grade = 1 and t3.deleted = \'0\'\r\ngroup by t3.id, t0.`year`\r\n) tt\r\ngroup by tt.programID, tt.`year`' WHERE `name` = '年度新增-项目集年度完成数据概览';
UPDATE `zt_chart` SET `sql` = 'SELECT\r\n    t1.name,t1.id,t2.`year`,IF(YEAR(t1.createdDate) = t2.`year`, 1, 0) as newProduct,\r\n    SUM(IFNULL(t3.story, 0)) AS story,\r\n    SUM(IFNULL(t4.bug, 0)) AS bug,\r\n    SUM(IFNULL(t5.`plan`, 0)) AS \'plan\',\r\n    SUM(IFNULL(t6.`release`, 0)) AS \'release\'\r\nFROM zt_product AS t1\r\nLEFT JOIN (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) as t2 ON 1 = 1\r\nLEFT JOIN (SELECT COUNT(1) as \'story\', product, YEAR(openedDate) as `year` FROM zt_story WHERE deleted = \'0\' GROUP BY product, `year`) AS t3 on t1.id = t3.product AND t3.`year` = t2.`year`\r\nLEFT JOIN (SELECT COUNT(1) as \'bug\', product, YEAR(openedDate) as `year` FROM zt_bug WHERE deleted = \'0\' GROUP BY product, `year`) AS t4 on t1.id = t4.product AND t4.`year` = t2.`year`\r\nLEFT JOIN (SELECT COUNT(1) as \'plan\', product, YEAR(createdDate) AS \'year\' FROM zt_productplan WHERE deleted = \'0\' GROUP BY product,`year`) AS t5 on t1.id = t5.product AND t5.`year` = t2.`year`\r\nLEFT JOIN (SELECT COUNT(1) as \'release\', product, YEAR(`date`) as `year` FROM zt_release WHERE deleted = \'0\' GROUP BY product, `year`) AS t6 ON t1.id = t6.product AND t6.`year` = t2.`year`\r\nWHERE t1.deleted = \'0\' AND t1.status != \'closed\' AND t1.shadow = \'0\'\r\nGROUP BY t1.name,t1.id,t2.`year`,newProduct' WHERE `name` = '年度新增-产品年度新增数据汇总表';
