ALTER TABLE `zt_mr` ADD executionID mediumint(8) unsigned NOT NULL DEFAULT 0 AFTER `jobID`;
ALTER TABLE `zt_testtask` ADD COLUMN `members` text NULL;
UPDATE `zt_solutions` SET `deleted` = '0' WHERE `deleted` = '';

-- Update createdBy to system in chart and pivot
UPDATE `zt_chart` SET `createdBy` = 'system' WHERE `builtin` = '1';
UPDATE `zt_pivot` SET `createdBy` = 'system' WHERE `id` >= 1000 and `id` <= 1027;

UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"topProgram\",\"name\":\"topProgram\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"storyDoneRate\",\"name\":\"storyDoneRate\",\"valOrAgg\":\"sum\"},{\"field\":\"bugSolvedRate\",\"name\":\"bugSolvedRate\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"topProgram\":{\"name\":\"topProgram\",\"object\":\"bug\",\"field\":\"topProgram\",\"type\":\"string\"},\"doneStory\":{\"name\":\"doneStory\",\"object\":\"bug\",\"field\":\"doneStory\",\"type\":\"number\"},\"allStory\":{\"name\":\"allStory\",\"object\":\"bug\",\"field\":\"allStory\",\"type\":\"number\"},\"storyDoneRate\":{\"name\":\"storyDoneRate\",\"object\":\"bug\",\"field\":\"storyDoneRate\",\"type\":\"number\"},\"solvedBug\":{\"name\":\"solvedBug\",\"object\":\"bug\",\"field\":\"solvedBug\",\"type\":\"number\"},\"allBug\":{\"name\":\"allBug\",\"object\":\"bug\",\"field\":\"allBug\",\"type\":\"number\"},\"bugSolvedRate\":{\"name\":\"bugSolvedRate\",\"object\":\"bug\",\"field\":\"bugSolvedRate\",\"type\":\"number\"}}', `filters` = '[]', `langs` = '{\"topProgram\":{\"zh-cn\":\"\\u4e00\\u7ea7\\u9879\\u76ee\\u96c6\",\"zh-tw\":\"\",\"en\":\"topProgram\",\"de\":\"\",\"fr\":\"\"},\"doneStory\":{\"zh-cn\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\",\"en\":\"doneStory\",\"de\":\"\",\"fr\":\"\"},\"allStory\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\",\"en\":\"allStory\",\"de\":\"\",\"fr\":\"\"},\"storyDoneRate\":{\"zh-cn\":\"\\u9700\\u6c42\\u5b8c\\u6210\\u7387\",\"zh-tw\":\"\",\"en\":\"storyDoneRate\",\"de\":\"\",\"fr\":\"\"},\"solvedBug\":{\"zh-cn\":\"\\u89e3\\u51b3bug\\u6570\",\"zh-tw\":\"\",\"en\":\"solvedBug\",\"de\":\"\",\"fr\":\"\"},\"allBug\":{\"zh-cn\":\"bug\\u6570\",\"zh-tw\":\"\",\"en\":\"allBug\",\"de\":\"\",\"fr\":\"\"},\"bugSolvedRate\":{\"zh-cn\":\"bug\\u4fee\\u590d\\u7387\",\"zh-tw\":\"\",\"en\":\"bugSolvedRate\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT\n    t1.name AS topProgram,\n    SUM(IFNULL(t3.doneStory,0)) as doneStory,\n    SUM(IFNULL(t4.allStory,0)) as allStory,\n    CONVERT(IF(SUM(IFNULL(t4.allStory,0)) <= 0, 0, SUM(IFNULL(t3.doneStory,0)) / SUM(IFNULL(t4.allStory,0))*100), decimal(10,2)) as storyDoneRate,                                                                                                                                         \n    SUM(IFNULL(t5.solvedBug,0)) as solvedBug,\n    SUM(IFNULL(t6.allBug,0)) as allBug,\n    CONVERT(IF(SUM(IFNULL(t6.allBug,0)) <= 0, 0, SUM(IFNULL(t5.solvedBug,0)) / SUM(IFNULL(t6.allBug,0))*100), decimal(10,2)) as bugSolvedRate\nFROM zt_project AS t1\nLEFT JOIN zt_product AS t2 ON t1.id = t2.program\nLEFT JOIN (SELECT COUNT(1) as doneStory, product FROM zt_story WHERE deleted = \'0\' AND closedReason = \'done\' AND status = \'closed\' GROUP BY product) AS t3 ON t2.id = t3.product\nLEFT JOIN (SELECT COUNT(1) as allStory, product FROM zt_story WHERE deleted = \'0\' AND ((closedReason = \'done\' AND status = \'closed\') OR status != \'closed\') GROUP BY product) AS t4 ON t2.id = t4.product\nLEFT JOIN (SELECT COUNT(1) as solvedBug, product FROM zt_bug WHERE deleted = \'0\' AND resolution = \'fixed\' AND status = \'closed\' GROUP BY product) AS t5 ON t2.id = t5.product\nLEFT JOIN (SELECT COUNT(1) as allBug, product FROM zt_bug WHERE deleted = \'0\' AND (resolution in (\'fixed\', \'postponed\') OR status = \'active\') GROUP BY product) AS t6 ON t2.id = t6.product\nWHERE t1.type = \'program\' AND t1.grade = 1 AND t1.deleted = \'0\'\nAND t2.deleted = \'0\'\nGROUP BY t1.name\nORDER BY t1.`order` DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1042;
UPDATE `zt_chart` SET `type` = 'pie', `settings` = '[{\"type\":\"pie\",\"group\":[{\"field\":\"status\",\"name\":\"\\u72b6\\u6001\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"\\u9879\\u76eeID\",\"valOrAgg\":\"count\"}]}]', `fields` = '{\"id\":{\"name\":\"\\u9879\\u76eeID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"status\":{\"name\":\"\\u72b6\\u6001\",\"object\":\"project\",\"field\":\"status\",\"type\":\"option\"}}', `filters` = '[]', `langs` = '{\"id\":{\"zh-cn\":\"\\u9879\\u76eeID\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"status\":{\"zh-cn\":\"\\u72b6\\u6001\",\"zh-tw\":\"\",\"en\":\"status\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT id, CASE `status` WHEN \'wait\' then \'未开始\' WHEN \'doing\' THEN \'进行中\' WHEN \'suspended\' THEN \'已挂起\' ELSE \'已关闭\' END status FROM zt_project  WHERE type = \'program\' AND grade = 1 AND deleted = \'0\'', `stage` = 'published', `builtin` = 0 WHERE `id` = 1043;
UPDATE `zt_chart` SET `type` = 'pie', `settings` = '[{\"type\":\"pie\",\"group\":[{\"field\":\"status\",\"name\":\"\\u72b6\\u6001\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"\\u9879\\u76eeID\",\"valOrAgg\":\"count\"}]}]', `fields` = '{\"id\":{\"name\":\"\\u9879\\u76eeID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"status\":{\"name\":\"\\u72b6\\u6001\",\"object\":\"project\",\"field\":\"status\",\"type\":\"option\"}}', `filters` = '[]', `langs` = '{\"id\":{\"zh-cn\":\"\\u9879\\u76eeID\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"status\":{\"zh-cn\":\"\\u72b6\\u6001\",\"zh-tw\":\"\",\"en\":\"status\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT id, CASE `status` WHEN \'wait\' then \'未开始\' WHEN \'doing\' THEN \'进行中\' WHEN \'suspended\' THEN \'已挂起\' ELSE \'已关闭\' END status FROM zt_project  WHERE type = \'project\' AND deleted = \'0\'', `stage` = 'published', `builtin` = 0 WHERE `id` = 1044;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"product\",\"name\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"closedRate\",\"name\":\"closedRate\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"product\":{\"name\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"object\":\"story\",\"field\":\"product\",\"type\":\"string\"},\"program\":{\"name\":\"program\",\"object\":\"story\",\"field\":\"program\",\"type\":\"string\"},\"productLine\":{\"name\":\"productLine\",\"object\":\"story\",\"field\":\"productLine\",\"type\":\"string\"},\"closedStory\":{\"name\":\"\\u9700\\u6c42\\uff1a%s \\u5df2\\u5173\\u95ed\\uff0c\\u5c06\\u4e0d\\u4f1a\\u88ab\\u5173\\u95ed\\u3002\",\"object\":\"story\",\"field\":\"closedStory\",\"type\":\"string\"},\"totalStory\":{\"name\":\"totalStory\",\"object\":\"story\",\"field\":\"totalStory\",\"type\":\"string\"},\"closedRate\":{\"name\":\"closedRate\",\"object\":\"story\",\"field\":\"closedRate\",\"type\":\"number\"}}', `filters` = '[]', `langs` = '{\"product\":{\"zh-cn\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"zh-tw\":\"\",\"en\":\"product\",\"de\":\"\",\"fr\":\"\"},\"program\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\",\"zh-tw\":\"\",\"en\":\"program\",\"de\":\"\",\"fr\":\"\"},\"productLine\":{\"zh-cn\":\"\\u4ea7\\u54c1\\u7ebf\",\"zh-tw\":\"\",\"en\":\"productLine\",\"de\":\"\",\"fr\":\"\"},\"closedStory\":{\"zh-cn\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\",\"en\":\"closedStory\",\"de\":\"\",\"fr\":\"\"},\"totalStory\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\",\"en\":\"totalStory\",\"de\":\"\",\"fr\":\"\"},\"closedRate\":{\"zh-cn\":\"\\u9700\\u6c42\\u5b8c\\u6210\\u7387\",\"zh-tw\":\"\",\"en\":\"closedRate\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT\n  t1.name AS product,\n  IFNULL(t2.name, \'/\') AS program, \n  IFNULL(t3.name, \'/\') AS productLine,   \n  IFNULL(t4.story, 0) AS closedStory, \n  t5.story AS totalStory, \n  ROUND(IFNULL(t4.story, 0) / t5.story * 100, 2) AS closedRate \nFROM zt_product AS t1 \nLEFT JOIN zt_project AS t2 ON t1.program = t2.id AND t2.type = \'program\' AND t2.grade = 1 \nLEFT JOIN zt_module AS t3 ON t1.line = t3.id AND t3.type = \'line\' \nLEFT JOIN (SELECT product, COUNT(1) AS story FROM zt_story WHERE deleted = \'0\' AND closedReason = \'done\' GROUP BY product) AS t4 ON t1.id = t4.product \nLEFT JOIN (SELECT product, COUNT(1) AS story FROM zt_story WHERE deleted = \'0\' AND ( closedReason = \'done\' OR status != \'closed\') GROUP BY product) AS t5 ON t1.id = t5.product \nWHERE t1.deleted = \'0\' AND t1.status != \'closed\' AND t1.shadow = \'0\' AND t1.vision = \'rnd\' AND t5.story IS NOT NULL \nORDER BY t1.order DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1046;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"product\",\"name\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"fixedRate\",\"name\":\"\\u4fee\\u590d\\u7387\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"product\":{\"name\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"object\":\"bug\",\"field\":\"product\",\"type\":\"string\"},\"program\":{\"name\":\"program\",\"object\":\"bug\",\"field\":\"program\",\"type\":\"string\"},\"productLine\":{\"name\":\"productLine\",\"object\":\"bug\",\"field\":\"productLine\",\"type\":\"string\"},\"fixedBug\":{\"name\":\"fixedBug\",\"object\":\"bug\",\"field\":\"fixedBug\",\"type\":\"string\"},\"totalBug\":{\"name\":\"totalBug\",\"object\":\"bug\",\"field\":\"totalBug\",\"type\":\"string\"},\"fixedRate\":{\"name\":\"\\u4fee\\u590d\\u7387\",\"object\":\"bug\",\"field\":\"fixedRate\",\"type\":\"number\"}}', `filters` = '[]', `langs` = '{\"product\":{\"zh-cn\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"zh-tw\":\"\",\"en\":\"product\",\"de\":\"\",\"fr\":\"\"},\"program\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\",\"zh-tw\":\"\",\"en\":\"program\",\"de\":\"\",\"fr\":\"\"},\"productLine\":{\"zh-cn\":\"\\u4ea7\\u54c1\\u7ebf\",\"zh-tw\":\"\",\"en\":\"productLine\",\"de\":\"\",\"fr\":\"\"},\"fixedBug\":{\"zh-cn\":\"\\u4fee\\u590dbug\\u6570\",\"zh-tw\":\"\",\"en\":\"fixedBug\",\"de\":\"\",\"fr\":\"\"},\"totalBug\":{\"zh-cn\":\"bug\\u6570\",\"zh-tw\":\"\",\"en\":\"totalBug\",\"de\":\"\",\"fr\":\"\"},\"fixedRate\":{\"zh-cn\":\"bug\\u4fee\\u590d\\u7387\",\"zh-tw\":\"\",\"en\":\"fixedRate\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  t1.name AS product,\n  IFNULL(t2.name, \'/\') AS program,\n  IFNULL(t3.name, \'/\') AS productLine,\n  IFNULL(t4.bug, 0) AS fixedBug,\n  t5.bug AS totalBug,\n  ROUND(IFNULL(t4.bug, 0) / t5.bug * 100, 2) AS fixedRate\nFROM zt_product AS t1\nLEFT JOIN zt_project AS t2 ON t1.program = t2.id AND t2.type = \'program\' AND t2.grade = 1\nLEFT JOIN zt_module AS t3 ON t1.line = t3.id AND t3.type = \'line\'\nLEFT JOIN (SELECT product, COUNT(1) AS bug FROM zt_bug WHERE deleted = \'0\' AND resolution = \'fixed\' AND status = \'closed\' GROUP BY product) AS t4 ON t1.id = t4.product\nLEFT JOIN (SELECT product, COUNT(1) AS bug FROM zt_bug WHERE deleted = \'0\' AND (resolution = \'fixed\' OR resolution = \'postponed\' OR status = \'active\') GROUP BY product) AS t5 ON t1.id = t5.product\nWHERE t1.deleted = \'0\' AND t1.status != \'closed\' AND t1.shadow = \'0\' AND t1.vision = \'rnd\'  AND t5.bug IS NOT NULL\nORDER BY t1.order DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1047;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"deptName\",\"name\":\"deptName\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"count\",\"name\":\"count\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"deptName\":{\"name\":\"deptName\",\"object\":\"false\",\"field\":\"deptName\",\"type\":\"object\"},\"count\":{\"name\":\"count\",\"object\":\"false\",\"field\":\"count\",\"type\":\"object\"},\"deptOrder\":{\"name\":\"deptOrder\",\"object\":\"false\",\"field\":\"deptOrder\",\"type\":\"object\"}}', `filters` = '[]', `langs` = '{\"deptName\":{\"zh-cn\":\"\\u90e8\\u95e8\",\"zh-tw\":\"\",\"en\":\"deptName\",\"de\":\"\",\"fr\":\"\"},\"count\":{\"zh-cn\":\"\\u4eba\\u6570\",\"zh-tw\":\"\",\"en\":\"count\",\"de\":\"\",\"fr\":\"\"},\"deptOrder\":{\"zh-cn\":\"\\u987a\\u5e8f\",\"zh-tw\":\"\",\"en\":\"deptOrder\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT IF(t3.id IS NOT NULL, t3.`name`, \"空\") AS deptName,count(1) as count, \nIF(t3.id IS NOT NULL, t3.`order`, 9999) AS deptOrder \nFROM zt_user AS t1 \nLEFT JOIN zt_dept AS t2 ON t1.dept = t2.id\nLEFT JOIN zt_dept AS t3 ON FIND_IN_SET(TRIM(\',\' FROM t3.path), TRIM(\',\' FROM t2.path)) AND t3.grade = \'1\'\nWHERE t1.deleted = \'0\'\nGROUP BY deptName, deptOrder \nORDER BY deptOrder  ASC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1049;
UPDATE `zt_chart` SET `type` = 'pie', `settings` = '[{\"type\":\"pie\",\"group\":[{\"field\":\"role\",\"name\":\"\\u804c\\u4f4d\",\"group\":\"\"}],\"metric\":[{\"field\":\"account\",\"name\":\"\\u7528\\u6237\\u540d\",\"valOrAgg\":\"count\"}]}]', `fields` = '{\"account\":{\"name\":\"\\u7528\\u6237\\u540d\",\"object\":\"user\",\"field\":\"account\",\"type\":\"string\"},\"role\":{\"name\":\"\\u804c\\u4f4d\",\"object\":\"user\",\"field\":\"role\",\"type\":\"string\"}}', `filters` = '[]', `langs` = '{\"account\":{\"zh-cn\":\"\\u7528\\u6237\\u540d\",\"zh-tw\":\"\",\"en\":\"account\",\"de\":\"\",\"fr\":\"\"},\"role\":{\"zh-cn\":\"\\u804c\\u4f4d\",\"zh-tw\":\"\",\"en\":\"role\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT\n	account,\nCASE\n		ROLE \n		WHEN \'dev\' THEN\n		\"研发\" \n		WHEN \'qa\' THEN\n		\"测试\" \n		WHEN \'pm\' THEN\n		\"项目经理\" \n		WHEN \'others\' THEN\n		\"其他\" \n		WHEN \'td\' THEN\n		\"研发主管\" \n		WHEN \'pd\' THEN\n		\"产品主管\" \n		WHEN \'po\' THEN\n		\"产品经理\" \n		WHEN \'qd\' THEN\n		\"测试主管\" \n		WHEN \'top\' THEN\n		\"高层管理\" ELSE \"未知\" \n	END role \nFROM\n	zt_user \nWHERE\n	deleted = \'0\'', `stage` = 'published', `builtin` = 0 WHERE `id` = 1050;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"joinDate\",\"name\":\"joinDate\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"count\",\"name\":\"count\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"count\":{\"name\":\"count\",\"object\":\"user\",\"field\":\"count\",\"type\":\"string\"},\"joinDate\":{\"name\":\"joinDate\",\"object\":\"user\",\"field\":\"joinDate\",\"type\":\"string\"}}', `filters` = '[]', `langs` = '{\"count\":{\"zh-cn\":\"\\u4eba\\u6570\",\"zh-tw\":\"\",\"en\":\"count\",\"de\":\"\",\"fr\":\"\"},\"joinDate\":{\"zh-cn\":\"\\u5de5\\u9f84\",\"zh-tw\":\"\",\"en\":\"joinDate\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT count(1) as count, \"0-1年\" as joinDate FROM zt_user WHERE deleted = \'0\' AND `join` > DATE_SUB(NOW(), INTERVAL 1 YEAR)\nunion\nSELECT count(1) as count, \"1-3年\" as joinDate FROM zt_user WHERE deleted = \'0\' AND `join` > DATE_SUB(NOW(), INTERVAL 3 YEAR) AND `join` <= DATE_SUB(NOW(), INTERVAL 1 YEAR)\nunion\nSELECT count(1) as count, \"3-5年\" as joinDate FROM zt_user WHERE deleted = \'0\' AND `join` > DATE_SUB(NOW(), INTERVAL 5 YEAR) AND `join` <= DATE_SUB(NOW(), INTERVAL 3 YEAR)\nunion\nSELECT count(1) as count, \"5-10年\" as joinDate FROM zt_user WHERE deleted = \'0\' AND `join` > DATE_SUB(NOW(), INTERVAL 10 YEAR) AND `join` <= DATE_SUB(NOW(), INTERVAL 5 YEAR)\nunion\nSELECT count(1) as count, \"10年以上\" as joinDate FROM zt_user WHERE deleted = \'0\' AND `join` < DATE_SUB(NOW(), INTERVAL 10 YEAR) AND LEFT(`join`, 4) != \'0000\'\nunion                                                                                                                                                                                                                                                          \nSELECT count(1) as count, \"未知\" as joinDate FROM zt_user WHERE deleted = \'0\' AND LEFT(`join`, 4) = \'0000\'', `stage` = 'published', `builtin` = 0 WHERE `id` = 1051;

-- 年度进行中项目过程大屏
UPDATE `zt_chart` SET `type` = 'pie', `settings` = '[{\"type\":\"pie\",\"group\":[{\"field\":\"status\",\"name\":\"\\u72b6\\u6001\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"id\",\"valOrAgg\":\"count\"}]}]', `fields` = '{\"id\":{\"name\":\"id\",\"object\":\"zt_project\",\"field\":\"id\",\"type\":\"number\"},\"name\":{\"name\":\"name\",\"object\":\"zt_project\",\"field\":\"name\",\"type\":\"string\"},\"status\":{\"name\":\"\\u72b6\\u6001\",\"object\":\"project\",\"field\":\"status\",\"type\":\"option\"},\"prograss\":{\"name\":\"prograss\",\"object\":\"task\",\"field\":\"prograss\",\"type\":\"number\"},\"planPrograss\":{\"name\":\"planPrograss\",\"object\":\"task\",\"field\":\"planPrograss\",\"type\":\"number\"},\"endYear\":{\"name\":\"endYear\",\"object\":\"task\",\"field\":\"endYear\",\"type\":\"string\"}}', `langs` = '{\"id\":{\"zh-cn\":\"\\u9879\\u76eeID\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"name\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"name\",\"de\":\"\",\"fr\":\"\"},\"status\":{\"zh-cn\":\"\\u72b6\\u6001\",\"zh-tw\":\"\",\"en\":\"status\",\"de\":\"\",\"fr\":\"\"},\"prograss\":{\"zh-cn\":\"\\u9879\\u76ee\\u8fdb\\u5ea6\",\"zh-tw\":\"\",\"en\":\"prograss\",\"de\":\"\",\"fr\":\"\"},\"planPrograss\":{\"zh-cn\":\"\\u8ba1\\u5212\\u8fdb\\u5ea6\",\"zh-tw\":\"\",\"en\":\"planPrograss\",\"de\":\"\",\"fr\":\"\"},\"endYear\":{\"zh-cn\":\"\\u7ed3\\u675f\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"endYear\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT t1.id, t1.name, \nIF(\n    DATEDIFF(t1.`end`, NOW()) < 0, \n    \"延期\", \n    (IF(\n        (IFNULL(prograss, 0) >= (DATEDIFF(NOW(), t1.`begin`) / DATEDIFF(t1.`end`, t1.`begin`) * 100) AND LEFT(t1.`end`, 4) != \'2059\') \n        OR LEFT(t1.`end`, 4) = \'2059\' ,\n        \"顺利\",\n        \"滞后\"\n    ))) AS \'status\',\nIFNULL(prograss, 0) AS prograss, ROUND(DATEDIFF(NOW(), t1.`begin`) / DATEDIFF(t1.`end`, t1.`begin`) * 100, 2)  AS planPrograss,LEFT(t1.`end`, 4) AS endYear\nFROM zt_project AS t1\nLEFT JOIN (\n    SELECT t22.project,\n    ROUND(IF(SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0)) > 0, SUM(t22.consumed) / (SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0))), 0) * 100, 2) AS prograss\n    FROM zt_project AS t21\n    LEFT JOIN zt_task AS t22 ON t21.id = t22.execution\n    WHERE t21.deleted = \'0\' AND t21.type IN (\'sprint\', \'kanban\')\n    AND t22.deleted = \'0\' AND t22.parent < 1\n    GROUP BY t22.project\n    UNION\n    SELECT  t.project, ROUND(SUM(t.prograss * (t.percent / 100)), 2) as prograss\n    FROM (\n        SELECT t21.id,t21.percent, t22.project,\n        IF(SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0)) > 0, ROUND(SUM(t22.consumed) / (SUM(t22.consumed) + SUM(IF(t22.status != \'closed\' && t22.status != \'cancel\', t22.`left`, 0))) * 1000 / 1000 * 100, 2), 0)  AS prograss\n        FROM zt_project AS t21\n        LEFT JOIN zt_task AS t22 ON t21.id = t22.execution\n        WHERE t21.deleted = \'0\' AND t21.type = \'stage\'\n        AND t22.deleted = \'0\' AND t22.parent < 1\n        AND t22.id IS NOT NULL\n        GROUP BY t21.id, t21.percent, t22.project\n    ) t\n    GROUP BY t.project\n) AS t2 ON t1.id = t2.project \nWHERE t1.deleted = \'0\'\nAND t1.status = \'doing\' \nAND t1.type = \'project\'', `stage` = 'published', `builtin` = 0 WHERE `id` = 10114;
UPDATE `zt_chart` SET `type` = 'pie', `settings` = '[{\"type\":\"pie\",\"group\":[{\"field\":\"status\",\"name\":\"\\u72b6\\u6001\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"\\u9879\\u76eeID\",\"valOrAgg\":\"count\"}]}]', `fields` = '{\"id\":{\"name\":\"\\u9879\\u76eeID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"name\":{\"name\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"object\":\"project\",\"field\":\"name\",\"type\":\"string\"},\"status\":{\"name\":\"\\u72b6\\u6001\",\"object\":\"project\",\"field\":\"status\",\"type\":\"option\"},\"prograss\":{\"name\":\"prograss\",\"object\":\"task\",\"field\":\"prograss\",\"type\":\"number\"},\"planPrograss\":{\"name\":\"planPrograss\",\"object\":\"task\",\"field\":\"planPrograss\",\"type\":\"number\"},\"end\":{\"name\":\"\\u8ba1\\u5212\\u5b8c\\u6210\",\"object\":\"project\",\"field\":\"end\",\"type\":\"date\"}}', `langs` = '{\"id\":{\"zh-cn\":\"\\u9879\\u76eeID\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"name\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"name\",\"de\":\"\",\"fr\":\"\"},\"status\":{\"zh-cn\":\"\\u72b6\\u6001\",\"zh-tw\":\"\",\"en\":\"status\",\"de\":\"\",\"fr\":\"\"},\"prograss\":{\"zh-cn\":\"\\u9879\\u76ee\\u8fdb\\u5ea6\",\"zh-tw\":\"\",\"en\":\"prograss\",\"de\":\"\",\"fr\":\"\"},\"planPrograss\":{\"zh-cn\":\"\\u8ba1\\u5212\\u8fdb\\u5ea6\",\"zh-tw\":\"\",\"en\":\"planPrograss\",\"de\":\"\",\"fr\":\"\"},\"end\":{\"zh-cn\":\"\\u8ba1\\u5212\\u5b8c\\u6210\",\"zh-tw\":\"\",\"en\":\"end\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT id, name,IF(\n    DATEDIFF(`end`, NOW()) < 0,\n    \"延期\",\n    (IF(\n        prograss >= planPrograss,\n        \"顺利\",\n        \"滞后\"\n    ))\n) AS status,\nprograss, planPrograss, `end`\nFROM (\nSELECT t1.id,t1.name,ROUND(DATEDIFF(NOW(), t1.`begin`) / DATEDIFF(t1.`end`, t1.`begin`) * 100, 2) AS planPrograss,t1.`end`,\nROUND(IF(SUM(t2.consumed) + SUM(IF(t2.status != \'closed\' && t2.status != \'cancel\', t2.`left`, 0)) > 0, SUM(t2.consumed) / (SUM(t2.consumed) + SUM(IF(t2.status != \'closed\' && t2.status != \'cancel\', t2.`left`, 0))), 0) * 100, 2) AS prograss\nFROM zt_project AS t1\nLEFT JOIN zt_task AS t2 ON t1.id = t2.execution\nWHERE t1.deleted = \'0\' AND t1.type IN (\'sprint\', \'stage\', \'kanban\') AND t1.status = \'doing\' AND t1.multiple = \'1\'\nAND ((t2.deleted = \'0\' AND t2.parent < 1) OR t2.id IS NULL)\nGROUP BY t1.id\n) AS t', `stage` = 'published', `builtin` = 0 WHERE `id` = 10115;

-- 年度汇总数据大屏
UPDATE `zt_chart` SET `type` = 'line', `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"month\",\"name\":\"month\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"newStory\",\"name\":\"\\u7ee7\\u7eed\\u6dfb\\u52a0\\u7814\\u53d1\\u9700\\u6c42\",\"valOrAgg\":\"sum\"},{\"field\":\"closedStory\",\"name\":\"\\u9700\\u6c42\\uff1a%s \\u5df2\\u5173\\u95ed\\uff0c\\u5c06\\u4e0d\\u4f1a\\u88ab\\u5173\\u95ed\\u3002\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"story\",\"field\":\"month\",\"type\":\"string\"},\"newStory\":{\"name\":\"\\u7ee7\\u7eed\\u6dfb\\u52a0\\u7814\\u53d1\\u9700\\u6c42\",\"object\":\"story\",\"field\":\"newStory\",\"type\":\"string\"},\"closedStory\":{\"name\":\"\\u9700\\u6c42\\uff1a%s \\u5df2\\u5173\\u95ed\\uff0c\\u5c06\\u4e0d\\u4f1a\\u88ab\\u5173\\u95ed\\u3002\",\"object\":\"story\",\"field\":\"closedStory\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u5ea6\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u5ea6\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u5ea6\",\"zh-tw\":\"\",\"en\":\"month\",\"de\":\"\",\"fr\":\"\"},\"newStory\":{\"zh-cn\":\"\\u65b0\\u589e\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\",\"en\":\"newStory\",\"de\":\"\",\"fr\":\"\"},\"closedStory\":{\"zh-cn\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\",\"en\":\"closedStory\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT t1.year, CONCAT(t1.month, \"月\") AS `month`, IFNULL(t2.story, 0) AS newStory, IFNULL(t3.story, 0) AS closedStory\nFROM (SELECT DISTINCT Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS story FROM zt_story WHERE deleted = \'0\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS story FROM zt_story WHERE deleted = \'0\' AND closedReason = \'done\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\nORDER BY `year`, t1.month', `stage` = 'published', `builtin` = 0 WHERE `id` = 1077;
UPDATE `zt_chart` SET `type` = 'line', `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"month\",\"name\":\"month\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"newBug\",\"name\":\"newBug\",\"valOrAgg\":\"sum\"},{\"field\":\"fixedBug\",\"name\":\"fixedBug\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"bug\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"bug\",\"field\":\"month\",\"type\":\"string\"},\"newBug\":{\"name\":\"newBug\",\"object\":\"bug\",\"field\":\"newBug\",\"type\":\"string\"},\"fixedBug\":{\"name\":\"fixedBug\",\"object\":\"bug\",\"field\":\"fixedBug\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u5ea6\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u5ea6\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u4efd\",\"zh-tw\":\"\",\"en\":\"month\",\"de\":\"\",\"fr\":\"\"},\"newBug\":{\"zh-cn\":\"\\u65b0\\u589eBug\\u6570\",\"zh-tw\":\"\",\"en\":\"newBug\",\"de\":\"\",\"fr\":\"\"},\"fixedBug\":{\"zh-cn\":\"\\u89e3\\u51b3Bug\\u6570\",\"zh-tw\":\"\",\"en\":\"fixedBug\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT t1.year, CONCAT(t1.month, \"月\") AS `month`, IFNULL(t2.bug, 0) AS newBug, IFNULL(t3.bug, 0) AS fixedBug\nFROM (SELECT DISTINCT Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS bug FROM zt_bug WHERE deleted = \'0\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS bug FROM zt_bug WHERE deleted = \'0\' AND resolution = \'fixed\' AND status = \'closed\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\nORDER BY `year`, t1.month', `stage` = 'published', `builtin` = 0 WHERE `id` = 1078;
UPDATE `zt_chart` SET `type` = 'line', `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"month\",\"name\":\"month\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"newTask\",\"name\":\"newTask\",\"valOrAgg\":\"sum\"},{\"field\":\"closedTask\",\"name\":\"closedTask\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"task\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"task\",\"field\":\"month\",\"type\":\"string\"},\"newTask\":{\"name\":\"newTask\",\"object\":\"task\",\"field\":\"newTask\",\"type\":\"string\"},\"closedTask\":{\"name\":\"closedTask\",\"object\":\"task\",\"field\":\"closedTask\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u4efd\",\"zh-tw\":\"\",\"en\":\"month\",\"de\":\"\",\"fr\":\"\"},\"newTask\":{\"zh-cn\":\"\\u65b0\\u589e\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\",\"en\":\"newTask\",\"de\":\"\",\"fr\":\"\"},\"closedTask\":{\"zh-cn\":\"\\u5b8c\\u6210\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\",\"en\":\"closedTask\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT t1.year, CONCAT(t1.month, \"月\") AS `month`, IFNULL(t2.task, 0) AS newTask, IFNULL(t3.task, 0) AS closedTask\nFROM (SELECT DISTINCT Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS task FROM zt_task WHERE deleted = \'0\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS task FROM zt_task WHERE deleted = \'0\' AND status = \'closed\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\nORDER BY `year`, t1.month', `stage` = 'published', `builtin` = 0 WHERE `id` = 1079;
UPDATE `zt_chart` SET `type` = 'line', `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"month\",\"name\":\"month\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"newProject\",\"name\":\"newProject\",\"valOrAgg\":\"sum\"},{\"field\":\"closedProject\",\"name\":\"\\u5df2\\u5173\\u95ed\\u7684\\u9879\\u76ee\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"project\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"project\",\"field\":\"month\",\"type\":\"string\"},\"newProject\":{\"name\":\"newProject\",\"object\":\"project\",\"field\":\"newProject\",\"type\":\"string\"},\"closedProject\":{\"name\":\"\\u5df2\\u5173\\u95ed\\u7684\\u9879\\u76ee\",\"object\":\"project\",\"field\":\"closedProject\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u4efd\",\"zh-tw\":\"\",\"en\":\"month\",\"de\":\"\",\"fr\":\"\"},\"newProject\":{\"zh-cn\":\"\\u65b0\\u589e\\u9879\\u76ee\\u6570\",\"zh-tw\":\"\",\"en\":\"newProject\",\"de\":\"\",\"fr\":\"\"},\"closedProject\":{\"zh-cn\":\"\\u5b8c\\u6210\\u9879\\u76ee\\u6570\",\"zh-tw\":\"\",\"en\":\"closedProject\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT t1.year, CONCAT(t1.month, \"月\") AS `month`, IFNULL(t2.project, 0) AS newProject, IFNULL(t3.project, 0) AS closedProject\nFROM (SELECT DISTINCT Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS project FROM zt_project WHERE deleted = \'0\' AND type = \'project\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS project FROM zt_project WHERE deleted = \'0\' AND type = \'project\' AND status = \'closed\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\nORDER BY `year`, t1.month', `stage` = 'published', `builtin` = 0 WHERE `id` = 1080;
UPDATE `zt_chart` SET `type` = 'line', `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"month\",\"name\":\"month\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"newExecution\",\"name\":\"newExecution\",\"valOrAgg\":\"sum\"},{\"field\":\"closedExecution\",\"name\":\"closedExecution\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"project\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"project\",\"field\":\"month\",\"type\":\"string\"},\"newExecution\":{\"name\":\"newExecution\",\"object\":\"project\",\"field\":\"newExecution\",\"type\":\"string\"},\"closedExecution\":{\"name\":\"closedExecution\",\"object\":\"project\",\"field\":\"closedExecution\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u4efd\",\"zh-tw\":\"\",\"en\":\"month\",\"de\":\"\",\"fr\":\"\"},\"newExecution\":{\"zh-cn\":\"\\u65b0\\u589e\\u6267\\u884c\\u6570\",\"zh-tw\":\"\",\"en\":\"newExecution\",\"de\":\"\",\"fr\":\"\"},\"closedExecution\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6267\\u884c\\u6570\",\"zh-tw\":\"\",\"en\":\"closedExecution\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT t1.year, CONCAT(t1.month, \"月\") AS `month`, IFNULL(t2.execution, 0) AS newExecution, IFNULL(t3.execution, 0) AS closedExecution\nFROM (SELECT DISTINCT YEAR(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS execution FROM zt_project WHERE deleted = \'0\' AND type IN (\'sprint\', \'stage\', \'kanban\') AND multiple = \'1\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS execution FROM zt_project WHERE deleted = \'0\' AND type IN (\'sprint\', \'stage\', \'kanban\') AND status = \'closed\' AND multiple = \'1\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\nORDER BY `year`, t1.month', `stage` = 'published', `builtin` = 0 WHERE `id` = 1081;
UPDATE `zt_chart` SET `type` = 'line', `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"month\",\"name\":\"month\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"release\",\"name\":\"release\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"release\",\"field\":\"year\",\"type\":\"number\"},\"month\":{\"name\":\"month\",\"object\":\"release\",\"field\":\"month\",\"type\":\"string\"},\"release\":{\"name\":\"release\",\"object\":\"release\",\"field\":\"release\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"month\":{\"zh-cn\":\"\\u6708\\u4efd\",\"zh-tw\":\"\",\"en\":\"month\",\"de\":\"\",\"fr\":\"\"},\"release\":{\"zh-cn\":\"\\u53d1\\u5e03\\u6b21\\u6570\",\"zh-tw\":\"\",\"en\":\"release\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT t1.year, CONCAT(t1.month, \"月\") AS `month`, IFNULL(t2.release, 0) AS `release`\nFROM (SELECT DISTINCT Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\nLEFT JOIN (SELECT YEAR(createdDate) AS `year`, MONTH(createdDate) AS `month`, COUNT(1) AS `release` FROM zt_release WHERE deleted = \'0\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\nORDER BY `year`, t1.month', `stage` = 'published', `builtin` = 0 WHERE `id` = 1082;

-- 年度完成项目过程数据大屏
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"name\",\"name\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"daterate\",\"name\":\"daterate\",\"valOrAgg\":\"max\"}]}]', `fields` = '{\"name\":{\"name\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"object\":\"project\",\"field\":\"name\",\"type\":\"string\"},\"closedDate\":{\"name\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"closedDate\",\"type\":\"date\"},\"daterate\":{\"name\":\"daterate\",\"object\":\"project\",\"field\":\"daterate\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"closedDate\",\"type\":\"date\",\"name\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]', `langs` = '{\"name\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"name\",\"de\":\"\",\"fr\":\"\"},\"closedDate\":{\"zh-cn\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"closedDate\",\"de\":\"\",\"fr\":\"\"},\"daterate\":{\"zh-cn\":\"\\u5de5\\u671f\\u504f\\u5dee\\u7387\",\"zh-tw\":\"\",\"en\":\"daterate\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select\nt1.name,\nt1.closedDate,\nround(t1.realduration-t1.planduration)/t1.planduration as daterate\nfrom(\nselect\nname,\nid,\nclosedDate,\nbegin,\nend,\ndatediff(`end`,`begin`) planduration,\nrealBegan,\nrealEnd,\nifnull(if(left(realEnd,4) != \'0000\',datediff(`realEnd`,`realBegan`),datediff(`closedDate`,`realBegan`)),0) realduration\nfrom\nzt_project\nwhere deleted=\'0\'\nand status=\'closed\'\nand type=\'project\'\n) t1', `stage` = 'published', `builtin` = 0 WHERE `id` = 10018;
UPDATE `zt_chart` SET `type` = 'pie', `settings` = '[{\"type\":\"pie\",\"group\":[{\"field\":\"completeStatus\",\"name\":\"completeStatus\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"\\u9879\\u76eeID\",\"valOrAgg\":\"count\"}]}]', `fields` = '{\"id\":{\"name\":\"\\u9879\\u76eeID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"completeStatus\":{\"name\":\"completeStatus\",\"object\":\"project\",\"field\":\"completeStatus\",\"type\":\"string\"},\"closedDate\":{\"name\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"closedDate\",\"type\":\"date\"}}', `filters` = '[{\"field\":\"closedDate\",\"type\":\"date\",\"name\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]', `langs` = '{\"id\":{\"zh-cn\":\"\\u9879\\u76eeID\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"completeStatus\":{\"zh-cn\":\"\\u9879\\u76ee\\u5b8c\\u6210\\u60c5\\u51b5\",\"zh-tw\":\"\",\"en\":\"completeStatus\",\"de\":\"\",\"fr\":\"\"},\"closedDate\":{\"zh-cn\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"closedDate\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select\nt1.id,\n(case when t1.realEnd<t1.end then \"提前完成项目\" when t1.realEnd=t1.end then \"正常完成项目\" else \"延期完成项目\" end) \"completeStatus\",\nt1.closedDate\nfrom(\nselect\nid,\nclosedDate,\nend,\nif(left(realEnd, 4) = \'0000\', closedDate, realEnd) as realEnd\nfrom\nzt_project\nwhere deleted=\'0\'\nand status=\'closed\'\nand type=\'project\') t1', `stage` = 'published', `builtin` = 0 WHERE `id` = 10020;
UPDATE `zt_chart` SET `type` = 'pie', `settings` = '[{\"type\":\"pie\",\"group\":[{\"field\":\"completeStatus\",\"name\":\"completeStatus\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"\\u9879\\u76eeID\",\"valOrAgg\":\"count\"}]}]', `fields` = '{\"id\":{\"name\":\"\\u9879\\u76eeID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"completeStatus\":{\"name\":\"completeStatus\",\"object\":\"project\",\"field\":\"completeStatus\",\"type\":\"string\"},\"closedDate\":{\"name\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"closedDate\",\"type\":\"date\"}}', `filters` = '[{\"field\":\"closedDate\",\"type\":\"date\",\"name\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]', `langs` = '{\"id\":{\"zh-cn\":\"\\u6267\\u884cID\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"completeStatus\":{\"zh-cn\":\"\\u5b8c\\u6210\\u60c5\\u51b5\",\"zh-tw\":\"\",\"en\":\"completeStatus\",\"de\":\"\",\"fr\":\"\"},\"closedDate\":{\"zh-cn\":\"\\u5173\\u95ed\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select\nt1.id,\n(case when t1.realEnd<t1.end then \"提前完成执行\" when t1.realEnd=t1.end then \"正常完成执行\" else \"延期完成执行\" end) \"completeStatus\",\nt1.closedDate\nfrom(\nselect\nid,\nclosedDate,\nend,\nif(left(realEnd, 4) = \'0000\', closedDate, realEnd) as realEnd\nfrom\nzt_project\nwhere deleted=\'0\'\nand status=\'closed\'\nand type=\'sprint\') t1', `stage` = 'published', `builtin` = 0 WHERE `id` = 10021;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"name\",\"name\":\"\\u4efb\\u52a1\\u540d\\u79f0\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"rate\",\"name\":\"rate\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"name\":{\"name\":\"\\u4efb\\u52a1\\u540d\\u79f0\",\"object\":\"project\",\"field\":\"name\",\"type\":\"string\"},\"id\":{\"name\":\"\\u7f16\\u53f7\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"closedDate\":{\"name\":\"\\u5173\\u95ed\\u65f6\\u95f4\",\"object\":\"task\",\"field\":\"closedDate\",\"type\":\"date\"},\"estimate\":{\"name\":\"\\u6700\\u521d\\u9884\\u8ba1\",\"object\":\"task\",\"field\":\"estimate\",\"type\":\"string\"},\"consumed\":{\"name\":\"\\u603b\\u8ba1\\u6d88\\u8017\",\"object\":\"task\",\"field\":\"consumed\",\"type\":\"string\"},\"left\":{\"name\":\"\\u9884\\u8ba1\\u5269\\u4f59\",\"object\":\"task\",\"field\":\"left\",\"type\":\"string\"},\"deviation\":{\"name\":\"deviation\",\"object\":\"task\",\"field\":\"deviation\",\"type\":\"number\"},\"rate\":{\"name\":\"rate\",\"object\":\"task\",\"field\":\"rate\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"closedDate\",\"type\":\"date\",\"name\":\"\\u5173\\u95ed\\u65f6\\u95f4\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]', `langs` = '{\"name\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"name\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"closedDate\":{\"zh-cn\":\"\\u5173\\u95ed\\u65f6\\u95f4\",\"zh-tw\":\"\",\"en\":\"closedDate\",\"de\":\"\",\"fr\":\"\"},\"estimate\":{\"zh-cn\":\"\\u6700\\u521d\\u9884\\u8ba1\",\"zh-tw\":\"\",\"en\":\"estimate\",\"de\":\"\",\"fr\":\"\"},\"consumed\":{\"zh-cn\":\"\\u603b\\u8ba1\\u6d88\\u8017\",\"zh-tw\":\"\",\"en\":\"consumed\",\"de\":\"\",\"fr\":\"\"},\"left\":{\"zh-cn\":\"\\u9884\\u8ba1\\u5269\\u4f59\",\"zh-tw\":\"\",\"en\":\"left\",\"de\":\"\",\"fr\":\"\"},\"deviation\":{\"zh-cn\":\"\\u504f\\u5dee\",\"zh-tw\":\"\",\"en\":\"deviation\",\"de\":\"\",\"fr\":\"\"},\"rate\":{\"zh-cn\":\"\\u504f\\u5dee\\u6bd4\\u7387\",\"zh-tw\":\"\",\"en\":\"rate\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select\n*,\nround(tt.deviation/tt.estimate,3) rate\nfrom(\nselect\nt1.name,\nt1.id,\nt1.closedDate,\nt2.estimate estimate,\nt2.consumed consumed,\nt2.`left`,\nt2.consumed-t2.estimate deviation\nfrom\nzt_project t1\nleft join\n(select\nproject,\nsum(estimate) estimate,\nsum(consumed) consumed,\nsum(`left`) `left`\nfrom\nzt_task\ngroup by project) t2\non t1.id=t2.project\nwhere t1.deleted=\'0\'\nand t1.status=\'closed\'\nand t1.type=\'project\') tt', `stage` = 'published', `builtin` = 0 WHERE `id` = 10022;

-- 公司质量数据盘点大屏
UPDATE `zt_chart` SET `type` = 'line', `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"year\",\"name\":\"year\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"effectiveBugRate\",\"name\":\"effectiveBugRate\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"bug\",\"field\":\"year\",\"type\":\"string\"},\"totalBugCount\":{\"name\":\"totalBugCount\",\"object\":\"bug\",\"field\":\"totalBugCount\",\"type\":\"string\"},\"effectiveBugCount\":{\"name\":\"effectiveBugCount\",\"object\":\"bug\",\"field\":\"effectiveBugCount\",\"type\":\"number\"},\"effectiveBugRate\":{\"name\":\"effectiveBugRate\",\"object\":\"bug\",\"field\":\"effectiveBugRate\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"Year\",\"de\":\"\",\"fr\":\"\"},\"totalBugCount\":{\"zh-cn\":\"Bug\\u603b\\u6570\",\"zh-tw\":\"\",\"en\":\"Total Bug Count\",\"de\":\"\",\"fr\":\"\"},\"effectiveBugCount\":{\"zh-cn\":\"\\u6709\\u6548Bug\\u6570\",\"zh-tw\":\"\",\"en\":\"Effective Bug Count\",\"de\":\"\",\"fr\":\"\"},\"effectiveBugRate\":{\"zh-cn\":\"\\u6709\\u6548Bug\\u7387\",\"zh-tw\":\"\",\"en\":\"Effective Bug Rate\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select\nyear,\ncount(a.id) as totalBugCount,\nsum(a.effectivebug) as effectiveBugCount,\nsum(a.effectivebug)/count(a.id) effectiveBugRate\nfrom(\nselect \nleft(openedDate,4) year,\nid,\n(case when  resolution in (\'fixed\',\'postponed\') or status=\'active\' then 1 else 0 end) effectivebug,\n(case when  resolution=\'fixed\' then 1 else 0 end) fixedBug\nfrom zt_bug\nwhere zt_bug.deleted=\'0\'\n) a\ngroup by a.year\norder by  a.year', `stage` = 'published', `builtin` = 0 WHERE `id` = 10212;
UPDATE `zt_chart` SET `type` = 'line', `settings` = '[{\"type\":\"line\",\"xaxis\":[{\"field\":\"year\",\"name\":\"year\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"bugCount\",\"name\":\"Bug\\u6570\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"string\"},\"createdBugs\":{\"name\":\"createdBugs\",\"object\":\"story\",\"field\":\"createdBugs\",\"type\":\"string\"},\"exfixedstoryestimate\":{\"name\":\"exfixedstoryestimate\",\"object\":\"story\",\"field\":\"exfixedstoryestimate\",\"type\":\"number\"},\"bugCount\":{\"name\":\"Bug\\u6570\",\"object\":\"story\",\"field\":\"bugCount\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"Year\",\"de\":\"\",\"fr\":\"\"},\"createdBugs\":{\"zh-cn\":\"\\u4ea7\\u751fBug\",\"zh-tw\":\"\",\"en\":\"Created Bug\",\"de\":\"\",\"fr\":\"\"},\"exfixedstoryestimate\":{\"zh-cn\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\",\"en\":\"Finished Story\",\"de\":\"\",\"fr\":\"\"},\"bugCount\":{\"zh-cn\":\"\\u5355\\u4f4d\\u5b8c\\u6210\\u9700\\u6c42\\u89c4\\u6a21\\u4ea7\\u751f\\u7684Bug\\u6570\",\"zh-tw\":\"\",\"en\":\"Bug Density\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select\nbug.year as year,\ncreatedBugs, \nexfixedstoryestimate,\nround(createdBugs/exfixedstoryestimate,2) as bugCount                                                                                                                                                             \nfrom\n(select \nleft(openedDate,4) year,\ncount(id) createdBugs\nfrom zt_bug\nwhere zt_bug.deleted=\'0\'\ngroup by year\n) bug \nleft join\n(select\nsum(estimate) exfixedstoryestimate,\nleft(closedDate,4) year\nfrom\nzt_story\nwhere zt_story.deleted=\'0\' and zt_story.status=\'closed\' and zt_story.closedReason=\'done\'\ngroup by year\n) story\non story.year=bug.year\norder by bug.year', `stage` = 'published', `builtin` = 0 WHERE `id` = 10213;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"name\",\"name\":\"name\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"count\",\"name\":\"count\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"name\":{\"name\":\"name\",\"object\":\"product\",\"field\":\"name\",\"type\":\"string\"},\"count\":{\"name\":\"count\",\"object\":\"testcase\",\"field\":\"id\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"name\",\"type\":\"select\",\"name\":\"\\u4ea7\\u54c1\"}]', `langs` = '{\"name\":{\"zh-cn\":\"\\u4ea7\\u54c1\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"Product\",\"de\":\"\",\"fr\":\"\"},\"count\":{\"zh-cn\":\"\\u7528\\u4f8b\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"Case Count\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select \nt1.name,\nifnull(t2.cases,0) as count\nfrom\nzt_product t1\nleft join\n(\nselect\nproduct,\ncount(id) cases \nfrom\nzt_case\nwhere deleted=\'0\'\ngroup by product )\nt2 on t1.id=t2.product', `stage` = 'published', `builtin` = 0 WHERE `id` = 10215;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"name\",\"name\":\"name\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"bug\",\"name\":\"bug\",\"valOrAgg\":\"sum\"}],\"rotateX\":\"notuse\"}]', `fields` = '{\"name\":{\"name\":\"name\",\"object\":\"product\",\"field\":\"name\",\"type\":\"string\"},\"bug\":{\"name\":\"bug\",\"object\":\"bug\",\"field\":\"id\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"name\",\"type\":\"select\",\"name\":\"\\u4ea7\\u54c1\"}]', `langs` = '{\"name\":{\"zh-cn\":\"\\u4ea7\\u54c1\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"Product\",\"de\":\"\",\"fr\":\"\"},\"bug\":{\"zh-cn\":\"Bug\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"Bug Count\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select \nt1.name,\nifnull(t2.bugs,0) bug\nfrom\nzt_product t1\nleft join\n(\nselect\nproduct,\ncount(id) bugs \nfrom\nzt_bug\nwhere zt_bug.deleted=\'0\'\ngroup by product )\nt2 on t1.id=t2.product', `stage` = 'published', `builtin` = 0 WHERE `id` = 10216;
UPDATE `zt_chart` SET `type` = 'pie', `settings` = '[{\"type\":\"pie\",\"group\":[{\"field\":\"status\",\"name\":\"Bug\\u72b6\\u6001\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"Bug\\u7f16\\u53f7\",\"valOrAgg\":\"count\"}]}]', `fields` = '{\"id\":{\"name\":\"Bug\\u7f16\\u53f7\",\"object\":\"bug\",\"field\":\"id\",\"type\":\"number\"},\"status\":{\"name\":\"Bug\\u72b6\\u6001\",\"object\":\"bug\",\"field\":\"status\",\"type\":\"option\"},\"openedDate\":{\"name\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"object\":\"bug\",\"field\":\"openedDate\",\"type\":\"date\"}}', `filters` = '[{\"field\":\"openedDate\",\"type\":\"date\",\"name\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]', `langs` = '{\"id\":{\"zh-cn\":\"Bug\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"Bug ID\",\"de\":\"\",\"fr\":\"\"},\"status\":{\"zh-cn\":\"Bug\\u72b6\\u6001\",\"zh-tw\":\"\",\"en\":\"Status\",\"de\":\"\",\"fr\":\"\"},\"openedDate\":{\"zh-cn\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"Opened Date\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select \nid,status,openedDate \nfrom zt_bug\nwhere deleted=\'0\'', `stage` = 'published', `builtin` = 0 WHERE `id` = 10217;
UPDATE `zt_chart` SET `type` = 'pie', `settings` = '[{\"type\":\"pie\",\"group\":[{\"field\":\"type\",\"name\":\"Bug\\u7c7b\\u578b\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"Bug\\u7f16\\u53f7\",\"valOrAgg\":\"count\"}]}]', `fields` = '{\"id\":{\"name\":\"Bug\\u7f16\\u53f7\",\"object\":\"bug\",\"field\":\"id\",\"type\":\"number\"},\"type\":{\"name\":\"Bug\\u7c7b\\u578b\",\"object\":\"bug\",\"field\":\"type\",\"type\":\"option\"},\"openedDate\":{\"name\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"object\":\"bug\",\"field\":\"openedDate\",\"type\":\"date\"}}', `filters` = '[{\"field\":\"openedDate\",\"type\":\"date\",\"name\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]', `langs` = '{\"id\":{\"zh-cn\":\"Bug\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"Bug ID\",\"de\":\"\",\"fr\":\"\"},\"type\":{\"zh-cn\":\"Bug\\u7c7b\\u578b\",\"zh-tw\":\"\",\"en\":\"Type\",\"de\":\"\",\"fr\":\"\"},\"openedDate\":{\"zh-cn\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"Opened Date\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select\nid,type,openedDate\nfrom\nzt_bug\nwhere deleted=\'0\'', `stage` = 'published', `builtin` = 0 WHERE `id` = 10218;
UPDATE `zt_chart` SET `type` = 'pie', `settings` = '[{\"type\":\"pie\",\"group\":[{\"field\":\"severity\",\"name\":\"\\u4e25\\u91cd\\u7a0b\\u5ea6\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"Bug\\u7f16\\u53f7\",\"valOrAgg\":\"count\"}]}]', `fields` = '{\"id\":{\"name\":\"Bug\\u7f16\\u53f7\",\"object\":\"bug\",\"field\":\"id\",\"type\":\"number\"},\"severity\":{\"name\":\"\\u4e25\\u91cd\\u7a0b\\u5ea6\",\"object\":\"bug\",\"field\":\"severity\",\"type\":\"option\"},\"openedDate\":{\"name\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"object\":\"bug\",\"field\":\"openedDate\",\"type\":\"date\"}}', `filters` = '[{\"field\":\"openedDate\",\"type\":\"date\",\"name\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]', `langs` = '{\"id\":{\"zh-cn\":\"Bug\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"Bug ID\",\"de\":\"\",\"fr\":\"\"},\"severity\":{\"zh-cn\":\"\\u4e25\\u91cd\\u7a0b\\u5ea6\",\"zh-tw\":\"\",\"en\":\"Severity\",\"de\":\"\",\"fr\":\"\"},\"openedDate\":{\"zh-cn\":\"\\u521b\\u5efa\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"Opened Date\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select\nid,severity,openedDate\nfrom\nzt_bug\nwhere deleted=\'0\'', `stage` = 'published', `builtin` = 0 WHERE `id` = 10219;
UPDATE `zt_chart` SET `type` = 'pie', `settings` = '[{\"type\":\"pie\",\"group\":[{\"field\":\"resolution\",\"name\":\"\\u89e3\\u51b3\\u65b9\\u6848\",\"group\":\"\"}],\"metric\":[{\"field\":\"id\",\"name\":\"Bug\\u7f16\\u53f7\",\"valOrAgg\":\"count\"}]}]', `fields` = '{\"id\":{\"name\":\"Bug\\u7f16\\u53f7\",\"object\":\"bug\",\"field\":\"id\",\"type\":\"number\"},\"resolution\":{\"name\":\"\\u89e3\\u51b3\\u65b9\\u6848\",\"object\":\"bug\",\"field\":\"resolution\",\"type\":\"option\"},\"resolvedDate\":{\"name\":\"\\u89e3\\u51b3\\u65e5\\u671f\",\"object\":\"bug\",\"field\":\"resolvedDate\",\"type\":\"date\"}}', `filters` = '[{\"field\":\"resolvedDate\",\"type\":\"date\",\"name\":\"\\u89e3\\u51b3\\u65e5\\u671f\",\"default\":{\"begin\":\"\",\"end\":\"\"}}]', `langs` = '{\"id\":{\"zh-cn\":\"Bug\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"Bug ID\",\"de\":\"\",\"fr\":\"\"},\"resolution\":{\"zh-cn\":\"\\u89e3\\u51b3\\u65b9\\u6848\",\"zh-tw\":\"\",\"en\":\"Resolution\",\"de\":\"\",\"fr\":\"\"},\"resolvedDate\":{\"zh-cn\":\"\\u89e3\\u51b3\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"Resolved Date\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'select id,resolution,resolvedDate from zt_bug\nwhere deleted=\'0\' and resolution!=\' \'', `stage` = 'published', `builtin` = 0 WHERE `id` = 10220;

UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"program\",\"name\":\"program\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"budget\",\"name\":\"\\u9884\\u7b97\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"project\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_project\",\"field\":\"id\",\"type\":\"number\"},\"program\":{\"name\":\"program\",\"object\":\"zt_project\",\"field\":\"program\",\"type\":\"string\"},\"budget\":{\"name\":\"\\u9884\\u7b97\",\"object\":\"project\",\"field\":\"budget\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"program\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"program\",\"de\":\"\",\"fr\":\"\"},\"budget\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u9884\\u7b97\",\"zh-tw\":\"\",\"en\":\"budget\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  YEAR(t2.openedDate) AS `year`, \n  t1.id,\n  t1.name AS program, \n  ROUND(\n    SUM(\n      IFNULL(t2.budget, 0)\n    ) / 10000, \n    2\n  ) AS budget \nFROM \n  zt_project AS t1 \n  LEFT JOIN zt_project AS t2 ON FIND_IN_SET(t1.id, t2.path) \n  AND t2.deleted = \'0\' \n  AND t2.type = \'project\' \nWHERE \n  t1.deleted = \'0\' \n  AND t1.type = \'program\' \n  AND t1.grade = 1 \nGROUP BY \n  `year`, \n  id,\n  program \nORDER BY \n  `year`, \n  budget DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1085;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"setName\",\"name\":\"setName\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"number\",\"name\":\"number\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"user\",\"field\":\"year\",\"type\":\"number\"},\"number\":{\"name\":\"number\",\"object\":\"user\",\"field\":\"number\",\"type\":\"string\"},\"setName\":{\"name\":\"setName\",\"object\":\"user\",\"field\":\"setName\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"number\":{\"zh-cn\":\"\\u4eba\\u5458\\u6570\\u91cf\",\"zh-tw\":\"\",\"en\":\"number\",\"de\":\"\",\"fr\":\"\"},\"setName\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"setName\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT tt.join as `year`, count(1) as number, tt.setName from (\nselect \nYEAR(t1.join) as `join`, t4.name as setName \nfrom zt_team t1 \nRIGHT JOIN zt_project t2 on t2.id = t1.root\nLEFT JOIN zt_project t4 on FIND_IN_SET(t4.id,t2.path) and t4.grade = 1\nRIGHT JOIN zt_user t3 on t3.account = t1.account\nWHERE t1.type = \'project\'\nAND t2.deleted = \'0\'\nAND t3.deleted = \'0\'\n) tt\nGROUP BY tt.setName, tt.join\nORDER BY tt.join, number desc, tt.setName', `stage` = 'published', `builtin` = 0 WHERE `id` = 1086;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"program\",\"name\":\"program\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"consumed\",\"name\":\"\\u603b\\u8ba1\\u6d88\\u8017\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"effort\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_project\",\"field\":\"id\",\"type\":\"number\"},\"program\":{\"name\":\"program\",\"object\":\"zt_project\",\"field\":\"program\",\"type\":\"string\"},\"consumed\":{\"name\":\"\\u603b\\u8ba1\\u6d88\\u8017\",\"object\":\"task\",\"field\":\"consumed\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"program\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"program\",\"de\":\"\",\"fr\":\"\"},\"consumed\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u603b\\u8ba1\\u6d88\\u8017\",\"zh-tw\":\"\",\"en\":\"program\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  YEAR(t5.date) AS `year`, \n  t1.id,\n  t1.name AS program, \n  ROUND(\n    SUM(t5.consumed), \n    2\n  ) AS consumed \nFROM \n  zt_project AS t1 \n  LEFT JOIN zt_project AS t2 ON FIND_IN_SET(t1.id, t2.path) \n  AND t2.deleted = \'0\' \n  AND t2.type = \'project\' \n  LEFT JOIN zt_project AS t3 ON t2.id = t3.parent \n  AND t3.deleted = \'0\' \n  AND t3.type IN (\'sprint\', \'stage\', \'kanban\') \n  LEFT JOIN zt_task AS t4 ON t3.id = t4.execution \n  AND t4.deleted = \'0\' \n  AND t4.status != \'cancel\' \n  LEFT JOIN zt_effort AS t5 ON t4.id = t5.objectID \n  AND t5.deleted = \'0\' \n  AND t5.objectType = \'task\' \nWHERE \n  t1.deleted = \'0\' \n  AND t1.type = \'program\' \n  AND t1.grade = 1 \n  AND t5.id IS NOT NULL \nGROUP BY \n  `year`, \n  id,\n  program \nORDER BY \n  `year`, \n  consumed DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1087;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"program\",\"name\":\"program\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"story\",\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_project\",\"field\":\"id\",\"type\":\"number\"},\"program\":{\"name\":\"program\",\"object\":\"zt_project\",\"field\":\"program\",\"type\":\"string\"},\"story\":{\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"object\":\"story\",\"field\":\"story\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"program\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"program\",\"de\":\"\",\"fr\":\"\"},\"story\":{\"zh-cn\":\"\\u65b0\\u589e\\u7814\\u53d1\\u9700\\u6c42\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"story\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  YEAR(t3.openedDate) AS `year`,\n  t1.id, \n  t1.name AS program, \n  COUNT(1) AS story \nFROM \n  zt_project AS t1 \n  LEFT JOIN zt_product AS t2 ON t1.id = t2.program \n  AND t2.deleted = \'0\' \n  LEFT JOIN zt_story AS t3 ON t2.id = t3.product \n  AND t3.deleted = \'0\' \nWHERE \n  t1.deleted = \'0\' \n  AND t1.type = \'program\' \n  AND t1.grade = 1 \n  AND t3.id IS NOT NULL \nGROUP BY \n  `year`, \n  id,\n  program \nORDER BY \n  `year`, \n  story DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1088;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"program\",\"name\":\"program\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"story\",\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_project\",\"field\":\"id\",\"type\":\"number\"},\"program\":{\"name\":\"program\",\"object\":\"zt_project\",\"field\":\"program\",\"type\":\"string\"},\"story\":{\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"object\":\"story\",\"field\":\"story\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"program\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"program\",\"de\":\"\",\"fr\":\"\"},\"story\":{\"zh-cn\":\"\\u65b0\\u589e\\u7814\\u53d1\\u9700\\u6c42\\u89c4\\u6a21\",\"zh-tw\":\"\",\"en\":\"\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  YEAR(t3.openedDate) AS `year`, \n  t1.id,\n  t1.name AS program, \n  ROUND(\n    SUM(t3.estimate), \n    2\n  ) AS story \nFROM \n  zt_project AS t1 \n  LEFT JOIN zt_product AS t2 ON t1.id = t2.program \n  AND t2.deleted = \'0\' \n  LEFT JOIN zt_story AS t3 ON t2.id = t3.product \n  AND t3.deleted = \'0\' \nWHERE \n  t1.deleted = \'0\' \n  AND t1.type = \'program\' \n  AND t1.grade = 1 \n  AND t3.id IS NOT NULL \nGROUP BY \n  `year`,\n  id, \n  program \nORDER BY \n  `year`, \n  story DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1089;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"program\",\"name\":\"program\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"bug\",\"name\":\"Bug\\u5217\\u8868\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"bug\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_project\",\"field\":\"id\",\"type\":\"number\"},\"program\":{\"name\":\"program\",\"object\":\"zt_project\",\"field\":\"program\",\"type\":\"string\"},\"bug\":{\"name\":\"Bug\\u5217\\u8868\",\"object\":\"project\",\"field\":\"bug\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"program\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"program\",\"de\":\"\",\"fr\":\"\"},\"bug\":{\"zh-cn\":\"\\u65b0\\u589eBug\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"bug\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  YEAR(t3.openedDate) AS `year`,\n  t1.id, \n  t1.name AS program, \n  COUNT(1) AS bug \nFROM \n  zt_project AS t1 \n  LEFT JOIN zt_product AS t2 ON t1.id = t2.program \n  AND t2.deleted = \'0\' \n  LEFT JOIN zt_bug AS t3 ON t2.id = t3.product \n  AND t3.deleted = \'0\' \nWHERE \n  t1.deleted = \'0\' \n  AND t1.type = \'program\' \n  AND t1.grade = 1 \n  AND t3.id IS NOT NULL \nGROUP BY \n  `year`, \n  id,\n  program \nORDER BY \n  `year`, \n  bug DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1090;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"program\",\"name\":\"program\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"story\",\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_project\",\"field\":\"id\",\"type\":\"number\"},\"program\":{\"name\":\"program\",\"object\":\"zt_project\",\"field\":\"program\",\"type\":\"string\"},\"story\":{\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"object\":\"story\",\"field\":\"story\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"program\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"program\",\"de\":\"\",\"fr\":\"\"},\"story\":{\"zh-cn\":\"\\u5b8c\\u6210\\u7814\\u53d1\\u9700\\u6c42\\u6c42\\u548c\",\"zh-tw\":\"\",\"en\":\"story\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  YEAR(t3.closedDate) AS `year`, \n  t1.id,\n  t1.name AS program, \n  COUNT(1) AS story \nFROM \n  zt_project AS t1 \n  LEFT JOIN zt_product AS t2 ON t1.id = t2.program \n  AND t2.deleted = \'0\' \n  LEFT JOIN zt_story AS t3 ON t2.id = t3.product \n  AND t3.deleted = \'0\' \n  AND t3.closedReason = \'done\' \nWHERE \n  t1.deleted = \'0\' \n  AND t1.type = \'program\' \n  AND t1.grade = 1 \n  AND t3.id IS NOT NULL \nGROUP BY \n  `year`,\n  id,  \n  program \nORDER BY \n  `year`, \n  story DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1091;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"program\",\"name\":\"program\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"story\",\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_project\",\"field\":\"id\",\"type\":\"number\"},\"program\":{\"name\":\"program\",\"object\":\"zt_project\",\"field\":\"program\",\"type\":\"string\"},\"story\":{\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"object\":\"story\",\"field\":\"story\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"program\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"program\",\"de\":\"\",\"fr\":\"\"},\"story\":{\"zh-cn\":\"\\u7814\\u53d1\\u9700\\u6c42\\u9884\\u8ba1\\u5de5\\u65f6\\u6c42\\u548c\",\"zh-tw\":\"\",\"en\":\"story\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  YEAR(t3.closedDate) AS `year`, \n  t1.id,\n  t1.name AS program, \n  ROUND(\n    SUM(t3.estimate), \n    2\n  ) AS story \nFROM \n  zt_project AS t1 \n  LEFT JOIN zt_product AS t2 ON t1.id = t2.program \n  AND t2.deleted = \'0\' \n  LEFT JOIN zt_story AS t3 ON t2.id = t3.product \n  AND t3.deleted = \'0\' \n  AND t3.closedReason = \'done\' \nWHERE \n  t1.deleted = \'0\' \n  AND t1.type = \'program\' \n  AND t1.grade = 1 \n  AND t3.id IS NOT NULL \nGROUP BY \n  `year`, \n  id,\n  program \nORDER BY \n  `year`, \n  story DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1092;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"program\",\"name\":\"program\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"bug\",\"name\":\"Bug\\u5217\\u8868\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"bug\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_project\",\"field\":\"id\",\"type\":\"number\"},\"program\":{\"name\":\"program\",\"object\":\"zt_project\",\"field\":\"program\",\"type\":\"string\"},\"bug\":{\"name\":\"Bug\\u5217\\u8868\",\"object\":\"project\",\"field\":\"bug\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"program\":{\"zh-cn\":\"\\u9879\\u76ee\\u96c6\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"program\",\"de\":\"\",\"fr\":\"\"},\"bug\":{\"zh-cn\":\"Bug\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"bug\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  YEAR(t3.closedDate) AS `year`,\n  t1.id,  \n  t1.name AS program, \n  COUNT(1) AS bug \nFROM \n  zt_project AS t1 \n  LEFT JOIN zt_product AS t2 ON t1.id = t2.program \n  AND t2.deleted = \'0\' \n  LEFT JOIN zt_bug AS t3 ON t2.id = t3.product \n  AND t3.deleted = \'0\' \n  AND t3.resolution = \'fixed\' \n  AND t3.status = \'closed\' \nWHERE \n  t1.deleted = \'0\' \n  AND t1.type = \'program\' \n  AND t1.grade = 1 \n  AND t3.id IS NOT NULL \nGROUP BY \n  `year`, \n  id,\n  program \nORDER BY \n  `year`, \n  bug DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1093;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"name\",\"name\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"duration\",\"name\":\"duration\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"project\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"\\u7f16\\u53f7\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"name\":{\"name\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"object\":\"project\",\"field\":\"name\",\"type\":\"string\"},\"status\":{\"name\":\"\\u72b6\\u6001\",\"object\":\"project\",\"field\":\"status\",\"type\":\"option\"},\"realBegan\":{\"name\":\"\\u5b9e\\u9645\\u5f00\\u59cb\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"realBegan\",\"type\":\"date\"},\"realEnd\":{\"name\":\"\\u5b9e\\u9645\\u5b8c\\u6210\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"realEnd\",\"type\":\"date\"},\"duration\":{\"name\":\"duration\",\"object\":\"project\",\"field\":\"duration\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"name\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"name\",\"de\":\"\",\"fr\":\"\"},\"status\":{\"zh-cn\":\"\\u72b6\\u6001\",\"zh-tw\":\"\",\"en\":\"status\",\"de\":\"\",\"fr\":\"\"},\"realBegan\":{\"zh-cn\":\"\\u5b9e\\u9645\\u5f00\\u59cb\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"realBegan\",\"de\":\"\",\"fr\":\"\"},\"realEnd\":{\"zh-cn\":\"\\u5b9e\\u9645\\u5b8c\\u6210\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"realEnd\",\"de\":\"\",\"fr\":\"\"},\"duration\":{\"zh-cn\":\"\\u5de5\\u671f\",\"zh-tw\":\"\",\"en\":\"duration\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT `year`, id,name,status,realBegan,realEnd,IF(status = \'closed\', DATEDIFF(realEnd, realBegan), DATEDIFF(NOW(),realBegan)) as duration\nFROM (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) AS t1\nLEFT JOIN zt_project AS t2 ON 1 = 1 WHERE deleted = \'0\' AND type = \'project\' AND YEAR(realBegan) <= `year` AND LEFT(realBegan, 4) != \'0000\' AND (status =\'doing\' OR (status = \'suspended\' AND YEAR(suspendedDate) >= `year`) OR (status = \'closed\' AND YEAR(realEnd) >= `year`)) HAVING 1=1 ORDER BY `year`, duration desc', `stage` = 'published', `builtin` = 0 WHERE `id` = 1094;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"name\",\"name\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"duration\",\"name\":\"duration\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"project\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"\\u7f16\\u53f7\",\"object\":\"action\",\"field\":\"id\",\"type\":\"number\"},\"name\":{\"name\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"object\":\"project\",\"field\":\"name\",\"type\":\"string\"},\"status\":{\"name\":\"\\u72b6\\u6001\",\"object\":\"project\",\"field\":\"status\",\"type\":\"option\"},\"begin\":{\"name\":\"\\u8ba1\\u5212\\u5f00\\u59cb\",\"object\":\"project\",\"field\":\"begin\",\"type\":\"date\"},\"end\":{\"name\":\"\\u8ba1\\u5212\\u5b8c\\u6210\",\"object\":\"project\",\"field\":\"end\",\"type\":\"date\"},\"realBegan\":{\"name\":\"\\u5b9e\\u9645\\u5f00\\u59cb\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"realBegan\",\"type\":\"date\"},\"realEnd\":{\"name\":\"\\u5b9e\\u9645\\u5b8c\\u6210\\u65e5\\u671f\",\"object\":\"project\",\"field\":\"realEnd\",\"type\":\"date\"},\"duration\":{\"name\":\"duration\",\"object\":\"project\",\"field\":\"duration\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"name\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"name\",\"de\":\"\",\"fr\":\"\"},\"status\":{\"zh-cn\":\"\\u72b6\\u6001\",\"zh-tw\":\"\",\"en\":\"status\",\"de\":\"\",\"fr\":\"\"},\"begin\":{\"zh-cn\":\"\\u8ba1\\u5212\\u5f00\\u59cb\",\"zh-tw\":\"\",\"en\":\"begin\",\"de\":\"\",\"fr\":\"\"},\"end\":{\"zh-cn\":\"\\u8ba1\\u5212\\u5b8c\\u6210\",\"zh-tw\":\"\",\"en\":\"end\",\"de\":\"\",\"fr\":\"\"},\"realBegan\":{\"zh-cn\":\"\\u5b9e\\u9645\\u5f00\\u59cb\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"realBegan\",\"de\":\"\",\"fr\":\"\"},\"realEnd\":{\"zh-cn\":\"\\u5b9e\\u9645\\u5b8c\\u6210\\u65e5\\u671f\",\"zh-tw\":\"\",\"en\":\"realEnd\",\"de\":\"\",\"fr\":\"\"},\"duration\":{\"zh-cn\":\"\\u5de5\\u671f\\u504f\\u5dee\",\"zh-tw\":\"\",\"en\":\"duration\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT `year`, id,name,status,`begin`,`end`,realBegan,realEnd,\nROUND((IF(LEFT(realEnd,4) != \'0000\', DATEDIFF(realEnd, realBegan), DATEDIFF(NOW(),realBegan)) - DATEDIFF(`end`, `begin`)) / DATEDIFF(`end`,`begin`) * 100) as duration\nFROM (SELECT DISTINCT YEAR(`date`) as \'year\' FROM zt_action) AS t1\nLEFT JOIN zt_project AS t2 ON 1 = 1 \nWHERE deleted = \'0\' AND type = \'project\'\nAND YEAR(realBegan) <= `year` AND LEFT(realBegan, 4) != \'0000\'\nAND (YEAR(realEnd) >= `year` OR LEFT(realEnd, 4) = \'0000\') AND YEAR(`end`) != \'2059\'\nHAVING 1=1\nORDER BY duration ASC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1096;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"name\",\"name\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"number\",\"name\":\"number\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"user\",\"field\":\"year\",\"type\":\"number\"},\"number\":{\"name\":\"number\",\"object\":\"user\",\"field\":\"number\",\"type\":\"string\"},\"name\":{\"name\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"object\":\"project\",\"field\":\"name\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"number\":{\"zh-cn\":\"\\u4eba\\u5458\\u4e2a\\u6570\",\"zh-tw\":\"\",\"en\":\"number\",\"de\":\"\",\"fr\":\"\"},\"name\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\",\"zh-tw\":\"\",\"en\":\"name\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT tt.join as `year`, count(1) as number, tt.name from (\nselect \nt2.name, YEAR(t1.join) as `join`\nfrom zt_team t1 \nRIGHT JOIN zt_project t2 on t2.id = t1.root\nRIGHT JOIN zt_user t3 on t3.account = t1.account\nWHERE t1.type = \'project\'\nAND t2.deleted = \'0\'\n) tt\nGROUP BY tt.`name`, tt.join\nORDER BY tt.join, number desc, tt.name', `stage` = 'published', `builtin` = 0 WHERE `id` = 1097;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"project\",\"name\":\"project\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"consumed\",\"name\":\"\\u603b\\u8ba1\\u6d88\\u8017\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"effort\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_project\",\"field\":\"id\",\"type\":\"number\"},\"project\":{\"name\":\"project\",\"object\":\"zt_project\",\"field\":\"project\",\"type\":\"string\"},\"consumed\":{\"name\":\"\\u603b\\u8ba1\\u6d88\\u8017\",\"object\":\"task\",\"field\":\"consumed\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"project\":{\"zh-cn\":\"\\u9879\\u76ee\",\"zh-tw\":\"\",\"en\":\"project\",\"de\":\"\",\"fr\":\"\"},\"consumed\":{\"zh-cn\":\"\\u4efb\\u52a1\\u603b\\u8ba1\\u6d88\\u8017\",\"zh-tw\":\"\",\"en\":\"consumed\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  YEAR(t4.date) AS `year`,\n  t1.id,  \n  t1.name AS project, \n  ROUND(\n    SUM(t4.consumed), \n    2\n  ) AS consumed \nFROM \n  zt_project AS t1 \n  LEFT JOIN zt_project AS t2 ON t1.id = t2.parent \n  AND t2.deleted = \'0\' \n  AND t2.type IN (\'sprint\', \'stage\', \'kanban\') \n  LEFT JOIN zt_task AS t3 ON t2.id = t3.execution \n  AND t3.deleted = \'0\' \n  AND t3.status != \'cancel\' \n  LEFT JOIN zt_effort AS t4 ON t3.id = t4.objectID \n  AND t4.deleted = \'0\' \n  AND t4.objectType = \'task\' \nWHERE \n  t1.deleted = \'0\' \n  AND t1.type = \'project\' \n  AND t4.id IS NOT NULL \nGROUP BY \n  `year`, \n  id,\n  project \nORDER BY \n  `year`, \n  consumed DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1098;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"project\",\"name\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"story\",\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\\u5217\\u8868\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"\\u9879\\u76eeID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"project\":{\"name\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"object\":\"project\",\"field\":\"project\",\"type\":\"string\"},\"story\":{\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\\u5217\\u8868\",\"object\":\"projectstory\",\"field\":\"story\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"project\":{\"zh-cn\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"zh-tw\":\"\",\"en\":\"project\",\"de\":\"\",\"fr\":\"\"},\"story\":{\"zh-cn\":\"\\u7814\\u53d1\\u9700\\u6c42\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"story\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  YEAR(t1.closedDate) AS `year`, \n  t1.id, \n  t1.project, \n  COUNT(1) AS story \nFROM \n  (\n    SELECT \n      DISTINCT t1.id, \n      t1.name AS project, \n      t4.id AS story, \n      t4.closedDate \n    FROM \n      zt_project AS t1 \n      LEFT JOIN zt_project AS t2 ON t1.id = t2.parent \n      AND t2.deleted = \'0\' \n      AND t2.type IN (\'sprint\', \'stage\', \'kanban\') \n      LEFT JOIN zt_projectstory AS t3 ON t2.id = t3.project \n      LEFT JOIN zt_story AS t4 ON t3.story = t4.id \n      AND t4.deleted = \'0\' \n      AND t4.closedReason = \'done\' \n    WHERE \n      t1.deleted = \'0\' \n      AND t1.type = \'project\' \n      AND t4.id IS NOT NULL\n  ) AS t1 \nGROUP BY \n  `year`, \n  id, \n  project \nORDER BY \n  `year`, \n  story DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1099;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"project\",\"name\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"story\",\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\\u5217\\u8868\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"\\u9879\\u76eeID\",\"object\":\"project\",\"field\":\"id\",\"type\":\"number\"},\"project\":{\"name\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"object\":\"project\",\"field\":\"project\",\"type\":\"string\"},\"story\":{\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\\u5217\\u8868\",\"object\":\"projectstory\",\"field\":\"story\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u9879\\u76ee\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"project\":{\"zh-cn\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"zh-tw\":\"\",\"en\":\"project\",\"de\":\"\",\"fr\":\"\"},\"story\":{\"zh-cn\":\"\\u9700\\u6c42\\u9884\\u8ba1\\u5de5\\u65f6\",\"zh-tw\":\"\",\"en\":\"story\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \n  YEAR(t1.closedDate) AS `year`, \n  t1.id, \n  t1.project, \n  ROUND(\n    SUM(t1.estimate), \n    2\n  ) AS story \nFROM \n  (\n    SELECT \n      DISTINCT t1.id, \n      t1.name AS project, \n      t4.id AS story, \n      t4.estimate, \n      t4.closedDate \n    FROM \n      zt_project AS t1 \n      LEFT JOIN zt_project AS t2 ON t1.id = t2.parent \n      AND t2.deleted = \'0\' \n      AND t2.type IN (\'sprint\', \'stage\', \'kanban\') \n      LEFT JOIN zt_projectstory AS t3 ON t2.id = t3.project \n      LEFT JOIN zt_story AS t4 ON t3.story = t4.id \n      AND t4.deleted = \'0\' \n      AND t4.closedReason = \'done\' \n    WHERE \n      t1.deleted = \'0\' \n      AND t1.type = \'project\' \n      AND t4.id IS NOT NULL\n  ) AS t1 \nGROUP BY \n  `year`, \n  id, \n  project \nORDER BY \n  `year`, \n  story DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1100;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"product\",\"name\":\"product\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"story\",\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_product\",\"field\":\"id\",\"type\":\"number\"},\"product\":{\"name\":\"product\",\"object\":\"zt_product\",\"field\":\"product\",\"type\":\"string\"},\"story\":{\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"object\":\"story\",\"field\":\"story\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u4ea7\\u54c1\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"product\":{\"zh-cn\":\"\\u4ea7\\u54c1\",\"zh-tw\":\"\",\"en\":\"product\",\"de\":\"\",\"fr\":\"\"},\"story\":{\"zh-cn\":\"\\u7814\\u53d1\\u9700\\u6c42\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"story\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT YEAR(t2.openedDate) AS `year`, t1.id,  t1.name AS product, COUNT(1) AS story\nFROM zt_product AS t1\nLEFT JOIN zt_story AS t2 ON t1.id = t2.product AND t2.deleted = \'0\'\nWHERE t1.deleted = \'0\' AND t1.shadow = \'0\' AND t1.vision = \'rnd\' AND t2.id IS NOT NULL\nGROUP BY `year`, id, product\nORDER BY `year`, story DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1101;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"product\",\"name\":\"product\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"story\",\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_product\",\"field\":\"id\",\"type\":\"number\"},\"product\":{\"name\":\"product\",\"object\":\"zt_product\",\"field\":\"product\",\"type\":\"string\"},\"story\":{\"name\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"object\":\"story\",\"field\":\"story\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u4ea7\\u54c1\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"product\":{\"zh-cn\":\"\\u4ea7\\u54c1\",\"zh-tw\":\"\",\"en\":\"product\",\"de\":\"\",\"fr\":\"\"},\"story\":{\"zh-cn\":\"\\u7814\\u53d1\\u9700\\u6c42\\u9884\\u8ba1\\u5de5\\u65f6\\u6c42\\u548c\",\"zh-tw\":\"\",\"en\":\"story\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT YEAR(t2.closedDate) AS `year`, t1.id, t1.name AS product, ROUND(SUM(t2.estimate), 1) AS story\nFROM zt_product AS t1\nLEFT JOIN zt_story AS t2 ON t1.id = t2.product AND t2.deleted = \'0\' AND t2.closedReason = \'done\'\nWHERE t1.deleted = \'0\' AND t1.shadow = \'0\' AND t1.vision = \'rnd\' AND t2.id IS NOT NULL\nGROUP BY `year`, id, product\nORDER BY `year`, story DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1102;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"product\",\"name\":\"product\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"bug\",\"name\":\"bug\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"bug\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_product\",\"field\":\"id\",\"type\":\"number\"},\"product\":{\"name\":\"product\",\"object\":\"zt_product\",\"field\":\"product\",\"type\":\"string\"},\"bug\":{\"name\":\"bug\",\"object\":\"bug\",\"field\":\"bug\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u4ea7\\u54c1\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"product\":{\"zh-cn\":\"\\u4ea7\\u54c1\",\"zh-tw\":\"\",\"en\":\"product\",\"de\":\"\",\"fr\":\"\"},\"bug\":{\"zh-cn\":\"Bug\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"bug\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT YEAR(t2.openedDate) AS `year`, t1.id,  t1.name AS product, COUNT(1) AS bug\nFROM zt_product AS t1\nLEFT JOIN zt_bug AS t2 ON t1.id = t2.product AND t2.deleted = \'0\'\nWHERE t1.deleted = \'0\' AND t1.shadow = \'0\' AND t1.vision = \'rnd\' AND t2.id IS NOT NULL\nGROUP BY `year`, id, product\nORDER BY `year`, bug DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1103;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"product\",\"name\":\"product\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"bug\",\"name\":\"bug\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"bug\",\"field\":\"year\",\"type\":\"number\"},\"id\":{\"name\":\"id\",\"object\":\"zt_product\",\"field\":\"id\",\"type\":\"number\"},\"product\":{\"name\":\"product\",\"object\":\"zt_product\",\"field\":\"product\",\"type\":\"string\"},\"bug\":{\"name\":\"bug\",\"object\":\"bug\",\"field\":\"bug\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"id\":{\"zh-cn\":\"\\u4ea7\\u54c1\\u7f16\\u53f7\",\"zh-tw\":\"\",\"en\":\"id\",\"de\":\"\",\"fr\":\"\"},\"product\":{\"zh-cn\":\"\\u4ea7\\u54c1\",\"zh-tw\":\"\",\"en\":\"product\",\"de\":\"\",\"fr\":\"\"},\"bug\":{\"zh-cn\":\"Bug\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"bug\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT YEAR(t2.closedDate) AS `year`, t1.id, t1.name AS product, COUNT(1) AS bug\nFROM zt_product AS t1\nLEFT JOIN zt_bug AS t2 ON t1.id = t2.product AND t2.deleted = \'0\' AND t2.resolution = \'fixed\' AND t2.status = \'closed\'\nWHERE t1.deleted = \'0\' AND t1.shadow = \'0\' AND t1.vision = \'rnd\' AND t2.id IS NOT NULL\nGROUP BY `year`, id, product\nORDER BY `year`, bug DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1104;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"realname\",\"name\":\"realname\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"count\",\"name\":\"count\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"story\",\"field\":\"year\",\"type\":\"number\"},\"realname\":{\"name\":\"realname\",\"object\":\"zt_user\",\"field\":\"realname\",\"type\":\"string\"},\"count\":{\"name\":\"count\",\"object\":\"story\",\"field\":\"count\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"realname\":{\"zh-cn\":\"\\u59d3\\u540d\",\"zh-tw\":\"\",\"en\":\"realname\",\"de\":\"\",\"fr\":\"\"},\"count\":{\"zh-cn\":\"\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"count\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \nYEAR(t3.openedDate) AS `year`,t2.realname,count(1) AS count\nFROM zt_action AS t1 RIGHT JOIN zt_user AS t2 ON t1.actor=t2.account LEFT JOIN zt_story AS t3 ON t1.objectID=t3.id\nWHERE t1.objectType=\'story\' AND t1.action=\'opened\' AND t3.deleted=\'0\'\nGROUP BY `year`,t2.account ORDER BY `year`,count DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1105;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"realname\",\"name\":\"realname\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"count\",\"name\":\"count\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"testcase\",\"field\":\"year\",\"type\":\"number\"},\"realname\":{\"name\":\"realname\",\"object\":\"zt_user\",\"field\":\"realname\",\"type\":\"string\"},\"count\":{\"name\":\"count\",\"object\":\"testcase\",\"field\":\"count\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"realname\":{\"zh-cn\":\"\\u59d3\\u540d\",\"zh-tw\":\"\",\"en\":\"realname\",\"de\":\"\",\"fr\":\"\"},\"count\":{\"zh-cn\":\"\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"count\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \nYEAR(t3.openedDate) AS `year`,t2.realname,count(1) AS count\nFROM zt_action AS t1 RIGHT JOIN zt_user AS t2 ON t1.actor=t2.account LEFT JOIN zt_case AS t3 ON t1.objectID=t3.id\nWHERE t1.objectType=\'case\' AND t1.action=\'opened\' AND t3.deleted=\'0\'\nGROUP BY `year`,t2.account ORDER BY `year`,count DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1106;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"realname\",\"name\":\"realname\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"count\",\"name\":\"count\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"bug\",\"field\":\"year\",\"type\":\"number\"},\"realname\":{\"name\":\"realname\",\"object\":\"zt_user\",\"field\":\"realname\",\"type\":\"string\"},\"count\":{\"name\":\"count\",\"object\":\"bug\",\"field\":\"count\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"realname\":{\"zh-cn\":\"\\u59d3\\u540d\",\"zh-tw\":\"\",\"en\":\"realname\",\"de\":\"\",\"fr\":\"\"},\"count\":{\"zh-cn\":\"\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"count\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \nYEAR(t3.openedDate) AS `year`,t2.realname,count(1) AS count\nFROM zt_action AS t1 RIGHT JOIN zt_user AS t2 ON t1.actor=t2.account LEFT JOIN zt_bug AS t3 ON t1.objectID=t3.id\nWHERE t1.objectType=\'bug\' AND t1.action=\'opened\' AND t3.deleted=\'0\'\nGROUP BY `year`,t2.account ORDER BY `year`,count DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1107;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"realname\",\"name\":\"realname\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"count\",\"name\":\"count\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"bug\",\"field\":\"year\",\"type\":\"number\"},\"realname\":{\"name\":\"realname\",\"object\":\"zt_user\",\"field\":\"realname\",\"type\":\"string\"},\"count\":{\"name\":\"count\",\"object\":\"bug\",\"field\":\"count\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"realname\":{\"zh-cn\":\"\\u59d3\\u540d\",\"zh-tw\":\"\",\"en\":\"realname\",\"de\":\"\",\"fr\":\"\"},\"count\":{\"zh-cn\":\"\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"count\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT \nYEAR(t3.openedDate) AS `year`,t2.realname,count(DISTINCT t3.id) AS count\nFROM zt_action AS t1 RIGHT JOIN zt_user AS t2 ON t1.actor=t2.account LEFT JOIN zt_bug AS t3 ON t1.objectID=t3.id\nWHERE t1.objectType=\'bug\' AND t1.action=\'resolved\' AND t3.deleted=\'0\'\nGROUP BY `year`,t2.account ORDER BY `year`,count DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1108;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"realname\",\"name\":\"realname\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"consumed\",\"name\":\"\\u8017\\u65f6\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"user\",\"field\":\"year\",\"type\":\"number\"},\"realname\":{\"name\":\"realname\",\"object\":\"zt_user\",\"field\":\"realname\",\"type\":\"string\"},\"consumed\":{\"name\":\"\\u8017\\u65f6\",\"object\":\"effort\",\"field\":\"consumed\",\"type\":\"number\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"realname\":{\"zh-cn\":\"\\u59d3\\u540d\",\"zh-tw\":\"\",\"en\":\"realname\",\"de\":\"\",\"fr\":\"\"},\"consumed\":{\"zh-cn\":\"\\u8017\\u65f6\",\"zh-tw\":\"\",\"en\":\"consumed\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT YEAR(t1.date) AS `year`, t2.realname, ROUND(SUM(t1.consumed),1) AS consumed\nFROM zt_effort AS t1 LEFT JOIN zt_user AS t2 ON t1.account = t2.account\nWHERE t1.deleted = \'0\' AND t2.deleted = \'0\'\nGROUP BY `year`, realname\nORDER BY `year`, consumed DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1109;
UPDATE `zt_chart` SET `type` = 'cluBarY', `settings` = '[{\"type\":\"cluBarY\",\"xaxis\":[{\"field\":\"realname\",\"name\":\"realname\",\"group\":\"\"}],\"yaxis\":[{\"field\":\"count\",\"name\":\"count\",\"valOrAgg\":\"sum\"}]}]', `fields` = '{\"year\":{\"name\":\"year\",\"object\":\"user\",\"field\":\"year\",\"type\":\"number\"},\"realname\":{\"name\":\"realname\",\"object\":\"zt_action\",\"field\":\"realname\",\"type\":\"string\"},\"count\":{\"name\":\"count\",\"object\":\"user\",\"field\":\"count\",\"type\":\"string\"}}', `filters` = '[{\"field\":\"year\",\"type\":\"select\",\"name\":\"\\u5e74\\u4efd\"}]', `langs` = '{\"year\":{\"zh-cn\":\"\\u5e74\\u4efd\",\"zh-tw\":\"\",\"en\":\"year\",\"de\":\"\",\"fr\":\"\"},\"realname\":{\"zh-cn\":\"\\u59d3\\u540d\",\"zh-tw\":\"\",\"en\":\"realname\",\"de\":\"\",\"fr\":\"\"},\"count\":{\"zh-cn\":\"\\u8ba1\\u6570\",\"zh-tw\":\"\",\"en\":\"count\",\"de\":\"\",\"fr\":\"\"}}', `sql` = 'SELECT YEAR(t1.date) AS `year`,IFNULL(t2.realname,t1.actor) AS realname,count(1) AS count\nFROM zt_action t1 LEFT JOIN zt_user AS t2 ON t1.actor=t2.account\nGROUP BY `year`,t1.actor\nORDER BY `year`, `count` DESC', `stage` = 'published', `builtin` = 0 WHERE `id` = 1110;

CREATE TABLE `zt_queue` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `cron` mediumint NOT NULL,
  `type` varchar(255) NOT NULL,
  `command` text NOT NULL,
  `status` enum('wait','doing','done') NOT NULL DEFAULT 'wait',
  `execId` int DEFAULT NULL,
  `createdDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

UPDATE `zt_dimension` SET `desc` = '为管理层提供洞察力和决策支持，从而推动业务增长和发展' WHERE `id` = 1;
UPDATE `zt_dimension` SET `desc` = '识别项目管理流程中的关键步骤、瓶颈和性能指标，从而做出有针对性的改进措施，达到优化项目管理流程和降本增效的目的' WHERE `id` = 2;
UPDATE `zt_dimension` SET `desc` = '确保项目交付过程和成果符合预期的质量标准和要求，从而实现客户满意度、提高项目绩效、保障项目可持续性和促进持续改进' WHERE `id` = 3;

ALTER TABLE zt_metric DROP INDEX `code`;

/* Add installed date to config. */
INSERT INTO `zt_config` ( `vision`, `owner`, `module`, `section`, `key`, `value` ) VALUES ('', 'system', 'common', 'global', 'installedDate', (SELECT LEFT( date, 10 ) AS date FROM zt_action WHERE LEFT ( date, 10 ) != '2012-06-05' AND LEFT ( date, 10 ) != '2021-04-28' AND date > '2009-03-14' ORDER BY id LIMIT 1));

REPLACE INTO `zt_chart`(`id`, `name`, `dimension`, `type`, `group`, `dataset`, `desc`, `settings`, `filters`, `step`, `fields`, `langs`, `sql`, `stage`, `builtin`, `objects`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES (1030, '宏观数据-禅道使用时长', 1, 'card', '58', '', '', '{\"value\": {\"type\": \"value\", \"field\": \"period\", \"agg\": \"value\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\n\"type\": \"value\"\n}', '[]', 0, '', NULL, '	SELECT if(t2.`year` > 0, concat(t2.`year`, \'年\', t2.`day`, \'天\'), concat(t2.`day`, \'天\')) as period from (\r\nSELECT TIMESTAMPDIFF(YEAR,t1.firstDay,t1.today) AS `year`,DATEDIFF(DATE_SUB(t1.today,INTERVAL TIMESTAMPDIFF(YEAR,t1.firstDay,t1.today) YEAR), t1.firstDay) AS `day`  \r\nFROM (SELECT `value` AS firstDay, now() AS today FROM zt_config WHERE `owner` = \'system\' AND `key` = \'installedDate\') AS t1\r\n) t2', 'published', 1, '', 'system', '2022-12-07 14:59:41', '', '2022-12-07 14:59:41', 0);
REPLACE INTO `zt_chart`(`id`, `name`, `dimension`, `type`, `group`, `dataset`, `desc`, `settings`, `filters`, `step`, `fields`, `langs`, `sql`, `stage`, `builtin`, `objects`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES (20015, '使用数据分析-上线时间', 1, 'card', '58', '0', ' ', '{\"value\": {\"type\": \"value\", \"field\": \"date\", \"agg\": \"value\"}, \"title\": {\"type\": \"text\", \"name\": \"\"}, \"type\": \"value\"}', '[]', 0, ' ', NULL, 'select `value` as date from zt_config where `owner` = \'system\' and `key` = \'installedDate\'', 'published', 1, ' ', 'system', '2023-08-16 15:32:10', 'admin', '2023-08-16 15:32:17', 0);

INSERT INTO `zt_prompt` (`name`, `model`, `module`, `source`, `targetForm`, `purpose`, `elaboration`, `role`, `characterization`, `createdBy`, `createdDate`, `status`) VALUES ('Bug转需求', 0, 'bug', ',bug.title,bug.steps,bug.severity,bug.pri,bug.status,bug.confirmed,bug.type,', 'story.create', '请将Bug转化为相应的研发需求。', '分条编写需求描述，分条编写验收标准，需求逻辑条理清晰。', '请你扮演一名资深的产品经理。', '负责产品战略、设计、开发、数据分析、用户体验、团队管理、沟通协调等方面，需要具备多种技能和能力，以实现产品目标和公司战略。', 'system', '2023-11-17 12:00:00', 'active');
INSERT INTO `zt_prompt` (`name`, `model`, `module`, `source`, `targetForm`, `purpose`, `elaboration`, `role`, `characterization`, `createdBy`, `createdDate`, `status`) VALUES ('拆分一个子计划', 0, 'productplan', ',productplan.title,productplan.desc,productplan.begin,productplan.end,', 'productplan.create', '根据给定计划名称、描述、计划开始时间和计划结束时间，将给定计划明确为其小范围的子计划。拆分出来的子计划可以更专注于给定计划中的某一类工作。	', '要求子计划的时间不能超出计划开始时间和计划结束时间，并且名称不能与原计划名称相同。润色子计划的描述。', '请你扮演一名资深的产品经理。', '负责产品计划、设计、用户体验等方面，需要具备多种技能和能力，以实现产品目标和公司战略。', 'system', '2023-11-17 12:00:00', 'active');

UPDATE `zt_cron` SET `type` = 'zentao' WHERE `command` = 'moduleName=metric&methodName=updateMetricLib';
