<?php
namespace zin;

class sidebar extends wg
{
    /**
     * @var mixed[]
     */
    protected static $defineProps = array(
        'side?:string="left"',
        'width?:string|number=40',
        'maxWidth?:string|number=400',
        'minWidth?:string|number=160',
        'showToggle?:bool=true',
        'parent?:string',
        'preserve?:string',
        'dragToResize?:bool',
        'onToggle?:function'
    );

    /**
     * @return \zin\wg
     */
    protected function build()
    {
        list($side, $showToggle, $width, $preserve, $parent, $maxWidth, $minWidth, $dragToResize, $onToggle) = $this->prop(array('side', 'showToggle', 'width', 'preserve', 'parent', 'maxWidth', 'minWidth', 'dragToResize', 'onToggle'));
        if($preserve === null)
        {
            global $app;
            $preserve = $app->getModuleName() . '-' . $app->getMethodName();
        }
        return div
        (
            setClass('sidebar'),
            width($width),
            setData(array('zui' => 'sidebar', 'side' => $side, 'toggleBtn' => $showToggle, 'preserve' => $preserve, 'parent' => $parent, 'maxWidth' => $maxWidth, 'minWidth' => $minWidth, 'dragToResize' => $dragToResize, 'onToggle' => $onToggle)),
            set($this->getRestProps()),
            $this->children()
        );
    }
}
