<?php
namespace zin;

class echarts extends wg
{
    /**
     * @param string|int $width
     * @param string|int $height
     * @return \zin\echarts
     */
    public function size($width, $height)
    {
        if(is_numeric($width))  $width  = "{$width}px";
        if(is_numeric($height)) $height = "{$height}px";
        $this->setProp('_size', array($width, $height));
        return $this;
    }

    /**
     * @param string|mixed[] $value
     * @return \zin\echarts
     */
    public function theme($value)
    {
        $this->setProp('theme', $value);
        return $this;
    }

    /**
     * @param bool $value
     * @return \zin\echarts
     */
    public function responsive($value)
    {
        $this->setProp('responsive', $value);
        return $this;
    }

    /**
     * @return \zin\zui
     */
    protected function build()
    {
        global $app;
        $jsFile = $app->getWebRoot() . 'js/echarts/echarts.common.min.js';

        return zui::echarts(inherit($this), set::_call("~((name,selector,options) => $.getLib('$jsFile', {root: false}, () => zui.create(name,selector,options)))"));
    }
}
