<?php
namespace zin;

require_once dirname(__DIR__) . DS . 'input' . DS . 'v1.php';
require_once dirname(__DIR__) . DS . 'textarea' . DS . 'v1.php';
require_once dirname(__DIR__) . DS . 'editor' . DS . 'v1.php';
require_once dirname(__DIR__) . DS . 'checkbox' . DS . 'v1.php';
require_once dirname(__DIR__) . DS . 'checklist' . DS . 'v1.php';
require_once dirname(__DIR__) . DS . 'radiolist' . DS . 'v1.php';
require_once dirname(__DIR__) . DS . 'select' . DS . 'v1.php';
require_once dirname(__DIR__) . DS . 'inputcontrol' . DS . 'v1.php';
require_once dirname(__DIR__) . DS . 'picker' . DS . 'v1.php';
require_once dirname(__DIR__) . DS . 'datepicker' . DS . 'v1.php';
require_once dirname(__DIR__) . DS . 'timepicker' . DS . 'v1.php';
require_once dirname(__DIR__) . DS . 'pripicker' . DS . 'v1.php';
require_once dirname(__DIR__) . DS . 'severitypicker' . DS . 'v1.php';
require_once dirname(__DIR__) . DS . 'colorpicker' . DS . 'v1.php';

class control extends wg
{
    /**
     * @var mixed[]
     */
    protected static $defineProps = array(
        'type?: string',         // 表单输入元素类型，值可以为：static, text, password, email, number, date, time, datetime, month, url, search, tel, color, picker, pri, severity, select, checkbox, radio, checkboxList, radioList, checkboxListInline, radioListInline, file, textarea
        'name: string',          // HTML name 属性
        'id?: string',           // HTML id 属性
        'value?: string',        // HTML value 属性
        'placeholder?: string',  // HTML placeholder 属性
        'readonly?: bool',       // HTML readonly 属性
        'required?: bool',       // 是否为必填项
        'disabled?: bool',       // 是否为禁用状态
        'items?: array'          // 表单输入元素子项数据
    );

    protected function created()
    {
        $name = $this->prop('name');
        if($this->prop('type') === 'static' && $name === null) $this->setProp('name', '');
        if($this->prop('id') === null && $this->prop('name') !== null)
        {
            $name = $this->prop('name');
            $id   = substr($name, -2) == '[]' ? substr($name, 0, - 2) : $name;
            $this->setProp('id', $id);
        }
    }

    /**
     * Build control with static content.
     *
     * @return wg
     */
    protected function buildStatic()
    {
        $name = $this->prop('name');
        return div
        (
            set::className('form-control-static'),
            set($this->props->skip(array('type', 'name', 'value', 'required', 'disabled', 'placeholder', 'items', 'required'))),
            $name ? set('data-name', $name) : null,
            $this->prop('value')
        );
    }

    /**
     * @return \zin\wg
     */
    protected function buildTextarea()
    {
        return new textarea(set($this->props->skip('type')));
    }

    /**
     * @return \zin\wg
     */
    protected function buildInputControl()
    {
        $controlProps = array();
        $allProps     = $this->props->skip('type');
        $propsNames   = array_keys(inputControl::definedPropsList());

        foreach($propsNames as $propName)
        {
            if(!isset($allProps[$propName])) continue;

            $controlProps[$propName] = $allProps[$propName];
            unset($allProps[$propName]);
        }

        return new inputControl
        (
            set($controlProps),
            new input(set($allProps))
        );
    }

    /**
     * @return \zin\wg
     */
    protected function buildCheckbox()
    {
        if($this->hasProp('items')) return $this->buildCheckList();
        return new checkList
        (
            new checkbox(set($this->props->skip('type')))
        );
    }

    /**
     * @return \zin\wg
     */
    protected function buildCheckList()
    {
        return new checkList
        (
            set($this->props->skip('type'))
        );
    }

    /**
     * @return \zin\wg
     */
    protected function buildRadioList()
    {
        return new radioList
        (
            set($this->props->skip('type'))
        );
    }

    /**
     * @return \zin\wg
     */
    protected function buildCheckListInline()
    {
        return new checkList
        (
            set::inline(true),
            set($this->props->skip('type'))
        );
    }

    /**
     * @return \zin\wg
     */
    protected function buildRadioListInline()
    {
        return new radioList
        (
            set::inline(true),
            set($this->props->skip('type'))
        );
    }

    /**
     * @return \zin\wg
     */
    protected function buildDate()
    {
        return new datePicker(set($this->props->skip('type')));
    }

    /**
     * @return \zin\wg
     */
    protected function buildTime()
    {
        return new timePicker(set($this->props->skip('type')));
    }

    /**
     * @return \zin\wg
     */
    protected function buildPri()
    {
        return new priPicker(set($this->props->skip('type')));
    }

    /**
     * @return \zin\wg
     */
    protected function buildSeverity()
    {
        return new severityPicker(set($this->props->skip('type')));
    }

    /**
     * @return \zin\wg
     */
    protected function buildColor()
    {
        return new colorPicker(set($this->props->skip('type')));
    }

    /**
     * @return \zin\wg
     */
    protected function build()
    {
        $type = $this->prop('type');
        if(empty($type)) $type = $this->hasProp('items') ? 'picker' : 'text';

        $methodName = "build{$type}";
        if(method_exists($this, $methodName)) return $this->$methodName();

        $wgName = "\\zin\\$type";
        if(class_exists($wgName)) return new $wgName(set($this->props->skip('type')), $this->children());

        return input(set($this->props));
    }
}
