<?php
namespace zin\utils;

/**
 * @param object|mixed[] $data
 * @param mixed $defaultValue
 * @return mixed
 * @param string $namePath
 */
function deepGet(&$data, $namePath, $defaultValue = null)
{
    $namePath = (string) $namePath;
    $names = explode('.', $namePath);
    foreach($names as $name)
    {
        if(is_object($data))
        {
            if(!isset($data->$name)) return $defaultValue;
            $data = &$data->$name;
            continue;
        }
        if(!is_array($data) || !isset($data[$name])) return $defaultValue;
        $data = &$data[$name];
    }
    return $data === null ? $defaultValue : $data;
}

/**
 * @param mixed $value
 * @param string $namePath
 */
function deepSet(array &$data, $namePath, $value)
{
    $namePath = (string) $namePath;
    $names = explode('.', $namePath);
    $lastName = array_pop($names);
    if(!empty($names))
    {
        foreach($names as $name)
        {
            if(!is_array($data)) return;

            if(!isset($data[$name])) $data[$name] = array();
            $data = &$data[$name];
        }
    }

    $data[$lastName] = $value;
}
