<?php
class myProduct extends product
{
    /**
     * Export product.
     *
     * @param  string $status
     * @param  string $orderBy
     * @access public
     * @return void
     */
    public function export($status, $orderBy)
    {
        if($_POST)
        {
            $productLang   = $this->lang->product;
            $productConfig = $this->config->product;

            /* Create field lists. */
            $fields = $this->post->exportFields ? $this->post->exportFields : explode(',', $productConfig->list->exportFields);
            foreach($fields as $key => $fieldName)
            {
                $fieldName = trim($fieldName);
                $fields[$fieldName] = zget($productLang, $fieldName);
                unset($fields[$key]);
            }

            $lastProgram  = $lastLine = '';
            $users        = $this->user->getPairs('noletter');
            $productStats = $this->product->getStats($orderBy, null, $status);
            foreach($productStats as $i => $product)
            {
                if(!empty($product->PMT))
                {
                    $pmt = trim($product->PMT, ',');
                    if(strpos($pmt, ',') !== false)
                    {
                        $pmt  = explode(',', $pmt);
                        $pmts = '';
                        foreach($pmt as $account)
                        {
                            $pmts .= zget($users, $account, $account);
                            $pmts .= ',';
                        }
                        $product->PMT = trim($pmts, ',');
                    }
                    else
                    {
                        $product->PMT  = zget($users, $product->PMT, '');
                    }
                }
                $product->type = zget($productLang, 'typeList')[$product->type];

                if($this->post->exportType == 'selected')
                {
                    $checkedItem = $this->cookie->checkedItem;
                    if(strpos(",$checkedItem,", ",{$product->id},") === false) unset($productStats[$i]);
                }
            }
            if($this->config->edition != 'open') list($fields, $productStats) = $this->loadModel('workflowfield')->appendDataFromFlow($fields, $productStats);

            if(isset($rowspan)) $this->post->set('rowspan', $rowspan);
            $this->post->set('fields', $fields);
            $this->post->set('rows', $productStats);
            $this->post->set('kind', $this->lang->productCommon);
            $this->fetch('file', 'export2' . $this->post->fileType, $_POST);
        }
        $this->display();
    }
public function __construct($moduleName = '', $methodName = '')
{
    parent::__construct($moduleName, $methodName);
$runVersion = 'ipd1.2';

    if(function_exists('ioncube_license_properties')) $properties = ioncube_license_properties();
$contactEmail  = !empty($properties['email']['value'])  ? $properties['email']['value']  : 'co@zentao.net';
$contactMobile = !empty($properties['mobile']['value']) ? $properties['mobile']['value'] : '4006 889923';
$contactQQ     = !empty($properties['qq']['value']) ? $properties['qq']['value'] : 'co@zentao.net';
if($this->app->getModuleName() != 'upgrade')
{
    $user = $this->dao->select("COUNT('*') as `count`")->from(TABLE_USER)
        ->where('deleted')->eq(0)
        ->beginIF($this->config->vision != 'lite')->andWhere('visions')->ne("lite")->fi()
        ->beginIF($this->config->vision == 'lite')->andWhere('visions')->eq("lite")->fi()
        ->fetch();
    if($this->config->vision == 'rnd' and !empty($properties['user']) and $properties['user']['value'] < $user->count) die("<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dli'>
<html xmlns='http://www.w3.org/1999/xhtml'>
<head>
  <meta http-equiv='Content-Type' content='text/html; charset=utf-8' />
  <title>Error</title>
</head>
<body>
<h2 style='color:red;text-align:center'>IPD版研发用户人数超出限制</h2>
您版本的研发用户数是{$properties['user']['value']}，您目前系统中已有{$user->count}人，已经超过了限制，请联系我们增加人数授权。<br />
Email：<a href='mailto:$contactEmail'>$contactEmail</a><br />
电话：$contactMobile<br />
QQ：$contactQQ<br />
网址：<a href='http://www.zentao.net/goto.php?item=buybiz'>www.zentao.net</a><br />
<br /><br /><br />
<h2 style='color:red;text-align:center'>Users Count Exceeded</h2>
The number of users is more than {$properties['user']['value']} as licensed. Please contact us to get more licenses.<br />
email:<a href='mailto:philip@easycorp.ltd'>philip@easycorp.ltd</a><br />
Web:<a href='http://www.zentao.pm'>www.zentao.pm</a><br />
</body>
</html>");
    if($this->config->vision == 'lite' and !empty($properties['lite']) and $properties['lite']['value'] < $user->count) die("<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dli'>
<html xmlns='http://www.w3.org/1999/xhtml'>
<head>
  <meta http-equiv='Content-Type' content='text/html; charset=utf-8' />
  <title>Error</title>
</head>
<body>
<h2 style='color:red;text-align:center'>IPD版非研发用户人数超出限制</h2>
您版本的非研发用户数是{$properties['lite']['value']}，您目前系统中已有{$user->count}人，已经超过了限制，请联系我们增加人数授权。<br />
Email：<a href='mailto:$contactEmail'>$contactEmail</a><br />
电话：$contactMobile<br />
QQ：$contactQQ<br />
网址：<a href='http://www.zentao.net/goto.php?item=buybiz'>www.zentao.net</a><br />
<br /><br /><br />
<h2 style='color:red;text-align:center'>Users Count Exceeded</h2>
The number of not dev users is more than {$properties['lite']['value']} as licensed. Please contact us to buy more licenses.<br />
email:<a href='mailto:philip@easycorp.ltd'>philip@easycorp.ltd</a><br />
Web:<a href='http://www.zentao.pm'>www.zentao.pm</a><br />
</body>
</html>");
}

if(!empty($properties['version']['value']) and !defined('IN_UPGRADE'))
{
    if(!isset($runVersion)) $runVersion = $this->config->version;
    if($runVersion != $properties['version']['value']) die("<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dli'>
<html xmlns='http://www.w3.org/1999/xhtml'>
<head>
  <meta http-equiv='Content-Type' content='text/html; charset=utf-8' />
  <title>Error</title>
</head>
<body>
<h2 style='color:red;text-align:center'>没有授权此版本</h2>
您版本授权的版本是{$properties['version']['value']}，当前使用的版本是{$runVersion}，请联系我们重新购买授权。<br />
Email：<a href='mailto:$contactEmail'>$contactEmail</a><br />
电话：$contactMobile<br />
QQ：$contactQQ<br />
网址：<a href='http://www.zentao.net/goto.php?item=buybiz'>www.zentao.net</a><br />
<br /><br /><br />
<h2 style='color:red;text-align:center'>This version is not licensed.</h2>
The licensed version is {$properties['version']['value']}. You are using {$runVersion}. Please contact us to buy the right licenses.<br />
email:<a href='mailto:philip@easycorp.ltd'>philip@easycorp.ltd</a><br />
Web:<a href='http://www.zentao.pm/'>www.zentao.pm/</a><br />
</body>
</html>");
}

if(!empty($properties['edition']['value']) and !defined('IN_UPGRADE'))
{
    if($properties['edition']['value'] != 'ipd') die("<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dli'>
<html xmlns='http://www.w3.org/1999/xhtml'>
<head>
  <meta http-equiv='Content-Type' content='text/html; charset=utf-8' />
  <title>Error</title>
</head>
<body>
<h2 style='color:red;text-align:center'>没有授权此版本</h2>
您版本授权的版本是{$properties['edition']['value']}，当前使用的版本是ipd，请联系我们重新购买授权。<br />
Email：<a href='mailto:$contactEmail'>$contactEmail</a><br />
电话：$contactMobile<br />
QQ：$contactQQ<br />
网址：<a href='http://www.zentao.net/goto.php?item=buybiz'>www.zentao.net</a><br />
<br /><br /><br />
<h2 style='color:red;text-align:center'>This version is not licensed.</h2>
The licensed version is {$properties['edition']['value']}. You are using ipd. Please contact us to buy the right licenses.<br />
email:<a href='mailto:philip@easycorp.ltd'>philip@easycorp.ltd</a><br />
Web:<a href='http://www.zentao.pm/'>www.zentao.pm/</a><br />
</body>
</html>");
}

if(!empty($properties['domain']))
{
    $host    = $_SERVER['HTTP_HOST'];
    $portPos = strrpos($host, ':');
    if($portPos !== false)
    {
        $port = substr($host, $portPos + 1);
        if(is_numeric($port)) $host = substr($host, 0, $portPos);
    }
    $host .= $_SERVER['REQUEST_URI'];

    $checkHost  = false;
    $allowHosts = explode(',', $properties['domain']['value']);
    foreach($allowHosts as $allowHost)
    {
        if(strpos($host, $allowHost) !== false)
        {
            $checkHost = true;
            break;
        }
    }
    if(!$checkHost) die("<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dli'>
<html xmlns='http://www.w3.org/1999/xhtml'>
<head>
  <meta http-equiv='Content-Type' content='text/html; charset=utf-8' />
  <title>Error</title>
</head>
<body>
<h2 style='color:red;text-align:center'>IPD版绑定域名访问错误</h2>
您版本绑定的域名是{$properties['domain']['value']}，您目前访问的域名是{$_SERVER['HTTP_HOST']}，如果有问题，请联系我们修改绑定域名。<br />
Email：<a href='mailto:$contactEmail'>$contactEmail</a><br />
电话：$contactMobile<br />
QQ：$contactQQ<br />
网址：<a href='http://www.zentao.net/goto.php?item=buybiz'>www.zentao.net</a><br />
<br /><br /><br />
<h2 style='color:red;text-align:center'>Domain Error</h2>
The domain in your license is {$properties['domain']['value']}. Please contact us to change the domain.<br />
email:<a href='mailto:philip@easycorp.ltd'>philip@easycorp.ltd</a><br />
Web:<a href='http://www.zentao.pm'>www.zentao.pm</a><br />
</body>
</html>");
};
}
}
