ALTER TABLE `zt_host`
DROP COLUMN `cabinet`,
DROP COLUMN `cpuRate`,
DROP COLUMN `diskType`,
DROP COLUMN `unit`,
DROP COLUMN `nic`,
DROP COLUMN `webserver`,
DROP COLUMN `database`,
DROP COLUMN `language`,
DROP COLUMN `instanceNum`,
DROP COLUMN `pri`,
DROP COLUMN `tags`,
DROP COLUMN `bridgeID`,
DROP COLUMN `cloudKey`,
DROP COLUMN `cloudSecret`,
DROP COLUMN `cloudRegion`,
DROP COLUMN `cloudNamespace`,
DROP COLUMN `cloudUser`,
DROP COLUMN `cloudAccount`,
DROP COLUMN `cloudPassword`,
DROP COLUMN `couldVPC`,
ADD COLUMN `name` varchar(255) NOT NULL DEFAULT '' AFTER `id`,
MODIFY COLUMN `type` varchar(30) NOT NULL DEFAULT 'normal' AFTER `name`,
MODIFY COLUMN `hostType` varchar(30) NOT NULL DEFAULT '' AFTER `type`,
MODIFY COLUMN `mac` varchar(128) NOT NULL AFTER `hostType`,
MODIFY COLUMN `memory` varchar(30) NOT NULL AFTER `mac`,
MODIFY COLUMN `diskSize` varchar(30) NOT NULL AFTER `memory`,
MODIFY COLUMN `status` varchar(50) NOT NULL AFTER `diskSize`,
MODIFY COLUMN `secret` varchar(50) NOT NULL DEFAULT '' AFTER `status`,
ADD COLUMN `desc` text NOT NULL AFTER `secret`,
CHANGE COLUMN `token` `tokenSN` varchar(50) NOT NULL DEFAULT '' AFTER `desc`,
CHANGE COLUMN `expiredDate` `tokenTime` datetime NOT NULL AFTER `tokenSN`,
ADD COLUMN `oldTokenSN` varchar(50) NOT NULL DEFAULT '' AFTER `tokenTime`,
CHANGE COLUMN `virtualSoftware` `vsoft` varchar(30) NOT NULL DEFAULT '' AFTER `tokenTime`,
CHANGE COLUMN `heartbeatTime` `heartbeat` datetime NOT NULL AFTER `vsoft`,
CHANGE COLUMN `agentPort` `zap` varchar(10) NOT NULL AFTER `heartbeat`,
MODIFY COLUMN `provider` varchar(255) NOT NULL DEFAULT '' AFTER `zap`,
ADD COLUMN `vnc` int(11) NOT NULL AFTER `provider`,
ADD COLUMN `ztf` int(11) NOT NULL AFTER `vnc`,
ADD COLUMN `zd` int(11) NOT NULL AFTER `ztf`,
ADD COLUMN `ssh` int(11) NOT NULL AFTER `zd`,
ADD COLUMN `parent` int(11) unsigned NOT NULL DEFAULT '0' AFTER `vnc`,
ADD COLUMN `image` int(11) unsigned NOT NULL DEFAULT '0' AFTER `parent`,
ADD COLUMN `group` varchar(128) NOT NULL DEFAULT '' AFTER `osVersion`,
ADD COLUMN `createdBy` varchar(30) NOT NULL,
ADD COLUMN  `createdDate` datetime NOT NULL,
ADD COLUMN  `editedBy` varchar(30) NOT NULL,
ADD COLUMN  `editedDate` datetime NOT NULL,
ADD COLUMN  `deleted` enum('0','1') NOT NULL DEFAULT '0',
CHANGE COLUMN `privateIP` `intranet` varchar(128) NOT NULL AFTER `cpuCores`,
CHANGE COLUMN `publicIP` `extranet` varchar(128) NOT NULL AFTER `intranet`;

UPDATE zt_host h,
zt_asset a
SET h.`name` = a.`name`,
h.`createdBy` = a.`createdBy`,
h.`createdDate` = a.`createdDate`,
h.`editedBy` = a.`editedBy`,
h.`editedDate` = a.`editedDate`,
h.`group` = a.`group`,
h.`type` = a.`type`,
h.`deleted` = a.`deleted`
WHERE
h.`assetID` = a.`id`;

ALTER TABLE `zt_host` DROP COLUMN `assetID`;

DROP TABLE IF EXISTS `zt_asset`;
DROP TABLE IF EXISTS `zt_baseimagebrowser`;
DROP TABLE IF EXISTS `zt_browser`;
DROP TABLE IF EXISTS `zt_baseimage`;
DROP TABLE IF EXISTS `zt_vmtemplate`;
DROP TABLE IF EXISTS `zt_vm`;

CREATE TABLE `zt_image` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `host` int(11) unsigned NOT NULL DEFAULT 0,
  `name` varchar(64) NOT NULL DEFAULT '',
  `address` varchar(64) NOT NULL DEFAULT '',
  `path` varchar(64) NOT NULL DEFAULT '',
  `status` varchar(20) NOT NULL DEFAULT '',
  `osName` varchar(32) NOT NULL DEFAULT '',
  `from` varchar(10) NOT NULL DEFAULT 'zentao',
  `memory` float unsigned NOT NULL,
  `disk` float unsigned NOT NULL,
  `fileSize` float unsigned NOT NULL,
  `md5` varchar(64) NOT NULL,
  `desc` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `zt_automation` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `node` int(11) unsigned NOT NULL DEFAULT 0,
  `product` int(11) unsigned NOT NULL DEFAULT 0,
  `scriptPath` varchar(255) NOT NULL DEFAULT '',
  `shell` mediumtext NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

ALTER TABLE `zt_repofiles` ADD `oldPath` varchar(255) DEFAULT '' AFTER `path`;
ALTER TABLE `zt_case` ADD `script` longtext NOT NULL AFTER `howRun`;
ALTER TABLE `zt_testresult` ADD `ZTFResult` text NOT NULL AFTER `stepResults`;
ALTER TABLE `zt_testresult` ADD `node` int(8) unsigned NOT NULL DEFAULT '0' AFTER `ZTFResult`;

REPLACE INTO `zt_screen` (`id`, `dimension`, `name`, `desc`, `cover`, `scheme`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES
(1,1,'宏观数据盘点大屏','从宏观的角度快速的了解公司的现状','static/images/screen1.png','[\n    {\n        \"id\": \"5scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 120, \"x\": 0, \"y\": 0, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 1300, \"h\": 120, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/screen_header.png\", \"borderRadius\": 10 }\n            },\n            {\n                \"id\": \"2nws38440fq000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 360, \"y\": 36, \"w\": 500, \"h\": 66, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"title\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"公司数据盘点大屏\", \"fontSize\": 20, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1cfwp95aiif400\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 0, \"y\": 171, \"w\": 1000, \"h\": 480, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 800, \"h\": 120, \"x\": 0, \"y\": 175, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"公司级数据概览\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 165, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 165, \"y\": 28, \"w\": 800, \"h\": 10, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 25, \"y\": 246, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"一级项目集个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1018,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"一级项目集个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"一级项目集个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"一级项目集个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 155, \"y\": 246, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1019,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"项目个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"项目个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"项目个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 285, \"y\": 246, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"产品个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1020,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"产品个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"产品个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"产品个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 25, \"y\": 346, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"计划个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1021,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"计划个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"计划个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"计划个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 155, \"y\": 346, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"执行个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1022,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"执行个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"执行个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"执行个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 285, \"y\": 346, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"发布个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1023,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"发布个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"发布个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"发布个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 25, \"y\": 446, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"需求个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1024,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"需求个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"需求个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"需求个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 155, \"y\": 446, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"任务个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1025,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"任务个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"任务个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"任务个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 285, \"y\": 446, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"缺陷个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1026,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"缺陷个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"缺陷个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"缺陷个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 25, \"y\": 546, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"文档个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1027,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"文档个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"文档个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"文档个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 155, \"y\": 546, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"现有人员个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1028,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"现有人员个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"现有人员个数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"现有人员个数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 285, \"y\": 546, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"累计消耗工时\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1029,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"累计消耗工时\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"累计消耗工时\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"累计消耗工时\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"3v5jz5hzz0c000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 211, \"h\": 150, \"x\": 500, \"y\": 180, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"使用时长\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1hxm2jtfh3y800\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 380, \"h\": 150, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"使用时长边框\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#6586ec00\", \"#2cf7fe00\" ], \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"3aekp6a7tag000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 60, \"y\": 25, \"w\": 200, \"h\": 150, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"使用时长\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"禅道使用时长：\", \"fontSize\": 19, \"fontColor\": \"#9abdcd\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"right\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"4u5rgs0pf34000\",\n                \"sourceID\": 1030,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 265, \"y\": 25, \"w\": 252, \"h\": 150, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"时长\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"\", \"fontSize\": 19, \"fontColor\": \"#9abdcd\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"fc4u6zmi58w00\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 963, \"y\": 186, \"w\": 20, \"h\": 20, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": 1 },\n        \"styles\": { \"filterShow\": false, \"hueRotate\": 0, \"saturate\": 1, \"contrast\": 1, \"brightness\": 1, \"opacity\": 1, \"rotateZ\": 0, \"rotateX\": 0, \"rotateY\": 0, \"skewX\": 0, \"skewY\": 0, \"blendMode\": \"normal\", \"animations\": [] },\n        \"status\": { \"lock\": false, \"hide\": false },\n        \"request\": { \"requestDataType\": 0, \"requestHttpType\": \"get\", \"requestUrl\": \"\", \"requestInterval\": null, \"requestIntervalUnit\": \"second\", \"requestContentType\": 0, \"requestParamsBodyType\": \"none\", \"requestSQLContent\": { \"sql\": \"select * from  where\" }, \"requestParams\": { \"Body\": { \"form-data\": {}, \"x-www-form-urlencoded\": {}, \"json\": \"\", \"xml\": \"\" }, \"Header\": {}, \"Params\": {} } },\n        \"filter\": null,\n        \"events\": { \"baseEvent\": { \"click\": null, \"dblclick\": null, \"mouseenter\": null, \"mouseleave\": null }, \"advancedEvents\": { \"vnodeMounted\": null, \"vnodeBeforeMount\": null } },\n        \"key\": \"Hint\",\n        \"chartConfig\": { \"key\": \"Hint\", \"chartKey\": \"VHint\", \"conKey\": \"VCHint\", \"title\": \"提示\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/hint-2cbf6381.png\" },\n        \"option\": { \"text\": \"\", \"icon\": \"\", \"textSize\": 15, \"textColor\": \"#ffffff\", \"textWeight\": \"bold\", \"placement\": \"left-top\", \"distance\": 8, \"hint\": \"需求完成率=关闭原因为已完成的需求个数/(关闭原因为已完成的需求个数+未关闭的需求个数)；\\nBug修复率=方案为已解决且状态为已关闭的Bug数/(方案为已解决的Bug数+方案为延期处理的Bug数+激活的Bug数)。\", \"width\": 0, \"height\": 0, \"paddingX\": 16, \"paddingY\": 8, \"borderWidth\": 1, \"borderStyle\": \"solid\", \"borderColor\": \"#1a77a5\", \"borderRadius\": 6, \"color\": \"#ffffff\", \"textAlign\": \"left\", \"fontWeight\": \"normal\", \"backgroundColor\": \"rgba(8, 40, 80, 0.9)\", \"fontSize\": 16 }\n    },\n    {\n        \"id\": \"17sqdjuu74ik00\",\n        \"sourceID\": 1031,\n        \"isGroup\": false,\n        \"attr\": { \"x\": 460, \"y\": 300, \"w\": 280, \"h\": 250, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"PieCircle\",\n        \"chartConfig\": { \"key\": \"PieCircle\", \"chartKey\": \"VPieCircle\", \"conKey\": \"VPieCircle\", \"title\": \"需求完成率\", \"category\": \"Pies\", \"categoryName\": \"饼图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/pie-circle-258fcce7.png\" },\n        \"option\": { \"legend\": { \"show\": true, \"top\": \"15%\", \"textStyle\": { \"color\": \"#B9B8CE\" } }, \"title\": {\"text\": \"30.00%\", \"x\": \"center\", \"y\": \"center\", \"textStyle\": {\"color\": \"#FFF\",\"fontSize\": 20}}, \"type\": \"nomal\", \"tooltip\": { \"show\": false, \"trigger\": \"item\", \"formatter\": \"{d}%\" }, \"dataset\": 0.25, \"series\": [ { \"type\": \"pie\", \"radius\": [ \"63%\", \"70%\" ], \"label\": { \"show\": false }, \"center\": [ \"50%\", \"50%\" ], \"data\": [ { \"value\": [ 30 ], \"itemStyle\": { \"color\": \"#03a9f4\", \"shadowBlur\": 10, \"shadowColor\": \"#97e2f5\" } }, { \"value\": [ 70 ], \"itemStyle\": { \"color\": \"#00bcd44a\", \"shadowBlur\": 0, \"shadowColor\": \"#00bcd44a\" } } ]} ] }\n    },\n    {\n        \"id\": \"4u5rgs0pf34000\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 475, \"y\": 535, \"w\": 250, \"h\": 50, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"TextCommon\",\n        \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"时长\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n        \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"需求完成率\", \"fontSize\": 15, \"fontColor\": \"#c6d3d9\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n    },\n    {\n        \"id\": \"4xgico362ww000\",\n        \"sourceID\": 1032,\n        \"isGroup\": false,\n        \"attr\": { \"x\": 720, \"y\": 300, \"w\": 280, \"h\": 250, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"PieCircle\",\n        \"chartConfig\": { \"key\": \"PieCircle\", \"chartKey\": \"VPieCircle\", \"conKey\": \"VPieCircle\", \"title\": \"Bug修复率\", \"category\": \"Pies\", \"categoryName\": \"饼图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/pie-circle-258fcce7.png\" },\n        \"option\": { \"legend\": { \"show\": true, \"top\": \"15%\", \"textStyle\": { \"color\": \"#B9B8CE\" } }, \"title\": {\"text\": \"30.00%\", \"x\": \"center\", \"y\": \"center\", \"textStyle\": {\"color\": \"#FFF\",\"fontSize\": 20}}, \"type\": \"nomal\", \"tooltip\": { \"show\": false, \"trigger\": \"item\", \"formatter\": \"{d}%\" }, \"dataset\": 0.25, \"series\": [ { \"type\": \"pie\", \"radius\": [ \"63%\", \"70%\" ], \"label\": { \"show\": false }, \"center\": [ \"50%\", \"50%\" ], \"data\": [ { \"value\": [ 30 ], \"itemStyle\": { \"color\": \"#C29160\", \"shadowBlur\": 10, \"shadowColor\": \"#eed045\" } }, { \"value\": [ 70 ], \"itemStyle\": { \"color\": \"#00bcd44a\", \"shadowBlur\": 0, \"shadowColor\": \"#00bcd44a\" } } ]} ] }\n    },\n    {\n        \"id\": \"4u5rgs0pf34000\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 735, \"y\": 535, \"w\": 250, \"h\": 50, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"TextCommon\",\n        \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"时长\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n        \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"Bug修复率\", \"fontSize\": 15, \"fontColor\": \"#c6d3d9\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n    },\n    {\n        \"id\": \"1cfwp95aiif400\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 1010, \"y\": 171, \"w\": 290, \"h\": 480, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 400, \"h\": 120, \"x\": 1010, \"y\": 175, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 400, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"公司级未完成数据概览\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 220, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 220, \"y\": 32, \"w\": 30, \"h\": 8, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 1035, \"y\": 246, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"一级项目集个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1033,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"一级项目集数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"一级项目集数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"一级项目集数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 1165, \"y\": 246, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1034,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"需求数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"需求数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"需求数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 1035, \"y\": 346, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"产品数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1035,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"产品数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"产品数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"产品数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 1165, \"y\": 346, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1036,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"项目数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"项目数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"项目数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 1035, \"y\": 446, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"计划数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1037,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"计划数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"计划数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"计划数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 1165, \"y\": 446, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"执行个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1038,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"执行数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"执行数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"执行数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 1035, \"y\": 546, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"Bug数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1039,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"Bug数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"Bug数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"Bug数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"z3gs9qz8hq800\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 110, \"h\": 100, \"x\": 1165, \"y\": 546, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"任务个数\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 110, \"h\": 80, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/card.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3ef3nnqh7gu00\",\n                \"sourceID\": 1040,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 14, \"w\": 110, \"h\": 30, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"任务数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"100\", \"fontSize\": 18, \"fontColor\": \"#ffffff\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"52mwo993eaw000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 38, \"w\": 110, \"h\": 49, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"任务数\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"任务数\", \"fontSize\": 9, \"fontColor\": \"#9abdcd\", \"paddingX\": 0, \"paddingY\": 0, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 1, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"fc4u6zmi58w00\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 1260, \"y\": 186, \"w\": 20, \"h\": 20, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": 1 },\n        \"styles\": { \"filterShow\": false, \"hueRotate\": 0, \"saturate\": 1, \"contrast\": 1, \"brightness\": 1, \"opacity\": 1, \"rotateZ\": 0, \"rotateX\": 0, \"rotateY\": 0, \"skewX\": 0, \"skewY\": 0, \"blendMode\": \"normal\", \"animations\": [] },\n        \"status\": { \"lock\": false, \"hide\": false },\n        \"request\": { \"requestDataType\": 0, \"requestHttpType\": \"get\", \"requestUrl\": \"\", \"requestInterval\": null, \"requestIntervalUnit\": \"second\", \"requestContentType\": 0, \"requestParamsBodyType\": \"none\", \"requestSQLContent\": { \"sql\": \"select * from  where\" }, \"requestParams\": { \"Body\": { \"form-data\": {}, \"x-www-form-urlencoded\": {}, \"json\": \"\", \"xml\": \"\" }, \"Header\": {}, \"Params\": {} } },\n        \"filter\": null,\n        \"events\": { \"baseEvent\": { \"click\": null, \"dblclick\": null, \"mouseenter\": null, \"mouseleave\": null }, \"advancedEvents\": { \"vnodeMounted\": null, \"vnodeBeforeMount\": null } },\n        \"key\": \"Hint\",\n        \"chartConfig\": { \"key\": \"Hint\", \"chartKey\": \"VHint\", \"conKey\": \"VCHint\", \"title\": \"提示\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/hint-2cbf6381.png\" },\n        \"option\": { \"text\": \"\", \"icon\": \"\", \"textSize\": 15, \"textColor\": \"#ffffff\", \"textWeight\": \"bold\", \"placement\": \"left-top\", \"distance\": 8, \"hint\": \"未完成的一级项目集个数=未关闭的一级项目集个数；\\n未完成的需求个数=未关闭的需求个数；\\n未完成的产品个数=未关闭的产品个数；\\n未完成的项目个数=未关闭的项目个数；\\n未完成的计划个数=未完成的计划个数；\\n未完成的执行个数=未关闭的执行个数；\\n未完成的任务个数=未完成的任务个数；\\n未完成的Bug个数=未关闭的Bug个数。\", \"width\": 0, \"height\": 0, \"paddingX\": 16, \"paddingY\": 8, \"borderWidth\": 1, \"borderStyle\": \"solid\", \"borderColor\": \"#1a77a5\", \"borderRadius\": 6, \"color\": \"#ffffff\", \"textAlign\": \"left\", \"fontWeight\": \"normal\", \"backgroundColor\": \"rgba(8, 40, 80, 0.9)\", \"fontSize\": 16 }\n    },\n    {\n        \"id\": \"1cfwp95aiif400\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 0, \"y\": 665, \"w\": 1300, \"h\": 525, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"6scfjzqsbzo000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 120, \"x\": 0, \"y\": 665, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57r67ykkwxk000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"项目集数据概览\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"2xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 165, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"3xjom2cw2b2000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 185, \"y\": 28, \"w\": 1090, \"h\": 10, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"1zhfrmecpnxc00\",\n                \"sourceID\": 1041,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 25, \"y\": 57, \"w\": 1250, \"h\": 446, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TableScrollBoard\",\n                \"chartConfig\": { \"key\": \"TableScrollBoard\", \"chartKey\": \"VTableScrollBoard\", \"conKey\": \"VCTableScrollBoard\", \"title\": \"轮播列表\", \"category\": \"Tables\", \"categoryName\": \"表格\", \"package\": \"Tables\", \"chartFrame\": \"common\", \"image\": \"static/png/table_scrollboard-fb642e78.png\" },\n                \"option\": { \"header\": [ \"列1\", \"列2\", \"列3\" ], \"dataset\": [ [ \"行1列1\", \"行1列2\", \"行1列3\" ], [ \"行2列1\", \"行2列2\", \"行2列3\" ], [ \"行3列1\", \"行3列2\", \"行3列3\" ], [ \"行4列1\", \"行4列2\", \"行4列3\" ], [ \"行5列1\", \"行5列2\", \"行5列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ] ], \"index\": false, \"columnWidth\": [], \"align\": [ \"center\", \"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"], \"rowNum\": 8, \"waitTime\": 3, \"headerHeight\": 45, \"carousel\": \"single\", \"headerBGC\": \"#165896FF\", \"oddRowBGC\": \"#042b4dFF\", \"evenRowBGC\": \"#0a1c37FF\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"3hqq7oh18ra000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 0, \"y\": 1200, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1dlpgwe8wwe800\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"obhxxjnin3400\",\n                \"sourceID\": 1042,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 60, \"w\": 380, \"h\": 416, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": true,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}%\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"18%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}%\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } }, { \"type\": \"bar\", \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[2]}%\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 5,\n                        \"maxValueSpan\": 5,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"handleIcon\": \"path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5M36.9,35.8h-1.3z M27.8,35.8 h-1.3H27L27.8,35.8L27.8,35.8z\",\n                        \"handleSize\": \"100%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"borderCap\": \"round\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n                }\n            },\n            {\n                \"id\": \"2u3zlsz5kk4000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 22, \"w\": 378, \"h\": 50, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"项目集需求完成率与Bug\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"项目集需求完成率与Bug修复率\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1xih6tzmmssg00\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 437, \"y\": 1200, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"公司一级项目集状态分布\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2bnelf1diy8000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"公司一级项目集状态分布\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"1351cy224nb400\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 25, \"w\": 426, \"h\": 45, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"公司一级项目集状态分布\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"公司一级项目集状态分布\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"4ocyn7hip9k000\",\n                \"sourceID\": 1043,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 10, \"y\": 50, \"w\": 400, \"h\": 410, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"PieCommon\",\n                \"chartConfig\": { \"key\": \"PieCommon\", \"chartKey\": \"VPieCommon\", \"conKey\": \"VCPieCommon\", \"title\": \"饼图\", \"category\": \"Pies\", \"categoryName\": \"饼图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/pie-9620f191.png\" },\n                \"option\": { \"legend\": { \"show\": true, \"top\": \"5%\", \"textStyle\": { \"color\": \"#B9B8CE\" } }, \"type\": \"nomal\", \"tooltip\": { \"show\": true, \"trigger\": \"item\" }, \"dataset\": { \"dimensions\": [ \"product\", \"data1\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120 }, { \"product\": \"Tue\", \"data1\": 200 }, { \"product\": \"Wed\", \"data1\": 150 }, { \"product\": \"Thu\", \"data1\": 80 }, { \"product\": \"Fri\", \"data1\": 70 }, { \"product\": \"Sat\", \"data1\": 110 }, { \"product\": \"Sun\", \"data1\": 130 } ] }, \"series\": [ { \"type\": \"pie\", \"radius\": [ \"30%\", \"30%\" ], \"label\": { \"show\": true, \"width\": 120, \"formatter\": \"{b}\\n{d}%\", \"lineHeight\": 20, \"color\": \"#ffffff\", \"position\": \"outside\", \"position\": \"outside\", \"alignTo\": \"edge\", \"margin\": 5 }, \"center\": [ \"50%\", \"55%\" ], \"roseType\": false , \"emphasis\": { \"itemStyle\": { \"shadowBlur\": 20, \"shadowOffsetX\": 2, \"shadowColor\": \"rgba(0, 0, 0, 0)\" } }} ] }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"2js0ncv6kpc000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 865, \"x\": 874, \"y\": 1200, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"公司项目状态分布\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"4d4pumofn5g000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"公司项目状态分布\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"50qj95gt8fs000\",\n                \"sourceID\": 1044,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 10, \"y\": 60, \"w\": 400, \"h\": 400, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"PieCommon\",\n                \"chartConfig\": { \"key\": \"PieCommon\", \"chartKey\": \"VPieCommon\", \"conKey\": \"VCPieCommon\", \"title\": \"饼图\", \"category\": \"Pies\", \"categoryName\": \"饼图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/pie-9620f191.png\" },\n                \"option\": { \"legend\": { \"show\": true, \"top\": \"5%\", \"textStyle\": { \"color\": \"#B9B8CE\" } }, \"type\": \"nomal\", \"tooltip\": { \"show\": true, \"trigger\": \"item\" }, \"dataset\": { \"dimensions\": [ \"product\", \"data1\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120 }, { \"product\": \"Tue\", \"data1\": 200 }, { \"product\": \"Wed\", \"data1\": 150 }, { \"product\": \"Thu\", \"data1\": 80 }, { \"product\": \"Fri\", \"data1\": 70 }, { \"product\": \"Sat\", \"data1\": 110 }, { \"product\": \"Sun\", \"data1\": 130 } ] }, \"series\": [ { \"type\": \"pie\", \"radius\": [ \"30%\", \"30%\" ], \"label\": { \"show\": true, \"width\": 120, \"formatter\": \"{b}\\n{d}%\", \"lineHeight\": 20, \"color\": \"#ffffff\", \"position\": \"outside\", \"position\": \"outside\", \"alignTo\": \"edge\", \"margin\": 5 }, \"center\": [ \"50%\", \"55%\" ], \"roseType\": false , \"emphasis\": { \"itemStyle\": { \"shadowBlur\": 20, \"shadowOffsetX\": 2, \"shadowColor\": \"rgba(0, 0, 0, 0)\" } }} ] }\n            },\n            {\"id\": \"36zg35ree9q000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 400, \"h\": 85, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"公司项目状态分布\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"公司项目状态分布\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1cfwp95aiif400\",\n        \"isGroup\": false,\n        \"attr\": { \"x\": 0, \"y\": 1710, \"w\": 1300, \"h\": 525, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"key\": \"Border03\",\n        \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"summary\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n        \"option\": { \"colors\": [ \"#00102800\", \"#00102800\" ], \"backgroundColor\": \"#0a1c38\" }\n    },\n    {\n        \"id\": \"vwvqtuc6lyo00\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 1300, \"h\": 120, \"x\": 0, \"y\": 1710, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"标题\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"5l0cps9x0z0000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 187, \"h\": 68, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"summary_top\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"产品数据概览\", \"fontSize\": 14, \"fontColor\": \"#b2d5e5\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"left\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"3ajkrqyykr8000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 150, \"y\": 26, \"w\": 14, \"h\": 11, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_left.png\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"2z65lmxl328000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 170, \"y\": 28, \"w\": 1105, \"h\": 10, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Image\",\n                \"chartConfig\": { \"key\": \"Image\", \"chartKey\": \"VImage\", \"conKey\": \"VCImage\", \"title\": \"header\", \"category\": \"Mores\", \"categoryName\": \"更多\", \"package\": \"Informations\", \"chartFrame\": \"common\", \"image\": \"static/png/photo-637bc05d.png\" },\n                \"option\": { \"dataset\": \"static/images/line_right.png\", \"fit\": \"fill\", \"borderRadius\": 0 }\n            },\n            {\n                \"id\": \"1zhfrmecpnxc00\",\n                \"sourceID\": 1045,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 25, \"y\": 57, \"w\": 1250, \"h\": 446, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TableScrollBoard\",\n                \"chartConfig\": { \"key\": \"TableScrollBoard\", \"chartKey\": \"VTableScrollBoard\", \"conKey\": \"VCTableScrollBoard\", \"title\": \"轮播列表\", \"category\": \"Tables\", \"categoryName\": \"表格\", \"package\": \"Tables\", \"chartFrame\": \"common\", \"image\": \"static/png/table_scrollboard-fb642e78.png\" },\n                \"option\": { \"header\": [ \"列1\", \"列2\", \"列3\" ], \"dataset\": [ [ \"行1列1\", \"行1列2\", \"行1列3\" ], [ \"行2列1\", \"行2列2\", \"行2列3\" ], [ \"行3列1\", \"行3列2\", \"行3列3\" ], [ \"行4列1\", \"行4列2\", \"行4列3\" ], [ \"行5列1\", \"行5列2\", \"行5列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ], [ \"行6列1\", \"行6列2\", \"行6列3\" ] ], \"index\": false, \"columnWidth\": [], \"align\": [ \"center\", \"center\",\"center\",\"center\",\"center\",\"center\",\"center\",\"center\"], \"rowNum\": 8, \"waitTime\": 3, \"headerHeight\": 45, \"carousel\": \"single\", \"headerBGC\": \"#165896FF\", \"oddRowBGC\": \"#042b4dFF\", \"evenRowBGC\": \"#0a1c37FF\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"sl2d95i1hz400\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 640, \"h\": 500, \"x\": 0, \"y\": 2250, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"产品需求完成率\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"57zre1am96c000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 640, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"产品需求完成率\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"42ae8w3dgeg000\",\n                \"sourceID\": 1046,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 60, \"w\": 530, \"h\": 416, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}%\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"15%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"item\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}%\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 6,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 6,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"handleIcon\": \"path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5M36.9,35.8h-1.3z M27.8,35.8 h-1.3H27L27.8,35.8L27.8,35.8z\",\n                        \"handleSize\": \"100%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"borderCap\": \"round\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n\n                }\n            },\n            {\n                \"id\": \"579jc04cfps000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 90, \"y\": 0, \"w\": 500, \"h\": 100, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"产品需求完成率\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"产品需求完成率\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"nr1mfqoyuwg00\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 645, \"h\": 500, \"x\": 655, \"y\": 2250, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"项目集需求完成率与Bug\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"2ta7xcd152i000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 645, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"产品Bug修复率\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"4o7ep6z91ii000\",\n                \"sourceID\": 1047,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 30, \"y\": 60, \"w\": 540, \"h\": 416, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}%\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"15%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}%\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 6,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 6,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"handleIcon\": \"path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5M36.9,35.8h-1.3z M27.8,35.8 h-1.3H27L27.8,35.8L27.8,35.8z\",\n                        \"handleSize\": \"100%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"borderCap\": \"round\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n\n                }\n            },\n            {\n                \"id\": \"4vcyxy305n6000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 90, \"y\": 0, \"w\": 500, \"h\": 100, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"产品Bug修复率\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"产品Bug修复率\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"45ao1xz9kzu000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 0, \"y\": 2770, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"部门人员分布图\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1ncdmrlvzjy800\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"部门人员分布图\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"v3d9spa59dc00\",\n                \"sourceID\": 1049,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 20, \"y\": 50, \"w\": 380, \"h\": 426, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": {\n                    \"legend\": {\n                        \"show\": false,\n                        \"top\": \"5%\",\n                        \"textStyle\": { \"color\": \"#B9B8CE\" }\n                    },\n                    \"xAxis\": {\n                        \"show\": true, \"name\": \"\",\n                        \"nameGap\": 15,\n                        \"nameTextStyle\": {\n                            \"color\": \"#B9B8CE\",\n                            \"fontSize\": 12\n                        },\n                        \"inverse\": false,\n                        \"axisLabel\": {\n                            \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0, \"formatter\": \"{value}\"\n                        },\n                        \"position\": \"bottom\",\n                        \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true },\n                        \"axisTick\": { \"show\": true, \"length\": 5 },\n                        \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }\n                    },\n                    \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0}, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" },\n                    \"grid\": { \"show\": false, \"left\": \"15%\", \"top\": \"60\", \"right\": \"12%\", \"bottom\": \"60\" },\n                    \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } },\n                    \"dataset\": { \"dimensions\": [ \"product\", \"data1\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] },\n                    \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"formatter\": \"{@[1]}\", \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ],\n                    \"backgroundColor\": \"rgba(0,0,0,0)\",\n                    \"dataZoom\": [\n                     {\n                        \"type\": \"inside\",\n                        \"startValue\": 0,\n                        \"endValue\": 5,\n                        \"minValueSpan\": 10,\n                        \"maxValueSpan\": 10,\n                        \"yAxisIndex\": [0],\n                        \"zoomOnMouseWheel\": false,\n                        \"moveOnMouseWheel\": true,\n                        \"moveOnMouseMove\": true\n                    },\n                    {\n                        \"type\": \"slider\",\n                        \"realtime\": true,\n                        \"startValue\": 0,\n                        \"endValue\": 6,\n                        \"zoomLock\": true,\n                        \"brushSelect\": false,\n                        \"width\":  5,\n                        \"height\":  \"80%\",\n                        \"handleIcon\": \"path://M30.9,53.2C16.8,53.2,5.3,41.7,5.3,27.6S16.8,2,30.9,2C45,2,56.4,13.5,56.4,27.6S45,53.2,30.9,53.2z M30.9,3.5M36.9,35.8h-1.3z M27.8,35.8 h-1.3H27L27.8,35.8L27.8,35.8z\",\n                        \"handleSize\": \"100%\",\n                        \"yAxisIndex\": [0],\n                        \"fillerColor\": \"#33aaff\",\n                        \"borderColor\": \"#33aaff00\",\n                        \"borderCap\": \"round\",\n                        \"backgroundColor\": \"#cfcfcf00\",\n                        \"handleSize\":0,\n                        \"showDataShadow\": false,\n                        \"showDetail\": false,\n                        \"top\": \"10%\",\n                        \"right\": 0\n                    }\n                    ]\n\n                }\n            },\n            {\n                \"id\": \"wam6ydb8zqo00\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 378, \"h\": 100, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"部门人员分布图\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"部门人员分布图\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"2dg0t90atgg000\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 437, \"y\": 2770, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"公司角色分布图\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"53ynqk2kzh8000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"公司角色分布图\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"1knkjcb65rwg00\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 25, \"w\": 426, \"h\": 45, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"公司角色分布图\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"公司角色分布图\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            },\n            {\n                \"id\": \"mblj8ow100000\",\n                \"sourceID\": 1050,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 20, \"y\": 60, \"w\": 400, \"h\": 420, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"PieCommon\",\n                \"chartConfig\": { \"key\": \"PieCommon\", \"chartKey\": \"VPieCommon\", \"conKey\": \"VCPieCommon\", \"title\": \"需求完成率\", \"category\": \"Pies\", \"categoryName\": \"饼图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/pie-9620f191.png\" },\n                \"option\": { \"legend\": { \"show\": true, \"top\": \"0%\", \"textStyle\": { \"color\": \"#B9B8CE\" } }, \"type\": \"nomal\", \"tooltip\": { \"show\": true, \"trigger\": \"item\" }, \"dataset\": { \"dimensions\": [ \"product\", \"data1\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120 }, { \"product\": \"Tue\", \"data1\": 200 }, { \"product\": \"Wed\", \"data1\": 150 }, { \"product\": \"Thu\", \"data1\": 80 }, { \"product\": \"Fri\", \"data1\": 70 }, { \"product\": \"Sat\", \"data1\": 110 }, { \"product\": \"Sun\", \"data1\": 130 } ] }, \"series\": [ { \"type\": \"pie\", \"radius\": [ \"40%\", \"40%\" ], \"label\": { \"show\": true, \"width\": 120, \"formatter\": \"{b}\\n{d}%\", \"lineHeight\": 20, \"color\": \"#ffffff\", \"position\": \"outside\", \"alignTo\": \"edge\", \"margin\": 5 }, \"center\": [ \"50%\", \"65%\" ], \"roseType\": false , \"emphasis\": { \"itemStyle\": { \"shadowBlur\": 20, \"shadowOffsetX\": 2, \"shadowColor\": \"rgba(0, 0, 0, 0)\" } }} ] }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    },\n    {\n        \"id\": \"1j55da3c41vk00\",\n        \"isGroup\": true,\n        \"attr\": { \"w\": 426, \"h\": 500, \"x\": 874, \"y\": 2770, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n        \"chartConfig\": { \"key\": \"group\", \"chartKey\": \"group\", \"conKey\": \"group\", \"category\": \"group\", \"categoryName\": \"group\", \"package\": \"group\", \"chartFrame\": \"common\", \"title\": \"人员工龄分布图\", \"image\": \"\" },\n        \"groupList\": [\n            {\n                \"id\": \"1xqnm37nva8w00\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 0, \"y\": 0, \"w\": 426, \"h\": 500, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"Border03\",\n                \"chartConfig\": { \"key\": \"Border03\", \"chartKey\": \"VBorder03\", \"conKey\": \"VCBorder03\", \"title\": \"人员工龄分布图\", \"category\": \"Borders\", \"categoryName\": \"边框\", \"package\": \"Decorates\", \"image\": \"\" },\n                \"option\": { \"colors\": [ \"#0a1c3700\", \"#042b4d00\" ], \"backgroundColor\": \"#0a1c38\" }\n            },\n            {\n                \"id\": \"5ll028fasrw000\",\n                \"sourceID\": 1051,\n                \"isGroup\": false,\n                \"attr\": { \"x\": 20, \"y\": 50, \"w\": 380, \"h\": 426, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"BarCrossrange\",\n                \"chartConfig\": { \"key\": \"BarCrossrange\", \"chartKey\": \"VBarCrossrange\", \"conKey\": \"VCBarCrossrange\", \"title\": \"横向柱状图\", \"category\": \"Bars\", \"categoryName\": \"柱状图\", \"package\": \"Charts\", \"chartFrame\": \"echarts\", \"image\": \"static/png/bar_y-05067169.png\" },\n                \"option\": { \"legend\": { \"show\": false, \"top\": \"5%\", \"textStyle\": { \"color\": \"#B9B8CE\" } }, \"xAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": false, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0 }, \"position\": \"bottom\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"value\" }, \"yAxis\": { \"show\": true, \"name\": \"\", \"nameGap\": 15, \"nameTextStyle\": { \"color\": \"#B9B8CE\", \"fontSize\": 12 }, \"inverse\": true, \"axisLabel\": { \"show\": true, \"fontSize\": 12, \"color\": \"#B9B8CE\", \"rotate\": 0 }, \"position\": \"left\", \"axisLine\": { \"show\": true, \"lineStyle\": { \"color\": \"#B9B8CE\", \"width\": 1 }, \"onZero\": true }, \"axisTick\": { \"show\": false, \"length\": 5 }, \"splitLine\": { \"show\": false, \"lineStyle\": { \"color\": \"#484753\", \"width\": 1, \"type\": \"solid\" } }, \"type\": \"category\" }, \"grid\": { \"show\": false, \"left\": \"20%\", \"top\": \"60\", \"right\": \"10%\", \"bottom\": \"60\" }, \"tooltip\": { \"show\": true, \"trigger\": \"axis\", \"axisPointer\": { \"show\": true, \"type\": \"shadow\" } }, \"dataset\": { \"dimensions\": [ \"product\", \"data1\", \"data2\" ], \"source\": [ { \"product\": \"Mon\", \"data1\": 120, \"data2\": 130 }, { \"product\": \"Tue\", \"data1\": 200, \"data2\": 130 }, { \"product\": \"Wed\", \"data1\": 150, \"data2\": 312 }, { \"product\": \"Thu\", \"data1\": 80, \"data2\": 268 }, { \"product\": \"Fri\", \"data1\": 70, \"data2\": 155 }, { \"product\": \"Sat\", \"data1\": 110, \"data2\": 117 }, { \"product\": \"Sun\", \"data1\": 130, \"data2\": 160 } ] }, \"series\": [ { \"type\": \"bar\", \"barMaxWidth\": 28, \"barWidth\": null, \"label\": { \"show\": true, \"position\": \"right\", \"color\": \"#fff\", \"fontSize\": 12 }, \"itemStyle\": { \"color\": null, \"borderRadius\": 0 } } ], \"backgroundColor\": \"rgba(0,0,0,0)\" }\n            },\n            {\n                \"id\": \"4887ix47ule000\",\n                \"isGroup\": false,\n                \"attr\": { \"x\": 15, \"y\": 0, \"w\": 378, \"h\": 100, \"offsetX\": 0, \"offsetY\": 0, \"zIndex\": -1 },\n                \"key\": \"TextCommon\",\n                \"chartConfig\": { \"key\": \"TextCommon\", \"chartKey\": \"VTextCommon\", \"conKey\": \"VCTextCommon\", \"title\": \"人员工龄分布图\", \"category\": \"Texts\", \"categoryName\": \"文本\", \"package\": \"Informations\", \"image\": \"static/png/text_static-b2721032.png\" },\n                \"option\": { \"link\": \"\", \"linkHead\": \"http://\", \"dataset\": \"人员工龄分布图\", \"fontSize\": 14, \"fontColor\": \"#ffffff\", \"paddingX\": 10, \"paddingY\": 10, \"textAlign\": \"center\", \"fontWeight\": \"bold\", \"borderWidth\": 0, \"borderColor\": \"#ffffff\", \"borderRadius\": 5, \"letterSpacing\": 5, \"writingMode\": \"horizontal-tb\", \"backgroundColor\": \"#00000000\" }\n            }\n        ],\n        \"key\": \"group\",\n        \"option\": {}\n    }\n]\n','admin','2022-11-18 10:46:18','admin','2022-11-18 10:46:18','0');

REPLACE INTO `zt_chart` (`id`, `name`, `dimension`, `type`, `group`, `dataset`, `desc`, `settings`, `filters`, `fields`, `sql`, `builtin`, `objects`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `deleted`) VALUES
(1041,'宏观数据-项目集数据概览',1,'table',0,'','','{\"group\":[],\"column\":[\n{\"field\":\"topProgram\",\"valOrAgg\":\"value\",\"name\":\"一级项目集\"},{\"field\":\"subProgram\",\"valOrAgg\":\"value\",\"name\":\"子项目集数\"},\n{\"field\":\"product\",\"valOrAgg\":\"value\",\"name\":\"产品数\"},\n{\"field\":\"story\",\"valOrAgg\":\"value\",\"name\":\"需求数\"},\n{\"field\":\"bug\",\"valOrAgg\":\"value\",\"name\":\"Bug数\"},\n{\"field\":\"release\",\"valOrAgg\":\"value\",\"name\":\"发布数\"},\n{\"field\":\"project\",\"valOrAgg\":\"value\",\"name\":\"项目数\"},\n{\"field\":\"task\",\"valOrAgg\":\"value\",\"name\":\"任务数\"}\n],\"filter\":[]}','[]','','SELECT\n  t1.name AS topProgram,\n  IFNULL(t2.subProgram, 0) AS subProgram,\n  COUNT(DISTINCT t3.id) AS product,\n  SUM(IFNULL(t4.story, 0)) AS story,\n  SUM(IFNULL(t5.`release`, 0)) AS \'release\',\n  SUM(IFNULL(t6.bug, 0)) AS bug,\n  IFNULL(t7.project, 0) AS project,\n  IFNULL(t7.task, 0) AS task\nFROM zt_project AS t1\nLEFT JOIN (SELECT SUBSTR(path, 2, POSITION(\',\' IN SUBSTR(path, 2)) -1) AS topProgram, COUNT(1) AS subProgram FROM zt_project WHERE deleted = \'0\' AND type = \'program\' AND grade > 1 GROUP BY topProgram) AS t2 ON t1.id = t2.topProgram\nLEFT JOIN zt_product AS t3 ON t1.id = t3.program AND t3.deleted = \'0\' AND t3.shadow = \'0\' AND t3.vision = \'rnd\'\nLEFT JOIN (SELECT product, COUNT(1) AS story FROM zt_story WHERE deleted = \'0\' GROUP BY product) AS t4 ON t3.id = t4.product\nLEFT JOIN (SELECT product, COUNT(1) AS \'release\' FROM zt_release WHERE deleted = \'0\' GROUP BY product) AS t5 ON t3.id = t5.product\nLEFT JOIN (SELECT product, COUNT(1) AS bug FROM zt_bug WHERE deleted = \'0\' GROUP BY product) AS t6 ON t3.id = t6.product\nLEFT JOIN (\n  SELECT t1.topProgram, COUNT(DISTINCT t1.project) AS project, COUNT(t2.id) AS task\n  FROM (SELECT SUBSTR(path, 2, POSITION(\',\' IN SUBSTR(path, 2)) -1) AS topProgram, id AS project FROM zt_project WHERE deleted = \'0\' AND type = \'project\') AS t1\n  LEFT JOIN zt_task AS t2 ON t1.project = t2.project AND t2.deleted = \'0\'\n  GROUP BY t1.topProgram\n) AS t7 ON t1.id = t7.topProgram\nWHERE t1.deleted = \'0\' AND t1.type = \'program\' AND t1.grade = 1\nGROUP BY t1.name',1,'','admin','2022-12-07 14:59:41','','2022-12-07 14:59:41',0),
(1066,'年度新增-完成项目数',1,'card',0,'','','{\"value\": {\"type\": \"agg\", \"field\": \"id\", \"agg\": \"count\"}, \"title\": {\"type\": \"text\", \"name\": \"\"},\r\n\"type\": \"value\"\r\n}','',NULL,'SELECT t1.year, t2.id, t2.name\r\nFROM (SELECT DISTINCT YEAR(date) AS \'year\' FROM zt_action) AS t1\r\nLEFT JOIN (SELECT id, name, YEAR(closedDate) AS `year` FROM zt_project WHERE `type` = \'project\' AND deleted = \'0\' AND status = \'closed\') AS t2 ON t1.year = t2.year\r\nWHERE t2.id IS NOT NULL',1,'','','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1077,'年度新增-需求年度新增和完成趋势图',1,'line',0,'','','{\r\n  \"xaxis\":[{\"field\":\"month\",\"name\":\"月份\",\"group\":\"value\"}],\r\n  \"yaxis\":[{\"type\":\"value\",\"field\":\"newStory\",\"agg\":\"value\",\"name\":\"新增需求数\",\"valOrAgg\":\"value\"},\r\n             {\"type\":\"value\",\"field\":\"closedStory\",\"agg\":\"value\",\"name\":\"完成需求数\",\"valOrAgg\":\"value\"}\r\n]}','',NULL,'SELECT t1.year, CONCAT(t1.month, \'月\') AS `month`, IFNULL(t2.story, 0) AS newStory, IFNULL(t3.story, 0) AS closedStory\r\nFROM (SELECT DISTINCT Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\r\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS story FROM zt_story WHERE deleted = \'0\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\r\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS story FROM zt_story WHERE deleted = \'0\' AND closedReason = \'done\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\r\nORDER BY `year`, t1.month',1,'','','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1078,'年度新增-Bug年度新增和解决趋势图',1,'line',0,'','','{\r\n  \"xaxis\":[{\"field\":\"month\",\"name\":\"月份\",\"group\":\"value\"}],\r\n  \"yaxis\":[{\"type\":\"value\",\"field\":\"newBug\",\"agg\":\"value\",\"name\":\"新增Bug数\",\"valOrAgg\":\"value\"},\r\n             {\"type\":\"value\",\"field\":\"fixedBug\",\"agg\":\"value\",\"name\":\"解决Bug数\",\"valOrAgg\":\"value\"}\r\n]}','',NULL,'SELECT t1.year, CONCAT(t1.month, \'月\') AS `month`, IFNULL(t2.bug, 0) AS newBug, IFNULL(t3.bug, 0) AS fixedBug\r\nFROM (SELECT DISTINCT Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\r\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS bug FROM zt_bug WHERE deleted = \'0\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\r\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS bug FROM zt_bug WHERE deleted = \'0\' AND resolution = \'fixed\' AND status = \'closed\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\r\nORDER BY `year`, t1.month',1,'','','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1079,'年度新增-任务年度新增和完成趋势图',1,'line',0,'','','{\r\n  \"xaxis\":[{\"field\":\"month\",\"name\":\"月份\",\"group\":\"value\"}],\r\n  \"yaxis\":[{\"type\":\"value\",\"field\":\"newTask\",\"agg\":\"value\",\"name\":\"新增任务数\",\"valOrAgg\":\"value\"},\r\n             {\"type\":\"value\",\"field\":\"closedTask\",\"agg\":\"value\",\"name\":\"完成任务数\",\"valOrAgg\":\"value\"}\r\n]}','',NULL,'SELECT t1.year, CONCAT(t1.month, \'月\') AS `month`, IFNULL(t2.task, 0) AS newTask, IFNULL(t3.task, 0) AS closedTask\r\nFROM (SELECT DISTINCT Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\r\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS task FROM zt_task WHERE deleted = \'0\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\r\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS task FROM zt_task WHERE deleted = \'0\' AND status = \'closed\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\r\nORDER BY `year`, t1.month',1,'','','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1080,'年度新增-项目年度新增和完成趋势图',1,'line',0,'','','{\r\n  \"xaxis\":[{\"field\":\"month\",\"name\":\"月份\",\"group\":\"value\"}],\r\n  \"yaxis\":[{\"type\":\"value\",\"field\":\"newProject\",\"agg\":\"value\",\"name\":\"新增项目数\",\"valOrAgg\":\"value\"},\r\n             {\"type\":\"value\",\"field\":\"closedProject\",\"agg\":\"value\",\"name\":\"完成项目数\",\"valOrAgg\":\"value\"}\r\n]}','',NULL,'SELECT t1.year, CONCAT(t1.month, \'月\') AS `month`, IFNULL(t2.project, 0) AS newProject, IFNULL(t3.project, 0) AS closedProject\r\nFROM (SELECT DISTINCT Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\r\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS project FROM zt_project WHERE deleted = \'0\' AND type = \'project\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\r\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS project FROM zt_project WHERE deleted = \'0\' AND type = \'project\' AND status = \'closed\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\r\nORDER BY `year`, t1.month',1,'','','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1081,'年度新增-执行年度新增和完成趋势图',1,'line',0,'','','{\r\n  \"xaxis\":[{\"field\":\"month\",\"name\":\"月份\",\"group\":\"value\"}],\r\n  \"yaxis\":[{\"type\":\"value\",\"field\":\"newExecution\",\"agg\":\"value\",\"name\":\"新增执行数\",\"valOrAgg\":\"value\"},\r\n             {\"type\":\"value\",\"field\":\"closedExecution\",\"agg\":\"value\",\"name\":\"完成执行数\",\"valOrAgg\":\"value\"}\r\n]}','',NULL,'SELECT t1.year, CONCAT(t1.month, \'月\') AS `month`, IFNULL(t2.execution, 0) AS newExecution, IFNULL(t3.execution, 0) AS closedExecution\r\nFROM (SELECT DISTINCT YEAR(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\r\nLEFT JOIN (SELECT YEAR(openedDate) AS `year`, MONTH(openedDate) AS `month`, COUNT(1) AS execution FROM zt_project WHERE deleted = \'0\' AND type IN (\'sprint\', \'stage\', \'kanban\') AND multiple = \'1\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\r\nLEFT JOIN (SELECT YEAR(closedDate) AS `year`, MONTH(closedDate) AS `month`, COUNT(1) AS execution FROM zt_project WHERE deleted = \'0\' AND type IN (\'sprint\', \'stage\', \'kanban\') AND status = \'closed\' AND multiple = \'1\' GROUP BY `year`, `month`) AS t3 ON t1.year = t3.year AND t1.month = t3.month\r\nORDER BY `year`, t1.month',1,'','','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1082,'年度新增-产品发布次数年度趋势图',1,'line',0,'','','{\r\n  \"xaxis\":[{\"field\":\"month\",\"name\":\"月份\",\"group\":\"value\"}],\r\n  \"yaxis\":[{\"type\":\"value\",\"field\":\"release\",\"agg\":\"value\",\"name\":\"发布次数\",\"valOrAgg\":\"value\"}\r\n]}','',NULL,'SELECT t1.year, CONCAT(t1.month, \'月\') AS `month`, IFNULL(t2.release, 0) AS `release`\r\nFROM (SELECT DISTINCT Year(date) AS `year`, MONTH(date) AS `month` FROM zt_action) AS t1\r\nLEFT JOIN (SELECT YEAR(createdDate) AS `year`, MONTH(createdDate) AS `month`, COUNT(1) AS `release` FROM zt_release WHERE deleted = \'0\' GROUP BY `year`, `month`) AS t2 ON t1.year = t2.year AND t1.month = t2.month\r\nORDER BY `year`, t1.month',1,'','','0000-00-00 00:00:00','','0000-00-00 00:00:00',0),
(1083,'年度新增-年度投入产出比',1,'line',0,'','','{\r\n  \"xaxis\":[{\"field\":\"month\",\"name\":\"月份\",\"group\":\"value\"}],\r\n  \"yaxis\":[{\"type\":\"value\",\"field\":\"ratio\",\"agg\":\"value\",\"name\":\"投入产出比\",\"valOrAgg\":\"value\"},\r\n{\"type\":\"value\",\"field\":\"story\",\"agg\":\"value\",\"name\":\"需求交付\",\"valOrAgg\":\"value\"},\r\n{\"type\":\"value\",\"field\":\"consumed\",\"agg\":\"value\",\"name\":\"工时消耗\",\"valOrAgg\":\"value\"}\r\n]}','',NULL,'SELECT t1.`year`, CONCAT(t1.`month`, \'月\') AS `month`, IFNULL(t2.story, 0) AS story, IFNULL(t3.consumed, 0) AS consumed, ROUND(IF(IFNULL(t3.consumed, 0) = 0, 0, IFNULL(t2.story, 0) / IFNULL(t3.consumed, 0)), 2) AS ratio\r\nFROM (SELECT YEAR(`date`) AS \'year\', MONTH(`date`) AS \'month\' FROM zt_action GROUP BY `year`,`month`) AS t1\r\nLEFT JOIN (SELECT ROUND(SUM(estimate)) AS story, YEAR(`closedDate`) AS \'year\', MONTH(`closedDate`) AS \'month\' FROM zt_story WHERE deleted = \'0\' AND closedReason = \'done\' AND status = \'closed\' GROUP BY `year`,`month`) AS t2 ON t1.`year` = t2.`year` AND t1.`month` = t2.`month`\r\nLEFT JOIN (SELECT ROUND(SUM(consumed)) as consumed, YEAR(`date`) as \'year\', MONTH(`date`) AS \'month\' FROM zt_effort WHERE deleted = \'0\' GROUP BY `year`,`month`) AS t3 ON t1.`year` = t3.`year` AND t1.`month` = t3.`month`',1,'','','0000-00-00 00:00:00','','0000-00-00 00:00:00',0);

REPLACE INTO `zt_workflow` (`parent`, `child`, `type`, `navigator`, `app`, `position`, `module`, `table`, `name`, `flowchart`, `js`, `css`, `order`, `buildin`, `administrator`, `desc`, `version`, `status`, `approval`, `vision`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `titleField`, `contentField`) VALUES
('', '', 'flow', 'secondary', 'feedback', '', 'ticket', 'zt_ticket', '工单', '', '', '', 0, 1, '', '', '1.0', 'normal', 'disabled', 'rnd', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', '', ''),
('', '', 'flow', 'secondary', 'feedback', '', 'ticket', 'zt_ticket', '工单', '', '', '', 0, 1, '', '', '1.0', 'normal', 'disabled', 'lite', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', '', '');

REPLACE INTO `zt_workflowfield` (`module`, `field`, `type`, `length`, `name`, `control`, `expression`, `options`, `default`, `rules`, `placeholder`, `canExport`, `canSearch`, `isValue`, `order`, `searchOrder`, `exportOrder`, `buildin`, `role`, `desc`, `readonly`, `createdBy`, `createdDate`, `editedBy`, `editedDate`) VALUES
('ticket', 'id', 'mediumint', '8', '编号', 'input', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'product', 'mediumint', '8', '所属产品', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'module', 'mediumint', '8', '所属模块', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'title', 'varchar', '255', '标题', 'input', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'type', 'varchar', '30', '类型', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'desc', 'text', '', '描述', 'textarea', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'openedBuild', 'varchar', '255', '影响版本', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'feedback', 'mediumint', '8', '来源反馈', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'assignedTo', 'varchar', '255', '指派给', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'assignedDate', 'datetime', '', '指派日期', 'input', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'realStarted', 'datetime', '', '实际开始', 'input', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'startedBy', 'varchar', '255', '由谁开始', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'startedDate', 'datetime', '', '开始日期', 'input', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'deadline', 'date', '', '截止日期', 'input', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'pri', 'tinyint', '3', '优先级', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'estimate', 'float', '', '最初预计', 'input', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'left', 'float', '', '预计剩余', 'input', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'status', 'varchar', '255', '状态', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'subStatus', 'varchar', '30', '子状态', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 0, 'buildin', '', '0', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'openedBy', 'varchar', '30', '由谁创建', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'openedDate', 'datetime', '', '创建日期', 'input', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'activatedCount', 'int', '10', '激活次数', 'input', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'activatedBy', 'varchar', '30', '由谁激活', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'activatedDate', 'datetime', '', '激活日期', 'input', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'closedBy', 'varchar', '30', '由谁关闭', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'closedDate', 'datetime', '', '关闭日期', 'input', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'closedReason', 'varchar', '30', '关闭原因', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'finishedBy', 'varchar', '30', '由谁完成', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'finishedDate', 'datetime', '', '完成日期', 'input', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'resolvedBy', 'varchar', '30', '由谁解决', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'resolvedDate', 'datetime', '', '解决日期', 'input', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'resolution', 'varchar', '1000', '解决方案', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'editedBy', 'varchar', '30', '由谁编辑', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'editedDate', 'datetime', '', '编辑日期', 'input', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'keywords', 'varchar', '255', '关键词', 'input', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'repeatTicket', 'mediumint', '8', '重复工单', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'mailto', 'varchar', '255', '抄送给', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'consumed', 'float', '', '消耗', 'input', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('ticket', 'deleted', 'enum', '', '是否删除', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00');

REPLACE INTO `zt_workflowaction` (`module`, `action`, `name`, `type`, `batchMode`, `extensionType`, `open`, `position`, `layout`, `show`, `order`, `buildin`, `role`, `virtual`, `conditions`, `verifications`, `hooks`, `linkages`, `js`, `css`, `toList`, `blocks`, `desc`, `status`, `vision`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `method`) VALUES
('ticket', 'browse', '浏览工单', 'batch', 'different', 'none', 'normal', 'browseandview', 'normal', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'rnd', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'browse'),
('ticket', 'create', '创建工单', 'single', 'different', 'none', 'normal', 'browse', 'normal', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'rnd', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'create'),
('ticket', 'edit', '编辑工单', 'single', 'different', 'none', 'normal', 'browseandview', 'normal', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'rnd', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'edit'),
('ticket', 'batchedit', '批量编辑', 'single', 'different', 'none', 'normal', 'browseandview', 'normal', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'rnd', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'operate'),
('ticket', 'start', '开始工单', 'single', 'different', 'none', 'normal', 'browseandview', 'normal', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'rnd', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'operate'),
('ticket', 'finish', '完成工单', 'single', 'different', 'none', 'normal', 'browseandview', 'normal', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'rnd', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'operate'),
('ticket', 'activate', '激活工单', 'single', 'different', 'none', 'normal', 'browseandview', 'normal', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'rnd', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'operate'),
('ticket', 'assign', '指派工单', 'single', 'different', 'none', 'normal', 'browseandview', 'normal', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'rnd', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'operate'),
('ticket', 'close', '关闭工单', 'single', 'different', 'none', 'normal', 'browseandview', 'normal', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'rnd', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'operate'),
('ticket', 'view', '工单详情', 'single', 'different', 'none', 'normal', 'browse', 'side', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'rnd', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'view'),
('ticket', 'browse', '浏览工单', 'batch', 'different', 'none', 'normal', 'browseandview', 'normal', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'lite', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'browse'),
('ticket', 'create', '创建工单', 'single', 'different', 'none', 'normal', 'browse', 'normal', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'lite', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'create'),
('ticket', 'edit', '编辑工单', 'single', 'different', 'none', 'normal', 'browseandview', 'normal', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'lite', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'edit'),
('ticket', 'batchedit', '批量编辑', 'single', 'different', 'none', 'normal', 'browseandview', 'normal', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'lite', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'operate'),
('ticket', 'start', '开始工单', 'single', 'different', 'none', 'normal', 'browseandview', 'normal', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'lite', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'operate'),
('ticket', 'finish', '完成工单', 'single', 'different', 'none', 'normal', 'browseandview', 'normal', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'lite', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'operate'),
('ticket', 'activate', '激活工单', 'single', 'different', 'none', 'normal', 'browseandview', 'normal', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'lite', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'operate'),
('ticket', 'assign', '指派工单', 'single', 'different', 'none', 'normal', 'browseandview', 'normal', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'lite', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'operate'),
('ticket', 'close', '关闭工单', 'single', 'different', 'none', 'normal', 'browseandview', 'normal', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'lite', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'operate'),
('ticket', 'view', '工单详情', 'single', 'different', 'none', 'normal', 'browse', 'side', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'lite', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'view');

UPDATE `zt_workflowfield` SET `name` = '类型'  WHERE `module` = 'feedback' and `field` = 'type';
UPDATE `zt_workflowfield` SET `name` = '创建者'  WHERE `module` = 'feedback' and `field` = 'openedBy';
UPDATE `zt_workflowfield` SET `name` = '创建时间'  WHERE `module` = 'feedback' and `field` = 'openedDate';
UPDATE `zt_workflowfield` SET `name` = '反馈邮箱'  WHERE `module` = 'feedback' and `field` = 'notifyEmail';
UPDATE `zt_workflowfield` SET `name` = '最后操作'  WHERE `module` = 'feedback' and `field` = 'editedBy';
UPDATE `zt_workflowfield` SET `name` = '最后操作时间'  WHERE `module` = 'feedback' and `field` = 'editedDate';

REPLACE INTO `zt_workflowfield` (`module`, `field`, `type`, `length`, `name`, `control`, `expression`, `options`, `default`, `rules`, `placeholder`, `canExport`, `canSearch`, `isValue`, `order`, `searchOrder`, `exportOrder`, `buildin`, `role`, `desc`, `readonly`, `createdBy`, `createdDate`, `editedBy`, `editedDate`) VALUES
('feedback', 'pri', 'tinyint', '3', '优先级', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('feedback', 'source', 'varchar', '30', '来源公司', 'input', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('feedback', 'repeatFeedback', 'varchar', '30', '重复反馈', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('feedback', 'activatedBy', 'varchar', '30', '由谁激活', 'select', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00'),
('feedback', 'activatedDate', 'datetime', '', '激活时间', 'datetime', '', '', '', '', '', '0', '0', '0', 1, 0, 0, 1, 'buildin', '', '1', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00');

REPLACE INTO `zt_workflowaction` (`module`, `action`, `name`, `type`, `batchMode`, `extensionType`, `open`, `position`, `layout`, `show`, `order`, `buildin`, `role`, `virtual`, `conditions`, `verifications`, `hooks`, `linkages`, `js`, `css`, `toList`, `blocks`, `desc`, `status`, `vision`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `method`) VALUES
('feedback', 'activate', '激活反馈', 'single', 'different', 'none', 'normal', 'browseandview', 'normal', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'rnd', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'activate'),
('feedback', 'import', '导入', 'single', 'different', 'none', 'normal', 'browse', 'normal', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'rnd', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'import'),
('feedback', 'exporttemplate', '导出模板', 'single', 'different', 'none', 'normal', 'browse', 'normal', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'rnd', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'exporttemplate'),
('feedback', 'batchclose', '批量关闭', 'batch', 'different', 'none', 'normal', 'browseandview', 'normal', 'direct', 0, 1, 'buildin', 0, '', '', '', '', '', '', '', '', '', 'enable', 'rnd', 'admin', '2022-12-19 14:13:30', '', '0000-00-00 00:00:00', 'batchclose');
