/**
 * Load product projects.
 *
 * @param  int productID
 * @access public
 * @return void
 */
function loadProductProject(productID)
{
    if(productID == 0)
    {
        replaceProject(defaultProject, true);
        loadProductExecutions(productID, $('#project').val());
        return;
    }

    var project = $('#project').length > 0 ? $('#project').val() : 0;
    var link = createLink('product', 'ajaxGetProjects', 'productID=' + productID + '&branch=0&project=' + project);

    $.get(link, function(data)
    {
        replaceProject(data);
        $('#projectIdBox select').trigger('change');
    });
}

/**
 * Load product、project executions.
 *
 * @param  int $productID
 * @access public
 * @return void
 */
function loadProductExecutions(productID, projectID)
{
    if($('#project').length > 0)
    {
        if(productID == 0 && projectID == 0)
        {
            replaceExecution(defaultExecution, true);
            return;
        }

        if(productID == 0)
        {
            var link = createLink('project', 'ajaxGetExecutions', 'projectID=' + projectID + '&executionID=' + $('#executionIdBox #execution').val());
        }
        else
        {
            var link = createLink('product', 'ajaxGetExecutions', 'productID=' + productID + '&project=' + $('#project').val() + '&branch=0&number=&executionID=' + $('#executionIdBox #execution').val());
        }
    }
    else // In classic mode.
    {
        if(productID == 0)
        {
            replaceExecution(defaultExecution);
            return;
        }

        var link = createLink('product', 'ajaxGetExecutions', 'productID=' + productID + '&project=0&branch=0&number=&executionID=' + $('#executionIdBox #execution').val());
    }

    $.get(link, function(data)
    {
        replaceExecution(data);
    });
}

/**
 * Replace project data.
 *
 * @param  string data
 * @access public
 * @return void
 */
function replaceProject(data, emptySelect)
{
    $('#projectIdBox select').replaceWith(data);
    $('#projectIdBox .chosen-container').remove();
    $('#projectIdBox .picker').remove();
    if($('#projectIdBox select option').length > maxCount)
    {
        $('#projectIdBox select').picker();
    }
    else
    {
        $('#projectIdBox select').chosen();
    }

    if(typeof(emptySelect) != 'undefined') $('#projectIdBox select').val('').trigger('chosen:updated');
}

/**
 * Replace execution data.
 *
 * @param  string data
 * @access public
 * @return void
 */
function replaceExecution(data, emptySelect)
{
    $('#executionIdBox select').replaceWith(data);
    $('#executionIdBox .chosen-container').remove();
    $('#executionIdBox .picker').remove();
    if($('#executionIdBox select option').length > maxCount)
    {
        $('#executionIdBox select').picker();
    }
    else
    {
        $('#executionIdBox select').chosen();
    }

    if(typeof(emptySelect) != 'undefined') $('#executionIdBox select').val('').trigger('chosen:updated');
}

/**
 * Load dept users.
 *
 * @param  int $deptID
 * @access public
 * @return void
 */
function loadDeptUsers(deptID)
{
    var link = createLink('dept', 'ajaxGetUsers', 'dept=' + deptID + '&user=' + $('#userBox #user').val() + '&key=id');

    $.get(link, function(data)
    {
        $('#userBox select').replaceWith(data);
        $('#userBox .chosen-container').remove();
        $('#userBox select').chosen();
    })
}

/**
 * Flush width.
 *
 * @param  object $obj
 * @access public
 * @return void
 */
function flushWidth(obj)
{
    var maxWidth = 0;
    $(obj).find('.input-group').each(function()
    {
        var $groupAddon = $(this).find('.input-group-addon:first');
        if($groupAddon.length > 0)
        {
            var width = $(this).find('.input-group-addon:first').outerWidth();
            if(width > maxWidth) maxWidth = width;
        }
    });
    $(obj).find('.input-group').each(function()
    {
        var $groupAddon = $(this).find('.input-group-addon:first');
        var padding     = 1;
        if($groupAddon.length > 0)
        {
            while($groupAddon.outerWidth() < maxWidth)
            {
                $groupAddon.css('padding-right', padding + 'px').css('padding-left', padding + 'px');
                padding++;
            }
        }
    });
}
