-- DROP TABLE IF EXISTS `zt_acl`;
CREATE TABLE IF NOT EXISTS `zt_acl` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `objectType` char(30) NOT NULL,
  `objectID` mediumint(9) NOT NULL DEFAULT '0',
  `type` char(40) NOT NULL DEFAULT 'whitelist',
  `source` char(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_action`;
CREATE TABLE IF NOT EXISTS `zt_action` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `objectType` varchar(30) NOT NULL default '',
  `objectID` mediumint(8) unsigned NOT NULL default '0',
  `product` text NOT NULL,
  `project` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `actor` varchar(100) NOT NULL default '',
  `action` varchar(30) NOT NULL default '',
  `date` datetime NOT NULL,
  `comment` text NOT NULL,
  `extra` text NOT NULL,
  `read` enum('0','1') NOT NULL default '0',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  KEY `date` (`date`),
  KEY `actor` (`actor`),
  KEY `project` (`project`),
  KEY `action` (`action`),
  KEY `objectID` (`objectID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_api_lib_release`;
CREATE TABLE `zt_api_lib_release` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `lib` int UNSIGNED NOT NULL DEFAULT 0,
  `desc` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(255) NOT NULL DEFAULT '',
  `snap` mediumtext NOT NULL,
  `addedBy` varchar(30) NOT NULL DEFAULT 0,
  `addedDate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_api`;
CREATE TABLE `zt_api` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `product` varchar(255) NOT NULL DEFAULT '',
  `lib` int UNSIGNED NOT NULL DEFAULT 0,
  `module` int UNSIGNED NOT NULL DEFAULT 0,
  `title` varchar(100) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `protocol` varchar(10)  NOT NULL DEFAULT '',
  `method` varchar(10)  NOT NULL DEFAULT '',
  `requestType` varchar(100) NOT NULL DEFAULT '',
  `responseType` varchar(100) NOT NULL DEFAULT '',
  `status` varchar(20)  NOT NULL DEFAULT '',
  `owner` varchar(30)  NOT NULl DEFAULT 0,
  `desc` mediumtext NULL,
  `version` smallint UNSIGNED NOT NULL DEFAULT 0,
  `params` text NULL,
  `paramsExample` text NUll,
  `responseExample` text NUll,
  `response` text NULL,
  `commonParams` text NULL,
  `addedBy` varchar(30)  NOT NULL DEFAULT 0,
  `addedDate` datetime NOT NULL,
  `editedBy` varchar(30)  NOT NULL DEFAULT 0,
  `editedDate` datetime NOT NULL,
  `deleted` enum ('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_apispec`;
CREATE TABLE `zt_apispec` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `doc` int UNSIGNED NOT NULL DEFAULT 0,
  `module` int UNSIGNED NOT NULL DEFAULT 0,
  `title` varchar(100) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `protocol` varchar(10)  NOT NULL DEFAULT '',
  `method` varchar(10)  NOT NULL DEFAULT '',
  `requestType` varchar(100) NOT NULL DEFAULT '',
  `responseType` varchar(100) NOT NULL DEFAULT '',
  `status` varchar(20)  NOT NULL DEFAULT '',
  `owner` varchar(255) NOT NULl DEFAULT 0,
  `desc` mediumtext NULL,
  `version` smallint UNSIGNED NOT NULL DEFAULT 0,
  `params` text NULL,
  `paramsExample` text NUll,
  `responseExample` text NUll,
  `response` text NULL,
  `addedBy` varchar(30)  NOT NULL DEFAULT 0,
  `addedDate` datetime NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_apistruct`;
CREATE TABLE `zt_apistruct` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `lib` int UNSIGNED NOT NULL DEFAULT 0,
  `name` varchar(30)  NOT NULL DEFAULT '',
  `type` varchar(50)  NOT NULL DEFAULT '',
  `desc` mediumtext NOT NULL DEFAULT '',
  `version` smallint unsigned NOT NULL DEFAULT 0,
  `attribute` text NULL,
  `addedBy` varchar(30) NOT NULL DEFAULT 0,
  `addedDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT 0,
  `editedDate` datetime NOT NULL,
  `deleted` enum ('0', '1') NOT NULL DEFAULT '0',
  primary key (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_apistruct_spec`;
CREATE TABLE `zt_apistruct_spec` (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(50)  NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `attribute` text NULL,
  `version` smallint unsigned NOT NULL DEFAULT 0,
  `addedBy` varchar(30) NOT NULL DEFAULT 0,
  `addedDate` datetime NOT NULL,
  primary key (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_approval`;
CREATE TABLE `zt_approval` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `flow` mediumint(8) NOT NULL,
  `objectType` varchar(30) NOT NULL,
  `objectID` mediumint(9) NOT NULL,
  `nodes` mediumtext NOT NULL,
  `version` mediumint(9) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'doing',
  `result` varchar(20) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` int(11) NOT NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_approvalflow`;
CREATE TABLE `zt_approvalflow` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `code` varchar(100) NOT NULL,
  `desc` mediumtext NOT NULL,
  `version` mediumint(8) NOT NULL DEFAULT '1',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `type` varchar(30) NOT NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_approvalflowobject`;
CREATE TABLE `zt_approvalflowobject` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `root` int(8) NOT NULL,
  `flow` int(8) NOT NULL,
  `objectType` char(30) NOT NULL,
  `objectID` mediumint(9) NOT NULL,
  `extra` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_approvalflowspec`;
CREATE TABLE `zt_approvalflowspec` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `flow` mediumint(8) NOT NULL,
  `version` mediumint(8) NOT NULL,
  `nodes` mediumtext NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_approvalnode`;
CREATE TABLE `zt_approvalnode` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `approval` mediumint(8) NOT NULL,
  `type` enum('review','cc') NOT NULL,
  `title` varchar(255) NOT NULL,
  `account` char(30) NOT NULL,
  `node` varchar(100) NOT NULL,
  `reviewType` varchar(100)  NOT NULL DEFAULT 'manual',
  `multipleType` enum('and','or') NOT NULL DEFAULT 'and',
  `prev` mediumtext NOT NULL,
  `next` mediumtext NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'wait',
  `result` varchar(10) NOT NULL,
  `date` date NOT NULL,
  `opinion` mediumtext NOT NULL,
  `extra` mediumtext NOT NULL,
  `reviewedBy` char(30) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_approvalobject`;
CREATE TABLE `zt_approvalobject` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `approval` int(8) NOT NULL,
  `objectType` char(30) NOT NULL,
  `objectID` mediumint(8) NOT NULL,
  `extra` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_approvalrole`;
CREATE TABLE `zt_approvalrole` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `code` char(30) NOT NULL,
  `name` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  `users` longtext NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_block`;
CREATE TABLE IF NOT EXISTS `zt_block` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `module` varchar(20) NOT NULL,
  `type` char(30) NOT NULL,
  `title` varchar(100) NOT NULL,
  `source` varchar(20) NOT NULL,
  `block` varchar(20) NOT NULL,
  `params` text NOT NULL,
  `order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `grid` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `height` smallint(5) unsigned NOT NULL DEFAULT '0',
  `hidden` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `account_vision_module_type_order` (`account`,`vision`,`module`,`type`,`order`),
  KEY `account` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_branch`;
CREATE TABLE IF NOT EXISTS `zt_branch` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `default` enum ('0', '1') NOT NULL DEFAULT '0',
  `status` enum ('active', 'closed') NOT NULL DEFAULT 'active',
  `desc` varchar(255) NOT NULL,
  `createdDate` date NOT NULL,
  `closedDate` date NOT NULL,
  `order` smallint unsigned NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY  (`id`),
  KEY `product` (`product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_bug`;
CREATE TABLE IF NOT EXISTS `zt_bug` (
  `id` mediumint(8) NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `execution` mediumint(8) unsigned NOT NULL default '0',
  `plan` mediumint(8) unsigned NOT NULL default '0',
  `story` mediumint(8) unsigned NOT NULL default '0',
  `storyVersion` smallint(6) NOT NULL default '1',
  `task` mediumint(8) unsigned NOT NULL default '0',
  `toTask` mediumint(8) unsigned NOT NULL default '0',
  `toStory` mediumint(8) NOT NULL default '0',
  `title` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `severity` tinyint(4) NOT NULL default '0',
  `pri` tinyint(3) unsigned NOT NULL,
  `type` varchar(30) NOT NULL default '',
  `os` varchar(30) NOT NULL default '',
  `browser` varchar(30) NOT NULL default '',
  `hardware` varchar(30) NOT NULL,
  `found` varchar(30) NOT NULL default '',
  `steps` mediumtext NOT NULL,
  `status` enum('active','resolved','closed') NOT NULL default 'active',
  `subStatus` varchar(30) NOT NULL default '',
  `color` char(7) NOT NULL,
  `confirmed` tinyint(1) NOT NULL default '0',
  `activatedCount` smallint(6) NOT NULL,
  `activatedDate` datetime NOT NULL,
  `feedbackBy` varchar(100) NOT NULL,
  `notifyEmail` varchar(100) NOT NULL,
  `mailto` text,
  `openedBy` varchar(30) NOT NULL default '',
  `openedDate` datetime NOT NULL,
  `openedBuild` varchar(255) NOT NULL,
  `assignedTo` varchar(30) NOT NULL default '',
  `assignedDate` datetime NOT NULL,
  `deadline` date NOT NULL,
  `resolvedBy` varchar(30) NOT NULL default '',
  `resolution` varchar(30) NOT NULL default '',
  `resolvedBuild` varchar(30) NOT NULL default '',
  `resolvedDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL default '',
  `closedDate` datetime NOT NULL,
  `duplicateBug` mediumint(8) unsigned NOT NULL,
  `linkBug` varchar(255) NOT NULL,
  `case` mediumint(8) unsigned NOT NULL,
  `caseVersion` smallint(6) NOT NULL DEFAULT '1',
  `result` mediumint(8) unsigned NOT NULL,
  `repo` mediumint(8) unsigned NOT NULL,
  `mr` mediumint(8) unsigned NOT NULL,
  `entry` text NOT NULL,
  `lines` varchar(10) NOT NULL,
  `v1` varchar(40) NOT NULL,
  `v2` varchar(40) NOT NULL,
  `repoType` varchar(30) NOT NULL DEFAULT '',
  `issueKey` varchar(50) NOT NULL DEFAULT '',
  `testtask` mediumint(8) unsigned NOT NULL,
  `lastEditedBy` varchar(30) NOT NULL default '',
  `lastEditedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`),
  KEY `status` (`status`),
  KEY `plan` (`plan`),
  KEY `story` (`story`),
  KEY `case` (`case`),
  KEY `toStory` (`toStory`),
  KEY `result` (`result`),
  KEY `assignedTo` (`assignedTo`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_build`;
CREATE TABLE IF NOT EXISTS `zt_build` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `execution` mediumint(8) unsigned NOT NULL default '0',
  `name` char(150) NOT NULL,
  `scmPath` char(255) NOT NULL,
  `filePath` char(255) NOT NULL,
  `date` date NOT NULL,
  `stories` text NOT NULL,
  `bugs` text NOT NULL,
  `builder` char(30) NOT NULL default '',
  `desc` mediumtext NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_burn`;
CREATE TABLE IF NOT EXISTS `zt_burn` (
  `execution` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `task` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `date` date NOT NULL,
  `estimate` float NOT NULL,
  `left` float NOT NULL,
  `consumed` float NOT NULL,
  `storyPoint` float NOT NULL,
  PRIMARY KEY  (`execution`,`date`,`task`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_case`;
CREATE TABLE IF NOT EXISTS `zt_case` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `execution` mediumint(8) unsigned NOT NULL,
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `lib` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `path` mediumint(8) unsigned NOT NULL default '0',
  `story` mediumint(30) unsigned NOT NULL default '0',
  `storyVersion` smallint(6) NOT NULL default '1',
  `title` varchar(255) NOT NULL,
  `precondition` text NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `pri` tinyint(3) unsigned NOT NULL default '3',
  `type` char(30) NOT NULL default '1',
  `auto` varchar(10) NOT NULL default 'no',
  `frame` varchar(10) NOT NULL,
  `stage` varchar(255) NOT NULL,
  `howRun` varchar(30) NOT NULL,
  `scriptedBy` varchar(30) NOT NULL,
  `scriptedDate` date NOT NULL,
  `scriptStatus` varchar(30) NOT NULL,
  `scriptLocation` varchar(255) NOT NULL,
  `status` char(30) NOT NULL default '1',
  `subStatus` varchar(30) NOT NULL default '',
  `color` char(7) NOT NULL,
  `frequency` enum('1','2','3') NOT NULL default '1',
  `order` tinyint(30) unsigned NOT NULL default '0',
  `openedBy` char(30) NOT NULL default '',
  `openedDate` datetime NOT NULL,
  `reviewedBy` varchar(255) NOT NULL,
  `reviewedDate` date NOT NULL,
  `lastEditedBy` char(30) NOT NULL default '',
  `lastEditedDate` datetime NOT NULL,
  `version` tinyint(3) unsigned NOT NULL default '0',
  `linkCase` varchar(255) NOT NULL,
  `fromBug` mediumint(8) unsigned NOT NULL,
  `fromCaseID` mediumint(8) unsigned NOT NULL,
  `fromCaseVersion` mediumint(8) unsigned NOT NULL default '1',
  `deleted` enum('0','1') NOT NULL default '0',
  `lastRunner` varchar(30) NOT NULL,
  `lastRunDate` datetime NOT NULL,
  `lastRunResult` char(30) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `story` (`story`),
  KEY `fromBug` (`fromBug`),
  KEY `module` (`module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_casestep`;
CREATE TABLE IF NOT EXISTS `zt_casestep` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `case` mediumint(8) unsigned NOT NULL default '0',
  `version` smallint(3) unsigned NOT NULL default '0',
  `type` varchar(10) NOT NULL DEFAULT 'step',
  `desc` text NOT NULL,
  `expect` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `case` (`case`),
  KEY `version` (`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_company`;
CREATE TABLE IF NOT EXISTS `zt_company` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` char(120) default NULL,
  `phone` char(20) default NULL,
  `fax` char(20) default NULL,
  `address` char(120) default NULL,
  `zipcode` char(10) default NULL,
  `website` char(120) default NULL,
  `backyard` char(120) default NULL,
  `guest` enum('1','0') NOT NULL default '0',
  `admins` char(255) default NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_compile`;
CREATE TABLE IF NOT EXISTS `zt_compile` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `job` mediumint(8) unsigned NOT NULL,
  `queue` mediumint(8) NOT NULL,
  `status` varchar(255) NOT NULL,
  `logs` text,
  `atTime` varchar(10) NOT NULL,
  `testtask` mediumint(8) unsigned NOT NULL,
  `tag` varchar(255) NOT NULL,
  `times` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `updateDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_config`;
CREATE TABLE IF NOT EXISTS `zt_config` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `vision` varchar(10) NOT NULL DEFAULT '',
  `owner` char(30) NOT NULL default '',
  `module` varchar(30) NOT NULL,
  `section` char(30) NOT NULL default '',
  `key` char(30) NOT NULL default '',
  `value` longtext NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `unique` (`vision`,`owner`,`module`,`section`,`key`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_cron`;
CREATE TABLE IF NOT EXISTS `zt_cron` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `m` varchar(20) NOT NULL,
  `h` varchar(20) NOT NULL,
  `dom` varchar(20) NOT NULL,
  `mon` varchar(20) NOT NULL,
  `dow` varchar(20) NOT NULL,
  `command` text NOT NULL,
  `remark` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `buildin` tinyint(1) NOT NULL DEFAULT '0',
  `status` varchar(20) NOT NULL,
  `lastTime` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `lastTime` (`lastTime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_dept`;
CREATE TABLE IF NOT EXISTS `zt_dept` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` char(60) NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `path` char(255) NOT NULL default '',
  `grade` tinyint(3) unsigned NOT NULL default '0',
  `order` smallint(4) unsigned NOT NULL default '0',
  `position` char(30) NOT NULL default '',
  `function` char(255) NOT NULL default '',
  `manager` char(30) NOT NULL default '',
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `path` (`path`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_design`;
CREATE TABLE IF NOT EXISTS `zt_design` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` varchar(255) NOT NULL,
  `product` varchar(255) NOT NULL,
  `commit` text NOT NULL,
  `commitedBy` varchar(30) NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL,
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `story` char(30) NOT NULL,
  `desc` mediumtext NOT NULL,
  `version` smallint(6) NOT NULL,
  `type` char(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_designspec`;
CREATE TABLE IF NOT EXISTS `zt_designspec` (
  `design` mediumint(8) NOT NULL,
  `version` smallint(6) NOT NULL,
  `name` varchar(255) NOT NULL,
  `desc` mediumtext NOT NULL,
  `files` varchar(255) NOT NULL,
  UNIQUE KEY `design` (`design`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_doc`;
CREATE TABLE IF NOT EXISTS `zt_doc` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `lib` varchar(30) NOT NULL,
  `module` varchar(30) NOT NULL,
  `title` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `type` varchar(30) NOT NULL,
  `views` smallint(5) unsigned NOT NULL,
  `draft` longtext NOT NULL,
  `collector` text NOT NULL,
  `addedBy` varchar(30) NOT NULL,
  `addedDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `mailto` text,
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `groups` varchar(255) NOT NULL,
  `users` text NOT NULL,
  `version` smallint(5) unsigned NOT NULL DEFAULT '1',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`),
  KEY `lib` (`lib`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_doccontent`;
CREATE TABLE IF NOT EXISTS `zt_doccontent` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `doc` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `digest` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `files` text NOT NULL,
  `type` varchar(10) NOT NULL,
  `version` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `doc_version` (`doc`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_doclib`;
CREATE TABLE IF NOT EXISTS `zt_doclib` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `type` varchar(30) NOT NULL,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `product` mediumint(8) unsigned NOT NULL,
  `project` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `name` varchar(60) NOT NULL,
  `baseUrl` varchar(255) NOT NULL DEFAULT '',
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `groups` varchar(255) NOT NULL,
  `users` text NOT NULL,
  `main` enum('0','1') NOT NULL default '0',
  `collector` text NOT NULL,
  `desc` mediumtext NOT NULL,
  `order` tinyint(5) unsigned NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_effort`;
CREATE TABLE IF NOT EXISTS `zt_effort` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `user` char(30) NOT NULL default '',
  `todo` enum('1','0') NOT NULL default '1',
  `date` date NOT NULL,
  `begin` datetime NOT NULL default '0000-00-00 00:00:00',
  `end` datetime NOT NULL default '0000-00-00 00:00:00',
  `type` enum('1','2','3') NOT NULL default '1',
  `idvalue` mediumint(8) unsigned NOT NULL default '0',
  `name` char(30) NOT NULL default '',
  `desc` char(255) NOT NULL default '',
  `status` enum('1','2','3') NOT NULL default '1',
  PRIMARY KEY  (`id`),
  KEY `user` (`user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_entry`;
CREATE TABLE IF NOT EXISTS `zt_entry` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `account` varchar(30) NOT NULL DEFAULT '',
  `code` varchar(20) NOT NULL,
  `key` varchar(32) NOT NULL,
  `freePasswd` enum('0','1') NOT NULL DEFAULT '0',
  `ip` varchar(100) NOT NULL,
  `desc` mediumtext NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `calledTime` int(10) unsigned NOT NULL DEFAULT '0',
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_expect`;
CREATE TABLE IF NOT EXISTS `zt_expect` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `userID` mediumint(8) NOT NULL,
  `project` mediumint(8) NOT NULL DEFAULT 0,
  `expect` text NOT NULL,
  `progress` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_extension`;
CREATE TABLE IF NOT EXISTS `zt_extension` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` varchar(150) NOT NULL,
  `code` varchar(30) NOT NULL,
  `version` varchar(50) NOT NULL,
  `author` varchar(100) NOT NULL,
  `desc` mediumtext NOT NULL,
  `license` text NOT NULL,
  `type` varchar(20) NOT NULL default 'extension',
  `site` varchar(150) NOT NULL,
  `zentaoCompatible` varchar(100) NOT NULL,
  `installedTime` datetime NOT NULL,
  `depends` varchar(100) NOT NULL,
  `dirs` mediumtext NOT NULL,
  `files` mediumtext NOT NULL,
  `status` varchar(20) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `name` (`name`),
  KEY `installedTime` (`installedTime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_file`;
CREATE TABLE IF NOT EXISTS `zt_file` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `pathname` char(50) NOT NULL,
  `title` varchar(255) NOT NULL,
  `extension` char(30) NOT NULL,
  `size` int(10) unsigned NOT NULL default '0',
  `objectType` char(30) NOT NULL,
  `objectID` mediumint(9) NOT NULL,
  `addedBy` char(30) NOT NULL default '',
  `addedDate` datetime NOT NULL,
  `downloads` mediumint(8) unsigned NOT NULL default '0',
  `extra` varchar(255) NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `objectType` (`objectType`),
  KEY `objectID` (`objectID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_group`;
CREATE TABLE IF NOT EXISTS `zt_group` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `name` char(30) NOT NULL,
  `role` char(30) NOT NULL default '',
  `desc` char(255) NOT NULL default '',
  `acl` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_grouppriv`;
CREATE TABLE IF NOT EXISTS `zt_grouppriv` (
  `group` mediumint(8) unsigned NOT NULL default '0',
  `module` char(30) NOT NULL default '',
  `method` char(30) NOT NULL default '',
  UNIQUE KEY `group` (`group`,`module`,`method`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_holiday`;
CREATE TABLE IF NOT EXISTS `zt_holiday` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `type` enum('holiday', 'working') NOT NULL DEFAULT 'holiday',
  `desc` mediumtext NOT NULL,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_history`;
CREATE TABLE IF NOT EXISTS `zt_history` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `action` mediumint(8) unsigned NOT NULL default '0',
  `field` varchar(30) NOT NULL default '',
  `old` text NOT NULL,
  `new` text NOT NULL,
  `diff` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `action` (`action`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_job`;
CREATE TABLE IF NOT EXISTS `zt_job` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `repo` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `frame` varchar(20) NOT NULL,
  `engine` varchar(20) NOT NULL,
  `server` mediumint(8) unsigned NOT NULL,
  `pipeline` varchar(500) NOT NULL,
  `triggerType` varchar(255) NOT NULL,
  `sonarqubeServer` mediumint(8) unsigned NOT NULL,
  `projectKey` varchar(255) NOT NULL,
  `svnDir` varchar(255) NOT NULL,
  `atDay` varchar(255) DEFAULT NULL,
  `atTime` varchar(10) DEFAULT NULL,
  `customParam` text NOT NULL,
  `comment` varchar(255) DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `lastExec` datetime DEFAULT NULL,
  `lastStatus` varchar(255) DEFAULT NULL,
  `lastTag` varchar(255) DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_kanbanspace`;
CREATE TABLE `zt_kanbanspace` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(50) NOT NULL,
  `owner` varchar(30) NOT NULL,
  `team` text NOT NULL,
  `desc` mediumtext NOT NULL,
  `acl` char(30) NOT NULL DEFAULT 'open',
  `whitelist` text NOT NULL,
  `status` enum('active','closed') NOT NULL default 'active',
  `order` mediumint(8) NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `lastEditedBy` char(30) NOT NULL,
  `lastEditedDate` datetime NOT NULL,
  `closedBy` char(30) NOT NULL,
  `closedDate` datetime NOT NULL,
  `activatedBy` char(30) NOT NULL,
  `activatedDate` datetime NOT NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_kanban`;
CREATE TABLE `zt_kanban` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `space` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `owner` varchar(30) NOT NULL,
  `team` text NOT NULL,
  `desc` mediumtext NOT NULL,
  `acl` char(30) NOT NULL DEFAULT 'open',
  `whitelist` text NOT NULL,
  `archived` enum('0', '1') NOT NULL DEFAULT '1',
  `performable` enum ('0', '1') NOT NULL DEFAULT '0',
  `status` enum('active','closed') NOT NULL default 'active',
  `order` mediumint(8) NOT NULL DEFAULT '0',
  `displayCards` smallint(6) NOT NULL default '0',
  `fluidBoard` enum('0','1') NOT NULL DEFAULT '0',
  `object` varchar(255) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `lastEditedBy` char(30) NOT NULL,
  `lastEditedDate` datetime NOT NULL,
  `closedBy` char(30) NOT NULL,
  `closedDate` datetime NOT NULL,
  `activatedBy` char(30) NOT NULL,
  `activatedDate` datetime NOT NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_kanbanregion`;
CREATE TABLE `zt_kanbanregion` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `space` mediumint(8) unsigned NOT NULL,
  `kanban` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `order` mediumint(8) NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `lastEditedBy` char(30) NOT NULL,
  `lastEditedDate` datetime NOT NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_kanbancard`;
CREATE TABLE `zt_kanbancard` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `kanban` mediumint(8) unsigned NOT NULL,
  `region` mediumint(8) unsigned NOT NULL,
  `group` mediumint(8) unsigned NOT NULL,
  `fromID` mediumint(8) unsigned NOT NULL,
  `fromType` varchar(30) NOT NULL,
  `name` varchar(255) NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'doing',
  `pri` mediumint(8) unsigned NOT NULL,
  `assignedTo` text NOT NULL,
  `desc` mediumtext NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `estimate` float unsigned NOT NULL,
  `progress` float unsigned NOT NULL DEFAULT '0',
  `color` char(7) NOT NULL,
  `acl` char(30) NOT NULL DEFAULT 'open',
  `whitelist` text NOT NULL,
  `order` mediumint(8) NOT NULL DEFAULT '0',
  `archived` enum('0', '1') NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `lastEditedBy` char(30) NOT NULL,
  `lastEditedDate` datetime NOT NULL,
  `archivedBy` char(30) NOT NULL,
  `archivedDate` datetime NOT NULL,
  `assignedBy` char(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_kanbancell`;
CREATE TABLE `zt_kanbancell` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `kanban` mediumint(8) NOT NULL,
  `lane` mediumint(8) NOT NULL,
  `column` mediumint(8) NOT NULL,
  `type` char(30) NOT NULL,
  `cards` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `card_group` (`kanban`,`type`,`lane`,`column`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_kanbangroup`;
CREATE TABLE `zt_kanbangroup` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `kanban` mediumint(8) unsigned NOT NULL,
  `region` mediumint(8) unsigned NOT NULL,
  `order` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_kanbanlane`;
CREATE TABLE IF NOT EXISTS `zt_kanbanlane` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `execution` mediumint(8) NOT NULL DEFAULT '0',
  `type` char(30) NOT NULL,
  `region` mediumint(8) unsigned NOT NULL,
  `group` mediumint(8) unsigned NOT NULL,
  `groupby` char(30) NOT NULL,
  `extra` char(30) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `color` char(30) NOT NULL,
  `order` smallint(6) NOT NULL DEFAULT '0',
  `lastEditedTime` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_kanbancolumn`;
CREATE TABLE IF NOT EXISTS `zt_kanbancolumn` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `parent` mediumint(8) NOT NULL DEFAULT '0',
  `type` char(30) NOT NULL,
  `region` mediumint(8) unsigned NOT NULL,
  `group` mediumint(8) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `color` char(30) NOT NULL,
  `limit` smallint(6) NOT NULL DEFAULT '-1',
  `order` mediumint(8) NOT NULL DEFAULT '0',
  `archived` enum('0', '1') NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_lang`;
CREATE TABLE IF NOT EXISTS `zt_lang` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `lang` varchar(30) NOT NULL,
  `module` varchar(30) NOT NULL,
  `section` varchar(30) NOT NULL,
  `key` varchar(60) NOT NULL,
  `value` text NOT NULL,
  `system` enum('0','1') NOT NULL default '1',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `lang` (`lang`,`module`,`section`,`key`,`vision`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_log`;
CREATE TABLE IF NOT EXISTS `zt_log` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(30) NOT NULL,
  `objectID` mediumint(8) unsigned NOT NULL,
  `action` mediumint(8) unsigned NOT NULL,
  `date` datetime NOT NULL,
  `url` varchar(255) NOT NULL,
  `contentType` varchar(30) NOT NULL,
  `data` text NOT NULL,
  `result` text  NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `objectType` (`objectType`),
  KEY `obejctID` (`objectID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_module`;
CREATE TABLE IF NOT EXISTS `zt_module` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `root` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `name` char(60) NOT NULL default '',
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `path` char(255) NOT NULL default '',
  `grade` tinyint(3) unsigned NOT NULL default '0',
  `order` smallint(5) unsigned NOT NULL default '0',
  `type` char(30) NOT NULL,
  `owner` varchar(30) NOT NULL,
  `collector` text NOT NULL,
  `short` varchar(30) NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `root` (`root`),
  KEY `type` (`type`),
  KEY `path` (`path`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_mr`;
CREATE TABLE IF NOT EXISTS `zt_mr` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `gitlabID` mediumint(8) unsigned NOT NULL,
  `sourceProject` int unsigned NOT NULL,
  `sourceBranch` varchar(100) NOT NULL,
  `targetProject` int unsigned NOT NULL,
  `targetBranch` varchar(100) NOT NULL,
  `mriid` int unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `assignee` varchar(255) NOT NULL,
  `reviewer` varchar(255) NOT NULL,
  `approver` varchar(255) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `status` char(30) NOT NULL,
  `mergeStatus` char(30) NOT NULL,
  `approvalStatus` char(30) NOT NULL,
  `needApproved` enum('0','1') NOT NULL DEFAULT '0',
  `needCI` enum('0','1') NOT NULL DEFAULT '0',
  `repoID` mediumint(8) unsigned NOT NULL,
  `jobID` mediumint(8) unsigned NOT NULL,
  `compileID` mediumint(8) unsigned NOT NULL,
  `compileStatus` char(30) NOT NULL,
  `removeSourceBranch` enum('0','1') NOT NULL DEFAULT '0',
  `squash` enum('0','1') NOT NULL DEFAULT '0',
  `synced` enum('0','1') COLLATE 'utf8_general_ci' NOT NULL DEFAULT '1',
  `syncError` varchar(255) NOT NULL,
  `hasNoConflict` enum('0','1') COLLATE 'utf8_general_ci' NOT NULL DEFAULT '0',
  `diffs` longtext COLLATE 'utf8_general_ci' NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_mrapproval`;
CREATE TABLE IF NOT EXISTS `zt_mrapproval` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `mrID` mediumint(8) unsigned NOT NULL,
  `account` varchar(255) NOT NULL,
  `date` datetime NOT NULL,
  `action` char(30) NOT NULL,
  `comment` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_notify`;
CREATE TABLE IF NOT EXISTS `zt_notify` (
  `id` mediumint unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(50) NOT NULL,
  `objectID` mediumint unsigned NOT NULL,
  `action` mediumint NOT NULL,
  `toList` varchar(255) NOT NULL,
  `ccList` text NOT NULL,
  `subject` varchar(255) NOT NULL,
  `data` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `sendTime` datetime NOT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `failReason` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `objectType_toList_status` (`objectType`,`toList`,`status`)
) ENGINE='MyISAM' COLLATE 'utf8_general_ci';
-- DROP TABLE IF EXISTS `zt_oauth`;
CREATE TABLE IF NOT EXISTS `zt_oauth` (
  `account` varchar(30) NOT NULL,
  `openID` varchar(255) NOT NULL,
  `providerType` varchar(30) NOT NULL,
  `providerID` mediumint(8) unsigned NOT NULL,
  KEY `account` (`account`),
  KEY `providerType` (`providerType`),
  KEY `providerID` (`providerID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_pipeline`;
CREATE TABLE IF NOT EXISTS `zt_pipeline` (
  `id` smallint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` char(30) NOT NULL,
  `name` varchar(50) NOT NULL,
  `url` varchar(255) DEFAULT NULL,
  `account` varchar(30) DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `token` varchar(255) DEFAULT NULL,
  `private` char(32) DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_planstory`;
CREATE TABLE IF NOT EXISTS `zt_planstory` (
  `plan` mediumint(8) unsigned NOT NULL,
  `story` mediumint(8) unsigned NOT NULL,
  `order` mediumint(9) NOT NULL,
  UNIQUE KEY `plan_story` (`plan`,`story`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_product`;
CREATE TABLE IF NOT EXISTS `zt_product` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `program` mediumint(8) unsigned NOT NULL,
  `name` varchar(90) NOT NULL,
  `code` varchar(45) NOT NULL,
  `bind` enum('0','1') NOT NULL DEFAULT '0',
  `line` mediumint(8) NOT NULL,
  `type` varchar(30) NOT NULL default 'normal',
  `status` varchar(30) NOT NULL default '',
  `subStatus` varchar(30) NOT NULL default '',
  `desc` mediumtext NOT NULL,
  `PO` varchar(30) NOT NULL,
  `QD` varchar(30) NOT NULL,
  `RD` varchar(30) NOT NULL,
  `acl` enum('open','private','custom') NOT NULL default 'open',
  `whitelist` text NOT NULL,
  `reviewer` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `createdVersion` varchar(20) NOT NULL,
  `order` mediumint(8) unsigned NOT NULL,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `acl` (`acl`),
  KEY `order` (`order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_productplan`;
CREATE TABLE IF NOT EXISTS `zt_productplan` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `product` mediumint(8) unsigned NOT NULL,
  `branch` mediumint(8) unsigned NOT NULL,
  `parent` mediumint(9) NOT NULL DEFAULT '0',
  `title` varchar(90) NOT NULL,
  `status` enum('wait','doing','done','closed') NOT NULL default 'wait',
  `desc` mediumtext NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `order` text NOT NULL,
  `closedReason` varchar(20) NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `end` (`end`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_project`;
CREATE TABLE IF NOT EXISTS `zt_project` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) NOT NULL DEFAULT 0,
  `model` char(30) NOT NULL,
  `type` char(30) NOT NULL DEFAULT 'sprint',
  `lifetime` char(30) NOT NULL DEFAULT '',
  `budget` varchar(30) NOT NULL DEFAULT '0',
  `budgetUnit` char(30) NOT NULL DEFAULT 'CNY',
  `attribute` varchar(30) NOT NULL DEFAULT '',
  `percent` float unsigned NOT NULL DEFAULT '0',
  `milestone` enum('0','1') NOT NULL DEFAULT '0',
  `output` text NOT NULL,
  `auth` char(30) NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL,
  `grade` tinyint(3) unsigned NOT NULL,
  `name` varchar(90) NOT NULL,
  `code` varchar(45) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `realBegan` date NOT NULL,
  `realEnd` date NOT NULL,
  `days` smallint(5) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `pri` enum('1','2','3','4') NOT NULL DEFAULT '1',
  `desc` mediumtext NOT NULL,
  `version` smallint(6) NOT NULL,
  `parentVersion` smallint(6) NOT NULL,
  `planDuration` int(11) NOT NULL,
  `realDuration` int(11) NOT NULL,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime NOT NULL,
  `openedVersion` varchar(20) NOT NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime NOT NULL,
  `canceledBy` varchar(30) NOT NULL DEFAULT '',
  `canceledDate` datetime NOT NULL,
  `suspendedDate` date NOT NULL,
  `PO` varchar(30) NOT NULL DEFAULT '',
  `PM` varchar(30) NOT NULL DEFAULT '',
  `QD` varchar(30) NOT NULL DEFAULT '',
  `RD` varchar(30) NOT NULL DEFAULT '',
  `team` varchar(90) NOT NULL,
  `acl` char(30) NOT NULL DEFAULT 'open',
  `whitelist` text NOT NULL,
  `order` mediumint(8) unsigned NOT NULL,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `displayCards` smallint(6) NOT NULL default '0',
  `fluidBoard` enum('0','1') NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `begin` (`begin`),
  KEY `end` (`end`),
  KEY `status` (`status`),
  KEY `acl` (`acl`),
  KEY `order` (`order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_projectcase`;
CREATE TABLE IF NOT EXISTS `zt_projectcase` (
  `project` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `product` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `case` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `count` mediumint(8) unsigned NOT NULL DEFAULT '1',
  `version` smallint(6) NOT NULL DEFAULT '1',
  `order` smallint(6) unsigned NOT NULL,
  UNIQUE KEY `project` (`project`,`case`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_projectproduct`;
CREATE TABLE IF NOT EXISTS `zt_projectproduct` (
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `branch` mediumint(8) unsigned NOT NULL,
  `plan` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY  (`project`, `product`, `branch`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_projectspec`;
CREATE TABLE IF NOT EXISTS `zt_projectspec` (
  `project` mediumint(8) NOT NULL,
  `version` smallint(6) NOT NULL,
  `name` varchar(255) NOT NULL,
  `milestone` enum('0','1') NOT NULL DEFAULT '0',
  `begin` date NOT NULL,
  `end` date NOT NULL,
  UNIQUE KEY `project` (`project`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_projectstory`;
CREATE TABLE IF NOT EXISTS `zt_projectstory` (
  `project` mediumint(8) unsigned NOT NULL default '0',
  `product` mediumint(8) unsigned NOT NULL,
  `branch` mediumint(8) unsigned NOT NULL,
  `story` mediumint(8) unsigned NOT NULL default '0',
  `version` smallint(6) NOT NULL default '1',
  `order` smallint(6) unsigned NOT NULL,
  UNIQUE KEY `project` (`project`,`story`),
  KEY `story` (`story`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_relation`;
CREATE TABLE IF NOT EXISTS `zt_relation` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) NOT NULL,
  `product` mediumint(8) NOT NULL,
  `execution` mediumint(8) NOT NULL,
  `AType` char(30) NOT NULL,
  `AID` mediumint(8) NOT NULL,
  `AVersion` char(30) NOT NULL,
  `relation` char(30) NOT NULL,
  `BType` char(30) NOT NULL,
  `BID` mediumint(8) NOT NULL,
  `BVersion` char(30) NOT NULL,
  `extra` char(30) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `relation` (`product`,`relation`,`AType`,`BType`, `AID`, `BID`)
) ENGINE='MyISAM' DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_release`;
CREATE TABLE IF NOT EXISTS `zt_release` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `build` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL default '',
  `marker` enum('0','1') NOT NULL default '0',
  `date` date NOT NULL,
  `stories` text NOT NULL,
  `bugs` text NOT NULL,
  `leftBugs` text NOT NULL,
  `desc` mediumtext NOT NULL,
  `mailto` text,
  `notify` varchar(255),
  `status` varchar(20) NOT NULL default 'normal',
  `subStatus` varchar(30) NOT NULL default '',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `build` (`build`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_repo`;
CREATE TABLE IF NOT EXISTS `zt_repo` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `product` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `path` varchar(255) NOT NULL,
  `prefix` varchar(100) NOT NULL,
  `encoding` varchar(20) NOT NULL,
  `SCM` varchar(10) NOT NULL,
  `client` varchar(100) NOT NULL,
  `commits` mediumint(8) unsigned NOT NULL,
  `account` varchar(30) NOT NULL,
  `password` varchar(30) NOT NULL,
  `encrypt` varchar(30) NOT NULL DEFAULT 'plain',
  `acl` text NOT NULL,
  `synced` tinyint(1) NOT NULL DEFAULT '0',
  `lastSync` datetime NOT NULL,
  `desc` text NOT NULL,
  `extra` char(30) NOT NULL,
  `preMerge` enum('0','1') COLLATE 'utf8_general_ci' NOT NULL DEFAULT '0',
  `job` mediumint unsigned NOT NULL,
  `fileServerUrl` text COLLATE 'utf8_general_ci' NULL,
  `fileServerAccount` varchar(40) NOT NULL default '',
  `fileServerPassword` varchar(100) NOT NULL default '',
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_repobranch`;
CREATE TABLE IF NOT EXISTS `zt_repobranch` (
  `repo` mediumint(8) unsigned NOT NULL,
  `revision` mediumint(8) unsigned NOT NULL,
  `branch` varchar(255) NOT NULL,
  UNIQUE KEY `repo_revision_branch` (`repo`,`revision`,`branch`),
  KEY `branch` (`branch`),
  KEY `revision` (`revision`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_repofiles`;
CREATE TABLE IF NOT EXISTS `zt_repofiles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `repo` mediumint(8) unsigned NOT NULL,
  `revision` mediumint(8) unsigned NOT NULL,
  `path` varchar(255) NOT NULL,
  `parent` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `action` char(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `path` (`path`),
  KEY `parent` (`parent`),
  KEY `repo` (`repo`),
  KEY `revision` (`revision`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_repohistory`;
CREATE TABLE IF NOT EXISTS `zt_repohistory` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `repo` mediumint(9) NOT NULL,
  `revision` varchar(40) NOT NULL,
  `commit` mediumint(8) unsigned NOT NULL,
  `comment` text NOT NULL,
  `committer` varchar(100) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `repo` (`repo`),
  KEY `revision` (`revision`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_score`;
CREATE TABLE IF NOT EXISTS `zt_score` (
  `id` bigint(12) unsigned NOT NULL AUTO_INCREMENT,
  `account` varchar(30) NOT NULL,
  `module` varchar(30) NOT NULL DEFAULT '',
  `method` varchar(30) NOT NULL,
  `desc` varchar(250) NOT NULL DEFAULT '',
  `before` int(11) NOT NULL DEFAULT '0',
  `score` int(11) NOT NULL DEFAULT '0',
  `after` int(11) NOT NULL DEFAULT '0',
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `model` (`module`),
  KEY `method` (`method`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_searchdict`;
CREATE TABLE IF NOT EXISTS `zt_searchdict` (
  `key` smallint(5) unsigned NOT NULL,
  `value` char(3) NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_searchindex`;
CREATE TABLE IF NOT EXISTS `zt_searchindex` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `objectType` char(20) NOT NULL,
  `objectID` mediumint(9) NOT NULL,
  `title` text NOT NULL,
  `content` text NOT NULL,
  `addedDate` datetime NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`objectType`,`objectID`),
  KEY `addedDate` (`addedDate`),
  FULLTEXT KEY `content` (`content`),
  FULLTEXT KEY `title` (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_stage`;
CREATE TABLE IF NOT EXISTS `zt_stage` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `percent` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_stakeholder`;
CREATE TABLE IF NOT EXISTS `zt_stakeholder` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `objectID` mediumint(8) NOT NULL,
  `objectType` char(30) NOT NULL,
  `user` char(30) NOT NULL,
  `type` char(30) NOT NULL,
  `key` enum('0','1') NOT NULL,
  `from` char(30) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL,
  KEY `objectID` (`objectID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_story`;
CREATE TABLE IF NOT EXISTS `zt_story` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `parent` mediumint(9) NOT NULL default '0',
  `product` mediumint(8) unsigned NOT NULL default '0',
  `branch` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `plan` text,
  `source` varchar(20) NOT NULL,
  `sourceNote` varchar(255) NOT NULL,
  `fromBug` mediumint(8) unsigned NOT NULL default '0',
  `title` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `type` varchar(30) NOT NULL default 'story',
  `category` varchar(30) NOT NULL default 'feature',
  `pri` tinyint(3) unsigned NOT NULL default '3',
  `estimate` float unsigned NOT NULL,
  `status` enum('','changed','active','draft','closed') NOT NULL default '',
  `subStatus` varchar(30) NOT NULL default '',
  `color` char(7) NOT NULL,
  `stage` enum('','wait','planned','projected','developing','developed','testing','tested','verified','released', 'closed') NOT NULL DEFAULT 'wait',
  `stagedBy` char(30) NOT NULL,
  `mailto` text,
  `openedBy` varchar(30) NOT NULL default '',
  `openedDate` datetime NOT NULL,
  `assignedTo` varchar(30) NOT NULL default '',
  `assignedDate` datetime NOT NULL,
  `lastEditedBy` varchar(30) NOT NULL default '',
  `lastEditedDate` datetime NOT NULL,
  `reviewedBy` varchar(255) NOT NULL,
  `reviewedDate` datetime NOT NULL default '0000-00-00 00:00:00',
  `closedBy` varchar(30) NOT NULL default '',
  `closedDate` datetime NOT NULL,
  `closedReason` varchar(30) NOT NULL,
  `activatedDate` datetime NOT NULL,
  `toBug` mediumint(8) unsigned NOT NULL,
  `childStories` varchar(255) NOT NULL,
  `linkStories` varchar(255) NOT NULL,
  `duplicateStory` mediumint(8) unsigned NOT NULL,
  `version` smallint(6) NOT NULL default '1',
  `feedbackBy` varchar(100) NOT NULL,
  `notifyEmail` varchar(100) NOT NULL,
  `URChanged` enum('0','1') NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `product` (`product`),
  KEY `status` (`status`),
  KEY `assignedTo` (`assignedTo`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_storyreview`;
CREATE TABLE IF NOT EXISTS `zt_storyreview` (
  `story` mediumint(9) NOT NULL,
  `version` smallint(6) NOT NULL,
  `reviewer` varchar(30) NOT NULL,
  `result` varchar(30) NOT NULL,
  `reviewDate` datetime NOT NULL,
  UNIQUE KEY `story` (`story`,`version`,`reviewer`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_storyestimate`;
CREATE TABLE IF NOT EXISTS `zt_storyestimate` (
  `story` mediumint(9) NOT NULL,
  `round` smallint(6) NOT NULL,
  `estimate` text NOT NULL,
  `average` float NOT NULL,
  `openedBy` varchar(30) NOT NULL,
  `openedDate` datetime NOT NULL,
  UNIQUE KEY `story` (`story`,`round`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_storyspec`;
CREATE TABLE IF NOT EXISTS `zt_storyspec` (
  `story` mediumint(9) NOT NULL,
  `version` smallint(6) NOT NULL,
  `title` varchar(255) NOT NULL,
  `spec` mediumtext NOT NULL,
  `verify` mediumtext NOT NULL,
  UNIQUE KEY `story` (`story`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_storystage`;
CREATE TABLE IF NOT EXISTS `zt_storystage` (
  `story` mediumint(8) unsigned NOT NULL,
  `branch` mediumint(8) unsigned NOT NULL,
  `stage` varchar(50) NOT NULL,
  `stagedBy` char(30) NOT NULL,
  UNIQUE KEY `story_branch` (`story`,`branch`),
  KEY `story` (`story`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_suitecase`;
CREATE TABLE IF NOT EXISTS `zt_suitecase` (
  `suite` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `case` mediumint(8) unsigned NOT NULL,
  `version` smallint(5) unsigned NOT NULL,
  UNIQUE KEY `suitecase` (`suite`,`case`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_task`;
CREATE TABLE IF NOT EXISTS `zt_task` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL,
  `parent` mediumint(8) NOT NULL DEFAULT '0',
  `execution` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `design` mediumint(8) unsigned NOT NULL,
  `story` mediumint(8) unsigned NOT NULL default '0',
  `storyVersion` smallint(6) NOT NULL default '1',
  `designVersion` smallint(6) unsigned NOT NULL,
  `fromBug` mediumint(8) unsigned NOT NULL default '0',
  `fromIssue` mediumint(8) unsigned NOT NULL default '0',
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `mode` varchar(10) NOT NULL,
  `pri` tinyint(3) unsigned NOT NULL default '0',
  `estimate` float unsigned NOT NULL,
  `consumed` float unsigned NOT NULL,
  `left` float unsigned NOT NULL,
  `deadline` date NOT NULL,
  `status` enum('wait','doing','done','pause','cancel','closed') NOT NULL default 'wait',
  `subStatus` varchar(30) NOT NULL default '',
  `color` char(7) NOT NULL,
  `mailto` text,
  `desc` mediumtext NOT NULL,
  `version` smallint(6) NOT NULL,
  `openedBy` varchar(30) NOT NULL,
  `openedDate` datetime NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `estStarted` date NOT NULL,
  `realStarted` datetime NOT NULL,
  `finishedBy` varchar(30) NOT NULL,
  `finishedDate` datetime NOT NULL,
  `finishedList` text NOT NULL,
  `canceledBy` varchar(30) NOT NULL,
  `canceledDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL,
  `closedDate` datetime NOT NULL,
  `planDuration` int(11) NOT NULL,
  `realDuration` int(11) NOT NULL,
  `closedReason` varchar(30) NOT NULL,
  `lastEditedBy` varchar(30) NOT NULL,
  `lastEditedDate` datetime NOT NULL,
  `activatedDate` datetime NOT NULL,
  `repo` mediumint(8) unsigned NOT NULL,
  `mr` mediumint(8) unsigned NOT NULL,
  `entry` varchar(255) NOT NULL,
  `lines` varchar(10) NOT NULL,
  `v1` varchar(40) NOT NULL,
  `v2` varchar(40) NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  KEY `execution` (`execution`),
  KEY `story` (`story`),
  KEY `parent` (`parent`),
  KEY `assignedTo` (`assignedTo`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_taskestimate`;
CREATE TABLE IF NOT EXISTS `zt_taskestimate` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `task` mediumint(8) unsigned NOT NULL default '0',
  `date` date NOT NULL,
  `left` float unsigned NOT NULL default '0',
  `consumed` float unsigned NOT NULL,
  `account` char(30) NOT NULL default '',
  `work` text,
  PRIMARY KEY (`id`),
  KEY `task` (`task`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_taskspec`;
CREATE TABLE IF NOT EXISTS `zt_taskspec` (
  `task` mediumint(8) NOT NULL,
  `version` smallint(6) NOT NULL,
  `name` varchar(255) NOT NULL,
  `estStarted` date NOT NULL,
  `deadline` date NOT NULL,
  UNIQUE KEY `task` (`task`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_team`;
CREATE TABLE IF NOT EXISTS `zt_team` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `root` mediumint(8) unsigned NOT NULL default '0',
  `type` enum('project','task','execution') NOT NULL DEFAULT 'project',
  `account` char(30) NOT NULL default '',
  `role` char(30) NOT NULL default '',
  `limited` char(8) NOT NULL default 'no',
  `join` date NOT NULL default '0000-00-00',
  `days` smallint(5) unsigned NOT NULL,
  `hours` float(3,1) unsigned NOT NULL default '0',
  `estimate` DECIMAL(12,2) UNSIGNED NOT NULL DEFAULT '0',
  `consumed` DECIMAL(12,2) UNSIGNED NOT NULL DEFAULT '0',
  `left` DECIMAL(12,2) UNSIGNED NOT NULL DEFAULT '0',
  `order` TINYINT(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `team` (`root`,`type`,`account`)
  ) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testreport`;
CREATE TABLE IF NOT EXISTS `zt_testreport` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `tasks` varchar(255) NOT NULL,
  `builds` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `owner` char(30) NOT NULL,
  `members` text NOT NULL,
  `stories` text NOT NULL,
  `bugs` text NOT NULL,
  `cases` text NOT NULL,
  `report` text NOT NULL,
  `objectType` varchar(20) NOT NULL,
  `objectID` mediumint(8) unsigned NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testresult`;
CREATE TABLE IF NOT EXISTS `zt_testresult` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `run` mediumint(8) unsigned NOT NULL,
  `case` mediumint(8) unsigned NOT NULL,
  `version` smallint(5) unsigned NOT NULL,
  `job` mediumint(8) unsigned NOT NULL,
  `compile` mediumint(8) unsigned NOT NULL,
  `caseResult` char(30) NOT NULL,
  `stepResults` text NOT NULL,
  `lastRunner` varchar(30) NOT NULL,
  `date` datetime NOT NULL,
  `duration` float NOT NULL,
  `xml` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `case` (`case`),
  KEY `version` (`version`),
  KEY `run` (`run`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testrun`;
CREATE TABLE IF NOT EXISTS `zt_testrun` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `task` mediumint(8) unsigned NOT NULL default '0',
  `case` mediumint(8) unsigned NOT NULL default '0',
  `version` tinyint(3) unsigned NOT NULL default '0',
  `assignedTo` char(30) NOT NULL default '',
  `lastRunner` varchar(30) NOT NULL,
  `lastRunDate` datetime NOT NULL,
  `lastRunResult` char(30) NOT NULL,
  `status` char(30) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `task` (`task`,`case`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testsuite`;
CREATE TABLE IF NOT EXISTS `zt_testsuite` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `desc` mediumtext NOT NULL,
  `type` varchar(20) NOT NULL,
  `addedBy` char(30) NOT NULL,
  `addedDate` datetime NOT NULL,
  `lastEditedBy` char(30) NOT NULL,
  `lastEditedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product` (`product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testtask`;
CREATE TABLE IF NOT EXISTS `zt_testtask` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `name` char(90) NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL default '0',
  `build` char(30) NOT NULL,
  `type` varchar(255) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL,
  `pri` tinyint(3) unsigned NOT NULL default '0',
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `realFinishedDate` datetime NOT NULL,
  `mailto` text,
  `desc` mediumtext NOT NULL,
  `report` text NOT NULL,
  `status` enum('blocked','doing','wait','done') NOT NULL DEFAULT 'wait',
  `testreport` mediumint(8) unsigned NOT NULL,
  `auto` varchar(10) NOT NULL DEFAULT 'no',
  `subStatus` varchar(30) NOT NULL default '',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `build` (`build`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_todo`;
CREATE TABLE IF NOT EXISTS `zt_todo` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `date` date NOT NULL,
  `begin` smallint(4) unsigned zerofill NOT NULL,
  `end` smallint(4) unsigned zerofill NOT NULL,
  `type` char(10) NOT NULL,
  `cycle` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `idvalue` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `pri` tinyint(3) unsigned NOT NULL,
  `name` char(150) NOT NULL,
  `desc` mediumtext NOT NULL,
  `status` enum('wait','doing','done','closed') NOT NULL DEFAULT 'wait',
  `private` tinyint(1) NOT NULL,
  `config` varchar(255) NOT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime NOT NULL,
  `finishedBy` varchar(30) NOT NULL DEFAULT '',
  `finishedDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `assignedTo` (`assignedTo`),
  KEY `finishedBy` (`finishedBy`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_user`;
CREATE TABLE IF NOT EXISTS `zt_user` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `company` mediumint unsigned NOT NULL,
  `type` char(30) NOT NULL default 'inside',
  `dept` mediumint(8) unsigned NOT NULL default '0',
  `account` char(30) NOT NULL default '',
  `password` char(32) NOT NULL default '',
  `role` char(10) NOT NULL default '',
  `realname` varchar(100) NOT NULL default '',
  `nickname` char(60) NOT NULL default '',
  `commiter` varchar(100) NOT NULL,
  `avatar` text NOT NULL,
  `birthday` date NOT NULL default '0000-00-00',
  `gender` enum('f','m') NOT NULL default 'f',
  `email` char(90) NOT NULL default '',
  `skype` char(90) NOT NULL default '',
  `qq` char(20) NOT NULL default '',
  `mobile` char(11) NOT NULL default '',
  `phone` char(20) NOT NULL default '',
  `weixin` varchar(90) NOT NULL default '',
  `dingding` varchar(90) NOT NULL default '',
  `slack` varchar(90) NOT NULL default '',
  `whatsapp` varchar(90) NOT NULL default '',
  `address` char(120) NOT NULL default '',
  `zipcode` char(10) NOT NULL default '',
  `nature` text NOT NULL,
  `analysis` text NOT NULL,
  `strategy` text NOT NULL,
  `join` date NOT NULL default '0000-00-00',
  `visits` mediumint(8) unsigned NOT NULL default '0',
  `visions` varchar(20) NOT NULL DEFAULT 'rnd,lite',
  `ip` char(15) NOT NULL default '',
  `last` int(10) unsigned NOT NULL default '0',
  `fails` tinyint(5) NOT NULL default '0',
  `locked` datetime NOT NULL default '0000-00-00 00:00:00',
  `ranzhi` char(30) NOT NULL default '',
  `score` INT(11) NOT NULL DEFAULT '0',
  `scoreLevel` INT(11) NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `account` (`account`),
  KEY `dept` (`dept`),
  KEY `email` (`email`),
  KEY `commiter` (`commiter`),
  KEY `deleted` (`deleted`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_usercontact`;
CREATE TABLE IF NOT EXISTS `zt_usercontact` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `account` char(30) NOT NULL,
  `listName` varchar(60) NOT NULL,
  `userList` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_usergroup`;
CREATE TABLE IF NOT EXISTS `zt_usergroup` (
  `account` char(30) NOT NULL default '',
  `group` mediumint(8) unsigned NOT NULL default '0',
  `project` text NOT NULL,
  UNIQUE KEY `account` (`account`,`group`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_userquery`;
CREATE TABLE IF NOT EXISTS `zt_userquery` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `account` char(30) NOT NULL,
  `module` varchar(30) NOT NULL,
  `title` varchar(90) NOT NULL,
  `form` text NOT NULL,
  `sql` text NOT NULL,
  `shortcut` enum('0','1') NOT NULL DEFAULT '0',
  `common` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY  (`id`),
  KEY `account` (`account`),
  KEY `module` (`module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_usertpl`;
CREATE TABLE IF NOT EXISTS `zt_usertpl` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `account` char(30) NOT NULL,
  `type` char(30) NOT NULL,
  `title` varchar(150) NOT NULL,
  `content` text NOT NULL,
  `public` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY  (`id`),
  KEY `account` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_userview`;
CREATE TABLE IF NOT EXISTS `zt_userview` (
  `account` char(30) NOT NULL,
  `programs` mediumtext NOT NULL,
  `products` mediumtext NOT NULL,
  `projects` mediumtext NOT NULL,
  `sprints` mediumtext NOT NULL,
  UNIQUE KEY `account` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_weeklyreport`;
CREATE TABLE IF NOT EXISTS `zt_weeklyreport`(
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `weekStart` date NOT NULL,
  `pv` float(9,2) NOT NULL,
  `ev` float(9,2) NOT NULL,
  `ac` float(9,2) NOT NULL,
  `sv` float(9,2) NOT NULL,
  `cv` float(9,2) NOT NULL,
  `staff` smallint(5) unsigned NOT NULL,
  `progress` varchar(255) NOT NULL,
  `workload` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `week` (`project`,`weekStart`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_webhook`;
CREATE TABLE IF NOT EXISTS `zt_webhook` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(15) NOT NULL DEFAULT 'default',
  `name` varchar(50) NOT NULL,
  `url` varchar(255) NOT NULL,
  `domain` varchar(255) NOT NULL,
  `secret` varchar(255) NOT NULL,
  `contentType` varchar(30) NOT NULL DEFAULT 'application/json',
  `sendType` enum('sync','async') NOT NULL DEFAULT 'sync',
  `products` text NOT NULL,
  `executions` text NOT NULL,
  `params` varchar(100) NOT NULL,
  `actions` text NOT NULL,
  `desc` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `zt_cron` (`m`, `h`, `dom`, `mon`, `dow`, `command`, `remark`, `type`, `buildin`, `status`, `lastTime`) VALUES
('*',    '*',    '*',    '*',    '*',    '', '监控定时任务', 'zentao', 1, 'normal',   '0000-00-00 00:00:00'),
('30',   '23',   '*',    '*',    '*',    'moduleName=execution&methodName=computeburn', '更新燃尽图',      'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('0',    '8',    '*',    '*',    '*',    'moduleName=report&methodName=remind',       '每日任务提醒',    'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=svn&methodName=run',             '同步SVN',         'zentao', 1, 'stop',   '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=git&methodName=run',             '同步GIT',         'zentao', 1, 'stop',   '0000-00-00 00:00:00'),
('30',   '0',    '*',    '*',    '*',    'moduleName=backup&methodName=backup',       '备份数据和附件',  'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=mail&methodName=asyncSend',      '异步发信',        'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=webhook&methodName=asyncSend',   '异步发送Webhook', 'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=admin&methodName=deleteLog',     '删除过期日志',    'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('1',    '1',    '*',    '*',    '*',    'moduleName=todo&methodName=createCycle',    '生成周期性待办',  'zentao', 1, 'normal', '0000-00-00 00:00:00'),
('1',    '0',    '*',    '*',    '*',    'moduleName=ci&methodName=initQueue', '创建周期性任务', 'zentao', 1, 'normal',   '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=ci&methodName=checkCompileStatus', '同步DevOps构建任务状态', 'zentao', 1, 'normal',   '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=ci&methodName=exec', '执行DevOps构建任务', 'zentao', 1, 'normal',   '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=mr&methodName=syncMR', '定时同步GitLab合并数据到禅道数据库', 'zentao', 1, 'normal', '0000-00-00 00:00:00');

INSERT INTO `zt_group` (`id`, `vision`, `name`, `role`, `desc`) VALUES
(1, 'rnd', 'ADMIN', 'admin', 'for administrator'),
(2, 'rnd', 'DEV', 'dev', 'for developers.'),
(3, 'rnd', 'QA', 'qa', 'for testers.'),
(4, 'rnd', 'PM', 'pm', 'for project managers.'),
(5, 'rnd', 'PO', 'po', 'for product owners.'),
(6, 'rnd', 'TD', 'td', 'for technical director.'),
(7, 'rnd', 'PD', 'pd', 'for product director.'),
(8, 'rnd', 'QD', 'qd', 'for quality director.'),
(9, 'rnd', 'TOP', 'top', 'for top manager.'),
(10, 'rnd', 'OTHERS', 'others', 'for others.'),
(11, 'rnd', 'guest', 'guest', 'For guest'),
(12, 'rnd', 'LIMITED', 'limited', 'For limited user'),
(13, 'rnd', 'PROJECTADMIN', 'projectAdmin', 'Project Admins manage project privileges'),
(14, 'lite', 'LITEADMIN', 'liteAdmin', 'for lite administrator'),
(15, 'lite', 'LITEPROJECT', 'liteProject', 'for lite project managers.'),
(16, 'lite', 'LITETEAM', 'liteTeam', 'for lite team.');

INSERT INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1,'action','comment'),
(1,'action','editComment'),
(1,'action','hideAll'),
(1,'action','hideOne'),
(1,'action','trash'),
(1,'action','undelete'),
(1,'admin','checkDB'),
(1,'admin','checkWeak'),
(1,'admin','index'),
(1,'admin','register'),
(1,'admin','safe'),
(1,'admin','sso'),
(1,'admin','ztCompany'),
(1,'api','debug'),
(1,'api','getModel'),
(1,'api','sql'),
(1,'automation','browse'),
(1,'backup','backup'),
(1,'backup','change'),
(1,'backup','delete'),
(1,'backup','index'),
(1,'backup','restore'),
(1,'backup','rmPHPHeader'),
(1,'backup','setting'),
(1,'branch','delete'),
(1,'branch','manage'),
(1,'branch','sort'),
(1,'bug','activate'),
(1,'bug','assignTo'),
(1,'bug','batchActivate'),
(1,'bug','batchAssignTo'),
(1,'bug','batchChangeBranch'),
(1,'bug','batchChangeModule'),
(1,'bug','batchClose'),
(1,'bug','batchConfirm'),
(1,'bug','batchCreate'),
(1,'bug','batchEdit'),
(1,'bug','batchResolve'),
(1,'bug','browse'),
(1,'bug','close'),
(1,'bug','confirmBug'),
(1,'bug','confirmStoryChange'),
(1,'bug','create'),
(1,'bug','delete'),
(1,'bug','edit'),
(1,'bug','export'),
(1,'bug','index'),
(1,'bug','linkBugs'),
(1,'bug','report'),
(1,'bug','resolve'),
(1,'bug','view'),
(1,'build','batchUnlinkBug'),
(1,'build','batchUnlinkStory'),
(1,'build','create'),
(1,'build','delete'),
(1,'build','edit'),
(1,'build','linkBug'),
(1,'build','linkStory'),
(1,'build','unlinkBug'),
(1,'build','unlinkStory'),
(1,'build','view'),
(1,'caselib','batchCreateCase'),
(1,'caselib','browse'),
(1,'caselib','create'),
(1,'caselib','createCase'),
(1,'caselib','delete'),
(1,'caselib','edit'),
(1,'caselib','exportTemplet'),
(1,'caselib','import'),
(1,'caselib','index'),
(1,'caselib','showImport'),
(1,'caselib','view'),
(1,'ci','checkCompileStatus'),
(1,'ci','commitResult'),
(1,'company','browse'),
(1,'company','dynamic'),
(1,'company','edit'),
(1,'company','index'),
(1,'company','view'),
(1,'compile','browse'),
(1,'compile','logs'),
(1,'convert','checkBugFree'),
(1,'convert','checkConfig'),
(1,'convert','checkRedmine'),
(1,'convert','convertBugFree'),
(1,'convert','convertRedmine'),
(1,'convert','execute'),
(1,'convert','index'),
(1,'convert','selectSource'),
(1,'convert','setBugfree'),
(1,'convert','setConfig'),
(1,'convert','setRedmine'),
(1,'cron','create'),
(1,'cron','delete'),
(1,'cron','edit'),
(1,'cron','index'),
(1,'cron','openProcess'),
(1,'cron','toggle'),
(1,'cron','turnon'),
(1,'custom','browseStoryConcept'),
(1,'custom','deleteStoryConcept'),
(1,'custom','editStoryConcept'),
(1,'custom','execution'),
(1,'custom','flow'),
(1,'custom','index'),
(1,'custom','product'),
(1,'custom','project'),
(1,'custom','restore'),
(1,'custom','set'),
(1,'custom','setDefaultConcept'),
(1,'custom','setPublic'),
(1,'custom','setStoryConcept'),
(1,'custom','timezone'),
(1,'custom','working'),
(1,'datatable','setGlobal'),
(1,'dept','browse'),
(1,'dept','delete'),
(1,'dept','edit'),
(1,'dept','manageChild'),
(1,'dept','updateOrder'),
(1,'dev','api'),
(1,'dev','db'),
(1,'dev','editor'),
(1,'dev','translate'),
(1,'doc','allLibs'),
(1,'doc','browse'),
(1,'doc','collect'),
(1,'doc','create'),
(1,'doc','createLib'),
(1,'doc','delete'),
(1,'doc','deleteFile'),
(1,'doc','deleteLib'),
(1,'doc','edit'),
(1,'doc','editLib'),
(1,'doc','index'),
(1,'doc','objectLibs'),
(1,'doc','showFiles'),
(1,'doc','tableContents'),
(1,'doc','view'),
(1,'execution','activate'),
(1,'execution','addWhitelist'),
(1,'execution','all'),
(1,'execution','batchedit'),
(1,'execution','batchUnlinkStory'),
(1,'execution','browse'),
(1,'execution','bug'),
(1,'execution','build'),
(1,'execution','burn'),
(1,'execution','burnData'),
(1,'execution','close'),
(1,'execution','computeBurn'),
(1,'execution','create'),
(1,'execution','delete'),
(1,'execution','doc'),
(1,'execution','dynamic'),
(1,'execution','edit'),
(1,'execution','executionkanban'),
(1,'execution','export'),
(1,'execution','fixFirst'),
(1,'execution','grouptask'),
(1,'execution','importBug'),
(1,'execution','importplanstories'),
(1,'execution','importtask'),
(1,'execution','index'),
(1,'execution','kanban'),
(1,'execution','linkStory'),
(1,'execution','manageMembers'),
(1,'execution','manageProducts'),
(1,'execution','printKanban'),
(1,'execution','putoff'),
(1,'execution','start'),
(1,'execution','story'),
(1,'execution','storyEstimate'),
(1,'execution','storyKanban'),
(1,'execution','storySort'),
(1,'execution','suspend'),
(1,'execution','task'),
(1,'execution','team'),
(1,'execution','testcase'),
(1,'execution','testreport'),
(1,'execution','testtask'),
(1,'execution','tree'),
(1,'execution','treeStory'),
(1,'execution','treeTask'),
(1,'execution','unbindWhitelist'),
(1,'execution','unlinkMember'),
(1,'execution','unlinkStory'),
(1,'execution','updateOrder'),
(1,'execution','view'),
(1,'execution','whitelist'),
(1,'extension','activate'),
(1,'extension','browse'),
(1,'extension','deactivate'),
(1,'extension','erase'),
(1,'extension','install'),
(1,'extension','obtain'),
(1,'extension','structure'),
(1,'extension','uninstall'),
(1,'extension','upgrade'),
(1,'extension','upload'),
(1,'file','delete'),
(1,'file','download'),
(1,'file','edit'),
(1,'file','setPublic'),
(1,'file','uploadImages'),
(1,'git','apiSync'),
(1,'git','cat'),
(1,'git','diff'),
(1,'gitlab','bindProduct'),
(1,'gitlab','bindUser'),
(1,'gitlab','browse'),
(1,'gitlab','create'),
(1,'gitlab','delete'),
(1,'gitlab','edit'),
(1,'gitlab','importIssue'),
(1,'group','browse'),
(1,'group','copy'),
(1,'group','create'),
(1,'group','delete'),
(1,'group','edit'),
(1,'group','manageMember'),
(1,'group','managePriv'),
(1,'group','manageProjectAdmin'),
(1,'group','manageView'),
(1,'index','index'),
(1,'jenkins','browse'),
(1,'jenkins','create'),
(1,'jenkins','delete'),
(1,'jenkins','edit'),
(1,'job','browse'),
(1,'job','create'),
(1,'job','delete'),
(1,'job','edit'),
(1,'job','exec'),
(1,'job','view'),
(1,'mail','batchDelete'),
(1,'mail','browse'),
(1,'mail','delete'),
(1,'mail','detect'),
(1,'mail','edit'),
(1,'mail','index'),
(1,'mail','resend'),
(1,'mail','reset'),
(1,'mail','save'),
(1,'mail','sendCloud'),
(1,'mail','sendcloudUser'),
(1,'mail','test'),
(1,'mail','ztCloud'),
(1,'message','browser'),
(1,'message','index'),
(1,'message','setting'),
(1,'misc','ping'),
(1,'my','bug'),
(1,'my','calendar'),
(1,'my','changePassword'),
(1,'my','contribute'),
(1,'my','deleteContacts'),
(1,'my','doc'),
(1,'my','dynamic'),
(1,'my','editProfile'),
(1,'my','execution'),
(1,'my','index'),
(1,'my','manageContacts'),
(1,'my','preference'),
(1,'my','profile'),
(1,'my','project'),
(1,'my','score'),
(1,'my','story'),
(1,'my','task'),
(1,'my','team'),
(1,'my','testcase'),
(1,'my','testtask'),
(1,'my','todo'),
(1,'my','unbind'),
(1,'my','uploadAvatar'),
(1,'my','work'),
(1,'personnel','accessible'),
(1,'personnel','addWhitelist'),
(1,'personnel','invest'),
(1,'personnel','unbindWhitelist'),
(1,'personnel','whitelist'),
(1,'product','addWhitelist'),
(1,'product','all'),
(1,'product','batchEdit'),
(1,'product','browse'),
(1,'product','build'),
(1,'product','close'),
(1,'product','create'),
(1,'product','dashboard'),
(1,'product','delete'),
(1,'product','doc'),
(1,'product','dynamic'),
(1,'product','edit'),
(1,'product','export'),
(1,'product','index'),
(1,'product','kanban'),
(1,'product','manageLine'),
(1,'product','project'),
(1,'product','roadmap'),
(1,'product','unbindWhitelist'),
(1,'product','updateOrder'),
(1,'product','view'),
(1,'product','whitelist'),
(1,'productplan','batchEdit'),
(1,'productplan','batchUnlinkBug'),
(1,'productplan','batchUnlinkStory'),
(1,'productplan','browse'),
(1,'productplan','create'),
(1,'productplan','delete'),
(1,'productplan','edit'),
(1,'productplan','linkBug'),
(1,'productplan','linkStory'),
(1,'productplan','unlinkBug'),
(1,'productplan','unlinkStory'),
(1,'productplan','view'),
(1,'program','index'),
(1,'program','activate'),
(1,'program','batchUnlinkStakeholders'),
(1,'program','browse'),
(1,'program','close'),
(1,'program','create'),
(1,'program','kanban'),
(1,'program','createStakeholder'),
(1,'program','delete'),
(1,'program','edit'),
(1,'program','export'),
(1,'program','product'),
(1,'program','project'),
(1,'program','stakeholder'),
(1,'program','start'),
(1,'program','suspend'),
(1,'program','unbindWhitelist'),
(1,'program','unlinkStakeholder'),
(1,'program','updateOrder'),
(1,'program','view'),
(1,'project','activate'),
(1,'project','addWhitelist'),
(1,'project','batchEdit'),
(1,'project','browse'),
(1,'project','bug'),
(1,'project','build'),
(1,'project','close'),
(1,'project','copyGroup'),
(1,'project','create'),
(1,'project','createGroup'),
(1,'project','createGuide'),
(1,'project','delete'),
(1,'project','dynamic'),
(1,'project','edit'),
(1,'project','editGroup'),
(1,'project','execution'),
(1,'project','export'),
(1,'project','group'),
(1,'project','index'),
(1,'project','kanban'),
(1,'project','createStakeholder'),
(1,'project','manageGroupMember'),
(1,'project','manageMembers'),
(1,'project','managePriv'),
(1,'project','manageProducts'),
(1,'project','manageView'),
(1,'project','programTitle'),
(1,'project','qa'),
(1,'project','start'),
(1,'project','suspend'),
(1,'project','team'),
(1,'project','testcase'),
(1,'project','testreport'),
(1,'project','testtask'),
(1,'project','unbindWhitelist'),
(1,'project','unlinkMember'),
(1,'project','updateOrder'),
(1,'project','view'),
(1,'project','whitelist'),
(1,'projectbuild','browse'),
(1,'projectrelease','batchUnlinkBug'),
(1,'projectrelease','batchUnlinkStory'),
(1,'projectrelease','browse'),
(1,'projectrelease','changeStatus'),
(1,'projectrelease','create'),
(1,'projectrelease','delete'),
(1,'projectrelease','edit'),
(1,'projectrelease','export'),
(1,'projectrelease','linkBug'),
(1,'projectrelease','linkStory'),
(1,'projectrelease','unlinkBug'),
(1,'projectrelease','unlinkStory'),
(1,'projectrelease','view'),
(1,'projectstory','batchUnlinkStory'),
(1,'projectstory','importplanstories'),
(1,'projectstory','linkStory'),
(1,'projectstory','story'),
(1,'projectstory','track'),
(1,'projectstory','unlinkStory'),
(1,'projectstory','view'),
(1,'qa','index'),
(1,'release','batchUnlinkBug'),
(1,'release','batchUnlinkStory'),
(1,'release','browse'),
(1,'release','changeStatus'),
(1,'release','create'),
(1,'release','delete'),
(1,'release','edit'),
(1,'release','export'),
(1,'release','linkBug'),
(1,'release','linkStory'),
(1,'release','unlinkBug'),
(1,'release','unlinkStory'),
(1,'release','view'),
(1,'repo','blame'),
(1,'repo','browse'),
(1,'repo','create'),
(1,'repo','delete'),
(1,'repo','diff'),
(1,'repo','download'),
(1,'repo','edit'),
(1,'repo','log'),
(1,'repo','maintain'),
(1,'repo','revision'),
(1,'repo','setRules'),
(1,'repo','showSyncCommit'),
(1,'repo','view'),
(1,'report','bugAssign'),
(1,'report','bugCreate'),
(1,'report','index'),
(1,'report','productSummary'),
(1,'report','projectDeviation'),
(1,'report','workload'),
(1,'search','buildForm'),
(1,'search','buildIndex'),
(1,'search','buildQuery'),
(1,'search','deleteQuery'),
(1,'search','index'),
(1,'search','saveQuery'),
(1,'search','select'),
(1,'stakeholder','batchCreate'),
(1,'stakeholder','browse'),
(1,'stakeholder','communicate'),
(1,'stakeholder','create'),
(1,'stakeholder','createExpect'),
(1,'stakeholder','delete'),
(1,'stakeholder','deleteExpect'),
(1,'stakeholder','edit'),
(1,'stakeholder','editExpect'),
(1,'stakeholder','expect'),
(1,'stakeholder','expectation'),
(1,'stakeholder','issue'),
(1,'stakeholder','plan'),
(1,'stakeholder','userIssue'),
(1,'stakeholder','view'),
(1,'stakeholder','viewExpect'),
(1,'stakeholder','viewIssue'),
(1,'story','activate'),
(1,'story','assignTo'),
(1,'story','batchAssignTo'),
(1,'story','batchChangeBranch'),
(1,'story','batchChangeModule'),
(1,'story','batchChangePlan'),
(1,'story','batchChangeStage'),
(1,'story','batchClose'),
(1,'story','batchCreate'),
(1,'story','batchEdit'),
(1,'story','batchReview'),
(1,'story','batchToTask'),
(1,'story','bugs'),
(1,'story','cases'),
(1,'story','change'),
(1,'story','close'),
(1,'story','create'),
(1,'story','delete'),
(1,'story','edit'),
(1,'story','export'),
(1,'story','linkStory'),
(1,'story','processStoryChange'),
(1,'story','recall'),
(1,'story','report'),
(1,'story','review'),
(1,'story','tasks'),
(1,'story','track'),
(1,'story','view'),
(1,'story','zeroCase'),
(1,'svn','apiSync'),
(1,'svn','cat'),
(1,'svn','diff'),
(1,'task','activate'),
(1,'task','assignTo'),
(1,'task','batchAssignTo'),
(1,'task','batchCancel'),
(1,'task','batchChangeModule'),
(1,'task','batchClose'),
(1,'task','batchCreate'),
(1,'task','batchEdit'),
(1,'task','cancel'),
(1,'task','close'),
(1,'task','confirmStoryChange'),
(1,'task','create'),
(1,'task','delete'),
(1,'task','deleteEstimate'),
(1,'task','edit'),
(1,'task','editEstimate'),
(1,'task','export'),
(1,'task','finish'),
(1,'task','pause'),
(1,'task','recordEstimate'),
(1,'task','report'),
(1,'task','restart'),
(1,'task','start'),
(1,'task','view'),
(1,'testcase','batchCaseTypeChange'),
(1,'testcase','batchChangeBranch'),
(1,'testcase','batchChangeModule'),
(1,'testcase','batchConfirmStoryChange'),
(1,'testcase','batchCreate'),
(1,'testcase','batchDelete'),
(1,'testcase','batchEdit'),
(1,'testcase','batchReview'),
(1,'testcase','browse'),
(1,'testcase','bugs'),
(1,'testcase','confirmChange'),
(1,'testcase','confirmLibcaseChange'),
(1,'testcase','confirmStoryChange'),
(1,'testcase','create'),
(1,'testcase','createBug'),
(1,'testcase','delete'),
(1,'testcase','edit'),
(1,'testcase','export'),
(1,'testcase','exportTemplet'),
(1,'testcase','groupCase'),
(1,'testcase','ignoreLibcaseChange'),
(1,'testcase','import'),
(1,'testcase','importFromLib'),
(1,'testcase','index'),
(1,'testcase','linkCases'),
(1,'testcase','review'),
(1,'testcase','showImport'),
(1,'testcase','view'),
(1,'testreport','browse'),
(1,'testreport','create'),
(1,'testreport','delete'),
(1,'testreport','edit'),
(1,'testreport','view'),
(1,'testsuite','batchUnlinkCases'),
(1,'testsuite','browse'),
(1,'testsuite','create'),
(1,'testsuite','delete'),
(1,'testsuite','edit'),
(1,'testsuite','index'),
(1,'testsuite','linkCase'),
(1,'testsuite','unlinkCase'),
(1,'testsuite','view'),
(1,'testtask','activate'),
(1,'testtask','batchAssign'),
(1,'testtask','batchRun'),
(1,'testtask','batchUnlinkCases'),
(1,'testtask','block'),
(1,'testtask','browse'),
(1,'testtask','browseUnits'),
(1,'testtask','cases'),
(1,'testtask','close'),
(1,'testtask','create'),
(1,'testtask','delete'),
(1,'testtask','edit'),
(1,'testtask','groupCase'),
(1,'testtask','index'),
(1,'testtask','importUnitResult'),
(1,'testtask','linkcase'),
(1,'testtask','report'),
(1,'testtask','results'),
(1,'testtask','runcase'),
(1,'testtask','start'),
(1,'testtask','unitCases'),
(1,'testtask','unlinkcase'),
(1,'testtask','view'),
(1,'todo','activate'),
(1,'todo','assignTo'),
(1,'todo','batchClose'),
(1,'todo','batchCreate'),
(1,'todo','batchEdit'),
(1,'todo','batchFinish'),
(1,'todo','close'),
(1,'todo','create'),
(1,'todo','createcycle'),
(1,'todo','delete'),
(1,'todo','edit'),
(1,'todo','export'),
(1,'todo','finish'),
(1,'todo','import2Today'),
(1,'todo','start'),
(1,'todo','view'),
(1,'tree','browse'),
(1,'tree','browseTask'),
(1,'tree','delete'),
(1,'tree','edit'),
(1,'tree','fix'),
(1,'tree','manageChild'),
(1,'tree','updateOrder'),
(1,'user','batchCreate'),
(1,'user','batchEdit'),
(1,'user','bug'),
(1,'user','create'),
(1,'user','cropAvatar'),
(1,'user','delete'),
(1,'user','dynamic'),
(1,'user','edit'),
(1,'user','execution'),
(1,'user','issue'),
(1,'user','profile'),
(1,'user','risk'),
(1,'user','setPublicTemplate'),
(1,'user','story'),
(1,'user','task'),
(1,'user','testCase'),
(1,'user','testTask'),
(1,'user','todo'),
(1,'user','unbind'),
(1,'user','unlock'),
(1,'user','view'),
(1,'webhook','bind'),
(1,'webhook','browse'),
(1,'webhook','chooseDept'),
(1,'webhook','create'),
(1,'webhook','delete'),
(1,'webhook','edit'),
(1,'webhook','log'),
(2,'action','comment'),
(2,'action','editComment'),
(2,'action','trash'),
(2,'action','undelete'),
(2,'admin','checkWeak'),
(2,'admin','index'),
(2,'admin','safe'),
(2,'api','debug'),
(2,'automation','browse'),
(2,'bug','activate'),
(2,'bug','assignTo'),
(2,'bug','batchActivate'),
(2,'bug','batchAssignTo'),
(2,'bug','batchChangeBranch'),
(2,'bug','batchChangeModule'),
(2,'bug','batchClose'),
(2,'bug','batchConfirm'),
(2,'bug','batchCreate'),
(2,'bug','batchEdit'),
(2,'bug','batchResolve'),
(2,'bug','browse'),
(2,'bug','close'),
(2,'bug','confirmBug'),
(2,'bug','confirmStoryChange'),
(2,'bug','create'),
(2,'bug','delete'),
(2,'bug','edit'),
(2,'bug','export'),
(2,'bug','index'),
(2,'bug','linkBugs'),
(2,'bug','report'),
(2,'bug','resolve'),
(2,'bug','view'),
(2,'build','batchUnlinkBug'),
(2,'build','batchUnlinkStory'),
(2,'build','create'),
(2,'build','delete'),
(2,'build','edit'),
(2,'build','linkBug'),
(2,'build','linkStory'),
(2,'build','unlinkBug'),
(2,'build','unlinkStory'),
(2,'build','view'),
(2,'caselib','browse'),
(2,'caselib','index'),
(2,'caselib','view'),
(2,'company','browse'),
(2,'company','dynamic'),
(2,'company','edit'),
(2,'company','index'),
(2,'company','view'),
(2,'custom','execution'),
(2,'custom','flow'),
(2,'custom','index'),
(2,'custom','product'),
(2,'custom','restore'),
(2,'custom','set'),
(2,'custom','setPublic'),
(2,'datatable','setGlobal'),
(2,'dept','browse'),
(2,'dept','delete'),
(2,'dept','edit'),
(2,'dept','manageChild'),
(2,'dept','updateOrder'),
(2,'dev','api'),
(2,'dev','db'),
(2,'dev','editor'),
(2,'doc','allLibs'),
(2,'doc','browse'),
(2,'doc','collect'),
(2,'doc','create'),
(2,'doc','createLib'),
(2,'doc','delete'),
(2,'doc','deleteFile'),
(2,'doc','deleteLib'),
(2,'doc','edit'),
(2,'doc','editLib'),
(2,'doc','index'),
(2,'doc','objectLibs'),
(2,'doc','showFiles'),
(2,'doc','tableContents'),
(2,'doc','view'),
(2,'execution','all'),
(2,'execution','browse'),
(2,'execution','bug'),
(2,'execution','build'),
(2,'execution','burn'),
(2,'execution','burnData'),
(2,'execution','computeBurn'),
(2,'execution','doc'),
(2,'execution','dynamic'),
(2,'execution','executionkanban'),
(2,'execution','fixFirst'),
(2,'execution','grouptask'),
(2,'execution','kanban'),
(2,'execution','manageMembers'),
(2,'execution','printKanban'),
(2,'execution','story'),
(2,'execution','storyEstimate'),
(2,'execution','storyKanban'),
(2,'execution','task'),
(2,'execution','team'),
(2,'execution','testcase'),
(2,'execution','testreport'),
(2,'execution','testtask'),
(2,'execution','tree'),
(2,'execution','treeStory'),
(2,'execution','treeTask'),
(2,'execution','view'),
(2,'execution','whitelist'),
(2,'file','delete'),
(2,'file','download'),
(2,'file','edit'),
(2,'file','setPublic'),
(2,'file','uploadImages'),
(2,'git','apiSync'),
(2,'git','cat'),
(2,'git','diff'),
(2,'group','browse'),
(2,'index','index'),
(2,'message','browser'),
(2,'message','index'),
(2,'message','setting'),
(2,'misc','ping'),
(2,'my','bug'),
(2,'my','calendar'),
(2,'my','changePassword'),
(2,'my','contribute'),
(2,'my','deleteContacts'),
(2,'my','doc'),
(2,'my','dynamic'),
(2,'my','editProfile'),
(2,'my','execution'),
(2,'my','index'),
(2,'my','manageContacts'),
(2,'my','preference'),
(2,'my','profile'),
(2,'my','project'),
(2,'my','score'),
(2,'my','story'),
(2,'my','task'),
(2,'my','team'),
(2,'my','testcase'),
(2,'my','testtask'),
(2,'my','todo'),
(2,'my','uploadAvatar'),
(2,'my','work'),
(2,'personnel','accessible'),
(2,'personnel','invest'),
(2,'personnel','whitelist'),
(2,'product','all'),
(2,'product','browse'),
(2,'product','build'),
(2,'product','dashboard'),
(2,'product','dynamic'),
(2,'product','index'),
(2,'product','kanban'),
(2,'product','project'),
(2,'product','roadmap'),
(2,'product','view'),
(2,'product','whitelist'),
(2,'productplan','browse'),
(2,'productplan','view'),
(2,'program','browse'),
(2,'program','kanban'),
(2,'program','product'),
(2,'program','project'),
(2,'program','stakeholder'),
(2,'program','view'),
(2,'project','browse'),
(2,'project','bug'),
(2,'project','build'),
(2,'project','create'),
(2,'project','dynamic'),
(2,'project','edit'),
(2,'project','execution'),
(2,'project','index'),
(2,'project','kanban'),
(2,'project','manageMembers'),
(2,'project','programTitle'),
(2,'project','qa'),
(2,'project','team'),
(2,'project','testcase'),
(2,'project','testreport'),
(2,'project','testtask'),
(2,'project','view'),
(2,'project','whitelist'),
(2,'projectbuild','browse'),
(2,'projectrelease','browse'),
(2,'projectrelease','view'),
(2,'projectstory','story'),
(2,'projectstory','track'),
(2,'projectstory','view'),
(2,'qa','index'),
(2,'release','browse'),
(2,'release','view'),
(2,'repo','blame'),
(2,'repo','browse'),
(2,'repo','create'),
(2,'repo','delete'),
(2,'repo','diff'),
(2,'repo','download'),
(2,'repo','edit'),
(2,'repo','log'),
(2,'repo','revision'),
(2,'repo','showSyncCommit'),
(2,'repo','view'),
(2,'report','bugAssign'),
(2,'report','bugCreate'),
(2,'report','index'),
(2,'report','productSummary'),
(2,'report','projectDeviation'),
(2,'report','workload'),
(2,'search','buildForm'),
(2,'search','buildIndex'),
(2,'search','buildQuery'),
(2,'search','deleteQuery'),
(2,'search','index'),
(2,'search','saveQuery'),
(2,'search','select'),
(2,'story','bugs'),
(2,'story','cases'),
(2,'story','report'),
(2,'story','tasks'),
(2,'story','track'),
(2,'story','view'),
(2,'svn','apiSync'),
(2,'svn','cat'),
(2,'svn','diff'),
(2,'task','activate'),
(2,'task','assignTo'),
(2,'task','batchAssignTo'),
(2,'task','batchCancel'),
(2,'task','batchChangeModule'),
(2,'task','batchClose'),
(2,'task','batchCreate'),
(2,'task','batchEdit'),
(2,'task','cancel'),
(2,'task','close'),
(2,'task','confirmStoryChange'),
(2,'task','create'),
(2,'task','delete'),
(2,'task','deleteEstimate'),
(2,'task','edit'),
(2,'task','editEstimate'),
(2,'task','export'),
(2,'task','finish'),
(2,'task','pause'),
(2,'task','recordEstimate'),
(2,'task','report'),
(2,'task','restart'),
(2,'task','start'),
(2,'task','view'),
(2,'testcase','browse'),
(2,'testcase','bugs'),
(2,'testcase','createBug'),
(2,'testcase','export'),
(2,'testcase','groupCase'),
(2,'testcase','view'),
(2,'testreport','browse'),
(2,'testreport','create'),
(2,'testreport','delete'),
(2,'testreport','edit'),
(2,'testreport','view'),
(2,'testsuite','browse'),
(2,'testsuite','index'),
(2,'testsuite','view'),
(2,'testtask','activate'),
(2,'testtask','batchAssign'),
(2,'testtask','batchRun'),
(2,'testtask','batchUnlinkCases'),
(2,'testtask','block'),
(2,'testtask','browse'),
(2,'testtask','browseUnits'),
(2,'testtask','cases'),
(2,'testtask','close'),
(2,'testtask','create'),
(2,'testtask','delete'),
(2,'testtask','edit'),
(2,'testtask','groupCase'),
(2,'testtask','index'),
(2,'testtask','importUnitResult'),
(2,'testtask','linkcase'),
(2,'testtask','report'),
(2,'testtask','results'),
(2,'testtask','runcase'),
(2,'testtask','start'),
(2,'testtask','unitCases'),
(2,'testtask','unlinkcase'),
(2,'testtask','view'),
(2,'todo','activate'),
(2,'todo','assignTo'),
(2,'todo','batchClose'),
(2,'todo','batchCreate'),
(2,'todo','batchEdit'),
(2,'todo','batchFinish'),
(2,'todo','close'),
(2,'todo','create'),
(2,'todo','createcycle'),
(2,'todo','delete'),
(2,'todo','edit'),
(2,'todo','export'),
(2,'todo','finish'),
(2,'todo','import2Today'),
(2,'todo','start'),
(2,'todo','view'),
(2,'tree','browse'),
(2,'tree','browseTask'),
(2,'tree','delete'),
(2,'tree','edit'),
(2,'tree','fix'),
(2,'tree','manageChild'),
(2,'tree','updateOrder'),
(2,'user','batchEdit'),
(2,'user','bug'),
(2,'user','cropAvatar'),
(2,'user','dynamic'),
(2,'user','execution'),
(2,'user','issue'),
(2,'user','profile'),
(2,'user','risk'),
(2,'user','story'),
(2,'user','task'),
(2,'user','testCase'),
(2,'user','testTask'),
(2,'user','todo'),
(2,'user','view'),
(3,'action','comment'),
(3,'action','editComment'),
(3,'admin','index'),
(3,'automation','browse'),
(3,'bug','activate'),
(3,'bug','assignTo'),
(3,'bug','batchActivate'),
(3,'bug','batchAssignTo'),
(3,'bug','batchChangeBranch'),
(3,'bug','batchChangeModule'),
(3,'bug','batchClose'),
(3,'bug','batchConfirm'),
(3,'bug','batchCreate'),
(3,'bug','batchEdit'),
(3,'bug','batchResolve'),
(3,'bug','browse'),
(3,'bug','close'),
(3,'bug','confirmBug'),
(3,'bug','confirmStoryChange'),
(3,'bug','create'),
(3,'bug','delete'),
(3,'bug','edit'),
(3,'bug','export'),
(3,'bug','index'),
(3,'bug','linkBugs'),
(3,'bug','report'),
(3,'bug','resolve'),
(3,'bug','view'),
(3,'build','create'),
(3,'build','edit'),
(3,'build','view'),
(3,'caselib','batchCreateCase'),
(3,'caselib','browse'),
(3,'caselib','createCase'),
(3,'caselib','exportTemplet'),
(3,'caselib','import'),
(3,'caselib','index'),
(3,'caselib','showImport'),
(3,'caselib','view'),
(3,'company','browse'),
(3,'company','dynamic'),
(3,'company','index'),
(3,'company','view'),
(3,'datatable','setGlobal'),
(3,'doc','allLibs'),
(3,'doc','browse'),
(3,'doc','collect'),
(3,'doc','create'),
(3,'doc','edit'),
(3,'doc','index'),
(3,'doc','objectLibs'),
(3,'doc','showFiles'),
(3,'doc','tableContents'),
(3,'doc','view'),
(3,'execution','all'),
(3,'execution','browse'),
(3,'execution','bug'),
(3,'execution','build'),
(3,'execution','burn'),
(3,'execution','computeBurn'),
(3,'execution','doc'),
(3,'execution','dynamic'),
(3,'execution','executionkanban'),
(3,'execution','grouptask'),
(3,'execution','importBug'),
(3,'execution','importtask'),
(3,'execution','index'),
(3,'execution','kanban'),
(3,'execution','story'),
(3,'execution','task'),
(3,'execution','team'),
(3,'execution','testcase'),
(3,'execution','testreport'),
(3,'execution','testtask'),
(3,'execution','tree'),
(3,'execution','treeStory'),
(3,'execution','treeTask'),
(3,'execution','view'),
(3,'execution','whitelist'),
(3,'file','delete'),
(3,'file','download'),
(3,'file','edit'),
(3,'file','setPublic'),
(3,'file','uploadImages'),
(3,'git','apiSync'),
(3,'git','cat'),
(3,'git','diff'),
(3,'group','browse'),
(3,'index','index'),
(3,'message','browser'),
(3,'misc','ping'),
(3,'my','bug'),
(3,'my','calendar'),
(3,'my','changePassword'),
(3,'my','contribute'),
(3,'my','deleteContacts'),
(3,'my','doc'),
(3,'my','dynamic'),
(3,'my','editProfile'),
(3,'my','execution'),
(3,'my','index'),
(3,'my','manageContacts'),
(3,'my','preference'),
(3,'my','profile'),
(3,'my','project'),
(3,'my','score'),
(3,'my','story'),
(3,'my','task'),
(3,'my','team'),
(3,'my','testcase'),
(3,'my','testtask'),
(3,'my','todo'),
(3,'my','unbind'),
(3,'my','uploadAvatar'),
(3,'my','work'),
(3,'personnel','accessible'),
(3,'personnel','invest'),
(3,'personnel','whitelist'),
(3,'product','all'),
(3,'product','browse'),
(3,'product','build'),
(3,'product','dashboard'),
(3,'product','doc'),
(3,'product','dynamic'),
(3,'product','index'),
(3,'product','kanban'),
(3,'product','manageLine'),
(3,'product','project'),
(3,'product','roadmap'),
(3,'product','view'),
(3,'product','whitelist'),
(3,'productplan','browse'),
(3,'productplan','view'),
(3,'program','browse'),
(3,'program','kanban'),
(3,'program','product'),
(3,'program','project'),
(3,'program','stakeholder'),
(3,'program','view'),
(3,'project','browse'),
(3,'project','bug'),
(3,'project','build'),
(3,'project','dynamic'),
(3,'project','execution'),
(3,'project','group'),
(3,'project','index'),
(3,'project','kanban'),
(3,'project','programTitle'),
(3,'project','qa'),
(3,'project','team'),
(3,'project','testcase'),
(3,'project','testreport'),
(3,'project','testtask'),
(3,'project','view'),
(3,'project','whitelist'),
(3,'projectbuild','browse'),
(3,'projectrelease','browse'),
(3,'projectrelease','view'),
(3,'projectstory','story'),
(3,'projectstory','track'),
(3,'projectstory','view'),
(3,'qa','index'),
(3,'release','browse'),
(3,'release','export'),
(3,'release','view'),
(3,'repo','blame'),
(3,'repo','browse'),
(3,'repo','diff'),
(3,'repo','download'),
(3,'repo','log'),
(3,'repo','revision'),
(3,'repo','showSyncCommit'),
(3,'repo','view'),
(3,'report','bugAssign'),
(3,'report','bugCreate'),
(3,'report','index'),
(3,'report','productSummary'),
(3,'report','projectDeviation'),
(3,'report','workload'),
(3,'search','buildForm'),
(3,'search','buildQuery'),
(3,'search','deleteQuery'),
(3,'search','index'),
(3,'search','saveQuery'),
(3,'search','select'),
(3,'story','batchToTask'),
(3,'story','bugs'),
(3,'story','cases'),
(3,'story','export'),
(3,'story','processStoryChange'),
(3,'story','report'),
(3,'story','tasks'),
(3,'story','track'),
(3,'story','view'),
(3,'story','zeroCase'),
(3,'svn','apiSync'),
(3,'svn','cat'),
(3,'svn','diff'),
(3,'task','activate'),
(3,'task','assignTo'),
(3,'task','batchAssignTo'),
(3,'task','batchChangeModule'),
(3,'task','batchClose'),
(3,'task','batchCreate'),
(3,'task','batchEdit'),
(3,'task','cancel'),
(3,'task','close'),
(3,'task','confirmStoryChange'),
(3,'task','create'),
(3,'task','deleteEstimate'),
(3,'task','edit'),
(3,'task','editEstimate'),
(3,'task','export'),
(3,'task','finish'),
(3,'task','pause'),
(3,'task','recordEstimate'),
(3,'task','report'),
(3,'task','restart'),
(3,'task','start'),
(3,'task','view'),
(3,'testcase','batchCaseTypeChange'),
(3,'testcase','batchChangeBranch'),
(3,'testcase','batchChangeModule'),
(3,'testcase','batchConfirmStoryChange'),
(3,'testcase','batchCreate'),
(3,'testcase','batchDelete'),
(3,'testcase','batchEdit'),
(3,'testcase','batchReview'),
(3,'testcase','browse'),
(3,'testcase','bugs'),
(3,'testcase','confirmChange'),
(3,'testcase','confirmLibcaseChange'),
(3,'testcase','confirmStoryChange'),
(3,'testcase','create'),
(3,'testcase','createBug'),
(3,'testcase','delete'),
(3,'testcase','edit'),
(3,'testcase','export'),
(3,'testcase','exportTemplet'),
(3,'testcase','groupCase'),
(3,'testcase','ignoreLibcaseChange'),
(3,'testcase','import'),
(3,'testcase','index'),
(3,'testcase','importFromLib'),
(3,'testcase','linkCases'),
(3,'testcase','review'),
(3,'testcase','showImport'),
(3,'testcase','view'),
(3,'testreport','browse'),
(3,'testreport','view'),
(3,'testsuite','batchUnlinkCases'),
(3,'testsuite','browse'),
(3,'testsuite','create'),
(3,'testsuite','delete'),
(3,'testsuite','edit'),
(3,'testsuite','index'),
(3,'testsuite','linkCase'),
(3,'testsuite','unlinkCase'),
(3,'testsuite','view'),
(3,'testtask','activate'),
(3,'testtask','batchAssign'),
(3,'testtask','batchRun'),
(3,'testtask','batchUnlinkCases'),
(3,'testtask','block'),
(3,'testtask','browse'),
(3,'testtask','browseUnits'),
(3,'testtask','cases'),
(3,'testtask','close'),
(3,'testtask','create'),
(3,'testtask','edit'),
(3,'testtask','groupCase'),
(3,'testtask','index'),
(3,'testtask','importUnitResult'),
(3,'testtask','linkcase'),
(3,'testtask','report'),
(3,'testtask','results'),
(3,'testtask','runcase'),
(3,'testtask','start'),
(3,'testtask','unitCases'),
(3,'testtask','unlinkcase'),
(3,'testtask','view'),
(3,'todo','activate'),
(3,'todo','assignTo'),
(3,'todo','batchClose'),
(3,'todo','batchCreate'),
(3,'todo','batchEdit'),
(3,'todo','batchFinish'),
(3,'todo','close'),
(3,'todo','create'),
(3,'todo','createcycle'),
(3,'todo','delete'),
(3,'todo','edit'),
(3,'todo','export'),
(3,'todo','finish'),
(3,'todo','import2Today'),
(3,'todo','start'),
(3,'todo','view'),
(3,'user','bug'),
(3,'user','cropAvatar'),
(3,'user','dynamic'),
(3,'user','execution'),
(3,'user','issue'),
(3,'user','profile'),
(3,'user','risk'),
(3,'user','story'),
(3,'user','task'),
(3,'user','testCase'),
(3,'user','testTask'),
(3,'user','todo'),
(3,'user','view'),
(4,'action','comment'),
(4,'action','editComment'),
(4,'action','hideAll'),
(4,'action','hideOne'),
(4,'action','trash'),
(4,'action','undelete'),
(4,'admin','index'),
(4,'admin','checkWeak'),
(4,'admin','safe'),
(4,'automation','browse'),
(4,'bug','activate'),
(4,'bug','assignTo'),
(4,'bug','batchActivate'),
(4,'bug','batchAssignTo'),
(4,'bug','batchChangeBranch'),
(4,'bug','batchChangeModule'),
(4,'bug','batchClose'),
(4,'bug','batchConfirm'),
(4,'bug','batchCreate'),
(4,'bug','batchEdit'),
(4,'bug','batchResolve'),
(4,'bug','browse'),
(4,'bug','close'),
(4,'bug','confirmBug'),
(4,'bug','confirmStoryChange'),
(4,'bug','create'),
(4,'bug','delete'),
(4,'bug','edit'),
(4,'bug','export'),
(4,'bug','index'),
(4,'bug','linkBugs'),
(4,'bug','report'),
(4,'bug','resolve'),
(4,'bug','view'),
(4,'build','batchUnlinkBug'),
(4,'build','batchUnlinkStory'),
(4,'build','create'),
(4,'build','delete'),
(4,'build','edit'),
(4,'build','linkBug'),
(4,'build','linkStory'),
(4,'build','unlinkBug'),
(4,'build','unlinkStory'),
(4,'build','view'),
(4,'caselib','batchCreateCase'),
(4,'caselib','browse'),
(4,'caselib','create'),
(4,'caselib','createCase'),
(4,'caselib','delete'),
(4,'caselib','edit'),
(4,'caselib','exportTemplet'),
(4,'caselib','import'),
(4,'caselib','index'),
(4,'caselib','showImport'),
(4,'caselib','view'),
(4,'ci','checkCompileStatus'),
(4,'ci','commitResult'),
(4,'company','browse'),
(4,'company','dynamic'),
(4,'company','edit'),
(4,'company','index'),
(4,'company','view'),
(4,'compile','browse'),
(4,'compile','logs'),
(4,'datatable','setGlobal'),
(4,'doc','allLibs'),
(4,'doc','browse'),
(4,'doc','collect'),
(4,'doc','create'),
(4,'doc','createLib'),
(4,'doc','delete'),
(4,'doc','deleteFile'),
(4,'doc','deleteLib'),
(4,'doc','edit'),
(4,'doc','editLib'),
(4,'doc','index'),
(4,'doc','objectLibs'),
(4,'doc','showFiles'),
(4,'doc','tableContents'),
(4,'doc','view'),
(4,'execution','activate'),
(4,'execution','addWhitelist'),
(4,'execution','all'),
(4,'execution','batchedit'),
(4,'execution','batchUnlinkStory'),
(4,'execution','browse'),
(4,'execution','bug'),
(4,'execution','build'),
(4,'execution','burn'),
(4,'execution','burnData'),
(4,'execution','close'),
(4,'execution','computeBurn'),
(4,'execution','create'),
(4,'execution','delete'),
(4,'execution','doc'),
(4,'execution','dynamic'),
(4,'execution','edit'),
(4,'execution','executionkanban'),
(4,'execution','export'),
(4,'execution','fixFirst'),
(4,'execution','grouptask'),
(4,'execution','importBug'),
(4,'execution','importplanstories'),
(4,'execution','importtask'),
(4,'execution','index'),
(4,'execution','kanban'),
(4,'execution','linkStory'),
(4,'execution','manageMembers'),
(4,'execution','manageProducts'),
(4,'execution','printKanban'),
(4,'execution','putoff'),
(4,'execution','start'),
(4,'execution','story'),
(4,'execution','storyEstimate'),
(4,'execution','storyKanban'),
(4,'execution','storySort'),
(4,'execution','suspend'),
(4,'execution','task'),
(4,'execution','team'),
(4,'execution','testcase'),
(4,'execution','testreport'),
(4,'execution','testtask'),
(4,'execution','tree'),
(4,'execution','treeStory'),
(4,'execution','treeTask'),
(4,'execution','unbindWhitelist'),
(4,'execution','unlinkMember'),
(4,'execution','unlinkStory'),
(4,'execution','updateOrder'),
(4,'execution','view'),
(4,'execution','whitelist'),
(4,'extension','browse'),
(4,'extension','obtain'),
(4,'extension','structure'),
(4,'file','delete'),
(4,'file','download'),
(4,'file','edit'),
(4,'file','setPublic'),
(4,'file','uploadImages'),
(4,'git','apiSync'),
(4,'git','cat'),
(4,'git','diff'),
(4,'group','browse'),
(4,'index','index'),
(4,'jenkins','browse'),
(4,'jenkins','create'),
(4,'jenkins','delete'),
(4,'jenkins','edit'),
(4,'job','browse'),
(4,'job','create'),
(4,'job','delete'),
(4,'job','edit'),
(4,'job','exec'),
(4,'job','view'),
(4,'misc','ping'),
(4,'my','bug'),
(4,'my','calendar'),
(4,'my','changePassword'),
(4,'my','contribute'),
(4,'my','deleteContacts'),
(4,'my','doc'),
(4,'my','dynamic'),
(4,'my','editProfile'),
(4,'my','execution'),
(4,'my','index'),
(4,'my','manageContacts'),
(4,'my','preference'),
(4,'my','profile'),
(4,'my','project'),
(4,'my','score'),
(4,'my','story'),
(4,'my','task'),
(4,'my','team'),
(4,'my','testcase'),
(4,'my','testtask'),
(4,'my','todo'),
(4,'my','unbind'),
(4,'my','uploadAvatar'),
(4,'my','work'),
(4,'personnel','accessible'),
(4,'personnel','addWhitelist'),
(4,'personnel','invest'),
(4,'personnel','unbindWhitelist'),
(4,'personnel','whitelist'),
(4,'product','all'),
(4,'product','batchEdit'),
(4,'product','browse'),
(4,'product','build'),
(4,'product','close'),
(4,'product','create'),
(4,'product','dashboard'),
(4,'product','doc'),
(4,'product','delete'),
(4,'product','dynamic'),
(4,'product','edit'),
(4,'product','index'),
(4,'product','kanban'),
(4,'product','manageLine'),
(4,'product','project'),
(4,'product','roadmap'),
(4,'product','view'),
(4,'product','whitelist'),
(4,'productplan','batchEdit'),
(4,'productplan','batchUnlinkBug'),
(4,'productplan','batchUnlinkStory'),
(4,'productplan','browse'),
(4,'productplan','create'),
(4,'productplan','delete'),
(4,'productplan','edit'),
(4,'productplan','linkBug'),
(4,'productplan','linkStory'),
(4,'productplan','unlinkBug'),
(4,'productplan','unlinkStory'),
(4,'productplan','view'),
(4,'program','index'),
(4,'program','activate'),
(4,'program','browse'),
(4,'program','close'),
(4,'program','create'),
(4,'program','createStakeholder'),
(4,'program','delete'),
(4,'program','edit'),
(4,'program','export'),
(4,'program','kanban'),
(4,'program','product'),
(4,'program','project'),
(4,'program','stakeholder'),
(4,'program','start'),
(4,'program','suspend'),
(4,'program','unbindWhitelist'),
(4,'program','unlinkStakeholder'),
(4,'program','updateOrder'),
(4,'program','view'),
(4,'project','activate'),
(4,'project','addWhitelist'),
(4,'project','batchEdit'),
(4,'project','browse'),
(4,'project','bug'),
(4,'project','build'),
(4,'project','close'),
(4,'project','copyGroup'),
(4,'project','create'),
(4,'project','createGroup'),
(4,'project','createStakeholder'),
(4,'project','createGuide'),
(4,'project','delete'),
(4,'project','dynamic'),
(4,'project','edit'),
(4,'project','editGroup'),
(4,'project','execution'),
(4,'project','export'),
(4,'project','group'),
(4,'project','index'),
(4,'project','kanban'),
(4,'project','manageGroupMember'),
(4,'project','manageMembers'),
(4,'project','managePriv'),
(4,'project','manageProducts'),
(4,'project','manageView'),
(4,'project','programTitle'),
(4,'project','qa'),
(4,'project','start'),
(4,'project','suspend'),
(4,'project','team'),
(4,'project','testcase'),
(4,'project','testreport'),
(4,'project','testtask'),
(4,'project','unbindWhitelist'),
(4,'project','unlinkMember'),
(4,'project','updateOrder'),
(4,'project','view'),
(4,'project','whitelist'),
(4,'projectbuild','browse'),
(4,'projectrelease','batchUnlinkBug'),
(4,'projectrelease','batchUnlinkStory'),
(4,'projectrelease','browse'),
(4,'projectrelease','changeStatus'),
(4,'projectrelease','create'),
(4,'projectrelease','delete'),
(4,'projectrelease','edit'),
(4,'projectrelease','export'),
(4,'projectrelease','linkBug'),
(4,'projectrelease','linkStory'),
(4,'projectrelease','unlinkBug'),
(4,'projectrelease','unlinkStory'),
(4,'projectrelease','view'),
(4,'projectstory','batchUnlinkStory'),
(4,'projectstory','importplanstories'),
(4,'projectstory','linkStory'),
(4,'projectstory','story'),
(4,'projectstory','track'),
(4,'projectstory','unlinkStory'),
(4,'projectstory','view'),
(4,'qa','index'),
(4,'release','batchUnlinkBug'),
(4,'release','batchUnlinkStory'),
(4,'release','browse'),
(4,'release','changeStatus'),
(4,'release','create'),
(4,'release','delete'),
(4,'release','edit'),
(4,'release','export'),
(4,'release','linkBug'),
(4,'release','linkStory'),
(4,'release','unlinkBug'),
(4,'release','unlinkStory'),
(4,'release','view'),
(4,'repo','blame'),
(4,'repo','browse'),
(4,'repo','create'),
(4,'repo','delete'),
(4,'repo','diff'),
(4,'repo','download'),
(4,'repo','edit'),
(4,'repo','log'),
(4,'repo','maintain'),
(4,'repo','revision'),
(4,'repo','setRules'),
(4,'repo','showSyncCommit'),
(4,'repo','view'),
(4,'report','bugAssign'),
(4,'report','bugCreate'),
(4,'report','index'),
(4,'report','productSummary'),
(4,'report','projectDeviation'),
(4,'report','workload'),
(4,'search','buildForm'),
(4,'search','buildQuery'),
(4,'search','deleteQuery'),
(4,'search','index'),
(4,'search','saveQuery'),
(4,'search','select'),
(4,'stakeholder','batchCreate'),
(4,'stakeholder','browse'),
(4,'stakeholder','communicate'),
(4,'stakeholder','create'),
(4,'stakeholder','createExpect'),
(4,'stakeholder','delete'),
(4,'stakeholder','deleteExpect'),
(4,'stakeholder','edit'),
(4,'stakeholder','editExpect'),
(4,'stakeholder','expect'),
(4,'stakeholder','expectation'),
(4,'stakeholder','issue'),
(4,'stakeholder','plan'),
(4,'stakeholder','userIssue'),
(4,'stakeholder','view'),
(4,'stakeholder','viewExpect'),
(4,'stakeholder','viewIssue'),
(4,'story','activate'),
(4,'story','assignTo'),
(4,'story','batchAssignTo'),
(4,'story','batchChangeBranch'),
(4,'story','batchChangeModule'),
(4,'story','batchChangePlan'),
(4,'story','batchChangeStage'),
(4,'story','batchClose'),
(4,'story','batchCreate'),
(4,'story','batchEdit'),
(4,'story','batchReview'),
(4,'story','batchToTask'),
(4,'story','bugs'),
(4,'story','cases'),
(4,'story','change'),
(4,'story','close'),
(4,'story','create'),
(4,'story','delete'),
(4,'story','edit'),
(4,'story','export'),
(4,'story','linkStory'),
(4,'story','processStoryChange'),
(4,'story','recall'),
(4,'story','report'),
(4,'story','review'),
(4,'story','tasks'),
(4,'story','track'),
(4,'story','view'),
(4,'story','zeroCase'),
(4,'svn','apiSync'),
(4,'svn','cat'),
(4,'svn','diff'),
(4,'task','activate'),
(4,'task','assignTo'),
(4,'task','batchAssignTo'),
(4,'task','batchCancel'),
(4,'task','batchChangeModule'),
(4,'task','batchClose'),
(4,'task','batchCreate'),
(4,'task','batchEdit'),
(4,'task','cancel'),
(4,'task','close'),
(4,'task','confirmStoryChange'),
(4,'task','create'),
(4,'task','delete'),
(4,'task','deleteEstimate'),
(4,'task','edit'),
(4,'task','editEstimate'),
(4,'task','export'),
(4,'task','finish'),
(4,'task','pause'),
(4,'task','recordEstimate'),
(4,'task','report'),
(4,'task','restart'),
(4,'task','start'),
(4,'task','view'),
(4,'testcase','batchCaseTypeChange'),
(4,'testcase','batchChangeBranch'),
(4,'testcase','batchChangeModule'),
(4,'testcase','batchConfirmStoryChange'),
(4,'testcase','batchCreate'),
(4,'testcase','batchDelete'),
(4,'testcase','batchEdit'),
(4,'testcase','batchReview'),
(4,'testcase','browse'),
(4,'testcase','bugs'),
(4,'testcase','confirmChange'),
(4,'testcase','confirmLibcaseChange'),
(4,'testcase','confirmStoryChange'),
(4,'testcase','create'),
(4,'testcase','createBug'),
(4,'testcase','delete'),
(4,'testcase','edit'),
(4,'testcase','export'),
(4,'testcase','exportTemplet'),
(4,'testcase','groupCase'),
(4,'testcase','index'),
(4,'testcase','ignoreLibcaseChange'),
(4,'testcase','import'),
(4,'testcase','importFromLib'),
(4,'testcase','linkCases'),
(4,'testcase','review'),
(4,'testcase','showImport'),
(4,'testcase','view'),
(4,'testreport','browse'),
(4,'testreport','create'),
(4,'testreport','delete'),
(4,'testreport','edit'),
(4,'testreport','view'),
(4,'testsuite','batchUnlinkCases'),
(4,'testsuite','browse'),
(4,'testsuite','create'),
(4,'testsuite','delete'),
(4,'testsuite','edit'),
(4,'testsuite','index'),
(4,'testsuite','linkCase'),
(4,'testsuite','unlinkCase'),
(4,'testsuite','view'),
(4,'testtask','activate'),
(4,'testtask','batchAssign'),
(4,'testtask','batchRun'),
(4,'testtask','batchUnlinkCases'),
(4,'testtask','block'),
(4,'testtask','browse'),
(4,'testtask','browseUnits'),
(4,'testtask','cases'),
(4,'testtask','close'),
(4,'testtask','create'),
(4,'testtask','delete'),
(4,'testtask','edit'),
(4,'testtask','groupCase'),
(4,'testtask','importUnitResult'),
(4,'testtask','index'),
(4,'testtask','linkcase'),
(4,'testtask','report'),
(4,'testtask','results'),
(4,'testtask','runcase'),
(4,'testtask','start'),
(4,'testtask','unitCases'),
(4,'testtask','unlinkcase'),
(4,'testtask','view'),
(4,'todo','activate'),
(4,'todo','assignTo'),
(4,'todo','batchClose'),
(4,'todo','batchCreate'),
(4,'todo','batchEdit'),
(4,'todo','batchFinish'),
(4,'todo','close'),
(4,'todo','create'),
(4,'todo','createcycle'),
(4,'todo','delete'),
(4,'todo','edit'),
(4,'todo','export'),
(4,'todo','finish'),
(4,'todo','import2Today'),
(4,'todo','start'),
(4,'todo','view'),
(4,'tree','browse'),
(4,'tree','browseTask'),
(4,'tree','delete'),
(4,'tree','edit'),
(4,'tree','fix'),
(4,'tree','manageChild'),
(4,'tree','updateOrder'),
(4,'user','bug'),
(4,'user','cropAvatar'),
(4,'user','dynamic'),
(4,'user','execution'),
(4,'user','issue'),
(4,'user','profile'),
(4,'user','risk'),
(4,'user','setPublicTemplate'),
(4,'user','story'),
(4,'user','task'),
(4,'user','testCase'),
(4,'user','testTask'),
(4,'user','todo'),
(4,'user','view'),
(5,'action','comment'),
(5,'action','editComment'),
(5,'action','hideAll'),
(5,'action','hideOne'),
(5,'action','trash'),
(5,'action','undelete'),
(5,'admin','index'),
(5,'admin','checkWeak'),
(5,'admin','safe'),
(5,'automation','browse'),
(5,'branch','delete'),
(5,'branch','manage'),
(5,'branch','sort'),
(5,'bug','activate'),
(5,'bug','assignTo'),
(5,'bug','batchActivate'),
(5,'bug','batchAssignTo'),
(5,'bug','batchChangeBranch'),
(5,'bug','batchChangeModule'),
(5,'bug','batchClose'),
(5,'bug','batchConfirm'),
(5,'bug','batchCreate'),
(5,'bug','batchEdit'),
(5,'bug','batchResolve'),
(5,'bug','browse'),
(5,'bug','close'),
(5,'bug','confirmBug'),
(5,'bug','confirmStoryChange'),
(5,'bug','create'),
(5,'bug','delete'),
(5,'bug','edit'),
(5,'bug','export'),
(5,'bug','index'),
(5,'bug','linkBugs'),
(5,'bug','report'),
(5,'bug','resolve'),
(5,'bug','view'),
(5,'build','batchUnlinkBug'),
(5,'build','batchUnlinkStory'),
(5,'build','create'),
(5,'build','delete'),
(5,'build','edit'),
(5,'build','linkBug'),
(5,'build','linkStory'),
(5,'build','unlinkBug'),
(5,'build','unlinkStory'),
(5,'build','view'),
(5,'company','browse'),
(5,'company','dynamic'),
(5,'company','index'),
(5,'company','view'),
(5,'compile','browse'),
(5,'compile','logs'),
(5,'datatable','setGlobal'),
(5,'doc','allLibs'),
(5,'doc','browse'),
(5,'doc','collect'),
(5,'doc','create'),
(5,'doc','createLib'),
(5,'doc','delete'),
(5,'doc','deleteFile'),
(5,'doc','deleteLib'),
(5,'doc','edit'),
(5,'doc','editLib'),
(5,'doc','index'),
(5,'doc','objectLibs'),
(5,'doc','showFiles'),
(5,'doc','tableContents'),
(5,'doc','view'),
(5,'execution','activate'),
(5,'execution','addWhitelist'),
(5,'execution','all'),
(5,'execution','batchedit'),
(5,'execution','batchUnlinkStory'),
(5,'execution','browse'),
(5,'execution','bug'),
(5,'execution','build'),
(5,'execution','burn'),
(5,'execution','burnData'),
(5,'execution','close'),
(5,'execution','computeBurn'),
(5,'execution','create'),
(5,'execution','delete'),
(5,'execution','doc'),
(5,'execution','dynamic'),
(5,'execution','edit'),
(5,'execution','executionkanban'),
(5,'execution','export'),
(5,'execution','fixFirst'),
(5,'execution','grouptask'),
(5,'execution','importBug'),
(5,'execution','importplanstories'),
(5,'execution','importtask'),
(5,'execution','index'),
(5,'execution','kanban'),
(5,'execution','linkStory'),
(5,'execution','manageMembers'),
(5,'execution','manageProducts'),
(5,'execution','printKanban'),
(5,'execution','putoff'),
(5,'execution','start'),
(5,'execution','story'),
(5,'execution','storyEstimate'),
(5,'execution','storyKanban'),
(5,'execution','storySort'),
(5,'execution','suspend'),
(5,'execution','task'),
(5,'execution','team'),
(5,'execution','testcase'),
(5,'execution','testreport'),
(5,'execution','testtask'),
(5,'execution','tree'),
(5,'execution','treeStory'),
(5,'execution','treeTask'),
(5,'execution','unbindWhitelist'),
(5,'execution','unlinkMember'),
(5,'execution','unlinkStory'),
(5,'execution','updateOrder'),
(5,'execution','view'),
(5,'execution','whitelist'),
(5,'extension','browse'),
(5,'extension','obtain'),
(5,'extension','structure'),
(5,'file','delete'),
(5,'file','download'),
(5,'file','edit'),
(5,'file','setPublic'),
(5,'file','uploadImages'),
(5,'git','apiSync'),
(5,'git','cat'),
(5,'git','diff'),
(5,'group','browse'),
(5,'index','index'),
(5,'jenkins','browse'),
(5,'jenkins','create'),
(5,'jenkins','delete'),
(5,'jenkins','edit'),
(5,'job','browse'),
(5,'job','create'),
(5,'job','delete'),
(5,'job','edit'),
(5,'job','exec'),
(5,'job','view'),
(5,'misc','ping'),
(5,'my','bug'),
(5,'my','calendar'),
(5,'my','changePassword'),
(5,'my','contribute'),
(5,'my','deleteContacts'),
(5,'my','doc'),
(5,'my','dynamic'),
(5,'my','editProfile'),
(5,'my','execution'),
(5,'my','index'),
(5,'my','manageContacts'),
(5,'my','preference'),
(5,'my','profile'),
(5,'my','project'),
(5,'my','score'),
(5,'my','story'),
(5,'my','task'),
(5,'my','team'),
(5,'my','testcase'),
(5,'my','testtask'),
(5,'my','todo'),
(5,'my','unbind'),
(5,'my','uploadAvatar'),
(5,'my','work'),
(5,'personnel','accessible'),
(5,'personnel','addWhitelist'),
(5,'personnel','invest'),
(5,'personnel','unbindWhitelist'),
(5,'personnel','whitelist'),
(5,'product','addWhitelist'),
(5,'product','all'),
(5,'product','batchEdit'),
(5,'product','browse'),
(5,'product','build'),
(5,'product','close'),
(5,'product','create'),
(5,'product','dashboard'),
(5,'product','delete'),
(5,'product','doc'),
(5,'product','dynamic'),
(5,'product','edit'),
(5,'product','export'),
(5,'product','index'),
(5,'product','kanban'),
(5,'product','manageLine'),
(5,'product','project'),
(5,'product','roadmap'),
(5,'product','unbindWhitelist'),
(5,'product','updateOrder'),
(5,'product','view'),
(5,'product','whitelist'),
(5,'productplan','batchEdit'),
(5,'productplan','batchUnlinkBug'),
(5,'productplan','batchUnlinkStory'),
(5,'productplan','browse'),
(5,'productplan','create'),
(5,'productplan','delete'),
(5,'productplan','edit'),
(5,'productplan','linkBug'),
(5,'productplan','linkStory'),
(5,'productplan','unlinkBug'),
(5,'productplan','unlinkStory'),
(5,'productplan','view'),
(5,'program','index'),
(5,'program','activate'),
(5,'program','batchUnlinkStakeholders'),
(5,'program','browse'),
(5,'program','close'),
(5,'program','create'),
(5,'program','createStakeholder'),
(5,'program','delete'),
(5,'program','edit'),
(5,'program','export'),
(5,'program','kanban'),
(5,'program','product'),
(5,'program','project'),
(5,'program','stakeholder'),
(5,'program','start'),
(5,'program','suspend'),
(5,'program','unbindWhitelist'),
(5,'program','unlinkStakeholder'),
(5,'program','updateOrder'),
(5,'program','view'),
(5,'project','activate'),
(5,'project','addWhitelist'),
(5,'project','batchEdit'),
(5,'project','browse'),
(5,'project','bug'),
(5,'project','build'),
(5,'project','close'),
(5,'project','copyGroup'),
(5,'project','create'),
(5,'project','createGroup'),
(5,'project','createGuide'),
(5,'project','delete'),
(5,'project','dynamic'),
(5,'project','edit'),
(5,'project','editGroup'),
(5,'project','execution'),
(5,'project','export'),
(5,'project','group'),
(5,'project','index'),
(5,'project','kanban'),
(5,'project','manageGroupMember'),
(5,'project','manageMembers'),
(5,'project','managePriv'),
(5,'project','manageProducts'),
(5,'project','programTitle'),
(5,'project','qa'),
(5,'project','start'),
(5,'project','suspend'),
(5,'project','team'),
(5,'project','testcase'),
(5,'project','testreport'),
(5,'project','testtask'),
(5,'project','unbindWhitelist'),
(5,'project','unlinkMember'),
(5,'project','updateOrder'),
(5,'project','view'),
(5,'project','whitelist'),
(5,'projectbuild','browse'),
(5,'projectrelease','batchUnlinkBug'),
(5,'projectrelease','batchUnlinkStory'),
(5,'projectrelease','browse'),
(5,'projectrelease','changeStatus'),
(5,'projectrelease','create'),
(5,'projectrelease','delete'),
(5,'projectrelease','edit'),
(5,'projectrelease','export'),
(5,'projectrelease','linkBug'),
(5,'projectrelease','linkStory'),
(5,'projectrelease','unlinkBug'),
(5,'projectrelease','unlinkStory'),
(5,'projectrelease','view'),
(5,'projectstory','batchUnlinkStory'),
(5,'projectstory','importplanstories'),
(5,'projectstory','linkStory'),
(5,'projectstory','story'),
(5,'projectstory','track'),
(5,'projectstory','unlinkStory'),
(5,'projectstory','view'),
(5,'qa','index'),
(5,'release','batchUnlinkBug'),
(5,'release','batchUnlinkStory'),
(5,'release','browse'),
(5,'release','changeStatus'),
(5,'release','create'),
(5,'release','delete'),
(5,'release','edit'),
(5,'release','export'),
(5,'release','linkBug'),
(5,'release','linkStory'),
(5,'release','unlinkBug'),
(5,'release','unlinkStory'),
(5,'release','view'),
(5,'repo','blame'),
(5,'repo','browse'),
(5,'repo','create'),
(5,'repo','delete'),
(5,'repo','diff'),
(5,'repo','download'),
(5,'repo','edit'),
(5,'repo','log'),
(5,'repo','maintain'),
(5,'repo','revision'),
(5,'repo','setRules'),
(5,'repo','showSyncCommit'),
(5,'repo','view'),
(5,'report','bugAssign'),
(5,'report','bugCreate'),
(5,'report','index'),
(5,'report','productSummary'),
(5,'report','projectDeviation'),
(5,'report','workload'),
(5,'search','buildForm'),
(5,'search','buildQuery'),
(5,'search','deleteQuery'),
(5,'search','index'),
(5,'search','saveQuery'),
(5,'search','select'),
(5,'stakeholder','browse'),
(5,'stakeholder','batchCreate'),
(5,'stakeholder','communicate'),
(5,'stakeholder','create'),
(5,'stakeholder','createExpect'),
(5,'stakeholder','delete'),
(5,'stakeholder','deleteExpect'),
(5,'stakeholder','edit'),
(5,'stakeholder','editExpect'),
(5,'stakeholder','expect'),
(5,'stakeholder','expectation'),
(5,'stakeholder','issue'),
(5,'stakeholder','plan'),
(5,'stakeholder','userIssue'),
(5,'stakeholder','view'),
(5,'stakeholder','viewExpect'),
(5,'stakeholder','viewIssue'),
(5,'story','activate'),
(5,'story','assignTo'),
(5,'story','batchAssignTo'),
(5,'story','batchChangeBranch'),
(5,'story','batchChangeModule'),
(5,'story','batchChangePlan'),
(5,'story','batchChangeStage'),
(5,'story','batchClose'),
(5,'story','batchCreate'),
(5,'story','batchEdit'),
(5,'story','batchReview'),
(5,'story','batchToTask'),
(5,'story','bugs'),
(5,'story','cases'),
(5,'story','change'),
(5,'story','close'),
(5,'story','create'),
(5,'story','delete'),
(5,'story','edit'),
(5,'story','export'),
(5,'story','linkStory'),
(5,'story','processStoryChange'),
(5,'story','recall'),
(5,'story','report'),
(5,'story','review'),
(5,'story','tasks'),
(5,'story','track'),
(5,'story','view'),
(5,'story','zeroCase'),
(5,'svn','apiSync'),
(5,'svn','cat'),
(5,'svn','diff'),
(5,'task','activate'),
(5,'task','assignTo'),
(5,'task','batchAssignTo'),
(5,'task','batchCancel'),
(5,'task','batchChangeModule'),
(5,'task','batchClose'),
(5,'task','batchCreate'),
(5,'task','batchEdit'),
(5,'task','cancel'),
(5,'task','close'),
(5,'task','confirmStoryChange'),
(5,'task','create'),
(5,'task','delete'),
(5,'task','deleteEstimate'),
(5,'task','edit'),
(5,'task','editEstimate'),
(5,'task','export'),
(5,'task','finish'),
(5,'task','pause'),
(5,'task','recordEstimate'),
(5,'task','report'),
(5,'task','restart'),
(5,'task','start'),
(5,'task','view'),
(5,'testcase','browse'),
(5,'testcase','bugs'),
(5,'testcase','createBug'),
(5,'testcase','export'),
(5,'testcase','groupCase'),
(5,'testcase','importFromLib'),
(5,'testcase','index'),
(5,'testcase','view'),
(5,'testreport','browse'),
(5,'testreport','create'),
(5,'testreport','delete'),
(5,'testreport','edit'),
(5,'testreport','view'),
(5,'testsuite','browse'),
(5,'testsuite','index'),
(5,'testsuite','view'),
(5,'testtask','browse'),
(5,'testtask','cases'),
(5,'testtask','create'),
(5,'testtask','edit'),
(5,'testtask','groupCase'),
(5,'testtask','index'),
(5,'testtask','results'),
(5,'testtask','view'),
(5,'todo','activate'),
(5,'todo','assignTo'),
(5,'todo','batchClose'),
(5,'todo','batchCreate'),
(5,'todo','batchEdit'),
(5,'todo','batchFinish'),
(5,'todo','close'),
(5,'todo','create'),
(5,'todo','createcycle'),
(5,'todo','delete'),
(5,'todo','edit'),
(5,'todo','export'),
(5,'todo','finish'),
(5,'todo','import2Today'),
(5,'todo','start'),
(5,'todo','view'),
(5,'tree','browse'),
(5,'tree','browseTask'),
(5,'tree','delete'),
(5,'tree','edit'),
(5,'tree','fix'),
(5,'tree','manageChild'),
(5,'tree','updateOrder'),
(5,'user','bug'),
(5,'user','cropAvatar'),
(5,'user','dynamic'),
(5,'user','execution'),
(5,'user','issue'),
(5,'user','profile'),
(5,'user','risk'),
(5,'user','story'),
(5,'user','task'),
(5,'user','testCase'),
(5,'user','testTask'),
(5,'user','todo'),
(5,'user','view'),
(6,'action','comment'),
(6,'action','editComment'),
(6,'action','hideAll'),
(6,'action','hideOne'),
(6,'action','trash'),
(6,'action','undelete'),
(6,'admin','index'),
(6,'automation','browse'),
(6,'bug','activate'),
(6,'bug','assignTo'),
(6,'bug','batchActivate'),
(6,'bug','batchAssignTo'),
(6,'bug','batchChangeModule'),
(6,'bug','batchClose'),
(6,'bug','batchConfirm'),
(6,'bug','batchCreate'),
(6,'bug','batchEdit'),
(6,'bug','batchResolve'),
(6,'bug','browse'),
(6,'bug','close'),
(6,'bug','confirmBug'),
(6,'bug','confirmStoryChange'),
(6,'bug','create'),
(6,'bug','delete'),
(6,'bug','edit'),
(6,'bug','export'),
(6,'bug','index'),
(6,'bug','linkBugs'),
(6,'bug','report'),
(6,'bug','resolve'),
(6,'bug','view'),
(6,'build','batchUnlinkBug'),
(6,'build','batchUnlinkStory'),
(6,'build','create'),
(6,'build','delete'),
(6,'build','edit'),
(6,'build','linkBug'),
(6,'build','linkStory'),
(6,'build','unlinkBug'),
(6,'build','unlinkStory'),
(6,'build','view'),
(6,'company','browse'),
(6,'company','dynamic'),
(6,'company','index'),
(6,'company','view'),
(6,'datatable','setGlobal'),
(6,'doc','allLibs'),
(6,'doc','browse'),
(6,'doc','collect'),
(6,'doc','create'),
(6,'doc','createLib'),
(6,'doc','delete'),
(6,'doc','deleteFile'),
(6,'doc','deleteLib'),
(6,'doc','edit'),
(6,'doc','editLib'),
(6,'doc','index'),
(6,'doc','objectLibs'),
(6,'doc','showFiles'),
(6,'doc','tableContents'),
(6,'doc','view'),
(6,'execution','activate'),
(6,'execution','addWhitelist'),
(6,'execution','all'),
(6,'execution','batchedit'),
(6,'execution','batchUnlinkStory'),
(6,'execution','browse'),
(6,'execution','bug'),
(6,'execution','build'),
(6,'execution','burn'),
(6,'execution','burnData'),
(6,'execution','close'),
(6,'execution','computeBurn'),
(6,'execution','create'),
(6,'execution','delete'),
(6,'execution','doc'),
(6,'execution','dynamic'),
(6,'execution','edit'),
(6,'execution','executionkanban'),
(6,'execution','export'),
(6,'execution','fixFirst'),
(6,'execution','grouptask'),
(6,'execution','importBug'),
(6,'execution','importplanstories'),
(6,'execution','importtask'),
(6,'execution','index'),
(6,'execution','kanban'),
(6,'execution','linkStory'),
(6,'execution','manageMembers'),
(6,'execution','manageProducts'),
(6,'execution','printKanban'),
(6,'execution','putoff'),
(6,'execution','start'),
(6,'execution','story'),
(6,'execution','storyEstimate'),
(6,'execution','storyKanban'),
(6,'execution','storySort'),
(6,'execution','suspend'),
(6,'execution','task'),
(6,'execution','team'),
(6,'execution','testcase'),
(6,'execution','testreport'),
(6,'execution','testtask'),
(6,'execution','tree'),
(6,'execution','treeStory'),
(6,'execution','treeTask'),
(6,'execution','unbindWhitelist'),
(6,'execution','unlinkMember'),
(6,'execution','unlinkStory'),
(6,'execution','updateOrder'),
(6,'execution','view'),
(6,'execution','whitelist'),
(6,'extension','browse'),
(6,'extension','obtain'),
(6,'extension','structure'),
(6,'file','delete'),
(6,'file','download'),
(6,'file','edit'),
(6,'file','setPublic'),
(6,'file','uploadImages'),
(6,'git','apiSync'),
(6,'git','cat'),
(6,'git','diff'),
(6,'group','browse'),
(6,'index','index'),
(6,'misc','ping'),
(6,'my','bug'),
(6,'my','calendar'),
(6,'my','changePassword'),
(6,'my','contribute'),
(6,'my','deleteContacts'),
(6,'my','doc'),
(6,'my','dynamic'),
(6,'my','editProfile'),
(6,'my','execution'),
(6,'my','index'),
(6,'my','manageContacts'),
(6,'my','preference'),
(6,'my','profile'),
(6,'my','project'),
(6,'my','score'),
(6,'my','story'),
(6,'my','task'),
(6,'my','team'),
(6,'my','testcase'),
(6,'my','testtask'),
(6,'my','todo'),
(6,'my','unbind'),
(6,'my','uploadAvatar'),
(6,'my','work'),
(6,'personnel','accessible'),
(6,'personnel','invest'),
(6,'personnel','whitelist'),
(6,'product','all'),
(6,'product','browse'),
(6,'product','build'),
(6,'product','dashboard'),
(6,'product','doc'),
(6,'product','dynamic'),
(6,'product','index'),
(6,'product','kanban'),
(6,'product','manageLine'),
(6,'product','project'),
(6,'product','roadmap'),
(6,'product','view'),
(6,'product','whitelist'),
(6,'productplan','browse'),
(6,'productplan','view'),
(6,'program','index'),
(6,'program','activate'),
(6,'program','browse'),
(6,'program','close'),
(6,'program','create'),
(6,'program','delete'),
(6,'program','edit'),
(6,'program','kanban'),
(6,'program','product'),
(6,'program','project'),
(6,'program','stakeholder'),
(6,'program','start'),
(6,'program','suspend'),
(6,'program','view'),
(6,'project','activate'),
(6,'project','addWhitelist'),
(6,'project','batchEdit'),
(6,'project','browse'),
(6,'project','bug'),
(6,'project','build'),
(6,'project','close'),
(6,'project','copyGroup'),
(6,'project','create'),
(6,'project','createGroup'),
(6,'project','createGuide'),
(6,'project','delete'),
(6,'project','dynamic'),
(6,'project','edit'),
(6,'project','editGroup'),
(6,'project','execution'),
(6,'project','export'),
(6,'project','group'),
(6,'project','index'),
(6,'project','kanban'),
(6,'project','manageGroupMember'),
(6,'project','manageMembers'),
(6,'project','managePriv'),
(6,'project','manageProducts'),
(6,'project','programTitle'),
(6,'project','qa'),
(6,'project','start'),
(6,'project','suspend'),
(6,'project','team'),
(6,'project','testcase'),
(6,'project','testreport'),
(6,'project','testtask'),
(6,'project','unbindWhitelist'),
(6,'project','unlinkMember'),
(6,'project','updateOrder'),
(6,'project','view'),
(6,'project','whitelist'),
(6,'projectbuild','browse'),
(6,'projectrelease','batchUnlinkBug'),
(6,'projectrelease','batchUnlinkStory'),
(6,'projectrelease','browse'),
(6,'projectrelease','changeStatus'),
(6,'projectrelease','create'),
(6,'projectrelease','delete'),
(6,'projectrelease','edit'),
(6,'projectrelease','export'),
(6,'projectrelease','linkBug'),
(6,'projectrelease','linkStory'),
(6,'projectrelease','unlinkBug'),
(6,'projectrelease','unlinkStory'),
(6,'projectrelease','view'),
(6,'projectstory','batchUnlinkStory'),
(6,'projectstory','importplanstories'),
(6,'projectstory','linkStory'),
(6,'projectstory','story'),
(6,'projectstory','track'),
(6,'projectstory','unlinkStory'),
(6,'projectstory','view'),
(6,'qa','index'),
(6,'release','browse'),
(6,'release','export'),
(6,'release','view'),
(6,'repo','blame'),
(6,'repo','browse'),
(6,'repo','diff'),
(6,'repo','download'),
(6,'repo','log'),
(6,'repo','revision'),
(6,'repo','showSyncCommit'),
(6,'repo','view'),
(6,'report','bugAssign'),
(6,'report','bugCreate'),
(6,'report','index'),
(6,'report','productSummary'),
(6,'report','projectDeviation'),
(6,'report','workload'),
(6,'search','buildForm'),
(6,'search','buildQuery'),
(6,'search','deleteQuery'),
(6,'search','index'),
(6,'search','saveQuery'),
(6,'search','select'),
(6,'stakeholder','browse'),
(6,'stakeholder','communicate'),
(6,'stakeholder','createExpect'),
(6,'stakeholder','deleteExpect'),
(6,'stakeholder','editExpect'),
(6,'stakeholder','expect'),
(6,'stakeholder','expectation'),
(6,'stakeholder','issue'),
(6,'stakeholder','userIssue'),
(6,'stakeholder','view'),
(6,'stakeholder','viewExpect'),
(6,'stakeholder','viewIssue'),
(6,'story','batchToTask'),
(6,'story','bugs'),
(6,'story','cases'),
(6,'story','export'),
(6,'story','processStoryChange'),
(6,'story','report'),
(6,'story','tasks'),
(6,'story','track'),
(6,'story','view'),
(6,'story','zeroCase'),
(6,'svn','apiSync'),
(6,'svn','cat'),
(6,'svn','diff'),
(6,'task','activate'),
(6,'task','assignTo'),
(6,'task','batchAssignTo'),
(6,'task','batchCancel'),
(6,'task','batchChangeModule'),
(6,'task','batchClose'),
(6,'task','batchCreate'),
(6,'task','batchEdit'),
(6,'task','cancel'),
(6,'task','close'),
(6,'task','confirmStoryChange'),
(6,'task','create'),
(6,'task','delete'),
(6,'task','deleteEstimate'),
(6,'task','edit'),
(6,'task','editEstimate'),
(6,'task','export'),
(6,'task','finish'),
(6,'task','pause'),
(6,'task','recordEstimate'),
(6,'task','report'),
(6,'task','restart'),
(6,'task','start'),
(6,'task','view'),
(6,'testcase','browse'),
(6,'testcase','bugs'),
(6,'testcase','export'),
(6,'testcase','groupCase'),
(6,'testcase','index'),
(6,'testcase','view'),
(6,'testreport','browse'),
(6,'testreport','create'),
(6,'testreport','delete'),
(6,'testreport','edit'),
(6,'testreport','view'),
(6,'testsuite','browse'),
(6,'testsuite','index'),
(6,'testsuite','view'),
(6,'testtask','activate'),
(6,'testtask','batchAssign'),
(6,'testtask','batchRun'),
(6,'testtask','batchUnlinkCases'),
(6,'testtask','block'),
(6,'testtask','browse'),
(6,'testtask','browseUnits'),
(6,'testtask','cases'),
(6,'testtask','close'),
(6,'testtask','create'),
(6,'testtask','delete'),
(6,'testtask','edit'),
(6,'testtask','groupCase'),
(6,'testtask','importUnitResult'),
(6,'testtask','index'),
(6,'testtask','linkcase'),
(6,'testtask','report'),
(6,'testtask','results'),
(6,'testtask','runcase'),
(6,'testtask','start'),
(6,'testtask','unitCases'),
(6,'testtask','unlinkcase'),
(6,'testtask','view'),
(6,'todo','activate'),
(6,'todo','assignTo'),
(6,'todo','batchClose'),
(6,'todo','batchCreate'),
(6,'todo','batchEdit'),
(6,'todo','batchFinish'),
(6,'todo','close'),
(6,'todo','create'),
(6,'todo','createcycle'),
(6,'todo','delete'),
(6,'todo','edit'),
(6,'todo','export'),
(6,'todo','finish'),
(6,'todo','import2Today'),
(6,'todo','start'),
(6,'todo','view'),
(6,'tree','browse'),
(6,'tree','browseTask'),
(6,'tree','delete'),
(6,'tree','edit'),
(6,'tree','fix'),
(6,'tree','manageChild'),
(6,'tree','updateOrder'),
(6,'user','bug'),
(6,'user','cropAvatar'),
(6,'user','dynamic'),
(6,'user','execution'),
(6,'user','issue'),
(6,'user','profile'),
(6,'user','risk'),
(6,'user','setPublicTemplate'),
(6,'user','story'),
(6,'user','task'),
(6,'user','testCase'),
(6,'user','testTask'),
(6,'user','todo'),
(6,'user','view'),
(7,'action','comment'),
(7,'action','editComment'),
(7,'action','hideAll'),
(7,'action','hideOne'),
(7,'action','trash'),
(7,'action','undelete'),
(7,'admin','index'),
(7,'admin','checkWeak'),
(7,'admin','safe'),
(7,'automation','browse'),
(7,'branch','delete'),
(7,'branch','manage'),
(7,'branch','sort'),
(7,'bug','activate'),
(7,'bug','assignTo'),
(7,'bug','batchActivate'),
(7,'bug','batchAssignTo'),
(7,'bug','batchChangeBranch'),
(7,'bug','batchChangeModule'),
(7,'bug','batchClose'),
(7,'bug','batchConfirm'),
(7,'bug','batchCreate'),
(7,'bug','batchEdit'),
(7,'bug','batchResolve'),
(7,'bug','browse'),
(7,'bug','close'),
(7,'bug','confirmBug'),
(7,'bug','confirmStoryChange'),
(7,'bug','create'),
(7,'bug','delete'),
(7,'bug','edit'),
(7,'bug','export'),
(7,'bug','index'),
(7,'bug','linkBugs'),
(7,'bug','report'),
(7,'bug','resolve'),
(7,'bug','view'),
(7,'build','create'),
(7,'build','delete'),
(7,'build','edit'),
(7,'build','view'),
(7,'company','browse'),
(7,'company','dynamic'),
(7,'company','index'),
(7,'company','view'),
(7,'datatable','setGlobal'),
(7,'doc','allLibs'),
(7,'doc','browse'),
(7,'doc','collect'),
(7,'doc','create'),
(7,'doc','createLib'),
(7,'doc','delete'),
(7,'doc','deleteFile'),
(7,'doc','deleteLib'),
(7,'doc','edit'),
(7,'doc','editLib'),
(7,'doc','index'),
(7,'doc','objectLibs'),
(7,'doc','showFiles'),
(7,'doc','tableContents'),
(7,'doc','view'),
(7,'execution','all'),
(7,'execution','browse'),
(7,'execution','bug'),
(7,'execution','build'),
(7,'execution','burn'),
(7,'execution','doc'),
(7,'execution','dynamic'),
(7,'execution','grouptask'),
(7,'execution','index'),
(7,'execution','kanban'),
(7,'execution','linkStory'),
(7,'execution','manageProducts'),
(7,'execution','story'),
(7,'execution','storyKanban'),
(7,'execution','storySort'),
(7,'execution','task'),
(7,'execution','team'),
(7,'execution','testtask'),
(7,'execution','tree'),
(7,'execution','treeStory'),
(7,'execution','treeTask'),
(7,'execution','unlinkStory'),
(7,'execution','view'),
(7,'extension','browse'),
(7,'extension','obtain'),
(7,'extension','structure'),
(7,'file','delete'),
(7,'file','download'),
(7,'file','edit'),
(7,'file','setPublic'),
(7,'file','uploadImages'),
(7,'git','apiSync'),
(7,'git','cat'),
(7,'git','diff'),
(7,'group','browse'),
(7,'index','index'),
(7,'misc','ping'),
(7,'my','bug'),
(7,'my','calendar'),
(7,'my','changePassword'),
(7,'my','contribute'),
(7,'my','deleteContacts'),
(7,'my','doc'),
(7,'my','dynamic'),
(7,'my','editProfile'),
(7,'my','execution'),
(7,'my','index'),
(7,'my','manageContacts'),
(7,'my','preference'),
(7,'my','profile'),
(7,'my','project'),
(7,'my','score'),
(7,'my','story'),
(7,'my','task'),
(7,'my','team'),
(7,'my','testcase'),
(7,'my','testtask'),
(7,'my','todo'),
(7,'my','unbind'),
(7,'my','uploadAvatar'),
(7,'my','work'),
(7,'personnel','accessible'),
(7,'personnel','addWhitelist'),
(7,'personnel','invest'),
(7,'personnel','unbindWhitelist'),
(7,'personnel','whitelist'),
(7,'product','addWhitelist'),
(7,'product','all'),
(7,'product','batchEdit'),
(7,'product','browse'),
(7,'product','build'),
(7,'product','close'),
(7,'product','create'),
(7,'product','dashboard'),
(7,'product','delete'),
(7,'product','doc'),
(7,'product','dynamic'),
(7,'product','edit'),
(7,'product','export'),
(7,'product','index'),
(7,'product','kanban'),
(7,'product','manageLine'),
(7,'product','project'),
(7,'product','roadmap'),
(7,'product','unbindWhitelist'),
(7,'product','updateOrder'),
(7,'product','view'),
(7,'product','whitelist'),
(7,'productplan','batchEdit'),
(7,'productplan','batchUnlinkBug'),
(7,'productplan','batchUnlinkStory'),
(7,'productplan','browse'),
(7,'productplan','create'),
(7,'productplan','delete'),
(7,'productplan','edit'),
(7,'productplan','linkBug'),
(7,'productplan','linkStory'),
(7,'productplan','unlinkBug'),
(7,'productplan','unlinkStory'),
(7,'productplan','view'),
(7,'program','index'),
(7,'program','activate'),
(7,'program','batchUnlinkStakeholders'),
(7,'program','browse'),
(7,'program','close'),
(7,'program','create'),
(7,'program','createStakeholder'),
(7,'program','delete'),
(7,'program','edit'),
(7,'program','export'),
(7,'program','kanban'),
(7,'program','product'),
(7,'program','project'),
(7,'program','stakeholder'),
(7,'program','start'),
(7,'program','suspend'),
(7,'program','unbindWhitelist'),
(7,'program','unlinkStakeholder'),
(7,'program','updateOrder'),
(7,'program','view'),
(7,'project','activate'),
(7,'project','addWhitelist'),
(7,'project','batchEdit'),
(7,'project','browse'),
(7,'project','bug'),
(7,'project','build'),
(7,'project','close'),
(7,'project','copyGroup'),
(7,'project','create'),
(7,'project','createGroup'),
(7,'project','createGuide'),
(7,'project','delete'),
(7,'project','dynamic'),
(7,'project','edit'),
(7,'project','editGroup'),
(7,'project','execution'),
(7,'project','export'),
(7,'project','group'),
(7,'project','index'),
(7,'project','kanban'),
(7,'project','manageGroupMember'),
(7,'project','manageMembers'),
(7,'project','managePriv'),
(7,'project','manageProducts'),
(7,'project','programTitle'),
(7,'project','qa'),
(7,'project','start'),
(7,'project','suspend'),
(7,'project','team'),
(7,'project','testcase'),
(7,'project','testreport'),
(7,'project','testtask'),
(7,'project','unbindWhitelist'),
(7,'project','updateOrder'),
(7,'project','view'),
(7,'project','whitelist'),
(7,'projectbuild','browse'),
(7,'projectrelease','browse'),
(7,'projectrelease','export'),
(7,'projectrelease','view'),
(7,'projectstory','linkStory'),
(7,'projectstory','story'),
(7,'projectstory','track'),
(7,'projectstory','view'),
(7,'qa','index'),
(7,'release','batchUnlinkBug'),
(7,'release','batchUnlinkStory'),
(7,'release','browse'),
(7,'release','changeStatus'),
(7,'release','create'),
(7,'release','delete'),
(7,'release','edit'),
(7,'release','export'),
(7,'release','linkBug'),
(7,'release','linkStory'),
(7,'release','unlinkBug'),
(7,'release','unlinkStory'),
(7,'release','view'),
(7,'repo','blame'),
(7,'repo','browse'),
(7,'repo','diff'),
(7,'repo','download'),
(7,'repo','log'),
(7,'repo','revision'),
(7,'repo','showSyncCommit'),
(7,'repo','view'),
(7,'report','bugAssign'),
(7,'report','bugCreate'),
(7,'report','index'),
(7,'report','productSummary'),
(7,'report','projectDeviation'),
(7,'report','workload'),
(7,'search','buildForm'),
(7,'search','buildQuery'),
(7,'search','deleteQuery'),
(7,'search','index'),
(7,'search','saveQuery'),
(7,'search','select'),
(7,'stakeholder','batchCreate'),
(7,'stakeholder','browse'),
(7,'stakeholder','communicate'),
(7,'stakeholder','create'),
(7,'stakeholder','createExpect'),
(7,'stakeholder','delete'),
(7,'stakeholder','deleteExpect'),
(7,'stakeholder','edit'),
(7,'stakeholder','editExpect'),
(7,'stakeholder','expect'),
(7,'stakeholder','expectation'),
(7,'stakeholder','issue'),
(7,'stakeholder','userIssue'),
(7,'stakeholder','view'),
(7,'stakeholder','viewExpect'),
(7,'stakeholder','viewIssue'),
(7,'story','activate'),
(7,'story','assignTo'),
(7,'story','batchAssignTo'),
(7,'story','batchChangeBranch'),
(7,'story','batchChangeModule'),
(7,'story','batchChangePlan'),
(7,'story','batchChangeStage'),
(7,'story','batchClose'),
(7,'story','batchCreate'),
(7,'story','batchEdit'),
(7,'story','batchReview'),
(7,'story','bugs'),
(7,'story','cases'),
(7,'story','change'),
(7,'story','close'),
(7,'story','create'),
(7,'story','delete'),
(7,'story','edit'),
(7,'story','export'),
(7,'story','linkStory'),
(7,'story','processStoryChange'),
(7,'story','recall'),
(7,'story','report'),
(7,'story','review'),
(7,'story','tasks'),
(7,'story','track'),
(7,'story','view'),
(7,'story','zeroCase'),
(7,'svn','apiSync'),
(7,'svn','cat'),
(7,'svn','diff'),
(7,'task','activate'),
(7,'task','assignTo'),
(7,'task','batchAssignTo'),
(7,'task','batchChangeModule'),
(7,'task','batchClose'),
(7,'task','batchCreate'),
(7,'task','batchEdit'),
(7,'task','cancel'),
(7,'task','close'),
(7,'task','create'),
(7,'task','confirmStoryChange'),
(7,'task','deleteEstimate'),
(7,'task','edit'),
(7,'task','editEstimate'),
(7,'task','export'),
(7,'task','finish'),
(7,'task','pause'),
(7,'task','recordEstimate'),
(7,'task','report'),
(7,'task','restart'),
(7,'task','start'),
(7,'task','view'),
(7,'testcase','browse'),
(7,'testcase','bugs'),
(7,'testcase','createBug'),
(7,'testcase','export'),
(7,'testcase','groupCase'),
(7,'testcase','importFromLib'),
(7,'testcase','index'),
(7,'testcase','view'),
(7,'testreport','browse'),
(7,'testreport','export'),
(7,'testreport','view'),
(7,'testsuite','browse'),
(7,'testsuite','index'),
(7,'testsuite','view'),
(7,'testtask','browse'),
(7,'testtask','cases'),
(7,'testtask','create'),
(7,'testtask','edit'),
(7,'testtask','groupCase'),
(7,'testtask','index'),
(7,'testtask','results'),
(7,'testtask','view'),
(7,'todo','activate'),
(7,'todo','assignTo'),
(7,'todo','batchClose'),
(7,'todo','batchCreate'),
(7,'todo','batchEdit'),
(7,'todo','batchFinish'),
(7,'todo','close'),
(7,'todo','create'),
(7,'todo','createcycle'),
(7,'todo','delete'),
(7,'todo','edit'),
(7,'todo','export'),
(7,'todo','finish'),
(7,'todo','import2Today'),
(7,'todo','start'),
(7,'todo','view'),
(7,'tree','browse'),
(7,'tree','browseTask'),
(7,'tree','delete'),
(7,'tree','edit'),
(7,'tree','fix'),
(7,'tree','manageChild'),
(7,'tree','updateOrder'),
(7,'user','bug'),
(7,'user','cropAvatar'),
(7,'user','dynamic'),
(7,'user','execution'),
(7,'user','issue'),
(7,'user','profile'),
(7,'user','risk'),
(7,'user','setPublicTemplate'),
(7,'user','story'),
(7,'user','task'),
(7,'user','testCase'),
(7,'user','testTask'),
(7,'user','todo'),
(7,'user','view'),
(8,'action','comment'),
(8,'action','editComment'),
(8,'action','hideAll'),
(8,'action','hideOne'),
(8,'action','trash'),
(8,'action','undelete'),
(8,'admin','index'),
(8,'admin','checkWeak'),
(8,'admin','safe'),
(8,'automation','browse'),
(8,'bug','activate'),
(8,'bug','assignTo'),
(8,'bug','batchActivate'),
(8,'bug','batchAssignTo'),
(8,'bug','batchChangeBranch'),
(8,'bug','batchChangeModule'),
(8,'bug','batchClose'),
(8,'bug','batchConfirm'),
(8,'bug','batchCreate'),
(8,'bug','batchEdit'),
(8,'bug','batchResolve'),
(8,'bug','browse'),
(8,'bug','close'),
(8,'bug','confirmBug'),
(8,'bug','confirmStoryChange'),
(8,'bug','create'),
(8,'bug','delete'),
(8,'bug','edit'),
(8,'bug','export'),
(8,'bug','index'),
(8,'bug','linkBugs'),
(8,'bug','report'),
(8,'bug','resolve'),
(8,'bug','view'),
(8,'build','create'),
(8,'build','delete'),
(8,'build','edit'),
(8,'build','view'),
(8,'caselib','batchCreateCase'),
(8,'caselib','browse'),
(8,'caselib','create'),
(8,'caselib','createCase'),
(8,'caselib','delete'),
(8,'caselib','edit'),
(8,'caselib','exportTemplet'),
(8,'caselib','import'),
(8,'caselib','index'),
(8,'caselib','showImport'),
(8,'caselib','view'),
(8,'ci','checkCompileStatus'),
(8,'ci','commitResult'),
(8,'company','browse'),
(8,'company','dynamic'),
(8,'company','index'),
(8,'company','view'),
(8,'compile','browse'),
(8,'compile','logs'),
(8,'custom','index'),
(8,'datatable','setGlobal'),
(8,'doc','allLibs'),
(8,'doc','browse'),
(8,'doc','collect'),
(8,'doc','create'),
(8,'doc','createLib'),
(8,'doc','delete'),
(8,'doc','deleteFile'),
(8,'doc','deleteLib'),
(8,'doc','edit'),
(8,'doc','editLib'),
(8,'doc','index'),
(8,'doc','objectLibs'),
(8,'doc','showFiles'),
(8,'doc','tableContents'),
(8,'doc','view'),
(8,'execution','all'),
(8,'execution','browse'),
(8,'execution','bug'),
(8,'execution','build'),
(8,'execution','burn'),
(8,'execution','burnData'),
(8,'execution','computeBurn'),
(8,'execution','doc'),
(8,'execution','dynamic'),
(8,'execution','executionkanban'),
(8,'execution','grouptask'),
(8,'execution','importBug'),
(8,'execution','importtask'),
(8,'execution','index'),
(8,'execution','kanban'),
(8,'execution','story'),
(8,'execution','storyKanban'),
(8,'execution','task'),
(8,'execution','team'),
(8,'execution','testcase'),
(8,'execution','testreport'),
(8,'execution','testtask'),
(8,'execution','tree'),
(8,'execution','treeStory'),
(8,'execution','treeTask'),
(8,'execution','view'),
(8,'execution','whitelist'),
(8,'extension','browse'),
(8,'extension','obtain'),
(8,'extension','structure'),
(8,'file','delete'),
(8,'file','download'),
(8,'file','edit'),
(8,'file','setPublic'),
(8,'file','uploadImages'),
(8,'git','apiSync'),
(8,'git','cat'),
(8,'git','diff'),
(8,'gitlab','bindProduct'),
(8,'gitlab','bindUser'),
(8,'gitlab','browse'),
(8,'gitlab','create'),
(8,'gitlab','delete'),
(8,'gitlab','edit'),
(8,'gitlab','importIssue'),
(8,'group','browse'),
(8,'index','index'),
(8,'jenkins','browse'),
(8,'jenkins','create'),
(8,'jenkins','delete'),
(8,'jenkins','edit'),
(8,'job','browse'),
(8,'job','create'),
(8,'job','delete'),
(8,'job','edit'),
(8,'job','exec'),
(8,'job','view'),
(8,'misc','ping'),
(8,'my','bug'),
(8,'my','calendar'),
(8,'my','changePassword'),
(8,'my','contribute'),
(8,'my','deleteContacts'),
(8,'my','doc'),
(8,'my','dynamic'),
(8,'my','editProfile'),
(8,'my','execution'),
(8,'my','index'),
(8,'my','manageContacts'),
(8,'my','preference'),
(8,'my','profile'),
(8,'my','project'),
(8,'my','score'),
(8,'my','story'),
(8,'my','task'),
(8,'my','team'),
(8,'my','testcase'),
(8,'my','testtask'),
(8,'my','todo'),
(8,'my','unbind'),
(8,'my','uploadAvatar'),
(8,'my','work'),
(8,'product','all'),
(8,'product','browse'),
(8,'product','build'),
(8,'product','dashboard'),
(8,'product','doc'),
(8,'product','dynamic'),
(8,'product','index'),
(8,'product','kanban'),
(8,'product','manageLine'),
(8,'product','project'),
(8,'product','roadmap'),
(8,'product','view'),
(8,'product','whitelist'),
(8,'productplan','browse'),
(8,'productplan','view'),
(8,'program','index'),
(8,'program','activate'),
(8,'program','browse'),
(8,'program','close'),
(8,'program','create'),
(8,'program','delete'),
(8,'program','edit'),
(8,'program','kanban'),
(8,'program','product'),
(8,'program','project'),
(8,'program','stakeholder'),
(8,'program','start'),
(8,'program','suspend'),
(8,'program','view'),
(8,'project','activate'),
(8,'project','addWhitelist'),
(8,'project','batchEdit'),
(8,'project','browse'),
(8,'project','bug'),
(8,'project','build'),
(8,'project','close'),
(8,'project','copyGroup'),
(8,'project','create'),
(8,'project','createGroup'),
(8,'project','createGuide'),
(8,'project','delete'),
(8,'project','dynamic'),
(8,'project','edit'),
(8,'project','editGroup'),
(8,'project','execution'),
(8,'project','export'),
(8,'project','group'),
(8,'project','index'),
(8,'project','kanban'),
(8,'project','manageGroupMember'),
(8,'project','manageMembers'),
(8,'project','managePriv'),
(8,'project','manageProducts'),
(8,'project','programTitle'),
(8,'project','qa'),
(8,'project','start'),
(8,'project','suspend'),
(8,'project','team'),
(8,'project','testcase'),
(8,'project','testreport'),
(8,'project','testtask'),
(8,'project','unbindWhitelist'),
(8,'project','updateOrder'),
(8,'project','view'),
(8,'project','whitelist'),
(8,'projectbuild','browse'),
(8,'projectrelease','browse'),
(8,'projectstory','story'),
(8,'projectstory','track'),
(8,'projectstory','view'),
(8,'qa','index'),
(8,'release','browse'),
(8,'release','export'),
(8,'release','view'),
(8,'repo','blame'),
(8,'repo','browse'),
(8,'repo','diff'),
(8,'repo','download'),
(8,'repo','log'),
(8,'repo','revision'),
(8,'repo','showSyncCommit'),
(8,'repo','view'),
(8,'report','bugAssign'),
(8,'report','bugCreate'),
(8,'report','index'),
(8,'report','productSummary'),
(8,'report','projectDeviation'),
(8,'report','workload'),
(8,'search','buildForm'),
(8,'search','buildQuery'),
(8,'search','deleteQuery'),
(8,'search','index'),
(8,'search','saveQuery'),
(8,'search','select'),
(8,'story','batchToTask'),
(8,'story','bugs'),
(8,'story','cases'),
(8,'story','export'),
(8,'story','processStoryChange'),
(8,'story','report'),
(8,'story','tasks'),
(8,'story','track'),
(8,'story','view'),
(8,'story','zeroCase'),
(8,'svn','apiSync'),
(8,'svn','cat'),
(8,'svn','diff'),
(8,'task','activate'),
(8,'task','assignTo'),
(8,'task','batchAssignTo'),
(8,'task','batchChangeModule'),
(8,'task','batchClose'),
(8,'task','batchCreate'),
(8,'task','batchEdit'),
(8,'task','cancel'),
(8,'task','close'),
(8,'task','confirmStoryChange'),
(8,'task','create'),
(8,'task','delete'),
(8,'task','deleteEstimate'),
(8,'task','edit'),
(8,'task','editEstimate'),
(8,'task','export'),
(8,'task','finish'),
(8,'task','pause'),
(8,'task','recordEstimate'),
(8,'task','report'),
(8,'task','restart'),
(8,'task','start'),
(8,'task','view'),
(8,'testcase','batchCaseTypeChange'),
(8,'testcase','batchChangeBranch'),
(8,'testcase','batchChangeModule'),
(8,'testcase','batchConfirmStoryChange'),
(8,'testcase','batchCreate'),
(8,'testcase','batchDelete'),
(8,'testcase','batchEdit'),
(8,'testcase','batchReview'),
(8,'testcase','browse'),
(8,'testcase','bugs'),
(8,'testcase','confirmChange'),
(8,'testcase','confirmLibcaseChange'),
(8,'testcase','confirmStoryChange'),
(8,'testcase','create'),
(8,'testcase','createBug'),
(8,'testcase','delete'),
(8,'testcase','edit'),
(8,'testcase','export'),
(8,'testcase','exportTemplet'),
(8,'testcase','groupCase'),
(8,'testcase','ignoreLibcaseChange'),
(8,'testcase','import'),
(8,'testcase','importFromLib'),
(8,'testcase','index'),
(8,'testcase','linkCases'),
(8,'testcase','review'),
(8,'testcase','showImport'),
(8,'testcase','view'),
(8,'testreport','browse'),
(8,'testreport','create'),
(8,'testreport','delete'),
(8,'testreport','edit'),
(8,'testreport','view'),
(8,'testsuite','batchUnlinkCases'),
(8,'testsuite','browse'),
(8,'testsuite','create'),
(8,'testsuite','delete'),
(8,'testsuite','edit'),
(8,'testsuite','index'),
(8,'testsuite','linkCase'),
(8,'testsuite','unlinkCase'),
(8,'testsuite','view'),
(8,'testtask','activate'),
(8,'testtask','batchAssign'),
(8,'testtask','batchRun'),
(8,'testtask','batchUnlinkCases'),
(8,'testtask','block'),
(8,'testtask','browse'),
(8,'testtask','browseUnits'),
(8,'testtask','cases'),
(8,'testtask','close'),
(8,'testtask','create'),
(8,'testtask','delete'),
(8,'testtask','edit'),
(8,'testtask','groupCase'),
(8,'testtask','importUnitResult'),
(8,'testtask','index'),
(8,'testtask','linkcase'),
(8,'testtask','report'),
(8,'testtask','results'),
(8,'testtask','runcase'),
(8,'testtask','start'),
(8,'testtask','unitCases'),
(8,'testtask','unlinkcase'),
(8,'testtask','view'),
(8,'todo','activate'),
(8,'todo','assignTo'),
(8,'todo','batchClose'),
(8,'todo','batchCreate'),
(8,'todo','batchEdit'),
(8,'todo','batchFinish'),
(8,'todo','close'),
(8,'todo','create'),
(8,'todo','createcycle'),
(8,'todo','delete'),
(8,'todo','edit'),
(8,'todo','export'),
(8,'todo','finish'),
(8,'todo','import2Today'),
(8,'todo','start'),
(8,'todo','view'),
(8,'tree','browse'),
(8,'tree','browseTask'),
(8,'tree','delete'),
(8,'tree','edit'),
(8,'tree','fix'),
(8,'tree','manageChild'),
(8,'tree','updateOrder'),
(8,'user','bug'),
(8,'user','cropAvatar'),
(8,'user','dynamic'),
(8,'user','execution'),
(8,'user','issue'),
(8,'user','profile'),
(8,'user','risk'),
(8,'user','setPublicTemplate'),
(8,'user','story'),
(8,'user','task'),
(8,'user','testCase'),
(8,'user','testTask'),
(8,'user','todo'),
(8,'user','view'),
(9,'action','comment'),
(9,'action','editComment'),
(9,'action','hideAll'),
(9,'action','hideOne'),
(9,'action','trash'),
(9,'action','undelete'),
(9,'admin','index'),
(9,'bug','activate'),
(9,'bug','assignTo'),
(9,'bug','batchActivate'),
(9,'bug','batchAssignTo'),
(9,'bug','batchChangeBranch'),
(9,'bug','batchChangeModule'),
(9,'bug','batchClose'),
(9,'bug','batchConfirm'),
(9,'bug','batchCreate'),
(9,'bug','batchEdit'),
(9,'bug','batchResolve'),
(9,'bug','browse'),
(9,'bug','close'),
(9,'bug','confirmBug'),
(9,'bug','confirmStoryChange'),
(9,'bug','create'),
(9,'bug','delete'),
(9,'bug','edit'),
(9,'bug','export'),
(9,'bug','index'),
(9,'bug','linkBugs'),
(9,'bug','report'),
(9,'bug','resolve'),
(9,'bug','view'),
(9,'build','create'),
(9,'build','delete'),
(9,'build','edit'),
(9,'build','view'),
(9,'company','browse'),
(9,'company','dynamic'),
(9,'company','edit'),
(9,'company','index'),
(9,'company','view'),
(9,'custom','index'),
(9,'custom','restore'),
(9,'custom','setPublic'),
(9,'datatable','setGlobal'),
(9,'dept','browse'),
(9,'dept','delete'),
(9,'dept','manageChild'),
(9,'dept','updateOrder'),
(9,'doc','allLibs'),
(9,'doc','browse'),
(9,'doc','collect'),
(9,'doc','create'),
(9,'doc','createLib'),
(9,'doc','delete'),
(9,'doc','deleteFile'),
(9,'doc','deleteLib'),
(9,'doc','edit'),
(9,'doc','editLib'),
(9,'doc','index'),
(9,'doc','objectLibs'),
(9,'doc','showFiles'),
(9,'doc','tableContents'),
(9,'doc','view'),
(9,'execution','all'),
(9,'execution','browse'),
(9,'execution','bug'),
(9,'execution','build'),
(9,'execution','burn'),
(9,'execution','burnData'),
(9,'execution','computeBurn'),
(9,'execution','doc'),
(9,'execution','dynamic'),
(9,'execution','executionkanban'),
(9,'execution','grouptask'),
(9,'execution','index'),
(9,'execution','importBug'),
(9,'execution','importtask'),
(9,'execution','kanban'),
(9,'execution','manageMembers'),
(9,'execution','story'),
(9,'execution','storyKanban'),
(9,'execution','storySort'),
(9,'execution','task'),
(9,'execution','team'),
(9,'execution','testcase'),
(9,'execution','testreport'),
(9,'execution','testtask'),
(9,'execution','tree'),
(9,'execution','treeStory'),
(9,'execution','treeTask'),
(9,'execution','updateOrder'),
(9,'execution','view'),
(9,'execution','whitelist'),
(9,'extension','browse'),
(9,'extension','obtain'),
(9,'extension','structure'),
(9,'file','delete'),
(9,'file','download'),
(9,'file','edit'),
(9,'file','setPublic'),
(9,'file','uploadImages'),
(9,'git','apiSync'),
(9,'git','cat'),
(9,'git','diff'),
(9,'group','browse'),
(9,'index','index'),
(9,'misc','ping'),
(9,'my','bug'),
(9,'my','calendar'),
(9,'my','changePassword'),
(9,'my','contribute'),
(9,'my','deleteContacts'),
(9,'my','doc'),
(9,'my','dynamic'),
(9,'my','editProfile'),
(9,'my','execution'),
(9,'my','index'),
(9,'my','manageContacts'),
(9,'my','preference'),
(9,'my','profile'),
(9,'my','project'),
(9,'my','score'),
(9,'my','story'),
(9,'my','task'),
(9,'my','team'),
(9,'my','testcase'),
(9,'my','testtask'),
(9,'my','todo'),
(9,'my','unbind'),
(9,'my','uploadAvatar'),
(9,'my','work'),
(9,'personnel','accessible'),
(9,'personnel','invest'),
(9,'personnel','whitelist'),
(9,'product','all'),
(9,'product','browse'),
(9,'product','build'),
(9,'product','dashboard'),
(9,'product','doc'),
(9,'product','dynamic'),
(9,'product','index'),
(9,'product','kanban'),
(9,'product','manageLine'),
(9,'product','project'),
(9,'product','roadmap'),
(9,'product','view'),
(9,'product','whitelist'),
(9,'productplan','browse'),
(9,'productplan','view'),
(9,'program','index'),
(9,'program','activate'),
(9,'program','browse'),
(9,'program','close'),
(9,'program','create'),
(9,'program','delete'),
(9,'program','edit'),
(9,'program','kanban'),
(9,'program','product'),
(9,'program','project'),
(9,'program','stakeholder'),
(9,'program','start'),
(9,'program','suspend'),
(9,'program','view'),
(9,'project','activate'),
(9,'project','addWhitelist'),
(9,'project','batchEdit'),
(9,'project','browse'),
(9,'project','bug'),
(9,'project','build'),
(9,'project','close'),
(9,'project','copyGroup'),
(9,'project','create'),
(9,'project','createGroup'),
(9,'project','createGuide'),
(9,'project','delete'),
(9,'project','dynamic'),
(9,'project','edit'),
(9,'project','editGroup'),
(9,'project','execution'),
(9,'project','export'),
(9,'project','group'),
(9,'project','index'),
(9,'project','kanban'),
(9,'project','manageGroupMember'),
(9,'project','manageMembers'),
(9,'project','managePriv'),
(9,'project','manageProducts'),
(9,'project','programTitle'),
(9,'project','qa'),
(9,'project','start'),
(9,'project','suspend'),
(9,'project','team'),
(9,'project','testcase'),
(9,'project','testreport'),
(9,'project','testtask'),
(9,'project','unbindWhitelist'),
(9,'project','unlinkMember'),
(9,'project','updateOrder'),
(9,'project','view'),
(9,'project','whitelist'),
(9,'projectbuild','browse'),
(9,'projectrelease','browse'),
(9,'projectrelease','view'),
(9,'projectstory','story'),
(9,'projectstory','track'),
(9,'projectstory','view'),
(9,'qa','index'),
(9,'release','browse'),
(9,'release','export'),
(9,'release','view'),
(9,'repo','blame'),
(9,'repo','browse'),
(9,'repo','diff'),
(9,'repo','download'),
(9,'repo','log'),
(9,'repo','revision'),
(9,'repo','showSyncCommit'),
(9,'repo','view'),
(9,'report','bugAssign'),
(9,'report','bugCreate'),
(9,'report','index'),
(9,'report','productSummary'),
(9,'report','projectDeviation'),
(9,'report','workload'),
(9,'search','buildForm'),
(9,'search','buildQuery'),
(9,'search','deleteQuery'),
(9,'search','index'),
(9,'search','saveQuery'),
(9,'search','select'),
(9,'stakeholder','batchCreate'),
(9,'stakeholder','browse'),
(9,'stakeholder','communicate'),
(9,'stakeholder','create'),
(9,'stakeholder','createExpect'),
(9,'stakeholder','delete'),
(9,'stakeholder','deleteExpect'),
(9,'stakeholder','edit'),
(9,'stakeholder','editExpect'),
(9,'stakeholder','expect'),
(9,'stakeholder','expectation'),
(9,'stakeholder','issue'),
(9,'stakeholder','plan'),
(9,'stakeholder','userIssue'),
(9,'stakeholder','view'),
(9,'stakeholder','viewExpect'),
(9,'stakeholder','viewIssue'),
(9,'story','bugs'),
(9,'story','cases'),
(9,'story','export'),
(9,'story','processStoryChange'),
(9,'story','report'),
(9,'story','review'),
(9,'story','tasks'),
(9,'story','track'),
(9,'story','view'),
(9,'story','zeroCase'),
(9,'svn','apiSync'),
(9,'svn','cat'),
(9,'svn','diff'),
(9,'task','activate'),
(9,'task','assignTo'),
(9,'task','batchAssignTo'),
(9,'task','batchCancel'),
(9,'task','batchChangeModule'),
(9,'task','batchClose'),
(9,'task','batchCreate'),
(9,'task','batchEdit'),
(9,'task','cancel'),
(9,'task','close'),
(9,'task','confirmStoryChange'),
(9,'task','create'),
(9,'task','delete'),
(9,'task','deleteEstimate'),
(9,'task','edit'),
(9,'task','editEstimate'),
(9,'task','export'),
(9,'task','finish'),
(9,'task','pause'),
(9,'task','recordEstimate'),
(9,'task','report'),
(9,'task','restart'),
(9,'task','start'),
(9,'task','view'),
(9,'testcase','browse'),
(9,'testcase','bugs'),
(9,'testcase','export'),
(9,'testcase','groupCase'),
(9,'testcase','index'),
(9,'testcase','view'),
(9,'testreport','browse'),
(9,'testreport','create'),
(9,'testreport','delete'),
(9,'testreport','edit'),
(9,'testreport','view'),
(9,'testsuite','browse'),
(9,'testsuite','index'),
(9,'testsuite','view'),
(9,'testtask','browse'),
(9,'testtask','cases'),
(9,'testtask','create'),
(9,'testtask','edit'),
(9,'testtask','groupCase'),
(9,'testtask','index'),
(9,'testtask','results'),
(9,'testtask','view'),
(9,'todo','activate'),
(9,'todo','assignTo'),
(9,'todo','batchClose'),
(9,'todo','batchCreate'),
(9,'todo','batchEdit'),
(9,'todo','batchFinish'),
(9,'todo','close'),
(9,'todo','create'),
(9,'todo','createcycle'),
(9,'todo','delete'),
(9,'todo','edit'),
(9,'todo','export'),
(9,'todo','finish'),
(9,'todo','import2Today'),
(9,'todo','start'),
(9,'todo','view'),
(9,'user','batchCreate'),
(9,'user','batchEdit'),
(9,'user','bug'),
(9,'user','create'),
(9,'user','cropAvatar'),
(9,'user','delete'),
(9,'user','dynamic'),
(9,'user','edit'),
(9,'user','execution'),
(9,'user','issue'),
(9,'user','profile'),
(9,'user','risk'),
(9,'user','story'),
(9,'user','task'),
(9,'user','testCase'),
(9,'user','testTask'),
(9,'user','todo'),
(9,'user','unbind'),
(9,'user','unlock'),
(9,'user','view'),
(10,'action','editComment'),
(10,'bug','activate'),
(10,'bug','assignTo'),
(10,'bug','batchActivate'),
(10,'bug','batchAssignTo'),
(10,'bug','batchChangeModule'),
(10,'bug','batchClose'),
(10,'bug','batchConfirm'),
(10,'bug','batchCreate'),
(10,'bug','batchEdit'),
(10,'bug','batchResolve'),
(10,'bug','browse'),
(10,'bug','close'),
(10,'bug','confirmBug'),
(10,'bug','confirmStoryChange'),
(10,'bug','create'),
(10,'bug','edit'),
(10,'bug','export'),
(10,'bug','index'),
(10,'bug','linkBugs'),
(10,'bug','report'),
(10,'bug','resolve'),
(10,'bug','view'),
(10,'build','create'),
(10,'build','delete'),
(10,'build','edit'),
(10,'build','view'),
(10,'company','browse'),
(10,'company','dynamic'),
(10,'company','index'),
(10,'company','view'),
(10,'doc','allLibs'),
(10,'doc','browse'),
(10,'doc','collect'),
(10,'doc','create'),
(10,'doc','edit'),
(10,'doc','index'),
(10,'doc','objectLibs'),
(10,'doc','showFiles'),
(10,'doc','tableContents'),
(10,'doc','view'),
(10,'execution','all'),
(10,'execution','browse'),
(10,'execution','bug'),
(10,'execution','build'),
(10,'execution','burn'),
(10,'execution','computeBurn'),
(10,'execution','doc'),
(10,'execution','dynamic'),
(10,'execution','grouptask'),
(10,'execution','importBug'),
(10,'execution','importtask'),
(10,'execution','index'),
(10,'execution','kanban'),
(10,'execution','story'),
(10,'execution','task'),
(10,'execution','team'),
(10,'execution','testtask'),
(10,'execution','tree'),
(10,'execution','view'),
(10,'file','download'),
(10,'file','edit'),
(10,'git','apiSync'),
(10,'git','cat'),
(10,'git','diff'),
(10,'group','browse'),
(10,'index','index'),
(10,'misc','ping'),
(10,'my','bug'),
(10,'my','calendar'),
(10,'my','changePassword'),
(10,'my','contribute'),
(10,'my','deleteContacts'),
(10,'my','doc'),
(10,'my','dynamic'),
(10,'my','editProfile'),
(10,'my','execution'),
(10,'my','index'),
(10,'my','manageContacts'),
(10,'my','preference'),
(10,'my','profile'),
(10,'my','project'),
(10,'my','score'),
(10,'my','story'),
(10,'my','task'),
(10,'my','team'),
(10,'my','testcase'),
(10,'my','testtask'),
(10,'my','todo'),
(10,'my','unbind'),
(10,'my','uploadAvatar'),
(10,'my','work'),
(10,'personnel','accessible'),
(10,'personnel','invest'),
(10,'personnel','whitelist'),
(10,'product','all'),
(10,'product','browse'),
(10,'product','build'),
(10,'product','dashboard'),
(10,'product','doc'),
(10,'product','dynamic'),
(10,'product','index'),
(10,'product','manageLine'),
(10,'product','roadmap'),
(10,'product','view'),
(10,'productplan','browse'),
(10,'productplan','view'),
(10,'program','browse'),
(10,'program','kanban'),
(10,'program','product'),
(10,'program','project'),
(10,'program','stakeholder'),
(10,'program','view'),
(10,'project','browse'),
(10,'project','bug'),
(10,'project','build'),
(10,'project','index'),
(10,'project','dynamic'),
(10,'project','kanban'),
(10,'project','team'),
(10,'project','testtask'),
(10,'project','view'),
(10,'projectbuild','browse'),
(10,'projectrelease','browse'),
(10,'projectrelease','view'),
(10,'projectstory','story'),
(10,'projectstory','track'),
(10,'projectstory','view'),
(10,'qa','index'),
(10,'release','browse'),
(10,'release','export'),
(10,'release','view'),
(10,'repo','blame'),
(10,'repo','browse'),
(10,'repo','diff'),
(10,'repo','download'),
(10,'repo','log'),
(10,'repo','revision'),
(10,'repo','showSyncCommit'),
(10,'repo','view'),
(10,'report','bugAssign'),
(10,'report','bugCreate'),
(10,'report','index'),
(10,'report','productSummary'),
(10,'report','projectDeviation'),
(10,'report','workload'),
(10,'search','buildForm'),
(10,'search','buildQuery'),
(10,'search','deleteQuery'),
(10,'search','index'),
(10,'search','saveQuery'),
(10,'search','select'),
(10,'stakeholder','browse'),
(10,'stakeholder','userIssue'),
(10,'stakeholder','view'),
(10,'stakeholder','viewIssue'),
(10,'story','bugs'),
(10,'story','cases'),
(10,'story','export'),
(10,'story','processStoryChange'),
(10,'story','report'),
(10,'story','tasks'),
(10,'story','track'),
(10,'story','view'),
(10,'svn','apiSync'),
(10,'svn','cat'),
(10,'svn','diff'),
(10,'task','activate'),
(10,'task','assignTo'),
(10,'task','batchAssignTo'),
(10,'task','batchChangeModule'),
(10,'task','batchClose'),
(10,'task','batchCreate'),
(10,'task','batchEdit'),
(10,'task','cancel'),
(10,'task','close'),
(10,'task','confirmStoryChange'),
(10,'task','create'),
(10,'task','deleteEstimate'),
(10,'task','edit'),
(10,'task','editEstimate'),
(10,'task','export'),
(10,'task','finish'),
(10,'task','pause'),
(10,'task','recordEstimate'),
(10,'task','report'),
(10,'task','restart'),
(10,'task','start'),
(10,'task','view'),
(10,'testcase','browse'),
(10,'testcase','bugs'),
(10,'testcase','export'),
(10,'testcase','groupCase'),
(10,'testcase','view'),
(10,'testreport','browse'),
(10,'testreport','view'),
(10,'testsuite','browse'),
(10,'testsuite','index'),
(10,'testsuite','view'),
(10,'testtask','browse'),
(10,'testtask','cases'),
(10,'testtask','create'),
(10,'testtask','edit'),
(10,'testtask','groupCase'),
(10,'testtask','results'),
(10,'testtask','view'),
(10,'todo','activate'),
(10,'todo','assignTo'),
(10,'todo','batchClose'),
(10,'todo','batchCreate'),
(10,'todo','batchEdit'),
(10,'todo','batchFinish'),
(10,'todo','close'),
(10,'todo','create'),
(10,'todo','delete'),
(10,'todo','edit'),
(10,'todo','export'),
(10,'todo','finish'),
(10,'todo','import2Today'),
(10,'todo','start'),
(10,'todo','view'),
(10,'user','bug'),
(10,'user','cropAvatar'),
(10,'user','dynamic'),
(10,'user','execution'),
(10,'user','issue'),
(10,'user','profile'),
(10,'user','risk'),
(10,'user','story'),
(10,'user','task'),
(10,'user','testCase'),
(10,'user','testTask'),
(10,'user','todo'),
(10,'user','view'),
(11,'action','comment'),
(11,'action','editComment'),
(11,'automation','browse'),
(11,'bug','activate'),
(11,'bug','assignTo'),
(11,'bug','batchActivate'),
(11,'bug','batchAssignTo'),
(11,'bug','batchChangeBranch'),
(11,'bug','batchChangeModule'),
(11,'bug','batchClose'),
(11,'bug','batchConfirm'),
(11,'bug','batchCreate'),
(11,'bug','batchEdit'),
(11,'bug','batchResolve'),
(11,'bug','browse'),
(11,'bug','index'),
(11,'bug','close'),
(11,'bug','confirmBug'),
(11,'bug','confirmStoryChange'),
(11,'bug','create'),
(11,'bug','edit'),
(11,'bug','export'),
(11,'bug','linkBugs'),
(11,'bug','report'),
(11,'bug','resolve'),
(11,'bug','view'),
(11,'build','create'),
(11,'build','delete'),
(11,'build','edit'),
(11,'build','view'),
(11,'company','browse'),
(11,'company','dynamic'),
(11,'company','index'),
(11,'company','view'),
(11,'doc','allLibs'),
(11,'doc','browse'),
(11,'doc','collect'),
(11,'doc','index'),
(11,'doc','objectLibs'),
(11,'doc','showFiles'),
(11,'doc','tableContents'),
(11,'doc','view'),
(11,'execution','all'),
(11,'execution','browse'),
(11,'execution','bug'),
(11,'execution','build'),
(11,'execution','burn'),
(11,'execution','doc'),
(11,'execution','dynamic'),
(11,'execution','executionkanban'),
(11,'execution','grouptask'),
(11,'execution','index'),
(11,'execution','kanban'),
(11,'execution','story'),
(11,'execution','task'),
(11,'execution','team'),
(11,'execution','testcase'),
(11,'execution','testreport'),
(11,'execution','testtask'),
(11,'execution','tree'),
(11,'execution','treestory'),
(11,'execution','treetask'),
(11,'execution','view'),
(11,'execution','whitelist'),
(11,'file','download'),
(11,'file','edit'),
(11,'git','apiSync'),
(11,'git','cat'),
(11,'git','diff'),
(11,'group','browse'),
(11,'index','index'),
(11,'misc','ping'),
(11,'my','bug'),
(11,'my','calendar'),
(11,'my','changePassword'),
(11,'my','contribute'),
(11,'my','deleteContacts'),
(11,'my','doc'),
(11,'my','dynamic'),
(11,'my','editProfile'),
(11,'my','execution'),
(11,'my','index'),
(11,'my','manageContacts'),
(11,'my','preference'),
(11,'my','profile'),
(11,'my','project'),
(11,'my','score'),
(11,'my','story'),
(11,'my','task'),
(11,'my','team'),
(11,'my','testcase'),
(11,'my','testtask'),
(11,'my','todo'),
(11,'my','uploadAvatar'),
(11,'my','work'),
(11,'personnel','accessible'),
(11,'personnel','invest'),
(11,'personnel','whitelist'),
(11,'product','all'),
(11,'product','browse'),
(11,'product','build'),
(11,'product','dashboard'),
(11,'product','doc'),
(11,'product','dynamic'),
(11,'product','index'),
(11,'product','kanban'),
(11,'product','project'),
(11,'product','roadmap'),
(11,'product','view'),
(11,'product','whitelist'),
(11,'productplan','browse'),
(11,'productplan','view'),
(11,'program','browse'),
(11,'program','kanban'),
(11,'program','product'),
(11,'program','project'),
(11,'program','stakeholder'),
(11,'program','view'),
(11,'project','browse'),
(11,'project','bug'),
(11,'project','build'),
(11,'project','dynamic'),
(11,'project','execution'),
(11,'project','group'),
(11,'project','index'),
(11,'project','kanban'),
(11,'project','programTitle'),
(11,'project','qa'),
(11,'project','team'),
(11,'project','testcase'),
(11,'project','testreport'),
(11,'project','testtask'),
(11,'project','view'),
(11,'project','whitelist'),
(11,'projectbuild','browse'),
(11,'projectrelease','browse'),
(11,'projectrelease','export'),
(11,'projectrelease','view'),
(11,'projectstory','story'),
(11,'projectstory','track'),
(11,'projectstory','view'),
(11,'qa','index'),
(11,'release','browse'),
(11,'release','export'),
(11,'release','view'),
(11,'repo','browse'),
(11,'repo','diff'),
(11,'repo','download'),
(11,'repo','log'),
(11,'repo','revision'),
(11,'repo','view'),
(11,'report','bugAssign'),
(11,'report','bugCreate'),
(11,'report','index'),
(11,'report','productSummary'),
(11,'report','projectDeviation'),
(11,'report','workload'),
(11,'search','buildForm'),
(11,'search','buildQuery'),
(11,'search','deleteQuery'),
(11,'search','index'),
(11,'search','saveQuery'),
(11,'search','select'),
(11,'stakeholder','browse'),
(11,'stakeholder','communicate'),
(11,'stakeholder','expect'),
(11,'stakeholder','expectation'),
(11,'stakeholder','issue'),
(11,'stakeholder','userIssue'),
(11,'stakeholder','view'),
(11,'stakeholder','viewExpect'),
(11,'stakeholder','viewIssue'),
(11,'story','bugs'),
(11,'story','cases'),
(11,'story','export'),
(11,'story','report'),
(11,'story','tasks'),
(11,'story','track'),
(11,'story','view'),
(11,'story','zeroCase'),
(11,'svn','apiSync'),
(11,'svn','cat'),
(11,'svn','diff'),
(11,'task','activate'),
(11,'task','assignTo'),
(11,'task','batchAssignTo'),
(11,'task','batchCancel'),
(11,'task','batchChangeModule'),
(11,'task','batchClose'),
(11,'task','batchCreate'),
(11,'task','batchEdit'),
(11,'task','cancel'),
(11,'task','close'),
(11,'task','confirmStoryChange'),
(11,'task','create'),
(11,'task','deleteEstimate'),
(11,'task','edit'),
(11,'task','editEstimate'),
(11,'task','export'),
(11,'task','finish'),
(11,'task','pause'),
(11,'task','recordEstimate'),
(11,'task','report'),
(11,'task','restart'),
(11,'task','start'),
(11,'task','view'),
(11,'testcase','browse'),
(11,'testcase','bugs'),
(11,'testcase','export'),
(11,'testcase','groupCase'),
(11,'testcase','index'),
(11,'testcase','view'),
(11,'testreport','browse'),
(11,'testreport','view'),
(11,'testsuite','browse'),
(11,'testsuite','index'),
(11,'testsuite','view'),
(11,'testtask','browse'),
(11,'testtask','cases'),
(11,'testtask','groupCase'),
(11,'testtask','index'),
(11,'testtask','report'),
(11,'testtask','results'),
(11,'testtask','view'),
(11,'todo','activate'),
(11,'todo','assignTo'),
(11,'todo','batchClose'),
(11,'todo','batchCreate'),
(11,'todo','batchEdit'),
(11,'todo','batchFinish'),
(11,'todo','close'),
(11,'todo','create'),
(11,'todo','delete'),
(11,'todo','edit'),
(11,'todo','export'),
(11,'todo','finish'),
(11,'todo','import2Today'),
(11,'todo','start'),
(11,'todo','view'),
(11,'user','bug'),
(11,'user','cropAvatar'),
(11,'user','dynamic'),
(11,'user','execution'),
(11,'user','issue'),
(11,'user','profile'),
(11,'user','project'),
(11,'user','risk'),
(11,'user','story'),
(11,'user','task'),
(11,'user','testCase'),
(11,'user','testTask'),
(11,'user','todo'),
(11,'user','view'),
(12,'my','limited');

REPLACE INTO `zt_lang` (`lang`, `module`, `section`, `key`, `value`, `system`) VALUES
('zh-cn', 'custom', 'URSRList', '1', '{\"SRName\":\"\\u8f6f\\u4ef6\\u9700\\u6c42\",\"URName\":\"\\u7528\\u6237\\u9700\\u6c42\"}', '1'),('zh-cn', 'custom', 'URSRList', '2', '{\"SRName\":\"\\u7814\\u53d1\\u9700\\u6c42\",\"URName\":\"\\u7528\\u6237\\u9700\\u6c42\"}', '1'),
('zh-cn', 'custom', 'URSRList', '3', '{\"SRName\":\"\\u8f6f\\u9700\",\"URName\":\"\\u7528\\u9700\"}', '1'),('zh-cn', 'custom', 'URSRList', '4', '{\"SRName\":\"\\u6545\\u4e8b\",\"URName\":\"\\u53f2\\u8bd7\"}', '1'),
('zh-cn', 'custom', 'URSRList', '5', '{\"SRName\":\"\\u9700\\u6c42\",\"URName\":\"\\u7528\\u6237\\u9700\\u6c42\"}', '1'),
('en', 'custom', 'URSRList', '1', '{\"SRName\":\"Story\",\"URName\":\"Epic\"}', '0'),
('en', 'custom', 'URSRList', '2', '{\"SRName\":\"Software Requirement\",\"URName\":\"User Requirement\"}', '0'),
('all','stage','typeList','request','需求', '1'),
('all','stage','typeList','design','设计', '1'),
('all','stage','typeList','dev','开发', '1'),
('all','stage','typeList','qa','测试', '1'),
('all','stage','typeList','release','发布', '1'),
('all','stage','typeList','review','总结评审','1'),
('all','stage','typeList','other','其他','1');

REPLACE INTO `zt_stage` (`name`,`percent`,`type`,`createdBy`,`createdDate`,`editedBy`,`editedDate`,`deleted`) VALUES
('需求','10','request','admin','2020-02-08 21:08:30','admin','2020-02-12 13:50:27','0'),
('设计','10','design','admin','2020-02-08 21:08:30','admin','2020-02-12 13:50:27','0'),
('开发','50','dev','admin','2020-02-08 21:08:30','admin','2020-02-12 13:50:27','0'),
('测试','15','qa','admin','2020-02-08 21:08:30','admin','2020-02-12 13:50:27','0'),
('发布','10','release','admin','2020-02-08 21:08:30','admin','2020-02-12 13:50:27','0'),
('总结评审','5','review','admin','2020-02-08 21:08:45','admin','2020-02-12 13:50:27','0');

INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'custom', '', 'hourPoint',   '0');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'common', '', 'CRProduct',   '1');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'common', '', 'CRExecution', '1');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'custom', '', 'URSR', '2');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'common', 'global', 'mode', 'new');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'project', '', 'unitList', 'CNY,USD');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'project', '', 'defaultCurrency', 'CNY');
INSERT INTO `zt_config` (`owner`, `module`, `section`, `key`, `value`) VALUES ('system', 'story', '', 'reviewRules', 'allpass');
-- DROP TABLE IF EXISTS `zt_im_chat`;
CREATE TABLE IF NOT EXISTS `zt_im_chat` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `gid` char(40) NOT NULL DEFAULT '',
  `name` varchar(60) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT 'group',
  `admins` varchar(255) NOT NULL DEFAULT '',
  `committers` varchar(255) NOT NULL DEFAULT '',
  `subject` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `public` enum('0', '1') NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ownedBy` varchar(30) NOT NULL DEFAULT '',
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `mergedDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastActiveTime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastMessage` int(11) unsigned NOT NULL DEFAULT 0,
  `dismissDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `pinnedMessages` text NOT NULL DEFAULT '',
  `mergedChats` text NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `gid` (`gid`),
  KEY `name` (`name`),
  KEY `type` (`type`),
  KEY `public` (`public`),
  KEY `createdBy` (`createdBy`),
  KEY `editedBy` (`editedBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_chatuser`;
CREATE TABLE IF NOT EXISTS `zt_im_chatuser` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `cgid` char(40) NOT NULL DEFAULT '',
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `order` smallint(5) NOT NULL DEFAULT 0,
  `star` enum('0', '1') NOT NULL DEFAULT '0',
  `hide` enum('0', '1') NOT NULL DEFAULT '0',
  `mute` enum('0', '1') NOT NULL DEFAULT '0',
  `freeze` enum('0', '1') NOT NULL DEFAULT '0',
  `join` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `quit` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `category` varchar(40) NOT NULL DEFAULT '',
  `lastReadMessage` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `cgid` (`cgid`),
  KEY `user` (`user`),
  KEY `order` (`order`),
  KEY `star` (`star`),
  KEY `hide` (`hide`),
  UNIQUE KEY `chatuser` (`cgid`, `user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_client`;
CREATE TABLE IF NOT EXISTS `zt_im_client` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` char(30) NOT NULL DEFAULT '',
  `desc` varchar(100) NOT NULL DEFAULT '',
  `changeLog` text NOT NULL,
  `strategy` varchar(10) NOT NULL DEFAULT '',
  `downloads` text NOT NULL,
  `createdDate` datetime NOT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `status` enum('released','wait') NOT NULL DEFAULT 'wait',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_message`;
CREATE TABLE IF NOT EXISTS `zt_im_message` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `gid` char(40) NOT NULL DEFAULT '',
  `cgid` char(40) NOT NULL DEFAULT '',
  `user` varchar(30) NOT NULL DEFAULT '',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `type` enum('normal', 'broadcast', 'notify', 'bulletin') NOT NULL DEFAULT 'normal',
  `content` text NOT NULL DEFAULT '',
  `contentType` enum('text', 'plain', 'emotion', 'image', 'file', 'object', 'code') NOT NULL DEFAULT 'text',
  `data` text NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mgid` (`gid`),
  KEY `mcgid` (`cgid`),
  KEY `muser` (`user`),
  KEY `mtype` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_message_backup`;
CREATE TABLE IF NOT EXISTS `zt_im_message_backup` (
  `id` int(11) unsigned NOT NULL,
  `gid` char(40) NOT NULL DEFAULT '',
  `cgid` char(40) NOT NULL DEFAULT '',
  `user` varchar(30) NOT NULL DEFAULT '',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `type` enum('normal', 'broadcast', 'notify') NOT NULL DEFAULT 'normal',
  `content` text NOT NULL DEFAULT '',
  `contentType` enum('text', 'plain', 'emotion', 'image', 'file', 'object', 'code') NOT NULL DEFAULT 'text',
  `data` text NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_message_index`;
CREATE TABLE IF NOT EXISTS `zt_im_message_index` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `tableName` char(64) NOT NULL,
  `start` int(11) unsigned NOT NULL,
  `end` int(11) unsigned NOT NULL,
  `startDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `endDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `chats` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `tableName` (`tableName`),
  KEY `start` (`start`),
  KEY `end` (`end`),
  KEY `startDate` (`startDate`),
  KEY `endDate` (`endDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_chat_message_index`;
CREATE TABLE IF NOT EXISTS `zt_im_chat_message_index` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `gid` char(40) NOT NULL,
  `tableName` char(64) NOT NULL,
  `start` int(11) unsigned NOT NULL,
  `end` int(11) unsigned NOT NULL,
  `startDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `endDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `count` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `chattable` (`gid`,`tableName`),
  KEY `start` (`start`),
  KEY `end` (`end`),
  KEY `startDate` (`startDate`),
  KEY `endDate` (`endDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_messagestatus`;
CREATE TABLE IF NOT EXISTS `zt_im_messagestatus` (
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `message` int(11) unsigned NOT NULL,
  `status` enum('waiting','sent','readed','deleted') NOT NULL DEFAULT 'waiting',
  UNIQUE KEY `user` (`user`,`message`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_queue`;
CREATE TABLE IF NOT EXISTS `zt_im_queue` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `type` char(30) NOT NULL,
  `content` text NOT NULL,
  `addDate` datetime NOT NULL,
  `processDate` datetime NOT NULL,
  `result` text NOT NULL,
  `status` char(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_conference`;
CREATE TABLE IF NOT EXISTS `zt_im_conference` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `rid` char(40) NOT NULL DEFAULT '',
  `cgid` char(40) NOT NULL DEFAULT '',
  `status` enum('closed','open') NOT NULL DEFAULT 'closed',
  `participants` text NOT NULL,
  `invitee` text NOT NULL,
  `openedBy` mediumint(8) NOT NULL DEFAULT 0,
  `openedDate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_conferenceaction`;
CREATE TABLE IF NOT EXISTS `zt_im_conferenceaction` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `rid` char(40) NOT NULL DEFAULT '',
  `type` enum('create','invite','join','leave','close','publish') NOT NULL DEFAULT 'create',
  `data` text NOT NULL DEFAULT '',
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `device` char(40) NOT NULL DEFAULT 'default',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_im_userdevice`;
CREATE TABLE IF NOT EXISTS `zt_im_userdevice` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `device` char(40) NOT NULL DEFAULT 'default',
  `deviceID` char(40) NOT NULL DEFAULT '',
  `token` char(64) NOT NULL DEFAULT '',
  `validUntil` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastLogin` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `lastLogout` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `user` (`user`),
  KEY `lastLogin` (`lastLogin`),
  KEY `lastLogout` (`lastLogout`),
  UNIQUE KEY `userdevice` (`user`, `device`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

ALTER TABLE `zt_file` CHANGE `pathname` `pathname` char(100) NOT NULL;
ALTER TABLE `zt_user` ADD `clientStatus` enum('online', 'away', 'busy', 'offline', 'meeting') NOT NULL DEFAULT 'offline';
ALTER TABLE `zt_user` ADD `clientLang` varchar(10) NOT NULL DEFAULT 'zh-cn';
ALTER TABLE `zt_user` ADD `pinyin` varchar(255) NOT NULL DEFAULT '' AFTER `realname`;
ALTER TABLE `zt_effort` DROP INDEX `user`;
ALTER TABLE `zt_effort` DROP `user`;
ALTER TABLE `zt_effort` DROP `todo`;
ALTER TABLE `zt_effort` DROP `type`;
ALTER TABLE `zt_effort` DROP `idvalue`;
ALTER TABLE `zt_effort` DROP `name`;
ALTER TABLE `zt_effort` DROP `desc`;
ALTER TABLE `zt_effort` DROP `status`;

ALTER TABLE `zt_effort` ADD `objectType` varchar(30) NOT NULL AFTER `id`;
ALTER TABLE `zt_effort` ADD `objectID` mediumint(8) unsigned NOT NULL AFTER `objectType`;
ALTER TABLE `zt_effort` ADD `product` text NOT NULL AFTER `objectID`;
ALTER TABLE `zt_effort` ADD `project` mediumint(8) unsigned NOT NULL AFTER `product`;
ALTER TABLE `zt_effort` ADD `execution` mediumint(8) unsigned NOT NULL AFTER `project`;
ALTER TABLE `zt_effort` ADD `account` varchar(30) NOT NULL AFTER `execution`;
ALTER TABLE `zt_effort` ADD `work` text COLLATE 'utf8_general_ci' NULL AFTER `account`;
ALTER TABLE `zt_effort` ADD `left` float NOT NULL AFTER `date`;
ALTER TABLE `zt_effort` ADD `consumed` float NOT NULL AFTER `left`;
ALTER TABLE `zt_effort` CHANGE `begin` `begin` smallint(4) unsigned zerofill NOT NULL AFTER `consumed`;
ALTER TABLE `zt_effort` CHANGE `end` `end` smallint(4) unsigned zerofill NOT NULL AFTER `begin`;
ALTER TABLE `zt_effort` ADD `deleted` enum('0','1') NOT NULL DEFAULT '0' AFTER `end`;
ALTER TABLE `zt_effort` ADD INDEX `execution` (`execution`);
ALTER TABLE `zt_effort` ADD INDEX `objectID` (`objectID`);
ALTER TABLE `zt_effort` ADD INDEX `date` (`date`);
ALTER TABLE `zt_effort` ADD INDEX `account` (`account`);

ALTER TABLE `zt_action` ADD  `efforted` BOOL NOT NULL DEFAULT  '0';
INSERT INTO `zt_cron` (`m`, `h`, `dom`, `mon`, `dow`, `command`, `remark`, `type`, `buildin`, `status`, `lastTime`) VALUES ('30', '23', '*', '*', '*', 'moduleName=execution&methodName=computeTaskEffort', '计算任务剩余工时', 'zentao', '1', 'normal', '0000-00-00 00:00:00');
INSERT INTO `zt_cron` (`m`, `h`, `dom`, `mon`, `dow`, `command`, `remark`, `type`, `buildin`, `status`, `lastTime`) VALUES ('30', '7', '*', '*', '*', 'moduleName=effort&methodName=remindNotRecord', '提醒录入日志', 'zentao', '1', 'stop', '0000-00-00 00:00:00');
REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1,'company','alleffort'),
(1,'company','allTodo'),
(1,'company','calendar'),
(1,'company','effort'),
(1,'company','todo'),
(1,'effort','batchCreate'),
(1,'effort','batchEdit'),
(1,'effort','calendar'),
(1,'effort','createForObject'),
(1,'effort','delete'),
(1,'effort','edit'),
(1,'effort','export'),
(1,'effort','view'),
(1,'execution','calendar'),
(1,'execution','computeTaskEffort'),
(1,'execution','deleterelation'),
(1,'execution','effort'),
(1,'execution','effortCalendar'),
(1,'execution','taskEffort'),
(1,'my','effort'),
(1,'todo','calendar'),
(1,'user','effort'),
(1,'user','effortcalendar'),
(1,'user','todocalendar'),
(2,'company','effort'),
(2,'effort','batchCreate'),
(2,'effort','batchEdit'),
(2,'effort','calendar'),
(2,'effort','createForObject'),
(2,'effort','delete'),
(2,'effort','edit'),
(2,'effort','export'),
(2,'effort','view'),
(2,'execution','calendar'),
(2,'execution','computeTaskEffort'),
(2,'execution','deleterelation'),
(2,'execution','effort'),
(2,'execution','effortCalendar'),
(2,'execution','taskEffort'),
(2,'my','effort'),
(2,'todo','calendar'),
(2,'user','effort'),
(2,'user','effortcalendar'),
(2,'user','todocalendar'),
(3,'company','effort'),
(3,'effort','batchCreate'),
(3,'effort','calendar'),
(3,'effort','createForObject'),
(3,'effort','delete'),
(3,'effort','edit'),
(3,'effort','export'),
(3,'effort','view'),
(3,'execution','calendar'),
(3,'execution','effort'),
(3,'my','effort'),
(3,'todo','calendar'),
(3,'user','effort'),
(3,'user','effortcalendar'),
(3,'user','todocalendar'),
(4,'company','effort'),
(4,'effort','batchCreate'),
(4,'effort','batchEdit'),
(4,'effort','calendar'),
(4,'effort','createForObject'),
(4,'effort','delete'),
(4,'effort','edit'),
(4,'effort','export'),
(4,'effort','view'),
(4,'execution','calendar'),
(4,'execution','computeTaskEffort'),
(4,'execution','effort'),
(4,'execution','effortCalendar'),
(4,'execution','taskEffort'),
(4,'my','effort'),
(4,'todo','calendar'),
(4,'user','effort'),
(4,'user','effortcalendar'),
(4,'user','todocalendar'),
(5,'company','effort'),
(5,'effort','batchCreate'),
(5,'effort','batchEdit'),
(5,'effort','calendar'),
(5,'effort','createForObject'),
(5,'effort','delete'),
(5,'effort','edit'),
(5,'effort','export'),
(5,'effort','view'),
(5,'execution','calendar'),
(5,'execution','computeTaskEffort'),
(5,'execution','effort'),
(5,'execution','effortCalendar'),
(5,'execution','taskEffort'),
(5,'my','effort'),
(5,'todo','calendar'),
(5,'user','effort'),
(5,'user','effortcalendar'),
(5,'user','todocalendar'),
(6,'company','effort'),
(6,'effort','batchCreate'),
(6,'effort','calendar'),
(6,'effort','createForObject'),
(6,'effort','delete'),
(6,'effort','edit'),
(6,'effort','export'),
(6,'effort','view'),
(6,'execution','calendar'),
(6,'execution','effort'),
(6,'my','effort'),
(6,'todo','calendar'),
(6,'user','effort'),
(6,'user','effortcalendar'),
(6,'user','todocalendar'),
(7,'company','calendar'),
(7,'company','effort'),
(7,'company','todo'),
(7,'effort','batchCreate'),
(7,'effort','calendar'),
(7,'effort','createForObject'),
(7,'effort','delete'),
(7,'effort','edit'),
(7,'effort','export'),
(7,'effort','view'),
(7,'execution','calendar'),
(7,'execution','effort'),
(7,'my','effort'),
(7,'todo','calendar'),
(7,'user','effort'),
(7,'user','effortcalendar'),
(7,'user','todocalendar'),
(8,'company','calendar'),
(8,'company','effort'),
(8,'company','todo'),
(8,'effort','batchCreate'),
(8,'effort','calendar'),
(8,'effort','createForObject'),
(8,'effort','delete'),
(8,'effort','edit'),
(8,'effort','export'),
(8,'effort','view'),
(8,'execution','calendar'),
(8,'execution','effort'),
(8,'execution','effortCalendar'),
(8,'execution','taskEffort'),
(8,'my','effort'),
(8,'todo','calendar'),
(8,'user','effort'),
(8,'user','effortcalendar'),
(8,'user','todocalendar'),
(9,'company','alleffort'),
(9,'company','allTodo'),
(9,'company','calendar'),
(9,'company','effort'),
(9,'company','todo'),
(9,'effort','batchCreate'),
(9,'effort','calendar'),
(9,'effort','createForObject'),
(9,'effort','delete'),
(9,'effort','edit'),
(9,'effort','export'),
(9,'effort','view'),
(9,'execution','calendar'),
(9,'execution','computeTaskEffort'),
(9,'execution','effort'),
(9,'execution','effortCalendar'),
(9,'execution','taskEffort'),
(9,'my','effort'),
(9,'todo','calendar'),
(9,'user','effort'),
(9,'user','effortcalendar'),
(9,'user','todocalendar'),
(10,'company','calendar'),
(10,'company','effort'),
(10,'company','todo'),
(10,'effort','batchCreate'),
(10,'effort','calendar'),
(10,'effort','createForObject'),
(10,'effort','delete'),
(10,'effort','edit'),
(10,'effort','export'),
(10,'effort','view'),
(10,'execution','calendar'),
(10,'execution','effort'),
(10,'my','effort'),
(10,'todo','calendar'),
(10,'user','effort'),
(10,'user','effortcalendar'),
(10,'user','todocalendar'),
(11,'company','calendar'),
(11,'company','effort'),
(11,'company','todo'),
(11,'effort','batchCreate'),
(11,'effort','calendar'),
(11,'effort','createForObject'),
(11,'effort','delete'),
(11,'effort','edit'),
(11,'effort','export'),
(11,'effort','view'),
(11,'my','effort'),
(11,'todo','calendar'),
(11,'user','effort'),
(11,'user','effortcalendar'),
(11,'user','todocalendar');
REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1,'bug','exportTemplet'),
(1,'bug','import'),
(1,'bug','showImport'),
(1,'story','exportTemplet'),
(1,'story','import'),
(1,'story','showImport'),
(1,'task','exportTemplet'),
(1,'task','import'),
(1,'task','showImport'),
(2,'bug','exportTemplet'),
(2,'bug','import'),
(2,'bug','showImport'),
(2,'task','exportTemplet'),
(2,'task','import'),
(2,'task','showImport'),
(3,'bug','exportTemplet'),
(3,'bug','import'),
(3,'bug','showImport'),
(4,'bug','exportTemplet'),
(4,'bug','import'),
(4,'bug','showImport'),
(4,'story','exportTemplet'),
(4,'story','import'),
(4,'story','showImport'),
(4,'task','exportTemplet'),
(4,'task','import'),
(4,'task','showImport'),
(5,'bug','exportTemplet'),
(5,'bug','import'),
(5,'bug','showImport'),
(5,'story','exportTemplet'),
(5,'story','import'),
(5,'story','showImport'),
(5,'task','exportTemplet'),
(5,'task','import'),
(5,'task','showImport'),
(7,'bug','exportTemplet'),
(7,'bug','import'),
(7,'bug','showImport'),
(7,'story','exportTemplet'),
(7,'story','import'),
(7,'story','showImport'),
(8,'bug','exportTemplet'),
(8,'bug','import'),
(8,'bug','showImport');
 -- DROP TABLE IF EXISTS `zt_relationoftasks`;
CREATE TABLE IF NOT EXISTS `zt_relationoftasks` (
  `id` MEDIUMINT(8) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `execution` MEDIUMINT(8) UNSIGNED NOT NULL ,
  `pretask` MEDIUMINT(8) UNSIGNED NOT NULL ,
  `condition` ENUM( 'begin', 'end' ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
  `task` MEDIUMINT( 8 ) UNSIGNED NOT NULL ,
  `action` ENUM( 'begin', 'end' ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
  PRIMARY KEY (`id`),
  KEY `relationoftasks` (`execution`,`task`)
) ENGINE = MYISAM CHARACTER SET utf8 COLLATE utf8_general_ci;
REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1,'execution','gantt'),
(1,'execution','relation'),
(1,'execution','maintainrelation'),
(2,'execution','gantt'),
(2,'execution','maintainrelation'),
(2,'execution','relation'),
(4,'execution','deleterelation'),
(4,'execution','gantt'),
(4,'execution','maintainrelation'),
(4,'execution','relation'),
(5,'execution','deleterelation'),
(5,'execution','gantt'),
(5,'execution','maintainrelation'),
(5,'execution','relation'),
(7,'execution','gantt'),
(8,'execution','gantt'),
(9,'execution','gantt'),
(10,'execution','gantt'),
(10,'execution','relation');
REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1,'repo','addBug'),
(1,'repo','addComment'),
(1,'repo','deleteBug'),
(1,'repo','deleteComment'),
(1,'repo','editBug'),
(1,'repo','editComment'),
(1,'repo','review'),
(9,'repo','addBug'),
(9,'repo','deleteComment'),
(9,'repo','editBug'),
(9,'repo','editComment');
REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1,'report','bugAssignSummary'),
(1,'report','bugSummary'),
(1,'report','build'),
(1,'report','casesrun'),
(1,'report','projectSummary'),
(1,'report','projectWorkload'),
(1,'report','reportExport'),
(1,'report','roadmap'),
(1,'report','storyLinkedBug'),
(1,'report','testcase'),
(1,'report','workAssignSummary'),
(1,'report','workSummary'),
(2,'report','bugAssignSummary'),
(2,'report','bugSummary'),
(2,'report','build'),
(2,'report','casesrun'),
(2,'report','projectSummary'),
(2,'report','projectWorkload'),
(2,'report','roadmap'),
(2,'report','storyLinkedBug'),
(2,'report','testcase'),
(2,'report','workAssignSummary'),
(2,'report','workSummary'),
(3,'report','bugAssignSummary'),
(3,'report','bugSummary'),
(3,'report','build'),
(3,'report','casesrun'),
(3,'report','projectSummary'),
(3,'report','projectWorkload'),
(3,'report','roadmap'),
(3,'report','storyLinkedBug'),
(3,'report','testcase'),
(3,'report','workAssignSummary'),
(3,'report','workSummary'),
(4,'report','bugAssignSummary'),
(4,'report','bugSummary'),
(4,'report','build'),
(4,'report','casesrun'),
(4,'report','projectSummary'),
(4,'report','projectWorkload'),
(4,'report','reportExport'),
(4,'report','roadmap'),
(4,'report','storyLinkedBug'),
(4,'report','testcase'),
(4,'report','workAssignSummary'),
(4,'report','workSummary'),
(5,'report','bugAssignSummary'),
(5,'report','bugSummary'),
(5,'report','build'),
(5,'report','casesrun'),
(5,'report','projectSummary'),
(5,'report','projectWorkload'),
(5,'report','reportExport'),
(5,'report','roadmap'),
(5,'report','storyLinkedBug'),
(5,'report','testcase'),
(5,'report','workAssignSummary'),
(5,'report','workSummary'),
(6,'report','bugAssignSummary'),
(6,'report','bugSummary'),
(6,'report','build'),
(6,'report','casesrun'),
(6,'report','projectSummary'),
(6,'report','projectWorkload'),
(6,'report','roadmap'),
(6,'report','storyLinkedBug'),
(6,'report','testcase'),
(6,'report','workAssignSummary'),
(6,'report','workSummary'),
(7,'report','bugAssignSummary'),
(7,'report','bugSummary'),
(7,'report','build'),
(7,'report','casesrun'),
(7,'report','projectSummary'),
(7,'report','projectWorkload'),
(7,'report','reportExport'),
(7,'report','roadmap'),
(7,'report','storyLinkedBug'),
(7,'report','testcase'),
(7,'report','workAssignSummary'),
(7,'report','workSummary'),
(8,'report','bugAssignSummary'),
(8,'report','bugSummary'),
(8,'report','build'),
(8,'report','casesrun'),
(8,'report','projectSummary'),
(8,'report','projectWorkload'),
(8,'report','roadmap'),
(8,'report','storyLinkedBug'),
(8,'report','testcase'),
(8,'report','workAssignSummary'),
(8,'report','workSummary'),
(9,'report','bugAssignSummary'),
(9,'report','bugSummary'),
(9,'report','build'),
(9,'report','casesrun'),
(9,'report','projectSummary'),
(9,'report','projectWorkload'),
(9,'report','reportExport'),
(9,'report','roadmap'),
(9,'report','storyLinkedBug'),
(9,'report','testcase'),
(9,'report','workAssignSummary'),
(9,'report','workSummary'),
(10,'report','bugAssignSummary'),
(10,'report','bugSummary'),
(10,'report','build'),
(10,'report','casesrun'),
(10,'report','projectSummary'),
(10,'report','projectWorkload'),
(10,'report','reportExport'),
(10,'report','roadmap'),
(10,'report','storyLinkedBug'),
(10,'report','testcase'),
(10,'report','workAssignSummary'),
(10,'report','workSummary'),
(11,'report','bugAssignSummary'),
(11,'report','bugSummary'),
(11,'report','build'),
(11,'report','casesrun'),
(11,'report','projectSummary'),
(11,'report','projectWorkload'),
(11,'report','roadmap'),
(11,'report','storyLinkedBug'),
(11,'report','testcase'),
(11,'report','workAssignSummary'),
(11,'report','workSummary');
ALTER TABLE `zt_user` ADD `ldap` CHAR(30) NOT NULL AFTER `ranzhi`;

REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1,'ldap','index'),
(1,'ldap','set'),
(1,'user','importldap');
-- DROP TABLE IF EXISTS `zt_report`;
CREATE TABLE IF NOT EXISTS `zt_report` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `code` varchar(100) NOT NULL,
  `name` text NOT NULL,
  `module` varchar(100) NOT NULL,
  `sql` text NOT NULL,
  `vars` text NOT NULL,
  `langs` text NOT NULL,
  `params` text NOT NULL,
  `step` tinyint(1) NOT NULL DEFAULT '2',
  `desc` text NOT NULL,
  `addedBy` char(30) NOT NULL,
  `addedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE OR REPLACE VIEW `ztv_executionsummary` AS select `zt_task`.`execution` AS `execution`,sum(if((`zt_task`.`parent` >= '0'),`zt_task`.`estimate`,0)) AS `estimate`,sum(if((`zt_task`.`parent` >= '0'),`zt_task`.`consumed`,0)) AS `consumed`,sum(if(((`zt_task`.`status` <> 'cancel') and (`zt_task`.`status` <> 'closed') and (`zt_task`.`parent` >= '0')),`zt_task`.`left`,0)) AS `left`,count(0) AS `number`,sum(if(((`zt_task`.`status` <> 'done') and (`zt_task`.`status` <> 'closed')),1,0)) AS `undone`,sum((if((`zt_task`.`parent` >= '0'),`zt_task`.`consumed`,0) + if(((`zt_task`.`status` <> 'cancel') and (`zt_task`.`status` <> 'closed') and (`zt_task`.`parent` >= '0')),`zt_task`.`left`,0))) AS `totalReal` from `zt_task` where (`zt_task`.`deleted` = '0') group by `zt_task`.`execution`;
CREATE OR REPLACE VIEW `ztv_projectsummary` AS select `zt_task`.`project` AS `project`,sum(if((`zt_task`.`parent` >= '0'),`zt_task`.`estimate`,0)) AS `estimate`,sum(if((`zt_task`.`parent` >= '0'),`zt_task`.`consumed`,0)) AS `consumed`,sum(if(((`zt_task`.`status` <> 'cancel') and (`zt_task`.`status` <> 'closed') and (`zt_task`.`parent` >= '0')),`zt_task`.`left`,0)) AS `left`,count(0) AS `number`,sum(if(((`zt_task`.`status` <> 'done') and (`zt_task`.`status` <> 'closed')),1,0)) AS `undone`,sum((if((`zt_task`.`parent` >= '0'),`zt_task`.`consumed`,0) + if(((`zt_task`.`status` <> 'cancel') and (`zt_task`.`status` <> 'closed') and (`zt_task`.`parent` >= '0')),`zt_task`.`left`,0))) AS `totalReal` from `zt_task` where (`zt_task`.`deleted` = '0') group by `zt_task`.`project`;
CREATE OR REPLACE VIEW `ztv_projectstories` AS select `t1`.`project` AS `execution`,count('*') AS `stories`,sum(if((`t2`.`status` = 'closed'),0,1)) AS `undone` from ((`zt_projectstory` `t1` left join `zt_story` `t2` on((`t1`.`story` = `t2`.`id`))) left join `zt_project` `t3` on((`t1`.`project` = `t3`.`id`))) where ((`t2`.`deleted` = '0') and (`t3`.`type` in ('sprint','stage'))) group by `t1`.`project`;
CREATE OR REPLACE VIEW `ztv_projectteams` AS select `zt_team`.`root` AS `execution`,count('*') AS `teams` from `zt_team` where (`zt_team`.`type` = 'execution') group by `zt_team`.`root`;
CREATE OR REPLACE VIEW `ztv_projectbugs` AS select `zt_bug`.`execution` AS `execution`,count(0) AS `bugs`,sum(if((`zt_bug`.`resolution` = ''),0,1)) AS `resolutions`,sum(if((`zt_bug`.`severity` <= 2),1,0)) AS `seriousBugs` from `zt_bug` where (`zt_bug`.`deleted` = '0') group by `zt_bug`.`execution`;
CREATE OR REPLACE VIEW `ztv_productbugs` AS select `zt_bug`.`product` AS `product`,count(0) AS `bugs`,sum(if((`zt_bug`.`resolution` = ''),0,1)) AS `resolutions`,sum(if((`zt_bug`.`severity` <= 2),1,0)) AS `seriousBugs` from `zt_bug` where (`zt_bug`.`deleted` = '0') group by `zt_bug`.`product`;
CREATE OR REPLACE VIEW `ztv_productstories` AS select `zt_story`.`product` AS `product`,count('*') AS `stories`,sum(if((`zt_story`.`status` = 'closed'),0,1)) AS `undone` from `zt_story` where (`zt_story`.`deleted` = '0') group by `zt_story`.`product`;
CREATE OR REPLACE VIEW `ztv_dayuserlogin` AS select count(*) AS `userlogin`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'user') and (`zt_action`.`action` = 'login')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_dayeffort` AS select round(sum(`zt_effort`.`consumed`),1) AS `consumed`,`zt_effort`.`date` AS `date` from `zt_effort` group by `zt_effort`.`date`;
CREATE OR REPLACE VIEW `ztv_daystoryopen` AS select count(*) AS `storyopen`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'story') and (`zt_action`.`action` = 'opened')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_daystoryclose` AS select count(*) AS `storyclose`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'story') and (`zt_action`.`action` = 'closed')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_daytaskopen` AS select count(*) AS `taskopen`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'task') and (`zt_action`.`action` = 'opened')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_daytaskfinish` AS select count(*) AS `taskfinish`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'task') and (`zt_action`.`action` = 'finished')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_daybugopen` AS select count(*) AS `bugopen`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'bug') and (`zt_action`.`action` = 'opened')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_daybugresolve` AS select count(*) AS `bugresolve`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'bug') and (`zt_action`.`action` = 'resolved')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_dayactions` AS select count(*) AS `actions`,left(`zt_action`.`date`,10) AS `day` from `zt_action` group by left(`zt_action`.`date`,10);

REPLACE INTO `zt_report` (`code`, `name`, `module`, `sql`, `vars`, `langs`, `params`, `step`, `desc`, `addedBy`, `addedDate`) VALUES
('product-invest', '{\"zh-cn\":\"\\u4ea7\\u54c1\\u6295\\u5165\\u8868\",\"zh-tw\":\"\\u7522\\u54c1\\u6295\\u5165\\u8868\",\"en\":\"Product Investment\"}', ',product', 'select t1.id,t1.name,1 as projects, round(t3.consumed,2) as consumed from TABLE_PRODUCT as t1\r\n left join TABLE_PROJECTPRODUCT as t2 on t1.id=t2.product\r\n left join ztv_projectsummary as t3 on t2.project=t3.project\r\n left join TABLE_PROJECT as t4 on t2.project=t4.id\r\n left join TABLE_PROGRAM as t5 on t1.program=t5.id\r\n where t1.deleted=\'0\' and t4.deleted=\'0\' and t4.type=\'project\'\r\norder by t5.`order` asc, t1.line desc, t1.`order` asc', '', '{\"projects\":{\"zh-cn\":\"\\u9879\\u76ee\\u6570\",\"zh-tw\":\"\\u9879\\u76ee\\u6570\",\"en\":\"Projects\"},\"consumed\":{\"zh-cn\":\"\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\",\"zh-tw\":\"\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\",\"en\":\"Cost(h)\"}}', '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"projects\",\"consumed\"],\"reportType\":[\"sum\",\"sum\"],\"sumAppend\":[\"projects\",\"consumed\"]}', 2, '{\"zh-cn\":\"\\u5217\\u51fa\\u6bcf\\u4e2a\\u4ea7\\u54c1\\u7684\\u9879\\u76ee\\u603b\\u6570\\uff0c\\u5df2\\u7ecf\\u6d88\\u8017\\u7684\\u5de5\\u65f6\\u3002\",\"zh-tw\":\"\\u5217\\u51fa\\u6bcf\\u500b\\u7522\\u54c1\\u7684\\u9805\\u76ee\\u7e3d\\u6578\\uff0c\\u5df2\\u7d93\\u6d88\\u8017\\u7684\\u5de5\\u6642\\u3002\",\"en\":\"Number of projects and consumed hours.\"}', 'admin', '2015-07-20 14:21:31'),
('product-progress', '{\"zh-cn\":\"\\u4ea7\\u54c1\\u5b8c\\u6210\\u5ea6\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u7522\\u54c1\\u5b8c\\u6210\\u5ea6\\u7d71\\u8a08\\u8868\",\"en\":\"Product Progress\"}', ',product', 'select t1.*,t2.name, (case when t1.status = \'closed\' or t1.stage = \'released\' then 1 else 0 end) as done, 1 as count from TABLE_STORY as t1 \r\nleft join TABLE_PRODUCT as t2 on t1.product=t2.id \r\nleft join TABLE_PROGRAM as t3 on t2.program=t3.id \r\nwhere t1.deleted=\'0\' and t2.deleted=\'0\'\r\norder by t3.`order` asc, t2.line desc, t2.`order` asc', '', '{\"count\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"done\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u6570\",\"en\":\"Done\"}}', '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"count\",\"done\"],\"reportType\":[\"sum\",\"sum\"],\"sumAppend\":[\"count\",\"done\"],\"percent\":{\"1\":\"1\"},\"contrast\":{\"1\":\"count\"},\"showAlone\":{\"1\":\"1\"}}', 2, '{\"zh-cn\":\"\\u6309\\u7167\\u4ea7\\u54c1\\u5217\\u51fa\\u9700\\u6c42\\u603b\\u6570\\uff0c\\u5b8c\\u6210\\u7684\\u603b\\u6570(\\u72b6\\u6001\\u662f\\u5173\\u95ed\\uff0c\\u6216\\u8005\\u7814\\u53d1\\u9636\\u6bb5\\u662f\\u53d1\\u5e03)\\uff0c\\u5b8c\\u6210\\u7684\\u767e\\u5206\\u6bd4\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u7522\\u54c1\\u5217\\u51fa\\u9700\\u6c42\\u7e3d\\u6578\\uff0c\\u5b8c\\u6210\\u7684\\u7e3d\\u6578(\\u72c0\\u614b\\u662f\\u95dc\\u9589\\uff0c\\u6216\\u8005\\u7814\\u767c\\u968e\\u6bb5\\u662f\\u767c\\u5e03)\\uff0c\\u5b8c\\u6210\\u7684\\u767e\\u5206\\u6bd4\\u3002\",\"en\":\"Number of total stories,done stories(state is closed, or stage is released), percent of completion.\"}', 'admin', '2015-07-21 15:07:48'),
('story-status', '{\"zh-cn\":\"\\u4ea7\\u54c1\\u9700\\u6c42\\u72b6\\u6001\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u7522\\u54c1\\u9700\\u6c42\\u72c0\\u614b\\u5206\\u5e03\\u8868\",\"en\":\"Story Status\"}', ',product', 'select t1.*,t2.name from TABLE_STORY as t1\r\n left join TABLE_PRODUCT as t2 on t1.product=t2.id \r\nleft join TABLE_PROGRAM as t3 on t2.program=t3.id \r\nwhere t1.deleted=\'0\' and t2.deleted=\'0\'\r\norder by t3.`order` asc, t2.line desc, t2.`order` asc', '', '', '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"status\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}', 2, '{\"zh-cn\":\"\\u6309\\u7167\\u4ea7\\u54c1\\u5217\\u51fa\\u9700\\u6c42\\u603b\\u6570\\uff0c\\u72b6\\u6001\\u7684\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u7522\\u54c1\\u5217\\u51fa\\u9700\\u6c42\\u7e3d\\u6578\\uff0c\\u72c0\\u614b\\u7684\\u5206\\u5e03\\u60c5\\u6cc1\\u3002\",\"en\":\"Total number and status distribution of stories.\"}', 'admin', '2015-07-21 15:35:38'),
('story-stage', '{\"zh-cn\":\"\\u4ea7\\u54c1\\u9700\\u6c42\\u9636\\u6bb5\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u7522\\u54c1\\u9700\\u6c42\\u968e\\u6bb5\\u5206\\u5e03\\u8868\",\"en\":\"Story Stage\"}', ',product', 'select t1.*,t2.name from TABLE_STORY as t1\r\n left join TABLE_PRODUCT as t2 on t1.product=t2.id \r\nleft join TABLE_PROGRAM as t3 on t2.program=t3.id \r\nwhere t1.deleted=\'0\' and t2.deleted=\'0\'\r\norder by t3.`order` asc, t2.line desc, t2.`order` asc', '', '', '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"stage\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}', 2, '{\"zh-cn\":\"\\u6309\\u7167\\u4ea7\\u54c1\\u5217\\u51fa\\u9700\\u6c42\\u603b\\u6570\\uff0c\\u7814\\u53d1\\u9636\\u6bb5\\u7684\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u7522\\u54c1\\u5217\\u51fa\\u9700\\u6c42\\u7e3d\\u6578\\uff0c\\u7814\\u767c\\u968e\\u6bb5\\u7684\\u5206\\u5e03\\u60c5\\u6cc1\\u3002\",\"en\":\"Total number and stage distribution of stories \"}', 'admin', '2015-07-21 15:38:34'),
('product-release', '{\"zh-cn\":\"\\u4ea7\\u54c1\\u53d1\\u5e03\\u6570\\u91cf\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u7522\\u54c1\\u767c\\u5e03\\u6578\\u91cf\\u7d71\\u8a08\\u8868\",\"en\":\"Product Release\"}', ',product', 'select t2.name, 1 as releases from TABLE_RELEASE as t1 \r\nleft join TABLE_PRODUCT as t2 on t1.product=t2.id \r\nleft join TABLE_PROGRAM as t3 on t2.program=t3.id \r\nwhere t1.deleted=\'0\' and t2.deleted=\'0\'\r\norder by t3.`order` asc, t2.line desc, t2.`order` asc', '', '{\"count\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"done\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u6570\",\"en\":\"Done\"}}', '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"releases\"],\"reportType\":[\"sum\"],\"sumAppend\":[\"releases\"]}', 2, '{\"zh-cn\":\"\\u6309\\u7167\\u4ea7\\u54c1\\u5217\\u51fa\\u53d1\\u5e03\\u7684\\u6570\\u91cf\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u7522\\u54c1\\u5217\\u51fa\\u767c\\u5e03\\u7684\\u6578\\u91cf\\u3002\",\"en\":\"List the number of releases by product.\"}', 'admin', '2015-07-21 16:00:52'),
('task-status', '{\"zh-cn\":\"\\u4efb\\u52a1\\u72b6\\u6001\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u4efb\\u52d9\\u72c0\\u614b\\u7d71\\u8a08\\u8868\",\"en\":\"Task Status Report\"}', ',project', 'select t1.id,t3.name as project,t1.name,t2.status,t1.name as execution,t2.id as taskID,  t1.status as projectstatus, (case when t2.deadline < CURDATE() and t2.deadline != \'0000-00-00\' and t2.status != \'closed\' and t2.status != \'done\' and t2.status != \'cancel\' then 1 else 0 end) as timeout from TABLE_EXECUTION as t1\r\n left join TABLE_TASK as t2 on t1.id=t2.execution\r\n left join TABLE_PROJECT as t3 on t3.id=t1.project\r\n where t1.deleted=\'0\' and t1.type in (\'sprint\',\'stage\') and t2.deleted=\'0\' and if($project=\'\',1,t3.id=$project) and if($status=\'\',1,t1.status=$status) and if($beginDate=\'\',1,t1.begin>=$beginDate) and if($endDate=\'\',1,t1.end<=$endDate)', '{\"varName\":[\"project\",\"status\",\"beginDate\",\"endDate\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u72b6\\u6001\",\"\\u6267\\u884c\\u8d77\\u59cb\\u65e5\\u671f\",\"\\u6267\\u884c\\u7ed3\\u675f\\u65e5\\u671f\"],\"requestType\":[\"select\",\"select\",\"date\",\"date\"],\"selectList\":[\"project\",\"project.status\",\"user\",\"user\"],\"default\":[\"\",\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}', '{\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}', '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"status\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}', 2, '{\"zh-cn\":\"\\u6309\\u7167\\u6267\\u884c\\u7edf\\u8ba1\\u4efb\\u52a1\\u7684\\u72b6\\u6001\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u57f7\\u884c\\u7d71\\u8a08\\u4efb\\u52d9\\u7684\\u72c0\\u614b\\u5206\\u5e03\\u60c5\\u6cc1\\u3002\",\"en\":\"Based on the status distribution of statistical tasks.\"}', 'admin', '2015-07-22 11:28:33'),
('task-type', '{\"zh-cn\":\"\\u4efb\\u52a1\\u7c7b\\u578b\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u4efb\\u52d9\\u985e\\u578b\\u7d71\\u8a08\\u8868\",\"en\":\"Task Type Report\"}', ',project', 'select t1.id,t3.name as project,t1.name as execution,t2.type,t2.id as taskID, t1.status as projectstatus from TABLE_EXECUTION as t1 \r\nleft join TABLE_TASK as t2 on t1.id=t2.execution\r\nleft join TABLE_PROJECT as t3 on t3.id=t1.project\r\nwhere t1.deleted=\'0\' and t1.type in (\'sprint\',\'stage\') and t2.deleted=\'0\' and if($project=\'\',1,t3.id=$project) and if($status=\'\',1,t1.status=$status) and if($beginDate=\'\',1,t1.begin>=$beginDate) and if($endDate=\'\',1,t1.end<=$endDate)', '{\"varName\":[\"project\",\"status\",\"beginDate\",\"endDate\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u72b6\\u6001\",\"\\u6267\\u884c\\u8d77\\u59cb\\u65e5\\u671f\",\"\\u6267\\u884c\\u7ed3\\u675f\\u65e5\\u671f\"],\"requestType\":[\"select\",\"select\",\"date\",\"date\"],\"selectList\":[\"project\",\"project.status\",\"user\",\"user\"],\"default\":[\"\",\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}', '{\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}', '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"type\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}', 2, '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1\\u4efb\\u52a1\\u7684\\u7c7b\\u578b\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08\\u4efb\\u52d9\\u7684\\u985e\\u578b\\u5206\\u5e03\\u60c5\\u6cc1\\u3002\",\"en\":\"According to the type of statistical task distribution.\"}', 'admin', '2015-07-22 13:06:46'),
('task-assign', '{\"zh-cn\":\"\\u9879\\u76ee\\u4efb\\u52a1\\u6307\\u6d3e\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u9805\\u76ee\\u4efb\\u52d9\\u6307\\u6d3e\\u7d71\\u8a08\\u8868\",\"en\":\"Task Assign Report\"}', ',project', 'select t1.id,t4.name as project,t1.name as execution,if(t3.account is not null, t3.account,t2.assignedTo) as assignedTo,t2.id as taskID, t1.status as projectstatus from TABLE_EXECUTION as t1\r\n left join TABLE_TASK as t2 on t1.id=t2.execution\r\n left join TABLE_TEAM as t3 on t3.type=\'task\' && t3.root=t2.id \r\nleft join TABLE_PROJECT as t4 on t1.project=t4.id\r\nwhere t1.deleted=\'0\' and t1.type in (\'sprint\',\'stage\') and t2.deleted=\'0\' and if($project=\'\',1,t4.id=$project) and if($status=\'\',1,t1.status=$status) and if($beginDate=\'\',1,t1.begin>=$beginDate) and if($endDate=\'\',1,t1.end<=$endDate)', '{\"varName\":[\"project\",\"status\",\"beginDate\",\"endDate\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u72b6\\u6001\",\"\\u6267\\u884c\\u8d77\\u59cb\\u65e5\\u671f\",\"\\u6267\\u884c\\u7ed3\\u675f\\u65e5\\u671f\"],\"requestType\":[\"select\",\"select\",\"date\",\"date\"],\"selectList\":[\"project\",\"project.status\",\"user\",\"user\"],\"default\":[\"\",\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}', '{\"assignedTo\":{\"zh-cn\":\"\\u6307\\u6d3e\\u7ed9\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}', '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"assignedTo\"],\"isUser\":{\"reportField\":[[\"1\"]]},\"reportType\":[\"count\"],\"sumAppend\":[\"\"]}', 2, '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1\\u4efb\\u52a1\\u7684\\u6307\\u6d3e\\u7ed9\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08\\u4efb\\u52d9\\u7684\\u6307\\u6d3e\\u7d66\\u5206\\u5e03\\u60c5\\u6cc1\\u3002\",\"en\":\"According to the project statistics task assigned to the distribution.\"}', 'admin', '2015-07-22 13:13:28'),
('task-finish', '{\"zh-cn\":\"\\u9879\\u76ee\\u4efb\\u52a1\\u5b8c\\u6210\\u8005\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u9805\\u76ee\\u4efb\\u52d9\\u5b8c\\u6210\\u8005\\u7d71\\u8a08\\u8868\",\"en\":\"Task Finish Report\"}', ',project', 'select t1.id,t3.name as project,t1.name as execution,t2.finishedBy,t2.id as taskID, t1.status as projectstatus from TABLE_EXECUTION as t1 \r\nleft join TABLE_TASK as t2 on t1.id=t2.execution\r\nleft join TABLE_PROJECT as t3 on t1.project=t3.id \r\nwhere t1.deleted=\'0\' and t1.type in (\'sprint\',\'stage\') and t2.deleted=\'0\' and t2.finishedBy!=\'\' and if($project=\'\',1,t3.id=$project) and if($status=\'\',1,t1.status=$status) and if($beginDate=\'\',1,t1.begin>=$beginDate) and if($endDate=\'\',1,t1.end<=$endDate)', '{\"varName\":[\"project\",\"status\",\"beginDate\",\"endDate\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u72b6\\u6001\",\"\\u6267\\u884c\\u8d77\\u59cb\\u65e5\\u671f\",\"\\u6267\\u884c\\u7ed3\\u675f\\u65e5\\u671f\"],\"requestType\":[\"select\",\"select\",\"date\",\"date\"],\"selectList\":[\"project\",\"project.status\",\"user\",\"user\"],\"default\":[\"\",\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}', '{\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}', '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"finishedBy\"],\"isUser\":{\"reportField\":[[\"1\"]]},\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}', 2, '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1\\u4efb\\u52a1\\u7684\\u5b8c\\u6210\\u8005\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08\\u4efb\\u52d9\\u7684\\u5b8c\\u6210\\u8005\\u5206\\u5e03\\u60c5\\u6cc1\\u3002\",\"en\":\"According to the project statistics task completion distribution.\"}', 'admin', '2015-07-22 13:16:21'),
('project-invest', '{\"zh-cn\":\"\\u9879\\u76ee\\u6295\\u5165\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u9805\\u76ee\\u6295\\u5165\\u7d71\\u8a08\\u8868\",\"en\":\"Project Invest Report\"}', ',project', 'select t1.id,t5.name as project,t1.name as execution,CONCAT(t1.begin,\' ~ \',t1.end) as timeLimit,t2.teams,t3.stories,round(t4.consumed,1) as consumed,t4.number, t1.status as projectstatus \r\nfrom TABLE_EXECUTION as t1\r\n left join ztv_projectteams as t2 on t1.id=t2.execution\r\nleft join ztv_projectstories as t3 on t1.id=t3.execution\r\n left join ztv_executionsummary as t4 on t1.id=t4.execution \r\nleft join TABLE_PROJECT as t5 on t1.project=t5.id \r\nwhere t1.deleted=\'0\' and t1.type in (\'sprint\',\'stage\') and if($project=\'\',1,t5.id=$project) and if($status=\'\',1,t1.status=$status) and if($beginDate=\'\',1,t1.begin>=$beginDate) and if($endDate=\'\',1,t1.end<=$endDate)', '{\"varName\":[\"project\",\"status\",\"beginDate\",\"endDate\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u72b6\\u6001\",\"\\u6267\\u884c\\u8d77\\u59cb\\u65e5\\u671f\",\"\\u6267\\u884c\\u7ed3\\u675f\\u65e5\\u671f\"],\"requestType\":[\"select\",\"select\",\"date\",\"date\"],\"selectList\":[\"project\",\"project.status\",\"user\",\"user\"],\"default\":[\"\",\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}', '{\"timeLimit\":{\"zh-cn\":\"\\u5de5\\u671f\"},\"teams\":{\"zh-cn\":\"\\u4eba\\u6570\"},\"stories\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\"},\"consumed\":{\"zh-cn\":\"\\u603b\\u6d88\\u8017\"},\"number\":{\"zh-cn\":\"\\u4efb\\u52a1\\u6570\"},\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}', '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"number\",\"stories\",\"teams\",\"consumed\"],\"reportType\":[\"sum\",\"sum\",\"sum\",\"sum\"],\"sumAppend\":[\"number\",\"stories\",\"teams\",\"consumed\"]}', 2, '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u5217\\u51fa\\uff1a\\u4efb\\u52a1\\u6570\\uff0c\\u9700\\u6c42\\u6570\\uff0c\\u4eba\\u6570\\uff0c\\u603b\\u6d88\\u8017\\u5de5\\u65f6\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u5217\\u51fa\\uff1a\\u4efb\\u52d9\\u6578\\uff0c\\u9700\\u6c42\\u6578\\uff0c\\u4eba\\u6578\\uff0c\\u7e3d\\u6d88\\u8017\\u5de5\\u6642\\u3002\",\"en\":\"Listed by project: number of tasks, number of demands, number of people, total hours consumed.\"}', 'admin', '2015-07-22 16:37:38'),
('projectstory-status', '{\"zh-cn\":\"\\u9879\\u76ee\\u9700\\u6c42\\u72b6\\u6001\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76ee\\u9700\\u6c42\\u72c0\\u614b\\u5206\\u5e03\\u8868\",\"en\":\"Project Story Status\"}', ',project', 'select t2.id, t4.name as project,t2.name as execution,t3.status from TABLE_PROJECTSTORY as t1 \r\nleft join TABLE_EXECUTION as t2 on t1.project=t2.id \r\nleft join TABLE_STORY as t3 on t1.story=t3.id \r\nleft join TABLE_PROJECT as t4 on t4.id=t2.project\r\nwhere t2.deleted=\'0\' and t2.type in(\'sprint\', \'stage\') and if($project=\'\',1,t4.id=$project) and if($execution=\'\',1,t2.id=$execution) and if($status=\'\',1,t2.status=$status)', '{\"varName\":[\"project\",\"execution\",\"status\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u5217\\u8868\",\"\\u6267\\u884c\\u72b6\\u6001\"],\"requestType\":[\"select\",\"select\",\"select\"],\"selectList\":[\"project\",\"execution\",\"project.status\"],\"default\":[\"\",\"\",\"\"]}', '{\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}', '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"status\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}', 2, '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1\\u9700\\u6c42\\u7684\\u72b6\\u6001\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08\\u9700\\u6c42\\u7684\\u72c0\\u614b\\u5206\\u5e03\\u60c5\\u6cc1\\u3002\",\"en\":\"According to the project statistics requirement status distribution.\"}', 'admin', '2015-07-23 15:35:08'),
('project-stage', '{\"zh-cn\":\"\\u9879\\u76ee\\u9700\\u6c42\\u9636\\u6bb5\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76ee\\u9700\\u6c42\\u968e\\u6bb5\\u5206\\u5e03\\u8868\",\"en\":\"Project Stage Report\"}', ',project', 'select t2.id, t4.name as project,t2.name as execution,t3.stage from TABLE_PROJECTSTORY as t1 \r\nleft join TABLE_EXECUTION as t2 on t1.project=t2.id \r\nleft join TABLE_STORY as t3 on t1.story=t3.id \r\nleft join TABLE_PROJECT as t4 on t4.id=t2.project\r\nwhere t2.deleted=\'0\' and t2.type in(\'sprint\', \'stage\') and if($project=\'\',1,t4.id=$project) and if($execution=\'\',1,t2.id=$execution) and if($status=\'\',1,t2.status=$status)', '{\"varName\":[\"project\",\"execution\",\"status\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u5217\\u8868\",\"\\u6267\\u884c\\u72b6\\u6001\"],\"requestType\":[\"select\",\"select\",\"select\"],\"selectList\":[\"project\",\"execution\",\"project.status\"],\"default\":[\"\",\"\",\"\"]}', '{\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}', '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"stage\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}', 2, '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1\\u9700\\u6c42\\u9636\\u6bb5\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08\\u9700\\u6c42\\u968e\\u6bb5\\u5206\\u5e03\\u60c5\\u6cc1\\u3002\",\"en\":\"According to the project statistics demand stage distribution.\"}', 'admin', '2015-07-23 15:38:18'),
('projectbug-resolution', '{\"zh-cn\":\"\\u9879\\u76eeBug\\u89e3\\u51b3\\u65b9\\u6848\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76eeBug\\u89e3\\u6c7a\\u65b9\\u6848\\u5206\\u5e03\\u8868\",\"en\":\"Project Bug Resolution\"}', ',project,test', 'select t1.id,t3.name as project,t3.id,t1.name as execution,t1.id as bugID,t2.resolution from TABLE_EXECUTION as t1 \r\nleft join TABLE_BUG as t2 on t1.id=t2.execution\r\nleft join TABLE_PROJECT as t3 on t3.id=t1.project\r\n where t1.deleted=\'0\' and t2.deleted=\'0\' and t2.resolution!=\'\' having bugID!=\'\' and if($project=\'\',1,t3.id=$project) and if($execution=\'\',1,t1.id=$execution)', '{\"varName\":[\"project\",\"execution\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u5217\\u8868\"],\"requestType\":[\"select\",\"select\"],\"selectList\":[\"project\",\"execution\"],\"default\":[\"\",\"\"]}', '{\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}', '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"resolution\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}', 2, '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1Bug\\u7684\\u89e3\\u51b3\\u65b9\\u6848\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08Bug\\u7684\\u89e3\\u6c7a\\u65b9\\u6848\\u5206\\u5e03\\u60c5\\u6cc1\\u3002\",\"en\":\"Solution distribution of statistical bugs by project.\"}', 'admin', '2015-07-23 16:04:46'),
('projectbug-status', '{\"zh-cn\":\"\\u9879\\u76eeBug\\u72b6\\u6001\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76eeBug\\u72c0\\u614b\\u5206\\u5e03\\u8868\",\"en\":\"Project Bug Status\"}', ',project,test', 'select t1.id,t3.name as project,t3.id,t1.name as execution,t1.id as bugID,t2.status from TABLE_EXECUTION as t1 \r\nleft join TABLE_BUG as t2 on t1.id=t2.execution\r\nleft join TABLE_PROJECT as t3 on t3.id=t1.project\r\nwhere t1.deleted=\'0\' and t2.deleted=\'0\' having bugID!=\' \' and if($project=\'\',1,t3.id=$project) and if($execution=\'\',1,t1.id=$execution)', '{\"varName\":[\"project\",\"execution\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u5217\\u8868\"],\"requestType\":[\"select\",\"select\"],\"selectList\":[\"project\",\"execution\"],\"default\":[\"\",\"\"]}', '{\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}', '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"status\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"]}', 2, '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1Bug\\u7684\\u72b6\\u6001\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08Bug\\u7684\\u72c0\\u614b\\u5206\\u5e03\\u60c5\\u6cc1\\u3002\",\"en\":\"Statistics Bug status distribution by project.\"}', 'admin', '2015-07-23 15:48:03'),
('projectbug-opened', '{\"zh-cn\":\"\\u9879\\u76eeBug\\u521b\\u5efa\\u8005\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76eeBug\\u5275\\u5efa\\u8005\\u5206\\u5e03\\u8868\",\"en\":\"Project Bug Opened\"}', ',project,test', 'select t1.id,t3.name as project,t3.id,t1.name as execution,t1.id as bugID,t2.openedBy from TABLE_EXECUTION as t1 \r\nleft join TABLE_BUG as t2 on t1.id=t2.execution\r\nleft join TABLE_PROJECT as t3 on t3.id=t1.project\r\nwhere t1.deleted=\'0\' and t2.deleted=\'0\' having bugID!=\'\' and if($project=\'\',1,t3.id=$project) and if($execution=\'\',1,t1.id=$execution)', '{\"varName\":[\"project\",\"execution\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u5217\\u8868\"],\"requestType\":[\"select\",\"select\"],\"selectList\":[\"project\",\"execution\"],\"default\":[\"\",\"\"]}', '{\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}', '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"openedBy\"],\"isUser\":{\"reportField\":[[\"1\"]]},\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}', 2, '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1Bug\\u7684\\u521b\\u5efa\\u8005\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08Bug\\u7684\\u5275\\u5efa\\u8005\\u5206\\u5e03\\u60c5\\u6cc1\\u3002\",\"en\":\"Bug creator distribution by project.\"}', 'admin', '2015-07-23 16:08:10'),
('projectbug-resolve', '{\"zh-cn\":\"\\u9879\\u76eeBug\\u89e3\\u51b3\\u8005\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76eeBug\\u89e3\\u6c7a\\u8005\\u5206\\u5e03\\u8868\",\"en\":\"Project Bug Resolve\"}', ',project,test', 'select t1.id,t3.name as project,t3.id,t1.name as execution,t1.id as bugID,t2.resolvedBy from TABLE_EXECUTION as t1 \r\nleft join TABLE_BUG as t2 on t1.id=t2.execution\r\nleft join TABLE_PROJECT as t3 on t3.id=t1.project\r\nwhere t1.deleted=\'0\' and t2.deleted=\'0\' and t2.status!=\'active\' and t2.resolvedBy!=\'\' having bugID!=\'\' and if($project=\'\',1,t3.id=$project) and if($execution=\'\',1,t1.id=$execution)', '{\"varName\":[\"project\",\"execution\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u5217\\u8868\"],\"requestType\":[\"select\",\"select\"],\"selectList\":[\"project\",\"execution\"],\"default\":[\"\",\"\"]}', '{\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}', '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"resolvedBy\"],\"isUser\":{\"reportField\":[[\"1\"]]},\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}', 2, '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1Bug\\u7684\\u89e3\\u51b3\\u8005\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08Bug\\u7684\\u89e3\\u6c7a\\u8005\\u5206\\u5e03\\u60c5\\u6cc1\\u3002\",\"en\":\"Bug solver distribution by project.\"}', 'admin', '2015-07-23 16:13:16'),
('projectbug-assign', '{\"zh-cn\":\"\\u9879\\u76eeBug\\u6307\\u6d3e\\u7ed9\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76eeBug\\u6307\\u6d3e\\u7d66\\u5206\\u5e03\\u8868\",\"en\":\"Project Bug Assign\"}', ',project,test', 'select t1.id,t3.name as project,t3.id,t1.name as execution,t1.id as bugID,t2.assignedTo from TABLE_EXECUTION as t1 \r\nleft join TABLE_BUG as t2 on t1.id=t2.execution \r\nleft join TABLE_PROJECT as t3 on t3.id=t1.project\r\nwhere t1.deleted=\'0\' and t2.deleted=\'0\' having bugID!=\'\' and if($project=\'\',1,t3.id=$project) and if($execution=\'\',1,t1.id=$execution)', '{\"varName\":[\"project\",\"execution\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u5217\\u8868\"],\"requestType\":[\"select\",\"select\"],\"selectList\":[\"project\",\"execution\"],\"default\":[\"\",\"\"]}', '{\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}', '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"assignedTo\"],\"isUser\":{\"reportField\":[[\"1\"]]},\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}', 2, '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1Bug\\u7684\\u6307\\u6d3e\\u7ed9\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08Bug\\u7684\\u6307\\u6d3e\\u7d66\\u5206\\u5e03\\u60c5\\u6cc1\\u3002\",\"en\":\"According to the project statistics Bug assigned to the distribution.\"}', 'admin', '2015-07-23 16:29:10'),
('project-quality', '{\"zh-cn\":\"\\u9879\\u76ee\\u8d28\\u91cf\\u8868\",\"zh-tw\":\"\\u9805\\u76ee\\u8cea\\u91cf\\u8868\",\"en\":\"Project Quality Report\"}', ',project', 'select t1.id, t5.name as project,t5.id,t1.name as execution,t2.stories,(t2.stories-t2.undone) as doneStory,t3.number,(t3.number-t3.undone) as doneTask,t4.bugs,t4.resolutions, round(t4.bugs/(t2.stories-t2.undone),2) as bugthanstory,round(t4.bugs/(t3.number-t3.undone),2) as bugthantask,t4.seriousBugs from TABLE_EXECUTION as t1 \r\nleft join ztv_projectstories as t2 on t1.id=t2.execution\r\nleft join ztv_executionsummary as t3 on t1.id=t3.execution\r\nleft join ztv_projectbugs as t4 on t1.id=t4.execution\r\nleft join TABLE_PROJECT as t5 on t5.id=t1.project\r\nwhere t1.deleted=\'0\' and t1.type in (\'sprint\',\'stage\') and t1.grade=\'1\' and if($project=\'\',1,t5.id=$project) and if($execution=\'\',1,t1.id=$execution)', '{\"varName\":[\"project\",\"execution\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u5217\\u8868\"],\"requestType\":[\"select\",\"select\"],\"selectList\":[\"project\",\"execution\"],\"default\":[\"\",\"\"]}', '{\"stories\":{\"zh-cn\":\"\\u9700\\u6c42\\u603b\\u6570\"},\"doneStory\":{\"zh-cn\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\"},\"number\":{\"zh-cn\":\"\\u4efb\\u52a1\\u603b\\u6570\"},\"doneTask\":{\"zh-cn\":\"\\u5b8c\\u6210\\u4efb\\u52a1\\u6570\"},\"bugs\":{\"zh-cn\":\"Bug\\u6570\"},\"resolutions\":{\"zh-cn\":\"\\u89e3\\u51b3Bug\\u6570\"},\"bugthanstory\":{\"zh-cn\":\"Bug\\/\\u5b8c\\u6210\\u9700\\u6c42\"},\"bugthantask\":{\"zh-cn\":\"Bug\\/\\u5b8c\\u6210\\u4efb\\u52a1\"},\"seriousBugs\":{\"zh-cn\":\"\\u91cd\\u8981Bug\\u6570\"},\"seriousBugsPercent\":{\"zh-cn\":\"\\u4e25\\u91cdBug\\u6bd4\\u7387\"},\"project\":{\"zh-cn\":\"\\u9879\\u76ee\\u540d\\u79f0\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}', '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"stories\",\"doneStory\",\"number\",\"doneTask\",\"bugs\",\"resolutions\",\"bugthanstory\",\"bugthantask\",\"seriousBugs\"],\"reportType\":[\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\"],\"sumAppend\":[\"stories\",\"doneStory\",\"number\",\"doneTask\",\"bugs\",\"resolutions\",\"bugthanstory\",\"bugthantask\",\"seriousBugs\"]}', 2, '{\"zh-cn\":\"\\u5217\\u51fa\\u9879\\u76ee\\u7684\\u9700\\u6c42\\u603b\\u6570\\uff0c\\u5b8c\\u6210\\u9700\\u6c42\\u6570\\uff0c\\u4efb\\u52a1\\u603b\\u6570\\uff0c\\u5b8c\\u6210\\u7684\\u4efb\\u52a1\\u6570\\uff0cBug\\u6570\\uff0c\\u89e3\\u51b3\\u7684Bug\\u6570\\uff0cBug\\/\\u9700\\u6c42\\uff0cBug\\/\\u4efb\\u52a1\\uff0c\\u91cd\\u8981Bug\\u6570\\u91cf(\\u4e25\\u91cd\\u7a0b\\u5ea6\\u4e0d\\u5927\\u4e8e3\\uff09\\u3002\",\"zh-tw\":\"\\u5217\\u51fa\\u9805\\u76ee\\u7684\\u9700\\u6c42\\u7e3d\\u6578\\uff0c\\u5b8c\\u6210\\u9700\\u6c42\\u6578\\uff0c\\u4efb\\u52d9\\u7e3d\\u6578\\uff0c\\u5b8c\\u6210\\u7684\\u4efb\\u52d9\\u6578\\uff0cBug\\u6578\\uff0c\\u89e3\\u6c7a\\u7684Bug\\u6578\\uff0cBug\\/\\u9700\\u6c42\\uff0cBug\\/\\u4efb\\u52d9\\uff0c\\u91cd\\u8981Bug\\u6578\\u91cf(\\u56b4\\u91cd\\u7a0b\\u5ea6\\u4e0d\\u5927\\u65bc3\\uff09\\u3002\",\"en\":\"List total requirements, completed requirements, total tasks, completed tasks, bugs, solved bugs, bugs\\/requirements, bugs\\/tasks, critical bugs (severity not greater than 3) for the project.\"}', 'admin', '2015-07-23 17:03:10'),
('productbug-type', '{\"zh-cn\":\"\\u4ea7\\u54c1Bug\\u7c7b\\u578b\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u7522\\u54c1Bug\\u985e\\u578b\\u7d71\\u8a08\\u8868\",\"en\":\"Bug Type of Product\"}', ',product,test', 'select t1.id,t1.name,t2.id as bugID,t2.type from TABLE_PRODUCT as t1 \r\nleft join TABLE_BUG as t2 on t1.id=t2.product \r\nleft join TABLE_PROGRAM as t3 on t1.program=t3.id \r\nwhere t1.deleted=\'0\' and t2.deleted=\'0\'\r\norder by t3.`order` asc, t1.line desc, t1.`order` asc', '', '{\"count\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"done\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u6570\",\"en\":\"Done\"}}', '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"type\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}', 2, '{\"zh-cn\":\"\\u6309\\u7167\\u4ea7\\u54c1\\u7edf\\u8ba1Bug\\u7684\\u7c7b\\u578b\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u7522\\u54c1\\u7d71\\u8a08Bug\\u7684\\u985e\\u578b\\u5206\\u5e03\\u60c5\\u6cc1\\u3002\",\"en\":\"The distribution of Bug types by product statistics.\"}', 'admin', '2015-07-24 13:48:22'),
('product-quality', '{\"zh-cn\":\"\\u4ea7\\u54c1\\u8d28\\u91cf\\u8868\",\"zh-tw\":\"\\u7522\\u54c1\\u8cea\\u91cf\\u8868\",\"en\":\"Product Quality\"}', ',product', 'select t1.id,t1.name,t2.stories,(t2.stories-t2.undone) as doneStory,t3.bugs,t3.resolutions,round(t3.bugs/(t2.stories-t2.undone),2) as bugthanstory,t3.seriousBugs from TABLE_PRODUCT as t1 \r\nleft join ztv_productstories as t2 on t1.id=t2.product \r\nleft join ztv_productbugs as t3 on t1.id=t3.product \r\nleft join TABLE_PROGRAM as t4 on t1.program=t4.id \r\nwhere t1.deleted=\'0\'\r\norder by t4.`order` asc, t1.line desc, t1.`order` asc', '', '{\"stories\":{\"zh-cn\":\"\\u9700\\u6c42\\u603b\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u603b\\u6570\",\"en\":\"Stories\"},\"doneStory\":{\"zh-cn\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"en\":\"Finished Stories\"},\"bugs\":{\"zh-cn\":\"Bug\\u6570\",\"zh-tw\":\"Bug\\u6570\",\"en\":\"Bugs\"},\"resolutions\":{\"zh-cn\":\"\\u89e3\\u51b3Bug\\u6570\",\"zh-tw\":\"\\u89e3\\u51b3Bug\\u6570\",\"en\":\"Solved Bugs\"},\"bugthanstory\":{\"zh-cn\":\"Bug\\/\\u5b8c\\u6210\\u9700\\u6c42\",\"zh-tw\":\"Bug\\/\\u5b8c\\u6210\\u9700\\u6c42\",\"en\":\"Bug\\/Finished Story\"},\"seriousBugs\":{\"zh-cn\":\"\\u91cd\\u8981Bug\\u6570\",\"zh-tw\":\"\\u91cd\\u8981Bug\\u6570\",\"en\":\"Serious Bugs\"},\"seriousBugsPercent\":{\"zh-cn\":\"\\u4e25\\u91cdbug\\u6bd4\\u7387\",\"zh-tw\":\"\\u4e25\\u91cdbug\\u6bd4\\u7387\",\"en\":\"Serious Bugs %\"}}', '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"stories\",\"doneStory\",\"bugs\",\"resolutions\",\"bugthanstory\",\"seriousBugs\"],\"reportType\":[\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\"],\"sumAppend\":[\"stories\",\"doneStory\",\"bugs\",\"resolutions\",\"bugthanstory\",\"seriousBugs\"],\"percent\":{\"5\":\"1\"},\"contrast\":{\"5\":\"bugs\"},\"showAlone\":{\"5\":\"1\"}}', 2, '{\"zh-cn\":\"\\u5217\\u51fa\\u4ea7\\u54c1\\u7684\\u9700\\u6c42\\u6570\\uff0c\\u5b8c\\u6210\\u7684\\u9700\\u6c42\\u603b\\u6570\\uff0cBug\\u6570\\uff0c\\u89e3\\u51b3\\u7684Bug\\u603b\\u6570\\uff0cBug\\/\\u9700\\u6c42\\uff0c\\u91cd\\u8981Bug\\u6570\\u91cf(\\u4e25\\u91cd\\u7a0b\\u5ea6\\u4e0d\\u5927\\u4e8e3)\\u3002\",\"zh-tw\":\"\\u5217\\u51fa\\u7522\\u54c1\\u7684\\u9700\\u6c42\\u6578\\uff0c\\u5b8c\\u6210\\u7684\\u9700\\u6c42\\u7e3d\\u6578\\uff0cBug\\u6578\\uff0c\\u89e3\\u6c7a\\u7684Bug\\u7e3d\\u6578\\uff0cBug\\/\\u9700\\u6c42\\uff0c\\u91cd\\u8981Bug\\u6578\\u91cf(\\u56b4\\u91cd\\u7a0b\\u5ea6\\u4e0d\\u5927\\u65bc3)\\u3002\",\"en\":\"List requirements for the product, total requirements completed, number of bugs, number of bugs solved, bugs\\/requirements, number of significant bugs (severity not greater than 3).\"}', 'admin', '2015-07-23 17:17:40'),
('user-login', '{\"zh-cn\":\"\\u5458\\u5de5\\u767b\\u5f55\\u6b21\\u6570\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u54e1\\u5de5\\u767b\\u9304\\u6b21\\u6578\\u7d71\\u8a08\\u8868\",\"en\":\"Login Times\"}', ',staff', 'select actor,LEFT(`date`,10) as `day` from TABLE_ACTION where `action`=\'login\' and if($startDate=\'\',1,`date`>=$startDate) and if($endDate=\'\',1,`date`<=$endDate) order by `date` asc, actor asc', '{\"varName\":[\"startDate\",\"endDate\"],\"showName\":[\"\\u8d77\\u59cb\\u65f6\\u95f4\",\"\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"date\",\"date\"],\"selectList\":[\"user\",\"user\"],\"default\":[\"$MONTHBEGIN\",\"$MONTHEND\"]}', '{\"count\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"done\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u6570\",\"en\":\"Done\"}}', '{\"group1\":\"actor\",\"isUser\":{\"group1\":[\"1\"]},\"group2\":\"\",\"reportField\":[\"day\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}', 2, '{\"zh-cn\":\"\\u5b9e\\u73b0\\u5458\\u5de5\\u767b\\u5f55\\u6b21\\u6570\\u7edf\\u8ba1\\u62a5\\u8868\\uff0c\\u6309\\u7167\\u5929\\u7edf\\u8ba1\\u6bcf\\u5929\\u6bcf\\u4e2a\\u4eba\\u7684\\u767b\\u5f55\\u6b21\\u6570\\uff0c\\u4ee5\\u53ca\\u603b\\u6570\\u3002\",\"zh-tw\":\"\\u5be6\\u73fe\\u54e1\\u5de5\\u767b\\u9304\\u6b21\\u6578\\u7d71\\u8a08\\u5831\\u8868\\uff0c\\u6309\\u7167\\u5929\\u7d71\\u8a08\\u6bcf\\u5929\\u6bcf\\u500b\\u4eba\\u7684\\u767b\\u9304\\u6b21\\u6578\\uff0c\\u4ee5\\u53ca\\u7e3d\\u6578\\u3002\",\"en\":\"Realize the employee login times statistics report, counting the login times of each person and the total number by day.\"}', 'admin', '2015-07-24 14:28:11'),
('effort', '{\"zh-cn\":\"\\u65e5\\u5fd7\\u6c47\\u603b\\u8868\",\"zh-tw\":\"\\u65e5\\u8a8c\\u532f\\u7e3d\\u8868\",\"en\":\"Effort Summary\"}', ',staff', 'select t1.account,t1.consumed,t1.`date`,if($dept=\'0\',0,t2.dept) as dept from TABLE_EFFORT as t1 left join TABLE_USER as t2 on t1.account=t2.account where t1.`deleted`=\'0\' and if($startDate=\'\',1,t1.`date`>=$startDate) and if($endDate=\'\',1,t1.`date`<=$endDate) having dept=$dept order by `date` asc', '{\"varName\":[\"dept\",\"startDate\",\"endDate\"],\"showName\":[\"\\u90e8\\u95e8\",\"\\u8d77\\u59cb\\u65f6\\u95f4\",\"\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"select\",\"date\",\"date\"],\"selectList\":[\"dept\",\"user\",\"user\"],\"default\":[\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}', '{\"date\":{\"zh-cn\":\"\\u65e5\\u671f\",\"zh-tw\":\"\\u65e5\\u671f\",\"en\":\"Date\"},\"consumed\":{\"zh-cn\":\"\\u6d88\\u8017\\u5de5\\u65f6\",\"zh-tw\":\"\\u6d88\\u8017\\u5de5\\u65f6\",\"en\":\"Cost\"}}', '{\"group1\":\"account\",\"isUser\":{\"group1\":[\"1\"]},\"group2\":\"\",\"reportField\":[\"date\"],\"reportType\":[\"sum\"],\"sumAppend\":[\"consumed\"]}', 2, '{\"zh-cn\":\"\\u67e5\\u770b\\u67d0\\u4e2a\\u65f6\\u95f4\\u6bb5\\u5185\\u7684\\u65e5\\u5fd7\\u60c5\\u51b5\\uff0c\\u53ef\\u4ee5\\u6309\\u7167\\u90e8\\u95e8\\u9009\\u62e9\\u3002\",\"zh-tw\":\"\\u67e5\\u770b\\u67d0\\u500b\\u6642\\u9593\\u6bb5\\u5167\\u7684\\u65e5\\u8a8c\\u60c5\\u6cc1\\uff0c\\u53ef\\u4ee5\\u6309\\u7167\\u90e8\\u9580\\u9078\\u64c7\\u3002\",\"en\":\"You can view the logs of a certain period by department.\"}', 'admin', '2015-07-27 13:53:32'),
('company-dynamic', '{\"zh-cn\":\"\\u516c\\u53f8\\u52a8\\u6001\\u6c47\\u603b\\u8868\",\"zh-tw\":\"\\u516c\\u53f8\\u52d5\\u614b\\u532f\\u7e3d\\u8868\",\"en\":\"Company Dynamics\"}', ',staff', 'select t1.day,t2.userlogin,t3.consumed,t4.storyopen,t5.storyclose,t6.taskopen,t7.taskfinish,t8.bugopen,t9.bugresolve,t1.actions from ztv_dayactions as t1 left join ztv_dayuserlogin as t2 on t1.day=t2.day left join ztv_dayeffort as t3 on t1.day=t3.date left join ztv_daystoryopen as t4 on t1.day=t4.day left join ztv_daystoryclose as t5 on t1.day=t5.day left join ztv_daytaskopen as t6 on t1.day=t6.day left join ztv_daytaskfinish as t7 on t1.day=t7.day left join ztv_daybugopen as t8 on t1.day=t8.day left join ztv_daybugresolve as t9 on t1.day=t9.day where if($startDate=\'\',1,t1.day>=$startDate) and if($endDate=\'\',1,t1.day<=$endDate)', '{\"varName\":[\"startDate\",\"endDate\"],\"showName\":[\"\\u8d77\\u59cb\\u65f6\\u95f4\",\"\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"date\",\"date\"],\"selectList\":[\"user\",\"user\"],\"default\":[\"$MONTHBEGIN\",\"$MONTHEND\"]}', '{\"day\":{\"zh-cn\":\"\\u65e5\\u671f\",\"zh-tw\":\"\\u65e5\\u671f\",\"en\":\"Date\"},\"userlogin\":{\"zh-cn\":\"\\u767b\\u5f55\\u6b21\\u6570\",\"zh-tw\":\"\\u767b\\u9304\\u6b21\\u6578\",\"en\":\"Login\"},\"consumed\":{\"zh-cn\":\"\\u65e5\\u5fd7\\u5de5\\u65f6\",\"zh-tw\":\"\\u65e5\\u8a8c\\u5de5\\u6642\",\"en\":\"Cost(h)\"},\"storyopen\":{\"zh-cn\":\"\\u65b0\\u589e\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u65b0\\u589e\\u9700\\u6c42\\u6578\",\"en\":\"Open Story\"},\"storyclose\":{\"zh-cn\":\"\\u5173\\u95ed\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u95dc\\u9589\\u9700\\u6c42\\u6578\",\"en\":\"Closed Story\"},\"taskopen\":{\"zh-cn\":\"\\u65b0\\u589e\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u65b0\\u589e\\u4efb\\u52d9\\u6578\",\"en\":\"Open Task\"},\"taskfinish\":{\"zh-cn\":\"\\u5b8c\\u6210\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u4efb\\u52d9\\u6578\",\"en\":\"Finished Task\"},\"bugopen\":{\"zh-cn\":\"\\u65b0\\u589eBug\\u6570\",\"zh-tw\":\"\\u65b0\\u589eBug\\u6578\",\"en\":\"Open Bug\"},\"bugresolve\":{\"zh-cn\":\"\\u89e3\\u51b3Bug\\u6570\",\"zh-tw\":\"\\u89e3\\u51b3Bug\\u6578\",\"en\":\"Resolved bug\"},\"actions\":{\"zh-cn\":\"\\u52a8\\u6001\\u6570\",\"zh-tw\":\"\\u52d5\\u614b\\u6578\",\"en\":\"Dynamics\"}}', '{\"group1\":\"day\",\"isUser\":{\"group1\":[\"1\"]},\"group2\":\"\",\"reportField\":[\"userlogin\",\"consumed\",\"storyopen\",\"storyclose\",\"taskopen\",\"taskfinish\",\"bugopen\",\"bugresolve\",\"actions\"],\"reportType\":[\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\"],\"sumAppend\":[\"userlogin\",\"consumed\",\"storyopen\",\"storyclose\",\"taskopen\",\"taskfinish\",\"bugopen\",\"bugresolve\",\"actions\"]}', 2, '{\"zh-cn\":\"\\u53ef\\u4ee5\\u6307\\u5b9a\\u4e00\\u4e2a\\u65f6\\u671f\\uff0c\\u5217\\u51fa\\u76f8\\u5e94\\u7684\\u6570\\u636e\\uff1a1. \\u6bcf\\u5929\\u7684\\u767b\\u5f55\\u6b21\\u6570\\u30022. \\u6bcf\\u5929\\u7684\\u65e5\\u5fd7\\u5de5\\u65f6\\u91cf\\u30023. \\u6bcf\\u5929\\u65b0\\u589e\\u7684\\u9700\\u6c42\\u6570\\u30024. \\u6bcf\\u5929\\u5173\\u95ed\\u7684\\u9700\\u6c42\\u6570\\u30025. \\u6bcf\\u5929\\u65b0\\u589e\\u7684\\u4efb\\u52a1\\u6570\\u30026. \\u6bcf\\u5929\\u5b8c\\u6210\\u7684\\u4efb\\u52a1\\u6570\\u30027. \\u6bcf\\u5929\\u65b0\\u589e\\u7684Bug\\u6570\\u30028. \\u6bcf\\u5929\\u89e3\\u51b3\\u7684Bug\\u6570\\u30029. \\u6bcf\\u5929\\u7684\\u52a8\\u6001\\u6570\\u3002\",\"zh-tw\":\"\\u53ef\\u4ee5\\u6307\\u5b9a\\u4e00\\u500b\\u6642\\u671f\\uff0c\\u5217\\u51fa\\u76f8\\u61c9\\u7684\\u6578\\u64da\\uff1a1. \\u6bcf\\u5929\\u7684\\u767b\\u9304\\u6b21\\u6578\\u30022. \\u6bcf\\u5929\\u7684\\u65e5\\u8a8c\\u5de5\\u6642\\u91cf\\u30023. \\u6bcf\\u5929\\u65b0\\u589e\\u7684\\u9700\\u6c42\\u6578\\u30024. \\u6bcf\\u5929\\u95dc\\u9589\\u7684\\u9700\\u6c42\\u6578\\u30025. \\u6bcf\\u5929\\u65b0\\u589e\\u7684\\u4efb\\u52d9\\u6578\\u30026. \\u6bcf\\u5929\\u5b8c\\u6210\\u7684\\u4efb\\u52d9\\u6578\\u30027. \\u6bcf\\u5929\\u65b0\\u589e\\u7684Bug\\u6578\\u30028. \\u6bcf\\u5929\\u89e3\\u6c7a\\u7684Bug\\u6578\\u30029. \\u6bcf\\u5929\\u7684\\u52d5\\u614b\\u6578\\u3002\",\"en\":\"The summary of company dynamics\"}', 'admin', '2015-07-27 15:09:42'),
('bug-resolve', '{\"zh-cn\":\"Bug\\u89e3\\u51b3\\u8868\",\"zh-tw\":\"Bug\\u89e3\\u6c7a\\u8868\",\"en\":\"Solved Bugs\"}', ',test', 'select *,if($product=\'\',0,product) as customproduct from TABLE_BUG where deleted=\'0\' and resolution!=\'\' and if($startDate=\'\',1,resolvedDate>=$startDate) and if($endDate=\'\',1,resolvedDate<=$endDate) having customproduct=$product', '{\"varName\":[\"product\",\"startDate\",\"endDate\"],\"showName\":[\"\\u4ea7\\u54c1\",\"\\u89e3\\u51b3\\u65e5\\u671f\\u5f00\\u59cb\",\"\\u89e3\\u51b3\\u65e5\\u671f\\u7ed3\\u675f\"],\"requestType\":[\"select\",\"date\",\"date\"],\"selectList\":[\"product\",\"user\",\"user\"],\"default\":[\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}', '{\"count\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"done\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u6570\",\"en\":\"Done\"}}', '{\"group1\":\"resolvedBy\",\"isUser\":{\"group1\":[\"1\"]},\"group2\":\"\",\"reportField\":[\"resolution\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"],\"percent\":[\"1\"],\"contrast\":[\"crystalTotal\"],\"showAlone\":[\"1\"]}', 2, '{\"zh-cn\":\"\\u5217\\u51fa\\u89e3\\u51b3\\u7684Bug\\u603b\\u6570\\uff0c\\u89e3\\u51b3\\u65b9\\u6848\\u7684\\u5206\\u5e03\\uff0c\\u5360\\u7684\\u6bd4\\u4f8b\\uff08\\u8be5\\u7528\\u6237\\u89e3\\u51b3\\u7684Bug\\u7684\\u6570\\u91cf\\u5360\\u6240\\u6709\\u7684\\u89e3\\u51b3\\u7684Bug\\u7684\\u6570\\u91cf)\\u3002\",\"zh-tw\":\"\\u5217\\u51fa\\u89e3\\u6c7a\\u7684Bug\\u7e3d\\u6578\\uff0c\\u89e3\\u6c7a\\u65b9\\u6848\\u7684\\u5206\\u5e03\\uff0c\\u5360\\u7684\\u6bd4\\u4f8b\\uff08\\u8a72\\u7528\\u6236\\u89e3\\u6c7a\\u7684Bug\\u7684\\u6578\\u91cf\\u5360\\u6240\\u6709\\u7684\\u89e3\\u6c7a\\u7684Bug\\u7684\\u6578\\u91cf)\\u3002\",\"en\":\"List the total number of bugs resolved, the distribution of solutions, and the percentage (the number of bugs solved by this user to the total number of bugs resolved).\"}', 'admin', '2015-07-24 13:44:25'),
('project-progress', '{\"zh-cn\":\"\\u9879\\u76ee\\u8fdb\\u5c55\\u8868\",\"zh-tw\":\"\\u9805\\u76ee\\u9032\\u5c55\\u8868\",\"en\":\"Project Progress Report\"}', ',project', 'select t1.id,t4.name as project,t4.id,t1.name as execution,t1.status,t2.number as tasks,round(t2.consumed,2) as consumed,round(t2.`left`,2) as `left`,t3.stories,t2.undone as undoneTask,t3.undone as undoneStory,t2.totalReal from TABLE_EXECUTION as t1 \r\nleft join ztv_executionsummary as t2 on t1.id=t2.execution\r\nleft join ztv_projectstories as t3 on t1.id=t3.execution\r\nleft join TABLE_PROJECT as t4 on t4.id=t1.project\r\nwhere t1.deleted=\'0\' and t1.type in (\'sprint\',\'stage\') and if($project=\'\',1,t4.id=$project) and if($execution=\'\',1,t1.id=$execution) and if($status=\'\' or $status=\'delay\',1,t1.status=$status) and if($status=\'delay\',t1.`end` < curdate(),1)', '{\"varName\":[\"project\",\"execution\",\"status\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u5217\\u8868\",\"\\u6267\\u884c\\u72b6\\u6001\"],\"requestType\":[\"select\",\"select\",\"select\"],\"selectList\":[\"project\",\"execution\",\"project.status\"],\"default\":[\"\",\"\",\"\"]}', '{\"stories\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"tasks\":{\"zh-cn\":\"\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u4efb\\u52a1\\u6570\",\"en\":\"Tasks\"},\"undoneStory\":{\"zh-cn\":\"\\u5269\\u4f59\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u5269\\u4f59\\u9700\\u6c42\\u6570\",\"en\":\"Undone Story\"},\"undoneTask\":{\"zh-cn\":\"\\u5269\\u4f59\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u5269\\u4f59\\u4efb\\u52a1\\u6570\",\"en\":\"Undone Task\"},\"consumed\":{\"zh-cn\":\"\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\",\"zh-tw\":\"\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\",\"en\":\"Cost(h)\"},\"left\":{\"zh-cn\":\"\\u5269\\u4f59\\u5de5\\u65f6\",\"zh-tw\":\"\\u5269\\u4f59\\u5de5\\u65f6\",\"en\":\"Left(h)\"},\"consumedPercent\":{\"zh-cn\":\"\\u8fdb\\u5ea6\",\"zh-tw\":\"\\u8fdb\\u5ea6\",\"en\":\"Process\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}', '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"stories\",\"undoneStory\",\"tasks\",\"undoneTask\",\"left\",\"consumed\"],\"reportType\":[\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\"],\"sumAppend\":[\"stories\",\"undoneStory\",\"tasks\",\"undoneTask\",\"left\",\"consumed\"],\"percent\":{\"5\":\"1\"},\"contrast\":{\"5\":\"totalReal\"},\"showAlone\":{\"5\":\"1\"}}', 2, '{\"zh-cn\":\"\\u9879\\u76ee\\u7684\\u9700\\u6c42\\u6570\\uff0c\\u4efb\\u52a1\\u6570\\uff0c\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\\uff0c\\u5269\\u4f59\\u5de5\\u65f6\\uff0c\\u5269\\u4f59\\u9700\\u6c42\\u6570\\uff0c\\u5269\\u4f59\\u4efb\\u52a1\\u6570\\uff0c\\u8fdb\\u5ea6\\u3002\",\"zh-tw\":\"\\u9805\\u76ee\\u7684\\u9700\\u6c42\\u6578\\uff0c\\u4efb\\u52d9\\u6578\\uff0c\\u5df2\\u6d88\\u8017\\u5de5\\u6642\\uff0c\\u5269\\u9918\\u5de5\\u6642\\uff0c\\u5269\\u9918\\u9700\\u6c42\\u6578\\uff0c\\u5269\\u9918\\u4efb\\u52d9\\u6578\\uff0c\\u9032\\u5ea6\\u3002\",\"en\":\"Project requirements, tasks, consumed hours, remaining hours, remaining demands, remaining tasks, schedule.\"}', 'admin', '2015-07-23 14:03:06'),
('projectbug-type', '{\"zh-cn\":\"\\u9879\\u76eeBug\\u7c7b\\u578b\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u9805\\u76eeBug\\u985e\\u578b\\u7d71\\u8a08\\u8868\",\"en\":\"Project Bug Type\"}', ',project,test', 'select t1.id,t3.name as project,t3.id,t1.name as execution,t2.id as bugID,t2.type from TABLE_EXECUTION as t1 \r\nleft join TABLE_BUG as t2 on t1.id=t2.execution\r\nleft join TABLE_PROJECT as t3 on t3.id=t1.project\r\nwhere t1.deleted=\'0\' and t2.deleted=\'0\' and if($project=\'\',1,t3.id=$project) and if($execution=\'\',1,t1.id=$execution)', '{\"varName\":[\"project\",\"execution\"],\"showName\":[\"\\u9879\\u76ee\\u5217\\u8868\",\"\\u6267\\u884c\\u5217\\u8868\"],\"requestType\":[\"select\",\"select\"],\"selectList\":[\"project\",\"execution\"],\"default\":[\"\",\"\"]}', '{\"stories\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"tasks\":{\"zh-cn\":\"\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u4efb\\u52a1\\u6570\",\"en\":\"Tasks\"},\"undoneStory\":{\"zh-cn\":\"\\u5269\\u4f59\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u5269\\u4f59\\u9700\\u6c42\\u6570\",\"en\":\"Undone Story\"},\"undoneTask\":{\"zh-cn\":\"\\u5269\\u4f59\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u5269\\u4f59\\u4efb\\u52a1\\u6570\",\"en\":\"Undone Task\"},\"consumed\":{\"zh-cn\":\"\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\",\"zh-tw\":\"\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\",\"en\":\"Cost(h)\"},\"left\":{\"zh-cn\":\"\\u5269\\u4f59\\u5de5\\u65f6\",\"zh-tw\":\"\\u5269\\u4f59\\u5de5\\u65f6\",\"en\":\"Left(h)\"},\"consumedPercent\":{\"zh-cn\":\"\\u8fdb\\u5ea6\",\"zh-tw\":\"\\u8fdb\\u5ea6\",\"en\":\"Process\"},\"execution\":{\"zh-cn\":\"\\u6267\\u884c\\u540d\\u79f0\"}}', '{\"group1\":\"project\",\"group2\":\"execution\",\"reportField\":[\"type\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"]}', 2, '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1Bug\\u7684\\u7c7b\\u578b\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\\u6309\\u7167\\u9805\\u76ee\\u7d71\\u8a08Bug\\u7684\\u985e\\u578b\\u5206\\u5e03\\u60c5\\u6cc1\\u3002\",\"en\":\"Type distribution of Bug statistics by project.\"}', 'admin', '2015-08-04 13:54:22');

REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1,'report','browseReport'),
(1,'report','crystalExport'),
(1,'report','custom'),
(1,'report','deleteReport'),
(1,'report','editReport'),
(1,'report','saveReport'),
(1,'report','show'),
(1,'report','useReport'),
(2,'report','show'),
(3,'report','show'),
(4,'report','browseReport'),
(4,'report','crystalExport'),
(4,'report','custom'),
(4,'report','deleteReport'),
(4,'report','editReport'),
(4,'report','saveReport'),
(4,'report','show'),
(4,'report','useReport'),
(5,'report','show'),
(5,'report','crystalExport'),
(6,'report','show'),
(7,'report','crystalExport'),
(7,'report','show'),
(8,'report','show'),
(9,'report','crystalExport'),
(9,'report','show'),
(10,'report','crystalExport'),
(10,'report','show'),
(11,'report','show');
REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1,'report','export'),
(4,'report','export'),
(5,'report','export'),
(6,'report','export'),
(7,'report','export'),
(8,'report','export'),
(9,'report','export'),
(10,'report','export');
REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1,'testreport','export'),
(4,'testreport','export'),
(5,'testreport','export'),
(8,'testreport','export');
-- DROP TABLE IF EXISTS `zt_feedback`;
CREATE TABLE IF NOT EXISTS `zt_feedback` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL,
  `module` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `type` char(30) NOT NULL,
  `solution` char(30) NOT NULL,
  `desc` text NOT NULL,
  `status` varchar(30) NOT NULL,
  `subStatus` varchar(30) NOT NULL default '',
  `public` enum('0','1') NOT NULL DEFAULT '0',
  `notify` enum('0','1') NOT NULL DEFAULT '0',
  `notifyEmail` varchar(100) NOT NULL,
  `likes` text NOT NULL,
  `result` mediumint(8) unsigned NOT NULL,
  `faq` mediumint(8) unsigned NOT NULL,
  `openedBy` char(30) NOT NULL,
  `openedDate` datetime NOT NULL,
  `reviewedBy` varchar(255) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  `processedBy` char(30) NOT NULL,
  `processedDate` datetime NOT NULL,
  `closedBy` char(30) NOT NULL,
  `closedDate` datetime NOT NULL,
  `closedReason` varchar(30) NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedTo` varchar(255) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `feedbackBy` varchar(100) NOT NULL,
  `mailto` varchar(255) NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `zt_bug`   ADD `feedback` mediumint(8) unsigned NOT NULL DEFAULT '0' AFTER `caseVersion`;
ALTER TABLE `zt_story` ADD `feedback` mediumint(8) unsigned NOT NULL DEFAULT '0' AFTER `fromBug`;
ALTER TABLE `zt_user`  ADD `feedback` enum('0', '1') NOT NULL DEFAULT '0' AFTER `locked`;
ALTER TABLE `zt_group` ADD `developer` enum('0', '1') NOT NULL DEFAULT '1' AFTER `acl`;

-- DROP TABLE IF EXISTS `zt_feedbackproduct`;
CREATE TABLE IF NOT EXISTS `zt_feedbackview` (
  `account` char(30) NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  UNIQUE KEY `account_product` (`account`,`product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_serverroom`;
CREATE TABLE IF NOT EXISTS `zt_serverroom` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `city` varchar(128) NOT NULL,
  `line` varchar(20) NOT NULL,
  `bandwidth` varchar(128) NOT NULL,
  `provider` varchar(128) NOT NULL,
  `owner` varchar(30) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_account`;
CREATE TABLE IF NOT EXISTS `zt_account` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `provider` varchar(255) NOT NULL,
  `adminURI` varchar(255) NOT NULL,
  `account` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `mobile` varchar(255) NOT NULL,
  `extra` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `status` varchar(30) NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  key `name` (`name`),
  key `provider` (`provider`),
  key `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_asset`;
CREATE TABLE IF NOT EXISTS `zt_asset` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `status` varchar(30) NOT NULL,
  `type` varchar(30) NOT NULL,
  `group` varchar(128) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_host`;
CREATE TABLE IF NOT EXISTS `zt_host` (
  `id` mediumint(8) unsigned  NOT NULL AUTO_INCREMENT,
  `assetID`      mediumint(8) UNSIGNED NOT NULL,
  `admin`        smallint(5)  UNSIGNED NOT NULL DEFAULT 0,
  `serverRoom`   mediumint(8) UNSIGNED NOT NULL,
  `cabinet`      varchar(128) NOT NULL,
  `serverModel`  varchar(256) NOT NULL,
  `hardwareType` varchar(64)  NOT NULL,
  `hostType`     enum('physical','virtual') NOT NULL,
  `cpuBrand`     varchar(128) NOT NULL,
  `cpuModel`     varchar(128) NOT NULL,
  `cpuNumber`    varchar(16)  NOT NULL,
  `cpuCores`     varchar(30)  NOT NULL,
  `cpuRate`      varchar(30)  NOT NULL,
  `memory`       varchar(30)  NOT NULL,
  `diskType`     varchar(30)  NOT NULL,
  `diskSize`     varchar(30)  NOT NULL,
  `unit`         enum('GB','TB') NOT NULL DEFAULT 'GB',
  `privateIP`    varchar(128) NOT NULL,
  `publicIP`     varchar(128) NOT NULL,
  `nic`          varchar(128) NOT NULL,
  `mac`          varchar(128) NOT NULL,
  `osName`       varchar(64)  NOT NULL,
  `osVersion`    varchar(64)  NOT NULL,
  `webserver`    varchar(128) NOT NULL,
  `database`     varchar(128) NOT NULL,
  `language`     varchar(16)  NOT NULL,
  `status`       varchar(50)  NOT NULL,
  `agentPort` varchar(10) NOT NULL,
  `instanceNum` tinyint(0) NOT NULL DEFAULT 0,
  `pri` smallint(5) unsigned NOT NULL DEFAULT 0,
  `heartbeatTime` datetime NOT NULL,
  `tags` varchar(50)  NOT NULL DEFAULT '',
  `provider` varchar(255) NOT NULL DEFAULT '',
  `bridgeID` varchar(255) NOT NULL DEFAULT '',
  `cloudKey` varchar(255) NOT NULL DEFAULT '',
  `cloudSecret` varchar(255) NOT NULL DEFAULT '',
  `cloudRegion` varchar(255) NOT NULL DEFAULT '',
  `cloudNamespace` varchar(255) NOT NULL DEFAULT '',
  `cloudUser` varchar(255) NOT NULL DEFAULT '',
  `cloudAccount` varchar(255) NOT NULL DEFAULT '',
  `cloudPassword` varchar(255) NOT NULL DEFAULT '',
  `couldVPC` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_service`;
CREATE TABLE IF NOT EXISTS `zt_service` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `external` enum('0','1') NOT NULL DEFAULT '0',
  `port` smallint(5) unsigned NOT NULL,
  `entry` varchar(255) NOT NULL,
  `deploy` varchar(255) NOT NULL,
  `version` varchar(64) NOT NULL,
  `color` char(7) NOT NULL,
  `desc` mediumtext,
  `dept` varchar(128) NOT NULL,
  `devel` varchar(30) NOT NULL,
  `qa` varchar(30) NOT NULL,
  `ops` varchar(30) NOT NULL,
  `hosts` text,
  `softName` varchar(128) NOT NULL,
  `softVersion` varchar(128) NOT NULL,
  `type` varchar(20) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `path` char(255) NOT NULL default '',
  `grade` tinyint(3) unsigned NOT NULL default '0',
  `order` smallint(5) unsigned NOT NULL default '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES (1, 'tree', 'editHost');

-- DROP TABLE IF EXISTS `zt_attend`;
CREATE TABLE IF NOT EXISTS `zt_attend` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `date` date NOT NULL,
  `signIn` time NOT NULL,
  `signOut` time NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `ip` varchar(15) NOT NULL,
  `device` varchar(30) NOT NULL,
  `client` varchar(20) NOT NULL,
  `manualIn` time NOT NULL,
  `manualOut` time NOT NULL,
  `reason` varchar(30) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  `reviewStatus` varchar(30) NOT NULL DEFAULT '',
  `reviewedBy` char(30) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `date` (`date`),
  KEY `status` (`status`),
  KEY `reason` (`reason`),
  KEY `reviewStatus` (`reviewStatus`),
  KEY `reviewedBy` (`reviewedBy`),
  UNIQUE KEY `attend` (`date`,`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_attendstat`;
CREATE TABLE IF NOT EXISTS `zt_attendstat` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL,
  `month` char(10) NOT NULL DEFAULT '',
  `normal` decimal(12,2) NOT NULL DEFAULT 0.00,
  `late` decimal(12,2) NOT NULL DEFAULT 0.00,
  `early` decimal(12,2) NOT NULL DEFAULT 0.00,
  `absent` decimal(12,2) NOT NULL DEFAULT 0.00,
  `trip` decimal(12,2) NOT NULL DEFAULT 0.00,
  `egress` decimal(12,2) NOT NULL DEFAULT 0.00,
  `lieu` decimal(12,2) NOT NULL DEFAULT 0.00,
  `paidLeave` decimal(12,2) NOT NULL DEFAULT 0.00,
  `unpaidLeave` decimal(12,2) NOT NULL DEFAULT 0.00,
  `timeOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `restOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `holidayOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `deserve` decimal(12,2) NOT NULL DEFAULT 0.00,
  `actual` decimal(12,2) NOT NULL DEFAULT 0.00,
  `status` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `month` (`month`),
  KEY `status` (`status`),
  UNIQUE KEY `attend` (`month`,`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_overtime`;
CREATE TABLE IF NOT EXISTS `zt_overtime` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT '0.0',
  `leave` varchar(255) NOT NULL,
  `type` varchar(30) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `rejectReason` varchar(100) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `reviewedBy` char(30) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `type` (`type`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_holiday`;
CREATE TABLE IF NOT EXISTS `zt_holiday` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `type` enum('holiday', 'working') NOT NULL DEFAULT 'holiday',
  `desc` text NOT NULL,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_leave`;
CREATE TABLE IF NOT EXISTS `zt_leave` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT '0.0',
  `backDate` datetime NOT NULL,
  `type` varchar(30) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `reviewedBy` char(30) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `type` (`type`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_lieu`;
CREATE TABLE IF NOT EXISTS `zt_lieu` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT '0.0',
  `overtime` char(255) NOT NULL,
  `trip` char(255) NOT NULL,
  `desc` text NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `reviewedBy` char(30) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_trip`;
CREATE TABLE IF NOT EXISTS `zt_trip` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('trip', 'egress') NOT NULL DEFAULT 'trip',
  `customers` varchar(20) NOT NULL,
  `name` char(30) NOT NULL,
  `desc` text NOT NULL,
  `year` char(4) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `start` time NOT NULL,
  `finish` time NOT NULL,
  `from` char(50) NOT NULL,
  `to` char(50) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `createdBy` (`createdBy`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_deploy`;
CREATE TABLE IF NOT EXISTS `zt_deploy` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `begin` datetime NOT NULL,
  `end` datetime NOT NULL,
  `name` varchar(255) NOT NULL,
  `desc` mediumtext NOT NULL,
  `status` varchar(20) NOT NULL,
  `owner` char(30) NOT NULL,
  `members` text NOT NULL,
  `notify` text NOT NULL,
  `cases` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `result` varchar(20) NOT NULL,
  `deleted` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_deployproduct`;
CREATE TABLE IF NOT EXISTS `zt_deployproduct` (
  `deploy` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `release` mediumint(8) unsigned NOT NULL,
  `package` varchar(255) NOT NULL,
  UNIQUE KEY `deploy_product_release` (`deploy`,`product`,`release`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_deploystep`;
CREATE TABLE IF NOT EXISTS `zt_deploystep` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `deploy` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `begin` datetime NOT NULL,
  `end` datetime NOT NULL,
  `stage` varchar(30) NOT NULL,
  `content` text NOT NULL,
  `status` varchar(30) NOT NULL,
  `assignedTo` char(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `finishedBy` char(30) NOT NULL,
  `finishedDate` datetime NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
ALTER TABLE `zt_testresult` ADD `deploy` mediumint(8) unsigned NOT NULL;
-- DROP TABLE IF EXISTS `zt_deployscope`;
CREATE TABLE IF NOT EXISTS `zt_deployscope` (
  `deploy` mediumint(8) unsigned NOT NULL,
  `service` mediumint(8) unsigned NOT NULL,
  `hosts` text NOT NULL,
  `remove` text NOT NULL,
  `add` text NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_vm`;
CREATE TABLE IF NOT EXISTS `zt_vm` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hostID` int(10) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `osCategory` varchar(50) NOT NULL DEFAULT '',
  `osType` varchar(50) NOT NULL DEFAULT '',
  `osArch` varchar(50) NOT NULL DEFAULT '',
  `osLang` varchar(50) NOT NULL DEFAULT '',
  `osCpu` tinyint(2) NOT NULL DEFAULT 0,
  `osMemory` smallint(6) NOT NULL DEFAULT 0,
  `osDisk` smallint(6) NOT NULL DEFAULT 0,
  `status` varchar(50) NOT NULL DEFAULT '',
  `destroyAt` datetime NULL,
  `macAddress` varchar(255) NOT NULL DEFAULT '',
  `workspace` varchar(255) NOT NULL DEFAULT '',
  `templateID` int(10) unsigned NOT NULL DEFAULT 0,
  `baseImageID` int(10) unsigned NOT NULL DEFAULT 0,
  `baseImagePath` varchar(255) NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `heatbeat` datetime NULL,
  `vncPort` int(10) NOT NULL DEFAULT 0,
  `instance` varchar(255) NOT NULL DEFAULT '',
  `eip` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `public` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_baseimage`;
CREATE TABLE IF NOT EXISTS `zt_baseimage` (
  `id` SMALLINT(7) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `osType` varchar(50) NOT NULL DEFAULT '',
  `os` varchar(50) NOT NULL DEFAULT '',
  `osCategory` varchar(50) NOT NULL DEFAULT '',
  `osArch` varchar(50) NOT NULL DEFAULT '',
  `osLang` varchar(50) NOT NULL DEFAULT '',
  `suggestCore` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `suggestMemory` mediumint(6) unsigned NOT NULL DEFAULT 0,
  `suggestVolume` mediumint(6) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_vmtemplate`;
CREATE TABLE IF NOT EXISTS `zt_vmtemplate` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `hostID` int(10) unsigned NOT NULL DEFAULT 0,
  `templateName` varchar(255) NOT NULL DEFAULT '',
  `osType` varchar(50) NOT NULL DEFAULT '',
  `osCategory` varchar(50) NOT NULL DEFAULT '',
  `osVersion` varchar(50) NOT NULL DEFAULT '',
  `osLang` varchar(50) NOT NULL,
  `cpuCoreNum` smallint(4) NOT NULL DEFAULT 0,
  `memorySize` int NOT NULL DEFAULT 0,
  `diskSize` int NOT NULL DEFAULT 0,
  `osArch` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_browser`;
CREATE TABLE IF NOT EXISTS `zt_browser` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(255) NOT NULL DEFAULT '',
  `lang` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_baseimagebrowser`;
CREATE TABLE IF NOT EXISTS `zt_baseimagebrowser` (
  `vmBackingID` int(10) NOT NULL,
  `browserID` int(10) NOT NULL,
  PRIMARY KEY (`vmBackingID`, `browserID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_traincourse`;
CREATE TABLE `zt_traincourse` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) NOT NULL,
  `category` mediumint(8) NOT NULL,
  `name` varchar(255) NOT NULL,
  `status` varchar(10) NOT NULL,
  `teacher` varchar(30) NOT NULL default '',
  `desc` mediumtext NOT NULL,
  `createdBy` varchar(255) NOT NULL,
  `createdDate` date NOT NULL,
  `editedBy` varchar(255) NOT NULL,
  `editedDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_traincontents`;
CREATE TABLE IF NOT EXISTS `zt_traincontents` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(50) NOT NULL,
  `course` mediumint(8) unsigned NOT NULL default '0',
  `name` varchar(255) NOT NULL,
  `type` varchar(30) NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `path` char(255) NOT NULL DEFAULT '',
  `desc` text NOT NULL,
  `order` mediumint(8) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_traincategory`;
CREATE TABLE IF NOT EXISTS `zt_traincategory` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(30) NOT NULL DEFAULT '',
  `parent` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `path` char(255) NOT NULL DEFAULT '',
  `grade` tinyint(3) NOT NULL,
  `order` mediumint(8) NOT NULL,
  `deleted` enum('0', '1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `path` (`path`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_trainrecords`;
CREATE TABLE IF NOT EXISTS `zt_trainrecords` (
  `user` char(30) NOT NULL,
  `objectId` mediumint(8) unsigned NOT NULL,
  `objectType` varchar(10) NOT NULL,
  `status` varchar(10) NOT NULL,
  PRIMARY KEY (`user`, `objectId`, `objectType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `zt_doc`
ADD `parent` smallint(5) unsigned NOT NULL DEFAULT '0' AFTER `type`,
ADD `path` char(255) COLLATE 'utf8_general_ci' NOT NULL DEFAULT '' AFTER `parent`,
ADD `grade` tinyint(3) unsigned NOT NULL DEFAULT '0' AFTER `path`,
ADD `order` smallint(5) unsigned NOT NULL DEFAULT '0' AFTER `grade`;

ALTER TABLE `zt_product` ADD `feedback` varchar(30) COLLATE 'utf8_general_ci' NOT NULL AFTER `RD`;

ALTER TABLE `zt_leave`       ADD `level` tinyint(3) NOT NULL;
ALTER TABLE `zt_leave`       ADD `assignedTo` varchar(30) NOT NULL;
ALTER TABLE `zt_leave`       ADD `reviewers` text NOT NULL;
ALTER TABLE `zt_leave`       ADD `backReviewers` text NOT NULL;
ALTER TABLE `zt_lieu`        ADD `level` tinyint(3) NOT NULL;
ALTER TABLE `zt_lieu`        ADD `assignedTo` varchar(30) NOT NULL;
ALTER TABLE `zt_lieu`        ADD `reviewers` text NOT NULL;
ALTER TABLE `zt_overtime`    ADD `level` tinyint(3) NOT NULL;
ALTER TABLE `zt_overtime`    ADD `assignedTo` varchar(30) NOT NULL;
ALTER TABLE `zt_overtime`    ADD `reviewers` text NOT NULL;

-- DROP TABLE IF EXISTS `zt_faq`;
CREATE TABLE IF NOT EXISTS `zt_faq` (
`id` mediumint(9) NOT NULL AUTO_INCREMENT,
`module` mediumint(9) NOT NULL,
`product` mediumint(9) NOT NULL,
`question` varchar(255) NOT NULL,
`answer` text NOT NULL,
`addedtime` datetime NOT NULL,
PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `zt_task` ADD `feedback` mediumint(8) unsigned NOT NULL AFTER `fromBug`;
ALTER TABLE `zt_todo` ADD `feedback` mediumint(8) unsigned NOT NULL AFTER `end`;

-- DROP TABLE IF EXISTS `zt_domain`;
CREATE TABLE IF NOT EXISTS `zt_domain`(
  `id` smallint(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `domain` varchar(255) NOT NULL,
  `adminURI` varchar(255) NOT NULL,
  `resolverURI` varchar(255) NOT NULL,
  `register` varchar(255) NOT NULL,
  `expiredDate` datetime NOT NULL,
  `renew` varchar(255) NOT NULL,
  `account` varchar(255) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  key `domain` (`domain`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP VIEW IF EXISTS `view_datasource_5`;
CREATE VIEW `view_datasource_5`  AS select `id`,`name` from `zt_task` where `deleted` = '0' and vision = 'rnd';

DROP VIEW IF EXISTS `view_datasource_54`;
CREATE VIEW `view_datasource_54` AS select `id`,`name` from `zt_task` where `deleted` = '0' and vision = 'lite';

UPDATE `zt_user` SET `visions` = 'lite', `feedback` = '0' WHERE `feedback` = '1';

REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1,'account','browse'),
(1,'account','create'),
(1,'account','delete'),
(1,'account','edit'),
(1,'account','view'),
(1,'attend','browseReview'),
(1,'attend','company'),
(1,'attend','department'),
(1,'attend','detail'),
(1,'attend','edit'),
(1,'attend','export'),
(1,'attend','exportDetail'),
(1,'attend','exportStat'),
(1,'attend','personal'),
(1,'attend','personalSettings'),
(1,'attend','review'),
(1,'attend','saveStat'),
(1,'attend','setManager'),
(1,'attend','settings'),
(1,'attend','stat'),
(1,'build','browse'),
(1,'custom','feedback'),
(1,'custom','libreoffice'),
(1,'deploy','activate'),
(1,'deploy','assignTo'),
(1,'deploy','batchUnlinkCases'),
(1,'deploy','browse'),
(1,'deploy','cases'),
(1,'deploy','create'),
(1,'deploy','delete'),
(1,'deploy','deleteStep'),
(1,'deploy','edit'),
(1,'deploy','editStep'),
(1,'deploy','finish'),
(1,'deploy','finishStep'),
(1,'deploy','linkCases'),
(1,'deploy','manageScope'),
(1,'deploy','manageStep'),
(1,'deploy','scope'),
(1,'deploy','steps'),
(1,'deploy','unlinkCase'),
(1,'deploy','view'),
(1,'deploy','viewStep'),
(1,'doc','catalog'),
(1,'doc','diff'),
(1,'doc','manageBook'),
(1,'domain','browse'),
(1,'domain','create'),
(1,'domain','delete'),
(1,'domain','edit'),
(1,'domain','view'),
(1,'faq','browse'),
(1,'faq','create'),
(1,'faq','delete'),
(1,'faq','edit'),
(1,'feedback','admin'),
(1,'feedback','adminView'),
(1,'feedback','assignTo'),
(1,'feedback','batchAssignTo'),
(1,'feedback','batchChangeModule'),
(1,'feedback','batchClose'),
(1,'feedback','batchEdit'),
(1,'feedback','batchReview'),
(1,'feedback','browse'),
(1,'feedback','close'),
(1,'feedback','comment'),
(1,'feedback','create'),
(1,'feedback','delete'),
(1,'feedback','edit'),
(1,'feedback','export'),
(1,'feedback','index'),
(1,'feedback','manageProduct'),
(1,'feedback','products'),
(1,'feedback','review'),
(1,'feedback','view'),
(1,'holiday','browse'),
(1,'holiday','create'),
(1,'holiday','delete'),
(1,'holiday','edit'),
(1,'host','browse'),
(1,'host','changeStatus'),
(1,'host','create'),
(1,'host','delete'),
(1,'host','edit'),
(1,'host','treemap'),
(1,'host','view'),
(1,'leave','back'),
(1,'leave','browseReview'),
(1,'leave','company'),
(1,'leave','create'),
(1,'leave','delete'),
(1,'leave','edit'),
(1,'leave','export'),
(1,'leave','personal'),
(1,'leave','personalAnnual'),
(1,'leave','review'),
(1,'leave','setReviewer'),
(1,'leave','switchstatus'),
(1,'leave','view'),
(1,'lieu','browseReview'),
(1,'lieu','company'),
(1,'lieu','create'),
(1,'lieu','delete'),
(1,'lieu','edit'),
(1,'lieu','personal'),
(1,'lieu','review'),
(1,'lieu','setReviewer'),
(1,'lieu','switchstatus'),
(1,'lieu','view'),
(1,'makeup','browseReview'),
(1,'makeup','company'),
(1,'makeup','create'),
(1,'makeup','delete'),
(1,'makeup','edit'),
(1,'makeup','export'),
(1,'makeup','personal'),
(1,'makeup','review'),
(1,'makeup','setReviewer'),
(1,'makeup','switchstatus'),
(1,'makeup','view'),
(1,'my','review'),
(1,'ops','index'),
(1,'ops','setting'),
(1,'overtime','browseReview'),
(1,'overtime','company'),
(1,'overtime','create'),
(1,'overtime','delete'),
(1,'overtime','edit'),
(1,'overtime','export'),
(1,'overtime','personal'),
(1,'overtime','review'),
(1,'overtime','setReviewer'),
(1,'overtime','switchstatus'),
(1,'overtime','view'),
(1,'serverroom','browse'),
(1,'serverroom','create'),
(1,'serverroom','delete'),
(1,'serverroom','edit'),
(1,'serverroom','view'),
(1,'service','browse'),
(1,'service','create'),
(1,'service','delete'),
(1,'service','edit'),
(1,'service','index'),
(1,'service','manage'),
(1,'service','view'),
(1,'story','browse'),
(1,'task','browse'),
(1,'testtask','deployCaseResults'),
(1,'testtask','runDeployCase'),
(1,'tree','browsehost'),
(1,'tree','editHost'),
(1,'workflow','activate'),
(1,'workflow','backup'),
(1,'workflow','browse'),
(1,'workflow','browseDB'),
(1,'workflow','browseFlow'),
(1,'workflow','copy'),
(1,'workflow','create'),
(1,'workflow','deactivate'),
(1,'workflow','delete'),
(1,'workflow','edit'),
(1,'workflow','flowchart'),
(1,'workflow','release'),
(1,'workflow','setCSS'),
(1,'workflow','setJS'),
(1,'workflow','ui'),
(1,'workflow','upgrade'),
(1,'workflow','view'),
(1,'workflowaction','browse'),
(1,'workflowaction','create'),
(1,'workflowaction','delete'),
(1,'workflowaction','edit'),
(1,'workflowaction','setCSS'),
(1,'workflowaction','setJS'),
(1,'workflowaction','setNotice'),
(1,'workflowaction','setVerification'),
(1,'workflowaction','sort'),
(1,'workflowaction','view'),
(1,'workflowcondition','browse'),
(1,'workflowcondition','create'),
(1,'workflowcondition','delete'),
(1,'workflowcondition','edit'),
(1,'workflowdatasource','browse'),
(1,'workflowdatasource','create'),
(1,'workflowdatasource','delete'),
(1,'workflowdatasource','edit'),
(1,'workflowfield','browse'),
(1,'workflowfield','create'),
(1,'workflowfield','delete'),
(1,'workflowfield','edit'),
(1,'workflowfield','exportTemplate'),
(1,'workflowfield','import'),
(1,'workflowfield','setExport'),
(1,'workflowfield','setSearch'),
(1,'workflowfield','setValue'),
(1,'workflowfield','showImport'),
(1,'workflowfield','sort'),
(1,'workflowhook','browse'),
(1,'workflowhook','create'),
(1,'workflowhook','delete'),
(1,'workflowhook','edit'),
(1,'workflowlabel','browse'),
(1,'workflowlabel','create'),
(1,'workflowlabel','delete'),
(1,'workflowlabel','edit'),
(1,'workflowlabel','sort'),
(1,'workflowlayout','admin'),
(1,'workflowlayout','block'),
(1,'workflowlinkage','browse'),
(1,'workflowlinkage','create'),
(1,'workflowlinkage','delete'),
(1,'workflowlinkage','edit'),
(1,'workflowrelation','admin'),
(1,'workflowreport','browse'),
(1,'workflowreport','create'),
(1,'workflowreport','delete'),
(1,'workflowreport','edit'),
(1,'workflowreport','sort'),
(1,'workflowrule','browse'),
(1,'workflowrule','create'),
(1,'workflowrule','delete'),
(1,'workflowrule','edit'),
(1,'workflowrule','view'),
(2,'account','browse'),
(2,'account','view'),
(2,'attend','company'),
(2,'attend','department'),
(2,'attend','detail'),
(2,'attend','edit'),
(2,'attend','export'),
(2,'attend','exportDetail'),
(2,'attend','exportStat'),
(2,'attend','personal'),
(2,'build','browse'),
(2,'deploy','activate'),
(2,'deploy','assignTo'),
(2,'deploy','batchUnlinkCases'),
(2,'deploy','browse'),
(2,'deploy','cases'),
(2,'deploy','create'),
(2,'deploy','delete'),
(2,'deploy','deleteStep'),
(2,'deploy','edit'),
(2,'deploy','editStep'),
(2,'deploy','finish'),
(2,'deploy','finishStep'),
(2,'deploy','linkCases'),
(2,'deploy','manageScope'),
(2,'deploy','manageStep'),
(2,'deploy','scope'),
(2,'deploy','steps'),
(2,'deploy','unlinkCase'),
(2,'deploy','view'),
(2,'deploy','viewStep'),
(2,'doc','diff'),
(2,'domain','browse'),
(2,'domain','view'),
(2,'feedback','admin'),
(2,'feedback','adminView'),
(2,'feedback','batchAssignTo'),
(2,'feedback','batchClose'),
(2,'feedback','batchEdit'),
(2,'feedback','browse'),
(2,'feedback','close'),
(2,'feedback','comment'),
(2,'feedback','create'),
(2,'feedback','delete'),
(2,'feedback','edit'),
(2,'feedback','index'),
(2,'feedback','view'),
(2,'holiday','browse'),
(2,'holiday','create'),
(2,'holiday','delete'),
(2,'holiday','edit'),
(2,'host','browse'),
(2,'host','changeStatus'),
(2,'host','create'),
(2,'host','delete'),
(2,'host','edit'),
(2,'host','treemap'),
(2,'host','view'),
(2,'leave','create'),
(2,'leave','delete'),
(2,'leave','edit'),
(2,'leave','export'),
(2,'leave','personal'),
(2,'leave','personalAnnual'),
(2,'leave','switchstatus'),
(2,'leave','view'),
(2,'lieu','create'),
(2,'lieu','delete'),
(2,'lieu','edit'),
(2,'lieu','personal'),
(2,'lieu','switchstatus'),
(2,'lieu','view'),
(2,'makeup','create'),
(2,'makeup','delete'),
(2,'makeup','edit'),
(2,'makeup','export'),
(2,'makeup','personal'),
(2,'makeup','switchstatus'),
(2,'makeup','view'),
(2,'my','review'),
(2,'ops','index'),
(2,'ops','setting'),
(2,'overtime','create'),
(2,'overtime','delete'),
(2,'overtime','edit'),
(2,'overtime','export'),
(2,'overtime','personal'),
(2,'overtime','switchstatus'),
(2,'overtime','view'),
(2,'serverroom','browse'),
(2,'serverroom','create'),
(2,'serverroom','delete'),
(2,'serverroom','edit'),
(2,'serverroom','view'),
(2,'service','browse'),
(2,'service','create'),
(2,'service','delete'),
(2,'service','edit'),
(2,'service','index'),
(2,'service','manage'),
(2,'service','view'),
(2,'story','browse'),
(2,'task','browse'),
(3,'attend','company'),
(3,'attend','department'),
(3,'attend','detail'),
(3,'attend','edit'),
(3,'attend','export'),
(3,'attend','exportDetail'),
(3,'attend','personal'),
(3,'doc','diff'),
(3,'leave','back'),
(3,'leave','create'),
(3,'leave','delete'),
(3,'leave','edit'),
(3,'leave','export'),
(3,'leave','personal'),
(3,'leave','personalAnnual'),
(3,'leave','switchstatus'),
(3,'leave','view'),
(3,'lieu','create'),
(3,'lieu','delete'),
(3,'lieu','edit'),
(3,'lieu','personal'),
(3,'lieu','switchstatus'),
(3,'lieu','view'),
(3,'makeup','create'),
(3,'makeup','delete'),
(3,'makeup','edit'),
(3,'makeup','personal'),
(3,'makeup','switchstatus'),
(3,'makeup','view'),
(3,'my','review'),
(3,'overtime','create'),
(3,'overtime','delete'),
(3,'overtime','edit'),
(3,'overtime','export'),
(3,'overtime','personal'),
(3,'overtime','switchstatus'),
(3,'overtime','view'),
(3,'testtask','deployCaseResults'),
(3,'testtask','runDeployCase'),
(4,'account','browse'),
(4,'account','create'),
(4,'account','delete'),
(4,'account','edit'),
(4,'account','view'),
(4,'attend','browseReview'),
(4,'attend','company'),
(4,'attend','department'),
(4,'attend','detail'),
(4,'attend','edit'),
(4,'attend','export'),
(4,'attend','exportDetail'),
(4,'attend','exportStat'),
(4,'attend','personal'),
(4,'attend','review'),
(4,'attend','saveStat'),
(4,'attend','stat'),
(4,'deploy','activate'),
(4,'deploy','assignTo'),
(4,'deploy','batchUnlinkCases'),
(4,'deploy','browse'),
(4,'deploy','cases'),
(4,'deploy','create'),
(4,'deploy','delete'),
(4,'deploy','deleteStep'),
(4,'deploy','edit'),
(4,'deploy','editStep'),
(4,'deploy','finish'),
(4,'deploy','finishStep'),
(4,'deploy','linkCases'),
(4,'deploy','manageScope'),
(4,'deploy','manageStep'),
(4,'deploy','scope'),
(4,'deploy','steps'),
(4,'deploy','unlinkCase'),
(4,'deploy','view'),
(4,'deploy','viewStep'),
(4,'doc','catalog'),
(4,'doc','diff'),
(4,'doc','manageBook'),
(4,'domain','browse'),
(4,'domain','create'),
(4,'domain','delete'),
(4,'domain','edit'),
(4,'domain','view'),
(4,'faq','browse'),
(4,'feedback','admin'),
(4,'feedback','adminView'),
(4,'feedback','assignTo'),
(4,'feedback','batchAssignTo'),
(4,'feedback','batchChangeModule'),
(4,'feedback','batchClose'),
(4,'feedback','batchEdit'),
(4,'feedback','batchReview'),
(4,'feedback','browse'),
(4,'feedback','close'),
(4,'feedback','comment'),
(4,'feedback','create'),
(4,'feedback','delete'),
(4,'feedback','edit'),
(4,'feedback','export'),
(4,'feedback','index'),
(4,'feedback','manageProduct'),
(4,'feedback','products'),
(4,'feedback','review'),
(4,'feedback','view'),
(4,'host','browse'),
(4,'host','create'),
(4,'host','delete'),
(4,'host','edit'),
(4,'host','treemap'),
(4,'host','view'),
(4,'leave','back'),
(4,'leave','browseReview'),
(4,'leave','company'),
(4,'leave','create'),
(4,'leave','delete'),
(4,'leave','edit'),
(4,'leave','export'),
(4,'leave','personal'),
(4,'leave','personalAnnual'),
(4,'leave','review'),
(4,'leave','setReviewer'),
(4,'leave','switchstatus'),
(4,'leave','view'),
(4,'lieu','browseReview'),
(4,'lieu','company'),
(4,'lieu','create'),
(4,'lieu','delete'),
(4,'lieu','edit'),
(4,'lieu','personal'),
(4,'lieu','review'),
(4,'lieu','setReviewer'),
(4,'lieu','switchstatus'),
(4,'lieu','view'),
(4,'makeup','browseReview'),
(4,'makeup','company'),
(4,'makeup','create'),
(4,'makeup','delete'),
(4,'makeup','edit'),
(4,'makeup','export'),
(4,'makeup','personal'),
(4,'makeup','review'),
(4,'makeup','setReviewer'),
(4,'makeup','switchstatus'),
(4,'makeup','view'),
(4,'my','review'),
(4,'ops','index'),
(4,'ops','setting'),
(4,'overtime','browseReview'),
(4,'overtime','company'),
(4,'overtime','create'),
(4,'overtime','delete'),
(4,'overtime','edit'),
(4,'overtime','export'),
(4,'overtime','personal'),
(4,'overtime','review'),
(4,'overtime','setReviewer'),
(4,'overtime','switchstatus'),
(4,'overtime','view'),
(4,'serverroom','browse'),
(4,'serverroom','create'),
(4,'serverroom','delete'),
(4,'serverroom','edit'),
(4,'serverroom','view'),
(4,'service','browse'),
(4,'service','create'),
(4,'service','delete'),
(4,'service','edit'),
(4,'service','index'),
(4,'service','manage'),
(4,'service','view'),
(4,'story','browse'),
(4,'testtask','deployCaseResults'),
(4,'testtask','runDeployCase'),
(4,'tree','browsehost'),
(5,'account','browse'),
(5,'account','create'),
(5,'account','delete'),
(5,'account','edit'),
(5,'account','view'),
(5,'attend','company'),
(5,'attend','department'),
(5,'attend','edit'),
(5,'attend','export'),
(5,'attend','personal'),
(5,'attend','review'),
(5,'build','browse'),
(5,'deploy','activate'),
(5,'deploy','assignTo'),
(5,'deploy','batchUnlinkCases'),
(5,'deploy','browse'),
(5,'deploy','cases'),
(5,'deploy','create'),
(5,'deploy','delete'),
(5,'deploy','deleteStep'),
(5,'deploy','edit'),
(5,'deploy','editStep'),
(5,'deploy','finish'),
(5,'deploy','finishStep'),
(5,'deploy','linkCases'),
(5,'deploy','manageScope'),
(5,'deploy','manageStep'),
(5,'deploy','scope'),
(5,'deploy','steps'),
(5,'deploy','unlinkCase'),
(5,'deploy','view'),
(5,'deploy','viewStep'),
(5,'domain','browse'),
(5,'domain','create'),
(5,'domain','delete'),
(5,'domain','edit'),
(5,'domain','view'),
(5,'faq','browse'),
(5,'faq','create'),
(5,'faq','delete'),
(5,'faq','edit'),
(5,'feedback','admin'),
(5,'feedback','adminView'),
(5,'feedback','assignTo'),
(5,'feedback','batchAssignTo'),
(5,'feedback','batchChangeModule'),
(5,'feedback','batchClose'),
(5,'feedback','batchEdit'),
(5,'feedback','batchReview'),
(5,'feedback','browse'),
(5,'feedback','close'),
(5,'feedback','comment'),
(5,'feedback','create'),
(5,'feedback','delete'),
(5,'feedback','edit'),
(5,'feedback','export'),
(5,'feedback','index'),
(5,'feedback','manageProduct'),
(5,'feedback','products'),
(5,'feedback','review'),
(5,'feedback','view'),
(5,'holiday','browse'),
(5,'host','browse'),
(5,'host','changeStatus'),
(5,'host','create'),
(5,'host','delete'),
(5,'host','edit'),
(5,'host','treemap'),
(5,'host','view'),
(5,'leave','back'),
(5,'leave','create'),
(5,'leave','delete'),
(5,'leave','edit'),
(5,'leave','export'),
(5,'leave','personal'),
(5,'leave','personalAnnual'),
(5,'leave','switchstatus'),
(5,'leave','view'),
(5,'lieu','create'),
(5,'lieu','delete'),
(5,'lieu','edit'),
(5,'lieu','personal'),
(5,'lieu','switchstatus'),
(5,'lieu','view'),
(5,'makeup','create'),
(5,'makeup','delete'),
(5,'makeup','edit'),
(5,'makeup','export'),
(5,'makeup','personal'),
(5,'makeup','switchstatus'),
(5,'makeup','view'),
(5,'my','review'),
(5,'ops','index'),
(5,'ops','setting'),
(5,'overtime','create'),
(5,'overtime','delete'),
(5,'overtime','edit'),
(5,'overtime','export'),
(5,'overtime','personal'),
(5,'overtime','switchstatus'),
(5,'overtime','view'),
(5,'serverroom','browse'),
(5,'serverroom','create'),
(5,'serverroom','delete'),
(5,'serverroom','edit'),
(5,'serverroom','view'),
(5,'service','browse'),
(5,'service','create'),
(5,'service','delete'),
(5,'service','edit'),
(5,'service','index'),
(5,'service','manage'),
(5,'service','view'),
(5,'story','browse'),
(5,'task','browse'),
(6,'account','browse'),
(6,'account','create'),
(6,'account','delete'),
(6,'account','edit'),
(6,'account','view'),
(6,'attend','company'),
(6,'attend','department'),
(6,'attend','detail'),
(6,'attend','edit'),
(6,'attend','export'),
(6,'attend','exportDetail'),
(6,'attend','exportStat'),
(6,'attend','personal'),
(6,'deploy','activate'),
(6,'deploy','assignTo'),
(6,'deploy','batchUnlinkCases'),
(6,'deploy','browse'),
(6,'deploy','cases'),
(6,'deploy','create'),
(6,'deploy','delete'),
(6,'deploy','deleteStep'),
(6,'deploy','edit'),
(6,'deploy','editStep'),
(6,'deploy','finish'),
(6,'deploy','finishStep'),
(6,'deploy','linkCases'),
(6,'deploy','manageScope'),
(6,'deploy','manageStep'),
(6,'deploy','scope'),
(6,'deploy','steps'),
(6,'deploy','unlinkCase'),
(6,'deploy','view'),
(6,'deploy','viewStep'),
(6,'domain','browse'),
(6,'domain','create'),
(6,'domain','delete'),
(6,'domain','edit'),
(6,'domain','view'),
(6,'faq','browse'),
(6,'feedback','admin'),
(6,'feedback','adminView'),
(6,'feedback','assignTo'),
(6,'feedback','batchAssignTo'),
(6,'feedback','batchClose'),
(6,'feedback','batchEdit'),
(6,'feedback','batchReview'),
(6,'feedback','close'),
(6,'feedback','comment'),
(6,'feedback','delete'),
(6,'feedback','export'),
(6,'feedback','index'),
(6,'feedback','review'),
(6,'feedback','view'),
(6,'host','browse'),
(6,'host','changeStatus'),
(6,'host','create'),
(6,'host','delete'),
(6,'host','edit'),
(6,'host','treemap'),
(6,'host','view'),
(6,'leave','back'),
(6,'leave','create'),
(6,'leave','delete'),
(6,'leave','edit'),
(6,'leave','export'),
(6,'leave','personal'),
(6,'leave','personalAnnual'),
(6,'leave','switchstatus'),
(6,'leave','view'),
(6,'lieu','create'),
(6,'lieu','delete'),
(6,'lieu','edit'),
(6,'lieu','personal'),
(6,'lieu','view'),
(6,'makeup','create'),
(6,'makeup','delete'),
(6,'makeup','edit'),
(6,'makeup','export'),
(6,'makeup','personal'),
(6,'makeup','switchstatus'),
(6,'makeup','view'),
(6,'my','review'),
(6,'ops','index'),
(6,'ops','setting'),
(6,'overtime','create'),
(6,'overtime','delete'),
(6,'overtime','edit'),
(6,'overtime','export'),
(6,'overtime','personal'),
(6,'overtime','switchstatus'),
(6,'overtime','view'),
(6,'serverroom','browse'),
(6,'serverroom','create'),
(6,'serverroom','delete'),
(6,'serverroom','edit'),
(6,'serverroom','view'),
(6,'service','browse'),
(6,'service','create'),
(6,'service','delete'),
(6,'service','edit'),
(6,'service','index'),
(6,'service','manage'),
(6,'service','view'),
(6,'tree','browsehost'),
(7,'attend','company'),
(7,'deploy','activate'),
(7,'deploy','assignTo'),
(7,'deploy','batchUnlinkCases'),
(7,'deploy','browse'),
(7,'deploy','cases'),
(7,'deploy','create'),
(7,'deploy','delete'),
(7,'deploy','deleteStep'),
(7,'deploy','edit'),
(7,'deploy','editStep'),
(7,'deploy','finish'),
(7,'deploy','finishStep'),
(7,'deploy','linkCases'),
(7,'deploy','manageScope'),
(7,'deploy','manageStep'),
(7,'deploy','scope'),
(7,'deploy','steps'),
(7,'deploy','unlinkCase'),
(7,'deploy','view'),
(7,'deploy','viewStep'),
(7,'attend','department'),
(7,'attend','edit'),
(7,'attend','export'),
(7,'attend','exportDetail'),
(7,'attend','exportStat'),
(7,'attend','personal'),
(7,'doc','diff'),
(7,'faq','browse'),
(7,'faq','create'),
(7,'faq','delete'),
(7,'faq','edit'),
(7,'feedback','admin'),
(7,'feedback','adminView'),
(7,'feedback','close'),
(7,'feedback','comment'),
(7,'feedback','index'),
(7,'host','browse'),
(7,'host','changeStatus'),
(7,'host','create'),
(7,'host','delete'),
(7,'host','edit'),
(7,'host','treemap'),
(7,'host','view'),
(7,'leave','back'),
(7,'leave','create'),
(7,'leave','delete'),
(7,'leave','edit'),
(7,'leave','export'),
(7,'leave','personal'),
(7,'leave','personalAnnual'),
(7,'leave','switchstatus'),
(7,'leave','view'),
(7,'lieu','create'),
(7,'lieu','delete'),
(7,'lieu','edit'),
(7,'lieu','personal'),
(7,'lieu','switchstatus'),
(7,'lieu','view'),
(7,'makeup','create'),
(7,'makeup','delete'),
(7,'makeup','edit'),
(7,'makeup','export'),
(7,'makeup','personal'),
(7,'makeup','switchstatus'),
(7,'makeup','view'),
(7,'my','review'),
(7,'ops','index'),
(7,'ops','setting'),
(7,'overtime','create'),
(7,'overtime','delete'),
(7,'overtime','edit'),
(7,'overtime','export'),
(7,'overtime','personal'),
(7,'overtime','switchstatus'),
(7,'overtime','view'),
(7,'serverroom','browse'),
(7,'serverroom','create'),
(7,'serverroom','delete'),
(7,'serverroom','edit'),
(7,'serverroom','view'),
(7,'service','browse'),
(7,'service','create'),
(7,'service','delete'),
(7,'service','edit'),
(7,'service','index'),
(7,'service','manage'),
(7,'service','view'),
(7,'story','browse'),
(8,'attend','company'),
(8,'attend','department'),
(8,'attend','edit'),
(8,'attend','export'),
(8,'attend','exportStat'),
(8,'attend','personal'),
(8,'doc','diff'),
(8,'faq','browse'),
(8,'feedback','admin'),
(8,'feedback','close'),
(8,'feedback','index'),
(8,'host','browse'),
(8,'host','create'),
(8,'host','delete'),
(8,'host','edit'),
(8,'host','treemap'),
(8,'host','view'),
(8,'leave','back'),
(8,'leave','create'),
(8,'leave','delete'),
(8,'leave','edit'),
(8,'leave','export'),
(8,'leave','personal'),
(8,'leave','personalAnnual'),
(8,'leave','switchstatus'),
(8,'leave','view'),
(8,'lieu','create'),
(8,'lieu','delete'),
(8,'lieu','edit'),
(8,'lieu','personal'),
(8,'lieu','switchstatus'),
(8,'lieu','view'),
(8,'makeup','create'),
(8,'makeup','delete'),
(8,'makeup','edit'),
(8,'makeup','export'),
(8,'makeup','personal'),
(8,'makeup','switchstatus'),
(8,'makeup','view'),
(8,'my','review'),
(8,'ops','index'),
(8,'overtime','create'),
(8,'overtime','delete'),
(8,'overtime','edit'),
(8,'overtime','export'),
(8,'overtime','personal'),
(8,'overtime','switchstatus'),
(8,'overtime','view'),
(8,'testtask','deployCaseResults'),
(8,'testtask','runDeployCase'),
(8,'tree','browsehost'),
(9,'account','browse'),
(9,'account','view'),
(9,'attend','browseReview'),
(9,'attend','company'),
(9,'attend','department'),
(9,'attend','detail'),
(9,'attend','edit'),
(9,'attend','export'),
(9,'attend','exportDetail'),
(9,'attend','exportStat'),
(9,'attend','personal'),
(9,'attend','personalSettings'),
(9,'attend','review'),
(9,'attend','saveStat'),
(9,'attend','setManager'),
(9,'attend','settings'),
(9,'attend','stat'),
(9,'deploy','browse'),
(9,'deploy','view'),
(9,'deploy','viewStep'),
(9,'doc','diff'),
(9,'domain','browse'),
(9,'domain','view'),
(9,'faq','browse'),
(9,'feedback','admin'),
(9,'feedback','adminView'),
(9,'feedback','index'),
(9,'feedback','view'),
(9,'holiday','browse'),
(9,'holiday','create'),
(9,'holiday','delete'),
(9,'holiday','edit'),
(9,'host','browse'),
(9,'host','treemap'),
(9,'host','view'),
(9,'leave','back'),
(9,'leave','browseReview'),
(9,'leave','company'),
(9,'leave','create'),
(9,'leave','delete'),
(9,'leave','edit'),
(9,'leave','export'),
(9,'leave','personal'),
(9,'leave','personalAnnual'),
(9,'leave','review'),
(9,'leave','setReviewer'),
(9,'leave','switchstatus'),
(9,'leave','view'),
(9,'lieu','browseReview'),
(9,'lieu','company'),
(9,'lieu','create'),
(9,'lieu','delete'),
(9,'lieu','edit'),
(9,'lieu','personal'),
(9,'lieu','review'),
(9,'lieu','setReviewer'),
(9,'lieu','switchstatus'),
(9,'lieu','view'),
(9,'makeup','browseReview'),
(9,'makeup','company'),
(9,'makeup','create'),
(9,'makeup','delete'),
(9,'makeup','edit'),
(9,'makeup','export'),
(9,'makeup','personal'),
(9,'makeup','review'),
(9,'makeup','setReviewer'),
(9,'makeup','switchstatus'),
(9,'makeup','view'),
(9,'my','review'),
(9,'ops','index'),
(9,'overtime','browseReview'),
(9,'overtime','company'),
(9,'overtime','create'),
(9,'overtime','delete'),
(9,'overtime','edit'),
(9,'overtime','export'),
(9,'overtime','personal'),
(9,'overtime','review'),
(9,'overtime','setReviewer'),
(9,'overtime','switchstatus'),
(9,'overtime','view'),
(9,'serverroom','browse'),
(9,'serverroom','view'),
(9,'service','browse'),
(9,'service','index'),
(9,'service','view'),
(10,'attend','company'),
(10,'attend','department'),
(10,'attend','edit'),
(10,'attend','export'),
(10,'attend','personal'),
(10,'doc','diff'),
(10,'holiday','browse'),
(10,'holiday','create'),
(10,'holiday','delete'),
(10,'holiday','edit'),
(10,'leave','back'),
(10,'leave','create'),
(10,'leave','delete'),
(10,'leave','edit'),
(10,'leave','export'),
(10,'leave','personal'),
(10,'leave','personalAnnual'),
(10,'leave','switchstatus'),
(10,'leave','view'),
(10,'lieu','create'),
(10,'lieu','delete'),
(10,'lieu','edit'),
(10,'lieu','personal'),
(10,'lieu','switchstatus'),
(10,'lieu','view'),
(10,'makeup','create'),
(10,'makeup','delete'),
(10,'makeup','edit'),
(10,'makeup','export'),
(10,'makeup','personal'),
(10,'makeup','switchstatus'),
(10,'makeup','view'),
(10,'my','review'),
(10,'overtime','create'),
(10,'overtime','delete'),
(10,'overtime','edit'),
(10,'overtime','export'),
(10,'overtime','personal'),
(10,'overtime','switchstatus'),
(10,'overtime','view'),
(11,'holiday','browse'),
(11,'holiday','create'),
(11,'holiday','delete'),
(11,'holiday','edit');
-- DROP TABLE IF EXISTS `zt_workflow`;
CREATE TABLE IF NOT EXISTS `zt_workflow` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `parent` varchar(30) NOT NULL,
  `child` varchar(30) NOT NULL,
  `type` varchar(10) NOT NULL DEFAULT 'flow',
  `app` varchar(20) NOT NULL,
  `position` varchar(30) NOT NULL,
  `module` varchar(30) NOT NULL,
  `table` varchar(50) NOT NULL,
  `name` varchar(30) NOT NULL,
  `titleField` varchar(30) NOT NULL,
  `contentField` text NOT NULL,
  `flowchart` text NOT NULL,
  `js` text NOT NULL,
  `css` text NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  `buildin` tinyint(1) unsigned NOT NULL,
  `administrator` text NOT NULL,
  `desc` text NOT NULL,
  `version` varchar(10) NOT NULL DEFAULT '1.0',
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `type` (`type`),
  KEY `app` (`app`),
  KEY `module` (`module`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`app`, `module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowaction`;
CREATE TABLE IF NOT EXISTS `zt_workflowaction` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `action` varchar(50) NOT NULL,
  `method` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `type` enum('single', 'batch') NOT NULL DEFAULT 'single',
  `batchMode` enum('same', 'different') NOT NULL DEFAULT 'different',
  `extensionType` varchar(10) NOT NULL DEFAULT 'override' COMMENT 'none | extend | override',
  `open` varchar(20) NOT NULL,
  `position` enum('menu', 'browseandview', 'browse', 'view') NOT NULL DEFAULT 'browseandview',
  `layout` char(20) NOT NULL,
  `show` enum('dropdownlist', 'direct') NOT NULL DEFAULT 'dropdownlist',
  `order` smallint(5) unsigned NOT NULL,
  `buildin` tinyint(1) unsigned NOT NULL,
  `virtual` tinyint(1) unsigned NOT NULL,
  `conditions` text NOT NULL,
  `verifications` text NOT NULL,
  `hooks` text NOT NULL,
  `linkages` text NOT NULL,
  `js` text NOT NULL,
  `css` text NOT NULL,
  `toList` char(255) NOT NULL,
  `blocks` text NOT NULL,
  `desc` text NOT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'enable',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `module` (`module`),
  KEY `action` (`action`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`module`, `action`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowdatasource`;
CREATE TABLE IF NOT EXISTS `zt_workflowdatasource` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('system', 'sql', 'func', 'option', 'lang', 'category') NOT NULL DEFAULT 'option',
  `name` varchar(30) NOT NULL,
  `code` varchar(30) NOT NULL,
  `datasource` text NOT NULL,
  `view` varchar(20) NOT NULL,
  `keyField` varchar(50) NOT NULL,
  `valueField` varchar(50) NOT NULL,
  `buildin` tinyint(1) unsigned NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowfield`;
CREATE TABLE IF NOT EXISTS `zt_workflowfield` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `field`  varchar(50) NOT NULL,
  `type` varchar(20) NOT NULL DEFAULT 'varchar',
  `length` varchar(10) NOT NULL,
  `name` varchar(50) NOT NULL,
  `control` varchar(20) NOT NULL,
  `expression` text NOT NULL,
  `options` text NOT NULL,
  `default` varchar(100) NOT NULL,
  `rules` varchar(255) NOT NULL,
  `placeholder` varchar(100) NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  `searchOrder` smallint(5) unsigned NOT NULL DEFAULT '0',
  `exportOrder` smallint(5) unsigned NOT NULL DEFAULT '0',
  `canExport` enum('0', '1') NOT NULL DEFAULT '0',
  `canSearch` enum('0', '1') NOT NULL DEFAULT '0',
  `isValue` enum('0', '1') NOT NULL DEFAULT '0',
  `readonly` enum('0', '1') NOT NULL DEFAULT '0',
  `buildin` tinyint(1) unsigned NOT NULL,
  `desc` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `module` (`module`),
  KEY `field` (`field`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`module`, `field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowlayout`;
CREATE TABLE IF NOT EXISTS `zt_workflowlayout` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `action` varchar(50) NOT NULL,
  `field`  varchar(50) NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  `width` smallint(5) NOT NULL,
  `position` text NOT NULL,
  `readonly` enum('0', '1') NOT NULL DEFAULT '0',
  `mobileShow` enum('0', '1') NOT NULL DEFAULT '1',
  `summary` varchar(20) NOT NULL,
  `defaultValue` text NOT NULL,
  `layoutRules` varchar(255) NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `module` (`module`),
  KEY `action` (`action`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`module`, `action`, `field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowlabel`;
CREATE TABLE IF NOT EXISTS `zt_workflowlabel` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `action` varchar(30) NOT NULL DEFAULT 'browse',
  `code` varchar(30) NOT NULL,
  `label` varchar(255) NOT NULL,
  `params` text NOT NULL,
  `orderBy` text NOT NULL,
  `order` tinyint(3) NOT NULL,
  `buildin` tinyint(1) unsigned NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowlinkdata`;
CREATE TABLE IF NOT EXISTS `zt_workflowlinkdata` (
  `objectType` varchar(30) NOT NULL,
  `objectID` mediumint(8) unsigned NOT NULL,
  `linkedType` varchar(30) NOT NULL,
  `linkedID` mediumint(8) unsigned NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  UNIQUE KEY `unique` (`objectType`, `objectID`, `linkedType`, `linkedID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowrelation`;
CREATE TABLE IF NOT EXISTS `zt_workflowrelation` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `prev` varchar(30) NOT NULL,
  `next` varchar(30) NOT NULL,
  `field` varchar(50) NOT NULL,
  `actions` varchar(20) NOT NULL,
  `actionCodes` text NOT NULL,
  `buildin` enum('0', '1') NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowrelationlayout`;
CREATE TABLE IF NOT EXISTS `zt_workflowrelationlayout` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `prev` varchar(30) NOT NULL,
  `next` varchar(30) NOT NULL,
  `action` varchar(50) NOT NULL,
  `field` varchar(50) NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `prev` (`prev`),
  KEY `next` (`next`),
  KEY `action` (`action`),
  KEY `order` (`order`),
  UNIQUE KEY `unique` (`prev`, `next`, `action`, `field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowrule`;
CREATE TABLE IF NOT EXISTS `zt_workflowrule` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('system', 'regex', 'func') NOT NULL DEFAULT 'regex',
  `name` varchar(30) NOT NULL,
  `rule` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` char(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowsql`;
CREATE TABLE IF NOT EXISTS `zt_workflowsql` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `field` varchar(50) NOT NULL,
  `action` varchar(50) NOT NULL,
  `sql` text NOT NULL,
  `vars` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY `id` (`id`),
  KEY `module` (`module`),
  KEY `field` (`field`),
  KEY `action` (`action`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowversion`;
CREATE TABLE IF NOT EXISTS `zt_workflowversion` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `version` varchar(10) NOT NULL,
  `fields` text NOT NULL,
  `actions` text NOT NULL,
  `layouts` text NOT NULL,
  `sqls` text NOT NULL,
  `labels` text NOT NULL,
  `table` text NOT NULL,
  `datas` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `moduleversion` (`module`, `version`),
  KEY `module` (`module`),
  KEY `version` (`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workflowreport`;
CREATE TABLE IF NOT EXISTS `zt_workflowreport` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL COMMENT 'module name',
  `name` varchar(100) NOT NULL COMMENT 'report name',
  `type` enum('pie', 'line', 'bar') NOT NULL DEFAULT 'pie' COMMENT 'report type',
  `countType` enum('sum', 'count') NOT NULL DEFAULT 'sum' COMMENT 'report count method',
  `displayType` enum('value', 'percent') NOT NULL DEFAULT 'value' COMMENT 'report display method',
  `dimension` varchar(130) NOT NULL COMMENT 'dimension field code of zt_workflowfield',
  `fields` text NOT NULL COMMENT 'count fileds code of zt_workflowfield,use comma split',
  `order` smallint(5) unsigned NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `zt_action` CHANGE `action` `action` varchar(80) NOT NULL DEFAULT '';
ALTER TABLE `zt_action` CHANGE `extra` `extra` text;
ALTER TABLE `zt_file` CHANGE `objectType` `objectType` char(30) NOT NULL;

REPLACE INTO `zt_workflowrule` VALUES (1,'system','必填','notempty','admin','2020-10-14 14:06:14','','0000-00-00 00:00:00'),(2,'system','唯一','unique','admin','2020-10-14 14:06:14','','0000-00-00 00:00:00'),(3,'system','日期','date','admin','2020-10-14 14:06:14','','0000-00-00 00:00:00'),(4,'system','email','email','admin','2020-10-14 14:06:14','','0000-00-00 00:00:00'),(5,'system','数字','float','admin','2020-10-14 14:06:14','','0000-00-00 00:00:00'),(6,'system','电话','phone','admin','2020-10-14 14:06:14','','0000-00-00 00:00:00'),(7,'system','IP','ip','admin','2020-10-14 14:06:14','','0000-00-00 00:00:00');

REPLACE INTO `zt_grouppriv` VALUES
(1,'apppriv','flow'),
(1,'workflow','activate'),
(1,'workflow','backup'),
(1,'workflow','browseDB'),
(1,'workflow','browseFlow'),
(1,'workflow','copy'),
(1,'workflow','create'),
(1,'workflow','deactivate'),
(1,'workflow','delete'),
(1,'workflow','edit'),
(1,'workflow','flowchart'),
(1,'workflow','setCSS'),
(1,'workflow','setJS'),
(1,'workflow','release'),
(1,'workflow','ui'),
(1,'workflow','upgrade'),
(1,'workflow','view'),
(1,'workflowaction','browse'),
(1,'workflowaction','create'),
(1,'workflowaction','delete'),
(1,'workflowaction','edit'),
(1,'workflowaction','setCSS'),
(1,'workflowaction','setJS'),
(1,'workflowaction','setNotice'),
(1,'workflowaction','setVerification'),
(1,'workflowaction','sort'),
(1,'workflowaction','view'),
(1,'workflowcondition','browse'),
(1,'workflowcondition','create'),
(1,'workflowcondition','delete'),
(1,'workflowcondition','edit'),
(1,'workflowdatasource','browse'),
(1,'workflowdatasource','create'),
(1,'workflowdatasource','delete'),
(1,'workflowdatasource','edit'),
(1,'workflowfield','browse'),
(1,'workflowfield','create'),
(1,'workflowfield','delete'),
(1,'workflowfield','edit'),
(1,'workflowfield','export'),
(1,'workflowfield','exportTemplate'),
(1,'workflowfield','setValue'),
(1,'workflowfield','setExport'),
(1,'workflowfield','setSearch'),
(1,'workflowfield','showImport'),
(1,'workflowfield','sort'),
(1,'workflowfield','import'),
(1,'workflowhook','browse'),
(1,'workflowhook','create'),
(1,'workflowhook','delete'),
(1,'workflowhook','edit'),
(1,'workflowlabel','browse'),
(1,'workflowlabel','create'),
(1,'workflowlabel','delete'),
(1,'workflowlabel','edit'),
(1,'workflowlabel','sort'),
(1,'workflowlayout','admin'),
(1,'workflowlayout','block'),
(1,'workflowlinkage','browse'),
(1,'workflowlinkage','create'),
(1,'workflowlinkage','delete'),
(1,'workflowlinkage','edit'),
(1,'workflowrelation','admin'),
(1,'workflowreport','browse'),
(1,'workflowreport','create'),
(1,'workflowreport','edit'),
(1,'workflowreport','delete'),
(1,'workflowreport','sort'),
(1,'workflowrule','browse'),
(1,'workflowrule','create'),
(1,'workflowrule','delete'),
(1,'workflowrule','edit'),
(1,'workflowrule','view');

ALTER TABLE `zt_workflow` ADD `navigator` varchar(10) NOT NULL AFTER `type`;
ALTER TABLE `zt_workflow` ADD `vision` varchar(10) NOT NULL DEFAULT 'rnd' AFTER `status`;
ALTER TABLE `zt_workflowdatasource` ADD `vision` varchar(10) NOT NULL DEFAULT 'rnd' AFTER `buildin`;
ALTER TABLE `zt_workflowaction` ADD `vision` varchar(10) NOT NULL DEFAULT 'rnd' AFTER `status`;
ALTER TABLE `zt_workflowlayout` ADD `vision` varchar(10) NOT NULL DEFAULT 'rnd';

ALTER TABLE `zt_workflow` DROP INDEX `unique`;
ALTER TABLE `zt_workflow` ADD UNIQUE `unique` (`app`, `module`, `vision`);
ALTER TABLE `zt_workflowaction` DROP INDEX `unique`;
ALTER TABLE `zt_workflowaction` ADD UNIQUE `unique` (`module`, `action`, `vision`);
ALTER TABLE `zt_workflowlayout` DROP INDEX `unique`;
ALTER TABLE `zt_workflowlayout` ADD UNIQUE `unique` (`module`, `action`, `field`, `vision`);

INSERT INTO `zt_workflowdatasource` (`type`, `name`, `code`, `buildin`, `datasource`, `view`, `keyField`, `valueField`) VALUES
('system',      '产品',           'products',        '1', '{\"app\":\"system\",\"module\":\"product\",\"method\":\"getPairs\",\"methodDesc\":\"Get product pairs.\",\"params\":[{\"name\":\"mode\",\"type\":\"string\",\"desc\":\"\",\"value\":\"all\"}]}',       '',     '',     ''),
('system',      '项目',           'projects',        '1', '{\"app\":\"system\",\"module\":\"project\",\"method\":\"getPairsByModel\",\"methodDesc\":\"Get project pairs by model and project.\",\"params\":[{\"name\":\"model\",\"type\":\"string\",\"desc\":\"all|scrum|waterfall\",\"value\":\"all\"},{\"name\":\"programID\",\"type\":\"int\",\"desc\":\"\",\"value\":\"0\"},{\"name\":\"param\",\"type\":\"\",\"desc\":\"\",\"value\":\"\"}]}',  '',     '',     ''),
('system',      '产品线',         'productLines',    '1', '{\"app\":\"system\",\"module\":\"product\",\"method\":\"getLinePairs\",\"methodDesc\":\"Get line pairs.\",\"params\":[{\"name\":\"useShort\",\"type\":\"bool\",\"desc\":\"\",\"value\":\"\"}]}',  '',     '',     ''),
('sql',         '需求',           'stories',         '1', 'select id,title from zt_story where deleted=\"0\"',    'view_datasource_4',    'id',   'title'),
('sql',         '任务',           'tasks',           '1', 'select id,name from zt_task where deleted=\"0\" and vision=\"rnd\"',      'view_datasource_5',    'id',   'name'),
('sql',         'Bug',            'bugs',            '1', 'select id,title from zt_bug where deleted=\"0\"',      'view_datasource_6',    'id',   'title'),
('system',      '权限分组',       'groups',          '1', '{\"app\":\"system\",\"module\":\"group\",\"method\":\"getPairs\",\"methodDesc\":\"\",\"params\":[]}',  '',     '',     ''),
('system',      '用户',           'users',           '1', '{\"app\":\"system\",\"module\":\"user\",\"method\":\"getPairs\",\"methodDesc\":\"\",\"params\":[{\"name\":\"params\",\"type\":\"\",\"desc\":\"\",\"value\":\"noclosed|noletter\"},{\"name\":\"usersToAppended\",\"type\":\"\",\"desc\":\"\",\"value\":\"\"}]}',        '',     '',     ''),
('system',      '产品分支',       'branches',        '1', '{\"app\":\"system\",\"module\":\"branch\",\"method\":\"getAllPairs\",\"methodDesc\":\"Get pairs.\",\"params\":[{\"name\":\"params\",\"type\":\"string\",\"desc\":\"\",\"value\":\"\"}]}',      '',     '',     ''),
('sql',         '版本',           'builds',          '1', 'select id,name from zt_build where deleted=\"0\"',     'view_datasource_10',   'id',   'name'),
('sql',         '模块',           'modules',         '1', 'select id,name from zt_module where deleted=\"0\"',    'view_datasource_11',   'id',   'name'),
('sql',         '计划',           'plans',           '1', 'select id,title from zt_productplan where deleted=\"0\"',      'view_datasource_12',   'id',   'title'),
('lang',        '产品类型',       'productType',     '1', 'productType',    '',     '',     ''),
('lang',        '产品状态',       'productStatus',   '1', 'productStatus',  '',     '',     ''),
('lang',        '产品访问控制',   'productAcl',      '1', 'productAcl',     '',     '',     ''),
('lang',        '项目类型',       'projectType',     '1', 'projectType',    '',     '',     ''),
('lang',        '项目状态',       'projectStatus',   '1', 'projectStatus',  '',     '',     ''),
('lang',        '项目访问控制',   'projectAcl',      '1', 'projectAcl',     '',     '',     ''),
('lang',        '发布状态',       'releaseStatus',   '1', 'releaseStatus',  '',     '',     ''),
('lang',        '需求来源',       'storySource',     '1', 'storySource',    '',     '',     ''),
('lang',        '需求优先级',     'storyPri',        '1', 'storyPri',       '',     '',     ''),
('lang',        '需求状态',       'storyStatus',     '1', 'storyStatus',    '',     '',     ''),
('lang',        '需求阶段',       'storyStage',      '1', 'storyStage',     '',     '',     ''),
('lang',        'Bug严重程度',    'bugSeverity',     '1', 'bugSeverity',    '',     '',     ''),
('lang',        'Bug优先级',      'bugPri',          '1', 'bugPri',         '',     '',     ''),
('lang',        'Bug类型',        'bugType',         '1', 'bugType',        '',     '',     ''),
('lang',        'Bug操作系统',    'bugOs',           '1', 'bugOs',          '',     '',     ''),
('lang',        'Bug浏览器',      'bugBrowser',      '1', 'bugBrowser',     '',     '',     ''),
('lang',        'Bug状态',        'bugStatus',       '1', 'bugStatus',      '',     '',     ''),
('lang',        '任务类型',       'taskType',        '1', 'taskType',       '',     '',     ''),
('lang',        '任务优先级',     'taskPri',         '1', 'taskPri',        '',     '',     ''),
('lang',        '任务状态',       'taskStatus',      '1', 'taskStatus',     '',     '',     ''),
('lang',        '测试用例优先级', 'testcasePri',     '1', 'testcasePri',    '',     '',     ''),
('lang',        '测试用例类型',   'testcaseType',    '1', 'testcaseType',   '',     '',     ''),
('lang',        '测试用例阶段',   'testcaseStage',   '1', 'testcaseStage',  '',     '',     ''),
('lang',        '测试用例状态',   'testcaseStatus',  '1', 'testcaseStatus', '',     '',     ''),
('lang',        '测试单优先级',   'testtaskPri',     '1', 'testtaskPri',    '',     '',     ''),
('lang',        '测试单状态',     'testtaskStatus',  '1', 'testtaskStatus', '',     '',     ''),
('lang',        '反馈状态',       'feedbackStatus',  '1', 'feedbackStatus', '',     '',     ''),
('lang',        'Bug解决方案',    'bugResolution',   '1', 'bugResolution',  '',     '',     ''),
('sql',         '用例',           'cases',           '1', 'select id,title from zt_case where deleted=\"0\"',     'view_datasource_41',   'id',   'title'),
('system',      '反馈分支',       'feedbackModules', '1', '{\"app\":\"system\",\"module\":\"tree\",\"method\":\"getOptionMenu\",\"methodDesc\":\"Create an option menu in html.\",\"params\":[{\"name\":\"rootID\",\"type\":\"int\",\"desc\":\"\",\"value\":\"0\"},{\"name\":\"type\",\"type\":\"string\",\"desc\":\"\",\"value\":\"feedback\"},{\"name\":\"startModule\",\"type\":\"int\",\"desc\":\"\",\"value\":\"0\"},{\"name\":\"branch\",\"type\":\"\",\"desc\":\"\",\"value\":\"0\"}]}',   '',     '',     ''),
('lang',        '需求类型',       'storyType',       '1', 'storyType',    '',     '',     ''),
('system',	'执行',	          'executions',      '1', '{\"app\":\"system\",\"module\":\"execution\",\"method\":\"getPairs\",\"methodDesc\":\"Get execution pairs.\",\"params\":[{\"name\":\"projectID\",\"type\":\"int\",\"desc\":\"\",\"value\":\"0\"},{\"name\":\"type\",\"type\":\"string\",\"desc\":\"all|sprint|stage|kanban\",\"value\":\"all\"},{\"name\":\"mode\",\"type\":\"string\",\"desc\":\"all|noclosed|stagefilter or empty\",\"value\":\"\"}]}',  '',     '',     ''),
('lang', '项目模型', 'projectModel', '1', 'projectModel', '', '', ''),
('lang', '反馈类型', 'feedbackType', '1', 'feedbackType', '', '', ''),
('lang', '反馈处理方案', 'feedbackSolution',     '1', 'feedbackSolution',     '', '', ''),
('lang', '反馈关闭原因', 'feedbackclosedReason', '1', 'feedbackclosedReason', '', '', ''),
('lang', '任务关闭原因', 'taskReason', '1', 'taskReason', '', '', ''),
('lang',        '套件权限',       'testsuiteAuth', '1', 'testsuiteAuth', '', '', ''),
('system',     '项目集',         'programs', '1', '{\"app\":\"system\",\"module\":\"program\",\"method\":\"getPairs\",\"methodDesc\":\"Get program pairs.\",\"params\":[{\"name\":\"isQueryAll\",\"type\":\"bool\",\"desc\":\"\",\"value\":\"\"},{\"name\":\"orderBy\",\"type\":\"string\",\"desc\":\"\",\"value\":\"id_desc\"}]}',  '',     '',     ''),
('lang', '需求关闭原因', 'storyClosedReason', '1', 'storyClosedReason', '', '', '');

INSERT INTO `zt_workflowdatasource` (`type`, `name`, `code`, `buildin`, `vision`, `datasource`, `view`, `keyField`, `valueField`) VALUES
('system',      '项目',           'liteprojects',             '1', 'lite', '{\"app\":\"system\",\"module\":\"project\",\"method\":\"getPairsByModel\",\"methodDesc\":\"Get project pairs by model and project.\",\"params\":[{\"name\":\"model\",\"type\":\"string\",\"desc\":\"all|scrum|waterfall\",\"value\":\"all\"},{\"name\":\"programID\",\"type\":\"int\",\"desc\":\"\",\"value\":\"0\"},{\"name\":\"param\",\"type\":\"\",\"desc\":\"\",\"value\":\"\"}]}',  '',     '',     ''),
('sql',         '任务',           'litetasks',                '1', 'lite', 'select id,name from zt_task where deleted=\"0\" and vision=\"lite\"',      'view_datasource_54',    'id',   'name'),
('system',      '权限分组',       'litegroups',               '1', 'lite', '{\"app\":\"system\",\"module\":\"group\",\"method\":\"getPairs\",\"methodDesc\":\"\",\"params\":[]}',  '',     '',     ''),
('system',      '用户',           'liteusers',                '1', 'lite', '{\"app\":\"system\",\"module\":\"user\",\"method\":\"getPairs\",\"methodDesc\":\"\",\"params\":[{\"name\":\"params\",\"type\":\"\",\"desc\":\"\",\"value\":\"noclosed|noletter\"},{\"name\":\"usersToAppended\",\"type\":\"\",\"desc\":\"\",\"value\":\"\"}]}',        '',     '',     ''),
('sql',         '模块',           'litemodules',              '1', 'lite', 'select id,name from zt_module where deleted=\"0\"',    'view_datasource_11',   'id',   'name'),
('lang',        '项目类型',       'liteprojectType',          '1', 'lite', 'projectType',    '',     '',     ''),
('lang',        '项目状态',       'liteprojectStatus',        '1', 'lite', 'projectStatus',  '',     '',     ''),
('lang',        '项目访问控制',   'liteprojectAcl',           '1', 'lite', 'projectAcl',     '',     '',     ''),
('lang',        '任务类型',       'litetaskType',             '1', 'lite', 'taskType',       '',     '',     ''),
('lang',        '任务优先级',     'litetaskPri',              '1', 'lite', 'taskPri',        '',     '',     ''),
('lang',        '任务状态',       'litetaskStatus',           '1', 'lite', 'taskStatus',     '',     '',     ''),
('lang',        '反馈状态',       'litefeedbackStatus',       '1', 'lite', 'feedbackStatus', '',     '',     ''),
('system',      '反馈分支',       'litefeedbackModules',      '1', 'lite', '{\"app\":\"system\",\"module\":\"tree\",\"method\":\"getOptionMenu\",\"methodDesc\":\"Create an option menu in html.\",\"params\":[{\"name\":\"rootID\",\"type\":\"int\",\"desc\":\"\",\"value\":\"0\"},{\"name\":\"type\",\"type\":\"string\",\"desc\":\"\",\"value\":\"feedback\"},{\"name\":\"startModule\",\"type\":\"int\",\"desc\":\"\",\"value\":\"0\"},{\"name\":\"branch\",\"type\":\"\",\"desc\":\"\",\"value\":\"0\"}]}',   '',     '',     ''),
('lang',        '反馈类型',       'litefeedbackType',         '1', 'lite', 'feedbackType',         '', '', ''),
('lang',        '反馈处理方案',   'litefeedbackSolution',     '1', 'lite', 'feedbackSolution',     '', '', ''),
('lang',        '反馈关闭原因',   'litefeedbackclosedReason', '1', 'lite', 'feedbackclosedReason', '', '', ''),
('lang',        '任务关闭原因',   'litetaskReason',           '1', 'lite', 'taskReason',           '', '', '');

DROP VIEW IF EXISTS `view_datasource_4`;
DROP VIEW IF EXISTS `view_datasource_5`;
DROP VIEW IF EXISTS `view_datasource_6`;
DROP VIEW IF EXISTS `view_datasource_10`;
DROP VIEW IF EXISTS `view_datasource_11`;
DROP VIEW IF EXISTS `view_datasource_12`;
DROP VIEW IF EXISTS `view_datasource_41`;
DROP VIEW IF EXISTS `view_datasource_54`;

CREATE VIEW `view_datasource_4`  AS select `id`,`title` from `zt_story` where `deleted` = '0';
CREATE VIEW `view_datasource_5`  AS select `id`,`name` from `zt_task` where `deleted` = '0' and vision = 'rnd';
CREATE VIEW `view_datasource_6`  AS select `id`,`title` from `zt_bug` where `deleted` = '0';
CREATE VIEW `view_datasource_10` AS select `id`,`name` from `zt_build` where `deleted` = '0';
CREATE VIEW `view_datasource_11` AS select `id`,`name` from `zt_module` where `deleted` = '0';
CREATE VIEW `view_datasource_12` AS select `id`,`title` from `zt_productplan` where `deleted` = '0';
CREATE VIEW `view_datasource_41` AS select `id`,`title` from `zt_case` where `deleted` = '0';
CREATE VIEW `view_datasource_54` AS select `id`,`name` from `zt_task` where `deleted` = '0' and vision = 'lite';

ALTER TABLE `zt_doc` ADD `template` varchar(30) COLLATE 'utf8_general_ci' NOT NULL AFTER `lib`;
ALTER TABLE `zt_doc` ADD `templateType` varchar(30) COLLATE 'utf8_general_ci' NOT NULL AFTER `template`;
ALTER TABLE `zt_doc` ADD `chapterType` varchar(30) COLLATE 'utf8_general_ci' NOT NULL AFTER `templateType`;
ALTER TABLE `zt_doc` ADD `assetLib` mediumint(8) unsigned NOT NULL default 0 after `views`;
ALTER TABLE `zt_doc` ADD `assetLibType` varchar(30) NOT NULL default '' after `assetLib`;
ALTER TABLE `zt_doc` ADD `from` mediumint(8) unsigned NOT NULL default 0 after `assetLibType`;
ALTER TABLE `zt_doc` ADD `fromVersion` smallint(6) NOT NULL default 1 after `from`;
ALTER TABLE `zt_doc` ADD `assignedTo` varchar(30) NOT NULL after `addedDate`;
ALTER TABLE `zt_doc` ADD `assignedDate` date NOT NULL after `assignedTo`;
ALTER TABLE `zt_doc` ADD `approvedDate` date NOT NULL after `assignedDate`;
ALTER TABLE `zt_doc` ADD `status` varchar(30) NOT NULL after `type`;

ALTER TABLE `zt_story` ADD `storyChanged` enum('0','1') NOT NULL DEFAULT '0' AFTER `version`;
ALTER TABLE `zt_story` ADD `lib` mediumint(8) unsigned NOT NULL default 0 after `mailto`;
ALTER TABLE `zt_story` ADD `fromStory` mediumint(8) unsigned NOT NULL default 0 after `lib`;
ALTER TABLE `zt_story` ADD `fromVersion` smallint(6) NOT NULL default 1 after `fromStory`;
ALTER TABLE `zt_story` ADD `approvedDate` date NOT NULL after `assignedDate`;

ALTER TABLE `zt_todo` MODIFY COLUMN `type` char(15) NOT NULL;

-- DROP TABLE IF EXISTS `zt_durationestimation`;
CREATE TABLE IF NOT EXISTS `zt_durationestimation` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `stage` mediumint(9) NOT NULL,
  `workload` varchar(255) NOT NULL,
  `worktimeRate` varchar(255) NOT NULL,
  `people` varchar(255) NOT NULL,
  `startDate` date NOT NULL,
  `endDate` date NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workestimation`;
CREATE TABLE IF NOT EXISTS `zt_workestimation` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `scale` decimal(10,2) unsigned NOT NULL,
  `productivity` decimal(10,2) unsigned NOT NULL,
  `duration` decimal(10,2) unsigned NOT NULL,
  `unitLaborCost` decimal(10,2) unsigned NOT NULL,
  `totalLaborCost` decimal(10,2) unsigned NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `dayHour` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_intervention`;
CREATE TABLE IF NOT EXISTS `zt_intervention` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `activity` mediumint(8) NOT NULL,
  `status` char(30) NOT NULL,
  `partake` text NOT NULL,
  `begin` date NOT NULL,
  `realBegin` date NOT NULL,
  `situation` varchar(255) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project` (`project`,`activity`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_activity`;
CREATE TABLE IF NOT EXISTS `zt_activity` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `process` mediumint(9) NOT NULL,
  `name` varchar(255) NOT NULL,
  `optional` varchar(255) NOT NULL,
  `tailorNorm` varchar(255) NOT NULL,
  `content` mediumtext NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `order` mediumint(8) DEFAULT '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_auditcl`;
CREATE TABLE IF NOT EXISTS `zt_auditcl` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `model` char(30) NOT NULL DEFAULT 'waterfall',
  `practiceArea` char(30) NOT NULL,
  `type` char(30) NOT NULL,
  `title` varchar(255) NOT NULL,
  `objectType` char(30) NOT NULL,
  `objectID` int(10) DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_auditplan`;
CREATE TABLE IF NOT EXISTS `zt_auditplan` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `dateType` char(30) DEFAULT NULL,
  `config` text,
  `objectID` mediumint(9) NOT NULL,
  `objectType` char(30) NOT NULL,
  `process` mediumint(9) NOT NULL,
  `processType` char(30) NOT NULL,
  `checkDate` date NOT NULL,
  `checkedBy` varchar(30) NOT NULL,
  `realCheckDate` date NOT NULL,
  `result` char(30) NOT NULL,
  `project` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `checkBy` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_auditresult`;
CREATE TABLE IF NOT EXISTS `zt_auditresult` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `auditplan` mediumint(8) NOT NULL,
  `listID` mediumint(8) NOT NULL,
  `result` char(30) NOT NULL,
  `checkedBy` varchar(30) NOT NULL,
  `checkedDate` date NOT NULL,
  `comment` text NOT NULL ,
  `assignedTo` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_nc`;
CREATE TABLE IF NOT EXISTS `zt_nc` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `auditplan` mediumint(8) NOT NULL,
  `listID` mediumint(8) NOT NULL,
  `title` varchar(255) NOT NULL,
  `desc` mediumtext NOT NULL,
  `type` char(30) NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  `severity` char(30) NOT NULL,
  `deadline` date NOT NULL,
  `resolvedBy` varchar(30) NOT NULL,
  `resolution` char(30) NOT NULL,
  `resolvedDate` date NOT NULL,
  `closedBy` varchar(30) NOT NULL,
  `closedDate` date NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `assignedDate` date NOT NULL,
  `activateDate` date NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_zoutput`;
CREATE TABLE IF NOT EXISTS `zt_zoutput` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `activity` mediumint(8) NOT NULL,
  `name` varchar(255) NOT NULL,
  `content` mediumtext NOT NULL,
  `optional` char(20) NOT NULL,
  `tailorNorm` varchar(255) NOT NULL,
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `order` mediumint(8) DEFAULT '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_process`;
CREATE TABLE IF NOT EXISTS `zt_process` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `model` char(30) NOT NULL DEFAULT 'waterfall',
  `name` varchar(255) NOT NULL,
  `type` char(30) NOT NULL,
  `abbr` char(30) NOT NULL,
  `desc` mediumtext NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `order` mediumint(9) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_programactivity`;
CREATE TABLE IF NOT EXISTS `zt_programactivity` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `process` mediumint(8) NOT NULL,
  `activity` mediumint(8) NOT NULL,
  `name` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `reason` varchar(255) NOT NULL,
  `result` char(30) NOT NULL,
  `linkedBy` char(30) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_programoutput`;
CREATE TABLE IF NOT EXISTS `zt_programoutput` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `process` mediumint(8) NOT NULL,
  `activity` mediumint(8) NOT NULL,
  `output` mediumint(8) NOT NULL,
  `content` text NOT NULL,
  `name` varchar(255) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `result` char(30) NOT NULL,
  `linkedBy` char(30) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_programprocess`;
CREATE TABLE IF NOT EXISTS `zt_programprocess` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `process` mediumint(8) NOT NULL,
  `name` varchar(255) NOT NULL,
  `type` char(30) NOT NULL,
  `abbr` char(30) NOT NULL,
  `desc` text NOT NULL,
  `reason` varchar(255) NOT NULL,
  `linkedBy` char(30) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_basicmeas`;
CREATE TABLE IF NOT EXISTS `zt_basicmeas` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `purpose` varchar(50) NOT NULL,
  `scope` char(30) NOT NULL,
  `object` char(30) NOT NULL,
  `name` varchar(90) NOT NULL,
  `code` char(30) NOT NULL,
  `unit` varchar(10) NOT NULL,
  `configure` text,
  `params` text,
  `definition` text,
  `source` varchar(255) DEFAULT NULL,
  `collectType` varchar(30) NOT NULL,
  `collectConf` text NOT NULL,
  `execTime` varchar(30) NOT NULL,
  `collectedBy` varchar(10) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `order` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_budget`;
CREATE TABLE IF NOT EXISTS `zt_budget` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `stage` char(30) NOT NULL,
  `subject` mediumint(8) NOT NULL,
  `amount` char(30) NOT NULL,
  `name` varchar(255) NOT NULL,
  `desc` mediumtext NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `lastEditedBy` char(30) NOT NULL,
  `lastEditedDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_researchplan`;
CREATE TABLE IF NOT EXISTS `zt_researchplan` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `customer` varchar(255) NOT NULL,
  `stakeholder` varchar(255) NOT NULL,
  `objective` varchar(255) NOT NULL,
  `begin` datetime NOT NULL,
  `end` datetime NOT NULL,
  `location` varchar(255) NOT NULL,
  `team` varchar(255) NOT NULL,
  `method` enum('','videoConference','interview','questionnaire','telephoneInterview') NOT NULL,
  `outline` mediumtext NOT NULL,
  `schedule` mediumtext NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_researchreport`;
CREATE TABLE IF NOT EXISTS `zt_researchreport` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `relatedPlan` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `author` varchar(30) NOT NULL,
  `content` mediumtext NOT NULL,
  `customer` varchar(255) NOT NULL,
  `researchObjects` varchar(255) NOT NULL,
  `begin` datetime NOT NULL,
  `end` datetime NOT NULL,
  `location` varchar(255) NOT NULL,
  `method` enum('','videoConference','interview','questionnaire','telephoneInterview') NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_meeting`;
CREATE TABLE IF NOT EXISTS `zt_meeting` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) NOT NULL,
  `execution` mediumint(8) NOT NULL,
  `name` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `begin` time NOT NULL,
  `end` time NOT NULL,
  `dept` mediumint(8) NOT NULL,
  `mode` varchar(255) NOT NULL,
  `host` varchar(30) NOT NULL,
  `participant` text NOT NULL,
  `date` date NOT NULL,
  `room` int NOT NULL,
  `minutes` text NOT NULL,
  `minutedBy` varchar(30) NOT NULL,
  `minutedDate` datetime NOT NULL,
  `objectType` varchar(30) NOT NULL,
  `objectID` mediumint(8) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_meetingroom`;
CREATE TABLE IF NOT EXISTS `zt_meetingroom` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `position` varchar(30) NOT NULL,
  `seats` int NOT NULL,
  `equipment` varchar(255) NOT NULL,
  `openTime` varchar(255) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_assetlib`;
CREATE TABLE IF NOT EXISTS `zt_assetlib` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `desc` mediumtext NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_meastemplate`;
CREATE TABLE IF NOT EXISTS `zt_meastemplate` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `model` char(30) NOT NULL,
  `name` varchar(255) NOT NULL,
  `content` mediumtext NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_programreport`;
CREATE TABLE IF NOT EXISTS `zt_programreport` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `template` mediumint(8) NOT NULL,
  `project` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `params` text NOT NULL,
  `content` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_measrecords`;
CREATE TABLE IF NOT EXISTS `zt_measrecords` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL,
  `mid` mediumint(8) NOT NULL,
  `measCode` char(50) NOT NULL DEFAULT '',
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `params` text NOT NULL,
  `year` char(4) NOT NULL,
  `month` char(6) NOT NULL,
  `week` char(8) NOT NULL,
  `day` char(8) NOT NULL,
  `value` varchar(255) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `project` (`project`),
  KEY `time` (`year`, `month`, `day`, `week`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_object`;
CREATE TABLE IF NOT EXISTS `zt_object` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) NOT NULL,
  `from` mediumint(8) NOT NULL,
  `title` varchar(255) NOT NULL,
  `category` char(30) NOT NULL,
  `version` varchar(255) NOT NULL,
  `type` enum('reviewed','taged') NOT NULL,
  `range` text NOT NULL,
  `data` text NOT NULL,
  `storyEst` char(30) NOT NULL,
  `taskEst` char(30) NOT NULL,
  `requestEst` char(30) NOT NULL,
  `testEst` char(30) NOT NULL,
  `devEst` char(30) NOT NULL,
  `designEst` char(30) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_review`;
CREATE TABLE IF NOT EXISTS `zt_review` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `object` mediumint(8) NOT NULL,
  `template` mediumint(8) NOT NULL,
  `doc` mediumint(8) DEFAULT NULL,
  `status` char(30) NOT NULL,
  `reviewedBy` varchar(255) NOT NULL,
  `auditedBy` varchar(255) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deadline` date NOT NULL,
  `lastReviewedBy` varchar(255) DEFAULT NULL,
  `lastReviewedDate` date NOT NULL,
  `lastAuditedBy` varchar(255) NOT NULL,
  `lastAuditedDate` date NOT NULL,
  `lastEditedBy` varchar(255) NOT NULL,
  `lastEditedDate` date NOT NULL,
  `result` char(30) NOT NULL,
  `auditResult` char(30) NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=39 DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_reviewcl`;
CREATE TABLE IF NOT EXISTS `zt_reviewcl` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `object` char(30) NOT NULL,
  `category` char(30) NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `order` mediumint(8) DEFAULT '0',
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_reviewresult`;
CREATE TABLE IF NOT EXISTS `zt_reviewresult` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `review` mediumint(8) NOT NULL,
  `type` char(30) NOT NULL DEFAULT 'review',
  `result` char(30) NOT NULL,
  `opinion` text NOT NULL,
  `reviewer` char(30) NOT NULL,
  `remainIssue` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `consumed` float NOT NULL,
  UNIQUE KEY `reviewer` (`review`,`reviewer`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_reviewissue`;
CREATE TABLE IF NOT EXISTS `zt_reviewissue` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `review` mediumint(8) NOT NULL,
  `injection` mediumint(8) NOT NULL,
  `identify` mediumint(8) NOT NULL,
  `type` char(30) NOT NULL DEFAULT 'review',
  `listID` mediumint(8) NOT NULL,
  `title` varchar(255) NOT NULL,
  `opinion` varchar(255) NOT NULL,
  `opinionDate` DATE NOT NULL,
  `status` char(30) NOT NULL,
  `resolution` char(30) NOT NULL,
  `resolutionBy` CHAR(30) NOT NULL,
  `resolutionDate` DATE NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_reviewlist`;
CREATE TABLE IF NOT EXISTS `zt_reviewlist` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `title` varchar(255) NOT NULL,
  `object` char(30) NOT NULL,
  `category` char(30) NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_cmcl`;
CREATE TABLE IF NOT EXISTS `zt_cmcl` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` char(30) NOT NULL,
  `title` int(11) NOT NULL,
  `contents` text NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `order` int(11) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_solutions`;
CREATE TABLE IF NOT EXISTS `zt_solutions` (
 `id` mediumint(8) NOT NULL AUTO_INCREMENT,
 `project` mediumint(8) unsigned NOT NULL,
 `execution` mediumint(8) unsigned NOT NULL,
 `contents` text NOT NULL COMMENT '问题描述',
 `support` text NOT NULL COMMENT '是否需要高层支持',
 `measures` text NOT NULL COMMENT '解决建议',
 `type` char(30) NOT NULL,
 `addedBy` varchar(30) NOT NULL,
 `addedDate` date NOT NULL,
 `editedBy` varchar(30) NOT NULL,
 `editedDate` date NOT NULL,
 `deleted` enum('0','1') NOT NULL DEFAULT '0',
 PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_measqueue`;
CREATE TABLE IF NOT EXISTS `zt_measqueue` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL,
  `mid` mediumint(8) unsigned NOT NULL,
  `status` varchar(255) NOT NULL,
  `logs` text,
  `execTime` varchar(10) NOT NULL,
  `params` text,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `updateDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_issue`;
CREATE TABLE IF NOT EXISTS `zt_issue` (
  `id` mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  `resolvedBy` varchar(30) NOT NULL,
  `project` varchar(255) NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `desc` mediumtext NOT NULL,
  `pri` char(30) NOT NULL,
  `severity` char(30) NOT NULL,
  `type` char(30) NOT NULL,
  `activity` varchar(255) NOT NULL,
  `deadline` date NOT NULL,
  `resolution` char(30) NOT NULL,
  `resolutionComment` text NOT NULL,
  `objectID` varchar(255) NOT NULL,
  `resolvedDate` date NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `lib` mediumint(8) unsigned NOT NULL default 0,
  `from` mediumint(8) unsigned NOT NULL default 0,
  `version` smallint(6) NOT NULL default 1,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `activateBy` varchar(30) NOT NULL,
  `activateDate` date NOT NULL,
  `closedBy` varchar(30) NOT NULL,
  `closedDate` date NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `approvedDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_risk`;
CREATE TABLE IF NOT EXISTS `zt_risk` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` varchar(255) NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `source` char(30) NOT NULL,
  `category` char(30) NOT NULL,
  `strategy` char(30) NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  `impact` char(30) NOT NULL,
  `probability` char(30) NOT NULL,
  `rate` char(30) NOT NULL,
  `pri` char(30) NOT NULL,
  `identifiedDate` date NOT NULL,
  `prevention` mediumtext NOT NULL,
  `remedy` mediumtext NOT NULL,
  `plannedClosedDate` date NOT NULL,
  `actualClosedDate` date NOT NULL,
  `lib` mediumint(8) unsigned NOT NULL default 0,
  `from` mediumint(8) unsigned NOT NULL default 0,
  `version` smallint(6) NOT NULL default 1,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `resolution` mediumtext NOT NULL,
  `resolvedBy` varchar(30) NOT NULL,
  `activateBy` varchar(30) NOT NULL,
  `activateDate` date NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `closedBy` varchar(30) NOT NULL,
  `closedDate` date NOT NULL,
  `cancelBy` varchar(30) NOT NULL,
  `cancelDate` date NOT NULL,
  `cancelReason` char(30) NOT NULL,
  `hangupBy` varchar(30) NOT NULL,
  `hangupDate` date NOT NULL,
  `trackedBy` varchar(30) NOT NULL,
  `trackedDate` date NOT NULL,
  `assignedDate` date NOT NULL,
  `approvedDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_opportunity`;
CREATE TABLE IF NOT EXISTS `zt_opportunity` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `source` char(30) NOT NULL,
  `type` char(30) NOT NULL,
  `strategy` char(30) NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  `impact` mediumint(8) NOT NULL,
  `chance` mediumint(8) NOT NULL,
  `ratio` mediumint(8) NOT NULL,
  `pri` char(30) NOT NULL,
  `identifiedDate` date NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `assignedDate` date NOT NULL,
  `approvedDate` date NOT NULL,
  `prevention` mediumtext NOT NULL,
  `plannedClosedDate` date NOT NULL,
  `actualClosedDate` date NOT NULL,
  `lib` mediumint(8) unsigned NOT NULL default 0,
  `from` mediumint(8) unsigned NOT NULL default 0,
  `version` smallint(6) NOT NULL default 1,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `activatedBy` varchar(30) NOT NULL,
  `activatedDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL,
  `closedDate` datetime NOT NULL,
  `canceledBy` varchar(30) NOT NULL,
  `canceledDate` datetime NOT NULL,
  `cancelReason` char(30) NOT NULL,
  `hangupedBy` varchar(30) NOT NULL,
  `hangupedDate` datetime NOT NULL,
  `resolution` mediumtext NOT NULL,
  `resolvedBy` varchar(30) NOT NULL,
  `resolvedDate` datetime NOT NULL,
  `lastCheckedBy` varchar(30) NOT NULL,
  `lastCheckedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_trainplan`;
CREATE TABLE IF NOT EXISTS `zt_trainplan` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `place` varchar(255) NOT NULL,
  `trainee` text NOT NULL,
  `lecturer` varchar(20) NOT NULL,
  `type` enum('inside','outside') NOT NULL DEFAULT 'inside',
  `status` varchar(20) NOT NULL,
  `summary` mediumtext NOT NULL,
  `createdBy` char(30),
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_gapanalysis`;
CREATE TABLE IF NOT EXISTS `zt_gapanalysis` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `account` varchar(30) NOT NULL,
  `role` varchar(20) NOT NULL,
  `analysis` mediumtext NOT NULL,
  `needTrain` enum('no','yes') NOT NULL DEFAULT 'no',
  `createdBy` char(30),
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_account` (`project`,`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `zt_bug`
ADD `injection` mediumint(8) unsigned NOT NULL AFTER `product`,
ADD `identify` mediumint(8) unsigned NOT NULL AFTER `injection`;

ALTER TABLE `zt_team` ADD `position` varchar(30) not null AFTER role;

REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1,'activity','assignTo'),
(1,'activity','batchCreate'),
(1,'activity','browse'),
(1,'activity','create'),
(1,'activity','delete'),
(1,'activity','edit'),
(1,'activity','outputList'),
(1,'activity','updateOrder'),
(1,'activity','view'),
(1,'apppriv','flow'),
(1,'assetlib','approveComponent'),
(1,'assetlib','approveIssue'),
(1,'assetlib','approveOpportunity'),
(1,'assetlib','approvePractice'),
(1,'assetlib','approveRisk'),
(1,'assetlib','approveStory'),
(1,'assetlib','assignToComponent'),
(1,'assetlib','assignToIssue'),
(1,'assetlib','assignToOpportunity'),
(1,'assetlib','assignToPractice'),
(1,'assetlib','assignToRisk'),
(1,'assetlib','assignToStory'),
(1,'assetlib','batchApproveComponent'),
(1,'assetlib','batchApproveIssue'),
(1,'assetlib','batchApproveOpportunity'),
(1,'assetlib','batchApprovePractice'),
(1,'assetlib','batchApproveRisk'),
(1,'assetlib','batchApproveStory'),
(1,'assetlib','batchAssignToComponent'),
(1,'assetlib','batchAssignToIssue'),
(1,'assetlib','batchAssignToOpportunity'),
(1,'assetlib','batchAssignToPractice'),
(1,'assetlib','batchAssignToRisk'),
(1,'assetlib','batchAssignToStory'),
(1,'assetlib','batchRemoveComponent'),
(1,'assetlib','batchRemoveIssue'),
(1,'assetlib','batchRemoveOpportunity'),
(1,'assetlib','batchRemovePractice'),
(1,'assetlib','batchRemoveRisk'),
(1,'assetlib','batchRemoveStory'),
(1,'assetlib','caselib'),
(1,'assetlib','component'),
(1,'assetlib','componentlib'),
(1,'assetlib','componentLibView'),
(1,'assetlib','componentView'),
(1,'assetlib','createComponentlib'),
(1,'assetlib','createIssuelib'),
(1,'assetlib','createOpportunitylib'),
(1,'assetlib','createPracticelib'),
(1,'assetlib','createRisklib'),
(1,'assetlib','createStorylib'),
(1,'assetlib','deleteComponentlib'),
(1,'assetlib','deleteIssuelib'),
(1,'assetlib','deleteOpportunitylib'),
(1,'assetlib','deletePracticelib'),
(1,'assetlib','deleteRisklib'),
(1,'assetlib','deleteStorylib'),
(1,'assetlib','editComponent'),
(1,'assetlib','editComponentlib'),
(1,'assetlib','editIssue'),
(1,'assetlib','editIssuelib'),
(1,'assetlib','editOpportunity'),
(1,'assetlib','editOpportunitylib'),
(1,'assetlib','editPractice'),
(1,'assetlib','editPracticelib'),
(1,'assetlib','editRisk'),
(1,'assetlib','editRisklib'),
(1,'assetlib','editStory'),
(1,'assetlib','editStorylib'),
(1,'assetlib','importComponent'),
(1,'assetlib','importIssue'),
(1,'assetlib','importOpportunity'),
(1,'assetlib','importPractice'),
(1,'assetlib','importRisk'),
(1,'assetlib','importStory'),
(1,'assetlib','issue'),
(1,'assetlib','issuelib'),
(1,'assetlib','issueLibView'),
(1,'assetlib','issueView'),
(1,'assetlib','opportunity'),
(1,'assetlib','opportunitylib'),
(1,'assetlib','opportunityLibView'),
(1,'assetlib','opportunityView'),
(1,'assetlib','practice'),
(1,'assetlib','practicelib'),
(1,'assetlib','practiceLibView'),
(1,'assetlib','practiceView'),
(1,'assetlib','removeComponent'),
(1,'assetlib','removeIssue'),
(1,'assetlib','removeOpportunity'),
(1,'assetlib','removePractice'),
(1,'assetlib','removeRisk'),
(1,'assetlib','removeStory'),
(1,'assetlib','risk'),
(1,'assetlib','risklib'),
(1,'assetlib','riskLibView'),
(1,'assetlib','riskView'),
(1,'assetlib','story'),
(1,'assetlib','storylib'),
(1,'assetlib','storyLibView'),
(1,'assetlib','storyView'),
(1,'assetlib','view'),
(1,'audit','8'),
(1,'audit','assign'),
(1,'audit','batchassign'),
(1,'audit','batchcreate'),
(1,'audit','batchedit'),
(1,'audit','browse'),
(1,'audit','create'),
(1,'audit','delete'),
(1,'audit','edit'),
(1,'audit','export'),
(1,'audit','exporttemplate'),
(1,'audit','import'),
(1,'audit','link'),
(1,'audit','search'),
(1,'audit','showimport'),
(1,'audit','unlink'),
(1,'audit','view'),
(1,'auditcl','batchCreate'),
(1,'auditcl','batchEdit'),
(1,'auditcl','browse'),
(1,'auditcl','delete'),
(1,'auditcl','edit'),
(1,'auditplan','batchCheck'),
(1,'auditplan','batchCreate'),
(1,'auditplan','browse'),
(1,'auditplan','check'),
(1,'auditplan','create'),
(1,'auditplan','edit'),
(1,'auditplan','nc'),
(1,'auditplan','result'),
(1,'auditresult','10'),
(1,'auditresult','assign'),
(1,'auditresult','batchassign'),
(1,'auditresult','batchcreate'),
(1,'auditresult','batchedit'),
(1,'auditresult','browse'),
(1,'auditresult','create'),
(1,'auditresult','delete'),
(1,'auditresult','edit'),
(1,'auditresult','export'),
(1,'auditresult','exporttemplate'),
(1,'auditresult','import'),
(1,'auditresult','link'),
(1,'auditresult','search'),
(1,'auditresult','showimport'),
(1,'auditresult','unlink'),
(1,'auditresult','view'),
(1,'baseline','articleview'),
(1,'baseline','catalog'),
(1,'baseline','createTemplate'),
(1,'baseline','delete'),
(1,'baseline','editBook'),
(1,'baseline','editTemplate'),
(1,'baseline','manageBook'),
(1,'baseline','template'),
(1,'baseline','view'),
(1,'bookborrow','59'),
(1,'bookborrow','62'),
(1,'bookborrow','assign'),
(1,'bookborrow','batchassign'),
(1,'bookborrow','batchcreate'),
(1,'bookborrow','batchedit'),
(1,'bookborrow','browse'),
(1,'bookborrow','create'),
(1,'bookborrow','delete'),
(1,'bookborrow','edit'),
(1,'bookborrow','export'),
(1,'bookborrow','exporttemplate'),
(1,'bookborrow','import'),
(1,'bookborrow','link'),
(1,'bookborrow','return'),
(1,'bookborrow','search'),
(1,'bookborrow','showimport'),
(1,'bookborrow','unlink'),
(1,'bookborrow','view'),
(1,'budget','batchCreate'),
(1,'budget','browse'),
(1,'budget','create'),
(1,'budget','delete'),
(1,'budget','edit'),
(1,'budget','summary'),
(1,'budget','view'),
(1,'caselib','justtest'),
(1,'classify','browse'),
(1,'cm','browse'),
(1,'cm','create'),
(1,'cm','delete'),
(1,'cm','edit'),
(1,'cm','report'),
(1,'cm','view'),
(1,'cmcl','batchCreate'),
(1,'cmcl','browse'),
(1,'cmcl','delete'),
(1,'cmcl','edit'),
(1,'cmcl','view'),
(1,'custom','estimate'),
(1,'design','assignTo'),
(1,'design','batchCreate'),
(1,'design','browse'),
(1,'design','create'),
(1,'design','delete'),
(1,'design','edit'),
(1,'design','linkCommit'),
(1,'design','revision'),
(1,'design','unlinkCommit'),
(1,'design','view'),
(1,'design','viewCommit'),
(1,'doc','importToComponentLib'),
(1,'doc','importToPracticeLib'),
(1,'durationestimation','create'),
(1,'durationestimation','index'),
(1,'gapanalysis','batchCreate'),
(1,'gapanalysis','batchEdit'),
(1,'gapanalysis','browse'),
(1,'gapanalysis','create'),
(1,'gapanalysis','delete'),
(1,'gapanalysis','edit'),
(1,'gapanalysis','view'),
(1,'investigation','126'),
(1,'investigation','assign'),
(1,'investigation','batchassign'),
(1,'investigation','batchcreate'),
(1,'investigation','batchedit'),
(1,'investigation','browse'),
(1,'investigation','create'),
(1,'investigation','delete'),
(1,'investigation','edit'),
(1,'investigation','export'),
(1,'investigation','exporttemplate'),
(1,'investigation','import'),
(1,'investigation','investigationreport_create'),
(1,'investigation','link'),
(1,'investigation','report'),
(1,'investigation','search'),
(1,'investigation','showimport'),
(1,'investigation','unlink'),
(1,'investigation','view'),
(1,'investigationreport','129'),
(1,'investigationreport','assign'),
(1,'investigationreport','batchassign'),
(1,'investigationreport','batchcreate'),
(1,'investigationreport','batchedit'),
(1,'investigationreport','browse'),
(1,'investigationreport','create'),
(1,'investigationreport','delete'),
(1,'investigationreport','edit'),
(1,'investigationreport','export'),
(1,'investigationreport','exporttemplate'),
(1,'investigationreport','import'),
(1,'investigationreport','link'),
(1,'investigationreport','report'),
(1,'investigationreport','search'),
(1,'investigationreport','showimport'),
(1,'investigationreport','unlink'),
(1,'investigationreport','view'),
(1,'issue','activate'),
(1,'issue','assignTo'),
(1,'issue','batchCreate'),
(1,'issue','batchImportToLib'),
(1,'issue','browse'),
(1,'issue','cancel'),
(1,'issue','close'),
(1,'issue','confirm'),
(1,'issue','create'),
(1,'issue','delete'),
(1,'issue','edit'),
(1,'issue','importFromLib'),
(1,'issue','importToLib'),
(1,'issue','resolve'),
(1,'issue','view'),
(1,'library','58'),
(1,'library','60'),
(1,'library','61'),
(1,'library','assign'),
(1,'library','batchassign'),
(1,'library','batchcreate'),
(1,'library','batchedit'),
(1,'library','browse'),
(1,'library','create'),
(1,'library','delete'),
(1,'library','edit'),
(1,'library','export'),
(1,'library','exporttemplate'),
(1,'library','import'),
(1,'library','link'),
(1,'library','review'),
(1,'library','search'),
(1,'library','setarea'),
(1,'library','setcategory'),
(1,'library','showimport'),
(1,'library','unlink'),
(1,'library','view'),
(1,'measrecord','browse'),
(1,'measurement','batchEdit'),
(1,'measurement','browse'),
(1,'measurement','createBasic'),
(1,'measurement','createTemplate'),
(1,'measurement','delete'),
(1,'measurement','design'),
(1,'measurement','designPHP'),
(1,'measurement','designSQL'),
(1,'measurement','editBasic'),
(1,'measurement','editDerivation'),
(1,'measurement','editTemplate'),
(1,'measurement','execCrontabQueue'),
(1,'measurement','initCrontabQueue'),
(1,'measurement','searchMeas'),
(1,'measurement','setSQL'),
(1,'measurement','settips'),
(1,'measurement','template'),
(1,'measurement','viewTemplate'),
(1,'meeting','browse'),
(1,'meeting','create'),
(1,'meeting','delete'),
(1,'meeting','edit'),
(1,'meeting','minutes'),
(1,'meeting','view'),
(1,'meetingroom','batchCreate'),
(1,'meetingroom','batchEdit'),
(1,'meetingroom','browse'),
(1,'meetingroom','create'),
(1,'meetingroom','delete'),
(1,'meetingroom','edit'),
(1,'meetingroom','view'),
(1,'metting','127'),
(1,'metting','130'),
(1,'metting','131'),
(1,'metting','assign'),
(1,'metting','batchassign'),
(1,'metting','batchcreate'),
(1,'metting','batchedit'),
(1,'metting','browse'),
(1,'metting','create'),
(1,'metting','delete'),
(1,'metting','edit'),
(1,'metting','export'),
(1,'metting','exporttemplate'),
(1,'metting','import'),
(1,'metting','link'),
(1,'metting','report'),
(1,'metting','search'),
(1,'metting','showimport'),
(1,'metting','summary'),
(1,'metting','unlink'),
(1,'metting','view'),
(1,'milestone','index'),
(1,'milestone','saveOtherProblem'),
(1,'my','issue'),
(1,'my','meeting'),
(1,'my','myMeeting'),
(1,'my','nc'),
(1,'my','risk'),
(1,'nc','16'),
(1,'nc','activate'),
(1,'nc','assign'),
(1,'nc','batchassign'),
(1,'nc','batchcreate'),
(1,'nc','batchedit'),
(1,'nc','browse'),
(1,'nc','close'),
(1,'nc','create'),
(1,'nc','delete'),
(1,'nc','edit'),
(1,'nc','export'),
(1,'nc','exporttemplate'),
(1,'nc','import'),
(1,'nc','link'),
(1,'nc','resolve'),
(1,'nc','search'),
(1,'nc','showimport'),
(1,'nc','unlink'),
(1,'nc','view'),
(1,'opportunity','activate'),
(1,'opportunity','assignTo'),
(1,'opportunity','batchActivate'),
(1,'opportunity','batchAssignTo'),
(1,'opportunity','batchCancel'),
(1,'opportunity','batchClose'),
(1,'opportunity','batchCreate'),
(1,'opportunity','batchEdit'),
(1,'opportunity','batchHangup'),
(1,'opportunity','batchImportToLib'),
(1,'opportunity','browse'),
(1,'opportunity','cancel'),
(1,'opportunity','close'),
(1,'opportunity','create'),
(1,'opportunity','delete'),
(1,'opportunity','edit'),
(1,'opportunity','hangup'),
(1,'opportunity','importFromLib'),
(1,'opportunity','importToLib'),
(1,'opportunity','track'),
(1,'opportunity','view'),
(1,'output','13'),
(1,'output','assign'),
(1,'output','batchassign'),
(1,'output','batchcreate'),
(1,'output','batchedit'),
(1,'output','browse'),
(1,'output','create'),
(1,'output','delete'),
(1,'output','edit'),
(1,'output','export'),
(1,'output','exporttemplate'),
(1,'output','import'),
(1,'output','link'),
(1,'output','search'),
(1,'output','showimport'),
(1,'output','unlink'),
(1,'output','view'),
(1,'process','activityList'),
(1,'process','batchCreate'),
(1,'process','browse'),
(1,'process','create'),
(1,'process','delete'),
(1,'process','edit'),
(1,'process','updateOrder'),
(1,'process','view'),
(1,'programplan','browse'),
(1,'programplan','create'),
(1,'programplan','edit'),
(1,'projectstory','importFromLib'),
(1,'pssp','browse'),
(1,'pssp','update'),
(1,'report','customeRedreport'),
(1,'report','instanceTemplate'),
(1,'researchplan','browse'),
(1,'researchplan','create'),
(1,'researchplan','delete'),
(1,'researchplan','edit'),
(1,'researchplan','view'),
(1,'researchreport','browse'),
(1,'researchreport','create'),
(1,'researchreport','delete'),
(1,'researchreport','edit'),
(1,'researchreport','view'),
(1,'review','assess'),
(1,'review','audit'),
(1,'review','browse'),
(1,'review','create'),
(1,'review','edit'),
(1,'review','recall'),
(1,'review','report'),
(1,'review','result'),
(1,'review','submit'),
(1,'review','toAudit'),
(1,'review','view'),
(1,'reviewcl','batchCreate'),
(1,'reviewcl','browse'),
(1,'reviewcl','create'),
(1,'reviewcl','delete'),
(1,'reviewcl','edit'),
(1,'reviewcl','view'),
(1,'reviewissue','create'),
(1,'reviewissue','edit'),
(1,'reviewissue','issue'),
(1,'reviewissue','resolved'),
(1,'reviewissue','updateStatus'),
(1,'reviewissue','view'),
(1,'reviewsetting','reviewer'),
(1,'reviewsetting','version'),
(1,'risk','activate'),
(1,'risk','assignTo'),
(1,'risk','batchCreate'),
(1,'risk','batchImportToLib'),
(1,'risk','browse'),
(1,'risk','cancel'),
(1,'risk','close'),
(1,'risk','create'),
(1,'risk','delete'),
(1,'risk','edit'),
(1,'risk','hangup'),
(1,'risk','importFromLib'),
(1,'risk','importToLib'),
(1,'risk','track'),
(1,'risk','view'),
(1,'sqlbuilder','browseSQLView'),
(1,'sqlbuilder','create'),
(1,'sqlbuilder','createSQLView'),
(1,'sqlbuilder','deleteSQLView'),
(1,'sqlbuilder','editSQLView'),
(1,'stage','batchCreate'),
(1,'stage','browse'),
(1,'stage','create'),
(1,'stage','delete'),
(1,'stage','edit'),
(1,'stage','setType'),
(1,'story','batchImportToLib'),
(1,'story','importToLib'),
(1,'subject','browse'),
(1,'task','confirmdesignchange'),
(1,'testcase','submit'),
(1,'testsuite','test'),
(1,'train','browse'),
(1,'train','create'),
(1,'train','delete'),
(1,'train','edit'),
(1,'train','finish'),
(1,'train','summary'),
(1,'train','view'),
(1,'trainbook','ajaxgetbookbysn'),
(1,'trainbook','export'),
(1,'traincareer','index'),
(1,'trainchapter','browse'),
(1,'trainchapter','catalog'),
(1,'trainchapter','delete'),
(1,'trainchapter','download'),
(1,'trainchapter','edit'),
(1,'trainchapter','manage'),
(1,'trainchapter','showDocFiles'),
(1,'trainchapter','sortChapterOrder'),
(1,'trainchapter','view'),
(1,'traincourse','browse'),
(1,'traincourse','changeStatus'),
(1,'traincourse','collect'),
(1,'traincourse','create'),
(1,'traincourse','delete'),
(1,'traincourse','edit'),
(1,'traincourse','manage'),
(1,'traincourse','view'),
(1,'trainexam','browse'),
(1,'trainexam','changeStatus'),
(1,'trainexam','choseExam'),
(1,'trainexam','create'),
(1,'trainexam','delete'),
(1,'trainexam','deleteQuestion'),
(1,'trainexam','edit'),
(1,'trainexam','editQuestion'),
(1,'trainexam','exam'),
(1,'trainexam','myExams'),
(1,'trainexam','review'),
(1,'trainexam','scoreDetail'),
(1,'trainexam','setQuestion'),
(1,'trainexam','updateOrder'),
(1,'trainexam','view'),
(1,'traingoal','browse'),
(1,'traingoal','browseCompanyGoals'),
(1,'traingoal','browseDeptGoals'),
(1,'traingoal','create'),
(1,'traingoal','delete'),
(1,'traingoal','edit'),
(1,'traingoal','recall'),
(1,'traingoal','review'),
(1,'traingoal','submitReview'),
(1,'traingoal','updateOrder'),
(1,'traingoal','view'),
(1,'trainplan','batchCreate'),
(1,'trainplan','batchEdit'),
(1,'trainplan','batchFinish'),
(1,'trainplan','browse'),
(1,'trainplan','create'),
(1,'trainplan','delete'),
(1,'trainplan','edit'),
(1,'trainplan','finish'),
(1,'trainplan','summary'),
(1,'trainplan','view'),
(1,'trainpost','browse'),
(1,'trainpost','create'),
(1,'trainpost','createGrade'),
(1,'trainpost','delete'),
(1,'trainpost','edit'),
(1,'trainpost','editGrade'),
(1,'trainpost','gradeView'),
(1,'trainpost','manageGrade'),
(1,'trainpost','sortGrade'),
(1,'trainpost','sortPost'),
(1,'trainpost','view'),
(1,'trainskill','browse'),
(1,'trainskill','create'),
(1,'trainskill','createGrade'),
(1,'trainskill','delete'),
(1,'trainskill','deleteDesc'),
(1,'trainskill','deleteGrade'),
(1,'trainskill','edit'),
(1,'trainskill','editGrade'),
(1,'trainskill','view'),
(1,'traintask','browse'),
(1,'traintask','browseCompanyTasks'),
(1,'traintask','browseDeptTasks'),
(1,'traintask','close'),
(1,'traintask','create'),
(1,'traintask','createTask'),
(1,'traintask','delete'),
(1,'traintask','edit'),
(1,'traintask','finish'),
(1,'traintask','import'),
(1,'traintask','setCondition'),
(1,'traintask','start'),
(1,'traintask','view'),
(1,'weekly','index'),
(1,'workestimation','index'),
(1,'workloadbudget','27'),
(1,'workloadbudget','assign'),
(1,'workloadbudget','batchassign'),
(1,'workloadbudget','batchcreate'),
(1,'workloadbudget','batchedit'),
(1,'workloadbudget','browse'),
(1,'workloadbudget','create'),
(1,'workloadbudget','delete'),
(1,'workloadbudget','edit'),
(1,'workloadbudget','export'),
(1,'workloadbudget','exporttemplate'),
(1,'workloadbudget','import'),
(1,'workloadbudget','link'),
(1,'workloadbudget','search'),
(1,'workloadbudget','showimport'),
(1,'workloadbudget','unlink'),
(1,'workloadbudget','view'),
(1,'zoutput','batchCreate'),
(1,'zoutput','batchEdit'),
(1,'zoutput','browse'),
(1,'zoutput','create'),
(1,'zoutput','delete'),
(1,'zoutput','edit'),
(1,'zoutput','updateOrder'),
(1,'zoutput','view'),
(2,'activity','browse'),
(2,'activity','create'),
(2,'activity','delete'),
(2,'activity','edit'),
(2,'activity','view'),
(2,'audit','8'),
(2,'audit','assign'),
(2,'audit','batchassign'),
(2,'audit','batchcreate'),
(2,'audit','batchedit'),
(2,'audit','browse'),
(2,'audit','create'),
(2,'audit','delete'),
(2,'audit','edit'),
(2,'audit','export'),
(2,'audit','exporttemplate'),
(2,'audit','import'),
(2,'audit','link'),
(2,'audit','search'),
(2,'audit','showimport'),
(2,'audit','unlink'),
(2,'audit','view'),
(2,'auditcl','browse'),
(2,'auditplan','browse'),
(2,'auditplan','create'),
(2,'auditplan','edit'),
(2,'auditplan','nc'),
(2,'auditplan','result'),
(2,'auditresult','10'),
(2,'auditresult','assign'),
(2,'auditresult','batchassign'),
(2,'auditresult','batchcreate'),
(2,'auditresult','batchedit'),
(2,'auditresult','browse'),
(2,'auditresult','create'),
(2,'auditresult','delete'),
(2,'auditresult','edit'),
(2,'auditresult','export'),
(2,'auditresult','exporttemplate'),
(2,'auditresult','import'),
(2,'auditresult','link'),
(2,'auditresult','search'),
(2,'auditresult','showimport'),
(2,'auditresult','unlink'),
(2,'auditresult','view'),
(2,'baseline','articleview'),
(2,'baseline','catalog'),
(2,'baseline','createTemplate'),
(2,'baseline','editBook'),
(2,'baseline','editTemplate'),
(2,'baseline','manageBook'),
(2,'baseline','template'),
(2,'baseline','view'),
(2,'budget','browse'),
(2,'classify','browse'),
(2,'cm','browse'),
(2,'cm','create'),
(2,'cm','edit'),
(2,'cm','report'),
(2,'cm','view'),
(2,'cmcl','browse'),
(2,'custom','estimate'),
(2,'design','browse'),
(2,'design','create'),
(2,'design','delete'),
(2,'design','edit'),
(2,'design','view'),
(2,'durationestimation','create'),
(2,'durationestimation','index'),
(2,'gapanalysis','batchCreate'),
(2,'gapanalysis','browse'),
(2,'gapanalysis','create'),
(2,'gapanalysis','edit'),
(2,'investigation','126'),
(2,'investigation','analysis'),
(2,'investigation','assign'),
(2,'investigation','batchassign'),
(2,'investigation','batchcreate'),
(2,'investigation','batchedit'),
(2,'investigation','browse'),
(2,'investigation','create'),
(2,'investigation','delete'),
(2,'investigation','edit'),
(2,'investigation','export'),
(2,'investigation','exporttemplate'),
(2,'investigation','import'),
(2,'investigation','link'),
(2,'investigation','report'),
(2,'investigation','search'),
(2,'investigation','showimport'),
(2,'investigation','unlink'),
(2,'investigation','view'),
(2,'issue','activate'),
(2,'issue','batchCreate'),
(2,'issue','browse'),
(2,'issue','cancel'),
(2,'issue','close'),
(2,'issue','create'),
(2,'issue','delete'),
(2,'issue','edit'),
(2,'issue','resolve'),
(2,'issue','view'),
(2,'leave','back'),
(2,'meeting','browse'),
(2,'meeting','create'),
(2,'meeting','delete'),
(2,'meeting','edit'),
(2,'meeting','minutes'),
(2,'meeting','view'),
(2,'milestone','index'),
(2,'milestone','saveOtherProblem'),
(2,'my','issue'),
(2,'my','meeting'),
(2,'my','myMeeting'),
(2,'my','nc'),
(2,'my','risk'),
(2,'nc','16'),
(2,'nc','activate'),
(2,'nc','assign'),
(2,'nc','batchassign'),
(2,'nc','batchcreate'),
(2,'nc','batchedit'),
(2,'nc','browse'),
(2,'nc','close'),
(2,'nc','create'),
(2,'nc','delete'),
(2,'nc','edit'),
(2,'nc','export'),
(2,'nc','exporttemplate'),
(2,'nc','import'),
(2,'nc','link'),
(2,'nc','resolve'),
(2,'nc','search'),
(2,'nc','showimport'),
(2,'nc','unlink'),
(2,'nc','view'),
(2,'opportunity','activate'),
(2,'opportunity','assignTo'),
(2,'opportunity','batchActivate'),
(2,'opportunity','batchAssignTo'),
(2,'opportunity','batchCancel'),
(2,'opportunity','batchClose'),
(2,'opportunity','batchCreate'),
(2,'opportunity','batchEdit'),
(2,'opportunity','batchHangup'),
(2,'opportunity','browse'),
(2,'opportunity','cancel'),
(2,'opportunity','close'),
(2,'opportunity','create'),
(2,'opportunity','delete'),
(2,'opportunity','edit'),
(2,'opportunity','hangup'),
(2,'opportunity','importFromLib'),
(2,'opportunity','track'),
(2,'opportunity','view'),
(2,'output','13'),
(2,'output','assign'),
(2,'output','batchassign'),
(2,'output','batchcreate'),
(2,'output','batchedit'),
(2,'output','browse'),
(2,'output','create'),
(2,'output','delete'),
(2,'output','edit'),
(2,'output','export'),
(2,'output','exporttemplate'),
(2,'output','import'),
(2,'output','link'),
(2,'output','search'),
(2,'output','showimport'),
(2,'output','unlink'),
(2,'output','view'),
(2,'process','browse'),
(2,'process','create'),
(2,'process','delete'),
(2,'process','edit'),
(2,'process','view'),
(2,'pssp','browse'),
(2,'pssp','update'),
(2,'report','customeRedreport'),
(2,'review','assess'),
(2,'review','audit'),
(2,'review','browse'),
(2,'review','create'),
(2,'review','edit'),
(2,'review','recall'),
(2,'review','report'),
(2,'review','result'),
(2,'review','submit'),
(2,'review','toAudit'),
(2,'review','view'),
(2,'reviewcl','browse'),
(2,'reviewissue','create'),
(2,'reviewissue','edit'),
(2,'reviewissue','issue'),
(2,'reviewissue','resolved'),
(2,'reviewissue','updateStatus'),
(2,'reviewissue','view'),
(2,'reviewsetting','reviewer'),
(2,'reviewsetting','version'),
(2,'risk','activate'),
(2,'risk','browse'),
(2,'risk','cancel'),
(2,'risk','close'),
(2,'risk','create'),
(2,'risk','delete'),
(2,'risk','edit'),
(2,'risk','hangup'),
(2,'risk','view'),
(2,'stage','batchCreate'),
(2,'stage','browse'),
(2,'stage','create'),
(2,'stage','delete'),
(2,'stage','edit'),
(2,'subject','browse'),
(2,'task','confirmdesignchange'),
(2,'testcase','submit'),
(2,'testsuite','test'),
(2,'trainchapter','browse'),
(2,'trainchapter','catalog'),
(2,'trainchapter','delete'),
(2,'trainchapter','edit'),
(2,'trainchapter','manage'),
(2,'trainchapter','showDocFiles'),
(2,'trainchapter','sortChapterOrder'),
(2,'trainchapter','view'),
(2,'traincourse','browse'),
(2,'traincourse','create'),
(2,'traincourse','delete'),
(2,'traincourse','edit'),
(2,'traincourse','view'),
(2,'traingoal','browse'),
(2,'traingoal','create'),
(2,'traingoal','delete'),
(2,'traingoal','edit'),
(2,'traingoal','review'),
(2,'traingoal','submitReview'),
(2,'traingoal','updateOrder'),
(2,'traingoal','view'),
(2,'trainplan','batchCreate'),
(2,'trainplan','batchEdit'),
(2,'trainplan','batchFinish'),
(2,'trainplan','browse'),
(2,'trainplan','create'),
(2,'trainplan','delete'),
(2,'trainplan','edit'),
(2,'trainplan','finish'),
(2,'trainplan','summary'),
(2,'trainplan','view'),
(2,'trainpost','browse'),
(2,'trainpost','create'),
(2,'trainpost','delete'),
(2,'trainpost','edit'),
(2,'trainpost','editGrade'),
(2,'trainpost','gradeView'),
(2,'trainpost','manageGrade'),
(2,'trainpost','updateOrder'),
(2,'trainpost','view'),
(2,'trainskill','browse'),
(2,'trainskill','create'),
(2,'trainskill','createGrade'),
(2,'trainskill','delete'),
(2,'trainskill','deleteDesc'),
(2,'trainskill','deleteGrade'),
(2,'trainskill','edit'),
(2,'trainskill','editGrade'),
(2,'trainskill','view'),
(2,'traintask','browse'),
(2,'traintask','closed'),
(2,'traintask','create'),
(2,'traintask','delete'),
(2,'traintask','edit'),
(2,'traintask','finish'),
(2,'traintask','import'),
(2,'traintask','start'),
(2,'traintask','view'),
(2,'weekly','index'),
(2,'workestimation','index'),
(2,'workloadbudget','27'),
(2,'workloadbudget','assign'),
(2,'workloadbudget','batchassign'),
(2,'workloadbudget','batchcreate'),
(2,'workloadbudget','batchedit'),
(2,'workloadbudget','browse'),
(2,'workloadbudget','create'),
(2,'workloadbudget','delete'),
(2,'workloadbudget','edit'),
(2,'workloadbudget','export'),
(2,'workloadbudget','exporttemplate'),
(2,'workloadbudget','import'),
(2,'workloadbudget','link'),
(2,'workloadbudget','search'),
(2,'workloadbudget','showimport'),
(2,'workloadbudget','unlink'),
(2,'workloadbudget','view'),
(3,'activity','browse'),
(3,'activity','create'),
(3,'activity','delete'),
(3,'activity','edit'),
(3,'activity','view'),
(3,'audit','8'),
(3,'audit','assign'),
(3,'audit','batchassign'),
(3,'audit','batchcreate'),
(3,'audit','batchedit'),
(3,'audit','browse'),
(3,'audit','create'),
(3,'audit','delete'),
(3,'audit','edit'),
(3,'audit','export'),
(3,'audit','exporttemplate'),
(3,'audit','import'),
(3,'audit','link'),
(3,'audit','search'),
(3,'audit','showimport'),
(3,'audit','unlink'),
(3,'audit','view'),
(3,'auditcl','browse'),
(3,'auditplan','browse'),
(3,'auditplan','create'),
(3,'auditplan','edit'),
(3,'auditplan','nc'),
(3,'auditplan','result'),
(3,'auditresult','10'),
(3,'auditresult','assign'),
(3,'auditresult','batchassign'),
(3,'auditresult','batchcreate'),
(3,'auditresult','batchedit'),
(3,'auditresult','browse'),
(3,'auditresult','create'),
(3,'auditresult','delete'),
(3,'auditresult','edit'),
(3,'auditresult','export'),
(3,'auditresult','exporttemplate'),
(3,'auditresult','import'),
(3,'auditresult','link'),
(3,'auditresult','search'),
(3,'auditresult','showimport'),
(3,'auditresult','unlink'),
(3,'auditresult','view'),
(3,'baseline','articleview'),
(3,'baseline','catalog'),
(3,'baseline','createTemplate'),
(3,'baseline','editBook'),
(3,'baseline','editTemplate'),
(3,'baseline','manageBook'),
(3,'baseline','template'),
(3,'baseline','view'),
(3,'budget','batchCreate'),
(3,'budget','browse'),
(3,'budget','create'),
(3,'budget','edit'),
(3,'budget','summary'),
(3,'budget','view'),
(3,'caselib','justtest'),
(3,'classify','browse'),
(3,'cm','browse'),
(3,'cm','create'),
(3,'cm','edit'),
(3,'cm','report'),
(3,'cm','view'),
(3,'cmcl','browse'),
(3,'custom','estimate'),
(3,'design','browse'),
(3,'design','create'),
(3,'design','edit'),
(3,'design','view'),
(3,'durationestimation','create'),
(3,'durationestimation','index'),
(3,'gapanalysis','batchCreate'),
(3,'gapanalysis','batchEdit'),
(3,'gapanalysis','browse'),
(3,'gapanalysis','create'),
(3,'gapanalysis','delete'),
(3,'gapanalysis','edit'),
(3,'gapanalysis','view'),
(3,'issue','activate'),
(3,'issue','browse'),
(3,'issue','cancel'),
(3,'issue','close'),
(3,'issue','create'),
(3,'issue','delete'),
(3,'issue','edit'),
(3,'issue','resolve'),
(3,'issue','view'),
(3,'meeting','browse'),
(3,'meeting','create'),
(3,'meeting','delete'),
(3,'meeting','edit'),
(3,'meeting','minutes'),
(3,'meeting','view'),
(3,'milestone','index'),
(3,'milestone','saveOtherProblem'),
(3,'my','issue'),
(3,'my','meeting'),
(3,'my','myMeeting'),
(3,'my','nc'),
(3,'my','risk'),
(3,'nc','16'),
(3,'nc','activate'),
(3,'nc','assign'),
(3,'nc','batchassign'),
(3,'nc','batchcreate'),
(3,'nc','batchedit'),
(3,'nc','browse'),
(3,'nc','close'),
(3,'nc','create'),
(3,'nc','delete'),
(3,'nc','edit'),
(3,'nc','export'),
(3,'nc','exporttemplate'),
(3,'nc','import'),
(3,'nc','link'),
(3,'nc','resolve'),
(3,'nc','search'),
(3,'nc','showimport'),
(3,'nc','unlink'),
(3,'nc','view'),
(3,'opportunity','activate'),
(3,'opportunity','assignTo'),
(3,'opportunity','batchActivate'),
(3,'opportunity','batchAssignTo'),
(3,'opportunity','batchCancel'),
(3,'opportunity','batchClose'),
(3,'opportunity','batchCreate'),
(3,'opportunity','batchEdit'),
(3,'opportunity','batchHangup'),
(3,'opportunity','browse'),
(3,'opportunity','cancel'),
(3,'opportunity','close'),
(3,'opportunity','create'),
(3,'opportunity','delete'),
(3,'opportunity','edit'),
(3,'opportunity','hangup'),
(3,'opportunity','importFromLib'),
(3,'opportunity','track'),
(3,'opportunity','view'),
(3,'output','13'),
(3,'output','assign'),
(3,'output','batchassign'),
(3,'output','batchcreate'),
(3,'output','batchedit'),
(3,'output','browse'),
(3,'output','create'),
(3,'output','delete'),
(3,'output','edit'),
(3,'output','export'),
(3,'output','exporttemplate'),
(3,'output','import'),
(3,'output','link'),
(3,'output','search'),
(3,'output','showimport'),
(3,'output','unlink'),
(3,'output','view'),
(3,'process','browse'),
(3,'process','create'),
(3,'process','delete'),
(3,'process','edit'),
(3,'process','view'),
(3,'pssp','browse'),
(3,'pssp','update'),
(3,'report','customeRedreport'),
(3,'review','assess'),
(3,'review','audit'),
(3,'review','browse'),
(3,'review','create'),
(3,'review','edit'),
(3,'review','recall'),
(3,'review','report'),
(3,'review','result'),
(3,'review','submit'),
(3,'review','toAudit'),
(3,'review','view'),
(3,'reviewcl','browse'),
(3,'reviewissue','create'),
(3,'reviewissue','edit'),
(3,'reviewissue','issue'),
(3,'reviewissue','resolved'),
(3,'reviewissue','updateStatus'),
(3,'reviewissue','view'),
(3,'reviewsetting','reviewer'),
(3,'reviewsetting','version'),
(3,'risk','activate'),
(3,'risk','browse'),
(3,'risk','cancel'),
(3,'risk','close'),
(3,'risk','create'),
(3,'risk','edit'),
(3,'risk','hangup'),
(3,'risk','view'),
(3,'stage','batchCreate'),
(3,'stage','browse'),
(3,'stage','create'),
(3,'stage','delete'),
(3,'stage','edit'),
(3,'subject','browse'),
(3,'testcase','submit'),
(3,'testsuite','test'),
(3,'trainbook','browse'),
(3,'trainplan','browse'),
(3,'trainplan','view'),
(3,'weekly','index'),
(3,'workestimation','index'),
(3,'workloadbudget','27'),
(3,'workloadbudget','assign'),
(3,'workloadbudget','batchassign'),
(3,'workloadbudget','batchcreate'),
(3,'workloadbudget','batchedit'),
(3,'workloadbudget','browse'),
(3,'workloadbudget','create'),
(3,'workloadbudget','delete'),
(3,'workloadbudget','edit'),
(3,'workloadbudget','export'),
(3,'workloadbudget','exporttemplate'),
(3,'workloadbudget','import'),
(3,'workloadbudget','link'),
(3,'workloadbudget','search'),
(3,'workloadbudget','showimport'),
(3,'workloadbudget','unlink'),
(3,'workloadbudget','view'),
(4,'activity','browse'),
(4,'activity','create'),
(4,'activity','delete'),
(4,'activity','edit'),
(4,'activity','view'),
(4,'audit','8'),
(4,'audit','assign'),
(4,'audit','batchassign'),
(4,'audit','batchcreate'),
(4,'audit','batchedit'),
(4,'audit','browse'),
(4,'audit','create'),
(4,'audit','delete'),
(4,'audit','edit'),
(4,'audit','export'),
(4,'audit','exporttemplate'),
(4,'audit','import'),
(4,'audit','link'),
(4,'audit','search'),
(4,'audit','showimport'),
(4,'audit','unlink'),
(4,'audit','view'),
(4,'auditcl','browse'),
(4,'auditcl','delete'),
(4,'auditcl','edit'),
(4,'auditplan','browse'),
(4,'auditplan','create'),
(4,'auditplan','edit'),
(4,'auditplan','nc'),
(4,'auditplan','result'),
(4,'auditresult','10'),
(4,'auditresult','assign'),
(4,'auditresult','batchassign'),
(4,'auditresult','batchcreate'),
(4,'auditresult','batchedit'),
(4,'auditresult','browse'),
(4,'auditresult','create'),
(4,'auditresult','delete'),
(4,'auditresult','edit'),
(4,'auditresult','export'),
(4,'auditresult','exporttemplate'),
(4,'auditresult','import'),
(4,'auditresult','link'),
(4,'auditresult','search'),
(4,'auditresult','showimport'),
(4,'auditresult','unlink'),
(4,'auditresult','view'),
(4,'baseline','articleview'),
(4,'baseline','catalog'),
(4,'baseline','createTemplate'),
(4,'baseline','editBook'),
(4,'baseline','editTemplate'),
(4,'baseline','manageBook'),
(4,'baseline','template'),
(4,'baseline','view'),
(4,'budget','batchCreate'),
(4,'budget','browse'),
(4,'budget','create'),
(4,'budget','edit'),
(4,'budget','summary'),
(4,'budget','view'),
(4,'build','browse'),
(4,'caselib','justtest'),
(4,'classify','browse'),
(4,'cm','browse'),
(4,'cm','create'),
(4,'cm','edit'),
(4,'cm','report'),
(4,'cm','view'),
(4,'cmcl','browse'),
(4,'cmcl','delete'),
(4,'cmcl','edit'),
(4,'cmcl','view'),
(4,'design','browse'),
(4,'design','create'),
(4,'design','delete'),
(4,'design','edit'),
(4,'design','view'),
(4,'doc','importToComponentLib'),
(4,'doc','importToPracticeLib'),
(4,'durationestimation','create'),
(4,'durationestimation','index'),
(4,'gapanalysis','batchCreate'),
(4,'gapanalysis','batchEdit'),
(4,'gapanalysis','browse'),
(4,'gapanalysis','create'),
(4,'gapanalysis','delete'),
(4,'gapanalysis','edit'),
(4,'gapanalysis','view'),
(4,'issue','activate'),
(4,'issue','batchCreate'),
(4,'issue','browse'),
(4,'issue','cancel'),
(4,'issue','close'),
(4,'issue','create'),
(4,'issue','delete'),
(4,'issue','edit'),
(4,'issue','resolve'),
(4,'issue','view'),
(4,'meeting','browse'),
(4,'meeting','create'),
(4,'meeting','delete'),
(4,'meeting','edit'),
(4,'meeting','minutes'),
(4,'meeting','view'),
(4,'meetingroom','batchCreate'),
(4,'meetingroom','batchEdit'),
(4,'meetingroom','browse'),
(4,'meetingroom','create'),
(4,'meetingroom','delete'),
(4,'meetingroom','edit'),
(4,'meetingroom','view'),
(4,'metting','127'),
(4,'metting','assign'),
(4,'metting','batchassign'),
(4,'metting','batchcreate'),
(4,'metting','batchedit'),
(4,'metting','browse'),
(4,'metting','create'),
(4,'metting','delete'),
(4,'metting','edit'),
(4,'metting','export'),
(4,'metting','exporttemplate'),
(4,'metting','import'),
(4,'metting','link'),
(4,'metting','report'),
(4,'metting','search'),
(4,'metting','showimport'),
(4,'metting','unlink'),
(4,'metting','view'),
(4,'milestone','index'),
(4,'milestone','saveOtherProblem'),
(4,'my','issue'),
(4,'my','meeting'),
(4,'my','myMeeting'),
(4,'my','nc'),
(4,'my','risk'),
(4,'nc','16'),
(4,'nc','activate'),
(4,'nc','assign'),
(4,'nc','batchassign'),
(4,'nc','batchcreate'),
(4,'nc','batchedit'),
(4,'nc','browse'),
(4,'nc','close'),
(4,'nc','create'),
(4,'nc','delete'),
(4,'nc','edit'),
(4,'nc','export'),
(4,'nc','exporttemplate'),
(4,'nc','import'),
(4,'nc','link'),
(4,'nc','resolve'),
(4,'nc','search'),
(4,'nc','showimport'),
(4,'nc','unlink'),
(4,'nc','view'),
(4,'opportunity','activate'),
(4,'opportunity','assignTo'),
(4,'opportunity','batchActivate'),
(4,'opportunity','batchAssignTo'),
(4,'opportunity','batchCancel'),
(4,'opportunity','batchClose'),
(4,'opportunity','batchCreate'),
(4,'opportunity','batchEdit'),
(4,'opportunity','batchHangup'),
(4,'opportunity','batchImportToLib'),
(4,'opportunity','browse'),
(4,'opportunity','cancel'),
(4,'opportunity','close'),
(4,'opportunity','create'),
(4,'opportunity','delete'),
(4,'opportunity','edit'),
(4,'opportunity','hangup'),
(4,'opportunity','importFromLib'),
(4,'opportunity','importToLib'),
(4,'opportunity','track'),
(4,'opportunity','view'),
(4,'output','13'),
(4,'output','assign'),
(4,'output','batchassign'),
(4,'output','batchcreate'),
(4,'output','batchedit'),
(4,'output','browse'),
(4,'output','create'),
(4,'output','delete'),
(4,'output','edit'),
(4,'output','export'),
(4,'output','exporttemplate'),
(4,'output','import'),
(4,'output','link'),
(4,'output','search'),
(4,'output','showimport'),
(4,'output','unlink'),
(4,'output','view'),
(4,'process','browse'),
(4,'process','create'),
(4,'process','delete'),
(4,'process','edit'),
(4,'process','view'),
(4,'programplan','browse'),
(4,'programplan','create'),
(4,'programplan','edit'),
(4,'projectstory','importFromLib'),
(4,'pssp','browse'),
(4,'pssp','update'),
(4,'report','customeRedreport'),
(4,'report','instanceTemplate'),
(4,'review','assess'),
(4,'review','audit'),
(4,'review','browse'),
(4,'review','create'),
(4,'review','edit'),
(4,'review','recall'),
(4,'review','report'),
(4,'review','result'),
(4,'review','submit'),
(4,'review','toAudit'),
(4,'review','view'),
(4,'reviewcl','browse'),
(4,'reviewcl','create'),
(4,'reviewcl','delete'),
(4,'reviewcl','edit'),
(4,'reviewcl','view'),
(4,'reviewissue','create'),
(4,'reviewissue','edit'),
(4,'reviewissue','issue'),
(4,'reviewissue','resolved'),
(4,'reviewissue','updateStatus'),
(4,'reviewissue','view'),
(4,'reviewsetting','reviewer'),
(4,'reviewsetting','version'),
(4,'risk','activate'),
(4,'risk','assignTo'),
(4,'risk','batchCreate'),
(4,'risk','browse'),
(4,'risk','cancel'),
(4,'risk','close'),
(4,'risk','create'),
(4,'risk','delete'),
(4,'risk','edit'),
(4,'risk','hangup'),
(4,'risk','importFromLib'),
(4,'risk','track'),
(4,'risk','view'),
(4,'stage','batchCreate'),
(4,'stage','browse'),
(4,'stage','create'),
(4,'stage','delete'),
(4,'stage','edit'),
(4,'story','batchImportToLib'),
(4,'story','importToLib'),
(4,'subject','browse'),
(4,'task','confirmdesignchange'),
(4,'testcase','submit'),
(4,'testsuite','test'),
(4,'trainbook','ajaxgetbookbysn'),
(4,'trainbook','borrow'),
(4,'trainbook','borrowhistory'),
(4,'trainbook','browse'),
(4,'trainbook','returnbook'),
(4,'trainbook','view'),
(4,'traincareer','index'),
(4,'trainchapter','browse'),
(4,'trainchapter','download'),
(4,'trainchapter','showDocFiles'),
(4,'trainchapter','view'),
(4,'traincourse','browse'),
(4,'traincourse','collect'),
(4,'traincourse','view'),
(4,'trainexam','browse'),
(4,'trainexam','choseExam'),
(4,'trainexam','exam'),
(4,'trainexam','myExams'),
(4,'trainexam','scoreDetail'),
(4,'traingoal','browse'),
(4,'traingoal','create'),
(4,'traingoal','delete'),
(4,'traingoal','edit'),
(4,'traingoal','recall'),
(4,'traingoal','review'),
(4,'traingoal','submitReview'),
(4,'traingoal','updateOrder'),
(4,'traingoal','view'),
(4,'trainplan','batchCreate'),
(4,'trainplan','batchEdit'),
(4,'trainplan','batchFinish'),
(4,'trainplan','browse'),
(4,'trainplan','create'),
(4,'trainplan','delete'),
(4,'trainplan','edit'),
(4,'trainplan','finish'),
(4,'trainplan','summary'),
(4,'trainplan','view'),
(4,'trainpost','browse'),
(4,'trainpost','gradeView'),
(4,'trainpost','view'),
(4,'trainskill','browse'),
(4,'trainskill','editGrade'),
(4,'trainskill','view'),
(4,'traintask','browse'),
(4,'traintask','browseDeptTasks'),
(4,'traintask','close'),
(4,'traintask','create'),
(4,'traintask','createTask'),
(4,'traintask','delete'),
(4,'traintask','edit'),
(4,'traintask','finish'),
(4,'traintask','import'),
(4,'traintask','start'),
(4,'traintask','view'),
(4,'weekly','index'),
(4,'workestimation','index'),
(4,'workloadbudget','27'),
(4,'workloadbudget','assign'),
(4,'workloadbudget','batchassign'),
(4,'workloadbudget','batchcreate'),
(4,'workloadbudget','batchedit'),
(4,'workloadbudget','browse'),
(4,'workloadbudget','create'),
(4,'workloadbudget','delete'),
(4,'workloadbudget','edit'),
(4,'workloadbudget','export'),
(4,'workloadbudget','exporttemplate'),
(4,'workloadbudget','import'),
(4,'workloadbudget','link'),
(4,'workloadbudget','search'),
(4,'workloadbudget','showimport'),
(4,'workloadbudget','unlink'),
(4,'workloadbudget','view'),
(5,'activity','browse'),
(5,'activity','create'),
(5,'activity','delete'),
(5,'activity','edit'),
(5,'activity','view'),
(5,'audit','8'),
(5,'audit','assign'),
(5,'audit','batchassign'),
(5,'audit','batchcreate'),
(5,'audit','batchedit'),
(5,'audit','browse'),
(5,'audit','create'),
(5,'audit','delete'),
(5,'audit','edit'),
(5,'audit','export'),
(5,'audit','exporttemplate'),
(5,'audit','import'),
(5,'audit','link'),
(5,'audit','search'),
(5,'audit','showimport'),
(5,'audit','unlink'),
(5,'audit','view'),
(5,'auditcl','browse'),
(5,'auditcl','delete'),
(5,'auditcl','edit'),
(5,'auditplan','browse'),
(5,'auditplan','create'),
(5,'auditplan','edit'),
(5,'auditplan','nc'),
(5,'auditplan','result'),
(5,'auditresult','10'),
(5,'auditresult','assign'),
(5,'auditresult','batchassign'),
(5,'auditresult','batchcreate'),
(5,'auditresult','batchedit'),
(5,'auditresult','browse'),
(5,'auditresult','create'),
(5,'auditresult','delete'),
(5,'auditresult','edit'),
(5,'auditresult','export'),
(5,'auditresult','exporttemplate'),
(5,'auditresult','import'),
(5,'auditresult','link'),
(5,'auditresult','search'),
(5,'auditresult','showimport'),
(5,'auditresult','unlink'),
(5,'auditresult','view'),
(5,'baseline','articleview'),
(5,'baseline','catalog'),
(5,'baseline','createTemplate'),
(5,'baseline','editBook'),
(5,'baseline','editTemplate'),
(5,'baseline','manageBook'),
(5,'baseline','template'),
(5,'baseline','view'),
(5,'budget','batchCreate'),
(5,'budget','browse'),
(5,'budget','create'),
(5,'budget','edit'),
(5,'budget','summary'),
(5,'budget','view'),
(5,'classify','browse'),
(5,'cm','browse'),
(5,'cm','create'),
(5,'cm','edit'),
(5,'cm','report'),
(5,'cm','view'),
(5,'cmcl','browse'),
(5,'cmcl','delete'),
(5,'cmcl','edit'),
(5,'cmcl','view'),
(5,'design','browse'),
(5,'design','create'),
(5,'design','delete'),
(5,'design','edit'),
(5,'design','view'),
(5,'durationestimation','create'),
(5,'durationestimation','index'),
(5,'issue','activate'),
(5,'issue','batchCreate'),
(5,'issue','browse'),
(5,'issue','cancel'),
(5,'issue','close'),
(5,'issue','create'),
(5,'issue','delete'),
(5,'issue','edit'),
(5,'issue','resolve'),
(5,'issue','view'),
(5,'measrecord','browse'),
(5,'measurement','batchEdit'),
(5,'measurement','browse'),
(5,'measurement','createBasic'),
(5,'measurement','createTemplate'),
(5,'measurement','delete'),
(5,'measurement','design'),
(5,'measurement','designPHP'),
(5,'measurement','designSQL'),
(5,'measurement','editBasic'),
(5,'measurement','editDerivation'),
(5,'measurement','editTemplate'),
(5,'measurement','execCrontabQueue'),
(5,'measurement','initCrontabQueue'),
(5,'measurement','searchMeas'),
(5,'measurement','template'),
(5,'measurement','viewTemplate'),
(5,'meeting','browse'),
(5,'meeting','create'),
(5,'meeting','delete'),
(5,'meeting','edit'),
(5,'meeting','minutes'),
(5,'meeting','view'),
(5,'meetingroom','batchCreate'),
(5,'meetingroom','batchEdit'),
(5,'meetingroom','browse'),
(5,'meetingroom','create'),
(5,'meetingroom','delete'),
(5,'meetingroom','edit'),
(5,'meetingroom','view'),
(5,'milestone','index'),
(5,'milestone','saveOtherProblem'),
(5,'my','issue'),
(5,'my','meeting'),
(5,'my','myMeeting'),
(5,'my','nc'),
(5,'my','risk'),
(5,'nc','16'),
(5,'nc','activate'),
(5,'nc','assign'),
(5,'nc','batchassign'),
(5,'nc','batchcreate'),
(5,'nc','batchedit'),
(5,'nc','browse'),
(5,'nc','close'),
(5,'nc','create'),
(5,'nc','delete'),
(5,'nc','edit'),
(5,'nc','export'),
(5,'nc','exporttemplate'),
(5,'nc','import'),
(5,'nc','link'),
(5,'nc','resolve'),
(5,'nc','search'),
(5,'nc','showimport'),
(5,'nc','unlink'),
(5,'nc','view'),
(5,'opportunity','activate'),
(5,'opportunity','assignTo'),
(5,'opportunity','batchActivate'),
(5,'opportunity','batchAssignTo'),
(5,'opportunity','batchCancel'),
(5,'opportunity','batchClose'),
(5,'opportunity','batchCreate'),
(5,'opportunity','batchEdit'),
(5,'opportunity','batchHangup'),
(5,'opportunity','batchImportToLib'),
(5,'opportunity','browse'),
(5,'opportunity','cancel'),
(5,'opportunity','close'),
(5,'opportunity','create'),
(5,'opportunity','delete'),
(5,'opportunity','edit'),
(5,'opportunity','hangup'),
(5,'opportunity','importFromLib'),
(5,'opportunity','importToLib'),
(5,'opportunity','track'),
(5,'opportunity','view'),
(5,'output','13'),
(5,'output','assign'),
(5,'output','batchassign'),
(5,'output','batchcreate'),
(5,'output','batchedit'),
(5,'output','browse'),
(5,'output','create'),
(5,'output','delete'),
(5,'output','edit'),
(5,'output','export'),
(5,'output','exporttemplate'),
(5,'output','import'),
(5,'output','link'),
(5,'output','search'),
(5,'output','showimport'),
(5,'output','unlink'),
(5,'output','view'),
(5,'process','browse'),
(5,'process','create'),
(5,'process','delete'),
(5,'process','edit'),
(5,'process','view'),
(5,'programplan','browse'),
(5,'programplan','create'),
(5,'programplan','edit'),
(5,'projectstory','importFromLib'),
(5,'pssp','browse'),
(5,'pssp','update'),
(5,'report','customeRedreport'),
(5,'researchplan','browse'),
(5,'researchplan','create'),
(5,'researchplan','delete'),
(5,'researchplan','edit'),
(5,'researchplan','view'),
(5,'researchreport','browse'),
(5,'researchreport','create'),
(5,'researchreport','delete'),
(5,'researchreport','edit'),
(5,'researchreport','view'),
(5,'review','assess'),
(5,'review','audit'),
(5,'review','browse'),
(5,'review','create'),
(5,'review','edit'),
(5,'review','recall'),
(5,'review','report'),
(5,'review','result'),
(5,'review','submit'),
(5,'review','toAudit'),
(5,'review','view'),
(5,'reviewcl','browse'),
(5,'reviewcl','create'),
(5,'reviewcl','delete'),
(5,'reviewcl','edit'),
(5,'reviewcl','view'),
(5,'reviewissue','create'),
(5,'reviewissue','edit'),
(5,'reviewissue','issue'),
(5,'reviewissue','resolved'),
(5,'reviewissue','updateStatus'),
(5,'reviewissue','view'),
(5,'reviewsetting','reviewer'),
(5,'reviewsetting','version'),
(5,'risk','activate'),
(5,'risk','assignTo'),
(5,'risk','batchCreate'),
(5,'risk','batchImportToLib'),
(5,'risk','browse'),
(5,'risk','cancel'),
(5,'risk','close'),
(5,'risk','create'),
(5,'risk','delete'),
(5,'risk','edit'),
(5,'risk','hangup'),
(5,'risk','importFromLib'),
(5,'risk','importToLib'),
(5,'risk','track'),
(5,'risk','view'),
(5,'stage','batchCreate'),
(5,'stage','browse'),
(5,'stage','create'),
(5,'stage','delete'),
(5,'stage','edit'),
(5,'stage','setType'),
(5,'story','batchImportToLib'),
(5,'story','importToLib'),
(5,'subject','browse'),
(5,'task','confirmdesignchange'),
(5,'weekly','index'),
(5,'workestimation','index'),
(5,'workloadbudget','27'),
(5,'workloadbudget','assign'),
(5,'workloadbudget','batchassign'),
(5,'workloadbudget','batchcreate'),
(5,'workloadbudget','batchedit'),
(5,'workloadbudget','browse'),
(5,'workloadbudget','create'),
(5,'workloadbudget','delete'),
(5,'workloadbudget','edit'),
(5,'workloadbudget','export'),
(5,'workloadbudget','exporttemplate'),
(5,'workloadbudget','import'),
(5,'workloadbudget','link'),
(5,'workloadbudget','search'),
(5,'workloadbudget','showimport'),
(5,'workloadbudget','unlink'),
(5,'workloadbudget','view'),
(5,'zoutput','batchCreate'),
(5,'zoutput','batchEdit'),
(5,'zoutput','browse'),
(5,'zoutput','create'),
(5,'zoutput','delete'),
(5,'zoutput','edit'),
(5,'zoutput','updateOrder'),
(5,'zoutput','view'),
(6,'activity','browse'),
(6,'activity','create'),
(6,'activity','delete'),
(6,'activity','edit'),
(6,'activity','view'),
(6,'audit','8'),
(6,'audit','assign'),
(6,'audit','batchassign'),
(6,'audit','batchcreate'),
(6,'audit','batchedit'),
(6,'audit','browse'),
(6,'audit','create'),
(6,'audit','delete'),
(6,'audit','edit'),
(6,'audit','export'),
(6,'audit','exporttemplate'),
(6,'audit','import'),
(6,'audit','link'),
(6,'audit','search'),
(6,'audit','showimport'),
(6,'audit','unlink'),
(6,'audit','view'),
(6,'auditcl','browse'),
(6,'auditcl','delete'),
(6,'auditcl','edit'),
(6,'auditplan','browse'),
(6,'auditplan','create'),
(6,'auditplan','edit'),
(6,'auditplan','nc'),
(6,'auditplan','result'),
(6,'auditresult','10'),
(6,'auditresult','assign'),
(6,'auditresult','batchassign'),
(6,'auditresult','batchcreate'),
(6,'auditresult','batchedit'),
(6,'auditresult','browse'),
(6,'auditresult','create'),
(6,'auditresult','delete'),
(6,'auditresult','edit'),
(6,'auditresult','export'),
(6,'auditresult','exporttemplate'),
(6,'auditresult','import'),
(6,'auditresult','link'),
(6,'auditresult','search'),
(6,'auditresult','showimport'),
(6,'auditresult','unlink'),
(6,'auditresult','view'),
(6,'baseline','articleview'),
(6,'baseline','catalog'),
(6,'baseline','createTemplate'),
(6,'baseline','editBook'),
(6,'baseline','editTemplate'),
(6,'baseline','manageBook'),
(6,'baseline','template'),
(6,'baseline','view'),
(6,'budget','batchCreate'),
(6,'budget','browse'),
(6,'budget','create'),
(6,'budget','edit'),
(6,'budget','summary'),
(6,'budget','view'),
(6,'classify','browse'),
(6,'cm','browse'),
(6,'cm','create'),
(6,'cm','edit'),
(6,'cm','report'),
(6,'cm','view'),
(6,'cmcl','browse'),
(6,'cmcl','delete'),
(6,'cmcl','edit'),
(6,'cmcl','view'),
(6,'custom','estimate'),
(6,'design','browse'),
(6,'design','create'),
(6,'design','delete'),
(6,'design','edit'),
(6,'design','view'),
(6,'durationestimation','create'),
(6,'durationestimation','index'),
(6,'gapanalysis','batchCreate'),
(6,'gapanalysis','batchEdit'),
(6,'gapanalysis','browse'),
(6,'gapanalysis','create'),
(6,'gapanalysis','delete'),
(6,'gapanalysis','edit'),
(6,'gapanalysis','view'),
(6,'issue','activate'),
(6,'issue','assignTo'),
(6,'issue','batchCreate'),
(6,'issue','browse'),
(6,'issue','cancel'),
(6,'issue','close'),
(6,'issue','confirm'),
(6,'issue','create'),
(6,'issue','delete'),
(6,'issue','edit'),
(6,'issue','importFromLib'),
(6,'issue','resolve'),
(6,'issue','view'),
(6,'meeting','browse'),
(6,'meeting','create'),
(6,'meeting','delete'),
(6,'meeting','edit'),
(6,'meeting','minutes'),
(6,'meeting','view'),
(6,'meetingroom','batchCreate'),
(6,'meetingroom','batchEdit'),
(6,'meetingroom','browse'),
(6,'meetingroom','create'),
(6,'meetingroom','delete'),
(6,'meetingroom','edit'),
(6,'meetingroom','view'),
(6,'milestone','index'),
(6,'milestone','saveOtherProblem'),
(6,'my','issue'),
(6,'my','meeting'),
(6,'my','myMeeting'),
(6,'my','nc'),
(6,'my','risk'),
(6,'nc','16'),
(6,'nc','activate'),
(6,'nc','assign'),
(6,'nc','batchassign'),
(6,'nc','batchcreate'),
(6,'nc','batchedit'),
(6,'nc','browse'),
(6,'nc','close'),
(6,'nc','create'),
(6,'nc','delete'),
(6,'nc','edit'),
(6,'nc','export'),
(6,'nc','exporttemplate'),
(6,'nc','import'),
(6,'nc','link'),
(6,'nc','resolve'),
(6,'nc','search'),
(6,'nc','showimport'),
(6,'nc','unlink'),
(6,'nc','view'),
(6,'opportunity','activate'),
(6,'opportunity','assignTo'),
(6,'opportunity','batchActivate'),
(6,'opportunity','batchAssignTo'),
(6,'opportunity','batchCancel'),
(6,'opportunity','batchClose'),
(6,'opportunity','batchCreate'),
(6,'opportunity','batchEdit'),
(6,'opportunity','batchHangup'),
(6,'opportunity','batchImportToLib'),
(6,'opportunity','browse'),
(6,'opportunity','cancel'),
(6,'opportunity','close'),
(6,'opportunity','create'),
(6,'opportunity','delete'),
(6,'opportunity','edit'),
(6,'opportunity','hangup'),
(6,'opportunity','importFromLib'),
(6,'opportunity','importToLib'),
(6,'opportunity','track'),
(6,'opportunity','view'),
(6,'output','13'),
(6,'output','assign'),
(6,'output','batchassign'),
(6,'output','batchcreate'),
(6,'output','batchedit'),
(6,'output','browse'),
(6,'output','create'),
(6,'output','delete'),
(6,'output','edit'),
(6,'output','export'),
(6,'output','exporttemplate'),
(6,'output','import'),
(6,'output','link'),
(6,'output','search'),
(6,'output','showimport'),
(6,'output','unlink'),
(6,'output','view'),
(6,'process','browse'),
(6,'process','create'),
(6,'process','delete'),
(6,'process','edit'),
(6,'process','view'),
(6,'programplan','browse'),
(6,'programplan','create'),
(6,'programplan','edit'),
(6,'pssp','browse'),
(6,'pssp','update'),
(6,'report','customeRedreport'),
(6,'review','assess'),
(6,'review','audit'),
(6,'review','browse'),
(6,'review','create'),
(6,'review','edit'),
(6,'review','recall'),
(6,'review','report'),
(6,'review','result'),
(6,'review','submit'),
(6,'review','toAudit'),
(6,'review','view'),
(6,'reviewcl','browse'),
(6,'reviewcl','create'),
(6,'reviewcl','delete'),
(6,'reviewcl','edit'),
(6,'reviewcl','view'),
(6,'reviewissue','create'),
(6,'reviewissue','edit'),
(6,'reviewissue','issue'),
(6,'reviewissue','resolved'),
(6,'reviewissue','updateStatus'),
(6,'reviewissue','view'),
(6,'reviewsetting','reviewer'),
(6,'reviewsetting','version'),
(6,'risk','activate'),
(6,'risk','assignTo'),
(6,'risk','batchCreate'),
(6,'risk','browse'),
(6,'risk','cancel'),
(6,'risk','close'),
(6,'risk','create'),
(6,'risk','delete'),
(6,'risk','edit'),
(6,'risk','hangup'),
(6,'risk','importFromLib'),
(6,'risk','view'),
(6,'stage','batchCreate'),
(6,'stage','browse'),
(6,'stage','create'),
(6,'stage','delete'),
(6,'stage','edit'),
(6,'subject','browse'),
(6,'trainplan','batchCreate'),
(6,'trainplan','batchEdit'),
(6,'trainplan','batchFinish'),
(6,'trainplan','browse'),
(6,'trainplan','create'),
(6,'trainplan','delete'),
(6,'trainplan','edit'),
(6,'trainplan','finish'),
(6,'trainplan','summary'),
(6,'trainplan','view'),
(6,'weekly','index'),
(6,'workestimation','index'),
(6,'workloadbudget','27'),
(6,'workloadbudget','assign'),
(6,'workloadbudget','batchassign'),
(6,'workloadbudget','batchcreate'),
(6,'workloadbudget','batchedit'),
(6,'workloadbudget','browse'),
(6,'workloadbudget','create'),
(6,'workloadbudget','delete'),
(6,'workloadbudget','edit'),
(6,'workloadbudget','export'),
(6,'workloadbudget','exporttemplate'),
(6,'workloadbudget','import'),
(6,'workloadbudget','link'),
(6,'workloadbudget','search'),
(6,'workloadbudget','showimport'),
(6,'workloadbudget','unlink'),
(6,'workloadbudget','view'),
(6,'zoutput','batchCreate'),
(6,'zoutput','batchEdit'),
(6,'zoutput','browse'),
(6,'zoutput','create'),
(6,'zoutput','delete'),
(6,'zoutput','edit'),
(6,'zoutput','updateOrder'),
(6,'zoutput','view'),
(7,'activity','browse'),
(7,'activity','create'),
(7,'activity','delete'),
(7,'activity','edit'),
(7,'activity','view'),
(7,'audit','8'),
(7,'audit','assign'),
(7,'audit','batchassign'),
(7,'audit','batchcreate'),
(7,'audit','batchedit'),
(7,'audit','browse'),
(7,'audit','create'),
(7,'audit','delete'),
(7,'audit','edit'),
(7,'audit','export'),
(7,'audit','exporttemplate'),
(7,'audit','import'),
(7,'audit','link'),
(7,'audit','search'),
(7,'audit','showimport'),
(7,'audit','unlink'),
(7,'audit','view'),
(7,'auditcl','browse'),
(7,'auditcl','delete'),
(7,'auditcl','edit'),
(7,'auditplan','browse'),
(7,'auditplan','create'),
(7,'auditplan','edit'),
(7,'auditplan','nc'),
(7,'auditplan','result'),
(7,'auditresult','10'),
(7,'auditresult','assign'),
(7,'auditresult','batchassign'),
(7,'auditresult','batchcreate'),
(7,'auditresult','batchedit'),
(7,'auditresult','browse'),
(7,'auditresult','create'),
(7,'auditresult','delete'),
(7,'auditresult','edit'),
(7,'auditresult','export'),
(7,'auditresult','exporttemplate'),
(7,'auditresult','import'),
(7,'auditresult','link'),
(7,'auditresult','search'),
(7,'auditresult','showimport'),
(7,'auditresult','unlink'),
(7,'auditresult','view'),
(7,'baseline','articleview'),
(7,'baseline','catalog'),
(7,'baseline','createTemplate'),
(7,'baseline','editBook'),
(7,'baseline','editTemplate'),
(7,'baseline','manageBook'),
(7,'baseline','template'),
(7,'baseline','view'),
(7,'budget','batchCreate'),
(7,'budget','browse'),
(7,'budget','create'),
(7,'budget','delete'),
(7,'budget','edit'),
(7,'budget','summary'),
(7,'budget','view'),
(7,'classify','browse'),
(7,'cm','browse'),
(7,'cm','create'),
(7,'cm','edit'),
(7,'cm','report'),
(7,'cm','view'),
(7,'cmcl','browse'),
(7,'cmcl','delete'),
(7,'cmcl','edit'),
(7,'cmcl','view'),
(7,'custom','estimate'),
(7,'design','browse'),
(7,'design','create'),
(7,'design','delete'),
(7,'design','edit'),
(7,'design','view'),
(7,'durationestimation','create'),
(7,'durationestimation','index'),
(7,'gapanalysis','batchCreate'),
(7,'gapanalysis','batchEdit'),
(7,'gapanalysis','browse'),
(7,'gapanalysis','create'),
(7,'gapanalysis','delete'),
(7,'gapanalysis','edit'),
(7,'gapanalysis','view'),
(7,'issue','activate'),
(7,'issue','assignTo'),
(7,'issue','batchCreate'),
(7,'issue','browse'),
(7,'issue','cancel'),
(7,'issue','close'),
(7,'issue','confirm'),
(7,'issue','create'),
(7,'issue','delete'),
(7,'issue','edit'),
(7,'issue','importFromLib'),
(7,'issue','resolve'),
(7,'issue','view'),
(7,'measrecord','browse'),
(7,'measurement','batchEdit'),
(7,'measurement','browse'),
(7,'measurement','createBasic'),
(7,'measurement','createTemplate'),
(7,'measurement','delete'),
(7,'measurement','design'),
(7,'measurement','designPHP'),
(7,'measurement','designSQL'),
(7,'measurement','editBasic'),
(7,'measurement','editDerivation'),
(7,'measurement','editTemplate'),
(7,'measurement','execCrontabQueue'),
(7,'measurement','initCrontabQueue'),
(7,'measurement','searchMeas'),
(7,'measurement','template'),
(7,'measurement','viewTemplate'),
(7,'meeting','browse'),
(7,'meeting','create'),
(7,'meeting','delete'),
(7,'meeting','edit'),
(7,'meeting','minutes'),
(7,'meeting','view'),
(7,'meetingroom','batchCreate'),
(7,'meetingroom','batchEdit'),
(7,'meetingroom','browse'),
(7,'meetingroom','create'),
(7,'meetingroom','delete'),
(7,'meetingroom','edit'),
(7,'meetingroom','view'),
(7,'milestone','index'),
(7,'my','issue'),
(7,'my','meeting'),
(7,'my','myMeeting'),
(7,'my','nc'),
(7,'my','risk'),
(7,'nc','16'),
(7,'nc','activate'),
(7,'nc','assign'),
(7,'nc','batchassign'),
(7,'nc','batchcreate'),
(7,'nc','batchedit'),
(7,'nc','browse'),
(7,'nc','close'),
(7,'nc','create'),
(7,'nc','delete'),
(7,'nc','edit'),
(7,'nc','export'),
(7,'nc','exporttemplate'),
(7,'nc','import'),
(7,'nc','link'),
(7,'nc','resolve'),
(7,'nc','search'),
(7,'nc','showimport'),
(7,'nc','unlink'),
(7,'nc','view'),
(7,'opportunity','activate'),
(7,'opportunity','assignTo'),
(7,'opportunity','batchActivate'),
(7,'opportunity','batchAssignTo'),
(7,'opportunity','batchCancel'),
(7,'opportunity','batchClose'),
(7,'opportunity','batchCreate'),
(7,'opportunity','batchEdit'),
(7,'opportunity','batchHangup'),
(7,'opportunity','batchImportToLib'),
(7,'opportunity','browse'),
(7,'opportunity','cancel'),
(7,'opportunity','close'),
(7,'opportunity','create'),
(7,'opportunity','delete'),
(7,'opportunity','edit'),
(7,'opportunity','hangup'),
(7,'opportunity','importFromLib'),
(7,'opportunity','importToLib'),
(7,'opportunity','track'),
(7,'opportunity','view'),
(7,'output','13'),
(7,'output','assign'),
(7,'output','batchassign'),
(7,'output','batchcreate'),
(7,'output','batchedit'),
(7,'output','browse'),
(7,'output','create'),
(7,'output','delete'),
(7,'output','edit'),
(7,'output','export'),
(7,'output','exporttemplate'),
(7,'output','import'),
(7,'output','link'),
(7,'output','search'),
(7,'output','showimport'),
(7,'output','unlink'),
(7,'output','view'),
(7,'process','browse'),
(7,'process','create'),
(7,'process','delete'),
(7,'process','edit'),
(7,'process','view'),
(7,'programplan','browse'),
(7,'programplan','create'),
(7,'programplan','edit'),
(7,'pssp','browse'),
(7,'pssp','update'),
(7,'report','customeRedreport'),
(7,'review','assess'),
(7,'review','audit'),
(7,'review','browse'),
(7,'review','create'),
(7,'review','edit'),
(7,'review','recall'),
(7,'review','report'),
(7,'review','result'),
(7,'review','submit'),
(7,'review','toAudit'),
(7,'review','view'),
(7,'reviewcl','browse'),
(7,'reviewcl','create'),
(7,'reviewcl','delete'),
(7,'reviewcl','edit'),
(7,'reviewcl','view'),
(7,'reviewissue','create'),
(7,'reviewissue','edit'),
(7,'reviewissue','issue'),
(7,'reviewissue','resolved'),
(7,'reviewissue','updateStatus'),
(7,'reviewissue','view'),
(7,'reviewsetting','reviewer'),
(7,'reviewsetting','version'),
(7,'risk','activate'),
(7,'risk','assignTo'),
(7,'risk','batchCreate'),
(7,'risk','browse'),
(7,'risk','cancel'),
(7,'risk','close'),
(7,'risk','create'),
(7,'risk','delete'),
(7,'risk','edit'),
(7,'risk','hangup'),
(7,'risk','importFromLib'),
(7,'risk','view'),
(7,'stage','batchCreate'),
(7,'stage','browse'),
(7,'stage','create'),
(7,'stage','delete'),
(7,'stage','edit'),
(7,'story','batchImportToLib'),
(7,'story','importToLib'),
(7,'subject','browse'),
(7,'trainplan','batchCreate'),
(7,'trainplan','batchEdit'),
(7,'trainplan','batchFinish'),
(7,'trainplan','browse'),
(7,'trainplan','create'),
(7,'trainplan','delete'),
(7,'trainplan','edit'),
(7,'trainplan','finish'),
(7,'trainplan','summary'),
(7,'trainplan','view'),
(7,'weekly','index'),
(7,'workestimation','index'),
(7,'workloadbudget','27'),
(7,'workloadbudget','assign'),
(7,'workloadbudget','batchassign'),
(7,'workloadbudget','batchcreate'),
(7,'workloadbudget','batchedit'),
(7,'workloadbudget','browse'),
(7,'workloadbudget','create'),
(7,'workloadbudget','delete'),
(7,'workloadbudget','edit'),
(7,'workloadbudget','export'),
(7,'workloadbudget','exporttemplate'),
(7,'workloadbudget','import'),
(7,'workloadbudget','link'),
(7,'workloadbudget','search'),
(7,'workloadbudget','showimport'),
(7,'workloadbudget','unlink'),
(7,'workloadbudget','view'),
(8,'activity','browse'),
(8,'activity','create'),
(8,'activity','delete'),
(8,'activity','edit'),
(8,'activity','view'),
(8,'audit','8'),
(8,'audit','assign'),
(8,'audit','batchassign'),
(8,'audit','batchcreate'),
(8,'audit','batchedit'),
(8,'audit','browse'),
(8,'audit','create'),
(8,'audit','delete'),
(8,'audit','edit'),
(8,'audit','export'),
(8,'audit','exporttemplate'),
(8,'audit','import'),
(8,'audit','link'),
(8,'audit','search'),
(8,'audit','showimport'),
(8,'audit','unlink'),
(8,'audit','view'),
(8,'auditcl','browse'),
(8,'auditcl','delete'),
(8,'auditcl','edit'),
(8,'auditplan','batchCreate'),
(8,'auditplan','browse'),
(8,'auditplan','create'),
(8,'auditplan','edit'),
(8,'auditplan','nc'),
(8,'auditplan','result'),
(8,'auditresult','10'),
(8,'auditresult','assign'),
(8,'auditresult','batchassign'),
(8,'auditresult','batchcreate'),
(8,'auditresult','batchedit'),
(8,'auditresult','browse'),
(8,'auditresult','create'),
(8,'auditresult','delete'),
(8,'auditresult','edit'),
(8,'auditresult','export'),
(8,'auditresult','exporttemplate'),
(8,'auditresult','import'),
(8,'auditresult','link'),
(8,'auditresult','search'),
(8,'auditresult','showimport'),
(8,'auditresult','unlink'),
(8,'auditresult','view'),
(8,'baseline','articleview'),
(8,'baseline','catalog'),
(8,'baseline','createTemplate'),
(8,'baseline','editBook'),
(8,'baseline','editTemplate'),
(8,'baseline','manageBook'),
(8,'baseline','template'),
(8,'baseline','view'),
(8,'budget','batchCreate'),
(8,'budget','browse'),
(8,'budget','create'),
(8,'budget','edit'),
(8,'budget','summary'),
(8,'budget','view'),
(8,'classify','browse'),
(8,'cm','browse'),
(8,'cm','create'),
(8,'cm','edit'),
(8,'cm','report'),
(8,'cm','view'),
(8,'cmcl','browse'),
(8,'cmcl','delete'),
(8,'cmcl','edit'),
(8,'cmcl','view'),
(8,'custom','estimate'),
(8,'design','browse'),
(8,'design','create'),
(8,'design','delete'),
(8,'design','edit'),
(8,'design','view'),
(8,'durationestimation','create'),
(8,'durationestimation','index'),
(8,'gapanalysis','batchCreate'),
(8,'gapanalysis','batchEdit'),
(8,'gapanalysis','browse'),
(8,'gapanalysis','create'),
(8,'gapanalysis','delete'),
(8,'gapanalysis','edit'),
(8,'gapanalysis','view'),
(8,'issue','activate'),
(8,'issue','assignTo'),
(8,'issue','batchCreate'),
(8,'issue','browse'),
(8,'issue','cancel'),
(8,'issue','close'),
(8,'issue','confirm'),
(8,'issue','create'),
(8,'issue','delete'),
(8,'issue','edit'),
(8,'issue','importFromLib'),
(8,'issue','resolve'),
(8,'issue','view'),
(8,'meeting','browse'),
(8,'meeting','create'),
(8,'meeting','delete'),
(8,'meeting','edit'),
(8,'meeting','minutes'),
(8,'meeting','view'),
(8,'meetingroom','batchCreate'),
(8,'meetingroom','batchEdit'),
(8,'meetingroom','browse'),
(8,'meetingroom','create'),
(8,'meetingroom','delete'),
(8,'meetingroom','edit'),
(8,'meetingroom','view'),
(8,'milestone','index'),
(8,'milestone','saveOtherProblem'),
(8,'my','issue'),
(8,'my','meeting'),
(8,'my','myMeeting'),
(8,'my','nc'),
(8,'my','risk'),
(8,'nc','16'),
(8,'nc','activate'),
(8,'nc','assign'),
(8,'nc','batchassign'),
(8,'nc','batchcreate'),
(8,'nc','batchedit'),
(8,'nc','browse'),
(8,'nc','close'),
(8,'nc','create'),
(8,'nc','delete'),
(8,'nc','edit'),
(8,'nc','export'),
(8,'nc','exporttemplate'),
(8,'nc','import'),
(8,'nc','link'),
(8,'nc','resolve'),
(8,'nc','search'),
(8,'nc','showimport'),
(8,'nc','unlink'),
(8,'nc','view'),
(8,'opportunity','activate'),
(8,'opportunity','assignTo'),
(8,'opportunity','batchActivate'),
(8,'opportunity','batchAssignTo'),
(8,'opportunity','batchCancel'),
(8,'opportunity','batchClose'),
(8,'opportunity','batchCreate'),
(8,'opportunity','batchEdit'),
(8,'opportunity','batchHangup'),
(8,'opportunity','batchImportToLib'),
(8,'opportunity','browse'),
(8,'opportunity','cancel'),
(8,'opportunity','close'),
(8,'opportunity','create'),
(8,'opportunity','delete'),
(8,'opportunity','edit'),
(8,'opportunity','hangup'),
(8,'opportunity','importFromLib'),
(8,'opportunity','importToLib'),
(8,'opportunity','track'),
(8,'opportunity','view'),
(8,'output','13'),
(8,'output','assign'),
(8,'output','batchassign'),
(8,'output','batchcreate'),
(8,'output','batchedit'),
(8,'output','browse'),
(8,'output','create'),
(8,'output','delete'),
(8,'output','edit'),
(8,'output','export'),
(8,'output','exporttemplate'),
(8,'output','import'),
(8,'output','link'),
(8,'output','search'),
(8,'output','showimport'),
(8,'output','unlink'),
(8,'output','view'),
(8,'process','browse'),
(8,'process','create'),
(8,'process','delete'),
(8,'process','edit'),
(8,'process','view'),
(8,'pssp','browse'),
(8,'pssp','update'),
(8,'report','customeRedreport'),
(8,'review','assess'),
(8,'review','audit'),
(8,'review','browse'),
(8,'review','create'),
(8,'review','edit'),
(8,'review','recall'),
(8,'review','report'),
(8,'review','result'),
(8,'review','submit'),
(8,'review','toAudit'),
(8,'review','view'),
(8,'reviewcl','browse'),
(8,'reviewcl','create'),
(8,'reviewcl','delete'),
(8,'reviewcl','edit'),
(8,'reviewcl','view'),
(8,'reviewissue','create'),
(8,'reviewissue','edit'),
(8,'reviewissue','issue'),
(8,'reviewissue','resolved'),
(8,'reviewissue','updateStatus'),
(8,'reviewissue','view'),
(8,'reviewsetting','reviewer'),
(8,'reviewsetting','version'),
(8,'risk','activate'),
(8,'risk','assignTo'),
(8,'risk','batchCreate'),
(8,'risk','browse'),
(8,'risk','cancel'),
(8,'risk','close'),
(8,'risk','create'),
(8,'risk','delete'),
(8,'risk','edit'),
(8,'risk','hangup'),
(8,'risk','importFromLib'),
(8,'risk','track'),
(8,'risk','view'),
(8,'stage','batchCreate'),
(8,'stage','browse'),
(8,'stage','create'),
(8,'stage','delete'),
(8,'stage','edit'),
(8,'subject','browse'),
(8,'testcase','submit'),
(8,'testsuite','test'),
(8,'trainbook','ajaxgetbookbysn'),
(8,'trainbook','batchChangeModule'),
(8,'trainbook','batchEdit'),
(8,'trainbook','borrow'),
(8,'trainbook','borrowrecords'),
(8,'trainbook','browse'),
(8,'trainbook','create'),
(8,'trainbook','delete'),
(8,'trainbook','edit'),
(8,'trainbook','export'),
(8,'trainbook','manage'),
(8,'trainbook','myborrow'),
(8,'trainbook','returnbook'),
(8,'trainbook','view'),
(8,'traincareer','index'),
(8,'trainchapter','browse'),
(8,'trainchapter','catalog'),
(8,'trainchapter','delete'),
(8,'trainchapter','download'),
(8,'trainchapter','edit'),
(8,'trainchapter','manage'),
(8,'trainchapter','showDocFiles'),
(8,'trainchapter','sortChapterOrder'),
(8,'trainchapter','view'),
(8,'traincourse','browse'),
(8,'traincourse','changeStatus'),
(8,'traincourse','collect'),
(8,'traincourse','create'),
(8,'traincourse','delete'),
(8,'traincourse','edit'),
(8,'traincourse','manage'),
(8,'traincourse','view'),
(8,'trainexam','browse'),
(8,'trainexam','changeStatus'),
(8,'trainexam','choseExam'),
(8,'trainexam','create'),
(8,'trainexam','delete'),
(8,'trainexam','deleteQuestion'),
(8,'trainexam','edit'),
(8,'trainexam','editQuestion'),
(8,'trainexam','exam'),
(8,'trainexam','myExams'),
(8,'trainexam','review'),
(8,'trainexam','scoreDetail'),
(8,'trainexam','setQuestion'),
(8,'trainexam','updateOrder'),
(8,'trainexam','view'),
(8,'traingoal','browse'),
(8,'traingoal','browseCompanyGoals'),
(8,'traingoal','browseDeptGoals'),
(8,'traingoal','create'),
(8,'traingoal','delete'),
(8,'traingoal','edit'),
(8,'traingoal','recall'),
(8,'traingoal','review'),
(8,'traingoal','submitReview'),
(8,'traingoal','updateOrder'),
(8,'traingoal','view'),
(8,'trainplan','batchCreate'),
(8,'trainplan','batchEdit'),
(8,'trainplan','batchFinish'),
(8,'trainplan','browse'),
(8,'trainplan','create'),
(8,'trainplan','delete'),
(8,'trainplan','edit'),
(8,'trainplan','finish'),
(8,'trainplan','summary'),
(8,'trainplan','view'),
(8,'trainpost','browse'),
(8,'trainpost','create'),
(8,'trainpost','createGrade'),
(8,'trainpost','delete'),
(8,'trainpost','edit'),
(8,'trainpost','editGrade'),
(8,'trainpost','manageGrade'),
(8,'trainpost','sortGrade'),
(8,'trainpost','sortPost'),
(8,'trainskill','browse'),
(8,'trainskill','create'),
(8,'trainskill','createGrade'),
(8,'trainskill','delete'),
(8,'trainskill','deleteDesc'),
(8,'trainskill','deleteGrade'),
(8,'trainskill','edit'),
(8,'trainskill','editGrade'),
(8,'trainskill','view'),
(8,'traintask','browse'),
(8,'traintask','browseCompanyTasks'),
(8,'traintask','browseDeptTasks'),
(8,'traintask','close'),
(8,'traintask','create'),
(8,'traintask','createTask'),
(8,'traintask','delete'),
(8,'traintask','edit'),
(8,'traintask','finish'),
(8,'traintask','import'),
(8,'traintask','setCondition'),
(8,'traintask','start'),
(8,'traintask','view'),
(8,'weekly','index'),
(8,'workestimation','index'),
(8,'workloadbudget','27'),
(8,'workloadbudget','assign'),
(8,'workloadbudget','batchassign'),
(8,'workloadbudget','batchcreate'),
(8,'workloadbudget','batchedit'),
(8,'workloadbudget','browse'),
(8,'workloadbudget','create'),
(8,'workloadbudget','delete'),
(8,'workloadbudget','edit'),
(8,'workloadbudget','export'),
(8,'workloadbudget','exporttemplate'),
(8,'workloadbudget','import'),
(8,'workloadbudget','link'),
(8,'workloadbudget','search'),
(8,'workloadbudget','showimport'),
(8,'workloadbudget','unlink'),
(8,'workloadbudget','view'),
(9,'activity','browse'),
(9,'activity','create'),
(9,'activity','delete'),
(9,'activity','edit'),
(9,'activity','view'),
(9,'audit','8'),
(9,'audit','assign'),
(9,'audit','batchassign'),
(9,'audit','batchcreate'),
(9,'audit','batchedit'),
(9,'audit','browse'),
(9,'audit','create'),
(9,'audit','delete'),
(9,'audit','edit'),
(9,'audit','export'),
(9,'audit','exporttemplate'),
(9,'audit','import'),
(9,'audit','link'),
(9,'audit','search'),
(9,'audit','showimport'),
(9,'audit','unlink'),
(9,'audit','view'),
(9,'auditcl','browse'),
(9,'auditcl','delete'),
(9,'auditcl','edit'),
(9,'auditplan','browse'),
(9,'auditplan','create'),
(9,'auditplan','edit'),
(9,'auditplan','nc'),
(9,'auditplan','result'),
(9,'auditresult','10'),
(9,'auditresult','assign'),
(9,'auditresult','batchassign'),
(9,'auditresult','batchcreate'),
(9,'auditresult','batchedit'),
(9,'auditresult','browse'),
(9,'auditresult','create'),
(9,'auditresult','delete'),
(9,'auditresult','edit'),
(9,'auditresult','export'),
(9,'auditresult','exporttemplate'),
(9,'auditresult','import'),
(9,'auditresult','link'),
(9,'auditresult','search'),
(9,'auditresult','showimport'),
(9,'auditresult','unlink'),
(9,'auditresult','view'),
(9,'baseline','articleview'),
(9,'baseline','catalog'),
(9,'baseline','createTemplate'),
(9,'baseline','delete'),
(9,'baseline','editBook'),
(9,'baseline','editTemplate'),
(9,'baseline','manageBook'),
(9,'baseline','template'),
(9,'baseline','view'),
(9,'budget','batchCreate'),
(9,'budget','browse'),
(9,'budget','create'),
(9,'budget','delete'),
(9,'budget','edit'),
(9,'budget','summary'),
(9,'budget','view'),
(9,'classify','browse'),
(9,'cm','browse'),
(9,'cm','create'),
(9,'cm','delete'),
(9,'cm','edit'),
(9,'cm','report'),
(9,'cm','view'),
(9,'cmcl','browse'),
(9,'cmcl','delete'),
(9,'cmcl','edit'),
(9,'cmcl','view'),
(9,'custom','estimate'),
(9,'design','assignTo'),
(9,'design','batchCreate'),
(9,'design','browse'),
(9,'design','create'),
(9,'design','delete'),
(9,'design','edit'),
(9,'design','view'),
(9,'durationestimation','create'),
(9,'durationestimation','index'),
(9,'issue','activate'),
(9,'issue','assignTo'),
(9,'issue','batchCreate'),
(9,'issue','browse'),
(9,'issue','cancel'),
(9,'issue','close'),
(9,'issue','confirm'),
(9,'issue','create'),
(9,'issue','delete'),
(9,'issue','edit'),
(9,'issue','importFromLib'),
(9,'issue','resolve'),
(9,'issue','view'),
(9,'meeting','browse'),
(9,'meeting','create'),
(9,'meeting','delete'),
(9,'meeting','edit'),
(9,'meeting','minutes'),
(9,'meeting','view'),
(9,'meetingroom','batchCreate'),
(9,'meetingroom','batchEdit'),
(9,'meetingroom','browse'),
(9,'meetingroom','create'),
(9,'meetingroom','delete'),
(9,'meetingroom','edit'),
(9,'meetingroom','view'),
(9,'milestone','index'),
(9,'milestone','saveOtherProblem'),
(9,'my','issue'),
(9,'my','meeting'),
(9,'my','myMeeting'),
(9,'my','nc'),
(9,'my','risk'),
(9,'nc','16'),
(9,'nc','activate'),
(9,'nc','assign'),
(9,'nc','batchassign'),
(9,'nc','batchcreate'),
(9,'nc','batchedit'),
(9,'nc','browse'),
(9,'nc','close'),
(9,'nc','create'),
(9,'nc','delete'),
(9,'nc','edit'),
(9,'nc','export'),
(9,'nc','exporttemplate'),
(9,'nc','import'),
(9,'nc','link'),
(9,'nc','resolve'),
(9,'nc','search'),
(9,'nc','showimport'),
(9,'nc','unlink'),
(9,'nc','view'),
(9,'opportunity','activate'),
(9,'opportunity','assignTo'),
(9,'opportunity','batchActivate'),
(9,'opportunity','batchAssignTo'),
(9,'opportunity','batchCancel'),
(9,'opportunity','batchClose'),
(9,'opportunity','batchCreate'),
(9,'opportunity','batchEdit'),
(9,'opportunity','batchHangup'),
(9,'opportunity','batchImportToLib'),
(9,'opportunity','browse'),
(9,'opportunity','cancel'),
(9,'opportunity','close'),
(9,'opportunity','create'),
(9,'opportunity','delete'),
(9,'opportunity','edit'),
(9,'opportunity','hangup'),
(9,'opportunity','importFromLib'),
(9,'opportunity','importToLib'),
(9,'opportunity','track'),
(9,'opportunity','view'),
(9,'output','13'),
(9,'output','assign'),
(9,'output','batchassign'),
(9,'output','batchcreate'),
(9,'output','batchedit'),
(9,'output','browse'),
(9,'output','create'),
(9,'output','delete'),
(9,'output','edit'),
(9,'output','export'),
(9,'output','exporttemplate'),
(9,'output','import'),
(9,'output','link'),
(9,'output','search'),
(9,'output','showimport'),
(9,'output','unlink'),
(9,'output','view'),
(9,'process','browse'),
(9,'process','create'),
(9,'process','delete'),
(9,'process','edit'),
(9,'process','view'),
(9,'programplan','browse'),
(9,'pssp','browse'),
(9,'pssp','update'),
(9,'report','customeRedreport'),
(9,'review','assess'),
(9,'review','audit'),
(9,'review','browse'),
(9,'review','create'),
(9,'review','edit'),
(9,'review','recall'),
(9,'review','report'),
(9,'review','result'),
(9,'review','submit'),
(9,'review','toAudit'),
(9,'review','view'),
(9,'reviewcl','browse'),
(9,'reviewcl','create'),
(9,'reviewcl','delete'),
(9,'reviewcl','edit'),
(9,'reviewcl','view'),
(9,'reviewissue','create'),
(9,'reviewissue','edit'),
(9,'reviewissue','issue'),
(9,'reviewissue','resolved'),
(9,'reviewissue','updateStatus'),
(9,'reviewissue','view'),
(9,'reviewsetting','reviewer'),
(9,'reviewsetting','version'),
(9,'risk','activate'),
(9,'risk','assignTo'),
(9,'risk','batchCreate'),
(9,'risk','browse'),
(9,'risk','cancel'),
(9,'risk','close'),
(9,'risk','create'),
(9,'risk','delete'),
(9,'risk','edit'),
(9,'risk','hangup'),
(9,'risk','importFromLib'),
(9,'risk','view'),
(9,'stage','batchCreate'),
(9,'stage','browse'),
(9,'stage','create'),
(9,'stage','delete'),
(9,'stage','edit'),
(9,'subject','browse'),
(9,'weekly','index'),
(9,'workestimation','index'),
(9,'workloadbudget','27'),
(9,'workloadbudget','assign'),
(9,'workloadbudget','batchassign'),
(9,'workloadbudget','batchcreate'),
(9,'workloadbudget','batchedit'),
(9,'workloadbudget','browse'),
(9,'workloadbudget','create'),
(9,'workloadbudget','delete'),
(9,'workloadbudget','edit'),
(9,'workloadbudget','export'),
(9,'workloadbudget','exporttemplate'),
(9,'workloadbudget','import'),
(9,'workloadbudget','link'),
(9,'workloadbudget','search'),
(9,'workloadbudget','showimport'),
(9,'workloadbudget','unlink'),
(9,'workloadbudget','view'),
(9,'zoutput','browse'),
(9,'zoutput','view'),
(10,'activity','browse'),
(10,'activity','create'),
(10,'activity','delete'),
(10,'activity','edit'),
(10,'activity','view'),
(10,'audit','8'),
(10,'audit','assign'),
(10,'audit','batchassign'),
(10,'audit','batchcreate'),
(10,'audit','batchedit'),
(10,'audit','browse'),
(10,'audit','create'),
(10,'audit','delete'),
(10,'audit','edit'),
(10,'audit','export'),
(10,'audit','exporttemplate'),
(10,'audit','import'),
(10,'audit','link'),
(10,'audit','search'),
(10,'audit','showimport'),
(10,'audit','unlink'),
(10,'audit','view'),
(10,'auditplan','browse'),
(10,'auditplan','create'),
(10,'auditplan','edit'),
(10,'auditplan','nc'),
(10,'auditplan','result'),
(10,'auditresult','10'),
(10,'auditresult','assign'),
(10,'auditresult','batchassign'),
(10,'auditresult','batchcreate'),
(10,'auditresult','batchedit'),
(10,'auditresult','browse'),
(10,'auditresult','create'),
(10,'auditresult','delete'),
(10,'auditresult','edit'),
(10,'auditresult','export'),
(10,'auditresult','exporttemplate'),
(10,'auditresult','import'),
(10,'auditresult','link'),
(10,'auditresult','search'),
(10,'auditresult','showimport'),
(10,'auditresult','unlink'),
(10,'auditresult','view'),
(10,'budget','batchCreate'),
(10,'budget','browse'),
(10,'budget','create'),
(10,'budget','delete'),
(10,'budget','edit'),
(10,'budget','summary'),
(10,'budget','view'),
(10,'custom','estimate'),
(10,'design','browse'),
(10,'design','create'),
(10,'design','delete'),
(10,'design','edit'),
(10,'design','view'),
(10,'durationestimation','create'),
(10,'durationestimation','index'),
(10,'issue','activate'),
(10,'issue','batchCreate'),
(10,'issue','browse'),
(10,'issue','cancel'),
(10,'issue','close'),
(10,'issue','create'),
(10,'issue','delete'),
(10,'issue','edit'),
(10,'issue','resolve'),
(10,'issue','view'),
(10,'meeting','browse'),
(10,'meeting','create'),
(10,'meeting','delete'),
(10,'meeting','edit'),
(10,'meeting','minutes'),
(10,'meeting','view'),
(10,'milestone','index'),
(10,'my','issue'),
(10,'my','meeting'),
(10,'my','myMeeting'),
(10,'my','nc'),
(10,'my','risk'),
(10,'nc','16'),
(10,'nc','activate'),
(10,'nc','assign'),
(10,'nc','batchassign'),
(10,'nc','batchcreate'),
(10,'nc','batchedit'),
(10,'nc','browse'),
(10,'nc','close'),
(10,'nc','create'),
(10,'nc','delete'),
(10,'nc','edit'),
(10,'nc','export'),
(10,'nc','exporttemplate'),
(10,'nc','import'),
(10,'nc','link'),
(10,'nc','resolve'),
(10,'nc','search'),
(10,'nc','showimport'),
(10,'nc','unlink'),
(10,'nc','view'),
(10,'opportunity','browse'),
(10,'opportunity','view'),
(10,'output','13'),
(10,'output','assign'),
(10,'output','batchassign'),
(10,'output','batchcreate'),
(10,'output','batchedit'),
(10,'output','browse'),
(10,'output','create'),
(10,'output','delete'),
(10,'output','edit'),
(10,'output','export'),
(10,'output','exporttemplate'),
(10,'output','import'),
(10,'output','link'),
(10,'output','search'),
(10,'output','showimport'),
(10,'output','unlink'),
(10,'output','view'),
(10,'process','browse'),
(10,'process','create'),
(10,'process','delete'),
(10,'process','edit'),
(10,'process','view'),
(10,'pssp','browse'),
(10,'pssp','update'),
(10,'report','customeRedreport'),
(10,'risk','activate'),
(10,'risk','batchCreate'),
(10,'risk','browse'),
(10,'risk','cancel'),
(10,'risk','close'),
(10,'risk','create'),
(10,'risk','delete'),
(10,'risk','edit'),
(10,'risk','hangup'),
(10,'risk','view'),
(10,'stage','batchCreate'),
(10,'stage','browse'),
(10,'stage','create'),
(10,'stage','delete'),
(10,'stage','edit'),
(10,'subject','browse'),
(10,'trainchapter','browse'),
(10,'trainchapter','catalog'),
(10,'trainchapter','delete'),
(10,'trainchapter','download'),
(10,'trainchapter','edit'),
(10,'trainchapter','manage'),
(10,'trainchapter','showDocFiles'),
(10,'trainchapter','sortChapterOrder'),
(10,'trainchapter','view'),
(10,'traincourse','browse'),
(10,'traincourse','create'),
(10,'traincourse','delete'),
(10,'traincourse','edit'),
(10,'traincourse','manage'),
(10,'traincourse','view'),
(10,'trainplan','browse'),
(10,'trainplan','view'),
(10,'trainskill','browse'),
(10,'trainskill','create'),
(10,'trainskill','createGrade'),
(10,'trainskill','delete'),
(10,'trainskill','deleteDesc'),
(10,'trainskill','deleteGrade'),
(10,'trainskill','edit'),
(10,'trainskill','editGrade'),
(10,'trainskill','view'),
(10,'weekly','index'),
(10,'workestimation','index'),
(10,'workloadbudget','27'),
(10,'workloadbudget','assign'),
(10,'workloadbudget','batchassign'),
(10,'workloadbudget','batchcreate'),
(10,'workloadbudget','batchedit'),
(10,'workloadbudget','browse'),
(10,'workloadbudget','create'),
(10,'workloadbudget','delete'),
(10,'workloadbudget','edit'),
(10,'workloadbudget','export'),
(10,'workloadbudget','exporttemplate'),
(10,'workloadbudget','import'),
(10,'workloadbudget','link'),
(10,'workloadbudget','search'),
(10,'workloadbudget','showimport'),
(10,'workloadbudget','unlink'),
(10,'workloadbudget','view'),
(11,'activity','browse'),
(11,'activity','create'),
(11,'activity','delete'),
(11,'activity','edit'),
(11,'activity','view'),
(11,'audit','8'),
(11,'audit','assign'),
(11,'audit','batchassign'),
(11,'audit','batchcreate'),
(11,'audit','batchedit'),
(11,'audit','browse'),
(11,'audit','create'),
(11,'audit','delete'),
(11,'audit','edit'),
(11,'audit','export'),
(11,'audit','exporttemplate'),
(11,'audit','import'),
(11,'audit','link'),
(11,'audit','search'),
(11,'audit','showimport'),
(11,'audit','unlink'),
(11,'audit','view'),
(11,'auditplan','browse'),
(11,'auditplan','create'),
(11,'auditplan','edit'),
(11,'auditplan','nc'),
(11,'auditplan','result'),
(11,'auditresult','10'),
(11,'auditresult','assign'),
(11,'auditresult','batchassign'),
(11,'auditresult','batchcreate'),
(11,'auditresult','batchedit'),
(11,'auditresult','browse'),
(11,'auditresult','create'),
(11,'auditresult','delete'),
(11,'auditresult','edit'),
(11,'auditresult','export'),
(11,'auditresult','exporttemplate'),
(11,'auditresult','import'),
(11,'auditresult','link'),
(11,'auditresult','search'),
(11,'auditresult','showimport'),
(11,'auditresult','unlink'),
(11,'auditresult','view'),
(11,'budget','batchCreate'),
(11,'budget','browse'),
(11,'budget','create'),
(11,'budget','delete'),
(11,'budget','edit'),
(11,'budget','summary'),
(11,'budget','view'),
(11,'custom','estimate'),
(11,'design','browse'),
(11,'design','create'),
(11,'design','delete'),
(11,'design','edit'),
(11,'design','view'),
(11,'durationestimation','create'),
(11,'durationestimation','index'),
(11,'issue','activate'),
(11,'issue','browse'),
(11,'issue','cancel'),
(11,'issue','close'),
(11,'issue','create'),
(11,'issue','delete'),
(11,'issue','edit'),
(11,'issue','resolve'),
(11,'issue','view'),
(11,'my','issue'),
(11,'my','meeting'),
(11,'my','myMeeting'),
(11,'my','risk'),
(11,'nc','16'),
(11,'nc','activate'),
(11,'nc','assign'),
(11,'nc','batchassign'),
(11,'nc','batchcreate'),
(11,'nc','batchedit'),
(11,'nc','browse'),
(11,'nc','close'),
(11,'nc','create'),
(11,'nc','delete'),
(11,'nc','edit'),
(11,'nc','export'),
(11,'nc','exporttemplate'),
(11,'nc','import'),
(11,'nc','link'),
(11,'nc','resolve'),
(11,'nc','search'),
(11,'nc','showimport'),
(11,'nc','unlink'),
(11,'nc','view'),
(11,'output','13'),
(11,'output','assign'),
(11,'output','batchassign'),
(11,'output','batchcreate'),
(11,'output','batchedit'),
(11,'output','browse'),
(11,'output','create'),
(11,'output','delete'),
(11,'output','edit'),
(11,'output','export'),
(11,'output','exporttemplate'),
(11,'output','import'),
(11,'output','link'),
(11,'output','search'),
(11,'output','showimport'),
(11,'output','unlink'),
(11,'output','view'),
(11,'process','browse'),
(11,'process','create'),
(11,'process','delete'),
(11,'process','edit'),
(11,'process','view'),
(11,'programplan','browse'),
(11,'pssp','browse'),
(11,'pssp','update'),
(11,'report','customeRedreport'),
(11,'risk','activate'),
(11,'risk','browse'),
(11,'risk','cancel'),
(11,'risk','close'),
(11,'risk','create'),
(11,'risk','delete'),
(11,'risk','edit'),
(11,'risk','hangup'),
(11,'risk','view'),
(11,'stage','browse'),
(11,'stage','create'),
(11,'stage','delete'),
(11,'stage','edit'),
(11,'story','processStoryChange'),
(11,'subject','browse'),
(11,'trainbook','ajaxgetbookbysn'),
(11,'trainbook','batchEdit'),
(11,'trainbook','borrow'),
(11,'trainbook','borrowhistory'),
(11,'trainbook','browse'),
(11,'trainbook','create'),
(11,'trainbook','delete'),
(11,'trainbook','edit'),
(11,'trainbook','export'),
(11,'trainbook','manage'),
(11,'trainbook','returnbook'),
(11,'trainbook','view'),
(11,'traincourse','browse'),
(11,'traincourse','changeStatus'),
(11,'traincourse','create'),
(11,'traincourse','edit'),
(11,'traincourse','manage'),
(11,'traincourse','view'),
(11,'weekly','index'),
(11,'workestimation','index'),
(11,'workloadbudget','27'),
(11,'workloadbudget','assign'),
(11,'workloadbudget','batchassign'),
(11,'workloadbudget','batchcreate'),
(11,'workloadbudget','batchedit'),
(11,'workloadbudget','browse'),
(11,'workloadbudget','create'),
(11,'workloadbudget','delete'),
(11,'workloadbudget','edit'),
(11,'workloadbudget','export'),
(11,'workloadbudget','exporttemplate'),
(11,'workloadbudget','import'),
(11,'workloadbudget','link'),
(11,'workloadbudget','search'),
(11,'workloadbudget','showimport'),
(11,'workloadbudget','unlink'),
(11,'workloadbudget','view');

REPLACE INTO `zt_approvalflow` (`id`, `name`, `code`, `desc`, `version`, `createdBy`, `createdDate`, `type`, `deleted`) VALUES
(1, '最简审批', 'simple', '', 1, 'admin', '2022-04-29 08:46:40', 'project', 0);

REPLACE INTO `zt_approvalflowspec` (`id`, `flow`, `version`, `nodes`, `createdBy`, `createdDate`) VALUES
(1, 1, 1, '[{\"type\":\"start\",\"ccs\":[]},{\"id\":\"3ewcj92p55e\",\"type\":\"approval\",\"title\":\"审批\",\"reviewType\":\"manual\",\"multiple\":\"and\",\"agentType\":\"pass\",\"reviewers\":[{\"type\":\"select\"}],\"ccs\":[]},{\"type\":\"end\",\"ccs\":[]}]', 'admin', '2022-04-29 08:46:40');

REPLACE INTO `zt_grouppriv`(`module`, `method`,`group`)
SELECT `module`, `method`, 14 from `zt_grouppriv` where `group` = 1;

REPLACE INTO `zt_grouppriv`(`module`, `method`,`group`)
SELECT `module`, `method`, 15 from `zt_grouppriv` where `group` = 4;

REPLACE INTO `zt_grouppriv`(`module`, `method`,`group`)
SELECT `module`, `method`, 16 from `zt_grouppriv` where `group` = 9;

REPLACE INTO `zt_lang` (`lang`, `module`, `section`, `key`, `value`, `system`) VALUES
('all', 'process', 'classify', 'support', '支持过程', '1'),
('all', 'process', 'classify', 'engineering', '工程支持', '1'),
('all', 'process', 'classify', 'project', '项目管理', '1');

REPLACE INTO `zt_process` (`id`, `name`, `type`, `abbr`, `desc`, `assignedTo`, `status`, `order`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `assignedBy`, `assignedDate`, `deleted`) VALUES
(11,'立项管理','project','PIM','','','',55,'admin','2020-01-09 10:29:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(12,'项目规划','project','PP','','','',60,'admin','2020-01-09 10:31:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(13,'项目监控','project','PMC','','','',65,'admin','2020-01-09 10:31:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(14,'风险管理','project','RSKM','','','',70,'admin','2020-01-09 10:31:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(15,'结项管理','project','PCM','','','',75,'admin','2020-01-09 10:31:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(16,'量化项目管理','project','QPM','','','',80,'admin','2020-01-09 10:31:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(17,'需求开发','engineering','RDM','','','',85,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(18,'设计开发','engineering','','','','',90,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(19,'实现与测试','engineering','EMBEDDED','','','',95,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(20,'系统测试','engineering','ST','','','',100,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(21,'客户验收','engineering','CA','','','',105,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(22,'质量保证','support','QA','','','',110,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(23,'配置管理','support','CM','','','',115,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(24,'度量分析','support','MA','','','',120,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(25,'原因分析与解决','support','CAR','','','',125,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(26,'决策分析','support','DAR','','','',130,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0');

REPLACE INTO `zt_activity` (`id`, `process`, `name`, `optional`, `content`, `assignedTo`, `status`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `assignedBy`, `assignedDate`, `order`, `deleted`) VALUES
(4,11,'立项调查，可行性分析，技术预研','yes','','','','admin','2020-01-09 10:49:34','','0000-00-00 00:00:00','','0000-00-00 00:00:00',20,'0'),
(5,11,'项目预算','yes','','','','admin','2020-01-09 10:49:34','','0000-00-00 00:00:00','','0000-00-00 00:00:00',25,'0'),
(6,11,'立项决策','yes','','','','admin','2020-01-09 10:49:34','','0000-00-00 00:00:00','','0000-00-00 00:00:00',30,'0'),
(7,11,'投标/商务洽谈','no','','','','admin','2020-01-09 10:49:34','','0000-00-00 00:00:00','','0000-00-00 00:00:00',35,'0'),
(8,12,'估算','yes','','','','admin','2020-01-09 11:12:17','','0000-00-00 00:00:00','','0000-00-00 00:00:00',40,'0'),
(9,12,'裁剪','yes','','','','admin','2020-01-09 11:12:17','','0000-00-00 00:00:00','','0000-00-00 00:00:00',45,'0'),
(10,12,'制定项目计划及下属计划','yes','','','','admin','2020-01-09 11:12:17','','0000-00-00 00:00:00','','0000-00-00 00:00:00',50,'0'),
(11,12,'评审项目计划及下属计划','yes','','','','admin','2020-01-09 11:12:17','','0000-00-00 00:00:00','','0000-00-00 00:00:00',55,'0'),
(12,13,'日常跟踪','yes','','','','admin','2020-01-09 11:13:37','','0000-00-00 00:00:00','','0000-00-00 00:00:00',60,'0'),
(13,13,'举行周例会','yes','','','','admin','2020-01-09 11:13:37','','0000-00-00 00:00:00','','0000-00-00 00:00:00',65,'0'),
(14,13,'里程碑评审','yes','','','','admin','2020-01-09 11:13:37','','0000-00-00 00:00:00','','0000-00-00 00:00:00',70,'0'),
(15,13,'采取纠正措施','no','','','','admin','2020-01-09 11:13:37','','0000-00-00 00:00:00','','0000-00-00 00:00:00',75,'0'),
(16,14,'制定风险管理计划','yes','','','','admin','2020-01-09 11:15:04','','0000-00-00 00:00:00','','0000-00-00 00:00:00',80,'0'),
(17,14,'风险识别','yes','','','','admin','2020-01-09 11:15:04','','0000-00-00 00:00:00','','0000-00-00 00:00:00',85,'0'),
(18,14,'风险分析','yes','','','','admin','2020-01-09 11:15:04','','0000-00-00 00:00:00','','0000-00-00 00:00:00',90,'0'),
(19,14,'风险规避和缓解','yes','','','','admin','2020-01-09 11:15:04','','0000-00-00 00:00:00','','0000-00-00 00:00:00',95,'0'),
(20,14,'风险跟踪','yes','','','','admin','2020-01-09 11:15:04','','0000-00-00 00:00:00','','0000-00-00 00:00:00',100,'0'),
(21,14,'更新组织级“风险列表库”','no','','','','admin','2020-01-09 11:15:04','','0000-00-00 00:00:00','','0000-00-00 00:00:00',105,'0'),
(22,15,'结项准备','no','','','','admin','2020-01-09 11:16:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00',110,'0'),
(23,15,'结项申请','yes','','','','admin','2020-01-09 11:16:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00',115,'0'),
(24,15,'结项评审','yes','','','','admin','2020-01-09 11:16:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00',120,'0'),
(25,15,'资料纳入组织级过程资产库','yes','','','','admin','2020-01-09 11:16:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00',125,'0'),
(26,16,'量化项目管理','yes','','','','admin','2020-01-09 11:16:34','','0000-00-00 00:00:00','','0000-00-00 00:00:00',130,'0'),
(27,17,'用户需求获取','yes','','','','admin','2020-01-09 13:25:22','','0000-00-00 00:00:00','','0000-00-00 00:00:00',135,'0'),
(28,17,'用户需求评审','yes','','','','admin','2020-01-09 13:25:22','','0000-00-00 00:00:00','','0000-00-00 00:00:00',140,'0'),
(29,17,'产品需求定义','yes','','','','admin','2020-01-09 13:25:22','','0000-00-00 00:00:00','','0000-00-00 00:00:00',145,'0'),
(30,17,'产品需求评审','yes','','','','admin','2020-01-09 13:25:22','','0000-00-00 00:00:00','','0000-00-00 00:00:00',150,'0'),
(31,17,'需求变更控制','no','未涉及变更时可不进行','','','admin','2020-01-09 13:25:22','','0000-00-00 00:00:00','','0000-00-00 00:00:00',155,'0'),
(32,18,'概要设计','','','','','admin','2020-01-09 13:26:07','','0000-00-00 00:00:00','','0000-00-00 00:00:00',160,'0'),
(33,18,'评审《概要设计说明书》','','','','','admin','2020-01-09 13:26:07','','0000-00-00 00:00:00','','0000-00-00 00:00:00',165,'0'),
(34,18,'详细设计','','','','','admin','2020-01-09 13:26:07','','0000-00-00 00:00:00','','0000-00-00 00:00:00',170,'0'),
(35,18,'评审详细设计工作产品','','','','','admin','2020-01-09 13:26:07','','0000-00-00 00:00:00','','0000-00-00 00:00:00',175,'0'),
(42,19,'制定编码阶段计划','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',210,'0'),
(43,19,'构建数据库','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',215,'0'),
(44,19,'编码实现','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',220,'0'),
(45,19,'代码检查','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',225,'0'),
(46,19,'单元测试','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',230,'0'),
(47,19,'交叉单元测试','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',235,'0'),
(48,19,'系统集成','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',240,'0'),
(49,19,'编写集成测试用例','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',245,'0'),
(50,19,'评审集成测试用例','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',250,'0'),
(51,19,'集成测试','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',255,'0'),
(52,19,'缺陷管理','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',260,'0'),
(53,19,'编写支持文档','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',265,'0'),
(54,20,'制定《系统测试计划》','','','','','admin','2020-01-09 13:28:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',270,'0'),
(55,20,'评审《系统测试计划》','','','','','admin','2020-01-09 13:28:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',275,'0'),
(56,20,'编写《系统测试用例》','','','','','admin','2020-01-09 13:28:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',280,'0'),
(57,20,'评审《系统测试用例》','','','','','admin','2020-01-09 13:28:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',285,'0'),
(58,20,'执行系统测试','','','','','admin','2020-01-09 13:28:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',290,'0'),
(59,21,'验收准备','','','','','admin','2020-01-09 13:29:28','','0000-00-00 00:00:00','','0000-00-00 00:00:00',295,'0'),
(60,21,'产品打包','','','','','admin','2020-01-09 13:29:28','','0000-00-00 00:00:00','','0000-00-00 00:00:00',300,'0'),
(61,21,'内部培训','','','','','admin','2020-01-09 13:29:28','','0000-00-00 00:00:00','','0000-00-00 00:00:00',305,'0'),
(62,21,'现场安装调试','','','','','admin','2020-01-09 13:29:28','','0000-00-00 00:00:00','','0000-00-00 00:00:00',310,'0'),
(63,21,'用户使用培训','','','','','admin','2020-01-09 13:29:28','','0000-00-00 00:00:00','','0000-00-00 00:00:00',315,'0'),
(64,21,'试运行','','','','','admin','2020-01-09 13:29:28','','0000-00-00 00:00:00','','0000-00-00 00:00:00',320,'0'),
(65,21,'客户验收','','','','','admin','2020-01-09 13:29:28','','0000-00-00 00:00:00','','0000-00-00 00:00:00',325,'0'),
(66,22,'制定质量保证计划','','','','','admin','2020-01-09 13:38:58','','0000-00-00 00:00:00','','0000-00-00 00:00:00',330,'0'),
(67,22,'评审质量保证计划','','','','','admin','2020-01-09 13:38:58','','0000-00-00 00:00:00','','0000-00-00 00:00:00',335,'0'),
(68,22,'过程和产品质量检查','','','','','admin','2020-01-09 13:38:58','','0000-00-00 00:00:00','','0000-00-00 00:00:00',340,'0'),
(69,22,'问题跟踪处理','','','','','admin','2020-01-09 13:38:58','','0000-00-00 00:00:00','','0000-00-00 00:00:00',345,'0'),
(70,22,'质量保证总结报告','','','','','admin','2020-01-09 13:38:58','','0000-00-00 00:00:00','','0000-00-00 00:00:00',350,'0'),
(71,23,'组织及配置管理员移交工作','','','','','admin','2020-01-09 13:39:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',355,'0'),
(72,23,'制定《配置管理计划》','','','','','admin','2020-01-09 13:39:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',360,'0'),
(73,23,'建立和维护配置库','','','','','admin','2020-01-09 13:39:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',365,'0'),
(74,23,'配置项管理','','','','','admin','2020-01-09 13:39:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',370,'0'),
(75,23,'基线管理','','','','','admin','2020-01-09 13:39:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',375,'0'),
(76,23,'变更管理','','','','','admin','2020-01-09 13:39:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',380,'0'),
(77,23,'配置审计','','','','','admin','2020-01-09 13:39:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',385,'0'),
(78,24,'建立项目度量目标','','','','','admin','2020-01-09 13:40:05','','0000-00-00 00:00:00','','0000-00-00 00:00:00',390,'0'),
(79,24,'确定项目度量点','','','','','admin','2020-01-09 13:40:05','','0000-00-00 00:00:00','','0000-00-00 00:00:00',395,'0'),
(80,24,'制定度量分析计划','','','','','admin','2020-01-09 13:40:05','','0000-00-00 00:00:00','','0000-00-00 00:00:00',400,'0'),
(81,24,'收集和分析度量数据','','','','','admin','2020-01-09 13:40:05','','0000-00-00 00:00:00','','0000-00-00 00:00:00',405,'0'),
(82,24,'存储和通报度量分析结果','','','','','admin','2020-01-09 13:40:05','','0000-00-00 00:00:00','','0000-00-00 00:00:00',410,'0'),
(83,25,'原因分析与解决','','','','','admin','2020-01-09 13:40:15','','0000-00-00 00:00:00','','0000-00-00 00:00:00',415,'0'),
(84,26,'建立评估标准','','','','','admin','2020-01-09 13:40:35','','0000-00-00 00:00:00','','0000-00-00 00:00:00',420,'0'),
(85,26,'确定候选方案','','','','','admin','2020-01-09 13:40:35','','0000-00-00 00:00:00','','0000-00-00 00:00:00',425,'0'),
(86,26,'原因分析与解决','','','','','admin','2020-01-09 13:40:35','','0000-00-00 00:00:00','','0000-00-00 00:00:00',430,'0'),
(87,26,'确定评估方法','','','','','admin','2020-01-09 13:40:35','','0000-00-00 00:00:00','','0000-00-00 00:00:00',435,'0'),
(88,26,'评估候选方案','','','','','admin','2020-01-09 13:40:35','','0000-00-00 00:00:00','','0000-00-00 00:00:00',440,'0'),
(89,26,'做出决策','','','','','admin','2020-01-09 13:40:35','','0000-00-00 00:00:00','','0000-00-00 00:00:00',445,'0');

REPLACE INTO `zt_zoutput` (`id`, `activity`, `name`, `content`, `optional`, `status`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `order`, `deleted`) VALUES
(5,4,'《技术可行性分析报告》','','','','admin','2020-01-09 11:01:52','','0000-00-00 00:00:00',25,'0'),
(6,5,'《项目预算表》','','','','admin','2020-01-09 11:17:27','','0000-00-00 00:00:00',30,'0'),
(7,6,'《立项申请报告》','','','','admin','2020-01-09 11:17:50','','0000-00-00 00:00:00',35,'0'),
(8,7,'《项目投标书》','不涉及投标','','','admin','2020-01-09 11:18:12','','0000-00-00 00:00:00',40,'0'),
(9,8,'《项目估算报告》','','','','admin','2020-01-09 11:18:41','','0000-00-00 00:00:00',45,'0'),
(10,8,'《功能点估算》','','','','admin','2020-01-09 11:18:41','','0000-00-00 00:00:00',50,'0'),
(11,9,'《PDP说明》','','','','admin','2020-01-09 11:18:54','','0000-00-00 00:00:00',55,'0'),
(12,10,'《项目进度表》','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',60,'0'),
(13,10,'《项目计划》及其下属计划','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',65,'0'),
(14,10,'《风险管理计划及跟踪表》','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',70,'0'),
(15,10,'《项目资源计划》','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',75,'0'),
(16,10,'《干系人计划》','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',80,'0'),
(17,10,'《同行评审计划》','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',85,'0'),
(18,10,'《质量保证计划》','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',90,'0'),
(19,10,'《配置管理计划》','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',95,'0'),
(20,11,'《同行评审通知》','','','','admin','2020-01-09 11:20:16','','0000-00-00 00:00:00',100,'0'),
(21,11,'《评审准备表》','','','','admin','2020-01-09 11:20:16','','0000-00-00 00:00:00',105,'0'),
(22,11,'《同行评审报告》','','','','admin','2020-01-09 11:20:17','','0000-00-00 00:00:00',110,'0'),
(23,12,'《里程碑报告》','','yes','','admin','2020-01-09 13:44:11','','0000-00-00 00:00:00',115,'0'),
(24,12,'《项目周报》','','yes','','admin','2020-01-09 13:44:11','','0000-00-00 00:00:00',120,'0'),
(25,13,'《项目周报》','','yes','','admin','2020-01-09 13:44:11','','0000-00-00 00:00:00',125,'0'),
(26,13,'《会议纪要》','','yes','','admin','2020-01-09 13:44:11','','0000-00-00 00:00:00',130,'0'),
(27,14,'《里程碑报告》','','yes','','admin','2020-01-09 13:44:11','','0000-00-00 00:00:00',135,'0'),
(28,14,'《里程碑会议纪要》','','yes','','admin','2020-01-09 13:44:11','','0000-00-00 00:00:00',140,'0'),
(29,15,'《计划变更申请》','','no','','admin','2020-01-09 13:44:11','','0000-00-00 00:00:00',145,'0'),
(30,16,'《风险管理计划及跟踪表》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',150,'0'),
(31,17,'《风险管理计划及跟踪表》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',155,'0'),
(32,17,'《风险管理报告》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',160,'0'),
(33,18,'《风险管理计划及跟踪表》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',165,'0'),
(34,19,'《异常处理申请表》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',170,'0'),
(35,19,'《风险管理计划及跟踪表》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',175,'0'),
(36,20,'《风险管理报告》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',180,'0'),
(37,20,'《风险管理计划及跟踪表》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',185,'0'),
(38,21,'《风险列表库》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',190,'0'),
(39,22,'《代码复用总结》','','','','admin','2020-01-09 13:46:26','','0000-00-00 00:00:00',195,'0'),
(40,24,'《结项报告》','','','','admin','2020-01-09 13:46:26','','0000-00-00 00:00:00',200,'0'),
(41,26,'《量化项目管理及跟踪计划》','','yes','','admin','2020-01-09 13:46:46','','0000-00-00 00:00:00',205,'0'),
(42,27,'《用户需求调查单》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',210,'0'),
(43,27,'《用户需求说明书》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',215,'0'),
(44,28,'《评审通知》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',220,'0'),
(45,28,'《同行评审准备表》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',225,'0'),
(46,28,'《同行评审报告》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',230,'0'),
(47,29,'《产品需求规格说明书》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',235,'0'),
(48,30,'《评审通知》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',240,'0'),
(49,30,' 《同行评审准备表》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',245,'0'),
(50,30,' 《同行评审报告》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',250,'0'),
(51,31,'《需求变更记录》','','','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',255,'0'),
(52,31,'《用户需求说明书》','','','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',260,'0'),
(53,31,'《软件需求规格说明书》','','','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',265,'0'),
(54,32,'《概要设计说明书》','','yes','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',270,'0'),
(55,33,'《评审通知》','','yes','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',275,'0'),
(56,33,'《同行评审准备表》','','yes','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',280,'0'),
(57,33,'《同行评审报告》','','yes','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',285,'0'),
(58,34,'《模块设计说明书》','','no','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',290,'0'),
(59,34,'《数据库设计说明书》','','yes','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',295,'0'),
(60,34,'《用户界面设计说明书》','','no','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',300,'0'),
(61,35,'《评审通知》','','no','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',305,'0'),
(62,35,'《同行评审准备表》','','no','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',310,'0'),
(63,35,'《同行评审报告》','','no','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',315,'0'),
(64,42,'《实现与测试计划》','','yes','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',320,'0'),
(65,42,'《单板硬件调试和单元测试计划》','','yes','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',325,'0'),
(66,42,'《项目进度表》中“实现与测试”部分','','yes','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',330,'0'),
(67,43,'产品数据库','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',335,'0'),
(68,44,'模块代码','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',340,'0'),
(69,45,'《代码质量检查记录单》','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',345,'0'),
(70,46,'《单元测试缺陷统计分析报告》','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',350,'0'),
(71,47,'禅道缺陷记录','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',355,'0'),
(72,48,'《系统集成说明书》','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',360,'0'),
(73,49,'《集成测试用例》','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',365,'0'),
(74,50,'《评审通知》 ','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',370,'0'),
(75,50,'《同行评审准备表》 ','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',375,'0'),
(76,50,'《同行评审报告》','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',380,'0'),
(77,51,'《集成测试报告》','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',385,'0'),
(78,52,'禅道缺陷记录','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',390,'0'),
(79,52,'《用户操作手册》 ','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',395,'0'),
(80,52,'《安装手册》','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',400,'0'),
(81,54,'《系统测试计划》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',405,'0'),
(82,55,'《评审通知》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',410,'0'),
(83,55,'《同行评审准备表》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',415,'0'),
(84,55,'《同行评审报告》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',420,'0'),
(85,56,'《系统测试用例》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',425,'0'),
(86,57,'《评审通知》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',430,'0'),
(87,57,'《同行评审准备表》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',435,'0'),
(88,57,'《同行评审报告》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',440,'0'),
(89,58,'禅道缺陷跟踪系统记录项','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',445,'0'),
(90,58,'《系统测试分析报告》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',450,'0'),
(91,58,'《缺陷统计分析报告》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',455,'0'),
(92,59,'《产品打包清单》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',460,'0'),
(93,60,'发布光盘、纸质支持文档','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',465,'0'),
(94,61,'《交接签收单》','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',470,'0'),
(95,62,'《工作联系单》','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',475,'0'),
(96,62,'《工作记录单》','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',480,'0'),
(97,62,'《交接签收单》','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',485,'0'),
(98,62,'《安装调试信息》','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',490,'0'),
(99,64,'禅道缺陷记录项','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',495,'0'),
(100,64,'会议纪要等文档','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',500,'0'),
(101,65,'《交接验收单》','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',505,'0'),
(102,65,'《客户验收报告》','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',510,'0'),
(103,66,'初步《质量保证计划及跟踪表》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',515,'0'),
(104,67,'详细《质量保证计划及跟踪表》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',520,'0'),
(105,68,'《过程审计检查表》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',525,'0'),
(106,68,'《产品审计检查表》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',530,'0'),
(107,68,'《QA审计报告》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',535,'0'),
(108,68,'《QA问题报告》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',540,'0'),
(109,68,'《QA里程碑报告》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',545,'0'),
(110,68,'《QA周报》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',550,'0'),
(111,69,'《QA审计报告》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',555,'0'),
(112,69,'《QA问题报告》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',560,'0'),
(113,70,'《QA总结报告》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',565,'0'),
(114,72,'《配置管理计划》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',570,'0'),
(115,72,'《配置项计划及跟踪表》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',575,'0'),
(116,72,'《基线计划及跟踪表》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',580,'0'),
(117,73,'《配置库管理报告》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',585,'0'),
(118,74,'《配置项计划及跟踪表》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',590,'0'),
(119,75,'《基线计划及跟踪表》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',595,'0'),
(120,76,'《变更申请书》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',600,'0'),
(121,77,'《配置审计报告》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',605,'0'),
(122,80,'《度量分析计划》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',610,'0'),
(123,82,'项目度量数据库','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',615,'0'),
(124,86,'《量化项目管理及跟踪计划》','','no','','admin','2020-01-09 14:59:04','','0000-00-00 00:00:00',620,'0'),
(125,84,'《决策分析报告》的决策分析评估表','','no','','admin','2020-01-09 14:59:04','','0000-00-00 00:00:00',625,'0'),
(126,83,'《量化项目计划及跟踪表》','','no','','admin','2020-01-09 14:59:04','','0000-00-00 00:00:00',630,'0'),
(127,87,'《决策分析报告》的评分表','','no','','admin','2020-01-09 14:59:04','','0000-00-00 00:00:00',635,'0'),
(128,88,'《决策分析报告》的评分表','','no','','admin','2020-01-09 14:59:04','','0000-00-00 00:00:00',640,'0'),
(129,89,'《决策分析报告》','','no','','admin','2020-01-09 14:59:04','','0000-00-00 00:00:00',645,'0');

REPLACE INTO `zt_basicmeas` VALUES
(2,'scale','project','userRequest','项目用户需求初始规模','pgmURInitScale','故事点或功能点','CREATE FUNCTION qc_pgmurinitscale($project int) returns float (10,2)\r\nbegin\r\n    declare scale float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'URS\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_initscale($project, \'URS\',\'requestEst\') into scale__DELIMITER__\r\n    return scale__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nend','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目每个产品的第一个用户需求规格说明书基线版本的规模之和','从基线表中查询该项目下面每个产品的第一个用户需求规模说明书版本，然后查询对应的需求，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 14:19:41',10,'0'),
(3,'scale','project','softRequest','项目软件需求初始规模','pgmSRInitScale','故事点或功能点','CREATE FUNCTION qc_pgmsrinitscale($project int) returns float (10,2)\r\nbegin\r\n    declare scale float (10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'SRS\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_initscale($project, \'SRS\',\'storyEst\') into scale __DELIMITER__\r\n    return scale __DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nend','{\"$project\":{\"showName\":\"\\u6240\\u9700\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目每个产品的第一个软件需求规格说明书基线版本的规模之和','从基线表中查询该项目下面每个产品的第一个软件需求规模说明书版本，然后查询对应的需求，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 14:21:53',15,'0'),
(4,'scale','project','userRequest','项目用户需求实时规模','pgmURRealScale','故事点或功能点','CREATE FUNCTION `qc_pgmurrealscale`($project int) RETURNS float (10,2)\r\nBEGIN\r\n  declare totalEstimate float(10,2) default 0__DELIMITER__\r\n  select CAST(sum(estimate) as DECIMAL(10,2)) as estimate from zt_story where project=$project and type=\'requirement\' and deleted=\'0\' and closedReason not in (\'subdivided\', \'duplicate\', \'willnotdo\', \'cancel\', \'bydesign\') into totalEstimate__DELIMITER__\r\n  return totalEstimate__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目用户需求实际的规模','从需求表中查询该项目下的所有用户需求，对规模进行求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 14:22:17',20,'0'),
(5,'scale','project','softRequest','项目软件需求实时规模','pgmSRRealScale','故事点或功能点','CREATE FUNCTION `qc_pgmsrrealscale`($project int) RETURNS float (10,2)\r\nBEGIN\r\n  declare totalEstimate float (10,2) default 0__DELIMITER__\r\n  select CAST(sum(estimate) as DECIMAL(10,2)) as estimate from zt_story where id in (select story from zt_projectstory where project=$project) and type=\'story\' and deleted=\'0\' and closedReason not in (\'subdivided\', \'duplicate\', \'willnotdo\', \'cancel\', \'bydesign\') into totalEstimate__DELIMITER__\r\n  return totalEstimate__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":false,\"options\":\"project\",\"defaultValue\":\"702\"}}','项目软件需求实际的规模','从需求表中查询该项目下的所有软件需求，对规模进行求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 14:28:01',25,'0'),
(6,'scale','project','program','项目估算规模','pgmPlanScale','故事点或功能点','CREATE FUNCTION `qc_pgmplanscale`($project int) RETURNS float (10,2)\r\nBEGIN\r\n   declare programScale float (10,2) default 0__DELIMITER__\r\n   select `scale` from zt_workestimation where project = $project into programScale__DELIMITER__\r\n   return programScale__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目最初估算时估计的规模','从项目估算表里面查询项目的估算规模。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 14:26:01',30,'0'),
(8,'duration','project','stage','项目需求阶段计划天数','pgmRequestPlanDays','天','CREATE FUNCTION `qc_pgmrequestplandays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeplanneddays($project,\'request\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有需求阶段计划天数的和','从阶段表里面统计该项目下面所有类型为需求的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',40,'0'),
(9,'duration','project','stage','项目设计阶段计划天数','pgmDesigntPlanDays','天','CREATE FUNCTION `qc_pgmdesigntplandays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeplanneddays($project,\'design\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有设计阶段计划天数的和','从阶段表里面统计该项目下面所有类型为设计的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',45,'0'),
(10,'duration','project','stage','项目开发阶段计划天数','pgmDevelPlanDays','天','CREATE FUNCTION `qc_pgmdevelplandays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeplanneddays($project,\'dev\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有研发阶段计划天数的和','从阶段表里面统计该项目下面所有类型为开发的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',50,'0'),
(11,'duration','project','stage','项目测试阶段计划天数','pgmTestPlanDays','天','CREATE FUNCTION `qc_pgmtestplandays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeplanneddays($project,\'qa\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有测试阶段计划天数的和','从阶段表里面统计该项目下面所有类型为测试的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',55,'0'),
(12,'duration','project','stage','项目需求阶段实际天数','pgmRequestRealDays','天','CREATE FUNCTION `qc_pgmrequestrealdays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeactualdays($project,\'request\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有需求阶段实际天数的和','从阶段表里面统计该项目下面所有类型为需求的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',60,'0'),
(13,'duration','project','stage','项目设计阶段实际天数','pgmDesigntRealDays','天','CREATE FUNCTION `qc_pgmdesigntrealdays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeactualdays($project,\'design\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有设计阶段实际天数的和','从阶段表里面统计该项目下面所有类型为设计的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',65,'0'),
(14,'duration','project','stage','项目开发阶段实际天数','pgmDevelRealDays','天','CREATE FUNCTION `qc_pgmdevelrealdays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeactualdays($project,\'dev\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有研发阶段实际天数的和','从阶段表里面统计该项目下面所有类型为开发的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',70,'0'),
(15,'duration','project','stage','项目测试阶段实际天数','pgmTestRealDays','天','CREATE FUNCTION `qc_pgmtestrealdays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeactualdays($project,\'qa\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"3\"}}','项目下面所有测试阶段实际天数的和','从阶段表里面统计该项目下面所有类型为测试的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',75,'0'),
(26,'duration','product','stage','分产品需求阶段计划天数','prdRequestPlanDays','天','CREATE FUNCTION `qc_prdrequestplandays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageplannedduration($product, \'request\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"\"}}','产品下面所有需求阶段计划天数的和','从阶段表里面统计该产品在该项目下所有类型为需求的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',130,'0'),
(27,'duration','product','stage','分产品设计阶段计划天数','prdDesigntPlanDays','天','CREATE FUNCTION `qc_prddesigntplandays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageplannedduration($product, \'design\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"\"}}','产品下面所有设计阶段计划天数的和','从阶段表里面统计该产品在该项目下所有类型为设计的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',135,'0'),
(28,'duration','product','stage','分产品开发阶段计划天数','prdDevelPlanDays','天','CREATE FUNCTION `qc_prddevelplandays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageplannedduration($product, \'dev\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"1\"}}','产品下面所有研发阶段计划天数的和','从阶段表里面统计该产品在该项目下所有类型为开发的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',140,'0'),
(29,'duration','product','stage','分产品测试阶段计划天数','prdTestPlanDays','天','CREATE FUNCTION `qc_prdtestplandays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageplannedduration($product, \'qa\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"\"}}','产品下面所有测试阶段计划天数的和','从阶段表里面统计该产品在该项目下所有类型为测试的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',145,'0'),
(30,'duration','product','stage','分产品需求阶段实际天数','prdRequestRealDays','天','CREATE FUNCTION `qc_prdrequestrealdays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageactualduration($product,\'request\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"\"}}','产品下面所有需求阶段实际天数的和','从阶段表里面统计该产品在该项目下所有类型为需求的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',150,'0'),
(31,'duration','product','stage','分产品设计阶段实际天数','prdDesigntRealDays','天','CREATE FUNCTION `qc_prddesigntrealdays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageactualduration($product, \'design\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"\"}}','产品下面所有设计阶段实际天数的和','从阶段表里面统计该产品在该项目下所有类型为设计的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',155,'0'),
(32,'duration','product','stage','分产品开发阶段实际天数','prdDevelRealDays','天','CREATE FUNCTION `qc_prddevelrealdays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageactualduration($product, \'dev\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"\"}}','产品下面所有研发阶段实际天数的和','从阶段表里面统计该产品在该项目下所有类型为开发的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',160,'0'),
(33,'duration','product','stage','分产品测试阶段实际天数','prdTestRealDays','天','CREATE FUNCTION `qc_prdtestrealdays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageactualduration($product, \'qa\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"1\"}}','产品下面所有测试阶段实际天数的和','从阶段表里面统计该产品在该项目下所有类型为测试的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',165,'0'),
(34,'workload','project','finance','项目任务实时预计工时数','pgmRealEstHours','小时','CREATE FUNCTION `qc_pgmrealesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    select sum(estimate) from zt_task where project=$project and parent >= 0 and status != \'cancel\' and deleted = \'0\' into @estimate__DELIMITER__\r\nreturn @estimate__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有任务的最初预计工时和','从任务表中查询该项目的所有任务，统计最初预计工>时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 19:51:39',170,'0'),
(35,'workload','project','finance','项目需求工作实时总预计工时数','pgmRequestRealEstHours','小时','CREATE FUNCTION `qc_pgmrequestrealesthours`($project int) RETURNS float (10,2)\r\nBEGIN\r\nreturn qc_pgmesthoursbytype($project, \'request\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有需求相关任务的最初预计工时和','从任务表中查询该项目所有任务类型为需求的任务，统计最初预计工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-23 13:49:17',175,'0'),
(36,'workload','project','finance','项目设计工作实时总预计工时数','pgmDesgignRealEstHours','小时','CREATE FUNCTION `qc_pgmdesgignrealesthours`($project int) RETURNS float (10,2)\r\nBEGIN\r\nreturn qc_pgmesthoursbytype($project, \'design\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有设计相关任务的最初预计工时和','从任务表中查询该项目所有任务类型为设计的任务，统计最初预计工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-23 13:45:32',180,'0'),
(37,'workload','project','finance','项目开发工作实时总预计工时数','pgmDevelRealEstHours','小时','CREATE FUNCTION `qc_pgmdevelrealesthours`($project int) RETURNS float (10,2)\r\nBEGIN\r\nreturn qc_pgmesthoursbytype($project, \'devel\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有开发相关任务的最初预计工时和','从任务表中查询该项目所有任务类型为开发的任务，统计最初预计工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-23 13:46:53',185,'0'),
(38,'workload','project','finance','项目测试工作实时总预计工时数','pgmTestRealEstHours','小时','CREATE FUNCTION `qc_pgmtestrealesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\nreturn qc_pgmesthoursbytype($project, \'test\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有测试相关任务的最初预计工时和','从任务表中查询该项目所有任务类型为测试的任务，统计最初预计工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-23 13:44:13',190,'0'),
(39,'workload','project','finance','项目任务实际消耗工时数','pgmRealHours','小时','CREATE FUNCTION `qc_pgmrealhours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n  select CAST(sum(consumed) as DECIMAL(10,2)) as consumed from zt_task where project=$project and parent >= 0 and status != \'cancel\' and deleted = \'0\'  into @consumed__DELIMITER__\r\n  return @consumed__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有任务的实际消耗工时和','从任务表中查询该项目的所有任务，统计实际消耗工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 19:49:32',195,'0'),
(40,'workload','project','finance','项目需求工作实际消耗工时数','pgmRequestRealHours','小时','CREATE FUNCTION `qc_pgmrequestrealhours`($project int) RETURNS float(10,2)\r\nBEGIN\r\nreturn qc_pgmrealhoursbytype($project, \'request\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有需求相关任务的实际消耗工时和','从任务表中查询该项目所有任务类型为需求的任务，统计实际消耗工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 19:49:03',200,'0'),
(41,'workload','project','finance','项目设计工作实际消耗工时数','pgmDesignRealHours','小时','CREATE FUNCTION `qc_pgmdesignrealhours`($project int) RETURNS float(10,2)\r\nBEGIN\r\nreturn qc_pgmrealhoursbytype($project, \'design\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有设计相关任务的实际消耗工时和','从任务表中查询该项目所有任务类型为设计的任务，统计实际消耗工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 19:48:35',205,'0'),
(42,'workload','project','finance','项目开发工作实际消耗工时数','pgmDevelRealHours','小时','CREATE FUNCTION `qc_pgmdevelrealhours`($project int) RETURNS float(10,2)\r\nBEGIN\r\nreturn qc_pgmrealhoursbytype($project, \'devel\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有开发相关任务的实际消耗工时和','从任务表中查询该项目所有任务类型为开发的任务，统计实际消耗工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 18:34:51',210,'0'),
(43,'workload','project','finance','项目测试工作实际消耗工时数','pgmTestRealHours','小时','CREATE FUNCTION `qc_pgmtestrealhours`($project int) RETURNS float(10, 2)\r\nBEGIN\r\nreturn qc_pgmrealhoursbytype($project, \'test\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有测试相关任务的实际消耗工时和','从任务表中查询该项目所有任务类型为测试的任务，统计实际消耗工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 18:09:01',215,'0'),
(44,'workload','project','finance','项目开发工作最初总预计工时数','pgmDevelFirstEstHours','小时','CREATE FUNCTION `qc_pgmdevelfirstesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getdevelfirstesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划第一个基线版本中所有开发相关工作最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-22 13:13:51','','0000-00-00 00:00:00',220,'0'),
(45,'workload','project','finance','项目设计工作最初总预计工时数','pgmDesignFirstEstHours','小时','CREATE FUNCTION `qc_pgmdesignfirstesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getdesignfirstesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划第一个基线版本中所有设计相关工作最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-22 16:33:20','admin','2020-07-23 10:31:23',225,'0'),
(46,'workload','project','finance','项目测试工作最初总预计工时数','pgmTestFirstEstHours','小时','CREATE FUNCTION `qc_pgmtestfirstesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_gettestfirstesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划第一个基线版本中所有测试相关工作最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 10:31:17','','0000-00-00 00:00:00',230,'0'),
(47,'workload','project','finance','项目需求工作最初总预计工时数','pgmRequestFirstEstHours','小时','CREATE FUNCTION `qc_pgmrequestfirstesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getstoryfirstesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划第一个基线版本中所有需求相关工作最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 10:53:09','','0000-00-00 00:00:00',235,'0'),
(48,'workload','project','finance','项目任务最初总预计工时数','pgmFirstEstHours','小时','CREATE FUNCTION `qc_pgmfirstesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getfirstesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划第一个基线版本中所有任务最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 13:06:59','','0000-00-00 00:00:00',240,'0'),
(49,'workload','project','finance','项目开发工作最终总预计工时数','pgmDevelLastEstHours','小时','CREATE FUNCTION `qc_pgmdevellastesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getdevlastesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划最后一个基线版本中所有开发相关任务最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 13:41:38','','0000-00-00 00:00:00',245,'0'),
(50,'workload','project','finance','项目需求工作最终总预计工时数','pgmRequestLastEstHours','小时','CREATE FUNCTION `qc_pgmrequestlastesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project,\'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getrequestlastesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划最后一个基线版本中所有需求相关任务最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 14:00:58','','0000-00-00 00:00:00',250,'0'),
(51,'workload','project','finance','项目测试工作最终总预计工时数','pgmTestLastEstHours','小时','CREATE FUNCTION `qc_pgmtestlastesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project,\'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_gettestlastesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划最后一个基线版本中所有测试相关任务最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 14:10:12','','0000-00-00 00:00:00',255,'0'),
(52,'workload','project','finance','项目设计工作最终总预计工时数','pgmDesignLastEstHours','小时','CREATE FUNCTION `qc_pgmdesignlastesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project,\'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getdesignlastesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划最后一个基线版本中所有设计相关任务最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 14:33:00','','0000-00-00 00:00:00',260,'0'),
(53,'workload','project','finance','项目任务最终总预计工时数','pgmLastEstHours','小时','CREATE FUNCTION `qc_pgmlastesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project,\'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getlastesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划最后一个基线版本中所有任务最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 14:54:42','','0000-00-00 00:00:00',265,'0');

REPLACE INTO `zt_cron` (`m`, `h`, `dom`, `mon`, `dow`, `command`, `remark`, `type`, `buildin`, `status`, `lastTime`) VALUES
('1','0','*','*','*','moduleName=weekly&methodName=computeWeekly','更新项目周报','system',0,'normal','2020-08-27 10:07:53'),
('1','0','*','*','*','moduleName=measurement&methodName=initCrontabQueue','初始化度量队列','zentao',0,'normal','2020-07-07 14:51:48'),
('*/5','*','*','*','*','moduleName=measurement&methodName=execCrontabQueue','执行度量队列','zentao',0,'running','2020-07-10 13:10:58');
-- DROP TABLE IF EXISTS `zt_sqlview`;
CREATE TABLE IF NOT EXISTS `zt_sqlview` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` varchar(90) NOT NULL,
  `code` varchar(45) NOT NULL,
  `sql` text NOT NULL,
  `desc` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
SET global log_bin_trust_function_creators = 1;
SET global sql_mode = '';
USE `__TABLE__`;

DROP FUNCTION IF EXISTS `get_monday`;
CREATE FUNCTION `get_monday`(day date) RETURNS date
  begin if date_format(day, '%w') = 0 then return subdate(day, date_format(day, '%w') - 6)__DELIMITER__
  else  return subdate(day, date_format(day, '%w') -1)__DELIMITER__
  end if__DELIMITER__
END;

DROP FUNCTION IF EXISTS `get_sunday`;
CREATE FUNCTION `get_sunday`(day date) RETURNS date
begin
  if date_format(day, '%w') = 0 then return day__DELIMITER__
  else return subdate(day, date_format(day, '%w') - 7)__DELIMITER__
  end if__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_cminited`;
CREATE FUNCTION qc_cminited($project int, $category varchar(30)) returns int
begin
    declare products int default 0__DELIMITER__
    declare objects  int default 0__DELIMITER__
    select count(*) from zt_projectproduct where project = $project into products__DELIMITER__
    select count(distinct product) from zt_object where project = $project and category = $category and type = 'taged' and product in (select product from zt_projectproduct where project = $project) into objects__DELIMITER__
    IF products = objects THEN
    return 1__DELIMITER__
    ELSEIF products != objects THEN
    return 0__DELIMITER__
    END IF__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_initscale`;
CREATE FUNCTION qc_initscale($project int, $category varchar(30), $estimateType varchar(30)) RETURNS float(10,2)
BEGIN
    declare $estimate int default 0__DELIMITER__
    declare $storyEst varchar(30) default 'storyEst'__DELIMITER__
    declare $requestEst varchar(30) default 'requestEst'__DELIMITER__
    if($estimateType = $storyEst) THEN SELECT sum(storyEst) as estimate FROM zt_object WHERE id in(SELECT MIN(id) FROM zt_object WHERE project = $project and category = $category and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__
    end if__DELIMITER__
    if($estimateType = $requestEst) THEN SELECT sum(requestEst) as estimate FROM zt_object WHERE id in(SELECT MIN(id) FROM zt_object WHERE project = $project and category = $category and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__
    end if__DELIMITER__
    RETURN @estimate__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmplanscale`;
CREATE FUNCTION `qc_pgmplanscale`($project int) RETURNS float(10,2)
BEGIN
   declare programScale float (10,2) default 0__DELIMITER__
   select `scale` from zt_workestimation where project = $project into @programScale__DELIMITER__
   return @programScale__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmsrinitscale`;
CREATE FUNCTION `qc_pgmsrinitscale`($project int) RETURNS float(10,2)
begin
    declare scale int default 0__DELIMITER__
    declare inited int default 0__DELIMITER__
    select qc_cminited($project, 'SRS') into inited__DELIMITER__
    IF inited = 1 THEN
    select qc_initscale($project, 'SRS', 'storyEst') into scale __DELIMITER__
    return scale __DELIMITER__
    ELSE
    return 0__DELIMITER__
    END IF__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmsrrealscale`;
CREATE FUNCTION `qc_pgmsrrealscale`($project int) RETURNS float(10,2)
BEGIN
  declare totalEstimate float(10,2) default 0__DELIMITER__
  select CAST(sum(estimate) as DECIMAL(10,2)) as estimate from zt_story where id in (select story from zt_projectstory where project=$project) and type='story' and deleted='0' and closedReason not in ('subdivided', 'duplicate', 'willnotdo', 'cancel', 'bydesign') into totalEstimate__DELIMITER__
  return totalEstimate__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmurinitscale`;
CREATE FUNCTION `qc_pgmurinitscale`($project int) RETURNS float(10,2)
begin
    declare scale int default 0__DELIMITER__
    declare inited int default 0__DELIMITER__
    select qc_cminited($project, 'URS') into inited__DELIMITER__
    IF inited = 1 THEN
    select qc_initscale($project, 'URS', 'requestEst') into scale__DELIMITER__
    return scale__DELIMITER__
    ELSE
    return 0__DELIMITER__
    END IF__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmurrealscale`;
CREATE FUNCTION `qc_pgmurrealscale`($project int) RETURNS float(10,2)
BEGIN
  declare totalEstimate float(10,2) default 0__DELIMITER__
  select CAST(sum(estimate) as DECIMAL(10,2)) as estimate from zt_story where project=$project and type='requirement' and deleted='0' and closedReason not in ('subdivided', 'duplicate', 'willnotdo', 'cancel', 'bydesign') into totalEstimate__DELIMITER__
  return totalEstimate__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmallrequirementstage`;
CREATE FUNCTION `qc_pgmallrequirementstage`($project int) RETURNS int(1)
BEGIN
    -- 获取项目产品总数
    select count(*) as products from zt_projectproduct where project = $project into @totalproduct__DELIMITER__
    -- 获取已经设置需求阶段的产品总数
    select count(*) as product from (select product from zt_projectproduct where project in (select id from zt_project where project = $project and type = 'stage' and attribute = 'request' and deleted = '0') GROUP BY product) as product into @product__DELIMITER__
    -- 让项目产品总数和已设置需求阶段产品总数比较,都设置返回1,否则返回0
    if @totalproduct = @product then return 1__DELIMITER__
    end if__DELIMITER__
    RETURN 0__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmdesigntplandays`;
CREATE FUNCTION `qc_pgmdesigntplandays`($project int) RETURNS int(10)
BEGIN
    select qc_pgmspecifiedtypeplanneddays($project,'design') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmdesigntrealdays`;
CREATE FUNCTION `qc_pgmdesigntrealdays`($project int) RETURNS int(10)
BEGIN
    select qc_pgmspecifiedtypeactualdays($project,'design') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmdevelplandays`;
CREATE FUNCTION `qc_pgmdevelplandays`($project int) RETURNS int(10)
BEGIN
    select qc_pgmspecifiedtypeplanneddays($project,'dev') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmdevelrealdays`;
CREATE FUNCTION `qc_pgmdevelrealdays`($project int) RETURNS int(10)
BEGIN
    select qc_pgmspecifiedtypeactualdays($project,'dev') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmrequestplandays`;
CREATE FUNCTION `qc_pgmrequestplandays`($project int) RETURNS int(10)
BEGIN
    select qc_pgmspecifiedtypeplanneddays($project,'request') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmrequestrealdays`;
CREATE FUNCTION `qc_pgmrequestrealdays`($project int) RETURNS int(10)
BEGIN
    select qc_pgmspecifiedtypeactualdays($project,'request') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmspecifiedtypeactualdays`;
CREATE FUNCTION `qc_pgmspecifiedtypeactualdays`($project int,$attribute varchar(50)) RETURNS int(10)
BEGIN
    -- 查询某类型的阶段总数
    select count(*) from zt_project where project = $project and attribute = $attribute and deleted = '0' and id not in (select parent from zt_project where project = $project and attribute = $attribute and grade = 2 group by parent) into @totalstory__DELIMITER__
    -- 查询某类型已设置实际工期的阶段总数
    select count(*) from zt_project where project = $project and attribute = $attribute and deleted = '0' and realDuration > 0 and id not in (select parent from zt_project where project = $project and attribute = $attribute and grade = 2 group by parent) into @setstory__DELIMITER__
    -- 查询项目下某类型阶段实际工期总数
    select sum(realDuration) as realDuration from zt_project where project = $project and attribute = $attribute and deleted = '0' and realDuration > 0 and id not in (select parent from zt_project where project = $project and attribute = $attribute and grade = 2 group by parent) into @days__DELIMITER__
    -- 判断项目下某类型的阶段是否都已设置实际工期
    if @totalstory != @setstory then
        set @days = 0__DELIMITER__
    end if__DELIMITER__
    return @days__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmspecifiedtypeplanneddays`;
CREATE FUNCTION `qc_pgmspecifiedtypeplanneddays`($project int,$attribute varchar(50)) RETURNS int(10)
BEGIN
    select sum(planDuration) as planDuration from zt_project where project = $project and attribute = $attribute and deleted = '0' and id not in (select parent from zt_project where project = $project and attribute = $attribute and grade = 2 group by parent) into @days__DELIMITER__
    return @days__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmstageactualduration`;
CREATE FUNCTION `qc_pgmstageactualduration`($product int, $attribute varchar(50)) RETURNS int(10)
BEGIN
    -- 查找某类型的阶段总数
    select count(*) as totalduration from zt_project where id in (select project from zt_projectproduct where product = $product) and type = 'stage' and attribute = $attribute and deleted = '0' and id not in (select parent from zt_project where id in (select project from zt_projectproduct where product = $product) and attribute = $attribute and grade = 2 group by parent) into @totalduration__DELIMITER__
    -- 查某类型阶段已设置实际工期的总数
    select count(*) as setduration from zt_project where id in (select project from zt_projectproduct where product = $product) and type = 'stage' and attribute = $attribute and deleted = '0' and id not in (select parent from zt_project where id in (select project from zt_projectproduct where product = $product) and attribute = $attribute and grade = 2 group by parent) and realDuration > 0 into @setduration__DELIMITER__
    -- 指定产品下某类型的阶段实际工期总和
    select sum(realDuration) as duration from zt_project where id in (select project from zt_projectproduct where product = $product) and type = 'stage' and attribute = $attribute and deleted = '0' and id not in (select parent from zt_project where id in (select project from zt_projectproduct where product = $product) and attribute = $attribute and grade = 2 group by parent) and realDuration > 0 into @duration__DELIMITER__
    -- 需要判断该类型阶段都已设置实际工期,否则不统计
    if @totalduration != @setduration then
        set @duration = 0__DELIMITER__
    end if__DELIMITER__
    return @duration__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmstageplannedduration`;
CREATE FUNCTION `qc_pgmstageplannedduration`($product int, $attribute varchar(50)) RETURNS int(10)
BEGIN
    -- 查找某产品对应阶段
    select sum(planDuration) as duration from zt_project where id in (select project from zt_projectproduct where product = $product) and attribute = $attribute and deleted = '0' and id not in (select parent from zt_project where id in (select project from zt_projectproduct where product = $product) and attribute = $attribute and grade = 2 group by parent) and planDuration > 0 into @duration__DELIMITER__
    RETURN @duration__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmtestplandays`;
CREATE FUNCTION `qc_pgmtestplandays`($project int) RETURNS int(10)
BEGIN
    select qc_pgmspecifiedtypeplanneddays($project,'qa') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmtestrealdays`;
CREATE FUNCTION `qc_pgmtestrealdays`($project int) RETURNS int(10)
BEGIN
    select qc_pgmspecifiedtypeactualdays($project,'qa') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_prddesigntplandays`;
CREATE FUNCTION `qc_prddesigntplandays`($project int, $product int) RETURNS int(10)
BEGIN
    select qc_pgmstageplannedduration($project, $product, 'design') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_prddesigntrealdays`;
CREATE FUNCTION `qc_prddesigntrealdays`($project int, $product int) RETURNS int(10)
BEGIN
    select qc_pgmstageactualduration($project, $product, 'design') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_prddevelplandays`;
CREATE FUNCTION `qc_prddevelplandays`($project int, $product int) RETURNS int(10)
BEGIN
    select qc_pgmstageplannedduration($project, $product, 'dev') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_prddevelrealdays`;
CREATE FUNCTION `qc_prddevelrealdays`($project int, $product int) RETURNS int(10)
BEGIN
    select qc_pgmstageactualduration($project, $product, 'dev') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_prdrequestplandays`;
CREATE FUNCTION `qc_prdrequestplandays`($project int, $product int) RETURNS int(10)
BEGIN
    select qc_pgmstageplannedduration($project, $product, 'request') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_prdrequestrealdays`;
CREATE FUNCTION `qc_prdrequestrealdays`($project int, $product int) RETURNS int(10)
BEGIN
    select qc_pgmstageactualduration($project, $product, 'request') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_prdtestplandays`;
CREATE FUNCTION `qc_prdtestplandays`($project int, $product int) RETURNS int(10)
BEGIN
    select qc_pgmstageplannedduration($project, $product, 'qa') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_prdtestrealdays`;
CREATE FUNCTION `qc_prdtestrealdays`($project int, $product int) RETURNS int(10)
BEGIN
    select qc_pgmstageactualduration($project, $product, 'qa') as days into @days__DELIMITER__
    return @days__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmdesgignrealesthours`;
CREATE FUNCTION `qc_pgmdesgignrealesthours`($project int) RETURNS float(10,2)
BEGIN
return qc_pgmesthoursbytype($project, 'design')__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmdesignrealhours`;
CREATE FUNCTION `qc_pgmdesignrealhours`($project int) RETURNS float(10,2)
BEGIN
return qc_pgmrealhoursbytype($project, 'design')__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmdevelrealesthours`;
CREATE FUNCTION `qc_pgmdevelrealesthours`($project int) RETURNS float(10,2)
BEGIN
return qc_pgmesthoursbytype($project, 'devel')__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmdevelrealhours`;
CREATE FUNCTION `qc_pgmdevelrealhours`($project int) RETURNS float(10,2)
BEGIN
return qc_pgmrealhoursbytype($project, 'devel')__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmrealesthours`;
CREATE FUNCTION `qc_pgmrealesthours`($project int) RETURNS float(10,2)
BEGIN
  select CAST(sum(estimate) as DECIMAL(10,2)) as estimate from zt_task where project=$project and parent >= 0 and status != 'cancel' and deleted = '0' into @estimate__DELIMITER__
  return @estimate__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmesthoursbytype`;
CREATE FUNCTION `qc_pgmesthoursbytype`($project int, $type char(30)) RETURNS float(10,2)
BEGIN
  select CAST(sum(estimate) as DECIMAL(10,2)) as estimate from zt_task where project=$project and type = $type and parent >= 0 and status != 'cancel' and deleted = '0' into @estimate__DELIMITER__
  return @estimate__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmrealhours`;
CREATE FUNCTION `qc_pgmrealhours`($project int) RETURNS float(10,2)
BEGIN
  select CAST(sum(consumed) as DECIMAL(10,2)) as consumed from zt_task where project=$project and parent >= 0 and status != 'cancel' and deleted = '0' into @consumed__DELIMITER__
  return @consumed__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmrealhoursbytype`;
CREATE FUNCTION `qc_pgmrealhoursbytype`($project int, $type char(30)) RETURNS float(10,2)
BEGIN
  select CAST(sum(consumed) as DECIMAL(10,2)) as consumed from zt_task where project=$project and type = $type and parent >= 0 and status != 'cancel' and deleted = '0' into @consumed__DELIMITER__
  return @consumed__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmrequestrealesthours`;
CREATE FUNCTION `qc_pgmrequestrealesthours`($project int) RETURNS float(10,2)
BEGIN
return qc_pgmesthoursbytype($project, 'request')__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmrequestrealhours`;
CREATE FUNCTION `qc_pgmrequestrealhours`($project int) RETURNS float(10,2)
BEGIN
return qc_pgmrealhoursbytype($project, 'request')__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmtestrealesthours`;
CREATE FUNCTION `qc_pgmtestrealesthours`($project int) RETURNS float(10,2)
BEGIN
return qc_pgmesthoursbytype($project, 'test')__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmtestrealhours`;
CREATE FUNCTION `qc_pgmtestrealhours`($project int) RETURNS float(10,2)
BEGIN
return qc_pgmrealhoursbytype($project, 'test')__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_getdevelfirstesthours`;
CREATE FUNCTION `qc_getdevelfirstesthours`($project int) RETURNS float(10,2)
BEGIN
    SELECT sum(devEst) as estimate FROM zt_object WHERE id in(SELECT MIN(id) FROM zt_object WHERE project = $project and category = 'PP' and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__

    return @estimate__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_getdesignfirstesthours`;
CREATE FUNCTION `qc_getdesignfirstesthours`($project int) RETURNS float(10,2)
BEGIN
    SELECT sum(designEst) as estimate FROM zt_object WHERE id in(SELECT MIN(id) FROM zt_object WHERE project = $project and category = 'PP' and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__

    return @estimate__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_getstoryfirstesthours`;
CREATE FUNCTION `qc_getstoryfirstesthours`($project int) RETURNS float(10,2)
BEGIN
    SELECT sum(requestEst) as estimate FROM zt_object WHERE id in(SELECT MIN(id) FROM zt_object WHERE project = $project and category = 'PP' and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__

    return @estimate__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_gettestfirstesthours`;
CREATE FUNCTION `qc_gettestfirstesthours`($project int) RETURNS float(10,2)
BEGIN
    SELECT sum(testEst) as estimate FROM zt_object WHERE id in(SELECT MIN(id) FROM zt_object WHERE project = $project and category = 'PP' and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__

    return @estimate__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_getfirstesthours`;
CREATE FUNCTION `qc_getfirstesthours`($project int) RETURNS float(10,2)
BEGIN
    SELECT sum(taskEst) as estimate FROM zt_object WHERE id in(SELECT MIN(id) FROM zt_object WHERE project = $project and category = 'PP' and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__

    return @estimate__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_getdevlastesthours`;
CREATE FUNCTION `qc_getdevlastesthours`($project int) RETURNS float(10,2)
BEGIN
    SELECT sum(devEst) as estimate FROM zt_object WHERE id in(SELECT MAX(id) FROM zt_object WHERE project = $project and category = 'PP' and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__

    return @estimate__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_getrequestlastesthours`;
CREATE FUNCTION `qc_getrequestlastesthours`($project int) RETURNS float(10,2)
BEGIN
    SELECT sum(requestEst) as estimate FROM zt_object WHERE id in(SELECT MAX(id) FROM zt_object WHERE project = $project and category = 'PP' and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__

    return @estimate__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_gettestlastesthours`;
CREATE FUNCTION `qc_gettestlastesthours`($project int) RETURNS float(10,2)
BEGIN
    SELECT sum(testEst) as estimate FROM zt_object WHERE id in(SELECT MAX(id) FROM zt_object WHERE project = $project and category = 'PP' and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__

    return @estimate__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_getdesignlastesthours`;
CREATE FUNCTION `qc_getdesignlastesthours`($project int) RETURNS float(10,2)
BEGIN
    SELECT sum(designEst) as estimate FROM zt_object WHERE id in(SELECT MAX(id) FROM zt_object WHERE project = $project and category = 'PP' and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__

    return @estimate__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_getlastesthours`;
CREATE FUNCTION `qc_getlastesthours`($project int) RETURNS float(10,2)
BEGIN
    SELECT sum(taskEst) as estimate FROM zt_object WHERE id in(SELECT MAX(id) FROM zt_object WHERE project = $project and category = 'PP' and type = 'taged' and product in (select product from zt_projectproduct where project = $project) group by `product`) into @estimate__DELIMITER__

    return @estimate__DELIMITER__
END;

DROP FUNCTION IF EXISTS `qc_pgmlastesthours`;
CREATE FUNCTION `qc_pgmlastesthours`($project int) RETURNS float(10,2)
BEGIN
    declare estimate float(10,2) default 0__DELIMITER__
    declare inited int default 0__DELIMITER__
    select qc_cminited($project,'PP') into inited__DELIMITER__
    IF inited = 1 THEN
    select qc_getlastesthours($project) into estimate__DELIMITER__
    return estimate__DELIMITER__
    ELSE
    return 0__DELIMITER__
    END IF__DELIMITER__
END;
