<?php include $app->getModuleRoot() . 'common/view/header.html.php';?>
<?php $browseLink = inlink('browse');?>
<div id="mainMenu" class="clearfix">
  <div class="btn-toolbar pull-left">
    <?php echo html::backButton('<i class="icon icon-back icon-sm"></i>' . $lang->goback, '', 'btn btn-secondary')?>
    <div class="divider"></div>
    <div class="page-title">
      <span class="label label-id"><?php echo $review->id?></span>
      <span class="text"><?php echo $review->title . '<i class="icon-angle-right"></i> ' . $lang->review->report->common?></span>
    </div>
  </div>
</div>
<div class='main-row' id='mainContent'>
  <div class='main-col main-table'>
    <div class='cell'>
      <table class='table table-borderless'>
        <tr><th class='text-center' colspan='8'><?php echo $lang->review->explain;?></th></tr>
        <tr>
          <th><?php echo $lang->review->object;?></th>
          <td colspan='3'><?php echo zget($lang->baseline->objectList, $review->category);?></td>
          <th><?php echo $lang->review->reviewerCount;?></th>
          <td colspan='3'><?php echo count(explode(',', $review->reviewedBy));?></td>
        </tr>
        <tr>
          <th><?php echo $lang->review->reviewedDate;?></th>
          <td colspan='3'><?php echo $review->lastReviewedDate;?></td>
          <th><?php echo $lang->review->reviewedHours;?></th>
          <td colspan='3'>
          <?php
          $consumed = 0;
          foreach($results as $result) $consumed += $result->consumed;
          echo $consumed;
          ?>
          </td>
        </tr>
        <tr>
          <th><?php echo $lang->review->area;?></th>
          <td colspan='3'> </td>
          <th>
            <?php echo $lang->review->objectScale;?>
            <a data-toggle='tooltip' class='text-help' title='<?php echo $lang->review->objectScaleTip;?>'><i class='icon-help'></i></a>
          </th>
          <td colspan='3'><?php echo $objectScale;?></td>
        </tr>
        <tr>
          <th>
            <?php echo $lang->review->issueCount;?>
            <a data-toggle='tooltip' class='text-help' title='<?php echo $lang->review->issueCountTip;?>'><i class='icon-help'></i></a>
          </th>
          <td colspan='3'><?php echo count($issues);?></td>
          <th>
            <?php echo $lang->review->issueFoundRate;?>
            <a data-toggle='tooltip' class='text-help' title='<?php echo $lang->review->issueFoundRateTip;?>'><i class='icon-help'></i></a>
          </th>
          <td colspan='3'><?php echo $consumed == 0 ? 0 : round(count($issues) / $consumed, 2);?></td>
        </tr>
        <tr>
          <th>
            <?php echo $lang->review->issueRate;?>
            <a data-toggle='tooltip' class='text-help' title='<?php echo $lang->review->issueRateTip;?>'><i class='icon-help'></i></a>
          </th>
          <td colspan='7'><?php echo $objectScale == 0 ? 0 : round(count($issues) / $objectScale, 2);?></td>
        </tr>
        <tr><th class='text-center' colspan='8'><?php echo $lang->review->record;?></th></tr>
        <?php if(!empty($issues)):?>
        <tr>
          <th colspan='2'><?php echo $lang->idAB;?></th>
          <th colspan='2'><?php echo $lang->review->issues;?></th>
          <th colspan='2'><?php echo $lang->review->isIssue;?></th>
          <th colspan='2'><?php echo $lang->comment;?></th>
        </tr>
        <?php foreach($issues as $issue):?>
        <tr>
          <td colspan='2'><?php echo $issue->id;?></td>
          <td colspan='2'><?php echo $issue->title;?></td>
          <td colspan='2'><?php echo '';?></td>
          <td colspan='2'><?php echo $issue->opinion;?></td>
        </tr>
        <?php endforeach;?>
        <?php endif;?>
        <tr>
          <th class='text-center' colspan='6'><?php echo $lang->review->resultExplain;?></th>
          <th class='text-center' colspan='2'><?php echo $lang->review->result;?></th>
        </tr>
        <tr>
          <td colspan='6'><?php echo $lang->review->resultExplainList['pass'];?></td>
          <td rowspan='2' colspan='2' class="text-center status-<?php echo $review->result;?>" style='background: #e3f2fd;'><?php echo zget($lang->review->resultList, $review->result);?></td>
        </tr>
        <tr>
          <td colspan='6'><?php echo $lang->review->resultExplainList['fail'];?></td>
        </tr>
        <tr>
          <th><?php echo $lang->review->reportCreatedBy;?></th>
          <th colspan='3'><?php echo zget($users, $review->createdBy);?></th>
          <th><?php echo $lang->review->reportApprovedBy;?></th>
          <th colspan='3'>
            <?php
            $reviewedBy = explode(',', $review->reviewedBy);
            foreach($reviewedBy as $account)
            {
                $account = trim($account);
                if(empty($account)) continue;
                echo zget($users, $account) . " &nbsp;";
            }
            ?>
          </th>
        </tr>
      </table>
    </div>
    <!--div class='cell'>
      <table class='table table-borderless'>
        <tr><th class='text-center' colspan='10'><?php echo $lang->review->issue->summary;?></th></tr>
        <tr>
          <th><?php echo $lang->review->issue->id;?></th>
          <th><?php echo $lang->review->issue->desc;?></th>
          <th><?php echo $lang->review->issue->analyse;?></th>
          <th><?php echo $lang->review->issue->introAnalyse;?></th>
          <th><?php echo $lang->review->issue->resolvedBy;?></th>
          <th><?php echo $lang->review->issue->deadline;?></th>
          <th><?php echo $lang->review->issue->resolvedDate;?></th>
          <th><?php echo $lang->review->issue->severity;?></th>
          <th><?php echo $lang->review->issue->verifiedBy;?></th>
          <th><?php echo $lang->review->issue->status;?></th>
        </tr>
      </table>
    </div -->
  </div>
</div>
<?php include $app->getModuleRoot() . 'common/view/footer.html.php';?>
