<?php include $app->getModuleRoot() . 'common/view/header.html.php'?>
<?php $app->loadLang('approvalflow');?>
<?php js::set('nodes', $nodes);?>
<?php js::set('reviewers', $reviewers);?>
<?php js::set('users', $users);?>
<?php js::set('nodeLang', $lang->approval->nodeList);?>
<?php js::set('nodeTypeList', $lang->approvalflow->nodeTypeList);?>
<div id='mainContent' class='main-content'>
  <div class='center-block'>
    <div class='main-header'>
      <span class="text"><?php echo $lang->approval->progress;?></span>
    </div>
    <div id="graph">
      <div id="editor" class="editor-node branch">
         <div id="root" class="nodes"></div>
      </div>
    </div>
  </div>
</div>

<script>
$(document).ready(function()
{
    nodes = nodes;
    render(nodes, false);
});

function render(nodes)
{
    var offsetTop = $('#graph').scrollTop();

    $('#root').empty();

    var $root = $('#root');
    $root.append(renderNodes(nodes));
}

function renderNodes(nodes)
{
    var nodesText = '';
    for(let index in nodes)
    {
        var node = nodes[index];
        if(node.type == 'branch')
        {
            nodesText += renderBranch(node);
        }
        else
        {
            nodesText += renderNode(node);
        }
    }

    return nodesText;
}

function renderBranch(branch)
{
    var branchType = branch.branchType == 'parallel' ? 'addParallel' : 'addCondition';
    var branchesText = '<div data-id="' + branch.id + '" class="editor-node route">';
    var count = Object.keys(branch.branches).length;
    if(count > 1) branchesText += '<div class="top-h-line"></div>';

    var branches = '';

    /* Branches. */
    for(var index in branch.branches)
    {
        var nodes = branch.branches[index].nodes;

        branches += '<div data-id=' + branch.branches[index].id + ' class="editor-node branch">';
        if(count > 1) branches += '<div class="top-line-mask"></div>';
        branches += '<div class="top-v-line"></div>' +
            '<div class="nodes">' +
            '<div class="editor-node ' + (count > 1 ? '' : 'short') + ' condition"><div class="bottom-v-line"></div></div>';

        branches += renderNodes(nodes);
        branches += '</div><div class="bottom-v-line"></div>';
        if(count > 1) branches += '<div class="bottom-line-mask"></div>';
        branches += '</div>';
    }

    branches += '</div>';

    /* Bottom. */
    if(count > 1) branches += '<div class="bottom-h-line"></div><div class="bottom-v-line"></div>';

    branchesText += '<div class="branches">' + branches + '</div>';

    return branchesText;
}

function displayUsers(accounts)
{
    var names = [];
    for(let account of accounts)
    {
        names.push(typeof users[account] == 'undefined' ? account : users[account]);
    }
    return names.join(',');
}

function renderNode(node)
{
    var id    = typeof(node.id) == 'undefined' ? '' : node.id;
    var title = typeof(node.title) == 'undefined' ? nodeTypeList[node.type] : node.title;

    var content = '';
    var status  = '';
    if(typeof reviewers[node.id] == 'undefined')
    {
        content = title;
    }
    else
    {
        status = reviewers[node.id]['status'];
        if(reviewers[node.id]['reviewers'].length == 0)
        {
            content = nodeLang['cc'] + ': ' + displayUsers(reviewers[node.id]['ccs']);
        }
        else
        {
            if(reviewers[node.id]['doing'].length !== 0)
            {
                content = nodeLang['doing'] + ': ' + displayUsers(reviewers[node.id]['doing']);
            }
            else
            {
                content = nodeLang['review'] + ': ' + displayUsers(reviewers[node.id]['reviewers']);
            }
        }
    }

    $node  = '<div id="' + id + '" class="editor-node ' + status + ' ' + node.type + '">';
    $node += '<div class="editor-node-container">';
    $node += '<div class="node-content" title="' + title + '"><div class="node-detail">';
    $node += '<div class="node-detail-item">' + content + '</div></div></div>';
    $node += '</div>';

    if(node.type != 'end') $node += '<div class="bottom-v-line"></div>';
    $node += '</div>';

    return $node;
}
</script>
