<?php
/**
 * The browse of risk module of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2020 青岛易软天创网络科技有限公司(QingDao Nature Easy Soft Network Technology Co,LTD, www.cnezsoft.com)
 * @license     ZPL(http://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yuchun Li <liyuchun@cnezsoft.com>
 * @package     risk
 * @version     $Id: browse.html.php 4903 2020-09-04 09:32:59Z lyc $
 * @link        http://www.zentao.net
 */
?>
<?php include $app->getModuleRoot() . "common/view/header.html.php"?>
<style>
#querybox #searchform{border-bottom: 1px solid #ddd; margin-bottom: 20px;}
</style>
<div id="mainMenu" class="clearfix">
  <div class="btn-toobar pull-left">
    <?php
    $menus = customModel::getFeatureMenu($this->moduleName, $this->methodName);
    foreach($menus as $menuItem)
    {
        $active = $menuItem->name == $browseType ? ' btn-active-text' : '';
        echo html::a($this->createLink('risk', 'browse', "projectID=$projectID&from=$from&browseType=$menuItem->name"), "<span class='text'>{$menuItem->text}</span> " . ($browseType == $menuItem->name ? "<span class='label label-light label-badge'>{$pager->recTotal}</span>" : ''), '', "class='btn btn-link $active' data-app='{$app->tab}'");
    }
    ?>
    <a class="btn btn-link querybox-toggle" id='bysearchTab'><i class="icon icon-search muted"></i> <?php echo $lang->risk->byQuery;?></a>
  </div>
  <div class="btn-toolbar pull-right">
    <div class='btn-group'>
      <button type='button' class='btn btn-link dropdown-toggle' data-toggle='dropdown' id='importAction'><i class='icon icon-import muted'></i> <?php echo $lang->import;?><span class='caret'></span></button>
      <ul class='dropdown-menu pull-right' id='importActionMenu'>
      <?php
      $class = common::hasPriv('risk', 'importFromLib') ? '' : "class=disabled";
      $misc  = common::hasPriv('risk', 'importFromLib') ? "data-app='{$app->tab}'" : "class=disabled";
      $link  = common::hasPriv('risk', 'importFromLib') ? $this->createLink('risk', 'importFromLib', "projectID=$projectID&from=$from") : '#';
      echo "<li $class>" . html::a($link, $lang->risk->importFromLib, '', $misc) . "</li>";
      ?>
      </ul>
    </div>
    <div class='btn-group dropdown'>
      <?php
      if(common::hasPriv('risk', 'create'))
      {
          $actionLink = $this->createLink('risk', 'create', "projectID=$projectID&from=$from");
          echo html::a($actionLink, "<i class='icon icon-plus'></i> {$lang->risk->create}", '', "class='btn btn-primary' data-app='{$app->tab}'");
      }
      elseif(common::hasPriv('risk', 'batchCreate'))
      {
          $actionLink = $this->createLink('risk', 'batchCreate', "projectID=$projectID&from=$from");
          echo html::a($actionLink, "<i class='icon icon-plus'></i> {$lang->risk->batchCreate}", '', "class='btn btn-primary' data-app='{$app->tab}'");
      }
      ?>
      <?php if((common::hasPriv('risk', 'create')) and (common::hasPriv('risk', 'batchCreate'))):?>
      <button type='button' class='btn btn-primary dropdown-toggle' data-toggle='dropdown'><span class='caret'></span></button>
      <ul class='dropdown-menu pull-right'>
        <li><?php echo html::a($actionLink, $lang->risk->create, '', "data-app='{$app->tab}'");?></li>
        <li><?php echo html::a($this->createLink('risk', 'batchCreate', "projectID=$projectID&from=$from"), $lang->risk->batchCreate, '', "data-app='{$app->tab}'");?></li>
      </ul>
      <?php endif;?>
    </div>
  </div>
</div>
<div class="cell<?php if($browseType == 'bysearch') echo ' show';?>" id="queryBox" data-module='risk'></div>
<div id="mainContent" class="main-table">
  <?php if(empty($risks)):?>
  <div class="table-empty-tip">
    <p>
      <span class="text-muted"><?php echo $lang->noData;?></span>
      <?php if(common::hasPriv('risk', 'create')):?>
      <?php echo html::a($this->createLink('risk', 'create', "projectID=$projectID&from=$from"), "<i class='icon icon-plus'></i> " . $lang->risk->create, '', "class='btn btn-info' data-app='{$app->tab}'");?>
      <?php endif;?>
    </p>
  </div>
  <?php else:?>
  <form class="main-table table-risk" data-ride="table" method="post" id="riskForm">
    <table class="table has-sort-head" id='riskList'>
      <?php $canBatchImportToLib = common::hasPriv('risk', 'batchImportToLib'); ?>
      <?php $vars = "projectID=$projectID&from=$from&browseType=$browseType&param=$param&orderBy=%s&recTotal={$pager->recTotal}&recPerPage={$pager->recPerPage}";?>
      <thead>
        <tr>
          <th class='text-left w-90px'>
            <?php
            if($canBatchImportToLib) echo "<div class='checkbox-primary check-all' title='{$this->lang->selectAll}'><label></label></div>";
            common::printOrderLink('id', $orderBy, $vars, $lang->risk->id);
            ?>
          </th>
          <th class='text-left'><?php common::printOrderLink('name', $orderBy, $vars, $lang->risk->name);?></th>
          <th class='w-80px'><?php common::printOrderLink('strategy', $orderBy, $vars, $lang->risk->strategy);?></th>
          <th class='w-80px'><?php common::printOrderLink('status', $orderBy, $vars, $lang->risk->status);?></th>
          <th class='w-120px'><?php common::printOrderLink('identifiedDate', $orderBy, $vars, $lang->risk->identifiedDate);?></th>
          <th class='w-80px'><?php common::printOrderLink('rate', $orderBy, $vars, $lang->risk->rate);?></th>
          <th class='w-80px'><?php common::printOrderLink('pri', $orderBy, $vars, $lang->risk->pri);?></th>
          <th class='w-120px'><?php common::printOrderLink('assignedTo', $orderBy, $vars, $lang->risk->assignedTo);?></th>
          <th class='w-120px'><?php common::printOrderLink('category', $orderBy, $vars, $lang->risk->category);?></th>
          <th class='w-200px'><?php echo $lang->actions;?></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($risks as $risk):?>
        <tr>
          <td>
            <?php echo $canBatchImportToLib ? html::checkbox('riskIDList', array($risk->id => '')) . sprintf('%03d',$risk->id) : sprintf('%03d',$risk->id);?>
          </td>
          <td class='c-name' title=<?php echo $risk->name;?>><?php echo html::a($this->createLink('risk', 'view', "riskID=$risk->id&from=$from"), $risk->name, '', "data-app='{$app->tab}'");?></td>
          <td><?php echo zget($lang->risk->strategyList, $risk->strategy);?></td>
          <td><?php echo zget($lang->risk->statusList, $risk->status);?></td>
          <td><?php echo $risk->identifiedDate == '0000-00-00' ? '' : $risk->identifiedDate;?></td>
          <td><?php echo $risk->rate;?></td>
          <td><?php echo "<span class='pri-{$risk->pri}'>" . zget($lang->risk->priList, $risk->pri) . "</span>";?></td>
          <td><?php echo $this->risk->printAssignedHtml($risk, $users);;?></td>
          <td><?php echo zget($lang->risk->categoryList, $risk->category);?></td>
          <td class='c-actions'>
            <?php
            $params = "riskID=$risk->id";
            common::printIcon('risk', 'track', $params, $risk, "list", 'checked', '', 'iframe', true);
            common::printIcon('risk', 'close', $params, $risk, "list", '', '', 'iframe', true);
            common::printIcon('risk', 'cancel', $params, $risk, "list", '', '', 'iframe', true);
            common::printIcon('risk', 'hangup', $params, $risk, "list", 'arrow-up', '', 'iframe', true);
            common::printIcon('risk', 'activate', $params, $risk, "list", '', '', 'iframe', true);
            common::printIcon('effort', 'createForObject', "objectType=risk&objectID=$risk->id", '', 'list', 'time', '', 'iframe', true, '', $lang->risk->effort);
            common::printIcon('risk', 'edit', $params . "&from=$from", $risk, "list");
            ?>
          </td>
        </tr>
        <?php endforeach;?>
      </tbody>
    </table>
    <div class='table-footer'>
      <?php if($canBatchImportToLib):?>
      <div class="checkbox-primary check-all"><label><?php echo $lang->selectAll?></label></div>
      <div class="table-actions btn-toolbar">
      <?php echo html::a('#batchImportToLib', $lang->risk->importToLib, '', 'class="btn" data-toggle="modal" id="importToLib"');?>
      </div>
      <?php endif;?>
      <?php $pager->show('right', 'pagerjs');?>
    </div>
  <?php endif;?>
  </form>
</div>

<div class="modal fade" id="batchImportToLib">
  <div class="modal-dialog mw-500px">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="icon icon-close"></i></button>
        <h4 class="modal-title"><?php echo $lang->risk->importToLib;?></h4>
      </div>
      <div class="modal-body">
        <form method='post' class='form-ajax' action='<?php echo $this->createLink('risk', 'batchImportToLib');?>'>
          <table class='table table-form'>
            <tr>
              <th><?php echo $lang->risk->lib;?></th>
              <td>
                <?php echo html::select('lib', $libs, '', "class='form-control chosen' required");?>
              </td>
            </tr>
            <?php if(!common::hasPriv('assetlib', 'approveIssue') and !common::hasPriv('assetlib', 'batchApproveIssue')):?>
            <tr>
              <th><?php echo $lang->risk->approver;?></th>
              <td>
                <?php echo html::select('assignedTo', $approvers, '', "class='form-control chosen'");?>
              </td>
            </tr>
            <?php endif;?>
            <tr>
              <td colspan='2' class='text-center'>
                <?php echo html::hidden('riskIDList', '');?>
                <?php echo html::submitButton($lang->import, '', 'btn btn-primary');?>
              </td>
            </tr>
          </table>
        </form>
      </div>
    </div>
  </div>
</div>
<?php include $app->getModuleRoot() . "common/view/footer.html.php"?>
