/**
 * Load product executions.
 *
 * @param  int $productID
 * @access public
 * @return void
 */
function loadProductExecutions(productID)
{
    var link = createLink('product', 'ajaxGetExecutions', 'productID=' + productID + '&project=0&branch=0&number=&executionID=' + $('#executionIdBox #execution').val());

    $.get(link, function(data)
    {
        $('#executionIdBox select').replaceWith(data);
        $('#executionIdBox .chosen-container').remove();
        $('#executionIdBox select').chosen();
    });
}

/**
 * Load dept users.
 *
 * @param  int $deptID
 * @access public
 * @return void
 */
function loadDeptUsers(deptID)
{
    var link = createLink('dept', 'ajaxGetUsers', 'dept=' + deptID + '&user=' + $('#userBox #user').val() + '&key=id');

    $.get(link, function(data)
    {
        $('#userBox select').replaceWith(data);
        $('#userBox .chosen-container').remove();
        $('#userBox select').chosen();
    })
}

/**
 * Flush width.
 *
 * @param  object $obj
 * @access public
 * @return void
 */
function flushWidth(obj)
{
    var maxWidth = 0;
    $(obj).find('.input-group').each(function()
    {
        var $groupAddon = $(this).find('.input-group-addon:first');
        if($groupAddon.length > 0)
        {
            var width = $(this).find('.input-group-addon:first').outerWidth();
            if(width > maxWidth) maxWidth = width;
        }
    });
    $(obj).find('.input-group').each(function()
    {
        var $groupAddon = $(this).find('.input-group-addon:first');
        var padding     = 1;
        if($groupAddon.length > 0)
        {
            while($groupAddon.outerWidth() < maxWidth)
            {
                $groupAddon.css('padding-right', padding + 'px').css('padding-left', padding + 'px');
                padding++;
            }
        }
    });
}
