<?php
error_reporting(0);
if(isset($_GET['mode'])) header('Content-type: image/svg+xml');
$acceptLang = stripos($_SERVER['HTTP_ACCEPT_LANGUAGE'], 'zh-CN') !== false ? 'cn' : 'en';
$acceptLang = isset($_GET['lang']) ? $_GET['lang'] : $acceptLang;
$acceptLang = htmlspecialchars($acceptLang, ENT_QUOTES);

function connectDB($params)
{
    try
    {
        if(!isset($params->emulatePrepare) and PHP_OS == 'Linux') $params->emulatePrepare = true;
        if(!isset($params->bufferQuery) and PHP_OS == 'Linux')    $params->bufferQuery = true;

        $dsn = "{$params->driver}:host={$params->host};port={$params->port};dbname={$params->name}";
        $dbh = new PDO($dsn, $params->user, $params->password);
        $dbh->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_OBJ);
        $dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $dbh->setAttribute(PDO::ATTR_ORACLE_NULLS, PDO::NULL_TO_STRING);
        $dbh->exec("SET NAMES {$params->encoding}");

        if(isset($params->strictMode) and !$params->strictMode) $dbh->exec("SET @@sql_mode= ''");
        if(isset($params->emulatePrepare)) $dbh->setAttribute(PDO::ATTR_EMULATE_PREPARES, $params->emulatePrepare);
        if(isset($params->bufferQuery))    $dbh->setAttribute(PDO::MYSQL_ATTR_USE_BUFFERED_QUERY, $params->bufferQuery);

        return $dbh;
    }
    catch(EndResponseException $exception){}
}

function checkSafeFile()
{
    $statusFile = __DIR__ . DIRECTORY_SEPARATOR . 'ok.txt';
    return (!is_file($statusFile) or (time() - filemtime($statusFile)) > 300) ? $statusFile : false;
}

function checkUpgradeStatus()
{
    $statusFile = checkSafeFile();
    if($statusFile)
    {
        $safeFile = str_replace(dirname(__DIR__, 3) . DIRECTORY_SEPARATOR, '', $statusFile);

        echo "<html><head><meta http-equiv='Content-Type' content='text/html; charset=utf-8' /></head><body>";
        echo "<table align='center' style='margin-top:100px; border:1px solid gray; font-size:14px;padding:8px;'><tr><td>";
        echo "<h4>安全起见，请先完成下面的操作：</h4>";
        echo "<p style='font-size:13px;'>";
        if(is_file($statusFile)) echo "删掉 <strong style='color:#ed980f'>{$safeFile}</strong> 这个文件，重新";
        echo "创建 <strong style='color:#ed980f'>{$safeFile}</strong> 空文件。</p>";
        echo "<p><strong style='color:red'>我已经仔细阅读上面提示且完成上述工作，<a href='#' onclick='location.reload()'>刷新</a></strong></p>";
        echo '</td></tr></table></body></html>';
        exit;
    }
}
if(!empty($_GET['change'])) checkUpgradeStatus();

$zentaoBasePath = dirname(__FILE__, 2) . '/zentao/';
$config = new stdclass();
include $zentaoBasePath . 'config/config.php';

$dbh = connectDB($config->db);
$currentEdition = $config->edition;
$initEdition    = false;
if($dbh) $initEdition = $dbh->query("SELECT * FROM " . TABLE_CONFIG . " WHERE `owner` = 'system' AND `module` = 'common' AND `section` = 'global' AND `key` = 'initEdition'")->fetch();
if(!empty($_GET['edition']))
{
    $version = $config->version;
    if(!in_array($_GET['edition'], array('open', 'biz', 'max', 'ipd'))) die('Error edition value.');
    if($_GET['edition'] != $currentEdition)
    {
        include $zentaoBasePath . 'module/upgrade/config.php';
        end($config->upgrade->ipdVersion);
        end($config->upgrade->maxVersion);

        $openVersion = str_replace('_', '.', end($config->upgrade->bizVersion));
        $bizVersion  = str_replace('_', '.', key($config->upgrade->bizVersion));
        $maxVersion  = str_replace('_', '.', key($config->upgrade->maxVersion));
        $ipdVersion  = str_replace('_', '.', key($config->upgrade->ipdVersion));
        $version = ${$_GET['edition'] . 'Version'};

        $dbh->exec("UPDATE " . TABLE_CONFIG . " SET `value` = '{$version}' WHERE `owner` = 'system' AND `module` = 'common' AND `section` = 'global' AND `key` = 'version'");
        file_put_contents($zentaoBasePath . 'config/ext/edition.php', "<?php\n\$config->edition = '{$_GET['edition']}';");
        sleep(3);
    }
    $dbh->exec("REPLACE INTO " . TABLE_CONFIG . " SET `owner` = 'system', `module` = 'common', `section` = 'global', `key` = 'initEdition', `value` = '1'");
    header("location: /zentao/");
    exit;
}

if(isset($_GET['mode']) and $_GET['mode'] == 'getlogo')
{
    die(base64_decode('PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz48c3ZnIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiIHZpZXdCb3g9IjAgMCA5ODAuNzIgMzA2LjE4Ij48ZGVmcz48c3R5bGU+LmNscy0xLC5jbHMtMntmaWxsOiNmZmY7fS5jbHMtM3tpc29sYXRpb246aXNvbGF0ZTt9LmNscy0ye21peC1ibGVuZC1tb2RlOnNjcmVlbjt9LmNscy0yLC5jbHMtNHtmaWxsLXJ1bGU6ZXZlbm9kZDt9LmNscy01LC5jbHMtNHtmaWxsOiMyMjE3MTQ7fS5jbHMtNntmaWxsOnVybCgjX+WRveWQjeeahOa4kOWPmF8yKTt9LmNscy03e2ZpbGw6IzA4NDQ3Zjt9PC9zdHlsZT48bGluZWFyR3JhZGllbnQgaWQ9Il/lkb3lkI3nmoTmuJDlj5hfMiIgeDE9IjE1My4wOSIgeTE9IjMwNi4xOCIgeDI9IjE1My4wOSIgeTI9IjAiIGdyYWRpZW50VHJhbnNmb3JtPSJtYXRyaXgoMSwgMCwgMCwgMSwgMCwgMCkiIGdyYWRpZW50VW5pdHM9InVzZXJTcGFjZU9uVXNlIj48c3RvcCBvZmZzZXQ9IjAiIHN0b3AtY29sb3I9IiMyOTc1ZmUiLz48c3RvcCBvZmZzZXQ9IjEiIHN0b3AtY29sb3I9IiMwY2Q1ZmYiLz48L2xpbmVhckdyYWRpZW50PjwvZGVmcz48ZyBjbGFzcz0iY2xzLTMiPjxnIGlkPSJf5bGCXzIiPjxnIGlkPSJf5bGCXzEtMiI+PGc+PHBhdGggY2xhc3M9ImNscy03IiBkPSJNODg4LjU3LDU2LjU2Yy0uMjctLjA1LTEsMS4yMi0xLjE2LDIuNDgtLjMyLDIuMzYtLjMxLDQuODEtLjUxLDcuMTgtLjA4LC44OC0uMjYsMS44NC0uNDYsMi42Mi0uMDMsLjEzLS4zNCwuMDQtLjQyLS4wNC0uMDctLjA3LS4yNC0uMzktLjIzLS42MSwuMTgtMy4wNiwwLTUuNywuMzYtOC45LC4zNy0zLjIsMi4xMS01Ljg0LDQuODItNy45MiwxLjMtLjk5LDIuNTgtMS4wOCw0LjUtMS4xMnM1LjI5LS4yNyw3LjMtLjQzYzItLjE2LDMuNi0uMzcsNS40My0uNTIsNC43OC0uMzcsOS40Ni0uNjksMTQuMjEtMS4wNSwuNjYtLjA1LDEuMzYtLjE1LDEuOTgtLjMsNS4wMi0xLjI1LDkuMzMtLjE4LDE0LjE5LDEuMTQsMS41MSwuNDEsMi45MSwuMzcsNC40MywuMiwzLjQ3LS4zOCw2LjUzLS40NSw5LjYzLDEuMzUsLjMsLjE4LC43NywuMjUsMS4xMiwuMjgsNi43NCwuNjIsMTEuMTksLjg5LDE1LjAzLDEuODcsNS4xMywxLjMsOS42OCw1Ljk1LDExLjI4LDExLjEyLDEuODMsNS45MS0uNjIsMTEuMTctMS4zNiwxMi43NS0yLjU5LDUuNTUtNy40Niw4LjkzLTEwLjI4LDEwLjg4LS44MywuNTgtMi44OSwxLjkyLTQuNywzLjA4LTIsMS4yOC0zLjAzLDEuODktMy41MywyLjE1LTIuNjMsMS4zNS01LjExLC43My04LjE4LC40Mi0zLjA2LS4zMS02LjE0LS41LTkuNDQtLjI4LTQuNCwuMjktOS4wNiwuODgtMTMuNiwxLjUtMi4xOCwuMy00LjU5LC40NS02LjkxLC43NS0yLjMyLC4zLTQuODcsLjI3LTcuMTUsLjE0LS4wOSwwLS4yMiwuMzMtLjE0LC41OSwuMjUsLjg1LDIuODgsLjc3LDQuODYsLjcsMi45MS0uMTEsNS4xMy0uNTMsNS4xNy0uMzIsLjAyLC4wOC0uMywuMjEtLjM5LC4yNS0yLjcsMS4xLTUuNjMsMS4xNy01LjYzLDEuMTctMy4wOCwuMDctNC42MywuMS02LjkyLS4yMy0uNDctLjA3LTEuNTctLjIzLTMuOTktLjgyLTUuNjMtMS4zNy04LjQ1LTIuMDYtMTAuNjItMy42MS0yLjA2LTEuNDctMy40NC0yLjk1LTQuMzQtNC44Mi0xLjM0LTIuODItMi45NC01LjgzLTMuNzEtOC44NC0uNS0xLjk1LS41Ny00LjMyLS40Ni02LjA1LC4xLTEuNzItLjA5LTMuMy0uMDctNC42LC4wMi0xLjMsLjM2LTIuNjQsLjQ5LTMuNCwuMTItLjc3LC40LS44NiwuMjktMS4yLS4xOC0uNTUtLjU1LTMuMDQtLjY5LTQuNzMtLjE2LTEuOTEsLjAzLTIuNzctLjE4LTIuODJaIi8+PHBhdGggY2xhc3M9ImNscy03IiBkPSJNOTMxLjc0LDQ2LjM5Yy4zOC0uMDgsMS40Mi0uMiwyLjE2LS4xOSw3LjQ3LC4wNSwxNS4xMSwuNTQsMjIuNTksMS40OCwxLjY4LC4yMSwzLjY1LC45OCw1LjEsMS41MywuMjEsLjA4LDAsLjU4LS4zMywuNjMtLjMzLC4wNS0xLjU4LC4wNC0yLjI2LS4wNy00LjA4LS42MS04LjM2LTEuMzItMTIuNDUtMS45OC0xLjA5LS4xOC0yLjI0LS4yNy0zLjIzLS4wNi0zLjgxLC44Mi03LjIxLS43LTEwLjk3LS41OC0uMjUsMC0uNzItLjI1LS43NC0uMzctLjAyLS4xMi0uMjYtLjMyLC4xMy0uNDFaIi8+PHBhdGggY2xhc3M9ImNscy03IiBkPSJNOTYxLjA1LDk1LjI0Yy0uMjYsLjE3LTEuMTgsLjU4LTEuODIsLjYyLTMuMDksLjE5LTYuMTcsLjI5LTkuMzQsLjYxLTEuODEsLjE4LTMuODYtLjItNS42Ni0uNjEtMS44LS40MS0zLjMtLjg0LTUuMTgtLjUxLS4yOSwuMDUtLjk2LC4wMy0xLjMsMCwxLjAyLS44NiwyLjItMS4yNywzLjQ5LTEuMjgsMS4yOS0uMDEsMi41MiwuMzEsMy43MSwuMzYsNSwuMjIsOS44OSwxLjA1LDE0Ljc5LC41NiwuNDctLjA1LDEuMTEtLjI5LDEuMjktLjIzLC4xOCwuMDYsLjMsLjMsLjA0LC40N1oiLz48cGF0aCBjbGFzcz0iY2xzLTciIGQ9Ik04OTMuMTksNDguNjJjMy40NS0xLjMsNi4yNS0zLjA5LDEwLjA2LTIuNzYsMS4xMywuMSwyLjQ0LC4yNCwzLjU0LC4zNiwuMzEsLjAzLC44NiwuMzUsLjg2LC41MSwwLC4xNi0uNTQsLjQ3LS44NSwuNS0yLjg4LC4yOS01Ljg4LC40Ny04Ljc5LC43Ni0uODIsLjA4LTEuNjUsLjQ2LTIuNDIsLjY0LS43NywuMTgtMS41MiwuMzctMi4yMywuNDUtLjE3LC4wMi0uMDYtLjQxLS4xOC0uNDdaIi8+PHBhdGggY2xhc3M9ImNscy03IiBkPSJNOTEwLjQyLDQ2LjU2YzEuNjksLjA2LDMuMzcsLjEyLDUuMDUsLjE4LTEuNTIsLjkyLTMuNTYsLjY2LTUuMDUtLjE4WiIvPjxnPjxwYXRoIGNsYXNzPSJjbHMtMSIgZD0iTTkxMC4xNCw1OS41NmMtLjE4LS4xNS0uNDEtLjMxLS42OS0uNDYtLjI1LS4xNC0uNTEtLjI1LS43Ni0uMy0uMDUtLjAxLS4xLS4wMS0uMTcsMC0uMDYsMC0uMTMsLjAzLS4yMSwuMDYtLjA5LC4wNC0uMTYsLjA3LS4xOSwuMDgtLjI1LC4xMS0uNDUsLjE5LS42LC4yMi0uNTYsLjE5LTEuMTUsLjM0LTEuNzUsLjQ3bC0uMjQsLjA1LC4xLS4yM2MuMzMtLjc1LC41OS0xLjQ0LC43Ni0yLjA0LC4wMy0uMDcsLjA5LS4yMiwuMTktLjQ3LC4wNS0uMDksLjA5LS4xOSwuMTQtLjMxLC4wMy0uMSwuMDQtLjE4LC4wNC0uMjUsMC0uMTctLjA4LS4zMy0uMjQtLjQ5LS4xNy0uMTYtLjM4LS4zLS42My0uNHMtLjQ4LS4xNS0uNjktLjE1Yy0uMTYsMC0uMiwuMDEtLjIxLC4wMi0uMDQsLjAxLS4wNywuMDItLjA3LC4xLDAsLjA2LC4wMSwuMTQsLjAyLC4yMywuMDIsLjExLC4wMywuMjEsLjAzLC4yOSwwLC40NC0uMTQsMS4xOC0uNDEsMi4yMS0uMjYsMS4wMy0uNiwyLjA1LS45OSwzLjAzbC0uMDksLjIyLS4xMy0uMTljLS4wOS0uMTMtLjE5LS4yNC0uMjktLjMyLS4xNi0uMTQtLjMxLS4yMS0uNDctLjIxLS4wMiwwLS4wNywuMDEtLjE1LC4wM2gtLjAzcy0uMSwuMDQtLjIyLC4wOGwtLjE2LC4wNXYtLjE3YzAtLjE3LS4wNS0uMjgtLjE0LS4zMy0uMTUtLjEtLjMyLS4xOC0uNS0uMjMtLjE5LS4wNi0uNDUtLjA5LS43Ny0uMTEtLjA4LDAtLjEyLDAtLjE2LC4wMy0uMDQsLjA0LS4wNSwuMDgtLjA1LC4xMnYxLjJsLS4wOSwuMDNjLS43OCwuMjUtLjk4LC4yOS0xLjA3LC4zbC0uMjQsLjAyLC4xMi0uMmMuMjUtLjQ0LC41OS0xLjA4LDEtMS44NGwuMDItLjA1aC4wNWMuMTctLjA2LC4zMy0uMSwuNTEtLjE2LC4xNy0uMDUsLjM0LS4wOSwuNTEtLjE0LC44Mi0uMjMsMS40NS0uNDEsMS43My0uNDgsLjEyLS4wMiwuMTQtLjA3LC4xNC0uMTUsMC0uMDYtLjAzLS4xMy0uMDgtLjItLjE4LS4yNC0uMzYtLjQzLS41My0uNTctLjExLS4xLS4yNy0uMTQtLjQ3LS4xNC0uMTMsMC0uMjQsLjAxLS4zNCwuMDUtLjA1LC4wMS0uMTgsLjA1LS40LC4xMmwtLjMxLC4xMSwuMTctLjI5Yy4yNC0uNDMsLjQtLjcxLC41Mi0uODhzLjIxLS4zMSwuMjYtLjQyYy4wNS0uMDgsLjA3LS4xNywuMDctLjI0LDAtLjA5LS4wMi0uMTYtLjA2LS4yMy0uMDktLjE3LS4yMy0uMzQtLjQ0LS41Mi0uMjItLjE5LS40Ny0uMzYtLjc0LS41LS4wOS0uMDUtLjE3LS4wOC0uMjQtLjA4LS4wNSwwLS4xOCwwLS4yMiwuMzQtLjAyLC4yMy0uMDUsLjUtLjA5LC43OS0uMDUsLjMtLjA5LC41Mi0uMTMsLjY2LS4yMSwuNjQtLjQyLDEuMjMtLjYzLDEuNzhsLS4wMiwuMDYtLjA2LC4wMmMtLjI2LC4wNy0uNDksLjE0LS42OCwuMmwtMS4wNywuM2MtLjA3LC4wMi0uMSwuMDMtLjEyLC4wNHYuMDNjLjEzLC4yNywuMzQsLjUsLjY1LC43LC4xLC4wNSwuMTksLjA4LC4yNSwuMSwuMDYsLjAxLC4xNCwuMDIsLjI0LC4wMWwuMjItLjAyLS4xLC4yYy0uMzgsLjc0LS43MywxLjMyLTEuMDgsMS43NS0uMDIsLjAzLS4wMywuMDctLjAzLC4xMiwwLC4wMywuMDEsLjA3LC4wMiwuMTMsLjE4LC4zNywuNDEsLjY3LC42OSwuODcsLjA2LC4wNSwuMTEsLjA3LC4xOCwuMDcsLjAyLDAsLjA5LDAsLjI1LS4wNywuNTEtLjE2LC44NC0uMjUsMS4wMy0uM2wuNjEtLjE5di4xN2MwLC44LS4wMSwxLjMxLS4wMiwxLjY2di4wOWwtLjA4LC4wMmMtMS4yMywuNDMtMi4yLC42Ny0yLjg4LC43MS0uMSwwLS4zMiwuMDItLjMyLC4xMSwwLC4wMywuMDIsLjEsLjA2LC4xOSwuMDIsLjAzLC4xLC4yLC4yNSwuNDdzLjMyLC40OCwuNTIsLjY1Yy4yMywuMTYsLjQ0LC4xNSwuNzYtLjA3bDEuNjctMS4xNnYuMjVjLS4wMywuODUtLjA3LDEuNDYtLjEyLDEuODctLjAzLC4yNSwuMDEsLjQ4LC4xMiwuNjlzLjI1LC4zOCwuNDMsLjUyYy4zOCwuMjcsLjY5LC4yNCwuODYtLjA3LC4xLS4xOCwuMTUtLjQ1LC4xNS0uNzh2LTEuMjNjLS4wMS0uNzMsMC0xLjQ2LC4wMy0yLjE2di0uMDZsMS40OS0xLjAxLTEuNDgsLjUyLC4xMS0xLjgxLC4wOS0uMDJjLjUzLS4xMywuODktLjIyLDEuMDUtLjI1bC4yMy0uMDQtLjA5LC4yMWMtLjA2LC4xNS0uMjEsLjQ1LS40MywuODgtLjAzLC4wNy0uMDMsLjExLS4wMywuMTIsLjA2LDAsLjEsMCwuMTUtLjA0LC43LS40MiwxLjM5LTEuMTcsMi4wNC0yLjIzbC4wNi0uMSwuMywuMTdjLjA3LC4wNCwuMTksLjA2LC4zNCwuMDYsLjA1LDAsLjE2LS4wMSwuMzctLjAzbC44Mi0uMmMuNTItLjE0LC45LS4yMywxLjA0LS4yNSwuMTItLjAzLC4yNC0uMDIsLjMzLC4wNSwuMSwuMDYsLjE1LC4xNSwuMTUsLjI2bC0uMDIsLjA5LS4xNCwuMzJjLS4xNywuMzctLjMxLC42Ni0uNDMsLjg1LS4wMiwuMDMtLjAzLC4wNS0uMDQsLjA2LC4xLDAsLjE5LS4wMywuMzEtLjExLC4zMi0uMjEsLjctLjQ0LDEuMTgtLjcsLjQ5LS4yNywuODQtLjQ0LDEuMTMtLjU1LC4yNS0uMSwuMjgtLjIyLC4yOC0uMzFzLS4wNy0uMzItLjUxLS43N1ptMS4xNSw4Ljg0Yy0uNTMtLjI3LTEuMTktLjc5LTEuOTYtMS41NS0uMzItLjI5LS42Ny0uNjYtMS4wNi0xLjExLS4zNS0uNC0uNjktLjgyLTEuMDItMS4yNmwtLjEtLjEyYy0uMjUtLjM0LS40LS41My0uNDQtLjZsLS4xNi0uMTl2LS4wNmMuMDYtLjI2LC4xNC0uNTgsLjI1LS45MywuMDYtLjIyLC4wOS0uMzgsLjA5LS40NywwLS4xMy0uMDYtLjI1LS4xNy0uMzYtLjE4LS4xNS0uMzYtLjI4LS41My0uMzgtLjE1LS4wOS0uMzktLjE1LS43Mi0uMmgtLjFjLS4wNiwwLS4wOSwwLS4xMiwuMDMtLjAzLC4wMy0uMDQsLjEyLS4wMiwuMjQsLjAzLC4xNywuMDUsLjMyLC4wNSwuNDUsMCwuMTgtLjA0LC40Ny0uMTEsLjg2LS4xMywuNjQtLjM1LDEuMzgtLjY2LDIuMjFzLS43MiwxLjYzLTEuMjMsMi40LTEuMSwxLjM5LTEuNzYsMS44M2MtLjA1LC4wNC0uMDcsLjA3LS4wNywuMTIsMCwuMDMsLjAxLC4wNSwuMDMsLjA3cy4wMywuMDQsLjEsLjAyYzEuMDgtLjM4LDIuMDEtLjk3LDIuNzYtMS43NXMxLjM0LTEuNjgsMS43Ni0yLjY4bC4xMS0uMjUsLjE4LC4zN2MuMTksLjM3LC40MSwuODIsLjY0LDEuMzEsLjUsMS4wNiwuODYsMS43MiwxLjA2LDEuOTcsLjM1LC40MSwuODksLjYxLDEuNiwuNjEsLjM1LDAsLjgzLS4xLDEuNDMtLjMsLjEtLjA0LC4xOC0uMDgsLjIyLS4xMywuMDQtLjAzLC4wNi0uMDYsLjA2LS4wNywwLS4wMi0uMDQtLjA2LS4xMS0uMDhaIi8+PHBhdGggY2xhc3M9ImNscy0xIiBkPSJNOTE4LjA2LDU2LjQ5Yy0uMDUtLjEtLjA5LS4xNi0uMTMtLjItLjIzLS4yNC0uNTgtLjQ3LTEuMDQtLjcyLS40Ni0uMjQtLjgxLS4zNi0xLjA1LS4zNi0uMDUsMC0uMDgsMC0uMDksLjAyLS4wMSwuMDItLjAyLC4wNSwwLC4xMSwuMDMsLjE3LC4wNSwuMzUsLjA1LC41NCwwLC4yMS0uMDIsLjQyLS4wNSwuNjMtLjIxLDEuMzgtLjY3LDIuNzQtMS4zNSw0LjA1LS42OCwxLjMyLTEuNjIsMi41Ni0yLjc5LDMuNjlsLS4wMywuMDNzLjAyLDAsLjAzLS4wMWMxLjI4LS40MywyLjM4LTEuMTMsMy4yNy0yLjA3bC4yLS4yMSwuMDIsLjI5YzAsLjE3LDAsLjQ1LDAsLjg5LDAsMS42MS0uMDgsMy4wNy0uMjUsNC4zMy0uMDIsLjE3LC4wMiwuMzgsLjEyLC42M3MuMjMsLjQ5LC4zOSwuN2MuMTgsLjI0LC4zMiwuMzMsLjQxLC4zNiwuMDgsLjAzLC4xNSwuMDQsLjIyLC4wNCwuMTMsMCwuNTEsMCwuNi0uOTgsLjAzLS4zNCwuMDQtLjg0LC4wNC0xLjVzMC0xLjIyLS4wMS0xLjU5bC0uMDItMS42MWMwLS40NywuMDEtLjksLjAzLTEuMzIsLjAzLS42MSwuMDQtLjc0LC4wNS0uNzksLjA0LS4yLS4wMy0uMjctLjExLS4zMS0uMDUtLjAzLS4xOC0uMDgtLjUyLS4xNGwtLjE5LS4wNCwuMTEtLjE2Yy4yNi0uNCwuNTktLjk4LC45Ny0xLjczLC4yMS0uNDQsLjM3LS43NCwuNDktLjkzLC4xOS0uMjksLjM3LS41OCwuNTQtLjg5LC4xLS4xNiwuMTUtLjMxLC4xNS0uNDUsMC0uMTEtLjAzLS4yMi0uMDctLjNabTguMTUsNi4zOGMtLjE4LS40LS41My0uNzMtMS4wNC0uOTctLjE3LS4wOC0uNDQtLjA3LS43MSwuMDMtLjU1LC4xNS0xLjE1LC4yOC0xLjc5LC40bC0uMTQsLjAzdi0uMTVjMC0uNTUtLjAyLTEuMzEtLjAyLTIuMjh2LS4xMWguMWMuOTUtLjE5LDEuNTktLjMzLDEuOTYtLjQ0LC4wNi0uMDIsLjExLS4wNSwuMTQtLjA5cy4wNS0uMDgsLjA1LS4xM2MwLS4wNy0uMDItLjEtLjAzLS4xMi0uMTctLjI3LS40My0uNTItLjc5LS43NC0uMTctLjEyLS40Mi0uMTEtLjY3LS4wM2gwYy0uMDksLjAzLS4yNywuMDctLjU5LC4xNmwtLjE5LC4wNSwuMDQtLjJoLS4xMmwuMTItLjA1Yy4wMS0uMDUsLjAxLS4xMiwuMDEtLjIxLC4wMy0uODcsLjA4LTEuNjMsLjE1LTIuMjQsMC0uMTItLjEtLjIzLS4zLS4zNC0uMjMtLjEyLS41MS0uMjEtLjg0LS4yNy0uMzItLjA1LS41Ny0uMDctLjc0LS4wNS0uMDcsMC0uMTEsLjA0LS4xMSwuMTZsLjAyLC4xMWMuMDYsLjMsLjEyLC42OCwuMTYsMS4xMiwuMDQsLjQ3LC4wNiwuODcsLjA2LDEuMjV2MS4xOWwtLjk3LC4zMywuMzEtLjUzYy4wOS0uMTYsLjExLS4yNSwuMTEtLjI5LDAtLjA3LS4wMi0uMTItLjA4LS4xNmwtLjAyLS4wM2MtLjE0LS4xNy0uMzItLjMzLS41My0uNDhzLS40Ni0uMjctLjcyLS4zNWMtLjA2LS4wMi0uMS0uMDMtLjEyLS4wMy0uMDMsMC0uMDgsMC0uMDksLjEzLS4wNSwuNjUtLjI2LDEuNDctLjY0LDIuNDEtLjM3LC45NS0uNzgsMS43My0xLjIxLDIuMzItLjA0LC4wNC0uMDYsLjA4LS4wNiwuMTQsLjAyLC4wMiwuMDIsLjA4LC4zMi0uMDgsLjQtLjI1LC44My0uNiwxLjI3LTEuMDQsLjQzLS40NSwuODMtLjk1LDEuMjMtMS41NmwuMDktLjE0LC4xMSwuMTRjLjA5LC4xLC4yMSwuMiwuMzUsLjI3LC4xNywuMTEsLjM1LC4xNSwuNTQsLjEzaC4xM3YuMTJjLjAyLC40NCwuMDIsMS4xMywuMDIsMi4yN3YuMTFoLS4xMWMtMS4wNiwuMTUtMi4xOSwuMj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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'));
}
if(isset($_GET['mode']) and $_GET['mode'] == 'getqucheng')
{
    if($acceptLang == 'en') die(base64_decode('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'));
    die(base64_decode('PHN2ZyB3aWR0aD0iMTU1IiBoZWlnaHQ9IjI0IiB2aWV3Qm94PSIwIDAgMTU1IDI0IiBmaWxsPSJub25lIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciPgo8cGF0aCBkPSJNMjUuOTUyIDE1LjA2MDRWMTUuNzcwNEgzNC4yMzJWMTUuMDYwNEgyNS45NTJaTTI1LjU4MiAxOC42MzA0VjE5LjM1MDRIMzQuNTUyVjE4LjYzMDRIMjUuNTgyWk0zMS41NDIgMTUuNDMwNFYyMy42MTA0SDMyLjMxMlYxNS40MzA0SDMxLjU0MlpNMjcuOTgyIDE1LjQzMDRWMTguMjAwNEMyNy45ODIgMTkuOTMwNCAyNy43NTIgMjEuNzYwNCAyNS42MDIgMjMuMDkwNEMyNS43OTIgMjMuMjEwNCAyNi4wNjIgMjMuNDcwNCAyNi4xOTIgMjMuNjQwNEMyOC40OTIgMjIuMTkwNCAyOC43NDIgMjAuMTQwNCAyOC43NDIgMTguMjAwNFYxNS40MzA0SDI3Ljk4MloiIGZpbGw9IiM5NzlCQTUiLz4KPHBhdGggZD0iTTM4LjY5MiAxNC44OTA0VjE1LjU4MDRINDQuNTYyVjE0Ljg5MDRIMzguNjkyWk0zOC40NDIgMTQuODkwNFYxNy42NDA0QzM4LjQ0MiAxOS4yOTA0IDM4LjMzMiAyMS41NjA0IDM3LjE5MiAyMy4xNzA0QzM3LjM3MiAyMy4yNDA0IDM3LjY4MiAyMy40NDA0IDM3LjgyMiAyMy41NzA0QzM5LjAwMiAyMS44OTA0IDM5LjE3MiAxOS4zODA0IDM5LjE3MiAxNy42NDA0VjE0Ljg5MDRIMzguNDQyWk00MC40MzIgMTguNjcwNEg0My40ODJWMTkuNTUwNEg0MC40MzJWMTguNjcwNFpNNDAuNDMyIDE3LjI1MDRINDMuNDgyVjE4LjEyMDRINDAuNDMyVjE3LjI1MDRaTTM5Ljc1MiAxNi42NzA0VjIwLjEzMDRINDQuMTgyVjE2LjY3MDRIMzkuNzUyWk00MC4xMDIgMjAuNjkwNEMzOS44MzIgMjEuNDEwNCAzOS4zODIgMjIuMTMwNCAzOC44OTIgMjIuNjQwNEMzOS4wNTIgMjIuNzMwNCAzOS4zNDIgMjIuOTIwNCAzOS40ODIgMjMuMDMwNEMzOS45NzIgMjIuNDkwNCA0MC40NzIgMjEuNjYwNCA0MC43ODIgMjAuODUwNEw0MC4xMDIgMjAuNjkwNFpNNDIuOTMyIDIwLjg3MDRDNDMuNDAyIDIxLjUwMDQgNDMuODkyIDIyLjM2MDQgNDQuMDgyIDIyLjkxMDRMNDQuNzYyIDIyLjYwMDRDNDQuNTYyIDIyLjA1MDQgNDQuMDQyIDIxLjIyMDQgNDMuNTgyIDIwLjYwMDRMNDIuOTMyIDIwLjg3MDRaTTQxLjU5MiAxNS40MzA0QzQxLjU0MiAxNS44NjA0IDQxLjQwMiAxNi41MDA0IDQxLjI5MiAxNi45MTA0TDQxLjk1MiAxNy4wNzA0QzQyLjA5MiAxNi42OTA0IDQyLjI1MiAxNi4xMTA0IDQyLjQwMiAxNS41OTA0TDQxLjU5MiAxNS40MzA0Wk00MS41NTIgMTkuOTAwNFYyMi44MTA0QzQxLjU1MiAyMi45MjA0IDQxLjUxMiAyMi45NTA0IDQxLjM4MiAyMi45NjA0QzQxLjI1MiAyMi45NjA0IDQwLjgyMiAyMi45NzA0IDQwLjM0MiAyMi45NTA0QzQwLjQzMiAyMy4xNDA0IDQwLjUyMiAyMy40MTA0IDQwLjU1MiAyMy42MDA0QzQxLjIyMiAyMy42MTA0IDQxLjY1MiAyMy42MDA0IDQxLjkyMiAyMy40OTA0QzQyLjIwMiAyMy4zOTA0IDQyLjI2MiAyMy4xOTA0IDQyLjI2MiAyMi44MjA0VjE5LjkwMDRINDEuNTUyWk0zNS45MjIgMTUuMDQwNEMzNi41MjIgMTUuMzQwNCAzNy4yNDIgMTUuODIwNCAzNy41ODIgMTYuMTgwNEwzOC4wMzIgMTUuNTgwNEMzNy42ODIgMTUuMjMwNCAzNi45NTIgMTQuNzgwNCAzNi4zNTIgMTQuNTAwNEwzNS45MjIgMTUuMDQwNFpNMzUuNDMyIDE3Ljc0MDRDMzYuMDQyIDE4LjAxMDQgMzYuNzcyIDE4LjQ2MDQgMzcuMTIyIDE4LjgwMDRMMzcuNTYyIDE4LjE5MDRDMzcuMTkyIDE3Ljg2MDQgMzYuNDYyIDE3LjQ0MDQgMzUuODYyIDE3LjE4MDRMMzUuNDMyIDE3Ljc0MDRaTTM1LjY0MiAyMy4wNDA0TDM2LjMxMiAyMy40NjA0QzM2Ljc5MiAyMi41MzA0IDM3LjM1MiAyMS4yOTA0IDM3Ljc3MiAyMC4yMzA0TDM3LjE2MiAxOS44MTA0QzM2LjcxMiAyMC45NDA0IDM2LjA5MiAyMi4yNjA0IDM1LjY0MiAyMy4wNDA0WiIgZmlsbD0iIzk3OUJBNSIvPgo8cGF0aCBkPSJNNDcuNzkyIDIzLjM2MDRMNDguNDcyIDIyLjc4MDRDNDcuODQyIDIyLjA1MDQgNDYuOTQyIDIxLjE1MDQgNDYuMjIyIDIwLjU3MDRMNDUuNTcyIDIxLjE0MDRDNDYuMjgyIDIxLjcyMDQgNDcuMTQyIDIyLjU3MDQgNDcuNzkyIDIzLjM2MDRaIiBmaWxsPSIjOTc5QkE1Ii8+CjxwYXRoIGQ9Ik02MC43NzIgMTkuODYwNFYyMi41MTA0QzYwLjc3MiAyMy4zMjA0IDYxLjAxMiAyMy41NTA0IDYxLjk1MiAyMy41NTA0QzYyLjE1MiAyMy41NTA0IDYzLjMxMiAyMy41NTA0IDYzLjUxMiAyMy41NTA0QzY0LjM0MiAyMy41NTA0IDY0LjU1MiAyMy4xOTA0IDY0LjY0MiAyMS43NTA0QzY0LjQzMiAyMS42OTA0IDY0LjExMiAyMS41NzA0IDYzLjk0MiAyMS40NDA0QzYzLjkwMiAyMi42NjA0IDYzLjg0MiAyMi44NDA0IDYzLjQ1MiAyMi44NDA0QzYzLjE4MiAyMi44NDA0IDYyLjIzMiAyMi44NDA0IDYyLjAzMiAyMi44NDA0QzYxLjYxMiAyMi44NDA0IDYxLjU0MiAyMi43OTA0IDYxLjU0MiAyMi41MDA0VjE5Ljg2MDRINjAuNzcyWk01OC4zNzIgMTkuOTUwNEM1OC4xODIgMjEuNDUwNCA1Ny43MTIgMjIuNDUwNCA1NS40MjIgMjIuOTUwNEM1NS41ODIgMjMuMTAwNCA1NS43ODIgMjMuNDIwNCA1NS44NjIgMjMuNjEwNEM1OC4zNDIgMjIuOTkwNCA1OC45NTIgMjEuNzgwNCA1OS4xNzIgMTkuOTUwNEg1OC4zNzJaTTU5LjY3MiAxNy4xNTA0VjE5LjcxMDRINjAuNDAyVjE3LjE1MDRINTkuNjcyWk01OC4zMzIgMTQuMzgwNEM1Ny44MTIgMTUuMzIwNCA1Ni44MzIgMTYuNDgwNCA1NS40NjIgMTcuMzIwNEM1NS42MzIgMTcuNDQwNCA1NS44NzIgMTcuNzEwNCA1NS45OTIgMTcuODkwNEM1Ny40NTIgMTYuOTIwNCA1OC40ODIgMTUuNjkwNCA1OS4xNTIgMTQuNTQwNEw1OC4zMzIgMTQuMzgwNFpNNTcuMjYyIDE3LjU2MDRINjMuMDUyVjE5LjM4MDRINTcuMjYyVjE3LjU2MDRaTTU2LjUxMiAxNi44ODA0VjIwLjA3MDRINjMuODMyVjE2Ljg4MDRINTYuNTEyWk02MS4wNjIgMTUuMTcwNFYxNS4zMjA0QzYwLjgxMiAxNS44NDA0IDYwLjI5MiAxNi42MTA0IDU5LjgyMiAxNy4wNzA0QzYwLjAwMiAxNy4xNjA0IDYwLjI1MiAxNy4zMjA0IDYwLjM5MiAxNy40MzA0QzYwLjg5MiAxNi45MzA0IDYxLjUwMiAxNi4xMzA0IDYxLjg3MiAxNS40NzA0TDYxLjM1MiAxNS4xMzA0TDYxLjIyMiAxNS4xNzA0SDYxLjA2MlpNNTguMTUyIDE1LjE3MDRMNTcuNzUyIDE1LjgwMDRINjEuMjcyVjE1LjE3MDRINTguMTUyWiIgZmlsbD0iIzk3OUJBNSIvPgo8cGF0aCBkPSJNNjYuODEyIDE2LjMxMDRWMTYuODUwNEg3My43OTJWMTUuMDQwNEg2Ni4xMzJWMTUuNTkwNEg3My4wOTJWMTYuMzEwNEg2Ni44MTJaTTY2LjY1MiAxNy41OTA0TDY2LjUwMiAxOC4xMzA0SDczLjkwMlYxNy41OTA0SDY2LjY1MlpNNzMuNjgyIDE3LjU5MDRWMTcuNjgwNEM3My42MjIgMTguMjgwNCA3My41NzIgMTguNTMwNCA3My40OTIgMTguNjEwNEM3My40NDIgMTguNjcwNCA3My4zNzIgMTguNjgwNCA3My4yNjIgMTguNjgwNEM3My4xNTIgMTguNjgwNCA3Mi44ODIgMTguNjgwNCA3Mi41NzIgMTguNjQwNEM3Mi42NDIgMTguNzkwNCA3Mi43MDIgMTkuMDAwNCA3Mi43MTIgMTkuMTUwNEM3My4wNzIgMTkuMTcwNCA3My40MTIgMTkuMTgwNCA3My41ODIgMTkuMTYwNEM3My43OTIgMTkuMTYwNCA3My45NDIgMTkuMTEwNCA3NC4wNzIgMTguOTgwNEM3NC4yMzIgMTguODIwNCA3NC4zMDIgMTguNTAwNCA3NC4zNzIgMTcuODUwNEM3NC4zNzIgMTcuNzUwNCA3NC4zODIgMTcuNTkwNCA3NC4zODIgMTcuNTkwNEg3My42ODJaTTY4LjYxMiAxNC40MTA0VjE2LjQ0MDRDNjguNjEyIDE3LjYxMDQgNjguMjkyIDE4LjYyMDQgNjUuNjQyIDE5LjI1MDRDNjUuNzcyIDE5LjM4MDQgNjUuOTUyIDE5LjY3MDQgNjYuMDEyIDE5LjgzMDRDNjguOTAyIDE5LjEzMDQgNjkuMzAyIDE3LjkxMDQgNjkuMzAyIDE2LjQ1MDRWMTQuNDEwNEg2OC42MTJaTTcwLjkwMiAxNC40MTA0VjE5LjE4MDRINzEuNjEyVjE0LjQxMDRINzAuOTAyWk02Ni45MjIgMTkuNDMwNFYyMi4yMTA0SDY3LjY1MlYyMC4wNjA0SDcyLjUxMlYyMi4xNTA0SDczLjI3MlYxOS40MzA0SDY2LjkyMlpNNjkuNzkyIDIwLjQ4MDRDNjkuNDcyIDIxLjk3MDQgNjguNjMyIDIyLjY2MDQgNjUuNDkyIDIyLjk3MDRDNjUuNjEyIDIzLjEzMDQgNjUuNzYyIDIzLjQzMDQgNjUuODEyIDIzLjYwMDRDNjkuMTUyIDIzLjIwMDQgNzAuMTcyIDIyLjMzMDQgNzAuNTQyIDIwLjQ4MDRINjkuNzkyWk03MC4yNzIgMjIuMjMwNEM3MS41NDIgMjIuNTkwNCA3My4yMzIgMjMuMTkwNCA3NC4wOTIgMjMuNjAwNEw3NC41MDIgMjMuMDEwNEM3My42MDIgMjIuNjAwNCA3MS45MTIgMjIuMDQwNCA3MC42NjIgMjEuNzIwNEw3MC4yNzIgMjIuMjMwNFpNNjYuNTMyIDE2LjMxMDRDNjYuNDYyIDE2LjkxMDQgNjYuMzQyIDE3LjY0MDQgNjYuMjIyIDE4LjEzMDRINjYuOTIyQzY3LjAyMiAxNy42NjA0IDY3LjEzMiAxNi45MzA0IDY3LjIxMiAxNi4zMTA0SDY2LjUzMloiIGZpbGw9IiM5NzlCQTUiLz4KPHBhdGggZD0iTTc2LjM3MiAxNi4wMTA0VjE2LjY4MDRINzguNzEyVjIxLjg3MDRINzYuMzcyVjIyLjU1MDRINzkuNDEyVjE2LjAxMDRINzYuMzcyWk03NS45MjIgMTYuMDEwNFYyMy4zNTA0SDc2LjYyMlYxNi4wMTA0SDc1LjkyMlpNNzYuMzIyIDE4Ljc5MDRWMTkuNDYwNEg3OS4wODJWMTguNzkwNEg3Ni4zMjJaTTc3LjQ1MiAxNC4zODA0Qzc3LjM3MiAxNC45MDA0IDc3LjE4MiAxNS42NjA0IDc3LjAxMiAxNi4xNDA0TDc3LjYxMiAxNi4yOTA0Qzc3LjgxMiAxNS44NDA0IDc4LjA2MiAxNS4xNTA0IDc4LjI2MiAxNC41MzA0TDc3LjQ1MiAxNC4zODA0Wk04MC44MzIgMTUuOTgwNFYxNi42ODA0SDgzLjkwMlYxNS45ODA0SDgwLjgzMlpNODMuNjQyIDE1Ljk4MDRWMTYuMTQwNEM4My41MDIgMjAuNTUwNCA4My4zNDIgMjIuMjEwNCA4My4wMTIgMjIuNTcwNEM4Mi45MDIgMjIuNzAwNCA4Mi43ODIgMjIuNzMwNCA4Mi41ODIgMjIuNzMwNEM4Mi4zNTIgMjIuNzMwNCA4MS43NTIgMjIuNzIwNCA4MS4xMDIgMjIuNjcwNEM4MS4yNDIgMjIuODcwNCA4MS4zMzIgMjMuMTgwNCA4MS4zNTIgMjMuNDAwNEM4MS45MTIgMjMuNDMwNCA4Mi41MDIgMjMuNDUwNCA4Mi44NDIgMjMuNDEwNEM4My4xOTIgMjMuMzgwNCA4My40MjIgMjMuMjkwNCA4My42NDIgMjMuMDAwNEM4NC4wNDIgMjIuNTEwNCA4NC4xODIgMjAuOTYwNCA4NC4zNDIgMTYuMzcwNEM4NC4zNDIgMTYuMjYwNCA4NC4zNDIgMTUuOTgwNCA4NC4zNDIgMTUuOTgwNEg4My42NDJaTTgxLjA0MiAxNC4zNjA0QzgwLjcyMiAxNS43NTA0IDgwLjE3MiAxNy4xMzA0IDc5LjQ5MiAxOC4wMTA0Qzc5LjY3MiAxOC4xMTA0IDc5Ljk4MiAxOC4zMjA0IDgwLjExMiAxOC40NDA0QzgwLjgwMiAxNy40OTA0IDgxLjM5MiAxNi4wMjA0IDgxLjc2MiAxNC41MzA0TDgxLjA0MiAxNC4zNjA0Wk04MC41ODIgMTguNTgwNEM4MS4xMzIgMTkuMzEwNCA4MS44MDIgMjAuMzAwNCA4Mi4xMDIgMjAuOTEwNEw4Mi43NDIgMjAuNTEwNEM4Mi40MjIgMTkuOTIwNCA4MS43MzIgMTguOTUwNCA4MS4xNjIgMTguMjQwNEw4MC41ODIgMTguNTgwNFoiIGZpbGw9IiM5NzlCQTUiLz4KPHBhdGggZD0iTTkwLjAxMiAxNS4xMzA0QzkwLjkyMiAxNi40ODA0IDkyLjY3MiAxOC4wMzA0IDk0LjI0MiAxOC45NDA0Qzk0LjM4MiAxOC43MjA0IDk0LjU3MiAxOC40NzA0IDk0Ljc1MiAxOC4yODA0QzkzLjE2MiAxNy40ODA0IDkxLjQwMiAxNS45NTA0IDkwLjM1MiAxNC4zODA0SDg5LjU5MkM4OC44MTIgMTUuNzYwNCA4Ny4xNDIgMTcuNDIwNCA4NS4zOTIgMTguNDAwNEM4NS41NjIgMTguNTYwNCA4NS43NzIgMTguODMwNCA4NS44NzIgMTkuMDAwNEM4Ny41ODIgMTcuOTgwNCA4OS4yMTIgMTYuNDIwNCA5MC4wMTIgMTUuMTMwNFpNOTAuMDgyIDE5LjQ1MDRWMjAuMTMwNEg5My40MDJWMTkuNDUwNEg5MC4wODJaTTg1LjgxMiAyMi42MzA0VjIzLjMyMDRIOTQuMzQyVjIyLjYzMDRIODUuODEyWk04OS43MjIgMTcuMTAwNFYyMi45OTA0SDkwLjUxMlYxNy4xMDA0SDg5LjcyMlpNODcuMDgyIDE4LjkxMDRWMjIuOTYwNEg4Ny44MTJWMTguOTEwNEg4Ny4wODJaIiBmaWxsPSIjOTc5QkE1Ii8+CjxwYXRoIGQ9Ik05NS42NjIgMjIuMzQwNFYyMy4wOTA0SDEwNC40ODJWMjIuMzQwNEg5NS42NjJaTTk4LjQ2MiAxNC41MzA0VjIyLjY1MDRIOTkuMjIyVjE0LjUzMDRIOTguNDYyWk0xMDAuOTEyIDE0LjUzMDRWMjIuNzAwNEgxMDEuNjcyVjE0LjUzMDRIMTAwLjkxMlpNMTAzLjU5MiAxNi43MzA0QzEwMy4yMDIgMTcuODQwNCAxMDIuNDkyIDE5LjI5MDQgMTAxLjkzMiAyMC4yMDA0TDEwMi41NTIgMjAuNTMwNEMxMDMuMTIyIDE5LjU5MDQgMTAzLjgwMiAxOC4yMTA0IDEwNC4yODIgMTcuMDUwNEwxMDMuNTkyIDE2LjczMDRaTTk1Ljg4MiAxNi45MTA0Qzk2LjQwMiAxOC4wNDA0IDk3LjAwMiAxOS41NjA0IDk3LjI0MiAyMC40NTA0TDk3Ljk5MiAyMC4xNzA0Qzk3LjcyMiAxOS4yOTA0IDk3LjEwMiAxNy44MTA0IDk2LjU3MiAxNi43MDA0TDk1Ljg4MiAxNi45MTA0WiIgZmlsbD0iIzk3OUJBNSIvPgo8cGF0aCBkPSJNMTEwLjg3MiAxNS45NDA0VjE2LjYyMDRIMTE0LjA4MlYxNS45NDA0SDExMC44NzJaTTExMC45NjIgMTQuNDAwNEMxMTAuNzUyIDE1Ljk1MDQgMTEwLjM2MiAxNy40MjA0IDEwOS42NjIgMTguMzYwNEMxMDkuODQyIDE4LjQ2MDQgMTEwLjE2MiAxOC42NzA0IDExMC4yOTIgMTguNzgwNEMxMTAuOTkyIDE3Ljc2MDQgMTExLjQ0MiAxNi4yMDA0IDExMS42OTIgMTQuNTEwNEwxMTAuOTYyIDE0LjQwMDRaTTExMy45MTIgMTUuOTQwNFYxNi4wNzA0QzExMy43NzIgMTYuOTAwNCAxMTMuNTUyIDE3Ljk1MDQgMTEzLjM3MiAxOC41NzA0TDExMy45NzIgMTguNzQwNEMxMTQuMjAyIDE4LjA3MDQgMTE0LjQ1MiAxNi45ODA0IDExNC42NDIgMTYuMDUwNEwxMTQuMTQyIDE1LjkyMDRMMTE0LjAyMiAxNS45NDA0SDExMy45MTJaTTExMS43MDIgMTcuNTgwNFYxOC4wNDA0QzExMS43MDIgMTkuNDMwNCAxMTEuNTYyIDIxLjUxMDQgMTA5LjQxMiAyMy4xMTA0QzEwOS41OTIgMjMuMjIwNCAxMDkuODUyIDIzLjQ1MDQgMTA5Ljk3MiAyMy42MTA0QzExMi4yMzIgMjEuODkwNCAxMTIuNDIyIDE5LjYwMDQgMTEyLjQyMiAxOC4wNTA0VjE3LjU4MDRIMTExLjcwMlpNMTEyLjM3MiAxOC44NzA0TDExMS43NTIgMTguOTkwNEMxMTIuMTMyIDIxLjA1MDQgMTEyLjg2MiAyMi44MDA0IDExNC4yMTIgMjMuNjAwNEMxMTQuMzIyIDIzLjQxMDQgMTE0LjU1MiAyMy4xMzA0IDExNC43MTIgMjIuOTgwNEMxMTMuNDQyIDIyLjMyMDQgMTEyLjcxMiAyMC43MDA0IDExMi4zNzIgMTguODcwNFpNMTA1LjU1MiAxNS41OTA0VjE2LjMxMDRIMTA5LjgzMlYxNS41OTA0SDEwNS41NTJaTTEwNy44MzIgMTcuMTgwNFYyMy41NjA0SDEwOC41MjJWMTcuMTgwNEgxMDcuODMyWk0xMDUuNDUyIDIxLjEyMDRMMTA1LjYxMiAyMS44ODA0QzEwNi43NzIgMjEuNzEwNCAxMDguMzcyIDIxLjQ0MDQgMTA5Ljg4MiAyMS4xOTA0TDEwOS44NTIgMjAuNTAwNEMxMDguMjMyIDIwLjc0MDQgMTA2LjU0MiAyMC45ODA0IDEwNS40NTIgMjEuMTIwNFpNMTA2LjAwMiAxOS40OTA0QzEwNi4wMDIgMTkuMzMwNCAxMDYuNTQyIDE5LjA3MDQgMTA2LjU0MiAxOS4wNzA0VjE5LjA2MDRDMTA3LjE1MiAxNy44ODA0IDEwNy43OTIgMTYuMTkwNCAxMDguMjEyIDE0LjU4MDRMMTA3LjQ4MiAxNC40MjA0QzEwNy4xNTIgMTUuOTMwNCAxMDYuNTEyIDE3LjU5MDQgMTA2LjMwMiAxOC4wMjA0QzEwNi4xMDIgMTguNDYwNCAxMDUuOTQyIDE4Ljc4MDQgMTA1Ljc2MiAxOC44MjA0QzEwNS44NDIgMTkuMDEwNCAxMDUuOTYyIDE5LjM0MDQgMTA2LjAwMiAxOS40OTA0Wk0xMDYuMDAyIDE5LjQ5MDRDMTA2LjA4MiAxOS40MTA0IDEwNi4zOTIgMTkuMzUwNCAxMDYuNzcyIDE5LjM1MDRIMTA5Ljc3MkwxMDkuNzgyIDE4LjY2MDRIMTA2LjQxMkwxMDYuMDAyIDE4Ljg3MDRWMTkuNDkwNFoiIGZpbGw9IiM5NzlCQTUiLz4KPHBhdGggZD0iTTEyMS4xMDIgMTQuNTMwNFYyMy42MDA0SDEyMS44NTJWMTQuNTMwNEgxMjEuMTAyWk0xMTkuMzcyIDE0LjkxMDRDMTE5LjE0MiAxNi4yMTA0IDExOC43MjIgMTcuNTAwNCAxMTguMTQyIDE4LjM0MDRDMTE4LjMzMiAxOC40MjA0IDExOC42NDIgMTguNjAwNCAxMTguNzkyIDE4LjcxMDRDMTE5LjM2MiAxNy44MjA0IDExOS44MjIgMTYuNDUwNCAxMjAuMDkyIDE1LjA1MDRMMTE5LjM3MiAxNC45MTA0Wk0xMTkuNDcyIDE2LjQ1MDRMMTE5LjI4MiAxNy4xOTA0SDEyNC4xNDJWMTYuNDUwNEgxMTkuNDcyWk0xMTguMjIyIDE5LjM5MDRWMjAuMTMwNEgxMjQuNTgyVjE5LjM5MDRIMTE4LjIyMlpNMTE3LjczMiAxNC40NDA0QzExNy4yMDIgMTUuOTYwNCAxMTYuMzEyIDE3LjQ2MDQgMTE1LjM3MiAxOC40MzA0QzExNS41MTIgMTguNjEwNCAxMTUuNzMyIDE5LjAwMDQgMTE1LjgwMiAxOS4xNzA0QzExNi44NDIgMTguMDQwNCAxMTcuODEyIDE2LjM1MDQgMTE4LjQ0MiAxNC42NjA0TDExNy43MzIgMTQuNDQwNFpNMTE2LjcyMiAxNy4wMjA0VjIzLjU5MDRIMTE3LjQ0MlYxNi4zMjA0TDExNy40MzIgMTYuMzEwNEwxMTYuNzIyIDE3LjAyMDRaIiBmaWxsPSIjOTc5QkE1Ii8+CjxwYXRoIGQ9Ik0xMjUuNjkyIDE0Ljk1MDRWMTUuNjgwNEgxMzQuNDMyVjE0Ljk1MDRIMTI1LjY5MlpNMTI3LjM2MiAxOS43MDA0VjIwLjM5MDRIMTMyLjk0MlYxOS43MDA0SDEyNy4zNjJaTTEyNy4zODIgMjIuMjYwNFYyMi45NzA0SDEzMi44NzJWMjIuMjYwNEgxMjcuMzgyWk0xMjkuNjAyIDE1LjIxMDRDMTI5LjUzMiAxNS44ODA0IDEyOS4zNTIgMTYuODQwNCAxMjkuMTkyIDE3LjQ0MDRMMTI5Ljg5MiAxNy42MzA0QzEzMC4wODIgMTcuMDUwNCAxMzAuMjkyIDE2LjE2MDQgMTMwLjQ5MiAxNS40MDA0TDEyOS42MDIgMTUuMjEwNFpNMTI2LjgzMiAxNy4xNzA0VjIzLjYyMDRIMTI3LjU5MlYxNy44ODA0SDEzMi42NDJWMjMuNjIwNEgxMzMuNDMyVjE3LjE3MDRIMTI2LjgzMloiIGZpbGw9IiM5NzlCQTUiLz4KPHBhdGggZD0iTTEzOS42NDIgMTcuOTYwNFYyMi45NDA0SDE0MC40MTJWMTcuOTYwNEgxMzkuNjQyWk0xMzYuNjcyIDE3LjY4MDRWMTguMzgwNEgxNDMuNDUyVjE3LjY4MDRIMTM2LjY3MlpNMTM2LjkzMiAxOS44OTA0VjIwLjU5MDRIMTQzLjIzMlYxOS44OTA0SDEzNi45MzJaTTEzNS43MjIgMjIuNjEwNFYyMy4zMTA0SDE0NC40MTJWMjIuNjEwNEgxMzUuNzIyWk0xNDEuMjAyIDIxLjA5MDRDMTQxLjc3MiAyMS41MTA0IDE0Mi40NjIgMjIuMTEwNCAxNDIuNzgyIDIyLjUzMDRMMTQzLjMzMiAyMi4wODA0QzE0My4wMDIgMjEuNjkwNCAxNDIuMzAyIDIxLjA5MDQgMTQxLjcyMiAyMC43MDA0TDE0MS4yMDIgMjEuMDkwNFpNMTM5LjY0MiAxNC40MTA0VjE2LjAyMDRIMTQwLjQzMlYxNC40MTA0SDEzOS42NDJaTTEzNS44OTIgMTUuNTkwNFYxNy43MTA0SDEzNi42NTJWMTYuMzEwNEgxNDMuNDMyVjE3LjcxMDRIMTQ0LjIyMlYxNS41OTA0SDEzNS44OTJaIiBmaWxsPSIjOTc5QkE1Ii8+CjxwYXRoIGQ9Ik0xNTAuMDMyIDE3LjYxMDRWMjMuNTkwNEgxNTAuNzUyVjE4LjI5MDRIMTUzLjQzMlYyMy41NDA0SDE1NC4xOTJWMTcuNjEwNEgxNTAuMDMyWk0xNDUuNjUyIDE4LjM5MDRWMTkuMDgwNEgxNDkuNzIyVjE4LjM5MDRIMTQ1LjY1MlpNMTUwLjM4MiAxOS4yOTA0VjE5Ljg3MDRIMTUzLjc5MlYxOS4yOTA0SDE1MC4zODJaTTE1MC4zODIgMjAuODkwNFYyMS40OTA0SDE1My43OTJWMjAuODkwNEgxNTAuMzgyWk0xNTAuMzgyIDIyLjUzMDRWMjMuMTYwNEgxNTMuNzkyVjIyLjUzMDRIMTUwLjM4MlpNMTQ3LjQwMiAxNy4yNTA0VjIzLjYxMDRIMTQ4LjEzMlYxNy4yNTA0SDE0Ny40MDJaTTE0OC4wMjIgMTkuMzcwNEwxNDcuNjAyIDE5LjcxMDRDMTQ4LjAwMiAyMC4wODA0IDE0OC45MzIgMjEuMTAwNCAxNDkuMjUyIDIxLjU1MDRMMTQ5LjczMiAyMC45NTA0QzE0OS40ODIgMjAuNjkwNCAxNDguMzQyIDE5LjYyMDQgMTQ4LjAyMiAxOS4zNzA0Wk0xNDYuNzIyIDE1LjM3MDRWMTYuMDIwNEgxNDkuOTMyVjE1LjM3MDRIMTQ2LjcyMlpNMTUwLjY1MiAxNS4zODA0VjE2LjAyMDRIMTU0LjUzMlYxNS4zODA0SDE1MC42NTJaTTE0Ni45MDIgMTQuMzYwNEMxNDYuNTkyIDE1LjM3MDQgMTQ2LjA1MiAxNi4zNzA0IDE0NS40MjIgMTcuMDMwNEMxNDUuNjAyIDE3LjEyMDQgMTQ1LjkxMiAxNy4zMzA0IDE0Ni4wNTIgMTcuNDUwNEMxNDYuNjYyIDE2LjczMDQgMTQ3LjI1MiAxNS42MzA0IDE0Ny42MzIgMTQuNTQwNEwxNDYuOTAyIDE0LjM2MDRaTTE1MC44MzIgMTQuMzYwNEMxNTAuNTQyIDE1LjM2MDQgMTUwLjAyMiAxNi4zMjA0IDE0OS4zNjIgMTYuOTMwNEMxNDkuNTQyIDE3LjAzMDQgMTQ5Ljg2MiAxNy4yNDA0IDE1MC4wMDIgMTcuMzcwNEMxNTAuNjQyIDE2LjY5MDQgMTUxLjIzMiAxNS42NDA0IDE1MS41NjIgMTQuNTQwNEwxNTAuODMyIDE0LjM2MDRaTTE0Ny4zMjIgMTUuODYwNEMxNDcuNTgyIDE2LjM0MDQgMTQ3Ljg0MiAxNi45ODA0IDE0Ny45MzIgMTcuMzgwNEwxNDguNTkyIDE3LjEwMDRDMTQ4LjQ5MiAxNi43MTA0IDE0OC4yMDIgMTYuMDgwNCAxNDcuOTQyIDE1LjYzMDRMMTQ3LjMyMiAxNS44NjA0Wk0xNTEuNDIyIDE1Ljg3MDRDMTUxLjc5MiAxNi4zMzA0IDE1Mi4xOTIgMTYuOTcwNCAxNTIuMzQyIDE3LjM3MDRMMTUyLjk5MiAxNy4xMDA0QzE1Mi44MjIgMTYuNjkwNCAxNTIuNDEyIDE2LjA3MDQgMTUyLjAzMiAxNS42MzA0TDE1MS40MjIgMTUuODcwNFpNMTQ3LjM5MiAxOC43NDA0QzE0Ni45ODIgMTkuODgwNCAxNDYuMTQyIDIxLjI1MDQgMTQ1LjM5MiAyMS45NTA0QzE0NS41NjIgMjIuMTAwNCAxNDUuNzcyIDIyLjM1MDQgMTQ1Ljg3MiAyMi41MzA0QzE0Ni42NDIgMjEuNzEwNCAxNDcuNTEyIDIwLjI2MDQgMTQ3Ljk0MiAxOS4wNjA0TDE0Ny4zOTIgMTguNzQwNFoiIGZpbGw9IiM5NzlCQTUiLz4KPHBhdGggZD0iTTQ0LjU3MTMgMS42MjA2OUM0NC44MzQ3IDEuNjIwNjkgNDUuMDk4MSAxLjYyMDY5IDQ1LjM2MTUgMS42MjA2OUM0NS4zOTg4IDEuNjIwNjkgNDUuNDM2IDEuNjIwNjkgNDUuNDczMyAxLjYyMDY5QzQ1LjU3NDQgMS42MjA2OSA0NS42ODM1IDEuNTc1NDYgNDUuNzU1MyAxLjUwMzYyQzQ1LjgyNDUgMS40MzQ0NCA0NS44Nzc3IDEuMzIwMDQgNDUuODcyNCAxLjIyMTZDNDUuODYxNyAxLjAwNjA5IDQ1LjY5NjggMC44MjI1MSA0NS40NzMzIDAuODIyNTFDNDUuMjA5OSAwLjgyMjUxIDQ0Ljk0NjUgMC44MjI1MSA0NC42ODMxIDAuODIyNTFDNDQuNjQ1OCAwLjgyMjUxIDQ0LjYwODYgMC44MjI1MSA0NC41NzEzIDAuODIyNTFDNDQuNDcwMiAwLjgyMjUxIDQ0LjM2MTEgMC44Njc3NCA0NC4yODkzIDAuOTM5NTc2QzQ0LjIyMDEgMS4wMDg3NSA0NC4xNjY5IDEuMTIzMTYgNDQuMTcyMiAxLjIyMTZDNDQuMTgyOSAxLjQzNzExIDQ0LjM0NzggMS42MjA2OSA0NC41NzEzIDEuNjIwNjlaIiBmaWxsPSIjMjEzMjRGIi8+CjxwYXRoIGQ9Ik0yNi41ODY5IDkuMTc2ODhDMjYuMzM5NSA5LjQyNDMyIDI2LjA5MiA5LjY3MTc1IDI1Ljg0NDYgOS45MTkxOEMyNS44MSA5Ljk1Mzc3IDI1Ljc3NTQgOS45ODgzNiAyNS43MzgyIDEwLjAyNTZDMjUuNjY2MyAxMC4wOTc0IDI1LjYyMTEgMTAuMjA2NSAyNS42MjExIDEwLjMwNzZDMjUuNjIxMSAxMC40MDYxIDI1LjY2MzcgMTAuNTIzMSAyNS43MzgyIDEwLjU4OTdDMjUuODE1MyAxMC42NTg4IDI1LjkxMzggMTAuNzEyIDI2LjAyMDIgMTAuNzA2N0MyNi4xMjY2IDEwLjcwMTQgMjYuMjI1IDEwLjY2NjggMjYuMzAyMiAxMC41ODk3QzI2LjU0OTYgMTAuMzQyMiAyNi43OTcxIDEwLjA5NDggMjcuMDQ0NSA5Ljg0NzM1QzI3LjA3OTEgOS44MTI3NiAyNy4xMTM3IDkuNzc4MTcgMjcuMTUwOSA5Ljc0MDkzQzI3LjIyMjggOS42NjkwOSAyNy4yNjggOS41NjAwMSAyNy4yNjggOS40NTg5QzI3LjI2OCA5LjM2MDQ2IDI3LjIyNTQgOS4yNDM0IDI3LjE1MDkgOS4xNzY4OEMyNy4wNzM4IDkuMTA3NzEgMjYuOTc1MyA5LjA1NDQ5IDI2Ljg2ODkgOS4wNTk4MkMyNi43NjI1IDkuMDY1MTQgMjYuNjY0IDkuMDk5NzIgMjYuNTg2OSA5LjE3Njg4WiIgZmlsbD0iIzIxMzI0RiIvPgo8cGF0aCBkPSJNMzIuNjIzMyA5Ljc0MDhDMzIuODcwNyA5Ljk4ODI0IDMzLjExODIgMTAuMjM1NyAzMy4zNjU2IDEwLjQ4MzFDMzMuNDAwMiAxMC41MTc3IDMzLjQzNDggMTAuNTUyMyAzMy40NzIgMTAuNTg5NUMzMy41NDM5IDEwLjY2MTQgMzMuNjUyOSAxMC43MDY2IDMzLjc1NCAxMC43MDY2QzMzLjg1MjUgMTAuNzA2NiAzMy45Njk1IDEwLjY2NCAzNC4wMzYxIDEwLjU4OTVDMzQuMTA1MiAxMC41MTI0IDM0LjE1ODUgMTAuNDEzOSAzNC4xNTMxIDEwLjMwNzVDMzQuMTQ3OCAxMC4yMDExIDM0LjExMzIgMTAuMTAyNiAzNC4wMzYxIDEwLjAyNTVDMzMuNzg4NiA5Ljc3ODA1IDMzLjU0MTIgOS41MzA2MiAzMy4yOTM4IDkuMjgzMThDMzMuMjU5MiA5LjI0ODU5IDMzLjIyNDYgOS4yMTQwMSAzMy4xODczIDkuMTc2NzZDMzMuMTE1NSA5LjEwNDkyIDMzLjAwNjQgOS4wNTk2OSAzMi45MDUzIDkuMDU5NjlDMzIuODA2OSA5LjA1OTY5IDMyLjY4OTggOS4xMDIyNiAzMi42MjMzIDkuMTc2NzZDMzIuNTU0MSA5LjI1MzkyIDMyLjUwMDkgOS4zNTIzNiAzMi41MDYyIDkuNDU4NzhDMzIuNTExNSA5LjU2NTIgMzIuNTQ2MSA5LjY2MzY1IDMyLjYyMzMgOS43NDA4WiIgZmlsbD0iIzIxMzI0RiIvPgo8cGF0aCBkPSJNMjUuOTM0MyAxLjQ3MTY3QzI2LjE1NTEgMS42OTI1IDI2LjM3ODYgMS45MTU5OSAyNi41OTk0IDIuMTM2ODJDMjYuNjg3MiAyLjIyNDYyIDI2LjgxNDkgMi4yNzc4MyAyNi45MzczIDIuMjc3ODNDMjcuMDAzOCAyLjI4MDQ5IDI3LjA2NSAyLjI2NzE5IDI3LjEyMDkgMi4yMzUyNkMyNy4xNzk0IDIuMjE2NjQgMjcuMjMyNyAyLjE4MjA1IDI3LjI3NTIgMi4xMzY4MkMyNy4zNTc3IDIuMDQ2MzYgMjcuNDIxNiAxLjkyNjYzIDI3LjQxNjIgMS43OTg5MkMyNy40MTA5IDEuNjcxMjIgMjcuMzY4MyAxLjU1MTQ5IDI3LjI3NTIgMS40NjEwM0MyNy4wNTQ0IDEuMjQwMiAyNi44MzA5IDEuMDE2NzEgMjYuNjEwMSAwLjc5NTg4M0MyNi41MjIzIDAuNzA4MDg0IDI2LjM5NDYgMC42NTQ4NzIgMjYuMjcyMiAwLjY1NDg3MkMyNi4yMDU3IDAuNjUyMjExIDI2LjE0NDUgMC42NjU1MTQgMjYuMDg4NiAwLjY5NzQ0MUMyNi4wMzAxIDAuNzE2MDY2IDI1Ljk3NjkgMC43NTA2NTMgMjUuOTM0MyAwLjc5NTg4M0MyNS44NTE4IDAuODg2MzQzIDI1Ljc4OCAxLjAwNjA3IDI1Ljc5MzMgMS4xMzM3OEMyNS43OTg2IDEuMjU4ODMgMjUuODQxMiAxLjM3ODU1IDI1LjkzNDMgMS40NzE2N1oiIGZpbGw9IiMyMTMyNEYiLz4KPHBhdGggZD0iTTI1LjQ0OTYgOC42MzEzMUMyNy45NjM4IDguNjMxMzEgMzAuNDgwNyA4LjYzMTMxIDMyLjk5NSA4LjYzMTMxQzMzLjM1MTUgOC42MzEzMSAzMy43MTA3IDguNjMxMzEgMzQuMDY3MiA4LjYzMTMxQzM0LjU4MDcgOC42MzEzMSAzNC41ODA3IDcuODMzMTMgMzQuMDY3MiA3LjgzMzEzQzMxLjU1MyA3LjgzMzEzIDI5LjAzNiA3LjgzMzEzIDI2LjUyMTggNy44MzMxM0MyNi4xNjUzIDcuODMzMTMgMjUuODA2MSA3LjgzMzEzIDI1LjQ0OTYgNy44MzMxM0MyNC45MzYxIDcuODMzMTMgMjQuOTM2MSA4LjYzMTMxIDI1LjQ0OTYgOC42MzEzMVoiIGZpbGw9IiMyMTMyNEYiLz4KPHBhdGggZD0iTTMzLjg5NTQgMi40MTM0NUMzMi4zNTUgMi40MTM0NSAzMC44MTQ1IDIuNDEzNDUgMjkuMjc0IDIuNDEzNDVDMjkuMDU1OCAyLjQxMzQ1IDI4LjgzNzcgMi40MTM0NSAyOC42MTk1IDIuNDEzNDVDMjguMTA2IDIuNDEzNDUgMjguMTA2IDMuMjExNjMgMjguNjE5NSAzLjIxMTYzQzMwLjE2IDMuMjExNjMgMzEuNzAwNSAzLjIxMTYzIDMzLjI0MDkgMy4yMTE2M0MzMy40NTkxIDMuMjExNjMgMzMuNjc3MyAzLjIxMTYzIDMzLjg5NTQgMy4yMTE2M0MzNC40MDg5IDMuMjExNjMgMzQuNDA4OSAyLjQxMzQ1IDMzLjg5NTQgMi40MTM0NVoiIGZpbGw9IiMyMTMyNEYiLz4KPHBhdGggZD0iTTMzLjg5NTQgNC4yMDE0MkMzMi4zNTUgNC4yMDE0MiAzMC44MTQ1IDQuMjAxNDIgMjkuMjc0IDQuMjAxNDJDMjkuMDU1OCA0LjIwMTQyIDI4LjgzNzcgNC4yMDE0MiAyOC42MTk1IDQuMjAxNDJDMjguMTA2IDQuMjAxNDIgMjguMTA2IDQuOTk5NTkgMjguNjE5NSA0Ljk5OTU5QzMwLjE2IDQuOTk5NTkgMzEuNzAwNSA0Ljk5OTU5IDMzLjI0MDkgNC45OTk1OUMzMy40NTkxIDQuOTk5NTkgMzMuNjc3MyA0Ljk5OTU5IDMzLjg5NTQgNC45OTk1OUMzNC40MDg5IDQuOTk5NTkgMzQuNDA4OSA0LjIwMTQyIDMzLjg5NTQgNC4yMDE0MloiIGZpbGw9IiMyMTMyNEYiLz4KPHBhdGggZD0iTTMzLjQxNiAyLjkwNTY0QzMzLjQxNiAzLjM3MzkgMzMuNDE2IDMuODQyMTcgMzMuNDE2IDQuMzEwNDNDMzMuNDE2IDQuMzc2OTQgMzMuNDE2IDQuNDQzNDYgMzMuNDE2IDQuNTA5OTdDMzMuNDE2IDQuNzYwMDcgMzMuNjM2OCA0Ljk5OTUyIDMzLjg5NDkgNC45ODg4OEMzNC4xNTU3IDQuOTc4MjQgMzQuMzczOCA0Ljc3ODY5IDM0LjM3MzggNC41MDk5N0MzNC4zNzM4IDQuMDQxNzEgMzQuMzczOCAzLjU3MzQ1IDM0LjM3MzggMy4xMDUxOEMzNC4zNzM4IDMuMDM4NjcgMzQuMzczOCAyLjk3MjE1IDM0LjM3MzggMi45MDU2NEMzNC4zNzM4IDIuNjU1NTQgMzQuMTUzIDIuNDE2MDkgMzMuODk0OSAyLjQyNjczQzMzLjYzNDIgMi40MzczOCAzMy40MTYgMi42MzY5MiAzMy40MTYgMi45MDU2NFoiIGZpbGw9IiMyMTMyNEYiLz4KPHBhdGggZD0iTTI4LjYxOTUgMS41MzAyM0MzMC4yMTA1IDEuNTMwMjMgMzEuODA0MiAxLjUzMDIzIDMzLjM5NTIgMS41MzAyM0MzMy42MjE0IDEuNTMwMjMgMzMuODQ0OSAxLjUzMDIzIDM0LjA3MSAxLjUzMDIzQzM0LjU4NDUgMS41MzAyMyAzNC41ODQ1IDAuNzMyMDU2IDM0LjA3MSAwLjczMjA1NkMzMi40OCAwLjczMjA1NiAzMC44ODYzIDAuNzMyMDU2IDI5LjI5NTMgMC43MzIwNTZDMjkuMDY5MSAwLjczMjA1NiAyOC44NDU2IDAuNzMyMDU2IDI4LjYxOTUgMC43MzIwNTZDMjguMTA2IDAuNzMyMDU2IDI4LjEwNiAxLjUzMDIzIDI4LjYxOTUgMS41MzAyM1oiIGZpbGw9IiMyMTMyNEYiLz4KPHBhdGggZD0iTTI4LjYxNzUgNi42ODEyM0MzMC4yMDg2IDYuNjgxMjMgMzEuODAyMyA2LjY4MTIzIDMzLjM5MzMgNi42ODEyM0MzMy42MTk0IDYuNjgxMjMgMzMuODQyOSA2LjY4MTIzIDM0LjA2OTEgNi42ODEyM0MzNC41ODI2IDYuNjgxMjMgMzQuNTgyNiA1Ljg4MzA2IDM0LjA2OTEgNS44ODMwNkMzMi40NzgxIDUuODgzMDYgMzAuODg0NCA1Ljg4MzA2IDI5LjI5MzMgNS44ODMwNkMyOS4wNjcyIDUuODgzMDYgMjguODQzNyA1Ljg4MzA2IDI4LjYxNzUgNS44ODMwNkMyOC4xMDQgNS44ODMwNiAyOC4xMDQgNi42ODEyMyAyOC42MTc1IDYuNjgxMjNaIiBmaWxsPSIjMjEzMjRGIi8+CjxwYXRoIGQ9Ik0yOC4wMTk1IDEuMzE3NjdDMjguMDE5NSAyLjcxMTgyIDI4LjAxOTUgNC4xMDg2MyAyOC4wMTk1IDUuNTAyNzdDMjguMDE5NSA1LjY5OTY2IDI4LjAxOTUgNS44OTY1NCAyOC4wMTk1IDYuMDkzNDJDMjguMDE5NSA2Ljg2NDk5IDI5LjIxNjggNi44NjQ5OSAyOS4yMTY4IDYuMDkzNDJDMjkuMjE2OCA0LjY5OTI4IDI5LjIxNjggMy4zMDI0NyAyOS4yMTY4IDEuOTA4MzJDMjkuMjE2OCAxLjcxMTQ0IDI5LjIxNjggMS41MTQ1NSAyOS4yMTY4IDEuMzE3NjdDMjkuMjE2OCAwLjU0ODc2MSAyOC4wMTk1IDAuNTQ2MSAyOC4wMTk1IDEuMzE3NjdaIiBmaWxsPSIjMjEzMjRGIi8+CjxwYXRoIGQ9Ik0yOC41NTg2IDcuNzUwNzlDMjguNTU4NiA4LjU0NjMxIDI4LjU1ODYgOS4zNDE4MyAyOC41NTg2IDEwLjEzNzNDMjguNTU4NiAxMC4yNDkxIDI4LjU1ODYgMTAuMzYzNSAyOC41NTg2IDEwLjQ3NTJDMjguNTU4NiAxMC43ODkyIDI4LjgzMjYgMTEuMDg3MiAyOS4xNTcyIDExLjA3MzlDMjkuNDgxOCAxMS4wNjA2IDI5Ljc1NTkgMTAuODEwNSAyOS43NTU5IDEwLjQ3NTJDMjkuNzU1OSA5LjY3OTcyIDI5Ljc1NTkgOC44ODQyIDI5Ljc1NTkgOC4wODg2OUMyOS43NTU5IDcuOTc2OTQgMjkuNzU1OSA3Ljg2MjU0IDI5Ljc1NTkgNy43NTA3OUMyOS43NTU5IDcuNDM2ODUgMjkuNDgxOCA3LjEzODg2IDI5LjE1NzIgNy4xNTIxNkMyOC44MzUzIDcuMTY1NDcgMjguNTU4NiA3LjQxMjkgMjguNTU4NiA3Ljc1MDc5WiIgZmlsbD0iIzIxMzI0RiIvPgo8cGF0aCBkPSJNMzcuNTg0MyAyLjgwNzMzQzM5Ljg4NTcgMi44MDczMyA0Mi4xODQ1IDIuODA3MzMgNDQuNDg1OSAyLjgwNzMzQzQ0LjgwNzggMi44MDczMyA0NS4xMjk4IDIuODA3MzMgNDUuNDU0NCAyLjgwNzMzQzQ1Ljk2NzggMi44MDczMyA0NS45Njc4IDIuMDA5MTYgNDUuNDU0NCAyLjAwOTE2QzQzLjE1MjkgMi4wMDkxNiA0MC44NTQyIDIuMDA5MTYgMzguNTUyOCAyLjAwOTE2QzM4LjIzMDkgMi4wMDkxNiAzNy45MDg5IDIuMDA5MTYgMzcuNTg0MyAyLjAwOTE2QzM3LjA3MDggMi4wMDkxNiAzNy4wNzA4IDIuODA3MzMgMzcuNTg0MyAyLjgwNzMzWiIgZmlsbD0iIzIxMzI0RiIvPgo8cGF0aCBkPSJNMzYuOTM0NCAyLjYxODM1QzM2LjkzNDQgMy45Nzc5MSAzNy4wMDM2IDUuMzUzNDMgMzYuOTA3OCA2LjcxMDMzQzM2LjgyIDcuOTU4MTUgMzYuNTE0MSA5LjE4NDY4IDM2LjA0MzEgMTAuMzQyQzM1LjkyMDcgMTAuNjQyNyAzNi4xNzYyIDEwLjk5OTIgMzYuNDYwOCAxMS4wNzlDMzYuODA0MSAxMS4xNzIxIDM3LjA3NTQgMTAuOTYxOSAzNy4xOTc4IDEwLjY2MTNDMzcuNjk1NCA5LjQzNzQzIDM3Ljk5MzMgOC4xNDQzOSAzOC4wOTcxIDYuODI0NzRDMzguMjA2MiA1LjQzMzI1IDM4LjEzMTcgNC4wMTUxNiAzOC4xMzE3IDIuNjE4MzVDMzguMTMxNyAxLjg0Njc4IDM2LjkzNDQgMS44NDY3OCAzNi45MzQ0IDIuNjE4MzVaIiBmaWxsPSIjMjEzMjRGIi8+CjxwYXRoIGQ9Ik00MC42NzYgNS4xOTEyOEMzOS43Mjg4IDUuMTkxMjggMzguNzc5IDUuMTkxMjggMzcuODMxOCA1LjE5MTI4QzM3LjY5ODggNS4xOTEyOCAzNy41NjMxIDUuMTkxMjggMzcuNDMgNS4xOTEyOEMzNi45MTY1IDUuMTkxMjggMzYuOTE2NSA1Ljk4OTQ2IDM3LjQzIDUuOTg5NDZDMzguMzc3MiA1Ljk4OTQ2IDM5LjMyNyA1Ljk4OTQ2IDQwLjI3NDIgNS45ODk0NkM0MC40MDcyIDUuOTg5NDYgNDAuNTQyOSA1Ljk4OTQ2IDQwLjY3NiA1Ljk4OTQ2QzQxLjE4OTQgNS45ODk0NiA0MS4xOTIxIDUuMTkxMjggNDAuNjc2IDUuMTkxMjhaIiBmaWxsPSIjMjEzMjRGIi8+CjxwYXRoIGQ9Ik00MC4xMDc0IDUuNzY1OTlDNDAuMTA3NCA3LjAwMDUgNDAuMTA3NCA4LjIzNzY3IDQwLjEwNzQgOS40NzIxOUM0MC4xMDc0IDkuNjQ3NzggNDAuMTA3NCA5LjgyMDcyIDQwLjEwNzQgOS45OTYzMkM0MC4xMDc0IDEwLjMyMDkgNDAuMzgxNSAxMC41OTUgNDAuNzA2MSAxMC41OTVDNDEuMDMwNiAxMC41OTUgNDEuMzA0NyAxMC4zMjA5IDQxLjMwNDcgOS45OTYzMkM0MS4zMDQ3IDguNzYxODEgNDEuMzA0NyA3LjUyNDY0IDQxLjMwNDcgNi4yOTAxM0M0MS4zMDQ3IDYuMTE0NTMgNDEuMzA0NyA1Ljk0MTU5IDQxLjMwNDcgNS43NjU5OUM0MS4zMDQ3IDUuNDQxNCA0MS4wMzA2IDUuMTY3MzYgNDAuNzA2MSA1LjE2NzM2QzQwLjM4MTUgNS4xNjczNiA0MC4xMDc0IDUuNDQxNCA0MC4xMDc0IDUuNzY1OTlaIiBmaWxsPSIjMjEzMjRGIi8+CjxwYXRoIGQ9Ik00Mi41NTkgMS4xMDcyNEM0Mi41NTkgMi4yNTkyOCA0Mi41NTkgMy40MTEzMSA0Mi41NTkgNC41NjA2OEM0Mi41NTkgNi4wMTMzNiA0Mi40MTggNy41MDg2MSA0My4wOTkxIDguODQ2ODlDNDMuNTE0MSA5LjY2MTAzIDQ0LjIwMDUgMTAuMjY1IDQ0LjgzOTEgMTAuODk1NUM0NS4zODk4IDExLjQzNTYgNDYuMjM1OSAxMC41ODk2IDQ1LjY4NTIgMTAuMDQ5NUM0NS4yMDg5IDkuNTgxMjEgNDQuNjY2MiA5LjEyODkxIDQ0LjMwOTYgOC41NTk1NEM0My45MDI2IDcuOTA1MDQgNDMuNzUzNiA3LjE4OTM0IDQzLjc1MzYgNi40Mjg0MUM0My43NTM2IDUuMTAwNzggNDMuNzUzNiAzLjc3MDQ5IDQzLjc1MzYgMi40NDI4NkM0My43NTM2IDEuOTk4NTQgNDMuNzUzNiAxLjU1MTU2IDQzLjc1MzYgMS4xMDcyNEM0My43NTYyIDAuMzM1NjcyIDQyLjU1OSAwLjMzNTY3MiA0Mi41NTkgMS4xMDcyNFoiIGZpbGw9IiMyMTMyNEYiLz4KPHBhdGggZD0iTTQ0LjczMDggNS4wOTgwNkM0NC4xMjE2IDUuOTczNCA0My41MTIzIDYuODQ4NzMgNDIuOTAwNCA3LjcyMTRDNDIuODEyNiA3Ljg0NjQ1IDQyLjcyNDggNy45NzE1IDQyLjYzOTYgOC4wOTY1NEM0Mi40NTg3IDguMzU0NjIgNDIuNTgzNyA4Ljc3MjMzIDQyLjg1NTEgOC45MTZDNDMuMTYxMSA5LjA3ODMgNDMuNDgzIDguOTc3MiA0My42NzQ2IDguNzAwNUM0NC4yODM5IDcuODI1MTYgNDQuODkzMSA2Ljk0OTgzIDQ1LjUwNTEgNi4wNzcxNkM0NS41OTI5IDUuOTUyMTEgNDUuNjgwNyA1LjgyNzA2IDQ1Ljc2NTggNS43MDIwMkM0NS45NDY3IDUuNDQzOTQgNDUuODIxNyA1LjAyNjIzIDQ1LjU1MDMgNC44ODI1NkM0NS4yNDQzIDQuNzIyOTIgNDQuOTIyNCA0LjgyNDAyIDQ0LjczMDggNS4wOTgwNloiIGZpbGw9IiMyMTMyNEYiLz4KPHBhdGggZD0iTTI3LjEzMjUgNi40NzkwNUMyNy4yNTIzIDYuMjYwODggMjcuMjQxNiA2LjAwODEyIDI3LjEyNzIgNS44MDg1OEMyNy4xMjk5IDUuODA4NTggMjcuMTMyNSA1LjgwODU4IDI3LjEzNTIgNS44MDg1OEMyNy4wMzY4IDUuNjY0OTEgMjYuOTI1IDUuNDYyNyAyNi44NDI1IDUuMjA3MjlDMjYuODQyNSA1LjIwNDYzIDI2Ljg0MjUgNS4yMDQ2MyAyNi44Mzk5IDUuMjAxOTdDMjYuNzU0NyA0LjkzMzI1IDI2Ljc0OTQgNC42NDU5IDI2LjgyMTIgNC4zNzQ1MkMyNi44NTA1IDQuMjY1NDQgMjYuODg3OCA0LjE1MTAzIDI2LjkzMyA0LjAzMzk3QzI2Ljk4MzUgMy45MDM2IDI3LjAzNjggMy43ODkxOSAyNy4wOTI2IDMuNjg1NDNDMjcuMDk1MyAzLjY3NzQ1IDI3LjEwMDYgMy42NzIxMyAyNy4xMDMzIDMuNjY0MTVMMjcuMTA1OSAzLjY2MTQ5QzI3LjE5MzcgMy40NjE5NCAyNy4xODg0IDMuMjI1MTUgMjcuMDY2IDMuMDIyOTVDMjYuODY5MSAyLjY5ODM1IDI2LjQ0NjEgMi41OTQ1OSAyNi4xMTg5IDIuNzkxNDdDMjUuODAyMiAyLjk4MzA0IDI1LjY5NTggMy4zOTAxMSAyNS44NzE0IDMuNzEyMDRDMjUuODc0MSAzLjcxNDcgMjUuODc2NyAzLjcyMDAyIDI1Ljg3OTQgMy43MjI2OEMyNS44ODIxIDMuNzI4IDI1Ljg4NDcgMy43MzMzMiAyNS44ODc0IDMuNzM4NjRDMjUuODkyNyAzLjc0NjYyIDI1Ljg5OCAzLjc1NDYxIDI1LjkwNiAzLjc2NTI1QzI1Ljk5NjUgMy45MDYyNiAyNi4wOTIyIDQuMDg5ODQgMjYuMTY2NyA0LjMxNTk5QzI2LjE2NjcgNC4zMTg2NSAyNi4xNjY3IDQuMzE4NjUgMjYuMTY5NCA0LjMyMTMxQzI2LjI1NzIgNC41OTAwMyAyNi4yNjI1IDQuODgwMDMgMjYuMTg4IDUuMTU0MDdDMjYuMTU4OCA1LjI2MDUgMjYuMTIxNSA1LjM3NDkgMjYuMDc2MyA1LjQ5MTk3QzI2LjAyMzEgNS42MzAzMiAyNS45NjE5IDUuNzU1MzcgMjUuOTAzMyA1Ljg2NzExSDI1LjkwNkMyNS43NTQ0IDYuMTkxNyAyNS44NzY3IDYuNTg1NDcgMjYuMTk4NyA2Ljc2MTA3QzI2LjUzMTIgNi45MzQwMSAyNi45NTE2IDYuODExNjIgMjcuMTMyNSA2LjQ3OTA1WiIgZmlsbD0iIzIxMzI0RiIvPgo8cGF0aCBkPSJNMTkuNTEzNiAxNS4yNDgzQzE5LjMzODIgMTQuNzQ0NSAxOS4wMzUzIDE0LjQ0MTUgMTguOTY1MSAxNC4zNzQ2QzE4Ljg3OSAxNC4yOTE3IDE4LjY3NDkgMTQuMTA5OSAxOC4zNTkyIDEzLjk2OTZDMTcuOTc5OCAxMy44MDA2IDE3LjY0ODEgMTMuNzg0NiAxNy41NTU3IDEzLjc4MTVDMTYuNzIzNCAxMy43MzY4IDE1LjM1NTQgMTMuNjQ3NSAxNC4zNzk2IDEzLjIzOTRDMTIuOTI1NSAxMi42MjcxIDEyLjA2MTMgMTEuMTY2NiAxMS45NDAxIDEwLjg3MDFDMTEuOTI3NCAxMC44MzgyIDExLjg3IDEwLjY4ODMgMTEuNzU1MiAxMC41MDk3QzExLjcxNjkgMTAuNDUyMyAxMS41ODMgMTAuMjQ4MiAxMS4zNDcgMTAuMDQ0MkMxMS4yMzg2IDkuOTQ4NDkgMTAuOTE5NyA5LjY4MDYzIDEwLjQ0MTQgOS41NTYyN0M5LjczMzQ4IDkuMzc0NTEgOS4xNDM1NSA5LjYzMjggOS4wMTkxOCA5LjY4NzAxQzguMzIwODMgMTAuMDA5MSA3Ljc1NjQxIDEwLjczOTMgNy43MzA5IDExLjYxNjJDNy43MDg1OCAxMi4zNTYxIDguMDY4OTEgMTMuMDA2NiA4LjU1NjggMTMuMzkyNEM4Ljk5Njg2IDEzLjc0MzIgOS41MTk4MyAxMy44MjkzIDkuNTgzNiAxMy44Mzg5QzkuNzU1OCAxMy44Njc2IDkuODgzMzUgMTMuODY3NiA5LjkxODQzIDEzLjg2NzZDMTAuNTI3NSAxMy44NzM5IDEyLjg0NTggMTQuNTY5MSAxNC42OTIxIDE2LjE4OUMxMy45MDEzIDE3LjAyNDUgMTIuODk2OCAxNy42NTI3IDExLjc2NDggMTcuOTgxMUMxMS4yNDUgMTguMTMxIDEwLjc5MjIgMTguMTkxNiAxMC41MDIgMTguMjE3MUMxMC40NTczIDE4LjIyMDMgOS44MTAwMSAxOC4yNzQ1IDkuMTQ5OTIgMTguMTk0OEM3Ljk5NTU3IDE4LjA1NzcgNi4yMDk4MyAxNy40NDIyIDQuODk5MjIgMTUuODg2MUM0LjY3MjgxIDE1LjYxODIgNC4zMDYxIDE1LjEzMzUgMy45ODcyMiAxNC40NTQzQzMuODY2MDQgMTQuMTkyOCAzLjM3MTc3IDEzLjA4NjMgMy4zNzQ5NiAxMS42ODY0QzMuMzgxMzQgOS4wODExMyA1LjEwNjQ5IDYuOTEyNzMgNi41OTI0OSA2LjA0MjE4QzcuMzM1NDggNS42MDg1IDguMzY4NjYgNS4yOTYgOC45MzMwOCA1LjIwNjcxQzkuMDE5MTggNS4xOTM5NiA5LjEwNTI4IDUuMTgxMiA5LjE4NSA1LjE3NDgyQzkuMTAyMDkgNS4xODQzOSA5LjAxNTk5IDUuMTkzOTYgOC45MzMwOCA1LjIwNjcxQzkuMTYyNjggNS4xNzgwMSA5LjM4MjcxIDUuMTU4ODggOS41OTMxNyA1LjE0NjEyQzkuNjUzNzYgNS4xMzk3NSA5LjcxNDM1IDUuMTM5NzUgOS43NzQ5MyA1LjEzNjU2QzEwLjEwMDIgNS4xMzMzNyAxMC4zOTM2IDUuMTQ5MzEgMTAuNDI1NSA1LjE0OTMxQzEwLjk5OTQgNS4xOTA3NyAxNC41MTY3IDYuNDAyNTIgMTUuNDkyNSA4LjI3NDM2QzE1LjU0MzUgOC4zNzMyMSAxNS42Njc5IDguNjI4MzIgMTUuOTI5NCA4Ljg4MzQzQzE2LjUzMjEgOS40NzMzNiAxNy4zMDA2IDkuNTIxMTkgMTcuMzY3NSA5LjUyNDM4QzE4LjI4NTkgOS41NjkwMiAxOC44ODg2IDkuMDA3NzkgMTguOTg0MyA4LjkxNTMxQzE5LjA2NCA4LjgzODc4IDE5LjcyMDkgOC4xODUwNyAxOS42NTA3IDcuMTgwNTlDMTkuNjQxMiA3LjA0OTg1IDE5LjU4MDYgNi4zNTE1IDE5LjAwOTggNS43ODM4OUMxOC45MyA1LjcwNDE3IDE4LjU1MzggNS4zNDM4MyAxNy45NTc1IDUuMjAzNTJDMTcuNzUwMiA1LjE1NTY5IDE3LjU5MDcgNS4xNTI1IDE3LjUwMTUgNS4xNDkzMUMxNi43MjAyIDUuMTI2OTkgMTUuOTQyMSA1LjEwNDY3IDE1LjQ3MzQgNS4wMjE3NkMxNC4zMTU4IDQuODIwODYgMTMuNDg5OSA0LjAwMTM0IDEzLjIwNjEgMy42OTg0QzEyLjgwNDMgMy4yNzEwOSAxMi41MDc4IDIuODgyMDYgMTIuNTA3OCAyLjg4MjA2QzEyLjEzNzkgMi4zNDYzNCAxMi4xMTIzIDIuMDg4MDQgMTEuNzA3NCAxLjYxOTI4QzExLjUxOTIgMS40MDI0NCAxMS4zNDcgMS4yMDQ3NCAxMS4wNDczIDEuMDM1NzNDMTAuNjI5NSAwLjc5OTc1NiAxMC4yMjE0IDAuNzU4MzAxIDkuOTkxNzcgMC43NTgzMDFDOS44MjI3NyAwLjc1ODMwMSA5LjU1NDkgMC43Nzc0MzQgOS4yNDg3OCAwLjg4NTg1NEM5LjEwNTI4IDAuOTM2ODc1IDguNjQyOSAxLjExODY0IDguMjc2MTkgMS41Nzc4M0M4LjEzNTg4IDEuNzUzMjEgOC4wNjU3MiAxLjg5OTkgOC4wMjEwOCAxLjk4NkM3LjY1NDM3IDIuNzA2NjcgNy4xMTIyNiAzLjMyODQ5IDYuOTI3MzEgMy41MjYyQzYuMTIzNzMgNC4zOTAzNyA1LjA4NDE3IDQuNzIyMDEgNC45MjQ3MyA0Ljc2NjY1QzQuMjEzNjIgNC45Njc1NSAzLjkyNjYzIDQuODI0MDUgMi4yNDkzMSA1LjExNDI0QzEuODA5MjUgNS4xOTA3NyAxLjY4NDg5IDUuMjI1ODQgMS41MzgyIDUuMjkyODFDMC44MDc5NTkgNS42Mjc2NCAwLjI2NTg1OSA2LjQzMTIyIDAuMjMzOTcxIDcuMjI1MjRDMC4yMTgwMjcgNy42NjUzIDAuMzYxNTI0IDguMDQ0NzcgMC4zNzEwOSA4LjA2NzA5QzAuNDA2MTY3IDguMTU5NTYgMC40NTA4MTEgOC4yNDg4NSAwLjYwMzg3NCA4LjUxMDMzQzAuNzg4ODI2IDguODI2MDMgMC44ODQ0OTEgOC45ODU0NyAxLjEwNDUyIDkuMzA0MzVDMS41NzAwOSA5Ljk4Njc2IDEuNzg2OTMgMTEuNTUyNSAxLjQ0NTcyIDEyLjgwODlDMS4zNjI4MSAxMy4xMDg2IDEuMjU3NTggMTMuMzg5MiAxLjA3NTgyIDEzLjg1NDhDMC45Njc0MDEgMTQuMTM1NCAwLjg1NTc5MiAxNC40MDAxIDAuNjU0ODk2IDE0LjcwNjJDMC41ODQ3NDIgMTQuODExNSAwLjU0OTY2NCAxNC44NTYxIDAuNTExMzk5IDE0LjkwNzFDMC4wNjE3NzQ0IDE1LjU0NDkgMC4xODkzMjcgMTYuMzAwNiAwLjIwMjA4MyAxNi4zOTMxQzAuMjE4MDI3IDE2LjUwNzkgMC4yNTk0ODEgMTYuNzEyIDAuMzY0NzEzIDE2Ljk0OEMwLjQxMjU0NSAxNy4wNTMyIDAuNjM1NzYzIDE3LjUzNDcgMS4xMzk2IDE3Ljg3NTlDMS41NDEzOSAxOC4xNDcgMS45Mzk5OSAxOC4yMDQ0IDIuMTEyMTkgMTguMjMzMUM0LjUzMjUxIDE4LjY1MDggNS45MjYwMiAxOC45MDI3IDYuNjg0OTYgMTkuNjU4NUM3LjE0MDk2IDIwLjExNDUgNy40MjE1OCAyMC41MDY3IDcuNDIxNTggMjAuNTA2N0M3LjY5OTAxIDIwLjkyNzYgNy43MzcyNyAyMS4xNTQgOC4wNzg0OCAyMS41OTQxQzguMjU3MDUgMjEuODIzNyA4LjM5NzM2IDIyLjAwNTQgOC42MzY1MiAyMi4xNzc2QzkuMjI5NjQgMjIuNjA0OSA5Ljg4NjU0IDIyLjU5MjIgOS45OTQ5NiAyMi41ODlDMTAuNzQ0MyAyMi41NjM1IDExLjI4MzIgMjIuMTU4NSAxMS41MTYgMjEuOTA2NkMxMS42MzcyIDIxLjc3NTggMTEuNzM5MiAyMS42MTk2IDExLjczOTIgMjEuNjE5NkMxMS45MzcgMjEuMzE5OCAxMi4wMDcxIDIxLjA0ODggMTIuMDMyNiAyMC45NzIzQzEyLjE2MzQgMjAuNTQxOCAxMi41NTU2IDIwLjE1OTEgMTIuOTUxIDE5Ljc3NjVDMTMuMjQ3NiAxOS40ODk1IDE0LjAyODggMTguNzMzNyAxNS4yMDIzIDE4LjQ2OUMxNi4yMzIzIDE4LjIzNjIgMTYuODE1OSAxOC41NTE5IDE4LjA2OTEgMTguMDczNkMxOC4xNjE1IDE4LjAzODUgMTguMjQxMyAxOC4wMDM1IDE4LjMxMTQgMTcuOTc0OEMxOC4zNjU2IDE3Ljk1NTYgMTguMzk3NSAxNy45Mzk3IDE4LjQwNzEgMTcuOTMzM0MxOC41MTU1IDE3Ljg4MjMgMTkuMzE1OSAxNy40ODM3IDE5LjU3NDIgMTYuNTYyMUMxOS43NDk2IDE1Ljk0NjcgMTkuNTc0MiAxNS40MjA1IDE5LjUxMzYgMTUuMjQ4M1pNOS4zMDkzNyA1LjE2NTI2QzkuNDUyODYgNS4xNTI1IDkuNTU0OSA1LjE0NjEyIDkuNTU0OSA1LjE0NjEyQzkuNDcxOTkgNS4xNDkzMSA5LjM5MjI3IDUuMTU1NjkgOS4zMDkzNyA1LjE2NTI2WiIgZmlsbD0idXJsKCNwYWludDBfcmFkaWFsXzQ4NjZfNjgyKSIvPgo8ZGVmcz4KPHJhZGlhbEdyYWRpZW50IGlkPSJwYWludDBfcmFkaWFsXzQ4NjZfNjgyIiBjeD0iMCIgY3k9IjAiIHI9IjEiIGdyYWRpZW50VW5pdHM9InVzZXJTcGFjZU9uVXNlIiBncmFkaWVudFRyYW5zZm9ybT0idHJhbnNsYXRlKDMuMjQ1NiAxMy41MTI0KSByb3RhdGUoMjcuMjU2OCkgc2NhbGUoMTAuNDkzOCAxMS4wNTczKSI+CjxzdG9wIHN0b3AtY29sb3I9IiMwRDlCMTciLz4KPHN0b3Agb2Zmc2V0PSIwLjE5NjIiIHN0b3AtY29sb3I9IiMzMEE1MjEiLz4KPHN0b3Agb2Zmc2V0PSIwLjQxOSIgc3RvcC1jb2xvcj0iIzUxQUQyQiIvPgo8c3RvcCBvZmZzZXQ9IjAuNjMyNyIgc3RvcC1jb2xvcj0iIzY5QjQzMiIvPgo8c3RvcCBvZmZzZXQ9IjAuODMxMyIgc3RvcC1jb2xvcj0iIzc3QjgzNyIvPgo8c3RvcCBvZmZzZXQ9IjEiIHN0b3AtY29sb3I9IiM3Q0I5MzgiLz4KPC9yYWRpYWxHcmFkaWVudD4KPC9kZWZzPgo8L3N2Zz4K'));
}
if(isset($_GET['mode']) and $_GET['mode'] == 'getzdoo')
{
    if($acceptLang == 'en') die(base64_decode('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'));
    die(base64_decode('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'));
}
if(isset($_GET['mode']) and $_GET['mode'] == 'getxuanxuan')
{
    if($acceptLang == 'en') die(base64_decode('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'));
    die(base64_decode('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'));
}
if(isset($_GET['mode']) and $_GET['mode'] == 'getzendata')
{
    if($acceptLang == 'en') die(base64_decode('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'));
    die(base64_decode('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'));
}
if(isset($_GET['mode']) and $_GET['mode'] == 'getztf')
{
    if($acceptLang == 'en') die(base64_decode('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'));
    die(base64_decode('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'));
}
if(isset($_GET['mode']) and $_GET['mode'] == 'getzendas')
{
    if($acceptLang == 'en') die(base64_decode('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'));
    die(base64_decode('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'));
}

$config = new stdclass();
$config->langs['cn'] = '简体';
$config->langs['en'] = 'English';

$lang = new stdclass();

$lang->logos['xuanxuan'] = 'xuanxuan';
$lang->logos['zendas']   = 'zendas';
$lang->logos['qucheng']  = 'qucheng';
$lang->logos['zdoo']     = 'zdoo';
$lang->logos['ztf']      = 'ztf';
$lang->logos['zendata']  = 'zendata';

$lang->cn = new stdclass();
$lang->cn->links['biz']['link']   = 'index.php?edition=biz';
$lang->cn->links['biz']['text']   = '企业版';
$lang->cn->links['biz']['target'] = '_self';

$lang->cn->links['max']['link']   = 'index.php?edition=max';
$lang->cn->links['max']['text']   = '旗舰版';
$lang->cn->links['max']['target'] = '_self';

$lang->cn->links['ipd']['link']   = 'index.php?edition=ipd';
$lang->cn->links['ipd']['text']   = 'IPD版';
$lang->cn->links['ipd']['target'] = '_self';

$lang->cn->title      = '欢迎使用禅道集成运行环境！';
$lang->cn->official   = " <a href='https://www.zentao.net' target='_blank'>禅道官网</a>";
$lang->cn->adminer    = "<a href='/adminer/?server=127.0.0.1:3306&username=root' target='_blank'>数据库管理</a>";
$lang->cn->others     = '禅道软件旗下产品:';
$lang->cn->api        = 'http://api.zentao.net/';

$lang->en = new stdclass();
$lang->en->links['biz']['link']   = 'index.php?edition=biz';
$lang->en->links['biz']['text']   = 'ZenTao Biz';
$lang->en->links['biz']['target'] = '_self';

$lang->en->links['max']['link']   = 'index.php?edition=max';
$lang->en->links['max']['text']   = 'ZenTao Max';
$lang->en->links['max']['target'] = '_self';

$lang->en->links['ipd']['link']   = 'index.php?edition=ipd';
$lang->en->links['ipd']['text']   = 'ZenTao IPD';
$lang->en->links['ipd']['target'] = '_self';

$lang->en->title    = 'Welcome to zentao!';
$lang->en->official = " <a href='https://www.zentao.pm' target='_blank'>Community</a>";
$lang->en->adminer  = "<a href='/adminer/' target='_blank'>MySQL</a>";
$lang->en->others   = 'Products also from ZenTao Software Co., LTD:';
$lang->en->api      = 'http://api.zentao.pm/';

if($initEdition && empty($_GET['change']))
{
    $link = $lang->cn->links[$currentEdition];
    $link['link'] = "/zentao/";
    $lang->cn->links = array();
    $lang->cn->links[$currentEdition] = $link;
    $lang->cn->links['change']['link']   = 'index.php?change=1';
    $lang->cn->links['change']['text']   = '修改版本';
    $lang->cn->links['change']['target'] = '_self';

    $link = $lang->en->links[$currentEdition];
    $link['link'] = "/zentao/";
    $lang->en->links = array();
    $lang->en->links[$currentEdition] = $link;
    $lang->en->links['change']['link']   = 'index.php?change=1';
    $lang->en->links['change']['text']   = 'Change Edition';
    $lang->en->links['change']['target'] = '_self';
}

$clientLang = $lang->$acceptLang;
?>
<html xmlns='http://www.w3.org/1999/xhtml'>
<head>
  <meta http-equiv='Content-Type' content='text/html; charset=utf-8' />
  <title><?php echo $clientLang->title;?></title>
  <link rel='stylesheet' href='/zentao/theme/zui/css/min.css' type='text/css' media='screen' />
  <link rel='stylesheet' href='/zentao/theme/default/style.css' type='text/css' media='screen' />
<style>
#welcome{font-size:20px; border-bottom:1px solid #efefef; padding:10px}
#logo{width:120px; border-right:1px solid #efefef}
body {background: #1183fb linear-gradient(-90deg, #0a48d1 0%, #1183fb 100%); background-color: #1183fb;}
.container{padding: 0}
.modal-dialog{width: 800px}
.modal-footer{text-align: center;margin-top: 0; padding: 10px 15px;}

.modal-dialog{position: relative; margin-top: 10%;}
.modal-header{border:0px;}
.modal-body {padding: 0px 60px 20px 60px;}
.modal-body .logo img {width: 224px;}
.modal-body .version-btns {padding: 28px 0 25px 8px;}
.modal-body .other-tip {display: flex; flex-direction: row; color: #C4C4C4;}
.modal-body .other-tip:before, .modal-body .other-tip:after {content: ''; flex: 1 1; border-bottom: 1px transparent solid; margin: auto;}
.modal-body .other-tip:before {margin-right: 10px; border-image: linear-gradient(to left, #c4c4c4, #fff) 1 10;}
.modal-body .other-tip:after {margin-left: 10px; border-image: linear-gradient(to right, #c4c4c4, #fff) 1 10;}
.modal-body .others {margin-top: 10px;}
.modal-body .others .table {margin-bottom: 0; margin-left: 40px;}

.nav>li>a {padding: 5px 10px; color: #838A9D;}
.nav>li>button {color: #999}
.nav.nav-pills > li.active > a, .nav.nav-pills > li.active > a:hover, .nav.nav-pills > li.active > a:focus {background: none; color: #1a4f85}
</style>
</head>
<script src='/zentao/js/jquery/lib.js' type='text/javascript'></script>
<body>
<div class='container'>
  <div class='modal-dialog' style="width: 700px">
    <div class='modal-header'>
      <ul class='nav nav-pills'>
        <li class="dropdown dropdown-hover">
          <button class='btn btn-sm'><?php echo $config->langs[$acceptLang];?> <span class="caret"></span></button>
          <ul class="dropdown-menu">
            <?php foreach($config->langs as $langCode => $langName):?>
            <?php $activeClass = $langCode == $acceptLang ? 'active' : '';?>
            <li class='<?php echo $activeClass;?>'>
              <a href='?lang=<?php echo $langCode;?>'><?php echo $langName;?></a>
            </li>
            <?php endforeach;?>
          </ul>
        </li>
        <li><?php echo $clientLang->official ?></li>
        <li><?php echo $clientLang->adminer ?></li>
      </ul>
    </div>
    <div class='modal-content'>
      <div class='modal-body text-center'>
        <div class="text-center logo">
          <img src='?mode=getlogo' />
        </div>
        <div class='version-btns'>
        <?php
        foreach($clientLang->links as $linkID => $link)
        {
            $primaryClass = $linkID == $currentEdition ? 'btn-primary' : '';
            echo "<a id='$linkID' href='$link[link]' class='btn $primaryClass' target='$link[target]'>$link[text]</a> &nbsp; &nbsp; ";
        }
        ?>
        </div>
        <div style='text-align:center'>
          <p>默认管理员账号如下，请登录成功后再重置</p>
          <p>用户名：admin&nbsp;&nbsp;&nbsp;密码：123456</p>
        </div>
        <div class='other-tip text-center'><?php echo $clientLang->others;?></div>
        <div class='row others <?php echo $acceptLang;?>'>
          <table class='table table-borderless'>
          <?php $index = 0;?>
          <?php foreach($lang->logos as $productKey => $logo):?>
          <?php if($index % 3 == 0) echo "<tr>";?>
            <td class='text-left <?php echo $productKey;?>'>
              <a href='<?php echo $clientLang->api . "goto.php?item={$productKey}";?>' target='_blank'>
                <img src='?mode=get<?php echo $logo;?>&lang=<?php echo $acceptLang;?>' />
              </a>
            </td>
          <?php if($index % 3 == 2) echo "</tr>";?>
          <?php $index++;?>
          <?php endforeach;?>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
</body>
<?php if(!$initEdition || !empty($_GET['change'])):?>
<script>
$(function()
{
    $(document).on('click', '.version-btns a', function()
    {
        $('.version-btns a').addClass('disabled').attr("disabled",true).css("pointer-events","none");
    });
});
</script>
<?php endif;?>
<?php if($initEdition && empty($_GET['change']) && $currentEdition != 'open'):?>
<script>
$(function()
{
    $.getJSON('/zentao/api-getLicenses.html', function(data)
    {
        if(!data) return false;
        if(data.company == 'try')
        {
            <?php if($acceptLang == 'en'):?>
            $('#<?php echo $currentEdition;?>').prepend('<?php echo 'Try '?>');
            <?php else:?>
            $('#<?php echo $currentEdition;?>').append('<?php echo ' 试用'?>');
            <?php endif;?>
        }
        <?php
        $allLife    = $acceptLang == 'en' ? 'Permanent' : '永久授权';
        $expireDate = $acceptLang == 'en' ? 'Expiration : ' : '到期时间：';
        $unlimited  = $acceptLang == 'en' ? 'Unlimited Users' : '不限人数';
        $limitUser  = $acceptLang == 'en' ? 'Licensed Users : ' : '授权人数：';
        ?>
        var expireDate = data.expireDate.toLowerCase() == 'all life' ? '<?php echo $allLife;?>' : '<?php echo $expireDate;?>' + data.expireDate;
        var users      = data.user == 0 ? '<?php echo $unlimited;?>' : '<?php echo $limitUser;?>' + data.user;
        $('#<?php echo $currentEdition;?>').attr('title', expireDate + ', ' + users);
    });
});
</script>
<?php endif;?>
</html>
