<?php

namespace Spiral\RoadRunner\Console\Configuration\Section;

final class Reload extends AbstractSection
{
    const NAME = 'reload';

    public function render()
    {
        return [
            self::NAME => [
                'interval' => '1s',
                'patterns' => [
                    '.php'
                ],
                'services' => [
                    'http' => [
                        'dirs' => [
                            '.'
                        ],
                        'recursive' => true,
                        'ignore' => [
                            'vendor'
                        ],
                        'patterns' => [
                            '.php',
                            '.go',
                            '.md'
                        ]
                    ]
                ]
            ]
        ];
    }

    public static function getShortName()
    {
        return self::NAME;
    }
}
