<?php
/**
 * The action module English file of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.cnezsoft.com)
 * @license     ZPL(http://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Chunsheng Wang <chunsheng@cnezsoft.com>
 * @package     action
 * @version     $Id: en.php 4729 2013-05-03 07:53:55Z chencongzhi520@gmail.com $
 * @link        https://www.zentao.net
 */
global $config;

$lang->action->common        = 'Log';
$lang->action->id            = 'ID';
$lang->action->product       = $lang->productCommon;
$lang->action->project       = $lang->projectCommon;
$lang->action->execution     = $lang->execution->common;
$lang->action->objectType    = 'Object Type';
$lang->action->objectID      = 'ID';
$lang->action->objectName    = 'Object Name';
$lang->action->actor         = 'User';
$lang->action->action        = 'Action';
$lang->action->actionID      = 'Action ID';
$lang->action->date          = 'Date';
$lang->action->dateAB        = 'Action Date';
$lang->action->extra         = 'Extra';
$lang->action->system        = 'System';
$lang->action->url           = 'URL';
$lang->action->contentType   = 'Content Type';
$lang->action->data          = 'Data';
$lang->action->result        = 'Result';
$lang->action->modified      = 'Modified';
$lang->action->old           = 'Old';
$lang->action->new           = 'New';
$lang->action->to            = 'To';
$lang->action->superReviewer = 'Super Reviewer';

$lang->action->trash         = 'Recycle';
$lang->action->undelete      = 'Restore';
$lang->action->hideOne       = 'Hide';
$lang->action->hideAll       = 'Hide All';
$lang->action->editComment   = 'Edit Comment';
$lang->action->create        = 'Add Comment';
$lang->action->comment       = 'Comment';
$lang->action->actioncomment = 'Comment';
$lang->action->lastComment   = 'Comment';
$lang->action->byQuery       = 'Search';

$lang->action->trashAction    = 'Recycle List';
$lang->action->undeleteAction = 'Reset Data';
$lang->action->hideOneAction  = 'Hide Data';

$lang->action->refusecase   = 'Before restoring the use case, please restore the scene to which the use case belongs';
$lang->action->refusescene  = 'Before restoring the scene, please restore the parent scene of this scene ';
$lang->action->refusemodule = 'Before restoring the module, please restore the parent module of this module ';
$lang->action->refusekanban = 'Before restoring the Kanban board, make sure to restore the space it belongs to';

$lang->action->trashTips          = 'Note: Delete in ZenTao is logic.';
$lang->action->textDiff           = 'Text Format';
$lang->action->original           = 'Original Format';
$lang->action->confirmHideAll     = 'Do you want to hide all the records?';
$lang->action->needEdit           = '%s that you want to restore. Please edit it.';
$lang->action->historyEdit        = 'The history EditBy cannot be empty.';
$lang->action->noDynamic          = 'No dynamics. ';
$lang->action->undeletedTips      = 'This data did not participate in the merging process during the version upgrade process, so restore is not supported.';
$lang->action->executionNoProject = "The execution does not belong to a {$lang->projectCommon},please restore the {$lang->projectCommon} first";
$lang->action->repoNoServer       = 'The repo does not belong to a server,please restore the server first';
$lang->action->hasCreatedTask     = 'Tasks have been created in this parent phase and cannot be restored!';
$lang->action->hasDeletedParent   = 'Restoring this phase requires restoring the deleted parent phase %s at the same time.';
$lang->action->hasChangedAttr     = "After recovery, the phase type will be adjusted to '%s' according to the parent phase type.";
$lang->action->whetherToRestore   = 'Confirm to restore?';
$lang->action->undeleteModuleTip  = 'Once the subdirectory has been restored, its parent directory will also be automatically recovered and synchronized, would you like to proceed with restoring the directory?';
$lang->action->undeleteTaskTip    = 'The execution associated with this task has been removed. If you choose to restore it, the task will no longer be visible. Would you like to proceed with restoring the task?';
$lang->action->undeleteBoardTip   = 'Before restoring the board, please restore its affiliated space first.';

$lang->action->hasOtherType = array();
$lang->action->hasOtherType['stage']  = "Only subtypes of {$lang->executionCommon} / Kanban types can be created at this parent stage, so the current stage cannot be restored.";
$lang->action->hasOtherType['sprint'] = "Only subtypes of Stage types can be created at this parent stage, so the current {$lang->executionCommon} cannot be restored.";
$lang->action->hasOtherType['kanban'] = "Only subtypes of Stage types can be created at this parent stage, so the current Kanban cannot be restored.";

$lang->action->repeatChange     = '%s with the same name and code already exists in the system, After recovery, the name are \"%s\",the code are \"%s\".';
$lang->action->nameRepeatChange = '%s with the same name already exists in the system, After recovery, the name are \"%s\".';
$lang->action->codeRepeatChange = '%s with the same code already exists in the system, After recovery, the code are \"%s\".';

$lang->action->history = new stdclass();
$lang->action->history->action = 'Link';
$lang->action->history->field  = 'Field';
$lang->action->history->old    = 'Old value';
$lang->action->history->new    = 'New value';
$lang->action->history->diff   = 'Compare';

$lang->action->dynamic = new stdclass();
$lang->action->dynamic->today      = 'Today';
$lang->action->dynamic->yesterday  = 'Yesterday';
$lang->action->dynamic->twoDaysAgo = '2 Days Ago';
$lang->action->dynamic->thisWeek   = 'This Week';
$lang->action->dynamic->lastWeek   = 'Last Week';
$lang->action->dynamic->thisMonth  = 'This Month';
$lang->action->dynamic->lastMonth  = 'Last Month';
$lang->action->dynamic->all        = 'All';
$lang->action->dynamic->hidden     = 'Hidden';
$lang->action->dynamic->search     = 'Search';

$lang->action->objectTypes['product']          = $lang->productCommon;
$lang->action->objectTypes['branch']           = 'Branch';
$lang->action->objectTypes['epic']             = $lang->ERCommon;
$lang->action->objectTypes['story']            = $lang->SRCommon;
$lang->action->objectTypes['requirement']      = $lang->URCommon;
$lang->action->objectTypes['design']           = 'Design';
$lang->action->objectTypes['productplan']      = 'Plan';
$lang->action->objectTypes['release']          = 'Release';
$lang->action->objectTypes['program']          = 'Program';
$lang->action->objectTypes['project']          = $lang->projectCommon;
$lang->action->objectTypes['execution']        = $lang->executionCommon;
$lang->action->objectTypes['task']             = 'Task';
$lang->action->objectTypes['build']            = 'Build';
$lang->action->objectTypes['projectbuild']     = 'Project Build';
$lang->action->objectTypes['job']              = 'Pipeline';
$lang->action->objectTypes['bug']              = 'Bug';
$lang->action->objectTypes['case']             = 'Case';
$lang->action->objectTypes['caseresult']       = 'Case Result';
$lang->action->objectTypes['stepresult']       = 'Case Steps';
$lang->action->objectTypes['caselib']          = 'Library';
$lang->action->objectTypes['testsuite']        = 'Suite';
$lang->action->objectTypes['testtask']         = 'Test Build';
$lang->action->objectTypes['testreport']       = 'Report';
$lang->action->objectTypes['zahost']           = 'Host';
$lang->action->objectTypes['zanode']           = 'ZA Node';
$lang->action->objectTypes['doc']              = 'Document';
$lang->action->objectTypes['api']              = 'Interface';
$lang->action->objectTypes['doclib']           = 'Document Library';
$lang->action->objectTypes['docspace']         = 'Document Space';
$lang->action->objectTypes['apistruct']        = 'API struct';
$lang->action->objectTypes['todo']             = 'Todo';
$lang->action->objectTypes['risk']             = 'Risk';
$lang->action->objectTypes['issue']            = 'Issue';
$lang->action->objectTypes['module']           = 'Module';
$lang->action->objectTypes['user']             = 'User';
$lang->action->objectTypes['stakeholder']      = 'Stakeholder';
$lang->action->objectTypes['budget']           = 'Cost Estimate';
$lang->action->objectTypes['entry']            = 'Entry';
$lang->action->objectTypes['webhook']          = 'Webhook';
$lang->action->objectTypes['team']             = 'Team';
$lang->action->objectTypes['whitelist']        = 'Whitelist';
$lang->action->objectTypes['pipeline']         = 'GitLab Server';
$lang->action->objectTypes['gitlab']           = 'GitLab Server';
$lang->action->objectTypes['gitea']            = 'Gitea Server';
$lang->action->objectTypes['gogs']             = 'Gogs Server';
$lang->action->objectTypes['jenkins']          = 'Jenkins';
$lang->action->objectTypes['nexus']            = 'Nexus';
$lang->action->objectTypes['mr']               = 'Merge Requests';
$lang->action->objectTypes['gitlabproject']    = 'GitLab Project';
$lang->action->objectTypes['gitlabuser']       = 'GitLab User';
$lang->action->objectTypes['gitlabgroup']      = 'GitLab Group';
$lang->action->objectTypes['gitlabbranch']     = 'GitLab Branch';
$lang->action->objectTypes['gitlabbranchpriv'] = 'GitLab Protected Branches';
$lang->action->objectTypes['gitlabtag']        = 'GitLab Tag';
$lang->action->objectTypes['gitlabtagpriv']    = 'GitLab Tag Protected';
$lang->action->objectTypes['giteauser']        = 'Gitea User';
$lang->action->objectTypes['gogsuser']         = 'Gogs User';
$lang->action->objectTypes['kanbanspace']      = 'Kanban Space';
$lang->action->objectTypes['kanban']           = 'Kanban';
$lang->action->objectTypes['kanbanregion']     = 'Kanban Region';
$lang->action->objectTypes['kanbanlane']       = 'Kanban Lane';
$lang->action->objectTypes['kanbancolumn']     = 'Kanban Column';
$lang->action->objectTypes['kanbancard']       = 'Kanban Card';
$lang->action->objectTypes['sonarqube']        = 'SonarQube Server';
$lang->action->objectTypes['sonarqubeproject'] = 'SonarQube Project';
$lang->action->objectTypes['stage']            = 'Stage';
$lang->action->objectTypes['patch']            = 'Patch';
$lang->action->objectTypes['repo']             = 'Repo';
$lang->action->objectTypes['dataview']         = 'Data View';
$lang->action->objectTypes['privlang']         = 'Priv';
$lang->action->objectTypes['scene']            = 'Scene';
$lang->action->objectTypes['pivot']            = 'Pivot';
$lang->action->objectTypes['privpackage']      = 'Priv Package';
$lang->action->objectTypes['serverroom']       = 'IDC';
$lang->action->objectTypes['account']          = 'Account';
$lang->action->objectTypes['host']             = 'Host';
$lang->action->objectTypes['deploy']           = 'Deploy';
$lang->action->objectTypes['service']          = 'Service';
$lang->action->objectTypes['domain']           = 'Domain';
$lang->action->objectTypes['prompt']           = 'Prompt';
$lang->action->objectTypes['miniprogram']      = 'Mini Program';
$lang->action->objectTypes['metric']           = 'Metric';
$lang->action->objectTypes['projectbuild']     = 'Build';
$lang->action->objectTypes['board']            = 'Board';
$lang->action->objectTypes['boardspace']       = 'Board Space';
$lang->action->objectTypes['productline']      = 'Product Line';
$lang->action->objectTypes['system']           = $lang->product->system;

/* Used to describe operation history. */
$lang->action->desc = new stdclass();
$lang->action->desc->common               = '$date, <strong>$action</strong> by <strong>$actor</strong>.' . "\n";
$lang->action->desc->extra                = '$date, <strong>$action</strong> as <strong>$extra</strong> by <strong>$actor</strong>.' . "\n";
$lang->action->desc->opened               = '$date, created by <strong>$actor</strong> .' . "\n";
$lang->action->desc->openedbysystem       = '$date, opened by system.' . "\n";
$lang->action->desc->created              = '$date, created by  <strong>$actor</strong> .' . "\n";
$lang->action->desc->added                = '$date, added by  <strong>$actor</strong> .' . "\n";
$lang->action->desc->changed              = '$date, changed by <strong>$actor</strong> .' . "\n";
$lang->action->desc->edited               = '$date, edited by <strong>$actor</strong> .' . "\n";
$lang->action->desc->assigned             = '$date, <strong>$actor</strong> assigned to <strong>$extra</strong>.' . "\n";
$lang->action->desc->closed               = '$date, closed by <strong>$actor</strong> .' . "\n";
$lang->action->desc->closedbysystem       = '$date, closed by system.' . "\n";
$lang->action->desc->closedbyparent       = '$date, closed by system.' . "\n";
$lang->action->desc->deleted              = '$date, deleted by <strong>$actor</strong> .' . "\n";
$lang->action->desc->deletedfile          = '$date, <strong>$actor</strong> deleted <strong><i>$extra</i></strong>.' . "\n";
$lang->action->desc->editfile             = '$date, <strong>$actor</strong> edited <strong><i>$extra</i></strong>.' . "\n";
$lang->action->desc->erased               = '$date, deleted by <strong>$actor</strong> .' . "\n";
$lang->action->desc->undeleted            = '$date, restored by <strong>$actor</strong> .' . "\n";
$lang->action->desc->hidden               = '$date, hidden by <strong>$actor</strong> .' . "\n";
$lang->action->desc->commented            = '$date, added by <strong>$actor</strong>.' . "\n";
$lang->action->desc->activated            = '$date, activated by <strong>$actor</strong> .' . "\n";
$lang->action->desc->blocked              = '$date, blocked by <strong>$actor</strong> .' . "\n";
$lang->action->desc->moved                = '$date, moved by <strong>$actor</strong> .' . "\n";
$lang->action->desc->confirmed            = '$date, <strong>$actor</strong> confirmed the story change. The latest build is <strong>#$extra</strong>.' . "\n";
$lang->action->desc->caseconfirmed        = '$date, <strong>$actor</strong> confirmed the case change. The latest build is <strong>#$extra</strong>' . "\n";
$lang->action->desc->bugconfirmed         = '$date, <strong>$actor</strong> confirmed Bug.' . "\n";
$lang->action->desc->frombug              = '$date, converted from <strong>$actor</strong>. Its ID was <strong>$extra</strong>.';
$lang->action->desc->started              = '$date, started by <strong>$actor</strong>.' . "\n";
$lang->action->desc->restarted            = '$date, continued by <strong>$actor</strong>.' . "\n";
$lang->action->desc->delayed              = '$date, postponed by <strong>$actor</strong>.' . "\n";
$lang->action->desc->suspended            = '$date, suspended by <strong>$actor</strong>.' . "\n";
$lang->action->desc->recordworkhour       = '$date, recorded by <strong>$actor</strong> and it cost <strong>$extra</strong> hours.';
$lang->action->desc->recordestimate       = '$date, recorded by <strong>$actor</strong> and it cost <strong>$extra</strong> hours.';
$lang->action->desc->editestimate         = '$date, <strong>$actor</strong> edited Hour.';
$lang->action->desc->editeffort           = '$date, <strong>$actor</strong> edited Hour.';
$lang->action->desc->deleteestimate       = '$date, <strong>$actor</strong> deleted Hour.';
$lang->action->desc->canceled             = '$date, cancelled by <strong>$actor</strong>.' . "\n";
$lang->action->desc->svncommited          = '$date, <strong>$actor</strong> committed and the build is <strong>#$extra</strong>.' . "\n";
$lang->action->desc->gitcommited          = '$date, <strong>$actor</strong> committed and the build is <strong>#$extra</strong>.' . "\n";
$lang->action->desc->finished             = '$date, finished by <strong>$actor</strong>.' . "\n";
$lang->action->desc->paused               = '$date, paused by <strong>$actor</strong>.' . "\n";
$lang->action->desc->verified             = '$date, verified by <strong>$actor</strong>.' . "\n";
$lang->action->desc->diff1                = '<strong><i>%s</i></strong> is changed. It was "%s" and it is "%s".<br />' . "\n";
$lang->action->desc->diff2                = '<strong><i>%s</i></strong> is changed. The difference is ' . "\n" . "<blockquote class='textdiff'>%s</blockquote>" . "\n<blockquote class='original'>%s</blockquote>";
$lang->action->desc->diff3                = 'File Name %s was changed to %s .' . "\n";
$lang->action->desc->addDiff              = 'Added "%s"。' . "\n";
$lang->action->desc->removeDiff           = 'Removed "%s"。' . "\n";
$lang->action->desc->linked2bug           = '$date, linked to <strong>$extra</strong> by <strong>$actor</strong>';
$lang->action->desc->linked2testtask      = '$date, linked to <strong>$extra</strong> by <strong>$actor</strong>';
$lang->action->desc->unlinkedfromtesttask = '$date, unlinked from <strong>$extra</strong> by <strong>$actor</strong>';
$lang->action->desc->resolved             = '$date, resolved by <strong>$actor</strong> ' . "\n";
$lang->action->desc->managed              = '$date, by <strong>$actor</strong> managed.' . "\n";
$lang->action->desc->estimated            = '$date, by <strong>$actor</strong> estimated.' . "\n";
$lang->action->desc->run                  = '$date, by <strong>$actor</strong> executed.' . "\n";
$lang->action->desc->syncprogram          = '$date, started by <strong>$actor</strong>(starting the project sets the program status as Ongoing).' . "\n";
$lang->action->desc->syncproject          = '$date, starting the execution sets the ' . $lang->projectCommon . ' status as Ongoing.' . "\n";
$lang->action->desc->syncmultipleproject  = '$date, starting the task sets the ' . $lang->projectCommon . ' status as Ongoing.' . "\n";
$lang->action->desc->syncexecution        = '$date, starting the task sets the execution status as Ongoing.' . "\n";
$lang->action->desc->syncexecutionbychild = '$date, starting the sub stage sets the execution status as Ongoing.' . "\n";
$lang->action->desc->importfromgitlab     = '$date, Issue associate created from gitlab by <strong>$actor</strong>.' . "\n";
$lang->action->desc->archived             = '$date, archived by <strong>$actor</strong>.' . "\n";
$lang->action->desc->restore              = '$date, restore by <strong>$actor</strong>.' . "\n";
$lang->action->desc->importedcard         = '$date, imported to <strong>$extra</strong> by <strong>$actor</strong>.' . "\n";
$lang->action->desc->importedproductplan  = '$date, imported to <strong>$extra</strong> by <strong>$actor</strong>.' . "\n";
$lang->action->desc->importedrelease      = '$date, imported to <strong>$extra</strong> by <strong>$actor</strong>.' . "\n";
$lang->action->desc->importedexecution    = '$date, imported to <strong>$extra</strong> by <strong>$actor</strong>.' . "\n";
$lang->action->desc->importedbuild        = '$date, imported to <strong>$extra</strong> by <strong>$actor</strong>.' . "\n";
$lang->action->desc->importedticket       = '$date, imported to <strong>$extra</strong> by <strong>$actor</strong>.' . "\n";
$lang->action->desc->fromsonarqube        = '$date, created by <strong>$actor</strong> from <strong>SonarQube Issue</strong>.' . "\n";
$lang->action->desc->tolib                = '$date, imported by <strong>$actor</strong> .' . "\n";
$lang->action->desc->updatetolib          = '$date, updated to ' . $lang->testcase->common . ' by  <strong>$actor</strong>.' . "\n";
$lang->action->desc->adjusttasktowait     = '$date, System Reminder: The task status will be set to Not Started as the consumed work hour is adjusted to 0. ' . "\n";
$lang->action->desc->reopen               = '$date, reopened by <strong>$actor</strong> .' . "\n";
$lang->action->desc->merged               = '$date, merged by <strong>$actor</strong> .' . "\n";
$lang->action->desc->submitreview         = '$date, submitted for review by <strong>$actor</strong>.' . "\n";
$lang->action->desc->ganttmove            = '$date, sort by <strong>$actor</strong> .' . "\n";
$lang->action->desc->suspend              = '$date, the ZenAgent Node is suspended by <strong>$actor</strong> .' . "\n";
$lang->action->desc->resume               = '$date, the ZenAgent Node is resumed by <strong>$actor</strong> .' . "\n";
$lang->action->desc->reboot               = '$date, the ZenAgent Node is reboot by <strong>$actor</strong> .' . "\n";
$lang->action->desc->destroy              = '$date, the ZenAgent Node is destroyed by <strong>$actor</strong> .' . "\n";
$lang->action->desc->boot                 = '$date, the ZenAgent Node is boot by <strong>$actor</strong> .' . "\n";
$lang->action->desc->relieved             = '$date, relieved by <strong>$actor</strong> .' . "\n";
$lang->action->desc->switchtolight        = '$date, Switch from ALM mode to light mode by <strong>'. $lang->admin->system .'</strong>.' . "\n";
$lang->action->desc->getvnc               = '$date, Remote control <strong>$extra</strong> by <strong>$actor</strong> .' . "\n";
$lang->action->desc->unlinkproduct        = '$date, the ' . $lang->projectCommon . ' is disassociated from the $extra, synchronization disassociates the ' . $lang->executionCommon . 's of the ' . $lang->projectCommon . ' from the $extra.' . "\n";
$lang->action->desc->createdsnapshot      = '$date, <strong>$actor</strong> creates a snapshot <strong>$extra</strong>。' . "\n";
$lang->action->desc->restoredsnapshot     = '$date, <strong>$actor</strong> restored a snapshot <strong>$extra</strong>。' . "\n";
$lang->action->desc->editsnapshot         = '$date, <strong>$actor</strong> edited the snapshot <strong>$extra</strong>。' . "\n";
$lang->action->desc->deletesnapshot       = '$date, <strong>$actor</strong> deleted snapshot <strong>$extra</strong>。' . "\n";
$lang->action->desc->online               = '$date, set online by <strong>$actor</strong> .' . "\n";
$lang->action->desc->offline              = '$date, set offline by <strong>$actor</strong> .' . "\n";
$lang->action->desc->linkhost             = '$date, the host is linked by <strong>$actor</strong> .' . "\n";
$lang->action->desc->createrepobranch     = '$date, <strong>$actor</strong> created code branch <strong>$extra</strong>.' . "\n";
$lang->action->desc->unlinkrepobranch     = '$date, <strong>$actor</strong> unlinked code branch <strong>$extra</strong>.' . "\n";
$lang->action->desc->changedprogram       = '$date, <strong>$actor</strong> adjust the program <strong>$extra</strong>.' . "\n";
$lang->action->desc->managedteam          = '$date, by <strong>$actor</strong> managed team.' . "\n";
$lang->action->desc->syncexecutionteam    = '$date, synchronise members when execution adds members.' . "\n";
$lang->action->desc->syncprojectteam      = '$date, synchronise members when project removes members' . "\n";

/* Used to describe the history of operations related to parent-child tasks. */
$lang->action->desc->createchildren        = '$date, <strong>$actor</strong> created a child task <strong>$extra</strong>。' . "\n";
$lang->action->desc->linkchildtask         = '$date, <strong>$actor</strong> linked a child task <strong>$extra</strong>。' . "\n";
$lang->action->desc->unlinkchildrentask    = '$date, <strong>$actor</strong> unlinked a child task <strong>$extra</strong>。' . "\n";
$lang->action->desc->linkparenttask        = '$date, <strong>$actor</strong> linked to a parent task <strong>$extra</strong>。' . "\n";
$lang->action->desc->unlinkparenttask      = '$date, <strong>$actor</strong> unlinked a parent task <strong>$extra</strong>。' . "\n";
$lang->action->desc->deletechildrentask    = '$date, <strong>$actor</strong> deleted a child task <strong>$extra</strong>。' . "\n";
$lang->action->desc->syncstorybyparenttask = "\$date, as the parent task updates its {$lang->SRCommon}, the child tasks are updated simultaneously.\n";

/* Used to describe the history of operations related to parent-child requirements. */
$lang->action->desc->createchildrenstory = '$date, <strong>$actor</strong> created a child story <strong>$extra</strong>。' . "\n";
$lang->action->desc->linkchildstory      = '$date, <strong>$actor</strong> linked a child story <strong>$extra</strong>。' . "\n";
$lang->action->desc->unlinkchildrenstory = '$date, <strong>$actor</strong> unlinked a child story <strong>$extra</strong>。' . "\n";
$lang->action->desc->linkparentstory     = '$date, <strong>$actor</strong> linked to a parent story <strong>$extra</strong>。' . "\n";
$lang->action->desc->unlinkparentstory   = '$date, <strong>$actor</strong> unlinked a parent story <strong>$extra</strong>。' . "\n";
$lang->action->desc->deletechildrenstory = '$date, <strong>$actor</strong> deleted a child story <strong>$extra</strong>。' . "\n";

/* Historical record of actions when associating and removing cases. */
$lang->action->desc->linkrelatedcase   = '$date, <strong>$actor</strong> linked a case <strong>$extra</strong>.' . "\n";
$lang->action->desc->unlinkrelatedcase = '$date, <strong>$actor</strong> unlinked a case <strong>$extra</strong>.' . "\n";

/* Used to describe the history of operations link story and bug to productplan. */
$lang->action->desc->linkstory   = '$date, <strong>$actor</strong> link stories <strong>$extra</strong>.' . "\n";
$lang->action->desc->linkbug     = '$date, <strong>$actor</strong> link bugs <strong>$extra</strong>.' . "\n";
$lang->action->desc->unlinkstory = '$date, <strong>$actor</strong> remove stories <strong>$extra</strong> from plan.' . "\n";
$lang->action->desc->unlinkbug   = '$date, <strong>$actor</strong> remove bugs <strong>$extra</strong> from plan.' . "\n";

/* Describes the history of operations when a document is saved as a draft or released. */
$lang->action->desc->saveddraft  = '$date, <strong>$actor</strong> save draft <strong>$extra</strong>.' . "\n";
$lang->action->desc->releaseddoc = '$date, <strong>$actor</strong> released <strong>$extra</strong>.' . "\n";

/* This parameter describes historical operations that are performed when a document is collected or uncollected. */
$lang->action->desc->collected   = '$date, <strong>$actor</strong> collected <strong>$extra</strong>.' . "\n";
$lang->action->desc->uncollected = '$date, <strong>$actor</strong> uncollected <strong>$extra</strong>.' . "\n";

/* AI prompts related actions. */
$lang->action->desc->published   = '$date, published by <strong>$actor</strong>.' . "\n";
$lang->action->desc->unpublished = '$date, unpublished by <strong>$actor</strong>.' . "\n";

/* 用来描述应用的历史操作记录。*/
$lang->action->desc->install                 = '$date, installed by <strong>$actor</strong>.' . "\n";
$lang->action->desc->uninstall               = '$date, uninstalled by <strong>$actor</strong>.' . "\n";
$lang->action->desc->start                   = '$date, started by <strong>$actor</strong>.' . "\n";
$lang->action->desc->stop                    = '$date, closed by <strong>$actor</strong>.' . "\n";
$lang->action->desc->editname                = '$date, updated from <strong>$oldname</strong> to <strong>$newName</strong> by <strong>$actor</strong>.' . "\n";
$lang->action->desc->upgrade                 = '$date, upgraded from <strong>$oldVersion</strong> to <strong>$newVersion</strong> by <strong>$actor</strong>.' . "\n";
$lang->action->desc->backup                  = '$date, backuped by <strong>$actor</strong>.' . "\n";
$lang->action->desc->adjustmemory            = '$date, resized to <strong>$newValue</strong> memory by <strong>$actor</strong>.' . "\n";
$lang->action->desc->adjustcpu               = '$date, resized to <strong>$newValue</strong> CPU by <strong>$actor</strong>.' . "\n";
$lang->action->desc->adjustvol               = '$date, resized to <strong>$newValue</strong> GB disk space by <strong>$actor</strong>.' . "\n";
$lang->action->desc->adjustmemorychange      = '$date, modify the memory from <strong>$oldValue</strong> to <strong>$newValue</strong> by <strong>$actor</strong>.' . "\n";
if(empty($oldValue))
{
    $lang->action->desc->adjustcpuchange     = '$date, modify CPU from <strong>unlimit</strong> to <strong>$newValue</strong>-core by <strong>$actor</strong>.' . "\n";
}
else
{
    $lang->action->desc->adjustcpuchange     = '$date, modify CPU from <strong>$oldValue</strong>-core to <strong>$newValue</strong>-core by <strong>$actor</strong>.' . "\n";
}
$lang->action->desc->adjustvolchange         = '$date, modify this disk space from <strong>oldValue</strong>GB to <strong>newValue</strong>GB。' . "\n";
$lang->action->desc->enableldap              = '$date, enabled by <strong>$actor</strong> of LDAP。' . "\n";
$lang->action->desc->disableldap             = '$date, disabled by <strong>$actor</strong> of LDAP。' . "\n";
$lang->action->desc->enablesmtp              = '$date, enabled by <strong>$actor</strong> of SMTP。' . "\n";
$lang->action->desc->disablesmtp             = '$date, disabled by <strong>$actor</strong> of SMTP。' . "\n";
$lang->action->desc->updatecustom            = '$date, updated by <strong>$actor</strong> of custom settings.' . "\n";

$lang->action->desc->delist  = '$date, delist by <strong>$actor</strong>.' . "\n";
$lang->action->desc->publish = '$date, publish by <strong>$actor</strong>.' . "\n";

$lang->action->desc->manualbackup        = '$date, Manually backed up by <strong>$actor</strong>.' . "\n";
$lang->action->desc->autobackup          = '$date, Automatic backup by <strong>$actor</strong>.' . "\n";
$lang->action->desc->openautobackup      = '$date, Enable automatic backup by <strong>$actor</strong>.' . "\n";
$lang->action->desc->closeautobackup     = '$date, Disable automatic backup by <strong>$actor</strong>.' . "\n";
$lang->action->desc->autodeletebackups   = '$date, Automatically clean up backups by <strong>$actor</strong>.' . "\n";
$lang->action->desc->savebackupsettings  = '$date, Save backup settings backups by <strong>$actor</strong>.' . "\n";
$lang->action->desc->deleteexpiredbackup = '$date, Clean up expired backups by <strong>$actor</strong>.' . "\n";
$lang->action->desc->manualdeletebackup  = '$date, Manually clean up backup by <strong>$actor</strong>.' . "\n";

/* Used to display dynamic information. */
$lang->action->label = new stdclass();
$lang->action->label->install                 = 'install ';
$lang->action->label->uninstall               = 'uninstall ';
$lang->action->label->upgrade                 = 'upgrade ';
$lang->action->label->start                   = 'start ';
$lang->action->label->stop                    = 'stop ';
$lang->action->label->editname                = 'edit name ';
$lang->action->label->backup                  = 'backup ';
$lang->action->label->adjustmemory            = 'adjust memory ';
$lang->action->label->adjustcpu               = 'adjust CPU';
$lang->action->label->adjustVol               = 'adjust volume';
$lang->action->label->enableldap              = 'enable LDAP ';
$lang->action->label->disableldap             = 'disable LDAP ';
$lang->action->label->enablesmtp              = 'enable SMTP ';
$lang->action->label->disablesmtp             = 'disable SMTP ';
$lang->action->label->revert                  = 'revert ';
$lang->action->label->created                 = 'created ';
$lang->action->label->opened                  = 'opened ';
$lang->action->label->openedbysystem          = 'Opened by system ';
$lang->action->label->closedbysystem          = 'Closed by system ';
$lang->action->label->added                   = 'added';
$lang->action->label->changed                 = 'changed ';
$lang->action->label->edited                  = 'edited ';
$lang->action->label->assigned                = 'assigned ';
$lang->action->label->closed                  = 'closed ';
$lang->action->label->deleted                 = 'deleted ';
$lang->action->label->deletedfile             = 'deleted ';
$lang->action->label->editfile                = 'edited ';
$lang->action->label->erased                  = 'erased ';
$lang->action->label->undeleted               = 'restored ';
$lang->action->label->hidden                  = 'hid ';
$lang->action->label->commented               = 'commented ';
$lang->action->label->communicated            = 'communicated';
$lang->action->label->activated               = 'activated ';
$lang->action->label->blocked                 = 'blocked ';
$lang->action->label->resolved                = 'resolved ';
$lang->action->label->reviewed                = 'reviewed ';
$lang->action->label->recalled                = 'recalled';
$lang->action->label->recalledchange          = 'undo changes';
$lang->action->label->moved                   = 'moved ';
$lang->action->label->confirmed               = 'confirmed Story ';
$lang->action->label->bugconfirmed            = 'confirmed';
$lang->action->label->tostory                 = 'converted to Story ';
$lang->action->label->frombug                 = 'converted from Bug ';
$lang->action->label->fromlib                 = 'imported from Library ';
$lang->action->label->totask                  = 'converted to Task ';
$lang->action->label->converttotask           = 'converted to Task ';
$lang->action->label->svncommited             = 'committed SVN ';
$lang->action->label->gitcommited             = 'committed Git ';
$lang->action->label->linked2plan             = 'linked to Plan ';
$lang->action->label->unlinkedfromplan        = 'unlinked from ';
$lang->action->label->changestatus            = 'changed status';
$lang->action->label->marked                  = 'marked';
$lang->action->label->linked2execution        = "linked to {$lang->executionCommon}";
$lang->action->label->unlinkedfromexecution   = "unlinked from {$lang->executionCommon}";
$lang->action->label->linked2kanban           = 'linked to kanban';
$lang->action->label->linked2project          = "linked to {$lang->projectCommon}";
$lang->action->label->unlinkedfromproject     = "unlinked from {$lang->projectCommon}";
$lang->action->label->unlinkedfrombuild       = "unlinked Build ";
$lang->action->label->linked2release          = "linked Release ";
$lang->action->label->unlinkedfromrelease     = "unlinked Release ";
$lang->action->label->linked2revision         = "Link Revision";
$lang->action->label->unlinkedfromrevision    = "Unlink Revision";
$lang->action->label->linkrelatedbug          = "linked Bug ";
$lang->action->label->unlinkrelatedbug        = "unlinked Bug ";
$lang->action->label->linkrelatedcase         = "linked Case ";
$lang->action->label->unlinkrelatedcase       = "unlinked Case ";
$lang->action->label->linkrelatedstory        = "linked Story ";
$lang->action->label->unlinkrelatedstory      = "unlinked Story ";
$lang->action->label->subdividestory          = "decomposed Story ";
$lang->action->label->unlinkchildstory        = "unlinked Story ";
$lang->action->label->started                 = 'started ';
$lang->action->label->restarted               = 'continued ';
$lang->action->label->recordworkhour          = 'recorded ';
$lang->action->label->recordestimate          = 'recorded ';
$lang->action->label->editestimate            = 'edited ';
$lang->action->label->editeffort              = 'edited ';
$lang->action->label->canceled                = 'cancelled ';
$lang->action->label->finished                = 'finished ';
$lang->action->label->paused                  = 'paused ';
$lang->action->label->verified                = 'verified ';
$lang->action->label->delayed                 = 'delayed ';
$lang->action->label->suspended               = 'suspended ';
$lang->action->label->login                   = 'login';
$lang->action->label->logout                  = "logout";
$lang->action->label->notified                = "Notified";
$lang->action->label->deleteestimate          = "deleted hours";
$lang->action->label->linked2build            = "linked ";
$lang->action->label->linked2bug              = "linked ";
$lang->action->label->linked2testtask         = "linked";
$lang->action->label->unlinkedfromtesttask    = "unlinked";
$lang->action->label->linkchildtask           = "linked a child task";
$lang->action->label->unlinkchildrentask      = "unlinked a child task";
$lang->action->label->linkparenttask          = "linked a parent task";
$lang->action->label->unlinkparenttask        = "unlink from parent task";
$lang->action->label->batchcreate             = "batch created tasks";
$lang->action->label->createchildren          = "create child tasks";
$lang->action->label->managed                 = "managed";
$lang->action->label->managedteam             = "managed";
$lang->action->label->managedwhitelist        = "managed";
$lang->action->label->deletechildrentask      = "delete children task";
$lang->action->label->createchildrenstory     = "create child stories";
$lang->action->label->linkchildstory          = "linked a child story";
$lang->action->label->unlinkchildrenstory     = "unlinked a child story";
$lang->action->label->linkparentstory         = "linked a parent story";
$lang->action->label->unlinkparentstory       = "unlink from parent story";
$lang->action->label->deletechildrenstory     = "delete children story";
$lang->action->label->syncgrade               = 'synced grade';
$lang->action->label->tracked                 = 'tracked';
$lang->action->label->hangup                  = 'hangup';
$lang->action->label->run                     = 'run';
$lang->action->label->estimated               = 'estimated';
$lang->action->label->reviewpassed            = 'Pass';
$lang->action->label->reviewrejected          = 'Reject';
$lang->action->label->reviewclarified         = 'Clarify';
$lang->action->label->reviewreverted          = 'Revert';
$lang->action->label->commitsummary           = 'Commit Summary';
$lang->action->label->updatetrainee           = 'Update Trainee';
$lang->action->label->setdefaultbranch        = 'Set default branch';
$lang->action->label->syncprogram             = 'start';
$lang->action->label->syncproject             = 'start';
$lang->action->label->syncexecution           = 'start';
$lang->action->label->syncexecutionbychild    = 'start';
$lang->action->label->syncmultipleproject     = 'start';
$lang->action->label->startProgram            = '(The start of the project sets the status of the program as Ongoing)';
$lang->action->label->createmr                = 'Linked';
$lang->action->label->deletemr                = 'Unlinked';
$lang->action->label->mergedmr                = 'Merged';
$lang->action->label->compilepass             = 'Compile Success';
$lang->action->label->compilefail             = 'Compile Fail';
$lang->action->label->reopen                  = 'Reopen';
$lang->action->label->approve                 = 'Passed';
$lang->action->label->reject                  = 'Rejected';
$lang->action->label->importfromgitlab        = 'Issue associate created';
$lang->action->label->archived                = 'Archived';
$lang->action->label->restore                 = 'Restore';
$lang->action->label->mergedbranch            = 'Merge Branch';
$lang->action->label->startedbychild          = 'started';
$lang->action->label->finishedbychild         = 'finished';
$lang->action->label->closedbychild           = 'closed';
$lang->action->label->activatedbychild        = 'activated';
$lang->action->label->createchild             = 'activated';
$lang->action->label->executed                = 'executed';
$lang->action->label->importedcard            = 'imported';
$lang->action->label->importedproductplan     = 'imported';
$lang->action->label->importedrelease         = 'imported';
$lang->action->label->importedexecution       = 'imported';
$lang->action->label->importedbuild           = 'imported';
$lang->action->label->importedticket          = 'imported';
$lang->action->label->fromsonarqube           = 'created a bug from SonarQube Issue named:';
$lang->action->label->bind                    = 'bound';
$lang->action->label->unbind                  = 'unbound';
$lang->action->label->linkstory               = 'link stories to';
$lang->action->label->linkbug                 = 'link bugs to';
$lang->action->label->unlinkstory             = 'unlink stories from';
$lang->action->label->unlinkbug               = 'unlink bugs from';
$lang->action->label->tolib                   = 'imported';
$lang->action->label->updatetolib             = 'updated';
$lang->action->label->ganttmove               = 'sorted';
$lang->action->label->submitreview            = 'submitted';
$lang->action->label->suspend                 = 'suspended';
$lang->action->label->resume                  = 'resumed';
$lang->action->label->reboot                  = 'reboot';
$lang->action->label->boot                    = 'boot';
$lang->action->label->destroy                 = 'destroyed';
$lang->action->label->getvnc                  = 'remote control';
$lang->action->label->synctwins               = 'synchronized changes';
$lang->action->label->closedbyparent          = 'synchronized closed';
$lang->action->label->relieved                = 'relieved';
$lang->action->label->switchtolight           = 'switch from ALM mode to light mode';
$lang->action->label->linkedrepo              = 'Linked Code Repo';
$lang->action->label->unlinkedrepo            = 'Unlinked Code Repo';
$lang->action->label->unlinkproduct           = "Unlinked {$lang->productCommon}";
$lang->action->label->createdsnapshot         = 'create snapshot';
$lang->action->label->restoredsnapshot        = 'create snapshot';
$lang->action->label->editsnapshot            = 'edit snapshot';
$lang->action->label->deletesnapshot          = 'deleted snapshot';
$lang->action->label->saveddraft              = 'save draft';
$lang->action->label->releaseddoc             = 'released';
$lang->action->label->collected               = 'collected';
$lang->action->label->uncollected             = 'uncollected';
$lang->action->label->online                  = 'online';
$lang->action->label->offline                 = 'offline';
$lang->action->label->linkhost                = 'link hosts to';
$lang->action->label->delist                  = 'delist';
$lang->action->label->createrepobranch        = 'Created branch from';
$lang->action->label->unlinkrepobranch        = 'Unlinked branch from';
$lang->action->label->communicate             = 'Communicate';
$lang->action->label->changedprogram          = 'Changed program';
$lang->action->label->published               = 'published';
$lang->action->label->unpublished             = 'unpublished';
$lang->action->label->aiassistant             = 'AI Assistant';
$lang->action->label->synced                  = 'synced';
$lang->action->label->imported                = 'imported';
$lang->action->label->createbackup            = 'Created system backup';
$lang->action->label->deletebackup            = 'Deleted system backup';
$lang->action->label->restorebackup           = 'Restored system backup';
$lang->action->label->upgradesystem           = 'Executed system upgrade';
$lang->action->label->system                  = $lang->product->system;
$lang->action->label->manualbackup            = 'Manual backup';
$lang->action->label->autobackup              = 'Automatic backup';
$lang->action->label->openautobackup          = 'Enable automatic backup';
$lang->action->label->closeautobackup         = 'Disable automatic backup';
$lang->action->label->autodeletebackups       = 'Automatically clean up backups';
$lang->action->label->savebackupsettings      = 'Save backup settings';
$lang->action->label->deleteexpiredbackup     = 'Clean up expired backups';
$lang->action->label->manualdeletebackup      = 'Manually clean up backup';
$lang->action->label->syncexecutionteam       = 'synchronized';
$lang->action->label->syncprojectteam         = 'synchronized';

/* Dynamic information is grouped by object. */
$lang->action->dynamicAction                    = new stdclass;
$lang->action->dynamicAction->todo['opened']    = 'Create Todo';
$lang->action->dynamicAction->todo['edited']    = 'Edit Todo';
$lang->action->dynamicAction->todo['erased']    = 'Delete Todo';
$lang->action->dynamicAction->todo['finished']  = 'Finish Todo';
$lang->action->dynamicAction->todo['activated'] = 'Activate Todo';
$lang->action->dynamicAction->todo['closed']    = 'Close Todo';
$lang->action->dynamicAction->todo['assigned']  = 'Assign Todo';
$lang->action->dynamicAction->todo['undeleted'] = 'Restore Todo';
$lang->action->dynamicAction->todo['hidden']    = 'Hide Todo';

$lang->action->dynamicAction->program['opened']    = 'Create Program';
$lang->action->dynamicAction->program['edited']    = 'Edit Program';
$lang->action->dynamicAction->program['activated'] = 'Activate Program';
$lang->action->dynamicAction->program['deleted']   = 'Delete Program';
$lang->action->dynamicAction->program['closed']    = 'Close Program';

$lang->action->dynamicAction->project['opened']        = "Create {$lang->projectCommon}";
$lang->action->dynamicAction->project['edited']        = "Edit {$lang->projectCommon}";
$lang->action->dynamicAction->project['started']       = "Start {$lang->projectCommon}";
$lang->action->dynamicAction->project['suspended']     = "Suspend {$lang->projectCommon}";
$lang->action->dynamicAction->project['activated']     = "Activate {$lang->projectCommon}";
$lang->action->dynamicAction->project['closed']        = "Close {$lang->projectCommon}";
$lang->action->dynamicAction->project['switchtolight'] = 'Switch Mode';

$lang->action->dynamicAction->product['opened']    = 'Create ' . $lang->productCommon;
$lang->action->dynamicAction->product['edited']    = 'Edit ' . $lang->productCommon;
$lang->action->dynamicAction->product['deleted']   = 'Delete ' . $lang->productCommon;
$lang->action->dynamicAction->product['closed']    = 'Close ' . $lang->productCommon;
$lang->action->dynamicAction->product['undeleted'] = 'Restore ' . $lang->productCommon;
$lang->action->dynamicAction->product['hidden']    = 'Hide ' . $lang->productCommon;

$lang->action->dynamicAction->branch['opened']           = 'Create Branch';
$lang->action->dynamicAction->branch['edited']           = 'Edit Branch';
$lang->action->dynamicAction->branch['closed']           = 'Close Branch';
$lang->action->dynamicAction->branch['activated']        = 'Activate Branch';
$lang->action->dynamicAction->branch['setdefaultbranch'] = 'Set Default Branch';
$lang->action->dynamicAction->branch['mergebranch']      = 'Merge Branch';

$lang->action->dynamicAction->productplan['opened']      = 'Create Plan';
$lang->action->dynamicAction->productplan['edited']      = 'Edit Plan';
$lang->action->dynamicAction->productplan['started']     = "Start Plan";
$lang->action->dynamicAction->productplan['finished']    = "Finish Plan";
$lang->action->dynamicAction->productplan['closed']      = "Close Plan";
$lang->action->dynamicAction->productplan['activated']   = "Activate Plan";
$lang->action->dynamicAction->productplan['linkstory']   = "Link Story";
$lang->action->dynamicAction->productplan['unlinkstory'] = "Unlink Story";
$lang->action->dynamicAction->productplan['linkbug']     = "Link Bug";
$lang->action->dynamicAction->productplan['unlinkbug']   = "Unlink Bug";

$lang->action->dynamicAction->release['opened']       = 'Create Release';
$lang->action->dynamicAction->release['edited']       = 'Edit Release';
$lang->action->dynamicAction->release['changestatus'] = 'Change Release Status';
$lang->action->dynamicAction->release['undeleted']    = 'Restore Release';
$lang->action->dynamicAction->release['notified']     = 'Notify Release';
$lang->action->dynamicAction->release['hidden']       = 'Hide Release';

$lang->action->dynamicAction->story['opened']                = 'Create Story';
$lang->action->dynamicAction->story['importfromgitlab']      = "Issue associate create story";
$lang->action->dynamicAction->story['edited']                = 'Edit Story';
$lang->action->dynamicAction->story['activated']             = 'Activate Story';
$lang->action->dynamicAction->story['reviewed']              = 'Review Story';
$lang->action->dynamicAction->story['recalled']              = 'Revoke';
$lang->action->dynamicAction->story['closed']                = 'Close Story';
$lang->action->dynamicAction->story['assigned']              = 'Assign Story';
$lang->action->dynamicAction->story['changed']               = 'Change Story';
$lang->action->dynamicAction->story['linked2plan']           = 'Link Story to Plan';
$lang->action->dynamicAction->story['unlinkedfromplan']      = 'Unlink Story from Plan';
$lang->action->dynamicAction->story['linked2release']        = 'Link Story to Release';
$lang->action->dynamicAction->story['unlinkedfromrelease']   = 'Unlink Story from Plan';
$lang->action->dynamicAction->story['linked2revision']       = 'Link Story to Revision';
$lang->action->dynamicAction->story['unlinkedfromrevision']  = 'Unlink Story from Revision';
$lang->action->dynamicAction->story['linked2build']          = 'Link Story to Build';
$lang->action->dynamicAction->story['unlinkedfrombuild']     = 'Unlink Story from Build';
$lang->action->dynamicAction->story['unlinkedfromproject']   = "Unlink {$lang->projectCommon}";
$lang->action->dynamicAction->story['undeleted']             = 'Restore Story';
$lang->action->dynamicAction->story['hidden']                = 'Hide Story';
$lang->action->dynamicAction->story['linked2execution']      = "Link Story";
$lang->action->dynamicAction->story['unlinkedfromexecution'] = "Unlink Story";
$lang->action->dynamicAction->story['linked2kanban']         = "Link Story";
$lang->action->dynamicAction->story['estimated']             = "Estimate $lang->SRCommon";

$lang->action->dynamicAction->execution['opened']    = 'Create ' . $lang->executionCommon;
$lang->action->dynamicAction->execution['edited']    = 'Edit ' . $lang->executionCommon;
$lang->action->dynamicAction->execution['deleted']   = 'Delete ' . $lang->executionCommon;
$lang->action->dynamicAction->execution['started']   = 'Start ' . $lang->executionCommon;
$lang->action->dynamicAction->execution['delayed']   = 'Delay ' . $lang->executionCommon;
$lang->action->dynamicAction->execution['suspended'] = 'Suspend ' . $lang->executionCommon;
$lang->action->dynamicAction->execution['activated'] = 'Activate ' . $lang->executionCommon;
$lang->action->dynamicAction->execution['closed']    = 'Close ' . $lang->executionCommon;
$lang->action->dynamicAction->execution['managed']   = 'Manage ' . $lang->executionCommon;
$lang->action->dynamicAction->execution['undeleted'] = 'Restore ' . $lang->executionCommon;
$lang->action->dynamicAction->execution['hidden']    = 'Hide ' . $lang->executionCommon;
$lang->action->dynamicAction->execution['moved']     = 'Improt Task';

$lang->action->dynamicAction->kanban['created'] = 'Create Kanban';
$lang->action->dynamicAction->kanban['edited']  = 'Kanban Settings';
$lang->action->dynamicAction->kanban['closed']  = 'Close Kanban';
$lang->action->dynamicAction->kanban['deleted'] = 'Delete Kanban';

$lang->action->dynamicAction->kanbanspace['created'] = 'Create Space';
$lang->action->dynamicAction->kanbanspace['edited']  = 'Space Settings';
$lang->action->dynamicAction->kanbanspace['closed']  = 'Close Space';
$lang->action->dynamicAction->kanbanspace['deleted'] = 'Deleted Space';

$lang->action->dynamicAction->kanbanregion['created'] = 'Create Region';
$lang->action->dynamicAction->kanbanregion['edited']  = 'Edit Region';
$lang->action->dynamicAction->kanbanregion['deleted'] = 'Delete Region';

$lang->action->dynamicAction->kanbancolumn['created']  = 'Create Column';
$lang->action->dynamicAction->kanbancolumn['edited']   = 'Column Settings';
$lang->action->dynamicAction->kanbancolumn['archived'] = 'Archive Column';
$lang->action->dynamicAction->kanbancolumn['restore']  = 'Restore Column';
$lang->action->dynamicAction->kanbancolumn['deleted']  = 'Delete Column';

$lang->action->dynamicAction->kanbanlane['created'] = 'Create Lane';
$lang->action->dynamicAction->kanbanlane['edited']  = 'Lane Settings';
$lang->action->dynamicAction->kanbanlane['moved']   = 'Move Lane';
$lang->action->dynamicAction->kanbanlane['deleted'] = 'Delete Lane';

$lang->action->dynamicAction->kanbancard['created']   = 'Create Card';
$lang->action->dynamicAction->kanbancard['edited']    = 'Edit Card';
$lang->action->dynamicAction->kanbancard['commented'] = 'Comment Card';
$lang->action->dynamicAction->kanbancard['archived']  = 'Archive Card';
$lang->action->dynamicAction->kanbancard['restore']   = 'Restore Card';
$lang->action->dynamicAction->kanbancard['deleted']   = 'Delete Card';

$lang->action->dynamicAction->team['managedTeam'] = 'Manage Team';

$lang->action->dynamicAction->task['opened']               = 'Create Task';
$lang->action->dynamicAction->task['importfromgitlab']     = "Issue associate create task";
$lang->action->dynamicAction->task['edited']               = 'Edit Task';
$lang->action->dynamicAction->task['commented']            = 'Task Comment';
$lang->action->dynamicAction->task['assigned']             = 'Assign Task';
$lang->action->dynamicAction->task['confirmed']            = 'Confirm Task';
$lang->action->dynamicAction->task['started']              = 'Start Task';
$lang->action->dynamicAction->task['finished']             = 'Finish Task';
$lang->action->dynamicAction->task['recordworkhour']       = 'Add Workhour';
$lang->action->dynamicAction->task['recordestimate']       = 'Add Workhour';
$lang->action->dynamicAction->task['editestimate']         = 'Edit Estimates';
$lang->action->dynamicAction->task['deleteestimate']       = 'Delete Estimates';
$lang->action->dynamicAction->task['paused']               = 'Pause Task';
$lang->action->dynamicAction->task['closed']               = 'Close Task';
$lang->action->dynamicAction->task['canceled']             = 'Cancel Task';
$lang->action->dynamicAction->task['activated']            = 'Activate Task';
$lang->action->dynamicAction->task['createchildren']       = 'Create Child Task';
$lang->action->dynamicAction->task['unlinkparenttask']     = 'Unlink Parent Task';
$lang->action->dynamicAction->task['deletechildrentask']   = 'Delete children task';
$lang->action->dynamicAction->task['linkparenttask']       = 'Link Parent Task';
$lang->action->dynamicAction->task['linkchildtask']        = 'Link Child Task';
$lang->action->dynamicAction->task['createchildrenstory']  = 'Create Child Story';
$lang->action->dynamicAction->task['unlinkparentstory']    = 'Unlink Parent Story';
$lang->action->dynamicAction->task['deletechildrenstory']  = 'Delete children story';
$lang->action->dynamicAction->task['linkparentstory']      = 'Link Parent Story';
$lang->action->dynamicAction->task['linkchildstory']       = 'Link Child Story';
$lang->action->dynamicAction->task['undeleted']            = 'Restore Task';
$lang->action->dynamicAction->task['hidden']               = 'Hide Task';
$lang->action->dynamicAction->task['svncommited']          = 'SVN Commit';
$lang->action->dynamicAction->task['gitcommited']          = 'GIT Commit';
$lang->action->dynamicAction->task['ganttmove']            = 'Order';
$lang->action->dynamicAction->task['linked2revision']      = 'Link Task to Revision';
$lang->action->dynamicAction->task['unlinkedfromrevision'] = 'Unlink Task from Revision';

$lang->action->dynamicAction->build['opened']  = 'Create Build';
$lang->action->dynamicAction->build['edited']  = 'Edit Build';
$lang->action->dynamicAction->build['deleted'] = 'Delete Build';

$lang->action->dynamicAction->bug['opened']               = 'Report Bug';
$lang->action->dynamicAction->bug['importfromgitlab']     = "Issue associate create bug";
$lang->action->dynamicAction->bug['edited']               = 'Edit Bug';
$lang->action->dynamicAction->bug['activated']            = 'Activate Bug';
$lang->action->dynamicAction->bug['assigned']             = 'Assign Bug';
$lang->action->dynamicAction->bug['closed']               = 'Close Bug';
$lang->action->dynamicAction->bug['bugconfirmed']         = 'Confirm Bug';
$lang->action->dynamicAction->bug['resolved']             = 'Resolve Bug';
$lang->action->dynamicAction->bug['undeleted']            = 'Restore Bug';
$lang->action->dynamicAction->bug['hidden']               = 'Hide Bug';
$lang->action->dynamicAction->bug['deleted']              = 'Delete Bug';
$lang->action->dynamicAction->bug['confirmed']            = 'Confirm Story Change';
$lang->action->dynamicAction->bug['tostory']              = 'Convert to Story';
$lang->action->dynamicAction->bug['totask']               = 'Convert to Task';
$lang->action->dynamicAction->bug['linked2plan']          = 'Link Plan';
$lang->action->dynamicAction->bug['unlinkedfromplan']     = 'Unlink Plan';
$lang->action->dynamicAction->bug['linked2release']       = 'Link Release';
$lang->action->dynamicAction->bug['unlinkedfromrelease']  = 'Unlink Plan';
$lang->action->dynamicAction->bug['linked2revision']      = 'Link Bug to Revision';
$lang->action->dynamicAction->bug['unlinkedfromrevision'] = 'Unlink Bug from Revision';
$lang->action->dynamicAction->bug['linked2bug']           = 'Link Build';
$lang->action->dynamicAction->bug['unlinkedfrombuild']    = 'Unlink Build';
$lang->action->dynamicAction->bug['fromsonarqube']        = 'Create Bug from SonarQube Issue';

$lang->action->dynamicAction->testtask['opened']    = 'Create Test Request';
$lang->action->dynamicAction->testtask['edited']    = 'Edit Test Request';
$lang->action->dynamicAction->testtask['started']   = 'Start Test Request';
$lang->action->dynamicAction->testtask['activated'] = 'Activate Test Request';
$lang->action->dynamicAction->testtask['closed']    = 'Close Test Request';
$lang->action->dynamicAction->testtask['blocked']   = 'Blocked Test Request';

$lang->action->dynamicAction->case['opened']      = 'Create Case';
$lang->action->dynamicAction->case['edited']      = 'Edit Case';
$lang->action->dynamicAction->case['deleted']     = 'Delete Case';
$lang->action->dynamicAction->case['undeleted']   = 'Restore Case';
$lang->action->dynamicAction->case['hidden']      = 'Hide Case';
$lang->action->dynamicAction->case['reviewed']    = 'Add Review Result';
$lang->action->dynamicAction->case['confirmed']   = 'Confirm Case';
$lang->action->dynamicAction->case['fromlib']     = 'Import from Case Lib';
$lang->action->dynamicAction->case['tolib']       = 'Import Case';
$lang->action->dynamicAction->case['updatetolib'] = 'Update Case';

$lang->action->dynamicAction->testreport['opened']    = 'Create Test Report';
$lang->action->dynamicAction->testreport['edited']    = 'Edit Test Report';
$lang->action->dynamicAction->testreport['deleted']   = 'Delete Test Report';
$lang->action->dynamicAction->testreport['undeleted'] = 'Restore Test Report';
$lang->action->dynamicAction->testreport['hidden']    = 'Hide Test Report';

$lang->action->dynamicAction->testsuite['opened']    = 'Create Test Suite';
$lang->action->dynamicAction->testsuite['edited']    = 'Edit Test Suite';
$lang->action->dynamicAction->testsuite['deleted']   = 'Delete Test Suite';
$lang->action->dynamicAction->testsuite['undeleted'] = 'Restore Test Suite';
$lang->action->dynamicAction->testsuite['hidden']    = 'Hide Test Suite';

$lang->action->dynamicAction->caselib['opened']    = 'Create Case Lib';
$lang->action->dynamicAction->caselib['edited']    = 'Edit Case Lib';
$lang->action->dynamicAction->caselib['deleted']   = 'Delete Case Lib';
$lang->action->dynamicAction->caselib['undeleted'] = 'Restore Case Lib';
$lang->action->dynamicAction->caselib['hidden']    = 'Hide Case Lib';

$lang->action->dynamicAction->zahost['created'] = 'Create Host';

$lang->action->dynamicAction->zanode['created'] = 'Create Zagent Node';
$lang->action->dynamicAction->zanode['suspend'] = 'Suspend Zagent Node';
$lang->action->dynamicAction->zanode['resume']  = 'Resume Zagent Node';
$lang->action->dynamicAction->zanode['reboot']  = 'Reboot Zagent Node';
$lang->action->dynamicAction->zanode['boot']    = 'Boot Zagent Node';
$lang->action->dynamicAction->zanode['destroy'] = 'Destory Zagent Node';

$lang->action->dynamicAction->doclib['created'] = 'Create Doc Library';
$lang->action->dynamicAction->doclib['edited']  = 'Edit Doc Library';
$lang->action->dynamicAction->doclib['deleted'] = 'Delete Doc Library';

$lang->action->dynamicAction->doc['created']   = 'Create Document';
$lang->action->dynamicAction->doc['edited']    = 'Edit Document';
$lang->action->dynamicAction->doc['commented'] = 'Comment Document';
$lang->action->dynamicAction->doc['deleted']   = 'Delete Document';
$lang->action->dynamicAction->doc['undeleted'] = 'Restore Document';
$lang->action->dynamicAction->doc['hidden']    = 'Hide Document';

$lang->action->dynamicAction->api['created'] = 'Create Interface';
$lang->action->dynamicAction->api['edited']  = 'Edit Interface';
$lang->action->dynamicAction->api['deleted'] = 'Delete Interface';

$lang->action->dynamicAction->user['created']       = 'Create User';
$lang->action->dynamicAction->user['edited']        = 'Edit User';
$lang->action->dynamicAction->user['deleted']       = 'Delete User';
$lang->action->dynamicAction->user['login']         = 'Login';
$lang->action->dynamicAction->user['logout']        = 'Logout';
$lang->action->dynamicAction->user['undeleted']     = 'Restore User';
$lang->action->dynamicAction->user['hidden']        = 'Hide User';
$lang->action->dynamicAction->user['loginxuanxuan'] = 'Login Desktop';

$lang->action->dynamicAction->entry['created'] = 'Add Application';
$lang->action->dynamicAction->entry['edited']  = 'Edit Application';

$lang->action->dynamicAction->job['created']   = 'Create Job';
$lang->action->dynamicAction->job['edited']    = 'Edit Job';
$lang->action->dynamicAction->job['executed']  = 'Execute Job';
$lang->action->dynamicAction->job['deleted']   = 'Delete Job';
$lang->action->dynamicAction->job['undeleted'] = 'Undelete Job';

$lang->action->dynamicAction->sonarqube['created']   = 'Create SonarQube Server';
$lang->action->dynamicAction->sonarqube['edited']    = 'Edit SonarQube Server';
$lang->action->dynamicAction->sonarqube['deleted']   = 'Delete SonarQube Server';
$lang->action->dynamicAction->sonarqube['undeleted'] = 'Undelete SonarQube Server';

$lang->action->dynamicAction->sonarqubeproject['deleted'] = 'Delete SonarQube Project';

$lang->action->dynamicAction->gitlab['created']   = 'Create GitLab Server';
$lang->action->dynamicAction->gitlab['edited']    = 'Edit GitLab Server';
$lang->action->dynamicAction->gitlab['deleted']   = 'Delete GitLab Server';
$lang->action->dynamicAction->gitlab['undeleted'] = 'Undelete GitLab Server';

$lang->action->dynamicAction->gitea['created']   = 'Create Gitea Server';
$lang->action->dynamicAction->gitea['edited']    = 'Edit Gitea Server';
$lang->action->dynamicAction->gitea['deleted']   = 'Delete Gitea Server';
$lang->action->dynamicAction->gitea['undeleted'] = 'Undelete Gitea Server';

$lang->action->dynamicAction->gogs['created']   = 'Create Gogs Server';
$lang->action->dynamicAction->gogs['edited']    = 'Edit Gogs Server';
$lang->action->dynamicAction->gogs['deleted']   = 'Delete Gogs Server';
$lang->action->dynamicAction->gogs['undeleted'] = 'Undelete Gogs Server';

$lang->action->dynamicAction->nexus['created']   = 'Create Nexus Server';
$lang->action->dynamicAction->nexus['edited']    = 'Edit Nexus Server';
$lang->action->dynamicAction->nexus['deleted']   = 'Delete Nexus Server';
$lang->action->dynamicAction->nexus['undeleted'] = 'Undelete Nexus Server';

$lang->action->dynamicAction->repo['created']   = 'Create Repo';
$lang->action->dynamicAction->repo['edited']    = 'Edit Repo';
$lang->action->dynamicAction->repo['deleted']   = 'Delete Repo';
$lang->action->dynamicAction->repo['undeleted'] = 'Undelete Repo';

$lang->action->dynamicAction->metric['created']   = 'Create Metric';
$lang->action->dynamicAction->metric['edited']    = 'Edit Metric';
$lang->action->dynamicAction->metric['deleted']   = 'Delete Metric';
$lang->action->dynamicAction->metric['undeleted'] = 'Undelete Metric';
$lang->action->dynamicAction->metric['delist']    = 'Delist Metric';
$lang->action->dynamicAction->metric['publish']   = 'Publish Metric';

/* Generate the corresponding object link. */
$lang->action->label->product     = $lang->productCommon . '|product|view|productID=%s';
$lang->action->label->productplan = 'Plan|productplan|view|productID=%s';
$lang->action->label->release     = 'Release|release|view|productID=%s';
$lang->action->label->story       = 'Story|story|storyView|storyID=%s';
$lang->action->label->program     = "Program|program|product|programID=%s";
$lang->action->label->project     = "{$lang->projectCommon}|project|index|projectID=%s";
$lang->action->label->execution   = "Execution|execution|task|executionID=%s";

$lang->action->label->task         = 'Task|task|view|taskID=%s';
$lang->action->label->build        = 'Build|build|view|buildID=%s';
$lang->action->label->bug          = 'Bug|bug|view|bugID=%s';
$lang->action->label->case         = 'Case|testcase|view|caseID=%s';
$lang->action->label->testtask     = 'Request|testtask|view|caseID=%s';
$lang->action->label->testsuite    = 'Test Suite|testsuite|view|suiteID=%s';
$lang->action->label->caselib      = 'Case Library|caselib|view|libID=%s';
$lang->action->label->todo         = 'Todo|todo|view|todoID=%s';
$lang->action->label->doclib       = 'Doc Library|doc|teamspace|objectID=%s&libID=%s';
$lang->action->label->docspace     = 'Doc Space';
$lang->action->label->doc          = 'Doc|doc|view|docID=%s';
$lang->action->label->user         = 'User|user|view|account=%s';
$lang->action->label->testreport   = 'Report|testreport|view|report=%s';
$lang->action->label->entry        = 'Application|entry|browse|';
$lang->action->label->webhook      = 'Webhook|webhook|browse|';
$lang->action->label->space        = ' ';
$lang->action->label->risk         = 'Risk|risk|view|riskID=%s';
$lang->action->label->issue        = 'Issue|issue|view|issueID=%s';
$lang->action->label->design       = 'Design|design|view|designID=%s';
$lang->action->label->stakeholder  = 'Stakeholder|stakeholder|view|userID=%s';
$lang->action->label->api          = 'Interface|api|view|libID=%s&apiID=%s&moduleID=%s';
$lang->action->label->kanbanspace  = 'Kanban Space|kanban|space|browseType=%s';
$lang->action->label->kanbanregion = 'Kanban Region|kanban|view|kanbanID=%s';
$lang->action->label->kanban       = 'Kanban|kanban|view|kanbanID=%s';
$lang->action->label->kanbancolumn = 'Kanban Column|execution|kanban|execution=%s';
$lang->action->label->kanbanlane   = 'Kanban Lane|execution|kanban|execution=%s&type=all';
$lang->action->label->kanbancard   = 'Kanban Card|kanban|view|kanbanID=%s';
$lang->action->label->stage        = 'Stage|stage|browse|';
$lang->action->label->module       = 'Module|tree|browse|productid=%s&view=story&currentModuleID=0&branch=all';
$lang->action->label->ticket       = 'Ticket|ticket|view|id=%s';
$lang->action->label->chartgroup   = 'Group';
$lang->action->label->serverroom   = 'IDC|serverroom|browse|';
$lang->action->label->host         = 'Host|host|view|id=%s';
$lang->action->label->account      = "Account|account|view|id=%s";
$lang->action->label->instance     = 'Application|instance|view|id=%s';
$lang->action->label->prompt       = 'Prompt|ai|promptview|id=%s';
$lang->action->label->miniprogram  = 'Mini Program|aiapp|browseminiprogram|id=%s';
$lang->action->label->holiday      = 'Holiday|holiday|browse|';

/* Object type. */
$lang->action->search = new stdclass();
$lang->action->search->objectTypeList['']            = '';
$lang->action->search->objectTypeList['product']     = $lang->productCommon;
$lang->action->search->objectTypeList['program']     = 'Program';
$lang->action->search->objectTypeList['project']     = $lang->projectCommon;
$lang->action->search->objectTypeList['execution']   = 'Execution';
$lang->action->search->objectTypeList['bug']         = 'Bug';
$lang->action->search->objectTypeList['case']        = 'Case';
$lang->action->search->objectTypeList['caseresult']  = 'Case Result';
$lang->action->search->objectTypeList['stepresult']  = 'Case Steps';
$lang->action->search->objectTypeList['story']       = "$lang->SRCommon/$lang->URCommon";
$lang->action->search->objectTypeList['task']        = 'Task';
$lang->action->search->objectTypeList['testtask']    = 'Request';
$lang->action->search->objectTypeList['user']        = 'User';
$lang->action->search->objectTypeList['doc']         = 'Doc';
$lang->action->search->objectTypeList['doclib']      = 'Doc Lib';
$lang->action->search->objectTypeList['todo']        = 'Todo';
$lang->action->search->objectTypeList['build']       = 'Build';
$lang->action->search->objectTypeList['release']     = 'Release';
$lang->action->search->objectTypeList['productplan'] = 'Plan';
$lang->action->search->objectTypeList['branch']      = 'Branch';
$lang->action->search->objectTypeList['testsuite']   = 'Suite';
$lang->action->search->objectTypeList['caselib']     = 'Library';
$lang->action->search->objectTypeList['testreport']  = 'Report';

/* Used to display actions in dynamic method. */
$lang->action->search->label['']                      = '';
$lang->action->search->label['created']               = $lang->action->label->created;
$lang->action->search->label['opened']                = $lang->action->label->opened;
$lang->action->search->label['changed']               = $lang->action->label->changed;
$lang->action->search->label['edited']                = $lang->action->label->edited;
$lang->action->search->label['assigned']              = $lang->action->label->assigned;
$lang->action->search->label['closed']                = $lang->action->label->closed;
$lang->action->search->label['deleted']               = $lang->action->label->deleted;
$lang->action->search->label['deletedfile']           = $lang->action->label->deletedfile;
$lang->action->search->label['editfile']              = $lang->action->label->editfile;
$lang->action->search->label['erased']                = $lang->action->label->erased;
$lang->action->search->label['undeleted']             = $lang->action->label->undeleted;
$lang->action->search->label['hidden']                = $lang->action->label->hidden;
$lang->action->search->label['commented']             = $lang->action->label->commented;
$lang->action->search->label['activated']             = $lang->action->label->activated;
$lang->action->search->label['blocked']               = $lang->action->label->blocked;
$lang->action->search->label['resolved']              = $lang->action->label->resolved;
$lang->action->search->label['reviewed']              = $lang->action->label->reviewed;
$lang->action->search->label['moved']                 = $lang->action->label->moved;
$lang->action->search->label['confirmed']             = $lang->action->label->confirmed;
$lang->action->search->label['bugconfirmed']          = $lang->action->label->bugconfirmed;
$lang->action->search->label['tostory']               = $lang->action->label->tostory;
$lang->action->search->label['frombug']               = $lang->action->label->frombug;
$lang->action->search->label['totask']                = $lang->action->label->totask;
$lang->action->search->label['svncommited']           = $lang->action->label->svncommited;
$lang->action->search->label['gitcommited']           = $lang->action->label->gitcommited;
$lang->action->search->label['linked2plan']           = $lang->action->label->linked2plan;
$lang->action->search->label['unlinkedfromplan']      = $lang->action->label->unlinkedfromplan;
$lang->action->search->label['changestatus']          = $lang->action->label->changestatus;
$lang->action->search->label['marked']                = $lang->action->label->marked;
$lang->action->search->label['linked2project']        = $lang->action->label->linked2project;
$lang->action->search->label['unlinkedfromproject']   = $lang->action->label->unlinkedfromproject;
$lang->action->search->label['linked2execution']      = $lang->action->label->linked2execution;
$lang->action->search->label['unlinkedfromexecution'] = $lang->action->label->unlinkedfromexecution;
$lang->action->search->label['linked2kanban']         = $lang->action->label->linked2kanban;
$lang->action->search->label['started']               = $lang->action->label->started;
$lang->action->search->label['restarted']             = $lang->action->label->restarted;
$lang->action->search->label['recordworkhour']        = $lang->action->label->recordworkhour;
$lang->action->search->label['recordestimate']        = $lang->action->label->recordworkhour;
$lang->action->search->label['editestimate']          = $lang->action->label->editestimate;
$lang->action->search->label['canceled']              = $lang->action->label->canceled;
$lang->action->search->label['finished']              = $lang->action->label->finished;
$lang->action->search->label['paused']                = $lang->action->label->paused;
$lang->action->search->label['verified']              = $lang->action->label->verified;
$lang->action->search->label['importfromgitlab']      = $lang->action->label->importfromgitlab;
$lang->action->search->label['login']                 = $lang->action->label->login;
$lang->action->search->label['logout']                = $lang->action->label->logout;

/* Action language config for API(JIHU) */
$lang->action->apiTitle = new stdclass();
$lang->action->apiTitle->opened                = 'Opened.';
$lang->action->apiTitle->created               = 'Created.';
$lang->action->apiTitle->added                 = 'Added.';
$lang->action->apiTitle->changed               = 'Changed.';
$lang->action->apiTitle->edited                = 'Edited.';
$lang->action->apiTitle->assigned              = 'Assigned to <strong>%s</strong>.';
$lang->action->apiTitle->closed                = 'Closed.';
$lang->action->apiTitle->deleted               = 'Deleted.';
$lang->action->apiTitle->deletedfile           = 'Deleted: <strong><i>%s</i></strong>.';
$lang->action->apiTitle->editfile              = 'Edited: <strong><i>%s</i></strong>.';
$lang->action->apiTitle->erased                = 'Erased.';
$lang->action->apiTitle->undeleted             = 'Restored.';
$lang->action->apiTitle->hidden                = 'Hidden.';
$lang->action->apiTitle->commented             = 'Commented';
$lang->action->apiTitle->activated             = 'Activated.';
$lang->action->apiTitle->confirmed             = 'Confirmed.';
$lang->action->apiTitle->caseconfirmed         = '<strong>$actor</strong> confirmed the case change. The latest build is <strong>#$extra</strong>';
$lang->action->apiTitle->bugconfirmed          = '<strong>$actor</strong> confirmed Bug.';
$lang->action->apiTitle->frombug               = 'Converted from <strong>$actor</strong>. Its ID was <strong>$extra</strong>.';
$lang->action->apiTitle->started               = 'Started by <strong>$actor</strong>.';
$lang->action->apiTitle->restarted             = 'Continued by <strong>$actor</strong>.';
$lang->action->apiTitle->delayed               = 'Postponed by <strong>$actor</strong>.';
$lang->action->apiTitle->suspended             = 'Suspended by <strong>$actor</strong>.';
$lang->action->apiTitle->recordworkhour        = 'Recorded by <strong>$actor</strong> and it cost <strong>$extra</strong> hours.';
$lang->action->apiTitle->recordestimate        = 'Recorded by <strong>$actor</strong> and it cost <strong>$extra</strong> hours.';
$lang->action->apiTitle->editestimate          = '<strong>$actor</strong> edited Hour.';
$lang->action->apiTitle->deleteestimate        = '<strong>$actor</strong> deleted Hour.';
$lang->action->apiTitle->canceled              = 'Cancelled by <strong>$actor</strong>.';
$lang->action->apiTitle->svncommited           = '<strong>$actor</strong> committed and the build is <strong>#$extra</strong>.';
$lang->action->apiTitle->gitcommited           = '<strong>$actor</strong> committed and the build is <strong>#$extra</strong>.';
$lang->action->apiTitle->finished              = 'Finished by <strong>$actor</strong>.';
$lang->action->apiTitle->paused                = 'Paused by <strong>$actor</strong>.';
$lang->action->apiTitle->linked2bug            = 'Linked to <strong>$extra</strong> by <strong>$actor</strong>';
$lang->action->apiTitle->linked2testtask       = 'Linked to <strong>$extra</strong> by <strong>$actor</strong>';
$lang->action->apiTitle->resolved              = 'Resolved by <strong>$actor</strong> ';
$lang->action->apiTitle->managed               = 'By <strong>$actor</strong> managed.';
$lang->action->apiTitle->estimated             = 'By <strong>$actor</strong> estimated.';
$lang->action->apiTitle->run                   = 'By <strong>$actor</strong> executed.';
$lang->action->apiTitle->tostory               = "To story: {$lang->SRCommon}";
$lang->action->apiTitle->createchildren        = 'Create children <strong>%s</strong>.';
$lang->action->apiTitle->linkchildtask         = 'Link a child task <strong>%s</strong>.';
$lang->action->apiTitle->unlinkchildrentask    = 'Unlink a child task <strong>%s</strong>.';
$lang->action->apiTitle->linkparenttask        = 'Link a parent task <strong>%s</strong>.';
$lang->action->apiTitle->unlinkparenttask      = 'Unlink a parent task <strong>%s</strong>.';
$lang->action->apiTitle->deletechildrentask    = 'Delete a child task<strong>%s</strong>.';
$lang->action->apiTitle->createchildrenstory   = 'Create a child story <strong>%s</strong>.';
$lang->action->apiTitle->linkchildstory        = 'Link a child story <strong>%s</strong>.';
$lang->action->apiTitle->unlinkchildrenstory   = 'Unlink a child story <strong>%s</strong>.';
$lang->action->apiTitle->linkparentstory       = 'Link parent story <strong>%s</strong>.';
$lang->action->apiTitle->unlinkparentstory     = 'Unlink parent story from <strong>%s</strong>.';
$lang->action->apiTitle->deletechildrenstory   = 'Deleted a child story <strong>%s</strong>.';
$lang->action->apiTitle->linkrelatedcase       = 'Link related case <strong>%s</strong>.';
$lang->action->apiTitle->unlinkrelatedcase     = 'Unlink related case <strong>%s</strong>.';
$lang->action->apiTitle->openedbysystem        = 'Opened by system';
$lang->action->apiTitle->closedbysystem        = 'Closed by system';
$lang->action->apiTitle->communicated          = 'Communicated';
$lang->action->apiTitle->blocked               = 'Blocked';
$lang->action->apiTitle->reviewed              = 'Reviewed';
$lang->action->apiTitle->recalled              = 'Recalled';
$lang->action->apiTitle->moved                 = 'Moved';
$lang->action->apiTitle->fromlib               = 'Import from lib';
$lang->action->apiTitle->totask                = 'To task';
$lang->action->apiTitle->linked2plan           = "Link to plan";
$lang->action->apiTitle->unlinkedfromplan      = "Unlinked from plan";
$lang->action->apiTitle->changestatus          = 'Changed status';
$lang->action->apiTitle->marked                = 'Marked';
$lang->action->apiTitle->linked2execution      = "Linked to {$lang->executionCommon}";
$lang->action->apiTitle->unlinkedfromexecution = "Unlinked from {$lang->executionCommon}";
$lang->action->apiTitle->linked2kanban         = 'Linked to Kanban';
$lang->action->apiTitle->linked2project        = "Linked to {$lang->projectCommon}";
$lang->action->apiTitle->unlinkedfromproject   = "Unlinked from {$lang->projectCommon}";
$lang->action->apiTitle->unlinkedfrombuild     = "Unlinked from build";
$lang->action->apiTitle->linked2release        = "Linked to release";
$lang->action->apiTitle->unlinkedfromrelease   = "Unlinked from release";
$lang->action->apiTitle->linked2revision       = "Linked to revision";
$lang->action->apiTitle->unlinkedfromrevision  = "Unlinked from revision";
$lang->action->apiTitle->linkrelatedbug        = "Linked related Bug";
$lang->action->apiTitle->unlinkrelatedbug      = "Unlinked related Bug";
$lang->action->apiTitle->linkrelatedstory      = "Link related story {$lang->SRCommon}";
$lang->action->apiTitle->unlinkrelatedstory    = "Unlink related story {$lang->SRCommon}";
$lang->action->apiTitle->subdividestory        = "Subdivided story: {$lang->SRCommon}";
$lang->action->apiTitle->unlinkchildstory      = "Unlink child story: {$lang->SRCommon}";
$lang->action->apiTitle->verified              = 'Verified';
$lang->action->apiTitle->login                 = 'Login';
$lang->action->apiTitle->logout                = "Logout";
$lang->action->apiTitle->linked2build          = "Linked to build";
$lang->action->apiTitle->unlinkedfromtesttask  = "Unlinked from test task";
$lang->action->apiTitle->batchcreate           = "Batch create";
$lang->action->apiTitle->managedteam           = "Managed team";
$lang->action->apiTitle->managedwhitelist      = "Managed white list";
$lang->action->apiTitle->tracked               = 'Tracked';
$lang->action->apiTitle->hangup                = 'Hangup';
$lang->action->apiTitle->reviewpassed          = 'Review passed';
$lang->action->apiTitle->reviewrejected        = 'Review rejected';
$lang->action->apiTitle->reviewclarified       = 'Review clarified';
$lang->action->apiTitle->commitsummary         = 'Commit summary';
$lang->action->apiTitle->updatetrainee         = 'Update trainee';

/* Code Review in Repo or Merge Request module. */
$lang->action->desc->repocreated                  = '$date, created and reviewed by <strong>$actor</strong>: $extra.' . "\n";
$lang->action->label->repocreated                 = "create and review";
$lang->action->dynamicAction->task['gitcommited'] = 'Git Commit';
$lang->action->dynamicAction->bug['repocreated']  = $lang->action->label->repocreated;
$lang->action->desc->createmr                     = '$extra';
$lang->action->desc->deletemr                     = '$date, <strong>$actor</strong> unlink <a href="$extra">merge request</a>。';
$lang->action->desc->mergedmr                     = '$date, <strong>$actor</strong> merged code.';
$lang->action->desc->compilefail                  = '$date, <strong>$actor</strong> compile fail.';
$lang->action->desc->compilepass                  = '$date, <strong>$actor</strong> compile pass';
$lang->action->desc->approve                      = '$date, <strong>$actor</strong> approved.';
$lang->action->desc->reject                       = '$date, <strong>$actor</strong> rejected.';
$lang->action->desc->linkedrepo                   = '$date, <strong>$actor</strong> linked repo $extra';
$lang->action->desc->unlinkedrepo                 = '$date, <strong>$actor</strong> unlinked repo $extra';

$lang->action->reviewStatusList['wait']      = 'Pending approval';
$lang->action->reviewStatusList['doing']     = 'Reviewing';
$lang->action->reviewStatusList['pass']      = 'Pass';
$lang->action->reviewStatusList['reject']    = 'Reject';
$lang->action->reviewStatusList['reverting'] = 'Reverting';

$lang->action->reviewResultList['pass']   = 'Pass';
$lang->action->reviewResultList['reject'] = 'Reject';
