zui.Graph.loadModule().then(
function()
{
    const g6 = zui.Graph.Module;
    g6.registerNode(
      'tree-node',
      {
        drawShape: function drawShape(cfg, group) {
            const shape = group.addShape('rect', {
              attrs: {
                width: 60,
                height: 62,
                radius: 4
              },
              name: 'rect-shape'
            });

            if(cfg.nodeType == 'relation')
            {
                /* Relation DOM. */
                group.addShape('dom', {
                  attrs: {
                      y: 20,
                      width: 60,
                      height: 20,
                      'html' : `
                      <div class="bg-primary-50 text-center">
                        <div class='text-primary px-1' title='${cfg.text}'>${cfg.text}</div>
                      </div>`
                  },
                  name: 'relation-dom'
                });
            }
            else
            {
                shape.attr({
                    width: 300,
                    height: !cfg.objectAssign && !cfg.objectStatus ? 31 : 62,
                    stroke: '#d2d6e5',
                    fill: '#ffffff'
                });

                /* Title DOM. */
                let url = typeof(cfg.objectURL) != 'undefined' ? cfg.objectURL : '';
                if(cfg.objectType == 'release' || cfg.objectType == 'build' || cfg.objectType == 'mr') url = '';
                const title = cfg.id !== 'main' && url.length > 0 ? '<a class="item-title" href="' + url + '" data-toggle="modal" data-size="lg" title="' + cfg.objectTitle + '">#' + cfg.objectID + ' ' + cfg.objectTitle + '</a>' : '#' + cfg.objectID + ' ' + cfg.objectTitle;
                group.addShape('dom', {
                  attrs: {
                      width: 300,
                      height: 29,
                      'html' : `
                      <div class='p-1.5'>
                        <span class="label label-id gray-300-outline size-sm rounded-full flex-none text-clip">${cfg.objectTypeName}</span>
                        ${title}
                      </div>`
                  },
                  name: 'title-dom'
                });

                /* Status DOM. */
                if(cfg.objectStatus)
                {
                    group.addShape('dom', {
                        attrs: {
                            x: 0,
                            y: 30,
                            width: 100,
                            height: 25,
                            'html' : `
                            <div class='p-2'>
                              <span class="status-${cfg.objectStatus}">${cfg.statusName}</span>
                            </div>`
                        },
                        name: 'status-dom'
                    });
                }

                /* Avatar DOM. */
                if(cfg.objectAssign)
                {
                    const $assignedToAvatar = cfg.objectAssign.length ? zui.UserAvatar.renderHTML({account: cfg.objectAssign, src: usersAvatar[cfg.objectAssign], size: 20}) : '';
                    group.addShape('dom', {
                        attrs: {
                            x: 270,
                            y: 35,
                            width: 20,
                            height: 20,
                            'html' : `${$assignedToAvatar}`
                        },
                        name: 'avatar-dom'
                    });
                }
            }
          return shape;
        },
      },
      'single-node'
    );
});

window.getVGap = function(d)
{
    if(d.nodeType != 'relation' && !d.objectStatus && !d.objectAssign) return 10;
    return 25;
}
window.getHGap = function(d)
{
    if(d.nodeType == "relation") return 80;
    return 200;
}
window.getSide = function()
{
    return 'right';
}
