<?php
namespace zin;

include $app->getModuleRoot() . 'transfer/ui/showimport.html.php';

jsVar('ignoreLang', $lang->project->ignore);
jsVar('overParentEstStartedLang', $lang->task->overParentEsStarted);
jsVar('overParentDeadlineLang', $lang->task->overParentDeadline);

$jsDatas       = json_encode(array_values($datas));
$jsTasks       = json_encode($datas);
$jsParentTasks = json_encode($parentTasks);

$team = array();
foreach($fields['assignedTo']['items'] as $account => $name) $team[] = array('text' => $name, 'value' => $account);
$team = json_encode($team);
pageJS(<<<JAVASCRIPT
$(function()
{
    var tbodyInited = false;
    $('#mainContainer > #mainContent .panel-body .form .form-batch-container .table tbody').on('inited', function() 
    {
        if(tbodyInited) return false;
        tbodyInited = true;
        $.each($('#mainContent .form .form-batch-container tbody tr'), function(trIndex)
        {
            const data = {$jsDatas}[trIndex];
            if(data.team != undefined)
            {
                let \$estimate = $(this).find('.form-batch-control[data-name="estimate"]').empty();
                $.each(data.team, function(index, account){
                    \$estimate.append('<div class="input-group estimate-box"></div>')
                    let \$estimateInputGroup = \$estimate.find('.input-group').last();
                    \$estimateInputGroup.append($('<div class="form-group-wrapper picker-box"></div>').picker({name: 'team[' + data.id + '][]', items: {$team}, defaultValue: account, required: true}));;
                    \$estimateInputGroup.append($('<input type="text" name="estimate[' + data.id + '][]" id="estimate_' + index + '" value="' + data.estimate[index] + '" class="form-control" autocomplete="off">'));
                });
            }
        });
        $('#mainContent .form .form-batch-container tbody').off('change', '[name^=estStarted]').on('change', '[name^=estStarted]', function(e){checkBatchEstStartedAndDeadline(e)});
        $('#mainContent .form .form-batch-container tbody').off('change', '[name^=deadline]').on('change', '[name^=deadline]', function(e){checkBatchEstStartedAndDeadline(e)});
    });
});

function checkBatchEstStartedAndDeadline(event)
{
    const parentTasks = {$jsParentTasks};
    const tasks       = {$jsTasks};
    if(parentTasks.length == 0) return true;

    const \$currentRow = $(event.target).closest('tr');
    const taskID      = \$currentRow.find('[name^=id]').val();
    const parentID    = typeof tasks[taskID].parent != 'undefined' ? tasks[taskID].parent : undefined;
    if(typeof parentTasks[parentID] == 'undefined' || !parentTasks[parentID]) return true;

    const parentTask  = parentTasks[parentID];
    const field       = $(event.target).closest('.form-batch-control').data('name');
    const estStarted  = \$currentRow.find('[name^=estStarted]').val();
    const deadline    = \$currentRow.find('[name^=deadline]').val();

    if(field == 'estStarted')
    {
        let parentEstStarted = typeof tasks[parentID] == 'undefined' || $(event.target).closest('tbody').find('[name="estStarted[' + parentID + ']"]').length == 0 ? parentTask.estStarted : $(event.target).closest('tbody').find('[name="estStarted[' + parentID + ']"]').val();
        if(estStarted.length > 0 && parentEstStarted.length > 0 && estStarted < parentEstStarted)
        {
            const \$estStartedTd = \$currentRow.find('td[data-name=estStarted]');
            if(\$estStartedTd.find('.date-tip').length == 0 || \$estStartedTd.find('.date-tip .form-tip').length > 0)
            {
                \$estStartedTd.find('.date-tip').remove();

                let \$datetip = $('<div class="date-tip"></div>');
                \$datetip.append('<div class="form-tip text-warning">' + overParentEstStartedLang.replace('%s', parentEstStarted) + '<span class="ignore-date underline">' + ignoreLang + '</div>');
                \$datetip.off('click', '.ignore-date').on('click', '.ignore-date', function(e){ignoreTip(e)});
                \$estStartedTd.append(\$datetip);
            }
        }
    }

    if(field == 'deadline')
    {
        let parentDeadline = typeof tasks[parentID] == 'undefined' || $(event.target).closest('tbody').find('[name="deadline[' + parentID + ']"]').length == 0 ? parentTask.deadline : $(event.target).closest('tbody').find('[name="deadline[' + parentID + ']"]').val();
        if(deadline.length > 0 && parentDeadline.length > 0 && deadline > parentDeadline)
        {
            const \$deadlineTd = \$currentRow.find('td[data-name=deadline]');
            if(\$deadlineTd.find('.date-tip').length == 0 || \$deadlineTd.find('.date-tip .form-tip').length > 0)
            {
                \$deadlineTd.find('.date-tip').remove();

                let \$datetip = $('<div class="date-tip"></div>');
                \$datetip.append('<div class="form-tip text-warning">' + overParentDeadlineLang.replace('%s', parentDeadline) + '<span class="ignore-date underline">' + ignoreLang + '</div>');
                \$datetip.off('click', '.ignore-date').on('click', '.ignore-date', function(e){ignoreTip(e)});
                \$deadlineTd.append(\$datetip);
            }
        }
    }
}
JAVASCRIPT
);
