<?php
/**
 * The control file of execution module of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2012 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.cnezsoft.com)
 * @license     business(商业软件)
 * @author      Yangyang Shi <shiyangyang@cnezsoft.com>
 * @package     execution
 * @version     $Id$
 * @link        http://www.zentao.net
 */
public function mergeRelations($relations = array())
{
    return $this->loadExtension('gantt')->mergeRelations($relations);
}
public function getRelationTasks($executionID, $appendTasks = array())
{
    return $this->loadExtension('gantt')->getRelationTasks($executionID, $appendTasks);
}

public function getDisabledTasks($taskRelations, $taskID, $taskType = 'pretask')
{
    return $this->loadExtension('gantt')->getDisabledTasks($taskRelations, $taskID, $taskType);
}

public function checkRelation($relations = array(), $executionID = 0)
{
    $this->loadExtension('gantt')->checkRelation($relations, $executionID);
}

public function createRelationOfTasks($executionID)
{
    $this->loadExtension('gantt')->createRelationOfTasks($executionID);
}

public function updateRelationOfTask($relationID, $executionID)
{
    $this->loadExtension('gantt')->updateRelationOfTask($relationID, $executionID);
}

public function editRelationOfTasks($executionID)
{
    $this->loadExtension('gantt')->editRelationOfTasks($executionID);
}

/**
 * @param object $pager
 * @param int $executionID
 */
public function getRelationsOfTasks($executionID, $pager = null)
{
    return $this->loadExtension('gantt')->getRelationsOfTasks($executionID, $pager);
}

public function getDataForGantt($executionID, $type, $orderBy)
{
    return $this->loadExtension('gantt')->getDataForGantt($executionID, $type, $orderBy);
}

public function deleteRelation($id)
{
    $this->loadExtension('gantt')->deleteRelation($id);
}

public function parseOrderBy($orderBy)
{
    return $this->loadExtension('gantt')->parseOrderBy($orderBy);
}

public function buildKanbanOrderBy($field, $currentOrder, $currentDirect)
{
    return $this->loadExtension('gantt')->buildKanbanOrderBy($field, $currentOrder, $currentDirect);
}

public function getTaskItems($executionID, $taskID, $taskType = 'pretask', $appendTasks = 0)
{
    return $this->loadExtension('gantt')->getTaskItems($executionID, $taskID, $taskType, $appendTasks);
}

public function checkTaskRelation($executionID)
{
    return $this->loadExtension('gantt')->checkTaskRelation($executionID);
}
