<?php
/**
 * The cases view file of deploy module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li <liyang@easycorp.ltd>
 * @package     deploy
 * @link        https://www.zentao.net
 */
namespace zin;

include 'nav.html.php';

toolbar
(
    hasPriv('deploy', 'linkCases') ? item(set(array
    (
        'type' => 'primary',
        'text' => $lang->deploy->linkCases,
        'url'   => createLink('deploy', 'linkCases', "deployID={$deploy->id}")
    ))) : null,
    backBtn
    (
        setClass('secondary'),
        set::icon('back'),
        $lang->goback
    )
);

$footToolbar = hasPriv('deploy', 'batchUnlinkCases') ? array('items' => array(array('text' => $lang->deploy->unlinkCase, 'className' => 'batch-btn ajax-btn', 'data-url' => createLink('deploy', 'batchUnlinkCases', "deployID={$deploy->id}")))) : null;

$config->deploy->dtable->cases->fieldList['actions']['list']['unlinkCase']['url'] = array('module' => 'deploy', 'method' => 'unlinkCase', 'params' => "deploy={$deploy->id}&id={id}");
if(!hasPriv('deploy', 'unlinkCase')) unset($config->deploy->dtable->cases->fieldList['actions']['list']['unlinkCase']);

$tableData = initTableData($cases, $config->deploy->dtable->cases->fieldList);

dtable
(
    set::cols($config->deploy->dtable->cases->fieldList),
    set::data($tableData),
    set::checkable('true'),
    set::footToolbar($footToolbar)
);
