<?php
/**
 * The steps view file of deploy module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li <liyang@easycorp.ltd>
 * @package     deploy
 * @link        https://www.zentao.net
 */
namespace zin;

include 'nav.html.php';

toolbar
(
    hasPriv('deploy', 'manageStep') ? item(set(array
    (
        'type' => 'primary',
        'text' => $lang->deploy->manageStep,
        'url'   => createLink('deploy', 'manageStep', "deployID={$deploy->id}")
    ))) : null,
    backBtn
    (
        setClass('secondary'),
        set::icon('back'),
        $lang->goback
    )
);

jsVar('deployLang', $this->lang->deploy);
jsVar('deployID', $deploy->id);
jsVar('users', $users);
jsVar('testtaskLang', $this->lang->testtask);
jsVar('testcaseLang', $this->lang->testcase);
jsVar('caseResults', $results);
jsVar('canRunCase', common::hasPriv('testtask', 'runDeployCase'));
jsVar('canViewCaseRunResult', common::hasPriv('testtask', 'deployCaseResults'));
jsVar('canViewStep', common::hasPriv('deploy', 'viewStep'));
jsVar('canViewCase', common::hasPriv('testcase', 'view'));
jsVar('canFinish', common::hasPriv('deploy', 'finishStep'));
jsVar('canAssignTo', common::hasPriv('deploy', 'assignTo'));
jsVar('canEdit', common::hasPriv('deploy', 'editStep'));
jsVar('canDelete', common::hasPriv('deploy', 'deleteStep'));
jsVar('canModify', common::hasPriv('deploy', 'deleteStep') || common::hasPriv('deploy', 'editStep') || common::hasPriv('deploy', 'finishStep') || common::hasPriv('deploy', 'assignTo'));

foreach($stepGroups as $current => $region)
{
    foreach($region['items'] as $index => $group)
    {
        $group['draggable']  = true;
        $group['colWidth']   = 'auto';
        $group['getCol']     = jsRaw('window.getCol');
        $group['getItem']    = jsRaw('window.getItem');
        $group['itemProps']  = array('actions' => jsRaw('window.getItemActions'));
        $group['itemRender'] = jsRaw('window.itemRender');
        $group['canDrop']    = jsRaw('window.canDrop');
        $stepGroups[$current]['items'][$index] = $group;
    }
}

div
(
    set::id('stepsKanbanList'),
    setClass('bg-white'),
    zui::kanbanList
    (
        set::key('kanban'),
        set::items($stepGroups),
        set::height('calc(100vh - 120px)')
    )
);
