const toggleNavigator = () => {
    const navigator    = event.target.value;
    const $form        = $(event.target).closest('form');
    const $app         = $form.find('[name=app]');
    const module       = $form.find('[name=module]').val();
    const appPicker    = $app.zui('picker');
    const modulePicker = $form.find('[name=positionModule]').zui('picker');

    if(navigator == 'primary') {
        $app.closest('.form-group').addClass('hidden');

        appPicker.render({items: []});
        appPicker.$.setValue('');

        $.getJSON($.createLink('workflow', 'ajaxGetApps', 'splitProject=0'), function(apps) {
            modulePicker.render({items: apps});
            modulePicker.$.setValue('');
        });
    } else if(navigator == 'secondary') {
        $app.closest('.form-group').removeClass('hidden');

        $.getJSON($.createLink('workflow', 'ajaxGetApps', `splitProject=1&exclude=${module}`), function(apps) {
            appPicker.render({items: apps});
            appPicker.$.setValue('');
        });

        modulePicker.render({items: []});
        modulePicker.$.setValue('');
    } else {
        $app.closest('.form-group').addClass('hidden');

        appPicker.render({items: []});
        appPicker.$.setValue('');

        modulePicker.render({items: []});
        modulePicker.$.setValue('');
    }
}

const toggleApp = () => {
    const app    = event.target.value;
    const picker = $(event.target).closest('form').find('[name=positionModule]').zui('picker');

    if(app) {
        $.getJSON($.createLink('workflow', 'ajaxGetAppMenus', `app=${app}`), function(menus) {
            picker.render({items: menus});
            picker.$.setValue('');
        });
    } else {
        picker.render({items: []});
        picker.$.setValue('');
    }
}

const toggleApproval = () => {
    const approval = event.target.value;
    $(event.target).closest('form').find('#approvalFlow').closest('.form-group').toggleClass('hidden', approval == 'disabled');
}
