<?php
/**
 * The browse view file of domain module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li <liyang@easycorp.ltd>
 * @package     domain
 * @link        https://www.zentao.net
 */
namespace zin;
$queryMenuLink = createLink('domain', 'browse', "browseType=bySearch&param={queryID}");
featureBar
(
    set::queryMenuLinkCallback(fn($key) => str_replace('{queryID}', (string)$key, $queryMenuLink)),
    li(searchToggle())
);

$canCreate  = hasPriv('domain', 'create');
$createLink = $this->createLink('domain', 'create');

$createItem = array();
$createItem['text']        = $lang->domain->create;
$createItem['url']         = $createLink;
$createItem['class']       = 'primary';
$createItem['icon']        = 'plus';
$createItem['data-toggle'] = 'modal';
$createItem['data-size']   = 'sm';

toolbar
(
    $canCreate ? item(set($createItem)) : null
);

$tableData = initTableData($domainList, $config->domain->dtable->fieldList, $this->domain);
dtable
(
    set::userMap($users),
    set::cols($config->domain->dtable->fieldList),
    set::data($tableData),
    set::sortLink
    (
        createLink
        (
            'domain',
            'browse',
            "browseType=$browseType&param=$param&orderBy={name}_{sortType}&recTotal={$pager->recTotal}&recPerPage={$pager->recPerPage}"
        )
    ),
    set::orderBy($orderBy),
    set::footPager(usePager())
);

render();
