<?php
namespace zin;

global $lang;

jsVar('currentMethod', 'create');

$model         = data('model');
$copyProjectID = data('copyProjectID');

if(data('model') != 'kanban')
{
    $loadUrl = helper::createLink('project', 'create', "model={$model}&program={parent}&copyProjectID={$copyProjectID}&extra=charter={charter},hasProduct={hasProduct}");
    query('formGridPanel')->each(function($node) use($lang, $loadUrl)
    {
        $fields = $node->prop('fields');

        $fields->field('charter')
            ->class('charterBox')
            ->control('picker')
            ->items(data('charters'))
            ->value(data('charter'))
            ->moveBefore('parent');

        $fields->field('hasProduct')->hidden(data('model') == 'ipd');

        $fields->field('category')
            ->class('categoryBox')
            ->labelControl
            (
                setting()
                    ->control('radioList')
                    ->inline()
                    ->className('ml-4 hasProduct hidden')
                    ->addToList('items', array('name' => 'hasProduct', 'text' => $lang->project->projectTypeList[1], 'value' => '1'))
                    ->addToList('items', array('name' => 'hasProduct', 'text' => $lang->project->projectTypeList[0], 'value' => '0'))
            )
            ->control('picker')
            ->items($lang->project->categoryList)
            ->value('')
            ->moveAfter('parent');

        $fields->field('budget')
            ->foldable(false)
            ->moveAfter('category');

        if(data('model') != 'ipd')
        {
            $fields->remove('category');
            $fields->orders('hasProduct,budget');
        }
        else
        {
            $fields->orders('category,budget');
        }

        $hasProductValue = data('hasProduct') === null ? (data('copyProjectID') ? data('copyProject.hasProduct') : '1') : data('hasProduct');

        $fields->field('productsBox')
            ->width('full')
            ->required(data('copyProject.parent') || data('parentProgram.id') || data('project.parent'))
            ->control(array
            (
                'control'           => 'productsBox',
                'productItems'      => data('charter') ? data('charterProductPairs') : data('allProducts'),
                'branchGroups'      => data('charter') ? data('branchPairs') : data('branchGroups'),
                'planGroups'        => data('productPlans'),
                'roadmapGroups'     => data('productRoadmaps'),
                'productPlans'      => data('productPlans'),
                'linkedProducts'    => data('charter') ? data('charterProducts') : data('linkedProducts'),
                'linkedBranches'    => data('linkedBranches'),
                'project'           => data('project') ? data('project') : data('copyProject'),
                'hasNewProduct'     => data('app.rawMethod') == 'create',
                'isStage'           => data('isStage'),
                'type'              => data('charter') ? 'roadmap' : 'plan',
                'errorSameProducts' => $lang->project->errorSameProducts,
                'selectTip'         => $lang->project->selectProductTip,
                'hidden'            => !$hasProductValue && !data('charter')
            ));

        $fields->field('hasProduct')->value($hasProductValue);

        $fields->autoLoad('parent', 'charter,acl,productsBox,hasProduct')
            ->autoLoad('charter', 'productsBox');

        $node->setProp('fields', $fields);
        $node->setProp('loadUrl', $loadUrl);
    });

    query('.charterBox .picker-box')->on('change', jsCallback()->call('changeCharter'));
    query('.categoryBox .picker-box')->on('change', jsCallback()->call('changeCategory'));
}
