<?php
/**
 * The create view file of feedback module of ZenTaoPMS.
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yuting Wang <wangyuting@easycorp.ltd>
 * @package     feedback
 * @link        https://www.zentao.net
 */
namespace zin;

dropmenu(set::text($productID == 'all' ? $lang->product->allProduct : ''), set::tab('product'));
formPanel
(
    setID('feedbackCreateForm'),
    set::title($lang->feedback->create),
    on::change('[name=product]', 'changeProduct'),
    formRow
    (
        formGroup
        (
            set::width('1/2'),
            set::label($lang->feedback->product),
            set::required(true),
            picker
            (
                set::name('product'),
                set::items($products),
                set::value((!empty($productID) && $productID !== 'all') ? $productID : '')
            )
        )
    ),
    formRow
    (
        setID('moduleBox'),
        formGroup
        (
            set::width('1/2'),
            set::label($lang->feedback->module),
            picker
            (
                set::name('module'),
                set::items($modules),
                set::value($moduleID),
                set::required(true)
            )
        )
    ),
    formRow
    (
        formGroup
        (
            set::width('1/2'),
            set::name('type'),
            set::label($lang->feedback->type),
            set::items($lang->feedback->typeList)
        )
    ),
    formRow
    (
        formGroup
        (
            set::label($lang->feedback->title),
            set::required(true),
            inputGroup
            (
                input(set::name('title')),
                checkbox
                (
                    set::name('public'),
                    set::text($lang->feedback->public),
                    set::value(1),
                    set::rootClass('btn'),
                    set::checked(true)
                ),
                $lang->feedback->pri,
                pripicker(set::width('120px'), set::name('pri'), set::items($lang->feedback->priList), set::value(3))
            )
        )
    ),
    formRow
    (
        formGroup
        (
            set::label($lang->feedback->desc),
            editor(set::name('desc'))
        )
    ),
    formRow
    (
        formGroup
        (
            set::width('1/2'),
            set::name('feedbackBy'),
            set::label($lang->feedback->feedbackBy),
        )
    ),
    formRow
    (
        formGroup
        (
            set::width('1/2'),
            set::name('source'),
            set::label($lang->feedback->source),
        )
    ),
    formRow
    (
        formGroup
        (
            set::width('1/2'),
            set::name('notifyEmail'),
            set::label($lang->feedback->notifyEmail),
        )
    ),
    formGroup
    (
        set::width('1/2'),
        set::label($lang->feedback->mailto),
        mailto
        (
            set::name('mailto'),
            set::items($users),
            set::multiple(true)
        )
    ),
    formGroup
    (
        set::width('1/2'),
        set::name('keywords'),
        set::label($lang->feedback->keywords)
    ),
    formRow
    (
        formGroup
        (
            set::label($lang->feedback->files),
            fileSelector()
        )
    ),
    formRow
    (
        formGroup
        (
            set::width('1/2'),
            set::label($lang->feedback->notify),
            inputGroup
            (
                setClass('h-8 items-center'),
                checkbox
                (
                    set::name('notify'),
                    set::text($lang->feedback->mailNotify),
                    set::value(1),
                    set::checked(true)
                )
            )
        )
    ),
);

render();
