<?php
declare(strict_types=1);
/**
 * The test class file of domain module of ZenTaoPMS.
 *
 * @copyright   Copyright 2009-2023 禅道软件（青岛）有限公司(ZenTao Software (Qingdao) Co., Ltd. www.zentao.net)
 * @license     ZPL(https://zpl.pub/page/zplv12.html) or AGPL(https://www.gnu.org/licenses/agpl-3.0.en.html)
 * @author      Yang Li <liyang@easycorp.ltd>
 * @package     domain
 * @link        https://www.zentao.net
 */
class domainTest
{
    private $objectModel;

    public function __construct()
    {
        su('admin');

        global $tester;
        $this->objectModel = $tester->loadModel('domain');
    }

    /**
     * Test create a domain.
     *
     * @param  array   $param
     * @access public
     * @return object|array
     */
    public function createTest(array $param = array()): object|array
    {
        $createFields = array();
        $createFields['domain']      = '';
        $createFields['adminURI']    = '';
        $createFields['resolverURI'] = '';
        $createFields['register']    = '';
        $createFields['expiredDate'] = '';
        $createFields['renew']       = 'auto';
        $createFields['account']     = 'admin';

        $data = new stdclass();
        foreach($createFields as $field => $defaultValue) $data->$field = zget($param, $field, $defaultValue);

        $objectID = $this->objectModel->create($data);
        return dao::isError() ? dao::getError() : $this->objectModel->fetchById($objectID);
    }

    /**
     *  Test update a domain.
     *
     *  @param  int     $oldDomainID
     *  @param  array   $newDomainData
     *  @access public
     *  @return object|array
     */
    public function updateTest(int $oldDomainID, array $newDomainData = array()): object|array
    {
        $oldDomain = $this->objectModel->fetchById($oldDomainID);

        $newDomain = clone $oldDomain;
        foreach($newDomainData as $field => $value) $newDomain->$field = $value;

        $change = $this->objectModel->update($oldDomainID, $newDomain);
        return dao::isError() ? dao::getError() : $change;
    }
}
