<?php
namespace zin;
global $lang, $config;

$copyType       = data('copyType');
$programListSet = data('programListSet');
$model          = data('model');
$copyProject    = data('copyProject');

jsVar('programID',    data('programID'));
jsVar('pageType',     data('pageType'));
jsVar('copyType',     $copyType);
jsVar('nextStepText', $lang->project->nextStep);
jsVar('LONG_TIME',    LONG_TIME);
jsVar('end',          isset($copyProject->end) ? $copyProject->end : '');
jsVar('budget',       isset($copyProject->budget) ? $copyProject->budget : '');
jsVar('days',         isset($copyProject->days) ? $copyProject->days : '');
jsVar('future',       isset($copyProject->future) ? $copyProject->future : 'off');

$allDataItems = array();
$allList      = $model == 'ipd' ? $lang->project->copyProject->ipdAllList : $lang->project->copyProject->allList;
foreach($allList as $name)
{
    $executionTitle = $model == 'scrum' || $model == 'agileplus' ? sprintf($name, $lang->project->copyProject->sprint) : sprintf($name, $lang->project->stage);
    $allDataItems[] = div
        (
            setClass('all-item clip'),
            set::title($executionTitle),
            icon('success', setClass('mr-2')),
            $executionTitle
        );
}

query('#copyProjectModal')->replaceWith
(
    modal
    (
        set::id('copyProjectModal'),
        div
        (
            setClass('copy-container'),
            ul
            (
                setClass('nav nav-tabs'),
                li
                (
                    setClass('active'),
                    a(setClass('pointer-events-none'), setID('firstTab'), setData('target', 'tabContent1'), setData('toggle', 'tab'), icon(setClass('number'), 1), span($lang->project->copyProject->select)),
                    div(setClass('line'))
                ),
                li
                (
                    a(setClass('pointer-events-none'), setData('toggle', 'tab'), icon(setClass('number'), 2), span($lang->project->copyProject->confirmData)),
                    div(setClass('line'))
                ),
                li
                (
                    a(setClass('pointer-events-none'), setData('toggle', 'tab'), icon(setClass('number'), 3), span($lang->project->copyProject->improveData)),
                    div(setClass('line'))
                ),
                li
                (
                    a(setClass('pointer-events-none'), setData('toggle', 'tab'), icon(setClass('number'), 4), span($lang->project->copyProject->improveData)),
                    div(setClass('line'))
                )
            ),
            div
            (
                setClass('tab-content'),
                div
                (
                    setID('tabContent1'),
                    setClass('tab-pane fade active in'),
                    div
                    (
                        setClass('content'),
                        div
                        (
                            setClass('copy-title'),
                            $lang->project->copyProject->selectPlz
                        ),
                        div
                        (
                            setClass('select-box'),
                            $config->systemMode == 'ALM' ? picker
                            (
                                setClass('mr-4'),
                                set::width('150'),
                                set::name('parent'),
                                set::items($programListSet),
                                set::placeholder($lang->project->copyProject->selectProgram)
                            ) : null,
                            picker
                            (
                                set::width('300'),
                                set::name('selectCopyprojectID'),
                                set::items(array()),
                                set::placeholder($lang->project->copyProject->selectProjectPlz)
                            )
                        ),
                        div(setID('replaceList'), setClass('flex items-center flex-wrap gap-4 mb-4'))
                    ),
                    div
                    (
                        setClass('footer-btns'),
                        button
                        (
                            setClass('btn primary next-btn'),
                            setData('target', '#tabContent2'),
                            setData('toggle', 'tab'),
                            $lang->project->nextStep
                        ),
                        button
                        (
                            setClass('btn cancel-btn'),
                            setData('dismiss', 'modal'),
                            $lang->project->copyProject->cancel
                        )
                    )
                ),
                div
                (
                    setID('tabContent2'),
                    setClass('tab-pane fade'),
                    div
                    (
                        setClass('content'),
                        div(setClass('copy-title'), $lang->project->copyProject->confirmCopyDataTip),
                        div(setClass('copy-project-title clip mb-4')),
                        div
                        (
                            setClass('all-content'),
                            radio
                            (
                                set::rootClass('allData'),
                                set::name('allCheckbox'),
                                $lang->project->copyProject->all
                            ),
                            div
                            (
                                setClass('all-data'),
                                $allDataItems
                            )
                        ),
                        div
                        (
                            setClass('basic-content'),
                            radio
                            (
                                set::rootClass('basicData'),
                                set::name('basicCheckbox'),
                                $lang->project->copyProject->basic
                            ),
                            div
                            (
                                setClass('all-data'),
                                div
                                (
                                    setClass('all-item clip'),
                                    icon('success', setClass('mr-2')),
                                    $lang->project->copyProject->basicInfo
                                )
                            )
                        )
                    ),
                    div
                    (
                        setClass('footer-btns'),
                        button
                        (
                            setClass('btn primary complete-btn'),
                            $lang->project->copyProject->toComplete
                        ),
                        button
                        (
                            setClass('btn cancel-btn'),
                            setData('dismiss', 'modal'),
                            $lang->project->copyProject->cancel
                        ),
                        formHidden('choseCopyprojectID', '')
                    )
                )
            )
        )
    )
);
