ALTER TABLE `zt_doc` ADD `template` varchar(30) COLLATE 'utf8_general_ci' NOT NULL AFTER `lib`;
ALTER TABLE `zt_doc` ADD `templateType` varchar(30) COLLATE 'utf8_general_ci' NOT NULL AFTER `template`;
ALTER TABLE `zt_doc` ADD `chapterType` varchar(30) COLLATE 'utf8_general_ci' NOT NULL AFTER `templateType`;
ALTER TABLE `zt_doc` ADD `assetLib` mediumint(8) unsigned NOT NULL default 0 after `views`;
ALTER TABLE `zt_doc` ADD `assetLibType` varchar(30) NOT NULL default '' after `assetLib`;
ALTER TABLE `zt_doc` ADD `from` mediumint(8) unsigned NOT NULL default 0 after `assetLibType`;
ALTER TABLE `zt_doc` ADD `fromVersion` smallint(6) NOT NULL default 1 after `from`;
ALTER TABLE `zt_doc` ADD `assignedTo` varchar(30) NOT NULL after `addedDate`;
ALTER TABLE `zt_doc` ADD `assignedDate` date NOT NULL after `assignedTo`;
ALTER TABLE `zt_doc` ADD `approvedDate` date NOT NULL after `assignedDate`;
ALTER TABLE `zt_doc` ADD `status` varchar(30) NOT NULL after `type`;

ALTER TABLE `zt_story` ADD `storyChanged` enum('0','1') NOT NULL DEFAULT '0' AFTER `version`;
ALTER TABLE `zt_story` ADD `lib` mediumint(8) unsigned NOT NULL default 0 after `mailto`;
ALTER TABLE `zt_story` ADD `fromStory` mediumint(8) unsigned NOT NULL default 0 after `lib`;
ALTER TABLE `zt_story` ADD `fromVersion` smallint(6) NOT NULL default 1 after `fromStory`;
ALTER TABLE `zt_story` ADD `approvedDate` date NOT NULL after `assignedDate`;

ALTER TABLE `zt_todo` CHANGE `type` `type` char(15) NOT NULL AFTER `feedback`;

-- DROP TABLE IF EXISTS `zt_approval`;
CREATE TABLE `zt_approval` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `flow` mediumint(8) NOT NULL,
  `objectType` varchar(30) NOT NULL,
  `objectID` mediumint(9) NOT NULL,
  `nodes` mediumtext NOT NULL,
  `version` mediumint(9) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'doing',
  `result` varchar(20) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_approvalflow`;
CREATE TABLE `zt_approvalflow` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `code` varchar(100) NOT NULL,
  `desc` mediumtext NOT NULL,
  `version` mediumint(8) NOT NULL DEFAULT '1',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `type` varchar(30) NOT NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_approvalflowobject`;
CREATE TABLE `zt_approvalflowobject` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `root` int(8) NOT NULL,
  `flow` int(8) NOT NULL,
  `objectType` char(30) NOT NULL,
  `objectID` mediumint(9) NOT NULL,
  `extra` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_approvalflowspec`;
CREATE TABLE `zt_approvalflowspec` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `flow` mediumint(8) NOT NULL,
  `version` mediumint(8) NOT NULL,
  `nodes` mediumtext NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_approvalnode`;
CREATE TABLE `zt_approvalnode` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `approval` mediumint(8) NOT NULL,
  `type` enum('review','cc') NOT NULL,
  `title` varchar(255) NOT NULL,
  `account` char(30) NOT NULL,
  `node` varchar(100) NOT NULL,
  `reviewType` varchar(100)  NOT NULL DEFAULT 'manual',
  `multipleType` enum('and','or') NOT NULL DEFAULT 'and',
  `prev` mediumtext NOT NULL,
  `next` mediumtext NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'wait',
  `result` varchar(10) NOT NULL,
  `date` date NOT NULL,
  `opinion` mediumtext NOT NULL,
  `extra` mediumtext NOT NULL,
  `reviewedBy` char(30) NOT NULL,
  `reviewedDate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_approvalobject`;
CREATE TABLE `zt_approvalobject` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `approval` int(8) NOT NULL,
  `objectType` char(30) NOT NULL,
  `objectID` mediumint(8) NOT NULL,
  `extra` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_approvalrole`;
CREATE TABLE `zt_approvalrole` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `code` char(30) NOT NULL,
  `name` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  `users` longtext NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_durationestimation`;
CREATE TABLE IF NOT EXISTS `zt_durationestimation` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `stage` mediumint(9) NOT NULL,
  `workload` varchar(255) NOT NULL,
  `worktimeRate` varchar(255) NOT NULL,
  `people` varchar(255) NOT NULL,
  `startDate` date NOT NULL,
  `endDate` date NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_workestimation`;
CREATE TABLE IF NOT EXISTS `zt_workestimation` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `scale` decimal(10,2) unsigned NOT NULL,
  `productivity` decimal(10,2) unsigned NOT NULL,
  `duration` decimal(10,2) unsigned NOT NULL,
  `unitLaborCost` decimal(10,2) unsigned NOT NULL,
  `totalLaborCost` decimal(10,2) unsigned NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `dayHour` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_intervention`;
CREATE TABLE IF NOT EXISTS `zt_intervention` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `activity` mediumint(8) NOT NULL,
  `status` char(30) NOT NULL,
  `partake` text NOT NULL,
  `begin` date NOT NULL,
  `realBegin` date NOT NULL,
  `situation` varchar(255) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project` (`project`,`activity`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_activity`;
CREATE TABLE IF NOT EXISTS `zt_activity` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `process` mediumint(9) NOT NULL,
  `name` varchar(255) NOT NULL,
  `optional` varchar(255) NOT NULL,
  `tailorNorm` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `order` mediumint(8) DEFAULT '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_auditcl`;
CREATE TABLE IF NOT EXISTS `zt_auditcl` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `model` char(30) NOT NULL DEFAULT 'waterfall',
  `practiceArea` char(30) NOT NULL,
  `type` char(30) NOT NULL,
  `title` varchar(255) NOT NULL,
  `objectType` char(30) NOT NULL,
  `objectID` int(10) DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_auditplan`;
CREATE TABLE IF NOT EXISTS `zt_auditplan` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `dateType` char(30) DEFAULT NULL,
  `config` text,
  `objectID` mediumint(9) NOT NULL,
  `objectType` char(30) NOT NULL,
  `process` mediumint(9) NOT NULL,
  `processType` char(30) NOT NULL,
  `checkDate` date NOT NULL,
  `checkedBy` varchar(30) NOT NULL,
  `realCheckDate` date NOT NULL,
  `result` char(30) NOT NULL,
  `project` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `checkBy` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_auditresult`;
CREATE TABLE IF NOT EXISTS `zt_auditresult` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `auditplan` mediumint(8) NOT NULL,
  `listID` mediumint(8) NOT NULL,
  `result` char(30) NOT NULL,
  `checkedBy` varchar(30) NOT NULL,
  `checkedDate` date NOT NULL,
  `comment` text NOT NULL ,
  `assignedTo` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_nc`;
CREATE TABLE IF NOT EXISTS `zt_nc` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `auditplan` mediumint(8) NOT NULL,
  `listID` mediumint(8) NOT NULL,
  `title` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  `type` char(30) NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  `severity` char(30) NOT NULL,
  `deadline` date NOT NULL,
  `resolvedBy` varchar(30) NOT NULL,
  `resolution` char(30) NOT NULL,
  `resolvedDate` date NOT NULL,
  `closedBy` varchar(30) NOT NULL,
  `closedDate` date NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `assignedDate` date NOT NULL,
  `activateDate` date NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_zoutput`;
CREATE TABLE IF NOT EXISTS `zt_zoutput` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `activity` mediumint(8) NOT NULL,
  `name` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `optional` char(20) NOT NULL,
  `tailorNorm` varchar(255) NOT NULL,
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `order` mediumint(8) DEFAULT '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_process`;
CREATE TABLE IF NOT EXISTS `zt_process` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `model` char(30) NOT NULL DEFAULT 'waterfall',
  `name` varchar(255) NOT NULL,
  `type` char(30) NOT NULL,
  `abbr` char(30) NOT NULL,
  `desc` text NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `order` mediumint(9) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_programactivity`;
CREATE TABLE IF NOT EXISTS `zt_programactivity` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `process` mediumint(8) NOT NULL,
  `activity` mediumint(8) NOT NULL,
  `name` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `reason` varchar(255) NOT NULL,
  `result` char(30) NOT NULL,
  `linkedBy` char(30) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_programoutput`;
CREATE TABLE IF NOT EXISTS `zt_programoutput` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `process` mediumint(8) NOT NULL,
  `activity` mediumint(8) NOT NULL,
  `output` mediumint(8) NOT NULL,
  `content` text NOT NULL,
  `name` varchar(255) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `result` char(30) NOT NULL,
  `linkedBy` char(30) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_programprocess`;
CREATE TABLE IF NOT EXISTS `zt_programprocess` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `process` mediumint(8) NOT NULL,
  `name` varchar(255) NOT NULL,
  `type` char(30) NOT NULL,
  `abbr` char(30) NOT NULL,
  `desc` text NOT NULL,
  `reason` varchar(255) NOT NULL,
  `linkedBy` char(30) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_basicmeas`;
CREATE TABLE IF NOT EXISTS `zt_basicmeas` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `purpose` varchar(50) NOT NULL,
  `scope` char(30) NOT NULL,
  `object` char(30) NOT NULL,
  `name` varchar(90) NOT NULL,
  `code` char(30) NOT NULL,
  `unit` varchar(10) NOT NULL,
  `configure` text,
  `params` text,
  `definition` text,
  `source` varchar(255) DEFAULT NULL,
  `collectType` varchar(30) NOT NULL,
  `collectConf` text NOT NULL,
  `execTime` varchar(30) NOT NULL,
  `collectedBy` varchar(10) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `order` mediumint(8) UNSIGNED NOT NULL DEFAULT 0,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_budget`;
CREATE TABLE IF NOT EXISTS `zt_budget` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `stage` char(30) NOT NULL,
  `subject` mediumint(8) NOT NULL,
  `amount` char(30) NOT NULL,
  `name` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `lastEditedBy` char(30) NOT NULL,
  `lastEditedDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_researchplan`;
CREATE TABLE IF NOT EXISTS `zt_researchplan` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `customer` varchar(255) NOT NULL,
  `stakeholder` varchar(255) NOT NULL,
  `objective` varchar(255) NOT NULL,
  `begin` datetime NOT NULL,
  `end` datetime NOT NULL,
  `location` varchar(255) NOT NULL,
  `team` varchar(255) NOT NULL,
  `method` enum('','videoConference','interview','questionnaire','telephoneInterview') NOT NULL,
  `outline` text NOT NULL,
  `schedule` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_researchreport`;
CREATE TABLE IF NOT EXISTS `zt_researchreport` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `relatedPlan` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `author` varchar(30) NOT NULL,
  `content` text NOT NULL,
  `customer` varchar(255) NOT NULL,
  `researchObjects` varchar(255) NOT NULL,
  `begin` datetime NOT NULL,
  `end` datetime NOT NULL,
  `location` varchar(255) NOT NULL,
  `method` enum('','videoConference','interview','questionnaire','telephoneInterview') NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_meeting`;
CREATE TABLE IF NOT EXISTS `zt_meeting` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) NOT NULL,
  `execution` mediumint(8) NOT NULL,
  `name` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `begin` time NOT NULL,
  `end` time NOT NULL,
  `dept` mediumint(8) NOT NULL,
  `mode` varchar(255) NOT NULL,
  `host` varchar(30) NOT NULL,
  `participant` text NOT NULL,
  `date` date NOT NULL,
  `room` int NOT NULL,
  `minutes` text NOT NULL,
  `minutedBy` varchar(30) NOT NULL,
  `minutedDate` datetime NOT NULL,
  `objectType` varchar(30) NOT NULL,
  `objectID` mediumint(8) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_meetingroom`;
CREATE TABLE IF NOT EXISTS `zt_meetingroom` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `position` varchar(30) NOT NULL,
  `seats` int NOT NULL,
  `equipment` varchar(255) NOT NULL,
  `openTime` varchar(255) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_assetlib`;
CREATE TABLE IF NOT EXISTS `zt_assetlib` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_meastemplate`;
CREATE TABLE IF NOT EXISTS `zt_meastemplate` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `model` char(30) NOT NULL,
  `name` varchar(255) NOT NULL,
  `content` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_programreport`;
CREATE TABLE IF NOT EXISTS `zt_programreport` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `template` mediumint(8) NOT NULL,
  `project` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `params` text NOT NULL,
  `content` text NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_measrecords`;
CREATE TABLE IF NOT EXISTS `zt_measrecords` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL,
  `mid` mediumint(8) NOT NULL,
  `measCode` char(50) NOT NULL DEFAULT '',
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `params` text NOT NULL,
  `year` char(4) NOT NULL,
  `month` char(6) NOT NULL,
  `week` char(8) NOT NULL,
  `day` char(8) NOT NULL,
  `value` varchar(255) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `project` (`project`),
  KEY `time` (`year`, `month`, `day`, `week`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_object`;
CREATE TABLE IF NOT EXISTS `zt_object` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) NOT NULL,
  `from` mediumint(8) NOT NULL,
  `title` varchar(255) NOT NULL,
  `category` char(30) NOT NULL,
  `version` varchar(255) NOT NULL,
  `type` enum('reviewed','taged') NOT NULL,
  `range` text NOT NULL,
  `data` text NOT NULL,
  `storyEst` char(30) NOT NULL,
  `taskEst` char(30) NOT NULL,
  `requestEst` char(30) NOT NULL,
  `testEst` char(30) NOT NULL,
  `devEst` char(30) NOT NULL,
  `designEst` char(30) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_review`;
CREATE TABLE IF NOT EXISTS `zt_review` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `object` mediumint(8) NOT NULL,
  `template` mediumint(8) NOT NULL,
  `status` char(30) NOT NULL,
  `reviewedBy` varchar(255) NOT NULL,
  `auditedBy` varchar(255) NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deadline` date NOT NULL,
  `lastReviewedBy` varchar(255) DEFAULT NULL,
  `lastReviewedDate` date NOT NULL,
  `lastAuditedBy` varchar(255) NOT NULL,
  `lastAuditedDate` date NOT NULL,
  `lastEditedBy` varchar(255) NOT NULL,
  `lastEditedDate` date NOT NULL,
  `result` char(30) NOT NULL,
  `auditResult` char(30) NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=39 DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_reviewcl`;
CREATE TABLE IF NOT EXISTS `zt_reviewcl` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `object` char(30) NOT NULL,
  `category` char(30) NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `order` mediumint(8) DEFAULT '0',
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_reviewresult`;
CREATE TABLE IF NOT EXISTS `zt_reviewresult` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `review` mediumint(8) NOT NULL,
  `type` char(30) NOT NULL DEFAULT 'review',
  `result` char(30) NOT NULL,
  `opinion` text NOT NULL,
  `reviewer` char(30) NOT NULL,
  `remainIssue` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `consumed` float NOT NULL,
  UNIQUE KEY `reviewer` (`review`,`reviewer`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_reviewissue`;
CREATE TABLE IF NOT EXISTS `zt_reviewissue` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `review` mediumint(8) NOT NULL,
  `injection` mediumint(8) NOT NULL,
  `identify` mediumint(8) NOT NULL,
  `type` char(30) NOT NULL DEFAULT 'review',
  `listID` mediumint(8) NOT NULL,
  `title` varchar(255) NOT NULL,
  `opinion` varchar(255) NOT NULL,
  `opinionDate` DATE NOT NULL,
  `status` char(30) NOT NULL,
  `resolution` char(30) NOT NULL,
  `resolutionBy` CHAR(30) NOT NULL,
  `resolutionDate` DATE NOT NULL,
  `createdBy` char(30) NOT NULL,
  `createdDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_reviewlist`;
CREATE TABLE IF NOT EXISTS `zt_reviewlist` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `title` varchar(255) NOT NULL,
  `object` char(30) NOT NULL,
  `category` char(30) NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_cmcl`;
CREATE TABLE IF NOT EXISTS `zt_cmcl` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` char(30) NOT NULL,
  `title` int(11) NOT NULL,
  `contents` text NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `status` varchar(30) NOT NULL,
  `order` int(11) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_solutions`;
CREATE TABLE IF NOT EXISTS `zt_solutions` (
 `id` mediumint(8) NOT NULL AUTO_INCREMENT,
 `project` mediumint(8) unsigned NOT NULL,
 `execution` mediumint(8) unsigned NOT NULL,
 `contents` text NOT NULL COMMENT '问题描述',
 `support` text NOT NULL COMMENT '是否需要高层支持',
 `measures` text NOT NULL COMMENT '解决建议',
 `type` char(30) NOT NULL,
 `addedBy` varchar(30) NOT NULL,
 `addedDate` date NOT NULL,
 `editedBy` varchar(30) NOT NULL,
 `editedDate` date NOT NULL,
 `deleted` enum('0','1') NOT NULL DEFAULT '0',
 PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_measqueue`;
CREATE TABLE IF NOT EXISTS `zt_measqueue` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL,
  `mid` mediumint(8) unsigned NOT NULL,
  `status` varchar(255) NOT NULL,
  `logs` text,
  `execTime` varchar(10) NOT NULL,
  `params` text,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `updateDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_issue`;
CREATE TABLE IF NOT EXISTS `zt_issue` (
  `id` mediumint(8) UNSIGNED NOT NULL AUTO_INCREMENT,
  `resolvedBy` varchar(30) NOT NULL,
  `project` varchar(255) NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `desc` text NOT NULL,
  `pri` char(30) NOT NULL,
  `severity` char(30) NOT NULL,
  `type` char(30) NOT NULL,
  `activity` varchar(255) NOT NULL,
  `deadline` date NOT NULL,
  `resolution` char(30) NOT NULL,
  `resolutionComment` text NOT NULL,
  `objectID` varchar(255) NOT NULL,
  `resolvedDate` date NOT NULL,
  `status` varchar(30) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `lib` mediumint(8) unsigned NOT NULL default 0,
  `from` mediumint(8) unsigned NOT NULL default 0,
  `version` smallint(6) NOT NULL default 1,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `activateBy` varchar(30) NOT NULL,
  `activateDate` date NOT NULL,
  `closedBy` varchar(30) NOT NULL,
  `closedDate` date NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `assignedBy` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `approvedDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_risk`;
CREATE TABLE IF NOT EXISTS `zt_risk` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` varchar(255) NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `source` char(30) NOT NULL,
  `category` char(30) NOT NULL,
  `strategy` char(30) NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  `impact` char(30) NOT NULL,
  `probability` char(30) NOT NULL,
  `rate` char(30) NOT NULL,
  `pri` char(30) NOT NULL,
  `identifiedDate` date NOT NULL,
  `prevention` text NOT NULL,
  `remedy` text NOT NULL,
  `plannedClosedDate` date NOT NULL,
  `actualClosedDate` date NOT NULL,
  `lib` mediumint(8) unsigned NOT NULL default 0,
  `from` mediumint(8) unsigned NOT NULL default 0,
  `version` smallint(6) NOT NULL default 1,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `resolution` text NOT NULL,
  `resolvedBy` varchar(30) NOT NULL,
  `activateBy` varchar(30) NOT NULL,
  `activateDate` date NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `closedBy` varchar(30) NOT NULL,
  `closedDate` date NOT NULL,
  `cancelBy` varchar(30) NOT NULL,
  `cancelDate` date NOT NULL,
  `cancelReason` char(30) NOT NULL,
  `hangupBy` varchar(30) NOT NULL,
  `hangupDate` date NOT NULL,
  `trackedBy` varchar(30) NOT NULL,
  `trackedDate` date NOT NULL,
  `assignedDate` date NOT NULL,
  `approvedDate` date NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_opportunity`;
CREATE TABLE IF NOT EXISTS `zt_opportunity` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `execution` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `source` char(30) NOT NULL,
  `type` char(30) NOT NULL,
  `strategy` char(30) NOT NULL,
  `status` varchar(30) NOT NULL DEFAULT 'active',
  `impact` mediumint(8) NOT NULL,
  `chance` mediumint(8) NOT NULL,
  `ratio` mediumint(8) NOT NULL,
  `pri` char(30) NOT NULL,
  `identifiedDate` date NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `assignedDate` date NOT NULL,
  `approvedDate` date NOT NULL,
  `prevention` text NOT NULL,
  `plannedClosedDate` date NOT NULL,
  `actualClosedDate` date NOT NULL,
  `lib` mediumint(8) unsigned NOT NULL default 0,
  `from` mediumint(8) unsigned NOT NULL default 0,
  `version` smallint(6) NOT NULL default 1,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `activatedBy` varchar(30) NOT NULL,
  `activatedDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL,
  `closedDate` datetime NOT NULL,
  `canceledBy` varchar(30) NOT NULL,
  `canceledDate` datetime NOT NULL,
  `cancelReason` char(30) NOT NULL,
  `hangupedBy` varchar(30) NOT NULL,
  `hangupedDate` datetime NOT NULL,
  `resolution` text NOT NULL,
  `resolvedBy` varchar(30) NOT NULL,
  `resolvedDate` datetime NOT NULL,
  `lastCheckedBy` varchar(30) NOT NULL,
  `lastCheckedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_trainplan`;
CREATE TABLE IF NOT EXISTS `zt_trainplan` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `place` varchar(255) NOT NULL,
  `trainee` text NOT NULL,
  `lecturer` varchar(20) NOT NULL,
  `type` enum('inside','outside') NOT NULL DEFAULT 'inside',
  `status` varchar(20) NOT NULL,
  `summary` text NOT NULL,
  `createdBy` char(30),
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_gapanalysis`;
CREATE TABLE IF NOT EXISTS `zt_gapanalysis` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL,
  `account` varchar(30) NOT NULL,
  `role` varchar(20) NOT NULL,
  `analysis` text NOT NULL,
  `needTrain` enum('no','yes') NOT NULL DEFAULT 'no',
  `createdBy` char(30),
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_account` (`project`,`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `zt_bug`
ADD `injection` mediumint(8) unsigned NOT NULL AFTER `product`,
ADD `identify` mediumint(8) unsigned NOT NULL AFTER `injection`;

ALTER TABLE `zt_team` ADD `position` varchar(30) not null AFTER role;

REPLACE INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1,'activity','assignTo'),
(1,'activity','batchCreate'),
(1,'activity','browse'),
(1,'activity','create'),
(1,'activity','delete'),
(1,'activity','edit'),
(1,'activity','outputList'),
(1,'activity','updateOrder'),
(1,'activity','view'),
(1,'apppriv','flow'),
(1,'assetlib','approveComponent'),
(1,'assetlib','approveIssue'),
(1,'assetlib','approveOpportunity'),
(1,'assetlib','approvePractice'),
(1,'assetlib','approveRisk'),
(1,'assetlib','approveStory'),
(1,'assetlib','assignToComponent'),
(1,'assetlib','assignToIssue'),
(1,'assetlib','assignToOpportunity'),
(1,'assetlib','assignToPractice'),
(1,'assetlib','assignToRisk'),
(1,'assetlib','assignToStory'),
(1,'assetlib','batchApproveComponent'),
(1,'assetlib','batchApproveIssue'),
(1,'assetlib','batchApproveOpportunity'),
(1,'assetlib','batchApprovePractice'),
(1,'assetlib','batchApproveRisk'),
(1,'assetlib','batchApproveStory'),
(1,'assetlib','batchAssignToComponent'),
(1,'assetlib','batchAssignToIssue'),
(1,'assetlib','batchAssignToOpportunity'),
(1,'assetlib','batchAssignToPractice'),
(1,'assetlib','batchAssignToRisk'),
(1,'assetlib','batchAssignToStory'),
(1,'assetlib','batchRemoveComponent'),
(1,'assetlib','batchRemoveIssue'),
(1,'assetlib','batchRemoveOpportunity'),
(1,'assetlib','batchRemovePractice'),
(1,'assetlib','batchRemoveRisk'),
(1,'assetlib','batchRemoveStory'),
(1,'assetlib','caselib'),
(1,'assetlib','component'),
(1,'assetlib','componentlib'),
(1,'assetlib','componentLibView'),
(1,'assetlib','componentView'),
(1,'assetlib','createComponentlib'),
(1,'assetlib','createIssuelib'),
(1,'assetlib','createOpportunitylib'),
(1,'assetlib','createPracticelib'),
(1,'assetlib','createRisklib'),
(1,'assetlib','createStorylib'),
(1,'assetlib','deleteComponentlib'),
(1,'assetlib','deleteIssuelib'),
(1,'assetlib','deleteOpportunitylib'),
(1,'assetlib','deletePracticelib'),
(1,'assetlib','deleteRisklib'),
(1,'assetlib','deleteStorylib'),
(1,'assetlib','editComponent'),
(1,'assetlib','editComponentlib'),
(1,'assetlib','editIssue'),
(1,'assetlib','editIssuelib'),
(1,'assetlib','editOpportunity'),
(1,'assetlib','editOpportunitylib'),
(1,'assetlib','editPractice'),
(1,'assetlib','editPracticelib'),
(1,'assetlib','editRisk'),
(1,'assetlib','editRisklib'),
(1,'assetlib','editStory'),
(1,'assetlib','editStorylib'),
(1,'assetlib','importComponent'),
(1,'assetlib','importIssue'),
(1,'assetlib','importOpportunity'),
(1,'assetlib','importPractice'),
(1,'assetlib','importRisk'),
(1,'assetlib','importStory'),
(1,'assetlib','issue'),
(1,'assetlib','issuelib'),
(1,'assetlib','issueLibView'),
(1,'assetlib','issueView'),
(1,'assetlib','opportunity'),
(1,'assetlib','opportunitylib'),
(1,'assetlib','opportunityLibView'),
(1,'assetlib','opportunityView'),
(1,'assetlib','practice'),
(1,'assetlib','practicelib'),
(1,'assetlib','practiceLibView'),
(1,'assetlib','practiceView'),
(1,'assetlib','removeComponent'),
(1,'assetlib','removeIssue'),
(1,'assetlib','removeOpportunity'),
(1,'assetlib','removePractice'),
(1,'assetlib','removeRisk'),
(1,'assetlib','removeStory'),
(1,'assetlib','risk'),
(1,'assetlib','risklib'),
(1,'assetlib','riskLibView'),
(1,'assetlib','riskView'),
(1,'assetlib','story'),
(1,'assetlib','storylib'),
(1,'assetlib','storyLibView'),
(1,'assetlib','storyView'),
(1,'assetlib','view'),
(1,'audit','8'),
(1,'audit','assign'),
(1,'audit','batchassign'),
(1,'audit','batchcreate'),
(1,'audit','batchedit'),
(1,'audit','browse'),
(1,'audit','create'),
(1,'audit','delete'),
(1,'audit','edit'),
(1,'audit','export'),
(1,'audit','exporttemplate'),
(1,'audit','import'),
(1,'audit','link'),
(1,'audit','search'),
(1,'audit','showimport'),
(1,'audit','unlink'),
(1,'audit','view'),
(1,'auditcl','batchCreate'),
(1,'auditcl','batchEdit'),
(1,'auditcl','browse'),
(1,'auditcl','delete'),
(1,'auditcl','edit'),
(1,'auditplan','batchCheck'),
(1,'auditplan','batchCreate'),
(1,'auditplan','browse'),
(1,'auditplan','check'),
(1,'auditplan','create'),
(1,'auditplan','edit'),
(1,'auditplan','nc'),
(1,'auditplan','result'),
(1,'auditresult','10'),
(1,'auditresult','assign'),
(1,'auditresult','batchassign'),
(1,'auditresult','batchcreate'),
(1,'auditresult','batchedit'),
(1,'auditresult','browse'),
(1,'auditresult','create'),
(1,'auditresult','delete'),
(1,'auditresult','edit'),
(1,'auditresult','export'),
(1,'auditresult','exporttemplate'),
(1,'auditresult','import'),
(1,'auditresult','link'),
(1,'auditresult','search'),
(1,'auditresult','showimport'),
(1,'auditresult','unlink'),
(1,'auditresult','view'),
(1,'baseline','catalog'),
(1,'baseline','createTemplate'),
(1,'baseline','delete'),
(1,'baseline','editBook'),
(1,'baseline','editTemplate'),
(1,'baseline','manageBook'),
(1,'baseline','template'),
(1,'baseline','view'),
(1,'bookborrow','59'),
(1,'bookborrow','62'),
(1,'bookborrow','assign'),
(1,'bookborrow','batchassign'),
(1,'bookborrow','batchcreate'),
(1,'bookborrow','batchedit'),
(1,'bookborrow','browse'),
(1,'bookborrow','create'),
(1,'bookborrow','delete'),
(1,'bookborrow','edit'),
(1,'bookborrow','export'),
(1,'bookborrow','exporttemplate'),
(1,'bookborrow','import'),
(1,'bookborrow','link'),
(1,'bookborrow','return'),
(1,'bookborrow','search'),
(1,'bookborrow','showimport'),
(1,'bookborrow','unlink'),
(1,'bookborrow','view'),
(1,'budget','batchCreate'),
(1,'budget','browse'),
(1,'budget','create'),
(1,'budget','delete'),
(1,'budget','edit'),
(1,'budget','summary'),
(1,'budget','view'),
(1,'caselib','justtest'),
(1,'classify','browse'),
(1,'cm','browse'),
(1,'cm','create'),
(1,'cm','delete'),
(1,'cm','edit'),
(1,'cm','report'),
(1,'cm','view'),
(1,'cmcl','batchCreate'),
(1,'cmcl','browse'),
(1,'cmcl','delete'),
(1,'cmcl','edit'),
(1,'cmcl','view'),
(1,'custom','estimate'),
(1,'design','assignTo'),
(1,'design','batchCreate'),
(1,'design','browse'),
(1,'design','create'),
(1,'design','delete'),
(1,'design','edit'),
(1,'design','linkCommit'),
(1,'design','revision'),
(1,'design','unlinkCommit'),
(1,'design','view'),
(1,'design','viewCommit'),
(1,'doc','importToComponentLib'),
(1,'doc','importToPracticeLib'),
(1,'durationestimation','create'),
(1,'durationestimation','index'),
(1,'gapanalysis','batchCreate'),
(1,'gapanalysis','batchEdit'),
(1,'gapanalysis','browse'),
(1,'gapanalysis','create'),
(1,'gapanalysis','delete'),
(1,'gapanalysis','edit'),
(1,'gapanalysis','view'),
(1,'investigation','126'),
(1,'investigation','assign'),
(1,'investigation','batchassign'),
(1,'investigation','batchcreate'),
(1,'investigation','batchedit'),
(1,'investigation','browse'),
(1,'investigation','create'),
(1,'investigation','delete'),
(1,'investigation','edit'),
(1,'investigation','export'),
(1,'investigation','exporttemplate'),
(1,'investigation','import'),
(1,'investigation','investigationreport_create'),
(1,'investigation','link'),
(1,'investigation','report'),
(1,'investigation','search'),
(1,'investigation','showimport'),
(1,'investigation','unlink'),
(1,'investigation','view'),
(1,'investigationreport','129'),
(1,'investigationreport','assign'),
(1,'investigationreport','batchassign'),
(1,'investigationreport','batchcreate'),
(1,'investigationreport','batchedit'),
(1,'investigationreport','browse'),
(1,'investigationreport','create'),
(1,'investigationreport','delete'),
(1,'investigationreport','edit'),
(1,'investigationreport','export'),
(1,'investigationreport','exporttemplate'),
(1,'investigationreport','import'),
(1,'investigationreport','link'),
(1,'investigationreport','report'),
(1,'investigationreport','search'),
(1,'investigationreport','showimport'),
(1,'investigationreport','unlink'),
(1,'investigationreport','view'),
(1,'issue','activate'),
(1,'issue','assignTo'),
(1,'issue','batchCreate'),
(1,'issue','batchImportToLib'),
(1,'issue','browse'),
(1,'issue','cancel'),
(1,'issue','close'),
(1,'issue','confirm'),
(1,'issue','create'),
(1,'issue','delete'),
(1,'issue','edit'),
(1,'issue','importFromLib'),
(1,'issue','importToLib'),
(1,'issue','resolve'),
(1,'issue','view'),
(1,'library','58'),
(1,'library','60'),
(1,'library','61'),
(1,'library','assign'),
(1,'library','batchassign'),
(1,'library','batchcreate'),
(1,'library','batchedit'),
(1,'library','browse'),
(1,'library','create'),
(1,'library','delete'),
(1,'library','edit'),
(1,'library','export'),
(1,'library','exporttemplate'),
(1,'library','import'),
(1,'library','link'),
(1,'library','review'),
(1,'library','search'),
(1,'library','setarea'),
(1,'library','setcategory'),
(1,'library','showimport'),
(1,'library','unlink'),
(1,'library','view'),
(1,'measrecord','browse'),
(1,'measurement','batchEdit'),
(1,'measurement','browse'),
(1,'measurement','createBasic'),
(1,'measurement','createTemplate'),
(1,'measurement','delete'),
(1,'measurement','design'),
(1,'measurement','designPHP'),
(1,'measurement','designSQL'),
(1,'measurement','editBasic'),
(1,'measurement','editDerivation'),
(1,'measurement','editTemplate'),
(1,'measurement','searchMeas'),
(1,'measurement','setSQL'),
(1,'measurement','settips'),
(1,'measurement','template'),
(1,'measurement','viewTemplate'),
(1,'meeting','browse'),
(1,'meeting','create'),
(1,'meeting','delete'),
(1,'meeting','edit'),
(1,'meeting','minutes'),
(1,'meeting','view'),
(1,'meetingroom','batchCreate'),
(1,'meetingroom','batchEdit'),
(1,'meetingroom','browse'),
(1,'meetingroom','create'),
(1,'meetingroom','delete'),
(1,'meetingroom','edit'),
(1,'meetingroom','view'),
(1,'metting','127'),
(1,'metting','130'),
(1,'metting','131'),
(1,'metting','assign'),
(1,'metting','batchassign'),
(1,'metting','batchcreate'),
(1,'metting','batchedit'),
(1,'metting','browse'),
(1,'metting','create'),
(1,'metting','delete'),
(1,'metting','edit'),
(1,'metting','export'),
(1,'metting','exporttemplate'),
(1,'metting','import'),
(1,'metting','link'),
(1,'metting','report'),
(1,'metting','search'),
(1,'metting','showimport'),
(1,'metting','summary'),
(1,'metting','unlink'),
(1,'metting','view'),
(1,'milestone','index'),
(1,'milestone','saveOtherProblem'),
(1,'my','issue'),
(1,'my','meeting'),
(1,'my','myMeeting'),
(1,'my','nc'),
(1,'my','risk'),
(1,'nc','16'),
(1,'nc','activate'),
(1,'nc','assign'),
(1,'nc','batchassign'),
(1,'nc','batchcreate'),
(1,'nc','batchedit'),
(1,'nc','browse'),
(1,'nc','close'),
(1,'nc','create'),
(1,'nc','delete'),
(1,'nc','edit'),
(1,'nc','export'),
(1,'nc','exporttemplate'),
(1,'nc','import'),
(1,'nc','link'),
(1,'nc','resolve'),
(1,'nc','search'),
(1,'nc','showimport'),
(1,'nc','unlink'),
(1,'nc','view'),
(1,'opportunity','activate'),
(1,'opportunity','assignTo'),
(1,'opportunity','batchActivate'),
(1,'opportunity','batchAssignTo'),
(1,'opportunity','batchCancel'),
(1,'opportunity','batchClose'),
(1,'opportunity','batchCreate'),
(1,'opportunity','batchEdit'),
(1,'opportunity','batchHangup'),
(1,'opportunity','batchImportToLib'),
(1,'opportunity','browse'),
(1,'opportunity','cancel'),
(1,'opportunity','close'),
(1,'opportunity','create'),
(1,'opportunity','delete'),
(1,'opportunity','edit'),
(1,'opportunity','hangup'),
(1,'opportunity','importFromLib'),
(1,'opportunity','importToLib'),
(1,'opportunity','track'),
(1,'opportunity','view'),
(1,'output','13'),
(1,'output','assign'),
(1,'output','batchassign'),
(1,'output','batchcreate'),
(1,'output','batchedit'),
(1,'output','browse'),
(1,'output','create'),
(1,'output','delete'),
(1,'output','edit'),
(1,'output','export'),
(1,'output','exporttemplate'),
(1,'output','import'),
(1,'output','link'),
(1,'output','search'),
(1,'output','showimport'),
(1,'output','unlink'),
(1,'output','view'),
(1,'process','activityList'),
(1,'process','batchCreate'),
(1,'process','browse'),
(1,'process','create'),
(1,'process','delete'),
(1,'process','edit'),
(1,'process','updateOrder'),
(1,'process','view'),
(1,'programplan','browse'),
(1,'programplan','create'),
(1,'programplan','edit'),
(1,'projectstory','importFromLib'),
(1,'pssp','browse'),
(1,'pssp','update'),
(1,'report','customeRedreport'),
(1,'report','instanceTemplate'),
(1,'researchplan','browse'),
(1,'researchplan','create'),
(1,'researchplan','delete'),
(1,'researchplan','edit'),
(1,'researchplan','view'),
(1,'researchreport','browse'),
(1,'researchreport','create'),
(1,'researchreport','delete'),
(1,'researchreport','edit'),
(1,'researchreport','view'),
(1,'review','assess'),
(1,'review','audit'),
(1,'review','browse'),
(1,'review','create'),
(1,'review','edit'),
(1,'review','recall'),
(1,'review','report'),
(1,'review','result'),
(1,'review','submit'),
(1,'review','toAudit'),
(1,'review','view'),
(1,'reviewcl','batchCreate'),
(1,'reviewcl','browse'),
(1,'reviewcl','create'),
(1,'reviewcl','delete'),
(1,'reviewcl','edit'),
(1,'reviewcl','view'),
(1,'reviewissue','create'),
(1,'reviewissue','edit'),
(1,'reviewissue','issue'),
(1,'reviewissue','resolved'),
(1,'reviewissue','updateStatus'),
(1,'reviewissue','view'),
(1,'reviewsetting','version'),
(1,'risk','activate'),
(1,'risk','assignTo'),
(1,'risk','batchCreate'),
(1,'risk','batchImportToLib'),
(1,'risk','browse'),
(1,'risk','cancel'),
(1,'risk','close'),
(1,'risk','create'),
(1,'risk','delete'),
(1,'risk','edit'),
(1,'risk','hangup'),
(1,'risk','importFromLib'),
(1,'risk','importToLib'),
(1,'risk','track'),
(1,'risk','view'),
(1,'sqlbuilder','browseSQLView'),
(1,'sqlbuilder','create'),
(1,'sqlbuilder','createSQLView'),
(1,'sqlbuilder','deleteSQLView'),
(1,'sqlbuilder','editSQLView'),
(1,'stage','batchCreate'),
(1,'stage','browse'),
(1,'stage','create'),
(1,'stage','delete'),
(1,'stage','edit'),
(1,'stage','setType'),
(1,'story','batchImportToLib'),
(1,'story','importToLib'),
(1,'subject','browse'),
(1,'task','confirmdesignchange'),
(1,'testcase','submit'),
(1,'testsuite','test'),
(1,'train','browse'),
(1,'train','create'),
(1,'train','delete'),
(1,'train','edit'),
(1,'train','finish'),
(1,'train','summary'),
(1,'train','view'),
(1,'trainbook','ajaxgetbookbysn'),
(1,'trainbook','export'),
(1,'traincareer','index'),
(1,'trainchapter','browse'),
(1,'trainchapter','catalog'),
(1,'trainchapter','delete'),
(1,'trainchapter','download'),
(1,'trainchapter','edit'),
(1,'trainchapter','manage'),
(1,'trainchapter','showDocFiles'),
(1,'trainchapter','sortChapterOrder'),
(1,'trainchapter','view'),
(1,'traincourse','browse'),
(1,'traincourse','changeStatus'),
(1,'traincourse','collect'),
(1,'traincourse','create'),
(1,'traincourse','delete'),
(1,'traincourse','edit'),
(1,'traincourse','manage'),
(1,'traincourse','view'),
(1,'trainexam','browse'),
(1,'trainexam','changeStatus'),
(1,'trainexam','choseExam'),
(1,'trainexam','create'),
(1,'trainexam','delete'),
(1,'trainexam','deleteQuestion'),
(1,'trainexam','edit'),
(1,'trainexam','editQuestion'),
(1,'trainexam','exam'),
(1,'trainexam','myExams'),
(1,'trainexam','review'),
(1,'trainexam','scoreDetail'),
(1,'trainexam','setQuestion'),
(1,'trainexam','updateOrder'),
(1,'trainexam','view'),
(1,'traingoal','browse'),
(1,'traingoal','browseCompanyGoals'),
(1,'traingoal','browseDeptGoals'),
(1,'traingoal','create'),
(1,'traingoal','delete'),
(1,'traingoal','edit'),
(1,'traingoal','recall'),
(1,'traingoal','review'),
(1,'traingoal','submitReview'),
(1,'traingoal','updateOrder'),
(1,'traingoal','view'),
(1,'trainplan','batchCreate'),
(1,'trainplan','batchEdit'),
(1,'trainplan','batchFinish'),
(1,'trainplan','browse'),
(1,'trainplan','create'),
(1,'trainplan','delete'),
(1,'trainplan','edit'),
(1,'trainplan','finish'),
(1,'trainplan','summary'),
(1,'trainplan','view'),
(1,'trainpost','browse'),
(1,'trainpost','create'),
(1,'trainpost','createGrade'),
(1,'trainpost','delete'),
(1,'trainpost','edit'),
(1,'trainpost','editGrade'),
(1,'trainpost','gradeView'),
(1,'trainpost','manageGrade'),
(1,'trainpost','sortGrade'),
(1,'trainpost','sortPost'),
(1,'trainpost','view'),
(1,'trainskill','browse'),
(1,'trainskill','create'),
(1,'trainskill','createGrade'),
(1,'trainskill','delete'),
(1,'trainskill','deleteDesc'),
(1,'trainskill','deleteGrade'),
(1,'trainskill','edit'),
(1,'trainskill','editGrade'),
(1,'trainskill','view'),
(1,'traintask','browse'),
(1,'traintask','browseCompanyTasks'),
(1,'traintask','browseDeptTasks'),
(1,'traintask','close'),
(1,'traintask','create'),
(1,'traintask','createTask'),
(1,'traintask','delete'),
(1,'traintask','edit'),
(1,'traintask','finish'),
(1,'traintask','import'),
(1,'traintask','setCondition'),
(1,'traintask','start'),
(1,'traintask','view'),
(1,'weekly','index'),
(1,'workestimation','index'),
(1,'workloadbudget','27'),
(1,'workloadbudget','assign'),
(1,'workloadbudget','batchassign'),
(1,'workloadbudget','batchcreate'),
(1,'workloadbudget','batchedit'),
(1,'workloadbudget','browse'),
(1,'workloadbudget','create'),
(1,'workloadbudget','delete'),
(1,'workloadbudget','edit'),
(1,'workloadbudget','export'),
(1,'workloadbudget','exporttemplate'),
(1,'workloadbudget','import'),
(1,'workloadbudget','link'),
(1,'workloadbudget','search'),
(1,'workloadbudget','showimport'),
(1,'workloadbudget','unlink'),
(1,'workloadbudget','view'),
(1,'zoutput','batchCreate'),
(1,'zoutput','batchEdit'),
(1,'zoutput','browse'),
(1,'zoutput','create'),
(1,'zoutput','delete'),
(1,'zoutput','edit'),
(1,'zoutput','updateOrder'),
(1,'zoutput','view'),
(2,'activity','browse'),
(2,'activity','create'),
(2,'activity','delete'),
(2,'activity','edit'),
(2,'activity','view'),
(2,'audit','8'),
(2,'audit','assign'),
(2,'audit','batchassign'),
(2,'audit','batchcreate'),
(2,'audit','batchedit'),
(2,'audit','browse'),
(2,'audit','create'),
(2,'audit','delete'),
(2,'audit','edit'),
(2,'audit','export'),
(2,'audit','exporttemplate'),
(2,'audit','import'),
(2,'audit','link'),
(2,'audit','search'),
(2,'audit','showimport'),
(2,'audit','unlink'),
(2,'audit','view'),
(2,'auditcl','browse'),
(2,'auditplan','browse'),
(2,'auditplan','create'),
(2,'auditplan','edit'),
(2,'auditplan','nc'),
(2,'auditplan','result'),
(2,'auditresult','10'),
(2,'auditresult','assign'),
(2,'auditresult','batchassign'),
(2,'auditresult','batchcreate'),
(2,'auditresult','batchedit'),
(2,'auditresult','browse'),
(2,'auditresult','create'),
(2,'auditresult','delete'),
(2,'auditresult','edit'),
(2,'auditresult','export'),
(2,'auditresult','exporttemplate'),
(2,'auditresult','import'),
(2,'auditresult','link'),
(2,'auditresult','search'),
(2,'auditresult','showimport'),
(2,'auditresult','unlink'),
(2,'auditresult','view'),
(2,'baseline','catalog'),
(2,'baseline','createTemplate'),
(2,'baseline','editBook'),
(2,'baseline','editTemplate'),
(2,'baseline','manageBook'),
(2,'baseline','template'),
(2,'baseline','view'),
(2,'budget','browse'),
(2,'classify','browse'),
(2,'cm','browse'),
(2,'cm','create'),
(2,'cm','edit'),
(2,'cm','report'),
(2,'cm','view'),
(2,'cmcl','browse'),
(2,'custom','estimate'),
(2,'design','browse'),
(2,'design','create'),
(2,'design','delete'),
(2,'design','edit'),
(2,'design','view'),
(2,'durationestimation','create'),
(2,'durationestimation','index'),
(2,'gapanalysis','batchCreate'),
(2,'gapanalysis','browse'),
(2,'gapanalysis','create'),
(2,'gapanalysis','edit'),
(2,'investigation','126'),
(2,'investigation','analysis'),
(2,'investigation','assign'),
(2,'investigation','batchassign'),
(2,'investigation','batchcreate'),
(2,'investigation','batchedit'),
(2,'investigation','browse'),
(2,'investigation','create'),
(2,'investigation','delete'),
(2,'investigation','edit'),
(2,'investigation','export'),
(2,'investigation','exporttemplate'),
(2,'investigation','import'),
(2,'investigation','link'),
(2,'investigation','report'),
(2,'investigation','search'),
(2,'investigation','showimport'),
(2,'investigation','unlink'),
(2,'investigation','view'),
(2,'issue','activate'),
(2,'issue','batchCreate'),
(2,'issue','browse'),
(2,'issue','cancel'),
(2,'issue','close'),
(2,'issue','create'),
(2,'issue','delete'),
(2,'issue','edit'),
(2,'issue','resolve'),
(2,'issue','view'),
(2,'leave','back'),
(2,'meeting','browse'),
(2,'meeting','create'),
(2,'meeting','delete'),
(2,'meeting','edit'),
(2,'meeting','minutes'),
(2,'meeting','view'),
(2,'milestone','index'),
(2,'milestone','saveOtherProblem'),
(2,'my','issue'),
(2,'my','meeting'),
(2,'my','myMeeting'),
(2,'my','nc'),
(2,'my','risk'),
(2,'nc','16'),
(2,'nc','activate'),
(2,'nc','assign'),
(2,'nc','batchassign'),
(2,'nc','batchcreate'),
(2,'nc','batchedit'),
(2,'nc','browse'),
(2,'nc','close'),
(2,'nc','create'),
(2,'nc','delete'),
(2,'nc','edit'),
(2,'nc','export'),
(2,'nc','exporttemplate'),
(2,'nc','import'),
(2,'nc','link'),
(2,'nc','resolve'),
(2,'nc','search'),
(2,'nc','showimport'),
(2,'nc','unlink'),
(2,'nc','view'),
(2,'opportunity','activate'),
(2,'opportunity','assignTo'),
(2,'opportunity','batchActivate'),
(2,'opportunity','batchAssignTo'),
(2,'opportunity','batchCancel'),
(2,'opportunity','batchClose'),
(2,'opportunity','batchCreate'),
(2,'opportunity','batchEdit'),
(2,'opportunity','batchHangup'),
(2,'opportunity','browse'),
(2,'opportunity','cancel'),
(2,'opportunity','close'),
(2,'opportunity','create'),
(2,'opportunity','delete'),
(2,'opportunity','edit'),
(2,'opportunity','hangup'),
(2,'opportunity','importFromLib'),
(2,'opportunity','track'),
(2,'opportunity','view'),
(2,'output','13'),
(2,'output','assign'),
(2,'output','batchassign'),
(2,'output','batchcreate'),
(2,'output','batchedit'),
(2,'output','browse'),
(2,'output','create'),
(2,'output','delete'),
(2,'output','edit'),
(2,'output','export'),
(2,'output','exporttemplate'),
(2,'output','import'),
(2,'output','link'),
(2,'output','search'),
(2,'output','showimport'),
(2,'output','unlink'),
(2,'output','view'),
(2,'process','browse'),
(2,'process','create'),
(2,'process','delete'),
(2,'process','edit'),
(2,'process','view'),
(2,'pssp','browse'),
(2,'pssp','update'),
(2,'report','customeRedreport'),
(2,'review','assess'),
(2,'review','audit'),
(2,'review','browse'),
(2,'review','create'),
(2,'review','edit'),
(2,'review','recall'),
(2,'review','report'),
(2,'review','result'),
(2,'review','submit'),
(2,'review','toAudit'),
(2,'review','view'),
(2,'reviewcl','browse'),
(2,'reviewissue','create'),
(2,'reviewissue','edit'),
(2,'reviewissue','issue'),
(2,'reviewissue','resolved'),
(2,'reviewissue','updateStatus'),
(2,'reviewissue','view'),
(2,'reviewsetting','version'),
(2,'risk','activate'),
(2,'risk','browse'),
(2,'risk','cancel'),
(2,'risk','close'),
(2,'risk','create'),
(2,'risk','delete'),
(2,'risk','edit'),
(2,'risk','hangup'),
(2,'risk','view'),
(2,'stage','batchCreate'),
(2,'stage','browse'),
(2,'stage','create'),
(2,'stage','delete'),
(2,'stage','edit'),
(2,'subject','browse'),
(2,'task','confirmdesignchange'),
(2,'testcase','submit'),
(2,'testsuite','test'),
(2,'trainchapter','browse'),
(2,'trainchapter','catalog'),
(2,'trainchapter','delete'),
(2,'trainchapter','edit'),
(2,'trainchapter','manage'),
(2,'trainchapter','showDocFiles'),
(2,'trainchapter','sortChapterOrder'),
(2,'trainchapter','view'),
(2,'traincourse','browse'),
(2,'traincourse','create'),
(2,'traincourse','delete'),
(2,'traincourse','edit'),
(2,'traincourse','view'),
(2,'traingoal','browse'),
(2,'traingoal','create'),
(2,'traingoal','delete'),
(2,'traingoal','edit'),
(2,'traingoal','review'),
(2,'traingoal','submitReview'),
(2,'traingoal','updateOrder'),
(2,'traingoal','view'),
(2,'trainplan','batchCreate'),
(2,'trainplan','batchEdit'),
(2,'trainplan','batchFinish'),
(2,'trainplan','browse'),
(2,'trainplan','create'),
(2,'trainplan','delete'),
(2,'trainplan','edit'),
(2,'trainplan','finish'),
(2,'trainplan','summary'),
(2,'trainplan','view'),
(2,'trainpost','browse'),
(2,'trainpost','create'),
(2,'trainpost','delete'),
(2,'trainpost','edit'),
(2,'trainpost','editGrade'),
(2,'trainpost','gradeView'),
(2,'trainpost','manageGrade'),
(2,'trainpost','updateOrder'),
(2,'trainpost','view'),
(2,'trainskill','browse'),
(2,'trainskill','create'),
(2,'trainskill','createGrade'),
(2,'trainskill','delete'),
(2,'trainskill','deleteDesc'),
(2,'trainskill','deleteGrade'),
(2,'trainskill','edit'),
(2,'trainskill','editGrade'),
(2,'trainskill','view'),
(2,'traintask','browse'),
(2,'traintask','closed'),
(2,'traintask','create'),
(2,'traintask','delete'),
(2,'traintask','edit'),
(2,'traintask','finish'),
(2,'traintask','import'),
(2,'traintask','start'),
(2,'traintask','view'),
(2,'weekly','index'),
(2,'workestimation','index'),
(2,'workloadbudget','27'),
(2,'workloadbudget','assign'),
(2,'workloadbudget','batchassign'),
(2,'workloadbudget','batchcreate'),
(2,'workloadbudget','batchedit'),
(2,'workloadbudget','browse'),
(2,'workloadbudget','create'),
(2,'workloadbudget','delete'),
(2,'workloadbudget','edit'),
(2,'workloadbudget','export'),
(2,'workloadbudget','exporttemplate'),
(2,'workloadbudget','import'),
(2,'workloadbudget','link'),
(2,'workloadbudget','search'),
(2,'workloadbudget','showimport'),
(2,'workloadbudget','unlink'),
(2,'workloadbudget','view'),
(3,'activity','browse'),
(3,'activity','create'),
(3,'activity','delete'),
(3,'activity','edit'),
(3,'activity','view'),
(3,'audit','8'),
(3,'audit','assign'),
(3,'audit','batchassign'),
(3,'audit','batchcreate'),
(3,'audit','batchedit'),
(3,'audit','browse'),
(3,'audit','create'),
(3,'audit','delete'),
(3,'audit','edit'),
(3,'audit','export'),
(3,'audit','exporttemplate'),
(3,'audit','import'),
(3,'audit','link'),
(3,'audit','search'),
(3,'audit','showimport'),
(3,'audit','unlink'),
(3,'audit','view'),
(3,'auditcl','browse'),
(3,'auditplan','browse'),
(3,'auditplan','create'),
(3,'auditplan','edit'),
(3,'auditplan','nc'),
(3,'auditplan','result'),
(3,'auditresult','10'),
(3,'auditresult','assign'),
(3,'auditresult','batchassign'),
(3,'auditresult','batchcreate'),
(3,'auditresult','batchedit'),
(3,'auditresult','browse'),
(3,'auditresult','create'),
(3,'auditresult','delete'),
(3,'auditresult','edit'),
(3,'auditresult','export'),
(3,'auditresult','exporttemplate'),
(3,'auditresult','import'),
(3,'auditresult','link'),
(3,'auditresult','search'),
(3,'auditresult','showimport'),
(3,'auditresult','unlink'),
(3,'auditresult','view'),
(3,'baseline','catalog'),
(3,'baseline','createTemplate'),
(3,'baseline','editBook'),
(3,'baseline','editTemplate'),
(3,'baseline','manageBook'),
(3,'baseline','template'),
(3,'baseline','view'),
(3,'budget','batchCreate'),
(3,'budget','browse'),
(3,'budget','create'),
(3,'budget','edit'),
(3,'budget','summary'),
(3,'budget','view'),
(3,'caselib','justtest'),
(3,'classify','browse'),
(3,'cm','browse'),
(3,'cm','create'),
(3,'cm','edit'),
(3,'cm','report'),
(3,'cm','view'),
(3,'cmcl','browse'),
(3,'custom','estimate'),
(3,'design','browse'),
(3,'design','create'),
(3,'design','edit'),
(3,'design','view'),
(3,'durationestimation','create'),
(3,'durationestimation','index'),
(3,'gapanalysis','batchCreate'),
(3,'gapanalysis','batchEdit'),
(3,'gapanalysis','browse'),
(3,'gapanalysis','create'),
(3,'gapanalysis','delete'),
(3,'gapanalysis','edit'),
(3,'gapanalysis','view'),
(3,'issue','activate'),
(3,'issue','browse'),
(3,'issue','cancel'),
(3,'issue','close'),
(3,'issue','create'),
(3,'issue','delete'),
(3,'issue','edit'),
(3,'issue','resolve'),
(3,'issue','view'),
(3,'meeting','browse'),
(3,'meeting','create'),
(3,'meeting','delete'),
(3,'meeting','edit'),
(3,'meeting','minutes'),
(3,'meeting','view'),
(3,'milestone','index'),
(3,'milestone','saveOtherProblem'),
(3,'my','issue'),
(3,'my','meeting'),
(3,'my','myMeeting'),
(3,'my','nc'),
(3,'my','risk'),
(3,'nc','16'),
(3,'nc','activate'),
(3,'nc','assign'),
(3,'nc','batchassign'),
(3,'nc','batchcreate'),
(3,'nc','batchedit'),
(3,'nc','browse'),
(3,'nc','close'),
(3,'nc','create'),
(3,'nc','delete'),
(3,'nc','edit'),
(3,'nc','export'),
(3,'nc','exporttemplate'),
(3,'nc','import'),
(3,'nc','link'),
(3,'nc','resolve'),
(3,'nc','search'),
(3,'nc','showimport'),
(3,'nc','unlink'),
(3,'nc','view'),
(3,'opportunity','activate'),
(3,'opportunity','assignTo'),
(3,'opportunity','batchActivate'),
(3,'opportunity','batchAssignTo'),
(3,'opportunity','batchCancel'),
(3,'opportunity','batchClose'),
(3,'opportunity','batchCreate'),
(3,'opportunity','batchEdit'),
(3,'opportunity','batchHangup'),
(3,'opportunity','browse'),
(3,'opportunity','cancel'),
(3,'opportunity','close'),
(3,'opportunity','create'),
(3,'opportunity','delete'),
(3,'opportunity','edit'),
(3,'opportunity','hangup'),
(3,'opportunity','importFromLib'),
(3,'opportunity','track'),
(3,'opportunity','view'),
(3,'output','13'),
(3,'output','assign'),
(3,'output','batchassign'),
(3,'output','batchcreate'),
(3,'output','batchedit'),
(3,'output','browse'),
(3,'output','create'),
(3,'output','delete'),
(3,'output','edit'),
(3,'output','export'),
(3,'output','exporttemplate'),
(3,'output','import'),
(3,'output','link'),
(3,'output','search'),
(3,'output','showimport'),
(3,'output','unlink'),
(3,'output','view'),
(3,'process','browse'),
(3,'process','create'),
(3,'process','delete'),
(3,'process','edit'),
(3,'process','view'),
(3,'pssp','browse'),
(3,'pssp','update'),
(3,'report','customeRedreport'),
(3,'review','assess'),
(3,'review','audit'),
(3,'review','browse'),
(3,'review','create'),
(3,'review','edit'),
(3,'review','recall'),
(3,'review','report'),
(3,'review','result'),
(3,'review','submit'),
(3,'review','toAudit'),
(3,'review','view'),
(3,'reviewcl','browse'),
(3,'reviewissue','create'),
(3,'reviewissue','edit'),
(3,'reviewissue','issue'),
(3,'reviewissue','resolved'),
(3,'reviewissue','updateStatus'),
(3,'reviewissue','view'),
(3,'reviewsetting','version'),
(3,'risk','activate'),
(3,'risk','browse'),
(3,'risk','cancel'),
(3,'risk','close'),
(3,'risk','create'),
(3,'risk','edit'),
(3,'risk','hangup'),
(3,'risk','view'),
(3,'stage','batchCreate'),
(3,'stage','browse'),
(3,'stage','create'),
(3,'stage','delete'),
(3,'stage','edit'),
(3,'subject','browse'),
(3,'testcase','submit'),
(3,'testsuite','test'),
(3,'trainbook','browse'),
(3,'trainplan','browse'),
(3,'trainplan','view'),
(3,'weekly','index'),
(3,'workestimation','index'),
(3,'workloadbudget','27'),
(3,'workloadbudget','assign'),
(3,'workloadbudget','batchassign'),
(3,'workloadbudget','batchcreate'),
(3,'workloadbudget','batchedit'),
(3,'workloadbudget','browse'),
(3,'workloadbudget','create'),
(3,'workloadbudget','delete'),
(3,'workloadbudget','edit'),
(3,'workloadbudget','export'),
(3,'workloadbudget','exporttemplate'),
(3,'workloadbudget','import'),
(3,'workloadbudget','link'),
(3,'workloadbudget','search'),
(3,'workloadbudget','showimport'),
(3,'workloadbudget','unlink'),
(3,'workloadbudget','view'),
(4,'activity','browse'),
(4,'activity','create'),
(4,'activity','delete'),
(4,'activity','edit'),
(4,'activity','view'),
(4,'audit','8'),
(4,'audit','assign'),
(4,'audit','batchassign'),
(4,'audit','batchcreate'),
(4,'audit','batchedit'),
(4,'audit','browse'),
(4,'audit','create'),
(4,'audit','delete'),
(4,'audit','edit'),
(4,'audit','export'),
(4,'audit','exporttemplate'),
(4,'audit','import'),
(4,'audit','link'),
(4,'audit','search'),
(4,'audit','showimport'),
(4,'audit','unlink'),
(4,'audit','view'),
(4,'auditcl','browse'),
(4,'auditcl','delete'),
(4,'auditcl','edit'),
(4,'auditplan','browse'),
(4,'auditplan','create'),
(4,'auditplan','edit'),
(4,'auditplan','nc'),
(4,'auditplan','result'),
(4,'auditresult','10'),
(4,'auditresult','assign'),
(4,'auditresult','batchassign'),
(4,'auditresult','batchcreate'),
(4,'auditresult','batchedit'),
(4,'auditresult','browse'),
(4,'auditresult','create'),
(4,'auditresult','delete'),
(4,'auditresult','edit'),
(4,'auditresult','export'),
(4,'auditresult','exporttemplate'),
(4,'auditresult','import'),
(4,'auditresult','link'),
(4,'auditresult','search'),
(4,'auditresult','showimport'),
(4,'auditresult','unlink'),
(4,'auditresult','view'),
(4,'baseline','catalog'),
(4,'baseline','createTemplate'),
(4,'baseline','editBook'),
(4,'baseline','editTemplate'),
(4,'baseline','manageBook'),
(4,'baseline','template'),
(4,'baseline','view'),
(4,'budget','batchCreate'),
(4,'budget','browse'),
(4,'budget','create'),
(4,'budget','edit'),
(4,'budget','summary'),
(4,'budget','view'),
(4,'build','browse'),
(4,'caselib','justtest'),
(4,'classify','browse'),
(4,'cm','browse'),
(4,'cm','create'),
(4,'cm','edit'),
(4,'cm','report'),
(4,'cm','view'),
(4,'cmcl','browse'),
(4,'cmcl','delete'),
(4,'cmcl','edit'),
(4,'cmcl','view'),
(4,'design','browse'),
(4,'design','create'),
(4,'design','delete'),
(4,'design','edit'),
(4,'design','view'),
(4,'doc','importToComponentLib'),
(4,'doc','importToPracticeLib'),
(4,'durationestimation','create'),
(4,'durationestimation','index'),
(4,'gapanalysis','batchCreate'),
(4,'gapanalysis','batchEdit'),
(4,'gapanalysis','browse'),
(4,'gapanalysis','create'),
(4,'gapanalysis','delete'),
(4,'gapanalysis','edit'),
(4,'gapanalysis','view'),
(4,'issue','activate'),
(4,'issue','batchCreate'),
(4,'issue','browse'),
(4,'issue','cancel'),
(4,'issue','close'),
(4,'issue','create'),
(4,'issue','delete'),
(4,'issue','edit'),
(4,'issue','resolve'),
(4,'issue','view'),
(4,'meeting','browse'),
(4,'meeting','create'),
(4,'meeting','delete'),
(4,'meeting','edit'),
(4,'meeting','minutes'),
(4,'meeting','view'),
(4,'meetingroom','batchCreate'),
(4,'meetingroom','batchEdit'),
(4,'meetingroom','browse'),
(4,'meetingroom','create'),
(4,'meetingroom','delete'),
(4,'meetingroom','edit'),
(4,'meetingroom','view'),
(4,'metting','127'),
(4,'metting','assign'),
(4,'metting','batchassign'),
(4,'metting','batchcreate'),
(4,'metting','batchedit'),
(4,'metting','browse'),
(4,'metting','create'),
(4,'metting','delete'),
(4,'metting','edit'),
(4,'metting','export'),
(4,'metting','exporttemplate'),
(4,'metting','import'),
(4,'metting','link'),
(4,'metting','report'),
(4,'metting','search'),
(4,'metting','showimport'),
(4,'metting','unlink'),
(4,'metting','view'),
(4,'milestone','index'),
(4,'milestone','saveOtherProblem'),
(4,'my','issue'),
(4,'my','meeting'),
(4,'my','myMeeting'),
(4,'my','nc'),
(4,'my','risk'),
(4,'nc','16'),
(4,'nc','activate'),
(4,'nc','assign'),
(4,'nc','batchassign'),
(4,'nc','batchcreate'),
(4,'nc','batchedit'),
(4,'nc','browse'),
(4,'nc','close'),
(4,'nc','create'),
(4,'nc','delete'),
(4,'nc','edit'),
(4,'nc','export'),
(4,'nc','exporttemplate'),
(4,'nc','import'),
(4,'nc','link'),
(4,'nc','resolve'),
(4,'nc','search'),
(4,'nc','showimport'),
(4,'nc','unlink'),
(4,'nc','view'),
(4,'opportunity','activate'),
(4,'opportunity','assignTo'),
(4,'opportunity','batchActivate'),
(4,'opportunity','batchAssignTo'),
(4,'opportunity','batchCancel'),
(4,'opportunity','batchClose'),
(4,'opportunity','batchCreate'),
(4,'opportunity','batchEdit'),
(4,'opportunity','batchHangup'),
(4,'opportunity','batchImportToLib'),
(4,'opportunity','browse'),
(4,'opportunity','cancel'),
(4,'opportunity','close'),
(4,'opportunity','create'),
(4,'opportunity','delete'),
(4,'opportunity','edit'),
(4,'opportunity','hangup'),
(4,'opportunity','importFromLib'),
(4,'opportunity','importToLib'),
(4,'opportunity','track'),
(4,'opportunity','view'),
(4,'output','13'),
(4,'output','assign'),
(4,'output','batchassign'),
(4,'output','batchcreate'),
(4,'output','batchedit'),
(4,'output','browse'),
(4,'output','create'),
(4,'output','delete'),
(4,'output','edit'),
(4,'output','export'),
(4,'output','exporttemplate'),
(4,'output','import'),
(4,'output','link'),
(4,'output','search'),
(4,'output','showimport'),
(4,'output','unlink'),
(4,'output','view'),
(4,'process','browse'),
(4,'process','create'),
(4,'process','delete'),
(4,'process','edit'),
(4,'process','view'),
(4,'programplan','browse'),
(4,'programplan','create'),
(4,'programplan','edit'),
(4,'projectstory','importFromLib'),
(4,'pssp','browse'),
(4,'pssp','update'),
(4,'report','customeRedreport'),
(4,'report','instanceTemplate'),
(4,'review','assess'),
(4,'review','audit'),
(4,'review','browse'),
(4,'review','create'),
(4,'review','edit'),
(4,'review','recall'),
(4,'review','report'),
(4,'review','result'),
(4,'review','submit'),
(4,'review','toAudit'),
(4,'review','view'),
(4,'reviewcl','browse'),
(4,'reviewcl','create'),
(4,'reviewcl','delete'),
(4,'reviewcl','edit'),
(4,'reviewcl','view'),
(4,'reviewissue','create'),
(4,'reviewissue','edit'),
(4,'reviewissue','issue'),
(4,'reviewissue','resolved'),
(4,'reviewissue','updateStatus'),
(4,'reviewissue','view'),
(4,'reviewsetting','version'),
(4,'risk','activate'),
(4,'risk','assignTo'),
(4,'risk','batchCreate'),
(4,'risk','browse'),
(4,'risk','cancel'),
(4,'risk','close'),
(4,'risk','create'),
(4,'risk','delete'),
(4,'risk','edit'),
(4,'risk','hangup'),
(4,'risk','importFromLib'),
(4,'risk','track'),
(4,'risk','view'),
(4,'stage','batchCreate'),
(4,'stage','browse'),
(4,'stage','create'),
(4,'stage','delete'),
(4,'stage','edit'),
(4,'story','batchImportToLib'),
(4,'story','importToLib'),
(4,'subject','browse'),
(4,'task','confirmdesignchange'),
(4,'testcase','submit'),
(4,'testsuite','test'),
(4,'trainbook','ajaxgetbookbysn'),
(4,'trainbook','borrow'),
(4,'trainbook','borrowhistory'),
(4,'trainbook','browse'),
(4,'trainbook','returnbook'),
(4,'trainbook','view'),
(4,'traincareer','index'),
(4,'trainchapter','browse'),
(4,'trainchapter','download'),
(4,'trainchapter','showDocFiles'),
(4,'trainchapter','view'),
(4,'traincourse','browse'),
(4,'traincourse','collect'),
(4,'traincourse','view'),
(4,'trainexam','browse'),
(4,'trainexam','choseExam'),
(4,'trainexam','exam'),
(4,'trainexam','myExams'),
(4,'trainexam','scoreDetail'),
(4,'traingoal','browse'),
(4,'traingoal','create'),
(4,'traingoal','delete'),
(4,'traingoal','edit'),
(4,'traingoal','recall'),
(4,'traingoal','review'),
(4,'traingoal','submitReview'),
(4,'traingoal','updateOrder'),
(4,'traingoal','view'),
(4,'trainplan','batchCreate'),
(4,'trainplan','batchEdit'),
(4,'trainplan','batchFinish'),
(4,'trainplan','browse'),
(4,'trainplan','create'),
(4,'trainplan','delete'),
(4,'trainplan','edit'),
(4,'trainplan','finish'),
(4,'trainplan','summary'),
(4,'trainplan','view'),
(4,'trainpost','browse'),
(4,'trainpost','gradeView'),
(4,'trainpost','view'),
(4,'trainskill','browse'),
(4,'trainskill','editGrade'),
(4,'trainskill','view'),
(4,'traintask','browse'),
(4,'traintask','browseDeptTasks'),
(4,'traintask','close'),
(4,'traintask','create'),
(4,'traintask','createTask'),
(4,'traintask','delete'),
(4,'traintask','edit'),
(4,'traintask','finish'),
(4,'traintask','import'),
(4,'traintask','start'),
(4,'traintask','view'),
(4,'weekly','index'),
(4,'workestimation','index'),
(4,'workloadbudget','27'),
(4,'workloadbudget','assign'),
(4,'workloadbudget','batchassign'),
(4,'workloadbudget','batchcreate'),
(4,'workloadbudget','batchedit'),
(4,'workloadbudget','browse'),
(4,'workloadbudget','create'),
(4,'workloadbudget','delete'),
(4,'workloadbudget','edit'),
(4,'workloadbudget','export'),
(4,'workloadbudget','exporttemplate'),
(4,'workloadbudget','import'),
(4,'workloadbudget','link'),
(4,'workloadbudget','search'),
(4,'workloadbudget','showimport'),
(4,'workloadbudget','unlink'),
(4,'workloadbudget','view'),
(5,'activity','browse'),
(5,'activity','create'),
(5,'activity','delete'),
(5,'activity','edit'),
(5,'activity','view'),
(5,'audit','8'),
(5,'audit','assign'),
(5,'audit','batchassign'),
(5,'audit','batchcreate'),
(5,'audit','batchedit'),
(5,'audit','browse'),
(5,'audit','create'),
(5,'audit','delete'),
(5,'audit','edit'),
(5,'audit','export'),
(5,'audit','exporttemplate'),
(5,'audit','import'),
(5,'audit','link'),
(5,'audit','search'),
(5,'audit','showimport'),
(5,'audit','unlink'),
(5,'audit','view'),
(5,'auditcl','browse'),
(5,'auditcl','delete'),
(5,'auditcl','edit'),
(5,'auditplan','browse'),
(5,'auditplan','create'),
(5,'auditplan','edit'),
(5,'auditplan','nc'),
(5,'auditplan','result'),
(5,'auditresult','10'),
(5,'auditresult','assign'),
(5,'auditresult','batchassign'),
(5,'auditresult','batchcreate'),
(5,'auditresult','batchedit'),
(5,'auditresult','browse'),
(5,'auditresult','create'),
(5,'auditresult','delete'),
(5,'auditresult','edit'),
(5,'auditresult','export'),
(5,'auditresult','exporttemplate'),
(5,'auditresult','import'),
(5,'auditresult','link'),
(5,'auditresult','search'),
(5,'auditresult','showimport'),
(5,'auditresult','unlink'),
(5,'auditresult','view'),
(5,'baseline','catalog'),
(5,'baseline','createTemplate'),
(5,'baseline','editBook'),
(5,'baseline','editTemplate'),
(5,'baseline','manageBook'),
(5,'baseline','template'),
(5,'baseline','view'),
(5,'budget','batchCreate'),
(5,'budget','browse'),
(5,'budget','create'),
(5,'budget','edit'),
(5,'budget','summary'),
(5,'budget','view'),
(5,'classify','browse'),
(5,'cm','browse'),
(5,'cm','create'),
(5,'cm','edit'),
(5,'cm','report'),
(5,'cm','view'),
(5,'cmcl','browse'),
(5,'cmcl','delete'),
(5,'cmcl','edit'),
(5,'cmcl','view'),
(5,'design','browse'),
(5,'design','create'),
(5,'design','delete'),
(5,'design','edit'),
(5,'design','view'),
(5,'durationestimation','create'),
(5,'durationestimation','index'),
(5,'issue','activate'),
(5,'issue','batchCreate'),
(5,'issue','browse'),
(5,'issue','cancel'),
(5,'issue','close'),
(5,'issue','create'),
(5,'issue','delete'),
(5,'issue','edit'),
(5,'issue','resolve'),
(5,'issue','view'),
(5,'measrecord','browse'),
(5,'measurement','batchEdit'),
(5,'measurement','browse'),
(5,'measurement','createBasic'),
(5,'measurement','createTemplate'),
(5,'measurement','delete'),
(5,'measurement','design'),
(5,'measurement','designPHP'),
(5,'measurement','designSQL'),
(5,'measurement','editBasic'),
(5,'measurement','editDerivation'),
(5,'measurement','editTemplate'),
(5,'measurement','searchMeas'),
(5,'measurement','template'),
(5,'measurement','viewTemplate'),
(5,'meeting','browse'),
(5,'meeting','create'),
(5,'meeting','delete'),
(5,'meeting','edit'),
(5,'meeting','minutes'),
(5,'meeting','view'),
(5,'meetingroom','batchCreate'),
(5,'meetingroom','batchEdit'),
(5,'meetingroom','browse'),
(5,'meetingroom','create'),
(5,'meetingroom','delete'),
(5,'meetingroom','edit'),
(5,'meetingroom','view'),
(5,'milestone','index'),
(5,'milestone','saveOtherProblem'),
(5,'my','issue'),
(5,'my','meeting'),
(5,'my','myMeeting'),
(5,'my','nc'),
(5,'my','risk'),
(5,'nc','16'),
(5,'nc','activate'),
(5,'nc','assign'),
(5,'nc','batchassign'),
(5,'nc','batchcreate'),
(5,'nc','batchedit'),
(5,'nc','browse'),
(5,'nc','close'),
(5,'nc','create'),
(5,'nc','delete'),
(5,'nc','edit'),
(5,'nc','export'),
(5,'nc','exporttemplate'),
(5,'nc','import'),
(5,'nc','link'),
(5,'nc','resolve'),
(5,'nc','search'),
(5,'nc','showimport'),
(5,'nc','unlink'),
(5,'nc','view'),
(5,'opportunity','activate'),
(5,'opportunity','assignTo'),
(5,'opportunity','batchActivate'),
(5,'opportunity','batchAssignTo'),
(5,'opportunity','batchCancel'),
(5,'opportunity','batchClose'),
(5,'opportunity','batchCreate'),
(5,'opportunity','batchEdit'),
(5,'opportunity','batchHangup'),
(5,'opportunity','batchImportToLib'),
(5,'opportunity','browse'),
(5,'opportunity','cancel'),
(5,'opportunity','close'),
(5,'opportunity','create'),
(5,'opportunity','delete'),
(5,'opportunity','edit'),
(5,'opportunity','hangup'),
(5,'opportunity','importFromLib'),
(5,'opportunity','importToLib'),
(5,'opportunity','track'),
(5,'opportunity','view'),
(5,'output','13'),
(5,'output','assign'),
(5,'output','batchassign'),
(5,'output','batchcreate'),
(5,'output','batchedit'),
(5,'output','browse'),
(5,'output','create'),
(5,'output','delete'),
(5,'output','edit'),
(5,'output','export'),
(5,'output','exporttemplate'),
(5,'output','import'),
(5,'output','link'),
(5,'output','search'),
(5,'output','showimport'),
(5,'output','unlink'),
(5,'output','view'),
(5,'process','browse'),
(5,'process','create'),
(5,'process','delete'),
(5,'process','edit'),
(5,'process','view'),
(5,'programplan','browse'),
(5,'programplan','create'),
(5,'programplan','edit'),
(5,'projectstory','importFromLib'),
(5,'pssp','browse'),
(5,'pssp','update'),
(5,'report','customeRedreport'),
(5,'researchplan','browse'),
(5,'researchplan','create'),
(5,'researchplan','delete'),
(5,'researchplan','edit'),
(5,'researchplan','view'),
(5,'researchreport','browse'),
(5,'researchreport','create'),
(5,'researchreport','delete'),
(5,'researchreport','edit'),
(5,'researchreport','view'),
(5,'review','assess'),
(5,'review','audit'),
(5,'review','browse'),
(5,'review','create'),
(5,'review','edit'),
(5,'review','recall'),
(5,'review','report'),
(5,'review','result'),
(5,'review','submit'),
(5,'review','toAudit'),
(5,'review','view'),
(5,'reviewcl','browse'),
(5,'reviewcl','create'),
(5,'reviewcl','delete'),
(5,'reviewcl','edit'),
(5,'reviewcl','view'),
(5,'reviewissue','create'),
(5,'reviewissue','edit'),
(5,'reviewissue','issue'),
(5,'reviewissue','resolved'),
(5,'reviewissue','updateStatus'),
(5,'reviewissue','view'),
(5,'reviewsetting','version'),
(5,'risk','activate'),
(5,'risk','assignTo'),
(5,'risk','batchCreate'),
(5,'risk','batchImportToLib'),
(5,'risk','browse'),
(5,'risk','cancel'),
(5,'risk','close'),
(5,'risk','create'),
(5,'risk','delete'),
(5,'risk','edit'),
(5,'risk','hangup'),
(5,'risk','importFromLib'),
(5,'risk','importToLib'),
(5,'risk','track'),
(5,'risk','view'),
(5,'stage','batchCreate'),
(5,'stage','browse'),
(5,'stage','create'),
(5,'stage','delete'),
(5,'stage','edit'),
(5,'stage','setType'),
(5,'story','batchImportToLib'),
(5,'story','importToLib'),
(5,'subject','browse'),
(5,'task','confirmdesignchange'),
(5,'weekly','index'),
(5,'workestimation','index'),
(5,'workloadbudget','27'),
(5,'workloadbudget','assign'),
(5,'workloadbudget','batchassign'),
(5,'workloadbudget','batchcreate'),
(5,'workloadbudget','batchedit'),
(5,'workloadbudget','browse'),
(5,'workloadbudget','create'),
(5,'workloadbudget','delete'),
(5,'workloadbudget','edit'),
(5,'workloadbudget','export'),
(5,'workloadbudget','exporttemplate'),
(5,'workloadbudget','import'),
(5,'workloadbudget','link'),
(5,'workloadbudget','search'),
(5,'workloadbudget','showimport'),
(5,'workloadbudget','unlink'),
(5,'workloadbudget','view'),
(5,'zoutput','batchCreate'),
(5,'zoutput','batchEdit'),
(5,'zoutput','browse'),
(5,'zoutput','create'),
(5,'zoutput','delete'),
(5,'zoutput','edit'),
(5,'zoutput','updateOrder'),
(5,'zoutput','view'),
(6,'activity','browse'),
(6,'activity','create'),
(6,'activity','delete'),
(6,'activity','edit'),
(6,'activity','view'),
(6,'audit','8'),
(6,'audit','assign'),
(6,'audit','batchassign'),
(6,'audit','batchcreate'),
(6,'audit','batchedit'),
(6,'audit','browse'),
(6,'audit','create'),
(6,'audit','delete'),
(6,'audit','edit'),
(6,'audit','export'),
(6,'audit','exporttemplate'),
(6,'audit','import'),
(6,'audit','link'),
(6,'audit','search'),
(6,'audit','showimport'),
(6,'audit','unlink'),
(6,'audit','view'),
(6,'auditcl','browse'),
(6,'auditcl','delete'),
(6,'auditcl','edit'),
(6,'auditplan','browse'),
(6,'auditplan','create'),
(6,'auditplan','edit'),
(6,'auditplan','nc'),
(6,'auditplan','result'),
(6,'auditresult','10'),
(6,'auditresult','assign'),
(6,'auditresult','batchassign'),
(6,'auditresult','batchcreate'),
(6,'auditresult','batchedit'),
(6,'auditresult','browse'),
(6,'auditresult','create'),
(6,'auditresult','delete'),
(6,'auditresult','edit'),
(6,'auditresult','export'),
(6,'auditresult','exporttemplate'),
(6,'auditresult','import'),
(6,'auditresult','link'),
(6,'auditresult','search'),
(6,'auditresult','showimport'),
(6,'auditresult','unlink'),
(6,'auditresult','view'),
(6,'baseline','catalog'),
(6,'baseline','createTemplate'),
(6,'baseline','editBook'),
(6,'baseline','editTemplate'),
(6,'baseline','manageBook'),
(6,'baseline','template'),
(6,'baseline','view'),
(6,'budget','batchCreate'),
(6,'budget','browse'),
(6,'budget','create'),
(6,'budget','edit'),
(6,'budget','summary'),
(6,'budget','view'),
(6,'classify','browse'),
(6,'cm','browse'),
(6,'cm','create'),
(6,'cm','edit'),
(6,'cm','report'),
(6,'cm','view'),
(6,'cmcl','browse'),
(6,'cmcl','delete'),
(6,'cmcl','edit'),
(6,'cmcl','view'),
(6,'custom','estimate'),
(6,'design','browse'),
(6,'design','create'),
(6,'design','delete'),
(6,'design','edit'),
(6,'design','view'),
(6,'durationestimation','create'),
(6,'durationestimation','index'),
(6,'gapanalysis','batchCreate'),
(6,'gapanalysis','batchEdit'),
(6,'gapanalysis','browse'),
(6,'gapanalysis','create'),
(6,'gapanalysis','delete'),
(6,'gapanalysis','edit'),
(6,'gapanalysis','view'),
(6,'issue','activate'),
(6,'issue','assignTo'),
(6,'issue','batchCreate'),
(6,'issue','browse'),
(6,'issue','cancel'),
(6,'issue','close'),
(6,'issue','confirm'),
(6,'issue','create'),
(6,'issue','delete'),
(6,'issue','edit'),
(6,'issue','importFromLib'),
(6,'issue','resolve'),
(6,'issue','view'),
(6,'meeting','browse'),
(6,'meeting','create'),
(6,'meeting','delete'),
(6,'meeting','edit'),
(6,'meeting','minutes'),
(6,'meeting','view'),
(6,'meetingroom','batchCreate'),
(6,'meetingroom','batchEdit'),
(6,'meetingroom','browse'),
(6,'meetingroom','create'),
(6,'meetingroom','delete'),
(6,'meetingroom','edit'),
(6,'meetingroom','view'),
(6,'milestone','index'),
(6,'milestone','saveOtherProblem'),
(6,'my','issue'),
(6,'my','meeting'),
(6,'my','myMeeting'),
(6,'my','nc'),
(6,'my','risk'),
(6,'nc','16'),
(6,'nc','activate'),
(6,'nc','assign'),
(6,'nc','batchassign'),
(6,'nc','batchcreate'),
(6,'nc','batchedit'),
(6,'nc','browse'),
(6,'nc','close'),
(6,'nc','create'),
(6,'nc','delete'),
(6,'nc','edit'),
(6,'nc','export'),
(6,'nc','exporttemplate'),
(6,'nc','import'),
(6,'nc','link'),
(6,'nc','resolve'),
(6,'nc','search'),
(6,'nc','showimport'),
(6,'nc','unlink'),
(6,'nc','view'),
(6,'opportunity','activate'),
(6,'opportunity','assignTo'),
(6,'opportunity','batchActivate'),
(6,'opportunity','batchAssignTo'),
(6,'opportunity','batchCancel'),
(6,'opportunity','batchClose'),
(6,'opportunity','batchCreate'),
(6,'opportunity','batchEdit'),
(6,'opportunity','batchHangup'),
(6,'opportunity','batchImportToLib'),
(6,'opportunity','browse'),
(6,'opportunity','cancel'),
(6,'opportunity','close'),
(6,'opportunity','create'),
(6,'opportunity','delete'),
(6,'opportunity','edit'),
(6,'opportunity','hangup'),
(6,'opportunity','importFromLib'),
(6,'opportunity','importToLib'),
(6,'opportunity','track'),
(6,'opportunity','view'),
(6,'output','13'),
(6,'output','assign'),
(6,'output','batchassign'),
(6,'output','batchcreate'),
(6,'output','batchedit'),
(6,'output','browse'),
(6,'output','create'),
(6,'output','delete'),
(6,'output','edit'),
(6,'output','export'),
(6,'output','exporttemplate'),
(6,'output','import'),
(6,'output','link'),
(6,'output','search'),
(6,'output','showimport'),
(6,'output','unlink'),
(6,'output','view'),
(6,'process','browse'),
(6,'process','create'),
(6,'process','delete'),
(6,'process','edit'),
(6,'process','view'),
(6,'programplan','browse'),
(6,'programplan','create'),
(6,'programplan','edit'),
(6,'pssp','browse'),
(6,'pssp','update'),
(6,'report','customeRedreport'),
(6,'review','assess'),
(6,'review','audit'),
(6,'review','browse'),
(6,'review','create'),
(6,'review','edit'),
(6,'review','recall'),
(6,'review','report'),
(6,'review','result'),
(6,'review','submit'),
(6,'review','toAudit'),
(6,'review','view'),
(6,'reviewcl','browse'),
(6,'reviewcl','create'),
(6,'reviewcl','delete'),
(6,'reviewcl','edit'),
(6,'reviewcl','view'),
(6,'reviewissue','create'),
(6,'reviewissue','edit'),
(6,'reviewissue','issue'),
(6,'reviewissue','resolved'),
(6,'reviewissue','updateStatus'),
(6,'reviewissue','view'),
(6,'reviewsetting','version'),
(6,'risk','activate'),
(6,'risk','assignTo'),
(6,'risk','batchCreate'),
(6,'risk','browse'),
(6,'risk','cancel'),
(6,'risk','close'),
(6,'risk','create'),
(6,'risk','delete'),
(6,'risk','edit'),
(6,'risk','hangup'),
(6,'risk','importFromLib'),
(6,'risk','view'),
(6,'stage','batchCreate'),
(6,'stage','browse'),
(6,'stage','create'),
(6,'stage','delete'),
(6,'stage','edit'),
(6,'subject','browse'),
(6,'trainplan','batchCreate'),
(6,'trainplan','batchEdit'),
(6,'trainplan','batchFinish'),
(6,'trainplan','browse'),
(6,'trainplan','create'),
(6,'trainplan','delete'),
(6,'trainplan','edit'),
(6,'trainplan','finish'),
(6,'trainplan','summary'),
(6,'trainplan','view'),
(6,'weekly','index'),
(6,'workestimation','index'),
(6,'workloadbudget','27'),
(6,'workloadbudget','assign'),
(6,'workloadbudget','batchassign'),
(6,'workloadbudget','batchcreate'),
(6,'workloadbudget','batchedit'),
(6,'workloadbudget','browse'),
(6,'workloadbudget','create'),
(6,'workloadbudget','delete'),
(6,'workloadbudget','edit'),
(6,'workloadbudget','export'),
(6,'workloadbudget','exporttemplate'),
(6,'workloadbudget','import'),
(6,'workloadbudget','link'),
(6,'workloadbudget','search'),
(6,'workloadbudget','showimport'),
(6,'workloadbudget','unlink'),
(6,'workloadbudget','view'),
(6,'zoutput','batchCreate'),
(6,'zoutput','batchEdit'),
(6,'zoutput','browse'),
(6,'zoutput','create'),
(6,'zoutput','delete'),
(6,'zoutput','edit'),
(6,'zoutput','updateOrder'),
(6,'zoutput','view'),
(7,'activity','browse'),
(7,'activity','create'),
(7,'activity','delete'),
(7,'activity','edit'),
(7,'activity','view'),
(7,'audit','8'),
(7,'audit','assign'),
(7,'audit','batchassign'),
(7,'audit','batchcreate'),
(7,'audit','batchedit'),
(7,'audit','browse'),
(7,'audit','create'),
(7,'audit','delete'),
(7,'audit','edit'),
(7,'audit','export'),
(7,'audit','exporttemplate'),
(7,'audit','import'),
(7,'audit','link'),
(7,'audit','search'),
(7,'audit','showimport'),
(7,'audit','unlink'),
(7,'audit','view'),
(7,'auditcl','browse'),
(7,'auditcl','delete'),
(7,'auditcl','edit'),
(7,'auditplan','browse'),
(7,'auditplan','create'),
(7,'auditplan','edit'),
(7,'auditplan','nc'),
(7,'auditplan','result'),
(7,'auditresult','10'),
(7,'auditresult','assign'),
(7,'auditresult','batchassign'),
(7,'auditresult','batchcreate'),
(7,'auditresult','batchedit'),
(7,'auditresult','browse'),
(7,'auditresult','create'),
(7,'auditresult','delete'),
(7,'auditresult','edit'),
(7,'auditresult','export'),
(7,'auditresult','exporttemplate'),
(7,'auditresult','import'),
(7,'auditresult','link'),
(7,'auditresult','search'),
(7,'auditresult','showimport'),
(7,'auditresult','unlink'),
(7,'auditresult','view'),
(7,'baseline','catalog'),
(7,'baseline','createTemplate'),
(7,'baseline','editBook'),
(7,'baseline','editTemplate'),
(7,'baseline','manageBook'),
(7,'baseline','template'),
(7,'baseline','view'),
(7,'budget','batchCreate'),
(7,'budget','browse'),
(7,'budget','create'),
(7,'budget','delete'),
(7,'budget','edit'),
(7,'budget','summary'),
(7,'budget','view'),
(7,'classify','browse'),
(7,'cm','browse'),
(7,'cm','create'),
(7,'cm','edit'),
(7,'cm','report'),
(7,'cm','view'),
(7,'cmcl','browse'),
(7,'cmcl','delete'),
(7,'cmcl','edit'),
(7,'cmcl','view'),
(7,'custom','estimate'),
(7,'design','browse'),
(7,'design','create'),
(7,'design','delete'),
(7,'design','edit'),
(7,'design','view'),
(7,'durationestimation','create'),
(7,'durationestimation','index'),
(7,'gapanalysis','batchCreate'),
(7,'gapanalysis','batchEdit'),
(7,'gapanalysis','browse'),
(7,'gapanalysis','create'),
(7,'gapanalysis','delete'),
(7,'gapanalysis','edit'),
(7,'gapanalysis','view'),
(7,'issue','activate'),
(7,'issue','assignTo'),
(7,'issue','batchCreate'),
(7,'issue','browse'),
(7,'issue','cancel'),
(7,'issue','close'),
(7,'issue','confirm'),
(7,'issue','create'),
(7,'issue','delete'),
(7,'issue','edit'),
(7,'issue','importFromLib'),
(7,'issue','resolve'),
(7,'issue','view'),
(7,'measrecord','browse'),
(7,'measurement','batchEdit'),
(7,'measurement','browse'),
(7,'measurement','createBasic'),
(7,'measurement','createTemplate'),
(7,'measurement','delete'),
(7,'measurement','design'),
(7,'measurement','designPHP'),
(7,'measurement','designSQL'),
(7,'measurement','editBasic'),
(7,'measurement','editDerivation'),
(7,'measurement','editTemplate'),
(7,'measurement','searchMeas'),
(7,'measurement','template'),
(7,'measurement','viewTemplate'),
(7,'meeting','browse'),
(7,'meeting','create'),
(7,'meeting','delete'),
(7,'meeting','edit'),
(7,'meeting','minutes'),
(7,'meeting','view'),
(7,'meetingroom','batchCreate'),
(7,'meetingroom','batchEdit'),
(7,'meetingroom','browse'),
(7,'meetingroom','create'),
(7,'meetingroom','delete'),
(7,'meetingroom','edit'),
(7,'meetingroom','view'),
(7,'milestone','index'),
(7,'my','issue'),
(7,'my','meeting'),
(7,'my','myMeeting'),
(7,'my','nc'),
(7,'my','risk'),
(7,'nc','16'),
(7,'nc','activate'),
(7,'nc','assign'),
(7,'nc','batchassign'),
(7,'nc','batchcreate'),
(7,'nc','batchedit'),
(7,'nc','browse'),
(7,'nc','close'),
(7,'nc','create'),
(7,'nc','delete'),
(7,'nc','edit'),
(7,'nc','export'),
(7,'nc','exporttemplate'),
(7,'nc','import'),
(7,'nc','link'),
(7,'nc','resolve'),
(7,'nc','search'),
(7,'nc','showimport'),
(7,'nc','unlink'),
(7,'nc','view'),
(7,'opportunity','activate'),
(7,'opportunity','assignTo'),
(7,'opportunity','batchActivate'),
(7,'opportunity','batchAssignTo'),
(7,'opportunity','batchCancel'),
(7,'opportunity','batchClose'),
(7,'opportunity','batchCreate'),
(7,'opportunity','batchEdit'),
(7,'opportunity','batchHangup'),
(7,'opportunity','batchImportToLib'),
(7,'opportunity','browse'),
(7,'opportunity','cancel'),
(7,'opportunity','close'),
(7,'opportunity','create'),
(7,'opportunity','delete'),
(7,'opportunity','edit'),
(7,'opportunity','hangup'),
(7,'opportunity','importFromLib'),
(7,'opportunity','importToLib'),
(7,'opportunity','track'),
(7,'opportunity','view'),
(7,'output','13'),
(7,'output','assign'),
(7,'output','batchassign'),
(7,'output','batchcreate'),
(7,'output','batchedit'),
(7,'output','browse'),
(7,'output','create'),
(7,'output','delete'),
(7,'output','edit'),
(7,'output','export'),
(7,'output','exporttemplate'),
(7,'output','import'),
(7,'output','link'),
(7,'output','search'),
(7,'output','showimport'),
(7,'output','unlink'),
(7,'output','view'),
(7,'process','browse'),
(7,'process','create'),
(7,'process','delete'),
(7,'process','edit'),
(7,'process','view'),
(7,'programplan','browse'),
(7,'programplan','create'),
(7,'programplan','edit'),
(7,'pssp','browse'),
(7,'pssp','update'),
(7,'report','customeRedreport'),
(7,'review','assess'),
(7,'review','audit'),
(7,'review','browse'),
(7,'review','create'),
(7,'review','edit'),
(7,'review','recall'),
(7,'review','report'),
(7,'review','result'),
(7,'review','submit'),
(7,'review','toAudit'),
(7,'review','view'),
(7,'reviewcl','browse'),
(7,'reviewcl','create'),
(7,'reviewcl','delete'),
(7,'reviewcl','edit'),
(7,'reviewcl','view'),
(7,'reviewissue','create'),
(7,'reviewissue','edit'),
(7,'reviewissue','issue'),
(7,'reviewissue','resolved'),
(7,'reviewissue','updateStatus'),
(7,'reviewissue','view'),
(7,'reviewsetting','version'),
(7,'risk','activate'),
(7,'risk','assignTo'),
(7,'risk','batchCreate'),
(7,'risk','browse'),
(7,'risk','cancel'),
(7,'risk','close'),
(7,'risk','create'),
(7,'risk','delete'),
(7,'risk','edit'),
(7,'risk','hangup'),
(7,'risk','importFromLib'),
(7,'risk','view'),
(7,'stage','batchCreate'),
(7,'stage','browse'),
(7,'stage','create'),
(7,'stage','delete'),
(7,'stage','edit'),
(7,'story','batchImportToLib'),
(7,'story','importToLib'),
(7,'subject','browse'),
(7,'trainplan','batchCreate'),
(7,'trainplan','batchEdit'),
(7,'trainplan','batchFinish'),
(7,'trainplan','browse'),
(7,'trainplan','create'),
(7,'trainplan','delete'),
(7,'trainplan','edit'),
(7,'trainplan','finish'),
(7,'trainplan','summary'),
(7,'trainplan','view'),
(7,'weekly','index'),
(7,'workestimation','index'),
(7,'workloadbudget','27'),
(7,'workloadbudget','assign'),
(7,'workloadbudget','batchassign'),
(7,'workloadbudget','batchcreate'),
(7,'workloadbudget','batchedit'),
(7,'workloadbudget','browse'),
(7,'workloadbudget','create'),
(7,'workloadbudget','delete'),
(7,'workloadbudget','edit'),
(7,'workloadbudget','export'),
(7,'workloadbudget','exporttemplate'),
(7,'workloadbudget','import'),
(7,'workloadbudget','link'),
(7,'workloadbudget','search'),
(7,'workloadbudget','showimport'),
(7,'workloadbudget','unlink'),
(7,'workloadbudget','view'),
(8,'activity','browse'),
(8,'activity','create'),
(8,'activity','delete'),
(8,'activity','edit'),
(8,'activity','view'),
(8,'audit','8'),
(8,'audit','assign'),
(8,'audit','batchassign'),
(8,'audit','batchcreate'),
(8,'audit','batchedit'),
(8,'audit','browse'),
(8,'audit','create'),
(8,'audit','delete'),
(8,'audit','edit'),
(8,'audit','export'),
(8,'audit','exporttemplate'),
(8,'audit','import'),
(8,'audit','link'),
(8,'audit','search'),
(8,'audit','showimport'),
(8,'audit','unlink'),
(8,'audit','view'),
(8,'auditcl','browse'),
(8,'auditcl','delete'),
(8,'auditcl','edit'),
(8,'auditplan','batchCreate'),
(8,'auditplan','browse'),
(8,'auditplan','create'),
(8,'auditplan','edit'),
(8,'auditplan','nc'),
(8,'auditplan','result'),
(8,'auditresult','10'),
(8,'auditresult','assign'),
(8,'auditresult','batchassign'),
(8,'auditresult','batchcreate'),
(8,'auditresult','batchedit'),
(8,'auditresult','browse'),
(8,'auditresult','create'),
(8,'auditresult','delete'),
(8,'auditresult','edit'),
(8,'auditresult','export'),
(8,'auditresult','exporttemplate'),
(8,'auditresult','import'),
(8,'auditresult','link'),
(8,'auditresult','search'),
(8,'auditresult','showimport'),
(8,'auditresult','unlink'),
(8,'auditresult','view'),
(8,'baseline','catalog'),
(8,'baseline','createTemplate'),
(8,'baseline','editBook'),
(8,'baseline','editTemplate'),
(8,'baseline','manageBook'),
(8,'baseline','template'),
(8,'baseline','view'),
(8,'budget','batchCreate'),
(8,'budget','browse'),
(8,'budget','create'),
(8,'budget','edit'),
(8,'budget','summary'),
(8,'budget','view'),
(8,'classify','browse'),
(8,'cm','browse'),
(8,'cm','create'),
(8,'cm','edit'),
(8,'cm','report'),
(8,'cm','view'),
(8,'cmcl','browse'),
(8,'cmcl','delete'),
(8,'cmcl','edit'),
(8,'cmcl','view'),
(8,'custom','estimate'),
(8,'design','browse'),
(8,'design','create'),
(8,'design','delete'),
(8,'design','edit'),
(8,'design','view'),
(8,'durationestimation','create'),
(8,'durationestimation','index'),
(8,'gapanalysis','batchCreate'),
(8,'gapanalysis','batchEdit'),
(8,'gapanalysis','browse'),
(8,'gapanalysis','create'),
(8,'gapanalysis','delete'),
(8,'gapanalysis','edit'),
(8,'gapanalysis','view'),
(8,'issue','activate'),
(8,'issue','assignTo'),
(8,'issue','batchCreate'),
(8,'issue','browse'),
(8,'issue','cancel'),
(8,'issue','close'),
(8,'issue','confirm'),
(8,'issue','create'),
(8,'issue','delete'),
(8,'issue','edit'),
(8,'issue','importFromLib'),
(8,'issue','resolve'),
(8,'issue','view'),
(8,'meeting','browse'),
(8,'meeting','create'),
(8,'meeting','delete'),
(8,'meeting','edit'),
(8,'meeting','minutes'),
(8,'meeting','view'),
(8,'meetingroom','batchCreate'),
(8,'meetingroom','batchEdit'),
(8,'meetingroom','browse'),
(8,'meetingroom','create'),
(8,'meetingroom','delete'),
(8,'meetingroom','edit'),
(8,'meetingroom','view'),
(8,'milestone','index'),
(8,'milestone','saveOtherProblem'),
(8,'my','issue'),
(8,'my','meeting'),
(8,'my','myMeeting'),
(8,'my','nc'),
(8,'my','risk'),
(8,'nc','16'),
(8,'nc','activate'),
(8,'nc','assign'),
(8,'nc','batchassign'),
(8,'nc','batchcreate'),
(8,'nc','batchedit'),
(8,'nc','browse'),
(8,'nc','close'),
(8,'nc','create'),
(8,'nc','delete'),
(8,'nc','edit'),
(8,'nc','export'),
(8,'nc','exporttemplate'),
(8,'nc','import'),
(8,'nc','link'),
(8,'nc','resolve'),
(8,'nc','search'),
(8,'nc','showimport'),
(8,'nc','unlink'),
(8,'nc','view'),
(8,'opportunity','activate'),
(8,'opportunity','assignTo'),
(8,'opportunity','batchActivate'),
(8,'opportunity','batchAssignTo'),
(8,'opportunity','batchCancel'),
(8,'opportunity','batchClose'),
(8,'opportunity','batchCreate'),
(8,'opportunity','batchEdit'),
(8,'opportunity','batchHangup'),
(8,'opportunity','batchImportToLib'),
(8,'opportunity','browse'),
(8,'opportunity','cancel'),
(8,'opportunity','close'),
(8,'opportunity','create'),
(8,'opportunity','delete'),
(8,'opportunity','edit'),
(8,'opportunity','hangup'),
(8,'opportunity','importFromLib'),
(8,'opportunity','importToLib'),
(8,'opportunity','track'),
(8,'opportunity','view'),
(8,'output','13'),
(8,'output','assign'),
(8,'output','batchassign'),
(8,'output','batchcreate'),
(8,'output','batchedit'),
(8,'output','browse'),
(8,'output','create'),
(8,'output','delete'),
(8,'output','edit'),
(8,'output','export'),
(8,'output','exporttemplate'),
(8,'output','import'),
(8,'output','link'),
(8,'output','search'),
(8,'output','showimport'),
(8,'output','unlink'),
(8,'output','view'),
(8,'process','browse'),
(8,'process','create'),
(8,'process','delete'),
(8,'process','edit'),
(8,'process','view'),
(8,'pssp','browse'),
(8,'pssp','update'),
(8,'report','customeRedreport'),
(8,'review','assess'),
(8,'review','audit'),
(8,'review','browse'),
(8,'review','create'),
(8,'review','edit'),
(8,'review','recall'),
(8,'review','report'),
(8,'review','result'),
(8,'review','submit'),
(8,'review','toAudit'),
(8,'review','view'),
(8,'reviewcl','browse'),
(8,'reviewcl','create'),
(8,'reviewcl','delete'),
(8,'reviewcl','edit'),
(8,'reviewcl','view'),
(8,'reviewissue','create'),
(8,'reviewissue','edit'),
(8,'reviewissue','issue'),
(8,'reviewissue','resolved'),
(8,'reviewissue','updateStatus'),
(8,'reviewissue','view'),
(8,'reviewsetting','version'),
(8,'risk','activate'),
(8,'risk','assignTo'),
(8,'risk','batchCreate'),
(8,'risk','browse'),
(8,'risk','cancel'),
(8,'risk','close'),
(8,'risk','create'),
(8,'risk','delete'),
(8,'risk','edit'),
(8,'risk','hangup'),
(8,'risk','importFromLib'),
(8,'risk','track'),
(8,'risk','view'),
(8,'stage','batchCreate'),
(8,'stage','browse'),
(8,'stage','create'),
(8,'stage','delete'),
(8,'stage','edit'),
(8,'subject','browse'),
(8,'testcase','submit'),
(8,'testsuite','test'),
(8,'trainbook','ajaxgetbookbysn'),
(8,'trainbook','batchChangeModule'),
(8,'trainbook','batchEdit'),
(8,'trainbook','borrow'),
(8,'trainbook','borrowrecords'),
(8,'trainbook','browse'),
(8,'trainbook','create'),
(8,'trainbook','delete'),
(8,'trainbook','edit'),
(8,'trainbook','export'),
(8,'trainbook','manage'),
(8,'trainbook','myborrow'),
(8,'trainbook','returnbook'),
(8,'trainbook','view'),
(8,'traincareer','index'),
(8,'trainchapter','browse'),
(8,'trainchapter','catalog'),
(8,'trainchapter','delete'),
(8,'trainchapter','download'),
(8,'trainchapter','edit'),
(8,'trainchapter','manage'),
(8,'trainchapter','showDocFiles'),
(8,'trainchapter','sortChapterOrder'),
(8,'trainchapter','view'),
(8,'traincourse','browse'),
(8,'traincourse','changeStatus'),
(8,'traincourse','collect'),
(8,'traincourse','create'),
(8,'traincourse','delete'),
(8,'traincourse','edit'),
(8,'traincourse','manage'),
(8,'traincourse','view'),
(8,'trainexam','browse'),
(8,'trainexam','changeStatus'),
(8,'trainexam','choseExam'),
(8,'trainexam','create'),
(8,'trainexam','delete'),
(8,'trainexam','deleteQuestion'),
(8,'trainexam','edit'),
(8,'trainexam','editQuestion'),
(8,'trainexam','exam'),
(8,'trainexam','myExams'),
(8,'trainexam','review'),
(8,'trainexam','scoreDetail'),
(8,'trainexam','setQuestion'),
(8,'trainexam','updateOrder'),
(8,'trainexam','view'),
(8,'traingoal','browse'),
(8,'traingoal','browseCompanyGoals'),
(8,'traingoal','browseDeptGoals'),
(8,'traingoal','create'),
(8,'traingoal','delete'),
(8,'traingoal','edit'),
(8,'traingoal','recall'),
(8,'traingoal','review'),
(8,'traingoal','submitReview'),
(8,'traingoal','updateOrder'),
(8,'traingoal','view'),
(8,'trainplan','batchCreate'),
(8,'trainplan','batchEdit'),
(8,'trainplan','batchFinish'),
(8,'trainplan','browse'),
(8,'trainplan','create'),
(8,'trainplan','delete'),
(8,'trainplan','edit'),
(8,'trainplan','finish'),
(8,'trainplan','summary'),
(8,'trainplan','view'),
(8,'trainpost','browse'),
(8,'trainpost','create'),
(8,'trainpost','createGrade'),
(8,'trainpost','delete'),
(8,'trainpost','edit'),
(8,'trainpost','editGrade'),
(8,'trainpost','manageGrade'),
(8,'trainpost','sortGrade'),
(8,'trainpost','sortPost'),
(8,'trainskill','browse'),
(8,'trainskill','create'),
(8,'trainskill','createGrade'),
(8,'trainskill','delete'),
(8,'trainskill','deleteDesc'),
(8,'trainskill','deleteGrade'),
(8,'trainskill','edit'),
(8,'trainskill','editGrade'),
(8,'trainskill','view'),
(8,'traintask','browse'),
(8,'traintask','browseCompanyTasks'),
(8,'traintask','browseDeptTasks'),
(8,'traintask','close'),
(8,'traintask','create'),
(8,'traintask','createTask'),
(8,'traintask','delete'),
(8,'traintask','edit'),
(8,'traintask','finish'),
(8,'traintask','import'),
(8,'traintask','setCondition'),
(8,'traintask','start'),
(8,'traintask','view'),
(8,'weekly','index'),
(8,'workestimation','index'),
(8,'workloadbudget','27'),
(8,'workloadbudget','assign'),
(8,'workloadbudget','batchassign'),
(8,'workloadbudget','batchcreate'),
(8,'workloadbudget','batchedit'),
(8,'workloadbudget','browse'),
(8,'workloadbudget','create'),
(8,'workloadbudget','delete'),
(8,'workloadbudget','edit'),
(8,'workloadbudget','export'),
(8,'workloadbudget','exporttemplate'),
(8,'workloadbudget','import'),
(8,'workloadbudget','link'),
(8,'workloadbudget','search'),
(8,'workloadbudget','showimport'),
(8,'workloadbudget','unlink'),
(8,'workloadbudget','view'),
(9,'activity','browse'),
(9,'activity','create'),
(9,'activity','delete'),
(9,'activity','edit'),
(9,'activity','view'),
(9,'audit','8'),
(9,'audit','assign'),
(9,'audit','batchassign'),
(9,'audit','batchcreate'),
(9,'audit','batchedit'),
(9,'audit','browse'),
(9,'audit','create'),
(9,'audit','delete'),
(9,'audit','edit'),
(9,'audit','export'),
(9,'audit','exporttemplate'),
(9,'audit','import'),
(9,'audit','link'),
(9,'audit','search'),
(9,'audit','showimport'),
(9,'audit','unlink'),
(9,'audit','view'),
(9,'auditcl','browse'),
(9,'auditcl','delete'),
(9,'auditcl','edit'),
(9,'auditplan','browse'),
(9,'auditplan','create'),
(9,'auditplan','edit'),
(9,'auditplan','nc'),
(9,'auditplan','result'),
(9,'auditresult','10'),
(9,'auditresult','assign'),
(9,'auditresult','batchassign'),
(9,'auditresult','batchcreate'),
(9,'auditresult','batchedit'),
(9,'auditresult','browse'),
(9,'auditresult','create'),
(9,'auditresult','delete'),
(9,'auditresult','edit'),
(9,'auditresult','export'),
(9,'auditresult','exporttemplate'),
(9,'auditresult','import'),
(9,'auditresult','link'),
(9,'auditresult','search'),
(9,'auditresult','showimport'),
(9,'auditresult','unlink'),
(9,'auditresult','view'),
(9,'baseline','catalog'),
(9,'baseline','createTemplate'),
(9,'baseline','delete'),
(9,'baseline','editBook'),
(9,'baseline','editTemplate'),
(9,'baseline','manageBook'),
(9,'baseline','template'),
(9,'baseline','view'),
(9,'budget','batchCreate'),
(9,'budget','browse'),
(9,'budget','create'),
(9,'budget','delete'),
(9,'budget','edit'),
(9,'budget','summary'),
(9,'budget','view'),
(9,'classify','browse'),
(9,'cm','browse'),
(9,'cm','create'),
(9,'cm','delete'),
(9,'cm','edit'),
(9,'cm','report'),
(9,'cm','view'),
(9,'cmcl','browse'),
(9,'cmcl','delete'),
(9,'cmcl','edit'),
(9,'cmcl','view'),
(9,'custom','estimate'),
(9,'design','assignTo'),
(9,'design','batchCreate'),
(9,'design','browse'),
(9,'design','create'),
(9,'design','delete'),
(9,'design','edit'),
(9,'design','view'),
(9,'durationestimation','create'),
(9,'durationestimation','index'),
(9,'issue','activate'),
(9,'issue','assignTo'),
(9,'issue','batchCreate'),
(9,'issue','browse'),
(9,'issue','cancel'),
(9,'issue','close'),
(9,'issue','confirm'),
(9,'issue','create'),
(9,'issue','delete'),
(9,'issue','edit'),
(9,'issue','importFromLib'),
(9,'issue','resolve'),
(9,'issue','view'),
(9,'meeting','browse'),
(9,'meeting','create'),
(9,'meeting','delete'),
(9,'meeting','edit'),
(9,'meeting','minutes'),
(9,'meeting','view'),
(9,'meetingroom','batchCreate'),
(9,'meetingroom','batchEdit'),
(9,'meetingroom','browse'),
(9,'meetingroom','create'),
(9,'meetingroom','delete'),
(9,'meetingroom','edit'),
(9,'meetingroom','view'),
(9,'milestone','index'),
(9,'milestone','saveOtherProblem'),
(9,'my','issue'),
(9,'my','meeting'),
(9,'my','myMeeting'),
(9,'my','nc'),
(9,'my','risk'),
(9,'nc','16'),
(9,'nc','activate'),
(9,'nc','assign'),
(9,'nc','batchassign'),
(9,'nc','batchcreate'),
(9,'nc','batchedit'),
(9,'nc','browse'),
(9,'nc','close'),
(9,'nc','create'),
(9,'nc','delete'),
(9,'nc','edit'),
(9,'nc','export'),
(9,'nc','exporttemplate'),
(9,'nc','import'),
(9,'nc','link'),
(9,'nc','resolve'),
(9,'nc','search'),
(9,'nc','showimport'),
(9,'nc','unlink'),
(9,'nc','view'),
(9,'opportunity','activate'),
(9,'opportunity','assignTo'),
(9,'opportunity','batchActivate'),
(9,'opportunity','batchAssignTo'),
(9,'opportunity','batchCancel'),
(9,'opportunity','batchClose'),
(9,'opportunity','batchCreate'),
(9,'opportunity','batchEdit'),
(9,'opportunity','batchHangup'),
(9,'opportunity','batchImportToLib'),
(9,'opportunity','browse'),
(9,'opportunity','cancel'),
(9,'opportunity','close'),
(9,'opportunity','create'),
(9,'opportunity','delete'),
(9,'opportunity','edit'),
(9,'opportunity','hangup'),
(9,'opportunity','importFromLib'),
(9,'opportunity','importToLib'),
(9,'opportunity','track'),
(9,'opportunity','view'),
(9,'output','13'),
(9,'output','assign'),
(9,'output','batchassign'),
(9,'output','batchcreate'),
(9,'output','batchedit'),
(9,'output','browse'),
(9,'output','create'),
(9,'output','delete'),
(9,'output','edit'),
(9,'output','export'),
(9,'output','exporttemplate'),
(9,'output','import'),
(9,'output','link'),
(9,'output','search'),
(9,'output','showimport'),
(9,'output','unlink'),
(9,'output','view'),
(9,'process','browse'),
(9,'process','create'),
(9,'process','delete'),
(9,'process','edit'),
(9,'process','view'),
(9,'programplan','browse'),
(9,'pssp','browse'),
(9,'pssp','update'),
(9,'report','customeRedreport'),
(9,'review','assess'),
(9,'review','audit'),
(9,'review','browse'),
(9,'review','create'),
(9,'review','edit'),
(9,'review','recall'),
(9,'review','report'),
(9,'review','result'),
(9,'review','submit'),
(9,'review','toAudit'),
(9,'review','view'),
(9,'reviewcl','browse'),
(9,'reviewcl','create'),
(9,'reviewcl','delete'),
(9,'reviewcl','edit'),
(9,'reviewcl','view'),
(9,'reviewissue','create'),
(9,'reviewissue','edit'),
(9,'reviewissue','issue'),
(9,'reviewissue','resolved'),
(9,'reviewissue','updateStatus'),
(9,'reviewissue','view'),
(9,'reviewsetting','version'),
(9,'risk','activate'),
(9,'risk','assignTo'),
(9,'risk','batchCreate'),
(9,'risk','browse'),
(9,'risk','cancel'),
(9,'risk','close'),
(9,'risk','create'),
(9,'risk','delete'),
(9,'risk','edit'),
(9,'risk','hangup'),
(9,'risk','importFromLib'),
(9,'risk','view'),
(9,'stage','batchCreate'),
(9,'stage','browse'),
(9,'stage','create'),
(9,'stage','delete'),
(9,'stage','edit'),
(9,'subject','browse'),
(9,'weekly','index'),
(9,'workestimation','index'),
(9,'workloadbudget','27'),
(9,'workloadbudget','assign'),
(9,'workloadbudget','batchassign'),
(9,'workloadbudget','batchcreate'),
(9,'workloadbudget','batchedit'),
(9,'workloadbudget','browse'),
(9,'workloadbudget','create'),
(9,'workloadbudget','delete'),
(9,'workloadbudget','edit'),
(9,'workloadbudget','export'),
(9,'workloadbudget','exporttemplate'),
(9,'workloadbudget','import'),
(9,'workloadbudget','link'),
(9,'workloadbudget','search'),
(9,'workloadbudget','showimport'),
(9,'workloadbudget','unlink'),
(9,'workloadbudget','view'),
(9,'zoutput','browse'),
(9,'zoutput','view'),
(10,'activity','browse'),
(10,'activity','create'),
(10,'activity','delete'),
(10,'activity','edit'),
(10,'activity','view'),
(10,'audit','8'),
(10,'audit','assign'),
(10,'audit','batchassign'),
(10,'audit','batchcreate'),
(10,'audit','batchedit'),
(10,'audit','browse'),
(10,'audit','create'),
(10,'audit','delete'),
(10,'audit','edit'),
(10,'audit','export'),
(10,'audit','exporttemplate'),
(10,'audit','import'),
(10,'audit','link'),
(10,'audit','search'),
(10,'audit','showimport'),
(10,'audit','unlink'),
(10,'audit','view'),
(10,'auditplan','browse'),
(10,'auditplan','create'),
(10,'auditplan','edit'),
(10,'auditplan','nc'),
(10,'auditplan','result'),
(10,'auditresult','10'),
(10,'auditresult','assign'),
(10,'auditresult','batchassign'),
(10,'auditresult','batchcreate'),
(10,'auditresult','batchedit'),
(10,'auditresult','browse'),
(10,'auditresult','create'),
(10,'auditresult','delete'),
(10,'auditresult','edit'),
(10,'auditresult','export'),
(10,'auditresult','exporttemplate'),
(10,'auditresult','import'),
(10,'auditresult','link'),
(10,'auditresult','search'),
(10,'auditresult','showimport'),
(10,'auditresult','unlink'),
(10,'auditresult','view'),
(10,'budget','batchCreate'),
(10,'budget','browse'),
(10,'budget','create'),
(10,'budget','delete'),
(10,'budget','edit'),
(10,'budget','summary'),
(10,'budget','view'),
(10,'custom','estimate'),
(10,'design','browse'),
(10,'design','create'),
(10,'design','delete'),
(10,'design','edit'),
(10,'design','view'),
(10,'durationestimation','create'),
(10,'durationestimation','index'),
(10,'issue','activate'),
(10,'issue','batchCreate'),
(10,'issue','browse'),
(10,'issue','cancel'),
(10,'issue','close'),
(10,'issue','create'),
(10,'issue','delete'),
(10,'issue','edit'),
(10,'issue','resolve'),
(10,'issue','view'),
(10,'meeting','browse'),
(10,'meeting','create'),
(10,'meeting','delete'),
(10,'meeting','edit'),
(10,'meeting','minutes'),
(10,'meeting','view'),
(10,'milestone','index'),
(10,'my','issue'),
(10,'my','meeting'),
(10,'my','myMeeting'),
(10,'my','nc'),
(10,'my','risk'),
(10,'nc','16'),
(10,'nc','activate'),
(10,'nc','assign'),
(10,'nc','batchassign'),
(10,'nc','batchcreate'),
(10,'nc','batchedit'),
(10,'nc','browse'),
(10,'nc','close'),
(10,'nc','create'),
(10,'nc','delete'),
(10,'nc','edit'),
(10,'nc','export'),
(10,'nc','exporttemplate'),
(10,'nc','import'),
(10,'nc','link'),
(10,'nc','resolve'),
(10,'nc','search'),
(10,'nc','showimport'),
(10,'nc','unlink'),
(10,'nc','view'),
(10,'opportunity','browse'),
(10,'opportunity','view'),
(10,'output','13'),
(10,'output','assign'),
(10,'output','batchassign'),
(10,'output','batchcreate'),
(10,'output','batchedit'),
(10,'output','browse'),
(10,'output','create'),
(10,'output','delete'),
(10,'output','edit'),
(10,'output','export'),
(10,'output','exporttemplate'),
(10,'output','import'),
(10,'output','link'),
(10,'output','search'),
(10,'output','showimport'),
(10,'output','unlink'),
(10,'output','view'),
(10,'process','browse'),
(10,'process','create'),
(10,'process','delete'),
(10,'process','edit'),
(10,'process','view'),
(10,'pssp','browse'),
(10,'pssp','update'),
(10,'report','customeRedreport'),
(10,'risk','activate'),
(10,'risk','batchCreate'),
(10,'risk','browse'),
(10,'risk','cancel'),
(10,'risk','close'),
(10,'risk','create'),
(10,'risk','delete'),
(10,'risk','edit'),
(10,'risk','hangup'),
(10,'risk','view'),
(10,'stage','batchCreate'),
(10,'stage','browse'),
(10,'stage','create'),
(10,'stage','delete'),
(10,'stage','edit'),
(10,'subject','browse'),
(10,'trainchapter','browse'),
(10,'trainchapter','catalog'),
(10,'trainchapter','delete'),
(10,'trainchapter','download'),
(10,'trainchapter','edit'),
(10,'trainchapter','manage'),
(10,'trainchapter','showDocFiles'),
(10,'trainchapter','sortChapterOrder'),
(10,'trainchapter','view'),
(10,'traincourse','browse'),
(10,'traincourse','create'),
(10,'traincourse','delete'),
(10,'traincourse','edit'),
(10,'traincourse','manage'),
(10,'traincourse','view'),
(10,'trainplan','browse'),
(10,'trainplan','view'),
(10,'trainskill','browse'),
(10,'trainskill','create'),
(10,'trainskill','createGrade'),
(10,'trainskill','delete'),
(10,'trainskill','deleteDesc'),
(10,'trainskill','deleteGrade'),
(10,'trainskill','edit'),
(10,'trainskill','editGrade'),
(10,'trainskill','view'),
(10,'weekly','index'),
(10,'workestimation','index'),
(10,'workloadbudget','27'),
(10,'workloadbudget','assign'),
(10,'workloadbudget','batchassign'),
(10,'workloadbudget','batchcreate'),
(10,'workloadbudget','batchedit'),
(10,'workloadbudget','browse'),
(10,'workloadbudget','create'),
(10,'workloadbudget','delete'),
(10,'workloadbudget','edit'),
(10,'workloadbudget','export'),
(10,'workloadbudget','exporttemplate'),
(10,'workloadbudget','import'),
(10,'workloadbudget','link'),
(10,'workloadbudget','search'),
(10,'workloadbudget','showimport'),
(10,'workloadbudget','unlink'),
(10,'workloadbudget','view'),
(11,'activity','browse'),
(11,'activity','create'),
(11,'activity','delete'),
(11,'activity','edit'),
(11,'activity','view'),
(11,'audit','8'),
(11,'audit','assign'),
(11,'audit','batchassign'),
(11,'audit','batchcreate'),
(11,'audit','batchedit'),
(11,'audit','browse'),
(11,'audit','create'),
(11,'audit','delete'),
(11,'audit','edit'),
(11,'audit','export'),
(11,'audit','exporttemplate'),
(11,'audit','import'),
(11,'audit','link'),
(11,'audit','search'),
(11,'audit','showimport'),
(11,'audit','unlink'),
(11,'audit','view'),
(11,'auditplan','browse'),
(11,'auditplan','create'),
(11,'auditplan','edit'),
(11,'auditplan','nc'),
(11,'auditplan','result'),
(11,'auditresult','10'),
(11,'auditresult','assign'),
(11,'auditresult','batchassign'),
(11,'auditresult','batchcreate'),
(11,'auditresult','batchedit'),
(11,'auditresult','browse'),
(11,'auditresult','create'),
(11,'auditresult','delete'),
(11,'auditresult','edit'),
(11,'auditresult','export'),
(11,'auditresult','exporttemplate'),
(11,'auditresult','import'),
(11,'auditresult','link'),
(11,'auditresult','search'),
(11,'auditresult','showimport'),
(11,'auditresult','unlink'),
(11,'auditresult','view'),
(11,'budget','batchCreate'),
(11,'budget','browse'),
(11,'budget','create'),
(11,'budget','delete'),
(11,'budget','edit'),
(11,'budget','summary'),
(11,'budget','view'),
(11,'custom','estimate'),
(11,'design','browse'),
(11,'design','create'),
(11,'design','delete'),
(11,'design','edit'),
(11,'design','view'),
(11,'durationestimation','create'),
(11,'durationestimation','index'),
(11,'issue','activate'),
(11,'issue','browse'),
(11,'issue','cancel'),
(11,'issue','close'),
(11,'issue','create'),
(11,'issue','delete'),
(11,'issue','edit'),
(11,'issue','resolve'),
(11,'issue','view'),
(11,'my','issue'),
(11,'my','meeting'),
(11,'my','myMeeting'),
(11,'my','risk'),
(11,'nc','16'),
(11,'nc','activate'),
(11,'nc','assign'),
(11,'nc','batchassign'),
(11,'nc','batchcreate'),
(11,'nc','batchedit'),
(11,'nc','browse'),
(11,'nc','close'),
(11,'nc','create'),
(11,'nc','delete'),
(11,'nc','edit'),
(11,'nc','export'),
(11,'nc','exporttemplate'),
(11,'nc','import'),
(11,'nc','link'),
(11,'nc','resolve'),
(11,'nc','search'),
(11,'nc','showimport'),
(11,'nc','unlink'),
(11,'nc','view'),
(11,'output','13'),
(11,'output','assign'),
(11,'output','batchassign'),
(11,'output','batchcreate'),
(11,'output','batchedit'),
(11,'output','browse'),
(11,'output','create'),
(11,'output','delete'),
(11,'output','edit'),
(11,'output','export'),
(11,'output','exporttemplate'),
(11,'output','import'),
(11,'output','link'),
(11,'output','search'),
(11,'output','showimport'),
(11,'output','unlink'),
(11,'output','view'),
(11,'process','browse'),
(11,'process','create'),
(11,'process','delete'),
(11,'process','edit'),
(11,'process','view'),
(11,'programplan','browse'),
(11,'pssp','browse'),
(11,'pssp','update'),
(11,'report','customeRedreport'),
(11,'risk','activate'),
(11,'risk','browse'),
(11,'risk','cancel'),
(11,'risk','close'),
(11,'risk','create'),
(11,'risk','delete'),
(11,'risk','edit'),
(11,'risk','hangup'),
(11,'risk','view'),
(11,'stage','browse'),
(11,'stage','create'),
(11,'stage','delete'),
(11,'stage','edit'),
(11,'story','processStoryChange'),
(11,'subject','browse'),
(11,'trainbook','ajaxgetbookbysn'),
(11,'trainbook','batchEdit'),
(11,'trainbook','borrow'),
(11,'trainbook','borrowhistory'),
(11,'trainbook','browse'),
(11,'trainbook','create'),
(11,'trainbook','delete'),
(11,'trainbook','edit'),
(11,'trainbook','export'),
(11,'trainbook','manage'),
(11,'trainbook','returnbook'),
(11,'trainbook','view'),
(11,'traincourse','browse'),
(11,'traincourse','changeStatus'),
(11,'traincourse','create'),
(11,'traincourse','edit'),
(11,'traincourse','manage'),
(11,'traincourse','view'),
(11,'weekly','index'),
(11,'workestimation','index'),
(11,'workloadbudget','27'),
(11,'workloadbudget','assign'),
(11,'workloadbudget','batchassign'),
(11,'workloadbudget','batchcreate'),
(11,'workloadbudget','batchedit'),
(11,'workloadbudget','browse'),
(11,'workloadbudget','create'),
(11,'workloadbudget','delete'),
(11,'workloadbudget','edit'),
(11,'workloadbudget','export'),
(11,'workloadbudget','exporttemplate'),
(11,'workloadbudget','import'),
(11,'workloadbudget','link'),
(11,'workloadbudget','search'),
(11,'workloadbudget','showimport'),
(11,'workloadbudget','unlink'),
(11,'workloadbudget','view');

REPLACE INTO `zt_lang` (`lang`, `module`, `section`, `key`, `value`, `system`) VALUES
('all', 'process', 'classify', 'support', '支持过程', '1'),
('all', 'process', 'classify', 'engineering', '工程支持', '1'),
('all', 'process', 'classify', 'project', '项目管理', '1');

REPLACE INTO `zt_process` (`id`, `name`, `type`, `abbr`, `desc`, `assignedTo`, `status`, `order`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `assignedBy`, `assignedDate`, `deleted`) VALUES
(11,'立项管理','project','PIM','','','',55,'admin','2020-01-09 10:29:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(12,'项目规划','project','PP','','','',60,'admin','2020-01-09 10:31:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(13,'项目监控','project','PMC','','','',65,'admin','2020-01-09 10:31:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(14,'风险管理','project','RSKM','','','',70,'admin','2020-01-09 10:31:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(15,'结项管理','project','PCM','','','',75,'admin','2020-01-09 10:31:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(16,'量化项目管理','project','QPM','','','',80,'admin','2020-01-09 10:31:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(17,'需求开发','engineering','RDM','','','',85,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(18,'技术解决方案','engineering','TS','','','',90,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(19,'实现与测试','engineering','EMBEDDED','','','',95,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(20,'系统测试','engineering','ST','','','',100,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(21,'客户验收','engineering','CA','','','',105,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(22,'质量保证','support','QA','','','',110,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(23,'配置管理','support','CM','','','',115,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(24,'度量分析','support','MA','','','',120,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(25,'原因分析与解决','support','CAR','','','',125,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0'),
(26,'决策分析','support','DAR','','','',130,'admin','2020-01-09 13:14:55','','0000-00-00 00:00:00','','0000-00-00 00:00:00','0');

REPLACE INTO `zt_activity` (`id`, `process`, `name`, `optional`, `content`, `assignedTo`, `status`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `assignedBy`, `assignedDate`, `order`, `deleted`) VALUES
(4,11,'立项调查，可行性分析，技术预研','yes','','','','admin','2020-01-09 10:49:34','','0000-00-00 00:00:00','','0000-00-00 00:00:00',20,'0'),
(5,11,'项目预算','yes','','','','admin','2020-01-09 10:49:34','','0000-00-00 00:00:00','','0000-00-00 00:00:00',25,'0'),
(6,11,'立项决策','yes','','','','admin','2020-01-09 10:49:34','','0000-00-00 00:00:00','','0000-00-00 00:00:00',30,'0'),
(7,11,'投标/商务洽谈','no','','','','admin','2020-01-09 10:49:34','','0000-00-00 00:00:00','','0000-00-00 00:00:00',35,'0'),
(8,12,'估算','yes','','','','admin','2020-01-09 11:12:17','','0000-00-00 00:00:00','','0000-00-00 00:00:00',40,'0'),
(9,12,'裁剪','yes','','','','admin','2020-01-09 11:12:17','','0000-00-00 00:00:00','','0000-00-00 00:00:00',45,'0'),
(10,12,'制定项目计划及下属计划','yes','','','','admin','2020-01-09 11:12:17','','0000-00-00 00:00:00','','0000-00-00 00:00:00',50,'0'),
(11,12,'评审项目计划及下属计划','yes','','','','admin','2020-01-09 11:12:17','','0000-00-00 00:00:00','','0000-00-00 00:00:00',55,'0'),
(12,13,'日常跟踪','yes','','','','admin','2020-01-09 11:13:37','','0000-00-00 00:00:00','','0000-00-00 00:00:00',60,'0'),
(13,13,'举行周例会','yes','','','','admin','2020-01-09 11:13:37','','0000-00-00 00:00:00','','0000-00-00 00:00:00',65,'0'),
(14,13,'里程碑评审','yes','','','','admin','2020-01-09 11:13:37','','0000-00-00 00:00:00','','0000-00-00 00:00:00',70,'0'),
(15,13,'采取纠正措施','no','','','','admin','2020-01-09 11:13:37','','0000-00-00 00:00:00','','0000-00-00 00:00:00',75,'0'),
(16,14,'制定风险管理计划','yes','','','','admin','2020-01-09 11:15:04','','0000-00-00 00:00:00','','0000-00-00 00:00:00',80,'0'),
(17,14,'风险识别','yes','','','','admin','2020-01-09 11:15:04','','0000-00-00 00:00:00','','0000-00-00 00:00:00',85,'0'),
(18,14,'风险分析','yes','','','','admin','2020-01-09 11:15:04','','0000-00-00 00:00:00','','0000-00-00 00:00:00',90,'0'),
(19,14,'风险规避和缓解','yes','','','','admin','2020-01-09 11:15:04','','0000-00-00 00:00:00','','0000-00-00 00:00:00',95,'0'),
(20,14,'风险跟踪','yes','','','','admin','2020-01-09 11:15:04','','0000-00-00 00:00:00','','0000-00-00 00:00:00',100,'0'),
(21,14,'更新组织级“风险列表库”','no','','','','admin','2020-01-09 11:15:04','','0000-00-00 00:00:00','','0000-00-00 00:00:00',105,'0'),
(22,15,'结项准备','no','','','','admin','2020-01-09 11:16:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00',110,'0'),
(23,15,'结项申请','yes','','','','admin','2020-01-09 11:16:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00',115,'0'),
(24,15,'结项评审','yes','','','','admin','2020-01-09 11:16:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00',120,'0'),
(25,15,'资料纳入组织级过程资产库','yes','','','','admin','2020-01-09 11:16:16','','0000-00-00 00:00:00','','0000-00-00 00:00:00',125,'0'),
(26,16,'量化项目管理','yes','','','','admin','2020-01-09 11:16:34','','0000-00-00 00:00:00','','0000-00-00 00:00:00',130,'0'),
(27,17,'用户需求获取','yes','','','','admin','2020-01-09 13:25:22','','0000-00-00 00:00:00','','0000-00-00 00:00:00',135,'0'),
(28,17,'用户需求评审','yes','','','','admin','2020-01-09 13:25:22','','0000-00-00 00:00:00','','0000-00-00 00:00:00',140,'0'),
(29,17,'产品需求定义','yes','','','','admin','2020-01-09 13:25:22','','0000-00-00 00:00:00','','0000-00-00 00:00:00',145,'0'),
(30,17,'产品需求评审','yes','','','','admin','2020-01-09 13:25:22','','0000-00-00 00:00:00','','0000-00-00 00:00:00',150,'0'),
(31,17,'需求变更控制','no','未涉及变更时可不进行','','','admin','2020-01-09 13:25:22','','0000-00-00 00:00:00','','0000-00-00 00:00:00',155,'0'),
(32,18,'概要设计','','','','','admin','2020-01-09 13:26:07','','0000-00-00 00:00:00','','0000-00-00 00:00:00',160,'0'),
(33,18,'评审《概要设计说明书》','','','','','admin','2020-01-09 13:26:07','','0000-00-00 00:00:00','','0000-00-00 00:00:00',165,'0'),
(34,18,'详细设计','','','','','admin','2020-01-09 13:26:07','','0000-00-00 00:00:00','','0000-00-00 00:00:00',170,'0'),
(35,18,'评审详细设计工作产品','','','','','admin','2020-01-09 13:26:07','','0000-00-00 00:00:00','','0000-00-00 00:00:00',175,'0'),
(42,19,'制定编码阶段计划','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',210,'0'),
(43,19,'构建数据库','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',215,'0'),
(44,19,'编码实现','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',220,'0'),
(45,19,'代码检查','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',225,'0'),
(46,19,'单元测试','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',230,'0'),
(47,19,'交叉单元测试','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',235,'0'),
(48,19,'系统集成','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',240,'0'),
(49,19,'编写集成测试用例','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',245,'0'),
(50,19,'评审集成测试用例','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',250,'0'),
(51,19,'集成测试','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',255,'0'),
(52,19,'缺陷管理','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',260,'0'),
(53,19,'编写支持文档','','','','','admin','2020-01-09 13:27:57','','0000-00-00 00:00:00','','0000-00-00 00:00:00',265,'0'),
(54,20,'制定《系统测试计划》','','','','','admin','2020-01-09 13:28:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',270,'0'),
(55,20,'评审《系统测试计划》','','','','','admin','2020-01-09 13:28:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',275,'0'),
(56,20,'编写《系统测试用例》','','','','','admin','2020-01-09 13:28:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',280,'0'),
(57,20,'评审《系统测试用例》','','','','','admin','2020-01-09 13:28:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',285,'0'),
(58,20,'执行系统测试','','','','','admin','2020-01-09 13:28:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',290,'0'),
(59,21,'验收准备','','','','','admin','2020-01-09 13:29:28','','0000-00-00 00:00:00','','0000-00-00 00:00:00',295,'0'),
(60,21,'产品打包','','','','','admin','2020-01-09 13:29:28','','0000-00-00 00:00:00','','0000-00-00 00:00:00',300,'0'),
(61,21,'内部培训','','','','','admin','2020-01-09 13:29:28','','0000-00-00 00:00:00','','0000-00-00 00:00:00',305,'0'),
(62,21,'现场安装调试','','','','','admin','2020-01-09 13:29:28','','0000-00-00 00:00:00','','0000-00-00 00:00:00',310,'0'),
(63,21,'用户使用培训','','','','','admin','2020-01-09 13:29:28','','0000-00-00 00:00:00','','0000-00-00 00:00:00',315,'0'),
(64,21,'试运行','','','','','admin','2020-01-09 13:29:28','','0000-00-00 00:00:00','','0000-00-00 00:00:00',320,'0'),
(65,21,'客户验收','','','','','admin','2020-01-09 13:29:28','','0000-00-00 00:00:00','','0000-00-00 00:00:00',325,'0'),
(66,22,'制定质量保证计划','','','','','admin','2020-01-09 13:38:58','','0000-00-00 00:00:00','','0000-00-00 00:00:00',330,'0'),
(67,22,'评审质量保证计划','','','','','admin','2020-01-09 13:38:58','','0000-00-00 00:00:00','','0000-00-00 00:00:00',335,'0'),
(68,22,'过程和产品质量检查','','','','','admin','2020-01-09 13:38:58','','0000-00-00 00:00:00','','0000-00-00 00:00:00',340,'0'),
(69,22,'问题跟踪处理','','','','','admin','2020-01-09 13:38:58','','0000-00-00 00:00:00','','0000-00-00 00:00:00',345,'0'),
(70,22,'质量保证总结报告','','','','','admin','2020-01-09 13:38:58','','0000-00-00 00:00:00','','0000-00-00 00:00:00',350,'0'),
(71,23,'组织及配置管理员移交工作','','','','','admin','2020-01-09 13:39:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',355,'0'),
(72,23,'制定《配置管理计划》','','','','','admin','2020-01-09 13:39:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',360,'0'),
(73,23,'建立和维护配置库','','','','','admin','2020-01-09 13:39:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',365,'0'),
(74,23,'配置项管理','','','','','admin','2020-01-09 13:39:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',370,'0'),
(75,23,'基线管理','','','','','admin','2020-01-09 13:39:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',375,'0'),
(76,23,'变更管理','','','','','admin','2020-01-09 13:39:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',380,'0'),
(77,23,'配置审计','','','','','admin','2020-01-09 13:39:25','','0000-00-00 00:00:00','','0000-00-00 00:00:00',385,'0'),
(78,24,'建立项目度量目标','','','','','admin','2020-01-09 13:40:05','','0000-00-00 00:00:00','','0000-00-00 00:00:00',390,'0'),
(79,24,'确定项目度量点','','','','','admin','2020-01-09 13:40:05','','0000-00-00 00:00:00','','0000-00-00 00:00:00',395,'0'),
(80,24,'制定度量分析计划','','','','','admin','2020-01-09 13:40:05','','0000-00-00 00:00:00','','0000-00-00 00:00:00',400,'0'),
(81,24,'收集和分析度量数据','','','','','admin','2020-01-09 13:40:05','','0000-00-00 00:00:00','','0000-00-00 00:00:00',405,'0'),
(82,24,'存储和通报度量分析结果','','','','','admin','2020-01-09 13:40:05','','0000-00-00 00:00:00','','0000-00-00 00:00:00',410,'0'),
(83,25,'原因分析与解决','','','','','admin','2020-01-09 13:40:15','','0000-00-00 00:00:00','','0000-00-00 00:00:00',415,'0'),
(84,26,'建立评估标准','','','','','admin','2020-01-09 13:40:35','','0000-00-00 00:00:00','','0000-00-00 00:00:00',420,'0'),
(85,26,'确定候选方案','','','','','admin','2020-01-09 13:40:35','','0000-00-00 00:00:00','','0000-00-00 00:00:00',425,'0'),
(86,26,'原因分析与解决','','','','','admin','2020-01-09 13:40:35','','0000-00-00 00:00:00','','0000-00-00 00:00:00',430,'0'),
(87,26,'确定评估方法','','','','','admin','2020-01-09 13:40:35','','0000-00-00 00:00:00','','0000-00-00 00:00:00',435,'0'),
(88,26,'评估候选方案','','','','','admin','2020-01-09 13:40:35','','0000-00-00 00:00:00','','0000-00-00 00:00:00',440,'0'),
(89,26,'做出决策','','','','','admin','2020-01-09 13:40:35','','0000-00-00 00:00:00','','0000-00-00 00:00:00',445,'0');

REPLACE INTO `zt_zoutput` (`id`, `activity`, `name`, `content`, `optional`, `status`, `createdBy`, `createdDate`, `editedBy`, `editedDate`, `order`, `deleted`) VALUES
(5,4,'《技术可行性分析报告》','','','','admin','2020-01-09 11:01:52','','0000-00-00 00:00:00',25,'0'),
(6,5,'《项目预算表》','','','','admin','2020-01-09 11:17:27','','0000-00-00 00:00:00',30,'0'),
(7,6,'《立项申请报告》','','','','admin','2020-01-09 11:17:50','','0000-00-00 00:00:00',35,'0'),
(8,7,'《项目投标书》','不涉及投标','','','admin','2020-01-09 11:18:12','','0000-00-00 00:00:00',40,'0'),
(9,8,'《项目估算报告》','','','','admin','2020-01-09 11:18:41','','0000-00-00 00:00:00',45,'0'),
(10,8,'《功能点估算》','','','','admin','2020-01-09 11:18:41','','0000-00-00 00:00:00',50,'0'),
(11,9,'《PDP说明》','','','','admin','2020-01-09 11:18:54','','0000-00-00 00:00:00',55,'0'),
(12,10,'《项目进度表》','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',60,'0'),
(13,10,'《项目计划》及其下属计划','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',65,'0'),
(14,10,'《风险管理计划及跟踪表》','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',70,'0'),
(15,10,'《项目资源计划》','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',75,'0'),
(16,10,'《干系人计划》','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',80,'0'),
(17,10,'《同行评审计划》','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',85,'0'),
(18,10,'《质量保证计划》','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',90,'0'),
(19,10,'《配置管理计划》','','','','admin','2020-01-09 11:19:46','','0000-00-00 00:00:00',95,'0'),
(20,11,'《同行评审通知》','','','','admin','2020-01-09 11:20:16','','0000-00-00 00:00:00',100,'0'),
(21,11,'《评审准备表》','','','','admin','2020-01-09 11:20:16','','0000-00-00 00:00:00',105,'0'),
(22,11,'《同行评审报告》','','','','admin','2020-01-09 11:20:17','','0000-00-00 00:00:00',110,'0'),
(23,12,'《里程碑报告》','','yes','','admin','2020-01-09 13:44:11','','0000-00-00 00:00:00',115,'0'),
(24,12,'《项目周报》','','yes','','admin','2020-01-09 13:44:11','','0000-00-00 00:00:00',120,'0'),
(25,13,'《项目周报》','','yes','','admin','2020-01-09 13:44:11','','0000-00-00 00:00:00',125,'0'),
(26,13,'《会议纪要》','','yes','','admin','2020-01-09 13:44:11','','0000-00-00 00:00:00',130,'0'),
(27,14,'《里程碑报告》','','yes','','admin','2020-01-09 13:44:11','','0000-00-00 00:00:00',135,'0'),
(28,14,'《里程碑会议纪要》','','yes','','admin','2020-01-09 13:44:11','','0000-00-00 00:00:00',140,'0'),
(29,15,'《计划变更申请》','','no','','admin','2020-01-09 13:44:11','','0000-00-00 00:00:00',145,'0'),
(30,16,'《风险管理计划及跟踪表》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',150,'0'),
(31,17,'《风险管理计划及跟踪表》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',155,'0'),
(32,17,'《风险管理报告》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',160,'0'),
(33,18,'《风险管理计划及跟踪表》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',165,'0'),
(34,19,'《异常处理申请表》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',170,'0'),
(35,19,'《风险管理计划及跟踪表》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',175,'0'),
(36,20,'《风险管理报告》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',180,'0'),
(37,20,'《风险管理计划及跟踪表》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',185,'0'),
(38,21,'《风险列表库》','','','','admin','2020-01-09 13:45:53','','0000-00-00 00:00:00',190,'0'),
(39,22,'《代码复用总结》','','','','admin','2020-01-09 13:46:26','','0000-00-00 00:00:00',195,'0'),
(40,24,'《结项报告》','','','','admin','2020-01-09 13:46:26','','0000-00-00 00:00:00',200,'0'),
(41,26,'《量化项目管理及跟踪计划》','','yes','','admin','2020-01-09 13:46:46','','0000-00-00 00:00:00',205,'0'),
(42,27,'《用户需求调查单》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',210,'0'),
(43,27,'《用户需求说明书》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',215,'0'),
(44,28,'《评审通知》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',220,'0'),
(45,28,'《同行评审准备表》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',225,'0'),
(46,28,'《同行评审报告》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',230,'0'),
(47,29,'《产品需求规格说明书》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',235,'0'),
(48,30,'《评审通知》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',240,'0'),
(49,30,' 《同行评审准备表》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',245,'0'),
(50,30,' 《同行评审报告》','','yes','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',250,'0'),
(51,31,'《需求变更记录》','','','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',255,'0'),
(52,31,'《用户需求说明书》','','','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',260,'0'),
(53,31,'《软件需求规格说明书》','','','','admin','2020-01-09 14:08:58','','0000-00-00 00:00:00',265,'0'),
(54,32,'《概要设计说明书》','','yes','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',270,'0'),
(55,33,'《评审通知》','','yes','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',275,'0'),
(56,33,'《同行评审准备表》','','yes','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',280,'0'),
(57,33,'《同行评审报告》','','yes','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',285,'0'),
(58,34,'《模块设计说明书》','','no','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',290,'0'),
(59,34,'《数据库设计说明书》','','yes','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',295,'0'),
(60,34,'《用户界面设计说明书》','','no','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',300,'0'),
(61,35,'《评审通知》','','no','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',305,'0'),
(62,35,'《同行评审准备表》','','no','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',310,'0'),
(63,35,'《同行评审报告》','','no','','admin','2020-01-09 14:20:09','','0000-00-00 00:00:00',315,'0'),
(64,42,'《实现与测试计划》','','yes','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',320,'0'),
(65,42,'《单板硬件调试和单元测试计划》','','yes','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',325,'0'),
(66,42,'《项目进度表》中“实现与测试”部分','','yes','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',330,'0'),
(67,43,'产品数据库','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',335,'0'),
(68,44,'模块代码','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',340,'0'),
(69,45,'《代码质量检查记录单》','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',345,'0'),
(70,46,'《单元测试缺陷统计分析报告》','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',350,'0'),
(71,47,'bugzilla缺陷记录','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',355,'0'),
(72,48,'《系统集成说明书》','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',360,'0'),
(73,49,'《集成测试用例》','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',365,'0'),
(74,50,'《评审通知》 ','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',370,'0'),
(75,50,'《同行评审准备表》 ','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',375,'0'),
(76,50,'《同行评审报告》','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',380,'0'),
(77,51,'《集成测试报告》','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',385,'0'),
(78,52,'bugzilla缺陷记录','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',390,'0'),
(79,52,'《用户操作手册》 ','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',395,'0'),
(80,52,'《安装手册》','','','','admin','2020-01-09 14:22:52','','0000-00-00 00:00:00',400,'0'),
(81,54,'《系统测试计划》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',405,'0'),
(82,55,'《评审通知》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',410,'0'),
(83,55,'《同行评审准备表》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',415,'0'),
(84,55,'《同行评审报告》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',420,'0'),
(85,56,'《系统测试用例》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',425,'0'),
(86,57,'《评审通知》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',430,'0'),
(87,57,'《同行评审准备表》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',435,'0'),
(88,57,'《同行评审报告》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',440,'0'),
(89,58,'bugzilla缺陷跟踪系统记录项','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',445,'0'),
(90,58,'《系统测试分析报告》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',450,'0'),
(91,58,'《缺陷统计分析报告》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',455,'0'),
(92,59,'《产品打包清单》','','yes','','admin','2020-01-09 14:25:16','','0000-00-00 00:00:00',460,'0'),
(93,60,'发布光盘、纸质支持文档','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',465,'0'),
(94,61,'《交接签收单》','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',470,'0'),
(95,62,'《工作联系单》','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',475,'0'),
(96,62,'《工作记录单》','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',480,'0'),
(97,62,'《交接签收单》','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',485,'0'),
(98,62,'《安装调试信息》','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',490,'0'),
(99,64,'bugzilla缺陷记录项','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',495,'0'),
(100,64,'会议纪要等文档','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',500,'0'),
(101,65,'《交接验收单》','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',505,'0'),
(102,65,'《客户验收报告》','','yes','','admin','2020-01-09 14:26:52','','0000-00-00 00:00:00',510,'0'),
(103,66,'初步《质量保证计划及跟踪表》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',515,'0'),
(104,67,'详细《质量保证计划及跟踪表》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',520,'0'),
(105,68,'《过程审计检查表》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',525,'0'),
(106,68,'《产品审计检查表》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',530,'0'),
(107,68,'《QA审计报告》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',535,'0'),
(108,68,'《QA问题报告》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',540,'0'),
(109,68,'《QA里程碑报告》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',545,'0'),
(110,68,'《QA周报》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',550,'0'),
(111,69,'《QA审计报告》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',555,'0'),
(112,69,'《QA问题报告》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',560,'0'),
(113,70,'《QA总结报告》','','yes','','admin','2020-01-09 14:28:18','','0000-00-00 00:00:00',565,'0'),
(114,72,'《配置管理计划》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',570,'0'),
(115,72,'《配置项计划及跟踪表》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',575,'0'),
(116,72,'《基线计划及跟踪表》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',580,'0'),
(117,73,'《配置库管理报告》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',585,'0'),
(118,74,'《配置项计划及跟踪表》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',590,'0'),
(119,75,'《基线计划及跟踪表》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',595,'0'),
(120,76,'《变更申请书》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',600,'0'),
(121,77,'《配置审计报告》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',605,'0'),
(122,80,'《度量分析计划》','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',610,'0'),
(123,82,'项目度量数据库','','yes','','admin','2020-01-09 14:55:08','','0000-00-00 00:00:00',615,'0'),
(124,86,'《量化项目管理及跟踪计划》','','no','','admin','2020-01-09 14:59:04','','0000-00-00 00:00:00',620,'0'),
(125,84,'《决策分析报告》的决策分析评估表','','no','','admin','2020-01-09 14:59:04','','0000-00-00 00:00:00',625,'0'),
(126,83,'《量化项目计划及跟踪表》','','no','','admin','2020-01-09 14:59:04','','0000-00-00 00:00:00',630,'0'),
(127,87,'《决策分析报告》的评分表','','no','','admin','2020-01-09 14:59:04','','0000-00-00 00:00:00',635,'0'),
(128,88,'《决策分析报告》的评分表','','no','','admin','2020-01-09 14:59:04','','0000-00-00 00:00:00',640,'0'),
(129,89,'《决策分析报告》','','no','','admin','2020-01-09 14:59:04','','0000-00-00 00:00:00',645,'0');

REPLACE INTO `zt_basicmeas` VALUES
(2,'scale','project','userRequest','项目用户需求初始规模','pgmURInitScale','故事点或功能点','CREATE FUNCTION qc_pgmurinitscale($project int) returns float (10,2)\r\nbegin\r\n    declare scale float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'URS\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_initscale($project, \'URS\',\'requestEst\') into scale__DELIMITER__\r\n    return scale__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nend','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目每个产品的第一个用户需求规格说明书基线版本的规模之和','从基线表中查询该项目下面每个产品的第一个用户需求规模说明书版本，然后查询对应的需求，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 14:19:41',10,'0'),
(3,'scale','project','softRequest','项目软件需求初始规模','pgmSRInitScale','故事点或功能点','CREATE FUNCTION qc_pgmsrinitscale($project int) returns float (10,2)\r\nbegin\r\n    declare scale float (10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'SRS\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_initscale($project, \'SRS\',\'storyEst\') into scale __DELIMITER__\r\n    return scale __DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nend','{\"$project\":{\"showName\":\"\\u6240\\u9700\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目每个产品的第一个软件需求规格说明书基线版本的规模之和','从基线表中查询该项目下面每个产品的第一个软件需求规模说明书版本，然后查询对应的需求，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 14:21:53',15,'0'),
(4,'scale','project','userRequest','项目用户需求实时规模','pgmURRealScale','故事点或功能点','CREATE FUNCTION `qc_pgmurrealscale`($project int) RETURNS float (10,2)\r\nBEGIN\r\n  declare totalEstimate float(10,2) default 0__DELIMITER__\r\n  select CAST(sum(estimate) as DECIMAL(10,2)) as estimate from zt_story where project=$project and type=\'requirement\' and deleted=\'0\' and closedReason not in (\'subdivided\', \'duplicate\', \'willnotdo\', \'cancel\', \'bydesign\') into totalEstimate__DELIMITER__\r\n  return totalEstimate__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目用户需求实际的规模','从需求表中查询该项目下的所有用户需求，对规模进行求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 14:22:17',20,'0'),
(5,'scale','project','softRequest','项目软件需求实时规模','pgmSRRealScale','故事点或功能点','CREATE FUNCTION `qc_pgmsrrealscale`($project int) RETURNS float (10,2)\r\nBEGIN\r\n  declare totalEstimate float (10,2) default 0__DELIMITER__\r\n  select CAST(sum(estimate) as DECIMAL(10,2)) as estimate from zt_story where id in (select story from zt_projectstory where project=$project) and type=\'story\' and deleted=\'0\' and closedReason not in (\'subdivided\', \'duplicate\', \'willnotdo\', \'cancel\', \'bydesign\') into totalEstimate__DELIMITER__\r\n  return totalEstimate__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":false,\"options\":\"project\",\"defaultValue\":\"702\"}}','项目软件需求实际的规模','从需求表中查询该项目下的所有软件需求，对规模进行求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 14:28:01',25,'0'),
(6,'scale','project','program','项目估算规模','pgmPlanScale','故事点或功能点','CREATE FUNCTION `qc_pgmplanscale`($project int) RETURNS float (10,2)\r\nBEGIN\r\n   declare programScale float (10,2) default 0__DELIMITER__\r\n   select `scale` from zt_workestimation where project = $project into programScale__DELIMITER__\r\n   return programScale__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目最初估算时估计的规模','从项目估算表里面查询项目的估算规模。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 14:26:01',30,'0'),
(8,'duration','project','stage','项目需求阶段计划天数','pgmRequestPlanDays','天','CREATE FUNCTION `qc_pgmrequestplandays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeplanneddays($project,\'request\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有需求阶段计划天数的和','从阶段表里面统计该项目下面所有类型为需求的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',40,'0'),
(9,'duration','project','stage','项目设计阶段计划天数','pgmDesigntPlanDays','天','CREATE FUNCTION `qc_pgmdesigntplandays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeplanneddays($project,\'design\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有设计阶段计划天数的和','从阶段表里面统计该项目下面所有类型为设计的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',45,'0'),
(10,'duration','project','stage','项目开发阶段计划天数','pgmDevelPlanDays','天','CREATE FUNCTION `qc_pgmdevelplandays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeplanneddays($project,\'dev\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有研发阶段计划天数的和','从阶段表里面统计该项目下面所有类型为开发的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',50,'0'),
(11,'duration','project','stage','项目测试阶段计划天数','pgmTestPlanDays','天','CREATE FUNCTION `qc_pgmtestplandays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeplanneddays($project,\'qa\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有测试阶段计划天数的和','从阶段表里面统计该项目下面所有类型为测试的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',55,'0'),
(12,'duration','project','stage','项目需求阶段实际天数','pgmRequestRealDays','天','CREATE FUNCTION `qc_pgmrequestrealdays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeactualdays($project,\'request\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有需求阶段实际天数的和','从阶段表里面统计该项目下面所有类型为需求的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',60,'0'),
(13,'duration','project','stage','项目设计阶段实际天数','pgmDesigntRealDays','天','CREATE FUNCTION `qc_pgmdesigntrealdays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeactualdays($project,\'design\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有设计阶段实际天数的和','从阶段表里面统计该项目下面所有类型为设计的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',65,'0'),
(14,'duration','project','stage','项目开发阶段实际天数','pgmDevelRealDays','天','CREATE FUNCTION `qc_pgmdevelrealdays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeactualdays($project,\'dev\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有研发阶段实际天数的和','从阶段表里面统计该项目下面所有类型为开发的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',70,'0'),
(15,'duration','project','stage','项目测试阶段实际天数','pgmTestRealDays','天','CREATE FUNCTION `qc_pgmtestrealdays`($project int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmspecifiedtypeactualdays($project,\'qa\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"3\"}}','项目下面所有测试阶段实际天数的和','从阶段表里面统计该项目下面所有类型为测试的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',75,'0'),
(26,'duration','product','stage','分产品需求阶段计划天数','prdRequestPlanDays','天','CREATE FUNCTION `qc_prdrequestplandays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageplannedduration($product, \'request\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"\"}}','产品下面所有需求阶段计划天数的和','从阶段表里面统计该产品在该项目下所有类型为需求的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',130,'0'),
(27,'duration','product','stage','分产品设计阶段计划天数','prdDesigntPlanDays','天','CREATE FUNCTION `qc_prddesigntplandays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageplannedduration($product, \'design\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"\"}}','产品下面所有设计阶段计划天数的和','从阶段表里面统计该产品在该项目下所有类型为设计的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',135,'0'),
(28,'duration','product','stage','分产品开发阶段计划天数','prdDevelPlanDays','天','CREATE FUNCTION `qc_prddevelplandays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageplannedduration($product, \'dev\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"1\"}}','产品下面所有研发阶段计划天数的和','从阶段表里面统计该产品在该项目下所有类型为开发的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',140,'0'),
(29,'duration','product','stage','分产品测试阶段计划天数','prdTestPlanDays','天','CREATE FUNCTION `qc_prdtestplandays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageplannedduration($product, \'qa\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"\"}}','产品下面所有测试阶段计划天数的和','从阶段表里面统计该产品在该项目下所有类型为测试的阶段的计划天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',145,'0'),
(30,'duration','product','stage','分产品需求阶段实际天数','prdRequestRealDays','天','CREATE FUNCTION `qc_prdrequestrealdays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageactualduration($product,\'request\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"\"}}','产品下面所有需求阶段实际天数的和','从阶段表里面统计该产品在该项目下所有类型为需求的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',150,'0'),
(31,'duration','product','stage','分产品设计阶段实际天数','prdDesigntRealDays','天','CREATE FUNCTION `qc_prddesigntrealdays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageactualduration($product, \'design\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"\"}}','产品下面所有设计阶段实际天数的和','从阶段表里面统计该产品在该项目下所有类型为设计的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',155,'0'),
(32,'duration','product','stage','分产品开发阶段实际天数','prdDevelRealDays','天','CREATE FUNCTION `qc_prddevelrealdays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageactualduration($product, \'dev\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"\"}}','产品下面所有研发阶段实际天数的和','从阶段表里面统计该产品在该项目下所有类型为开发的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',160,'0'),
(33,'duration','product','stage','分产品测试阶段实际天数','prdTestRealDays','天','CREATE FUNCTION `qc_prdtestrealdays`($product int) RETURNS int(10)\r\nBEGIN\r\n    select qc_pgmstageactualduration($product, \'qa\') as days into @days__DELIMITER__\r\n    return @days__DELIMITER__\r\nEND','{\"$product\":{\"showName\":\"\\u6240\\u5c5e\\u4ea7\\u54c1\",\"varName\":\"$product\",\"varType\":\"select\",\"options\":\"product\",\"defaultValue\":\"1\"}}','产品下面所有测试阶段实际天数的和','从阶段表里面统计该产品在该项目下所有类型为测试的阶段的实际天数，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','','0000-00-00 00:00:00',165,'0'),
(34,'workload','project','finance','项目任务实时预计工时数','pgmRealEstHours','小时','CREATE FUNCTION `qc_pgmrealesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    select sum(estimate) from zt_task where project=$project and parent >= 0 and status != \'cancel\' and deleted = \'0\' into @estimate__DELIMITER__\r\nreturn @estimate__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有任务的最初预计工时和','从任务表中查询该项目的所有任务，统计最初预计工>时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 19:51:39',170,'0'),
(35,'workload','project','finance','项目需求工作实时总预计工时数','pgmRequestRealEstHours','小时','CREATE FUNCTION `qc_pgmrequestrealesthours`($project int) RETURNS float (10,2)\r\nBEGIN\r\nreturn qc_pgmesthoursbytype($project, \'request\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有需求相关任务的最初预计工时和','从任务表中查询该项目所有任务类型为需求的任务，统计最初预计工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-23 13:49:17',175,'0'),
(36,'workload','project','finance','项目设计工作实时总预计工时数','pgmDesgignRealEstHours','小时','CREATE FUNCTION `qc_pgmdesgignrealesthours`($project int) RETURNS float (10,2)\r\nBEGIN\r\nreturn qc_pgmesthoursbytype($project, \'design\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有设计相关任务的最初预计工时和','从任务表中查询该项目所有任务类型为设计的任务，统计最初预计工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-23 13:45:32',180,'0'),
(37,'workload','project','finance','项目开发工作实时总预计工时数','pgmDevelRealEstHours','小时','CREATE FUNCTION `qc_pgmdevelrealesthours`($project int) RETURNS float (10,2)\r\nBEGIN\r\nreturn qc_pgmesthoursbytype($project, \'devel\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有开发相关任务的最初预计工时和','从任务表中查询该项目所有任务类型为开发的任务，统计最初预计工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-23 13:46:53',185,'0'),
(38,'workload','project','finance','项目测试工作实时总预计工时数','pgmTestRealEstHours','小时','CREATE FUNCTION `qc_pgmtestrealesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\nreturn qc_pgmesthoursbytype($project, \'test\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有测试相关任务的最初预计工时和','从任务表中查询该项目所有任务类型为测试的任务，统计最初预计工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-23 13:44:13',190,'0'),
(39,'workload','project','finance','项目任务实际消耗工时数','pgmRealHours','小时','CREATE FUNCTION `qc_pgmrealhours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n  select CAST(sum(consumed) as DECIMAL(10,2)) as consumed from zt_task where project=$project and parent >= 0 and status != \'cancel\' and deleted = \'0\'  into @consumed__DELIMITER__\r\n  return @consumed__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目下面所有任务的实际消耗工时和','从任务表中查询该项目的所有任务，统计实际消耗工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 19:49:32',195,'0'),
(40,'workload','project','finance','项目需求工作实际消耗工时数','pgmRequestRealHours','小时','CREATE FUNCTION `qc_pgmrequestrealhours`($project int) RETURNS float(10,2)\r\nBEGIN\r\nreturn qc_pgmrealhoursbytype($project, \'request\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有需求相关任务的实际消耗工时和','从任务表中查询该项目所有任务类型为需求的任务，统计实际消耗工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 19:49:03',200,'0'),
(41,'workload','project','finance','项目设计工作实际消耗工时数','pgmDesignRealHours','小时','CREATE FUNCTION `qc_pgmdesignrealhours`($project int) RETURNS float(10,2)\r\nBEGIN\r\nreturn qc_pgmrealhoursbytype($project, \'design\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有设计相关任务的实际消耗工时和','从任务表中查询该项目所有任务类型为设计的任务，统计实际消耗工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 19:48:35',205,'0'),
(42,'workload','project','finance','项目开发工作实际消耗工时数','pgmDevelRealHours','小时','CREATE FUNCTION `qc_pgmdevelrealhours`($project int) RETURNS float(10,2)\r\nBEGIN\r\nreturn qc_pgmrealhoursbytype($project, \'devel\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有开发相关任务的实际消耗工时和','从任务表中查询该项目所有任务类型为开发的任务，统计实际消耗工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 18:34:51',210,'0'),
(43,'workload','project','finance','项目测试工作实际消耗工时数','pgmTestRealHours','小时','CREATE FUNCTION `qc_pgmtestrealhours`($project int) RETURNS float(10, 2)\r\nBEGIN\r\nreturn qc_pgmrealhoursbytype($project, \'test\')__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目所有测试相关任务的实际消耗工时和','从任务表中查询该项目所有任务类型为测试的任务，统计实际消耗工时，求和。','crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','system','0000-00-00 00:00:00','admin','2020-07-07 18:09:01',215,'0'),
(44,'workload','project','finance','项目开发工作最初总预计工时数','pgmDevelFirstEstHours','小时','CREATE FUNCTION `qc_pgmdevelfirstesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getdevelfirstesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划第一个基线版本中所有开发相关工作最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-22 13:13:51','','0000-00-00 00:00:00',220,'0'),
(45,'workload','project','finance','项目设计工作最初总预计工时数','pgmDesignFirstEstHours','小时','CREATE FUNCTION `qc_pgmdesignfirstesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getdesignfirstesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划第一个基线版本中所有设计相关工作最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-22 16:33:20','admin','2020-07-23 10:31:23',225,'0'),
(46,'workload','project','finance','项目测试工作最初总预计工时数','pgmTestFirstEstHours','小时','CREATE FUNCTION `qc_pgmtestfirstesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_gettestfirstesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划第一个基线版本中所有测试相关工作最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 10:31:17','','0000-00-00 00:00:00',230,'0'),
(47,'workload','project','finance','项目需求工作最初总预计工时数','pgmRequestFirstEstHours','小时','CREATE FUNCTION `qc_pgmrequestfirstesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getstoryfirstesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划第一个基线版本中所有需求相关工作最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 10:53:09','','0000-00-00 00:00:00',235,'0'),
(48,'workload','project','finance','项目任务最初总预计工时数','pgmFirstEstHours','小时','CREATE FUNCTION `qc_pgmfirstesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getfirstesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划第一个基线版本中所有任务最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 13:06:59','','0000-00-00 00:00:00',240,'0'),
(49,'workload','project','finance','项目开发工作最终总预计工时数','pgmDevelLastEstHours','小时','CREATE FUNCTION `qc_pgmdevellastesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project, \'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getdevlastesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划最后一个基线版本中所有开发相关任务最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 13:41:38','','0000-00-00 00:00:00',245,'0'),
(50,'workload','project','finance','项目需求工作最终总预计工时数','pgmRequestLastEstHours','小时','CREATE FUNCTION `qc_pgmrequestlastesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project,\'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getrequestlastesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划最后一个基线版本中所有需求相关任务最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 14:00:58','','0000-00-00 00:00:00',250,'0'),
(51,'workload','project','finance','项目测试工作最终总预计工时数','pgmTestLastEstHours','小时','CREATE FUNCTION `qc_pgmtestlastesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project,\'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_gettestlastesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划最后一个基线版本中所有测试相关任务最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 14:10:12','','0000-00-00 00:00:00',255,'0'),
(52,'workload','project','finance','项目设计工作最终总预计工时数','pgmDesignLastEstHours','小时','CREATE FUNCTION `qc_pgmdesignlastesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project,\'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getdesignlastesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划最后一个基线版本中所有设计相关任务最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 14:33:00','','0000-00-00 00:00:00',260,'0'),
(53,'workload','project','finance','项目任务最终总预计工时数','pgmLastEstHours','小时','CREATE FUNCTION `qc_pgmlastesthours`($project int) RETURNS float(10,2)\r\nBEGIN\r\n    declare estimate float(10,2) default 0__DELIMITER__\r\n    declare inited int default 0__DELIMITER__\r\n    select qc_cminited($project,\'PP\') into inited__DELIMITER__\r\n    IF inited = 1 THEN\r\n    select qc_getlastesthours($project) into estimate__DELIMITER__\r\n    return estimate__DELIMITER__\r\n    ELSE \r\n    return 0__DELIMITER__\r\n    END IF__DELIMITER__\r\nEND','{\"$project\":{\"showName\":\"\\u6240\\u5c5e\\u9879\\u76ee\",\"varName\":\"$project\",\"varType\":\"select\",\"options\":\"project\",\"defaultValue\":\"\"}}','项目计划最后一个基线版本中所有任务最初预计工时和',NULL,'crontab','{\"week\":\"1,2,3,4,5,6,0\",\"type\":\"week\"}','00:00','','admin','2020-07-23 14:54:42','','0000-00-00 00:00:00',265,'0');

REPLACE INTO `zt_approvalflow` (`id`, `name`, `code`, `desc`, `version`, `createdBy`, `createdDate`, `type`, `deleted`) VALUES
(1, '最简审批', 'simple', '', 1, 'admin', '2022-04-29 08:46:40', 'project', 0);

REPLACE INTO `zt_approvalflowspec` (`id`, `flow`, `version`, `nodes`, `createdBy`, `createdDate`) VALUES
(1, 1, 1, '[{\"type\":\"start\",\"ccs\":[]},{\"id\":\"3ewcj92p55e\",\"type\":\"approval\",\"title\":\"审批\",\"reviewType\":\"manual\",\"multiple\":\"and\",\"agentType\":\"pass\",\"reviewers\":[{\"type\":\"select\"}],\"ccs\":[]},{\"type\":\"end\",\"ccs\":[]}]', 'admin', '2022-04-29 08:46:40');

REPLACE INTO `zt_cron` (`m`, `h`, `dom`, `mon`, `dow`, `command`, `remark`, `type`, `buildin`, `status`, `lastTime`) VALUES
('1','0','*','*','*','moduleName=weekly&methodName=computeWeekly','更新项目周报','system',0,'normal','2020-08-27 10:07:53'),
('1','0','*','*','*','moduleName=measurement&methodName=initCrontabQueue','初始化度量队列','zentao',0,'normal','2020-07-07 14:51:48'),
('*/5','*','*','*','*','moduleName=measurement&methodName=execCrontabQueue','执行度量队列','zentao',0,'running','2020-07-10 13:10:58');
