CREATE TABLE `zt_acl` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `account` varchar(30) NOT NULL DEFAULT '',
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` int unsigned NOT NULL DEFAULT 0,
  `type` varchar(40) NOT NULL DEFAULT 'whitelist',
  `source` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_action` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` int unsigned NOT NULL DEFAULT 0,
  `product` text DEFAULT NULL,
  `project` int unsigned NOT NULL DEFAULT 0,
  `execution` int unsigned NOT NULL DEFAULT 0,
  `actor` varchar(30) NOT NULL DEFAULT '',
  `action` varchar(80) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  `comment` text DEFAULT NULL,
  `files` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `read` tinyint unsigned NOT NULL DEFAULT 0,
  `efforted` tinyint unsigned NOT NULL DEFAULT 0,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  KEY `vision_date` (`vision`,`date`),
  KEY `actor` (`actor`),
  KEY `project` (`project`),
  KEY `execution` (`execution`),
  KEY `action` (`action`),
  KEY `objectID` (`objectID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_actionproduct` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `action` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `action_product` (`action`,`product`),
  KEY `product` (`product`)
) ENGINE=InnoDB;
CREATE TABLE `zt_actionrecent` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` int unsigned NOT NULL DEFAULT 0,
  `product` text DEFAULT NULL,
  `project` int unsigned NOT NULL DEFAULT 0,
  `execution` int unsigned NOT NULL DEFAULT 0,
  `actor` varchar(30) NOT NULL DEFAULT '',
  `action` varchar(80) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  `comment` text DEFAULT NULL,
  `files` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `read` tinyint unsigned NOT NULL DEFAULT 0,
  `efforted` tinyint unsigned NOT NULL DEFAULT 0,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  KEY `vision_date` (`vision`,`date`),
  KEY `actor` (`actor`),
  KEY `project` (`project`),
  KEY `execution` (`execution`),
  KEY `action` (`action`),
  KEY `objectID` (`objectID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_activity` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `process` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `optional` varchar(255) NOT NULL DEFAULT '',
  `tailorNorm` varchar(255) NOT NULL DEFAULT '',
  `content` mediumtext DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT 0,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_assistant` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `modelId` int unsigned NOT NULL DEFAULT 0,
  `desc` text DEFAULT NULL,
  `systemMessage` text DEFAULT NULL,
  `greetings` text DEFAULT NULL,
  `icon` varchar(30) NOT NULL DEFAULT 'coding-1',
  `enabled` tinyint unsigned NOT NULL DEFAULT 1,
  `createdDate` datetime DEFAULT NULL,
  `publishedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_knowledgeitem` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '知识库内容条目在禅道中的 ID',
  `lib` int unsigned NOT NULL DEFAULT 0 COMMENT '知识库内容条目所属知识库，对应 zt_ai_knowledgelib.id',
  `type` varchar(30) NOT NULL DEFAULT '' COMMENT '知识内容类型，目前包括：自定义文本（text）、文件（file）、禅道对象（object）',
  `file` int unsigned NOT NULL DEFAULT 0 COMMENT '文件类型条目对应的文件在禅道中的 ID，对应 zt_file.id',
  `objectType` varchar(30) NOT NULL DEFAULT '' COMMENT '禅道对象类型条目对应的禅道对象在禅道中的类型，例如 bug',
  `objectID` int unsigned NOT NULL DEFAULT 0 COMMENT '禅道对象类型条目对应的禅道对象在禅道中的 ID',
  `objectData` text DEFAULT NULL COMMENT '禅道对象数据，JSON 格式',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `content` text DEFAULT NULL COMMENT '知识库内容条目内容，如果是自定义文本，对应的是文本内容，如果是文件则为空，如果是禅道对象，则为禅道对象转为 Markdown 的内容',
  `contentType` varchar(10) NOT NULL DEFAULT 'markdown' COMMENT '内容类型',
  `attrs` text DEFAULT NULL COMMENT '知识库内容条目属性，JSON 格式',
  `createdBy` varchar(30) NOT NULL DEFAULT '' COMMENT '知识库内容条目创建者',
  `createdDate` datetime DEFAULT NULL COMMENT '知识库内容条目创建时间',
  `editedBy` varchar(30) NOT NULL DEFAULT '' COMMENT '知识库内容条目编辑者',
  `editedDate` datetime DEFAULT NULL COMMENT '知识库内容条目编辑时间',
  `externalID` varchar(255) NOT NULL DEFAULT '' COMMENT '知识库在外部服务中的 ID，在 ZAI 中对应 memory_content_id，如果没有 ID，表示未在外部服务中创建对应的内容条目',
  `syncedDate` datetime DEFAULT NULL COMMENT '上次成功同步时间，为空表示未同步',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0 COMMENT '是否已删除',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_knowledgelib` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd' COMMENT '所属界面',
  `type` varchar(30) NOT NULL DEFAULT '' COMMENT '知识库类型，目前包括：我的知识库（my）、组织知识库（team）',
  `importType` varchar(20) NOT NULL DEFAULT '' COMMENT '知识库导入类型，目前包括：从文档库导入（doclib）、从资产库导入（assetlib）',
  `importID` int unsigned NOT NULL DEFAULT 0 COMMENT '知识库导入类型条目对应的导入对象在禅道中的 ID，对应 zt_doclib.id 或 zt_assetlib.id',
  `name` varchar(255) NOT NULL DEFAULT '' COMMENT '知识库名称',
  `desc` text DEFAULT NULL COMMENT '知识库描述',
  `createdBy` varchar(30) NOT NULL DEFAULT '' COMMENT '创建者',
  `createdDate` datetime DEFAULT NULL COMMENT '创建时间',
  `editedBy` varchar(30) NOT NULL DEFAULT '' COMMENT '编辑者',
  `editedDate` datetime DEFAULT NULL COMMENT '编辑时间',
  `published` tinyint unsigned NOT NULL DEFAULT 0 COMMENT '是否已发布',
  `publishedDate` datetime DEFAULT NULL COMMENT '上次发布时间',
  `publishedBy` varchar(30) NOT NULL DEFAULT '' COMMENT '上次发布者',
  `acl` varchar(10) NOT NULL DEFAULT 'open' COMMENT '权限控制',
  `groups` varchar(255) NOT NULL DEFAULT '' COMMENT '权限控制组',
  `users` text DEFAULT NULL COMMENT '权限控制用户',
  `externalID` varchar(255) NOT NULL DEFAULT '' COMMENT '知识库在外部服务中的 ID，在 ZAI 中对应 memory_id，如果没有 ID，表示未在外部服务中创建对应知识库',
  `syncedBy` varchar(30) NOT NULL DEFAULT '' COMMENT '上次成功同步者',
  `syncedDate` datetime DEFAULT NULL COMMENT '上次成功同步时间，为空表示未同步',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0 COMMENT '是否已删除',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_message` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `appID` int unsigned NOT NULL DEFAULT 0,
  `user` int unsigned NOT NULL DEFAULT 0,
  `type` varchar(10) NOT NULL DEFAULT '',
  `content` text DEFAULT NULL,
  `createdDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_miniprogram` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `category` varchar(30) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `model` varchar(255) NOT NULL DEFAULT '',
  `knowledgeLib` varchar(255) NOT NULL DEFAULT '' COMMENT '关联的知识库ID列表',
  `icon` varchar(30) NOT NULL DEFAULT 'writinghand-7',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `published` tinyint unsigned NOT NULL DEFAULT 0,
  `publishedDate` datetime DEFAULT NULL,
  `prompt` text DEFAULT NULL,
  `builtIn` tinyint unsigned NOT NULL DEFAULT 0,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_miniprogramfield` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `appID` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(30) NOT NULL DEFAULT '',
  `type` varchar(10) NOT NULL DEFAULT 'text',
  `placeholder` text DEFAULT NULL,
  `options` text DEFAULT NULL,
  `required` tinyint unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_miniprogramstar` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `appID` int unsigned NOT NULL DEFAULT 0,
  `userID` int unsigned NOT NULL DEFAULT 0,
  `createdDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_appUser` (`appID`,`userID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_model` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL DEFAULT '',
  `vendor` varchar(20) NOT NULL DEFAULT '',
  `credentials` text DEFAULT NULL,
  `proxy` text DEFAULT NULL,
  `name` varchar(20) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `enabled` tinyint unsigned NOT NULL DEFAULT 1,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_prompt` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `model` varchar(255) NOT NULL DEFAULT '',
  `knowledgeLib` varchar(255) NOT NULL DEFAULT '' COMMENT '关联的知识库ID列表',
  `module` varchar(30) NOT NULL DEFAULT '',
  `source` text DEFAULT NULL,
  `targetForm` varchar(30) NOT NULL DEFAULT '',
  `purpose` text DEFAULT NULL,
  `elaboration` text DEFAULT NULL,
  `role` text DEFAULT NULL,
  `characterization` text DEFAULT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'draft',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_promptfield` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `appID` int unsigned NOT NULL COMMENT '所属 Prompt 的 ID，对应 zt_ai_prompt.id',
  `name` varchar(30) NOT NULL DEFAULT '' COMMENT '字段名称',
  `type` varchar(20) NOT NULL DEFAULT 'text' COMMENT '字段类型',
  `placeholder` text DEFAULT NULL COMMENT '输入提示',
  `options` text DEFAULT NULL COMMENT '选项列表，逗号分隔',
  `required` tinyint unsigned NOT NULL DEFAULT 1 COMMENT '是否必填',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_promptrole` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `model` varchar(255) NOT NULL DEFAULT '',
  `role` text DEFAULT NULL,
  `characterization` text DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_api` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `product` varchar(255) NOT NULL DEFAULT '',
  `lib` int unsigned NOT NULL DEFAULT 0,
  `module` int unsigned NOT NULL DEFAULT 0,
  `title` varchar(100) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `protocol` varchar(10) NOT NULL DEFAULT '',
  `method` varchar(10) NOT NULL DEFAULT '',
  `requestType` varchar(100) NOT NULL DEFAULT '',
  `responseType` varchar(100) NOT NULL DEFAULT '',
  `status` varchar(20) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `params` text DEFAULT NULL,
  `paramsExample` text DEFAULT NULL,
  `responseExample` text DEFAULT NULL,
  `response` text DEFAULT NULL,
  `commonParams` text DEFAULT NULL,
  `addedBy` varchar(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_api_lib_release` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `lib` int unsigned NOT NULL DEFAULT 0,
  `desc` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(255) NOT NULL DEFAULT '',
  `snap` mediumtext DEFAULT NULL,
  `addedBy` varchar(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_apispec` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `doc` int unsigned NOT NULL DEFAULT 0,
  `module` int unsigned NOT NULL DEFAULT 0,
  `title` varchar(100) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `protocol` varchar(10) NOT NULL DEFAULT '',
  `method` varchar(10) NOT NULL DEFAULT '',
  `requestType` varchar(100) NOT NULL DEFAULT '',
  `responseType` varchar(100) NOT NULL DEFAULT '',
  `status` varchar(20) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `params` text DEFAULT NULL,
  `paramsExample` text DEFAULT NULL,
  `responseExample` text DEFAULT NULL,
  `response` text DEFAULT NULL,
  `addedBy` varchar(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_apistruct` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `lib` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(30) NOT NULL DEFAULT '',
  `type` varchar(50) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `attribute` text DEFAULT NULL,
  `addedBy` varchar(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_apistruct_spec` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(50) NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `attribute` text DEFAULT NULL,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `addedBy` varchar(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_approval` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `flow` int unsigned NOT NULL DEFAULT 0,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` int unsigned NOT NULL DEFAULT 0,
  `nodes` mediumtext DEFAULT NULL,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `status` varchar(20) NOT NULL DEFAULT 'doing',
  `result` varchar(20) NOT NULL DEFAULT '',
  `extra` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_approvalflow` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `code` varchar(100) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `workflow` varchar(30) NOT NULL DEFAULT '',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_approvalflowobject` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `root` int unsigned NOT NULL DEFAULT 0,
  `flow` int unsigned NOT NULL DEFAULT 0,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` int unsigned NOT NULL DEFAULT 0,
  `extra` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_approvalflowspec` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `flow` int unsigned NOT NULL DEFAULT 0,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `nodes` mediumtext DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_approvalnode` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `approval` int unsigned NOT NULL DEFAULT 0,
  `type` varchar(10) NOT NULL DEFAULT 'review',
  `title` varchar(255) NOT NULL DEFAULT '',
  `account` varchar(30) NOT NULL DEFAULT '',
  `node` varchar(100) NOT NULL DEFAULT '',
  `reviewType` varchar(100) NOT NULL DEFAULT 'manual',
  `agentType` varchar(100) NOT NULL DEFAULT 'pass',
  `multipleType` varchar(10) NOT NULL DEFAULT 'and',
  `percent` tinyint unsigned NOT NULL DEFAULT 0,
  `needAll` tinyint unsigned NOT NULL DEFAULT 0,
  `solicit` tinyint unsigned NOT NULL DEFAULT 0,
  `prev` mediumtext DEFAULT NULL,
  `next` mediumtext DEFAULT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'wait',
  `result` varchar(10) NOT NULL DEFAULT '',
  `date` date DEFAULT NULL,
  `opinion` mediumtext DEFAULT NULL,
  `extra` mediumtext DEFAULT NULL,
  `revertTo` varchar(30) NOT NULL DEFAULT '',
  `forwardBy` varchar(30) NOT NULL DEFAULT '',
  `reviewedBy` varchar(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_reviewed_date` (`reviewedDate`)
) ENGINE=InnoDB;
CREATE TABLE `zt_approvalobject` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `approval` int unsigned NOT NULL DEFAULT 0,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` int unsigned NOT NULL DEFAULT 0,
  `reviewers` text DEFAULT NULL,
  `opinion` text DEFAULT NULL,
  `result` varchar(10) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `appliedBy` varchar(30) NOT NULL DEFAULT '',
  `appliedDate` datetime DEFAULT NULL,
  `desc` text DEFAULT NULL,
  `extra` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_approvalrole` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(30) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `users` longtext DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_artifactrepo` (
  `id` smallint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(45) NOT NULL DEFAULT '',
  `products` varchar(255) NOT NULL DEFAULT '',
  `serverID` smallint unsigned NOT NULL DEFAULT 0,
  `repoName` varchar(45) NOT NULL DEFAULT '',
  `format` varchar(10) NOT NULL DEFAULT '',
  `type` varchar(7) NOT NULL DEFAULT '',
  `status` varchar(10) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_assetlib` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_attend` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `account` varchar(30) NOT NULL DEFAULT '',
  `date` date DEFAULT NULL,
  `signIn` time DEFAULT NULL,
  `signOut` time DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `ip` varchar(100) NOT NULL DEFAULT '',
  `device` varchar(30) NOT NULL DEFAULT '',
  `client` varchar(20) NOT NULL DEFAULT '',
  `manualIn` time DEFAULT NULL,
  `manualOut` time DEFAULT NULL,
  `reason` varchar(30) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `reviewStatus` varchar(30) NOT NULL DEFAULT '',
  `reviewedBy` varchar(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `attend` (`date`,`account`),
  KEY `account` (`account`),
  KEY `date` (`date`),
  KEY `status` (`status`),
  KEY `reason` (`reason`),
  KEY `reviewStatus` (`reviewStatus`),
  KEY `reviewedBy` (`reviewedBy`)
) ENGINE=InnoDB;
CREATE TABLE `zt_attendstat` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `account` varchar(30) NOT NULL DEFAULT '',
  `month` varchar(10) NOT NULL DEFAULT '',
  `normal` decimal(12,2) NOT NULL DEFAULT 0.00,
  `late` decimal(12,2) NOT NULL DEFAULT 0.00,
  `early` decimal(12,2) NOT NULL DEFAULT 0.00,
  `absent` decimal(12,2) NOT NULL DEFAULT 0.00,
  `trip` decimal(12,2) NOT NULL DEFAULT 0.00,
  `egress` decimal(12,2) NOT NULL DEFAULT 0.00,
  `lieu` decimal(12,2) NOT NULL DEFAULT 0.00,
  `paidLeave` decimal(12,2) NOT NULL DEFAULT 0.00,
  `unpaidLeave` decimal(12,2) NOT NULL DEFAULT 0.00,
  `timeOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `restOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `holidayOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `deserve` decimal(12,2) NOT NULL DEFAULT 0.00,
  `actual` decimal(12,2) NOT NULL DEFAULT 0.00,
  `status` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `attend` (`month`,`account`),
  KEY `account` (`account`),
  KEY `month` (`month`),
  KEY `status` (`status`)
) ENGINE=InnoDB;
CREATE TABLE `zt_auditcl` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `model` varchar(30) NOT NULL DEFAULT 'waterfall',
  `practiceArea` varchar(30) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `objectType` varchar(10) NOT NULL DEFAULT '',
  `objectID` int unsigned NOT NULL DEFAULT 0,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_auditplan` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `dateType` varchar(30) NOT NULL DEFAULT '',
  `config` text DEFAULT NULL,
  `objectID` int unsigned NOT NULL DEFAULT 0,
  `objectType` varchar(10) NOT NULL DEFAULT '',
  `process` int unsigned NOT NULL DEFAULT 0,
  `processType` varchar(30) NOT NULL DEFAULT '',
  `checkDate` date DEFAULT NULL,
  `checkedBy` varchar(30) NOT NULL DEFAULT '',
  `realCheckDate` date DEFAULT NULL,
  `result` varchar(30) NOT NULL DEFAULT '',
  `project` int unsigned NOT NULL DEFAULT 0,
  `execution` int unsigned NOT NULL DEFAULT 0,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `checkBy` varchar(30) NOT NULL DEFAULT '',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_auditresult` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `auditplan` int unsigned NOT NULL DEFAULT 0,
  `listID` int unsigned NOT NULL DEFAULT 0,
  `result` varchar(30) NOT NULL DEFAULT '',
  `checkedBy` varchar(30) NOT NULL DEFAULT '',
  `checkedDate` date DEFAULT NULL,
  `comment` text DEFAULT NULL,
  `severity` tinyint unsigned NOT NULL DEFAULT 0,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_autocache` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(30) NOT NULL DEFAULT '',
  `fields` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `cache` (`code`,`fields`)
) ENGINE=InnoDB;
CREATE TABLE `zt_automation` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `node` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `scriptPath` varchar(255) NOT NULL DEFAULT '',
  `shell` mediumtext DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_basicmeas` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `purpose` varchar(50) NOT NULL DEFAULT '',
  `scope` varchar(30) NOT NULL DEFAULT '',
  `object` varchar(30) NOT NULL DEFAULT '',
  `name` varchar(90) NOT NULL DEFAULT '',
  `code` varchar(30) NOT NULL DEFAULT '',
  `unit` varchar(100) NOT NULL DEFAULT '',
  `configure` text DEFAULT NULL,
  `params` text DEFAULT NULL,
  `definition` text DEFAULT NULL,
  `source` varchar(255) NOT NULL DEFAULT '',
  `collectType` varchar(30) NOT NULL DEFAULT '',
  `collectConf` text DEFAULT NULL,
  `execTime` varchar(30) NOT NULL DEFAULT '',
  `collectedBy` varchar(10) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT 0,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB;
CREATE TABLE `zt_block` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `account` varchar(30) NOT NULL DEFAULT '',
  `dashboard` varchar(20) NOT NULL DEFAULT '',
  `module` varchar(20) NOT NULL DEFAULT '',
  `title` varchar(100) NOT NULL DEFAULT '',
  `block` varchar(30) NOT NULL DEFAULT '',
  `code` varchar(30) NOT NULL DEFAULT '',
  `width` tinyint unsigned NOT NULL DEFAULT 1,
  `height` smallint unsigned NOT NULL DEFAULT 3,
  `left` tinyint unsigned NOT NULL DEFAULT 0,
  `top` smallint unsigned NOT NULL DEFAULT 0,
  `params` text DEFAULT NULL,
  `hidden` tinyint unsigned NOT NULL DEFAULT 0,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  KEY `account` (`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_branch` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `product` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `default` tinyint unsigned NOT NULL DEFAULT 0,
  `status` varchar(10) NOT NULL DEFAULT 'active',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `closedDate` datetime DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT 0,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `product` (`product`)
) ENGINE=InnoDB;
CREATE TABLE `zt_budget` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `stage` varchar(30) NOT NULL DEFAULT '',
  `subject` int unsigned NOT NULL DEFAULT 0,
  `amount` varchar(30) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_bug` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `injection` varchar(30) NOT NULL DEFAULT '',
  `identify` varchar(30) NOT NULL DEFAULT '',
  `branch` int unsigned NOT NULL DEFAULT 0,
  `module` int unsigned NOT NULL DEFAULT 0,
  `execution` int unsigned NOT NULL DEFAULT 0,
  `plan` int unsigned NOT NULL DEFAULT 0,
  `story` int unsigned NOT NULL DEFAULT 0,
  `storyVersion` smallint unsigned NOT NULL DEFAULT 1,
  `task` int unsigned NOT NULL DEFAULT 0,
  `toTask` int unsigned NOT NULL DEFAULT 0,
  `toStory` int unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `severity` tinyint unsigned NOT NULL DEFAULT 0,
  `pri` tinyint unsigned NOT NULL DEFAULT 0,
  `type` varchar(30) NOT NULL DEFAULT '',
  `os` varchar(255) NOT NULL DEFAULT '',
  `browser` varchar(255) NOT NULL DEFAULT '',
  `hardware` varchar(30) NOT NULL DEFAULT '',
  `found` varchar(30) NOT NULL DEFAULT '',
  `steps` mediumtext DEFAULT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'active',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `color` char(7) NOT NULL DEFAULT '',
  `confirmed` tinyint unsigned NOT NULL DEFAULT 0,
  `activatedCount` smallint unsigned NOT NULL DEFAULT 0,
  `activatedDate` datetime DEFAULT NULL,
  `feedbackBy` varchar(100) NOT NULL DEFAULT '',
  `notifyEmail` varchar(100) NOT NULL DEFAULT '',
  `mailto` text DEFAULT NULL,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `openedBuild` varchar(255) NOT NULL DEFAULT '',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `resolvedBy` varchar(30) NOT NULL DEFAULT '',
  `resolution` varchar(30) NOT NULL DEFAULT '',
  `resolvedBuild` varchar(30) NOT NULL DEFAULT '',
  `resolvedDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `duplicateBug` int unsigned NOT NULL DEFAULT 0,
  `relatedBug` varchar(255) NOT NULL DEFAULT '',
  `case` int unsigned NOT NULL DEFAULT 0,
  `caseVersion` smallint unsigned NOT NULL DEFAULT 1,
  `feedback` int unsigned NOT NULL DEFAULT 0,
  `result` int unsigned NOT NULL DEFAULT 0,
  `repo` int unsigned NOT NULL DEFAULT 0,
  `mr` int unsigned NOT NULL DEFAULT 0,
  `entry` text DEFAULT NULL,
  `lines` varchar(10) NOT NULL DEFAULT '',
  `v1` varchar(255) NOT NULL DEFAULT '',
  `v2` varchar(255) NOT NULL DEFAULT '',
  `repoType` varchar(30) NOT NULL DEFAULT '',
  `issueKey` varchar(50) NOT NULL DEFAULT '',
  `testtask` int unsigned NOT NULL DEFAULT 0,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`),
  KEY `status` (`status`),
  KEY `plan` (`plan`),
  KEY `story` (`story`),
  KEY `case` (`case`),
  KEY `toStory` (`toStory`),
  KEY `result` (`result`),
  KEY `assignedTo` (`assignedTo`),
  KEY `deleted` (`deleted`),
  KEY `project` (`project`),
  KEY `product_status_deleted` (`product`,`status`,`deleted`),
  KEY `idx_repo` (`repo`),
  KEY `feedback` (`feedback`)
) ENGINE=InnoDB;
CREATE TABLE `zt_build` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `branch` varchar(255) NOT NULL DEFAULT '0',
  `execution` int unsigned NOT NULL DEFAULT 0,
  `builds` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(150) NOT NULL DEFAULT '',
  `system` int unsigned NOT NULL DEFAULT 0,
  `scmPath` varchar(255) NOT NULL DEFAULT '',
  `filePath` varchar(255) NOT NULL DEFAULT '',
  `date` date DEFAULT NULL,
  `stories` text DEFAULT NULL,
  `bugs` text DEFAULT NULL,
  `artifactRepoID` int unsigned NOT NULL DEFAULT 0,
  `builder` varchar(30) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`),
  KEY `idx_system` (`system`)
) ENGINE=InnoDB;
CREATE TABLE `zt_burn` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `execution` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `task` int unsigned NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `estimate` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `left` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `consumed` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `storyPoint` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`),
  UNIQUE KEY `execution_task` (`execution`,`date`,`task`)
) ENGINE=InnoDB;
CREATE TABLE `zt_case` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `execution` int unsigned NOT NULL DEFAULT 0,
  `branch` int unsigned NOT NULL DEFAULT 0,
  `lib` int unsigned NOT NULL DEFAULT 0,
  `module` int unsigned NOT NULL DEFAULT 0,
  `path` int unsigned NOT NULL DEFAULT 0,
  `story` int unsigned NOT NULL DEFAULT 0,
  `storyVersion` smallint unsigned NOT NULL DEFAULT 1,
  `title` varchar(255) NOT NULL DEFAULT '',
  `precondition` text DEFAULT NULL,
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `pri` tinyint unsigned NOT NULL DEFAULT 3,
  `type` varchar(30) NOT NULL DEFAULT '',
  `auto` varchar(10) NOT NULL DEFAULT 'no',
  `frame` varchar(10) NOT NULL DEFAULT '',
  `stage` varchar(255) NOT NULL DEFAULT '',
  `howRun` varchar(30) NOT NULL DEFAULT '',
  `script` longtext DEFAULT NULL,
  `scriptedBy` varchar(30) NOT NULL DEFAULT '',
  `scriptedDate` datetime DEFAULT NULL,
  `scriptStatus` varchar(30) NOT NULL DEFAULT '',
  `scriptLocation` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `color` char(7) NOT NULL DEFAULT '',
  `frequency` tinyint unsigned NOT NULL DEFAULT 1,
  `order` int unsigned NOT NULL DEFAULT 0,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `reviewedBy` varchar(255) NOT NULL DEFAULT '',
  `reviewedDate` date DEFAULT NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `linkCase` varchar(255) NOT NULL DEFAULT '',
  `fromBug` int unsigned NOT NULL DEFAULT 0,
  `fromCaseID` int unsigned NOT NULL DEFAULT 0,
  `fromCaseVersion` smallint unsigned NOT NULL DEFAULT 1,
  `lastRunner` varchar(30) NOT NULL DEFAULT '',
  `lastRunDate` datetime DEFAULT NULL,
  `lastRunResult` varchar(30) NOT NULL DEFAULT '',
  `scene` int unsigned NOT NULL DEFAULT 0,
  `sort` int unsigned NOT NULL DEFAULT 0,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `story` (`story`),
  KEY `fromBug` (`fromBug`),
  KEY `module` (`module`),
  KEY `scene` (`scene`)
) ENGINE=InnoDB;
CREATE TABLE `zt_casespec` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `case` int unsigned NOT NULL DEFAULT 0,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `title` varchar(255) NOT NULL DEFAULT '',
  `precondition` text DEFAULT NULL,
  `files` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `case` (`case`,`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_casestep` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `parent` int unsigned NOT NULL DEFAULT 0,
  `case` int unsigned NOT NULL DEFAULT 0,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `type` varchar(10) NOT NULL DEFAULT 'step',
  `desc` text DEFAULT NULL,
  `expect` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `case` (`case`),
  KEY `version` (`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_cfd` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `execution` int unsigned NOT NULL DEFAULT 0,
  `type` varchar(30) NOT NULL DEFAULT '',
  `name` varchar(30) NOT NULL DEFAULT '',
  `count` smallint unsigned NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `execution_type_name_date` (`execution`,`type`,`name`,`date`)
) ENGINE=InnoDB;
CREATE TABLE `zt_chart` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `code` varchar(255) NOT NULL DEFAULT '',
  `driver` varchar(10) NOT NULL DEFAULT 'mysql',
  `mode` varchar(10) NOT NULL DEFAULT 'builder',
  `dimension` int unsigned NOT NULL DEFAULT 0,
  `type` varchar(30) NOT NULL DEFAULT '',
  `group` varchar(255) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `whitelist` text DEFAULT NULL,
  `settings` mediumtext DEFAULT NULL,
  `filters` mediumtext DEFAULT NULL,
  `step` tinyint unsigned NOT NULL DEFAULT 0,
  `fields` mediumtext DEFAULT NULL,
  `langs` text DEFAULT NULL,
  `sql` mediumtext DEFAULT NULL,
  `version` varchar(10) NOT NULL DEFAULT '1',
  `stage` varchar(10) NOT NULL DEFAULT 'draft',
  `builtin` tinyint unsigned NOT NULL DEFAULT 0,
  `objects` mediumtext DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_charter` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `level` varchar(255) NOT NULL DEFAULT '',
  `category` varchar(30) NOT NULL DEFAULT '',
  `market` varchar(30) NOT NULL DEFAULT '',
  `check` tinyint unsigned NOT NULL DEFAULT 0,
  `appliedBy` varchar(30) NOT NULL DEFAULT '',
  `appliedDate` datetime DEFAULT NULL,
  `appliedReviewer` text DEFAULT NULL,
  `budget` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `budgetUnit` varchar(30) NOT NULL DEFAULT 'CNY',
  `product` text DEFAULT NULL,
  `roadmap` text DEFAULT NULL,
  `plan` text DEFAULT NULL,
  `type` varchar(30) NOT NULL DEFAULT 'roadmap',
  `filesConfig` text DEFAULT NULL,
  `spec` mediumtext DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `charterFiles` text DEFAULT NULL,
  `completionFiles` text DEFAULT NULL,
  `canceledFiles` text DEFAULT NULL,
  `prevCanceledStatus` varchar(30) NOT NULL DEFAULT '',
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `closedReason` varchar(255) NOT NULL DEFAULT '',
  `activatedBy` varchar(30) NOT NULL DEFAULT '',
  `activatedDate` datetime DEFAULT NULL,
  `activatedReviewer` text DEFAULT NULL,
  `reviewedBy` varchar(255) NOT NULL DEFAULT '',
  `reviewedResult` varchar(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  `reviewStatus` varchar(30) NOT NULL DEFAULT 'wait',
  `completedBy` varchar(30) NOT NULL DEFAULT '',
  `completedDate` datetime DEFAULT NULL,
  `completedReviewer` text DEFAULT NULL,
  `canceledBy` varchar(30) NOT NULL DEFAULT '',
  `canceledDate` datetime DEFAULT NULL,
  `canceledReviewer` text DEFAULT NULL,
  `meetingDate` date DEFAULT NULL,
  `meetingLocation` varchar(255) NOT NULL DEFAULT '',
  `meetingMinutes` mediumtext DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_charterproduct` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `charter` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `branch` int unsigned NOT NULL DEFAULT 0,
  `plan` varchar(255) NOT NULL DEFAULT '',
  `roadmap` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `charter_product` (`charter`,`product`,`branch`)
) ENGINE=InnoDB;
CREATE TABLE `zt_cmcl` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL DEFAULT '',
  `projectType` varchar(255) NOT NULL DEFAULT '',
  `title` int unsigned NOT NULL DEFAULT 0,
  `contents` text DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `order` int unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_company` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) NOT NULL DEFAULT '',
  `phone` varchar(20) NOT NULL DEFAULT '',
  `fax` varchar(20) NOT NULL DEFAULT '',
  `address` varchar(120) NOT NULL DEFAULT '',
  `zipcode` varchar(10) NOT NULL DEFAULT '',
  `website` varchar(120) NOT NULL DEFAULT '',
  `backyard` varchar(120) NOT NULL DEFAULT '',
  `guest` tinyint unsigned NOT NULL DEFAULT 0,
  `admins` varchar(255) NOT NULL DEFAULT '',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_compile` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `job` int unsigned NOT NULL DEFAULT 0,
  `queue` int unsigned NOT NULL DEFAULT 0,
  `status` varchar(100) NOT NULL DEFAULT '',
  `branch` varchar(255) NOT NULL DEFAULT '',
  `logs` longtext DEFAULT NULL,
  `atTime` varchar(10) NOT NULL DEFAULT '',
  `testtask` int unsigned NOT NULL DEFAULT 0,
  `tag` varchar(255) NOT NULL DEFAULT '',
  `times` tinyint unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `updateDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_created_status` (`createdDate`,`status`,`deleted`)
) ENGINE=InnoDB;
CREATE TABLE `zt_config` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `vision` varchar(10) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `section` varchar(30) NOT NULL DEFAULT '',
  `key` varchar(30) NOT NULL DEFAULT '',
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`vision`,`owner`,`module`,`section`,`key`),
  KEY `vision` (`vision`),
  KEY `owner` (`owner`),
  KEY `module` (`module`),
  KEY `key` (`key`)
) ENGINE=InnoDB;
CREATE TABLE `zt_cron` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `m` varchar(20) NOT NULL DEFAULT '',
  `h` varchar(20) NOT NULL DEFAULT '',
  `dom` varchar(20) NOT NULL DEFAULT '',
  `mon` varchar(20) NOT NULL DEFAULT '',
  `dow` varchar(20) NOT NULL DEFAULT '',
  `command` text DEFAULT NULL,
  `remark` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT '',
  `buildin` tinyint unsigned NOT NULL DEFAULT 0,
  `status` varchar(20) NOT NULL DEFAULT '',
  `lastTime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lastTime` (`lastTime`)
) ENGINE=InnoDB;
CREATE TABLE `zt_dataset` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(155) NOT NULL DEFAULT '',
  `sql` text DEFAULT NULL,
  `fields` mediumtext DEFAULT NULL,
  `objects` mediumtext DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_dataview` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `group` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(155) NOT NULL DEFAULT '',
  `code` varchar(50) NOT NULL DEFAULT '',
  `mode` varchar(50) NOT NULL DEFAULT 'builder',
  `driver` varchar(10) NOT NULL DEFAULT 'mysql',
  `view` varchar(57) NOT NULL DEFAULT '',
  `sql` text DEFAULT NULL,
  `fields` text DEFAULT NULL,
  `langs` text DEFAULT NULL,
  `objects` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_deliverable` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `method` varchar(30) NOT NULL DEFAULT '',
  `model` text DEFAULT NULL,
  `type` varchar(10) NOT NULL DEFAULT 'file',
  `desc` text DEFAULT NULL,
  `files` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_demand` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pool` int unsigned NOT NULL DEFAULT 0,
  `module` int unsigned NOT NULL DEFAULT 0,
  `product` varchar(255) NOT NULL DEFAULT '',
  `parent` int NOT NULL DEFAULT 0,
  `pri` tinyint unsigned NOT NULL DEFAULT 3,
  `category` varchar(30) NOT NULL DEFAULT '',
  `source` varchar(30) NOT NULL DEFAULT '',
  `sourceNote` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `feedbackedBy` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `reviewedBy` text DEFAULT NULL,
  `reviewedDate` datetime DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `stage` varchar(20) NOT NULL DEFAULT 'wait',
  `duration` varchar(30) NOT NULL DEFAULT '',
  `BSA` varchar(30) NOT NULL DEFAULT '',
  `story` int unsigned NOT NULL DEFAULT 0,
  `roadmap` int unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `mailto` text DEFAULT NULL,
  `duplicateDemand` int unsigned NOT NULL DEFAULT 0,
  `childDemands` varchar(255) NOT NULL DEFAULT '',
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `parentVersion` smallint unsigned NOT NULL DEFAULT 1,
  `color` char(7) NOT NULL DEFAULT '',
  `changedBy` varchar(30) NOT NULL DEFAULT '',
  `changedDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `closedReason` varchar(30) NOT NULL DEFAULT '',
  `submitedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `activatedDate` datetime DEFAULT NULL,
  `distributedBy` varchar(30) NOT NULL DEFAULT '',
  `distributedDate` datetime DEFAULT NULL,
  `feedback` int unsigned NOT NULL DEFAULT 0,
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `vision` varchar(10) NOT NULL DEFAULT 'or',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_demandpool` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `products` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `owner` text DEFAULT NULL,
  `reviewer` text DEFAULT NULL,
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_demandreview` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `demand` int unsigned NOT NULL DEFAULT 0,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `reviewer` varchar(30) NOT NULL DEFAULT '',
  `result` varchar(30) NOT NULL DEFAULT '',
  `reviewDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `demand` (`demand`,`version`,`reviewer`)
) ENGINE=InnoDB;
CREATE TABLE `zt_demandspec` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `demand` int unsigned NOT NULL DEFAULT 0,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `title` varchar(255) NOT NULL DEFAULT '',
  `spec` mediumtext DEFAULT NULL,
  `verify` mediumtext DEFAULT NULL,
  `files` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `demand` (`demand`,`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_deploy` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `begin` datetime DEFAULT NULL,
  `end` datetime DEFAULT NULL,
  `estimate` datetime DEFAULT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `host` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `status` varchar(20) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `members` text DEFAULT NULL,
  `notify` text DEFAULT NULL,
  `cases` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `result` varchar(20) NOT NULL DEFAULT '',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_deployproduct` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `deploy` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `release` int unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `deploy_product_release` (`deploy`,`product`,`release`)
) ENGINE=InnoDB;
CREATE TABLE `zt_deploystep` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `deploy` int unsigned NOT NULL DEFAULT 0,
  `parent` int unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `stage` varchar(30) NOT NULL DEFAULT '',
  `content` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `finishedBy` varchar(30) NOT NULL DEFAULT '',
  `finishedDate` datetime DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_dept` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '',
  `parent` int unsigned NOT NULL DEFAULT 0,
  `path` varchar(255) NOT NULL DEFAULT '',
  `grade` tinyint unsigned NOT NULL DEFAULT 0,
  `order` int unsigned NOT NULL DEFAULT 0,
  `manager` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `path` (`path`)
) ENGINE=InnoDB;
CREATE TABLE `zt_design` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `commit` text DEFAULT NULL,
  `commitedBy` varchar(30) NOT NULL DEFAULT '',
  `execution` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `story` int unsigned NOT NULL DEFAULT 0,
  `storyVersion` smallint unsigned NOT NULL DEFAULT 1,
  `docs` text DEFAULT NULL,
  `docVersions` text DEFAULT NULL,
  `desc` mediumtext DEFAULT NULL,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `type` varchar(30) NOT NULL DEFAULT '',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_designspec` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `design` int unsigned NOT NULL DEFAULT 0,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `files` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `design` (`design`,`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_dimension` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL DEFAULT '',
  `code` varchar(45) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `whitelist` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `code` (`code`)
) ENGINE=InnoDB;
CREATE TABLE `zt_doc` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `execution` int unsigned NOT NULL DEFAULT 0,
  `lib` int unsigned NOT NULL DEFAULT 0,
  `template` varchar(30) NOT NULL DEFAULT '',
  `templateType` varchar(30) NOT NULL DEFAULT '',
  `templateDesc` text DEFAULT NULL,
  `objects` text DEFAULT NULL,
  `chapterType` varchar(30) NOT NULL DEFAULT '',
  `cycle` varchar(10) NOT NULL DEFAULT '',
  `cycleConfig` text DEFAULT NULL,
  `module` int unsigned NOT NULL DEFAULT 0,
  `reportModule` varchar(20) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT 'normal',
  `parent` int unsigned NOT NULL DEFAULT 0,
  `path` varchar(255) NOT NULL DEFAULT '',
  `grade` tinyint unsigned NOT NULL DEFAULT 0,
  `order` int unsigned NOT NULL DEFAULT 0,
  `views` smallint unsigned NOT NULL DEFAULT 0,
  `assetLib` int unsigned NOT NULL DEFAULT 0,
  `assetLibType` varchar(30) NOT NULL DEFAULT '',
  `from` int unsigned NOT NULL DEFAULT 0,
  `fromVersion` smallint unsigned NOT NULL DEFAULT 1,
  `draft` longtext DEFAULT NULL,
  `collects` smallint unsigned NOT NULL DEFAULT 0,
  `weeklyDate` char(8) NOT NULL DEFAULT '',
  `addedBy` varchar(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `approvedDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `editingDate` text DEFAULT NULL,
  `editedList` text DEFAULT NULL,
  `mailto` text DEFAULT NULL,
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `groups` varchar(255) NOT NULL DEFAULT '',
  `users` text DEFAULT NULL,
  `readGroups` varchar(255) NOT NULL DEFAULT '',
  `readUsers` text DEFAULT NULL,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `builtIn` tinyint unsigned NOT NULL DEFAULT 0,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`),
  KEY `lib` (`lib`),
  KEY `templateType` (`templateType`)
) ENGINE=InnoDB;
CREATE TABLE `zt_docaction` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `doc` int unsigned NOT NULL DEFAULT 0,
  `action` varchar(80) NOT NULL DEFAULT '',
  `actor` varchar(30) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `doc` (`doc`),
  KEY `actor` (`actor`)
) ENGINE=InnoDB;
CREATE TABLE `zt_docblock` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `doc` int unsigned NOT NULL DEFAULT 0,
  `type` varchar(50) NOT NULL DEFAULT '',
  `settings` text DEFAULT NULL,
  `content` mediumtext DEFAULT NULL,
  `extra` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_doc` (`doc`)
) ENGINE=InnoDB;
CREATE TABLE `zt_doccontent` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `doc` int unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `digest` varchar(255) NOT NULL DEFAULT '',
  `content` longtext DEFAULT NULL,
  `rawContent` longtext DEFAULT NULL,
  `files` text DEFAULT NULL,
  `type` varchar(10) NOT NULL DEFAULT '',
  `addedBy` varchar(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `fromVersion` smallint unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  UNIQUE KEY `doc_version` (`doc`,`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_doclib` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL DEFAULT '',
  `parent` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `project` int unsigned NOT NULL DEFAULT 0,
  `execution` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(60) NOT NULL DEFAULT '',
  `baseUrl` varchar(255) NOT NULL DEFAULT '',
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `groups` varchar(255) NOT NULL DEFAULT '',
  `users` text DEFAULT NULL,
  `main` tinyint unsigned NOT NULL DEFAULT 0,
  `collector` text DEFAULT NULL,
  `desc` mediumtext DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT 0,
  `addedBy` varchar(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  `archived` tinyint unsigned NOT NULL DEFAULT 0,
  `orderBy` varchar(30) NOT NULL DEFAULT 'id_asc',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`)
) ENGINE=InnoDB;
CREATE TABLE `zt_duckdbqueue` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `object` varchar(255) NOT NULL DEFAULT '',
  `updatedTime` datetime DEFAULT NULL,
  `syncTime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`object`)
) ENGINE=InnoDB;
CREATE TABLE `zt_durationestimation` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `stage` int unsigned NOT NULL DEFAULT 0,
  `workload` varchar(255) NOT NULL DEFAULT '',
  `worktimeRate` varchar(255) NOT NULL DEFAULT '',
  `people` varchar(255) NOT NULL DEFAULT '',
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_effort` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` int unsigned NOT NULL DEFAULT 0,
  `product` text DEFAULT NULL,
  `project` int unsigned NOT NULL DEFAULT 0,
  `execution` int unsigned NOT NULL DEFAULT 0,
  `account` varchar(30) NOT NULL DEFAULT '',
  `work` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  `left` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `consumed` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `begin` char(4) NOT NULL DEFAULT '',
  `end` char(4) NOT NULL DEFAULT '',
  `extra` text DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT 0,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `execution` (`execution`),
  KEY `objectID` (`objectID`),
  KEY `date` (`date`),
  KEY `account` (`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_entry` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `account` varchar(30) NOT NULL DEFAULT '',
  `code` varchar(20) NOT NULL DEFAULT '',
  `key` char(32) NOT NULL DEFAULT '',
  `freePasswd` tinyint unsigned NOT NULL DEFAULT 0,
  `ip` varchar(100) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `calledTime` int unsigned NOT NULL DEFAULT 0,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_expect` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `userID` int unsigned NOT NULL DEFAULT 0,
  `project` int unsigned NOT NULL DEFAULT 0,
  `expect` text DEFAULT NULL,
  `progress` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_extension` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL DEFAULT '',
  `code` varchar(30) NOT NULL DEFAULT '',
  `version` varchar(50) NOT NULL DEFAULT '',
  `author` varchar(100) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `license` text DEFAULT NULL,
  `type` varchar(20) NOT NULL DEFAULT 'extension',
  `site` varchar(150) NOT NULL DEFAULT '',
  `zentaoCompatible` text DEFAULT NULL,
  `installedTime` datetime DEFAULT NULL,
  `depends` varchar(100) NOT NULL DEFAULT '',
  `dirs` mediumtext DEFAULT NULL,
  `files` mediumtext DEFAULT NULL,
  `status` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `name` (`name`),
  KEY `installedTime` (`installedTime`)
) ENGINE=InnoDB;
CREATE TABLE `zt_extuser` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL DEFAULT '',
  `account` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_faq` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `module` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `question` varchar(255) NOT NULL DEFAULT '',
  `answer` text DEFAULT NULL,
  `addedtime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_feedback` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `product` int unsigned NOT NULL DEFAULT 0,
  `module` int unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `solution` varchar(30) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `pri` tinyint unsigned NOT NULL DEFAULT 2,
  `status` varchar(30) NOT NULL DEFAULT '',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `prevStatus` varchar(30) NOT NULL DEFAULT '',
  `public` tinyint unsigned NOT NULL DEFAULT 0,
  `notify` tinyint unsigned NOT NULL DEFAULT 0,
  `notifyEmail` varchar(100) NOT NULL DEFAULT '',
  `source` varchar(255) NOT NULL DEFAULT '',
  `likes` text DEFAULT NULL,
  `result` int unsigned NOT NULL DEFAULT 0,
  `faq` int unsigned NOT NULL DEFAULT 0,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `reviewedBy` varchar(255) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  `processedBy` varchar(30) NOT NULL DEFAULT '',
  `processedDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `closedReason` varchar(30) NOT NULL DEFAULT '',
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `prevAssignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `activatedBy` varchar(30) NOT NULL DEFAULT '',
  `activatedDate` datetime DEFAULT NULL,
  `feedbackBy` varchar(100) NOT NULL DEFAULT '',
  `repeatFeedback` int unsigned NOT NULL DEFAULT 0,
  `mailto` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_feedbackview` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `account` varchar(30) NOT NULL DEFAULT '',
  `product` int unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `account_product` (`account`,`product`)
) ENGINE=InnoDB;
CREATE TABLE `zt_file` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pathname` varchar(100) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `extension` varchar(30) NOT NULL DEFAULT '',
  `size` int unsigned NOT NULL DEFAULT 0,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` int unsigned NOT NULL DEFAULT 0,
  `gid` char(48) NOT NULL DEFAULT '',
  `addedBy` varchar(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  `downloads` int unsigned NOT NULL DEFAULT 0,
  `extra` varchar(255) NOT NULL DEFAULT '',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `objectType` (`objectType`),
  KEY `objectID` (`objectID`),
  KEY `gid` (`gid`)
) ENGINE=InnoDB;
CREATE TABLE `zt_gapanalysis` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `account` varchar(30) NOT NULL DEFAULT '',
  `role` varchar(20) NOT NULL DEFAULT '',
  `analysis` mediumtext DEFAULT NULL,
  `needTrain` varchar(10) NOT NULL DEFAULT 'no',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_account` (`project`,`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_group` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(30) NOT NULL DEFAULT '',
  `role` varchar(30) NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `acl` text DEFAULT NULL,
  `developer` tinyint unsigned NOT NULL DEFAULT 1,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_grouppriv` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `group` int unsigned NOT NULL DEFAULT 0,
  `module` varchar(30) NOT NULL DEFAULT '',
  `method` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `group` (`group`,`module`,`method`)
) ENGINE=InnoDB;
CREATE TABLE `zt_history` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `action` int unsigned NOT NULL DEFAULT 0,
  `field` varchar(30) NOT NULL DEFAULT '',
  `old` longtext DEFAULT NULL,
  `oldValue` text DEFAULT NULL,
  `new` longtext DEFAULT NULL,
  `newValue` text DEFAULT NULL,
  `diff` mediumtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `action` (`action`)
) ENGINE=InnoDB;
CREATE TABLE `zt_holiday` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `type` varchar(10) NOT NULL DEFAULT 'holiday',
  `desc` text DEFAULT NULL,
  `year` char(4) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `name` (`name`)
) ENGINE=InnoDB;
CREATE TABLE `zt_host` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT 'normal',
  `hostType` varchar(30) NOT NULL DEFAULT '',
  `mac` varchar(128) NOT NULL DEFAULT '',
  `memory` varchar(30) NOT NULL DEFAULT '',
  `diskSize` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(50) NOT NULL DEFAULT '',
  `secret` varchar(50) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `tokenSN` varchar(50) NOT NULL DEFAULT '',
  `tokenTime` datetime DEFAULT NULL,
  `oldTokenSN` varchar(50) NOT NULL DEFAULT '',
  `vsoft` varchar(30) NOT NULL DEFAULT '',
  `heartbeat` datetime DEFAULT NULL,
  `zap` varchar(10) NOT NULL DEFAULT '',
  `vnc` int unsigned NOT NULL DEFAULT 0,
  `ztf` int unsigned NOT NULL DEFAULT 0,
  `zd` int unsigned NOT NULL DEFAULT 0,
  `ssh` int unsigned NOT NULL DEFAULT 0,
  `parent` int unsigned NOT NULL DEFAULT 0,
  `image` int unsigned NOT NULL DEFAULT 0,
  `admin` smallint unsigned NOT NULL DEFAULT 0,
  `serverRoom` int unsigned NOT NULL DEFAULT 0,
  `cpuNumber` varchar(16) NOT NULL DEFAULT '',
  `cpuCores` varchar(30) NOT NULL DEFAULT '',
  `intranet` varchar(128) NOT NULL DEFAULT '',
  `extranet` varchar(128) NOT NULL DEFAULT '',
  `osName` varchar(64) NOT NULL DEFAULT '',
  `osVersion` varchar(64) NOT NULL DEFAULT '',
  `group` varchar(128) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_image` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `host` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(64) NOT NULL DEFAULT '',
  `localName` varchar(64) NOT NULL DEFAULT '',
  `address` varchar(64) NOT NULL DEFAULT '',
  `path` varchar(64) NOT NULL DEFAULT '',
  `status` varchar(20) NOT NULL DEFAULT '',
  `osName` varchar(32) NOT NULL DEFAULT '',
  `from` varchar(10) NOT NULL DEFAULT 'zentao',
  `memory` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `disk` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `fileSize` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `md5` varchar(64) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `restoreDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_instance` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `space` int unsigned NOT NULL DEFAULT 0,
  `solution` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(50) NOT NULL DEFAULT '',
  `appID` int unsigned NOT NULL DEFAULT 0,
  `appName` varchar(50) NOT NULL DEFAULT '',
  `appVersion` varchar(20) NOT NULL DEFAULT '',
  `chart` varchar(50) NOT NULL DEFAULT '',
  `logo` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(50) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `introduction` text DEFAULT NULL,
  `source` varchar(20) NOT NULL DEFAULT '',
  `channel` varchar(20) NOT NULL DEFAULT '',
  `k8name` varchar(64) NOT NULL DEFAULT '',
  `status` varchar(20) NOT NULL DEFAULT '',
  `pinned` tinyint unsigned NOT NULL DEFAULT 0,
  `domain` varchar(255) NOT NULL DEFAULT '',
  `smtpSnippetName` varchar(30) NOT NULL DEFAULT '',
  `ldapSnippetName` varchar(30) NOT NULL DEFAULT '',
  `ldapSettings` text DEFAULT NULL,
  `dbSettings` text DEFAULT NULL,
  `autoBackup` tinyint unsigned NOT NULL DEFAULT 0,
  `backupKeepDays` int unsigned NOT NULL DEFAULT 1,
  `autoRestore` tinyint unsigned NOT NULL DEFAULT 0,
  `env` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdAt` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `space` (`space`),
  KEY `k8name` (`k8name`)
) ENGINE=InnoDB;
CREATE TABLE `zt_intervention` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `activity` int unsigned NOT NULL DEFAULT 0,
  `status` varchar(30) NOT NULL DEFAULT '',
  `partake` text DEFAULT NULL,
  `begin` date DEFAULT NULL,
  `realBegin` date DEFAULT NULL,
  `situation` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project` (`project`,`activity`)
) ENGINE=InnoDB;
CREATE TABLE `zt_issue` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `resolvedBy` varchar(30) NOT NULL DEFAULT '',
  `project` int unsigned NOT NULL DEFAULT 0,
  `execution` int unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `pri` tinyint unsigned NOT NULL DEFAULT 3,
  `severity` tinyint unsigned NOT NULL DEFAULT 0,
  `type` varchar(30) NOT NULL DEFAULT '',
  `activity` varchar(255) NOT NULL DEFAULT '',
  `deadline` date DEFAULT NULL,
  `resolution` varchar(30) NOT NULL DEFAULT '',
  `resolutionComment` text DEFAULT NULL,
  `objectID` varchar(255) NOT NULL DEFAULT '',
  `resolvedDate` datetime DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `owner` varchar(255) NOT NULL DEFAULT '',
  `lib` int unsigned NOT NULL DEFAULT 0,
  `from` int unsigned NOT NULL DEFAULT 0,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `activateBy` varchar(30) NOT NULL DEFAULT '',
  `activateDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `approvedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_job` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `repo` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `frame` varchar(20) NOT NULL DEFAULT '',
  `engine` varchar(20) NOT NULL DEFAULT '',
  `autoRun` tinyint unsigned NOT NULL DEFAULT 1,
  `server` int unsigned NOT NULL DEFAULT 0,
  `pipeline` varchar(500) NOT NULL DEFAULT '',
  `triggerType` varchar(255) NOT NULL DEFAULT '',
  `sonarqubeServer` int unsigned NOT NULL DEFAULT 0,
  `projectKey` varchar(255) NOT NULL DEFAULT '',
  `svnDir` varchar(255) NOT NULL DEFAULT '',
  `atDay` varchar(255) NOT NULL DEFAULT '',
  `atTime` varchar(10) NOT NULL DEFAULT '',
  `customParam` text DEFAULT NULL,
  `comment` varchar(255) NOT NULL DEFAULT '',
  `triggerActions` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `lastExec` datetime DEFAULT NULL,
  `lastStatus` varchar(255) NOT NULL DEFAULT '',
  `lastTag` varchar(255) NOT NULL DEFAULT '',
  `lastSyncDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_repo_deleted` (`repo`,`deleted`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanban` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `space` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `team` text DEFAULT NULL,
  `desc` mediumtext DEFAULT NULL,
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `whitelist` text DEFAULT NULL,
  `archived` tinyint unsigned NOT NULL DEFAULT 1,
  `performable` tinyint unsigned NOT NULL DEFAULT 0,
  `status` varchar(10) NOT NULL DEFAULT 'active',
  `order` int unsigned NOT NULL DEFAULT 0,
  `displayCards` smallint unsigned NOT NULL DEFAULT 0,
  `showWIP` tinyint unsigned NOT NULL DEFAULT 1,
  `fluidBoard` tinyint unsigned NOT NULL DEFAULT 0,
  `colWidth` smallint unsigned NOT NULL DEFAULT 264,
  `minColWidth` smallint unsigned NOT NULL DEFAULT 200,
  `maxColWidth` smallint unsigned NOT NULL DEFAULT 384,
  `object` varchar(255) NOT NULL DEFAULT '',
  `alignment` varchar(10) NOT NULL DEFAULT 'center',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `activatedBy` varchar(30) NOT NULL DEFAULT '',
  `activatedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanbancard` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `kanban` int unsigned NOT NULL DEFAULT 0,
  `region` int unsigned NOT NULL DEFAULT 0,
  `group` int unsigned NOT NULL DEFAULT 0,
  `fromID` int unsigned NOT NULL DEFAULT 0,
  `fromType` varchar(30) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT 'doing',
  `pri` int unsigned NOT NULL DEFAULT 0,
  `assignedTo` text DEFAULT NULL,
  `desc` mediumtext DEFAULT NULL,
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `estimate` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `progress` decimal(5,2) unsigned NOT NULL DEFAULT 0.00,
  `color` char(7) NOT NULL DEFAULT '',
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `whitelist` text DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT 0,
  `archived` tinyint unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `archivedBy` varchar(30) NOT NULL DEFAULT '',
  `archivedDate` datetime DEFAULT NULL,
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanbancell` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `kanban` int unsigned NOT NULL DEFAULT 0,
  `lane` int unsigned NOT NULL DEFAULT 0,
  `column` int unsigned NOT NULL DEFAULT 0,
  `type` varchar(30) NOT NULL DEFAULT '',
  `cards` mediumtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `card_group` (`kanban`,`type`,`lane`,`column`),
  KEY `lane` (`lane`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanbancolumn` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `parent` int NOT NULL DEFAULT 0,
  `type` varchar(30) NOT NULL DEFAULT '',
  `region` int unsigned NOT NULL DEFAULT 0,
  `group` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `color` char(7) NOT NULL DEFAULT '',
  `limit` smallint NOT NULL DEFAULT -1,
  `order` int unsigned NOT NULL DEFAULT 0,
  `archived` tinyint unsigned NOT NULL DEFAULT 0,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `group` (`group`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanbangroup` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `kanban` int unsigned NOT NULL DEFAULT 0,
  `region` int unsigned NOT NULL DEFAULT 0,
  `order` int unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanbanlane` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `execution` int unsigned NOT NULL DEFAULT 0,
  `type` varchar(30) NOT NULL DEFAULT '',
  `region` int unsigned NOT NULL DEFAULT 0,
  `group` int unsigned NOT NULL DEFAULT 0,
  `groupby` varchar(30) NOT NULL DEFAULT '',
  `extra` varchar(30) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `color` char(7) NOT NULL DEFAULT '',
  `order` int unsigned NOT NULL DEFAULT 0,
  `lastEditedTime` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `execution` (`execution`),
  KEY `group` (`group`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanbanregion` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `space` int unsigned NOT NULL DEFAULT 0,
  `kanban` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `order` int unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanbanspace` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(50) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `team` text DEFAULT NULL,
  `desc` mediumtext DEFAULT NULL,
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `whitelist` text DEFAULT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'active',
  `order` int unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `activatedBy` varchar(30) NOT NULL DEFAULT '',
  `activatedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_lang` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `lang` varchar(30) NOT NULL DEFAULT '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `section` varchar(50) NOT NULL DEFAULT '',
  `key` varchar(60) NOT NULL DEFAULT '',
  `value` text DEFAULT NULL,
  `system` tinyint unsigned NOT NULL DEFAULT 1,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  UNIQUE KEY `lang` (`lang`,`module`,`section`,`key`,`vision`)
) ENGINE=InnoDB;
CREATE TABLE `zt_leave` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `start` time DEFAULT NULL,
  `finish` time DEFAULT NULL,
  `hours` decimal(4,1) unsigned NOT NULL DEFAULT 0.0,
  `backDate` datetime DEFAULT NULL,
  `type` varchar(30) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `reviewedBy` varchar(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  `level` tinyint unsigned NOT NULL DEFAULT 0,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `reviewers` text DEFAULT NULL,
  `backReviewers` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `type` (`type`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=InnoDB;
CREATE TABLE `zt_lieu` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `start` time DEFAULT NULL,
  `finish` time DEFAULT NULL,
  `hours` decimal(4,1) unsigned NOT NULL DEFAULT 0.0,
  `overtime` varchar(255) NOT NULL DEFAULT '',
  `trip` varchar(255) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `reviewedBy` varchar(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  `level` tinyint unsigned NOT NULL DEFAULT 0,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `reviewers` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=InnoDB;
CREATE TABLE `zt_log` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` int unsigned NOT NULL DEFAULT 0,
  `action` int unsigned NOT NULL DEFAULT 0,
  `date` datetime DEFAULT NULL,
  `url` varchar(255) NOT NULL DEFAULT '',
  `contentType` varchar(30) NOT NULL DEFAULT '',
  `data` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `objectType` (`objectType`),
  KEY `obejctID` (`objectID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_mark` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(10) NOT NULL DEFAULT '',
  `objectID` int unsigned NOT NULL DEFAULT 0,
  `version` varchar(10) NOT NULL DEFAULT '1',
  `account` varchar(30) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  `mark` varchar(50) NOT NULL DEFAULT '',
  `extra` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_object` (`objectType`,`objectID`),
  KEY `idx_account` (`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_market` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `industry` varchar(255) NOT NULL DEFAULT '',
  `scale` decimal(10,2) NOT NULL DEFAULT 0.00,
  `maturity` varchar(255) NOT NULL DEFAULT '',
  `speed` varchar(255) NOT NULL DEFAULT '',
  `competition` varchar(255) NOT NULL DEFAULT '',
  `strategy` varchar(255) NOT NULL DEFAULT '',
  `ppm` varchar(20) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_marketreport` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `market` int unsigned NOT NULL DEFAULT 0,
  `research` int unsigned NOT NULL DEFAULT 0,
  `maturity` varchar(30) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `participants` varchar(255) NOT NULL DEFAULT '',
  `source` varchar(30) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `status` varchar(20) NOT NULL DEFAULT '',
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `publishedBy` varchar(30) NOT NULL DEFAULT '',
  `publishedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_measqueue` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL DEFAULT '',
  `mid` int unsigned NOT NULL DEFAULT 0,
  `status` varchar(100) NOT NULL DEFAULT '',
  `logs` text DEFAULT NULL,
  `execTime` varchar(10) NOT NULL DEFAULT '',
  `params` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `updateDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `status_deleted` (`status`,`deleted`)
) ENGINE=InnoDB;
CREATE TABLE `zt_measrecords` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL DEFAULT '',
  `mid` int unsigned NOT NULL DEFAULT 0,
  `measCode` varchar(50) NOT NULL DEFAULT '',
  `project` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `execution` int unsigned NOT NULL DEFAULT 0,
  `params` text DEFAULT NULL,
  `year` char(4) NOT NULL DEFAULT '',
  `month` char(6) NOT NULL DEFAULT '',
  `week` char(2) NOT NULL DEFAULT '',
  `day` char(8) NOT NULL DEFAULT '',
  `value` varchar(255) NOT NULL DEFAULT '',
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `time` (`year`,`month`,`day`,`week`),
  KEY `product` (`product`),
  KEY `project` (`project`)
) ENGINE=InnoDB;
CREATE TABLE `zt_meastemplate` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `model` varchar(30) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `content` mediumtext DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_meeting` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `execution` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `begin` time DEFAULT NULL,
  `end` time DEFAULT NULL,
  `dept` int unsigned NOT NULL DEFAULT 0,
  `mode` varchar(255) NOT NULL DEFAULT '',
  `host` varchar(30) NOT NULL DEFAULT '',
  `participant` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  `room` int unsigned NOT NULL DEFAULT 0,
  `minutes` text DEFAULT NULL,
  `minutedBy` varchar(30) NOT NULL DEFAULT '',
  `minutedDate` datetime DEFAULT NULL,
  `objectType` varchar(15) NOT NULL DEFAULT '',
  `objectID` int unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_meetingroom` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `position` varchar(30) NOT NULL DEFAULT '',
  `seats` int unsigned NOT NULL DEFAULT 0,
  `equipment` varchar(255) NOT NULL DEFAULT '',
  `openTime` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_metric` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `purpose` varchar(50) NOT NULL DEFAULT '',
  `scope` varchar(30) NOT NULL DEFAULT '',
  `object` varchar(30) NOT NULL DEFAULT '',
  `stage` varchar(10) NOT NULL DEFAULT 'wait',
  `type` varchar(10) NOT NULL DEFAULT 'php',
  `name` varchar(90) NOT NULL DEFAULT '',
  `alias` varchar(90) NOT NULL DEFAULT '',
  `code` varchar(90) NOT NULL DEFAULT '',
  `unit` varchar(10) NOT NULL DEFAULT '',
  `dateType` varchar(50) NOT NULL DEFAULT '',
  `collector` text DEFAULT NULL,
  `desc` text DEFAULT NULL,
  `definition` text DEFAULT NULL,
  `when` varchar(30) NOT NULL DEFAULT '',
  `event` varchar(30) NOT NULL DEFAULT '',
  `cronCFG` varchar(30) NOT NULL DEFAULT '',
  `time` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `implementedBy` varchar(30) NOT NULL DEFAULT '',
  `implementedDate` datetime DEFAULT NULL,
  `delistedBy` varchar(30) NOT NULL DEFAULT '',
  `delistedDate` datetime DEFAULT NULL,
  `builtin` tinyint unsigned NOT NULL DEFAULT 0,
  `fromID` int unsigned NOT NULL DEFAULT 0,
  `order` int unsigned NOT NULL DEFAULT 0,
  `lastCalcRows` int unsigned NOT NULL DEFAULT 0,
  `lastCalcTime` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_metriclib` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `metricID` int unsigned NOT NULL DEFAULT 0,
  `metricCode` varchar(100) NOT NULL DEFAULT '',
  `system` tinyint unsigned NOT NULL DEFAULT 0,
  `program` int unsigned NOT NULL DEFAULT 0,
  `project` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `execution` int unsigned NOT NULL DEFAULT 0,
  `code` varchar(30) NOT NULL DEFAULT '',
  `pipeline` varchar(30) NOT NULL DEFAULT '',
  `repo` varchar(30) NOT NULL DEFAULT '',
  `user` varchar(30) NOT NULL DEFAULT '',
  `dept` varchar(30) NOT NULL DEFAULT '',
  `year` char(4) NOT NULL DEFAULT '',
  `month` char(2) NOT NULL DEFAULT '',
  `week` char(2) NOT NULL DEFAULT '',
  `day` char(2) NOT NULL DEFAULT '',
  `value` varchar(100) NOT NULL DEFAULT '',
  `calcType` varchar(10) NOT NULL DEFAULT 'cron',
  `calculatedBy` varchar(30) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `metricCode_system_date` (`metricCode`,`system`,`date`),
  KEY `metricCode_program_date` (`metricCode`,`program`,`date`),
  KEY `metricCode_project_date` (`metricCode`,`project`,`date`),
  KEY `metricCode_product_date` (`metricCode`,`product`,`date`),
  KEY `metricCode_execution_date` (`metricCode`,`execution`,`date`),
  KEY `metricCode_user_date` (`metricCode`,`user`,`date`)
) ENGINE=InnoDB;
CREATE TABLE `zt_module` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `root` int unsigned NOT NULL DEFAULT 0,
  `branch` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(60) NOT NULL DEFAULT '',
  `parent` int unsigned NOT NULL DEFAULT 0,
  `path` varchar(255) NOT NULL DEFAULT '',
  `grade` tinyint unsigned NOT NULL DEFAULT 0,
  `order` int unsigned NOT NULL DEFAULT 0,
  `type` varchar(30) NOT NULL DEFAULT '',
  `from` int unsigned NOT NULL DEFAULT 0,
  `owner` varchar(30) NOT NULL DEFAULT '',
  `collector` text DEFAULT NULL,
  `short` varchar(60) NOT NULL DEFAULT '',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `root` (`root`),
  KEY `type` (`type`),
  KEY `path` (`path`)
) ENGINE=InnoDB;
CREATE TABLE `zt_mr` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `hostID` int unsigned NOT NULL DEFAULT 0,
  `sourceProject` varchar(50) NOT NULL DEFAULT '',
  `sourceBranch` varchar(100) NOT NULL DEFAULT '',
  `targetProject` varchar(50) NOT NULL DEFAULT '',
  `targetBranch` varchar(100) NOT NULL DEFAULT '',
  `mriid` int unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text DEFAULT NULL,
  `assignee` varchar(255) NOT NULL DEFAULT '',
  `reviewer` varchar(255) NOT NULL DEFAULT '',
  `approver` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `mergeStatus` varchar(30) NOT NULL DEFAULT '',
  `approvalStatus` varchar(30) NOT NULL DEFAULT '',
  `needApproved` tinyint unsigned NOT NULL DEFAULT 0,
  `needCI` tinyint unsigned NOT NULL DEFAULT 0,
  `repoID` int unsigned NOT NULL DEFAULT 0,
  `jobID` int unsigned NOT NULL DEFAULT 0,
  `executionID` int unsigned NOT NULL DEFAULT 0,
  `compileID` int unsigned NOT NULL DEFAULT 0,
  `compileStatus` varchar(30) NOT NULL DEFAULT '',
  `removeSourceBranch` tinyint unsigned NOT NULL DEFAULT 0,
  `squash` tinyint unsigned NOT NULL DEFAULT 0,
  `isFlow` tinyint unsigned NOT NULL DEFAULT 0,
  `synced` tinyint unsigned NOT NULL DEFAULT 1,
  `syncError` varchar(255) NOT NULL DEFAULT '',
  `hasNoConflict` tinyint unsigned NOT NULL DEFAULT 0,
  `diffs` longtext DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_mrapproval` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `mrID` int unsigned NOT NULL DEFAULT 0,
  `account` varchar(255) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  `action` varchar(30) NOT NULL DEFAULT '',
  `comment` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_nc` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `auditplan` int unsigned NOT NULL DEFAULT 0,
  `listID` int unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `type` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT 'active',
  `severity` tinyint unsigned NOT NULL DEFAULT 0,
  `deadline` date DEFAULT NULL,
  `resolvedBy` varchar(30) NOT NULL DEFAULT '',
  `resolution` varchar(30) NOT NULL DEFAULT '',
  `resolvedDate` date DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `parent` int unsigned NOT NULL DEFAULT 0,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `activateDate` datetime DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_notify` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(10) NOT NULL DEFAULT '',
  `objectID` int unsigned NOT NULL DEFAULT 0,
  `action` int unsigned NOT NULL DEFAULT 0,
  `toList` text DEFAULT NULL,
  `ccList` text DEFAULT NULL,
  `subject` text DEFAULT NULL,
  `data` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `sendTime` datetime DEFAULT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `failReason` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `objectType` (`objectType`),
  KEY `status` (`status`)
) ENGINE=InnoDB;
CREATE TABLE `zt_oauth` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `account` varchar(30) NOT NULL DEFAULT '',
  `openID` varchar(100) NOT NULL DEFAULT '',
  `providerType` varchar(30) NOT NULL DEFAULT '',
  `providerID` int unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `account_openID` (`account`,`openID`,`providerType`,`providerID`),
  KEY `account` (`account`),
  KEY `providerType` (`providerType`),
  KEY `providerID` (`providerID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_object` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `from` int unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `category` varchar(30) NOT NULL DEFAULT '',
  `version` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(10) NOT NULL DEFAULT 'reviewed',
  `enabled` tinyint unsigned NOT NULL DEFAULT 1,
  `range` text DEFAULT NULL,
  `data` text DEFAULT NULL,
  `storyEst` varchar(30) NOT NULL DEFAULT '',
  `taskEst` varchar(30) NOT NULL DEFAULT '',
  `requestEst` varchar(30) NOT NULL DEFAULT '',
  `testEst` varchar(30) NOT NULL DEFAULT '',
  `devEst` varchar(30) NOT NULL DEFAULT '',
  `designEst` varchar(30) NOT NULL DEFAULT '',
  `end` date DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_opportunity` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `execution` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `source` varchar(30) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `strategy` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT 'active',
  `impact` int unsigned NOT NULL DEFAULT 0,
  `chance` int unsigned NOT NULL DEFAULT 0,
  `ratio` int unsigned NOT NULL DEFAULT 0,
  `pri` tinyint unsigned NOT NULL DEFAULT 3,
  `identifiedDate` date DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `approvedDate` datetime DEFAULT NULL,
  `prevention` mediumtext DEFAULT NULL,
  `plannedClosedDate` date DEFAULT NULL,
  `actualClosedDate` date DEFAULT NULL,
  `lib` int unsigned NOT NULL DEFAULT 0,
  `from` int unsigned NOT NULL DEFAULT 0,
  `desc` mediumtext DEFAULT NULL,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `activatedBy` varchar(30) NOT NULL DEFAULT '',
  `activatedDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `canceledBy` varchar(30) NOT NULL DEFAULT '',
  `canceledDate` datetime DEFAULT NULL,
  `cancelReason` varchar(30) NOT NULL DEFAULT '',
  `hangupedBy` varchar(30) NOT NULL DEFAULT '',
  `hangupedDate` datetime DEFAULT NULL,
  `resolution` mediumtext DEFAULT NULL,
  `resolvedBy` varchar(30) NOT NULL DEFAULT '',
  `resolvedDate` datetime DEFAULT NULL,
  `lastCheckedBy` varchar(30) NOT NULL DEFAULT '',
  `lastCheckedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_overtime` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `start` time DEFAULT NULL,
  `finish` time DEFAULT NULL,
  `hours` decimal(4,1) unsigned NOT NULL DEFAULT 0.0,
  `leave` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `rejectReason` varchar(100) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `reviewedBy` varchar(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  `level` tinyint unsigned NOT NULL DEFAULT 0,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `reviewers` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `type` (`type`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=InnoDB;
CREATE TABLE `zt_pipeline` (
  `id` smallint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `account` varchar(30) NOT NULL DEFAULT '',
  `password` varchar(255) NOT NULL DEFAULT '',
  `token` varchar(255) NOT NULL DEFAULT '',
  `private` char(32) NOT NULL DEFAULT '',
  `instanceID` int unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_pivot` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `dimension` int unsigned NOT NULL DEFAULT 0,
  `group` varchar(255) NOT NULL DEFAULT '',
  `code` varchar(255) NOT NULL DEFAULT '',
  `driver` varchar(10) NOT NULL DEFAULT 'mysql',
  `mode` varchar(10) NOT NULL DEFAULT 'builder',
  `name` text DEFAULT NULL,
  `desc` text DEFAULT NULL,
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `whitelist` text DEFAULT NULL,
  `sql` text DEFAULT NULL,
  `fields` text DEFAULT NULL,
  `langs` text DEFAULT NULL,
  `vars` text DEFAULT NULL,
  `objects` text DEFAULT NULL,
  `settings` text DEFAULT NULL,
  `filters` text DEFAULT NULL,
  `step` tinyint unsigned NOT NULL DEFAULT 0,
  `stage` varchar(10) NOT NULL DEFAULT 'draft',
  `builtin` tinyint unsigned NOT NULL DEFAULT 0,
  `version` varchar(10) NOT NULL DEFAULT '1',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `dimension` (`dimension`),
  KEY `group` (`group`)
) ENGINE=InnoDB;
CREATE TABLE `zt_pivotdrill` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pivot` int unsigned NOT NULL DEFAULT 0,
  `version` varchar(10) NOT NULL DEFAULT '1',
  `field` varchar(255) NOT NULL DEFAULT '',
  `object` varchar(40) NOT NULL DEFAULT '',
  `whereSql` mediumtext DEFAULT NULL,
  `condition` mediumtext DEFAULT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'published',
  `account` varchar(30) NOT NULL DEFAULT '',
  `type` varchar(10) NOT NULL DEFAULT 'manual',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_pivotspec` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `pivot` int unsigned NOT NULL DEFAULT 0,
  `version` varchar(10) NOT NULL DEFAULT '1',
  `driver` varchar(10) NOT NULL DEFAULT 'mysql',
  `mode` varchar(10) NOT NULL DEFAULT 'builder',
  `name` text DEFAULT NULL,
  `desc` text DEFAULT NULL,
  `sql` text DEFAULT NULL,
  `fields` text DEFAULT NULL,
  `langs` text DEFAULT NULL,
  `vars` text DEFAULT NULL,
  `objects` text DEFAULT NULL,
  `settings` text DEFAULT NULL,
  `filters` text DEFAULT NULL,
  `createdDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_pivot_version` (`pivot`,`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_planstory` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `plan` int unsigned NOT NULL DEFAULT 0,
  `story` int unsigned NOT NULL DEFAULT 0,
  `order` int unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `plan_story` (`plan`,`story`)
) ENGINE=InnoDB;
CREATE TABLE `zt_practice` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `module` int unsigned NOT NULL DEFAULT 0,
  `code` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `labels` varchar(255) NOT NULL DEFAULT '',
  `summary` varchar(255) NOT NULL DEFAULT '',
  `content` text DEFAULT NULL,
  `contributor` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB;
CREATE TABLE `zt_process` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `model` varchar(30) NOT NULL DEFAULT 'waterfall',
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `abbr` varchar(30) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `order` int unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_product` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `program` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(110) NOT NULL DEFAULT '',
  `code` varchar(45) NOT NULL DEFAULT '',
  `shadow` tinyint unsigned NOT NULL DEFAULT 0,
  `bind` tinyint unsigned NOT NULL DEFAULT 0,
  `line` int unsigned NOT NULL DEFAULT 0,
  `type` varchar(30) NOT NULL DEFAULT 'normal',
  `status` varchar(30) NOT NULL DEFAULT '',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `PO` varchar(30) NOT NULL DEFAULT '',
  `QD` varchar(30) NOT NULL DEFAULT '',
  `RD` varchar(30) NOT NULL DEFAULT '',
  `feedback` varchar(30) NOT NULL DEFAULT '',
  `ticket` varchar(30) NOT NULL DEFAULT '',
  `workflowGroup` int unsigned NOT NULL DEFAULT 0,
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `groups` text DEFAULT NULL,
  `whitelist` text DEFAULT NULL,
  `reviewer` text DEFAULT NULL,
  `PMT` text DEFAULT NULL,
  `draftEpics` int unsigned NOT NULL DEFAULT 0,
  `activeEpics` int unsigned NOT NULL DEFAULT 0,
  `changingEpics` int unsigned NOT NULL DEFAULT 0,
  `reviewingEpics` int unsigned NOT NULL DEFAULT 0,
  `finishedEpics` int unsigned NOT NULL DEFAULT 0,
  `closedEpics` int unsigned NOT NULL DEFAULT 0,
  `totalEpics` int unsigned NOT NULL DEFAULT 0,
  `draftRequirements` int unsigned NOT NULL DEFAULT 0,
  `activeRequirements` int unsigned NOT NULL DEFAULT 0,
  `changingRequirements` int unsigned NOT NULL DEFAULT 0,
  `reviewingRequirements` int unsigned NOT NULL DEFAULT 0,
  `finishedRequirements` int unsigned NOT NULL DEFAULT 0,
  `closedRequirements` int unsigned NOT NULL DEFAULT 0,
  `totalRequirements` int unsigned NOT NULL DEFAULT 0,
  `draftStories` int unsigned NOT NULL DEFAULT 0,
  `activeStories` int unsigned NOT NULL DEFAULT 0,
  `changingStories` int unsigned NOT NULL DEFAULT 0,
  `reviewingStories` int unsigned NOT NULL DEFAULT 0,
  `finishedStories` int unsigned NOT NULL DEFAULT 0,
  `closedStories` int unsigned NOT NULL DEFAULT 0,
  `totalStories` int unsigned NOT NULL DEFAULT 0,
  `unresolvedBugs` int unsigned NOT NULL DEFAULT 0,
  `closedBugs` int unsigned NOT NULL DEFAULT 0,
  `fixedBugs` int unsigned NOT NULL DEFAULT 0,
  `totalBugs` int unsigned NOT NULL DEFAULT 0,
  `plans` int unsigned NOT NULL DEFAULT 0,
  `releases` int unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `createdVersion` varchar(20) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT 0,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `acl` (`acl`),
  KEY `order` (`order`)
) ENGINE=InnoDB;
CREATE TABLE `zt_productplan` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `product` int unsigned NOT NULL DEFAULT 0,
  `branch` varchar(255) NOT NULL DEFAULT '0',
  `parent` int NOT NULL DEFAULT 0,
  `title` varchar(90) NOT NULL DEFAULT '',
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `desc` mediumtext DEFAULT NULL,
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `finishedDate` datetime DEFAULT NULL,
  `closedDate` datetime DEFAULT NULL,
  `order` text DEFAULT NULL,
  `closedReason` varchar(20) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `end` (`end`)
) ENGINE=InnoDB;
CREATE TABLE `zt_programactivity` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `execution` int unsigned NOT NULL DEFAULT 0,
  `process` int unsigned NOT NULL DEFAULT 0,
  `activity` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `content` text DEFAULT NULL,
  `reason` varchar(255) NOT NULL DEFAULT '',
  `result` varchar(30) NOT NULL DEFAULT '',
  `linkedBy` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_programoutput` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `execution` int unsigned NOT NULL DEFAULT 0,
  `process` int unsigned NOT NULL DEFAULT 0,
  `activity` int unsigned NOT NULL DEFAULT 0,
  `output` int unsigned NOT NULL DEFAULT 0,
  `content` text DEFAULT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `reason` varchar(255) NOT NULL DEFAULT '',
  `result` varchar(30) NOT NULL DEFAULT '',
  `linkedBy` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_programprocess` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `process` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `abbr` varchar(30) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `reason` varchar(255) NOT NULL DEFAULT '',
  `linkedBy` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_programreport` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `template` int unsigned NOT NULL DEFAULT 0,
  `project` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `params` text DEFAULT NULL,
  `content` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_project` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `isTpl` tinyint unsigned NOT NULL DEFAULT 0,
  `charter` int unsigned NOT NULL DEFAULT 0,
  `model` varchar(30) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT 'sprint',
  `category` varchar(30) NOT NULL DEFAULT '',
  `lifetime` varchar(30) NOT NULL DEFAULT '',
  `budget` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `budgetUnit` varchar(30) NOT NULL DEFAULT 'CNY',
  `attribute` varchar(30) NOT NULL DEFAULT '',
  `percent` decimal(5,2) unsigned NOT NULL DEFAULT 0.00,
  `milestone` tinyint unsigned NOT NULL DEFAULT 0,
  `output` text DEFAULT NULL,
  `auth` varchar(30) NOT NULL DEFAULT '',
  `storyType` varchar(30) NOT NULL DEFAULT 'story',
  `parent` int unsigned NOT NULL DEFAULT 0,
  `path` varchar(255) NOT NULL DEFAULT '',
  `grade` tinyint unsigned NOT NULL DEFAULT 0,
  `name` varchar(90) NOT NULL DEFAULT '',
  `code` varchar(45) NOT NULL DEFAULT '',
  `hasProduct` tinyint unsigned NOT NULL DEFAULT 1,
  `workflowGroup` int unsigned NOT NULL DEFAULT 0,
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `firstEnd` date DEFAULT NULL,
  `realBegan` date DEFAULT NULL,
  `realEnd` date DEFAULT NULL,
  `days` smallint unsigned NOT NULL DEFAULT 0,
  `status` varchar(10) NOT NULL DEFAULT '',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `pri` tinyint unsigned NOT NULL DEFAULT 1,
  `desc` mediumtext DEFAULT NULL,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `parentVersion` smallint unsigned NOT NULL DEFAULT 1,
  `planDuration` int unsigned NOT NULL DEFAULT 0,
  `realDuration` int unsigned NOT NULL DEFAULT 0,
  `progress` decimal(5,2) unsigned NOT NULL DEFAULT 0.00,
  `estimate` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `left` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `consumed` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `teamCount` int unsigned NOT NULL DEFAULT 0,
  `market` int unsigned NOT NULL DEFAULT 0,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `openedVersion` varchar(20) NOT NULL DEFAULT '',
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `closedReason` varchar(20) NOT NULL DEFAULT '',
  `canceledBy` varchar(30) NOT NULL DEFAULT '',
  `canceledDate` datetime DEFAULT NULL,
  `suspendedDate` datetime DEFAULT NULL,
  `PO` varchar(30) NOT NULL DEFAULT '',
  `PM` varchar(30) NOT NULL DEFAULT '',
  `QD` varchar(30) NOT NULL DEFAULT '',
  `RD` varchar(30) NOT NULL DEFAULT '',
  `team` varchar(90) NOT NULL DEFAULT '',
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `whitelist` text DEFAULT NULL,
  `tplAcl` varchar(30) NOT NULL DEFAULT 'open',
  `tplWhiteList` text DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT 0,
  `stageBy` varchar(10) NOT NULL DEFAULT 'product',
  `displayCards` smallint unsigned NOT NULL DEFAULT 0,
  `fluidBoard` tinyint unsigned NOT NULL DEFAULT 0,
  `multiple` tinyint unsigned NOT NULL DEFAULT 1,
  `parallel` int unsigned NOT NULL DEFAULT 0,
  `enabled` varchar(10) NOT NULL DEFAULT 'on',
  `linkType` varchar(30) NOT NULL DEFAULT 'plan',
  `taskDateLimit` varchar(30) NOT NULL DEFAULT 'auto',
  `colWidth` smallint unsigned NOT NULL DEFAULT 264,
  `minColWidth` smallint unsigned NOT NULL DEFAULT 200,
  `maxColWidth` smallint unsigned NOT NULL DEFAULT 384,
  `deliverable` text DEFAULT NULL,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `begin` (`begin`),
  KEY `end` (`end`),
  KEY `status` (`status`),
  KEY `acl` (`acl`),
  KEY `order` (`order`),
  KEY `project` (`project`),
  KEY `type_order` (`type`,`order`)
) ENGINE=InnoDB;
CREATE TABLE `zt_projectadmin` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `group` smallint unsigned NOT NULL DEFAULT 0,
  `account` varchar(30) NOT NULL DEFAULT '',
  `programs` text DEFAULT NULL,
  `projects` text DEFAULT NULL,
  `products` text DEFAULT NULL,
  `executions` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `group_account` (`group`,`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_projectcase` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `case` int unsigned NOT NULL DEFAULT 0,
  `count` int unsigned NOT NULL DEFAULT 1,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `order` int unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project` (`project`,`case`)
) ENGINE=InnoDB;
CREATE TABLE `zt_projectproduct` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `branch` int unsigned NOT NULL DEFAULT 0,
  `plan` varchar(255) NOT NULL DEFAULT '',
  `roadmap` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_product` (`project`,`product`,`branch`)
) ENGINE=InnoDB;
CREATE TABLE `zt_projectspec` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `name` varchar(255) NOT NULL DEFAULT '',
  `milestone` tinyint unsigned NOT NULL DEFAULT 0,
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project` (`project`,`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_projectstory` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `branch` int unsigned NOT NULL DEFAULT 0,
  `story` int unsigned NOT NULL DEFAULT 0,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `order` int unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `project` (`project`,`story`),
  KEY `story` (`story`)
) ENGINE=InnoDB;
CREATE TABLE `zt_queue` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `cron` int unsigned NOT NULL DEFAULT 0,
  `type` varchar(255) NOT NULL DEFAULT '',
  `command` text DEFAULT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `execId` int unsigned NOT NULL DEFAULT 0,
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `status_createdDate` (`status`,`createdDate`),
  KEY `cron_createdDate` (`cron`,`createdDate`)
) ENGINE=InnoDB;
CREATE TABLE `zt_relation` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `execution` int unsigned NOT NULL DEFAULT 0,
  `AType` varchar(30) NOT NULL DEFAULT '',
  `AID` int unsigned NOT NULL DEFAULT 0,
  `AVersion` smallint unsigned NOT NULL DEFAULT 1,
  `relation` varchar(30) NOT NULL DEFAULT '',
  `BType` varchar(30) NOT NULL DEFAULT '',
  `BID` int unsigned NOT NULL DEFAULT 0,
  `BVersion` smallint unsigned NOT NULL DEFAULT 1,
  `extra` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `relation` (`product`,`relation`,`AType`,`BType`,`AID`,`BID`),
  KEY `AID` (`AType`,`AID`),
  KEY `BID` (`BType`,`BID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_relationoftasks` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `execution` varchar(30) NOT NULL DEFAULT '',
  `pretask` int unsigned NOT NULL DEFAULT 0,
  `condition` varchar(10) NOT NULL DEFAULT '',
  `task` int unsigned NOT NULL DEFAULT 0,
  `action` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `relationoftasks` (`execution`,`task`)
) ENGINE=InnoDB;
CREATE TABLE `zt_release` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` varchar(255) NOT NULL DEFAULT '0',
  `product` int unsigned NOT NULL DEFAULT 0,
  `branch` varchar(255) NOT NULL DEFAULT '0',
  `shadow` int unsigned NOT NULL DEFAULT 0,
  `build` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `system` int unsigned NOT NULL DEFAULT 0,
  `releases` varchar(255) NOT NULL DEFAULT '',
  `marker` tinyint unsigned NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `releasedDate` date DEFAULT NULL,
  `stories` text DEFAULT NULL,
  `bugs` text DEFAULT NULL,
  `leftBugs` text DEFAULT NULL,
  `desc` mediumtext DEFAULT NULL,
  `mailto` text DEFAULT NULL,
  `notify` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(20) NOT NULL DEFAULT 'normal',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `build` (`build`),
  KEY `idx_system` (`system`)
) ENGINE=InnoDB;
CREATE TABLE `zt_releaserelated` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `release` int unsigned NOT NULL DEFAULT 0,
  `objectID` int unsigned NOT NULL DEFAULT 0,
  `objectType` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`release`,`objectID`,`objectType`),
  KEY `objectID` (`objectID`),
  KEY `objectType` (`objectType`)
) ENGINE=InnoDB;
CREATE TABLE `zt_repo` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `product` varchar(255) NOT NULL DEFAULT '',
  `projects` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `prefix` varchar(100) NOT NULL DEFAULT '',
  `encoding` varchar(20) NOT NULL DEFAULT '',
  `SCM` varchar(10) NOT NULL DEFAULT '',
  `client` varchar(100) NOT NULL DEFAULT '',
  `serviceHost` varchar(50) NOT NULL DEFAULT '',
  `serviceProject` varchar(100) NOT NULL DEFAULT '',
  `commits` int unsigned NOT NULL DEFAULT 0,
  `account` varchar(30) NOT NULL DEFAULT '',
  `password` varchar(30) NOT NULL DEFAULT '',
  `encrypt` varchar(30) NOT NULL DEFAULT 'plain',
  `acl` text DEFAULT NULL,
  `synced` tinyint unsigned NOT NULL DEFAULT 0,
  `lastSync` datetime DEFAULT NULL,
  `lastCommit` datetime DEFAULT NULL,
  `desc` text DEFAULT NULL,
  `extra` varchar(30) NOT NULL DEFAULT '',
  `preMerge` tinyint unsigned NOT NULL DEFAULT 0,
  `job` int unsigned NOT NULL DEFAULT 0,
  `fileServerUrl` text DEFAULT NULL,
  `fileServerAccount` varchar(40) NOT NULL DEFAULT '',
  `fileServerPassword` varchar(100) NOT NULL DEFAULT '',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_repobranch` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `repo` int unsigned NOT NULL DEFAULT 0,
  `revision` int unsigned NOT NULL DEFAULT 0,
  `branch` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `repo_revision_branch` (`repo`,`revision`,`branch`),
  KEY `branch` (`branch`),
  KEY `revision` (`revision`)
) ENGINE=InnoDB;
CREATE TABLE `zt_repofiles` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `repo` int unsigned NOT NULL DEFAULT 0,
  `revision` int unsigned NOT NULL DEFAULT 0,
  `path` varchar(255) NOT NULL DEFAULT '',
  `oldPath` varchar(255) NOT NULL DEFAULT '',
  `parent` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT '',
  `action` char(1) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `path` (`path`),
  KEY `parent` (`parent`),
  KEY `repo` (`repo`),
  KEY `revision` (`revision`)
) ENGINE=InnoDB;
CREATE TABLE `zt_repohistory` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `repo` int unsigned NOT NULL DEFAULT 0,
  `revision` varchar(40) NOT NULL DEFAULT '',
  `commit` int unsigned NOT NULL DEFAULT 0,
  `comment` text DEFAULT NULL,
  `committer` varchar(100) NOT NULL DEFAULT '',
  `time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `repo` (`repo`),
  KEY `revision` (`revision`)
) ENGINE=InnoDB;
CREATE TABLE `zt_report` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(100) NOT NULL DEFAULT '',
  `name` text DEFAULT NULL,
  `dimension` int unsigned NOT NULL DEFAULT 0,
  `module` varchar(100) NOT NULL DEFAULT '',
  `sql` text DEFAULT NULL,
  `vars` text DEFAULT NULL,
  `langs` text DEFAULT NULL,
  `params` text DEFAULT NULL,
  `step` tinyint unsigned NOT NULL DEFAULT 2,
  `desc` text DEFAULT NULL,
  `addedBy` varchar(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB;
CREATE TABLE `zt_researchplan` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `customer` varchar(255) NOT NULL DEFAULT '',
  `stakeholder` varchar(255) NOT NULL DEFAULT '',
  `objective` varchar(255) NOT NULL DEFAULT '',
  `begin` datetime DEFAULT NULL,
  `end` datetime DEFAULT NULL,
  `location` varchar(255) NOT NULL DEFAULT '',
  `team` varchar(255) NOT NULL DEFAULT '',
  `method` varchar(20) NOT NULL DEFAULT '',
  `outline` mediumtext DEFAULT NULL,
  `schedule` mediumtext DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_researchreport` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `relatedPlan` int unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `author` varchar(30) NOT NULL DEFAULT '',
  `content` mediumtext DEFAULT NULL,
  `customer` varchar(255) NOT NULL DEFAULT '',
  `researchObjects` varchar(255) NOT NULL DEFAULT '',
  `begin` datetime DEFAULT NULL,
  `end` datetime DEFAULT NULL,
  `location` varchar(255) NOT NULL DEFAULT '',
  `method` varchar(20) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_review` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `object` int unsigned NOT NULL DEFAULT 0,
  `template` int unsigned NOT NULL DEFAULT 0,
  `doc` varchar(255) NOT NULL DEFAULT '',
  `docVersion` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `reviewedBy` varchar(255) NOT NULL DEFAULT '',
  `auditedBy` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `begin` date DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `lastReviewedBy` varchar(255) NOT NULL DEFAULT '',
  `lastReviewedDate` datetime DEFAULT NULL,
  `lastAuditedBy` varchar(255) NOT NULL DEFAULT '',
  `lastAuditedDate` datetime DEFAULT NULL,
  `toAuditBy` varchar(30) NOT NULL DEFAULT '',
  `toAuditDate` datetime DEFAULT NULL,
  `lastEditedBy` varchar(255) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `result` varchar(30) NOT NULL DEFAULT '',
  `auditResult` varchar(30) NOT NULL DEFAULT '',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_reviewcl` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `object` varchar(30) NOT NULL DEFAULT '',
  `category` varchar(30) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `order` int unsigned NOT NULL DEFAULT 0,
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_reviewissue` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `review` int unsigned NOT NULL DEFAULT 0,
  `approval` int unsigned NOT NULL DEFAULT 0,
  `injection` int unsigned NOT NULL DEFAULT 0,
  `identify` int unsigned NOT NULL DEFAULT 0,
  `type` varchar(30) NOT NULL DEFAULT 'review',
  `listID` int unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `opinion` mediumtext DEFAULT NULL,
  `opinionDate` date DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `resolution` varchar(30) NOT NULL DEFAULT '',
  `resolutionBy` varchar(30) NOT NULL DEFAULT '',
  `resolutionDate` datetime DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_reviewlist` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `object` varchar(30) NOT NULL DEFAULT '',
  `category` varchar(30) NOT NULL DEFAULT '',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_reviewresult` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `review` int unsigned NOT NULL DEFAULT 0,
  `type` varchar(30) NOT NULL DEFAULT 'review',
  `result` varchar(30) NOT NULL DEFAULT '',
  `opinion` text DEFAULT NULL,
  `reviewer` varchar(30) NOT NULL DEFAULT '',
  `remainIssue` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `consumed` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`),
  UNIQUE KEY `reviewer` (`review`,`reviewer`,`type`)
) ENGINE=InnoDB;
CREATE TABLE `zt_risk` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `execution` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `source` varchar(30) NOT NULL DEFAULT '',
  `category` varchar(30) NOT NULL DEFAULT '',
  `strategy` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT 'active',
  `impact` varchar(30) NOT NULL DEFAULT '',
  `probability` varchar(30) NOT NULL DEFAULT '',
  `rate` varchar(30) NOT NULL DEFAULT '',
  `pri` tinyint unsigned NOT NULL DEFAULT 2,
  `identifiedDate` date DEFAULT NULL,
  `prevention` mediumtext DEFAULT NULL,
  `remedy` mediumtext DEFAULT NULL,
  `plannedClosedDate` date DEFAULT NULL,
  `actualClosedDate` date DEFAULT NULL,
  `lib` int unsigned NOT NULL DEFAULT 0,
  `from` int unsigned NOT NULL DEFAULT 0,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `resolution` mediumtext DEFAULT NULL,
  `resolvedBy` varchar(30) NOT NULL DEFAULT '',
  `activateBy` varchar(30) NOT NULL DEFAULT '',
  `activateDate` datetime DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `cancelBy` varchar(30) NOT NULL DEFAULT '',
  `cancelDate` datetime DEFAULT NULL,
  `cancelReason` varchar(30) NOT NULL DEFAULT '',
  `hangupBy` varchar(30) NOT NULL DEFAULT '',
  `hangupDate` datetime DEFAULT NULL,
  `trackedBy` varchar(30) NOT NULL DEFAULT '',
  `trackedDate` datetime DEFAULT NULL,
  `assignedDate` datetime DEFAULT NULL,
  `approvedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_riskissue` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `risk` int unsigned NOT NULL DEFAULT 0,
  `issue` int unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `risk_issue` (`risk`,`issue`)
) ENGINE=InnoDB;
CREATE TABLE `zt_roadmap` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `product` int unsigned NOT NULL DEFAULT 0,
  `branch` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `desc` longtext DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `closedReason` varchar(10) NOT NULL DEFAULT '',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_roadmapstory` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `roadmap` int unsigned NOT NULL DEFAULT 0,
  `story` int unsigned NOT NULL DEFAULT 0,
  `order` int unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roadmap_story` (`roadmap`,`story`)
) ENGINE=InnoDB;
CREATE TABLE `zt_scene` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `product` int unsigned NOT NULL DEFAULT 0,
  `branch` int unsigned NOT NULL DEFAULT 0,
  `module` int unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `sort` int unsigned NOT NULL DEFAULT 0,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `parent` int unsigned NOT NULL DEFAULT 0,
  `grade` tinyint unsigned NOT NULL DEFAULT 0,
  `path` varchar(1000) NOT NULL DEFAULT '',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_score` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `account` varchar(30) NOT NULL DEFAULT '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `method` varchar(30) NOT NULL DEFAULT '',
  `desc` varchar(250) NOT NULL DEFAULT '',
  `before` int unsigned NOT NULL DEFAULT 0,
  `score` int unsigned NOT NULL DEFAULT 0,
  `after` int unsigned NOT NULL DEFAULT 0,
  `time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `module` (`module`),
  KEY `method` (`method`)
) ENGINE=InnoDB;
CREATE TABLE `zt_screen` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `dimension` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `whitelist` text DEFAULT NULL,
  `cover` mediumtext DEFAULT NULL,
  `scheme` mediumtext DEFAULT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'draft',
  `builtin` tinyint unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_searchdict` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `key` smallint unsigned NOT NULL DEFAULT 0,
  `value` char(3) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `key_value` (`key`,`value`)
) ENGINE=InnoDB;
CREATE TABLE `zt_searchindex` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` int unsigned NOT NULL DEFAULT 0,
  `title` text DEFAULT NULL,
  `content` text DEFAULT NULL,
  `addedDate` datetime DEFAULT NULL,
  `editedDate` datetime DEFAULT NULL,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`objectType`,`objectID`),
  KEY `addedDate` (`addedDate`),
  FULLTEXT KEY `title_content` (`title`,`content`)
) ENGINE=InnoDB;
CREATE TABLE `zt_serverroom` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL DEFAULT '',
  `city` varchar(128) NOT NULL DEFAULT '',
  `line` varchar(20) NOT NULL DEFAULT '',
  `bandwidth` varchar(128) NOT NULL DEFAULT '',
  `provider` varchar(128) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_solutions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `execution` int unsigned NOT NULL DEFAULT 0,
  `contents` text DEFAULT NULL,
  `support` text DEFAULT NULL,
  `measures` text DEFAULT NULL,
  `type` varchar(30) NOT NULL DEFAULT '',
  `addedBy` varchar(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_space` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `k8space` varchar(64) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `default` tinyint unsigned NOT NULL DEFAULT 0,
  `createdAt` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=InnoDB;
CREATE TABLE `zt_sqlbuilder` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `objectID` int unsigned NOT NULL DEFAULT 0,
  `objectType` varchar(10) NOT NULL DEFAULT '',
  `sql` text DEFAULT NULL,
  `setting` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_sqlview` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL DEFAULT '',
  `code` varchar(45) NOT NULL DEFAULT '',
  `sql` text DEFAULT NULL,
  `desc` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_stage` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `percent` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `projectType` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_stakeholder` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `objectID` int unsigned NOT NULL DEFAULT 0,
  `objectType` varchar(10) NOT NULL DEFAULT '',
  `user` varchar(30) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `key` tinyint unsigned NOT NULL DEFAULT 0,
  `from` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `objectID` (`objectID`),
  KEY `objectType` (`objectType`)
) ENGINE=InnoDB;
CREATE TABLE `zt_story` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `parent` int unsigned NOT NULL DEFAULT 0,
  `isParent` tinyint unsigned NOT NULL DEFAULT 0,
  `root` int unsigned NOT NULL DEFAULT 0,
  `path` text DEFAULT NULL,
  `grade` tinyint unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `branch` int unsigned NOT NULL DEFAULT 0,
  `module` int unsigned NOT NULL DEFAULT 0,
  `plan` text DEFAULT NULL,
  `source` varchar(20) NOT NULL DEFAULT '',
  `sourceNote` varchar(255) NOT NULL DEFAULT '',
  `fromBug` int unsigned NOT NULL DEFAULT 0,
  `feedback` int unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT 'story',
  `category` varchar(30) NOT NULL DEFAULT 'feature',
  `pri` tinyint unsigned NOT NULL DEFAULT 3,
  `estimate` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `status` varchar(10) NOT NULL DEFAULT '',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `color` char(7) NOT NULL DEFAULT '',
  `stage` varchar(10) NOT NULL DEFAULT 'wait',
  `stagedBy` varchar(30) NOT NULL DEFAULT '',
  `mailto` text DEFAULT NULL,
  `lib` int unsigned NOT NULL DEFAULT 0,
  `fromStory` int unsigned NOT NULL DEFAULT 0,
  `fromVersion` smallint unsigned NOT NULL DEFAULT 1,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `approvedDate` datetime DEFAULT NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `changedBy` varchar(30) NOT NULL DEFAULT '',
  `changedDate` datetime DEFAULT NULL,
  `reviewedBy` varchar(255) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  `releasedDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `closedReason` varchar(30) NOT NULL DEFAULT '',
  `activatedDate` datetime DEFAULT NULL,
  `toBug` int unsigned NOT NULL DEFAULT 0,
  `linkStories` varchar(255) NOT NULL DEFAULT '',
  `linkRequirements` varchar(255) NOT NULL DEFAULT '',
  `docs` text DEFAULT NULL,
  `twins` varchar(255) NOT NULL DEFAULT '',
  `duplicateStory` int unsigned NOT NULL DEFAULT 0,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `parentVersion` smallint unsigned NOT NULL DEFAULT 1,
  `demandVersion` smallint unsigned NOT NULL DEFAULT 1,
  `storyChanged` tinyint unsigned NOT NULL DEFAULT 0,
  `feedbackBy` varchar(100) NOT NULL DEFAULT '',
  `notifyEmail` varchar(100) NOT NULL DEFAULT '',
  `BSA` varchar(30) NOT NULL DEFAULT '',
  `duration` varchar(30) NOT NULL DEFAULT '',
  `demand` int unsigned NOT NULL DEFAULT 0,
  `submitedBy` varchar(30) NOT NULL DEFAULT '',
  `roadmap` varchar(255) NOT NULL DEFAULT '',
  `URChanged` tinyint unsigned NOT NULL DEFAULT 0,
  `unlinkReason` varchar(10) NOT NULL DEFAULT '',
  `retractedReason` varchar(10) NOT NULL DEFAULT '',
  `retractedBy` varchar(30) NOT NULL DEFAULT '',
  `retractedDate` datetime DEFAULT NULL,
  `verifiedDate` datetime DEFAULT NULL,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `product` (`product`),
  KEY `root` (`root`),
  KEY `status` (`status`),
  KEY `assignedTo` (`assignedTo`),
  KEY `feedback` (`feedback`)
) ENGINE=InnoDB;
CREATE TABLE `zt_storyestimate` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `story` int unsigned NOT NULL DEFAULT 0,
  `round` smallint unsigned NOT NULL DEFAULT 0,
  `estimate` text DEFAULT NULL,
  `average` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `story` (`story`,`round`)
) ENGINE=InnoDB;
CREATE TABLE `zt_storygrade` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL DEFAULT '',
  `grade` tinyint unsigned NOT NULL DEFAULT 0,
  `name` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_storyreview` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `story` int unsigned NOT NULL DEFAULT 0,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `reviewer` varchar(30) NOT NULL DEFAULT '',
  `result` varchar(30) NOT NULL DEFAULT '',
  `reviewDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `story` (`story`,`version`,`reviewer`)
) ENGINE=InnoDB;
CREATE TABLE `zt_storyspec` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `story` int unsigned NOT NULL DEFAULT 0,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `title` varchar(255) NOT NULL DEFAULT '',
  `spec` mediumtext DEFAULT NULL,
  `verify` mediumtext DEFAULT NULL,
  `files` text DEFAULT NULL,
  `docs` text DEFAULT NULL,
  `docVersions` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `story` (`story`,`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_storystage` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `story` int unsigned NOT NULL DEFAULT 0,
  `branch` int unsigned NOT NULL DEFAULT 0,
  `stage` varchar(50) NOT NULL DEFAULT '',
  `stagedBy` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `story_branch` (`story`,`branch`),
  KEY `story` (`story`)
) ENGINE=InnoDB;
CREATE TABLE `zt_suitecase` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `suite` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `case` int unsigned NOT NULL DEFAULT 0,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  UNIQUE KEY `suitecase` (`suite`,`case`)
) ENGINE=InnoDB;
CREATE TABLE `zt_system` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `product` int unsigned NOT NULL DEFAULT 0,
  `integrated` tinyint unsigned NOT NULL DEFAULT 0,
  `latestRelease` int unsigned NOT NULL DEFAULT 0,
  `latestDate` datetime DEFAULT NULL,
  `children` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(10) NOT NULL DEFAULT 'active',
  `desc` mediumtext DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_product` (`product`),
  KEY `idx_status` (`status`)
) ENGINE=InnoDB;
CREATE TABLE `zt_task` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `parent` int unsigned NOT NULL DEFAULT 0,
  `isParent` tinyint unsigned NOT NULL DEFAULT 0,
  `isTpl` tinyint unsigned NOT NULL DEFAULT 0,
  `path` varchar(255) NOT NULL DEFAULT '',
  `execution` int unsigned NOT NULL DEFAULT 0,
  `module` int unsigned NOT NULL DEFAULT 0,
  `design` int unsigned NOT NULL DEFAULT 0,
  `story` int unsigned NOT NULL DEFAULT 0,
  `storyVersion` smallint unsigned NOT NULL DEFAULT 1,
  `designVersion` smallint unsigned NOT NULL DEFAULT 1,
  `fromBug` int unsigned NOT NULL DEFAULT 0,
  `feedback` int unsigned NOT NULL DEFAULT 0,
  `fromIssue` int unsigned NOT NULL DEFAULT 0,
  `docs` text DEFAULT NULL,
  `docVersions` text DEFAULT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT '',
  `mode` varchar(10) NOT NULL DEFAULT '',
  `pri` tinyint unsigned NOT NULL DEFAULT 0,
  `estimate` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `consumed` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `left` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `deadline` date DEFAULT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `color` char(7) NOT NULL DEFAULT '',
  `mailto` text DEFAULT NULL,
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `estStarted` date DEFAULT NULL,
  `realStarted` datetime DEFAULT NULL,
  `finishedBy` varchar(30) NOT NULL DEFAULT '',
  `finishedDate` datetime DEFAULT NULL,
  `finishedList` text DEFAULT NULL,
  `canceledBy` varchar(30) NOT NULL DEFAULT '',
  `canceledDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `planDuration` int unsigned NOT NULL DEFAULT 0,
  `realDuration` int unsigned NOT NULL DEFAULT 0,
  `closedReason` varchar(30) NOT NULL DEFAULT '',
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `activatedDate` datetime DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT 0,
  `repo` int unsigned NOT NULL DEFAULT 0,
  `mr` int unsigned NOT NULL DEFAULT 0,
  `entry` varchar(255) NOT NULL DEFAULT '',
  `lines` varchar(10) NOT NULL DEFAULT '',
  `v1` varchar(40) NOT NULL DEFAULT '',
  `v2` varchar(40) NOT NULL DEFAULT '',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `execution` (`execution`),
  KEY `story` (`story`),
  KEY `parent` (`parent`),
  KEY `path` (`path`),
  KEY `assignedTo` (`assignedTo`),
  KEY `order` (`order`),
  KEY `feedback` (`feedback`)
) ENGINE=InnoDB;
CREATE TABLE `zt_taskestimate` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `task` int unsigned NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `left` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `consumed` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `account` varchar(30) NOT NULL DEFAULT '',
  `work` text DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `task` (`task`)
) ENGINE=InnoDB;
CREATE TABLE `zt_taskspec` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `task` int unsigned NOT NULL DEFAULT 0,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `name` varchar(255) NOT NULL DEFAULT '',
  `estStarted` date DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `task` (`task`,`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_taskteam` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `task` int unsigned NOT NULL DEFAULT 0,
  `account` varchar(30) NOT NULL DEFAULT '',
  `estimate` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `consumed` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `left` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `transfer` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `storyVersion` smallint unsigned NOT NULL DEFAULT 1,
  `order` int unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `task` (`task`)
) ENGINE=InnoDB;
CREATE TABLE `zt_team` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `root` int unsigned NOT NULL DEFAULT 0,
  `type` varchar(10) NOT NULL DEFAULT 'project',
  `account` varchar(30) NOT NULL DEFAULT '',
  `role` varchar(30) NOT NULL DEFAULT '',
  `position` varchar(30) NOT NULL DEFAULT '',
  `limited` varchar(8) NOT NULL DEFAULT 'no',
  `join` date DEFAULT NULL,
  `days` smallint unsigned NOT NULL DEFAULT 0,
  `hours` decimal(3,1) unsigned NOT NULL DEFAULT 0.0,
  `estimate` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `consumed` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `left` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `order` int unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `team` (`root`,`type`,`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_testreport` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `execution` int unsigned NOT NULL DEFAULT 0,
  `tasks` varchar(255) NOT NULL DEFAULT '',
  `builds` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `owner` varchar(30) NOT NULL DEFAULT '',
  `members` text DEFAULT NULL,
  `stories` text DEFAULT NULL,
  `bugs` text DEFAULT NULL,
  `cases` text DEFAULT NULL,
  `report` text DEFAULT NULL,
  `objectType` varchar(10) NOT NULL DEFAULT '',
  `objectID` int unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_testresult` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `run` int unsigned NOT NULL DEFAULT 0,
  `case` int unsigned NOT NULL DEFAULT 0,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `job` int unsigned NOT NULL DEFAULT 0,
  `compile` int unsigned NOT NULL DEFAULT 0,
  `caseResult` varchar(30) NOT NULL DEFAULT '',
  `stepResults` text DEFAULT NULL,
  `ZTFResult` text DEFAULT NULL,
  `node` int unsigned NOT NULL DEFAULT 0,
  `lastRunner` varchar(30) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  `duration` decimal(10,3) unsigned NOT NULL DEFAULT 0.000,
  `xml` text DEFAULT NULL,
  `deploy` int unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `case` (`case`),
  KEY `version` (`version`),
  KEY `run` (`run`)
) ENGINE=InnoDB;
CREATE TABLE `zt_testrun` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `task` int unsigned NOT NULL DEFAULT 0,
  `case` int unsigned NOT NULL DEFAULT 0,
  `version` smallint unsigned NOT NULL DEFAULT 1,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `lastRunner` varchar(30) NOT NULL DEFAULT '',
  `lastRunDate` datetime DEFAULT NULL,
  `lastRunResult` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `task` (`task`,`case`)
) ENGINE=InnoDB;
CREATE TABLE `zt_testsuite` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `product` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `type` varchar(20) NOT NULL DEFAULT '',
  `order` int unsigned NOT NULL DEFAULT 0,
  `addedBy` varchar(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `product` (`product`)
) ENGINE=InnoDB;
CREATE TABLE `zt_testtask` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '测试单编号',
  `project` int unsigned NOT NULL DEFAULT 0 COMMENT '所属项目',
  `product` int unsigned NOT NULL DEFAULT 0 COMMENT '所属产品',
  `name` varchar(90) NOT NULL DEFAULT '' COMMENT '测试单名称',
  `execution` int unsigned NOT NULL DEFAULT 0 COMMENT '所属执行',
  `build` int unsigned NOT NULL DEFAULT 0 COMMENT '所属构建',
  `joint` tinyint unsigned NOT NULL DEFAULT 0 COMMENT '是否为联调测试单',
  `type` varchar(255) NOT NULL DEFAULT '' COMMENT '类型',
  `owner` varchar(30) NOT NULL DEFAULT '' COMMENT '负责人',
  `pri` tinyint unsigned NOT NULL DEFAULT 0 COMMENT '优先级',
  `begin` date DEFAULT NULL COMMENT '计划开始日期',
  `end` date DEFAULT NULL COMMENT '计划结束日期',
  `realBegan` date DEFAULT NULL COMMENT '实际开始日期',
  `realFinishedDate` datetime DEFAULT NULL COMMENT '实际完成时间',
  `mailto` text DEFAULT NULL COMMENT '抄送人',
  `desc` mediumtext DEFAULT NULL COMMENT '描述',
  `report` text DEFAULT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'wait' COMMENT '状态',
  `testreport` int unsigned NOT NULL DEFAULT 0 COMMENT '相关联的测试报告',
  `auto` varchar(10) NOT NULL DEFAULT 'no' COMMENT '是否为自动化测试',
  `subStatus` varchar(30) NOT NULL DEFAULT '' COMMENT '子状态',
  `createdBy` varchar(30) NOT NULL DEFAULT '' COMMENT '由谁创建',
  `createdDate` datetime DEFAULT NULL COMMENT '创建时间',
  `members` text DEFAULT NULL COMMENT '团队成员',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0 COMMENT '是否删除',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `build` (`build`)
) ENGINE=InnoDB;
CREATE TABLE `zt_testtaskproduct` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT '编号',
  `product` int unsigned NOT NULL DEFAULT 0 COMMENT '所属产品',
  `build` int unsigned NOT NULL DEFAULT 0 COMMENT '所属构建',
  `task` int unsigned NOT NULL DEFAULT 0 COMMENT '所属测试单',
  `execution` int unsigned NOT NULL DEFAULT 0 COMMENT '所属执行',
  `project` int unsigned NOT NULL DEFAULT 0 COMMENT '所属项目',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_productbuild` (`product`,`build`,`task`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ticket` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `product` int unsigned NOT NULL DEFAULT 0,
  `module` int unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `openedBuild` varchar(255) NOT NULL DEFAULT '',
  `feedback` int unsigned NOT NULL DEFAULT 0,
  `assignedTo` varchar(255) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `realStarted` datetime DEFAULT NULL,
  `startedBy` varchar(255) NOT NULL DEFAULT '',
  `startedDate` datetime DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `pri` tinyint unsigned NOT NULL DEFAULT 0,
  `estimate` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `left` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `status` varchar(30) NOT NULL DEFAULT '',
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `activatedCount` int unsigned NOT NULL DEFAULT 0,
  `activatedBy` varchar(30) NOT NULL DEFAULT '',
  `activatedDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `closedReason` varchar(30) NOT NULL DEFAULT '',
  `finishedBy` varchar(30) NOT NULL DEFAULT '',
  `finishedDate` datetime DEFAULT NULL,
  `resolvedBy` varchar(30) NOT NULL DEFAULT '',
  `resolvedDate` datetime DEFAULT NULL,
  `resolution` text DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `repeatTicket` int unsigned NOT NULL DEFAULT 0,
  `mailto` varchar(255) NOT NULL DEFAULT '',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `feedback` (`feedback`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ticketrelation` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ticketId` int unsigned NOT NULL DEFAULT 0,
  `objectId` int unsigned NOT NULL DEFAULT 0,
  `objectType` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `ticketId` (`ticketId`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ticketsource` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `ticketId` int unsigned NOT NULL DEFAULT 0,
  `customer` varchar(100) NOT NULL DEFAULT '',
  `contact` varchar(100) NOT NULL DEFAULT '',
  `notifyEmail` varchar(100) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticketId` (`ticketId`)
) ENGINE=InnoDB;
CREATE TABLE `zt_todo` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `account` varchar(30) NOT NULL DEFAULT '',
  `date` date DEFAULT NULL,
  `begin` char(4) NOT NULL DEFAULT '',
  `end` char(4) NOT NULL DEFAULT '',
  `feedback` int unsigned NOT NULL DEFAULT 0,
  `type` varchar(15) NOT NULL DEFAULT '',
  `cycle` tinyint unsigned NOT NULL DEFAULT 0,
  `objectID` int unsigned NOT NULL DEFAULT 0,
  `pri` tinyint unsigned NOT NULL DEFAULT 0,
  `name` varchar(150) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `private` tinyint unsigned NOT NULL DEFAULT 0,
  `config` varchar(1000) NOT NULL DEFAULT '',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `finishedBy` varchar(30) NOT NULL DEFAULT '',
  `finishedDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `assignedTo` (`assignedTo`),
  KEY `finishedBy` (`finishedBy`),
  KEY `date` (`date`),
  KEY `feedback` (`feedback`)
) ENGINE=InnoDB;
CREATE TABLE `zt_traincategory` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `parent` int unsigned NOT NULL DEFAULT 0,
  `path` varchar(255) NOT NULL DEFAULT '',
  `grade` tinyint unsigned NOT NULL DEFAULT 0,
  `order` int unsigned NOT NULL DEFAULT 0,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `path` (`path`)
) ENGINE=InnoDB;
CREATE TABLE `zt_traincontents` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(50) NOT NULL DEFAULT '',
  `course` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `parent` int unsigned NOT NULL DEFAULT 0,
  `path` varchar(255) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_traincourse` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL DEFAULT '',
  `category` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(10) NOT NULL DEFAULT '',
  `teacher` varchar(30) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `importedStatus` varchar(10) NOT NULL DEFAULT '',
  `lastUpdatedTime` int unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(255) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(255) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_trainplan` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `place` varchar(255) NOT NULL DEFAULT '',
  `trainee` text DEFAULT NULL,
  `lecturer` varchar(20) NOT NULL DEFAULT '',
  `type` varchar(10) NOT NULL DEFAULT 'inside',
  `status` varchar(20) NOT NULL DEFAULT '',
  `summary` mediumtext DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_trainrecords` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user` varchar(30) NOT NULL DEFAULT '',
  `objectId` int unsigned NOT NULL DEFAULT 0,
  `objectType` varchar(10) NOT NULL DEFAULT '',
  `status` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`user`,`objectId`,`objectType`)
) ENGINE=InnoDB;
CREATE TABLE `zt_trip` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(10) NOT NULL DEFAULT 'trip',
  `customers` varchar(20) NOT NULL DEFAULT '',
  `name` varchar(30) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `year` char(4) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `start` time DEFAULT NULL,
  `finish` time DEFAULT NULL,
  `from` varchar(50) NOT NULL DEFAULT '',
  `to` varchar(50) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `createdBy` (`createdBy`)
) ENGINE=InnoDB;
CREATE TABLE `zt_user` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `company` int unsigned NOT NULL DEFAULT 0,
  `type` varchar(30) NOT NULL DEFAULT 'inside',
  `dept` int unsigned NOT NULL DEFAULT 0,
  `account` varchar(30) NOT NULL DEFAULT '',
  `password` char(32) NOT NULL DEFAULT '',
  `role` varchar(10) NOT NULL DEFAULT '',
  `realname` varchar(100) NOT NULL DEFAULT '',
  `superior` varchar(30) NOT NULL DEFAULT '',
  `pinyin` varchar(255) NOT NULL DEFAULT '',
  `nickname` varchar(60) NOT NULL DEFAULT '',
  `commiter` varchar(100) NOT NULL DEFAULT '',
  `avatar` text DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `gender` char(1) NOT NULL DEFAULT 'f',
  `email` varchar(90) NOT NULL DEFAULT '',
  `skype` varchar(90) NOT NULL DEFAULT '',
  `qq` varchar(20) NOT NULL DEFAULT '',
  `mobile` varchar(20) NOT NULL DEFAULT '',
  `phone` varchar(20) NOT NULL DEFAULT '',
  `weixin` varchar(90) NOT NULL DEFAULT '',
  `dingding` varchar(90) NOT NULL DEFAULT '',
  `slack` varchar(90) NOT NULL DEFAULT '',
  `whatsapp` varchar(90) NOT NULL DEFAULT '',
  `address` varchar(120) NOT NULL DEFAULT '',
  `zipcode` varchar(10) NOT NULL DEFAULT '',
  `nature` text DEFAULT NULL,
  `analysis` text DEFAULT NULL,
  `strategy` text DEFAULT NULL,
  `join` date DEFAULT NULL,
  `visits` int unsigned NOT NULL DEFAULT 0,
  `visions` varchar(20) NOT NULL DEFAULT 'rnd,lite',
  `ip` varchar(255) NOT NULL DEFAULT '',
  `last` datetime DEFAULT NULL,
  `fails` tinyint unsigned NOT NULL DEFAULT 0,
  `locked` datetime DEFAULT NULL,
  `feedback` tinyint unsigned NOT NULL DEFAULT 0,
  `ranzhi` varchar(30) NOT NULL DEFAULT '',
  `ldap` varchar(30) NOT NULL DEFAULT '',
  `score` int unsigned NOT NULL DEFAULT 0,
  `scoreLevel` int unsigned NOT NULL DEFAULT 0,
  `resetToken` varchar(50) NOT NULL DEFAULT '',
  `clientStatus` varchar(10) NOT NULL DEFAULT 'offline',
  `clientLang` varchar(10) NOT NULL DEFAULT 'zh-cn',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `account` (`account`),
  KEY `dept` (`dept`),
  KEY `email` (`email`),
  KEY `commiter` (`commiter`),
  KEY `deleted` (`deleted`)
) ENGINE=InnoDB;
CREATE TABLE `zt_usercontact` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `account` varchar(30) NOT NULL DEFAULT '',
  `listName` varchar(60) NOT NULL DEFAULT '',
  `userList` text DEFAULT NULL,
  `public` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `account` (`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_usergroup` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `account` varchar(30) NOT NULL DEFAULT '',
  `group` int unsigned NOT NULL DEFAULT 0,
  `project` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `account` (`account`,`group`)
) ENGINE=InnoDB;
CREATE TABLE `zt_userquery` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `account` varchar(30) NOT NULL DEFAULT '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `title` varchar(90) NOT NULL DEFAULT '',
  `form` text DEFAULT NULL,
  `sql` text DEFAULT NULL,
  `shortcut` tinyint unsigned NOT NULL DEFAULT 0,
  `common` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `module` (`module`)
) ENGINE=InnoDB;
CREATE TABLE `zt_usertpl` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `account` varchar(30) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `title` varchar(150) NOT NULL DEFAULT '',
  `content` text DEFAULT NULL,
  `public` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `account` (`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_userview` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `account` varchar(30) NOT NULL DEFAULT '',
  `programs` mediumtext DEFAULT NULL,
  `products` mediumtext DEFAULT NULL,
  `projects` mediumtext DEFAULT NULL,
  `sprints` mediumtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `account` (`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_webhook` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(15) NOT NULL DEFAULT 'default',
  `name` varchar(50) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `domain` varchar(255) NOT NULL DEFAULT '',
  `secret` varchar(255) NOT NULL DEFAULT '',
  `contentType` varchar(30) NOT NULL DEFAULT 'application/json',
  `sendType` varchar(10) NOT NULL DEFAULT 'sync',
  `products` text DEFAULT NULL,
  `executions` text DEFAULT NULL,
  `params` varchar(100) NOT NULL DEFAULT '',
  `actions` text DEFAULT NULL,
  `desc` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_weeklyreport` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `weekStart` date DEFAULT NULL,
  `pv` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `ev` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `ac` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `sv` decimal(12,2) NOT NULL DEFAULT 0.00,
  `cv` decimal(12,2) NOT NULL DEFAULT 0.00,
  `staff` smallint unsigned NOT NULL DEFAULT 0,
  `progress` varchar(255) NOT NULL DEFAULT '',
  `workload` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `week` (`project`,`weekStart`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workestimation` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `project` int unsigned NOT NULL DEFAULT 0,
  `scale` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `productivity` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `duration` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `unitLaborCost` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `totalLaborCost` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `dayHour` decimal(10,2) NOT NULL DEFAULT 0.00,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflow` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `group` int unsigned NOT NULL DEFAULT 0,
  `parent` varchar(30) NOT NULL DEFAULT '',
  `child` varchar(30) NOT NULL DEFAULT '',
  `type` varchar(10) NOT NULL DEFAULT 'flow',
  `navigator` varchar(10) NOT NULL DEFAULT '',
  `app` varchar(20) NOT NULL DEFAULT '',
  `position` varchar(30) NOT NULL DEFAULT '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `table` varchar(50) NOT NULL DEFAULT '',
  `name` varchar(30) NOT NULL DEFAULT '',
  `icon` varchar(30) NOT NULL DEFAULT 'flow',
  `titleField` varchar(30) NOT NULL DEFAULT '',
  `contentField` text DEFAULT NULL,
  `flowchart` text DEFAULT NULL,
  `js` text DEFAULT NULL,
  `css` text DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT 0,
  `buildin` tinyint unsigned NOT NULL DEFAULT 0,
  `role` varchar(10) NOT NULL DEFAULT 'buildin',
  `belong` varchar(50) NOT NULL DEFAULT '',
  `administrator` text DEFAULT NULL,
  `desc` text DEFAULT NULL,
  `version` varchar(10) NOT NULL DEFAULT '1.0',
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `approval` varchar(10) NOT NULL DEFAULT 'disabled',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`group`,`app`,`module`,`vision`),
  KEY `type` (`type`),
  KEY `app` (`app`),
  KEY `module` (`module`),
  KEY `order` (`order`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowaction` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `group` int unsigned NOT NULL DEFAULT 0,
  `module` varchar(30) NOT NULL DEFAULT '',
  `action` varchar(50) NOT NULL DEFAULT '',
  `method` varchar(50) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `type` varchar(10) NOT NULL DEFAULT 'single',
  `batchMode` varchar(10) NOT NULL DEFAULT 'different',
  `extensionType` varchar(10) NOT NULL DEFAULT 'override',
  `open` varchar(20) NOT NULL DEFAULT '',
  `position` varchar(20) NOT NULL DEFAULT 'browseandview',
  `layout` varchar(20) NOT NULL DEFAULT '',
  `show` varchar(20) NOT NULL DEFAULT 'dropdownlist',
  `order` int unsigned NOT NULL DEFAULT 0,
  `buildin` tinyint unsigned NOT NULL DEFAULT 0,
  `role` varchar(10) NOT NULL DEFAULT 'custom',
  `virtual` tinyint unsigned NOT NULL DEFAULT 0,
  `conditions` text DEFAULT NULL,
  `verifications` text DEFAULT NULL,
  `hooks` text DEFAULT NULL,
  `linkages` text DEFAULT NULL,
  `js` text DEFAULT NULL,
  `css` text DEFAULT NULL,
  `toList` varchar(255) NOT NULL DEFAULT '',
  `blocks` text DEFAULT NULL,
  `desc` text DEFAULT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'enable',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`group`,`module`,`action`,`vision`),
  KEY `module` (`module`),
  KEY `action` (`action`),
  KEY `order` (`order`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowdatasource` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(10) NOT NULL DEFAULT 'option',
  `name` varchar(30) NOT NULL DEFAULT '',
  `code` varchar(30) NOT NULL DEFAULT '',
  `datasource` text DEFAULT NULL,
  `view` varchar(20) NOT NULL DEFAULT '',
  `keyField` varchar(50) NOT NULL DEFAULT '',
  `valueField` varchar(50) NOT NULL DEFAULT '',
  `buildin` tinyint unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowfield` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `group` int unsigned NOT NULL DEFAULT 0,
  `module` varchar(30) NOT NULL DEFAULT '',
  `field` varchar(50) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT 'varchar',
  `length` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `control` varchar(20) NOT NULL DEFAULT '',
  `expression` text DEFAULT NULL,
  `options` text DEFAULT NULL,
  `default` varchar(100) NOT NULL DEFAULT '',
  `rules` varchar(255) NOT NULL DEFAULT '',
  `placeholder` varchar(255) NOT NULL DEFAULT '',
  `order` int unsigned NOT NULL DEFAULT 0,
  `searchOrder` smallint unsigned NOT NULL DEFAULT 0,
  `exportOrder` smallint unsigned NOT NULL DEFAULT 0,
  `canExport` tinyint unsigned NOT NULL DEFAULT 0,
  `canSearch` tinyint unsigned NOT NULL DEFAULT 0,
  `isValue` tinyint unsigned NOT NULL DEFAULT 0,
  `readonly` tinyint unsigned NOT NULL DEFAULT 0,
  `buildin` tinyint unsigned NOT NULL DEFAULT 0,
  `role` varchar(10) NOT NULL DEFAULT 'custom',
  `desc` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`group`,`module`,`field`),
  KEY `module` (`module`),
  KEY `field` (`field`),
  KEY `order` (`order`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowgroup` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `objectID` int unsigned NOT NULL DEFAULT 0,
  `type` varchar(10) NOT NULL DEFAULT '',
  `projectModel` varchar(10) NOT NULL DEFAULT '',
  `projectType` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `code` varchar(30) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `disabledModules` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `main` tinyint unsigned NOT NULL DEFAULT 0,
  `exclusive` tinyint unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deliverable` text DEFAULT NULL,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowlabel` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `group` int unsigned NOT NULL DEFAULT 0,
  `module` varchar(30) NOT NULL DEFAULT '',
  `action` varchar(30) NOT NULL DEFAULT 'browse',
  `code` varchar(30) NOT NULL DEFAULT '',
  `label` varchar(255) NOT NULL DEFAULT '',
  `params` text DEFAULT NULL,
  `orderBy` text DEFAULT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT 0,
  `buildin` tinyint unsigned NOT NULL DEFAULT 0,
  `role` varchar(10) NOT NULL DEFAULT 'custom',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`module`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowlayout` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `group` int unsigned NOT NULL DEFAULT 0,
  `module` varchar(30) NOT NULL DEFAULT '',
  `action` varchar(50) NOT NULL DEFAULT '',
  `ui` int unsigned NOT NULL DEFAULT 0,
  `field` varchar(50) NOT NULL DEFAULT '',
  `order` int unsigned NOT NULL DEFAULT 0,
  `width` smallint unsigned NOT NULL DEFAULT 0,
  `position` text DEFAULT NULL,
  `readonly` tinyint unsigned NOT NULL DEFAULT 0,
  `mobileShow` tinyint unsigned NOT NULL DEFAULT 1,
  `summary` varchar(20) NOT NULL DEFAULT '',
  `defaultValue` text DEFAULT NULL,
  `layoutRules` varchar(255) NOT NULL DEFAULT '',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`group`,`module`,`action`,`ui`,`field`,`vision`),
  KEY `module` (`module`),
  KEY `action` (`action`),
  KEY `order` (`order`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowlinkdata` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` int unsigned NOT NULL DEFAULT 0,
  `linkedType` varchar(30) NOT NULL DEFAULT '',
  `linkedID` int unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`objectType`,`objectID`,`linkedType`,`linkedID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowrelation` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `prev` varchar(30) NOT NULL DEFAULT '',
  `next` varchar(30) NOT NULL DEFAULT '',
  `field` varchar(50) NOT NULL DEFAULT '',
  `actions` varchar(20) NOT NULL DEFAULT '',
  `actionCodes` text DEFAULT NULL,
  `buildin` tinyint unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowrelationlayout` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `prev` varchar(30) NOT NULL DEFAULT '',
  `next` varchar(30) NOT NULL DEFAULT '',
  `action` varchar(50) NOT NULL DEFAULT '',
  `ui` int unsigned NOT NULL DEFAULT 0,
  `field` varchar(50) NOT NULL DEFAULT '',
  `order` int unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`prev`,`next`,`action`,`ui`,`field`),
  KEY `prev` (`prev`),
  KEY `next` (`next`),
  KEY `action` (`action`),
  KEY `order` (`order`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowreport` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL DEFAULT '',
  `name` varchar(100) NOT NULL DEFAULT '',
  `type` varchar(10) NOT NULL DEFAULT 'pie',
  `countType` varchar(10) NOT NULL DEFAULT 'sum',
  `displayType` varchar(10) NOT NULL DEFAULT 'value',
  `dimension` varchar(130) NOT NULL DEFAULT '',
  `fields` text DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowrule` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(10) NOT NULL DEFAULT 'regex',
  `name` varchar(30) NOT NULL DEFAULT '',
  `rule` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowsql` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL DEFAULT '',
  `field` varchar(50) NOT NULL DEFAULT '',
  `action` varchar(50) NOT NULL DEFAULT '',
  `sql` text DEFAULT NULL,
  `vars` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`module`),
  KEY `field` (`field`),
  KEY `action` (`action`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowui` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `group` int unsigned NOT NULL DEFAULT 0,
  `module` varchar(30) NOT NULL DEFAULT '',
  `action` varchar(50) NOT NULL DEFAULT '',
  `name` varchar(30) NOT NULL DEFAULT '',
  `conditions` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`module`),
  KEY `action` (`action`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowversion` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL DEFAULT '',
  `version` varchar(10) NOT NULL DEFAULT '',
  `fields` text DEFAULT NULL,
  `actions` text DEFAULT NULL,
  `layouts` text DEFAULT NULL,
  `sqls` text DEFAULT NULL,
  `labels` text DEFAULT NULL,
  `table` text DEFAULT NULL,
  `datas` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `moduleversion` (`module`,`version`),
  KEY `module` (`module`),
  KEY `version` (`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_zoutput` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `activity` int unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `content` mediumtext DEFAULT NULL,
  `optional` varchar(20) NOT NULL DEFAULT '',
  `tailorNorm` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT 0,
  `deleted` tinyint unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
