CREATE TABLE `im_chat` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `gid` char(40) NOT NULL DEFAULT '',
  `name` varchar(60) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT 'group',
  `admins` varchar(255) NOT NULL DEFAULT '',
  `committers` varchar(255) NOT NULL DEFAULT '',
  `subject` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `public` enum('0','1') NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `ownedBy` varchar(30) NOT NULL DEFAULT '',
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `mergedDate` datetime DEFAULT NULL,
  `lastActiveTime` datetime DEFAULT NULL,
  `lastMessage` int(11) unsigned NOT NULL DEFAULT 0,
  `lastMessageIndex` int(11) unsigned NOT NULL DEFAULT 0,
  `dismissDate` datetime DEFAULT NULL,
  `pinnedMessages` text DEFAULT NULL,
  `mergedChats` text DEFAULT NULL,
  `adminInvite` enum('0','1') NOT NULL DEFAULT '0',
  `avatar` text DEFAULT NULL,
  `archiveDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gid` (`gid`),
  KEY `name` (`name`),
  KEY `type` (`type`),
  KEY `public` (`public`),
  KEY `createdBy` (`createdBy`),
  KEY `editedBy` (`editedBy`)
) ENGINE=InnoDB;
CREATE TABLE `im_chat_message_index` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `gid` char(40) NOT NULL,
  `tableName` char(64) NOT NULL,
  `start` int(11) unsigned NOT NULL,
  `end` int(11) unsigned NOT NULL,
  `startIndex` int(11) unsigned NOT NULL,
  `endIndex` int(11) unsigned NOT NULL,
  `startDate` datetime DEFAULT NULL,
  `endDate` datetime DEFAULT NULL,
  `count` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `chattable` (`gid`,`tableName`),
  KEY `start` (`start`),
  KEY `end` (`end`),
  KEY `startDate` (`startDate`),
  KEY `endDate` (`endDate`),
  KEY `chatstartindex` (`gid`,`startIndex`),
  KEY `chatendindex` (`gid`,`endIndex`)
) ENGINE=InnoDB;
CREATE TABLE `im_chatuser` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `cgid` char(40) NOT NULL DEFAULT '',
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `order` smallint(5) NOT NULL DEFAULT 0,
  `star` enum('0','1') NOT NULL DEFAULT '0',
  `hide` enum('0','1') NOT NULL DEFAULT '0',
  `mute` enum('0','1') NOT NULL DEFAULT '0',
  `freeze` enum('0','1') NOT NULL DEFAULT '0',
  `join` datetime DEFAULT NULL,
  `quit` datetime DEFAULT NULL,
  `category` varchar(40) NOT NULL DEFAULT '',
  `lastReadMessage` int(11) unsigned NOT NULL DEFAULT 0,
  `lastReadMessageIndex` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `chatuser` (`cgid`,`user`),
  KEY `cgid` (`cgid`),
  KEY `user` (`user`),
  KEY `order` (`order`),
  KEY `star` (`star`),
  KEY `hide` (`hide`)
) ENGINE=InnoDB;
CREATE TABLE `im_client` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` char(30) NOT NULL DEFAULT '',
  `desc` varchar(100) NOT NULL DEFAULT '',
  `changeLog` text DEFAULT NULL,
  `strategy` varchar(10) NOT NULL DEFAULT '',
  `downloads` text DEFAULT NULL,
  `createdDate` datetime DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `status` enum('released','wait') NOT NULL DEFAULT 'wait',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `im_conference` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `rid` char(40) NOT NULL DEFAULT '',
  `cgid` char(40) NOT NULL DEFAULT '',
  `status` enum('closed','open','notStarted','canceled') NOT NULL DEFAULT 'closed',
  `participants` text DEFAULT NULL,
  `subscribers` text DEFAULT NULL,
  `invitee` text DEFAULT NULL,
  `openedBy` mediumint(8) NOT NULL DEFAULT 0,
  `openedDate` datetime DEFAULT NULL,
  `topic` text DEFAULT NULL,
  `startTime` datetime DEFAULT NULL,
  `endTime` datetime DEFAULT NULL,
  `password` char(20) NOT NULL DEFAULT '',
  `type` enum('default','periodic','scheduled') NOT NULL DEFAULT 'default',
  `number` char(20) NOT NULL DEFAULT '',
  `note` text DEFAULT NULL,
  `sentNotify` tinyint(1) NOT NULL DEFAULT 0,
  `reminderTime` int(11) NOT NULL DEFAULT 0,
  `moderators` text DEFAULT NULL,
  `isPrivate` enum('0','1') NOT NULL DEFAULT '0',
  `isInner` enum('0','1') NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB;
CREATE TABLE `im_conferenceaction` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `rid` char(40) NOT NULL DEFAULT '',
  `type` enum('create','invite','join','leave','close','publish') NOT NULL DEFAULT 'create',
  `data` text DEFAULT NULL,
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `date` datetime DEFAULT NULL,
  `device` char(40) NOT NULL DEFAULT 'default',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `im_conferenceinvite` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `conferenceID` mediumint(8) unsigned NOT NULL,
  `inviteeID` mediumint(8) unsigned NOT NULL,
  `status` enum('pending','accepted','rejected') NOT NULL DEFAULT 'pending',
  `createdDate` datetime DEFAULT NULL,
  `updatedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `conference_user` (`conferenceID`,`inviteeID`)
) ENGINE=InnoDB;
CREATE TABLE `im_conferenceuser` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `conference` mediumint(8) NOT NULL DEFAULT 0,
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `hide` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `conferenceuser` (`conference`,`user`)
) ENGINE=InnoDB;
CREATE TABLE `im_message` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `gid` char(40) NOT NULL DEFAULT '',
  `cgid` char(40) NOT NULL DEFAULT '',
  `user` varchar(30) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  `index` int(11) unsigned NOT NULL DEFAULT 0,
  `type` enum('normal','broadcast','notify','bulletin','botcommand') NOT NULL DEFAULT 'normal',
  `content` text DEFAULT NULL,
  `contentType` enum('text','plain','emotion','image','file','object','code') NOT NULL DEFAULT 'text',
  `data` text DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `legacy` tinyint(1) NOT NULL DEFAULT 0,
  `uniqueIndex` int(11) GENERATED ALWAYS AS (case when `legacy` = 1 then NULL when `cgid` = 'notification' then NULL else `index` end) STORED,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniqueIndexInChat` (`cgid`,`uniqueIndex`),
  KEY `mgid` (`gid`),
  KEY `mcgid` (`cgid`),
  KEY `muser` (`user`),
  KEY `mtype` (`type`)
) ENGINE=InnoDB;
CREATE TABLE `im_message_backup` (
  `id` int(11) unsigned NOT NULL,
  `gid` char(40) NOT NULL DEFAULT '',
  `cgid` char(40) NOT NULL DEFAULT '',
  `user` varchar(30) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  `index` int(11) unsigned NOT NULL DEFAULT 0,
  `type` enum('normal','broadcast','notify') NOT NULL DEFAULT 'normal',
  `content` text DEFAULT NULL,
  `contentType` enum('text','plain','emotion','image','file','object','code') NOT NULL DEFAULT 'text',
  `data` text DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0'
) ENGINE=InnoDB;
CREATE TABLE `im_message_index` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `tableName` char(64) NOT NULL,
  `start` int(11) unsigned NOT NULL,
  `end` int(11) unsigned NOT NULL,
  `startDate` datetime DEFAULT NULL,
  `endDate` datetime DEFAULT NULL,
  `chats` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tableName` (`tableName`),
  KEY `start` (`start`),
  KEY `end` (`end`),
  KEY `startDate` (`startDate`),
  KEY `endDate` (`endDate`)
) ENGINE=InnoDB;
CREATE TABLE `im_messagestatus` (
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `message` int(11) unsigned NOT NULL,
  `status` enum('waiting','sent','readed','deleted') NOT NULL DEFAULT 'waiting',
  UNIQUE KEY `user` (`user`,`message`)
) ENGINE=InnoDB;
CREATE TABLE `im_queue` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` char(30) NOT NULL,
  `content` text DEFAULT NULL,
  `addDate` datetime DEFAULT NULL,
  `processDate` datetime DEFAULT NULL,
  `result` text DEFAULT NULL,
  `status` char(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `im_userdevice` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `user` mediumint(8) NOT NULL DEFAULT 0,
  `device` char(40) NOT NULL DEFAULT 'default',
  `deviceID` char(40) NOT NULL DEFAULT '',
  `token` char(64) NOT NULL DEFAULT '',
  `validUntil` datetime DEFAULT NULL,
  `lastLogin` datetime DEFAULT NULL,
  `lastLogout` datetime DEFAULT NULL,
  `online` tinyint(1) NOT NULL DEFAULT 0,
  `version` char(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `userdevice` (`user`,`device`),
  KEY `user` (`user`),
  KEY `lastLogin` (`lastLogin`),
  KEY `lastLogout` (`lastLogout`)
) ENGINE=InnoDB;
CREATE TABLE `zt_account` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `provider` varchar(255) NOT NULL DEFAULT '',
  `adminURI` varchar(255) NOT NULL DEFAULT '',
  `account` varchar(255) NOT NULL DEFAULT '',
  `password` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `mobile` varchar(255) NOT NULL DEFAULT '',
  `extra` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `provider` (`provider`),
  KEY `status` (`status`)
) ENGINE=InnoDB;
CREATE TABLE `zt_acl` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL DEFAULT '',
  `objectType` char(30) NOT NULL DEFAULT '',
  `objectID` mediumint(9) NOT NULL DEFAULT 0,
  `type` char(40) NOT NULL DEFAULT 'whitelist',
  `source` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_action` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `product` text DEFAULT NULL,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `execution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `actor` varchar(100) NOT NULL DEFAULT '',
  `action` varchar(80) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  `comment` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `read` enum('0','1') NOT NULL DEFAULT '0',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `efforted` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `date` (`date`),
  KEY `actor` (`actor`),
  KEY `project` (`project`),
  KEY `action` (`action`),
  KEY `objectID` (`objectID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_actionrecent` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `product` text DEFAULT NULL,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `execution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `actor` varchar(100) NOT NULL DEFAULT '',
  `action` varchar(80) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  `comment` text DEFAULT NULL,
  `extra` text DEFAULT NULL,
  `read` enum('0','1') NOT NULL DEFAULT '0',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `efforted` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `date` (`date`),
  KEY `actor` (`actor`),
  KEY `project` (`project`),
  KEY `action` (`action`),
  KEY `objectID` (`objectID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_activity` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `process` mediumint(9) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `optional` varchar(255) NOT NULL DEFAULT '',
  `tailorNorm` varchar(255) NOT NULL DEFAULT '',
  `content` mediumtext DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `order` mediumint(8) DEFAULT 0,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_assistant` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `modelId` mediumint(8) unsigned NOT NULL,
  `desc` text NOT NULL,
  `systemMessage` text NOT NULL,
  `greetings` text NOT NULL,
  `icon` varchar(30) NOT NULL DEFAULT 'coding-1',
  `enabled` enum('0','1') NOT NULL DEFAULT '1',
  `createdDate` datetime NOT NULL,
  `publishedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_message` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `appID` mediumint(8) unsigned NOT NULL,
  `user` mediumint(8) unsigned NOT NULL,
  `type` enum('req','res','ntf') NOT NULL,
  `content` text NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_miniprogram` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `category` varchar(30) NOT NULL,
  `desc` text DEFAULT NULL,
  `model` mediumint(8) unsigned DEFAULT NULL,
  `icon` varchar(30) NOT NULL DEFAULT 'writinghand-7',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `published` enum('0','1') NOT NULL DEFAULT '0',
  `publishedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `prompt` text NOT NULL,
  `builtIn` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_miniprogramfield` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `appID` mediumint(8) unsigned NOT NULL,
  `name` varchar(30) NOT NULL,
  `type` enum('radio','checkbox','text','textarea') DEFAULT 'text',
  `placeholder` text DEFAULT NULL,
  `options` text DEFAULT NULL,
  `required` enum('0','1') DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_miniprogramstar` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `appID` mediumint(8) unsigned NOT NULL,
  `userID` mediumint(8) unsigned NOT NULL,
  `createdDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `appID` (`appID`,`userID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_model` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `vendor` varchar(20) NOT NULL,
  `credentials` text NOT NULL,
  `proxy` text DEFAULT NULL,
  `name` varchar(20) DEFAULT NULL,
  `desc` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) DEFAULT NULL,
  `editedDate` datetime DEFAULT NULL,
  `enabled` enum('0','1') NOT NULL DEFAULT '1',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_prompt` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `desc` text DEFAULT NULL,
  `model` mediumint(8) unsigned DEFAULT NULL,
  `module` varchar(30) DEFAULT NULL,
  `source` text DEFAULT NULL,
  `targetForm` varchar(30) DEFAULT NULL,
  `purpose` text DEFAULT NULL,
  `elaboration` text DEFAULT NULL,
  `role` text DEFAULT NULL,
  `characterization` text DEFAULT NULL,
  `status` enum('draft','active') NOT NULL DEFAULT 'draft',
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `editedBy` varchar(30) DEFAULT NULL,
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ai_promptrole` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) DEFAULT NULL,
  `desc` text DEFAULT NULL,
  `model` mediumint(8) unsigned DEFAULT NULL,
  `role` text DEFAULT NULL,
  `characterization` text DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_api` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `product` varchar(255) NOT NULL DEFAULT '',
  `lib` int(11) unsigned NOT NULL DEFAULT 0,
  `module` int(11) unsigned NOT NULL DEFAULT 0,
  `title` varchar(100) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `protocol` varchar(10) NOT NULL DEFAULT '',
  `method` varchar(10) NOT NULL DEFAULT '',
  `requestType` varchar(100) NOT NULL DEFAULT '',
  `responseType` varchar(100) NOT NULL DEFAULT '',
  `status` varchar(20) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '0',
  `desc` mediumtext DEFAULT NULL,
  `version` smallint(6) unsigned NOT NULL DEFAULT 0,
  `params` text DEFAULT NULL,
  `paramsExample` text DEFAULT NULL,
  `responseExample` text DEFAULT NULL,
  `response` text DEFAULT NULL,
  `commonParams` text DEFAULT NULL,
  `addedBy` varchar(30) NOT NULL DEFAULT '0',
  `addedDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_api_lib_release` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `lib` int(11) unsigned NOT NULL DEFAULT 0,
  `desc` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(255) NOT NULL DEFAULT '',
  `snap` mediumtext DEFAULT NULL,
  `addedBy` varchar(30) NOT NULL DEFAULT '0',
  `addedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_apispec` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `doc` int(11) unsigned NOT NULL DEFAULT 0,
  `module` int(11) unsigned NOT NULL DEFAULT 0,
  `title` varchar(100) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `protocol` varchar(10) NOT NULL DEFAULT '',
  `method` varchar(10) NOT NULL DEFAULT '',
  `requestType` varchar(100) NOT NULL DEFAULT '',
  `responseType` varchar(100) NOT NULL DEFAULT '',
  `status` varchar(20) NOT NULL DEFAULT '',
  `owner` varchar(255) NOT NULL DEFAULT '0',
  `desc` mediumtext DEFAULT NULL,
  `version` smallint(6) unsigned NOT NULL DEFAULT 0,
  `params` text DEFAULT NULL,
  `paramsExample` text DEFAULT NULL,
  `responseExample` text DEFAULT NULL,
  `response` text DEFAULT NULL,
  `addedBy` varchar(30) NOT NULL DEFAULT '0',
  `addedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_apistruct` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `lib` int(11) unsigned NOT NULL DEFAULT 0,
  `name` varchar(30) NOT NULL DEFAULT '',
  `type` varchar(50) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `version` smallint(6) unsigned NOT NULL DEFAULT 0,
  `attribute` text DEFAULT NULL,
  `addedBy` varchar(30) NOT NULL DEFAULT '0',
  `addedDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_apistruct_spec` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(50) NOT NULL DEFAULT '',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `attribute` text DEFAULT NULL,
  `version` smallint(6) unsigned NOT NULL DEFAULT 0,
  `addedBy` varchar(30) NOT NULL DEFAULT '0',
  `addedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_approval` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `flow` mediumint(8) NOT NULL DEFAULT 0,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` mediumint(9) NOT NULL DEFAULT 0,
  `nodes` mediumtext DEFAULT NULL,
  `version` mediumint(9) NOT NULL DEFAULT 0,
  `status` varchar(20) NOT NULL DEFAULT 'doing',
  `result` varchar(20) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_approvalflow` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `code` varchar(100) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `version` mediumint(8) NOT NULL DEFAULT 1,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `workflow` varchar(30) NOT NULL DEFAULT '',
  `deleted` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_approvalflowobject` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `root` int(8) NOT NULL DEFAULT 0,
  `flow` int(8) NOT NULL DEFAULT 0,
  `objectType` char(30) NOT NULL DEFAULT '',
  `objectID` mediumint(9) NOT NULL DEFAULT 0,
  `extra` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_approvalflowspec` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `flow` mediumint(8) NOT NULL DEFAULT 0,
  `version` mediumint(8) NOT NULL DEFAULT 0,
  `nodes` mediumtext DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_approvalnode` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `approval` mediumint(8) NOT NULL DEFAULT 0,
  `type` enum('review','cc') NOT NULL DEFAULT 'review',
  `title` varchar(255) NOT NULL DEFAULT '',
  `account` char(30) NOT NULL DEFAULT '',
  `node` varchar(100) NOT NULL DEFAULT '',
  `reviewType` varchar(100) NOT NULL DEFAULT 'manual',
  `agentType` varchar(100) NOT NULL DEFAULT 'pass',
  `multipleType` enum('and','or') NOT NULL DEFAULT 'and',
  `percent` smallint(6) NOT NULL DEFAULT 0,
  `needAll` enum('0','1') NOT NULL DEFAULT '0',
  `solicit` enum('0','1') NOT NULL DEFAULT '0',
  `prev` mediumtext DEFAULT NULL,
  `next` mediumtext DEFAULT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'wait',
  `result` varchar(10) NOT NULL DEFAULT '',
  `date` date DEFAULT NULL,
  `opinion` mediumtext DEFAULT NULL,
  `extra` mediumtext DEFAULT NULL,
  `revertTo` char(30) NOT NULL DEFAULT '',
  `forwardBy` char(30) NOT NULL DEFAULT '',
  `reviewedBy` char(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_reviewed_date` (`reviewedDate`)
) ENGINE=InnoDB;
CREATE TABLE `zt_approvalobject` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `approval` int(8) NOT NULL DEFAULT 0,
  `objectType` char(30) NOT NULL DEFAULT '',
  `objectID` mediumint(8) NOT NULL DEFAULT 0,
  `extra` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_approvalrole` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `code` char(30) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `users` longtext DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_artifactrepo` (
  `id` smallint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(45) NOT NULL DEFAULT '',
  `products` varchar(255) NOT NULL DEFAULT '',
  `serverID` smallint(8) NOT NULL DEFAULT 0,
  `repoName` varchar(45) NOT NULL DEFAULT '',
  `format` varchar(10) NOT NULL DEFAULT '',
  `type` char(7) NOT NULL DEFAULT '',
  `status` varchar(10) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint(4) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_assetlib` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `order` smallint(5) unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_attend` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL DEFAULT '',
  `date` date DEFAULT NULL,
  `signIn` time DEFAULT NULL,
  `signOut` time DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `ip` varchar(100) NOT NULL DEFAULT '',
  `device` varchar(30) NOT NULL DEFAULT '',
  `client` varchar(20) NOT NULL DEFAULT '',
  `manualIn` time DEFAULT NULL,
  `manualOut` time DEFAULT NULL,
  `reason` varchar(30) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `reviewStatus` varchar(30) DEFAULT NULL,
  `reviewedBy` char(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `attend` (`date`,`account`),
  KEY `account` (`account`),
  KEY `date` (`date`),
  KEY `status` (`status`),
  KEY `reason` (`reason`),
  KEY `reviewStatus` (`reviewStatus`),
  KEY `reviewedBy` (`reviewedBy`)
) ENGINE=InnoDB;
CREATE TABLE `zt_attendstat` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL DEFAULT '',
  `month` char(10) NOT NULL DEFAULT '',
  `normal` decimal(12,2) NOT NULL DEFAULT 0.00,
  `late` decimal(12,2) NOT NULL DEFAULT 0.00,
  `early` decimal(12,2) NOT NULL DEFAULT 0.00,
  `absent` decimal(12,2) NOT NULL DEFAULT 0.00,
  `trip` decimal(12,2) NOT NULL DEFAULT 0.00,
  `egress` decimal(12,2) NOT NULL DEFAULT 0.00,
  `lieu` decimal(12,2) NOT NULL DEFAULT 0.00,
  `paidLeave` decimal(12,2) NOT NULL DEFAULT 0.00,
  `unpaidLeave` decimal(12,2) NOT NULL DEFAULT 0.00,
  `timeOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `restOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `holidayOvertime` decimal(12,2) NOT NULL DEFAULT 0.00,
  `deserve` decimal(12,2) NOT NULL DEFAULT 0.00,
  `actual` decimal(12,2) NOT NULL DEFAULT 0.00,
  `status` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `attend` (`month`,`account`),
  KEY `account` (`account`),
  KEY `month` (`month`),
  KEY `status` (`status`)
) ENGINE=InnoDB;
CREATE TABLE `zt_auditcl` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `model` char(30) NOT NULL DEFAULT 'waterfall',
  `practiceArea` char(30) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `objectType` char(30) NOT NULL DEFAULT '',
  `objectID` int(11) NOT NULL DEFAULT 0,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_auditplan` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `dateType` char(30) NOT NULL DEFAULT '',
  `config` text DEFAULT NULL,
  `objectID` mediumint(9) NOT NULL DEFAULT 0,
  `objectType` char(30) NOT NULL DEFAULT '',
  `process` mediumint(9) NOT NULL DEFAULT 0,
  `processType` char(30) NOT NULL DEFAULT '',
  `checkDate` date DEFAULT NULL,
  `checkedBy` varchar(30) NOT NULL DEFAULT '',
  `realCheckDate` date DEFAULT NULL,
  `result` char(30) NOT NULL DEFAULT '',
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `execution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `checkBy` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_auditresult` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `auditplan` mediumint(8) NOT NULL DEFAULT 0,
  `listID` mediumint(8) NOT NULL DEFAULT 0,
  `result` char(30) NOT NULL DEFAULT '',
  `checkedBy` varchar(30) NOT NULL DEFAULT '',
  `checkedDate` date DEFAULT NULL,
  `comment` text DEFAULT NULL,
  `severity` char(30) NOT NULL DEFAULT '',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_automation` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `node` int(11) unsigned NOT NULL DEFAULT 0,
  `product` int(11) unsigned NOT NULL DEFAULT 0,
  `scriptPath` varchar(255) NOT NULL DEFAULT '',
  `shell` mediumtext DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_basicmeas` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `purpose` varchar(50) NOT NULL DEFAULT '',
  `scope` char(30) NOT NULL DEFAULT '',
  `object` char(30) NOT NULL DEFAULT '',
  `name` varchar(90) NOT NULL DEFAULT '',
  `code` char(30) NOT NULL DEFAULT '',
  `unit` varchar(100) NOT NULL DEFAULT '',
  `configure` text DEFAULT NULL,
  `params` text DEFAULT NULL,
  `definition` text DEFAULT NULL,
  `source` varchar(255) NOT NULL DEFAULT '',
  `collectType` varchar(30) NOT NULL DEFAULT '',
  `collectConf` text DEFAULT NULL,
  `execTime` varchar(30) NOT NULL DEFAULT '',
  `collectedBy` varchar(10) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `order` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB;
CREATE TABLE `zt_block` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL DEFAULT '',
  `dashboard` varchar(20) NOT NULL DEFAULT '',
  `module` varchar(20) NOT NULL DEFAULT '',
  `title` varchar(100) NOT NULL DEFAULT '',
  `block` varchar(30) NOT NULL DEFAULT '',
  `code` varchar(30) NOT NULL DEFAULT '',
  `width` enum('1','2','3') NOT NULL DEFAULT '1',
  `height` smallint(6) unsigned NOT NULL DEFAULT 3,
  `left` enum('0','1','2') NOT NULL DEFAULT '0',
  `top` smallint(5) unsigned NOT NULL DEFAULT 0,
  `params` text DEFAULT NULL,
  `hidden` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  KEY `account` (`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_branch` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `default` enum('0','1') NOT NULL DEFAULT '0',
  `status` enum('active','closed') NOT NULL DEFAULT 'active',
  `desc` varchar(255) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `closedDate` date DEFAULT NULL,
  `order` smallint(6) unsigned NOT NULL DEFAULT 0,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`)
) ENGINE=InnoDB;
CREATE TABLE `zt_budget` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `stage` char(30) NOT NULL DEFAULT '',
  `subject` mediumint(8) NOT NULL DEFAULT 0,
  `amount` char(30) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `lastEditedBy` char(30) NOT NULL DEFAULT '',
  `lastEditedDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_bug` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `injection` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `identify` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `branch` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `module` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `execution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `plan` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `story` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `storyVersion` smallint(6) NOT NULL DEFAULT 1,
  `task` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `toTask` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `toStory` mediumint(8) NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `severity` tinyint(4) NOT NULL DEFAULT 0,
  `pri` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `type` varchar(30) NOT NULL DEFAULT '',
  `os` varchar(255) NOT NULL DEFAULT '',
  `browser` varchar(255) NOT NULL DEFAULT '',
  `hardware` varchar(30) NOT NULL DEFAULT '',
  `found` varchar(30) NOT NULL DEFAULT '',
  `steps` mediumtext DEFAULT NULL,
  `status` enum('active','resolved','closed') NOT NULL DEFAULT 'active',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `color` char(7) NOT NULL DEFAULT '',
  `confirmed` tinyint(1) NOT NULL DEFAULT 0,
  `activatedCount` smallint(6) NOT NULL DEFAULT 0,
  `activatedDate` datetime DEFAULT NULL,
  `feedbackBy` varchar(100) NOT NULL DEFAULT '',
  `notifyEmail` varchar(100) NOT NULL DEFAULT '',
  `mailto` text DEFAULT NULL,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `openedBuild` varchar(255) NOT NULL DEFAULT '',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `resolvedBy` varchar(30) NOT NULL DEFAULT '',
  `resolution` varchar(30) NOT NULL DEFAULT '',
  `resolvedBuild` varchar(30) NOT NULL DEFAULT '',
  `resolvedDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `duplicateBug` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `relatedBug` varchar(255) NOT NULL DEFAULT '',
  `case` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `caseVersion` smallint(6) NOT NULL DEFAULT 1,
  `feedback` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `result` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `repo` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `mr` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `entry` text DEFAULT NULL,
  `lines` varchar(10) NOT NULL DEFAULT '',
  `v1` varchar(255) NOT NULL DEFAULT '',
  `v2` varchar(255) NOT NULL DEFAULT '',
  `repoType` varchar(30) NOT NULL DEFAULT '',
  `issueKey` varchar(50) NOT NULL DEFAULT '',
  `testtask` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`),
  KEY `status` (`status`),
  KEY `plan` (`plan`),
  KEY `story` (`story`),
  KEY `case` (`case`),
  KEY `toStory` (`toStory`),
  KEY `result` (`result`),
  KEY `assignedTo` (`assignedTo`),
  KEY `deleted` (`deleted`),
  KEY `project` (`project`),
  KEY `product_status_deleted` (`product`,`status`,`deleted`)
) ENGINE=InnoDB;
CREATE TABLE `zt_build` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `branch` varchar(255) NOT NULL DEFAULT '0',
  `execution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `builds` varchar(255) NOT NULL DEFAULT '',
  `name` char(150) NOT NULL DEFAULT '',
  `scmPath` char(255) NOT NULL DEFAULT '',
  `filePath` char(255) NOT NULL DEFAULT '',
  `date` date DEFAULT NULL,
  `stories` text DEFAULT NULL,
  `bugs` text DEFAULT NULL,
  `artifactRepoID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `builder` char(30) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`)
) ENGINE=InnoDB;
CREATE TABLE `zt_burn` (
  `execution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `task` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `date` date NOT NULL,
  `estimate` float NOT NULL DEFAULT 0,
  `left` float NOT NULL DEFAULT 0,
  `consumed` float NOT NULL DEFAULT 0,
  `storyPoint` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`execution`,`date`,`task`)
) ENGINE=InnoDB;
CREATE TABLE `zt_case` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `execution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `branch` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `lib` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `module` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `path` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `story` mediumint(30) unsigned NOT NULL DEFAULT 0,
  `storyVersion` smallint(6) NOT NULL DEFAULT 1,
  `title` varchar(255) NOT NULL DEFAULT '',
  `precondition` text DEFAULT NULL,
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `pri` tinyint(3) unsigned NOT NULL DEFAULT 3,
  `type` char(30) NOT NULL DEFAULT '1',
  `auto` varchar(10) NOT NULL DEFAULT 'no',
  `frame` varchar(10) NOT NULL DEFAULT '',
  `stage` varchar(255) NOT NULL DEFAULT '',
  `howRun` varchar(30) NOT NULL DEFAULT '',
  `script` longtext DEFAULT NULL,
  `scriptedBy` varchar(30) NOT NULL DEFAULT '',
  `scriptedDate` date DEFAULT NULL,
  `scriptStatus` varchar(30) NOT NULL DEFAULT '',
  `scriptLocation` varchar(255) NOT NULL DEFAULT '',
  `status` char(30) NOT NULL DEFAULT '1',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `color` char(7) NOT NULL DEFAULT '',
  `frequency` enum('1','2','3') NOT NULL DEFAULT '1',
  `order` tinyint(30) unsigned NOT NULL DEFAULT 0,
  `openedBy` char(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `reviewedBy` varchar(255) NOT NULL DEFAULT '',
  `reviewedDate` date DEFAULT NULL,
  `lastEditedBy` char(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `version` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `linkCase` varchar(255) NOT NULL DEFAULT '',
  `fromBug` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `fromCaseID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `fromCaseVersion` mediumint(8) unsigned NOT NULL DEFAULT 1,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `lastRunner` varchar(30) NOT NULL DEFAULT '',
  `lastRunDate` datetime DEFAULT NULL,
  `lastRunResult` char(30) NOT NULL DEFAULT '',
  `scene` int(11) NOT NULL DEFAULT 0,
  `sort` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `story` (`story`),
  KEY `fromBug` (`fromBug`),
  KEY `module` (`module`),
  KEY `scene` (`scene`)
) ENGINE=InnoDB;
CREATE TABLE `zt_casestep` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `parent` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `case` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `version` smallint(6) unsigned NOT NULL DEFAULT 0,
  `type` varchar(10) NOT NULL DEFAULT 'step',
  `desc` text DEFAULT NULL,
  `expect` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `case` (`case`),
  KEY `version` (`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_cfd` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `execution` int(8) NOT NULL DEFAULT 0,
  `type` char(30) NOT NULL DEFAULT '',
  `name` char(30) NOT NULL DEFAULT '',
  `count` smallint(6) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `execution_type_name_date` (`execution`,`type`,`name`,`date`)
) ENGINE=InnoDB;
CREATE TABLE `zt_chart` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `code` varchar(255) NOT NULL DEFAULT '',
  `driver` enum('mysql','duckdb') NOT NULL DEFAULT 'mysql',
  `mode` enum('text','builder') NOT NULL DEFAULT 'builder',
  `dimension` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `type` varchar(30) NOT NULL DEFAULT '',
  `group` varchar(255) NOT NULL DEFAULT '',
  `dataset` varchar(30) NOT NULL DEFAULT '0',
  `desc` text DEFAULT NULL,
  `acl` enum('open','private') NOT NULL DEFAULT 'open',
  `whitelist` text DEFAULT NULL,
  `settings` mediumtext DEFAULT NULL,
  `filters` mediumtext DEFAULT NULL,
  `step` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `fields` mediumtext DEFAULT NULL,
  `langs` text DEFAULT NULL,
  `sql` mediumtext DEFAULT NULL,
  `stage` enum('draft','published') NOT NULL DEFAULT 'draft',
  `builtin` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `objects` mediumtext DEFAULT NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_charter` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `level` int(8) NOT NULL DEFAULT 0,
  `category` char(30) NOT NULL DEFAULT '',
  `market` varchar(30) NOT NULL DEFAULT '',
  `check` enum('0','1') NOT NULL DEFAULT '0',
  `appliedBy` char(30) NOT NULL DEFAULT '',
  `appliedDate` datetime DEFAULT NULL,
  `budget` char(30) NOT NULL DEFAULT '',
  `budgetUnit` char(30) NOT NULL DEFAULT '',
  `product` text DEFAULT NULL,
  `roadmap` text DEFAULT NULL,
  `spec` mediumtext DEFAULT NULL,
  `status` char(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `charterFiles` text DEFAULT NULL,
  `closedBy` char(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `closedReason` varchar(255) NOT NULL DEFAULT '',
  `activatedBy` char(30) NOT NULL DEFAULT '',
  `activatedDate` datetime DEFAULT NULL,
  `reviewedBy` varchar(255) NOT NULL DEFAULT '',
  `reviewedResult` char(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  `meetingDate` date DEFAULT NULL,
  `meetingLocation` varchar(255) NOT NULL DEFAULT '',
  `meetingMinutes` mediumtext DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_cmcl` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` char(30) NOT NULL DEFAULT '',
  `projectType` varchar(255) NOT NULL DEFAULT '',
  `title` int(11) NOT NULL DEFAULT 0,
  `contents` text DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `order` int(11) NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_company` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(120) DEFAULT NULL,
  `phone` char(20) DEFAULT NULL,
  `fax` char(20) DEFAULT NULL,
  `address` char(120) DEFAULT NULL,
  `zipcode` char(10) DEFAULT NULL,
  `website` char(120) DEFAULT NULL,
  `backyard` char(120) DEFAULT NULL,
  `guest` enum('1','0') NOT NULL DEFAULT '0',
  `admins` char(255) DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_compile` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `job` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `queue` mediumint(8) NOT NULL DEFAULT 0,
  `status` varchar(255) NOT NULL DEFAULT '',
  `logs` longtext DEFAULT NULL,
  `atTime` varchar(10) NOT NULL DEFAULT '',
  `testtask` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `tag` varchar(255) NOT NULL DEFAULT '',
  `times` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `updateDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_config` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `vision` varchar(10) NOT NULL DEFAULT '',
  `owner` char(30) NOT NULL DEFAULT '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `section` char(30) NOT NULL DEFAULT '',
  `key` char(30) NOT NULL DEFAULT '',
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`vision`,`owner`,`module`,`section`,`key`),
  KEY `vision` (`vision`),
  KEY `owner` (`owner`),
  KEY `module` (`module`),
  KEY `key` (`key`)
) ENGINE=InnoDB;
CREATE TABLE `zt_cron` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `m` varchar(20) NOT NULL DEFAULT '',
  `h` varchar(20) NOT NULL DEFAULT '',
  `dom` varchar(20) NOT NULL DEFAULT '',
  `mon` varchar(20) NOT NULL DEFAULT '',
  `dow` varchar(20) NOT NULL DEFAULT '',
  `command` text DEFAULT NULL,
  `remark` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT '',
  `buildin` tinyint(1) NOT NULL DEFAULT 0,
  `status` varchar(20) NOT NULL DEFAULT '',
  `lastTime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lastTime` (`lastTime`)
) ENGINE=InnoDB;
CREATE TABLE `zt_dashboard` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `dimension` int(8) NOT NULL DEFAULT 0,
  `module` mediumint(8) NOT NULL DEFAULT 0,
  `desc` mediumtext DEFAULT NULL,
  `layout` mediumtext DEFAULT NULL,
  `filters` mediumtext DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_dataset` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(155) NOT NULL DEFAULT '',
  `sql` text DEFAULT NULL,
  `fields` mediumtext DEFAULT NULL,
  `objects` mediumtext DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_dataview` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `group` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` varchar(155) NOT NULL DEFAULT '',
  `code` varchar(50) NOT NULL DEFAULT '',
  `mode` enum('text','builder') NOT NULL DEFAULT 'builder',
  `view` varchar(57) NOT NULL DEFAULT '',
  `sql` text DEFAULT NULL,
  `fields` mediumtext DEFAULT NULL,
  `langs` text DEFAULT NULL,
  `objects` mediumtext DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_demand` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `pool` int(8) NOT NULL DEFAULT 0,
  `module` int(8) NOT NULL DEFAULT 0,
  `product` varchar(255) NOT NULL DEFAULT '',
  `parent` mediumint(8) NOT NULL DEFAULT 0,
  `pri` char(30) NOT NULL DEFAULT '',
  `category` char(30) NOT NULL DEFAULT '',
  `source` char(30) NOT NULL DEFAULT '',
  `sourceNote` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `feedbackedBy` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `assignedTo` char(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `reviewedBy` text DEFAULT NULL,
  `reviewedDate` datetime DEFAULT NULL,
  `status` char(30) NOT NULL DEFAULT '',
  `stage` enum('wait','distributed','inroadmap','incharter','developing','delivering','delivered','closed') NOT NULL DEFAULT 'wait',
  `duration` char(30) NOT NULL DEFAULT '',
  `BSA` char(30) NOT NULL DEFAULT '',
  `story` mediumint(8) NOT NULL DEFAULT 0,
  `roadmap` mediumint(8) NOT NULL DEFAULT 0,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `mailto` text DEFAULT NULL,
  `duplicateDemand` mediumint(8) DEFAULT NULL,
  `childDemands` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(255) NOT NULL DEFAULT '',
  `parentVersion` smallint(6) NOT NULL DEFAULT 0,
  `vision` varchar(255) NOT NULL DEFAULT 'or',
  `color` varchar(255) NOT NULL DEFAULT '',
  `changedBy` char(30) NOT NULL DEFAULT '',
  `changedDate` datetime DEFAULT NULL,
  `closedBy` char(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `closedReason` varchar(30) NOT NULL DEFAULT '',
  `submitedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `activatedDate` datetime DEFAULT NULL,
  `distributedBy` varchar(30) NOT NULL DEFAULT '',
  `distributedDate` datetime DEFAULT NULL,
  `feedback` mediumint(9) NOT NULL DEFAULT 0,
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_demandpool` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `status` char(30) NOT NULL DEFAULT '',
  `products` varchar(255) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `owner` text DEFAULT NULL,
  `reviewer` text DEFAULT NULL,
  `acl` char(30) DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_demandreview` (
  `demand` mediumint(9) NOT NULL DEFAULT 0,
  `version` smallint(6) NOT NULL DEFAULT 0,
  `reviewer` varchar(30) NOT NULL DEFAULT '',
  `result` varchar(30) NOT NULL DEFAULT '',
  `reviewDate` datetime DEFAULT NULL,
  UNIQUE KEY `demand` (`demand`,`version`,`reviewer`)
) ENGINE=InnoDB;
CREATE TABLE `zt_demandspec` (
  `demand` mediumint(9) NOT NULL DEFAULT 0,
  `version` smallint(6) NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `spec` mediumtext DEFAULT NULL,
  `verify` mediumtext DEFAULT NULL,
  `files` text DEFAULT NULL,
  UNIQUE KEY `demand` (`demand`,`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_deploy` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `begin` datetime DEFAULT NULL,
  `end` datetime DEFAULT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `status` varchar(20) NOT NULL DEFAULT '',
  `owner` char(30) NOT NULL DEFAULT '',
  `members` text DEFAULT NULL,
  `notify` text DEFAULT NULL,
  `cases` text DEFAULT NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `result` varchar(20) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_deployproduct` (
  `deploy` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `release` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `package` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `deploy_product_release` (`deploy`,`product`,`release`)
) ENGINE=InnoDB;
CREATE TABLE `zt_deployscope` (
  `deploy` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `service` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `hosts` text DEFAULT NULL,
  `remove` text DEFAULT NULL,
  `add` text DEFAULT NULL
) ENGINE=InnoDB;
CREATE TABLE `zt_deploystep` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `deploy` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `begin` datetime DEFAULT NULL,
  `end` datetime DEFAULT NULL,
  `stage` varchar(30) NOT NULL DEFAULT '',
  `content` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `assignedTo` char(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `finishedBy` char(30) NOT NULL DEFAULT '',
  `finishedDate` datetime DEFAULT NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_dept` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(60) NOT NULL DEFAULT '',
  `parent` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `path` char(255) NOT NULL DEFAULT '',
  `grade` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `order` smallint(6) unsigned NOT NULL DEFAULT 0,
  `position` char(30) NOT NULL DEFAULT '',
  `function` char(255) NOT NULL DEFAULT '',
  `manager` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `path` (`path`)
) ENGINE=InnoDB;
CREATE TABLE `zt_design` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` varchar(255) NOT NULL DEFAULT '',
  `product` varchar(255) NOT NULL DEFAULT '',
  `commit` text DEFAULT NULL,
  `commitedBy` varchar(30) NOT NULL DEFAULT '',
  `execution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `story` char(30) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `version` smallint(6) NOT NULL DEFAULT 0,
  `type` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_designspec` (
  `design` mediumint(8) NOT NULL DEFAULT 0,
  `version` smallint(6) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `files` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `design` (`design`,`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_dimension` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL DEFAULT '',
  `code` varchar(45) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `acl` enum('open','private') NOT NULL DEFAULT 'open',
  `whitelist` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `code` (`code`)
) ENGINE=InnoDB;
CREATE TABLE `zt_doc` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `execution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `lib` varchar(30) NOT NULL DEFAULT '',
  `template` varchar(30) NOT NULL DEFAULT '',
  `templateType` varchar(30) NOT NULL DEFAULT '',
  `chapterType` varchar(30) NOT NULL DEFAULT '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT 'normal',
  `parent` smallint(6) unsigned NOT NULL DEFAULT 0,
  `path` char(255) NOT NULL DEFAULT '',
  `grade` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `order` smallint(6) unsigned NOT NULL DEFAULT 0,
  `views` smallint(6) unsigned NOT NULL DEFAULT 0,
  `assetLib` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `assetLibType` varchar(30) NOT NULL DEFAULT '',
  `from` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `fromVersion` smallint(6) NOT NULL DEFAULT 1,
  `draft` longtext DEFAULT NULL,
  `collects` smallint(6) unsigned NOT NULL DEFAULT 0,
  `addedBy` varchar(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `approvedDate` date DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `editingDate` text DEFAULT NULL,
  `editedList` text DEFAULT NULL,
  `mailto` text DEFAULT NULL,
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `groups` varchar(255) NOT NULL DEFAULT '',
  `users` text DEFAULT NULL,
  `version` smallint(6) unsigned NOT NULL DEFAULT 1,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`),
  KEY `lib` (`lib`)
) ENGINE=InnoDB;
CREATE TABLE `zt_docaction` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `doc` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `action` varchar(80) NOT NULL DEFAULT '',
  `actor` char(30) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `doc` (`doc`),
  KEY `actor` (`actor`)
) ENGINE=InnoDB;
CREATE TABLE `zt_doccontent` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `doc` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `digest` varchar(255) NOT NULL DEFAULT '',
  `content` longtext DEFAULT NULL,
  `files` text DEFAULT NULL,
  `type` varchar(10) NOT NULL DEFAULT '',
  `version` smallint(6) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `doc_version` (`doc`,`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_doclib` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL DEFAULT '',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `parent` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `execution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` varchar(60) NOT NULL DEFAULT '',
  `baseUrl` varchar(255) NOT NULL DEFAULT '',
  `acl` varchar(10) NOT NULL DEFAULT 'open',
  `groups` varchar(255) NOT NULL DEFAULT '',
  `users` text DEFAULT NULL,
  `main` enum('0','1') NOT NULL DEFAULT '0',
  `collector` text DEFAULT NULL,
  `desc` mediumtext DEFAULT NULL,
  `order` tinyint(5) unsigned NOT NULL DEFAULT 0,
  `addedBy` varchar(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `orderBy` varchar(30) NOT NULL DEFAULT 'id_asc',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `execution` (`execution`)
) ENGINE=InnoDB;
CREATE TABLE `zt_domain` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `domain` varchar(255) NOT NULL DEFAULT '',
  `adminURI` varchar(255) NOT NULL DEFAULT '',
  `resolverURI` varchar(255) NOT NULL DEFAULT '',
  `register` varchar(255) NOT NULL DEFAULT '',
  `expiredDate` datetime DEFAULT NULL,
  `renew` varchar(255) NOT NULL DEFAULT '',
  `account` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `domain` (`domain`)
) ENGINE=InnoDB;
CREATE TABLE `zt_duckdbqueue` (
  `object` varchar(255) NOT NULL DEFAULT '',
  `updatedTime` datetime DEFAULT NULL,
  `syncTime` datetime DEFAULT NULL,
  UNIQUE KEY `object` (`object`)
) ENGINE=InnoDB;
CREATE TABLE `zt_durationestimation` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `stage` mediumint(9) NOT NULL DEFAULT 0,
  `workload` varchar(255) NOT NULL DEFAULT '',
  `worktimeRate` varchar(255) NOT NULL DEFAULT '',
  `people` varchar(255) NOT NULL DEFAULT '',
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_effort` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `product` text DEFAULT NULL,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `execution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `account` varchar(30) NOT NULL DEFAULT '',
  `work` text DEFAULT NULL,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `date` date DEFAULT NULL,
  `left` float NOT NULL DEFAULT 0,
  `consumed` float NOT NULL DEFAULT 0,
  `begin` smallint(4) unsigned zerofill NOT NULL DEFAULT 0000,
  `end` smallint(4) unsigned zerofill NOT NULL DEFAULT 0000,
  `extra` text DEFAULT NULL,
  `order` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `execution` (`execution`),
  KEY `objectID` (`objectID`),
  KEY `date` (`date`),
  KEY `account` (`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_entry` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `account` varchar(30) NOT NULL DEFAULT '',
  `code` varchar(20) NOT NULL DEFAULT '',
  `key` varchar(32) NOT NULL DEFAULT '',
  `freePasswd` enum('0','1') NOT NULL DEFAULT '0',
  `ip` varchar(100) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `calledTime` int(11) unsigned NOT NULL DEFAULT 0,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_expect` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `userID` mediumint(8) NOT NULL DEFAULT 0,
  `project` mediumint(8) NOT NULL DEFAULT 0,
  `expect` text DEFAULT NULL,
  `progress` text DEFAULT NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_extension` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL DEFAULT '',
  `code` varchar(30) NOT NULL DEFAULT '',
  `version` varchar(50) NOT NULL DEFAULT '',
  `author` varchar(100) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `license` text DEFAULT NULL,
  `type` varchar(20) NOT NULL DEFAULT 'extension',
  `site` varchar(150) NOT NULL DEFAULT '',
  `zentaoCompatible` text DEFAULT NULL,
  `installedTime` datetime DEFAULT NULL,
  `depends` varchar(100) NOT NULL DEFAULT '',
  `dirs` mediumtext DEFAULT NULL,
  `files` mediumtext DEFAULT NULL,
  `status` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `name` (`name`),
  KEY `installedTime` (`installedTime`)
) ENGINE=InnoDB;
CREATE TABLE `zt_faq` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `module` mediumint(9) NOT NULL DEFAULT 0,
  `product` mediumint(9) NOT NULL DEFAULT 0,
  `question` varchar(255) NOT NULL DEFAULT '',
  `answer` text DEFAULT NULL,
  `addedtime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_feedback` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `module` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT '',
  `solution` char(30) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `pri` tinyint(3) unsigned NOT NULL DEFAULT 2,
  `status` varchar(30) NOT NULL DEFAULT '',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `public` enum('0','1') NOT NULL DEFAULT '0',
  `notify` enum('0','1') NOT NULL DEFAULT '0',
  `notifyEmail` varchar(100) NOT NULL DEFAULT '',
  `source` varchar(255) NOT NULL DEFAULT '',
  `likes` text DEFAULT NULL,
  `result` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `faq` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `openedBy` char(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `reviewedBy` varchar(255) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  `processedBy` char(30) NOT NULL DEFAULT '',
  `processedDate` datetime DEFAULT NULL,
  `closedBy` char(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `closedReason` varchar(30) NOT NULL DEFAULT '',
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedTo` varchar(255) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `activatedBy` varchar(30) NOT NULL DEFAULT '',
  `activatedDate` datetime DEFAULT NULL,
  `feedbackBy` varchar(100) NOT NULL DEFAULT '',
  `repeatFeedback` mediumint(8) NOT NULL DEFAULT 0,
  `mailto` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_feedbackview` (
  `account` char(30) NOT NULL DEFAULT '',
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  UNIQUE KEY `account_product` (`account`,`product`)
) ENGINE=InnoDB;
CREATE TABLE `zt_file` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `pathname` char(100) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `extension` char(30) NOT NULL DEFAULT '',
  `size` int(11) unsigned NOT NULL DEFAULT 0,
  `objectType` char(30) NOT NULL DEFAULT '',
  `objectID` mediumint(9) NOT NULL DEFAULT 0,
  `addedBy` char(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  `downloads` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `extra` varchar(255) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `objectType` (`objectType`),
  KEY `objectID` (`objectID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_gapanalysis` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `account` varchar(30) NOT NULL DEFAULT '',
  `role` varchar(20) NOT NULL DEFAULT '',
  `analysis` mediumtext DEFAULT NULL,
  `needTrain` enum('no','yes') NOT NULL DEFAULT 'no',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `project_account` (`project`,`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_group` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `name` char(30) NOT NULL DEFAULT '',
  `role` char(30) NOT NULL DEFAULT '',
  `desc` char(255) NOT NULL DEFAULT '',
  `acl` text DEFAULT NULL,
  `developer` enum('0','1') NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_grouppriv` (
  `group` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `module` char(30) NOT NULL DEFAULT '',
  `method` char(30) NOT NULL DEFAULT '',
  UNIQUE KEY `group` (`group`,`module`,`method`)
) ENGINE=InnoDB;
CREATE TABLE `zt_history` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `action` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `field` varchar(30) NOT NULL DEFAULT '',
  `old` text DEFAULT NULL,
  `oldValue` text DEFAULT NULL,
  `new` text DEFAULT NULL,
  `newValue` text DEFAULT NULL,
  `diff` mediumtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `action` (`action`)
) ENGINE=InnoDB;
CREATE TABLE `zt_holiday` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `type` enum('holiday','working') NOT NULL DEFAULT 'holiday',
  `desc` text DEFAULT NULL,
  `year` char(4) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `name` (`name`)
) ENGINE=InnoDB;
CREATE TABLE `zt_host` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT 'normal',
  `hostType` varchar(30) NOT NULL DEFAULT '',
  `mac` varchar(128) NOT NULL DEFAULT '',
  `memory` varchar(30) NOT NULL DEFAULT '',
  `diskSize` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(50) NOT NULL DEFAULT '',
  `secret` varchar(50) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `tokenSN` varchar(50) NOT NULL DEFAULT '',
  `tokenTime` datetime DEFAULT NULL,
  `oldTokenSN` varchar(50) NOT NULL DEFAULT '',
  `vsoft` varchar(30) NOT NULL DEFAULT '',
  `heartbeat` datetime DEFAULT NULL,
  `zap` varchar(10) NOT NULL DEFAULT '',
  `provider` varchar(255) NOT NULL DEFAULT '',
  `vnc` int(11) NOT NULL DEFAULT 0,
  `ztf` int(11) NOT NULL DEFAULT 0,
  `zd` int(11) NOT NULL DEFAULT 0,
  `ssh` int(11) NOT NULL DEFAULT 0,
  `parent` int(11) unsigned NOT NULL DEFAULT 0,
  `image` int(11) unsigned NOT NULL DEFAULT 0,
  `admin` smallint(5) unsigned NOT NULL DEFAULT 0,
  `serverRoom` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `serverModel` varchar(256) NOT NULL DEFAULT '',
  `hardwareType` varchar(64) NOT NULL DEFAULT '',
  `cpuBrand` varchar(128) NOT NULL DEFAULT '',
  `cpuModel` varchar(128) NOT NULL DEFAULT '',
  `cpuNumber` varchar(16) NOT NULL DEFAULT '',
  `cpuCores` varchar(30) NOT NULL DEFAULT '',
  `intranet` varchar(128) NOT NULL DEFAULT '',
  `extranet` varchar(128) NOT NULL DEFAULT '',
  `osName` varchar(64) NOT NULL DEFAULT '',
  `osVersion` varchar(64) NOT NULL DEFAULT '',
  `group` varchar(128) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_image` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `host` int(11) unsigned NOT NULL DEFAULT 0,
  `name` varchar(64) NOT NULL DEFAULT '',
  `localName` varchar(64) NOT NULL DEFAULT '',
  `address` varchar(64) NOT NULL DEFAULT '',
  `path` varchar(64) NOT NULL DEFAULT '',
  `status` varchar(20) NOT NULL DEFAULT '',
  `osName` varchar(32) NOT NULL DEFAULT '',
  `from` varchar(10) NOT NULL DEFAULT 'zentao',
  `memory` float unsigned NOT NULL DEFAULT 0,
  `disk` float unsigned NOT NULL DEFAULT 0,
  `fileSize` float unsigned NOT NULL DEFAULT 0,
  `md5` varchar(64) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `restoreDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_instance` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `space` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `solution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` char(50) NOT NULL DEFAULT '',
  `appID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `appName` char(50) NOT NULL DEFAULT '',
  `appVersion` char(20) NOT NULL DEFAULT '',
  `chart` char(50) NOT NULL DEFAULT '',
  `logo` varchar(255) NOT NULL DEFAULT '',
  `version` char(50) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `introduction` text DEFAULT NULL,
  `source` char(20) NOT NULL DEFAULT '',
  `channel` char(20) NOT NULL DEFAULT '',
  `k8name` char(64) NOT NULL DEFAULT '',
  `status` char(20) NOT NULL DEFAULT '',
  `pinned` enum('0','1') NOT NULL DEFAULT '0',
  `domain` char(255) NOT NULL DEFAULT '',
  `smtpSnippetName` char(30) NOT NULL DEFAULT '',
  `ldapSnippetName` char(30) NOT NULL DEFAULT '',
  `ldapSettings` text DEFAULT NULL,
  `dbSettings` text DEFAULT NULL,
  `autoBackup` tinyint(1) NOT NULL DEFAULT 0,
  `backupKeepDays` int(10) unsigned NOT NULL DEFAULT 1,
  `autoRestore` tinyint(1) NOT NULL DEFAULT 0,
  `env` text DEFAULT NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdAt` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `space` (`space`),
  KEY `k8name` (`k8name`)
) ENGINE=InnoDB;
CREATE TABLE `zt_intervention` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `activity` mediumint(8) NOT NULL DEFAULT 0,
  `status` char(30) NOT NULL DEFAULT '',
  `partake` text DEFAULT NULL,
  `begin` date DEFAULT NULL,
  `realBegin` date DEFAULT NULL,
  `situation` varchar(255) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `project` (`project`,`activity`)
) ENGINE=InnoDB;
CREATE TABLE `zt_issue` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `resolvedBy` varchar(30) NOT NULL DEFAULT '',
  `project` varchar(255) NOT NULL DEFAULT '',
  `execution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `pri` char(30) NOT NULL DEFAULT '',
  `severity` char(30) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT '',
  `activity` varchar(255) NOT NULL DEFAULT '',
  `deadline` date DEFAULT NULL,
  `resolution` char(30) NOT NULL DEFAULT '',
  `resolutionComment` text DEFAULT NULL,
  `objectID` varchar(255) NOT NULL DEFAULT '',
  `resolvedDate` date DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `owner` varchar(255) NOT NULL DEFAULT '',
  `lib` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `from` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `version` smallint(6) NOT NULL DEFAULT 1,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `activateBy` varchar(30) NOT NULL DEFAULT '',
  `activateDate` date DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` date DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `approvedDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_job` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `repo` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `frame` varchar(20) NOT NULL DEFAULT '',
  `engine` varchar(20) NOT NULL DEFAULT '',
  `autoRun` enum('0','1') NOT NULL DEFAULT '1',
  `server` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `pipeline` varchar(500) NOT NULL DEFAULT '',
  `triggerType` varchar(255) NOT NULL DEFAULT '',
  `sonarqubeServer` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `projectKey` varchar(255) NOT NULL DEFAULT '',
  `svnDir` varchar(255) NOT NULL DEFAULT '',
  `atDay` varchar(255) NOT NULL DEFAULT '',
  `atTime` varchar(10) NOT NULL DEFAULT '',
  `customParam` text DEFAULT NULL,
  `comment` varchar(255) NOT NULL DEFAULT '',
  `triggerActions` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `lastExec` datetime DEFAULT NULL,
  `lastStatus` varchar(255) NOT NULL DEFAULT '',
  `lastTag` varchar(255) NOT NULL DEFAULT '',
  `lastSyncDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_repo_deleted` (`repo`,`deleted`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanban` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `space` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `team` text DEFAULT NULL,
  `desc` mediumtext DEFAULT NULL,
  `acl` char(30) NOT NULL DEFAULT 'open',
  `whitelist` text DEFAULT NULL,
  `archived` enum('0','1') NOT NULL DEFAULT '1',
  `performable` enum('0','1') NOT NULL DEFAULT '0',
  `status` enum('active','closed') NOT NULL DEFAULT 'active',
  `order` mediumint(8) NOT NULL DEFAULT 0,
  `displayCards` smallint(6) NOT NULL DEFAULT 0,
  `showWIP` enum('0','1') NOT NULL DEFAULT '1',
  `fluidBoard` enum('0','1') NOT NULL DEFAULT '0',
  `colWidth` smallint(4) NOT NULL DEFAULT 264,
  `minColWidth` smallint(4) NOT NULL DEFAULT 200,
  `maxColWidth` smallint(4) NOT NULL DEFAULT 384,
  `object` varchar(255) NOT NULL DEFAULT '',
  `alignment` varchar(10) NOT NULL DEFAULT 'center',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `lastEditedBy` char(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `closedBy` char(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `activatedBy` char(30) NOT NULL DEFAULT '',
  `activatedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanbancard` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `kanban` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `region` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `group` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `fromID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `fromType` varchar(30) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT 'doing',
  `pri` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `assignedTo` text DEFAULT NULL,
  `desc` mediumtext DEFAULT NULL,
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `estimate` float unsigned NOT NULL DEFAULT 0,
  `progress` float unsigned NOT NULL DEFAULT 0,
  `color` char(7) NOT NULL DEFAULT '',
  `acl` char(30) NOT NULL DEFAULT 'open',
  `whitelist` text DEFAULT NULL,
  `order` mediumint(8) NOT NULL DEFAULT 0,
  `archived` enum('0','1') NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `lastEditedBy` char(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `archivedBy` char(30) NOT NULL DEFAULT '',
  `archivedDate` datetime DEFAULT NULL,
  `assignedBy` char(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanbancell` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `kanban` mediumint(8) NOT NULL DEFAULT 0,
  `lane` mediumint(8) NOT NULL DEFAULT 0,
  `column` mediumint(8) NOT NULL DEFAULT 0,
  `type` char(30) NOT NULL DEFAULT '',
  `cards` mediumtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `card_group` (`kanban`,`type`,`lane`,`column`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanbancolumn` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `parent` mediumint(8) NOT NULL DEFAULT 0,
  `type` char(30) NOT NULL DEFAULT '',
  `region` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `group` mediumint(8) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `color` char(30) NOT NULL DEFAULT '',
  `limit` smallint(6) NOT NULL DEFAULT -1,
  `order` mediumint(8) NOT NULL DEFAULT 0,
  `archived` enum('0','1') NOT NULL DEFAULT '0',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanbangroup` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `kanban` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `region` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `order` smallint(6) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanbanlane` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `execution` mediumint(8) NOT NULL DEFAULT 0,
  `type` char(30) NOT NULL DEFAULT '',
  `region` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `group` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `groupby` char(30) NOT NULL DEFAULT '',
  `extra` char(30) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `color` char(30) NOT NULL DEFAULT '',
  `order` smallint(6) NOT NULL DEFAULT 0,
  `lastEditedTime` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanbanregion` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `space` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `kanban` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `order` mediumint(8) NOT NULL DEFAULT 0,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `lastEditedBy` char(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_kanbanspace` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(50) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `team` text DEFAULT NULL,
  `desc` mediumtext DEFAULT NULL,
  `acl` char(30) NOT NULL DEFAULT 'open',
  `whitelist` text DEFAULT NULL,
  `status` enum('active','closed') NOT NULL DEFAULT 'active',
  `order` mediumint(8) NOT NULL DEFAULT 0,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `lastEditedBy` char(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `closedBy` char(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `activatedBy` char(30) NOT NULL DEFAULT '',
  `activatedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_lang` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `lang` varchar(30) NOT NULL DEFAULT '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `section` varchar(50) NOT NULL DEFAULT '',
  `key` varchar(60) NOT NULL DEFAULT '',
  `value` text DEFAULT NULL,
  `system` enum('0','1') NOT NULL DEFAULT '1',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  UNIQUE KEY `lang` (`lang`,`module`,`section`,`key`,`vision`)
) ENGINE=InnoDB;
CREATE TABLE `zt_leave` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `start` time DEFAULT NULL,
  `finish` time DEFAULT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT 0.0,
  `backDate` datetime DEFAULT NULL,
  `type` varchar(30) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `reviewedBy` char(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  `level` tinyint(3) NOT NULL DEFAULT 0,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `reviewers` text DEFAULT NULL,
  `backReviewers` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `type` (`type`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=InnoDB;
CREATE TABLE `zt_lieu` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `start` time DEFAULT NULL,
  `finish` time DEFAULT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT 0.0,
  `overtime` char(255) NOT NULL DEFAULT '',
  `trip` char(255) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `reviewedBy` char(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  `level` tinyint(3) NOT NULL DEFAULT 0,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `reviewers` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=InnoDB;
CREATE TABLE `zt_log` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `action` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `date` datetime DEFAULT NULL,
  `url` varchar(255) NOT NULL DEFAULT '',
  `contentType` varchar(30) NOT NULL DEFAULT '',
  `data` text DEFAULT NULL,
  `result` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `objectType` (`objectType`),
  KEY `obejctID` (`objectID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_market` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `industry` char(255) NOT NULL DEFAULT '',
  `scale` decimal(10,2) NOT NULL DEFAULT 0.00,
  `maturity` char(255) NOT NULL DEFAULT '',
  `speed` varchar(255) NOT NULL DEFAULT '',
  `competition` char(255) NOT NULL DEFAULT '',
  `strategy` varchar(255) NOT NULL DEFAULT '',
  `ppm` varchar(20) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_marketreport` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `market` mediumint(8) NOT NULL DEFAULT 0,
  `research` mediumint(8) NOT NULL DEFAULT 0,
  `maturity` varchar(30) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `participants` char(255) NOT NULL DEFAULT '',
  `source` varchar(30) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `status` varchar(20) NOT NULL DEFAULT '',
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `publishedBy` varchar(30) NOT NULL DEFAULT '',
  `publishedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_measqueue` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL DEFAULT '',
  `mid` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `status` varchar(255) NOT NULL DEFAULT '',
  `logs` text DEFAULT NULL,
  `execTime` varchar(10) NOT NULL DEFAULT '',
  `params` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `updateDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_measrecords` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `type` varchar(30) NOT NULL DEFAULT '',
  `mid` mediumint(8) NOT NULL DEFAULT 0,
  `measCode` char(50) NOT NULL DEFAULT '',
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `execution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `params` text DEFAULT NULL,
  `year` char(4) NOT NULL DEFAULT '',
  `month` char(6) NOT NULL DEFAULT '',
  `week` char(8) NOT NULL DEFAULT '',
  `day` char(8) NOT NULL DEFAULT '',
  `value` varchar(255) NOT NULL DEFAULT '',
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `time` (`year`,`month`,`day`,`week`),
  KEY `product` (`product`),
  KEY `project` (`project`)
) ENGINE=InnoDB;
CREATE TABLE `zt_meastemplate` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `model` char(30) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `content` mediumtext DEFAULT NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_meeting` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) NOT NULL DEFAULT 0,
  `execution` mediumint(8) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `begin` time DEFAULT NULL,
  `end` time DEFAULT NULL,
  `dept` mediumint(8) NOT NULL DEFAULT 0,
  `mode` varchar(255) NOT NULL DEFAULT '',
  `host` varchar(30) NOT NULL DEFAULT '',
  `participant` text DEFAULT NULL,
  `date` date DEFAULT NULL,
  `room` int(11) NOT NULL DEFAULT 0,
  `minutes` text DEFAULT NULL,
  `minutedBy` varchar(30) NOT NULL DEFAULT '',
  `minutedDate` datetime DEFAULT NULL,
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` mediumint(8) NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_meetingroom` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `position` varchar(30) NOT NULL DEFAULT '',
  `seats` int(11) NOT NULL DEFAULT 0,
  `equipment` varchar(255) NOT NULL DEFAULT '',
  `openTime` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_metric` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `purpose` varchar(50) NOT NULL DEFAULT '',
  `scope` char(30) NOT NULL DEFAULT '',
  `object` char(30) NOT NULL DEFAULT '',
  `stage` enum('wait','released') DEFAULT 'wait',
  `type` enum('php','sql') DEFAULT 'php',
  `name` varchar(90) NOT NULL DEFAULT '',
  `alias` varchar(90) NOT NULL DEFAULT '',
  `code` varchar(90) NOT NULL DEFAULT '',
  `unit` varchar(10) NOT NULL DEFAULT '',
  `dateType` varchar(50) NOT NULL DEFAULT '',
  `collector` text DEFAULT NULL,
  `desc` text DEFAULT NULL,
  `definition` text DEFAULT NULL,
  `when` varchar(30) NOT NULL DEFAULT '',
  `event` varchar(30) NOT NULL DEFAULT '',
  `cronCFG` varchar(30) NOT NULL DEFAULT '',
  `time` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `implementedBy` varchar(30) NOT NULL DEFAULT '',
  `implementedDate` datetime DEFAULT NULL,
  `delistedBy` varchar(30) NOT NULL DEFAULT '',
  `delistedDate` datetime DEFAULT NULL,
  `builtin` enum('0','1') NOT NULL DEFAULT '0',
  `fromID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `order` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `lastCalcRows` int(11) NOT NULL DEFAULT 0,
  `lastCalcTime` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_metriclib` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `metricID` mediumint(9) NOT NULL DEFAULT 0,
  `metricCode` varchar(100) NOT NULL DEFAULT '',
  `system` char(30) NOT NULL DEFAULT '0',
  `program` char(30) NOT NULL DEFAULT '',
  `project` char(30) NOT NULL DEFAULT '',
  `product` char(30) NOT NULL DEFAULT '',
  `execution` char(30) NOT NULL DEFAULT '',
  `code` char(30) NOT NULL DEFAULT '',
  `pipeline` char(30) NOT NULL DEFAULT '',
  `repo` char(30) NOT NULL DEFAULT '',
  `user` text DEFAULT NULL,
  `dept` char(30) NOT NULL DEFAULT '',
  `year` char(4) NOT NULL DEFAULT '0',
  `month` char(2) NOT NULL DEFAULT '0',
  `week` char(2) NOT NULL DEFAULT '0',
  `day` char(2) NOT NULL DEFAULT '0',
  `value` varchar(100) NOT NULL DEFAULT '0',
  `calcType` enum('cron','inference') NOT NULL DEFAULT 'cron',
  `calculatedBy` varchar(30) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `metricID` (`metricID`),
  KEY `metricCode` (`metricCode`),
  KEY `date` (`date`),
  KEY `deleted` (`deleted`)
) ENGINE=InnoDB;
CREATE TABLE `zt_module` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `root` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `branch` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` char(60) NOT NULL DEFAULT '',
  `parent` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `path` char(255) NOT NULL DEFAULT '',
  `grade` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `order` smallint(5) unsigned NOT NULL DEFAULT 0,
  `type` char(30) NOT NULL DEFAULT '',
  `from` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `owner` varchar(30) NOT NULL DEFAULT '',
  `collector` text DEFAULT NULL,
  `short` varchar(30) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `root` (`root`),
  KEY `type` (`type`),
  KEY `path` (`path`)
) ENGINE=InnoDB;
CREATE TABLE `zt_mr` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `hostID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `sourceProject` varchar(50) NOT NULL DEFAULT '',
  `sourceBranch` varchar(100) NOT NULL DEFAULT '',
  `targetProject` varchar(50) NOT NULL DEFAULT '',
  `targetBranch` varchar(100) NOT NULL DEFAULT '',
  `mriid` int(10) unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text DEFAULT NULL,
  `assignee` varchar(255) NOT NULL DEFAULT '',
  `reviewer` varchar(255) NOT NULL DEFAULT '',
  `approver` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `status` char(30) NOT NULL DEFAULT '',
  `mergeStatus` char(30) NOT NULL DEFAULT '',
  `approvalStatus` char(30) NOT NULL DEFAULT '',
  `needApproved` enum('0','1') NOT NULL DEFAULT '0',
  `needCI` enum('0','1') NOT NULL DEFAULT '0',
  `repoID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `jobID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `executionID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `compileID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `compileStatus` char(30) NOT NULL DEFAULT '',
  `removeSourceBranch` enum('0','1') NOT NULL DEFAULT '0',
  `squash` enum('0','1') NOT NULL DEFAULT '0',
  `isFlow` enum('0','1') NOT NULL DEFAULT '0',
  `synced` enum('0','1') NOT NULL DEFAULT '1',
  `syncError` varchar(255) NOT NULL DEFAULT '',
  `hasNoConflict` enum('0','1') NOT NULL DEFAULT '0',
  `diffs` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_mrapproval` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `mrID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `account` varchar(255) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  `action` char(30) NOT NULL DEFAULT '',
  `comment` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_nc` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `auditplan` mediumint(8) NOT NULL DEFAULT 0,
  `listID` mediumint(8) NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `type` char(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT 'active',
  `severity` char(30) NOT NULL DEFAULT '',
  `deadline` date DEFAULT NULL,
  `resolvedBy` varchar(30) NOT NULL DEFAULT '',
  `resolution` char(30) NOT NULL DEFAULT '',
  `resolvedDate` date DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` date DEFAULT NULL,
  `parent` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` date DEFAULT NULL,
  `activateDate` date DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_notify` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `objectType` varchar(50) NOT NULL DEFAULT '',
  `objectID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `action` mediumint(8) NOT NULL DEFAULT 0,
  `toList` text DEFAULT NULL,
  `ccList` text DEFAULT NULL,
  `subject` text DEFAULT NULL,
  `data` text DEFAULT NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `sendTime` datetime DEFAULT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `failReason` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `objectType` (`objectType`),
  KEY `status` (`status`)
) ENGINE=InnoDB;
CREATE TABLE `zt_oauth` (
  `account` varchar(30) NOT NULL DEFAULT '',
  `openID` varchar(255) NOT NULL DEFAULT '',
  `providerType` varchar(30) NOT NULL DEFAULT '',
  `providerID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  UNIQUE KEY `account_openID` (`account`,`openID`,`providerType`,`providerID`),
  KEY `account` (`account`),
  KEY `providerType` (`providerType`),
  KEY `providerID` (`providerID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_object` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `product` mediumint(8) NOT NULL DEFAULT 0,
  `from` mediumint(8) NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `category` char(30) NOT NULL DEFAULT '',
  `version` varchar(255) NOT NULL DEFAULT '',
  `type` enum('reviewed','taged') NOT NULL DEFAULT 'reviewed',
  `enabled` enum('0','1') NOT NULL DEFAULT '1',
  `range` text DEFAULT NULL,
  `data` text DEFAULT NULL,
  `storyEst` char(30) NOT NULL DEFAULT '',
  `taskEst` char(30) NOT NULL DEFAULT '',
  `requestEst` char(30) NOT NULL DEFAULT '',
  `testEst` char(30) NOT NULL DEFAULT '',
  `devEst` char(30) NOT NULL DEFAULT '',
  `designEst` char(30) NOT NULL DEFAULT '',
  `end` date DEFAULT NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_opportunity` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `execution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `source` char(30) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT '',
  `strategy` char(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT 'active',
  `impact` mediumint(8) NOT NULL DEFAULT 0,
  `chance` mediumint(8) NOT NULL DEFAULT 0,
  `ratio` mediumint(8) NOT NULL DEFAULT 0,
  `pri` char(30) NOT NULL DEFAULT '',
  `identifiedDate` date DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` date DEFAULT NULL,
  `approvedDate` date DEFAULT NULL,
  `prevention` mediumtext DEFAULT NULL,
  `plannedClosedDate` date DEFAULT NULL,
  `actualClosedDate` date DEFAULT NULL,
  `lib` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `from` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `desc` mediumtext DEFAULT NULL,
  `version` smallint(6) NOT NULL DEFAULT 1,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `activatedBy` varchar(30) NOT NULL DEFAULT '',
  `activatedDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `canceledBy` varchar(30) NOT NULL DEFAULT '',
  `canceledDate` datetime DEFAULT NULL,
  `cancelReason` char(30) NOT NULL DEFAULT '',
  `hangupedBy` varchar(30) NOT NULL DEFAULT '',
  `hangupedDate` datetime DEFAULT NULL,
  `resolution` mediumtext DEFAULT NULL,
  `resolvedBy` varchar(30) NOT NULL DEFAULT '',
  `resolvedDate` datetime DEFAULT NULL,
  `lastCheckedBy` varchar(30) NOT NULL DEFAULT '',
  `lastCheckedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_overtime` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `year` char(4) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `start` time DEFAULT NULL,
  `finish` time DEFAULT NULL,
  `hours` float(4,1) unsigned NOT NULL DEFAULT 0.0,
  `leave` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `status` varchar(30) NOT NULL DEFAULT '',
  `rejectReason` varchar(100) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `reviewedBy` char(30) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  `level` tinyint(3) NOT NULL DEFAULT 0,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `reviewers` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `type` (`type`),
  KEY `status` (`status`),
  KEY `createdBy` (`createdBy`)
) ENGINE=InnoDB;
CREATE TABLE `zt_pipeline` (
  `id` smallint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` char(30) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `url` varchar(255) DEFAULT NULL,
  `account` varchar(30) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `token` varchar(255) DEFAULT NULL,
  `private` char(32) DEFAULT NULL,
  `instanceID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_pivot` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `dimension` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `group` varchar(255) NOT NULL DEFAULT '',
  `code` varchar(255) NOT NULL DEFAULT '',
  `driver` enum('mysql','duckdb') NOT NULL DEFAULT 'mysql',
  `mode` enum('text','builder') NOT NULL DEFAULT 'builder',
  `name` text DEFAULT NULL,
  `desc` text DEFAULT NULL,
  `acl` enum('open','private') NOT NULL DEFAULT 'open',
  `whitelist` text DEFAULT NULL,
  `sql` mediumtext DEFAULT NULL,
  `fields` mediumtext DEFAULT NULL,
  `langs` mediumtext DEFAULT NULL,
  `vars` mediumtext DEFAULT NULL,
  `objects` mediumtext DEFAULT NULL,
  `settings` mediumtext DEFAULT NULL,
  `filters` mediumtext DEFAULT NULL,
  `step` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `stage` enum('draft','published') NOT NULL DEFAULT 'draft',
  `builtin` enum('0','1') NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `dimension` (`dimension`),
  KEY `group` (`group`)
) ENGINE=InnoDB;
CREATE TABLE `zt_pivotdrill` (
  `pivot` mediumint(9) NOT NULL,
  `field` varchar(255) NOT NULL,
  `object` varchar(40) NOT NULL,
  `whereSql` mediumtext NOT NULL,
  `condition` mediumtext NOT NULL,
  `status` enum('design','published') NOT NULL DEFAULT 'published',
  `account` varchar(30) NOT NULL DEFAULT '',
  `type` enum('auto','manual') NOT NULL DEFAULT 'manual'
) ENGINE=InnoDB;
CREATE TABLE `zt_planstory` (
  `plan` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `story` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `order` mediumint(9) NOT NULL DEFAULT 0,
  UNIQUE KEY `plan_story` (`plan`,`story`)
) ENGINE=InnoDB;
CREATE TABLE `zt_practice` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `code` char(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `labels` varchar(255) NOT NULL DEFAULT '',
  `summary` varchar(255) NOT NULL DEFAULT '',
  `content` text DEFAULT NULL,
  `contributor` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB;
CREATE TABLE `zt_priv` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL DEFAULT '',
  `method` varchar(30) NOT NULL DEFAULT '',
  `parent` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `edition` varchar(30) NOT NULL DEFAULT ',open,biz,max,',
  `vision` varchar(30) NOT NULL DEFAULT ',rnd,',
  `system` enum('0','1') NOT NULL DEFAULT '0',
  `order` mediumint(8) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `priv` (`module`,`method`)
) ENGINE=InnoDB;
CREATE TABLE `zt_privlang` (
  `objectID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `objectType` enum('priv','manager') NOT NULL DEFAULT 'priv',
  `lang` varchar(30) NOT NULL DEFAULT '',
  `key` varchar(100) NOT NULL DEFAULT '',
  `value` varchar(255) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  UNIQUE KEY `objectlang` (`objectID`,`objectType`,`lang`)
) ENGINE=InnoDB;
CREATE TABLE `zt_privmanager` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `parent` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `code` varchar(100) NOT NULL DEFAULT '',
  `type` enum('view','module','package') NOT NULL DEFAULT 'package',
  `edition` varchar(30) NOT NULL DEFAULT ',open,biz,max,',
  `vision` varchar(30) NOT NULL DEFAULT ',rnd,',
  `order` mediumint(8) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_privrelation` (
  `priv` varchar(100) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `relationPriv` varchar(100) NOT NULL DEFAULT '',
  UNIQUE KEY `privrelation` (`priv`,`type`,`relationPriv`)
) ENGINE=InnoDB;
CREATE TABLE `zt_process` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `model` char(30) NOT NULL DEFAULT 'waterfall',
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT '',
  `abbr` char(30) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `order` mediumint(9) NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_product` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `program` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` varchar(110) NOT NULL DEFAULT '',
  `code` varchar(45) NOT NULL DEFAULT '',
  `shadow` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `bind` enum('0','1') NOT NULL DEFAULT '0',
  `line` mediumint(8) NOT NULL DEFAULT 0,
  `type` varchar(30) NOT NULL DEFAULT 'normal',
  `status` varchar(30) NOT NULL DEFAULT '',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `PO` varchar(30) NOT NULL DEFAULT '',
  `QD` varchar(30) NOT NULL DEFAULT '',
  `RD` varchar(30) NOT NULL DEFAULT '',
  `feedback` varchar(30) NOT NULL DEFAULT '',
  `ticket` varchar(30) NOT NULL DEFAULT '',
  `workflowGroup` int(8) NOT NULL DEFAULT 0,
  `acl` enum('open','private','custom') NOT NULL DEFAULT 'open',
  `groups` text DEFAULT NULL,
  `whitelist` text DEFAULT NULL,
  `reviewer` text DEFAULT NULL,
  `PMT` text DEFAULT NULL,
  `draftEpics` mediumint(8) NOT NULL DEFAULT 0,
  `activeEpics` mediumint(8) NOT NULL DEFAULT 0,
  `changingEpics` mediumint(8) NOT NULL DEFAULT 0,
  `reviewingEpics` mediumint(8) NOT NULL DEFAULT 0,
  `finishedEpics` mediumint(8) NOT NULL DEFAULT 0,
  `closedEpics` mediumint(8) NOT NULL DEFAULT 0,
  `totalEpics` mediumint(8) NOT NULL DEFAULT 0,
  `draftRequirements` mediumint(8) NOT NULL DEFAULT 0,
  `activeRequirements` mediumint(8) NOT NULL DEFAULT 0,
  `changingRequirements` mediumint(8) NOT NULL DEFAULT 0,
  `reviewingRequirements` mediumint(8) NOT NULL DEFAULT 0,
  `finishedRequirements` mediumint(8) NOT NULL DEFAULT 0,
  `closedRequirements` mediumint(8) NOT NULL DEFAULT 0,
  `totalRequirements` mediumint(8) NOT NULL DEFAULT 0,
  `draftStories` mediumint(8) NOT NULL DEFAULT 0,
  `activeStories` mediumint(8) NOT NULL DEFAULT 0,
  `changingStories` mediumint(8) NOT NULL DEFAULT 0,
  `reviewingStories` mediumint(8) NOT NULL DEFAULT 0,
  `finishedStories` mediumint(8) NOT NULL DEFAULT 0,
  `closedStories` mediumint(8) NOT NULL DEFAULT 0,
  `totalStories` mediumint(8) NOT NULL DEFAULT 0,
  `unresolvedBugs` mediumint(8) NOT NULL DEFAULT 0,
  `closedBugs` mediumint(8) NOT NULL DEFAULT 0,
  `fixedBugs` mediumint(8) NOT NULL DEFAULT 0,
  `totalBugs` mediumint(8) NOT NULL DEFAULT 0,
  `plans` mediumint(8) NOT NULL DEFAULT 0,
  `releases` mediumint(8) NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `createdVersion` varchar(20) NOT NULL DEFAULT '',
  `closedDate` date DEFAULT NULL,
  `order` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `acl` (`acl`),
  KEY `order` (`order`)
) ENGINE=InnoDB;
CREATE TABLE `zt_productplan` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `branch` varchar(255) NOT NULL DEFAULT '0',
  `parent` mediumint(9) NOT NULL DEFAULT 0,
  `title` varchar(90) NOT NULL DEFAULT '',
  `status` enum('wait','doing','done','closed') NOT NULL DEFAULT 'wait',
  `desc` mediumtext DEFAULT NULL,
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `finishedDate` datetime DEFAULT NULL,
  `closedDate` datetime DEFAULT NULL,
  `order` text DEFAULT NULL,
  `closedReason` varchar(20) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `end` (`end`)
) ENGINE=InnoDB;
CREATE TABLE `zt_programactivity` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `execution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `process` mediumint(8) NOT NULL DEFAULT 0,
  `activity` mediumint(8) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `content` text DEFAULT NULL,
  `reason` varchar(255) NOT NULL DEFAULT '',
  `result` char(30) NOT NULL DEFAULT '',
  `linkedBy` char(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_programoutput` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `execution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `process` mediumint(8) NOT NULL DEFAULT 0,
  `activity` mediumint(8) NOT NULL DEFAULT 0,
  `output` mediumint(8) NOT NULL DEFAULT 0,
  `content` text DEFAULT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `reason` varchar(255) NOT NULL DEFAULT '',
  `result` char(30) NOT NULL DEFAULT '',
  `linkedBy` char(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_programprocess` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `process` mediumint(8) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT '',
  `abbr` char(30) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `reason` varchar(255) NOT NULL DEFAULT '',
  `linkedBy` char(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_programreport` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `template` mediumint(8) NOT NULL DEFAULT 0,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `params` text DEFAULT NULL,
  `content` text DEFAULT NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_project` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) NOT NULL DEFAULT 0,
  `charter` mediumint(8) NOT NULL DEFAULT 0,
  `model` char(30) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT 'sprint',
  `category` char(30) NOT NULL DEFAULT '',
  `lifetime` char(30) NOT NULL DEFAULT '',
  `budget` varchar(30) NOT NULL DEFAULT '0',
  `budgetUnit` char(30) NOT NULL DEFAULT 'CNY',
  `attribute` varchar(30) NOT NULL DEFAULT '',
  `percent` float unsigned NOT NULL DEFAULT 0,
  `milestone` enum('0','1') NOT NULL DEFAULT '0',
  `output` text DEFAULT NULL,
  `auth` char(30) NOT NULL DEFAULT '',
  `storyType` char(30) NOT NULL DEFAULT '',
  `parent` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `path` varchar(255) NOT NULL DEFAULT '',
  `grade` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `name` varchar(90) NOT NULL DEFAULT '',
  `code` varchar(45) NOT NULL DEFAULT '',
  `hasProduct` tinyint(1) unsigned NOT NULL DEFAULT 1,
  `workflowGroup` int(8) NOT NULL DEFAULT 0,
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `firstEnd` date DEFAULT NULL,
  `realBegan` date DEFAULT NULL,
  `realEnd` date DEFAULT NULL,
  `days` smallint(6) unsigned NOT NULL DEFAULT 0,
  `status` varchar(10) NOT NULL DEFAULT '',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `pri` enum('1','2','3','4') NOT NULL DEFAULT '1',
  `desc` mediumtext DEFAULT NULL,
  `version` smallint(6) NOT NULL DEFAULT 0,
  `parentVersion` smallint(6) NOT NULL DEFAULT 0,
  `planDuration` int(11) NOT NULL DEFAULT 0,
  `realDuration` int(11) NOT NULL DEFAULT 0,
  `progress` decimal(5,2) NOT NULL DEFAULT 0.00,
  `estimate` float NOT NULL DEFAULT 0,
  `left` float NOT NULL DEFAULT 0,
  `consumed` float NOT NULL DEFAULT 0,
  `teamCount` int(11) NOT NULL DEFAULT 0,
  `market` mediumint(8) NOT NULL DEFAULT 0,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `openedVersion` varchar(20) NOT NULL DEFAULT '',
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `closedReason` varchar(20) NOT NULL DEFAULT '',
  `canceledBy` varchar(30) NOT NULL DEFAULT '',
  `canceledDate` datetime DEFAULT NULL,
  `suspendedDate` date DEFAULT NULL,
  `PO` varchar(30) NOT NULL DEFAULT '',
  `PM` varchar(30) NOT NULL DEFAULT '',
  `QD` varchar(30) NOT NULL DEFAULT '',
  `RD` varchar(30) NOT NULL DEFAULT '',
  `team` varchar(90) NOT NULL DEFAULT '',
  `acl` char(30) NOT NULL DEFAULT 'open',
  `whitelist` text DEFAULT NULL,
  `order` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `stageBy` enum('project','product') NOT NULL DEFAULT 'product',
  `displayCards` smallint(6) NOT NULL DEFAULT 0,
  `fluidBoard` enum('0','1') NOT NULL DEFAULT '0',
  `multiple` enum('0','1') NOT NULL DEFAULT '1',
  `parallel` mediumint(9) NOT NULL DEFAULT 0,
  `enabled` enum('on','off') NOT NULL DEFAULT 'on',
  `colWidth` smallint(6) NOT NULL DEFAULT 264,
  `minColWidth` smallint(6) NOT NULL DEFAULT 200,
  `maxColWidth` smallint(6) NOT NULL DEFAULT 384,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `begin` (`begin`),
  KEY `end` (`end`),
  KEY `status` (`status`),
  KEY `acl` (`acl`),
  KEY `order` (`order`),
  KEY `project` (`project`),
  KEY `type_order` (`type`,`order`)
) ENGINE=InnoDB;
CREATE TABLE `zt_projectadmin` (
  `group` smallint(6) NOT NULL DEFAULT 0,
  `account` char(30) NOT NULL DEFAULT '',
  `programs` text DEFAULT NULL,
  `projects` text DEFAULT NULL,
  `products` text DEFAULT NULL,
  `executions` text DEFAULT NULL,
  UNIQUE KEY `group_account` (`group`,`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_projectcase` (
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `case` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `count` mediumint(8) unsigned NOT NULL DEFAULT 1,
  `version` smallint(6) NOT NULL DEFAULT 1,
  `order` smallint(6) unsigned NOT NULL DEFAULT 0,
  UNIQUE KEY `project` (`project`,`case`)
) ENGINE=InnoDB;
CREATE TABLE `zt_projectproduct` (
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `branch` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `plan` varchar(255) NOT NULL DEFAULT '',
  `roadmap` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`project`,`product`,`branch`)
) ENGINE=InnoDB;
CREATE TABLE `zt_projectspec` (
  `project` mediumint(8) NOT NULL DEFAULT 0,
  `version` smallint(6) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `milestone` enum('0','1') NOT NULL DEFAULT '0',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  UNIQUE KEY `project` (`project`,`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_projectstory` (
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `branch` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `story` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `version` smallint(6) NOT NULL DEFAULT 1,
  `order` smallint(6) unsigned NOT NULL DEFAULT 0,
  UNIQUE KEY `project` (`project`,`story`),
  KEY `story` (`story`)
) ENGINE=InnoDB;
CREATE TABLE `zt_queue` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `cron` mediumint(9) NOT NULL,
  `type` varchar(255) NOT NULL,
  `command` text NOT NULL,
  `status` enum('wait','doing','done') NOT NULL DEFAULT 'wait',
  `execId` int(11) DEFAULT NULL,
  `createdDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_relation` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) NOT NULL DEFAULT 0,
  `product` mediumint(8) NOT NULL DEFAULT 0,
  `execution` mediumint(8) NOT NULL DEFAULT 0,
  `AType` char(30) NOT NULL DEFAULT '',
  `AID` mediumint(8) NOT NULL DEFAULT 0,
  `AVersion` char(30) NOT NULL DEFAULT '',
  `relation` char(30) NOT NULL DEFAULT '',
  `BType` char(30) NOT NULL DEFAULT '',
  `BID` mediumint(8) NOT NULL DEFAULT 0,
  `BVersion` char(30) NOT NULL DEFAULT '',
  `extra` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `relation` (`product`,`relation`,`AType`,`BType`,`AID`,`BID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_relationoftasks` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `execution` mediumint(8) unsigned NOT NULL,
  `pretask` mediumint(8) unsigned NOT NULL,
  `condition` enum('begin','end') NOT NULL,
  `task` mediumint(8) unsigned NOT NULL,
  `action` enum('begin','end') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `relationoftasks` (`execution`,`task`)
) ENGINE=InnoDB;
CREATE TABLE `zt_release` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` varchar(255) NOT NULL DEFAULT '0',
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `branch` varchar(255) NOT NULL DEFAULT '0',
  `shadow` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `build` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `marker` enum('0','1') NOT NULL DEFAULT '0',
  `date` date DEFAULT NULL,
  `releasedDate` date DEFAULT NULL,
  `stories` text DEFAULT NULL,
  `bugs` text DEFAULT NULL,
  `leftBugs` text DEFAULT NULL,
  `desc` mediumtext DEFAULT NULL,
  `mailto` text DEFAULT NULL,
  `notify` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(20) NOT NULL DEFAULT 'normal',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `build` (`build`)
) ENGINE=InnoDB;
CREATE TABLE `zt_repo` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `product` varchar(255) NOT NULL DEFAULT '',
  `projects` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `prefix` varchar(100) NOT NULL DEFAULT '',
  `encoding` varchar(20) NOT NULL DEFAULT '',
  `SCM` varchar(10) NOT NULL DEFAULT '',
  `client` varchar(100) NOT NULL DEFAULT '',
  `serviceHost` varchar(50) NOT NULL DEFAULT '',
  `serviceProject` varchar(100) NOT NULL DEFAULT '',
  `commits` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `account` varchar(30) NOT NULL DEFAULT '',
  `password` varchar(30) NOT NULL DEFAULT '',
  `encrypt` varchar(30) NOT NULL DEFAULT 'plain',
  `acl` text DEFAULT NULL,
  `synced` tinyint(1) NOT NULL DEFAULT 0,
  `lastSync` datetime DEFAULT NULL,
  `lastCommit` datetime DEFAULT NULL,
  `desc` text DEFAULT NULL,
  `extra` char(30) NOT NULL DEFAULT '',
  `preMerge` enum('0','1') NOT NULL DEFAULT '0',
  `job` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `fileServerUrl` text DEFAULT NULL,
  `fileServerAccount` varchar(40) NOT NULL DEFAULT '',
  `fileServerPassword` varchar(100) NOT NULL DEFAULT '',
  `deleted` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_repobranch` (
  `repo` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `revision` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `branch` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `repo_revision_branch` (`repo`,`revision`,`branch`),
  KEY `branch` (`branch`),
  KEY `revision` (`revision`)
) ENGINE=InnoDB;
CREATE TABLE `zt_repofiles` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `repo` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `revision` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `path` varchar(255) NOT NULL DEFAULT '',
  `oldPath` varchar(255) NOT NULL DEFAULT '',
  `parent` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT '',
  `action` char(1) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `path` (`path`),
  KEY `parent` (`parent`),
  KEY `repo` (`repo`),
  KEY `revision` (`revision`)
) ENGINE=InnoDB;
CREATE TABLE `zt_repohistory` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `repo` mediumint(9) NOT NULL DEFAULT 0,
  `revision` varchar(40) NOT NULL DEFAULT '',
  `commit` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `comment` text DEFAULT NULL,
  `committer` varchar(100) NOT NULL DEFAULT '',
  `time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `repo` (`repo`),
  KEY `revision` (`revision`)
) ENGINE=InnoDB;
CREATE TABLE `zt_report` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `code` varchar(100) NOT NULL DEFAULT '',
  `name` text DEFAULT NULL,
  `dimension` int(8) NOT NULL DEFAULT 0,
  `module` varchar(100) NOT NULL DEFAULT '',
  `sql` text DEFAULT NULL,
  `vars` text DEFAULT NULL,
  `langs` text DEFAULT NULL,
  `params` text DEFAULT NULL,
  `step` tinyint(1) NOT NULL DEFAULT 2,
  `desc` text DEFAULT NULL,
  `addedBy` char(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB;
CREATE TABLE `zt_researchplan` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `customer` varchar(255) NOT NULL DEFAULT '',
  `stakeholder` varchar(255) NOT NULL DEFAULT '',
  `objective` varchar(255) NOT NULL DEFAULT '',
  `begin` datetime DEFAULT NULL,
  `end` datetime DEFAULT NULL,
  `location` varchar(255) NOT NULL DEFAULT '',
  `team` varchar(255) NOT NULL DEFAULT '',
  `method` enum('','videoConference','interview','questionnaire','telephoneInterview') NOT NULL DEFAULT '',
  `outline` mediumtext DEFAULT NULL,
  `schedule` mediumtext DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_researchreport` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `relatedPlan` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `author` varchar(30) NOT NULL DEFAULT '',
  `content` mediumtext DEFAULT NULL,
  `customer` varchar(255) NOT NULL DEFAULT '',
  `researchObjects` varchar(255) NOT NULL DEFAULT '',
  `begin` datetime DEFAULT NULL,
  `end` datetime DEFAULT NULL,
  `location` varchar(255) NOT NULL DEFAULT '',
  `method` enum('','videoConference','interview','questionnaire','telephoneInterview') NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_review` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `object` mediumint(8) NOT NULL DEFAULT 0,
  `template` mediumint(8) NOT NULL DEFAULT 0,
  `doc` varchar(255) NOT NULL DEFAULT '',
  `docVersion` varchar(255) NOT NULL DEFAULT '',
  `status` char(30) NOT NULL DEFAULT '',
  `reviewedBy` varchar(255) NOT NULL DEFAULT '',
  `auditedBy` varchar(255) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `begin` date DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `lastReviewedBy` varchar(255) NOT NULL DEFAULT '',
  `lastReviewedDate` date DEFAULT NULL,
  `lastAuditedBy` varchar(255) NOT NULL DEFAULT '',
  `lastAuditedDate` date DEFAULT NULL,
  `lastEditedBy` varchar(255) NOT NULL DEFAULT '',
  `lastEditedDate` date DEFAULT NULL,
  `result` char(30) NOT NULL DEFAULT '',
  `auditResult` char(30) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_reviewcl` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `object` char(30) NOT NULL DEFAULT '',
  `category` char(30) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `order` mediumint(8) DEFAULT 0,
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_reviewissue` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `review` mediumint(8) NOT NULL DEFAULT 0,
  `approval` mediumint(8) NOT NULL DEFAULT 0,
  `injection` mediumint(8) NOT NULL DEFAULT 0,
  `identify` mediumint(8) NOT NULL DEFAULT 0,
  `type` char(30) NOT NULL DEFAULT 'review',
  `listID` mediumint(8) NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `opinion` mediumtext DEFAULT NULL,
  `opinionDate` date DEFAULT NULL,
  `status` char(30) NOT NULL DEFAULT '',
  `resolution` char(30) NOT NULL DEFAULT '',
  `resolutionBy` char(30) NOT NULL DEFAULT '',
  `resolutionDate` date DEFAULT NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_reviewlist` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `object` char(30) NOT NULL DEFAULT '',
  `category` char(30) NOT NULL DEFAULT '',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_reviewresult` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `review` mediumint(8) NOT NULL DEFAULT 0,
  `type` char(30) NOT NULL DEFAULT 'review',
  `result` char(30) NOT NULL DEFAULT '',
  `opinion` text DEFAULT NULL,
  `reviewer` char(30) NOT NULL DEFAULT '',
  `remainIssue` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `consumed` float NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `reviewer` (`review`,`reviewer`,`type`)
) ENGINE=InnoDB;
CREATE TABLE `zt_risk` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` varchar(255) NOT NULL DEFAULT '',
  `execution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `source` char(30) NOT NULL DEFAULT '',
  `category` char(30) NOT NULL DEFAULT '',
  `strategy` char(30) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT 'active',
  `impact` char(30) NOT NULL DEFAULT '',
  `probability` char(30) NOT NULL DEFAULT '',
  `rate` char(30) NOT NULL DEFAULT '',
  `pri` char(30) NOT NULL DEFAULT '',
  `identifiedDate` date DEFAULT NULL,
  `prevention` mediumtext DEFAULT NULL,
  `remedy` mediumtext DEFAULT NULL,
  `plannedClosedDate` date DEFAULT NULL,
  `actualClosedDate` date DEFAULT NULL,
  `lib` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `from` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `version` smallint(6) NOT NULL DEFAULT 1,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `resolution` mediumtext DEFAULT NULL,
  `resolvedBy` varchar(30) NOT NULL DEFAULT '',
  `activateBy` varchar(30) NOT NULL DEFAULT '',
  `activateDate` date DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` date DEFAULT NULL,
  `cancelBy` varchar(30) NOT NULL DEFAULT '',
  `cancelDate` date DEFAULT NULL,
  `cancelReason` char(30) NOT NULL DEFAULT '',
  `hangupBy` varchar(30) NOT NULL DEFAULT '',
  `hangupDate` date DEFAULT NULL,
  `trackedBy` varchar(30) NOT NULL DEFAULT '',
  `trackedDate` date DEFAULT NULL,
  `assignedDate` date DEFAULT NULL,
  `approvedDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_riskissue` (
  `risk` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `issue` mediumint(8) unsigned NOT NULL DEFAULT 0,
  UNIQUE KEY `risk_issue` (`risk`,`issue`)
) ENGINE=InnoDB;
CREATE TABLE `zt_roadmap` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) NOT NULL DEFAULT 0,
  `branch` mediumint(8) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `status` char(30) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `desc` longtext DEFAULT NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `closedBy` char(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `closedReason` enum('done','canceled') DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_roadmapstory` (
  `roadmap` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `story` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `order` mediumint(8) unsigned NOT NULL,
  UNIQUE KEY `roadmap_story` (`roadmap`,`story`)
) ENGINE=InnoDB;
CREATE TABLE `zt_scene` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `branch` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `module` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `sort` int(11) unsigned NOT NULL DEFAULT 0,
  `openedBy` char(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `lastEditedBy` char(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `parent` int(11) NOT NULL DEFAULT 0,
  `grade` tinyint(3) NOT NULL DEFAULT 0,
  `path` varchar(1000) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_score` (
  `id` bigint(12) unsigned NOT NULL AUTO_INCREMENT,
  `account` varchar(30) NOT NULL DEFAULT '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `method` varchar(30) NOT NULL DEFAULT '',
  `desc` varchar(250) NOT NULL DEFAULT '',
  `before` int(11) NOT NULL DEFAULT 0,
  `score` int(11) NOT NULL DEFAULT 0,
  `after` int(11) NOT NULL DEFAULT 0,
  `time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `module` (`module`),
  KEY `method` (`method`)
) ENGINE=InnoDB;
CREATE TABLE `zt_screen` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `dimension` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `acl` enum('open','private') NOT NULL DEFAULT 'open',
  `whitelist` text DEFAULT NULL,
  `cover` mediumtext DEFAULT NULL,
  `scheme` mediumtext DEFAULT NULL,
  `status` enum('draft','published') NOT NULL DEFAULT 'draft',
  `builtin` enum('0','1') NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_searchdict` (
  `key` smallint(6) unsigned NOT NULL DEFAULT 0,
  `value` char(3) NOT NULL DEFAULT '',
  PRIMARY KEY (`key`)
) ENGINE=InnoDB;
CREATE TABLE `zt_searchindex` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `objectType` char(20) NOT NULL DEFAULT '',
  `objectID` mediumint(9) NOT NULL DEFAULT 0,
  `title` text DEFAULT NULL,
  `content` text DEFAULT NULL,
  `addedDate` datetime DEFAULT NULL,
  `editedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`objectType`,`objectID`),
  KEY `addedDate` (`addedDate`),
  FULLTEXT KEY `title_content` (`title`,`content`)
) ENGINE=InnoDB;
CREATE TABLE `zt_serverroom` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL DEFAULT '',
  `city` varchar(128) NOT NULL DEFAULT '',
  `line` varchar(20) NOT NULL DEFAULT '',
  `bandwidth` varchar(128) NOT NULL DEFAULT '',
  `provider` varchar(128) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_service` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `external` enum('0','1') NOT NULL DEFAULT '0',
  `port` smallint(5) unsigned NOT NULL DEFAULT 0,
  `entry` varchar(255) NOT NULL DEFAULT '',
  `deploy` varchar(255) NOT NULL DEFAULT '',
  `version` varchar(64) NOT NULL DEFAULT '',
  `color` char(7) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `dept` varchar(128) NOT NULL DEFAULT '',
  `devel` varchar(30) NOT NULL DEFAULT '',
  `qa` varchar(30) NOT NULL DEFAULT '',
  `ops` varchar(30) NOT NULL DEFAULT '',
  `hosts` text DEFAULT NULL,
  `softName` varchar(128) NOT NULL DEFAULT '',
  `softVersion` varchar(128) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `parent` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `path` char(255) NOT NULL DEFAULT '',
  `grade` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `order` smallint(5) unsigned NOT NULL DEFAULT 0,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_session` (
  `id` varchar(32) NOT NULL,
  `data` mediumtext DEFAULT NULL,
  `timestamp` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB;
CREATE TABLE `zt_solution` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(50) NOT NULL DEFAULT '',
  `appID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `appName` char(50) NOT NULL DEFAULT '',
  `appVersion` char(20) NOT NULL DEFAULT '',
  `version` char(50) NOT NULL DEFAULT '',
  `chart` char(50) NOT NULL DEFAULT '',
  `cover` varchar(255) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `introduction` varchar(255) NOT NULL DEFAULT '',
  `source` char(20) NOT NULL DEFAULT '',
  `channel` char(20) NOT NULL DEFAULT '',
  `components` text DEFAULT NULL,
  `status` char(20) NOT NULL DEFAULT '',
  `deleted` tinyint(1) NOT NULL DEFAULT 0,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdAt` datetime DEFAULT NULL,
  `updatedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_solutions` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `execution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `contents` text NOT NULL,
  `support` text NOT NULL,
  `measures` text NOT NULL,
  `type` char(30) NOT NULL DEFAULT '',
  `addedBy` varchar(30) NOT NULL DEFAULT '',
  `addedDate` date DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_space` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `k8space` char(64) NOT NULL,
  `owner` char(30) NOT NULL,
  `default` tinyint(1) NOT NULL DEFAULT 0,
  `createdAt` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=InnoDB;
CREATE TABLE `zt_sqlbuilder` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `objectID` mediumint(8) NOT NULL,
  `objectType` varchar(50) NOT NULL,
  `sql` text DEFAULT NULL,
  `setting` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_sqlview` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL DEFAULT '',
  `code` varchar(45) NOT NULL DEFAULT '',
  `sql` text DEFAULT NULL,
  `desc` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_stage` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `percent` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `projectType` varchar(255) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_stakeholder` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `objectID` mediumint(8) NOT NULL DEFAULT 0,
  `objectType` char(30) NOT NULL DEFAULT '',
  `user` char(30) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT '',
  `key` enum('0','1') NOT NULL DEFAULT '0',
  `from` char(30) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `objectID` (`objectID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_story` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `parent` mediumint(9) NOT NULL DEFAULT 0,
  `isParent` enum('0','1') NOT NULL DEFAULT '0',
  `root` mediumint(9) NOT NULL DEFAULT 0,
  `path` text DEFAULT NULL,
  `grade` smallint(6) NOT NULL DEFAULT 0,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `branch` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `module` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `plan` text DEFAULT NULL,
  `source` varchar(20) NOT NULL DEFAULT '',
  `sourceNote` varchar(255) NOT NULL DEFAULT '',
  `fromBug` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `feedback` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT 'story',
  `category` varchar(30) NOT NULL DEFAULT 'feature',
  `pri` tinyint(3) unsigned NOT NULL DEFAULT 3,
  `estimate` float unsigned NOT NULL DEFAULT 0,
  `status` enum('','changing','active','draft','closed','reviewing','launched','developing') NOT NULL DEFAULT '',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `color` char(7) NOT NULL DEFAULT '',
  `stage` enum('','wait','inroadmap','incharter','planned','projected','designing','designed','developing','developed','testing','tested','verified','rejected','delivering','delivered','released','closed') NOT NULL DEFAULT 'wait',
  `stagedBy` char(30) NOT NULL DEFAULT '',
  `mailto` text DEFAULT NULL,
  `lib` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `fromStory` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `fromVersion` smallint(6) NOT NULL DEFAULT 1,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `approvedDate` date DEFAULT NULL,
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `changedBy` varchar(30) NOT NULL DEFAULT '',
  `changedDate` datetime DEFAULT NULL,
  `reviewedBy` varchar(255) NOT NULL DEFAULT '',
  `reviewedDate` datetime DEFAULT NULL,
  `releasedDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `closedReason` varchar(30) NOT NULL DEFAULT '',
  `activatedDate` datetime DEFAULT NULL,
  `toBug` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `linkStories` varchar(255) NOT NULL DEFAULT '',
  `linkRequirements` varchar(255) NOT NULL DEFAULT '',
  `twins` varchar(255) NOT NULL DEFAULT '',
  `duplicateStory` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `version` smallint(6) NOT NULL DEFAULT 1,
  `parentVersion` smallint(6) NOT NULL DEFAULT 0,
  `demandVersion` smallint(6) NOT NULL DEFAULT 0,
  `storyChanged` enum('0','1') NOT NULL DEFAULT '0',
  `feedbackBy` varchar(100) NOT NULL DEFAULT '',
  `notifyEmail` varchar(100) NOT NULL DEFAULT '',
  `BSA` char(30) NOT NULL DEFAULT '',
  `duration` char(30) NOT NULL DEFAULT '',
  `demand` mediumint(8) NOT NULL DEFAULT 0,
  `submitedBy` varchar(30) NOT NULL DEFAULT '',
  `roadmap` varchar(255) NOT NULL DEFAULT '',
  `URChanged` enum('0','1') NOT NULL DEFAULT '0',
  `unlinkReason` enum('','omit','other') NOT NULL DEFAULT '',
  `retractedReason` enum('','omit','other') NOT NULL DEFAULT '',
  `retractedBy` varchar(30) NOT NULL DEFAULT '',
  `retractedDate` datetime DEFAULT NULL,
  `verifiedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `root` (`root`),
  KEY `status` (`status`),
  KEY `assignedTo` (`assignedTo`)
) ENGINE=InnoDB;
CREATE TABLE `zt_storyestimate` (
  `story` mediumint(9) NOT NULL DEFAULT 0,
  `round` smallint(6) NOT NULL DEFAULT 0,
  `estimate` text DEFAULT NULL,
  `average` float NOT NULL DEFAULT 0,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  UNIQUE KEY `story` (`story`,`round`)
) ENGINE=InnoDB;
CREATE TABLE `zt_storygrade` (
  `type` enum('story','requirement','epic') NOT NULL,
  `grade` smallint(6) NOT NULL,
  `name` char(30) NOT NULL,
  `status` char(30) NOT NULL
) ENGINE=InnoDB;
CREATE TABLE `zt_storyreview` (
  `story` mediumint(9) NOT NULL DEFAULT 0,
  `version` smallint(6) NOT NULL DEFAULT 0,
  `reviewer` varchar(30) NOT NULL DEFAULT '',
  `result` varchar(30) NOT NULL DEFAULT '',
  `reviewDate` datetime DEFAULT NULL,
  UNIQUE KEY `story` (`story`,`version`,`reviewer`)
) ENGINE=InnoDB;
CREATE TABLE `zt_storyspec` (
  `story` mediumint(9) NOT NULL DEFAULT 0,
  `version` smallint(6) NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `spec` mediumtext DEFAULT NULL,
  `verify` mediumtext DEFAULT NULL,
  `files` text DEFAULT NULL,
  UNIQUE KEY `story` (`story`,`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_storystage` (
  `story` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `branch` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `stage` varchar(50) NOT NULL DEFAULT '',
  `stagedBy` char(30) NOT NULL DEFAULT '',
  UNIQUE KEY `story_branch` (`story`,`branch`),
  KEY `story` (`story`)
) ENGINE=InnoDB;
CREATE TABLE `zt_suitecase` (
  `suite` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `case` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `version` smallint(5) unsigned NOT NULL DEFAULT 0,
  UNIQUE KEY `suitecase` (`suite`,`case`)
) ENGINE=InnoDB;
CREATE TABLE `zt_task` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `parent` mediumint(8) NOT NULL DEFAULT 0,
  `execution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `module` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `design` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `story` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `storyVersion` smallint(6) NOT NULL DEFAULT 1,
  `designVersion` smallint(6) unsigned NOT NULL DEFAULT 1,
  `fromBug` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `feedback` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `fromIssue` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT '',
  `mode` varchar(10) NOT NULL DEFAULT '',
  `pri` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `estimate` float unsigned NOT NULL DEFAULT 0,
  `consumed` float unsigned NOT NULL DEFAULT 0,
  `left` float unsigned NOT NULL DEFAULT 0,
  `deadline` date DEFAULT NULL,
  `status` enum('wait','doing','done','pause','cancel','closed') NOT NULL DEFAULT 'wait',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `color` char(7) NOT NULL DEFAULT '',
  `mailto` text DEFAULT NULL,
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `version` smallint(6) NOT NULL DEFAULT 0,
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `estStarted` date DEFAULT NULL,
  `realStarted` datetime DEFAULT NULL,
  `finishedBy` varchar(30) NOT NULL DEFAULT '',
  `finishedDate` datetime DEFAULT NULL,
  `finishedList` text DEFAULT NULL,
  `canceledBy` varchar(30) NOT NULL DEFAULT '',
  `canceledDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `planDuration` int(11) NOT NULL DEFAULT 0,
  `realDuration` int(11) NOT NULL DEFAULT 0,
  `closedReason` varchar(30) NOT NULL DEFAULT '',
  `lastEditedBy` varchar(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `activatedDate` datetime DEFAULT NULL,
  `order` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `repo` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `mr` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `entry` varchar(255) NOT NULL DEFAULT '',
  `lines` varchar(10) NOT NULL DEFAULT '',
  `v1` varchar(40) NOT NULL DEFAULT '',
  `v2` varchar(40) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  KEY `execution` (`execution`),
  KEY `story` (`story`),
  KEY `parent` (`parent`),
  KEY `assignedTo` (`assignedTo`),
  KEY `order` (`order`)
) ENGINE=InnoDB;
CREATE TABLE `zt_taskestimate` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `task` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `left` float unsigned NOT NULL DEFAULT 0,
  `consumed` float unsigned NOT NULL DEFAULT 0,
  `account` char(30) NOT NULL DEFAULT '',
  `work` text DEFAULT NULL,
  `order` tinyint(3) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `task` (`task`)
) ENGINE=InnoDB;
CREATE TABLE `zt_taskspec` (
  `task` mediumint(8) NOT NULL DEFAULT 0,
  `version` smallint(6) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `estStarted` date DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  UNIQUE KEY `task` (`task`,`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_taskteam` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `task` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `account` char(30) NOT NULL DEFAULT '',
  `estimate` decimal(12,2) NOT NULL DEFAULT 0.00,
  `consumed` decimal(12,2) NOT NULL DEFAULT 0.00,
  `left` decimal(12,2) NOT NULL DEFAULT 0.00,
  `transfer` char(30) NOT NULL DEFAULT '',
  `status` enum('wait','doing','done','cancel','closed') NOT NULL DEFAULT 'wait',
  `order` int(8) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `task` (`task`)
) ENGINE=InnoDB;
CREATE TABLE `zt_team` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `root` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `type` enum('project','task','execution') NOT NULL DEFAULT 'project',
  `account` char(30) NOT NULL DEFAULT '',
  `role` char(30) NOT NULL DEFAULT '',
  `position` varchar(30) NOT NULL DEFAULT '',
  `limited` char(8) NOT NULL DEFAULT 'no',
  `join` date DEFAULT NULL,
  `days` smallint(5) unsigned NOT NULL DEFAULT 0,
  `hours` float(3,1) unsigned NOT NULL DEFAULT 0.0,
  `estimate` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `consumed` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `left` decimal(12,2) unsigned NOT NULL DEFAULT 0.00,
  `order` tinyint(3) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `team` (`root`,`type`,`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_testreport` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `execution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `tasks` varchar(255) NOT NULL DEFAULT '',
  `builds` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `owner` char(30) NOT NULL DEFAULT '',
  `members` text DEFAULT NULL,
  `stories` text DEFAULT NULL,
  `bugs` text DEFAULT NULL,
  `cases` text DEFAULT NULL,
  `report` text DEFAULT NULL,
  `objectType` varchar(20) NOT NULL DEFAULT '',
  `objectID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_testresult` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `run` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `case` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `version` smallint(5) unsigned NOT NULL DEFAULT 0,
  `job` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `compile` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `caseResult` char(30) NOT NULL DEFAULT '',
  `stepResults` text DEFAULT NULL,
  `ZTFResult` text DEFAULT NULL,
  `node` int(8) unsigned NOT NULL DEFAULT 0,
  `lastRunner` varchar(30) NOT NULL DEFAULT '',
  `date` datetime DEFAULT NULL,
  `duration` float NOT NULL DEFAULT 0,
  `xml` text DEFAULT NULL,
  `deploy` mediumint(8) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `case` (`case`),
  KEY `version` (`version`),
  KEY `run` (`run`)
) ENGINE=InnoDB;
CREATE TABLE `zt_testrun` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `task` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `case` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `version` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `assignedTo` char(30) NOT NULL DEFAULT '',
  `lastRunner` varchar(30) NOT NULL DEFAULT '',
  `lastRunDate` datetime DEFAULT NULL,
  `lastRunResult` char(30) NOT NULL DEFAULT '',
  `status` char(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `task` (`task`,`case`)
) ENGINE=InnoDB;
CREATE TABLE `zt_testsuite` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `type` varchar(20) NOT NULL DEFAULT '',
  `order` smallint(5) unsigned NOT NULL DEFAULT 0,
  `addedBy` char(30) NOT NULL DEFAULT '',
  `addedDate` datetime DEFAULT NULL,
  `lastEditedBy` char(30) NOT NULL DEFAULT '',
  `lastEditedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `product` (`product`)
) ENGINE=InnoDB;
CREATE TABLE `zt_testtask` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` char(90) NOT NULL DEFAULT '',
  `execution` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `build` char(30) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `owner` varchar(30) NOT NULL DEFAULT '',
  `pri` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `realBegan` date DEFAULT NULL,
  `realFinishedDate` datetime DEFAULT NULL,
  `mailto` text DEFAULT NULL,
  `desc` mediumtext DEFAULT NULL,
  `report` text DEFAULT NULL,
  `status` enum('blocked','doing','wait','done') NOT NULL DEFAULT 'wait',
  `testreport` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `auto` varchar(10) NOT NULL DEFAULT 'no',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `members` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product` (`product`),
  KEY `build` (`build`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ticket` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `product` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `module` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `openedBuild` varchar(255) NOT NULL DEFAULT '',
  `feedback` mediumint(8) NOT NULL DEFAULT 0,
  `assignedTo` varchar(255) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `realStarted` datetime DEFAULT NULL,
  `startedBy` varchar(255) NOT NULL DEFAULT '',
  `startedDate` datetime DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `pri` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `estimate` float unsigned NOT NULL DEFAULT 0,
  `left` float unsigned NOT NULL DEFAULT 0,
  `status` varchar(30) NOT NULL DEFAULT '',
  `openedBy` varchar(30) NOT NULL DEFAULT '',
  `openedDate` datetime DEFAULT NULL,
  `activatedCount` int(11) NOT NULL DEFAULT 0,
  `activatedBy` varchar(30) NOT NULL DEFAULT '',
  `activatedDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `closedReason` varchar(30) NOT NULL DEFAULT '',
  `finishedBy` varchar(30) NOT NULL DEFAULT '',
  `finishedDate` datetime DEFAULT NULL,
  `resolvedBy` varchar(30) NOT NULL DEFAULT '',
  `resolvedDate` datetime DEFAULT NULL,
  `resolution` text DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `repeatTicket` mediumint(8) NOT NULL DEFAULT 0,
  `mailto` varchar(255) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `subStatus` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `product` (`product`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ticketrelation` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `ticketId` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `objectId` mediumint(8) NOT NULL DEFAULT 0,
  `objectType` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `ticketId` (`ticketId`)
) ENGINE=InnoDB;
CREATE TABLE `zt_ticketsource` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `ticketId` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `customer` varchar(100) NOT NULL DEFAULT '',
  `contact` varchar(100) NOT NULL DEFAULT '',
  `notifyEmail` varchar(100) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ticketId` (`ticketId`)
) ENGINE=InnoDB;
CREATE TABLE `zt_todo` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL DEFAULT '',
  `date` date DEFAULT NULL,
  `begin` smallint(4) unsigned zerofill NOT NULL DEFAULT 0000,
  `end` smallint(4) unsigned zerofill NOT NULL DEFAULT 0000,
  `feedback` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `type` char(15) NOT NULL DEFAULT '',
  `cycle` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `objectID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `pri` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `name` char(150) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `status` enum('wait','doing','done','closed') NOT NULL DEFAULT 'wait',
  `private` tinyint(1) NOT NULL DEFAULT 0,
  `config` varchar(1000) NOT NULL DEFAULT '',
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedBy` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `finishedBy` varchar(30) NOT NULL DEFAULT '',
  `finishedDate` datetime DEFAULT NULL,
  `closedBy` varchar(30) NOT NULL DEFAULT '',
  `closedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `assignedTo` (`assignedTo`),
  KEY `finishedBy` (`finishedBy`),
  KEY `date` (`date`)
) ENGINE=InnoDB;
CREATE TABLE `zt_traincategory` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(30) NOT NULL DEFAULT '',
  `parent` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `path` char(255) NOT NULL DEFAULT '',
  `grade` tinyint(3) NOT NULL DEFAULT 0,
  `order` mediumint(8) NOT NULL DEFAULT 0,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent` (`parent`),
  KEY `path` (`path`)
) ENGINE=InnoDB;
CREATE TABLE `zt_traincontents` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(50) NOT NULL DEFAULT '',
  `course` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(30) NOT NULL DEFAULT '',
  `parent` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `path` char(255) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `order` mediumint(8) NOT NULL DEFAULT 0,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_traincourse` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL DEFAULT '',
  `category` mediumint(8) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(10) NOT NULL DEFAULT '',
  `teacher` varchar(30) NOT NULL DEFAULT '',
  `desc` mediumtext DEFAULT NULL,
  `importedStatus` enum('','wait','doing','done') NOT NULL DEFAULT '',
  `lastUpdatedTime` int(10) unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(255) NOT NULL DEFAULT '',
  `createdDate` date DEFAULT NULL,
  `editedBy` varchar(255) NOT NULL DEFAULT '',
  `editedDate` date DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_trainplan` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `place` varchar(255) NOT NULL DEFAULT '',
  `trainee` text DEFAULT NULL,
  `lecturer` varchar(20) NOT NULL DEFAULT '',
  `type` enum('inside','outside') NOT NULL DEFAULT 'inside',
  `status` varchar(20) NOT NULL DEFAULT '',
  `summary` mediumtext DEFAULT NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_trainrecords` (
  `user` char(30) NOT NULL DEFAULT '',
  `objectId` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `objectType` varchar(10) NOT NULL DEFAULT '',
  `status` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`user`,`objectId`,`objectType`)
) ENGINE=InnoDB;
CREATE TABLE `zt_trip` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('trip','egress') NOT NULL DEFAULT 'trip',
  `customers` varchar(20) NOT NULL DEFAULT '',
  `name` char(30) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `year` char(4) NOT NULL DEFAULT '',
  `begin` date DEFAULT NULL,
  `end` date DEFAULT NULL,
  `start` time DEFAULT NULL,
  `finish` time DEFAULT NULL,
  `from` char(50) NOT NULL DEFAULT '',
  `to` char(50) NOT NULL DEFAULT '',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `year` (`year`),
  KEY `createdBy` (`createdBy`)
) ENGINE=InnoDB;
CREATE TABLE `zt_user` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `company` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `type` char(30) NOT NULL DEFAULT 'inside',
  `dept` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `account` char(30) NOT NULL DEFAULT '',
  `password` char(32) NOT NULL DEFAULT '',
  `role` char(10) NOT NULL DEFAULT '',
  `realname` varchar(100) NOT NULL DEFAULT '',
  `superior` char(30) DEFAULT '',
  `pinyin` varchar(255) NOT NULL DEFAULT '',
  `nickname` char(60) NOT NULL DEFAULT '',
  `commiter` varchar(100) NOT NULL DEFAULT '',
  `avatar` text DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `gender` enum('f','m') NOT NULL DEFAULT 'f',
  `email` char(90) NOT NULL DEFAULT '',
  `skype` char(90) NOT NULL DEFAULT '',
  `qq` char(20) NOT NULL DEFAULT '',
  `mobile` char(11) NOT NULL DEFAULT '',
  `phone` char(20) NOT NULL DEFAULT '',
  `weixin` varchar(90) NOT NULL DEFAULT '',
  `dingding` varchar(90) NOT NULL DEFAULT '',
  `slack` varchar(90) NOT NULL DEFAULT '',
  `whatsapp` varchar(90) NOT NULL DEFAULT '',
  `address` char(120) NOT NULL DEFAULT '',
  `zipcode` char(10) NOT NULL DEFAULT '',
  `nature` text DEFAULT NULL,
  `analysis` text DEFAULT NULL,
  `strategy` text DEFAULT NULL,
  `join` date DEFAULT NULL,
  `visits` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `visions` varchar(20) NOT NULL DEFAULT 'rnd,lite',
  `ip` varchar(255) NOT NULL DEFAULT '',
  `last` int(11) unsigned NOT NULL DEFAULT 0,
  `fails` tinyint(5) NOT NULL DEFAULT 0,
  `locked` datetime DEFAULT NULL,
  `feedback` enum('0','1') NOT NULL DEFAULT '0',
  `ranzhi` char(30) NOT NULL DEFAULT '',
  `ldap` char(30) NOT NULL DEFAULT '',
  `score` int(11) NOT NULL DEFAULT 0,
  `scoreLevel` int(11) NOT NULL DEFAULT 0,
  `resetToken` varchar(50) NOT NULL DEFAULT '',
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `clientStatus` enum('online','away','busy','offline','meeting') NOT NULL DEFAULT 'offline',
  `clientLang` varchar(10) NOT NULL DEFAULT 'zh-cn',
  PRIMARY KEY (`id`),
  UNIQUE KEY `account` (`account`),
  KEY `dept` (`dept`),
  KEY `email` (`email`),
  KEY `commiter` (`commiter`),
  KEY `deleted` (`deleted`)
) ENGINE=InnoDB;
CREATE TABLE `zt_usercontact` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL DEFAULT '',
  `listName` varchar(60) NOT NULL DEFAULT '',
  `userList` text DEFAULT NULL,
  `public` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `account` (`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_usergroup` (
  `account` char(30) NOT NULL DEFAULT '',
  `group` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `project` text DEFAULT NULL,
  UNIQUE KEY `account` (`account`,`group`)
) ENGINE=InnoDB;
CREATE TABLE `zt_userquery` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL DEFAULT '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `title` varchar(90) NOT NULL DEFAULT '',
  `form` text DEFAULT NULL,
  `sql` text DEFAULT NULL,
  `shortcut` enum('0','1') NOT NULL DEFAULT '0',
  `common` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `account` (`account`),
  KEY `module` (`module`)
) ENGINE=InnoDB;
CREATE TABLE `zt_usertpl` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `account` char(30) NOT NULL DEFAULT '',
  `type` char(30) NOT NULL DEFAULT '',
  `title` varchar(150) NOT NULL DEFAULT '',
  `content` text DEFAULT NULL,
  `public` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `account` (`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_userview` (
  `account` char(30) NOT NULL DEFAULT '',
  `programs` mediumtext DEFAULT NULL,
  `products` mediumtext DEFAULT NULL,
  `projects` mediumtext DEFAULT NULL,
  `sprints` mediumtext DEFAULT NULL,
  UNIQUE KEY `account` (`account`)
) ENGINE=InnoDB;
CREATE TABLE `zt_webhook` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(15) NOT NULL DEFAULT 'default',
  `name` varchar(50) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `domain` varchar(255) NOT NULL DEFAULT '',
  `secret` varchar(255) NOT NULL DEFAULT '',
  `contentType` varchar(30) NOT NULL DEFAULT 'application/json',
  `sendType` enum('sync','async') NOT NULL DEFAULT 'sync',
  `products` text DEFAULT NULL,
  `executions` text DEFAULT NULL,
  `params` varchar(100) NOT NULL DEFAULT '',
  `actions` text DEFAULT NULL,
  `desc` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_weeklyreport` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `weekStart` date DEFAULT NULL,
  `pv` float(9,2) NOT NULL DEFAULT 0.00,
  `ev` float(9,2) NOT NULL DEFAULT 0.00,
  `ac` float(9,2) NOT NULL DEFAULT 0.00,
  `sv` float(9,2) NOT NULL DEFAULT 0.00,
  `cv` float(9,2) NOT NULL DEFAULT 0.00,
  `staff` smallint(5) unsigned NOT NULL DEFAULT 0,
  `progress` varchar(255) NOT NULL DEFAULT '',
  `workload` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `week` (`project`,`weekStart`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workestimation` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `project` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `scale` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `productivity` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `duration` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `unitLaborCost` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `totalLaborCost` decimal(10,2) unsigned NOT NULL DEFAULT 0.00,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `assignedTo` varchar(30) NOT NULL DEFAULT '',
  `assignedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  `dayHour` decimal(10,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflow` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `group` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `parent` varchar(30) NOT NULL DEFAULT '',
  `child` varchar(30) NOT NULL DEFAULT '',
  `type` varchar(10) NOT NULL DEFAULT 'flow',
  `navigator` varchar(10) NOT NULL DEFAULT '',
  `app` varchar(20) NOT NULL DEFAULT '',
  `position` varchar(30) NOT NULL DEFAULT '',
  `module` varchar(30) NOT NULL DEFAULT '',
  `table` varchar(50) NOT NULL DEFAULT '',
  `name` varchar(30) NOT NULL DEFAULT '',
  `icon` varchar(30) NOT NULL DEFAULT 'flow',
  `titleField` varchar(30) NOT NULL DEFAULT '',
  `contentField` text DEFAULT NULL,
  `flowchart` text DEFAULT NULL,
  `js` text DEFAULT NULL,
  `css` text DEFAULT NULL,
  `order` smallint(5) unsigned NOT NULL DEFAULT 0,
  `buildin` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `role` varchar(10) NOT NULL DEFAULT 'buildin',
  `belong` varchar(50) NOT NULL DEFAULT '',
  `administrator` text DEFAULT NULL,
  `desc` text DEFAULT NULL,
  `version` varchar(10) NOT NULL DEFAULT '1.0',
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `approval` enum('enabled','disabled') NOT NULL DEFAULT 'disabled',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`group`,`app`,`module`,`vision`),
  KEY `type` (`type`),
  KEY `app` (`app`),
  KEY `module` (`module`),
  KEY `order` (`order`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowaction` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `group` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `module` varchar(30) NOT NULL DEFAULT '',
  `action` varchar(50) NOT NULL DEFAULT '',
  `method` varchar(50) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `type` enum('single','batch') NOT NULL DEFAULT 'single',
  `batchMode` enum('same','different') NOT NULL DEFAULT 'different',
  `extensionType` varchar(10) NOT NULL DEFAULT 'override',
  `open` varchar(20) NOT NULL DEFAULT '',
  `position` enum('menu','browseandview','browse','view') NOT NULL DEFAULT 'browseandview',
  `layout` char(20) NOT NULL DEFAULT '',
  `show` enum('dropdownlist','direct') NOT NULL DEFAULT 'dropdownlist',
  `order` smallint(5) unsigned NOT NULL DEFAULT 0,
  `buildin` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `role` varchar(10) NOT NULL DEFAULT 'custom',
  `virtual` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `conditions` text DEFAULT NULL,
  `verifications` text DEFAULT NULL,
  `hooks` text DEFAULT NULL,
  `linkages` text DEFAULT NULL,
  `js` text DEFAULT NULL,
  `css` text DEFAULT NULL,
  `toList` char(255) NOT NULL DEFAULT '',
  `blocks` text DEFAULT NULL,
  `desc` text DEFAULT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'enable',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`group`,`module`,`action`,`vision`),
  KEY `module` (`module`),
  KEY `action` (`action`),
  KEY `order` (`order`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowdatasource` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('system','sql','func','option','lang','category') NOT NULL DEFAULT 'option',
  `name` varchar(30) NOT NULL DEFAULT '',
  `code` varchar(30) NOT NULL DEFAULT '',
  `datasource` text DEFAULT NULL,
  `view` varchar(20) NOT NULL DEFAULT '',
  `keyField` varchar(50) NOT NULL DEFAULT '',
  `valueField` varchar(50) NOT NULL DEFAULT '',
  `buildin` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowfield` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `group` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `module` varchar(30) NOT NULL DEFAULT '',
  `field` varchar(50) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT 'varchar',
  `length` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `control` varchar(20) NOT NULL DEFAULT '',
  `expression` text DEFAULT NULL,
  `options` text DEFAULT NULL,
  `default` varchar(100) NOT NULL DEFAULT '',
  `rules` varchar(255) NOT NULL DEFAULT '',
  `placeholder` varchar(100) NOT NULL DEFAULT '',
  `order` smallint(5) unsigned NOT NULL DEFAULT 0,
  `searchOrder` smallint(5) unsigned NOT NULL DEFAULT 0,
  `exportOrder` smallint(5) unsigned NOT NULL DEFAULT 0,
  `canExport` enum('0','1') NOT NULL DEFAULT '0',
  `canSearch` enum('0','1') NOT NULL DEFAULT '0',
  `isValue` enum('0','1') NOT NULL DEFAULT '0',
  `readonly` enum('0','1') NOT NULL DEFAULT '0',
  `buildin` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `role` varchar(10) NOT NULL DEFAULT 'custom',
  `desc` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`group`,`module`,`field`),
  KEY `module` (`module`),
  KEY `field` (`field`),
  KEY `order` (`order`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowgroup` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(10) NOT NULL DEFAULT '',
  `projectModel` varchar(10) NOT NULL DEFAULT '',
  `projectType` varchar(10) NOT NULL DEFAULT '',
  `name` varchar(30) NOT NULL DEFAULT '',
  `code` varchar(30) NOT NULL DEFAULT '',
  `desc` text DEFAULT NULL,
  `disabledModules` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  `main` enum('0','1') NOT NULL DEFAULT '0',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowlabel` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `group` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `module` varchar(30) NOT NULL DEFAULT '',
  `action` varchar(30) NOT NULL DEFAULT 'browse',
  `code` varchar(30) NOT NULL DEFAULT '',
  `label` varchar(255) NOT NULL DEFAULT '',
  `params` text DEFAULT NULL,
  `orderBy` text DEFAULT NULL,
  `order` tinyint(3) NOT NULL DEFAULT 0,
  `buildin` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `role` varchar(10) NOT NULL DEFAULT 'custom',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`module`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowlayout` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `group` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `module` varchar(30) NOT NULL DEFAULT '',
  `action` varchar(50) NOT NULL DEFAULT '',
  `ui` mediumint(8) NOT NULL DEFAULT 0,
  `field` varchar(50) NOT NULL DEFAULT '',
  `order` smallint(5) unsigned NOT NULL DEFAULT 0,
  `width` varchar(50) NOT NULL DEFAULT '0',
  `position` text DEFAULT NULL,
  `readonly` enum('0','1') NOT NULL DEFAULT '0',
  `mobileShow` enum('0','1') NOT NULL DEFAULT '1',
  `summary` varchar(20) NOT NULL DEFAULT '',
  `defaultValue` text DEFAULT NULL,
  `layoutRules` varchar(255) NOT NULL DEFAULT '',
  `vision` varchar(10) NOT NULL DEFAULT 'rnd',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`group`,`module`,`action`,`ui`,`field`,`vision`),
  KEY `module` (`module`),
  KEY `action` (`action`),
  KEY `order` (`order`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowlinkdata` (
  `objectType` varchar(30) NOT NULL DEFAULT '',
  `objectID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `linkedType` varchar(30) NOT NULL DEFAULT '',
  `linkedID` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  UNIQUE KEY `unique` (`objectType`,`objectID`,`linkedType`,`linkedID`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowrelation` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `prev` varchar(30) NOT NULL DEFAULT '',
  `next` varchar(30) NOT NULL DEFAULT '',
  `field` varchar(50) NOT NULL DEFAULT '',
  `actions` varchar(20) NOT NULL DEFAULT '',
  `actionCodes` text DEFAULT NULL,
  `buildin` enum('0','1') NOT NULL DEFAULT '0',
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowrelationlayout` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `prev` varchar(30) NOT NULL DEFAULT '',
  `next` varchar(30) NOT NULL DEFAULT '',
  `action` varchar(50) NOT NULL DEFAULT '',
  `ui` mediumint(8) NOT NULL DEFAULT 0,
  `field` varchar(50) NOT NULL DEFAULT '',
  `order` smallint(5) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`prev`,`next`,`action`,`ui`,`field`),
  KEY `prev` (`prev`),
  KEY `next` (`next`),
  KEY `action` (`action`),
  KEY `order` (`order`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowreport` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL,
  `name` varchar(100) NOT NULL,
  `type` enum('pie','line','bar') NOT NULL DEFAULT 'pie',
  `countType` enum('sum','count') NOT NULL DEFAULT 'sum',
  `displayType` enum('value','percent') NOT NULL DEFAULT 'value',
  `dimension` varchar(130) NOT NULL,
  `fields` text NOT NULL,
  `order` smallint(5) unsigned NOT NULL DEFAULT 0,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowrule` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('system','regex','func') NOT NULL DEFAULT 'regex',
  `name` varchar(30) NOT NULL DEFAULT '',
  `rule` text DEFAULT NULL,
  `createdBy` char(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` char(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowsql` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL DEFAULT '',
  `field` varchar(50) NOT NULL DEFAULT '',
  `action` varchar(50) NOT NULL DEFAULT '',
  `sql` text DEFAULT NULL,
  `vars` text DEFAULT NULL,
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`module`),
  KEY `field` (`field`),
  KEY `action` (`action`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowui` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `group` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `module` varchar(30) NOT NULL,
  `action` varchar(50) NOT NULL,
  `name` varchar(30) NOT NULL,
  `conditions` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`module`),
  KEY `action` (`action`)
) ENGINE=InnoDB;
CREATE TABLE `zt_workflowversion` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(30) NOT NULL DEFAULT '',
  `version` varchar(10) NOT NULL DEFAULT '',
  `fields` text DEFAULT NULL,
  `actions` text DEFAULT NULL,
  `layouts` text DEFAULT NULL,
  `sqls` text DEFAULT NULL,
  `labels` text DEFAULT NULL,
  `table` text DEFAULT NULL,
  `datas` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `moduleversion` (`module`,`version`),
  KEY `module` (`module`),
  KEY `version` (`version`)
) ENGINE=InnoDB;
CREATE TABLE `zt_zoutput` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `activity` mediumint(8) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL DEFAULT '',
  `content` mediumtext DEFAULT NULL,
  `optional` char(20) NOT NULL DEFAULT '',
  `tailorNorm` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(30) NOT NULL DEFAULT '',
  `createdBy` varchar(30) NOT NULL DEFAULT '',
  `createdDate` datetime DEFAULT NULL,
  `editedBy` varchar(30) NOT NULL DEFAULT '',
  `editedDate` datetime DEFAULT NULL,
  `order` mediumint(8) DEFAULT 0,
  `deleted` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB;
