<?php
$pmsRepoPath = getenv('SRC_PMS_PATH');
foreach(array('zh-cn', 'en') as $lang)
{
    /* 检查my.php 中有没有apiGetModel关键字 */
    /* 没有的话追加一条配置：$config->features->apiGetModel = true; */
    $dirName  = $lang == 'zh-cn' ? 'zentaotest' : 'zentaotesten';
    $baseUrl  = 'http://localhost';
    $basePath = "/var/www/$dirName";
    $flowSql  = $lang == 'zh-cn' ? 'flow.sql' : 'enflow.sql';

    `sudo chmod -R 777 $basePath`;

    if($lang == 'en') `sed -i "s/\$config->default->lang   = 'zh-cn';/\$config->default->lang   = 'en';/" $basePath/config/my.php`;

    $checkConfig = `grep apiGetModel $basePath/config/my.php`;
    if(empty($checkConfig)) file_put_contents("$basePath/config/my.php", "\n\$config->features->apiGetModel = true;", FILE_APPEND);

    /* 删除zentaotest数据库；创建zentaotest数据库 */
    $dbFile = "$basePath/db/zentao.sql";
    $dbName = $dirName;

    `sudo rm -f $dbFile`;
    `sudo cp -af $pmsRepoPath/db/zentao.sql $basePath/db/`;

    $tableContent = preg_replace('/__DELIMITER__+/', ";", file_get_contents($dbFile));
    $tableContent = preg_replace('/__TABLE__+/', $dbName, $tableContent);
    $tableContent = preg_replace('/^CREATE\s+FUNCTION+/m', "DELIMITER ;;\nCREATE FUNCTION", $tableContent);
    $tableContent = preg_replace('/END;+/', "END;; \nDELIMITER ;", $tableContent);
    file_put_contents($dbFile, "SET @@sql_mode='';\nSET NAMES utf8;" . $tableContent);

    `mysql -uzentao -p123456 -e "DROP DATABASE IF EXISTS $dbName"`;
    `mysql -uzentao -p123456 -e "CREATE DATABASE IF NOT EXISTS $dbName COLLATE 'utf8_general_ci'"`;
    `mysql -uzentao -p123456 -D{$dbName} < $dbFile`;

    /* 插入一条公司数据 */
    system("mysql -uzentao -p123456 -D{$dbName} -e \"INSERT INTO zt_company (name, admins) VALUES('flowTest', ',admin,');\"");

    /* 执行三条升级程序 */
    `cd $basePath/bin/; sudo ./ztcli $baseUrl/api-getmodel-upgrade-importBuildinModules.html`;
    `cd $basePath/bin/; sudo ./ztcli $baseUrl/api-getmodel-upgrade-importLiteModules.html`;
    `cd $basePath/bin/; sudo ./ztcli $baseUrl/api-getmodel-upgrade-addSubStatus.html`;

    `mysqldump -uzentao -p123456 --compact -t $dbName --tables zt_workflow zt_workflowaction zt_workflowdatasource zt_workflowfield zt_workflowlabel zt_workflowlayout zt_workflowrule > $flowSql`;

    $sqlContents = file_get_contents($flowSql);
    $sqlContents = str_replace("INSERT", 'REPLACE', $sqlContents);
    $sqlContents = str_replace("guest", '', $sqlContents);
    file_put_contents($flowSql, "SET NAMES utf8;\n$sqlContents");
}
