<?php
define('DS', DIRECTORY_SEPARATOR);

$basePath = dirname(dirname(__FILE__));

include $basePath . '/framework/router.class.php';
include $basePath . '/framework/control.class.php';
include $basePath . '/framework/model.class.php';
include $basePath . '/framework/helper.class.php';

$modules = glob($basePath . '/module/*');
foreach($modules as $modulePath)
{
    mergeExt($modulePath);
}

function mergeExt($modulePath)
{
    $moduleName = basename($modulePath);
    echo "Merge $moduleName\n";
    if(!is_dir($modulePath . '/ext')) return true;

    /* Merge model. */
    if(is_dir($modulePath . '/ext/model'))
    {
        echo "Merge $moduleName model\n";
        $mainModelFile  = $modulePath . '/model.php';
        $mainModelLines = explode("\n", trim(file_get_contents($mainModelFile)));
        helper::import($mainModelFile);
        $moduleReflection = new ReflectionClass($moduleName . 'Model');
        $moduleAllMethods = getAllMethods($moduleReflection);
        $lastLine         = $moduleReflection->getEndLine() - 1;

        $hasMethods  = array();
        $extContents = '';

        if(is_dir($modulePath . '/ext/model/hook/'))
        {
            foreach(glob($modulePath . '/ext/model/hook/*.php') as $extModelHookFile)
            {
                $mergeToMainModel = true;
                $hookContent = removePHPTAG($extModelHookFile);
                $extMethod   = basename($extModelHookFile);
                $extMethod   = substr($extMethod, 0, strpos($extMethod, '.'));
                foreach(glob($modulePath . '/ext/model/*.php') as $extModelFile)
                {
                    $extContents = file_get_contents($extModelFile);
                    $position    = stripos($extContents, " function $extMethod(");
                    if($position !== false)
                    {
                        $extContents = preg_replace("/( function $extMethod\([^\)]*\)\n){/Ui","$1{\n" . $hookContent . "\n", $extContents);
                        file_put_contents($extModelFile, $extContents);
                        $mergeToMainModel = false;
                    }
                }
                if($mergeToMainModel)
                {
                    $methodReflection = $moduleReflection->getMethod($extMethod);
                    $startLine = $methodReflection->getStartLine();
                    $mainModelLines[$startLine + 1] = $hookContent . "\n" . $mainModelLines[$startLine + 1];
                }
            }
        }
        $mainModelContents = join("\n", $mainModelLines);
        file_put_contents($mainModelFile, $mainModelContents);

        if(is_dir($modulePath . '/ext/model/hook/'))
        {
            foreach(glob($modulePath . '/ext/model/hook/*.php') as $extModelFile) `rm $extModelFile`;
            rmdir($modulePath . '/ext/model/hook/');
        }
    }
}

function getMethodCode($methodName, $reflection, $lines)
{
    $methodReflection = $reflection->getMethod($methodName);
    $startLine  = $methodReflection->getStartLine();
    $endLine    = $methodReflection->getEndLine();
    $endLine    = $endLine - 1;
    $methodCode = '';
    for($i = $startLine + 1; $i < $endLine; $i++) $methodCode .= $lines[$i] . "\n";
    return $methodCode;
}


function getAllMethods($reflection)
{
    $allMethods = array();
    foreach($reflection->getMethods() as $method)
    {
        $methodName = strtolower($method->name);
        $allMethods[$methodName] = strtolower($method->class);
    }
    return $allMethods;
}

function removePHPTAG($fileName)
{
    $code = trim(file_get_contents($fileName));
    if(strpos($code, '<?php') === 0)     $code = ltrim($code, '<?php');
    if(strrpos($code, '?>')   !== false) $code = rtrim($code, '?>');
    return trim($code);
}

