<?php
define('DS', DIRECTORY_SEPARATOR);

$basePath = dirname(dirname(__FILE__));

include $basePath . '/framework/router.class.php';
include $basePath . '/framework/control.class.php';
include $basePath . '/framework/model.class.php';
include $basePath . '/framework/helper.class.php';

$modules = glob($basePath . '/module/*');
foreach($modules as $modulePath)
{
    mergeExt($modulePath);
}

function mergeExt($modulePath)
{
    $moduleName = basename($modulePath);
    echo "Merge $moduleName\n";
    if(!is_dir($modulePath . '/ext')) return true;

    /* Merge control. */
    if(is_dir($modulePath . '/ext/control'))
    {
        echo "Merge $moduleName control\n";
        $mainControlFile  = $modulePath . '/control.php';
        $hasControlFile   = file_exists($modulePath . '/control.php');
        $mainControlLines = array();
        $moduleReflection = '';
        $moduleAllMethods = array();
        $lastLine         = 0;
        if($hasControlFile)
        {
            $mainControlLines = explode("\n", trim(file_get_contents($mainControlFile)));
            helper::import($mainControlFile);
            $moduleReflection = new ReflectionClass($moduleName);
            $moduleAllMethods = getAllMethods($moduleReflection);
            $lastLine = $moduleReflection->getEndLine() - 1;
        }

        $hasMethods = array();
        $extVars   = array();
        foreach(glob($modulePath . '/ext/control/*.php') as $extControlFile)
        {
            if(!$hasControlFile and empty($mainControlLines))
            {
                $mainControlLines = explode("\n", trim(file_get_contents($extControlFile)));
                continue;
            }

            $extMethod = str_replace( '.php', '', basename($extControlFile));
            echo "Merge $moduleName control $extMethod method\n";
            $extContents = trim(file_get_contents($extControlFile));
            if(stripos($extContents, " function $extMethod(") == false) continue;

            $extClassName = $extMethod . $moduleName;
            $extContents = preg_replace("/class (\w+) extends /", "class $extClassName extends ", $extContents);
            $extContents = preg_replace("/\n[^\n]*include.*control\.php[^\n]*\n/Ui", "\n", $extContents);
            file_put_contents($extControlFile, $extContents);
            chdir($modulePath . '/ext/control/');
            helper::import($extControlFile);
            $extControlReflection = new ReflectionClass($extClassName);
            $extControlAllMethods = getAllMethods($extControlReflection);

            /* Replace parent method code. */
            $extContents = replaceParentCode($extContents, $moduleReflection, $mainControlLines, $moduleAllMethods, $moduleName);

            $methods = getParsedMethods($extContents);
            foreach($methods as $i => $methodName)
            {
                $methodName = strtolower($methodName);
                if(isset($hasMethods[$methodName])) continue;

                $extMethodContent = getFunctionCode($extContents, $methodName, isset($methods[$i + 1]) ? $methods[$i + 1] : '', $extClassName);
                if(!isset($extControlAllMethods[$methodName]))
                {
                    $mainControlLines[$lastLine] .= "\n" . $extMethodContent;
                }
                else
                {
                    if(!isset($methods[$i + 1])) $extMethodContent = trim(substr($extMethodContent, 0, strrpos($extMethodContent, '}') - 1));
                    if(isset($moduleAllMethods[$methodName]) and $moduleAllMethods[$methodName] == $moduleName)
                    {
                        $methodReflection = $moduleReflection->getMethod($methodName);
                        $startLine = $methodReflection->getStartLine();
                        $startLine = $startLine -1;
                        $endLine   = $methodReflection->getEndLine();
                        $endLine   = $endLine - 1;
                        $mainControlLines[$startLine] = $extMethodContent . "\n";
                        for($i = $startLine + 1; $i <= $endLine; $i++) unset($mainControlLines[$i]);
                    }
                    else
                    {
                        $mainControlLines[$lastLine] = "\n" . $extMethodContent . "\n" . $mainControlLines[$lastLine];
                    }
                }
                $hasMethods[$methodName] = $methodName;
            }
            foreach(getClassVars($extContents) as $varName => $extVar) $extVars[$varName] = $extVar;

            echo "rm $extControlFile\n";
            `rm $extControlFile`;
        }

        if($mainControlLines)
        {
            if($extVars)
            {
                foreach($mainControlLines as $i => $line)
                {
                    if(strpos($line, $varName) === false) continue;
                    foreach($extVars as $varName => $extVar)
                    {
                        preg_replace("/\n[^\n]*{$extVar['power']} +\${$varName} +\= [^\n]*\n/", "\n{$extVar['line']}\n", $mainControlLines[$i]);
                        unset($extVars[$varName]);
                    }
                }
                foreach($extVars as $varName => $extVar)$mainControlLines[$lastLine] = $extVar['line'] . "\n" . $mainControlLines[$lastLine];
            }

            file_put_contents($mainControlFile, join("\n", $mainControlLines));
        }
    }
    /* Merge model. */
    if(is_dir($modulePath . '/ext/model'))
    {
        echo "Merge $moduleName model\n";
        $mainModelFile  = $modulePath . '/model.php';
        $mainModelLines = explode("\n", trim(file_get_contents($mainModelFile)));
        helper::import($mainModelFile);
        $moduleReflection = new ReflectionClass($moduleName . 'Model');
        $moduleAllMethods = getAllMethods($moduleReflection);
        $lastLine         = $moduleReflection->getEndLine() - 1;

        $hasMethods  = array();
        $extContents = '';
        foreach(glob($modulePath . '/ext/model/*.php') as $extModelFile) $extContents .= "\n" . removePHPTAG($extModelFile);
        if(is_dir($modulePath . '/ext/model/hook/'))
        {
            foreach(glob($modulePath . '/ext/model/hook/*.php') as $extModelHookFile)
            {
                $hookContent = removePHPTAG($extModelHookFile);
                $extMethod   = basename($extModelHookFile);
                $extMethod   = substr($extMethod, 0, strpos($extMethod, '.'));
                $position    = stripos($extContents, " function $extMethod(");
                if($position !== false)
                {
                    $extContents = preg_replace("/( function $extMethod\([^\)]*\)\n){/Ui","$1{\n" . $hookContent . "\n", $extContents);
                }
                else
                {
                    $methodReflection = $moduleReflection->getMethod($extMethod);
                    $startLine = $methodReflection->getStartLine();
                    $mainModelLines[$startLine + 1] = $hookContent . "\n" . $mainModelLines[$startLine + 1];
                }
            }
        }

        /* Merge for class model. */
        preg_match_all('/this->loadExtension\([\'|\"](\w+)[\'|\"]\)/Ui', $extContents, $matches);
        $modelClassExt = array();
        foreach($matches[1] as $i => $className) $modelClassExt[$className] = array();
        preg_match_all('/loadExtension\([\'|\"](\w+)[\'|\"]\)->(\w+)\(/Ui', $extContents, $matches);
        foreach($matches[1] as $i => $className)
        {
            $methodName = $matches[2][$i];
            $modelClassExt[$className][$methodName] = $methodName;
        }
        foreach($modelClassExt as $className => $methods)
        {
            preg_match_all("/this->$className$moduleName->(\w+)\(/Ui", $extContents, $matches);
            foreach($matches[1] as $i => $methodName) $modelClassExt[$className][$methodName] = $methodName;
        }

        $extVars       = array();
        $mergedMethods = array();
        foreach($modelClassExt as $className => $methods)
        {
            $modelClassExtFile = $modulePath . '/ext/model/class/' . $className . ".class.php";
            $classExtContent   = trim(file_get_contents($modelClassExtFile));
            $oldExtClassName   = $className . ucfirst($moduleName);
            $newExtClassName   = strtolower('ext' . $oldExtClassName);
            $classExtContent   = preg_replace("/class $oldExtClassName extends /i", "class $newExtClassName extends ", $classExtContent);
            file_put_contents($modelClassExtFile, $classExtContent);
            helper::import($modelClassExtFile);

            $classExtLines      = explode("\n", $classExtContent);
            if(!class_exists($newExtClassName)) continue;
            $extModelReflection = new ReflectionClass($newExtClassName);
            $extAllMethods      = getAllMethods($extModelReflection);

            /* Merge used method code. */
            foreach($methods as $methodName)
            {
                $methodName = strtolower($methodName);
                if(!isset($extAllMethods[$methodName]) or ($extAllMethods[$methodName] != $moduleName . 'model' and $extAllMethods[$methodName] != $newExtClassName)) continue;

                $foundReflection  = $extModelReflection;
                $foundLines       = $classExtLines;
                if($extAllMethods[$methodName] == $moduleName . 'model')
                {
                    $foundReflection = $moduleReflection;
                    $foundLines      = $mainModelLines;
                }

                $methodContent = getMethodCode($methodName, $foundReflection, $foundLines);
                $extContents = preg_replace("/\n[^\n]*loadExtension\(['|\"]{$className}['|\"]\)->{$methodName}\([^\n]*\n/Ui", "\n" . $methodContent . "\n", $extContents);
                $extContents = preg_replace("/\n[^\n]*this->{$oldExtClassName}->{$methodName}\([^\n]*\n/Ui", "\n" . $methodContent . "\n", $extContents);
                $mergedMethods[$methodName] = $methodName;
            }

            /* Merge other code. */
            $methods = getParsedMethods($classExtContent);
            $extMethods = getParsedMethods($extContents);
            $extHasMethods = array();
            foreach($extMethods as $i => $methodName)
            {
                $methodName = strtolower($methodName);
                $extHasMethods[$methodName] = $i;
            }
            foreach($methods as $i => $methodName)
            {
                $methodName = strtolower($methodName);
                if(isset($mergedMethods[$methodName])) continue;
                $extMethodCode = getFunctionCode($classExtContent, $methodName, isset($methods[$i + 1]) ? $methods[$i + 1] : '', $className . ucfirst($moduleName));
                if(!isset($extAllMethods[$methodName]))
                {
                    $mainModelLines[$lastLine] .= "\n" . $extMethodCode;
                }
                else
                {
                    if(!isset($methods[$i + 1])) $extMethodCode = trim(substr($extMethodCode, 0, strrpos($extMethodCode, '}') - 1));
                    $extContents .= "\n" . $extMethodCode;
                    if(isset($extHasMethods[$methodName]))
                    {
                        $key = $extHasMethods[$methodName];
                        $extMethodCode = getFunctionCode($extContents, $methodName, isset($extMethods[$key + 1]) ? $extMethods[$key + 1] : '');
                        $extContents = str_replace($extMethodCode, '', $extContents);
                        unset($extMethods[$key]);
                    }
                    $extMethods[] = $methodName;
                    end($extMethods);
                    $extHasMethods[$methodName] = key($extMethods);
                }
            }

            /* Merge vars. */
            foreach(getClassVars($classExtContent) as $varName => $extVar) $extVars[$varName] = $extVar;
            $extContents = preg_replace("/\n[^\n]*this->loadExtension\(['|\"]{$className}['|\"]\)[^\n]*\n/Ui", "\n", $extContents);
        }

        /* Replace parent method code. */
        $extContents = replaceParentCode($extContents, $moduleReflection, $mainModelLines, $moduleAllMethods, $moduleName . 'model');

        $methods = getParsedMethods($extContents);
        $mergedMethods = array();
        foreach($methods as $i => $methodName)
        {
            $methodName = strtolower($methodName);
            $extMethodContent = getFunctionCode($extContents, $methodName, isset($methods[$i + 1]) ? $methods[$i + 1] : '');

            if(isset($moduleAllMethods[$methodName]) and $moduleAllMethods[$methodName] == $moduleName . 'model')
            {
                $methodReflection = $moduleReflection->getMethod($methodName);
                $startLine = $methodReflection->getStartLine();
                $startLine = $startLine - 1;
                $endLine   = $methodReflection->getEndLine();
                $endLine   = $endLine - 1;
                $mainModelLines[$startLine] = $extMethodContent . "\n";
                for($i = $startLine + 1; $i <= $endLine; $i++) unset($mainModelLines[$i]);
            }
            elseif(!isset($mergedMethods[$methodName]))
            {
                $mainModelLines[$lastLine]  = "\n" . $extMethodContent . "\n" . $mainModelLines[$lastLine];
                $mergedMethods[$methodName] = true;
            }
        }

        if($mainModelLines)
        {
            if($extVars)
            {
                foreach($mainModelLines as $i => $line)
                {
                    if(strpos($line, $varName) === false) continue;
                    foreach($extVars as $varName => $extVar)
                    {
                        preg_replace("/\n[^\n]*{$extVar['power']} +\${$varName} +\= [^\n]*\n/", "\n{$extVar['line']}\n", $mainModelLines[$i]);
                        unset($extVars[$varName]);
                    }
                }
                foreach($extVars as $varName => $extVar)$mainModelLines[$lastLine] = $extVar['line'] . "\n" . $mainModelLines[$lastLine];
            }
            $mainModelContents = join("\n", $mainModelLines);
        }

        /* Merge for class model. */
        preg_match_all('/this->loadExtension\([\'|\"](\w+)[\'|\"]\)/Ui', $mainModelContents, $matches);
        $modelClassExt = array();
        foreach($matches[1] as $i => $className) $modelClassExt[$className] = array();
        preg_match_all('/loadExtension\([\'|\"](\w+)[\'|\"]\)->(\w+)\(/Ui', $mainModelContents, $matches);
        foreach($matches[1] as $i => $className)
        {
            $methodName = $matches[2][$i];
            $modelClassExt[$className][$methodName] = $methodName;
        }
        foreach($modelClassExt as $className => $methods)
        {
            preg_match_all("/this->$className$moduleName->(\w+)\(/Ui", $mainModelContents, $matches);
            foreach($matches[1] as $i => $methodName) $modelClassExt[$className][$methodName] = $methodName;
        }




        $mergedMethods = array();
        $extMethodCodes = '';
        foreach($modelClassExt as $className => $methods)
        {
            $modelClassExtFile = $modulePath . '/ext/model/class/' . $className . ".class.php";
            $classExtContent   = trim(file_get_contents($modelClassExtFile));
            $oldExtClassName   = $className . ucfirst($moduleName);
            $newExtClassName   = strtolower('ext' . $oldExtClassName);
            $classExtContent   = preg_replace("/class $oldExtClassName extends /i", "class $newExtClassName extends ", $classExtContent);
            file_put_contents($modelClassExtFile, $classExtContent);
            helper::import($modelClassExtFile);

            $classExtLines      = explode("\n", $classExtContent);
            if(!class_exists($newExtClassName)) continue;
            $extModelReflection = new ReflectionClass($newExtClassName);
            $extAllMethods      = getAllMethods($extModelReflection);

            /* Merge used method code. */
            foreach($methods as $methodName)
            {
                $methodName = strtolower($methodName);
                if(!isset($extAllMethods[$methodName]) or ($extAllMethods[$methodName] != $moduleName . 'model' and $extAllMethods[$methodName] != $newExtClassName)) continue;

                $foundReflection  = $extModelReflection;
                $foundLines       = $classExtLines;
                if($extAllMethods[$methodName] == $moduleName . 'model')
                {
                    $foundReflection = $moduleReflection;
                    $foundLines      = $mainModelLines;
                }

                $methodContent = getMethodCode($methodName, $foundReflection, $foundLines);
                foreach($mainModelLines as $i => $lineContent)
                {
                    $mainModelLines[$i] = preg_replace("/[^\n]*loadExtension\(['|\"]{$className}['|\"]\)->{$methodName}\([^\n]*/i", "\n" . $methodContent . "\n", $mainModelLines[$i]);
                    $mainModelLines[$i] = preg_replace("/[^\n]*this->{$oldExtClassName}->{$methodName}\([^\n]*/i", "\n" . $methodContent . "\n", $mainModelLines[$i]);
                }
                $mergedMethods[$methodName] = $methodName;
            }

            /* Merge other code. */
            $mainModelContents = join("\n", $mainModelLines);
            $methods = getParsedMethods($classExtContent);
            $extMethods = getParsedMethods($mainModelContents);
            $extHasMethods = array();
            foreach($extMethods as $i => $methodName)
            {
                $methodName = strtolower($methodName);
                $extHasMethods[$methodName] = $i;
            }
            foreach($methods as $i => $methodName)
            {
                $methodName = strtolower($methodName);
                if(isset($mergedMethods[$methodName])) continue;
                $extMethodCode = getFunctionCode($classExtContent, $methodName, isset($methods[$i + 1]) ? $methods[$i + 1] : '', $className . ucfirst($moduleName));
                if(!isset($extAllMethods[$methodName]))
                {
                    $extMethodCodes .= "\n" . $extMethodCode;
                }
                else
                {
                    if(!isset($methods[$i + 1])) $extMethodCode = trim(substr($extMethodCode, 0, strrpos($extMethodCode, '}') - 1));
                    $extMethodCodes .= "\n" . $extMethodCode;
                    if(isset($extHasMethods[$methodName]))
                    {
                        $key = $extHasMethods[$methodName];
                        $extMethodCode  = getFunctionCode($mainModelContents, $methodName, isset($extMethods[$key + 1]) ? $extMethods[$key + 1] : '');
                        $extMethodCodes = str_replace($extMethodCode, '', $extMethodCodes);
                        unset($extMethods[$key]);
                    }
                    $extMethods[] = $methodName;
                    end($extMethods);
                    $extHasMethods[$methodName] = key($extMethods);
                }
            }

            foreach($mainModelLines as $i => $lineContent)
            {
                $mainModelLines[$i] = preg_replace("/[^\n]*this->loadExtension\(['|\"]{$className}['|\"]\)[^\n]*/Ui", "\n", $mainModelLines[$i]);
            }
        }

        $mainModelLines[$lastLine] = "\n" . $extMethodCodes . "\n" . $mainModelLines[$lastLine];
        $mainModelContents = join("\n", $mainModelLines);
        file_put_contents($mainModelFile, $mainModelContents);

        foreach(glob($modulePath . '/ext/model/*.php') as $extModelFile) `rm $extModelFile`;
        if(is_dir($modulePath . '/ext/model/hook/'))
        {
            foreach(glob($modulePath . '/ext/model/hook/*.php') as $extModelFile) `rm $extModelFile`;
            rmdir($modulePath . '/ext/model/hook/');
        }
        if(is_dir($modulePath . '/ext/model/class/'))
        {
            foreach(glob($modulePath . '/ext/model/class/*.php') as $extModelFile) `rm $extModelFile`;
            rmdir($modulePath . '/ext/model/class/');
        }
    }
}

function getMethodCode($methodName, $reflection, $lines)
{
    $methodReflection = $reflection->getMethod($methodName);
    $startLine  = $methodReflection->getStartLine();
    $endLine    = $methodReflection->getEndLine();
    $endLine    = $endLine - 1;
    $methodCode = '';
    for($i = $startLine + 1; $i < $endLine; $i++) $methodCode .= $lines[$i] . "\n";
    return $methodCode;
}

function getClassVars($code)
{
    $classVars = substr($code, strpos($code, 'class '));
    $classVars = substr($classVars, strpos($classVars, '{') + 1);
    $classVars = substr($classVars, 0, strpos($classVars, "function"));
    $classVars = substr($classVars, 0, strrpos($classVars, "\n"));
    if(strrpos($classVars, "/**") !== false) $classVars = substr($classVars, 0, strrpos($classVars, "/**") - 1);
    $classVars = trim($classVars);
    $vars  = array();
    foreach(explode("\n", $classVars) as $line)
    {
        preg_match_all('/(\w*) *\$(\w+) +\=/Ui', $line, $matches);
        foreach($matches[2] as $i => $varName)
        {
            $vars[$varName]['power'] = $matches[1][$i];
            $vars[$varName]['line']  = $line;
        }
    }
    return $vars;
}

function getFunctionCode($codes, $methodName, $nextMethod = '', $className = '')
{
    $position = strripos($codes, "function $methodName(");
    $position = strrpos($codes, "\n", $position - strlen($codes));
    $methodContent = substr($codes, $position);
    if(!empty($nextMethod))
    {
        $nextPos = stripos($methodContent, "function $nextMethod(");
        if($nextPos === false)
        {
            $position = stripos($codes, "function $methodName(");
            $position = strrpos($codes, "\n", $position - strlen($codes));
            $methodContent = substr($codes, $position);
            $nextPos = stripos($methodContent, "function $nextMethod(");
        }
        $methodContent = substr($methodContent, 0, $nextPos);
    }
    $methodContent = substr($methodContent, 0, strrpos($methodContent, '}') + 1);

    /* Get not in class function. */
    if(!empty($className) and strpos($methodContent, "class $className") !== false)
    {
        $position = stripos($methodContent, "class $className");
        $methodContent = substr($methodContent, 0, $position);
        $methodContent = substr($methodContent, 0, strrpos($methodContent, '}') + 1);
    }
    $methodContent = trim($methodContent);
    return $methodContent;
}

function replaceParentCode($code, $reflection, $lines, $allMethods, $excludeClass)
{
    preg_match_all('/parent::(\w+)\(/Ui', $code, $matches);
    $parentMethods = empty($matches[1]) ? array() : $matches[1];
    foreach($parentMethods as $methodName)
    {
        $methodName = strtolower($methodName);
        if(!isset($allMethods[$methodName]) or $allMethods[$methodName] != $excludeClass) continue;

        $parentMethodCode = getMethodCode($methodName, $reflection, $lines);

        $method = $reflection->getMethod($methodName);
        $methodParam = '';
        foreach($method->getParameters() as $param) 
        {   
            $methodParam .= '$' . $param->getName();
            $methodParam .= ', ';
        }
        $methodParam = rtrim($methodParam, ', ');
        $code = preg_replace("/\n([^\n]*)parent::{$methodName}(\([^\n]*)\n/Ui", "\n \$" . $methodName . " = function($methodParam)\n{\n" . $parentMethodCode . "\n};\n$1 \$" . $methodName . "$2\n", $code);
    }

    return $code;
}

function getAllMethods($reflection)
{
    $allMethods = array();
    foreach($reflection->getMethods() as $method)
    {
        $methodName = strtolower($method->name);
        $allMethods[$methodName] = strtolower($method->class);
    }
    return $allMethods;
}

function getParsedMethods($code)
{
    preg_match_all('/function (\w+)\(/Ui', $code, $matches);
    return !empty($matches[1]) ? $matches[1] : array();
}

function removePHPTAG($fileName)
{
    $code = trim(file_get_contents($fileName));
    if(strpos($code, '<?php') === 0)     $code = ltrim($code, '<?php');
    if(strrpos($code, '?>')   !== false) $code = rtrim($code, '?>');
    return trim($code);
}

