<?php
if(empty($argv[1])) die('Must request a param');
$filePath   = $argv[1];
$users      = empty($argv[2]) ? 0 : $argv[2];
$company    = empty($argv[3]) ? '' : $argv[3]; // 如果没有，try (type = 180d)
$type       = empty($argv[4]) ? '' : $argv[4]; // try ->31d   year ->365d  or 60 -> 60d
$ip         = empty($argv[5]) ? '' : $argv[5];
$mac        = empty($argv[6]) ? '' : $argv[6];
$domain     = empty($argv[7]) ? '' : $argv[7]; // 多个域名用','隔开
$phpVersion = empty($argv[8]) ? 53 : $argv[8];
$feedback   = empty($argv[8]) ? 0 : $argv[8];
$dirName    = basename($filePath);

define('PASSWORD', md5(md5('Zentao Biz editor') . 'cnezsoft'));

include "company.php";
if(!isset($companyName[$company])) die("This company has not the name, please write it in the file of company.php\n");

echo "Removing file\n";
`rm -rf /tmp/$dirName`;
echo "Copying file\n";
`cp -rf $filePath /tmp`;

class control
{
    public function __construct()
    {
    }
}

$filePath     = "/tmp/$dirName";
$defaultValue = "";
$moduleDir    = $filePath . '/module/';
$modules      = glob($moduleDir . '*');

echo "Seting default value for control\n";
include 'biznotice.php';

foreach($modules as $module)
{
    /* Process main control file. */
    $controlPath = $module . '/control.php';
    $className   = basename($module);

    if(isset($excludeModule[$dirName]) and in_array($className, $excludeModule[$dirName])) continue;

    if(file_exists($controlPath))
    {
        echo "Seting value for $className\n";
        include $controlPath;

        $reflection = new ReflectionClass($className);
        /* Add limit condition in construct. */
        if(method_exists($className, '__construct'))
        {
            $construct = new ReflectionMethod($className, '__construct');
            $fileName  = $construct->getFileName();
            $controlContent  = file_get_contents($controlPath);
            $controlLines    = explode("\n", $controlContent);
            if($controlPath == $fileName)
            {
                $endLine = $construct->getEndLine() - 1;
                $controlLines[$endLine] = $limitCondition . "\n" . $controlLines[$endLine];
            }
            else
            {
                $methods = $reflection->getMethods();
                $startLine = $methods[0]->getStartLine() - 1;
                $controlLines[$startLine] = $limitFunc . "\n" . $controlLines[$startLine];
            }
            $controlContent = join("\n", $controlLines);
            file_put_contents($controlPath, $controlContent);
        }

        foreach($reflection->getMethods(ReflectionMethod::IS_PUBLIC) as $method)
        {
            $methodName = strtolower($method->name);

            /* This method is not extend from parent */
            if($method->getFileName() != $controlPath) continue;
            if($methodName == '__construct') continue;

            $params = $method->getParameters();
            foreach($params as $param)
            {
                $paramName = $param->getName();
                if($param->isDefaultValueAvailable()) $defaultValue .= "\$paramDefaultValue['$className']['$methodName']['$paramName'] = '" . ((is_array($param->getDefaultValue())) ? '' : $param->getDefaultValue()) . "';\n";
            }
        }
    }
    /* Set ext control default value.*/
   $extControlPath = $module . '/ext/control/';
   if(is_dir($extControlPath))
   {
       echo "Seting value for extension of $className\n";
       chdir($extControlPath);
       $extControls = glob($extControlPath . '*');
       if(empty($extControls)) continue;
       foreach($extControls as $extControl)
       {
           $hasConstruct     = false;
           $constructLeftTag = 0;
           $constructEndLine = 0;
           $methodName       = strtolower(substr(basename($extControl), 0, strrpos(basename($extControl), '.')));
           $extFile          = file_get_contents($extControl);
           $extLines         = explode("\n", $extFile);
           $classEndLine     = 0;

           foreach($extLines as $i => $line)
           {
               $line = trim($line);

               if(strpos($line, '}') !== false) $classEndLine = $i;
               if(preg_match("/^class +($className) +extends +/i", $line, $class) == 1)   $extClassName = strtolower($class[1]);
               if(preg_match("/^class +(my$className) +extends +/i", $line, $class) == 1) $extClassName = strtolower($class[1]);
               if(preg_match("/^(public)?\s+function\s+__construct/i", $line) == 1) $hasConstruct = true;
               if($hasConstruct and $line and strpos('{', $line) !== false) $constructLeftTag ++;
               if($hasConstruct and $line and strpos('}', $line) !== false and --$constructLeftTag == 0 and $constructEndLine == 0) $constructEndLine = $i;

               if(preg_match("/^(public)?\s+function\s+$methodName/i", $line) == 1)
               {
                   $params = strstr($line, '(');
                   if(preg_match('/^(.+)$/', $params) == 0) continue;
                   $params = substr($params, strpos($params, '(') + 1); 
                   $params = substr($params, 0, strrpos($params, ')'));
                   $params = preg_replace('/, *\$/', ',\$', $params);
                   $params = explode(',$', trim($params, '$'));
                   foreach($params as $param)
                   {
                       if(strpos($param, '=') === false) continue;
                       $pair          = explode('=', $param);
                       $paramName     = trim($pair[0]);
                       $paramValue    = trim(end($pair));
                       $defaultValue .= "\$paramDefaultValue['$extClassName']['$methodName']['$paramName'] = $paramValue;\n";
                   }
               }
           }

           /* Add limit condition in construct. */
           if($hasConstruct)
           {
               $endLine = $constructEndLine - 1;
               $extLines[$endLine] = $limitCondition . "\n" . $extLines[$endLine];
           }
           else
           {
               $extLines[$classEndLine] = $limitFunc . "\n" . $extLines[$classEndLine];
           }
           $controlContent = join("\n", $extLines);
           file_put_contents($extControl, $controlContent);
       }
   }
}
if($defaultValue)
{
    echo "Writing default value to file\n";
    $valueFile  = "<?php\n";
    $valueFile .= $defaultValue;
    $tmp = $filePath . '/tmp/';
    $defaultDir = $tmp . 'defaultvalue/';
    if(!is_dir($tmp))
    {
        mkdir($tmp);
        chmod($tmp, 0777);
    }
    if(!is_dir($defaultDir))
    {
        mkdir($defaultDir);
        chmod($defaultDir, 0777);
    }
    file_put_contents($defaultDir . basename($filePath) . '.php', $valueFile);
}
$file = "/tmp/$dirName";

/* encrypt file*/
echo "Encrypting extension\n";
if(!is_dir('/tmp/encrypt'))mkdir("/tmp/encrypt");

$withLicense = '';
$order = new stdclass();
$order->account  = $company;
$order->company  = $companyName[$company];
$order->users    = (int)$users;
$order->ip       = $ip;
$order->mac      = $mac;
$order->domain   = $domain;
$order->type     = $type;
$order->feedback = (int)$feedback;
$passphrase      = PASSWORD;
createLicense($order, $dirName, '/tmp/');
$withLicense = "--with-license config/license/" . basename($file) . ".txt --passphrase $passphrase";
$callback = "--callback-file config/license/bizcallback.php";

/* Exclude encrypt module. Because run error when encrypt modules. */
$excludeCode = '';
if(isset($excludeModule[$dirName]))
{
    foreach($excludeModule[$dirName] as $module) $excludeCode .= "--copy $module/ ";
}

exec("/usr/local/ioncube/ioncube_encoder{$phpVersion} --copy config.php $excludeCode --copy phpexcel/ --copy phpword/ --copy tmp/ --copy hook/ --copy framework/ --copy config/ --copy view/ --copy lang/ $withLicense $callback --action-if-no-loader \"$noLoader\" $file --update-target --into /tmp/encrypt/", $outError);
foreach($outError as $error)
{
    $errorFile    = substr($error, 0 , strpos($error, ':'));
    $relativeFile = str_replace('/tmp/', '', $errorFile) . "\n";
    echo "Copying $errorFile\n";
    `cp $errorFile /tmp/encrypt/$relativeFile`;
}
echo "Ziping extension\n";
if(file_exists("/tmp/encrypt/$dirName$company.zip")) `rm /tmp/encrypt/$dirName$company.zip`;
`cd /tmp/encrypt/; zip -rm -9 $dirName$company.zip $dirName`;
echo "$dirName$company.zip Finished\n";

function createLicense($order, $saveName, $encryptPath)
{
    echo "Creating license.\n";
    if(!is_dir($encryptPath . $saveName . "/config/license")) echo `mkdir -p $encryptPath$saveName/config/license`;
    chmod($encryptPath . $saveName . "/config/license", 0777);

    $server  = empty($order->domain) ? '' : ((!empty($order->ip) or !empty($order->mac)) ? 'localhost,127.0.0.1,' . $order->domain . '@' : '');
    $server .= empty($order->ip) ? '' : '127.0.0.1,' . $order->ip;
    $server .= empty($order->mac) ? '' : "{{$order->mac}}";
    $server  = empty($server) ? '' : '--allowed-server ' . "'$server'";

    $expireDays = empty($order->account) ? '186' : '';
    $expireDays = $order->type == 'year' ? "372" : $expireDays;
    $expireDays = $order->type == 'try' ? "31" : $expireDays;
    $expireDays = is_numeric($order->type) ? "{$order->type}" : $expireDays;
    $expireDays = $order->type == 'life' ? "" : $expireDays;

    $expire       = empty($expireDays) ? '' : "--expire-in {$expireDays}d";
    $expiredate   = empty($expireDays) ? 'All Life' : date('Y-m-d', strtotime("+$expireDays day"));
    $callbackFile = dirname(__FILE__) . "/bizcallback.php";
    $callbackCon  = file_get_contents($callbackFile);
    $callbackCon  = str_replace(array('%expiredate%', '%domain%', '%ip%', '%mac%', '%users%', '%account%', '%feedback%'), array($expiredate, $order->domain, $order->ip, $order->mac, $order->users, $order->account, $order->feedback), $callbackCon);
    file_put_contents($encryptPath . "$saveName/config/license/bizcallback.php", $callbackCon);

    $user     = empty($order->account) ? 3 : $order->users;
    $feedback = empty($order->account) ? $user * 2 : $order->feedback;
    if(empty($feedback)) $feedback = $order->users * 2;

    $property  = empty($order->account) ? "company='try'" : "company='$order->account'";
    $property .= ",companyName='{$order->company}'";
    $property .= ",startDate='" . date('Y-m-d') . "'";
    $property .= ",expireDate='{$expiredate}'";
    $property .= $user ? ",user=$user" : '';
    $property .= $feedback ? ",feedback=$feedback" : '';
    $property .= empty($order->ip) ? '' : ",ip='$order->ip'";
    $property .= empty($order->mac) ? '' : ",mac='$order->mac'";
    $property .= empty($order->domain) ? '' : ",domain='localhost,127.0.0.1,{$order->domain}'";
    $property = "--property \"$property\"";

    $passphrase = PASSWORD;
    $license = $encryptPath . $saveName . '/config/license/' . $saveName . '.txt';
    echo `/usr/local/ioncube/make_license $property $server $expire --passphrase $passphrase -o $license`;
}
